/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.widget;

import appeng.api.util.AEColor;
import com.asdflj.ae2thing.client.gui.GuiWirelessConnectorTerminal;
import com.asdflj.ae2thing.client.gui.widget.HighLightButton;
import com.asdflj.ae2thing.client.gui.widget.IClickable;
import com.asdflj.ae2thing.client.gui.widget.METextField;
import com.asdflj.ae2thing.client.gui.widget.THGuiButton;
import com.asdflj.ae2thing.client.gui.widget.THGuiSelection;
import com.asdflj.ae2thing.client.me.IDisplayRepo;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.util.Info;
import com.asdflj.ae2thing.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class Component
implements IClickable {
    public static Info activeInfo = null;
    private final IDisplayRepo repo;
    private final int idx;
    private static final int offsetY = 42;
    private final FontRenderer render;
    private final int x;
    private final int y;
    private final GuiWirelessConnectorTerminal gui;
    private final METextField textField;
    private final THGuiButton unbind;
    private final THGuiButton bind;
    private final HighLightButton highLightBtn;
    private THGuiSelection selection;

    public Component(IDisplayRepo repo, int idx, GuiWirelessConnectorTerminal gui, int x, int y) {
        this.textField = new METextField(110, 12, this, gui.getGuiLeft(), gui.getGuiTop());
        this.gui = gui;
        this.repo = repo;
        this.idx = idx;
        this.render = gui.getFontRenderer();
        this.x = x;
        this.y = y + 42 * idx;
        this.textField.x = x + this.render.func_78256_a(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.name", (Object[])new Object[0]) + ": ");
        this.textField.y = this.y - 2;
        this.textField.setVisible(false);
        this.bind = new THGuiButton(this.x + 96, this.y + 18, 40, 20, I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.bind", (Object[])new Object[0]), gui.getGuiLeft(), gui.getGuiTop(), this, "WirelessConnectorTerminal.Bind");
        this.unbind = new THGuiButton(this.x + 96, this.y + 18, 40, 20, I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.unbind", (Object[])new Object[0]), gui.getGuiLeft(), gui.getGuiTop(), this, "WirelessConnectorTerminal.Unbind");
        this.highLightBtn = new HighLightButton(this.x + this.render.func_78256_a(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.pos", (Object[])new Object[0]) + ": "), this.y + 20, 0, this.render.field_78288_b, gui.getGuiLeft(), gui.getGuiTop(), this);
        this.gui.getClickables().add(this);
        this.gui.getClickables().add(this.bind);
        this.gui.getClickables().add(this.unbind);
        this.gui.getClickables().add(this.textField);
        this.gui.getClickables().add(this.highLightBtn);
        if (Config.wirelessConnectorTerminalColorSelection) {
            this.selection = new THGuiSelection(x + 85, this.y + 11, 16, 7, gui.getGuiLeft(), gui.getGuiTop(), this, "WirelessConnectorTerminal.Color");
            this.gui.getClickables().add(this.selection);
            this.gui.getScrollables().add(this.selection);
        }
    }

    private String getName(Info info) {
        String name = I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.name", (Object[])new Object[0]) + ": ";
        return this.textField.isVisible() ? name : name + info.getName();
    }

    public void drawBackground(int color) {
        Info info = this.getInfo();
        if (info == null) {
            return;
        }
        GuiTextField.func_73734_a((int)9, (int)(18 + this.idx * 42), (int)169, (int)(18 + 42 * (this.idx + 1)), (int)color);
    }

    public Info getInfo() {
        return this.repo.getInfo(this.idx);
    }

    public void drawUnbindBtn(MousePos mouse) {
        this.unbind.field_146125_m = true;
        this.bind.field_146125_m = false;
        this.unbind.func_146112_a(this.gui.field_146297_k, mouse.x - this.gui.getGuiLeft(), mouse.y - this.gui.getGuiTop());
    }

    public void drawBindBtn(MousePos mouse) {
        this.unbind.field_146125_m = false;
        this.bind.field_146125_m = true;
        this.bind.func_146112_a(this.gui.field_146297_k, mouse.x - this.gui.getGuiLeft(), mouse.y - this.gui.getGuiTop());
    }

    private void drawSelection(MousePos mouse) {
        this.drawSelection(mouse.x, mouse.y);
    }

    public void drawSelection(int mouseX, int mouseY) {
        if (this.selection != null) {
            this.selection.func_146112_a(this.gui.field_146297_k, mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        }
    }

    public void draw() {
        Info info = this.getInfo();
        if (info == null) {
            return;
        }
        MousePos mouse = new MousePos();
        this.highLightBtn.setWidth(this.render.func_78256_a(info.getPosString()));
        if (this.textField.isVisible()) {
            this.textField.drawTextBox();
        }
        if (activeInfo != null) {
            if (Component.activeInfo.link && Util.isSameDimensionalCoord(Component.activeInfo.b, info.a)) {
                this.drawBackground(1174399493);
                this.drawUnbindBtn(mouse);
            } else if (info.equals(activeInfo) && info.link) {
                this.drawBackground(1162205813);
                this.drawUnbindBtn(mouse);
            } else if (!Component.activeInfo.link && info.equals(activeInfo)) {
                this.drawBackground(1162205813);
            } else if (!Component.activeInfo.link && info.dim == Component.activeInfo.dim) {
                this.drawBindBtn(mouse);
            }
        } else {
            this.unbind.field_146125_m = false;
            this.bind.field_146125_m = false;
        }
        this.render.func_78276_b(this.getName(info), this.x, this.y, 0x404040);
        this.render.func_78276_b(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.color", (Object[])new Object[0]) + ": " + info.getColor(), this.x, this.y + 10, 0x404040);
        this.render.func_78276_b(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.pos", (Object[])new Object[0]) + ": " + info.getPosString(), this.x, this.y + 20, 0x404040);
        this.render.func_78276_b(I18n.func_135052_a((String)"ae2thing.gui.wireless_connector_terminal.channels_used", (Object[])new Object[0]) + ": " + info.getChannelsUsed(), this.x, this.y + 30, 0x404040);
        this.drawWirelessConnector(info);
        this.drawSelection(mouse);
    }

    private void drawWirelessConnector(Info info) {
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        this.gui.bindTextureBack(this.gui.getBackground());
        if (this.selection != null) {
            this.gui.func_73729_b(this.selection.field_146128_h, this.selection.field_146129_i, 224, 32, 16, 16);
        }
        if (info.link) {
            this.gui.func_73729_b(10, 40 + 42 * this.idx, 224, 0, 16, 16);
            if (info.getAEColor() == AEColor.Transparent) {
                this.gui.func_73729_b(10, 20 + 42 * this.idx, 224, 16, 16, 16);
            } else {
                this.gui.func_73729_b(10, 20 + 42 * this.idx, 208, info.getAEColor().ordinal() * 16, 16, 16);
            }
        } else {
            this.gui.func_73729_b(10, 40 + 42 * this.idx, 240, 0, 16, 16);
            this.gui.func_73729_b(10, 20 + 42 * this.idx, 240, 16, 16, 16);
        }
    }

    public boolean isFocused() {
        return this.textField.isFocused();
    }

    public void textboxKeyTyped(char character, int key) {
        if (key == 28) {
            this.textField.unfocused();
        } else {
            this.textField.textboxKeyTyped(character, key);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY) {
        boolean withinXRange = this.gui.getGuiLeft() + 9 <= mouseX && mouseX < this.gui.getGuiLeft() + 160 + 9;
        boolean withinYRange = this.y <= mouseY && mouseY < this.y + 42;
        return withinXRange && withinYRange;
    }

    @Override
    public void onClick() {
        Info info = this.repo.getInfo(this.idx);
        if (info == null) {
            return;
        }
        Component.setActiveInfo(info);
    }

    @Override
    public int getIndex() {
        return 0;
    }

    public static void setActiveInfo(Info info) {
        activeInfo = info;
    }

    public GuiWirelessConnectorTerminal getGui() {
        return this.gui;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public FontRenderer getRender() {
        return this.render;
    }

    public static class MousePos {
        public final int x;
        public final int y;

        public MousePos() {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            this.x = Mouse.getX() * i / mc.field_71443_c;
            this.y = j - Mouse.getY() * j / mc.field_71440_d - 1;
        }
    }
}

