/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IContainerCraftingPacket;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.Constants;
import com.asdflj.ae2thing.client.gui.container.BaseMonitor.FluidMonitor;
import com.asdflj.ae2thing.client.gui.container.BaseMonitor.ItemMonitor;
import com.asdflj.ae2thing.client.gui.container.BaseNetworkContainer;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import com.asdflj.ae2thing.util.HBMAeAddonUtil;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.glodblock.github.util.Util;
import com.hbm.inventory.FluidContainerRegistry;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public abstract class ContainerMonitor
extends BaseNetworkContainer
implements IConfigurableObject,
IConfigManagerHost,
IAEAppEngInventory,
IContainerCraftingPacket {
    protected final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    protected final IConfigManager clientCM;
    protected final ItemMonitor monitor;
    protected final FluidMonitor fluidMonitor;
    protected ITerminalHost host;
    protected IConfigManagerHost gui;
    protected IConfigManager serverCM;
    protected IGridNode networkNode;

    public ContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
        this.monitor = new ItemMonitor(this.field_75149_d);
        this.fluidMonitor = new FluidMonitor(this.field_75149_d);
        if (Platform.isServer()) {
            if (monitorable instanceof INetworkTerminal) {
                this.networkNode = ((INetworkTerminal)monitorable).getGridNode();
            }
            this.serverCM = monitorable.getConfigManager();
            this.setMonitor();
        }
    }

    protected void dropItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return;
        }
        ItemStack itemStack = is.func_77946_l();
        int i = itemStack.func_77976_d();
        while (itemStack.field_77994_a > 0) {
            if (i > itemStack.field_77994_a) {
                if (this.getPlayerInv().func_70441_a(itemStack.func_77946_l())) break;
                this.getPlayerInv().field_70458_d.func_70099_a(itemStack.func_77946_l(), 0.0f);
                break;
            }
            itemStack.field_77994_a -= i;
            ItemStack item = itemStack.func_77946_l();
            item.field_77994_a = i;
            if (this.getPlayerInv().func_70441_a(item)) continue;
            this.getPlayerInv().field_70458_d.func_70099_a(item, 0.0f);
        }
    }

    protected void dropItem(ItemStack itemStack, int stackSize) {
        if (itemStack == null || itemStack.field_77994_a <= 0) {
            return;
        }
        ItemStack is = itemStack.func_77946_l();
        is.field_77994_a = stackSize;
        this.dropItem(is);
    }

    protected void adjustStack(ItemStack stack) {
        if (stack != null && stack.field_77994_a > stack.func_77976_d()) {
            this.dropItem(stack, stack.field_77994_a - stack.func_77976_d());
            stack.field_77994_a = stack.func_77976_d();
        }
    }

    abstract void setMonitor();

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public IMEMonitor<IAEItemStack> getMonitor() {
        return this.monitor.getMonitor();
    }

    protected boolean isInvalid() {
        return !this.monitor.isValid(null);
    }

    protected void processItemList() {
        this.monitor.processItemList();
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.isInvalid()) {
                this.setValidContainer(false);
            }
            if (this.serverCM != null) {
                for (Settings set : this.serverCM.getSettings()) {
                    Enum sideRemote;
                    Enum sideLocal = this.serverCM.getSetting(set);
                    if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                    this.clientCM.putSetting(set, sideLocal);
                    for (Object crafter : this.field_75149_d) {
                        try {
                            NetworkHandler.instance.sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                        }
                        catch (IOException e) {
                            AELog.debug((Throwable)e);
                        }
                    }
                }
            }
            this.processItemList();
            super.func_75142_b();
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    protected IConfigManagerHost getGui() {
        return this.gui;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.monitor.queueInventory(c);
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        this.monitor.removeCraftingFromCrafters(c);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor.getMonitor() != null) {
            this.monitor.removeListener();
        }
    }

    private void extractPlayerInventoryItemStack(EntityPlayer player, ItemStack itemStack, int stackSize) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack is = player.field_71071_by.field_70462_a[x];
            if (is == null || !Platform.isSameItemPrecise((ItemStack)is, (ItemStack)itemStack)) continue;
            ItemStack tmp = is.func_77946_l();
            if (is.field_77994_a < stackSize) {
                stackSize = is.field_77994_a;
            }
            is.field_77994_a -= stackSize;
            tmp.field_77994_a = stackSize;
            if (is.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(x, null);
            }
            player.field_71071_by.func_70437_b(tmp);
            player.field_71071_by.func_70296_d();
            return;
        }
    }

    private boolean canFillDefaultContainer(IAEFluidStack ifs) {
        if (ifs == null) {
            return false;
        }
        MutablePair result = null;
        ItemStack container = AE2ThingAPI.instance().getFluidContainer(ifs);
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((FluidStack)ifs.getFluidStack())) {
            result = AspectUtil.fillEssentiaFromGas((ItemStack)container, (FluidStack)ifs.getFluidStack());
        } else if (Util.FluidUtil.isFluidContainer((ItemStack)AE2ThingAPI.instance().getFluidContainer(ifs))) {
            result = Util.FluidUtil.fillStack((ItemStack)container, (FluidStack)ifs.getFluidStack());
        }
        return result != null && (Integer)result.left != 0;
    }

    public void postChange(IAEFluidStack fluid, EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack targetStack = this.getTargetStack(player, slotIndex);
        if (targetStack == null) {
            if (!this.canFillDefaultContainer(fluid)) {
                return;
            }
            IAEItemStack extractItem = (IAEItemStack)this.monitor.getMonitor().extractItems((IAEStack)AEItemStack.create((ItemStack)AE2ThingAPI.instance().getFluidContainer(fluid)), Actionable.MODULATE, this.getActionSource());
            if (extractItem != null) {
                player.field_71071_by.func_70437_b(extractItem.getItemStack());
            } else {
                this.extractPlayerInventoryItemStack(player, AE2ThingAPI.instance().getFluidContainer(fluid), 1);
            }
            targetStack = this.getTargetStack(player, slotIndex);
        }
        if (targetStack == null) {
            return;
        }
        if (fluid != null && (ModAndClassUtil.THE && AspectUtil.isEmptyEssentiaContainer((ItemStack)targetStack) && AspectUtil.isEssentiaGas((IAEFluidStack)fluid) || ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemIsEmptyContainer(targetStack, fluid) || Util.FluidUtil.isEmpty((ItemStack)targetStack))) {
            this.extractFluid(fluid, player, slotIndex, shift);
        } else if (Util.FluidUtil.isFluidContainer((ItemStack)targetStack) && !Util.FluidUtil.isEmpty((ItemStack)targetStack) || ModAndClassUtil.THE && !AspectUtil.isEmptyEssentiaContainer((ItemStack)targetStack) || ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemHasFluidType(targetStack)) {
            this.insertFluid(player, slotIndex, shift);
        }
        this.func_75142_b();
    }

    private ItemStack getTargetStack(EntityPlayer player, int slotIndex) {
        if (slotIndex == -1) {
            return player.field_71071_by.func_70445_o();
        }
        return player.field_71071_by.func_70301_a(slotIndex);
    }

    private void insertFluid(EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack partialTanksStack;
        ItemStack emptiedTanksStack;
        long totalInserted;
        long insertableFluid;
        boolean partialInsertSupported;
        FluidStack fluidStackPerContainer;
        int fluidPerContainer;
        Item test;
        int containersRequestedToInsert;
        ItemStack targetStack = this.getTargetStack(player, slotIndex);
        int n = containersRequestedToInsert = shift ? targetStack.field_77994_a : 1;
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaContainer((ItemStack)targetStack)) {
            test = targetStack.func_77946_l();
            test.field_77994_a = 1;
            AEFluidStack fs = AspectUtil.getAEGasFromContainer((ItemStack)test);
            fluidPerContainer = AspectUtil.HELPER.getContainerStoredAmount((ItemStack)test) * AspectUtil.R;
            if (fs == null || fluidPerContainer == 0) {
                return;
            }
            fluidStackPerContainer = fs.getFluidStack();
            partialInsertSupported = true;
        } else {
            ItemStack emptyTank;
            test = targetStack.func_77973_b();
            if (test instanceof IFluidContainerItem) {
                IFluidContainerItem fcItem = (IFluidContainerItem)test;
                test = targetStack.func_77946_l();
                test.field_77994_a = 1;
                fluidStackPerContainer = fcItem.drain((ItemStack)test, Integer.MAX_VALUE, false);
                if (fluidStackPerContainer == null || fluidStackPerContainer.amount == 0) {
                    return;
                }
                fluidPerContainer = fluidStackPerContainer.amount;
                partialInsertSupported = true;
            } else if (net.minecraftforge.fluids.FluidContainerRegistry.isContainer((ItemStack)targetStack)) {
                emptyTank = net.minecraftforge.fluids.FluidContainerRegistry.drainFluidContainer((ItemStack)targetStack);
                if (emptyTank == null) {
                    return;
                }
                fluidStackPerContainer = net.minecraftforge.fluids.FluidContainerRegistry.getFluidForFilledItem((ItemStack)targetStack);
                fluidPerContainer = fluidStackPerContainer.amount;
                partialInsertSupported = false;
            } else if (ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemHasFluidType(targetStack)) {
                emptyTank = FluidContainerRegistry.getEmptyContainer((ItemStack)targetStack);
                if (emptyTank == null) {
                    return;
                }
                fluidStackPerContainer = HBMAeAddonUtil.getFluidPerContainer(targetStack);
                fluidPerContainer = fluidStackPerContainer.amount;
                partialInsertSupported = false;
            } else {
                return;
            }
        }
        AEFluidStack totalFluid = AEFluidStack.create((Object)fluidStackPerContainer);
        totalFluid.setStackSize((long)fluidPerContainer * (long)containersRequestedToInsert);
        IAEFluidStack notInsertable = this.injectFluids((IAEFluidStack)totalFluid, Actionable.SIMULATE);
        if (notInsertable == null || notInsertable.getStackSize() == 0L) {
            insertableFluid = totalFluid.getStackSize();
        } else {
            long insertable = totalFluid.getStackSize() - notInsertable.getStackSize();
            insertableFluid = partialInsertSupported ? insertable : insertable - insertable % (long)fluidPerContainer;
        }
        totalFluid.setStackSize(insertableFluid);
        IAEFluidStack notInserted = this.injectFluids((IAEFluidStack)totalFluid, Actionable.MODULATE);
        if (notInserted != null && notInserted.getStackSize() > 0L) {
            long total = totalFluid.getStackSize() - notInserted.getStackSize();
            if (total == 0L) {
                return;
            }
            if (partialInsertSupported) {
                totalInserted = total;
            } else {
                long overflowAmount = (long)fluidPerContainer - total % (long)fluidPerContainer;
                AEFluidStack overflow = AEFluidStack.create((Object)fluidStackPerContainer);
                overflow.setStackSize(overflowAmount);
                this.dropItem(ItemFluidPacket.newStack((IAEFluidStack)overflow));
                totalInserted = total + overflowAmount;
            }
        } else {
            totalInserted = totalFluid.getStackSize();
        }
        int emptiedTanks = (int)(totalInserted / (long)fluidPerContainer);
        int partialDrain = (int)(totalInserted % (long)fluidPerContainer);
        int partialTanks = partialDrain > 0 && partialInsertSupported ? 1 : 0;
        int usedTanks = emptiedTanks + partialTanks;
        int untouchedTanks = targetStack.field_77994_a - usedTanks;
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaContainer((ItemStack)targetStack)) {
            if (emptiedTanks > 0) {
                emptiedTanksStack = targetStack.func_77946_l();
                emptiedTanksStack.field_77994_a = 1;
                emptiedTanksStack = (ItemStack)AspectUtil.drainEssentiaFromGas((ItemStack)emptiedTanksStack, (FluidStack)fluidStackPerContainer).right;
                emptiedTanksStack.field_77994_a = emptiedTanks;
            } else {
                emptiedTanksStack = null;
            }
            if (partialTanks > 0) {
                partialTanksStack = targetStack.func_77946_l();
                partialTanksStack.field_77994_a = 1;
                emptiedTanksStack = (ItemStack)AspectUtil.drainEssentiaFromGas((ItemStack)partialTanksStack, (FluidStack)fluidStackPerContainer).right;
            } else {
                partialTanksStack = null;
            }
        } else {
            Item item = targetStack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                IFluidContainerItem fcItem = (IFluidContainerItem)item;
                if (emptiedTanks > 0) {
                    emptiedTanksStack = targetStack.func_77946_l();
                    emptiedTanksStack.field_77994_a = 1;
                    fcItem.drain(emptiedTanksStack, fluidPerContainer, true);
                    emptiedTanksStack.field_77994_a = emptiedTanks;
                } else {
                    emptiedTanksStack = null;
                }
                if (partialTanks > 0) {
                    partialTanksStack = targetStack.func_77946_l();
                    partialTanksStack.field_77994_a = 1;
                    fcItem.drain(partialTanksStack, partialDrain, true);
                } else {
                    partialTanksStack = null;
                }
            } else if (ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemHasFluidType(targetStack)) {
                if (emptiedTanks > 0) {
                    emptiedTanksStack = FluidContainerRegistry.getEmptyContainer((ItemStack)targetStack);
                    emptiedTanksStack.field_77994_a = emptiedTanks;
                } else {
                    emptiedTanksStack = null;
                }
                partialTanksStack = null;
            } else {
                if (emptiedTanks > 0) {
                    emptiedTanksStack = net.minecraftforge.fluids.FluidContainerRegistry.drainFluidContainer((ItemStack)targetStack);
                    emptiedTanksStack.field_77994_a = emptiedTanks;
                } else {
                    emptiedTanksStack = null;
                }
                partialTanksStack = null;
            }
        }
        boolean shouldSendStack = true;
        if (slotIndex == -1) {
            if (untouchedTanks > 0) {
                targetStack.field_77994_a = untouchedTanks;
                this.adjustStack(targetStack);
                this.dropItem(emptiedTanksStack);
                this.dropItem(partialTanksStack);
            } else if (emptiedTanksStack != null) {
                this.adjustStack(emptiedTanksStack);
                player.field_71071_by.func_70437_b(emptiedTanksStack);
                this.dropItem(partialTanksStack);
            } else if (partialTanksStack != null) {
                player.field_71071_by.func_70437_b(partialTanksStack);
            } else {
                player.field_71071_by.func_70437_b(null);
                shouldSendStack = false;
            }
        } else if (untouchedTanks > 0) {
            targetStack.field_77994_a = untouchedTanks;
            this.adjustStack(targetStack);
            this.dropItem(emptiedTanksStack);
            this.dropItem(partialTanksStack);
        } else if (emptiedTanksStack != null) {
            this.adjustStack(emptiedTanksStack);
            player.field_71071_by.func_70299_a(slotIndex, emptiedTanksStack);
            this.dropItem(partialTanksStack);
        } else if (partialTanksStack != null) {
            player.field_71071_by.func_70299_a(slotIndex, partialTanksStack);
        } else {
            player.field_71071_by.func_70437_b(null);
            shouldSendStack = false;
        }
        SPacketMEItemInvUpdate packet = new SPacketMEItemInvUpdate(Constants.MessageType.UPDATE_PLAYER_ITEM);
        if (shouldSendStack) {
            packet.appendItem(AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o()));
        }
        AE2Thing.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
    }

    private void extractFluid(IAEFluidStack clientRequestedFluid, EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack partialTanksStack;
        Item toInsert;
        ItemStack filledTanksStack;
        IAEFluidStack extracted;
        boolean partialInsertSupported;
        int fluidPerContainer;
        Item testStack;
        if (slotIndex != -1) {
            return;
        }
        ItemStack targetStack = player.field_71071_by.func_70445_o();
        int containersRequestedToExtract = shift ? targetStack.field_77994_a : 1;
        FluidStack clientRequestedFluidStack = clientRequestedFluid.getFluidStack();
        clientRequestedFluidStack.amount = Integer.MAX_VALUE;
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaContainer((ItemStack)targetStack)) {
            testStack = targetStack.func_77946_l();
            testStack.field_77994_a = 1;
            fluidPerContainer = (Integer)AspectUtil.fillEssentiaFromGas((ItemStack)testStack, (FluidStack)clientRequestedFluidStack).left;
            if (fluidPerContainer == 0) {
                return;
            }
            partialInsertSupported = true;
        } else {
            testStack = targetStack.func_77973_b();
            if (testStack instanceof IFluidContainerItem) {
                IFluidContainerItem fcItem = (IFluidContainerItem)testStack;
                testStack = targetStack.func_77946_l();
                testStack.field_77994_a = 1;
                fluidPerContainer = fcItem.fill((ItemStack)testStack, clientRequestedFluidStack, false);
                if (fluidPerContainer == 0) {
                    return;
                }
                partialInsertSupported = true;
            } else if (net.minecraftforge.fluids.FluidContainerRegistry.isContainer((ItemStack)targetStack)) {
                fluidPerContainer = net.minecraftforge.fluids.FluidContainerRegistry.getContainerCapacity((FluidStack)clientRequestedFluidStack, (ItemStack)targetStack);
                partialInsertSupported = false;
            } else if (ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemIsEmptyContainer(targetStack, clientRequestedFluid)) {
                fluidPerContainer = HBMAeAddonUtil.getEmptyContainerAmount(targetStack, clientRequestedFluid);
                partialInsertSupported = false;
            } else {
                return;
            }
        }
        IAEFluidStack totalRequestedFluid = clientRequestedFluid.copy();
        totalRequestedFluid.setStackSize((long)fluidPerContainer * (long)containersRequestedToExtract);
        IAEFluidStack availableFluid = this.extractFluids(totalRequestedFluid, Actionable.SIMULATE);
        if (availableFluid == null || availableFluid.getStackSize() == 0L) {
            return;
        }
        if (availableFluid.getStackSize() != totalRequestedFluid.getStackSize() && !partialInsertSupported) {
            availableFluid.decStackSize(availableFluid.getStackSize() % (long)fluidPerContainer);
        }
        long totalExtracted = (extracted = this.extractFluids(availableFluid, Actionable.MODULATE)) != null ? extracted.getStackSize() : 0L;
        int filledTanks = (int)(totalExtracted / (long)fluidPerContainer);
        int partialFill = (int)(totalExtracted % (long)fluidPerContainer);
        int partialTanks = partialFill > 0 && partialInsertSupported ? 1 : 0;
        int usedTanks = filledTanks + partialTanks;
        int untouchedTanks = targetStack.field_77994_a - usedTanks;
        if (ModAndClassUtil.THE && AspectUtil.isEssentiaContainer((ItemStack)targetStack)) {
            if (filledTanks > 0) {
                filledTanksStack = targetStack.func_77946_l();
                filledTanksStack.field_77994_a = 1;
                toInsert = extracted.getFluidStack().copy();
                toInsert.amount = fluidPerContainer;
                filledTanksStack = (ItemStack)AspectUtil.fillEssentiaFromGas((ItemStack)filledTanksStack, (FluidStack)toInsert).right;
                filledTanksStack.field_77994_a = filledTanks;
            } else {
                filledTanksStack = null;
            }
            if (partialTanks > 0) {
                partialTanksStack = targetStack.func_77946_l();
                partialTanksStack.field_77994_a = 1;
                toInsert = extracted.getFluidStack().copy();
                toInsert.amount = partialFill;
                partialTanksStack = (ItemStack)AspectUtil.fillEssentiaFromGas((ItemStack)partialTanksStack, (FluidStack)toInsert).right;
            } else {
                partialTanksStack = null;
            }
        } else {
            toInsert = targetStack.func_77973_b();
            if (toInsert instanceof IFluidContainerItem) {
                IFluidContainerItem fcItem = (IFluidContainerItem)toInsert;
                if (filledTanks > 0) {
                    filledTanksStack = targetStack.func_77946_l();
                    filledTanksStack.field_77994_a = 1;
                    toInsert = extracted.getFluidStack().copy();
                    toInsert.amount = fluidPerContainer;
                    fcItem.fill(filledTanksStack, (FluidStack)toInsert, true);
                    filledTanksStack.field_77994_a = filledTanks;
                } else {
                    filledTanksStack = null;
                }
                if (partialTanks > 0) {
                    partialTanksStack = targetStack.func_77946_l();
                    partialTanksStack.field_77994_a = 1;
                    toInsert = extracted.getFluidStack().copy();
                    toInsert.amount = partialFill;
                    fcItem.fill(partialTanksStack, (FluidStack)toInsert, true);
                } else {
                    partialTanksStack = null;
                }
            } else if (ModAndClassUtil.HBM_AE_ADDON && HBMAeAddonUtil.getItemIsEmptyContainer(targetStack, clientRequestedFluid)) {
                if (filledTanks > 0) {
                    filledTanksStack = targetStack.func_77946_l();
                    filledTanksStack.field_77994_a = 1;
                    toInsert = extracted.getFluidStack().copy();
                    toInsert.amount = fluidPerContainer;
                    filledTanksStack = HBMAeAddonUtil.getFillContainer(targetStack, clientRequestedFluid);
                    filledTanksStack.field_77994_a = filledTanks;
                } else {
                    filledTanksStack = null;
                }
                if (partialTanks > 0) {
                    partialTanksStack = targetStack.func_77946_l();
                    partialTanksStack.field_77994_a = 1;
                    toInsert = extracted.getFluidStack().copy();
                    toInsert.amount = partialFill;
                    partialTanksStack = HBMAeAddonUtil.getFillContainer(targetStack, clientRequestedFluid);
                } else {
                    partialTanksStack = null;
                }
            } else {
                if (filledTanks > 0) {
                    toInsert = extracted.getFluidStack().copy();
                    toInsert.amount = fluidPerContainer;
                    filledTanksStack = net.minecraftforge.fluids.FluidContainerRegistry.fillFluidContainer((FluidStack)toInsert, (ItemStack)targetStack);
                    filledTanksStack.field_77994_a = filledTanks;
                } else {
                    filledTanksStack = null;
                }
                if (partialFill > 0) {
                    IAEFluidStack overflow = extracted.copy();
                    overflow.setStackSize((long)partialFill);
                    this.dropItem(ItemFluidPacket.newStack((IAEFluidStack)overflow));
                }
                partialTanksStack = null;
            }
        }
        boolean shouldSendStack = true;
        if (untouchedTanks > 0) {
            ItemStack emptyStack = player.field_71071_by.func_70445_o();
            emptyStack.field_77994_a = untouchedTanks;
            this.adjustStack(emptyStack);
            this.dropItem(filledTanksStack);
            this.dropItem(partialTanksStack);
        } else if (filledTanksStack != null) {
            this.adjustStack(filledTanksStack);
            player.field_71071_by.func_70437_b(filledTanksStack);
            this.dropItem(partialTanksStack);
        } else if (partialTanksStack != null) {
            player.field_71071_by.func_70437_b(partialTanksStack);
        } else {
            player.field_71071_by.func_70437_b(null);
            shouldSendStack = false;
        }
        SPacketMEItemInvUpdate packet = new SPacketMEItemInvUpdate(Constants.MessageType.UPDATE_PLAYER_ITEM);
        if (shouldSendStack) {
            packet.appendItem(AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o()));
        }
        AE2Thing.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
    }

    protected IAEFluidStack extractFluids(IAEFluidStack ifs, Actionable mode) {
        if (ifs.getStackSize() == 0L) {
            return ifs;
        }
        return (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)ifs, mode, this.getActionSource());
    }

    protected IAEFluidStack injectFluids(IAEFluidStack ifs, Actionable mode) {
        return (IAEFluidStack)this.host.getFluidInventory().injectItems((IAEStack)ifs, mode, this.getActionSource());
    }
}

