/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui;

import appeng.util.Platform;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import com.asdflj.ae2thing.api.Constants;
import com.asdflj.ae2thing.api.TerminalMenu;
import com.asdflj.ae2thing.client.gui.container.ContainerTerminalMenu;
import com.asdflj.ae2thing.client.render.Shader;
import com.asdflj.ae2thing.loader.KeybindLoader;
import cpw.mods.fml.common.Loader;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class GuiTerminalMenu
extends GuiContainer
implements INEIGuiHandler {
    private static final Shader Shader = new Shader("ae2thing", "shaders/menu.vert", "shaders/menu.frag");
    private static final int VBO = GL15.glGenBuffers();
    private final TerminalMenu menu = new TerminalMenu();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private ScaledResolution scaledresolution;
    public static int page = 0;
    private int maxPage;
    private int currentIndex;
    private static final int SECTOR_COUNT = 6;
    private static final boolean hasLwjgl3 = Loader.isModLoaded((String)"lwjgl3ify");

    public GuiTerminalMenu() {
        super((Container)new ContainerTerminalMenu());
        this.scaledresolution = new ScaledResolution(mc, GuiTerminalMenu.mc.field_71443_c, GuiTerminalMenu.mc.field_71440_d);
        this.maxPage = page;
        this.currentIndex = 0;
        this.field_146999_f = 256;
    }

    private int calMaxPage() {
        if (this.menu.getItems().isEmpty()) {
            return 0;
        }
        int page = this.menu.getItems().size() / 6;
        if (this.menu.getItems().size() % 6 == 0 && page > 0) {
            --page;
        }
        return page;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.menu.getItems().size() <= page * 6) {
            page = 0;
        }
        this.maxPage = this.calMaxPage();
        this.scaledresolution = new ScaledResolution(mc, GuiTerminalMenu.mc.field_71443_c, GuiTerminalMenu.mc.field_71440_d);
        float x = GuiTerminalMenu.mc.field_71443_c;
        float y = GuiTerminalMenu.mc.field_71440_d;
        float[] vertices = new float[]{0.0f, 0.0f, 0.0f, y, x, y, x, 0.0f};
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)vertices.length).put(vertices);
        vertexBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)VBO);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        FloatBuffer buf1 = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buf1);
        FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)buf2);
        Shader.use();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"modelview"), (boolean)false, (FloatBuffer)buf1);
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"projection"), (boolean)false, (FloatBuffer)buf2);
        GL20.glUniform2f((int)GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"iResolution"), (float)x, (float)y);
        Shader.clear();
    }

    public void func_146281_b() {
    }

    public void func_146276_q_() {
    }

    public void func_146269_k() {
        boolean isKeyReleased;
        boolean isMouseButton;
        super.func_146269_k();
        int keyCode = KeybindLoader.openTerminalMenu.func_151463_i();
        boolean bl = isMouseButton = keyCode < 0;
        if (isMouseButton) {
            int mouseButton = keyCode + 100;
            isKeyReleased = !Mouse.isButtonDown((int)mouseButton);
        } else {
            boolean bl2 = isKeyReleased = !Keyboard.isKeyDown((int)keyCode);
        }
        if (isKeyReleased) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            this.menu.OpenTerminal(this.currentIndex);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0) {
            return;
        }
        if (!hasLwjgl3) {
            wheel = wheel > 0 ? (int)Platform.ceilDiv((long)wheel, (long)120L) : -((int)Platform.ceilDiv((long)(-wheel), (long)120L));
        }
        int x = Mouse.getEventX() * this.field_146294_l / GuiTerminalMenu.mc.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / GuiTerminalMenu.mc.field_71440_d - 1;
        this.mouseWheelEvent(x, y, wheel);
    }

    public void mouseWheelEvent(int x, int y, int wheel) {
        if (this.menu.getItems().size() <= 6) {
            page = 0;
        }
        if (wheel == Constants.MouseWheel.NEXT.direction) {
            page = Math.max(page - 1, 0);
            this.currentIndex = -1;
        } else if (wheel == Constants.MouseWheel.PREVIEW.direction) {
            page = Math.min(page + 1, this.maxPage);
            this.currentIndex = -1;
        }
    }

    private short selection(int mouseX, int mouseY) {
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        short result = -1;
        if (mouseX != x || mouseY != y) {
            double deltaX = x - mouseX;
            double deltaY = mouseY - y;
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            if (length < 20.0) {
                return -1;
            }
            double radians = Math.atan2(deltaY, deltaX);
            double degrees = Math.toDegrees(radians);
            if (degrees < 0.0) {
                degrees += 360.0;
            }
            return (short)(degrees / 60.0);
        }
        return result;
    }

    public void drawItem() {
        GL11.glPushMatrix();
        float innerRadius = 20.0f;
        float outerRadius = 50.0f;
        int centerX = this.field_146999_f / 2;
        int centerY = this.field_147000_g / 2;
        float sectorSize = 1.0471976f;
        float startAngleOffset = 9.948377f;
        for (int i = 0; i < 6; ++i) {
            float centerAngle = startAngleOffset + (float)i * sectorSize;
            float iconRadius = (innerRadius + outerRadius) / 2.0f;
            int iconX = centerX + (int)((double)iconRadius * Math.cos(centerAngle));
            int iconY = centerY - (int)((double)iconRadius * Math.sin(centerAngle));
            int ax = this.getRealIndex(i);
            if (ax == -1) continue;
            ItemStack item = this.menu.getTerminalItems().get(ax).getTargetItem();
            field_146296_j.func_82406_b(this.field_146289_q, mc.func_110434_K(), item, iconX - 8, iconY - 9);
        }
        GL11.glPopMatrix();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scaledresolution.func_78325_e(), (float)this.scaledresolution.func_78325_e(), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        Shader.use();
        GL20.glUniform2f((int)GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"iMouse"), (float)Mouse.getX(), (float)Mouse.getY());
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)Shader.getProgram(), (CharSequence)"scaleFactor"), (float)this.scaledresolution.func_78325_e());
        GL15.glBindBuffer((int)34962, (int)VBO);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL11.glDrawArrays((int)7, (int)0, (int)4);
        GL20.glDisableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        Shader.clear();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        short rx = this.selection(mouseX, mouseY);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawItem();
        this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"ae2thing.gui.terminal_menu.page", (Object[])new Object[]{page + 1}), 0, this.field_147000_g - 20, 0xFFFFFF);
        this.field_146289_q.func_78261_a(I18n.func_135052_a((String)"ae2thing.gui.terminal_menu.max_page", (Object[])new Object[]{this.maxPage + 1}), this.field_146999_f - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"ae2thing.gui.terminal_menu.max_page", (Object[])new Object[]{this.maxPage + 1})), this.field_147000_g - 20, 0xFFFFFF);
        if (rx == -1) {
            this.currentIndex = -1;
            return;
        }
        this.currentIndex = this.getRealIndex(rx);
        if (this.currentIndex == -1) {
            return;
        }
        String name = this.menu.getTerminalItems().get(this.currentIndex).getDisplayName();
        this.field_146289_q.func_78261_a(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 18, 0xFFFFFF);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
    }

    private int getRealIndex(int rx) {
        int ax = rx + page * 6;
        if (ax >= this.menu.getTerminalItems().size()) {
            return -1;
        }
        return ax;
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showNEI = false;
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return true;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return true;
    }
}

