/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui;

import appeng.api.config.CraftingStatus;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.util.IConfigManager;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotCraftingTerm;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternTerm;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.InventoryAction;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.modules.NEI;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import codechicken.nei.util.TextHistory;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.BaseMEGui;
import com.asdflj.ae2thing.client.gui.IGuiDrawSlot;
import com.asdflj.ae2thing.client.gui.IGuiMonitorTerminal;
import com.asdflj.ae2thing.client.gui.container.ContainerMonitor;
import com.asdflj.ae2thing.client.gui.widget.THGuiTextField;
import com.asdflj.ae2thing.client.me.AdvItemRepo;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.network.CPacketInventoryAction;
import com.asdflj.ae2thing.util.Ae2ReflectClient;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiMonitor
extends BaseMEGui
implements IConfigManagerHost,
ISortSource,
IDropToFillTextField,
IGuiDrawSlot,
IGuiMonitorTerminal {
    protected GuiImgButton clearBtn;
    public static int craftingGridOffsetX;
    public static int craftingGridOffsetY;
    protected static String memoryText;
    protected final int offsetX = 9;
    protected final int lowerTextureOffset = 0;
    protected AdvItemRepo repo;
    protected THGuiTextField searchField;
    protected int perRow = 9;
    protected int reservedSpace = 0;
    protected int rows = 0;
    protected int maxRows = Integer.MAX_VALUE;
    protected int standardSize;
    protected int offsetY;
    protected GuiTabButton craftingStatusBtn;
    protected GuiImgButton craftingStatusImgBtn;
    protected GuiImgButton SortByBox;
    protected GuiImgButton SortDirBox;
    protected GuiImgButton searchBoxSettings;
    protected GuiImgButton terminalStyleBox;
    protected GuiImgButton searchStringSave;
    protected GuiImgButton ViewBox;
    protected GuiImgButton typeFilter;
    protected boolean showViewBtn = true;
    protected boolean viewCell = true;
    protected final ContainerMonitor container;

    public GuiMonitor(Container container) {
        super(container);
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.container = (ContainerMonitor)container;
        this.repo = new AdvItemRepo((IScrollSource)this.getScrollBar(), this);
        this.repo.setPowered(true);
    }

    protected void saveSearchString() {
        if (ModAndClassUtil.NEI && this.isNEISearch() && !this.searchField.func_146179_b().isEmpty()) {
            this.history.add(this.searchField.func_146179_b());
        }
    }

    protected void func_146984_a(Slot slot, int slotIdx, int ctrlDown, int mouseButton) {
        this.saveSearchString();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.updateFluidContainer(slot, slotIdx, ctrlDown, mouseButton)) {
            return;
        }
        if (slot instanceof SlotFake) {
            InventoryAction action;
            InventoryAction inventoryAction = action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                action = action == InventoryAction.SPLIT_OR_PLACE_SINGLE ? InventoryAction.MOVE_REGION : InventoryAction.PICKUP_SINGLE;
            }
            if (Ae2ReflectClient.getDragClick((AEBaseGui)this).size() > 1) {
                return;
            }
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer((AppEngPacket)p);
            return;
        }
        if (slot instanceof SlotPatternTerm) {
            if (mouseButton == 6) {
                return;
            }
            try {
                NetworkHandler.instance.sendToServer(((SlotPatternTerm)slot).getRequest(GuiMonitor.func_146272_n()));
            }
            catch (IOException e) {
                AELog.debug((Throwable)e);
            }
        } else if (slot instanceof SlotCraftingTerm) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = GuiMonitor.func_146272_n() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            PacketInventoryAction p = new PacketInventoryAction(action, slotIdx, 0L);
            NetworkHandler.instance.sendToServer((AppEngPacket)p);
            return;
        }
        if (Keyboard.isKeyDown((int)57) && this.enableSpaceClicking() && !(slot instanceof SlotPatternTerm)) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = Ae2ReflectClient.getInventorySlots((AEBaseGui)this).size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_75222_d;
            }
            ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
            PacketInventoryAction p = new PacketInventoryAction(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance.sendToServer((AppEngPacket)p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            if (Ae2ReflectClient.getDragClick((AEBaseGui)this).size() > 1) {
                return;
            }
            InventoryAction action = null;
            switch (mouseButton) {
                case 0: {
                    ItemStack heldStack = player.field_71071_by.func_70445_o();
                    if (slot.func_75211_c() == null && heldStack != null) {
                        action = InventoryAction.SPLIT_OR_PLACE_SINGLE;
                        break;
                    }
                    if (slot.func_75211_c() == null || heldStack != null && heldStack.field_77994_a > 1) break;
                    action = InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case 3: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PacketInventoryAction p = new PacketInventoryAction(action, slot.getSlotIndex(), ((SlotDisconnected)slot).getSlot().getId());
                NetworkHandler.instance.sendToServer((AppEngPacket)p);
            }
            return;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (mouseButton) {
                case 0: {
                    action = ctrlDown == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || player.field_71071_by.func_70445_o() != null) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case 1: {
                    action = ctrlDown == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case 3: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    stack = this.transformItem(stack);
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.field_71075_bZ.field_75098_d || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                }
            }
            if (action == InventoryAction.AUTO_CRAFT) {
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                AE2Thing.proxy.netHandler.sendToServer(new CPacketInventoryAction(action, Ae2ReflectClient.getInventorySlots((AEBaseGui)this).size(), 0, stack));
            } else if (action != null) {
                if (stack != null && stack.getItem() instanceof ItemFluidDrop) {
                    stack = null;
                }
                ((AEBaseContainer)this.field_147002_h).setTargetStack(stack);
                PacketInventoryAction p = new PacketInventoryAction(action, Ae2ReflectClient.getInventorySlots((AEBaseGui)this).size(), 0L);
                NetworkHandler.instance.sendToServer((AppEngPacket)p);
            }
            return;
        }
        super.func_146984_a(slot, slotIdx, ctrlDown, mouseButton);
    }

    protected IAEItemStack transformItem(IAEItemStack stack) {
        return stack;
    }

    protected int getMaxRows() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    @Override
    public void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    public void func_73866_w_() {
        Enum setting;
        Keyboard.enableRepeatEvents((boolean)true);
        this.maxRows = this.getMaxRows();
        this.perRow = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? 9 : 9 + (this.field_146294_l - this.standardSize) / 18;
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        boolean NEI = false;
        int top = hasNEI ? 22 : 0;
        int magicNumber = 115;
        int extraSpace = this.field_146295_m - 115 - 0 - top - this.reservedSpace;
        this.rows = (int)Math.floor((double)extraSpace / 18.0);
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (hasNEI) {
            --this.rows;
        }
        if (this.rows < 3) {
            this.rows = 3;
        }
        this.getMeSlots().clear();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                this.getMeSlots().add(new InternalSlotME((IDisplayRepo)this.repo, x + y * this.perRow, this.offsetX + x * 18, 18 + y * 18));
            }
        }
        this.field_146999_f = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.FULL ? this.standardSize + (this.perRow - 9) * 18 : this.standardSize;
        super.func_73866_w_();
        this.field_147000_g = 115 + this.rows * 18 + this.reservedSpace;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        this.offsetY = this.field_147009_r + 8;
        this.SortByBox = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.SORT_BY, this.configSrc.getSetting(Settings.SORT_BY));
        this.field_146292_n.add(this.SortByBox);
        this.offsetY += 20;
        if (this.showViewBtn) {
            this.ViewBox = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.VIEW_MODE, this.configSrc.getSetting(Settings.VIEW_MODE));
            this.field_146292_n.add(this.ViewBox);
            this.offsetY += 20;
        }
        if (ModAndClassUtil.isTypeFilter) {
            this.typeFilter = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.TYPE_FILTER, this.configSrc.getSetting(Settings.TYPE_FILTER));
            this.field_146292_n.add(this.typeFilter);
            this.offsetY += 20;
        }
        this.SortDirBox = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.SORT_DIRECTION, this.configSrc.getSetting(Settings.SORT_DIRECTION));
        this.field_146292_n.add(this.SortDirBox);
        this.offsetY += 20;
        this.searchBoxSettings = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.SEARCH_MODE, AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE));
        this.field_146292_n.add(this.searchBoxSettings);
        this.offsetY += 20;
        this.searchStringSave = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.SAVE_SEARCH, (Enum)(AEConfig.instance.preserveSearchBar ? YesNo.YES : YesNo.NO));
        this.field_146292_n.add(this.searchStringSave);
        this.offsetY += 20;
        this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.TERMINAL_STYLE, AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.terminalStyleBox);
        this.offsetY += 20;
        this.searchField = new THGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(80, this.offsetX), this.field_147009_r + 4, 90, 12);
        this.searchField.setMessage(ButtonToolTips.SearchStringTooltip.getLocal());
        if (this.viewCell) {
            if (ModAndClassUtil.isCraftStatus && AEConfig.instance.getConfigManager().getSetting(Settings.CRAFTING_STATUS).equals(CraftingStatus.BUTTON)) {
                this.craftingStatusImgBtn = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.CRAFTING_STATUS, AEConfig.instance.settings.getSetting(Settings.CRAFTING_STATUS));
                this.field_146292_n.add(this.craftingStatusImgBtn);
                this.offsetY += 20;
            } else {
                this.craftingStatusBtn = new GuiTabButton(this.field_147003_i + 170, this.field_147009_r - 4, 178, GuiText.CraftingStatus.getLocal(), field_146296_j);
                this.field_146292_n.add(this.craftingStatusBtn);
                this.craftingStatusBtn.setHideEdge(13);
            }
        }
        this.searchField.func_146195_b(SearchBoxMode.AUTOSEARCH == (setting = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE)) || SearchBoxMode.NEI_AUTOSEARCH == setting);
        if (AEConfig.instance.preserveSearchBar || this.isSubGui()) {
            this.setSearchString(memoryText, false);
        }
        if (this.isSubGui()) {
            this.repo.updateView();
            this.setScrollBar();
        }
        craftingGridOffsetX = Integer.MAX_VALUE;
        craftingGridOffsetY = Integer.MAX_VALUE;
        for (Object s : this.field_147002_h.field_75151_b) {
            if (s instanceof AppEngSlot && (((Slot)s).field_75223_e < 195 || s instanceof SlotDisabled)) {
                this.repositionSlot((AppEngSlot)s);
            }
            if (!(s instanceof SlotCraftingMatrix) && !(s instanceof SlotFakeCraftingMatrix)) continue;
            Slot g = (Slot)s;
            if (g.field_75223_e <= 0 || g.field_75221_f <= 0) continue;
            craftingGridOffsetX = Math.min(craftingGridOffsetX, g.field_75223_e);
            craftingGridOffsetY = Math.min(craftingGridOffsetY, g.field_75221_f);
        }
        craftingGridOffsetX -= 25;
        craftingGridOffsetY -= 6;
    }

    protected void repositionSlot(AppEngSlot s) {
    }

    @Override
    protected void func_73869_a(char character, int key) {
        if (ModAndClassUtil.NEI && this.isNEISearch()) {
            if (key == 15) {
                Optional<String> history = Ae2ReflectClient.getHistoryList(this.history).stream().filter(s -> s.startsWith(this.searchField.func_146179_b())).findFirst();
                history.ifPresent(s -> this.setSearchString((String)s, true));
                return;
            }
            if (key == 211) {
                String next = this.history.getNext(this.searchField.func_146179_b()).orElse("");
                Ae2ReflectClient.getHistoryList(this.history).removeIf(s -> s.equals(this.searchField.func_146179_b()));
                this.setSearchString(next, true);
                return;
            }
        }
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.repo.setSearchString(this.searchField.func_146179_b());
                this.repo.updateView();
                this.setScrollBar();
                this.updateSuggestion();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    private void updateSuggestion() {
        if (ModAndClassUtil.NEI && this.isNEISearch()) {
            if (this.searchField.func_146179_b().isEmpty()) {
                this.setSuggestion("");
                return;
            }
            Optional<String> history = Ae2ReflectClient.getHistoryList(this.history).stream().filter(s -> s.startsWith(this.searchField.func_146179_b())).findFirst();
            if (history.isPresent()) {
                this.setSuggestion(history.get());
            } else {
                this.setSuggestion("");
            }
        }
    }

    private void setSuggestion(String suggestion) {
        this.searchField.setSuggestion(suggestion);
    }

    public void setSearchString(String memoryText, boolean updateView) {
        this.searchField.func_146180_a(memoryText);
        this.repo.setSearchString(memoryText);
        if (updateView) {
            this.repo.updateView();
            this.setScrollBar();
        }
        this.updateSuggestion();
    }

    public void setSearchString(String memoryText, boolean updateView, int pos) {
        this.setSearchString(memoryText, updateView);
        this.searchField.func_146190_e(pos);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        memoryText = this.searchField.func_146179_b();
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.SortByBox != null) {
            this.SortByBox.set(this.configSrc.getSetting(Settings.SORT_BY));
        }
        if (this.SortDirBox != null) {
            this.SortDirBox.set(this.configSrc.getSetting(Settings.SORT_DIRECTION));
        }
        if (this.ViewBox != null) {
            this.ViewBox.set(this.configSrc.getSetting(Settings.VIEW_MODE));
        }
        if (this.typeFilter != null) {
            this.typeFilter.set(this.configSrc.getSetting(Settings.TYPE_FILTER));
        }
        this.repo.updateView();
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode != SearchBoxMode.AUTOSEARCH && searchMode != SearchBoxMode.NEI_AUTOSEARCH) {
            this.searchField.func_146192_a(xCoord, yCoord, btn);
        }
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.setSearchString("", true);
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.craftingStatusBtn || btn == this.craftingStatusImgBtn) {
            InventoryHandler.switchGui(GuiType.CRAFTING_STATUS);
        }
        if (btn instanceof GuiImgButton) {
            GuiImgButton iBtn = (GuiImgButton)btn;
            boolean backwards = Mouse.isButtonDown((int)1);
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
                if (btn == this.terminalStyleBox) {
                    AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                } else if (btn == this.searchBoxSettings) {
                    AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                } else if (btn == this.searchStringSave) {
                    AEConfig.instance.preserveSearchBar = next == YesNo.YES;
                } else {
                    try {
                        NetworkHandler.instance.sendToServer((AppEngPacket)new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
                iBtn.set(next);
                if (next.getClass() == SearchBoxMode.class || next.getClass() == TerminalStyle.class) {
                    this.reInitalize();
                }
            }
        }
        super.func_146284_a(btn);
    }

    protected void reInitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    public Enum<?> getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    public Enum<?> getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    public Enum<?> getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    public Enum<?> getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        if (this.repo.hasCache()) {
            try {
                this.repo.getLock().lock();
                super.func_73863_a(mouseX, mouseY, btn);
            }
            finally {
                this.repo.getLock().unlock();
            }
        } else {
            super.func_73863_a(mouseX, mouseY, btn);
        }
        if (this.searchField == null) {
            return;
        }
        if (AEConfig.instance.preserveSearchBar) {
            this.handleTooltip(mouseX, mouseY, this.searchField.getTooltipProvider());
        }
        if (ModAndClassUtil.NEI && this.searchField.isMouseIn(mouseX, mouseY) && this.isNEISearch()) {
            List<String> list = Ae2ReflectClient.getHistoryList(this.history);
            this.drawHistorySelection(this.searchField.field_146209_f, this.searchField.field_146210_g, this.searchField.func_146179_b(), this.searchField.field_146218_h, list);
        }
    }

    public void bindTextureBack(String file) {
        ResourceLocation loc = new ResourceLocation("ae2thing", "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public boolean isOverTextField(int mousex, int mousey) {
        return this.searchField.isMouseIn(mousex, mousey);
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (ModAndClassUtil.THE && AspectUtil.getAspectFromJar((ItemStack)stack) != null) {
            this.setSearchString(Objects.requireNonNull(AspectUtil.getAspectFromJar((ItemStack)stack)).getName(), true);
        } else {
            this.setSearchString(NEI.searchField.getEscapedSearchText(displayName), true);
        }
        this.saveSearchString();
    }

    protected boolean mouseWheelEvent(int x, int y, int wheel) {
        if (ModAndClassUtil.NEI && this.searchField.isMouseIn(x, y) && this.isNEISearch()) {
            TextHistory.Direction direction;
            switch (wheel) {
                case -1: {
                    direction = TextHistory.Direction.PREVIOUS;
                    break;
                }
                case 1: {
                    direction = TextHistory.Direction.NEXT;
                    break;
                }
                default: {
                    return super.mouseWheelEvent(x, y, wheel);
                }
            }
            this.history.get(direction, this.searchField.func_146179_b()).ifPresent(t -> this.setSearchString((String)t, true));
        }
        return super.mouseWheelEvent(x, y, wheel);
    }

    public void func_146977_a(Slot s) {
        if (this.drawSlot(s)) {
            super.func_146977_a(s);
        }
    }

    @Override
    public float getzLevel() {
        return this.field_73735_i;
    }

    @Override
    public abstract void postUpdate(List<IAEItemStack> var1);

    @Override
    public void setPlayerInv(ItemStack is) {
        this.container.getPlayerInv().func_70437_b(is);
    }

    @Override
    public AEBaseGui getAEBaseGui() {
        return this;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public AdvItemRepo getRepo() {
        return this.repo;
    }

    public void func_146282_l() {
        super.func_146282_l();
        this.getRepo().setPaused(this.hasShiftDown());
    }

    @Override
    public THGuiTextField getSearchField() {
        return this.searchField;
    }

    static {
        memoryText = "";
    }
}

