/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api.adapter.pattern;

import appeng.core.AELog;
import appeng.helpers.IContainerCraftingPacket;
import com.asdflj.ae2thing.api.adapter.pattern.IRecipeHandler;
import com.asdflj.ae2thing.nei.object.OrderStack;
import com.asdflj.ae2thing.network.CPacketTransferRecipe;
import com.glodblock.github.common.item.ItemFluidPacket;
import java.util.HashMap;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IPatternTerminalAdapter {
    public static final HashMap<Class<? extends Container>, HashMap<String, IRecipeHandler>> map = new HashMap();

    default public boolean supportFluid() {
        return false;
    }

    public Class<? extends Container> getContainer();

    default public void transferPack(List<OrderStack<?>> packs, IInventory inv) {
        for (OrderStack<?> stack : packs) {
            ItemStack stack1;
            if (stack == null) continue;
            int index = stack.getIndex();
            if (stack.getStack() instanceof ItemStack) {
                stack1 = ((ItemStack)stack.getStack()).func_77946_l();
            } else if (this.supportFluid() && stack.getStack() instanceof FluidStack) {
                stack1 = ItemFluidPacket.newStack((FluidStack)((FluidStack)stack.getStack()));
            } else {
                AELog.warn((Throwable)new UnsupportedOperationException("Trying to get an unsupported item!"));
                continue;
            }
            if (index >= inv.func_70302_i_()) continue;
            inv.func_70299_a(index, stack1);
        }
    }

    default public IInventory getInventoryByName(Container container, String name) {
        if (container instanceof IContainerCraftingPacket) {
            IContainerCraftingPacket c = (IContainerCraftingPacket)container;
            return c.getInventoryByName(name);
        }
        return null;
    }

    default public String getCraftingInvName() {
        return "crafting";
    }

    default public String getOutputInvName() {
        return "output";
    }

    default public void transfer(Container container, List<OrderStack<?>> inputs, List<OrderStack<?>> outputs, String identifier, CPacketTransferRecipe message) {
        IRecipeHandler handler = this.getIdentifiers().get(identifier);
        if (handler == null) {
            return;
        }
        handler.transferPack(container, inputs, outputs, identifier, this, message);
    }

    default public IPatternTerminalAdapter registerIdentifier(String identifier, IRecipeHandler transferPack) {
        this.getIdentifiers().put(identifier, transferPack);
        return this;
    }

    default public HashMap<String, IRecipeHandler> getIdentifiers() {
        HashMap<String, IRecipeHandler> m = map.getOrDefault(this.getContainer(), new HashMap());
        map.put(this.getContainer(), m);
        return m;
    }
}

