/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseGui;
import codechicken.nei.recipe.GuiRecipe;
import com.asdflj.ae2thing.api.adapter.crafting.ICraftingTerminalAdapter;
import com.asdflj.ae2thing.api.adapter.findit.IFindItAdapter;
import com.asdflj.ae2thing.api.adapter.pattern.IPatternTerminalAdapter;
import com.asdflj.ae2thing.api.adapter.terminal.ITerminal;
import com.asdflj.ae2thing.api.adapter.terminal.item.ITerminalHandler;
import com.asdflj.ae2thing.client.gui.GuiCraftingTerminal;
import com.asdflj.ae2thing.client.gui.widget.IGuiMonitor;
import com.asdflj.ae2thing.nei.NEI_TH_Config;
import com.asdflj.ae2thing.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;

public class Terminal {
    public static Terminal API = new Terminal();
    private static final HashSet<Class<? extends AEBaseGui>> terminal = new HashSet();
    private static final HashSet<Class<? extends AEBaseGui>> terminalBlackList = new HashSet();
    private static final HashMap<Class<? extends Container>, ICraftingTerminalAdapter> craftingTerminal = new HashMap();
    private static final IItemList<IAEItemStack> tracking = AEApi.instance().storage().createPrimitiveItemList();
    private static final HashMap<Class<? extends IGridHost>, IFindItAdapter> storageProviders = new HashMap();
    private static final HashMap<Class<? extends Container>, IPatternTerminalAdapter> patternTerminal = new HashMap();
    private static final HashMap<Class<? extends Item>, ITerminalHandler> terminalItem = new HashMap();
    private static final HashSet<ITerminal> terminalSet = new HashSet();

    public void registerTerminal(Class<? extends AEBaseGui> clazz) {
        terminal.add(clazz);
    }

    public HashSet<Class<? extends AEBaseGui>> getTerminal() {
        return terminal;
    }

    public HashSet<ITerminal> getTerminalSet() {
        return terminalSet;
    }

    public void registerTerminalSet(ITerminal iTerminal) {
        terminalSet.add(iTerminal);
    }

    public void registerTerminalBlackList(Class<? extends AEBaseGui> clazz) {
        terminalBlackList.add(clazz);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isTerminal(GuiScreen gui) {
        if (gui == null) {
            return false;
        }
        if (gui instanceof IGuiMonitor) {
            return true;
        }
        return terminal.contains(gui.getClass());
    }

    public boolean isBackPackTerminal(GuiScreen gui) {
        return gui instanceof GuiCraftingTerminal;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPinTerminal(GuiScreen gui) {
        if (Util.getAEVersion() >= 586) {
            return false;
        }
        if (!NEI_TH_Config.getConfigValue("ae2thing.pinned_bar")) {
            return false;
        }
        if (gui == null || terminalBlackList.contains(gui.getClass())) {
            return false;
        }
        if (gui instanceof IGuiMonitor) {
            return true;
        }
        return terminal.contains(gui.getClass());
    }

    public void registerCraftingTerminal(ICraftingTerminalAdapter adapter) {
        craftingTerminal.put(adapter.getContainer(), adapter);
    }

    public HashMap<Class<? extends Container>, ICraftingTerminalAdapter> getCraftingTerminal() {
        return craftingTerminal;
    }

    public boolean isCraftingTerminal(Class<? extends Container> terminal) {
        return craftingTerminal.containsKey(terminal);
    }

    public void registerFindItStorageProvider(IFindItAdapter adapter) {
        storageProviders.putIfAbsent(adapter.getCls(), adapter);
    }

    public Collection<IFindItAdapter> getStorageProviders() {
        return storageProviders.values();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isCraftingTerminal(GuiScreen terminal) {
        if (terminal == null) {
            return false;
        }
        if (terminal instanceof GuiContainer) {
            GuiContainer gc = (GuiContainer)terminal;
            if (gc.field_147002_h != null) {
                return craftingTerminal.containsKey(gc.field_147002_h.getClass());
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addTrackingMissingItem(IAEItemStack is) {
        tracking.add((IAEStack)is);
    }

    @SideOnly(value=Side.CLIENT)
    public IItemList<IAEItemStack> getTrackingMissingItems() {
        return tracking;
    }

    @SideOnly(value=Side.CLIENT)
    public void clearTrackingMissingItems() {
        tracking.resetStatus();
    }

    public IPatternTerminalAdapter registerPatternTerminal(IPatternTerminalAdapter adapter) {
        patternTerminal.putIfAbsent(adapter.getContainer(), adapter);
        return adapter;
    }

    public boolean isPatternTerminal() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiRecipe) {
            GuiRecipe g = (GuiRecipe)gui;
            return patternTerminal.containsKey(g.getFirstScreen().field_147002_h.getClass());
        }
        return false;
    }

    public IPatternTerminalAdapter getPatternTerminal(Container c) {
        return patternTerminal.getOrDefault(c.getClass(), null);
    }

    public void registerTerminalItem(Class<? extends Item> item, ITerminalHandler terminal) {
        terminalItem.put(item, terminal);
    }

    public ITerminalHandler getOpenTerminalHandler(Class<? extends Item> item) {
        return terminalItem.get(item);
    }
}

