/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.AEApi;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.nei.NEI_TH_Config;
import com.asdflj.ae2thing.network.CPacketNetworkCraftingItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

@SideOnly(value=Side.CLIENT)
public class Pinned {
    private final HashMap<IAEItemStack, PinInfo> pinInfo = new HashMap();
    public static int MAX_PINNED = 9;
    public static Pinned INSTANCE = new Pinned();
    private long lastRunTime;
    private static final int interval = 1000;
    private static final Comparator<Map.Entry<IAEItemStack, PinInfo>> TIME_COMPARATOR = Comparator.comparing(e -> ((PinInfo)e.getValue()).since);
    private static final IItemDisplayRegistry registry = AEApi.instance().registries().itemDisplay();

    public Set<IAEItemStack> getPinnedItems() {
        return this.pinInfo.keySet();
    }

    public boolean isEmpty() {
        return this.pinInfo.isEmpty();
    }

    public void add(IAEItemStack item) {
        if (item == null) {
            return;
        }
        if (registry.isBlacklisted(item.getItem()) || registry.isBlacklisted(item.getItem().getClass())) {
            return;
        }
        PinInfo info = this.pinInfo.get(item);
        if (info != null) {
            info.since = Instant.now();
            info.canPrune = false;
        } else {
            this.pinInfo.put(item, new PinInfo(PinReason.CRAFTING));
        }
        if (this.pinInfo.size() > MAX_PINNED) {
            ArrayList<Map.Entry<IAEItemStack, PinInfo>> toRemove = new ArrayList<Map.Entry<IAEItemStack, PinInfo>>(this.pinInfo.entrySet());
            toRemove.sort(TIME_COMPARATOR);
            for (Map.Entry entry : toRemove.subList(0, toRemove.size() - MAX_PINNED)) {
                this.pinInfo.remove(entry.getKey());
            }
        }
    }

    public PinInfo remove(IAEItemStack item) {
        if (item == null) {
            return null;
        }
        return this.pinInfo.remove(item);
    }

    public boolean isPinnedItem(IAEItemStack item) {
        if (item == null) {
            return false;
        }
        return this.pinInfo.containsKey(item);
    }

    public List<IAEItemStack> getSortedPinnedItems() {
        ArrayList<Map.Entry<IAEItemStack, PinInfo>> list = new ArrayList<Map.Entry<IAEItemStack, PinInfo>>(this.pinInfo.entrySet());
        list.sort(TIME_COMPARATOR);
        return list.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Nullable
    public PinInfo getPinInfo(IAEItemStack item) {
        if (item == null) {
            return null;
        }
        return this.pinInfo.get(item);
    }

    public void togglePinnedItems(IAEItemStack stack) {
        if (stack == null || this.remove(stack) != null) {
            return;
        }
        this.add(stack);
    }

    public int getMaxPinSize() {
        return MAX_PINNED;
    }

    public void updatePinnedItems(List<IAEItemStack> items) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!AE2ThingAPI.instance().terminal().isPinTerminal(gui)) {
            return;
        }
        if (items == null || items.isEmpty()) {
            this.pinInfo.values().forEach(i -> {
                i.canPrune = true;
            });
            return;
        }
        HashSet<IAEItemStack> set = new HashSet<IAEItemStack>(items);
        for (IAEItemStack item : this.pinInfo.keySet()) {
            if (set.contains(item)) continue;
            this.pinInfo.get((Object)item).canPrune = true;
        }
    }

    public void prune() {
        if (NEI_TH_Config.getConfigValue("ae2thing.pinned_bar_remove")) {
            this.pinInfo.values().removeIf(v -> v.canPrune);
        }
    }

    public void clear() {
        this.pinInfo.clear();
    }

    public void updateCraftingItems(boolean force) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return;
        }
        if (!AE2ThingAPI.instance().terminal().isPinTerminal(gui)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRunTime >= 1000L || force) {
            CPacketNetworkCraftingItems p = new CPacketNetworkCraftingItems();
            AE2Thing.proxy.netHandler.sendToServer(p);
            this.lastRunTime = currentTime;
        }
    }

    public void updateCraftingItems() {
        this.updateCraftingItems(false);
    }

    public static class PinInfo {
        public Instant since;
        public PinReason reason;
        public boolean canPrune;

        public PinInfo(PinReason reason) {
            this.reason = reason;
            this.since = Instant.now();
        }
    }

    public static enum PinReason {
        CRAFTING;

    }
}

