/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.asdflj.ae2thing.common.Config;
import com.asdflj.ae2thing.common.item.ItemBackpackTerminal;
import com.asdflj.ae2thing.common.storage.CellInventory;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;

public class MagnetObject {
    public static String modeKey = "MagnetMode";
    private static final int range = Config.magnetRange;
    private final NBTTagCompound data;
    private Mode currentMode;
    private IItemList<IAEItemStack> blackList;
    private final ItemStack item;
    private CellInventory inventory;

    public static MagnetObject getMagnet(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBackpackTerminal)) continue;
            return new MagnetObject(stack);
        }
        return null;
    }

    public MagnetObject(ItemStack is) {
        this.item = is;
        this.data = Platform.openNbtData((ItemStack)is);
        this.currentMode = Mode.values()[this.data.func_74771_c(modeKey)];
    }

    private void addBlackItems(IAEItemStack is) {
        this.getBlackList().add((IAEStack)is);
    }

    public void clearBlackList() {
        this.blackList = AEApi.instance().storage().createPrimitiveItemList();
    }

    private IItemList<IAEItemStack> getBlackList() {
        if (this.blackList == null) {
            this.blackList = AEApi.instance().storage().createPrimitiveItemList();
        }
        return this.blackList;
    }

    public boolean injectItems(EntityPlayer player, EntityItem itemEntity) {
        try {
            if (this.inventory == null) {
                this.inventory = new CellInventory(this.item, null, player);
            }
            ItemStack stack = itemEntity.func_92059_d();
            IAEItemStack is = AEApi.instance().storage().createItemStack(stack);
            if (this.getBlackList().findPrecise((IAEStack)is) != null) {
                return false;
            }
            IAEItemStack result = this.inventory.injectItems(is, Actionable.MODULATE, null);
            if (result != null) {
                stack.field_77994_a = (int)result.getStackSize();
                this.addBlackItems(result);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        this.data.func_74774_a(modeKey, (byte)mode.ordinal());
    }

    public Mode getNextMode() {
        return Mode.values()[(this.getMode().ordinal() + 1) % Mode.values().length];
    }

    public void setNextMode() {
        this.setMode(this.getNextMode());
    }

    public void doMagnet(World world, Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        int range = MagnetObject.range;
        List items = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v).func_72314_b((double)range, (double)range, (double)range));
        for (EntityItem item : items) {
            if (item.func_92059_d() == null) continue;
            if (item.field_145804_b > 0) {
                item.field_145804_b = this.isBackpack() ? 7 : 0;
            }
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.func_70107_b(entity.field_70165_t - 0.2 + world.field_73012_v.nextDouble() * 0.4, entity.field_70163_u - 0.6, entity.field_70161_v - 0.2 + world.field_73012_v.nextDouble() * 0.4);
            if (!Platform.isServer() || !this.isBackpack() || !this.injectItems((EntityPlayer)entity, item)) continue;
            item.func_70106_y();
        }
        world.func_72956_a(entity, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        if (!world.field_72995_K) {
            List xp = world.func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v).func_72314_b(4.0, 4.0, 4.0));
            EntityPlayer player = (EntityPlayer)entity;
            for (EntityXPOrb orb : xp) {
                if (orb.field_70532_c != 0 || !orb.func_70089_S() || MinecraftForge.EVENT_BUS.post((Event)new PlayerPickupXpEvent(player, orb))) continue;
                world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                player.func_71001_a((Entity)orb, 1);
                player.func_71023_q(orb.field_70530_e);
                orb.func_70106_y();
            }
        }
    }

    public boolean isBackpack() {
        return this.getMode() == Mode.Backpack;
    }

    public boolean isInv() {
        return this.getMode() == Mode.Inv;
    }

    public boolean isOff() {
        return this.getMode() == Mode.Off;
    }

    public static enum Mode {
        Off,
        Inv,
        Backpack;

    }
}

