[中文](./README.md) | English

<div align="center">
<img alt="logo" height="120" src="./assets/img/logo/puock.png" width="120"/>
</div>

## Introduction

![cover](./screenshot.png)

<div align="center">
    <h1>WordPress Theme - Puock</h1>
    <p>A high-value adaptive theme based on WordPress, supporting day and night modes.</p>
      <a target="_blank" href="https://github.com/Licoy/wordpress-theme-puock/releases/latest">
        <img src="https://img.shields.io/github/v/release/Licoy/wordpress-theme-puock.svg?logo=git" alt="Release-Version">
      </a>
    <a target="_blank" href="https://github.com/Licoy/wordpress-theme-puock">
        <img src="https://img.shields.io/badge/WordPress-V5.0+-0099CC.svg?logo=wordpress" alt="WordPress-Version">
      </a>
    <a target="_blank" href="https://github.com/Licoy/wordpress-theme-puock">
        <img src="https://img.shields.io/badge/PHP-V7.4+-666699.svg?logo=php" alt="PHP-Version">
      </a>
    <br>
    <a target="_blank" href="https://t.me/puocktheme">
        <img src="https://img.shields.io/badge/TG-@PuockTheme-29a9ec.svg?logo=Telegram" alt="Telegram Group">
      </a>
    <br><br>
    <img src='https://repobeats.axiom.co/api/embed/5f966833712409c00d4269bf2800b2d4762e09ea.svg'></img>
    <br><br>
    <a href="https://www.producthunt.com/posts/puock-wordpress-theme?utm_source=badge-featured&utm_medium=badge&utm_souce=badge-puock-wordpress-theme" target="_blank"><img src="https://api.producthunt.com/widgets/embed-image/v1/featured.svg?post_id=327798&theme=light" alt="Puock WordPress Theme - A high-value adaptive theme based on WordPress | Product Hunt" style="width: 250px; height: 54px;" width="250" height="54" /></a>
</div>

## Theme options screenshot
![theme-options.png](./.screenshot/options.png)

## Install
Please go to the [release version](https://github.com/Licoy/wordpress-theme-puock/releases) to download the latest version, and then click "Add" in "Appearance"-"Themes" in the WordPress management background, select Puock's theme package to upload, install and enable it.

**Tip: in order to prevent incompatible themes, please backup data before installing themes to prevent data fields from overlapping.**

### Environmental requirements

- WordPress `6.0+`
- PHP `7.4+`

## Theme characteristics
- [x] Support day and dark mode
- [x] Global load without refresh
- [x] Support blog, CMS, enterprise three layouts
- [x] Built-in WP optimization strategy
- [x] Built-in frontend user center
- [x] Support QQ / Github / Gitee / Weibo login
- [x] Support thumbnail pseudo-static
- [x] Global top scrolling announcements
- [x] Graphics and geetest captcha support
- [x] Custom SMTP support
- [x] All sites are grayed out with one click
- [x] Web page compressed into one line
- [x] Background anti-malicious login
- [x] Great SEO features built in
- [x] Comments ajax loaded
- [x] Article likes, rewards, poster generation, sharing
- [x] Twemoji integration
- [x] Rich ad slots
- [x] Rich widgets
- [x] Automatic Baidu link submission
- [x] Numerous page templates (Reader Wall/Archives/Book Recommendations/Site Navigation/Tags/Sitemap etc.)
- [x] Numerous shortcode support (visible after downloading / commenting / visible after login / visible after login and verification email / multiple prompt boxes / Github cards, etc.)
- [x] Support Dplayer player
- [x] MacOS-like code style and copy code
- [x] High-value background configuration integrated with Vue3+NaiveUI
- [x] Article multi-level directory generation
- [x] Sidebar sticky scrolling
- [x] WP cache support
- [x] Custom primary color
- [x] LOGO sweep light animation
- [x] ChatGPT and AI painting support
- [x] Please refer to the release notes for more feature updates：[releases](https://github.com/Licoy/wordpress-theme-puock/releases)
- [x] More features, waiting for your [proposal](https://github.com/Licoy/wordpress-theme-puock/issues)
## Documentation
- Theme use document: [Use immediately](https://www.licoy.cn/puock-doc.html)
## Support
- Reward theme to support：[Click me in](https://licoy.cn/puock-theme-sponsor.html)
## Thanks
- [Jetbrains](https://www.jetbrains.com/?from=wordpress-theme-puock)
- [Cloudflare](https://www.cloudflare.com/?from=wordpress-theme-puock)
- <a href="http://idc.daozhiyun.cn"><img src="https://sv.png.pub/imgs/2024/06/26/fd4efab4bfd2bb9e.png" width="100"></a>
## License
- [GPL 3.0](./LICENSE)
- Please abide by the open source agreement and keep the author's signature at the bottom of the subject
