package ClaRa "Simulation of Clausius-Rankine Cycles"
  extends ClaRa.Basics.Icons.PackageIcons.ClaRab100;
  import SI = ClaRa.Basics.Units;

  package Basics "Fundamental classes like functions and records"
    extends ClaRa.Basics.Icons.PackageIcons.Basics100;

    package Interfaces
      extends ClaRa.Basics.Icons.PackageIcons.Basics80;

      connector CycleSumPort
      //    flow SI.Mass mass_fluid "Accumulated fluid mass";
        flow Units.Power power_in;
        flow Units.Power power_out_elMech;
        flow Units.Power power_out_th;
        flow Units.Power power_aux;
          annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
         Icon(graphics={Ellipse(
                extent={{-100,100},{100,-100}},
                lineColor={149,45,152},
                lineThickness=0.5,
                fillColor={149,45,152},
                fillPattern=FillPattern.Solid)}));
      end CycleSumPort;
    end Interfaces;

    package Icons
      extends ClaRa.Basics.Icons.PackageIcons.Basics80;

      package PackageIcons
        extends ClaRa.Basics.Icons.PackageIcons.Basics60;

        partial class Basics100

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource="iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMZJREFUeNrs16ERAyEQhtGQoQ0sjv4LwWEpZOMjIrnby3sNMPzmmy0R8XqC1sczPgKQxNsEAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAwLfa+ggzAOACAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQAfqsnHtlrFlMDGbQ+wgouEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBATACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAPdSTUBWrY+wwn3sNYsVXCAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAsBVqgnIaq9ZrAAuEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEB4JRqAoCz9prFBQLA3xIQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQEgsXrikdZHmBrABQIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAGT2EWAAgW8XmDb+pwcAAAAASUVORK5CYII=",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Basics_100.png")}));

        end Basics100;

        partial class Basics80

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},
                    {100,100}}), graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource="iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMVJREFUeNrs1yESAyEQRcGQ4nRIDGfEILnexEdEsjub7gtQfPNqSkS8nqD18YyPACTxNgEAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIADwrbY+wgwAuEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAYDf6olH9prF1EAGrY+wggsEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAExAQACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgLAvVQTkFXrI6xwH3vNYgUXCAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAcJVqArLaaxYrgAsEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAA4pZoA4Ky9ZnGBAPC3BAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAAEisnnik9RGmBnCBAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAmX0EGAAiTxgbBNuQzAAAAABJRU5ErkJggg==",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Basics_80.png")}));

        end Basics80;

        partial class Basics60

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}),
                                 graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource=
                      "iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMNJREFUeNrs17ENAyEQRUFjbdEkCCESul7nDhxyx3mmAcRPnjYy8/UEtY1nfATgEG8TACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAN+itpFmAMAFAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgA/BY7HlmzF1MDJ6htpBVcIAAICAACAoCAACAgACAgAAgIAAICgIAAICAmAEBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAO4lTMCpahtphftYsxcruEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBICrhAk41Zq9WAFcIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICwC5hAoC91uzFBQLA3xIQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQHgYLHjkdpGmhrABQIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAJzsI8AAFZMYoS8IGjMAAAAASUVORK5CYII=",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Basics_60.png")}));

        end Basics60;

        partial class Components100

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}),
                                 graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource=
                      "iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMhJREFUeNrs17ENAyEQRUFjbRukZPRfCBkphaxzy7IuOpu7mQYQP3nakpmPK6itX+MjAJt4mgAAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAB4F7X1NAMALhAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAOC7OOORNUcxNbCD2npawQUCgIAAICAACAgAAgIAAgKAgAAgIAAICAACYgIABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQHgv4QJjqutpxXgszVHsYILBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAA+JUwwXFrjmIFABcIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIADcU5gA4FxrjuICAeC2BAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAANhYnPFIbT1NDeACAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAAdvYSYADByReYenQ6nwAAAABJRU5ErkJggg==",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Components_100.png")}));

        end Components100;

        partial class Components80

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}),
                                 graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource=
                      "iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMlJREFUeNrs1zEOAiEURVExbE46KWSNNJRs79tPjJlqlJlzNkB4zc1PEXE7g1LbOT4CsIi7CQAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQFAQABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAYCt9Hi+wgwAuEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAYDv8hGPzNGTqYEVlNrCCi4QAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEBMAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgA/yWbYL9SW1gBPpujJyu4QABAQAAQEAAEBAABAUBAAEBAABAQAAQEAAEBQEAAQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAAEBAABAQAAQFAQAAQEAAQEAAEBAABAUBAABAQABAQAAQEgF/JJthvjp6sAOACAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABASAa8omADjWHD25QAC4LAEBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABAQABAUBAABAQAAQEAAEBAAEBQEAAEBAABAQAAQEAAQFAQAAQEAAWlo94pNQWpgZwgQCAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIACt7CzAAEn4YFbcde0oAAAAASUVORK5CYII=",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Components_80.png")}));

        end Components80;

        partial class Components60

          annotation (Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                    -100},{100,100}}),
                                 graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource=
                      "iVBORw0KGgoAAAANSUhEUgAAAZAAAAGQCAYAAACAvzbMAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABMVJREFUeNrs1zEKAyEQhtEY5tA2ImLjrSd9CGGrTdx97wLi33xMyczHFdQ2rvERgE08TQCAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAC8i9pGmgEAFwgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgAPBdnPHImr2YGthBbSOt4AIBQEAAEBAABAQAAQEAAQFAQAAQEAAEBAABMQEAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgADwX8IEx9U20grw2Zq9WMEFAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAACAgACAgAAgKAgAAgIAAICAAICAACAoCAACAgAAgIAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgAAgIAAgIAAICAACAoCAACAgACAgAAgIAAICgIAAICAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAA/EqY4Lg1e7ECgAsEAAEBQEAAEBAABAQABAQAAQFAQAAQEAAEBAAEBAABAUBAABAQAAQEAAQEAAEBQEAAEBAABAQABAQAAQFAQAAQEADuKUwAcK41e3GBAHBbAgKAgAAgIAAICAACAgACAoCAACAgAAgIAAICAAICgIAAICAACAgAAgIAAgKAgAAgIAAICAACAgACAoCAACAgAGwszniktpGmBnCBAICAACAgAAgIAAICgIAAgIAAICAACAgAAgKAgACAgAAgIAAICAACAoCAAICAACAgAAgIAAICgIAAgIAAICAACAgAO3sJMAADihieiMJ3bAAAAABJRU5ErkJggg==",
                  fileName="modelica://ClaRa/Resources/Images/Packages/Components_60.png")}));

        end Components60;

        package ClaRab100
          annotation (Icon(graphics={Bitmap(
                  extent={{-100,-100},{100,100}},
                  imageSource=
                      "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",
                  fileName="modelica://ClaRa/Resources/Images/Packages/ClaRa.png")}));
        end ClaRab100;
      end PackageIcons;

      record RecordIcon

        annotation (Icon(graphics={
              Polygon(
                points={{-100,60},{100,60},{100,-60},{-100,-60},{-100,60}},
                smooth=Smooth.None,
                fillColor={153,205,221},
                fillPattern=FillPattern.Solid,
                lineColor={51,156,186}),
              Line(
                points={{-40,60},{-40,-60}},
                color={51,156,186},
                smooth=Smooth.None),
              Line(
                points={{40,60},{40,-60}},
                color={51,156,186},
                smooth=Smooth.None),
              Line(
                points={{-100,0},{100,0}},
                color={51,156,186},
                smooth=Smooth.None),
              Text(
                extent={{-100,100},{100,60}},
                lineColor={51,156,186},
                textString="%name")}));
      end RecordIcon;
    end Icons;

    package Units
      extends ClaRa.Basics.Icons.PackageIcons.Basics80;

      type AbsolutePressure = Real(final quantity= "PressureDifference", final unit="Pa", displayUnit="Pa", nominal= 1e5, min=0);

      type EnthalpyMassSpecific = Real(final quantity= "MassSpecificEnthalpy", final unit="J/kg", displayUnit="J/kg", nominal= 1e3);

      type EntropyMassSpecific = Real(final quantity= "MassSpecificEntropy", final unit="J/(kg.K)", displayUnit="J/(kg.K)", nominal= 1e3,min=0);

      type HeatCapacityMassSpecific = Real(final quantity= "SpecificHeatCapacity", final unit="J/(kg.K)", displayUnit="J/(kg.K)", nominal= 1e3);

      type MassFraction = Real(final quantity= "MassFraction", final unit="kg/kg", displayUnit="kg/kg", nominal=1, min=0);

      type Power = Real(final quantity= "Power", final unit="W", displayUnit="W", nominal= 1e5);

      type RelativeHumidity = Real(final quantity= "RelativeHumidity", final unit="1", displayUnit="1", nominal= 0, min=0);

      type Temperature = Real(final quantity= "Temperature", final unit="K", min=0, displayUnit="K") "Absolute thermodynamic temperature";

      type Time =  Real(final quantity= "Time", final unit="s", displayUnit="s", nominal= 1);
    end Units;

    package Media "Media data (properties of air, water, steam, ...)"
      extends ClaRa.Basics.Icons.PackageIcons.Basics80;

      package FuelTypes
      extends ClaRa.Basics.Icons.PackageIcons.Basics60;

        record BaseFuel "Chose fuel below:"
          //___________________________________________________________________________//
          // Component of the ClaRa library, version: 1.6.0                            //
          //                                                                           //
          // Licensed by the DYNCAP/DYNSTART research team under Modelica License 2.   //
          // Copyright  2013-2020, DYNCAP/DYNSTART research team.                      //
          //___________________________________________________________________________//
          // DYNCAP and DYNSTART are research projects supported by the German Federal //
          // Ministry of Economic Affairs and Energy (FKZ 03ET2009/FKZ 03ET7060).      //
          // The research team consists of the following project partners:             //
          // Institute of Energy Systems (Hamburg University of Technology),           //
          // Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
          // TLK-Thermo GmbH (Braunschweig, Germany),                                  //
          // XRG Simulation GmbH (Hamburg, Germany).                                   //
          //___________________________________________________________________________//

          extends ClaRa.Basics.Media.FuelTypes.EmptyFuel;
          extends ClaRa.Basics.Icons.RecordIcon;
          constant Integer N_c=5 "Number of components";
          constant Integer N_e=5 "Number of elements";
          parameter Real C_LHV[N_c] = {1,1,1,1,1} "Coefficients for LHV calculation";
          parameter Real C_cp[N_c] = {1,1,1,1,1} "Coefficients for cp calculation";
          constant Real C_rho[N_c] = {1,1,1,1,1} "Coefficients for rho calculation";
          constant Integer waterIndex "Index of water in composition";
          constant Integer ashIndex "Index of ash in composition";
          constant ClaRa.Basics.Units.MassFraction defaultComposition[N_c - 1] "Elemental compostion of combustible, e.g. {C,H,O,N,S, H2O, ash}";
          parameter ClaRa.Basics.Units.MassFraction xi_e_waf[:,:] "water and ash free elementary composition of the two pure fuels";
          constant ClaRa.Basics.Units.Temperature T_ref=273.15 "Reference temperature";
          //
              annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions=
                "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"));
        end BaseFuel;

        record Fuel_refvalues_v1 "{fuel_waf, ash, h2o } |  former 'Coal_v1'  | C,H,O,N,S,Ash,H2O"
          //___________________________________________________________________________//
          // Component of the ClaRa library, version: 1.6.0                            //
          //                                                                           //
          // Licensed by the DYNCAP/DYNSTART research team under Modelica License 2.   //
          // Copyright  2013-2020, DYNCAP/DYNSTART research team.                      //
          //___________________________________________________________________________//
          // DYNCAP and DYNSTART are research projects supported by the German Federal //
          // Ministry of Economic Affairs and Energy (FKZ 03ET2009/FKZ 03ET7060).      //
          // The research team consists of the following project partners:             //
          // Institute of Energy Systems (Hamburg University of Technology),           //
          // Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
          // TLK-Thermo GmbH (Braunschweig, Germany),                                  //
          // XRG Simulation GmbH (Hamburg, Germany).                                   //
          //___________________________________________________________________________//

          extends ClaRa.Basics.Media.FuelTypes.BaseFuel(
            N_c=3,
            N_e=7,
            C_LHV={30769230.769230768,0,-2500e3},
            C_rho={500,7000,1000},
            C_cp={1266.67,1000,4190},
            waterIndex=3,
            ashIndex=2,
            defaultComposition={0.975,0.025},
            xi_e_waf={{0.8205128205128206,0.05128205128205129,0.05128205128205129,0.05128205128205129}},
            T_ref=273.15);
                annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions=
                "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"));
        end Fuel_refvalues_v1;

        partial record EmptyFuel "Allows support of obsolete fuel definition applied in version <= 1.2.2"
        //__________________________________________________________________________//
        // Component of the ClaRa library, version: 1.6.0                           //
        //                                                                          //
        // Licensed by the ClaRa development team under Modelica License 2.         //
        // Copyright  2013-2021, ClaRa development team.                            //
        //                                                                          //
        // The ClaRa development team consists of the following partners:           //
        // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
        // XRG Simulation GmbH (Hamburg, Germany).                                  //
        //__________________________________________________________________________//
        // Contents published in ClaRa have been contributed by different authors   //
        // and institutions. Please see model documentation for detailed information//
        // on original authorship and copyrights.                                   //
        //__________________________________________________________________________//

            annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
         Icon(coordinateSystem(preserveAspectRatio=false), graphics={Rectangle(extent={{-60,52},{60,-56}}, lineColor={238,46,47}), Text(
                  extent={{-46,10},{54,-10}},
                  lineColor={238,46,47},
                  textString="Will be removed in version 1.4.0")}), Diagram(coordinateSystem(preserveAspectRatio=false)));
        end EmptyFuel;
      end FuelTypes;

      package Slag
      extends ClaRa.Basics.Icons.PackageIcons.Basics60;

        record Slag_v1
          //___________________________________________________________________________//
          // Component of the ClaRa library, version: 1.6.0                            //
          //                                                                           //
          // Licensed by the DYNCAP/DYNSTART research team under Modelica License 2.   //
          // Copyright  2013-2020, DYNCAP/DYNSTART research team.                      //
          //___________________________________________________________________________//
          // DYNCAP and DYNSTART are research projects supported by the German Federal //
          // Ministry of Economic Affairs and Energy (FKZ 03ET2009/FKZ 03ET7060).      //
          // The research team consists of the following project partners:             //
          // Institute of Energy Systems (Hamburg University of Technology),           //
          // Institute of Thermo-Fluid Dynamics (Hamburg University of Technology),    //
          // TLK-Thermo GmbH (Braunschweig, Germany),                                  //
          // XRG Simulation GmbH (Hamburg, Germany).                                   //
          //___________________________________________________________________________//
         extends ClaRa.Basics.Media.Slag.PartialSlag(cp=800);
                                                           // F.Brandt FDBR Band I;
        annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions=
                "<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"));
        end Slag_v1;

        record PartialSlag "Base class for solid type media definition"
        //__________________________________________________________________________//
        // Component of the ClaRa library, version: 1.6.0                           //
        //                                                                          //
        // Licensed by the ClaRa development team under Modelica License 2.         //
        // Copyright  2013-2021, ClaRa development team.                            //
        //                                                                          //
        // The ClaRa development team consists of the following partners:           //
        // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
        // XRG Simulation GmbH (Hamburg, Germany).                                  //
        //__________________________________________________________________________//
        // Contents published in ClaRa have been contributed by different authors   //
        // and institutions. Please see model documentation for detailed information//
        // on original authorship and copyrights.                                   //
        //__________________________________________________________________________//

        constant ClaRa.Basics.Units.HeatCapacityMassSpecific cp;
            annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
        revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),
         Icon(graphics={
                Line(
                  points={{-72,34},{-38,6},{-4,48},{38,6},{66,36}},
                  color={255,255,255},
                  smooth=Smooth.Bezier),
                Line(
                  points={{-74,-8},{-40,-38},{-6,4},{36,-38},{66,-8}},
                  color={255,255,255},
                  smooth=Smooth.Bezier),
                Line(
                  points={{-76,-48},{-42,-78},{-8,-36},{34,-78},{64,-48}},
                  color={255,255,255},
                  smooth=Smooth.Bezier),
                                 Bitmap(extent={{-100,-100},{100,100}},
                  imageSource=
                      "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",
                  fileName="modelica://ClaRa/Resources/Images/Components/Slag.png")}));

        end PartialSlag;
      end Slag;
    annotation (Documentation(info="<html>
<p><h2><font color=\"#008000\">AP 2.6 Implementierung der bentigten Stoffdaten</font></h2></p>
<p>Ziel dieses Arbeitspaketes ist die Implementierung der f&uuml;r die Simulation aller anderen Kom-ponenten ben&ouml;tigten Stoffdaten in die zu erstellende ClaRa-Modelica-Bibliothek. Dabei geht es insbesondere darum, die relevanten physikalischen Effekte f&uuml;r den jeweiligen Teilbe-reich der Gesamtmodelle mit hinreichender Genauigkeit abzubilden. Gleichzeitig ist es not-wendig, einen transparenten und schnell rechnenden Programmecode zu erzeugen.</p>
<p>Zur Simulation des konventionellen Kraftwerksprozesses wird beispielsweise die genaue Abbildung der Stoffdaten von Wasser ben&ouml;tigt, um eine hinreichende Genauigkeit der Simu-lationsergebnisse f&uuml;r den Wasser-Dampfkreislauf zu gew&auml;hrleisten. Diese Stoffdaten sind zwar grunds&auml;tzlich vorhanden, m&uuml;ssen aber ggf. noch bzgl. Rechengeschwindigkeit optimiert und in die ClaRa-Modelica-Bibliothek eingebunden werden. In anderen Bereichen, wie der CO2-Rauchgasw&auml;sche, der Rauchgasseite des Kraftwerks oder der CO2-Aufreinigung werden neue Stoffdatenmodelle ben&ouml;tigt. Die Vielzahl vorhandener Modellen f&uuml;r die Berechnung von Stoffdaten macht die Auswahl eines ad&auml;quaten Ansatzes schwierig. Hierbei kann die Validierung der Modellergebnisse durch Literaturquellen unterst&uuml;tzt werden.</p>
</html>"));
    end Media;
  end Basics;

  package Components
  "Containing general description of pumps, heat exchangers,..."
    extends ClaRa.Basics.Icons.PackageIcons.Components100;

    package Utilities "Some nice help for modelling"
    extends ClaRa.Basics.Icons.PackageIcons.Components80;

      package Blocks "Some rucial control elements"
          extends ClaRa.Basics.Icons.PackageIcons.Components60;

        block LimPID "P, PI, PD, and PID controller with limited output, anti-windup compensation and delayed, smooth activation"
          import InitPID =
                 Modelica.Blocks.Types.Init;
          import Modelica.Blocks.Types.SimpleController;

          output Real controlError = u_s - u_m "Control error (set point - measurement)";

        //---------------------------------------
        //General Design of the Controller ------
          parameter Modelica.Blocks.Types.SimpleController controllerType=
                 Modelica.Blocks.Types.SimpleController.PID "Type of controller" annotation(Dialog(group="General Design of Controller"));
          parameter Real sign= 1 "set to 1 if a positive control error leads to a positive control output, else -1"
                                                                                               annotation(Dialog(group="General Design of Controller"));
          parameter Boolean perUnitConversion= true "True, if input and output values should be normalised with respect to reference values"
                                                                                                    annotation(Dialog(group="Normalisation of I/O Signals"));
          parameter Real u_ref = 1 "Reference value for controlled variable"
                                                                            annotation(Dialog(enable=perUnitConversion, group="Normalisation of I/O Signals"));
          parameter Real y_ref = 1 "Reference value for actuated variable"
                                                                          annotation(Dialog(enable=perUnitConversion, group="Normalisation of I/O Signals"));
          parameter Real y_max=1 "Upper limit of output" annotation(Dialog(group="Limiter for Controller Output"));
          parameter Real y_min=-y_max "Lower limit of output" annotation(Dialog(group="Limiter for Controller Output"));

        //----------------------------------------
        //Time Resononse of the Controller -------
          parameter Real k = 1 "Gain of Proportional block"
                                                           annotation(Dialog(group="Time Response of the Controller"));
          parameter Modelica.Units.SI.Time Tau_i(min=Modelica.Constants.small) = 0.5 "1/Ti is gain of integrator block" annotation (Dialog(enable=controllerType == Modelica.Blocks.Types.SimpleController.PI or controllerType == Modelica.Blocks.Types.SimpleController.PID, group="Time Response of the Controller"));
          parameter Modelica.Units.SI.Time Tau_d(min=0) = 0.1 "Gain of derivative block" annotation (Dialog(enable=controllerType == Modelica.Blocks.Types.SimpleController.PD or controllerType == Modelica.Blocks.Types.SimpleController.PID, group="Time Response of the Controller"));

          parameter Modelica.Units.SI.Time Ni(min=100*Modelica.Constants.eps) = 0.9 "1/Ni is gain of anti-windup compensation" annotation (Dialog(enable=controllerType == Modelica.Blocks.Types.SimpleController.PI or controllerType == Modelica.Blocks.Types.SimpleController.PID, group="Anti-Windup Compensation"));
          parameter Real Nd = 1 "The smaller Nd, the more ideal the derivative block, setting Nd=0 introduces ideal derivative"
               annotation(Dialog(enable=controllerType==Modelica.Blocks.Types.SimpleController.PD or
                                        controllerType==Modelica.Blocks.Types.SimpleController.PID,group="Derivative Filtering"));

        //------------------- Controller activation --------------------

        parameter Boolean use_activateInput = false "Provide Boolean input to switch controller on/off."
                                                            annotation(Dialog(tab="Controller activation"));
          parameter ClaRa.Basics.Units.Time t_activation=0.0 "Time when controller is switched on. For use_activateInput==true the controller is switched on if (time>t_activation AND activateController=true)." annotation (Dialog(tab="Controller activation"));
          parameter ClaRa.Basics.Units.Time Tau_lag_I=0.0 "Time lag for activation of integral part AFTER controller is being switched on " annotation (Dialog(tab="Controller activation"));

        parameter Real y_inactive = 1 "Controller output if controller is not active" annotation(Dialog(tab="Controller activation"));

        //Signal Smoothening---------------------------

      public
          parameter Real Tau_in(min=0)=0 "Time constant for input smoothening, Tau_in=0 refers to signal no smoothening"
              annotation(Dialog(tab="I/O Filters"));
          parameter Real Tau_out(min=0)=0 "time constant for output smoothening, Tau_out=0 refers to signal no smoothening"
                   annotation(Dialog(tab="I/O Filters"));

        //Initialisation--------------------------
      public
          parameter Integer initOption = 501 "Initialisation option" annotation(choicesAllMatching, Dialog(tab="Initialisation"), choices(choice = 501 "No init (y_start and x_start as guess values)",
                                                                                                            choice=502 "Steady state",
                                                                                                            choice=503 "Force y_start/y_inactive at output"));
          parameter Boolean limitsAtInit = true "= false, if limits are ignored during initializiation"
            annotation(Dialog(tab="Initialisation",
                               enable=controllerType==SimpleController.PI or
                                      controllerType==SimpleController.PID));

          parameter Real xi_start=0 "Initial or guess value value for integrator output (= integrator state)"
            annotation (Dialog(enable= initOption == 501,  tab="Initialisation"));


          parameter Real y_start=0 "Initial value of output"
            annotation(Dialog(enable=(initOption == 503 or initOption == 502), tab=
                  "Initialisation"));

        //Expert Settings---------------------------------------------------------------
          parameter Real Tau_add(min=0)=0 "Set to >0 for additional state after add block in controller, if DAE-index reduction fails."
            annotation(Dialog(tab="Expert Settings", group="DAE Index Reduction"));
          parameter Real xd_start=0 "Initial or guess value for state of derivative block"
            annotation (Dialog(tab="Expert Settings", group= "Obsolete Settings",
                                 enable=((controllerType==Modelica.Blocks.Types.SimpleController.PD or
                                        controllerType==Modelica.Blocks.Types.SimpleController.PID) and initOption == 501)));
      protected
          parameter Boolean with_I = controllerType==Modelica.Blocks.Types.SimpleController.PI or
                                     controllerType==Modelica.Blocks.Types.SimpleController.PID annotation (HideResult=true);
          parameter Boolean with_D = controllerType==Modelica.Blocks.Types.SimpleController.PD or
                                     controllerType==Modelica.Blocks.Types.SimpleController.PID annotation (HideResult=true);
          Real resetValueP(start=0, fixed=true) "Input to P part before controller activation";
          Real resetValueID(start=0, fixed=true) "Output of controller before activation";

          Real resetValueI "";

        //  parameter Real y_in_start(fixed=false) "Start value of inlet pseudo state";
        //   parameter Real y_out_start(fixed=false) "Start value of outlet pseudo state";
        //   parameter Real y_aux_start(fixed=false) "Start value of auxilliary pseudo state";
      public
          Modelica.Blocks.Interfaces.RealInput u_s "Connector of setpoint input signal"
            annotation (Placement(transformation(extent={{-240.5,-20},{-200.5,20}},
                  rotation=0), iconTransformation(extent={{-140,-20},{-100,20}})));
          Modelica.Blocks.Interfaces.RealInput u_m "Connector of measurement input signal"
            annotation (Placement(transformation(
                origin={0,-216},
                extent={{20,-20},{-20,20}},
                rotation=270), iconTransformation(
                extent={{20,-20},{-20,20}},
                rotation=270,
                origin={1,-120})));

            Modelica.Blocks.Interfaces.BooleanInput activateInput if use_activateInput "true, if controller is on"
                                        annotation (Placement(transformation(extent={{-239.5,140},{-199.5,180}}),
                                          iconTransformation(extent={{-140,-100},{-100,-60}})));

          Modelica.Blocks.Interfaces.RealOutput y "Connector of actuator output signal"
            annotation (Placement(transformation(extent={{260,-10},{280,10}}, rotation=0),
                iconTransformation(extent={{100,-10},{120,10}})));
          Modelica.Blocks.Math.Gain P(k=k)
                             annotation (Placement(transformation(extent={{-18,60},{2,80}},   rotation=0)));
          ClaRa.Components.Utilities.Blocks.Integrator I(
            y_startInputIsActive=true,
            Tau_i_const=Tau_i,
            initOption= if initOption == 798    then 504
                      else if initOption == 796 then 504
                      else if initOption == 797  then 504
                      else if initOption == 795 or initOption == 501 then 501
                      else if initOption == 502 then 502
                      else if initOption == 503 then 504 else 0) if  with_I annotation (Placement(transformation(extent={{-30,-92},{-10,-72}}, rotation=0)));

          ClaRa.Components.Utilities.Blocks.DerivativeClaRa D_approx(
            k=Tau_d,
            x_start=xd_start,
            initOption=if initOption == 798 or initOption == 796 or initOption == 502 or initOption == 503 then 502
                       else if initOption == 797 then 799
                       else if initOption == 795 or initOption == 501 then 501
                       else 0,
            Tau=Nd) if with_D annotation (Placement(transformation(extent={{-26,-10},{-6,10}},rotation=0)));
          Modelica.Blocks.Math.Add3 addPID(
            k1=1,
            k2=1,
            k3=1)                 annotation (Placement(transformation(extent={{42,-5},{52,5}},  rotation=0)));
          Modelica.Blocks.Math.Add addI if with_I annotation (Placement(transformation(
                extent={{-5,-5},{5,5}},
                rotation=0,
                origin={-60,-105})));
          Modelica.Blocks.Math.Gain gainTrack(k=1/Ni) if   with_I
            annotation (Placement(transformation(extent={{3,-119},{-10,-132}},
                                                                             rotation=0)));
          Modelica.Blocks.Nonlinear.Limiter limiter(uMax=if perUnitConversion then y_max/y_ref else y_max, uMin=if perUnitConversion then y_min/y_ref else y_min) annotation (Placement(transformation(extent={{154,-2},{174,18}}, rotation=0)));

      public
          Modelica.Blocks.Sources.Constant Dzero(k=0) if not with_D
            annotation (Placement(transformation(extent={{-13,-25.5},{-6,-18.5}},
                                                                             rotation=0)));
          Modelica.Blocks.Sources.RealExpression
                                           Izero(y=resetValueI) if      not with_I
            annotation (Placement(transformation(
                extent={{-6,-4},{4,6}},
                rotation=0,
                origin={-15.5,-104.75})));
          Modelica.Blocks.Math.Gain toPU(k=if perUnitConversion then sign/u_ref else
                sign) "convert input values to \"per unit\""
                                                   annotation (Placement(transformation(
                  extent={{-106,-10},{-86,10}},
                                             rotation=0)));
          Modelica.Blocks.Math.Feedback feedback
            annotation (Placement(transformation(extent={{-190.5,-10},{-170.5,10}},
                                                                              rotation=0)));
          Modelica.Blocks.Math.Gain fromPU(k=if perUnitConversion then y_ref else 1) "convert output values to \"Real\""
                                                   annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                                           rotation=0,
                origin={210,0})));

          Modelica.Blocks.Logical.Switch switch_OnOff_I if  with_I
            annotation (Placement(transformation(extent={{-49,-76},{-38,-87}})));
      public
          Modelica.Blocks.Sources.Constant I_off_zero(k=0) if
                                                          with_I
            annotation (Placement(transformation(extent={{4.25,-4.5},{-4.25,4.5}},
                                                                             rotation=180,
                origin={-64.75,-67})));

          Modelica.Blocks.Logical.Switch switch_OnOff
            annotation (Placement(transformation(extent={{94,18},{114,-2}})));
          Modelica.Blocks.Sources.RealExpression y_unlocked(y=if perUnitConversion
                 then y_inactive/y_ref else y_inactive)
            annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=180,
                origin={112,30})));
          ClaRa.Components.Utilities.Blocks.FirstOrderClaRa smoothPIDInput(Tau=Tau_in,
            initOption=if Tau_in > 0 then 1 else 4)
            annotation (Placement(transformation(extent={{-132,-10},{-112,10}})));
          ClaRa.Components.Utilities.Blocks.FirstOrderClaRa smoothPIDOutput(Tau=Tau_out,
            initOption=if Tau_out > 0 then 1 else 4)
            annotation (Placement(transformation(extent={{230,-10},{250,10}})));
          Modelica.Blocks.Math.Feedback addSat
            annotation (Placement(transformation(extent={{-10,-10},{10,10}},  rotation=180,
                origin={145,-125.5})));
          ClaRa.Components.Utilities.Blocks.FirstOrderClaRa smoothPIDOutput1(Tau=
                Tau_add,
            initOption=if Tau_add > 0 then 1 else 4)
            annotation (Placement(transformation(extent={{122,-2.5},{142,18}})));

          Modelica.Blocks.Sources.RealExpression y_start_I(y = if initOption == 798 or initOption == 797 or initOption == 796 then y_start/y_ref else if perUnitConversion then y_start/y_ref - addPID.u1 - addPID.u2 else y_start - addPID.u1 - addPID.u2)
            annotation (Placement(transformation(extent={{10,-64},{-8,-52}})));
          // The following alternative will truely allow to initialise the PID block at y_start if InitialOutput is chosen:
          // Modelica.Blocks.Sources.RealExpression y_start_I(y=if initType == InitPID.InitialOutput then y_start/y_ref - addPID.u1 - addPID.u2 elseif initType == InitPID.SteadyState then y_start/y_ref else xi_start)
          //   annotation (Placement(transformation(extent={{10,-64},{-8,-52}})));
          Modelica.Blocks.Math.Feedback resetP annotation (Placement(transformation(
                extent={{-10,10},{10,-10}},
                rotation=90,
                origin={-78,50.5})));
          Modelica.Blocks.Sources.RealExpression y_unlocked1(y=resetValueP)
            annotation (Placement(transformation(extent={{10,10},{-10,-10}},
                                                                           rotation=180,
                origin={-113,51})));
          Modelica.Blocks.Math.Add resetPD annotation (Placement(transformation(
                extent={{-5,-5},{5,5}},
                rotation=0,
                origin={69,-3})));
          Modelica.Blocks.Sources.RealExpression y_unlocked2(y=resetValueID) annotation (Placement(transformation(extent={{10,10},{-10,-10}},
                                                                           rotation=270,
                origin={56,-30})));
        Modelica.Blocks.Sources.BooleanExpression activate_(y=time >= t_activation) annotation (Placement(transformation(extent={{-194,180},{-174,200}})));
        Modelica.Blocks.Logical.Timer time_lag_I_activation annotation (Placement(transformation(extent={{-10,-10},{10,10}}, rotation=0, origin={18,142})));
        Modelica.Blocks.Logical.And controllerActive if use_activateInput annotation (Placement(transformation(extent={{-134,170},{-114,150}})));
        Modelica.Blocks.Routing.BooleanPassThrough booleanPassThrough if not use_activateInput annotation (Placement(transformation(extent={{-60,180},{-40,200}})));
        Modelica.Blocks.Logical.GreaterThreshold I_activation(threshold=Tau_lag_I) annotation (Placement(transformation(extent={{-10,-10},{10,10}}, rotation=270, origin={-152,-66})));
        initial equation
          resetValueI =   if with_D then if perUnitConversion then y_start/y_ref - addPID.u1 else y_start-addPID.u1 else 0;
        equation

          assert(y_max >= y_min, "LimPID: Limits must be consistent. However, y_max (=" + String(y_max) +
                               ") < y_min (=" + String(y_min) + ")");

         if initOption==503 and limitsAtInit and (y_start < y_min or y_start > y_max) then
             Modelica.Utilities.Streams.error("LimPID: Start value y_start (=" + String(y_start) + ") is beyond allowed limits of y_min (=" + String(y_min) +") and y_max (=" + String(y_max) + ") in instance " + getInstanceName());
         end if;

          when change(switch_OnOff.u2) then
            reinit(resetValueP, pre(toPU.y));
            reinit(resetValueID, y_unlocked.y - addPID.u2 - addPID.u3);

          end when;
          der(resetValueP)=0;
          der(resetValueID)=0;
          der(resetValueI)=0;

          connect(P.y, addPID.u1) annotation (Line(points={{3,70},{32,70},{32,4},{41,4}},
                       color={0,0,127}));
          connect(D_approx.y, addPID.u2)
            annotation (Line(points={{-5,0},{41,0}},  color={0,0,127}));
          connect(toPU.y, D_approx.u)
                               annotation (Line(points={{-85,0},{-28,0}},   color={0,0,127}));
          connect(gainTrack.y, addI.u2) annotation (Line(points={{-10.65,-125.5},{-10.65,-126},{-80,-126},{-80,-108},{-66,-108}},
                                   color={0,0,127}));
          connect(u_s, feedback.u1) annotation (Line(points={{-220.5,0},{-188.5,0}},
                                                                                color={0,
                  0,127}));
          connect(u_m, feedback.u2) annotation (Line(points={{0,-216},{0,-160},{-180.5,-160},{-180.5,-8}},
                             color={0,0,127}));

          connect(switch_OnOff_I.y, I.u) annotation (Line(
              points={{-37.45,-81.5},{-37.45,-82},{-32,-82}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(I_off_zero.y, switch_OnOff_I.u3) annotation (Line(
              points={{-60.075,-67},{-55,-67},{-55,-77.1},{-50.1,-77.1}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(toPU.y, addI.u1) annotation (Line(
              points={{-85,0},{-80,0},{-80,-102},{-66,-102}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(addI.y, switch_OnOff_I.u1) annotation (Line(
              points={{-54.5,-105},{-54.5,-85.9},{-50.1,-85.9}},
              color={0,0,127},
              smooth=Smooth.None));

          connect(limiter.y, fromPU.u) annotation (Line(
              points={{175,8},{178,8},{178,0},{198,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(switch_OnOff.u3, y_unlocked.y) annotation (Line(
              points={{92,16},{92,30},{101,30}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(smoothPIDInput.y, toPU.u) annotation (Line(
              points={{-111,0},{-108,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(fromPU.y, smoothPIDOutput.u) annotation (Line(
              points={{221,0},{228,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(smoothPIDOutput.y, y) annotation (Line(
              points={{251,0},{270,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(addSat.y, gainTrack.u) annotation (Line(
              points={{136,-125.5},{4.3,-125.5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(addPID.u2, Dzero.y) annotation (Line(
              points={{41,0},{0,0},{0,-22},{-5.65,-22}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Izero.y, addPID.u3) annotation (Line(
              points={{-11,-103.75},{12,-103.75},{12,-104},{34,-104},{34,-82},{34,-82},{34,-4},{41,-4}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(switch_OnOff.y, smoothPIDOutput1.u) annotation (Line(
              points={{115,8},{116.85,8},{116.85,7.75},{120,7.75}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(smoothPIDOutput1.y, limiter.u) annotation (Line(
              points={{143,7.75},{152,7.75},{152,8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(y_unlocked1.y,resetP. u2) annotation (Line(points={{-102,51},{-86,51},{-86,50.5}},color={0,0,127}));
          connect(resetP.y, P.u) annotation (Line(points={{-78,59.5},{-78,70},{-20,70}},       color={0,0,127}));
          connect(toPU.y, resetP.u1) annotation (Line(points={{-85,0},{-78,0},{-78,42.5}},           color={0,0,127}));
          connect(limiter.y, addSat.u1) annotation (Line(points={{175,8},{178,8},{178,-125.5},{153,-125.5}},
                                                                                                    color={0,0,127}));
          connect(y_unlocked2.y, resetPD.u2) annotation (Line(points={{56,-19},{56,-6},{63,-6}},color={0,0,127}));
          connect(y_start_I.y, I.y_start) annotation (Line(points={{-8.9,-58},{-20,-58},{-20,-70}}, color={0,0,127}));
          connect(smoothPIDOutput1.y, addSat.u2) annotation (Line(points={{143,7.75},{145,7.75},{145,-117.5}},   color={0,0,127}));
          connect(feedback.y, smoothPIDInput.u) annotation (Line(points={{-171.5,0},{-172,0},{-134,0}}, color={0,0,127}));
          connect(I.y, addPID.u3) annotation (Line(points={{-9,-82},{34,-82},{34,-4},{41,-4}},          color={0,0,127}));
          connect(addPID.y, resetPD.u1) annotation (Line(points={{52.5,0},{63,0}},           color={0,0,127}));
          connect(resetPD.y, switch_OnOff.u1) annotation (Line(points={{74.5,-3},{74.25,-3},{74.25,0},{92,0}},   color={0,0,127}));
        connect(activateInput, controllerActive.u1) annotation (Line(points={{-219.5,160},{-136,160}}, color={255,0,255}, smooth=Smooth.None));
        connect(activate_.y, controllerActive.u2) annotation (Line(points={{-173,190},{-156,190},{-156,168},{-136,168}}, color={255,0,255}, smooth=Smooth.None));
        connect(controllerActive.y, time_lag_I_activation.u) annotation (Line(points={{-113,160},{-54,160},{-54,142},{6,142}}, color={255,0,255}, smooth=Smooth.None));
        connect(controllerActive.y, switch_OnOff.u2) annotation (Line(points={{-113,160},{86,160},{86,8},{92,8}}, color={255,0,255}));
        connect(time_lag_I_activation.y, I_activation.u) annotation (Line(points={{29,142},{34,142},{34,124},{-152,124},{-152,-54}}, color={0,0,127}));
        connect(activate_.y, booleanPassThrough.u) annotation (Line(points={{-173,190},{-62,190}}, color={255,0,255}));
        connect(booleanPassThrough.y, switch_OnOff.u2) annotation (Line(points={{-39,190},{86,190},{86,8},{92,8}}, color={255,0,255}));
        connect(booleanPassThrough.y, time_lag_I_activation.u) annotation (Line(points={{-39,190},{-22,190},{-22,142},{6,142}}, color={255,0,255}));
        connect(I_activation.y, switch_OnOff_I.u2) annotation (Line(points={{-152,-77},{-152,-81.5},{-50.1,-81.5}}, color={255,0,255}));
          annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",       revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),        defaultComponentName="PID",
            Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Text(
                  extent={{-100,130},{100,100}},
                  lineColor={27,36,42},
                  textString="%name"),  Rectangle(
                  extent={{-100,-100},{100,100}},
                  lineColor={221,222,223},
                  fillColor={118,124,127},
                  fillPattern=FillPattern.Solid),
                Line(
                  points={{-80,-90},{-80,80}},
                  color={221,222,223},
                  smooth=Smooth.Bezier),
                Polygon(
                  points={{-80,90},{-88,68},{-72,68},{-80,90}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(
                  points={{-80,-80},{-80,40},{-80,6},{-60,-20},{30,60},{30,60},{80,60}},
                  color={27,36,42},
                  smooth=Smooth.Bezier),
                Text(
                  extent={{-20,-20},{80,-60}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid,
                  textString="PID"),
                Line(points={{-90,-80},{80,-80}}, color={221,222,223}),
                Polygon(
                  points={{90,-80},{68,-72},{68,-88},{90,-80}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{30,60},{80,60}}, color={167,25,48}, visible = limitsAtInit)}),
            Diagram(graphics,
                    coordinateSystem(
                preserveAspectRatio=false,
                extent={{-200,-200},{260,200}},
                initialScale=0.1)));
        end LimPID;

        block Integrator "Output the integral of the input signal - variable Integrator time constant"
        //__________________________________________________________________________//
        // Component of the ClaRa library, version: 1.6.0                           //
        //                                                                          //
        // Licensed by the ClaRa development team under Modelica License 2.         //
        // Copyright  2013-2021, ClaRa development team.                            //
        //                                                                          //
        // The ClaRa development team consists of the following partners:           //
        // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
        // XRG Simulation GmbH (Hamburg, Germany).                                  //
        //__________________________________________________________________________//
        // Contents published in ClaRa have been contributed by different authors   //
        // and institutions. Please see model documentation for detailed information//
        // on original authorship and copyrights.                                   //
        //__________________________________________________________________________//
          import Modelica.Blocks.Types.Init;
          import SI = ClaRa.Basics.Units;
          extends Modelica.Blocks.Interfaces.SISO(y(start=y_start_const));

          parameter Boolean variable_Tau_i=false "True, if integrator time is set by variable input";
          parameter Basics.Units.Time Tau_i_const=1 "Constant integrator time" annotation (Dialog(enable=not variable_Tau_i));

          parameter Integer initOption = 501 "Initialisation option" annotation(Dialog(choicesAllMatching, group="Initialisation"), choices(choice = 501 "No init (y_start and x_start as guess values)",
                                                                                                            choice=502 "Steady state",
                                                                                                            choice=504 "Force y_start at output"));

          parameter Boolean y_startInputIsActive=false "True, if integrator initial output shall be set by variable input"
                                                                                                    annotation (Dialog(group="Initialization"));

          parameter Real y_start_const=0 "Initial or guess value of output (= state)"  annotation (Dialog(group="Initialization",enable= not y_startInputIsActive));
          parameter Basics.Units.Time startTime=0 "Start time for integration";

      protected
          Basics.Units.Time Tau_i_in;
          Real y_start_in;
      public
          Modelica.Blocks.Interfaces.RealInput Tau_i=Tau_i_in if (variable_Tau_i) annotation (Placement(
                transformation(
                extent={{-20,-20},{20,20}},
                rotation=-90,
                origin={-50,120})));

          Modelica.Blocks.Interfaces.RealInput y_start=y_start_in if
                                                                   (y_startInputIsActive) annotation (Placement(transformation(
                extent={{-20,-20},{20,20}},
                rotation=-90,
                origin={0,120})));
        initial equation
           if initOption == 502 then
              der(y) = 0;
           elseif initOption == 504 or initOption ==799 then // 799 refers to former buggy initial state initialisation which is still supported but not visible in the drop down any more
             y = y_start_in;
           elseif initOption ==501 then
             //Do nothing, use y_start_const as guess value
           else
            assert(false, "Unknown init option in integrator instance " + getInstanceName());
           end if;



        equation
          if not variable_Tau_i then
            Tau_i_in=Tau_i_const;
          end if;
          if not y_startInputIsActive then
            y_start_in=y_start_const;
          end if;

          der(y) =  if time >= startTime then u/Tau_i_in else 0;
          annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",       revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),  Documentation(info="<html></html>"), Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(
                  extent={{-100,100},{100,-100}},
                  lineColor={221,222,223},
                  fillColor={118,124,127},
                  fillPattern=FillPattern.Solid),
                Line(points={{-80,78},{-80,-90}}, color={221,222,223}),
                Polygon(
                  points={{-80,90},{-88,68},{-72,68},{-80,90}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,-80},{82,-80}}, color={221,222,223}),
                Polygon(
                  points={{90,-80},{68,-72},{68,-88},{90,-80}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{0,-10},{60,-70}},
                  lineColor={221,222,223},
                  textString="I"),
                Text(
                  extent={{-150,-150},{150,-110}},
                  lineColor={27,36,42},
                  textString="Ti=%Ti_in"),
                Line(points={{-80,-80},{80,80}}, color={27,36,42})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=false,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
                Line(points={{-100,0},{-60,0}}, color={0,0,255}),
                Line(points={{60,0},{100,0}}, color={0,0,255}),
                Text(
                  extent={{-36,60},{32,2}},
                  lineColor={0,0,0},
                  textString="k"),
                Text(
                  extent={{-32,0},{36,-58}},
                  lineColor={0,0,0},
                  textString="s"),
                Line(points={{-46,0},{46,0}}, color={0,0,0})}));
        end Integrator;

        block DerivativeClaRa "Derivative block ( can be adjusted to behave as ideal or approximated)"
        //__________________________________________________________________________//
        // Component of the ClaRa library, version: 1.6.0                           //
        //                                                                          //
        // Licensed by the ClaRa development team under Modelica License 2.         //
        // Copyright  2013-2021, ClaRa development team.                            //
        //                                                                          //
        // The ClaRa development team consists of the following partners:           //
        // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
        // XRG Simulation GmbH (Hamburg, Germany).                                  //
        //__________________________________________________________________________//
        // Contents published in ClaRa have been contributed by different authors   //
        // and institutions. Please see model documentation for detailed information//
        // on original authorship and copyrights.                                   //
        //__________________________________________________________________________//
          import Modelica.Blocks.Types.Init;
          parameter Real k(unit="1")=1 "Gain";
          parameter ClaRa.Basics.Units.Time Tau(min=Modelica.Constants.small)=0.01 "Time constant (Tau>0 for approxomated derivative; Tau=0 is ideal derivative block)";
          parameter Integer initOption = 501 "Initialisation option" annotation(choicesAllMatching,Dialog( group="Initialisation"), choices(choice = 501 "No init (y_start and x_start as guess values)",
                                                                                                            choice=502 "Steady state",
                                                                                                            choice=504 "Force y_start at output"));

          parameter Real x_start=0 "Initial or guess value of state"
            annotation (Dialog(tab="Obsolete Settings", group="Initialization"));
          parameter Real y_start=0 "Initial value of output (= state)"
            annotation(Dialog(enable=initOption == 504, group=
                  "Initialization"));
          extends Modelica.Blocks.Interfaces.SISO(y(start=y_start));

          output Real x(start=x_start) "State of block";

      protected
          parameter Boolean zeroGain = abs(k) < Modelica.Constants.eps;
        initial equation
          if initOption == 502 then
            der(x) = 0;
          elseif initOption == 799 then //initialisation with initial state
            x = x_start;
          elseif initOption == 504 then
            if zeroGain then
               x = u;
            else
               y = y_start;
            end if;
          elseif initOption == 501 then
              //Do nothing, use x_start and y_start as guess values
          else
            assert(false, "Unknown init option in derivative instance " + getInstanceName());
          end if;

        equation
          der(x) = if zeroGain or Tau < Modelica.Constants.eps then 0 else (u - x)/Tau;
          if zeroGain then
            y=0;
          elseif Tau < Modelica.Constants.eps then
            y=k*der(u);
          else
            y =(k/Tau)*(u - x);
          end if;
          annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",       revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),  Documentation(info="
<HTML>

</HTML>
"),         Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(
                  extent={{-100,100},{100,-100}},
                  lineColor={221,222,223},
                  fillColor={118,124,127},
                  fillPattern=FillPattern.Solid),
                Line(points={{-80,78},{-80,-90}}, color={221,222,223}),
                Polygon(
                  points={{-80,90},{-88,68},{-72,68},{-80,90}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,-80},{82,-80}}, color={221,222,223}),
                Polygon(
                  points={{90,-80},{68,-72},{68,-88},{90,-80}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{-80,-80},{-80,60},{-70,17.95},{-60,-11.46},{-50,-32.05},
                      {-40,-46.45},{-30,-56.53},{-20,-63.58},{-10,-68.51},{0,-71.96},
                      {10,-74.37},{20,-76.06},{30,-77.25},{40,-78.07},{50,-78.65},{60,
                      -79.06}}, color={27,36,42}),
                Text(
                  extent={{-30,14},{86,60}},
                  lineColor={221,222,223},
                  textString="DT1"),
                Text(
                  extent={{-150,-150},{150,-110}},
                  lineColor={0,0,0},
                  textString="k=%k")}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Text(
                  extent={{-54,52},{50,10}},
                  lineColor={0,0,0},
                  textString="k s"),
                Text(
                  extent={{-54,-6},{52,-52}},
                  lineColor={0,0,0},
                  textString="T s + 1"),
                Line(points={{-50,0},{50,0}}, color={0,0,0}),
                Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
                Line(points={{-100,0},{-60,0}}, color={0,0,255}),
                Line(points={{60,0},{100,0}}, color={0,0,255})}));
        end DerivativeClaRa;

        block FirstOrderClaRa "First order transfer function block (= 1 pole, allows Tau = 0)"
        //__________________________________________________________________________//
        // Component of the ClaRa library, version: 1.6.0                           //
        //                                                                          //
        // Licensed by the ClaRa development team under Modelica License 2.         //
        // Copyright  2013-2021, ClaRa development team.                            //
        //                                                                          //
        // The ClaRa development team consists of the following partners:           //
        // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
        // XRG Simulation GmbH (Hamburg, Germany).                                  //
        //__________________________________________________________________________//
        // Contents published in ClaRa have been contributed by different authors   //
        // and institutions. Please see model documentation for detailed information//
        // on original authorship and copyrights.                                   //
        //__________________________________________________________________________//
          extends Modelica.Blocks.Interfaces.SISO;

          parameter Modelica.Units.SI.Time Tau=0 "Time Constant, set Tau=0 for no signal smoothing";
          parameter Integer initOption = 1 "Initialisation option" annotation(choices(choice=1 "y = u", choice=2 "y = y_start", choice=3 "der(y) = 0",
                                                                                                    choice=4 "no init"));
          parameter Real y_start=1 "Start value at output" annotation(Dialog(enable = Tau>0 and initOption==2));
      protected
          Real y_aux;
        initial equation
          if initOption == 1 then // y= u
            y_aux = u;
          elseif initOption == 2 then // y = y_start
            y_aux=y_start;
          elseif initOption == 3 and Tau>0 then // der(y) = 0
            der(y_aux)=0;
          elseif initOption == 4 then // no init
            y_aux=0;
          else
            assert(false, "Unknown init option in component " + getInstanceName());
           end if;
        equation
          if Tau < Modelica.Constants.eps then
            y=u;
            der(y_aux)=0;
          else
            der(y_aux) = (u - y_aux)/Tau;
            y=y_aux;
          end if;
          annotation (Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",       revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"),  Documentation(info="<HTML>


</HTML>
"),         Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(
                  extent={{-100,100},{100,-100}},
                  lineColor={221,222,223},
                  fillColor={118,124,127},
                  fillPattern=FillPattern.Solid),
                Line(points={{-80,78},{-80,-90}}, color={221,222,223}),
                Polygon(
                  points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,-80},{82,-80}}, color={221,222,223}),
                Polygon(
                  points={{90,-80},{68,-72},{68,-88},{90,-80}},
                  lineColor={221,222,223},
                  fillColor={221,222,223},
                  fillPattern=FillPattern.Solid),
                Line(points={{-80,-80},{-70,-45.11},{-60,-19.58},{-50,-0.9087},{-40,
                      12.75},{-30,22.75},{-20,30.06},{-10,35.41},{0,39.33},{10,42.19},
                      {20,44.29},{30,45.82},{40,46.94},{50,47.76},{60,48.36},{70,48.8},
                      {80,49.12}}, color={27,36,42}),
                Text(
                  extent={{0,0},{60,-60}},
                  lineColor={221,222,223},
                  textString="PT1"),
                Text(
                  extent={{-150,-150},{150,-110}},
                  lineColor={0,0,0},
                  textString="T=%T")}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Text(
                  extent={{-48,52},{50,8}},
                  lineColor={0,0,0},
                  textString="k"),
                Text(
                  extent={{-54,-6},{56,-56}},
                  lineColor={0,0,0},
                  textString="T s + 1"),
                Line(points={{-50,0},{50,0}}, color={0,0,0}),
                Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
                Line(points={{-100,0},{-60,0}}, color={0,0,255}),
                Line(points={{60,0},{100,0}}, color={0,0,255})}));
        end FirstOrderClaRa;
      end Blocks;
    end Utilities;
  annotation (Documentation(info="<html>
</html>"));
  end Components;

  model SimCenter
  //__________________________________________________________________________//
  // Component of the ClaRa library, version: 1.6.0                           //
  //                                                                          //
  // Licensed by the ClaRa development team under Modelica License 2.         //
  // Copyright  2013-2021, ClaRa development team.                            //
  //                                                                          //
  // The ClaRa development team consists of the following partners:           //
  // TLK-Thermo GmbH (Braunschweig, Germany),                                 //
  // XRG Simulation GmbH (Hamburg, Germany).                                  //
  //__________________________________________________________________________//
  // Contents published in ClaRa have been contributed by different authors   //
  // and institutions. Please see model documentation for detailed information//
  // on original authorship and copyrights.                                   //
  //__________________________________________________________________________//

  //extends ClaRa.Basics.Functions.ClaRaDelay.DelayInit;

    replaceable parameter TILMedia.VLEFluidTypes.TILMedia_SplineWater fluid1 constrainedby
    TILMedia.VLEFluidTypes.BaseVLEFluid(   final ID=1) "Medium name of working fluid in steam cycle"
                                                                  annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: VLE Components"),choicesAllMatching);
    replaceable parameter TILMedia.VLEFluidTypes.TILMedia_SplineWater fluid2 constrainedby
    TILMedia.VLEFluidTypes.BaseVLEFluid(   final ID=2) "Medium name of working fluid in steam cycle"
                                                                  annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: VLE Components"),choicesAllMatching);
    replaceable parameter TILMedia.VLEFluidTypes.TILMedia_SplineWater fluid3 constrainedby
    TILMedia.VLEFluidTypes.BaseVLEFluid(   final ID=3) "Medium name of working fluid in steam cycle"
                                                                  annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: VLE Components"),choicesAllMatching);
    replaceable parameter TILMedia.GasTypes.MoistAirMixture airModel constrainedby
    TILMedia.GasTypes.BaseGas                                                                                "Medium name of air model"
                                annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: Gas Components"),choicesAllMatching);
    replaceable parameter TILMedia.GasTypes.FlueGasTILMedia flueGasModel constrainedby
    TILMedia.GasTypes.BaseGas                                                                                    "Medium name of flue gas model"
                                      annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: Gas Components"),choicesAllMatching);

    replaceable parameter ClaRa.Basics.Media.FuelTypes.Fuel_refvalues_v1 fuelModel1 constrainedby
    ClaRa.Basics.Media.FuelTypes.EmptyFuel                                                                                        "Fuel 1" annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: Fuel, Coal and Slag"),choicesAllMatching);
    replaceable parameter ClaRa.Basics.Media.FuelTypes.Fuel_refvalues_v1 fuelModel2   constrainedby
    ClaRa.Basics.Media.FuelTypes.EmptyFuel                                                                                          "Fuel 2" annotation(Dialog(tab="Media and Materials", group="ClaRa-based Models: Fuel, Coal and Slag"),choicesAllMatching);

    replaceable parameter ClaRa.Basics.Media.Slag.Slag_v1 slagModel constrainedby
    ClaRa.Basics.Media.Slag.PartialSlag                                                                               "Medium name of slag model" annotation (Dialog(tab="Media and Materials", group="ClaRa-based Models: Fuel, Coal and Slag"), choicesAllMatching);

  ///////////////////////
    input ClaRa.Basics.Units.AbsolutePressure p_amb=1.013e5 "Ambient pressure" annotation (Dialog(tab="Ambience", group="Variable Input"));
    input ClaRa.Basics.Units.Temperature T_amb=293.15 "Ambient temperature" annotation (Dialog(tab="Ambience", group="Variable Input"));
    input ClaRa.Basics.Units.RelativeHumidity rh_amb=0.2 "Ambient relative humidity (0 < rh < 1)" annotation (Dialog(tab="Ambience", group="Variable Input"));
    parameter ClaRa.Basics.Units.AbsolutePressure p_amb_start(fixed=false) "Initial ambient pressure (automatically calculated)" annotation (Dialog(
        tab="Ambience",
        group="Start Values",
        enable=false));
    parameter ClaRa.Basics.Units.Temperature T_amb_start(fixed=false) "Initial ambient temperature (automatically calculated)" annotation (Dialog(
        tab="Ambience",
        group="Start Values",
        enable=false));

  ///////////////////////
      parameter Boolean showExpertSummary=false "|Summary and Visualisation||True, if expert summary should be applied";
    parameter Boolean largeFonts= false "|Summary and Visualisation||True if visualisers shall be displayed as large as posible";
    parameter Boolean contributeToCycleSummary = false "True if components shall contribute to automatic efficiency calculation"
                                                                                                    annotation(Dialog(tab="Summary and Visualisation"));

  //////////////////////
    parameter Boolean steamCycleAllowFlowReversal = true "Allow flow reversal in steam cycle" annotation(Dialog(tab="Numerics", group="ClaRa-basedModels: VLE Components"));

     parameter Boolean useClaRaDelay=true "True for using ClaRa delay implementation / false for built in Modelica delay"
       annotation(Dialog(tab="Numerics",group="Delay Function"));
     parameter Real MaxSimTime=1e4 "Maximum time for simulation, must be set for Modelica delay blocks with variable delay time"
               annotation(Dialog(enable=useClaRaDelay==false,tab="Numerics", group="Delay Function"));
    parameter Boolean useHomotopy=true "True, if homotopy method is used during initialisation"
                                                               annotation(Dialog(tab="Numerics", group="Misc"),Evaluate=true);
      ClaRa.Basics.Interfaces.CycleSumPort cycleSumPort "Reference to the volume and mass of the VLE fluid in components"
        annotation(HideResult=false);

  /////////////////////
    ClaRa.Basics.Units.EnthalpyMassSpecific h_amb_fluid1 "Ambient enthalpy of VLE fluid 1";
    ClaRa.Basics.Units.EntropyMassSpecific s_amb_fluid1 "Ambient entropy of VLE fluid 1";

    ClaRa.Basics.Units.EnthalpyMassSpecific h_amb_fluid2 "Ambient enthalpy of VLE fluid 2";
    ClaRa.Basics.Units.EntropyMassSpecific s_amb_fluid2 "Ambient entropy of VLE fluid 2";

    ClaRa.Basics.Units.EnthalpyMassSpecific h_amb_fluid3 "Ambient enthalpy of VLE fluid 3";
    ClaRa.Basics.Units.EntropyMassSpecific s_amb_fluid3 "Ambient entropy of VLE fluid 3";

protected
    TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluid vleFluid_amb1(vleFluidType=fluid1) annotation (Placement(transformation(extent={{-90,-12},{-70,8}})));
    TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluid vleFluid_amb2(vleFluidType=fluid2) annotation (Placement(transformation(extent={{-60,-12},{-40,8}})));
    TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluid vleFluid_amb3(vleFluidType=fluid3) annotation (Placement(transformation(extent={{-30,-12},{-10,8}})));

public
  record summary_clara
    extends ClaRa.Basics.Icons.RecordIcon;
    Real eta_gross  "Gross electrical efficiency";
    Real eta_net    "Net electrical efficiency";
    Real eta_util   "Utilization efficiency";
    Real spec_heat_cons "Specific heat consumption";
  end summary_clara;
    summary_clara summary(eta_gross=(cycleSumPort.power_out_elMech)/(cycleSumPort.power_in + 1e-6),
                          eta_net=(cycleSumPort.power_out_elMech - cycleSumPort.power_aux) /(cycleSumPort.power_in + 1e-6),
                          eta_util=(cycleSumPort.power_out_elMech + cycleSumPort.power_out_th - cycleSumPort.power_aux)/(1e-6 + cycleSumPort.power_in),
                          spec_heat_cons = if summary.eta_gross > 0 then 1/summary.eta_gross*3600 else 0);

  initial equation
   p_amb_start=p_amb;
   T_amb_start=T_amb;
  equation
   h_amb_fluid1 =  vleFluid_amb1.h_pTxi(p_amb,T_amb,fluid1.xi_default);
   s_amb_fluid1 =  vleFluid_amb1.s_pTxi(p_amb,T_amb,fluid1.xi_default);
   h_amb_fluid2 =  vleFluid_amb2.h_pTxi(p_amb,T_amb,fluid2.xi_default);
   s_amb_fluid2 =  vleFluid_amb2.s_pTxi(p_amb,T_amb,fluid2.xi_default);
   h_amb_fluid3 =  vleFluid_amb3.h_pTxi(p_amb,T_amb,fluid3.xi_default);
   s_amb_fluid3 =  vleFluid_amb3.s_pTxi(p_amb,T_amb,fluid3.xi_default);

  annotation (   defaultComponentName="simCenter",
      defaultComponentPrefixes="inner",
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-200,-100},{200,
              100}}),
           graphics={Bitmap(
            extent={{-200,-100},{200,100}},
            imageSource="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",
            fileName="modelica://ClaRa/Resources/Images/Components/SimCenter.png"), Text(
            visible=contributeToCycleSummary,
            extent={{200,80},{800,20}},
            lineColor={0,131,169},
            textStyle={TextStyle.Bold},
            horizontalAlignment=TextAlignment.Left,
            textString=DynamicSelect("eta_gross", "eta_gross = " + String(summary.eta_gross*100, format="1.2f") + " %%")),Text(
            visible=contributeToCycleSummary,
            extent={{200,-20},{800,-80}},
            lineColor={0,131,169},
            textStyle={TextStyle.Bold},
            horizontalAlignment=TextAlignment.Left,
            textString=DynamicSelect("eta_net", "eta_net = " + String(summary.eta_net*100, format="1.2f") + " %%"))}),
       Documentation(info="<html>
<p><b>For detailed model documentation please consult the html-documentation shipped with ClaRa.</b> </p>
<p>&nbsp;</p>
<p><br><b><span style=\"font-size: 10pt;\">Authorship and Copyright Statement for original (initial) Contribution</span></b></p>
<p><b>Author:</b> </p>
DYNCAP/DYNSTART development team, Copyright &copy; 2011-2020.</p>
<p><b>References:</b> </p>
<p> For references please consult the html-documentation shipped with ClaRa. </p>
<p><b>Remarks:</b> </p>
<p>This component was developed by ClaRa development team under Modelica License 2.</p>
<b>Acknowledgements:</b>
<p>ClaRa originated from the collaborative research projects DYNCAP and DYNSTART. Both research projects were supported by the German Federal Ministry for Economic Affairs and Energy (FKZ 03ET2009 and FKZ 03ET7060).</p>
<p><b>CLA:</b> </p>
<p>The author(s) have agreed to ClaRa CLA, version 1.0. See <a href=\"https://claralib.com/CLA/\">https://claralib.com/CLA/</a></p>
<p>By agreeing to ClaRa CLA, version 1.0 the author has granted the ClaRa development team a permanent right to use and modify his initial contribution as well as to publish it or its modified versions under Modelica License 2.</p>
<p>The ClaRa development team consists of the following partners:</p>
<p>TLK-Thermo GmbH (Braunschweig, Germany)</p>
<p>XRG Simulation GmbH (Hamburg, Germany).</p>
</html>",
    revisions="<html>
<body>
<p>For revisions please consult the html-documentation shipped with ClaRa.</p>
</body>
</html>"));
  end SimCenter;
  annotation (preferedView="info",version="1.6.0",
                           uses(
    Modelica(version="4.0.0"),
    TILMedia(version="1.6.0 ClaRa")),  Icon(graphics,
                                      coordinateSystem(preserveAspectRatio=
          false, extent={{-100,-100},{100,100}})),
  conversion(from(version="0.0",to="0.1 alpha",  script="modelica://ClaRa/Resources/Scripts/ConvertFrom000.mos"),
    from(version="0.1 alpha",to="0.2 alpha", script="modelica://ClaRa/Resources/Scripts/ConvertFrom010.mos"),
    from(version="0.2 alpha",to="0.2.1 alpha", script="modelica://ClaRa/Resources/Scripts/ConvertFrom020.mos"),
    from(version="0.2.1 alpha",to="0.2.2 alpha", script="modelica://ClaRa/Resources/Scripts/ConvertFrom021.mos"),
    from(version="0.2.2 alpha",to="1.0.1", script="modelica://ClaRa/Resources/Scripts/ConvertFrom022.mos"),
    from(version="1.0.1",to="1.1.2", script="modelica://ClaRa/Resources/Scripts/ConvertFrom101.mos"),
    from(version="1.1.2",to="1.2.1", script="modelica://ClaRa/Resources/Scripts/ConvertFrom112_to_121.mos"),
    from(version="1.2.1",to="1.3.0", script="modelica://ClaRa/Resources/Scripts/ConvertFrom12x_to_130.mos"),
    from(version="1.2.2",to="1.3.0", script="modelica://ClaRa/Resources/Scripts/ConvertFrom12x_to_130.mos"),
    from(version="1.2.3",to="1.3.0", script="modelica://ClaRa/Resources/Scripts/ConvertFrom12x_to_130.mos"),
    from(version="1.3.1",to="1.4.0", script="modelica://ClaRa/Resources/Scripts/ConvertFrom131_to_140.mos"),
    from(version="1.4.0",to="1.4.1", script="modelica://ClaRa/Resources/Scripts/ConvertFrom140_to_141.mos"),
    from(version="1.4.1",to="1.5.0", script="modelica://ClaRa/Resources/Scripts/ConvertFrom141_to_150.mos"),
    from(version="1.4.1",to="1.5.1", script="modelica://ClaRa/Resources/Scripts/ConvertFrom141_to_150.mos")),
  Documentation(info="<html>
<p><img src=\"modelica://ClaRa/Resources/Images/ClaRaLibraryInfo.png\"/></p>
<p><h4> Coordinating developers:</h4></p>
<ul>
<li>ClaRa development team (TLK Thermo GmbH, XRG Simulation GmbH)</li>
<li>Lasse Nielsen, Ales Vojacek, Johannes Brunnemann</li>
</ul>
<p><h4>Further developers:</h4></p>
<ul>
<li>Gottelt, Friedrich </li>
<li>Hoppe, Timm </li>
<li>Renz, Ala </li>
<li>Scheffler, Jan </li>
<li>Gulba, Jan </li>
<li>Von der Heyde, Michael </li>
<li>Von Ohlen, Carsten </li>
</ul>
</html>"));
end ClaRa;

package ModelicaServices
  "ModelicaServices (Dymola implementation) - Models and functions used in the Modelica Standard Library requiring a tool specific implementation"
extends Modelica.Icons.Package;

package ExternalReferences

  function loadResource
    "Return the absolute path name of a URI or local file name (in this default implementation URIs are not supported, but only local file names)"
    input String uri;
    output String fileReference;
  external "C" fileReference = loadResourceInternal(uri) annotation (Include="static char* loadResourceInternal(char*) { return \"\"; }");
  end loadResource;
end ExternalReferences;

package Machine

  final constant Real eps=1.e-15 "Biggest number such that 1.0 + eps = 1.0";

  final constant Real small=1.e-60
    "Smallest number such that small and -small are representable on the machine";

  final constant Real inf=1.e+60
    "Biggest Real number such that inf and -inf are representable on the machine";
  annotation (Documentation(info="<html>
<p>
Package in which processor specific constants are defined that are needed
by numerical algorithms. Typically these constants are not directly used,
but indirectly via the alias definition in
<a href=\"modelica://Modelica.Constants\">Modelica.Constants</a>.
</p>
</html>"));
end Machine;
annotation (
  Protection(access=Access.hide),
  preferredView="info",
  version="4.0.0",
  Dymola2(checkSum="3933384872:3320196239"),
  versionBuild=0,
  versionDate="2020-01-15",
  dateModified = "2020-01-15 08:44:41Z",
  uses(Modelica(version="4.0.0")),
  conversion(
    noneFromVersion="1.0",
    noneFromVersion="1.1",
    noneFromVersion="1.2",
    noneFromVersion="3.2.1",
 noneFromVersion="3.2.3"),
  Documentation(info="<html>
<p>
This package contains a set of functions and models to be used in the
Modelica Standard Library that requires a tool specific implementation.
These are:
</p>

<ul>
<li> <a href=\"modelica://ModelicaServices.Animation.Shape\">Animation.Shape</a>
     provides a 3-dim. visualization of elementary
     mechanical objects. It is used in
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Animation.Surface\">Animation.Surface</a>
     provides a 3-dim. visualization of
     moveable parameterized surface. It is used in
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Animation.Vector\">Animation.Vector</a>
     provides a 3-dim. visualization of a vector objects. It is used in
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Vector\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Vector</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.ExternalReferences.loadResource\">ExternalReferences.loadResource</a>
     provides a function to return the absolute path name of an URI or a local file name. It is used in
<a href=\"modelica://Modelica.Utilities.Files.loadResource\">Modelica.Utilities.Files.loadResource</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Machine\">Machine</a>
     provides a package of machine constants. It is used in
<a href=\"modelica://Modelica.Constants\">Modelica.Constants</a>.</li>

<li> <a href=\"modelica://ModelicaServices.System.exit\">System.exit</a> provides a function to terminate the execution of the Modelica environment. It is used in <a href=\"modelica://Modelica.Utilities.System.exit\">Modelica.Utilities.System.exit</a> via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Types.SolverMethod\">Types.SolverMethod</a>
     provides a string defining the integration method to solve differential equations in
     a clocked discretized continuous-time partition (see Modelica 3.3 language specification).
     It is not yet used in the Modelica Standard Library, but in the Modelica_Synchronous library
     that provides convenience blocks for the clock operators of Modelica version &ge; 3.3.</li>
</ul>

<p>
This is the Dymola implementation.
</p>

<p>
Original version
<strong>Licensed by the Modelica Association under the 3-Clause BSD License</strong><br>
Copyright &copy; 2009-2020, Modelica Association and contributors.
</p>
<p>
<strong>Modifications licensed by Dassault Syst&egrave;mes, copyright &copy; 2009-2020.</strong>
</p>

</html>"));
end ModelicaServices;

package TILMedia
  "TILMedia-Library with thermophysical properties of Fluids and Solids"
  import Modelica.Units.SI;

  package BaseClasses
    extends .TILMedia.Internals.ClassTypes.ModelPackage;

    partial model PartialVLEFluid "Compressible fluid model for object and member function based evaluation"
      replaceable parameter .TILMedia.VLEFluidTypes.TILMedia_Water vleFluidType constrainedby .TILMedia.VLEFluidTypes.BaseVLEFluid
        "type record of the VLE fluid or VLE fluid mixture"
        annotation (choicesAllMatching=true);

      parameter .TILMedia.Internals.TILMediaExternalObject vleFluidPointer annotation (Dialog(tab="Advanced"));

      parameter Boolean computeTransportProperties=false
        "=true, if transport properties are calculated";
      parameter Boolean interpolateTransportProperties=true
        "Interpolate transport properties in vapor dome"
        annotation (Dialog(tab="Advanced"));
      parameter Boolean computeSurfaceTension=true
        annotation (Dialog(tab="Advanced"));
      parameter Boolean deactivateDensityDerivatives=false
        "Deactivate calculation of partial derivatives of density"
        annotation (Evaluate=true, Dialog(tab="Advanced"));
      parameter Boolean deactivateTwoPhaseRegion=false
        "Deactivate calculation of two phase region" annotation (Evaluate=true);

      replaceable partial function h_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function p_dTxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.pressure_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.pressure_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function q_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cv_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function w_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodh_pxi_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodp_hxi_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function gamma_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function Pr_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function lambda_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function eta_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function sigma_dTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_dTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_dTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);

      replaceable partial function d_phxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function T_phxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.temperature_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.temperature_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function q_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cv_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function w_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodh_pxi_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodp_hxi_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function gamma_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function Pr_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function lambda_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function eta_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function sigma_phxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_phxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_phxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);

      replaceable partial function d_psxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function T_psxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.temperature_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.temperature_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function q_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cv_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function w_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodh_pxi_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodp_hxi_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function gamma_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function Pr_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function lambda_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function eta_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function sigma_psxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_psxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_psxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);

      replaceable partial function d_pTxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.density_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEnthalpy_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificEntropy_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function q_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.steamMassFraction_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsobaricHeatCapacity_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cv_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.specificIsochoricHeatCapacity_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.isothermalCompressibility_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function w_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.speedOfSound_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodh_pxi_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function drhodp_hxi_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.densityDerivativeWRTpressure_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function gamma_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.heatCapacityRatio_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function Pr_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.prandtlNumber_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function lambda_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.thermalConductivity_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function eta_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dynamicViscosity_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function sigma_pTxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_pTxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.surfaceTension_pTxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);


      replaceable partial function d_dew_Txi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewDensity_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewDensity_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function d_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleDensity_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleDensity_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_dew_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEnthalpy_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEnthalpy_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEnthalpy_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEnthalpy_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function p_dew_Txi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewPressure_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewPressure_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function p_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubblePressure_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubblePressure_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_dew_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEntropy_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEntropy_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEntropy_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEntropy_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_dew_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_dew_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_dew_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsothermalCompressibility_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsothermalCompressibility_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_bubble_Txi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsothermalCompressibility_Txi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsothermalCompressibility_Txi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);

      replaceable partial function d_dew_pxi =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewDensity_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewDensity_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function d_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleDensity_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleDensity_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEnthalpy_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEnthalpy_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function h_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEnthalpy_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEnthalpy_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEntropy_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificEntropy_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function s_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEntropy_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificEntropy_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function T_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewTemperature_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewTemperature_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function T_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleTemperature_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleTemperature_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function cp_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function beta_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_dew_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsothermalCompressibility_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.dewIsothermalCompressibility_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function kappa_bubble_pxi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsothermalCompressibility_pxi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.bubbleIsothermalCompressibility_pxi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);



      replaceable partial function dc_xi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalDensity_xi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalDensity_xi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function hc_xi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalSpecificEnthalpy_xi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalSpecificEnthalpy_xi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function pc_xi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalPressure_xi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalPressure_xi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function sc_xi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalSpecificEntropy_xi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalSpecificEntropy_xi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);
      replaceable partial function Tc_xi =

        .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalTemperature_xi
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.criticalTemperature_xi(
            xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer);

      replaceable partial function M_i_n =
          .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.molarMass_n
        constrainedby
      .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions.molarMass_n(
            vleFluidPointer=vleFluidPointer);

      annotation (
        defaultComponentName="vleFluid",
        Icon(graphics={Bitmap(
              extent={{-100,-100},{100,100}},
              imageSource="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",
              fileName="modelica://TILMedia/Images/Icon_VLEFluid.png"), Text(
              extent={{-120,-60},{120,-100}},
              lineColor={153,204,0},
              textString="%name")}),
        Documentation(info="<html>
                   <p>
                   The VLE-fluid model VLEFluid_ph calculates the thermopyhsical property data with given inputs: pressure (p), enthalpy (h), mass fraction (xi) and the parameter vleFluidType.<br>
                   The interface and the way of using, is demonstrated in the Testers -> <a href=\"modelica://TILMedia.Testers.TestVLEFluid\">TestVLEFluid</a>.
                   </p>
                   <hr>
                   </html>"));

    end PartialVLEFluid;

    partial model PartialVLEFluid_pT
      "Compressible fluid model with p, T and xi as independent variables"
      replaceable parameter .TILMedia.VLEFluidTypes.TILMedia_Water vleFluidType
        constrainedby .TILMedia.VLEFluidTypes.BaseVLEFluid
        "type record of the VLE fluid or VLE fluid mixture"
        annotation (choicesAllMatching=true);

      parameter .TILMedia.Internals.TILMediaExternalObject vleFluidPointer annotation (Dialog(tab="Advanced"));

      parameter Boolean stateSelectPreferForInputs=false
        "=true, StateSelect.prefer is set for input variables"
        annotation (Evaluate=true, Dialog(tab="Advanced", group "StateSelect"));
      parameter Boolean computeTransportProperties=false
        "=true, if transport properties are calculated";
      parameter Boolean interpolateTransportProperties=true
        "Interpolate transport properties in vapor dome"
        annotation (Dialog(tab="Advanced"));
      parameter Boolean computeSurfaceTension=true
        annotation (Dialog(tab="Advanced"));
      parameter Boolean deactivateDensityDerivatives=false
        "Deactivate calculation of partial derivatives of density"
        annotation (Evaluate=true, Dialog(tab="Advanced"));
      parameter Boolean computeVLEAdditionalProperties=false
        "Compute detailed vapor liquid equilibrium properties"
        annotation (Evaluate=true);
      parameter Boolean computeVLETransportProperties=false
        "Compute detailed vapor liquid equilibrium transport properties"
        annotation (Evaluate=true);
      parameter Boolean deactivateTwoPhaseRegion=false
        "Deactivate calculation of two phase region"
        annotation (Evaluate=true);

      //Base Properties
      SI.Density d "Density";
      SI.SpecificEnthalpy h "Specific enthalpy";
      input SI.AbsolutePressure p(stateSelect=if (
            stateSelectPreferForInputs) then StateSelect.prefer else StateSelect.default)
        "Pressure" annotation(Dialog);
      SI.SpecificEntropy s "Specific entropy";
      input SI.Temperature T(stateSelect=if (
            stateSelectPreferForInputs) then StateSelect.prefer else StateSelect.default)
        "Temperature" annotation(Dialog);
      input SI.MassFraction[vleFluidType.nc - 1] xi(each stateSelect=if (
            stateSelectPreferForInputs) then StateSelect.prefer else StateSelect.default)=vleFluidType.xi_default
        "Mass Fraction of Component i" annotation(Dialog);
      SI.MoleFraction x[vleFluidType.nc - 1] "Mole fraction";
      SI.MolarMass M "Average molar mass";

      //Additional Properties
      SI.MassFraction q "Steam mass fraction (quality)";
      SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      SI.Compressibility kappa "Isothermal compressibility";
      SI.Velocity w "Speed of sound";
      SI.DerDensityByEnthalpy drhodh_pxi
        "1st derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      SI.DerDensityByPressure drhodp_hxi
        "1st derivative of density wrt pressure at specific enthalpy and mass fraction";
      .TILMedia.Internals.Units.DensityDerMassFraction drhodxi_ph[vleFluidType.nc - 1]
        "1st derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      Real gamma "Heat capacity ratio aka isentropic expansion factor";

      parameter SI.MolarMass M_i[vleFluidType.nc] "Molar mass of component i";

      .TILMedia.Internals.CriticalDataRecord crit "Critical data record" annotation (
         Placement(transformation(extent={{-80,60},{-60,80}}, rotation=0)));
      .TILMedia.Internals.TransportPropertyRecord transp(eta(min=-1))
        "Transport property record" annotation (Placement(transformation(extent={{-80,
                -100},{-60,-80}}, rotation=0)));
      .TILMedia.Internals.VLERecord VLE(final nc=vleFluidType.nc) annotation (
          Placement(transformation(extent={{-80,20},{-60,40}}, rotation=0)));
      .TILMedia.Internals.AdditionalVLERecord VLEAdditional annotation (Placement(
            transformation(extent={{-80,-20},{-60,0}}, rotation=0)));
      .TILMedia.Internals.VLETransportPropertyRecord VLETransp(eta_l(min=-1), eta_v(min=-1)) annotation (Placement(
            transformation(extent={{-80,-60},{-60,-40}}, rotation=0)));

      function getProperties = .TILMedia.Internals.getPropertiesVLE (
          d=d,
          h=h,
          p=p,
          s=s,
          T=T,
          cp=cp,
          q=q,
          d_l=VLE.d_l,
          h_l=VLE.h_l,
          p_l=VLE.p_l,
          s_l=VLE.s_l,
          T_l=VLE.T_l,
          d_v=VLE.d_v,
          h_v=VLE.h_v,
          p_v=VLE.p_v,
          s_v=VLE.s_v,
          T_v=VLE.T_v,
          d_crit=crit.d,
          h_crit=crit.h,
          p_crit=crit.p,
          s_crit=crit.s,
          T_crit=crit.T,
          Pr=transp.Pr,
          lambda=transp.lambda,
          eta=transp.eta,
          sigma=transp.sigma,
          Pr_l=VLETransp.Pr_l,
          Pr_v=VLETransp.Pr_v,
          lambda_l=VLETransp.lambda_l,
          lambda_v=VLETransp.lambda_v,
          eta_l=VLETransp.eta_l,
          eta_v=VLETransp.eta_v);

      annotation (
        defaultComponentName="vleFluid",
        Icon(graphics={            Bitmap(
              extent={{-100,-100},{100,100}},
              imageSource=
                  "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",
              fileName="modelica://TILMedia/Images/Icon_VLEFluid_pT.png"),
                       Text(
              extent={{-120,-60},{120,-100}},
              lineColor={153,204,0},
              textString="%name")}),
        Documentation(info="<html>
                   <p>
                   The VLE-fluid model VLEFluid_pT calculates the thermopyhsical property data with given inputs: pressure (p), temperature (T), mass fraction (xi) and the parameter vleFluidType.<br>
                   The interface and the way of using, is demonstrated in the Testers -> <a href=\"modelica://TILMedia.Testers.TestVLEFluid\">TestVLEFluid</a>.
                   </p>
                   <hr>
                   </html>"));

    end PartialVLEFluid_pT;

    package PartialVLEFluidFunctions
      "Package for calculation of VLEFluid properties with a functional call"
      extends .TILMedia.Internals.ClassTypes.ModelPackage;

      replaceable function specificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_dTxi;

      replaceable function pressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p "Pressure";
      end pressure_dTxi;

      replaceable function specificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_dTxi;

      replaceable function moleFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_dTxin;

      replaceable function steamMassFraction_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_dTxi;

      replaceable function specificIsobaricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_dTxi;

      replaceable function specificIsochoricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_dTxi;

      replaceable function isobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_dTxi;

      replaceable function isothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_dTxi;

      replaceable function speedOfSound_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Velocity w "Speed of sound";
      end speedOfSound_dTxi;

      replaceable function densityDerivativeWRTspecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_dTxi;

      replaceable function densityDerivativeWRTpressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_dTxi;

      replaceable function densityDerivativeWRTmassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_dTxin;

      replaceable function heatCapacityRatio_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_dTxi;

      replaceable function prandtlNumber_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_dTxi;

      replaceable function thermalConductivity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_dTxi;

      replaceable function dynamicViscosity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_dTxi;

      replaceable function surfaceTension_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_dTxi;

      replaceable function liquidDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_dTxi;

      replaceable function vapourDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_dTxi;

      replaceable function liquidSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_dTxi;

      replaceable function vapourSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_dTxi;

      replaceable function liquidPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_l "Pressure of liquid phase";
      end liquidPressure_dTxi;

      replaceable function vapourPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_v "Pressure of vapour phase";
      end vapourPressure_dTxi;

      replaceable function liquidSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_dTxi;

      replaceable function vapourSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_dTxi;

      replaceable function liquidMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_dTxin;

      replaceable function vapourMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_dTxin;

      replaceable function liquidSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_dTxi;

      replaceable function vapourSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_dTxi;

      replaceable function liquidIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_dTxi;

      replaceable function vapourIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_dTxi;

      replaceable function liquidIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_dTxi;

      replaceable function vapourIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_dTxi;

      replaceable function density_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d "Density";
      end density_phxi;

      replaceable function specificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_phxi;

      replaceable function temperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T "Temperature";
      end temperature_phxi;

      replaceable function moleFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_phxin;

      replaceable function steamMassFraction_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_phxi;

      replaceable function specificIsobaricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_phxi;

      replaceable function specificIsochoricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_phxi;

      replaceable function isobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_phxi;

      replaceable function isothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_phxi;

      replaceable function speedOfSound_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Velocity w "Speed of sound";
      end speedOfSound_phxi;

      replaceable function densityDerivativeWRTspecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_phxi;

      replaceable function densityDerivativeWRTpressure_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_phxi;

      replaceable function densityDerivativeWRTmassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_phxin;

      replaceable function heatCapacityRatio_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_phxi;

      replaceable function prandtlNumber_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_phxi;

      replaceable function thermalConductivity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_phxi;

      replaceable function dynamicViscosity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_phxi;

      replaceable function surfaceTension_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_phxi;

      replaceable function liquidDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_phxi;

      replaceable function vapourDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_phxi;

      replaceable function liquidSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_phxi;

      replaceable function vapourSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_phxi;

      replaceable function liquidSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_phxi;

      replaceable function vapourSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_phxi;

      replaceable function liquidTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_phxi;

      replaceable function vapourTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_phxi;

      replaceable function liquidMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_phxin;

      replaceable function vapourMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_phxin;

      replaceable function liquidSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_phxi;

      replaceable function vapourSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_phxi;

      replaceable function liquidIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_phxi;

      replaceable function vapourIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_phxi;

      replaceable function liquidIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_phxi;

      replaceable function vapourIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_phxi;

      replaceable function density_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d "Density";
      end density_psxi;

      replaceable function specificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_psxi;

      replaceable function temperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T "Temperature";
      end temperature_psxi;

      replaceable function moleFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_psxin;

      replaceable function steamMassFraction_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_psxi;

      replaceable function specificIsobaricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_psxi;

      replaceable function specificIsochoricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_psxi;

      replaceable function isobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_psxi;

      replaceable function isothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_psxi;

      replaceable function speedOfSound_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Velocity w "Speed of sound";
      end speedOfSound_psxi;

      replaceable function densityDerivativeWRTspecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_psxi;

      replaceable function densityDerivativeWRTpressure_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_psxi;

      replaceable function densityDerivativeWRTmassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_psxin;

      replaceable function heatCapacityRatio_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_psxi;

      replaceable function prandtlNumber_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_psxi;

      replaceable function thermalConductivity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_psxi;

      replaceable function dynamicViscosity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_psxi;

      replaceable function surfaceTension_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_psxi;

      replaceable function liquidDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_psxi;

      replaceable function vapourDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_psxi;

      replaceable function liquidSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_psxi;

      replaceable function vapourSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_psxi;

      replaceable function liquidSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_psxi;

      replaceable function vapourSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_psxi;

      replaceable function liquidTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_psxi;

      replaceable function vapourTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_psxi;

      replaceable function liquidMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_psxin;

      replaceable function vapourMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_psxin;

      replaceable function liquidSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_psxi;

      replaceable function vapourSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_psxi;

      replaceable function liquidIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_psxi;

      replaceable function vapourIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_psxi;

      replaceable function liquidIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_psxi;

      replaceable function vapourIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_psxi;

      replaceable function density_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d "Density";
      end density_pTxi;

      replaceable function specificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_pTxi;

      replaceable function specificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_pTxi;

      replaceable function moleFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_pTxin;

      replaceable function steamMassFraction_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_pTxi;

      replaceable function specificIsobaricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_pTxi;

      replaceable function specificIsochoricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_pTxi;

      replaceable function isobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_pTxi;

      replaceable function isothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_pTxi;

      replaceable function speedOfSound_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Velocity w "Speed of sound";
      end speedOfSound_pTxi;

      replaceable function densityDerivativeWRTspecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_pTxi;

      replaceable function densityDerivativeWRTpressure_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_pTxi;

      replaceable function densityDerivativeWRTmassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_pTxin;

      replaceable function heatCapacityRatio_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_pTxi;

      replaceable function prandtlNumber_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_pTxi;

      replaceable function thermalConductivity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_pTxi;

      replaceable function dynamicViscosity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_pTxi;

      replaceable function surfaceTension_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_pTxi;

      replaceable function liquidDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_pTxi;

      replaceable function vapourDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_pTxi;

      replaceable function liquidSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_pTxi;

      replaceable function vapourSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_pTxi;

      replaceable function liquidSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_pTxi;

      replaceable function vapourSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_pTxi;

      replaceable function liquidTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_pTxi;

      replaceable function vapourTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_pTxi;

      replaceable function liquidMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_pTxin;

      replaceable function vapourMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_pTxin;

      replaceable function liquidSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_pTxi;

      replaceable function vapourSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_pTxi;

      replaceable function liquidIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_pTxi;

      replaceable function vapourIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_pTxi;

      replaceable function liquidIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_pTxi;

      replaceable function vapourIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_pTxi;


      replaceable function dewDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_dew "Density at dew point";
      end dewDensity_Txi;

      replaceable function bubbleDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_bubble "Density at bubble point";
      end bubbleDensity_Txi;

      replaceable function dewSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      end dewSpecificEnthalpy_Txi;

      replaceable function bubbleSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      end bubbleSpecificEnthalpy_Txi;

      replaceable function dewPressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_dew "Pressure at dew point";
      end dewPressure_Txi;

      replaceable function bubblePressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_bubble "Pressure at bubble point";
      end bubblePressure_Txi;

      replaceable function dewSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      end dewSpecificEntropy_Txi;

      replaceable function bubbleSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      end bubbleSpecificEntropy_Txi;

      replaceable function dewLiquidMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      end dewLiquidMassFraction_Txin;

      replaceable function bubbleVapourMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      end bubbleVapourMassFraction_Txin;

      replaceable function dewSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      end dewSpecificIsobaricHeatCapacity_Txi;

      replaceable function bubbleSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      end bubbleSpecificIsobaricHeatCapacity_Txi;

      replaceable function dewIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      end dewIsobaricThermalExpansionCoefficient_Txi;

      replaceable function bubbleIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      end bubbleIsobaricThermalExpansionCoefficient_Txi;

      replaceable function dewIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      end dewIsothermalCompressibility_Txi;

      replaceable function bubbleIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      end bubbleIsothermalCompressibility_Txi;

      replaceable function dewDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_dew "Density at dew point";
      end dewDensity_pxi;

      replaceable function bubbleDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density d_bubble "Density at bubble point";
      end bubbleDensity_pxi;

      replaceable function dewSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      end dewSpecificEnthalpy_pxi;

      replaceable function bubbleSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      end bubbleSpecificEnthalpy_pxi;

      replaceable function dewSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      end dewSpecificEntropy_pxi;

      replaceable function bubbleSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      end bubbleSpecificEntropy_pxi;

      replaceable function dewTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_dew "Temperature at dew point";
      end dewTemperature_pxi;

      replaceable function bubbleTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_bubble "Temperature at bubble point";
      end bubbleTemperature_pxi;

      replaceable function dewLiquidMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      end dewLiquidMassFraction_pxin;

      replaceable function bubbleVapourMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      end bubbleVapourMassFraction_pxin;

      replaceable function dewSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      end dewSpecificIsobaricHeatCapacity_pxi;

      replaceable function bubbleSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      end bubbleSpecificIsobaricHeatCapacity_pxi;

      replaceable function dewIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      end dewIsobaricThermalExpansionCoefficient_pxi;

      replaceable function bubbleIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      end bubbleIsobaricThermalExpansionCoefficient_pxi;

      replaceable function dewIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      end dewIsothermalCompressibility_pxi;

      replaceable function bubbleIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      end bubbleIsothermalCompressibility_pxi;



      replaceable function averageMolarMass_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.MolarMass M "Average molar mass";
      end averageMolarMass_xi;

      replaceable function criticalDensity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Density dc "Critical density";
      end criticalDensity_xi;

      replaceable function criticalSpecificEnthalpy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEnthalpy hc "Critical specific enthalpy";
      end criticalSpecificEnthalpy_xi;

      replaceable function criticalPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure pc "Critical pressure";
      end criticalPressure_xi;

      replaceable function criticalSpecificEntropy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificEntropy sc "Critical specific entropy";
      end criticalSpecificEntropy_xi;

      replaceable function criticalTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature Tc "Critical temperature";
      end criticalTemperature_xi;

      replaceable function criticalSpecificIsobaricHeatCapacity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SpecificHeatCapacity cpc "Critical specific isobaric heat capacity cp";
      end criticalSpecificIsobaricHeatCapacity_xi;

      replaceable function criticalIsobaricThermalExpansionCoefficient_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.LinearExpansionCoefficient betac "Critical isobaric thermal expansion coefficient";
      end criticalIsobaricThermalExpansionCoefficient_xi;

      replaceable function criticalIsothermalCompressibility_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Compressibility kappac "Critical isothermal compressibility";
      end criticalIsothermalCompressibility_xi;

      replaceable function criticalThermalConductivity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.ThermalConductivity lambdac "Critical thermal conductivity";
      end criticalThermalConductivity_xi;

      replaceable function criticalDynamicViscosity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.DynamicViscosity etac "Critical dynamic viscosity";
      end criticalDynamicViscosity_xi;

      replaceable function criticalSurfaceTension_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.SurfaceTension sigmac "Critical surface tension";
      end criticalSurfaceTension_xi;

      replaceable function cricondenbarTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_ccb "";
      end cricondenbarTemperature_xi;

      replaceable function cricondenthermTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.Temperature T_cct "";
      end cricondenthermTemperature_xi;

      replaceable function cricondenbarPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_ccb "";
      end cricondenbarPressure_xi;

      replaceable function cricondenthermPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input SI.MassFraction[:] xi=
            .TILMedia.Internals.massFraction_mixingRatio(vleFluidType.mixingRatio_propertyCalculation)
          "Mass fractions of the first nc-1 components";
        output SI.AbsolutePressure p_cct "";
      end cricondenthermPressure_xi;

      replaceable function molarMass_n
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        // Don't use these functions during simulation, Medium classes are always faster! Use only for start and initial values.
        input .TILMedia.VLEFluidTypes.BaseVLEFluid vleFluidType "VLEFluid type"
          annotation(choicesAllMatching=true);
        input Integer compNo "Component ID";
        output SI.MolarMass M_i "Molar mass of component i";
      end molarMass_n;

    end PartialVLEFluidFunctions;

    package PartialVLEFluidObjectFunctions
      "Package for calculation of VLEFluid properties with a functional call"
      extends .TILMedia.Internals.ClassTypes.ModelPackage;

      replaceable partial function specificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_dTxi;

      replaceable partial function pressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p "Pressure";
      end pressure_dTxi;

      replaceable partial function specificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_dTxi;

      replaceable partial function moleFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_dTxin;

      replaceable partial function steamMassFraction_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_dTxi;

      replaceable partial function specificIsobaricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_dTxi;

      replaceable partial function specificIsochoricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_dTxi;

      replaceable partial function isobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_dTxi;

      replaceable partial function isothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_dTxi;

      replaceable partial function speedOfSound_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Velocity w "Speed of sound";
      end speedOfSound_dTxi;

      replaceable partial function densityDerivativeWRTspecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_dTxi;

      replaceable partial function densityDerivativeWRTpressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_dTxi;

      replaceable partial function densityDerivativeWRTmassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_dTxin;

      replaceable partial function heatCapacityRatio_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_dTxi;

      replaceable partial function prandtlNumber_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_dTxi;

      replaceable partial function thermalConductivity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_dTxi;

      replaceable partial function dynamicViscosity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_dTxi;

      replaceable partial function surfaceTension_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_dTxi;

      replaceable partial function liquidDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_dTxi;

      replaceable partial function vapourDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_dTxi;

      replaceable partial function liquidSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_dTxi;

      replaceable partial function vapourSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_dTxi;

      replaceable partial function liquidPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_l "Pressure of liquid phase";
      end liquidPressure_dTxi;

      replaceable partial function vapourPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_v "Pressure of vapour phase";
      end vapourPressure_dTxi;

      replaceable partial function liquidSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_dTxi;

      replaceable partial function vapourSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_dTxi;

      replaceable partial function liquidMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_dTxin;

      replaceable partial function vapourMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_dTxin;

      replaceable partial function liquidSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_dTxi;

      replaceable partial function vapourSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_dTxi;

      replaceable partial function
      liquidIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_dTxi;

      replaceable partial function
      vapourIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_dTxi;

      replaceable partial function liquidIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_dTxi;

      replaceable partial function vapourIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_dTxi;

      replaceable partial function density_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d "Density";
      end density_phxi;

      replaceable partial function specificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_phxi;

      replaceable partial function temperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T "Temperature";
      end temperature_phxi;

      replaceable partial function moleFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_phxin;

      replaceable partial function steamMassFraction_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_phxi;

      replaceable partial function specificIsobaricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_phxi;

      replaceable partial function specificIsochoricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_phxi;

      replaceable partial function isobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_phxi;

      replaceable partial function isothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_phxi;

      replaceable partial function speedOfSound_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Velocity w "Speed of sound";
      end speedOfSound_phxi;

      replaceable partial function densityDerivativeWRTspecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_phxi;

      replaceable partial function densityDerivativeWRTpressure_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_phxi;

      replaceable partial function densityDerivativeWRTmassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_phxin;

      replaceable partial function heatCapacityRatio_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_phxi;

      replaceable partial function prandtlNumber_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_phxi;

      replaceable partial function thermalConductivity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_phxi;

      replaceable partial function dynamicViscosity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_phxi;

      replaceable partial function surfaceTension_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_phxi;

      replaceable partial function liquidDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_phxi;

      replaceable partial function vapourDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_phxi;

      replaceable partial function liquidSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_phxi;

      replaceable partial function vapourSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_phxi;

      replaceable partial function liquidSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_phxi;

      replaceable partial function vapourSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_phxi;

      replaceable partial function liquidTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_phxi;

      replaceable partial function vapourTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_phxi;

      replaceable partial function liquidMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_phxin;

      replaceable partial function vapourMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_phxin;

      replaceable partial function liquidSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_phxi;

      replaceable partial function vapourSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_phxi;

      replaceable partial function
      liquidIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_phxi;

      replaceable partial function
      vapourIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_phxi;

      replaceable partial function liquidIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_phxi;

      replaceable partial function vapourIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_phxi;

      replaceable partial function density_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d "Density";
      end density_psxi;

      replaceable partial function specificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_psxi;

      replaceable partial function temperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T "Temperature";
      end temperature_psxi;

      replaceable partial function moleFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_psxin;

      replaceable partial function steamMassFraction_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_psxi;

      replaceable partial function specificIsobaricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_psxi;

      replaceable partial function specificIsochoricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_psxi;

      replaceable partial function isobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_psxi;

      replaceable partial function isothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_psxi;

      replaceable partial function speedOfSound_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Velocity w "Speed of sound";
      end speedOfSound_psxi;

      replaceable partial function densityDerivativeWRTspecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_psxi;

      replaceable partial function densityDerivativeWRTpressure_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_psxi;

      replaceable partial function densityDerivativeWRTmassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_psxin;

      replaceable partial function heatCapacityRatio_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_psxi;

      replaceable partial function prandtlNumber_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_psxi;

      replaceable partial function thermalConductivity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_psxi;

      replaceable partial function dynamicViscosity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_psxi;

      replaceable partial function surfaceTension_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_psxi;

      replaceable partial function liquidDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_psxi;

      replaceable partial function vapourDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_psxi;

      replaceable partial function liquidSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_psxi;

      replaceable partial function vapourSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_psxi;

      replaceable partial function liquidSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_psxi;

      replaceable partial function vapourSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_psxi;

      replaceable partial function liquidTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_psxi;

      replaceable partial function vapourTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_psxi;

      replaceable partial function liquidMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_psxin;

      replaceable partial function vapourMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_psxin;

      replaceable partial function liquidSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_psxi;

      replaceable partial function vapourSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_psxi;

      replaceable partial function
      liquidIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_psxi;

      replaceable partial function
      vapourIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_psxi;

      replaceable partial function liquidIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_psxi;

      replaceable partial function vapourIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_psxi;

      replaceable partial function density_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d "Density";
      end density_pTxi;

      replaceable partial function specificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h "Specific enthalpy";
      end specificEnthalpy_pTxi;

      replaceable partial function specificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s "Specific entropy";
      end specificEntropy_pTxi;

      replaceable partial function moleFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MoleFraction x "Mole fraction";
      end moleFraction_pTxin;

      replaceable partial function steamMassFraction_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      end steamMassFraction_pTxi;

      replaceable partial function specificIsobaricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      end specificIsobaricHeatCapacity_pTxi;

      replaceable partial function specificIsochoricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      end specificIsochoricHeatCapacity_pTxi;

      replaceable partial function isobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      end isobaricThermalExpansionCoefficient_pTxi;

      replaceable partial function isothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa "Isothermal compressibility";
      end isothermalCompressibility_pTxi;

      replaceable partial function speedOfSound_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Velocity w "Speed of sound";
      end speedOfSound_pTxi;

      replaceable partial function densityDerivativeWRTspecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      end densityDerivativeWRTspecificEnthalpy_pTxi;

      replaceable partial function densityDerivativeWRTpressure_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      end densityDerivativeWRTpressure_pTxi;

      replaceable partial function densityDerivativeWRTmassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      end densityDerivativeWRTmassFraction_pTxin;

      replaceable partial function heatCapacityRatio_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      end heatCapacityRatio_pTxi;

      replaceable partial function prandtlNumber_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.PrandtlNumber Pr "Prandtl number";
      end prandtlNumber_pTxi;

      replaceable partial function thermalConductivity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.ThermalConductivity lambda "Thermal conductivity";
      end thermalConductivity_pTxi;

      replaceable partial function dynamicViscosity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DynamicViscosity eta "Dynamic viscosity";
      end dynamicViscosity_pTxi;

      replaceable partial function surfaceTension_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SurfaceTension sigma "Surface tension";
      end surfaceTension_pTxi;

      replaceable partial function liquidDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_l "Density of liquid phase";
      end liquidDensity_pTxi;

      replaceable partial function vapourDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_v "Density of vapour phase";
      end vapourDensity_pTxi;

      replaceable partial function liquidSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      end liquidSpecificEnthalpy_pTxi;

      replaceable partial function vapourSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      end vapourSpecificEnthalpy_pTxi;

      replaceable partial function liquidSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      end liquidSpecificEntropy_pTxi;

      replaceable partial function vapourSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      end vapourSpecificEntropy_pTxi;

      replaceable partial function liquidTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_l "Temperature of liquid phase";
      end liquidTemperature_pTxi;

      replaceable partial function vapourTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_v "Temperature of vapour phase";
      end vapourTemperature_pTxi;

      replaceable partial function liquidMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      end liquidMassFraction_pTxin;

      replaceable partial function vapourMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      end vapourMassFraction_pTxin;

      replaceable partial function liquidSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      end liquidSpecificHeatCapacity_pTxi;

      replaceable partial function vapourSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      end vapourSpecificHeatCapacity_pTxi;

      replaceable partial function
      liquidIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      end liquidIsobaricThermalExpansionCoefficient_pTxi;

      replaceable partial function
      vapourIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      end vapourIsobaricThermalExpansionCoefficient_pTxi;

      replaceable partial function liquidIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      end liquidIsothermalCompressibility_pTxi;

      replaceable partial function vapourIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      end vapourIsothermalCompressibility_pTxi;


      replaceable partial function dewDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_dew "Density at dew point";
      end dewDensity_Txi;

      replaceable partial function bubbleDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_bubble "Density at bubble point";
      end bubbleDensity_Txi;

      replaceable partial function dewSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      end dewSpecificEnthalpy_Txi;

      replaceable partial function bubbleSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      end bubbleSpecificEnthalpy_Txi;

      replaceable partial function dewPressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_dew "Pressure at dew point";
      end dewPressure_Txi;

      replaceable partial function bubblePressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_bubble "Pressure at bubble point";
      end bubblePressure_Txi;

      replaceable partial function dewSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      end dewSpecificEntropy_Txi;

      replaceable partial function bubbleSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      end bubbleSpecificEntropy_Txi;

      replaceable partial function dewLiquidMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      end dewLiquidMassFraction_Txin;

      replaceable partial function bubbleVapourMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      end bubbleVapourMassFraction_Txin;

      replaceable partial function dewSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      end dewSpecificIsobaricHeatCapacity_Txi;

      replaceable partial function bubbleSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      end bubbleSpecificIsobaricHeatCapacity_Txi;

      replaceable partial function dewIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      end dewIsobaricThermalExpansionCoefficient_Txi;

      replaceable partial function
      bubbleIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      end bubbleIsobaricThermalExpansionCoefficient_Txi;

      replaceable partial function dewIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      end dewIsothermalCompressibility_Txi;

      replaceable partial function bubbleIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      end bubbleIsothermalCompressibility_Txi;

      replaceable partial function dewDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_dew "Density at dew point";
      end dewDensity_pxi;

      replaceable partial function bubbleDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density d_bubble "Density at bubble point";
      end bubbleDensity_pxi;

      replaceable partial function dewSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      end dewSpecificEnthalpy_pxi;

      replaceable partial function bubbleSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      end bubbleSpecificEnthalpy_pxi;

      replaceable partial function dewSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      end dewSpecificEntropy_pxi;

      replaceable partial function bubbleSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      end bubbleSpecificEntropy_pxi;

      replaceable partial function dewTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_dew "Temperature at dew point";
      end dewTemperature_pxi;

      replaceable partial function bubbleTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_bubble "Temperature at bubble point";
      end bubbleTemperature_pxi;

      replaceable partial function dewLiquidMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      end dewLiquidMassFraction_pxin;

      replaceable partial function bubbleVapourMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      end bubbleVapourMassFraction_pxin;

      replaceable partial function dewSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      end dewSpecificIsobaricHeatCapacity_pxi;

      replaceable partial function bubbleSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      end bubbleSpecificIsobaricHeatCapacity_pxi;

      replaceable partial function dewIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      end dewIsobaricThermalExpansionCoefficient_pxi;

      replaceable partial function
      bubbleIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      end bubbleIsobaricThermalExpansionCoefficient_pxi;

      replaceable partial function dewIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      end dewIsothermalCompressibility_pxi;

      replaceable partial function bubbleIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      end bubbleIsothermalCompressibility_pxi;



      replaceable partial function averageMolarMass_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MolarMass M "Average molar mass";
      end averageMolarMass_xi;

      replaceable partial function criticalDensity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Density dc "Critical density";
      end criticalDensity_xi;

      replaceable partial function criticalSpecificEnthalpy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEnthalpy hc "Critical specific enthalpy";
      end criticalSpecificEnthalpy_xi;

      replaceable partial function criticalPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure pc "Critical pressure";
      end criticalPressure_xi;

      replaceable partial function criticalSpecificEntropy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificEntropy sc "Critical specific entropy";
      end criticalSpecificEntropy_xi;

      replaceable partial function criticalTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature Tc "Critical temperature";
      end criticalTemperature_xi;

      replaceable partial function criticalSpecificIsobaricHeatCapacity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SpecificHeatCapacity cpc "Critical specific isobaric heat capacity cp";
      end criticalSpecificIsobaricHeatCapacity_xi;

      replaceable partial function
      criticalIsobaricThermalExpansionCoefficient_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.LinearExpansionCoefficient betac "Critical isobaric thermal expansion coefficient";
      end criticalIsobaricThermalExpansionCoefficient_xi;

      replaceable partial function criticalIsothermalCompressibility_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Compressibility kappac "Critical isothermal compressibility";
      end criticalIsothermalCompressibility_xi;

      replaceable partial function criticalThermalConductivity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.ThermalConductivity lambdac "Critical thermal conductivity";
      end criticalThermalConductivity_xi;

      replaceable partial function criticalDynamicViscosity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.DynamicViscosity etac "Critical dynamic viscosity";
      end criticalDynamicViscosity_xi;

      replaceable partial function criticalSurfaceTension_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.SurfaceTension sigmac "Critical surface tension";
      end criticalSurfaceTension_xi;

      replaceable partial function cricondenbarTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_ccb "";
      end cricondenbarTemperature_xi;

      replaceable partial function cricondenthermTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.Temperature T_cct "";
      end cricondenthermTemperature_xi;

      replaceable partial function cricondenbarPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_ccb "";
      end cricondenbarPressure_xi;

      replaceable partial function cricondenthermPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.AbsolutePressure p_cct "";
      end cricondenthermPressure_xi;

      replaceable partial function molarMass_n
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input Integer compNo "Component ID";
        input .TILMedia.Internals.TILMediaExternalObject vleFluidPointer;
        output SI.MolarMass M_i "Molar mass of component i";
      end molarMass_n;

    end PartialVLEFluidObjectFunctions;

    partial function PartialVLEFluidFunction
      annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
              imageSource=
                  "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",
              fileName="modelica://TILMedia/Images/Icon_VLEFluid_Function.png")}));

    end PartialVLEFluidFunction;

    partial function PartialVLEFluidObjectFunction
      annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
              imageSource=
                  "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",
              fileName=
                  "modelica://TILMedia/Images/Icon_VLEFluid_Function.png")}));

    end PartialVLEFluidObjectFunction;
    annotation(Protection(access=Access.nonPackageDuplicate));
  end BaseClasses;

  package GasTypes
  "Gases and Gas Vapor mixtures, that can be used or composed in TILMedia"
    extends .TILMedia.Internals.ClassTypes.ModelPackage;

    record BaseGas "Base record for gas definitions"
      extends .TILMedia.Internals.ClassTypes.Record;
      constant Boolean fixedMixingRatio
        "Treat medium as pseudo pure in Modelica if it is a mixture"
        annotation(Dialog, HideResult = true);
      constant Integer nc_propertyCalculation(min=1)
        "Number of components for fluid property calculations"
        annotation(Dialog, HideResult = true);
      final constant Integer nc=if fixedMixingRatio then 1 else nc_propertyCalculation
        "Number of components in Modelica models"
        annotation(Evaluate=true, HideResult = true);
      parameter .TILMedia.Internals.GasName[:] gasNames = {""}
        "Array of gas names e.g. {\"gasName\"} for pure component"
        annotation(Dialog, choices);
      parameter Real[nc_propertyCalculation] mixingRatio_propertyCalculation = {1}
        "Mixing ratio for fluid property calculation (={1} for pure components)"
        annotation(Dialog, HideResult = true);
      final parameter Real[nc] defaultMixingRatio = if fixedMixingRatio then {1} else mixingRatio_propertyCalculation
        "Default composition for models in Modelica (={1} for pure components)"
        annotation(HideResult = true);
      final parameter Real xi_default[nc-1] = defaultMixingRatio[1:end-1]/sum(defaultMixingRatio)
        "Default mass fractions"
        annotation(HideResult = true);
      constant Integer condensingIndex
        "Index of condensing component (=0, if no condensation is desired)"
        annotation(HideResult = true);
      final parameter String concatGasName = .TILMedia.Internals.concatNames(gasNames)
        annotation(Dialog(tab="Internals"));
      constant Integer ID=0
        "ID is used to map the selected Gas to the sim.cumulatedGasMass array item" annotation(HideResult = true);
      annotation (Documentation(info="<html>
<p><br>Every gas substance model contains a substance record as replaceable parameter extending from this base gas model. The substance record contains the following parameters: </p>
<ul>
<li>fixedMixingRatio - Boolean = true, if mixing ratio is fixed during simulation. </li>
<li>nc_propertyCalculation - Integer with number of components which are calculated. </li>
<li>&apos;substanceNames&apos; - gasName 1, liquidName 2, and so on. Array which lists the substance names. </li>
<li>mixingRatio_propertyCalculation - Array with the mixing ratio of all substances. </li>
<li>condensingIndex - Only for gas mixtures: Integer with the index of the component that can condense. </li>
</ul>
<p><b>Access additional substances:</b> </p>
<p>To acces the properties of an additional substance, it is possible to create a new substance reccord. For more information on the acces of additional propeties see the <a href=\"modelica://TILMedia.UsersGuide.SubstanceRecord\">substance record documentation</a>. </p>
<p>Furthermore it is possible to parameterize this gase base record, using a gas substance name, listed in the <a href=\"modelica://TILMedia.UsersGuide.SubstanceNames\">substance names documentation</a>. An example how to parameterize the base gas model is shown below. However note that this is only a local configuration and therefore only accesible in the corresponding model.</p>
<p><img src=\"modelica://TILMedia/Images/Base_Gas_Parameter_frame.PNG\"/> </p>
</html>"));
    end BaseGas;

    record FlueGasTILMedia "Flue gas TILMedia (Ash,CO,CO2,SO2,N2,O2,NO,H2O,NH3,Ar)"
      extends TILMedia.GasTypes.BaseGas(
        final fixedMixingRatio=false,
        final nc_propertyCalculation=10,
        final gasNames={"TILMedia.Ash","TILMediaXTR.Carbon_Monoxide","TILMediaXTR.Carbon_Dioxide","TILMediaXTR.Sulfur_Dioxide","TILMediaXTR.Nitrogen","TILMediaXTR.Oxygen","TILMediaXTR.Nitrous_Oxide","TILMediaXTR.Water","TILMediaXTR.Ammonia","TILMediaXTR.Argon"},
        final condensingIndex=8,
        final mixingRatio_propertyCalculation={0.001,0.001,0.001,0.001,1,0.001,0.001,0.001,0.001,0.001});
    end FlueGasTILMedia;

    record MoistAirMixture "Moist air gas mixture with a condensing component"
      extends TILMedia.GasTypes.BaseGas(
        final fixedMixingRatio=false,
        final nc_propertyCalculation=10,
        final gasNames={"TILMedia.Ash","TILMediaXTR.Carbon_Monoxide","TILMediaXTR.Carbon_Dioxide","TILMediaXTR.Sulfur_Dioxide","TILMediaXTR.Nitrogen","TILMediaXTR.Oxygen","TILMediaXTR.Nitrous_Oxide","TILMediaXTR.Water","TILMediaXTR.Ammonia","TILMediaXTR.Argon"},
        final condensingIndex=8,
        final mixingRatio_propertyCalculation={0.0,0.0,0.00058,0.0,0.75419,0.23135,0.0,0.001,0.0,0.01288});
    end MoistAirMixture;
    annotation(Protection(access=Access.nonPackageDuplicate));
  end GasTypes;

  package VLEFluidFunctions
  "Package for calculation of VLEFluid properties with a functional call"
    extends .TILMedia.BaseClasses.PartialVLEFluidFunctions;

    redeclare function extends specificEnthalpy_dTxi
    algorithm
      h := .TILMedia.Internals.VLEFluidFunctions.specificEnthalpy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEnthalpy_dTxi;

    redeclare function extends pressure_dTxi
    algorithm
      p := .TILMedia.Internals.VLEFluidFunctions.pressure_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end pressure_dTxi;

    redeclare function extends specificEntropy_dTxi
    algorithm
      s := .TILMedia.Internals.VLEFluidFunctions.specificEntropy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEntropy_dTxi;

    redeclare function extends moleFraction_dTxin
    algorithm
      x := .TILMedia.Internals.VLEFluidFunctions.moleFraction_dTxin(d,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end moleFraction_dTxin;

    redeclare function extends steamMassFraction_dTxi
    algorithm
      q := .TILMedia.Internals.VLEFluidFunctions.steamMassFraction_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end steamMassFraction_dTxi;

    redeclare function extends specificIsobaricHeatCapacity_dTxi
    algorithm
      cp := .TILMedia.Internals.VLEFluidFunctions.specificIsobaricHeatCapacity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsobaricHeatCapacity_dTxi;

    redeclare function extends specificIsochoricHeatCapacity_dTxi
    algorithm
      cv := .TILMedia.Internals.VLEFluidFunctions.specificIsochoricHeatCapacity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsochoricHeatCapacity_dTxi;

    redeclare function extends isobaricThermalExpansionCoefficient_dTxi
    algorithm
      beta := .TILMedia.Internals.VLEFluidFunctions.isobaricThermalExpansionCoefficient_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isobaricThermalExpansionCoefficient_dTxi;

    redeclare function extends isothermalCompressibility_dTxi
    algorithm
      kappa := .TILMedia.Internals.VLEFluidFunctions.isothermalCompressibility_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isothermalCompressibility_dTxi;

    redeclare function extends speedOfSound_dTxi
    algorithm
      w := .TILMedia.Internals.VLEFluidFunctions.speedOfSound_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end speedOfSound_dTxi;

    redeclare function extends densityDerivativeWRTspecificEnthalpy_dTxi
    algorithm
      drhodh_pxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTspecificEnthalpy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTspecificEnthalpy_dTxi;

    redeclare function extends densityDerivativeWRTpressure_dTxi
    algorithm
      drhodp_hxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTpressure_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTpressure_dTxi;

    redeclare function extends densityDerivativeWRTmassFraction_dTxin
    algorithm
      drhodxi_ph := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTmassFraction_dTxin(d,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTmassFraction_dTxin;

    redeclare function extends heatCapacityRatio_dTxi
    algorithm
      gamma := .TILMedia.Internals.VLEFluidFunctions.heatCapacityRatio_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end heatCapacityRatio_dTxi;

    redeclare function extends prandtlNumber_dTxi
    algorithm
      Pr := .TILMedia.Internals.VLEFluidFunctions.prandtlNumber_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end prandtlNumber_dTxi;

    redeclare function extends thermalConductivity_dTxi
    algorithm
      lambda := .TILMedia.Internals.VLEFluidFunctions.thermalConductivity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end thermalConductivity_dTxi;

    redeclare function extends dynamicViscosity_dTxi
    algorithm
      eta := .TILMedia.Internals.VLEFluidFunctions.dynamicViscosity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dynamicViscosity_dTxi;

    redeclare function extends surfaceTension_dTxi
    algorithm
      sigma := .TILMedia.Internals.VLEFluidFunctions.surfaceTension_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end surfaceTension_dTxi;

    redeclare function extends liquidDensity_dTxi
    algorithm
      d_l := .TILMedia.Internals.VLEFluidFunctions.liquidDensity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidDensity_dTxi;

    redeclare function extends vapourDensity_dTxi
    algorithm
      d_v := .TILMedia.Internals.VLEFluidFunctions.vapourDensity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourDensity_dTxi;

    redeclare function extends liquidSpecificEnthalpy_dTxi
    algorithm
      h_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEnthalpy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEnthalpy_dTxi;

    redeclare function extends vapourSpecificEnthalpy_dTxi
    algorithm
      h_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEnthalpy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEnthalpy_dTxi;

    redeclare function extends liquidPressure_dTxi
    algorithm
      p_l := .TILMedia.Internals.VLEFluidFunctions.liquidPressure_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidPressure_dTxi;

    redeclare function extends vapourPressure_dTxi
    algorithm
      p_v := .TILMedia.Internals.VLEFluidFunctions.vapourPressure_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourPressure_dTxi;

    redeclare function extends liquidSpecificEntropy_dTxi
    algorithm
      s_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEntropy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEntropy_dTxi;

    redeclare function extends vapourSpecificEntropy_dTxi
    algorithm
      s_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEntropy_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEntropy_dTxi;

    redeclare function extends liquidMassFraction_dTxin
    algorithm
      xi_l := .TILMedia.Internals.VLEFluidFunctions.liquidMassFraction_dTxin(d,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidMassFraction_dTxin;

    redeclare function extends vapourMassFraction_dTxin
    algorithm
      xi_v := .TILMedia.Internals.VLEFluidFunctions.vapourMassFraction_dTxin(d,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourMassFraction_dTxin;

    redeclare function extends liquidSpecificHeatCapacity_dTxi
    algorithm
      cp_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificHeatCapacity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificHeatCapacity_dTxi;

    redeclare function extends vapourSpecificHeatCapacity_dTxi
    algorithm
      cp_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificHeatCapacity_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificHeatCapacity_dTxi;

    redeclare function extends liquidIsobaricThermalExpansionCoefficient_dTxi
    algorithm
      beta_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsobaricThermalExpansionCoefficient_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsobaricThermalExpansionCoefficient_dTxi;

    redeclare function extends vapourIsobaricThermalExpansionCoefficient_dTxi
    algorithm
      beta_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsobaricThermalExpansionCoefficient_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsobaricThermalExpansionCoefficient_dTxi;

    redeclare function extends liquidIsothermalCompressibility_dTxi
    algorithm
      kappa_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsothermalCompressibility_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsothermalCompressibility_dTxi;

    redeclare function extends vapourIsothermalCompressibility_dTxi
    algorithm
      kappa_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsothermalCompressibility_dTxi(d,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsothermalCompressibility_dTxi;

    redeclare function extends density_phxi
    algorithm
      d := .TILMedia.Internals.VLEFluidFunctions.density_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end density_phxi;

    redeclare function extends specificEntropy_phxi
    algorithm
      s := .TILMedia.Internals.VLEFluidFunctions.specificEntropy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEntropy_phxi;

    redeclare function extends temperature_phxi
    algorithm
      T := .TILMedia.Internals.VLEFluidFunctions.temperature_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end temperature_phxi;

    redeclare function extends moleFraction_phxin
    algorithm
      x := .TILMedia.Internals.VLEFluidFunctions.moleFraction_phxin(p,h,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end moleFraction_phxin;

    redeclare function extends steamMassFraction_phxi
    algorithm
      q := .TILMedia.Internals.VLEFluidFunctions.steamMassFraction_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end steamMassFraction_phxi;

    redeclare function extends specificIsobaricHeatCapacity_phxi
    algorithm
      cp := .TILMedia.Internals.VLEFluidFunctions.specificIsobaricHeatCapacity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsobaricHeatCapacity_phxi;

    redeclare function extends specificIsochoricHeatCapacity_phxi
    algorithm
      cv := .TILMedia.Internals.VLEFluidFunctions.specificIsochoricHeatCapacity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsochoricHeatCapacity_phxi;

    redeclare function extends isobaricThermalExpansionCoefficient_phxi
    algorithm
      beta := .TILMedia.Internals.VLEFluidFunctions.isobaricThermalExpansionCoefficient_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isobaricThermalExpansionCoefficient_phxi;

    redeclare function extends isothermalCompressibility_phxi
    algorithm
      kappa := .TILMedia.Internals.VLEFluidFunctions.isothermalCompressibility_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isothermalCompressibility_phxi;

    redeclare function extends speedOfSound_phxi
    algorithm
      w := .TILMedia.Internals.VLEFluidFunctions.speedOfSound_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end speedOfSound_phxi;

    redeclare function extends densityDerivativeWRTspecificEnthalpy_phxi
    algorithm
      drhodh_pxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTspecificEnthalpy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTspecificEnthalpy_phxi;

    redeclare function extends densityDerivativeWRTpressure_phxi
    algorithm
      drhodp_hxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTpressure_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTpressure_phxi;

    redeclare function extends densityDerivativeWRTmassFraction_phxin
    algorithm
      drhodxi_ph := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTmassFraction_phxin(p,h,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTmassFraction_phxin;

    redeclare function extends heatCapacityRatio_phxi
    algorithm
      gamma := .TILMedia.Internals.VLEFluidFunctions.heatCapacityRatio_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end heatCapacityRatio_phxi;

    redeclare function extends prandtlNumber_phxi
    algorithm
      Pr := .TILMedia.Internals.VLEFluidFunctions.prandtlNumber_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end prandtlNumber_phxi;

    redeclare function extends thermalConductivity_phxi
    algorithm
      lambda := .TILMedia.Internals.VLEFluidFunctions.thermalConductivity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end thermalConductivity_phxi;

    redeclare function extends dynamicViscosity_phxi
    algorithm
      eta := .TILMedia.Internals.VLEFluidFunctions.dynamicViscosity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dynamicViscosity_phxi;

    redeclare function extends surfaceTension_phxi
    algorithm
      sigma := .TILMedia.Internals.VLEFluidFunctions.surfaceTension_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end surfaceTension_phxi;

    redeclare function extends liquidDensity_phxi
    algorithm
      d_l := .TILMedia.Internals.VLEFluidFunctions.liquidDensity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidDensity_phxi;

    redeclare function extends vapourDensity_phxi
    algorithm
      d_v := .TILMedia.Internals.VLEFluidFunctions.vapourDensity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourDensity_phxi;

    redeclare function extends liquidSpecificEnthalpy_phxi
    algorithm
      h_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEnthalpy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEnthalpy_phxi;

    redeclare function extends vapourSpecificEnthalpy_phxi
    algorithm
      h_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEnthalpy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEnthalpy_phxi;

    redeclare function extends liquidSpecificEntropy_phxi
    algorithm
      s_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEntropy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEntropy_phxi;

    redeclare function extends vapourSpecificEntropy_phxi
    algorithm
      s_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEntropy_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEntropy_phxi;

    redeclare function extends liquidTemperature_phxi
    algorithm
      T_l := .TILMedia.Internals.VLEFluidFunctions.liquidTemperature_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidTemperature_phxi;

    redeclare function extends vapourTemperature_phxi
    algorithm
      T_v := .TILMedia.Internals.VLEFluidFunctions.vapourTemperature_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourTemperature_phxi;

    redeclare function extends liquidMassFraction_phxin
    algorithm
      xi_l := .TILMedia.Internals.VLEFluidFunctions.liquidMassFraction_phxin(p,h,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidMassFraction_phxin;

    redeclare function extends vapourMassFraction_phxin
    algorithm
      xi_v := .TILMedia.Internals.VLEFluidFunctions.vapourMassFraction_phxin(p,h,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourMassFraction_phxin;

    redeclare function extends liquidSpecificHeatCapacity_phxi
    algorithm
      cp_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificHeatCapacity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificHeatCapacity_phxi;

    redeclare function extends vapourSpecificHeatCapacity_phxi
    algorithm
      cp_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificHeatCapacity_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificHeatCapacity_phxi;

    redeclare function extends liquidIsobaricThermalExpansionCoefficient_phxi
    algorithm
      beta_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsobaricThermalExpansionCoefficient_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsobaricThermalExpansionCoefficient_phxi;

    redeclare function extends vapourIsobaricThermalExpansionCoefficient_phxi
    algorithm
      beta_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsobaricThermalExpansionCoefficient_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsobaricThermalExpansionCoefficient_phxi;

    redeclare function extends liquidIsothermalCompressibility_phxi
    algorithm
      kappa_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsothermalCompressibility_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsothermalCompressibility_phxi;

    redeclare function extends vapourIsothermalCompressibility_phxi
    algorithm
      kappa_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsothermalCompressibility_phxi(p,h,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsothermalCompressibility_phxi;

    redeclare function extends density_psxi
    algorithm
      d := .TILMedia.Internals.VLEFluidFunctions.density_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end density_psxi;

    redeclare function extends specificEnthalpy_psxi
    algorithm
      h := .TILMedia.Internals.VLEFluidFunctions.specificEnthalpy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEnthalpy_psxi;

    redeclare function extends temperature_psxi
    algorithm
      T := .TILMedia.Internals.VLEFluidFunctions.temperature_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end temperature_psxi;

    redeclare function extends moleFraction_psxin
    algorithm
      x := .TILMedia.Internals.VLEFluidFunctions.moleFraction_psxin(p,s,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end moleFraction_psxin;

    redeclare function extends steamMassFraction_psxi
    algorithm
      q := .TILMedia.Internals.VLEFluidFunctions.steamMassFraction_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end steamMassFraction_psxi;

    redeclare function extends specificIsobaricHeatCapacity_psxi
    algorithm
      cp := .TILMedia.Internals.VLEFluidFunctions.specificIsobaricHeatCapacity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsobaricHeatCapacity_psxi;

    redeclare function extends specificIsochoricHeatCapacity_psxi
    algorithm
      cv := .TILMedia.Internals.VLEFluidFunctions.specificIsochoricHeatCapacity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsochoricHeatCapacity_psxi;

    redeclare function extends isobaricThermalExpansionCoefficient_psxi
    algorithm
      beta := .TILMedia.Internals.VLEFluidFunctions.isobaricThermalExpansionCoefficient_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isobaricThermalExpansionCoefficient_psxi;

    redeclare function extends isothermalCompressibility_psxi
    algorithm
      kappa := .TILMedia.Internals.VLEFluidFunctions.isothermalCompressibility_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isothermalCompressibility_psxi;

    redeclare function extends speedOfSound_psxi
    algorithm
      w := .TILMedia.Internals.VLEFluidFunctions.speedOfSound_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end speedOfSound_psxi;

    redeclare function extends densityDerivativeWRTspecificEnthalpy_psxi
    algorithm
      drhodh_pxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTspecificEnthalpy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTspecificEnthalpy_psxi;

    redeclare function extends densityDerivativeWRTpressure_psxi
    algorithm
      drhodp_hxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTpressure_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTpressure_psxi;

    redeclare function extends densityDerivativeWRTmassFraction_psxin
    algorithm
      drhodxi_ph := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTmassFraction_psxin(p,s,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTmassFraction_psxin;

    redeclare function extends heatCapacityRatio_psxi
    algorithm
      gamma := .TILMedia.Internals.VLEFluidFunctions.heatCapacityRatio_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end heatCapacityRatio_psxi;

    redeclare function extends prandtlNumber_psxi
    algorithm
      Pr := .TILMedia.Internals.VLEFluidFunctions.prandtlNumber_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end prandtlNumber_psxi;

    redeclare function extends thermalConductivity_psxi
    algorithm
      lambda := .TILMedia.Internals.VLEFluidFunctions.thermalConductivity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end thermalConductivity_psxi;

    redeclare function extends dynamicViscosity_psxi
    algorithm
      eta := .TILMedia.Internals.VLEFluidFunctions.dynamicViscosity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dynamicViscosity_psxi;

    redeclare function extends surfaceTension_psxi
    algorithm
      sigma := .TILMedia.Internals.VLEFluidFunctions.surfaceTension_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end surfaceTension_psxi;

    redeclare function extends liquidDensity_psxi
    algorithm
      d_l := .TILMedia.Internals.VLEFluidFunctions.liquidDensity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidDensity_psxi;

    redeclare function extends vapourDensity_psxi
    algorithm
      d_v := .TILMedia.Internals.VLEFluidFunctions.vapourDensity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourDensity_psxi;

    redeclare function extends liquidSpecificEnthalpy_psxi
    algorithm
      h_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEnthalpy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEnthalpy_psxi;

    redeclare function extends vapourSpecificEnthalpy_psxi
    algorithm
      h_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEnthalpy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEnthalpy_psxi;

    redeclare function extends liquidSpecificEntropy_psxi
    algorithm
      s_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEntropy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEntropy_psxi;

    redeclare function extends vapourSpecificEntropy_psxi
    algorithm
      s_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEntropy_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEntropy_psxi;

    redeclare function extends liquidTemperature_psxi
    algorithm
      T_l := .TILMedia.Internals.VLEFluidFunctions.liquidTemperature_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidTemperature_psxi;

    redeclare function extends vapourTemperature_psxi
    algorithm
      T_v := .TILMedia.Internals.VLEFluidFunctions.vapourTemperature_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourTemperature_psxi;

    redeclare function extends liquidMassFraction_psxin
    algorithm
      xi_l := .TILMedia.Internals.VLEFluidFunctions.liquidMassFraction_psxin(p,s,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidMassFraction_psxin;

    redeclare function extends vapourMassFraction_psxin
    algorithm
      xi_v := .TILMedia.Internals.VLEFluidFunctions.vapourMassFraction_psxin(p,s,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourMassFraction_psxin;

    redeclare function extends liquidSpecificHeatCapacity_psxi
    algorithm
      cp_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificHeatCapacity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificHeatCapacity_psxi;

    redeclare function extends vapourSpecificHeatCapacity_psxi
    algorithm
      cp_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificHeatCapacity_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificHeatCapacity_psxi;

    redeclare function extends liquidIsobaricThermalExpansionCoefficient_psxi
    algorithm
      beta_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsobaricThermalExpansionCoefficient_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsobaricThermalExpansionCoefficient_psxi;

    redeclare function extends vapourIsobaricThermalExpansionCoefficient_psxi
    algorithm
      beta_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsobaricThermalExpansionCoefficient_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsobaricThermalExpansionCoefficient_psxi;

    redeclare function extends liquidIsothermalCompressibility_psxi
    algorithm
      kappa_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsothermalCompressibility_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsothermalCompressibility_psxi;

    redeclare function extends vapourIsothermalCompressibility_psxi
    algorithm
      kappa_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsothermalCompressibility_psxi(p,s,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsothermalCompressibility_psxi;

    redeclare function extends density_pTxi
    algorithm
      d := .TILMedia.Internals.VLEFluidFunctions.density_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end density_pTxi;

    redeclare function extends specificEnthalpy_pTxi
    algorithm
      h := .TILMedia.Internals.VLEFluidFunctions.specificEnthalpy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEnthalpy_pTxi;

    redeclare function extends specificEntropy_pTxi
    algorithm
      s := .TILMedia.Internals.VLEFluidFunctions.specificEntropy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificEntropy_pTxi;

    redeclare function extends moleFraction_pTxin
    algorithm
      x := .TILMedia.Internals.VLEFluidFunctions.moleFraction_pTxin(p,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end moleFraction_pTxin;

    redeclare function extends steamMassFraction_pTxi
    algorithm
      q := .TILMedia.Internals.VLEFluidFunctions.steamMassFraction_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end steamMassFraction_pTxi;

    redeclare function extends specificIsobaricHeatCapacity_pTxi
    algorithm
      cp := .TILMedia.Internals.VLEFluidFunctions.specificIsobaricHeatCapacity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsobaricHeatCapacity_pTxi;

    redeclare function extends specificIsochoricHeatCapacity_pTxi
    algorithm
      cv := .TILMedia.Internals.VLEFluidFunctions.specificIsochoricHeatCapacity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end specificIsochoricHeatCapacity_pTxi;

    redeclare function extends isobaricThermalExpansionCoefficient_pTxi
    algorithm
      beta := .TILMedia.Internals.VLEFluidFunctions.isobaricThermalExpansionCoefficient_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isobaricThermalExpansionCoefficient_pTxi;

    redeclare function extends isothermalCompressibility_pTxi
    algorithm
      kappa := .TILMedia.Internals.VLEFluidFunctions.isothermalCompressibility_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end isothermalCompressibility_pTxi;

    redeclare function extends speedOfSound_pTxi
    algorithm
      w := .TILMedia.Internals.VLEFluidFunctions.speedOfSound_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end speedOfSound_pTxi;

    redeclare function extends densityDerivativeWRTspecificEnthalpy_pTxi
    algorithm
      drhodh_pxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTspecificEnthalpy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTspecificEnthalpy_pTxi;

    redeclare function extends densityDerivativeWRTpressure_pTxi
    algorithm
      drhodp_hxi := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTpressure_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTpressure_pTxi;

    redeclare function extends densityDerivativeWRTmassFraction_pTxin
    algorithm
      drhodxi_ph := .TILMedia.Internals.VLEFluidFunctions.densityDerivativeWRTmassFraction_pTxin(p,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end densityDerivativeWRTmassFraction_pTxin;

    redeclare function extends heatCapacityRatio_pTxi
    algorithm
      gamma := .TILMedia.Internals.VLEFluidFunctions.heatCapacityRatio_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end heatCapacityRatio_pTxi;

    redeclare function extends prandtlNumber_pTxi
    algorithm
      Pr := .TILMedia.Internals.VLEFluidFunctions.prandtlNumber_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end prandtlNumber_pTxi;

    redeclare function extends thermalConductivity_pTxi
    algorithm
      lambda := .TILMedia.Internals.VLEFluidFunctions.thermalConductivity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end thermalConductivity_pTxi;

    redeclare function extends dynamicViscosity_pTxi
    algorithm
      eta := .TILMedia.Internals.VLEFluidFunctions.dynamicViscosity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dynamicViscosity_pTxi;

    redeclare function extends surfaceTension_pTxi
    algorithm
      sigma := .TILMedia.Internals.VLEFluidFunctions.surfaceTension_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end surfaceTension_pTxi;

    redeclare function extends liquidDensity_pTxi
    algorithm
      d_l := .TILMedia.Internals.VLEFluidFunctions.liquidDensity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidDensity_pTxi;

    redeclare function extends vapourDensity_pTxi
    algorithm
      d_v := .TILMedia.Internals.VLEFluidFunctions.vapourDensity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourDensity_pTxi;

    redeclare function extends liquidSpecificEnthalpy_pTxi
    algorithm
      h_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEnthalpy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEnthalpy_pTxi;

    redeclare function extends vapourSpecificEnthalpy_pTxi
    algorithm
      h_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEnthalpy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEnthalpy_pTxi;

    redeclare function extends liquidSpecificEntropy_pTxi
    algorithm
      s_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificEntropy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificEntropy_pTxi;

    redeclare function extends vapourSpecificEntropy_pTxi
    algorithm
      s_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificEntropy_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificEntropy_pTxi;

    redeclare function extends liquidTemperature_pTxi
    algorithm
      T_l := .TILMedia.Internals.VLEFluidFunctions.liquidTemperature_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidTemperature_pTxi;

    redeclare function extends vapourTemperature_pTxi
    algorithm
      T_v := .TILMedia.Internals.VLEFluidFunctions.vapourTemperature_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourTemperature_pTxi;

    redeclare function extends liquidMassFraction_pTxin
    algorithm
      xi_l := .TILMedia.Internals.VLEFluidFunctions.liquidMassFraction_pTxin(p,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidMassFraction_pTxin;

    redeclare function extends vapourMassFraction_pTxin
    algorithm
      xi_v := .TILMedia.Internals.VLEFluidFunctions.vapourMassFraction_pTxin(p,T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourMassFraction_pTxin;

    redeclare function extends liquidSpecificHeatCapacity_pTxi
    algorithm
      cp_l := .TILMedia.Internals.VLEFluidFunctions.liquidSpecificHeatCapacity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidSpecificHeatCapacity_pTxi;

    redeclare function extends vapourSpecificHeatCapacity_pTxi
    algorithm
      cp_v := .TILMedia.Internals.VLEFluidFunctions.vapourSpecificHeatCapacity_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourSpecificHeatCapacity_pTxi;

    redeclare function extends liquidIsobaricThermalExpansionCoefficient_pTxi
    algorithm
      beta_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsobaricThermalExpansionCoefficient_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsobaricThermalExpansionCoefficient_pTxi;

    redeclare function extends vapourIsobaricThermalExpansionCoefficient_pTxi
    algorithm
      beta_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsobaricThermalExpansionCoefficient_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsobaricThermalExpansionCoefficient_pTxi;

    redeclare function extends liquidIsothermalCompressibility_pTxi
    algorithm
      kappa_l := .TILMedia.Internals.VLEFluidFunctions.liquidIsothermalCompressibility_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end liquidIsothermalCompressibility_pTxi;

    redeclare function extends vapourIsothermalCompressibility_pTxi
    algorithm
      kappa_v := .TILMedia.Internals.VLEFluidFunctions.vapourIsothermalCompressibility_pTxi(p,T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end vapourIsothermalCompressibility_pTxi;

    redeclare function extends dewDensity_Txi
    algorithm
      d_dew := .TILMedia.Internals.VLEFluidFunctions.dewDensity_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewDensity_Txi;

    redeclare function extends bubbleDensity_Txi
    algorithm
      d_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleDensity_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleDensity_Txi;

    redeclare function extends dewSpecificEnthalpy_Txi
    algorithm
      h_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificEnthalpy_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificEnthalpy_Txi;

    redeclare function extends bubbleSpecificEnthalpy_Txi
    algorithm
      h_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificEnthalpy_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificEnthalpy_Txi;

    redeclare function extends dewPressure_Txi
    algorithm
      p_dew := .TILMedia.Internals.VLEFluidFunctions.dewPressure_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewPressure_Txi;

    redeclare function extends bubblePressure_Txi
    algorithm
      p_bubble := .TILMedia.Internals.VLEFluidFunctions.bubblePressure_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubblePressure_Txi;

    redeclare function extends dewSpecificEntropy_Txi
    algorithm
      s_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificEntropy_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificEntropy_Txi;

    redeclare function extends bubbleSpecificEntropy_Txi
    algorithm
      s_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificEntropy_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificEntropy_Txi;

    redeclare function extends dewLiquidMassFraction_Txin
    algorithm
      xi_ldew := .TILMedia.Internals.VLEFluidFunctions.dewLiquidMassFraction_Txin(T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewLiquidMassFraction_Txin;

    redeclare function extends bubbleVapourMassFraction_Txin
    algorithm
      xi_vbubble := .TILMedia.Internals.VLEFluidFunctions.bubbleVapourMassFraction_Txin(T,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleVapourMassFraction_Txin;

    redeclare function extends dewSpecificIsobaricHeatCapacity_Txi
    algorithm
      cp_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificIsobaricHeatCapacity_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificIsobaricHeatCapacity_Txi;

    redeclare function extends bubbleSpecificIsobaricHeatCapacity_Txi
    algorithm
      cp_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificIsobaricHeatCapacity_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificIsobaricHeatCapacity_Txi;

    redeclare function extends dewIsobaricThermalExpansionCoefficient_Txi
    algorithm
      beta_dew := .TILMedia.Internals.VLEFluidFunctions.dewIsobaricThermalExpansionCoefficient_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewIsobaricThermalExpansionCoefficient_Txi;

    redeclare function extends bubbleIsobaricThermalExpansionCoefficient_Txi
    algorithm
      beta_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleIsobaricThermalExpansionCoefficient_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleIsobaricThermalExpansionCoefficient_Txi;

    redeclare function extends dewIsothermalCompressibility_Txi
    algorithm
      kappa_dew := .TILMedia.Internals.VLEFluidFunctions.dewIsothermalCompressibility_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewIsothermalCompressibility_Txi;

    redeclare function extends bubbleIsothermalCompressibility_Txi
    algorithm
      kappa_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleIsothermalCompressibility_Txi(T,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleIsothermalCompressibility_Txi;

    redeclare function extends dewDensity_pxi
    algorithm
      d_dew := .TILMedia.Internals.VLEFluidFunctions.dewDensity_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewDensity_pxi;

    redeclare function extends bubbleDensity_pxi
    algorithm
      d_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleDensity_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleDensity_pxi;

    redeclare function extends dewSpecificEnthalpy_pxi
    algorithm
      h_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificEnthalpy_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificEnthalpy_pxi;

    redeclare function extends bubbleSpecificEnthalpy_pxi
    algorithm
      h_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificEnthalpy_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificEnthalpy_pxi;

    redeclare function extends dewSpecificEntropy_pxi
    algorithm
      s_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificEntropy_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificEntropy_pxi;

    redeclare function extends bubbleSpecificEntropy_pxi
    algorithm
      s_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificEntropy_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificEntropy_pxi;

    redeclare function extends dewTemperature_pxi
    algorithm
      T_dew := .TILMedia.Internals.VLEFluidFunctions.dewTemperature_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewTemperature_pxi;

    redeclare function extends bubbleTemperature_pxi
    algorithm
      T_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleTemperature_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleTemperature_pxi;

    redeclare function extends dewLiquidMassFraction_pxin
    algorithm
      xi_ldew := .TILMedia.Internals.VLEFluidFunctions.dewLiquidMassFraction_pxin(p,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewLiquidMassFraction_pxin;

    redeclare function extends bubbleVapourMassFraction_pxin
    algorithm
      xi_vbubble := .TILMedia.Internals.VLEFluidFunctions.bubbleVapourMassFraction_pxin(p,xi,compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleVapourMassFraction_pxin;

    redeclare function extends dewSpecificIsobaricHeatCapacity_pxi
    algorithm
      cp_dew := .TILMedia.Internals.VLEFluidFunctions.dewSpecificIsobaricHeatCapacity_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewSpecificIsobaricHeatCapacity_pxi;

    redeclare function extends bubbleSpecificIsobaricHeatCapacity_pxi
    algorithm
      cp_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleSpecificIsobaricHeatCapacity_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleSpecificIsobaricHeatCapacity_pxi;

    redeclare function extends dewIsobaricThermalExpansionCoefficient_pxi
    algorithm
      beta_dew := .TILMedia.Internals.VLEFluidFunctions.dewIsobaricThermalExpansionCoefficient_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewIsobaricThermalExpansionCoefficient_pxi;

    redeclare function extends bubbleIsobaricThermalExpansionCoefficient_pxi
    algorithm
      beta_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleIsobaricThermalExpansionCoefficient_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleIsobaricThermalExpansionCoefficient_pxi;

    redeclare function extends dewIsothermalCompressibility_pxi
    algorithm
      kappa_dew := .TILMedia.Internals.VLEFluidFunctions.dewIsothermalCompressibility_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end dewIsothermalCompressibility_pxi;

    redeclare function extends bubbleIsothermalCompressibility_pxi
    algorithm
      kappa_bubble := .TILMedia.Internals.VLEFluidFunctions.bubbleIsothermalCompressibility_pxi(p,xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end bubbleIsothermalCompressibility_pxi;

    redeclare function extends averageMolarMass_xi
    algorithm
      M := .TILMedia.Internals.VLEFluidFunctions.averageMolarMass_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end averageMolarMass_xi;

    redeclare function extends criticalDensity_xi
    algorithm
      dc := .TILMedia.Internals.VLEFluidFunctions.criticalDensity_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalDensity_xi;

    redeclare function extends criticalSpecificEnthalpy_xi
    algorithm
      hc := .TILMedia.Internals.VLEFluidFunctions.criticalSpecificEnthalpy_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalSpecificEnthalpy_xi;

    redeclare function extends criticalPressure_xi
    algorithm
      pc := .TILMedia.Internals.VLEFluidFunctions.criticalPressure_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalPressure_xi;

    redeclare function extends criticalSpecificEntropy_xi
    algorithm
      sc := .TILMedia.Internals.VLEFluidFunctions.criticalSpecificEntropy_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalSpecificEntropy_xi;

    redeclare function extends criticalTemperature_xi
    algorithm
      Tc := .TILMedia.Internals.VLEFluidFunctions.criticalTemperature_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalTemperature_xi;

    redeclare function extends criticalSpecificIsobaricHeatCapacity_xi
    algorithm
      cpc := .TILMedia.Internals.VLEFluidFunctions.criticalSpecificIsobaricHeatCapacity_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalSpecificIsobaricHeatCapacity_xi;

    redeclare function extends criticalIsobaricThermalExpansionCoefficient_xi
    algorithm
      betac := .TILMedia.Internals.VLEFluidFunctions.criticalIsobaricThermalExpansionCoefficient_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalIsobaricThermalExpansionCoefficient_xi;

    redeclare function extends criticalIsothermalCompressibility_xi
    algorithm
      kappac := .TILMedia.Internals.VLEFluidFunctions.criticalIsothermalCompressibility_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalIsothermalCompressibility_xi;

    redeclare function extends criticalThermalConductivity_xi
    algorithm
      lambdac := .TILMedia.Internals.VLEFluidFunctions.criticalThermalConductivity_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalThermalConductivity_xi;

    redeclare function extends criticalDynamicViscosity_xi
    algorithm
      etac := .TILMedia.Internals.VLEFluidFunctions.criticalDynamicViscosity_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalDynamicViscosity_xi;

    redeclare function extends criticalSurfaceTension_xi
    algorithm
      sigmac := .TILMedia.Internals.VLEFluidFunctions.criticalSurfaceTension_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end criticalSurfaceTension_xi;

    redeclare function extends cricondenbarTemperature_xi
    algorithm
      T_ccb := .TILMedia.Internals.VLEFluidFunctions.cricondenbarTemperature_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end cricondenbarTemperature_xi;

    redeclare function extends cricondenthermTemperature_xi
    algorithm
      T_cct := .TILMedia.Internals.VLEFluidFunctions.cricondenthermTemperature_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end cricondenthermTemperature_xi;

    redeclare function extends cricondenbarPressure_xi
    algorithm
      p_ccb := .TILMedia.Internals.VLEFluidFunctions.cricondenbarPressure_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end cricondenbarPressure_xi;

    redeclare function extends cricondenthermPressure_xi
    algorithm
      p_cct := .TILMedia.Internals.VLEFluidFunctions.cricondenthermPressure_xi(xi,vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end cricondenthermPressure_xi;

    redeclare function extends molarMass_n
    algorithm
      M_i := .TILMedia.Internals.VLEFluidFunctions.molarMass_n(compNo, vleFluidType.concatVLEFluidName, vleFluidType.nc+.TILMedia.Internals.redirectModelicaFormatMessage());
      annotation(Inline=false, LateInline=true);
    end molarMass_n;
  end VLEFluidFunctions;

  package VLEFluidObjectFunctions
    "Package for calculation of VLEFLuid properties with a functional call, referencing existing external objects for highspeed evaluation"
    extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunctions;

    redeclare replaceable function specificEnthalpy_dTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEnthalpy_dTxi;
    redeclare replaceable function pressure_dTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.pressure_dTxi;
    redeclare replaceable function specificEntropy_dTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEntropy_dTxi;
    redeclare replaceable function extends moleFraction_dTxin
    external"C" x = TILMedia_VLEFluidObjectFunctions_moleFraction_dTxin(
        d,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_moleFraction_dTxin(double,double,double*,int, void*) { return 0.0; }");
    end moleFraction_dTxin;

    redeclare replaceable function extends steamMassFraction_dTxi
    external"C" q = TILMedia_VLEFluidObjectFunctions_steamMassFraction_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_steamMassFraction_dTxi(double,double,double*,void*) { return 0.0; }");
    end steamMassFraction_dTxi;

    redeclare replaceable function extends specificIsobaricHeatCapacity_dTxi
    external"C" cp = TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_dTxi(double,double,double*,void*) { return 0.0; }");
    end specificIsobaricHeatCapacity_dTxi;

    redeclare replaceable function extends specificIsochoricHeatCapacity_dTxi
    external"C" cv = TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_dTxi(double,double,double*,void*) { return 0.0; }");
    end specificIsochoricHeatCapacity_dTxi;

    redeclare replaceable function extends
    isobaricThermalExpansionCoefficient_dTxi
    external"C" beta = TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_dTxi(double,double,double*,void*) { return 0.0; }");
    end isobaricThermalExpansionCoefficient_dTxi;

    redeclare replaceable function extends isothermalCompressibility_dTxi
    external"C" kappa = TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_dTxi(double,double,double*,void*) { return 0.0; }");
    end isothermalCompressibility_dTxi;

    redeclare replaceable function extends speedOfSound_dTxi
    external"C" w = TILMedia_VLEFluidObjectFunctions_speedOfSound_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_speedOfSound_dTxi(double,double,double*,void*) { return 0.0; }");
    end speedOfSound_dTxi;

    redeclare replaceable function extends
    densityDerivativeWRTspecificEnthalpy_dTxi
    external"C" drhodh_pxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_dTxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTspecificEnthalpy_dTxi;

    redeclare replaceable function extends densityDerivativeWRTpressure_dTxi
    external"C" drhodp_hxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_dTxi(double,double,double*,void*)  { return 0.0; }");
    end densityDerivativeWRTpressure_dTxi;

    redeclare replaceable function extends
    densityDerivativeWRTmassFraction_dTxin
    external"C" drhodxi_ph = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_dTxin(
        d,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_dTxin(double,double,double*,int, void*) { return 0.0; }");
    end densityDerivativeWRTmassFraction_dTxin;

    redeclare replaceable function extends heatCapacityRatio_dTxi
    external"C" gamma = TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_dTxi(double,double,double*,void*)  { return 0.0; }");
    end heatCapacityRatio_dTxi;

    redeclare replaceable function extends prandtlNumber_dTxi
    external"C" Pr = TILMedia_VLEFluidObjectFunctions_prandtlNumber_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_prandtlNumber_dTxi(double,double,double*,void*) { return 0.0; }");
    end prandtlNumber_dTxi;

    redeclare replaceable function extends thermalConductivity_dTxi
    external"C" lambda = TILMedia_VLEFluidObjectFunctions_thermalConductivity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_thermalConductivity_dTxi(double,double,double*,void*) { return 0.0; }");
    end thermalConductivity_dTxi;

    redeclare replaceable function extends dynamicViscosity_dTxi
    external"C" eta = TILMedia_VLEFluidObjectFunctions_dynamicViscosity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_dynamicViscosity_dTxi(double,double,double*,void*) { return 0.0; }");
    end dynamicViscosity_dTxi;

    redeclare replaceable function extends surfaceTension_dTxi
    external"C" sigma = TILMedia_VLEFluidObjectFunctions_surfaceTension_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_surfaceTension_dTxi(double,double,double*,void*) { return 0.0; }");
    end surfaceTension_dTxi;

    redeclare replaceable function extends liquidDensity_dTxi
    external"C" d_l = TILMedia_VLEFluidObjectFunctions_liquidDensity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidDensity_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidDensity_dTxi;

    redeclare replaceable function extends vapourDensity_dTxi
    external"C" d_v = TILMedia_VLEFluidObjectFunctions_vapourDensity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourDensity_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourDensity_dTxi;

    redeclare replaceable function extends liquidSpecificEnthalpy_dTxi
    external"C" h_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEnthalpy_dTxi;

    redeclare replaceable function extends vapourSpecificEnthalpy_dTxi
    external"C" h_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEnthalpy_dTxi;

    redeclare replaceable function extends liquidPressure_dTxi
    external"C" p_l = TILMedia_VLEFluidObjectFunctions_liquidPressure_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidPressure_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidPressure_dTxi;

    redeclare replaceable function extends vapourPressure_dTxi
    external"C" p_v = TILMedia_VLEFluidObjectFunctions_vapourPressure_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourPressure_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourPressure_dTxi;

    redeclare replaceable function extends liquidSpecificEntropy_dTxi
    external"C" s_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEntropy_dTxi;

    redeclare replaceable function extends vapourSpecificEntropy_dTxi
    external"C" s_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEntropy_dTxi;

    redeclare replaceable function extends liquidMassFraction_dTxin
    external"C" xi_l = TILMedia_VLEFluidObjectFunctions_liquidMassFraction_dTxin(
        d,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidMassFraction_dTxin(double,double,double*,int, void*) { return 0.0; }");
    end liquidMassFraction_dTxin;

    redeclare replaceable function extends vapourMassFraction_dTxin
    external"C" xi_v = TILMedia_VLEFluidObjectFunctions_vapourMassFraction_dTxin(
        d,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourMassFraction_dTxin(double,double,double*,int, void*) { return 0.0; }");
    end vapourMassFraction_dTxin;

    redeclare replaceable function extends liquidSpecificHeatCapacity_dTxi
    external"C" cp_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificHeatCapacity_dTxi;

    redeclare replaceable function extends vapourSpecificHeatCapacity_dTxi
    external"C" cp_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificHeatCapacity_dTxi;

    redeclare replaceable function extends
    liquidIsobaricThermalExpansionCoefficient_dTxi
    external"C" beta_l = TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsobaricThermalExpansionCoefficient_dTxi;

    redeclare replaceable function extends
    vapourIsobaricThermalExpansionCoefficient_dTxi
    external"C" beta_v = TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsobaricThermalExpansionCoefficient_dTxi;

    redeclare replaceable function extends liquidIsothermalCompressibility_dTxi

    external"C" kappa_l = TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_dTxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsothermalCompressibility_dTxi;

    redeclare replaceable function extends vapourIsothermalCompressibility_dTxi

    external"C" kappa_v = TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_dTxi(
        d,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_dTxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsothermalCompressibility_dTxi;

    redeclare replaceable function density_phxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.density_phxi;
    redeclare replaceable function specificEntropy_phxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEntropy_phxi;
    redeclare replaceable function temperature_phxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.temperature_phxi;
    redeclare replaceable function extends moleFraction_phxin
    external"C" x = TILMedia_VLEFluidObjectFunctions_moleFraction_phxin(
        p,
        h,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_moleFraction_phxin(double,double,double*,int, void*) { return 0.0; }");
    end moleFraction_phxin;

    redeclare replaceable function extends steamMassFraction_phxi
    external"C" q = TILMedia_VLEFluidObjectFunctions_steamMassFraction_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_steamMassFraction_phxi(double,double,double*,void*) { return 0.0; }");
    end steamMassFraction_phxi;

    redeclare replaceable function extends specificIsobaricHeatCapacity_phxi
    external"C" cp = TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_phxi(double,double,double*,void*) { return 0.0; }");
    end specificIsobaricHeatCapacity_phxi;

    redeclare replaceable function extends specificIsochoricHeatCapacity_phxi
    external"C" cv = TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_phxi(double,double,double*,void*) { return 0.0; }");
    end specificIsochoricHeatCapacity_phxi;

    redeclare replaceable function extends
    isobaricThermalExpansionCoefficient_phxi
    external"C" beta = TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_phxi(double,double,double*,void*) { return 0.0; }");
    end isobaricThermalExpansionCoefficient_phxi;

    redeclare replaceable function extends isothermalCompressibility_phxi
    external"C" kappa = TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_phxi(double,double,double*,void*) { return 0.0; }");
    end isothermalCompressibility_phxi;

    redeclare replaceable function extends speedOfSound_phxi
    external"C" w = TILMedia_VLEFluidObjectFunctions_speedOfSound_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_speedOfSound_phxi(double,double,double*,void*) { return 0.0; }");
    end speedOfSound_phxi;

    redeclare replaceable function extends
    densityDerivativeWRTspecificEnthalpy_phxi
    external"C" drhodh_pxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_phxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTspecificEnthalpy_phxi;

    redeclare replaceable function extends densityDerivativeWRTpressure_phxi
    external"C" drhodp_hxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_phxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTpressure_phxi;

    redeclare replaceable function extends
    densityDerivativeWRTmassFraction_phxin
    external"C" drhodxi_ph = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_phxin(
        p,
        h,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_phxin(double,double,double*,int, void*) { return 0.0; }");
    end densityDerivativeWRTmassFraction_phxin;

    redeclare replaceable function extends heatCapacityRatio_phxi
    external"C" gamma = TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_phxi(double,double,double*,void*) { return 0.0; }");
    end heatCapacityRatio_phxi;

    redeclare replaceable function extends prandtlNumber_phxi
    external"C" Pr = TILMedia_VLEFluidObjectFunctions_prandtlNumber_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_prandtlNumber_phxi(double,double,double*,void*) { return 0.0; }");
    end prandtlNumber_phxi;

    redeclare replaceable function extends thermalConductivity_phxi
    external"C" lambda = TILMedia_VLEFluidObjectFunctions_thermalConductivity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_thermalConductivity_phxi(double,double,double*,void*) { return 0.0; }");
    end thermalConductivity_phxi;

    redeclare replaceable function extends dynamicViscosity_phxi
    external"C" eta = TILMedia_VLEFluidObjectFunctions_dynamicViscosity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_dynamicViscosity_phxi(double,double,double*,void*) { return 0.0; }");
    end dynamicViscosity_phxi;

    redeclare replaceable function extends surfaceTension_phxi
    external"C" sigma = TILMedia_VLEFluidObjectFunctions_surfaceTension_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_surfaceTension_phxi(double,double,double*,void*) { return 0.0; }");
    end surfaceTension_phxi;

    redeclare replaceable function extends liquidDensity_phxi
    external"C" d_l = TILMedia_VLEFluidObjectFunctions_liquidDensity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidDensity_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidDensity_phxi;

    redeclare replaceable function extends vapourDensity_phxi
    external"C" d_v = TILMedia_VLEFluidObjectFunctions_vapourDensity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourDensity_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourDensity_phxi;

    redeclare replaceable function extends liquidSpecificEnthalpy_phxi
    external"C" h_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEnthalpy_phxi;

    redeclare replaceable function extends vapourSpecificEnthalpy_phxi
    external"C" h_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEnthalpy_phxi;

    redeclare replaceable function extends liquidSpecificEntropy_phxi
    external"C" s_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEntropy_phxi;

    redeclare replaceable function extends vapourSpecificEntropy_phxi
    external"C" s_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEntropy_phxi;

    redeclare replaceable function extends liquidTemperature_phxi
    external"C" T_l = TILMedia_VLEFluidObjectFunctions_liquidTemperature_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidTemperature_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidTemperature_phxi;

    redeclare replaceable function extends vapourTemperature_phxi
    external"C" T_v = TILMedia_VLEFluidObjectFunctions_vapourTemperature_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourTemperature_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourTemperature_phxi;

    redeclare replaceable function extends liquidMassFraction_phxin
    external"C" xi_l = TILMedia_VLEFluidObjectFunctions_liquidMassFraction_phxin(
        p,
        h,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidMassFraction_phxin(double,double,double*,int, void*);");
    end liquidMassFraction_phxin;

    redeclare replaceable function extends vapourMassFraction_phxin
    external"C" xi_v = TILMedia_VLEFluidObjectFunctions_vapourMassFraction_phxin(
        p,
        h,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourMassFraction_phxin(double,double,double*,int, void*);");
    end vapourMassFraction_phxin;

    redeclare replaceable function extends liquidSpecificHeatCapacity_phxi
    external"C" cp_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificHeatCapacity_phxi;

    redeclare replaceable function extends vapourSpecificHeatCapacity_phxi
    external"C" cp_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificHeatCapacity_phxi;

    redeclare replaceable function extends
    liquidIsobaricThermalExpansionCoefficient_phxi
    external"C" beta_l = TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsobaricThermalExpansionCoefficient_phxi;

    redeclare replaceable function extends
    vapourIsobaricThermalExpansionCoefficient_phxi
    external"C" beta_v = TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsobaricThermalExpansionCoefficient_phxi;

    redeclare replaceable function extends liquidIsothermalCompressibility_phxi

    external"C" kappa_l = TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_phxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsothermalCompressibility_phxi;

    redeclare replaceable function extends vapourIsothermalCompressibility_phxi

    external"C" kappa_v = TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_phxi(
        p,
        h,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_phxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsothermalCompressibility_phxi;

    redeclare replaceable function density_psxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.density_psxi;
    redeclare replaceable function specificEnthalpy_psxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEnthalpy_psxi;
    redeclare replaceable function temperature_psxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.temperature_psxi;
    redeclare replaceable function extends moleFraction_psxin
    external"C" x = TILMedia_VLEFluidObjectFunctions_moleFraction_psxin(
        p,
        s,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_moleFraction_psxin(double,double,double*,int, void*);");
    end moleFraction_psxin;

    redeclare replaceable function extends steamMassFraction_psxi
    external"C" q = TILMedia_VLEFluidObjectFunctions_steamMassFraction_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_steamMassFraction_psxi(double,double,double*,void*) { return 0.0; }");
    end steamMassFraction_psxi;

    redeclare replaceable function extends specificIsobaricHeatCapacity_psxi
    external"C" cp = TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_psxi(double,double,double*,void*) { return 0.0; }");
    end specificIsobaricHeatCapacity_psxi;

    redeclare replaceable function extends specificIsochoricHeatCapacity_psxi
    external"C" cv = TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_psxi(double,double,double*,void*) { return 0.0; }");
    end specificIsochoricHeatCapacity_psxi;

    redeclare replaceable function extends
    isobaricThermalExpansionCoefficient_psxi
    external"C" beta = TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_psxi(double,double,double*,void*) { return 0.0; }");
    end isobaricThermalExpansionCoefficient_psxi;

    redeclare replaceable function extends isothermalCompressibility_psxi
    external"C" kappa = TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_psxi(double,double,double*,void*) { return 0.0; }");
    end isothermalCompressibility_psxi;

    redeclare replaceable function extends speedOfSound_psxi
    external"C" w = TILMedia_VLEFluidObjectFunctions_speedOfSound_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_speedOfSound_psxi(double,double,double*,void*) { return 0.0; }");
    end speedOfSound_psxi;

    redeclare replaceable function extends
    densityDerivativeWRTspecificEnthalpy_psxi
    external"C" drhodh_pxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_psxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTspecificEnthalpy_psxi;

    redeclare replaceable function extends densityDerivativeWRTpressure_psxi
    external"C" drhodp_hxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_psxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTpressure_psxi;

    redeclare replaceable function extends
    densityDerivativeWRTmassFraction_psxin
    external"C" drhodxi_ph = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_psxin(
        p,
        s,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_psxin(double,double,double*,int, void*);");
    end densityDerivativeWRTmassFraction_psxin;

    redeclare replaceable function extends heatCapacityRatio_psxi
    external"C" gamma = TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_psxi(double,double,double*,void*) { return 0.0; }");
    end heatCapacityRatio_psxi;

    redeclare replaceable function extends prandtlNumber_psxi
    external"C" Pr = TILMedia_VLEFluidObjectFunctions_prandtlNumber_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_prandtlNumber_psxi(double,double,double*,void*) { return 0.0; }");
    end prandtlNumber_psxi;

    redeclare replaceable function extends thermalConductivity_psxi
    external"C" lambda = TILMedia_VLEFluidObjectFunctions_thermalConductivity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_thermalConductivity_psxi(double,double,double*,void*) { return 0.0; }");
    end thermalConductivity_psxi;

    redeclare replaceable function extends dynamicViscosity_psxi
    external"C" eta = TILMedia_VLEFluidObjectFunctions_dynamicViscosity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dynamicViscosity_psxi(double,double,double*,void*) { return 0.0; }");
    end dynamicViscosity_psxi;

    redeclare replaceable function extends surfaceTension_psxi
    external"C" sigma = TILMedia_VLEFluidObjectFunctions_surfaceTension_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_surfaceTension_psxi(double,double,double*,void*) { return 0.0; }");
    end surfaceTension_psxi;

    redeclare replaceable function extends liquidDensity_psxi
    external"C" d_l = TILMedia_VLEFluidObjectFunctions_liquidDensity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidDensity_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidDensity_psxi;

    redeclare replaceable function extends vapourDensity_psxi
    external"C" d_v = TILMedia_VLEFluidObjectFunctions_vapourDensity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourDensity_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourDensity_psxi;

    redeclare replaceable function extends liquidSpecificEnthalpy_psxi
    external"C" h_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEnthalpy_psxi;

    redeclare replaceable function extends vapourSpecificEnthalpy_psxi
    external"C" h_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEnthalpy_psxi;

    redeclare replaceable function extends liquidSpecificEntropy_psxi
    external"C" s_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEntropy_psxi;

    redeclare replaceable function extends vapourSpecificEntropy_psxi
    external"C" s_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEntropy_psxi;

    redeclare replaceable function extends liquidTemperature_psxi
    external"C" T_l = TILMedia_VLEFluidObjectFunctions_liquidTemperature_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidTemperature_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidTemperature_psxi;

    redeclare replaceable function extends vapourTemperature_psxi
    external"C" T_v = TILMedia_VLEFluidObjectFunctions_vapourTemperature_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourTemperature_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourTemperature_psxi;

    redeclare replaceable function extends liquidMassFraction_psxin
    external"C" xi_l = TILMedia_VLEFluidObjectFunctions_liquidMassFraction_psxin(
        p,
        s,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidMassFraction_psxin(double,double,double*,int, void*);");
    end liquidMassFraction_psxin;

    redeclare replaceable function extends vapourMassFraction_psxin
    external"C" xi_v = TILMedia_VLEFluidObjectFunctions_vapourMassFraction_psxin(
        p,
        s,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourMassFraction_psxin(double,double,double*,int, void*);");
    end vapourMassFraction_psxin;

    redeclare replaceable function extends liquidSpecificHeatCapacity_psxi
    external"C" cp_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificHeatCapacity_psxi;

    redeclare replaceable function extends vapourSpecificHeatCapacity_psxi
    external"C" cp_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificHeatCapacity_psxi;

    redeclare replaceable function extends
    liquidIsobaricThermalExpansionCoefficient_psxi
    external"C" beta_l = TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsobaricThermalExpansionCoefficient_psxi;

    redeclare replaceable function extends
    vapourIsobaricThermalExpansionCoefficient_psxi
    external"C" beta_v = TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsobaricThermalExpansionCoefficient_psxi;

    redeclare replaceable function extends liquidIsothermalCompressibility_psxi

    external"C" kappa_l = TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_psxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsothermalCompressibility_psxi;

    redeclare replaceable function extends vapourIsothermalCompressibility_psxi

    external"C" kappa_v = TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_psxi(
        p,
        s,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_psxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsothermalCompressibility_psxi;

    redeclare replaceable function density_pTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.density_pTxi;
    redeclare replaceable function specificEnthalpy_pTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEnthalpy_pTxi;
    redeclare replaceable function specificEntropy_pTxi =
      .TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEntropy_pTxi;
    redeclare replaceable function extends moleFraction_pTxin
    external"C" x = TILMedia_VLEFluidObjectFunctions_moleFraction_pTxin(
        p,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_moleFraction_pTxin(double,double,double*,int, void*);");
    end moleFraction_pTxin;

    redeclare replaceable function extends steamMassFraction_pTxi
    external"C" q = TILMedia_VLEFluidObjectFunctions_steamMassFraction_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_steamMassFraction_pTxi(double,double,double*,void*) { return 0.0; }");
    end steamMassFraction_pTxi;

    redeclare replaceable function extends specificIsobaricHeatCapacity_pTxi
    external"C" cp = TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_specificIsobaricHeatCapacity_pTxi(double,double,double*,void*) { return 0.0; }");
    end specificIsobaricHeatCapacity_pTxi;

    redeclare replaceable function extends specificIsochoricHeatCapacity_pTxi
    external"C" cv = TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_specificIsochoricHeatCapacity_pTxi(double,double,double*,void*) { return 0.0; }");
    end specificIsochoricHeatCapacity_pTxi;

    redeclare replaceable function extends
    isobaricThermalExpansionCoefficient_pTxi
    external"C" beta = TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_isobaricThermalExpansionCoefficient_pTxi(double,double,double*,void*) { return 0.0; }");
    end isobaricThermalExpansionCoefficient_pTxi;

    redeclare replaceable function extends isothermalCompressibility_pTxi
    external"C" kappa = TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_isothermalCompressibility_pTxi(double,double,double*,void*) { return 0.0; }");
    end isothermalCompressibility_pTxi;

    redeclare replaceable function extends speedOfSound_pTxi
    external"C" w = TILMedia_VLEFluidObjectFunctions_speedOfSound_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_speedOfSound_pTxi(double,double,double*,void*) { return 0.0; }");
    end speedOfSound_pTxi;

    redeclare replaceable function extends
    densityDerivativeWRTspecificEnthalpy_pTxi
    external"C" drhodh_pxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTspecificEnthalpy_pTxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTspecificEnthalpy_pTxi;

    redeclare replaceable function extends densityDerivativeWRTpressure_pTxi
    external"C" drhodp_hxi = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTpressure_pTxi(double,double,double*,void*) { return 0.0; }");
    end densityDerivativeWRTpressure_pTxi;

    redeclare replaceable function extends
    densityDerivativeWRTmassFraction_pTxin
    external"C" drhodxi_ph = TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_pTxin(
        p,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_densityDerivativeWRTmassFraction_pTxin(double,double,double*,int, void*);");
    end densityDerivativeWRTmassFraction_pTxin;

    redeclare replaceable function extends heatCapacityRatio_pTxi
    external"C" gamma = TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_heatCapacityRatio_pTxi(double,double,double*,void*) { return 0.0; }");
    end heatCapacityRatio_pTxi;

    redeclare replaceable function extends prandtlNumber_pTxi
    external"C" Pr = TILMedia_VLEFluidObjectFunctions_prandtlNumber_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_prandtlNumber_pTxi(double,double,double*,void*) { return 0.0; }");
    end prandtlNumber_pTxi;

    redeclare replaceable function extends thermalConductivity_pTxi
    external"C" lambda = TILMedia_VLEFluidObjectFunctions_thermalConductivity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_thermalConductivity_pTxi(double,double,double*,void*) { return 0.0; }");
    end thermalConductivity_pTxi;

    redeclare replaceable function extends dynamicViscosity_pTxi
    external"C" eta = TILMedia_VLEFluidObjectFunctions_dynamicViscosity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dynamicViscosity_pTxi(double,double,double*,void*) { return 0.0; }");
    end dynamicViscosity_pTxi;

    redeclare replaceable function extends surfaceTension_pTxi
    external"C" sigma = TILMedia_VLEFluidObjectFunctions_surfaceTension_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_surfaceTension_pTxi(double,double,double*,void*) { return 0.0; }");
    end surfaceTension_pTxi;

    redeclare replaceable function extends liquidDensity_pTxi
    external"C" d_l = TILMedia_VLEFluidObjectFunctions_liquidDensity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidDensity_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidDensity_pTxi;

    redeclare replaceable function extends vapourDensity_pTxi
    external"C" d_v = TILMedia_VLEFluidObjectFunctions_vapourDensity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourDensity_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourDensity_pTxi;

    redeclare replaceable function extends liquidSpecificEnthalpy_pTxi
    external"C" h_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEnthalpy_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEnthalpy_pTxi;

    redeclare replaceable function extends vapourSpecificEnthalpy_pTxi
    external"C" h_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEnthalpy_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEnthalpy_pTxi;

    redeclare replaceable function extends liquidSpecificEntropy_pTxi
    external"C" s_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificEntropy_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificEntropy_pTxi;

    redeclare replaceable function extends vapourSpecificEntropy_pTxi
    external"C" s_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificEntropy_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificEntropy_pTxi;

    redeclare replaceable function extends liquidTemperature_pTxi
    external"C" T_l = TILMedia_VLEFluidObjectFunctions_liquidTemperature_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidTemperature_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidTemperature_pTxi;

    redeclare replaceable function extends vapourTemperature_pTxi
    external"C" T_v = TILMedia_VLEFluidObjectFunctions_vapourTemperature_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourTemperature_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourTemperature_pTxi;

    redeclare replaceable function extends liquidMassFraction_pTxin
    external"C" xi_l = TILMedia_VLEFluidObjectFunctions_liquidMassFraction_pTxin(
        p,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidMassFraction_pTxin(double,double,double*,int, void*);");
    end liquidMassFraction_pTxin;

    redeclare replaceable function extends vapourMassFraction_pTxin
    external"C" xi_v = TILMedia_VLEFluidObjectFunctions_vapourMassFraction_pTxin(
        p,
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourMassFraction_pTxin(double,double,double*,int, void*);");
    end vapourMassFraction_pTxin;

    redeclare replaceable function extends liquidSpecificHeatCapacity_pTxi
    external"C" cp_l = TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidSpecificHeatCapacity_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidSpecificHeatCapacity_pTxi;

    redeclare replaceable function extends vapourSpecificHeatCapacity_pTxi
    external"C" cp_v = TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourSpecificHeatCapacity_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourSpecificHeatCapacity_pTxi;

    redeclare replaceable function extends
    liquidIsobaricThermalExpansionCoefficient_pTxi
    external"C" beta_l = TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidIsobaricThermalExpansionCoefficient_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsobaricThermalExpansionCoefficient_pTxi;

    redeclare replaceable function extends
    vapourIsobaricThermalExpansionCoefficient_pTxi
    external"C" beta_v = TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourIsobaricThermalExpansionCoefficient_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsobaricThermalExpansionCoefficient_pTxi;

    redeclare replaceable function extends liquidIsothermalCompressibility_pTxi

    external"C" kappa_l = TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_liquidIsothermalCompressibility_pTxi(double,double,double*,void*) { return 0.0; }");
    end liquidIsothermalCompressibility_pTxi;

    redeclare replaceable function extends vapourIsothermalCompressibility_pTxi

    external"C" kappa_v = TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_pTxi(
        p,
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_vapourIsothermalCompressibility_pTxi(double,double,double*,void*) { return 0.0; }");
    end vapourIsothermalCompressibility_pTxi;


    redeclare replaceable function extends dewDensity_Txi
    external"C" d_dew = TILMedia_VLEFluidObjectFunctions_dewDensity_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewDensity_Txi(double,double*,void*) { return 0.0; }");
    end dewDensity_Txi;

    redeclare replaceable function extends bubbleDensity_Txi
    external"C" d_bubble = TILMedia_VLEFluidObjectFunctions_bubbleDensity_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleDensity_Txi(double,double*,void*) { return 0.0; }");
    end bubbleDensity_Txi;

    redeclare replaceable function extends dewSpecificEnthalpy_Txi
    external"C" h_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificEnthalpy_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificEnthalpy_Txi(double,double*,void*) { return 0.0; }");
    end dewSpecificEnthalpy_Txi;

    redeclare replaceable function extends bubbleSpecificEnthalpy_Txi
    external"C" h_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificEnthalpy_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificEnthalpy_Txi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificEnthalpy_Txi;

    redeclare replaceable function extends dewPressure_Txi
    external"C" p_dew = TILMedia_VLEFluidObjectFunctions_dewPressure_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewPressure_Txi(double,double*,void*) { return 0.0; }");
    end dewPressure_Txi;

    redeclare replaceable function extends bubblePressure_Txi
    external"C" p_bubble = TILMedia_VLEFluidObjectFunctions_bubblePressure_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubblePressure_Txi(double,double*,void*) { return 0.0; }");
    end bubblePressure_Txi;

    redeclare replaceable function extends dewSpecificEntropy_Txi
    external"C" s_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificEntropy_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificEntropy_Txi(double,double*,void*) { return 0.0; }");
    end dewSpecificEntropy_Txi;

    redeclare replaceable function extends bubbleSpecificEntropy_Txi
    external"C" s_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificEntropy_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificEntropy_Txi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificEntropy_Txi;

    redeclare replaceable function extends dewLiquidMassFraction_Txin
    external"C" xi_ldew = TILMedia_VLEFluidObjectFunctions_dewLiquidMassFraction_Txin(
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewLiquidMassFraction_Txin(double,double*,int, void*);");
    end dewLiquidMassFraction_Txin;

    redeclare replaceable function extends bubbleVapourMassFraction_Txin
    external"C" xi_vbubble = TILMedia_VLEFluidObjectFunctions_bubbleVapourMassFraction_Txin(
        T,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleVapourMassFraction_Txin(double,double*,int, void*);");
    end bubbleVapourMassFraction_Txin;

    redeclare replaceable function extends dewSpecificIsobaricHeatCapacity_Txi
    external"C" cp_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificIsobaricHeatCapacity_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificIsobaricHeatCapacity_Txi(double,double*,void*) { return 0.0; }");
    end dewSpecificIsobaricHeatCapacity_Txi;

    redeclare replaceable function extends
    bubbleSpecificIsobaricHeatCapacity_Txi
    external"C" cp_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificIsobaricHeatCapacity_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificIsobaricHeatCapacity_Txi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificIsobaricHeatCapacity_Txi;

    redeclare replaceable function extends
    dewIsobaricThermalExpansionCoefficient_Txi
    external"C" beta_dew = TILMedia_VLEFluidObjectFunctions_dewIsobaricThermalExpansionCoefficient_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewIsobaricThermalExpansionCoefficient_Txi(double,double*,void*) { return 0.0; }");
    end dewIsobaricThermalExpansionCoefficient_Txi;

    redeclare replaceable function extends
    bubbleIsobaricThermalExpansionCoefficient_Txi
    external"C" beta_bubble = TILMedia_VLEFluidObjectFunctions_bubbleIsobaricThermalExpansionCoefficient_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleIsobaricThermalExpansionCoefficient_Txi(double,double*,void*) { return 0.0; }");
    end bubbleIsobaricThermalExpansionCoefficient_Txi;

    redeclare replaceable function extends dewIsothermalCompressibility_Txi
    external"C" kappa_dew = TILMedia_VLEFluidObjectFunctions_dewIsothermalCompressibility_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewIsothermalCompressibility_Txi(double,double*,void*) { return 0.0; }");
    end dewIsothermalCompressibility_Txi;

    redeclare replaceable function extends bubbleIsothermalCompressibility_Txi
    external"C" kappa_bubble = TILMedia_VLEFluidObjectFunctions_bubbleIsothermalCompressibility_Txi(
        T,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleIsothermalCompressibility_Txi(double,double*,void*) { return 0.0; }");
    end bubbleIsothermalCompressibility_Txi;

    redeclare replaceable function extends dewDensity_pxi
    external"C" d_dew = TILMedia_VLEFluidObjectFunctions_dewDensity_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewDensity_pxi(double,double*,void*) { return 0.0; }");
    end dewDensity_pxi;

    redeclare replaceable function extends bubbleDensity_pxi
    external"C" d_bubble = TILMedia_VLEFluidObjectFunctions_bubbleDensity_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleDensity_pxi(double,double*,void*) { return 0.0; }");
    end bubbleDensity_pxi;

    redeclare replaceable function extends dewSpecificEnthalpy_pxi
    external"C" h_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificEnthalpy_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificEnthalpy_pxi(double,double*,void*) { return 0.0; }");
    end dewSpecificEnthalpy_pxi;

    redeclare replaceable function extends bubbleSpecificEnthalpy_pxi
    external"C" h_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificEnthalpy_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificEnthalpy_pxi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificEnthalpy_pxi;

    redeclare replaceable function extends dewSpecificEntropy_pxi
    external"C" s_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificEntropy_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificEntropy_pxi(double,double*,void*) { return 0.0; }");
    end dewSpecificEntropy_pxi;

    redeclare replaceable function extends bubbleSpecificEntropy_pxi
    external"C" s_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificEntropy_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificEntropy_pxi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificEntropy_pxi;

    redeclare replaceable function extends dewTemperature_pxi
    external"C" T_dew = TILMedia_VLEFluidObjectFunctions_dewTemperature_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewTemperature_pxi(double,double*,void*) { return 0.0; }");
    end dewTemperature_pxi;

    redeclare replaceable function extends bubbleTemperature_pxi
    external"C" T_bubble = TILMedia_VLEFluidObjectFunctions_bubbleTemperature_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleTemperature_pxi(double,double*,void*) { return 0.0; }");
    end bubbleTemperature_pxi;

    redeclare replaceable function extends dewLiquidMassFraction_pxin
    external"C" xi_ldew = TILMedia_VLEFluidObjectFunctions_dewLiquidMassFraction_pxin(
        p,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewLiquidMassFraction_pxin(double,double*,int, void*);");
    end dewLiquidMassFraction_pxin;

    redeclare replaceable function extends bubbleVapourMassFraction_pxin
    external"C" xi_vbubble = TILMedia_VLEFluidObjectFunctions_bubbleVapourMassFraction_pxin(
        p,
        xi,
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleVapourMassFraction_pxin(double,double*,int, void*);");
    end bubbleVapourMassFraction_pxin;

    redeclare replaceable function extends dewSpecificIsobaricHeatCapacity_pxi
    external"C" cp_dew = TILMedia_VLEFluidObjectFunctions_dewSpecificIsobaricHeatCapacity_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewSpecificIsobaricHeatCapacity_pxi(double,double*,void*) { return 0.0; }");
    end dewSpecificIsobaricHeatCapacity_pxi;

    redeclare replaceable function extends
    bubbleSpecificIsobaricHeatCapacity_pxi
    external"C" cp_bubble = TILMedia_VLEFluidObjectFunctions_bubbleSpecificIsobaricHeatCapacity_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleSpecificIsobaricHeatCapacity_pxi(double,double*,void*) { return 0.0; }");
    end bubbleSpecificIsobaricHeatCapacity_pxi;

    redeclare replaceable function extends
    dewIsobaricThermalExpansionCoefficient_pxi
    external"C" beta_dew = TILMedia_VLEFluidObjectFunctions_dewIsobaricThermalExpansionCoefficient_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewIsobaricThermalExpansionCoefficient_pxi(double,double*,void*) { return 0.0; }");
    end dewIsobaricThermalExpansionCoefficient_pxi;

    redeclare replaceable function extends
    bubbleIsobaricThermalExpansionCoefficient_pxi
    external"C" beta_bubble = TILMedia_VLEFluidObjectFunctions_bubbleIsobaricThermalExpansionCoefficient_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleIsobaricThermalExpansionCoefficient_pxi(double,double*,void*) { return 0.0; }");
    end bubbleIsobaricThermalExpansionCoefficient_pxi;

    redeclare replaceable function extends dewIsothermalCompressibility_pxi
    external"C" kappa_dew = TILMedia_VLEFluidObjectFunctions_dewIsothermalCompressibility_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_dewIsothermalCompressibility_pxi(double,double*,void*) { return 0.0; }");
    end dewIsothermalCompressibility_pxi;

    redeclare replaceable function extends bubbleIsothermalCompressibility_pxi
    external"C" kappa_bubble = TILMedia_VLEFluidObjectFunctions_bubbleIsothermalCompressibility_pxi(
        p,
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_bubbleIsothermalCompressibility_pxi(double,double*,void*) { return 0.0; }");
    end bubbleIsothermalCompressibility_pxi;



    redeclare replaceable function extends averageMolarMass_xi
    external"C" M = TILMedia_VLEFluidObjectFunctions_averageMolarMass_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_averageMolarMass_xi(double*,void*) { return 0.0; }");
    end averageMolarMass_xi;

    redeclare replaceable function extends criticalDensity_xi
    external"C" dc = TILMedia_VLEFluidObjectFunctions_criticalDensity_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalDensity_xi(double*,void*) { return 0.0; }");
    end criticalDensity_xi;

    redeclare replaceable function extends criticalSpecificEnthalpy_xi
    external"C" hc = TILMedia_VLEFluidObjectFunctions_criticalSpecificEnthalpy_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalSpecificEnthalpy_xi(double*,void*) { return 0.0; }");
    end criticalSpecificEnthalpy_xi;

    redeclare replaceable function extends criticalPressure_xi
    external"C" pc = TILMedia_VLEFluidObjectFunctions_criticalPressure_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalPressure_xi(double*,void*) { return 0.0; }");
    end criticalPressure_xi;

    redeclare replaceable function extends criticalSpecificEntropy_xi
    external"C" sc = TILMedia_VLEFluidObjectFunctions_criticalSpecificEntropy_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalSpecificEntropy_xi(double*,void*) { return 0.0; }");
    end criticalSpecificEntropy_xi;

    redeclare replaceable function extends criticalTemperature_xi
    external"C" Tc = TILMedia_VLEFluidObjectFunctions_criticalTemperature_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalTemperature_xi(double*,void*) { return 0.0; }");
    end criticalTemperature_xi;

    redeclare replaceable function extends
    criticalSpecificIsobaricHeatCapacity_xi
    external"C" cpc = TILMedia_VLEFluidObjectFunctions_criticalSpecificIsobaricHeatCapacity_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalSpecificIsobaricHeatCapacity_xi(double*,void*) { return 0.0; }");
    end criticalSpecificIsobaricHeatCapacity_xi;

    redeclare replaceable function extends
    criticalIsobaricThermalExpansionCoefficient_xi
    external"C" betac = TILMedia_VLEFluidObjectFunctions_criticalIsobaricThermalExpansionCoefficient_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalIsobaricThermalExpansionCoefficient_xi(double*,void*) { return 0.0; }");
    end criticalIsobaricThermalExpansionCoefficient_xi;

    redeclare replaceable function extends criticalIsothermalCompressibility_xi

    external"C" kappac = TILMedia_VLEFluidObjectFunctions_criticalIsothermalCompressibility_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalIsothermalCompressibility_xi(double*,void*) { return 0.0; }");
    end criticalIsothermalCompressibility_xi;

    redeclare replaceable function extends criticalThermalConductivity_xi
    external"C" lambdac = TILMedia_VLEFluidObjectFunctions_criticalThermalConductivity_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalThermalConductivity_xi(double*,void*) { return 0.0; }");
    end criticalThermalConductivity_xi;

    redeclare replaceable function extends criticalDynamicViscosity_xi
    external"C" etac = TILMedia_VLEFluidObjectFunctions_criticalDynamicViscosity_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalDynamicViscosity_xi(double*,void*) { return 0.0; }");
    end criticalDynamicViscosity_xi;

    redeclare replaceable function extends criticalSurfaceTension_xi
    external"C" sigmac = TILMedia_VLEFluidObjectFunctions_criticalSurfaceTension_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_criticalSurfaceTension_xi(double*,void*) { return 0.0; }");
    end criticalSurfaceTension_xi;

    redeclare replaceable function extends cricondenbarTemperature_xi
    external"C" T_ccb = TILMedia_VLEFluidObjectFunctions_cricondenbarTemperature_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_cricondenbarTemperature_xi(double*,void*) { return 0.0; }");
    end cricondenbarTemperature_xi;

    redeclare replaceable function extends cricondenthermTemperature_xi
    external"C" T_cct = TILMedia_VLEFluidObjectFunctions_cricondenthermTemperature_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_cricondenthermTemperature_xi(double*,void*) { return 0.0; }");
    end cricondenthermTemperature_xi;

    redeclare replaceable function extends cricondenbarPressure_xi
    external"C" p_ccb = TILMedia_VLEFluidObjectFunctions_cricondenbarPressure_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_cricondenbarPressure_xi(double*,void*) { return 0.0; }");
    end cricondenbarPressure_xi;

    redeclare replaceable function extends cricondenthermPressure_xi
    external"C" p_cct = TILMedia_VLEFluidObjectFunctions_cricondenthermPressure_xi(
        xi,
        vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_cricondenthermPressure_xi(double*,void*) { return 0.0; }");
    end cricondenthermPressure_xi;

    redeclare replaceable function extends molarMass_n
    external"C" M_i = TILMedia_VLEFluidObjectFunctions_molarMass_n(
        compNo, vleFluidPointer) annotation (
          __iti_dllNoExport=true,
          Include=
"static double TILMedia_VLEFluidObjectFunctions_molarMass_n(int, void*) { return 0.0; }");
    end molarMass_n;

  end VLEFluidObjectFunctions;

  package VLEFluidTypes
  "VLEFluids and VLEFluid mixtures, that can be used or composed in TILMedia"
  extends .TILMedia.Internals.ClassTypes.ModelPackage;

    record BaseVLEFluid "Base record for VLEFluid definitions"
      extends .TILMedia.Internals.ClassTypes.Record;
      constant Boolean fixedMixingRatio = true
        "Treat medium as pseudo pure in Modelica if it is a mixture"
        annotation(Dialog, HideResult = true);
      constant Integer nc_propertyCalculation(min=1) = 1
        "Number of components for fluid property calculations"
        annotation(Dialog, HideResult = true);
      final constant Integer nc=if fixedMixingRatio then 1 else nc_propertyCalculation
        "Number of components in Modelica models"
        annotation(Evaluate=true, HideResult = true);
      parameter .TILMedia.Internals.VLEFluidName[:] vleFluidNames = {""}
        "Array of VLEFluid names e.g. {\"vleFluidName\"} for pure component"
        annotation(Dialog, choices);
      parameter Real[nc_propertyCalculation] mixingRatio_propertyCalculation = {1}
        "Mixing ratio for fluid property calculation (={1} for pure components)"
        annotation(Dialog, HideResult = true);
      final parameter Real[nc] defaultMixingRatio = if fixedMixingRatio then {1} else mixingRatio_propertyCalculation
        "Default composition for models in Modelica (={1} for pure components)"
        annotation(HideResult = true);
      final parameter Real xi_default[nc-1] = defaultMixingRatio[1:end-1]/sum(defaultMixingRatio)
        "Default mass fractions"
        annotation(HideResult = true);
      final parameter String concatVLEFluidName=.TILMedia.Internals.concatNames(vleFluidNames)
        annotation(Dialog(tab="Internals"));
      constant Integer ID=0
        "ID is used to map the selected VLEFluid to the sim.cumulatedVLEFluidMass array item" annotation(HideResult = true);
      annotation (Documentation(info="<html>
<p><br>Every VLEFluid substance model contains a substance record as replaceable parameter extending from this base VLEFluid model. The substance record contains the following parameters: </p>
<ul>
<li>fixedMixingRatio - Boolean = true, if mixing ratio is fixed during simulation. </li>
<li>nc_propertyCalculation - Integer with number of components which are calculated. </li>
<li>&QUOT;substanceNames&QUOT; - VLEFluidName 1, VLEFluidName 2, and so on. Array which lists the substance names. </li>
<li>mixingRatio_propertyCalculation - Array with the mixing ratio of all substances. </li>
</ul>
<p><b>Access additional substances:</b> </p>
<p>To acces the properties of an additional substance, it is possible to create a new substance reccord. For more information on the acces of additional propeties see the <a href=\"modelica://TILMedia.UsersGuide.SubstanceRecord\">substance record documentation</a>. </p>
<p>Furthermore it is possible to parameterize this VLEFluide base record, using a VLEFluid substance name, listed in the <a href=\"modelica://TILMedia.UsersGuide.SubstanceNames\">substance names documentation</a>. An example how to parameterize the base VLEFluid model is shown below. However note that this is only a local configuration and therefore only accesible in the corresponding model.</p>
<p><img src=\"modelica://TILMedia/Images/Base_VLE_Parameter_frame.PNG\"/> </p>
</html>"));
    end BaseVLEFluid;

    record TILMedia_Water "TILMedia.Water"
      extends TILMedia.VLEFluidTypes.BaseVLEFluid(
        final fixedMixingRatio=true,
        final nc_propertyCalculation=1,
        final vleFluidNames={"TILMedia.Water"},
        final mixingRatio_propertyCalculation={1});
    end TILMedia_Water;

    record TILMedia_SplineWater
      "Water, IAPWS1995, Bicubic Spline Interpolation, table based calculation (TLK Implementation)"
      extends TILMedia.VLEFluidTypes.BaseVLEFluid(
        final fixedMixingRatio=true,
        final nc_propertyCalculation=1,
        final vleFluidNames={"Interpolation.LoadSpline(filename=\"" +
            Modelica.Utilities.Files.loadResource(
            "Modelica://TILMedia/Resources/WATER_SPLINE.DAT") + "\")"},
        final mixingRatio_propertyCalculation={1});
    end TILMedia_SplineWater;
    annotation(Protection(access=Access.nonPackageDuplicate));
  end VLEFluidTypes;

  package Internals "Internal functions"

    package ClassTypes "Icon definitions"

      partial class ModelPackage
        annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
                imageSource="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",
                fileName="modelica://TILMedia/Images/Icon_Package_Empty.png")}));

      end ModelPackage;

      partial record Record "Partial Record"
        annotation (Icon(graphics={        Text(
                extent={{-100,110},{100,70}},
                lineColor={0,0,0},
                textString=
                     "%name"), Bitmap(
                extent={{-100,-100},{100,100}},
                imageSource="iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAYAAACtWK6eAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA8NJREFUeNrs3cFt2lAcwOHXKFIi5VArl+SYDWADfMwWMEI3cLJBRigjZAPYwGxANvAGqY2aqFKgwQ4E+73vk1BPRNTmJ/v9MfjH6+trALY7swlAICAQEAgIBAQCAgGBgEBAIIBAQCAgEBAICAQEAgIBgYBAQCCAQEAgIBAQCAgEBAICAYGAQACBgEBAICAQEAgIBAQCAgGBgECAbc5P/QIeHx8f6n8Ku+IkVvUjL4qisikcQfhoVD+ebAaBsNv071EcgbBDUUcysxkEwm5PdSRjm0EgbPezfizqSDKbQiCIRCB0YrIlED5hsiUQPmGyFXrwSfq+JpNJyPPc27aF9Xod5vP5V/5EM9kqi6IoHUHAol0giEQgHFqyky2BsK8kJ1sCoY3kJlsCoa2krtkSCOHsrNXbIKlFu0AI19fXbZ+STCQCIVxdXW0+iG0picmWQNhorlIYjUZtnxb9ZEsgvLu/vw83Nzdtnxb1ZEsgvLu8vAyz2SxcXFy0fWq0ky2BcIhIol20C4QPbm9vN6dbLUUZiUDYajwem2wJhP8x2RIIn0h9siUQjrFob0Qx2RIIx4okikW7QNhLqpMtgbC3FCdbAqGV1CZbAqG1lCZbAuG7Fu2NwU22BMJ3RjK4Rft5aju2qqpQlmUy/9djeptsPT8/d4lkEPdGTDKQ5XLpEHAgzWSrwzZ9m2z1fk3iFIsvi3myJRAOItbJlkA45aK90evJlkA4dSS9nmwJhIOK7ZotgXBwMV2zJRCOIpbJ1rldycvLS6jfmH15Oc1ka10UxW9HENiuN5MtgdBHvVm0J3eKlWVZlwXkIDWXgKxWqyFH8qt+PAjkmwNJ5XbSzW2gBxxILzjFAoGAQEAgIBDoCZ+kR+zu7i4URdG717VYLAbzrU5HEBAICAQEAgIBgYBAQCAgEBAIIBAQCAgEBAICAYGAQEAgkILkvnLb/JjafD635zuYTqebr/E6ggACAYGAQEAgIBAQCAgEBAICAYEAHyR3LVZfbwmAIwgIBAQCAgEEAgIBgYBAQCAgEBAICAQEAgIBBAICAYGAQEAgIBAQCAgEBAICAXZJ7ofjqqoKZVna8x2Mx+OQZZlAYg9kuVx6t3fQ/CplaoE4xQKBgEBAICAQEAgIBAQCAgGBAP9K7lKT5lKJyWRiz3fcdgJJYCfnee7djlMsEAgIBAQCAgGBgEBAICAQQCAgEBAICAQEAgIBgYBAQCCAQEAgIBAQCAgEBAICgRgM5pcVmzvTujstjiAgEBAICAQEAgIBBAICAYHA0f0RYABzbuCi+dNNSwAAAABJRU5ErkJggg==",
                fileName="modelica://TILMedia/Images/Icon_Record.png")}));

      end Record;
      annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
              imageSource=
                  "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",
              fileName="modelica://TILMedia/Images/Icon_Package_Internals.png")}));
    end ClassTypes;

    package VLEFluidObjectFunctions
      extends .TILMedia.Internals.ClassTypes.ModelPackage;

      function additionalProperties_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output SI.MassFraction x "Steam mass fraction";
        output SI.SpecificHeatCapacity cp "Specific heat capacity cp";
        output SI.SpecificHeatCapacity cv "Specific heat capacity cv";
        output SI.LinearExpansionCoefficient beta
          "Isobaric expansion coefficient";
        output SI.Compressibility kappa "Isothermal compressibility";
        output .TILMedia.Internals.Units.DensityDerPressure drhodp
          "Derivative of density wrt pressure";
        output .TILMedia.Internals.Units.DensityDerSpecificEnthalpy drhodh
          "Derivative of density wrt specific enthalpy";
        output Real[size(xi,1)] drhodxi "Derivative of density wrt mass fraction";
        output SI.Velocity a "Speed of sound";
        output Real gamma "Heat capacity ratio";
      external "C" TILMedia_VLEFluid_additionalProperties_phxi(
            p,
            h,
            xi, vleFluidPointer,
            x,
            cp,
            cv,
            beta,
            kappa,
            drhodp,
            drhodh,
            drhodxi,
            a,
            gamma)
      annotation(__iti_dllNoExport = true,Include="static void TILMedia_VLEFluid_additionalProperties_phxi(double, double, double*, void*, double*, double*, double*, double*, double*, double*, double*, double*, double*, double*) {}");
                                        annotation(Impure=false);
      end additionalProperties_phxi;

      function transportPropertyRecord_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output SI.PrandtlNumber Pr "Prandtl number";
        output SI.ThermalConductivity lambda "Thermal conductivity";
        output SI.DynamicViscosity eta "Dynamic viscosity";
        output SI.SurfaceTension sigma "Surface tension";
      external "C" TILMedia_VLEFluid_transportProperties_phxi(
            p,
            h,
            xi, vleFluidPointer,
            Pr,
            lambda,
            eta,
            sigma)
      annotation(__iti_dllNoExport = true,Include="void TILMedia_VLEFluid_transportProperties_phxi(double, double, double*, void*, double*, double*, double*, double*);");
                                        annotation(Impure=false);
      end transportPropertyRecord_phxi;

      function VLETransportPropertyRecord_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output SI.PrandtlNumber Pr_l "Prandtl number";
        output SI.PrandtlNumber Pr_v "Prandtl number";
        output SI.ThermalConductivity lambda_l "Thermal conductivity";
        output SI.ThermalConductivity lambda_v "Thermal conductivity";
        output SI.DynamicViscosity eta_l "Dynamic viscosity";
        output SI.DynamicViscosity eta_v "Dynamic viscosity";
      external "C" TILMedia_VLEFluid_VLETransportProperties_phxi(
            p,
            h,
            xi, vleFluidPointer,
            Pr_l,
            Pr_v,
            lambda_l,
            lambda_v,
            eta_l,
            eta_v)
      annotation(__iti_dllNoExport = true,Include="void TILMedia_VLEFluid_VLETransportProperties_phxi(double, double, double*, void*, double*, double*, double*, double*, double*, double*);");
                                        annotation(Impure=false);
      end VLETransportPropertyRecord_phxi;

      function VLEAdditionalProperties_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output SI.SpecificHeatCapacity cp_l
          "Specific heat capacity cp";
        output SI.LinearExpansionCoefficient beta_l
          "Isobaric expansion coefficient";
        output SI.Compressibility kappa_l
          "Isothermal compressibility";
        output SI.SpecificHeatCapacity cp_v
          "Specific heat capacity cp";
        output SI.LinearExpansionCoefficient beta_v
          "Isobaric expansion coefficient";
        output SI.Compressibility kappa_v
          "Isothermal compressibility";
      external "C" TILMedia_VLEFluid_VLEAdditionalProperties_phxi(
            p,
            h,
            xi, vleFluidPointer,
        cp_l, beta_l, kappa_l,
        cp_v, beta_v, kappa_v)
      annotation(__iti_dllNoExport = true,Include="void TILMedia_VLEFluid_VLEAdditionalProperties_phxi(double, double, double*, void*,double*, double*, double*, double*, double*, double*);");
                                        annotation(Impure=false);
      end VLEAdditionalProperties_phxi;

      function VLEProperties_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output SI.Density d_l "Density";
        output SI.SpecificEnthalpy h_l "Specific enthalpy";
        output SI.AbsolutePressure p_l "Pressure";
        output SI.SpecificEntropy s_l "Specific entropy";
        output SI.Temperature T_l "Temperature";
        output SI.MassFraction[size(xi,1)] xi_l "Mass fractions";
        output SI.Density d_v "Density";
        output SI.SpecificEnthalpy h_v "Specific enthalpy";
        output SI.AbsolutePressure p_v "Pressure";
        output SI.SpecificEntropy s_v "Specific entropy";
        output SI.Temperature T_v "Temperature";
        output SI.MassFraction[size(xi,1)] xi_v "Mass fractions";
      external "C" TILMedia_VLEFluid_VLEProperties_phxi(
            p,
            h,
            xi, vleFluidPointer,
        d_l, h_l, p_l, s_l, T_l, xi_l,
        d_v, h_v, p_v, s_v, T_v, xi_v)
      annotation(__iti_dllNoExport = true,Include="static void TILMedia_VLEFluid_VLEProperties_phxi(double, double, double*, void*, double*, double*, double*, double*, double*, double*,
                double*, double*, double*, double*, double*, double*) {}");
               annotation(Impure=false);
      end VLEProperties_phxi;

      function cricondenbar_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
        input SI.MassFraction[:] xi
          "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.TILMediaExternalObject
          vleFluidPointer;
        output Real d,h,p,s,T;
      external "C" TILMedia_VLEFluid_cricondenbar_xi(
            xi, vleFluidPointer,
            d,
            h,
            p,
            s,
            T)
      annotation(__iti_dllNoExport = true,Include="static void TILMedia_VLEFluid_cricondenbar_xi(double*, void*, double*, double*, double*, double*, double*) {}");
                                                                                                            annotation(Impure=false);
      end cricondenbar_xi;

      package PureComponentDerivatives
        extends .TILMedia.Internals.ClassTypes.ModelPackage;

        function specificEntropy_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEntropy s "Specific Entropy";
        external "C" s = TILMedia_VLEFluid_Cached_specificEntropy_dTxi(
              d,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEntropy_dTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEntropy_dTxi,
          Impure=false);

        end specificEntropy_dTxi;

        function der_specificEntropy_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_d "Derivative of Density";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_s "Derivative of Specific Entropy";
        external "C" der_s = TILMedia_VLEFluid_Cached_der_specificEntropy_dTxi(
              d,
              T,
              xi,
              der_d,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEntropy_dTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEntropy_dTxi;

        function specificEnthalpy_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEnthalpy h "Specific Enthalpy";
        external "C" h = TILMedia_VLEFluid_Cached_specificEnthalpy_dTxi(
              d,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEnthalpy_dTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEnthalpy_dTxi,Impure=false);
        end specificEnthalpy_dTxi;

        function der_specificEnthalpy_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_d "Derivative of Density";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_h "Derivative of Specific Enthalpy";
        external "C" der_h = TILMedia_VLEFluid_Cached_der_specificEnthalpy_dTxi(
              d,
              T,
              xi,
              der_d,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEnthalpy_dTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEnthalpy_dTxi;

        function pressure_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.AbsolutePressure p "Pressure";
        external "C" p = TILMedia_VLEFluid_Cached_pressure_dTxi(
              d,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_pressure_dTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_pressure_dTxi,
          inverse(d=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.density_pTxi(p, T, xi, vleFluidPointer)),Impure=false);
        end pressure_dTxi;

        function der_pressure_dTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.Density d "Density";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_d "Derivative of Density";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_p "Derivative of Pressure";
        external "C" der_p = TILMedia_VLEFluid_Cached_der_pressure_dTxi(
              d,
              T,
              xi,
              der_d,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_pressure_dTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_pressure_dTxi;

        function temperature_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.Temperature T "Temperature";
        external "C" T = TILMedia_VLEFluid_Cached_temperature_psxi(
              p,
              s,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_temperature_psxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_temperature_psxi,
          inverse(s=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEntropy_pTxi(p, T, xi, vleFluidPointer)),Impure=false);
        end temperature_psxi;

        function der_temperature_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_s "Derivative of Specific Entropy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_T "Derivative of Temperature";
        external "C" der_T = TILMedia_VLEFluid_Cached_der_temperature_psxi(
              p,
              s,
              xi,
              der_p,
              der_s,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_temperature_psxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_temperature_psxi;

        function density_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.Density d "Density";
        external "C" d = TILMedia_VLEFluid_Cached_density_psxi(
              p,
              s,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_density_psxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_density_psxi,Impure=false);
        end density_psxi;

        function der_density_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_s "Derivative of Specific Entropy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_d "Derivative of Density";
        external "C" der_d = TILMedia_VLEFluid_Cached_der_density_psxi(
              p,
              s,
              xi,
              der_p,
              der_s,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_density_psxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_density_psxi;

        function specificEnthalpy_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEnthalpy h "Specific Enthalpy";
        external "C" h = TILMedia_VLEFluid_Cached_specificEnthalpy_psxi(
              p,
              s,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEnthalpy_psxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEnthalpy_psxi, inverse(s=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEntropy_phxi(p, h, xi, vleFluidPointer)),Impure=false);
        end specificEnthalpy_psxi;

        function der_specificEnthalpy_psxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEntropy s "Specific Entropy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_s "Derivative of Specific Entropy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_h "Derivative of Specific Enthalpy";
        external "C" der_h = TILMedia_VLEFluid_Cached_der_specificEnthalpy_psxi(
              p,
              s,
              xi,
              der_p,
              der_s,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEnthalpy_psxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEnthalpy_psxi;

        function temperature_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.Temperature T "Temperature";
        external "C" T = TILMedia_VLEFluid_Cached_temperature_phxi(
              p,
              h,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_temperature_phxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_temperature_phxi, inverse(h=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEnthalpy_pTxi(p, T, xi, vleFluidPointer)),Impure=false);
        end temperature_phxi;

        function der_temperature_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_h "Derivative of Specific Enthalpy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_T "Derivative of Temperature";
        external "C" der_T = TILMedia_VLEFluid_Cached_der_temperature_phxi(
              p,
              h,
              xi,
              der_p,
              der_h,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_temperature_phxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_temperature_phxi;

        function specificEntropy_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEntropy s "Specific Entropy";
        external "C" s = TILMedia_VLEFluid_Cached_specificEntropy_phxi(
              p,
              h,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEntropy_phxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEntropy_phxi, inverse(h=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.specificEnthalpy_psxi(p, s, xi, vleFluidPointer)),Impure=false);
        end specificEntropy_phxi;

        function der_specificEntropy_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_h "Derivative of Specific Enthalpy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_s "Derivative of Specific Entropy";
        external "C" der_s = TILMedia_VLEFluid_Cached_der_specificEntropy_phxi(
              p,
              h,
              xi,
              der_p,
              der_h,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEntropy_phxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEntropy_phxi;

        function density_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.Density d "Density";
        external "C" d = TILMedia_VLEFluid_Cached_density_phxi(
              p,
              h,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_density_phxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_density_phxi,Impure=false);
        end density_phxi;

        function der_density_phxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.SpecificEnthalpy h "Specific Enthalpy";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_h "Derivative of Specific Enthalpy";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_d "Derivative of Density";
        external "C" der_d = TILMedia_VLEFluid_Cached_der_density_phxi(
              p,
              h,
              xi,
              der_p,
              der_h,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_density_phxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_density_phxi;

        function specificEntropy_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEntropy s "Specific Entropy";
        external "C" s = TILMedia_VLEFluid_Cached_specificEntropy_pTxi(
              p,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEntropy_pTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEntropy_pTxi, inverse(T=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.temperature_psxi(p, s, xi, vleFluidPointer)),Impure=false);
        end specificEntropy_pTxi;

        function der_specificEntropy_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_s "Derivative of Specific Entropy";
        external "C" der_s = TILMedia_VLEFluid_Cached_der_specificEntropy_pTxi(
              p,
              T,
              xi,
              der_p,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEntropy_pTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEntropy_pTxi;

        function density_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.Density d "Density";
        external "C" d = TILMedia_VLEFluid_Cached_density_pTxi(
              p,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_density_pTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_density_pTxi);
        end density_pTxi;

        function der_density_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_d "Derivative of Density";
        external "C" der_d = TILMedia_VLEFluid_Cached_der_density_pTxi(
              p,
              T,
              xi,
              der_p,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_density_pTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_density_pTxi;

        function specificEnthalpy_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         output SI.SpecificEnthalpy h "Specific Enthalpy";
        external "C" h = TILMedia_VLEFluid_Cached_specificEnthalpy_pTxi(
              p,
              T,
              xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_specificEnthalpy_pTxi(double, double, double*, void*) { return 0.0; }");
        annotation(derivative(noDerivative=vleFluidPointer)=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.der_specificEnthalpy_pTxi, inverse(T=TILMedia.Internals.VLEFluidObjectFunctions.PureComponentDerivatives.temperature_phxi(p, h, xi, vleFluidPointer)),Impure=false);
        end specificEnthalpy_pTxi;

        function der_specificEnthalpy_pTxi
          extends .TILMedia.BaseClasses.PartialVLEFluidObjectFunction;
         input SI.AbsolutePressure p "Pressure";
         input SI.Temperature T "Temperature";
         input SI.MassFraction[:] xi
            "Mass fractions of the first nc-1 components";
          input .TILMedia.Internals.TILMediaExternalObject
            vleFluidPointer;
         input Real der_p "Derivative of Pressure";
         input Real der_T "Derivative of Temperature";
         input Real[:] der_xi
            "Derivative of Mass fractions of the first nc-1 components";
         output Real der_h "Derivative of Specific Enthalpy";
        external "C" der_h = TILMedia_VLEFluid_Cached_der_specificEnthalpy_pTxi(
              p,
              T,
              xi,
              der_p,
              der_T,
              der_xi, vleFluidPointer)
        annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluid_Cached_der_specificEnthalpy_pTxi(double, double, double*, double, double, double*, void*) { return 0.0; }");
                                          annotation(Impure=false);
        end der_specificEnthalpy_pTxi;
      end PureComponentDerivatives;
    end VLEFluidObjectFunctions;

    package VLEFluidFunctions
      extends .TILMedia.Internals.ClassTypes.ModelPackage;

      function specificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      external"C" h = TILMedia_VLEFluidFunctions_specificEnthalpy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEnthalpy_dTxi(double, double, double*,const char*, int);");
      end specificEnthalpy_dTxi;

      function pressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p "Pressure";
      external"C" p = TILMedia_VLEFluidFunctions_pressure_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_pressure_dTxi(double, double, double*,const char*, int);");
      end pressure_dTxi;

      function specificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s "Specific entropy";
      external"C" s = TILMedia_VLEFluidFunctions_specificEntropy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEntropy_dTxi(double, double, double*,const char*, int);");
      end specificEntropy_dTxi;

      function moleFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MoleFraction x "Mole fraction";
      external"C" x = TILMedia_VLEFluidFunctions_moleFraction_dTxin(
          d,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_moleFraction_dTxin(double, double, double*,int, const char*, int);");
      end moleFraction_dTxin;

      function steamMassFraction_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      external"C" q = TILMedia_VLEFluidFunctions_steamMassFraction_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_steamMassFraction_dTxi(double, double, double*,const char*, int);");
      end steamMassFraction_dTxi;

      function specificIsobaricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      external"C" cp = TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_dTxi(double, double, double*,const char*, int);");
      end specificIsobaricHeatCapacity_dTxi;

      function specificIsochoricHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      external"C" cv = TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_dTxi(double, double, double*,const char*, int);");
      end specificIsochoricHeatCapacity_dTxi;

      function isobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      external"C" beta = TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_dTxi(double, double, double*,const char*, int);");
      end isobaricThermalExpansionCoefficient_dTxi;

      function isothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa "Isothermal compressibility";
      external"C" kappa = TILMedia_VLEFluidFunctions_isothermalCompressibility_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isothermalCompressibility_dTxi(double, double, double*,const char*, int);");
      end isothermalCompressibility_dTxi;

      function speedOfSound_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Velocity w "Speed of sound";
      external"C" w = TILMedia_VLEFluidFunctions_speedOfSound_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_speedOfSound_dTxi(double, double, double*,const char*, int);");
      end speedOfSound_dTxi;

      function densityDerivativeWRTspecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      external"C" drhodh_pxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_dTxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTspecificEnthalpy_dTxi;

      function densityDerivativeWRTpressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      external"C" drhodp_hxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_dTxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTpressure_dTxi;

      function densityDerivativeWRTmassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      external"C" drhodxi_ph = TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_dTxin(
          d,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_dTxin(double, double, double*,int, const char*, int);");
      end densityDerivativeWRTmassFraction_dTxin;

      function heatCapacityRatio_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      external"C" gamma = TILMedia_VLEFluidFunctions_heatCapacityRatio_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_heatCapacityRatio_dTxi(double, double, double*,const char*, int);");
      end heatCapacityRatio_dTxi;

      function prandtlNumber_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.PrandtlNumber Pr "Prandtl number";
      external"C" Pr = TILMedia_VLEFluidFunctions_prandtlNumber_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_prandtlNumber_dTxi(double, double, double*,const char*, int);");
      end prandtlNumber_dTxi;

      function thermalConductivity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      external"C" lambda = TILMedia_VLEFluidFunctions_thermalConductivity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_thermalConductivity_dTxi(double, double, double*,const char*, int);");
      end thermalConductivity_dTxi;

      function dynamicViscosity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      external"C" eta = TILMedia_VLEFluidFunctions_dynamicViscosity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dynamicViscosity_dTxi(double, double, double*,const char*, int);");
      end dynamicViscosity_dTxi;

      function surfaceTension_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SurfaceTension sigma "Surface tension";
      external"C" sigma = TILMedia_VLEFluidFunctions_surfaceTension_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_surfaceTension_dTxi(double, double, double*,const char*, int);");
      end surfaceTension_dTxi;

      function liquidDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_l "Density of liquid phase";
      external"C" d_l = TILMedia_VLEFluidFunctions_liquidDensity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidDensity_dTxi(double, double, double*,const char*, int);");
      end liquidDensity_dTxi;

      function vapourDensity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_v "Density of vapour phase";
      external"C" d_v = TILMedia_VLEFluidFunctions_vapourDensity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourDensity_dTxi(double, double, double*,const char*, int);");
      end vapourDensity_dTxi;

      function liquidSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      external"C" h_l = TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_dTxi(double, double, double*,const char*, int);");
      end liquidSpecificEnthalpy_dTxi;

      function vapourSpecificEnthalpy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      external"C" h_v = TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_dTxi(double, double, double*,const char*, int);");
      end vapourSpecificEnthalpy_dTxi;

      function liquidPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_l "Pressure of liquid phase";
      external"C" p_l = TILMedia_VLEFluidFunctions_liquidPressure_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidPressure_dTxi(double, double, double*,const char*, int);");
      end liquidPressure_dTxi;

      function vapourPressure_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_v "Pressure of vapour phase";
      external"C" p_v = TILMedia_VLEFluidFunctions_vapourPressure_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourPressure_dTxi(double, double, double*,const char*, int);");
      end vapourPressure_dTxi;

      function liquidSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      external"C" s_l = TILMedia_VLEFluidFunctions_liquidSpecificEntropy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEntropy_dTxi(double, double, double*,const char*, int);");
      end liquidSpecificEntropy_dTxi;

      function vapourSpecificEntropy_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      external"C" s_v = TILMedia_VLEFluidFunctions_vapourSpecificEntropy_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEntropy_dTxi(double, double, double*,const char*, int);");
      end vapourSpecificEntropy_dTxi;

      function liquidMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      external"C" xi_l = TILMedia_VLEFluidFunctions_liquidMassFraction_dTxin(
          d,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidMassFraction_dTxin(double, double, double*,int, const char*, int);");
      end liquidMassFraction_dTxin;

      function vapourMassFraction_dTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      external"C" xi_v = TILMedia_VLEFluidFunctions_vapourMassFraction_dTxin(
          d,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourMassFraction_dTxin(double, double, double*,int, const char*, int);");
      end vapourMassFraction_dTxin;

      function liquidSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      external"C" cp_l = TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_dTxi(double, double, double*,const char*, int);");
      end liquidSpecificHeatCapacity_dTxi;

      function vapourSpecificHeatCapacity_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      external"C" cp_v = TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_dTxi(double, double, double*,const char*, int);");
      end vapourSpecificHeatCapacity_dTxi;

      function liquidIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      external"C" beta_l = TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_dTxi(double, double, double*,const char*, int);");
      end liquidIsobaricThermalExpansionCoefficient_dTxi;

      function vapourIsobaricThermalExpansionCoefficient_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      external"C" beta_v = TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_dTxi(double, double, double*,const char*, int);");
      end vapourIsobaricThermalExpansionCoefficient_dTxi;

      function liquidIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      external"C" kappa_l = TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_dTxi(double, double, double*,const char*, int);");
      end liquidIsothermalCompressibility_dTxi;

      function vapourIsothermalCompressibility_dTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Density d "Density";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      external"C" kappa_v = TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_dTxi(
          d,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_dTxi(double, double, double*,const char*, int);");
      end vapourIsothermalCompressibility_dTxi;

      function density_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d "Density";
      external"C" d = TILMedia_VLEFluidFunctions_density_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_density_phxi(double, double, double*,const char*, int);");
      end density_phxi;

      function specificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s "Specific entropy";
      external"C" s = TILMedia_VLEFluidFunctions_specificEntropy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEntropy_phxi(double, double, double*,const char*, int);");
      end specificEntropy_phxi;

      function temperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T "Temperature";
      external"C" T = TILMedia_VLEFluidFunctions_temperature_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_temperature_phxi(double, double, double*,const char*, int);");
      end temperature_phxi;

      function moleFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MoleFraction x "Mole fraction";
      external"C" x = TILMedia_VLEFluidFunctions_moleFraction_phxin(
          p,
          h,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_moleFraction_phxin(double, double, double*,int, const char*, int);");
      end moleFraction_phxin;

      function steamMassFraction_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      external"C" q = TILMedia_VLEFluidFunctions_steamMassFraction_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_steamMassFraction_phxi(double, double, double*,const char*, int);");
      end steamMassFraction_phxi;

      function specificIsobaricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      external"C" cp = TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_phxi(double, double, double*,const char*, int);");
      end specificIsobaricHeatCapacity_phxi;

      function specificIsochoricHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      external"C" cv = TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_phxi(double, double, double*,const char*, int);");
      end specificIsochoricHeatCapacity_phxi;

      function isobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      external"C" beta = TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_phxi(double, double, double*,const char*, int);");
      end isobaricThermalExpansionCoefficient_phxi;

      function isothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa "Isothermal compressibility";
      external"C" kappa = TILMedia_VLEFluidFunctions_isothermalCompressibility_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isothermalCompressibility_phxi(double, double, double*,const char*, int);");
      end isothermalCompressibility_phxi;

      function speedOfSound_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Velocity w "Speed of sound";
      external"C" w = TILMedia_VLEFluidFunctions_speedOfSound_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_speedOfSound_phxi(double, double, double*,const char*, int);");
      end speedOfSound_phxi;

      function densityDerivativeWRTspecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      external"C" drhodh_pxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_phxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTspecificEnthalpy_phxi;

      function densityDerivativeWRTpressure_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      external"C" drhodp_hxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_phxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTpressure_phxi;

      function densityDerivativeWRTmassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      external"C" drhodxi_ph = TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_phxin(
          p,
          h,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_phxin(double, double, double*,int, const char*, int);");
      end densityDerivativeWRTmassFraction_phxin;

      function heatCapacityRatio_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      external"C" gamma = TILMedia_VLEFluidFunctions_heatCapacityRatio_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_heatCapacityRatio_phxi(double, double, double*,const char*, int);");
      end heatCapacityRatio_phxi;

      function prandtlNumber_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.PrandtlNumber Pr "Prandtl number";
      external"C" Pr = TILMedia_VLEFluidFunctions_prandtlNumber_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_prandtlNumber_phxi(double, double, double*,const char*, int);");
      end prandtlNumber_phxi;

      function thermalConductivity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      external"C" lambda = TILMedia_VLEFluidFunctions_thermalConductivity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_thermalConductivity_phxi(double, double, double*,const char*, int);");
      end thermalConductivity_phxi;

      function dynamicViscosity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      external"C" eta = TILMedia_VLEFluidFunctions_dynamicViscosity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dynamicViscosity_phxi(double, double, double*,const char*, int);");
      end dynamicViscosity_phxi;

      function surfaceTension_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SurfaceTension sigma "Surface tension";
      external"C" sigma = TILMedia_VLEFluidFunctions_surfaceTension_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_surfaceTension_phxi(double, double, double*,const char*, int);");
      end surfaceTension_phxi;

      function liquidDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_l "Density of liquid phase";
      external"C" d_l = TILMedia_VLEFluidFunctions_liquidDensity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidDensity_phxi(double, double, double*,const char*, int);");
      end liquidDensity_phxi;

      function vapourDensity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_v "Density of vapour phase";
      external"C" d_v = TILMedia_VLEFluidFunctions_vapourDensity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourDensity_phxi(double, double, double*,const char*, int);");
      end vapourDensity_phxi;

      function liquidSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      external"C" h_l = TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_phxi(double, double, double*,const char*, int);");
      end liquidSpecificEnthalpy_phxi;

      function vapourSpecificEnthalpy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      external"C" h_v = TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_phxi(double, double, double*,const char*, int);");
      end vapourSpecificEnthalpy_phxi;

      function liquidSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      external"C" s_l = TILMedia_VLEFluidFunctions_liquidSpecificEntropy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEntropy_phxi(double, double, double*,const char*, int);");
      end liquidSpecificEntropy_phxi;

      function vapourSpecificEntropy_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      external"C" s_v = TILMedia_VLEFluidFunctions_vapourSpecificEntropy_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEntropy_phxi(double, double, double*,const char*, int);");
      end vapourSpecificEntropy_phxi;

      function liquidTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_l "Temperature of liquid phase";
      external"C" T_l = TILMedia_VLEFluidFunctions_liquidTemperature_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidTemperature_phxi(double, double, double*,const char*, int);");
      end liquidTemperature_phxi;

      function vapourTemperature_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_v "Temperature of vapour phase";
      external"C" T_v = TILMedia_VLEFluidFunctions_vapourTemperature_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourTemperature_phxi(double, double, double*,const char*, int);");
      end vapourTemperature_phxi;

      function liquidMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      external"C" xi_l = TILMedia_VLEFluidFunctions_liquidMassFraction_phxin(
          p,
          h,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidMassFraction_phxin(double, double, double*,int, const char*, int);");
      end liquidMassFraction_phxin;

      function vapourMassFraction_phxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      external"C" xi_v = TILMedia_VLEFluidFunctions_vapourMassFraction_phxin(
          p,
          h,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourMassFraction_phxin(double, double, double*,int, const char*, int);");
      end vapourMassFraction_phxin;

      function liquidSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      external"C" cp_l = TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_phxi(double, double, double*,const char*, int);");
      end liquidSpecificHeatCapacity_phxi;

      function vapourSpecificHeatCapacity_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      external"C" cp_v = TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_phxi(double, double, double*,const char*, int);");
      end vapourSpecificHeatCapacity_phxi;

      function liquidIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      external"C" beta_l = TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_phxi(double, double, double*,const char*, int);");
      end liquidIsobaricThermalExpansionCoefficient_phxi;

      function vapourIsobaricThermalExpansionCoefficient_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      external"C" beta_v = TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_phxi(double, double, double*,const char*, int);");
      end vapourIsobaricThermalExpansionCoefficient_phxi;

      function liquidIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      external"C" kappa_l = TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_phxi(double, double, double*,const char*, int);");
      end liquidIsothermalCompressibility_phxi;

      function vapourIsothermalCompressibility_phxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEnthalpy h "Specific enthalpy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      external"C" kappa_v = TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_phxi(
          p,
          h,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_phxi(double, double, double*,const char*, int);");
      end vapourIsothermalCompressibility_phxi;

      function density_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d "Density";
      external"C" d = TILMedia_VLEFluidFunctions_density_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_density_psxi(double, double, double*,const char*, int);");
      end density_psxi;

      function specificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      external"C" h = TILMedia_VLEFluidFunctions_specificEnthalpy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEnthalpy_psxi(double, double, double*,const char*, int);");
      end specificEnthalpy_psxi;

      function temperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T "Temperature";
      external"C" T = TILMedia_VLEFluidFunctions_temperature_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_temperature_psxi(double, double, double*,const char*, int);");
      end temperature_psxi;

      function moleFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MoleFraction x "Mole fraction";
      external"C" x = TILMedia_VLEFluidFunctions_moleFraction_psxin(
          p,
          s,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_moleFraction_psxin(double, double, double*,int, const char*, int);");
      end moleFraction_psxin;

      function steamMassFraction_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      external"C" q = TILMedia_VLEFluidFunctions_steamMassFraction_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_steamMassFraction_psxi(double, double, double*,const char*, int);");
      end steamMassFraction_psxi;

      function specificIsobaricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      external"C" cp = TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_psxi(double, double, double*,const char*, int);");
      end specificIsobaricHeatCapacity_psxi;

      function specificIsochoricHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      external"C" cv = TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_psxi(double, double, double*,const char*, int);");
      end specificIsochoricHeatCapacity_psxi;

      function isobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      external"C" beta = TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_psxi(double, double, double*,const char*, int);");
      end isobaricThermalExpansionCoefficient_psxi;

      function isothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa "Isothermal compressibility";
      external"C" kappa = TILMedia_VLEFluidFunctions_isothermalCompressibility_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isothermalCompressibility_psxi(double, double, double*,const char*, int);");
      end isothermalCompressibility_psxi;

      function speedOfSound_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Velocity w "Speed of sound";
      external"C" w = TILMedia_VLEFluidFunctions_speedOfSound_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_speedOfSound_psxi(double, double, double*,const char*, int);");
      end speedOfSound_psxi;

      function densityDerivativeWRTspecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      external"C" drhodh_pxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_psxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTspecificEnthalpy_psxi;

      function densityDerivativeWRTpressure_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      external"C" drhodp_hxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_psxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTpressure_psxi;

      function densityDerivativeWRTmassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      external"C" drhodxi_ph = TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_psxin(
          p,
          s,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_psxin(double, double, double*,int, const char*, int);");
      end densityDerivativeWRTmassFraction_psxin;

      function heatCapacityRatio_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      external"C" gamma = TILMedia_VLEFluidFunctions_heatCapacityRatio_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_heatCapacityRatio_psxi(double, double, double*,const char*, int);");
      end heatCapacityRatio_psxi;

      function prandtlNumber_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.PrandtlNumber Pr "Prandtl number";
      external"C" Pr = TILMedia_VLEFluidFunctions_prandtlNumber_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_prandtlNumber_psxi(double, double, double*,const char*, int);");
      end prandtlNumber_psxi;

      function thermalConductivity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      external"C" lambda = TILMedia_VLEFluidFunctions_thermalConductivity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_thermalConductivity_psxi(double, double, double*,const char*, int);");
      end thermalConductivity_psxi;

      function dynamicViscosity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      external"C" eta = TILMedia_VLEFluidFunctions_dynamicViscosity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dynamicViscosity_psxi(double, double, double*,const char*, int);");
      end dynamicViscosity_psxi;

      function surfaceTension_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SurfaceTension sigma "Surface tension";
      external"C" sigma = TILMedia_VLEFluidFunctions_surfaceTension_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_surfaceTension_psxi(double, double, double*,const char*, int);");
      end surfaceTension_psxi;

      function liquidDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_l "Density of liquid phase";
      external"C" d_l = TILMedia_VLEFluidFunctions_liquidDensity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidDensity_psxi(double, double, double*,const char*, int);");
      end liquidDensity_psxi;

      function vapourDensity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_v "Density of vapour phase";
      external"C" d_v = TILMedia_VLEFluidFunctions_vapourDensity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourDensity_psxi(double, double, double*,const char*, int);");
      end vapourDensity_psxi;

      function liquidSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      external"C" h_l = TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_psxi(double, double, double*,const char*, int);");
      end liquidSpecificEnthalpy_psxi;

      function vapourSpecificEnthalpy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      external"C" h_v = TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_psxi(double, double, double*,const char*, int);");
      end vapourSpecificEnthalpy_psxi;

      function liquidSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      external"C" s_l = TILMedia_VLEFluidFunctions_liquidSpecificEntropy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEntropy_psxi(double, double, double*,const char*, int);");
      end liquidSpecificEntropy_psxi;

      function vapourSpecificEntropy_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      external"C" s_v = TILMedia_VLEFluidFunctions_vapourSpecificEntropy_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEntropy_psxi(double, double, double*,const char*, int);");
      end vapourSpecificEntropy_psxi;

      function liquidTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_l "Temperature of liquid phase";
      external"C" T_l = TILMedia_VLEFluidFunctions_liquidTemperature_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidTemperature_psxi(double, double, double*,const char*, int);");
      end liquidTemperature_psxi;

      function vapourTemperature_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_v "Temperature of vapour phase";
      external"C" T_v = TILMedia_VLEFluidFunctions_vapourTemperature_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourTemperature_psxi(double, double, double*,const char*, int);");
      end vapourTemperature_psxi;

      function liquidMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      external"C" xi_l = TILMedia_VLEFluidFunctions_liquidMassFraction_psxin(
          p,
          s,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidMassFraction_psxin(double, double, double*,int, const char*, int);");
      end liquidMassFraction_psxin;

      function vapourMassFraction_psxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      external"C" xi_v = TILMedia_VLEFluidFunctions_vapourMassFraction_psxin(
          p,
          s,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourMassFraction_psxin(double, double, double*,int, const char*, int);");
      end vapourMassFraction_psxin;

      function liquidSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      external"C" cp_l = TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_psxi(double, double, double*,const char*, int);");
      end liquidSpecificHeatCapacity_psxi;

      function vapourSpecificHeatCapacity_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      external"C" cp_v = TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_psxi(double, double, double*,const char*, int);");
      end vapourSpecificHeatCapacity_psxi;

      function liquidIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      external"C" beta_l = TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_psxi(double, double, double*,const char*, int);");
      end liquidIsobaricThermalExpansionCoefficient_psxi;

      function vapourIsobaricThermalExpansionCoefficient_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      external"C" beta_v = TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_psxi(double, double, double*,const char*, int);");
      end vapourIsobaricThermalExpansionCoefficient_psxi;

      function liquidIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      external"C" kappa_l = TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_psxi(double, double, double*,const char*, int);");
      end liquidIsothermalCompressibility_psxi;

      function vapourIsothermalCompressibility_psxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.SpecificEntropy s "Specific entropy";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      external"C" kappa_v = TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_psxi(
          p,
          s,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_psxi(double, double, double*,const char*, int);");
      end vapourIsothermalCompressibility_psxi;

      function density_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d "Density";
      external"C" d = TILMedia_VLEFluidFunctions_density_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_density_pTxi(double, double, double*,const char*, int);");
      end density_pTxi;

      function specificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h "Specific enthalpy";
      external"C" h = TILMedia_VLEFluidFunctions_specificEnthalpy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEnthalpy_pTxi(double, double, double*,const char*, int) { return 0.0; }");
      end specificEnthalpy_pTxi;

      function specificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s "Specific entropy";
      external"C" s = TILMedia_VLEFluidFunctions_specificEntropy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificEntropy_pTxi(double, double, double*,const char*, int);");
      end specificEntropy_pTxi;

      function moleFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MoleFraction x "Mole fraction";
      external"C" x = TILMedia_VLEFluidFunctions_moleFraction_pTxin(
          p,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_moleFraction_pTxin(double, double, double*,int, const char*, int);");
      end moleFraction_pTxin;

      function steamMassFraction_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction q "Vapor quality (steam mass fraction)";
      external"C" q = TILMedia_VLEFluidFunctions_steamMassFraction_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_steamMassFraction_pTxi(double, double, double*,const char*, int);");
      end steamMassFraction_pTxi;

      function specificIsobaricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp "Specific isobaric heat capacity cp";
      external"C" cp = TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsobaricHeatCapacity_pTxi(double, double, double*,const char*, int);");
      end specificIsobaricHeatCapacity_pTxi;

      function specificIsochoricHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cv "Specific isochoric heat capacity cv";
      external"C" cv = TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_specificIsochoricHeatCapacity_pTxi(double, double, double*,const char*, int);");
      end specificIsochoricHeatCapacity_pTxi;

      function isobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta "Isobaric thermal expansion coefficient";
      external"C" beta = TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isobaricThermalExpansionCoefficient_pTxi(double, double, double*,const char*, int);");
      end isobaricThermalExpansionCoefficient_pTxi;

      function isothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa "Isothermal compressibility";
      external"C" kappa = TILMedia_VLEFluidFunctions_isothermalCompressibility_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_isothermalCompressibility_pTxi(double, double, double*,const char*, int);");
      end isothermalCompressibility_pTxi;

      function speedOfSound_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Velocity w "Speed of sound";
      external"C" w = TILMedia_VLEFluidFunctions_speedOfSound_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_speedOfSound_pTxi(double, double, double*,const char*, int);");
      end speedOfSound_pTxi;

      function densityDerivativeWRTspecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByEnthalpy drhodh_pxi "Derivative of density wrt specific enthalpy at constant pressure and mass fraction";
      external"C" drhodh_pxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTspecificEnthalpy_pTxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTspecificEnthalpy_pTxi;

      function densityDerivativeWRTpressure_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DerDensityByPressure drhodp_hxi "Derivative of density wrt pressure at specific enthalpy and mass fraction";
      external"C" drhodp_hxi = TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTpressure_pTxi(double, double, double*,const char*, int);");
      end densityDerivativeWRTpressure_pTxi;

      function densityDerivativeWRTmassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density drhodxi_ph "Derivative of density wrt mass fraction of water at constant pressure and specific enthalpy";
      external"C" drhodxi_ph = TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_pTxin(
          p,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_densityDerivativeWRTmassFraction_pTxin(double, double, double*,int, const char*, int);");
      end densityDerivativeWRTmassFraction_pTxin;

      function heatCapacityRatio_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.IsentropicExponent gamma "Heat capacity ratio aka isentropic expansion factor";
      external"C" gamma = TILMedia_VLEFluidFunctions_heatCapacityRatio_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_heatCapacityRatio_pTxi(double, double, double*,const char*, int);");
      end heatCapacityRatio_pTxi;

      function prandtlNumber_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.PrandtlNumber Pr "Prandtl number";
      external"C" Pr = TILMedia_VLEFluidFunctions_prandtlNumber_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_prandtlNumber_pTxi(double, double, double*,const char*, int);");
      end prandtlNumber_pTxi;

      function thermalConductivity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.ThermalConductivity lambda "Thermal conductivity";
      external"C" lambda = TILMedia_VLEFluidFunctions_thermalConductivity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_thermalConductivity_pTxi(double, double, double*,const char*, int);");
      end thermalConductivity_pTxi;

      function dynamicViscosity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DynamicViscosity eta "Dynamic viscosity";
      external"C" eta = TILMedia_VLEFluidFunctions_dynamicViscosity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dynamicViscosity_pTxi(double, double, double*,const char*, int);");
      end dynamicViscosity_pTxi;

      function surfaceTension_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SurfaceTension sigma "Surface tension";
      external"C" sigma = TILMedia_VLEFluidFunctions_surfaceTension_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_surfaceTension_pTxi(double, double, double*,const char*, int);");
      end surfaceTension_pTxi;

      function liquidDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_l "Density of liquid phase";
      external"C" d_l = TILMedia_VLEFluidFunctions_liquidDensity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidDensity_pTxi(double, double, double*,const char*, int);");
      end liquidDensity_pTxi;

      function vapourDensity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_v "Density of vapour phase";
      external"C" d_v = TILMedia_VLEFluidFunctions_vapourDensity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourDensity_pTxi(double, double, double*,const char*, int);");
      end vapourDensity_pTxi;

      function liquidSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      external"C" h_l = TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEnthalpy_pTxi(double, double, double*,const char*, int);");
      end liquidSpecificEnthalpy_pTxi;

      function vapourSpecificEnthalpy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      external"C" h_v = TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEnthalpy_pTxi(double, double, double*,const char*, int);");
      end vapourSpecificEnthalpy_pTxi;

      function liquidSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      external"C" s_l = TILMedia_VLEFluidFunctions_liquidSpecificEntropy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificEntropy_pTxi(double, double, double*,const char*, int);");
      end liquidSpecificEntropy_pTxi;

      function vapourSpecificEntropy_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      external"C" s_v = TILMedia_VLEFluidFunctions_vapourSpecificEntropy_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificEntropy_pTxi(double, double, double*,const char*, int);");
      end vapourSpecificEntropy_pTxi;

      function liquidTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_l "Temperature of liquid phase";
      external"C" T_l = TILMedia_VLEFluidFunctions_liquidTemperature_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidTemperature_pTxi(double, double, double*,const char*, int);");
      end liquidTemperature_pTxi;

      function vapourTemperature_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_v "Temperature of vapour phase";
      external"C" T_v = TILMedia_VLEFluidFunctions_vapourTemperature_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourTemperature_pTxi(double, double, double*,const char*, int);");
      end vapourTemperature_pTxi;

      function liquidMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_l "Mass fraction of liquid phase";
      external"C" xi_l = TILMedia_VLEFluidFunctions_liquidMassFraction_pTxin(
          p,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidMassFraction_pTxin(double, double, double*,int, const char*, int);");
      end liquidMassFraction_pTxin;

      function vapourMassFraction_pTxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_v "Mass fraction of vapour phase";
      external"C" xi_v = TILMedia_VLEFluidFunctions_vapourMassFraction_pTxin(
          p,
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourMassFraction_pTxin(double, double, double*,int, const char*, int);");
      end vapourMassFraction_pTxin;

      function liquidSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_l "Specific heat capacity cp of liquid phase";
      external"C" cp_l = TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidSpecificHeatCapacity_pTxi(double, double, double*,const char*, int);");
      end liquidSpecificHeatCapacity_pTxi;

      function vapourSpecificHeatCapacity_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_v "Specific heat capacity cp of vapour phase";
      external"C" cp_v = TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourSpecificHeatCapacity_pTxi(double, double, double*,const char*, int);");
      end vapourSpecificHeatCapacity_pTxi;

      function liquidIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_l "Isobaric expansion coefficient of liquid phase";
      external"C" beta_l = TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsobaricThermalExpansionCoefficient_pTxi(double, double, double*,const char*, int);");
      end liquidIsobaricThermalExpansionCoefficient_pTxi;

      function vapourIsobaricThermalExpansionCoefficient_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_v "Isobaric expansion coefficient of vapour phase";
      external"C" beta_v = TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsobaricThermalExpansionCoefficient_pTxi(double, double, double*,const char*, int);");
      end vapourIsobaricThermalExpansionCoefficient_pTxi;

      function liquidIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_l "Isothermal compressibility of liquid phase";
      external"C" kappa_l = TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_liquidIsothermalCompressibility_pTxi(double, double, double*,const char*, int);");
      end liquidIsothermalCompressibility_pTxi;

      function vapourIsothermalCompressibility_pTxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_v "Isothermal compressibility of vapour phase";
      external"C" kappa_v = TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_pTxi(
          p,
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_vapourIsothermalCompressibility_pTxi(double, double, double*,const char*, int);");
      end vapourIsothermalCompressibility_pTxi;

      function dewDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_dew "Density at dew point";
      external"C" d_dew = TILMedia_VLEFluidFunctions_dewDensity_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewDensity_Txi(double, double*, const char*, int);");
      end dewDensity_Txi;

      function bubbleDensity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_bubble "Density at bubble point";
      external"C" d_bubble = TILMedia_VLEFluidFunctions_bubbleDensity_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleDensity_Txi(double, double*, const char*, int);");
      end bubbleDensity_Txi;

      function dewSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      external"C" h_dew = TILMedia_VLEFluidFunctions_dewSpecificEnthalpy_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificEnthalpy_Txi(double, double*, const char*, int);");
      end dewSpecificEnthalpy_Txi;

      function bubbleSpecificEnthalpy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      external"C" h_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificEnthalpy_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificEnthalpy_Txi(double, double*, const char*, int);");
      end bubbleSpecificEnthalpy_Txi;

      function dewPressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_dew "Pressure at dew point";
      external"C" p_dew = TILMedia_VLEFluidFunctions_dewPressure_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewPressure_Txi(double, double*, const char*, int);");
      end dewPressure_Txi;

      function bubblePressure_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_bubble "Pressure at bubble point";
      external"C" p_bubble = TILMedia_VLEFluidFunctions_bubblePressure_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubblePressure_Txi(double, double*, const char*, int);");
      end bubblePressure_Txi;

      function dewSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      external"C" s_dew = TILMedia_VLEFluidFunctions_dewSpecificEntropy_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificEntropy_Txi(double, double*, const char*, int);");
      end dewSpecificEntropy_Txi;

      function bubbleSpecificEntropy_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      external"C" s_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificEntropy_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificEntropy_Txi(double, double*, const char*, int);");
      end bubbleSpecificEntropy_Txi;

      function dewLiquidMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      external"C" xi_ldew = TILMedia_VLEFluidFunctions_dewLiquidMassFraction_Txin(
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewLiquidMassFraction_Txin(double, double*, int, const char*, int);");
      end dewLiquidMassFraction_Txin;

      function bubbleVapourMassFraction_Txin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      external"C" xi_vbubble = TILMedia_VLEFluidFunctions_bubbleVapourMassFraction_Txin(
          T,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleVapourMassFraction_Txin(double, double*, int, const char*, int);");
      end bubbleVapourMassFraction_Txin;

      function dewSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      external"C" cp_dew = TILMedia_VLEFluidFunctions_dewSpecificIsobaricHeatCapacity_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificIsobaricHeatCapacity_Txi(double, double*, const char*, int);");
      end dewSpecificIsobaricHeatCapacity_Txi;

      function bubbleSpecificIsobaricHeatCapacity_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      external"C" cp_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificIsobaricHeatCapacity_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificIsobaricHeatCapacity_Txi(double, double*, const char*, int);");
      end bubbleSpecificIsobaricHeatCapacity_Txi;

      function dewIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      external"C" beta_dew = TILMedia_VLEFluidFunctions_dewIsobaricThermalExpansionCoefficient_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewIsobaricThermalExpansionCoefficient_Txi(double, double*, const char*, int);");
      end dewIsobaricThermalExpansionCoefficient_Txi;

      function bubbleIsobaricThermalExpansionCoefficient_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      external"C" beta_bubble = TILMedia_VLEFluidFunctions_bubbleIsobaricThermalExpansionCoefficient_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleIsobaricThermalExpansionCoefficient_Txi(double, double*, const char*, int);");
      end bubbleIsobaricThermalExpansionCoefficient_Txi;

      function dewIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      external"C" kappa_dew = TILMedia_VLEFluidFunctions_dewIsothermalCompressibility_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewIsothermalCompressibility_Txi(double, double*, const char*, int);");
      end dewIsothermalCompressibility_Txi;

      function bubbleIsothermalCompressibility_Txi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.Temperature T "Temperature";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      external"C" kappa_bubble = TILMedia_VLEFluidFunctions_bubbleIsothermalCompressibility_Txi(
          T,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleIsothermalCompressibility_Txi(double, double*, const char*, int);");
      end bubbleIsothermalCompressibility_Txi;

      function dewDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_dew "Density at dew point";
      external"C" d_dew = TILMedia_VLEFluidFunctions_dewDensity_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewDensity_pxi(double, double*, const char*, int);");
      end dewDensity_pxi;

      function bubbleDensity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density d_bubble "Density at bubble point";
      external"C" d_bubble = TILMedia_VLEFluidFunctions_bubbleDensity_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleDensity_pxi(double, double*, const char*, int);");
      end bubbleDensity_pxi;

      function dewSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_dew "Specific enthalpy at dew point";
      external"C" h_dew = TILMedia_VLEFluidFunctions_dewSpecificEnthalpy_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificEnthalpy_pxi(double, double*, const char*, int);");
      end dewSpecificEnthalpy_pxi;

      function bubbleSpecificEnthalpy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy h_bubble "Specific enthalpy at bubble point";
      external"C" h_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificEnthalpy_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificEnthalpy_pxi(double, double*, const char*, int);");
      end bubbleSpecificEnthalpy_pxi;

      function dewSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_dew "Specific entropy at dew point";
      external"C" s_dew = TILMedia_VLEFluidFunctions_dewSpecificEntropy_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificEntropy_pxi(double, double*, const char*, int);");
      end dewSpecificEntropy_pxi;

      function bubbleSpecificEntropy_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy s_bubble "Specific entropy at bubble point";
      external"C" s_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificEntropy_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificEntropy_pxi(double, double*, const char*, int);");
      end bubbleSpecificEntropy_pxi;

      function dewTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_dew "Temperature at dew point";
      external"C" T_dew = TILMedia_VLEFluidFunctions_dewTemperature_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewTemperature_pxi(double, double*, const char*, int);");
      end dewTemperature_pxi;

      function bubbleTemperature_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_bubble "Temperature at bubble point";
      external"C" T_bubble = TILMedia_VLEFluidFunctions_bubbleTemperature_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleTemperature_pxi(double, double*, const char*, int);");
      end bubbleTemperature_pxi;

      function dewLiquidMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_ldew "Mass fration at dew point";
      external"C" xi_ldew = TILMedia_VLEFluidFunctions_dewLiquidMassFraction_pxin(
          p,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewLiquidMassFraction_pxin(double, double*, int, const char*, int);");
      end dewLiquidMassFraction_pxin;

      function bubbleVapourMassFraction_pxin
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MassFraction xi_vbubble "Mass fration at bubble point";
      external"C" xi_vbubble = TILMedia_VLEFluidFunctions_bubbleVapourMassFraction_pxin(
          p,
          xi,
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleVapourMassFraction_pxin(double, double*, int, const char*, int);");
      end bubbleVapourMassFraction_pxin;

      function dewSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_dew "Specific isobaric heat capacity cp at dew point";
      external"C" cp_dew = TILMedia_VLEFluidFunctions_dewSpecificIsobaricHeatCapacity_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewSpecificIsobaricHeatCapacity_pxi(double, double*, const char*, int);");
      end dewSpecificIsobaricHeatCapacity_pxi;

      function bubbleSpecificIsobaricHeatCapacity_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cp_bubble "Specific isobaric heat capacity cp at bubble point";
      external"C" cp_bubble = TILMedia_VLEFluidFunctions_bubbleSpecificIsobaricHeatCapacity_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleSpecificIsobaricHeatCapacity_pxi(double, double*, const char*, int);");
      end bubbleSpecificIsobaricHeatCapacity_pxi;

      function dewIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_dew "Isobaric thermal expansion coefficient at dew point";
      external"C" beta_dew = TILMedia_VLEFluidFunctions_dewIsobaricThermalExpansionCoefficient_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewIsobaricThermalExpansionCoefficient_pxi(double, double*, const char*, int);");
      end dewIsobaricThermalExpansionCoefficient_pxi;

      function bubbleIsobaricThermalExpansionCoefficient_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient beta_bubble "Isobaric thermal expansion coefficient at bubble point";
      external"C" beta_bubble = TILMedia_VLEFluidFunctions_bubbleIsobaricThermalExpansionCoefficient_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleIsobaricThermalExpansionCoefficient_pxi(double, double*, const char*, int);");
      end bubbleIsobaricThermalExpansionCoefficient_pxi;

      function dewIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_dew "Isothermal compressibility at dew point";
      external"C" kappa_dew = TILMedia_VLEFluidFunctions_dewIsothermalCompressibility_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_dewIsothermalCompressibility_pxi(double, double*, const char*, int);");
      end dewIsothermalCompressibility_pxi;

      function bubbleIsothermalCompressibility_pxi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.AbsolutePressure p "Pressure";
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappa_bubble "Isothermal compressibility at bubble point";
      external"C" kappa_bubble = TILMedia_VLEFluidFunctions_bubbleIsothermalCompressibility_pxi(
          p,
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_bubbleIsothermalCompressibility_pxi(double, double*, const char*, int);");
      end bubbleIsothermalCompressibility_pxi;

      function averageMolarMass_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MolarMass M "Average molar mass";
      external"C" M = TILMedia_VLEFluidFunctions_averageMolarMass_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_averageMolarMass_xi(double*,  const char*, int);");
      end averageMolarMass_xi;

      function criticalDensity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Density dc "Critical density";
      external"C" dc = TILMedia_VLEFluidFunctions_criticalDensity_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalDensity_xi(double*,  const char*, int);");
      end criticalDensity_xi;

      function criticalSpecificEnthalpy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEnthalpy hc "Critical specific enthalpy";
      external"C" hc = TILMedia_VLEFluidFunctions_criticalSpecificEnthalpy_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalSpecificEnthalpy_xi(double*,  const char*, int);");
      end criticalSpecificEnthalpy_xi;

      function criticalPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure pc "Critical pressure";
      external"C" pc = TILMedia_VLEFluidFunctions_criticalPressure_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalPressure_xi(double*,  const char*, int);");
      end criticalPressure_xi;

      function criticalSpecificEntropy_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificEntropy sc "Critical specific entropy";
      external"C" sc = TILMedia_VLEFluidFunctions_criticalSpecificEntropy_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalSpecificEntropy_xi(double*,  const char*, int);");
      end criticalSpecificEntropy_xi;

      function criticalTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature Tc "Critical temperature";
      external"C" Tc = TILMedia_VLEFluidFunctions_criticalTemperature_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalTemperature_xi(double*,  const char*, int);");
      end criticalTemperature_xi;

      function criticalSpecificIsobaricHeatCapacity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SpecificHeatCapacity cpc "Critical specific isobaric heat capacity cp";
      external"C" cpc = TILMedia_VLEFluidFunctions_criticalSpecificIsobaricHeatCapacity_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalSpecificIsobaricHeatCapacity_xi(double*,  const char*, int);");
      end criticalSpecificIsobaricHeatCapacity_xi;

      function criticalIsobaricThermalExpansionCoefficient_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.LinearExpansionCoefficient betac "Critical isobaric thermal expansion coefficient";
      external"C" betac = TILMedia_VLEFluidFunctions_criticalIsobaricThermalExpansionCoefficient_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalIsobaricThermalExpansionCoefficient_xi(double*,  const char*, int);");
      end criticalIsobaricThermalExpansionCoefficient_xi;

      function criticalIsothermalCompressibility_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Compressibility kappac "Critical isothermal compressibility";
      external"C" kappac = TILMedia_VLEFluidFunctions_criticalIsothermalCompressibility_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalIsothermalCompressibility_xi(double*,  const char*, int);");
      end criticalIsothermalCompressibility_xi;

      function criticalThermalConductivity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.ThermalConductivity lambdac "Critical thermal conductivity";
      external"C" lambdac = TILMedia_VLEFluidFunctions_criticalThermalConductivity_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalThermalConductivity_xi(double*,  const char*, int);");
      end criticalThermalConductivity_xi;

      function criticalDynamicViscosity_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.DynamicViscosity etac "Critical dynamic viscosity";
      external"C" etac = TILMedia_VLEFluidFunctions_criticalDynamicViscosity_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalDynamicViscosity_xi(double*,  const char*, int);");
      end criticalDynamicViscosity_xi;

      function criticalSurfaceTension_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.SurfaceTension sigmac "Critical surface tension";
      external"C" sigmac = TILMedia_VLEFluidFunctions_criticalSurfaceTension_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_criticalSurfaceTension_xi(double*,  const char*, int);");
      end criticalSurfaceTension_xi;

      function cricondenbarTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_ccb "";
      external"C" T_ccb = TILMedia_VLEFluidFunctions_cricondenbarTemperature_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_cricondenbarTemperature_xi(double*,  const char*, int);");
      end cricondenbarTemperature_xi;

      function cricondenthermTemperature_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.Temperature T_cct "";
      external"C" T_cct = TILMedia_VLEFluidFunctions_cricondenthermTemperature_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_cricondenthermTemperature_xi(double*,  const char*, int);");
      end cricondenthermTemperature_xi;

      function cricondenbarPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_ccb "";
      external"C" p_ccb = TILMedia_VLEFluidFunctions_cricondenbarPressure_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_cricondenbarPressure_xi(double*,  const char*, int);");
      end cricondenbarPressure_xi;

      function cricondenthermPressure_xi
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input SI.MassFraction[:] xi "Mass fractions of the first nc-1 components";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.AbsolutePressure p_cct "";
      external"C" p_cct = TILMedia_VLEFluidFunctions_cricondenthermPressure_xi(
          xi,
          vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_cricondenthermPressure_xi(double*,  const char*, int);");
      end cricondenthermPressure_xi;

      function molarMass_n
        extends .TILMedia.BaseClasses.PartialVLEFluidFunction;
        input Integer compNo "Component ID";
        input .TILMedia.Internals.VLEFluidName vleFluidName "VLEFluid name";
        input Integer nc "Number of components";
        output SI.MolarMass M_i "Molar mass of component i";
      external"C" M_i = TILMedia_VLEFluidFunctions_molarMass_n(
          compNo, vleFluidName,
          nc) annotation (
          __iti_dllNoExport=true,
          Include="static double TILMedia_VLEFluidFunctions_molarMass_n(  int, const char*, int);");
      end molarMass_n;
    end VLEFluidFunctions;

    package VLEFluidConfigurations
    extends .TILMedia.Internals.ClassTypes.ModelPackage;

      package FullyMixtureCompatible
        extends .TILMedia.Internals.ClassTypes.ModelPackage;

        model VLEFluid "Compressible fluid model for object and member function based evaluation"
          extends .TILMedia.BaseClasses.PartialVLEFluid(
            vleFluidPointer=.TILMedia.Internals.TILMediaExternalObject(
                "VLEFluid",
                vleFluidType.concatVLEFluidName,
                .TILMedia.Internals.calcComputeFlags(
                  computeTransportProperties,
                  interpolateTransportProperties,
                  computeSurfaceTension,
                  deactivateTwoPhaseRegion,
                  deactivateDensityDerivatives),
                vleFluidType.mixingRatio_propertyCalculation[1:end - 1]/sum(
                  vleFluidType.mixingRatio_propertyCalculation),
                vleFluidType.nc,
                0,
                getInstanceName()),
          redeclare replaceable function h_dTxi =
              .TILMedia.VLEFluidObjectFunctions.specificEnthalpy_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function p_dTxi =
              .TILMedia.VLEFluidObjectFunctions.pressure_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_dTxi =
              .TILMedia.VLEFluidObjectFunctions.specificEntropy_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function q_dTxi =
              .TILMedia.VLEFluidObjectFunctions.steamMassFraction_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_dTxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsobaricHeatCapacity_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cv_dTxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsochoricHeatCapacity_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_dTxi =
              .TILMedia.VLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_dTxi =
              .TILMedia.VLEFluidObjectFunctions.isothermalCompressibility_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function w_dTxi =
              .TILMedia.VLEFluidObjectFunctions.speedOfSound_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodh_pxi_dTxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodp_hxi_dTxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTpressure_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function gamma_dTxi =
              .TILMedia.VLEFluidObjectFunctions.heatCapacityRatio_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function Pr_dTxi =
              .TILMedia.VLEFluidObjectFunctions.prandtlNumber_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function lambda_dTxi =
              .TILMedia.VLEFluidObjectFunctions.thermalConductivity_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function eta_dTxi =
              .TILMedia.VLEFluidObjectFunctions.dynamicViscosity_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function sigma_dTxi =
              .TILMedia.VLEFluidObjectFunctions.surfaceTension_dTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_phxi =
              .TILMedia.VLEFluidObjectFunctions.density_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_phxi =
              .TILMedia.VLEFluidObjectFunctions.specificEntropy_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function T_phxi =
              .TILMedia.VLEFluidObjectFunctions.temperature_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function q_phxi =
              .TILMedia.VLEFluidObjectFunctions.steamMassFraction_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_phxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsobaricHeatCapacity_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cv_phxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsochoricHeatCapacity_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_phxi =
              .TILMedia.VLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_phxi =
              .TILMedia.VLEFluidObjectFunctions.isothermalCompressibility_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function w_phxi =
              .TILMedia.VLEFluidObjectFunctions.speedOfSound_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodh_pxi_phxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodp_hxi_phxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTpressure_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function gamma_phxi =
              .TILMedia.VLEFluidObjectFunctions.heatCapacityRatio_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function Pr_phxi =
              .TILMedia.VLEFluidObjectFunctions.prandtlNumber_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function lambda_phxi =
              .TILMedia.VLEFluidObjectFunctions.thermalConductivity_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function eta_phxi =
              .TILMedia.VLEFluidObjectFunctions.dynamicViscosity_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function sigma_phxi =
              .TILMedia.VLEFluidObjectFunctions.surfaceTension_phxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_psxi =
              .TILMedia.VLEFluidObjectFunctions.density_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_psxi =
              .TILMedia.VLEFluidObjectFunctions.specificEnthalpy_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function T_psxi =
              .TILMedia.VLEFluidObjectFunctions.temperature_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function q_psxi =
              .TILMedia.VLEFluidObjectFunctions.steamMassFraction_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_psxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsobaricHeatCapacity_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cv_psxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsochoricHeatCapacity_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_psxi =
              .TILMedia.VLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_psxi =
              .TILMedia.VLEFluidObjectFunctions.isothermalCompressibility_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function w_psxi =
              .TILMedia.VLEFluidObjectFunctions.speedOfSound_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodh_pxi_psxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodp_hxi_psxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTpressure_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function gamma_psxi =
              .TILMedia.VLEFluidObjectFunctions.heatCapacityRatio_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function Pr_psxi =
              .TILMedia.VLEFluidObjectFunctions.prandtlNumber_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function lambda_psxi =
              .TILMedia.VLEFluidObjectFunctions.thermalConductivity_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function eta_psxi =
              .TILMedia.VLEFluidObjectFunctions.dynamicViscosity_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function sigma_psxi =
              .TILMedia.VLEFluidObjectFunctions.surfaceTension_psxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_pTxi =
              .TILMedia.VLEFluidObjectFunctions.density_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_pTxi =
              .TILMedia.VLEFluidObjectFunctions.specificEnthalpy_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_pTxi =
              .TILMedia.VLEFluidObjectFunctions.specificEntropy_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function q_pTxi =
              .TILMedia.VLEFluidObjectFunctions.steamMassFraction_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_pTxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsobaricHeatCapacity_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cv_pTxi =
              .TILMedia.VLEFluidObjectFunctions.specificIsochoricHeatCapacity_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_pTxi =
              .TILMedia.VLEFluidObjectFunctions.isobaricThermalExpansionCoefficient_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_pTxi =
              .TILMedia.VLEFluidObjectFunctions.isothermalCompressibility_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function w_pTxi =
              .TILMedia.VLEFluidObjectFunctions.speedOfSound_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodh_pxi_pTxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTspecificEnthalpy_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function drhodp_hxi_pTxi =
              .TILMedia.VLEFluidObjectFunctions.densityDerivativeWRTpressure_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function gamma_pTxi =
              .TILMedia.VLEFluidObjectFunctions.heatCapacityRatio_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function Pr_pTxi =
              .TILMedia.VLEFluidObjectFunctions.prandtlNumber_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function lambda_pTxi =
              .TILMedia.VLEFluidObjectFunctions.thermalConductivity_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function eta_pTxi =
              .TILMedia.VLEFluidObjectFunctions.dynamicViscosity_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function sigma_pTxi =
              .TILMedia.VLEFluidObjectFunctions.surfaceTension_pTxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewDensity_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleDensity_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificEnthalpy_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificEnthalpy_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function p_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewPressure_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function p_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubblePressure_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificEntropy_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificEntropy_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_dew_Txi =
              .TILMedia.VLEFluidObjectFunctions.dewIsothermalCompressibility_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_bubble_Txi =
              .TILMedia.VLEFluidObjectFunctions.bubbleIsothermalCompressibility_Txi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewDensity_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function d_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleDensity_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificEnthalpy_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function h_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificEnthalpy_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificEntropy_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function s_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificEntropy_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function T_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewTemperature_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function T_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleTemperature_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewSpecificIsobaricHeatCapacity_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function cp_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleSpecificIsobaricHeatCapacity_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewIsobaricThermalExpansionCoefficient_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function beta_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleIsobaricThermalExpansionCoefficient_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_dew_pxi =
              .TILMedia.VLEFluidObjectFunctions.dewIsothermalCompressibility_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function kappa_bubble_pxi =
              .TILMedia.VLEFluidObjectFunctions.bubbleIsothermalCompressibility_pxi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function dc_xi =
              .TILMedia.VLEFluidObjectFunctions.criticalDensity_xi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function hc_xi =
              .TILMedia.VLEFluidObjectFunctions.criticalSpecificEnthalpy_xi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function pc_xi =
              .TILMedia.VLEFluidObjectFunctions.criticalPressure_xi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function sc_xi =
              .TILMedia.VLEFluidObjectFunctions.criticalSpecificEntropy_xi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function Tc_xi =
              .TILMedia.VLEFluidObjectFunctions.criticalTemperature_xi(xi=vleFluidType.xi_default, vleFluidPointer=vleFluidPointer),
          redeclare replaceable function M_i_n =
              .TILMedia.VLEFluidObjectFunctions.molarMass_n(vleFluidPointer=vleFluidPointer));



          annotation (defaultComponentName="vleFluid", Protection(access=Access.packageDuplicate));
        end VLEFluid;

        model VLEFluid_pT
          "Compressible fluid model with p, T and xi as independent variables"
          extends .TILMedia.BaseClasses.PartialVLEFluid_pT(vleFluidPointer=
                .TILMedia.Internals.TILMediaExternalObject(
                "VLEFluid",
                vleFluidType.concatVLEFluidName,
                computeFlags,
                vleFluidType.mixingRatio_propertyCalculation[1:end - 1]/sum(
                  vleFluidType.mixingRatio_propertyCalculation),
                vleFluidType.nc,
                0,
                getInstanceName()),
                M_i = {.TILMedia.VLEFluidObjectFunctions.molarMass_n(i-1,vleFluidPointer) for i in 1:vleFluidType.nc});
      protected
          constant Real invalidValue=-1;
          final parameter Integer computeFlags=.TILMedia.Internals.calcComputeFlags(
              computeTransportProperties,
              interpolateTransportProperties,
              computeSurfaceTension,
              deactivateTwoPhaseRegion,
              deactivateDensityDerivatives);

        equation
          (crit.d,crit.h,crit.p,crit.s,crit.T) =
            .TILMedia.Internals.VLEFluidObjectFunctions.cricondenbar_xi(xi,
            vleFluidPointer);
          //calculate molar mass
          M = 1/sum(cat(
            1,
            xi,
            {1 - sum(xi)}) ./ M_i);
          //calculate mole fraction
          xi = x .* M_i[1:end - 1]*(sum(cat(
            1,
            xi,
            {1 - sum(xi)}) ./ M_i));
          //xi = x.*M_i/M

          //Calculate Main Properties of state
          d =
            .TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluidObjectFunctions.density_pTxi(
            p,
            T,
            xi,
            vleFluidPointer);
          h =
            .TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluidObjectFunctions.specificEnthalpy_pTxi(
            p,
            T,
            xi,
            vleFluidPointer);
          s =
            .TILMedia.Internals.VLEFluidConfigurations.FullyMixtureCompatible.VLEFluidObjectFunctions.specificEntropy_pTxi(
            p,
            T,
            xi,
            vleFluidPointer);

          //Calculate Additional Properties of state
          (q,cp,cv,beta,kappa,drhodp_hxi,drhodh_pxi,drhodxi_ph,w,gamma) =
            .TILMedia.Internals.VLEFluidObjectFunctions.additionalProperties_phxi(
            p,
            h,
            xi,
            vleFluidPointer);

          //Calculate VLE Properties
          if (vleFluidType.nc == 1) then
            //VLE only depends on p or T
            (VLE.d_l,VLE.h_l,VLE.p_l,VLE.s_l,VLE.T_l,VLE.xi_l,VLE.d_v,VLE.h_v,VLE.p_v,
              VLE.s_v,VLE.T_v,VLE.xi_v) =
              .TILMedia.Internals.VLEFluidObjectFunctions.VLEProperties_phxi(
              p,
              -1,
              zeros(0),
              vleFluidPointer);
          else
            //VLE of a mixture also depends on density/enthalpy/entropy/temperature
            (VLE.d_l,VLE.h_l,VLE.p_l,VLE.s_l,VLE.T_l,VLE.xi_l,VLE.d_v,VLE.h_v,VLE.p_v,
              VLE.s_v,VLE.T_v,VLE.xi_v) =
              .TILMedia.Internals.VLEFluidObjectFunctions.VLEProperties_phxi(
              p,
              h,
              xi,
              vleFluidPointer);
          end if;

          //Calculate Transport Properties
          if computeTransportProperties then
            (transp.Pr,
          transp.lambda,
          transp.eta,
          transp.sigma) =
              .TILMedia.Internals.VLEFluidObjectFunctions.transportPropertyRecord_phxi(
              p,
              h,
              xi,
              vleFluidPointer);
          else
            transp = .TILMedia.Internals.TransportPropertyRecord(
              invalidValue,
              invalidValue,
              invalidValue,
              invalidValue);
          end if;

          //compute VLE Additional Properties
          if computeVLEAdditionalProperties then
            if (vleFluidType.nc == 1) then
              //VLE only depends on p or T
              (VLEAdditional.cp_l,VLEAdditional.beta_l,VLEAdditional.kappa_l,
                VLEAdditional.cp_v,VLEAdditional.beta_v,VLEAdditional.kappa_v) =
                .TILMedia.Internals.VLEFluidObjectFunctions.VLEAdditionalProperties_phxi(
                p,
                -1,
                zeros(vleFluidType.nc - 1),
                vleFluidPointer);
            else
              //VLE of a mixture also depends on density/enthalpy/entropy/temperature
              (VLEAdditional.cp_l,VLEAdditional.beta_l,VLEAdditional.kappa_l,
                VLEAdditional.cp_v,VLEAdditional.beta_v,VLEAdditional.kappa_v) =
                .TILMedia.Internals.VLEFluidObjectFunctions.VLEAdditionalProperties_phxi(
                p,
                h,
                xi,
                vleFluidPointer);
            end if;
          else
            VLEAdditional.cp_l = invalidValue;
            VLEAdditional.beta_l = invalidValue;
            VLEAdditional.kappa_l = invalidValue;
            VLEAdditional.cp_v = invalidValue;
            VLEAdditional.beta_v = invalidValue;
            VLEAdditional.kappa_v = invalidValue;
          end if;

          //compute VLE Transport Properties
          if computeVLETransportProperties then
            if (vleFluidType.nc == 1) then
              //VLE only depends on p or T
              (VLETransp.Pr_l,VLETransp.Pr_v,VLETransp.lambda_l,VLETransp.lambda_v,
                VLETransp.eta_l,VLETransp.eta_v) =
                .TILMedia.Internals.VLEFluidObjectFunctions.VLETransportPropertyRecord_phxi(
                p,
                -1,
                zeros(0),
                vleFluidPointer);
            else
              //VLE of a mixture also depends on density/enthalpy/entropy/temperature
              (VLETransp.Pr_l,VLETransp.Pr_v,VLETransp.lambda_l,VLETransp.lambda_v,
                VLETransp.eta_l,VLETransp.eta_v) =
                .TILMedia.Internals.VLEFluidObjectFunctions.VLETransportPropertyRecord_phxi(
                p,
                h,
                xi,
                vleFluidPointer);
            end if;
          else
            VLETransp.Pr_l = invalidValue;
            VLETransp.Pr_v = invalidValue;
            VLETransp.lambda_l = invalidValue;
            VLETransp.lambda_v = invalidValue;
            VLETransp.eta_l = invalidValue;
            VLETransp.eta_v = invalidValue;
          end if;

          annotation (
            defaultComponentName="vleFluid",
            Protection(access=Access.packageDuplicate),
            Documentation(info="<html>
                   <p>
                   The VLE-fluid model VLEFluid_pT calculates the thermopyhsical property data with given inputs: pressure (p), temperature (T), mass fraction (xi) and the parameter vleFluidType.<br>
                   The interface and the way of using, is demonstrated in the Testers -> <a href=\"modelica://TILMedia.Testers.TestVLEFluid\">TestVLEFluid</a>.
                   </p>
                   <hr>
                   </html>"));
        end VLEFluid_pT;

        package VLEFluidObjectFunctions
        "Package for calculation of VLEFLuid properties with a functional call, referencing existing external objects for highspeed evaluation"
          extends .TILMedia.VLEFluidObjectFunctions;

          redeclare replaceable function extends pressure_dTxi
          external "C" p = TILMedia_VLEFluidObjectFunctions_pressure_dTxi(d, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_pressure_dTxi(double, double, double*, void*) { return 0.0; }");
            annotation(inverse(d=TILMedia.VLEFluidObjectFunctions.density_pTxi(p, T, xi, vleFluidPointer)));
          end pressure_dTxi;

          redeclare replaceable function extends specificEnthalpy_dTxi
          external "C" h = TILMedia_VLEFluidObjectFunctions_specificEnthalpy_dTxi(d, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEnthalpy_dTxi(double, double, double*, void*) { return 0.0; }");
          end specificEnthalpy_dTxi;

          redeclare replaceable function extends specificEntropy_dTxi
          external "C" s = TILMedia_VLEFluidObjectFunctions_specificEntropy_dTxi(d, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEntropy_dTxi(double, double, double*, void*) { return 0.0; }");
          end specificEntropy_dTxi;

          redeclare replaceable function extends temperature_phxi
          external "C" T = TILMedia_VLEFluidObjectFunctions_temperature_phxi(p, h, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_temperature_phxi(double, double, double*, void*) { return 0.0; }");
          annotation(inverse(h=TILMedia.VLEFluidObjectFunctions.specificEnthalpy_pTxi(p, T, xi, vleFluidPointer)),Impure=false);
          end temperature_phxi;

          redeclare replaceable function extends specificEntropy_phxi
          external "C" s = TILMedia_VLEFluidObjectFunctions_specificEntropy_phxi(p, h, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEntropy_phxi(double, double, double*, void*) { return 0.0; }");
          end specificEntropy_phxi;

          redeclare replaceable function extends density_pTxi
          external "C" d = TILMedia_VLEFluidObjectFunctions_density_pTxi(p, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_density_pTxi(double, double, double*, void*) { return 0.0; }");
          end density_pTxi;

          redeclare replaceable function extends specificEnthalpy_pTxi
          external "C" h = TILMedia_VLEFluidObjectFunctions_specificEnthalpy_pTxi(p, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEnthalpy_pTxi(double, double, double*, void*) { return 0.0; }");
          annotation(inverse(T=TILMedia.VLEFluidObjectFunctions.temperature_phxi(p, h, xi, vleFluidPointer)),Impure=false);
          end specificEnthalpy_pTxi;

          redeclare replaceable function extends specificEntropy_pTxi
          external "C" s = TILMedia_VLEFluidObjectFunctions_specificEntropy_pTxi(p, T, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEntropy_pTxi(double, double, double*, void*) { return 0.0; }");
          annotation(inverse(T=TILMedia.VLEFluidObjectFunctions.temperature_psxi(p, s, xi, vleFluidPointer)),Impure=false);
          end specificEntropy_pTxi;

          redeclare replaceable function extends density_psxi
          external "C" d = TILMedia_VLEFluidObjectFunctions_density_psxi(p, s, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_density_psxi(double, double, double*, void*) { return 0.0; }");
          end density_psxi;

          redeclare replaceable function extends temperature_psxi
          external "C" T = TILMedia_VLEFluidObjectFunctions_temperature_psxi(p, s, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_temperature_psxi(double, double, double*, void*) { return 0.0; }");
          annotation(inverse(s=TILMedia.VLEFluidObjectFunctions.specificEntropy_pTxi(p, T, xi, vleFluidPointer)),Impure=false);
          end temperature_psxi;

          redeclare replaceable function extends specificEnthalpy_psxi
          external "C" h = TILMedia_VLEFluidObjectFunctions_specificEnthalpy_psxi(p, s, xi, vleFluidPointer)
            annotation(__iti_dllNoExport = true,Include="static double TILMedia_VLEFluidObjectFunctions_specificEnthalpy_psxi(double, double, double*, void*) { return 0.0; }");
          annotation(inverse(s=TILMedia.VLEFluidObjectFunctions.specificEntropy_phxi(p, h, xi, vleFluidPointer)),Impure=false);
          end specificEnthalpy_psxi;
        end VLEFluidObjectFunctions;

        package VLEFluidFunctions
        "Package for calculation of VLEFluid properties with a functional call"
          extends .TILMedia.VLEFluidFunctions;
        end VLEFluidFunctions;
      end FullyMixtureCompatible;
    end VLEFluidConfigurations;

    package Units "Unit definitions"
    extends .TILMedia.Internals.ClassTypes.ModelPackage;

      type DensityDerPressure = Real(final unit="kg/(N.m)");

      type DensityDerSpecificEnthalpy = Real(final unit="kg2/(m3.J)");

      type DensityDerMassFraction =     Real(final unit="kg/(m3)");
    end Units;

    type GasName "Gas name"
      extends String;
    annotation(choices(
        choice="TILMedia.ASH",
        choice="TILMedia.DieselExhaustGas_1.0",
        choice="TILMedia.DieselExhaustGas_1.1",
        choice="TILMedia.DieselExhaustGas_1.2",
        choice="TILMedia.DRYAIR",
        choice="TILMedia.EXHAUSTGAS_LAMBDA_1",
        choice="TILMedia.SIMPLEDRYAIR",
        choice="TILMedia.SIMPLEWATER",
        choice="TILMedia.SIMPLEWATER2",
        choice="TILMediaXTR.AMMONIA",
        choice="TILMediaXTR.ARGON",
        choice="TILMediaXTR.CARBON_DIOXIDE",
        choice="TILMediaXTR.CARBON_MONOXIDE",
        choice="TILMediaXTR.DRYAIR",
        choice="TILMediaXTR.ExhaustGas",
        choice="TILMediaXTR.HYDROGEN",
        choice="TILMediaXTR.METHANE",
        choice="TILMediaXTR.NITROGEN",
        choice="TILMediaXTR.NITROUS_OXIDE",
        choice="TILMediaXTR.OXYGEN",
        choice="TILMediaXTR.SULFUR_DIOXIDE",
        choice="TILMediaXTR.WATER",
        choice="VDI4670.ARGON",
        choice="VDI4670.CARBON_DIOXIDE",
        choice="VDI4670.CARBON_MONOXIDE",
        choice="VDI4670.DRYAIR",
        choice="VDI4670.NEON",
        choice="VDI4670.NITROGEN",
        choice="VDI4670.OXYGEN",
        choice="VDI4670.SULPHUR_DIOXIDE",
        choice="VDI4670.WATER",
        choice="VDIWA2006.1,1,1-TRICHLOROETHANE",
        choice="VDIWA2006.1,1,1-TRIFLUOROETHANE",
        choice="VDIWA2006.1,1,2,2-TETRACHLORODIFLUOROETHANE",
        choice="VDIWA2006.1,1,2,2-TETRACHLOROETHANE",
        choice="VDIWA2006.1,1,2-TRICHLORO-1,2,2-TRIFLUOROETHANE",
        choice="VDIWA2006.1,1-DICHLOROETHANE",
        choice="VDIWA2006.1,1-DICHLOROETHENE",
        choice="VDIWA2006.1,2,3,4-TETRAMETHYLBENZENE",
        choice="VDIWA2006.1,2,3,5-TETRAMETHYLBENZENE",
        choice="VDIWA2006.1,2,3-TRIMETHYLBENZENE",
        choice="VDIWA2006.1,2,4,5-TETRAMETHYLBENZENE",
        choice="VDIWA2006.1,2,4-TRIMETHYLBENZENE",
        choice="VDIWA2006.1,2-BUTADIENE",
        choice="VDIWA2006.1,2-DIBROMOETHANE",
        choice="VDIWA2006.1,2-DICHLORO-1,1,2,2-TETRAFLUOROETHANE",
        choice="VDIWA2006.1,2-DICHLOROETHANE",
        choice="VDIWA2006.1,2-PENTADIENE",
        choice="VDIWA2006.1,3,5-TRIMETHYLBENZENE",
        choice="VDIWA2006.1,3-BUTADIENE",
        choice="VDIWA2006.1,3-PENTADIENE",
        choice="VDIWA2006.1,3-PROPYLENGLYCOL",
        choice="VDIWA2006.1,4-DIOXANE",
        choice="VDIWA2006.1,4-PENTADIENE",
        choice="VDIWA2006.1-BUTENE",
        choice="VDIWA2006.1-CHLOROBUTANE",
        choice="VDIWA2006.1-CHLOROPENTANE",
        choice="VDIWA2006.1-CHLOROPROPANE",
        choice="VDIWA2006.1-ETHYLNAPHTHALENE",
        choice="VDIWA2006.1-HEPTENE",
        choice="VDIWA2006.1-HEXENE",
        choice="VDIWA2006.1-METHYLNAPHTHALENE",
        choice="VDIWA2006.1-OCTENE",
        choice="VDIWA2006.1-PENTENE",
        choice="VDIWA2006.1-PHENYLETHANONE",
        choice="VDIWA2006.2,2-DIMETHYLBUTANE",
        choice="VDIWA2006.2,2-DIMETHYLPROPANE",
        choice="VDIWA2006.2,3-DIMETHYLBUTANE",
        choice="VDIWA2006.2,3-PENTADIENE",
        choice="VDIWA2006.2,4,6-TRIMETHYL-1,3,5-TRIOXANE",
        choice="VDIWA2006.2-ETHYLNAPHTHALENE",
        choice="VDIWA2006.2-HYDROXYBENZALDEHYDE",
        choice="VDIWA2006.2-METHYLBUTANE",
        choice="VDIWA2006.2-METHYLNAPHTHALENE",
        choice="VDIWA2006.2-METHYLPENTANE",
        choice="VDIWA2006.2-METHYLPROPAN-1-OL",
        choice="VDIWA2006.2-METHYLPROPANE",
        choice="VDIWA2006.3-METHYLPENTANE",
        choice="VDIWA2006.ACETALDEHYDE",
        choice="VDIWA2006.ACETIC ANHYDRIDE",
        choice="VDIWA2006.ACETONITRILE",
        choice="VDIWA2006.ACETYLENE",
        choice="VDIWA2006.AMMONIA",
        choice="VDIWA2006.ARGON",
        choice="VDIWA2006.BENZALDEHYDE",
        choice="VDIWA2006.BENZENE",
        choice="VDIWA2006.BENZONITRILE",
        choice="VDIWA2006.BENZOPHENONE",
        choice="VDIWA2006.BIPHENYL",
        choice="VDIWA2006.BROMINE",
        choice="VDIWA2006.BROMOBENZENE",
        choice="VDIWA2006.BROMOCYANIDE",
        choice="VDIWA2006.BROMOETHANE",
        choice="VDIWA2006.BROMOMETHANE",
        choice="VDIWA2006.BUTAN-1-AMINE",
        choice="VDIWA2006.BUTANE",
        choice="VDIWA2006.BUTANENITRILE",
        choice="VDIWA2006.BUTANOIC ACID",
        choice="VDIWA2006.BUTANOL",
        choice="VDIWA2006.BUTYLBENZENE",
        choice="VDIWA2006.BUTYLCYCLOHEXANE",
        choice="VDIWA2006.BUTYLCYCLOPENTANE",
        choice="VDIWA2006.CARBOMETHENE",
        choice="VDIWA2006.CARBON DIOXIDE",
        choice="VDIWA2006.CARBON DISULFIDE",
        choice="VDIWA2006.CARBON MONOXIDE",
        choice="VDIWA2006.CARBON SUBOXIDE",
        choice="VDIWA2006.CARBONYL SULFIDE",
        choice="VDIWA2006.CHLORINE",
        choice="VDIWA2006.CHLOROACETIC ACID",
        choice="VDIWA2006.CHLOROBENZENE",
        choice="VDIWA2006.CHLOROCYANIDE",
        choice="VDIWA2006.CHLORODIFLUOROMETHANE",
        choice="VDIWA2006.CHLOROETHANE",
        choice="VDIWA2006.CHLOROETHYLENE",
        choice="VDIWA2006.CHLOROMETHANE",
        choice="VDIWA2006.CHLOROMETHYLBENZENE",
        choice="VDIWA2006.CHLOROTRIFLUOROETHYLENE",
        choice="VDIWA2006.CHLOROTRIFLUOROMETHANE",
        choice="VDIWA2006.CYANOGEN",
        choice="VDIWA2006.CYCLOBUTANE",
        choice="VDIWA2006.CYCLOHEXANE",
        choice="VDIWA2006.CYCLOHEXANOL",
        choice="VDIWA2006.CYCLOHEXENE",
        choice="VDIWA2006.CYCLOPENTANE",
        choice="VDIWA2006.CYCLOPENTENE",
        choice="VDIWA2006.CYCLOPROPANE",
        choice="VDIWA2006.DECANE",
        choice="VDIWA2006.DIBROMOMETHANE",
        choice="VDIWA2006.DICHLOROACETIC ACID",
        choice="VDIWA2006.DICHLORODIFLUOROMETHANE",
        choice="VDIWA2006.DICHLORODIFLUOROMETHANE",
        choice="VDIWA2006.DICHLOROMETHANE",
        choice="VDIWA2006.DIETHYL KETONE",
        choice="VDIWA2006.DIETHYL SULFIDE",
        choice="VDIWA2006.DIETHYLAMINE",
        choice="VDIWA2006.DIFLUOROMETHANE",
        choice="VDIWA2006.DIMETHYL SULFIDE",
        choice="VDIWA2006.DIMETHYLACETYLENE",
        choice="VDIWA2006.DIMETHYLAMINE",
        choice="VDIWA2006.DIMETHYLENEMETHANE",
        choice="VDIWA2006.DINITROGEN TETROXIDE",
        choice="VDIWA2006.DIPHENYLAMINE",
        choice="VDIWA2006.DIPHENYLMETHANE",
        choice="VDIWA2006.DODECANE",
        choice="VDIWA2006.DRYAIR",
        choice="VDIWA2006.ETHANAMINE",
        choice="VDIWA2006.ETHANE",
        choice="VDIWA2006.ETHANETHIOL",
        choice="VDIWA2006.ETHANOIC ACID",
        choice="VDIWA2006.ETHANOL",
        choice="VDIWA2006.ETHENE",
        choice="VDIWA2006.ETHOXYETHANE",
        choice="VDIWA2006.ETHOXYPROPANE",
        choice="VDIWA2006.ETHYL-ACETATE",
        choice="VDIWA2006.ETHYL-BENZOATE",
        choice="VDIWA2006.ETHYL-BUTANOATE",
        choice="VDIWA2006.ETHYL-FORMATE",
        choice="VDIWA2006.ETHYL-PROPIONATE",
        choice="VDIWA2006.ETHYLACETYLENE",
        choice="VDIWA2006.ETHYLBENZENE",
        choice="VDIWA2006.ETHYLCYCLEPENTANE",
        choice="VDIWA2006.ETHYLCYCLOHEXANE",
        choice="VDIWA2006.ETHYLENE OXIDE",
        choice="VDIWA2006.ETHYLENGLYCOL",
        choice="VDIWA2006.FLUORINE",
        choice="VDIWA2006.FLUOROBENZENE",
        choice="VDIWA2006.FLUOROCYANIDE",
        choice="VDIWA2006.FLUOROETHANE",
        choice="VDIWA2006.FLUOROMETHANE",
        choice="VDIWA2006.FURAN",
        choice="VDIWA2006.FURAN-2-CARBALDEHYDE",
        choice="VDIWA2006.GLYCERIN",
        choice="VDIWA2006.HELIUM",
        choice="VDIWA2006.HEPTADECANE",
        choice="VDIWA2006.HEPTANE",
        choice="VDIWA2006.HEPTANOL",
        choice="VDIWA2006.HEXACHLOROETHANE",
        choice="VDIWA2006.HEXADECANE",
        choice="VDIWA2006.HEXAMETHYLBENZENE",
        choice="VDIWA2006.HEXANE",
        choice="VDIWA2006.HEXANOIC ACID",
        choice="VDIWA2006.HEXANOL",
        choice="VDIWA2006.HEXYLBENZENE",
        choice="VDIWA2006.HEXYLCYCLOHEXANE",
        choice="VDIWA2006.HEXYLCYCLOPENTANE",
        choice="VDIWA2006.HYDROGEN",
        choice="VDIWA2006.HYDROGEN BROMIDE",
        choice="VDIWA2006.HYDROGEN CHLORIDE",
        choice="VDIWA2006.HYDROGEN CYANIDE",
        choice="VDIWA2006.HYDROGEN FLUORIDE",
        choice="VDIWA2006.HYDROGEN IODIDE",
        choice="VDIWA2006.HYDROGEN SULFIDE",
        choice="VDIWA2006.ICOSANE",
        choice="VDIWA2006.IODINE",
        choice="VDIWA2006.IODINECYANIDE",
        choice="VDIWA2006.IODOBENZENE",
        choice="VDIWA2006.ISOPENTYL ALCOHOL",
        choice="VDIWA2006.ISOPROPYL ALCOHOL",
        choice="VDIWA2006.ISOPROPYLBENZENE",
        choice="VDIWA2006.KRYPTON",
        choice="VDIWA2006.M-CHLOROTOLUENE",
        choice="VDIWA2006.M-CRESOL",
        choice="VDIWA2006.M-NITROTOLUENE",
        choice="VDIWA2006.M-XYLENE",
        choice="VDIWA2006.METHANAL",
        choice="VDIWA2006.METHANAMIDE",
        choice="VDIWA2006.METHANE",
        choice="VDIWA2006.METHANETHIOL",
        choice="VDIWA2006.METHANOIC ACID",
        choice="VDIWA2006.METHANOL",
        choice="VDIWA2006.METHOXYMETHANE",
        choice="VDIWA2006.METHOXYPROPANE",
        choice="VDIWA2006.METHYL ETHYL KETONE",
        choice="VDIWA2006.METHYL-ACETATE",
        choice="VDIWA2006.METHYL-BENZOATE",
        choice="VDIWA2006.METHYL-BUTANOATE",
        choice="VDIWA2006.METHYL-FORMATE",
        choice="VDIWA2006.METHYL-PROPIONATE",
        choice="VDIWA2006.METHYL-SALICYLATE",
        choice="VDIWA2006.METHYLACETYLENE",
        choice="VDIWA2006.METHYLAMINE",
        choice="VDIWA2006.METHYLBENZENE",
        choice="VDIWA2006.METHYLCYCLOHEXANE",
        choice="VDIWA2006.METHYLCYCLOPENTANE",
        choice="VDIWA2006.N,N-DIETHYL-ANILIN",
        choice="VDIWA2006.N,N-DIMETHYL-ANILIN",
        choice="VDIWA2006.N-METHYL-ANILIN",
        choice="VDIWA2006.N-PROPYL-PROPIONATE",
        choice="VDIWA2006.NAPHTHALENE",
        choice="VDIWA2006.NEON",
        choice="VDIWA2006.NITRIC OXIDE",
        choice="VDIWA2006.NITROBENZENE",
        choice="VDIWA2006.NITROGEN",
        choice="VDIWA2006.NITROGEN DIOXIDE",
        choice="VDIWA2006.NITROMETHANE",
        choice="VDIWA2006.NITROUS OXIDE",
        choice="VDIWA2006.NONADECANE",
        choice="VDIWA2006.NONANE",
        choice="VDIWA2006.O-CRESOL",
        choice="VDIWA2006.O-NITROTOLUENE",
        choice="VDIWA2006.O-XYLENE",
        choice="VDIWA2006.OCTADECANE",
        choice="VDIWA2006.OCTANE",
        choice="VDIWA2006.OCTANOL",
        choice="VDIWA2006.OXYGEN",
        choice="VDIWA2006.P-CRESOL",
        choice="VDIWA2006.P-NITROTOLUENE",
        choice="VDIWA2006.P-XYLENE",
        choice="VDIWA2006.PENTACHLOROETHANE",
        choice="VDIWA2006.PENTADECANE",
        choice="VDIWA2006.PENTAMETHYLBENZENE",
        choice="VDIWA2006.PENTANE",
        choice="VDIWA2006.PENTANOIC ACID",
        choice="VDIWA2006.PENTANOL",
        choice="VDIWA2006.PENTYLBENZENE",
        choice="VDIWA2006.PENTYLCYCLOHEXANE",
        choice="VDIWA2006.PENTYLCYCLOPENTANE",
        choice="VDIWA2006.PHENOL",
        choice="VDIWA2006.PHENYLAMINE",
        choice="VDIWA2006.PHENYLHYDRAZINE",
        choice="VDIWA2006.PHENYLMETHANOL",
        choice="VDIWA2006.PHOSGENE",
        choice="VDIWA2006.PIPERIDINE",
        choice="VDIWA2006.PROPANE",
        choice="VDIWA2006.PROPANENITRILE",
        choice="VDIWA2006.PROPANOIC ACID",
        choice="VDIWA2006.PROPANOL",
        choice="VDIWA2006.PROPANONE",
        choice="VDIWA2006.PROPANOYL PROPANOATE",
        choice="VDIWA2006.PROPENE",
        choice="VDIWA2006.PROPOXYPROPANE",
        choice="VDIWA2006.PROPYL KETONE",
        choice="VDIWA2006.PROPYL-ACETATE",
        choice="VDIWA2006.PROPYL-FORMATE",
        choice="VDIWA2006.PROPYLAMINE",
        choice="VDIWA2006.PROPYLBENZENE",
        choice="VDIWA2006.PROPYLCYCLOHEXANE",
        choice="VDIWA2006.PROPYLCYCLOPENTANE",
        choice="VDIWA2006.PYRIDINE",
        choice="VDIWA2006.STYRENE",
        choice="VDIWA2006.SULFUR",
        choice="VDIWA2006.SULFUR DIOXIDE",
        choice="VDIWA2006.SULFUR HEXAFLUORIDE",
        choice="VDIWA2006.SULFUR TRIOXIDE",
        choice="VDIWA2006.SULFURY CHLORIDE",
        choice="VDIWA2006.TETRABROMOMETHANE",
        choice="VDIWA2006.TETRACHLOROCARBON",
        choice="VDIWA2006.TETRACHLOROETHENE",
        choice="VDIWA2006.TETRADECANE",
        choice="VDIWA2006.TETRAFLUOROMETHANE",
        choice="VDIWA2006.TETRAPHENYLMETHANE",
        choice="VDIWA2006.THIOPHENE",
        choice="VDIWA2006.TRIBROMOMETHANE",
        choice="VDIWA2006.TRICHLOROACETIC ACID",
        choice="VDIWA2006.TRICHLOROETHYLENE",
        choice="VDIWA2006.TRICHLOROFLUOROMETHANE",
        choice="VDIWA2006.TRICHLOROMETHANE",
        choice="VDIWA2006.TRIDECANE",
        choice="VDIWA2006.TRIETHYLAMINE",
        choice="VDIWA2006.TRIFLUOROMETHANE",
        choice="VDIWA2006.TRIMETHYLAMINE",
        choice="VDIWA2006.TRIPHENYLMETHANE",
        choice="VDIWA2006.UNDECANE",
        choice="VDIWA2006.WATER",
        choice="VDIWA2006.XENON"),
        Protection(access=Access.packageDuplicate));

    end GasName;

    type VLEFluidName "VLEFluid name"
      extends String;
    annotation(choices(
        choice="TILMedia.CO2",
        choice="TILMedia.R134A",
        choice="TILMedia.R1234YF",
        choice="TILMedia.1-BUTENE",
        choice="TILMedia.ACETONE",
        choice="TILMedia.AMMONIA",
        choice="TILMedia.ARGON",
        choice="TILMedia.CARBONYLSULFIDE",
        choice="TILMedia.CO2(EOS=AClibReferenceProperties)",
        choice="TILMedia.CO2(EOS=AClibTechnical)",
        choice="TILMedia.CYCLOPENTANE",
        choice="TILMedia.D4",
        choice="TILMedia.D5",
        choice="TILMedia.DEUTERIUM",
        choice="TILMedia.DIMETHYLCARBONATE",
        choice="TILMedia.DIMETHYLETHER",
        choice="TILMedia.ETHANE",
        choice="TILMedia.ETHANOL",
        choice="TILMedia.ETHYLBENZENE",
        choice="TILMedia.ETHYLENE",
        choice="TILMedia.HEAVYWATER",
        choice="TILMedia.HELIUM",
        choice="TILMedia.HYDROGEN",
        choice="TILMedia.HYDROGENSULFIDE",
        choice="TILMedia.ISOBUTANE",
        choice="TILMedia.ISOPENTANE",
        choice="TILMedia.KRYPTON",
        choice="TILMedia.M-XYLENE",
        choice="TILMedia.MD4M",
        choice="TILMedia.METHANE",
        choice="TILMedia.METHYLLINOLEATE",
        choice="TILMedia.METHYLOLEATE",
        choice="TILMedia.METHYLPALMITATE",
        choice="TILMedia.METHYLSTEARATE",
        choice="TILMedia.MM",
        choice="TILMedia.N-BUTANE",
        choice="TILMedia.N-DODECANE",
        choice="TILMedia.N-NONANE",
        choice="TILMedia.NEON",
        choice="TILMedia.NEOPENTANE",
        choice="TILMedia.NITROGEN",
        choice="TILMedia.NITROUSOXIDE",
        choice="TILMedia.O-XYLENE",
        choice="TILMedia.ORTHOHYDROGEN",
        choice="TILMedia.OXYGEN",
        choice="TILMedia.P-XYLENE",
        choice="TILMedia.PARAHYDROGEN",
        choice="TILMedia.PROPANE",
        choice="TILMedia.PROPYLENE",
        choice="TILMedia.R113",
        choice="TILMedia.R116",
        choice="TILMedia.R12",
        choice="TILMedia.R1233ZDE",
        choice="TILMedia.R1234ZEE",
        choice="TILMedia.R1234ZEZ",
        choice="TILMedia.R124",
        choice="TILMedia.R125",
        choice="TILMedia.R1336MZZ",
        choice="TILMedia.R141B",
        choice="TILMedia.R142B",
        choice="TILMedia.R143A",
        choice="TILMedia.R161",
        choice="TILMedia.R218",
        choice="TILMedia.R227EA",
        choice="TILMedia.R23",
        choice="TILMedia.R245FA",
        choice="TILMedia.R32",
        choice="TILMedia.R365MFC",
        choice="TILMedia.R404APPF",
        choice="TILMedia.R407CPPF",
        choice="TILMedia.R410APPF",
        choice="TILMedia.R507APPF",
        choice="TILMedia.RC318",
        choice="TILMedia.SES36",
        choice="TILMedia.SULFURHEXAFLUORIDE",
        choice="TILMedia.TOLUENE",
        choice="TILMedia.WATER",
        choice="TILMedia.XENON",
        choice="TILMediaRT.CO2",
        choice="TILMediaRT.R1234YF",
        choice="TILMediaRT.R134A",
        choice="TILMediaRT.R407C",
        choice="TILMediaRT.R410A",
        choice="TILMediaRT.WATER",
        choice="Refprop.13BUTADIENE.FLD",
        choice="Refprop.1BUTENE.FLD",
        choice="Refprop.1BUTYNE.FLD",
        choice="Refprop.1PENTENE.FLD",
        choice="Refprop.22DIMETHYLBUTANE.FLD",
        choice="Refprop.23DIMETHYLBUTANE.FLD",
        choice="Refprop.3METHYLPENTANE.FLD",
        choice="Refprop.ACETONE.FLD",
        choice="Refprop.ACETYLENE.FLD",
        choice="Refprop.AIR.MIX",
        choice="Refprop.AIR.PPF",
        choice="Refprop.AMARILLO.MIX",
        choice="Refprop.AMMONIA.FLD",
        choice="Refprop.ARGON.FLD",
        choice="Refprop.BENZENE.FLD",
        choice="Refprop.BUTANE.FLD",
        choice="Refprop.C11.FLD",
        choice="Refprop.C12.FLD",
        choice="Refprop.C16.FLD",
        choice="Refprop.C1CC6.FLD",
        choice="Refprop.C22.FLD",
        choice="Refprop.C2BUTENE.FLD",
        choice="Refprop.C3CC6.FLD",
        choice="Refprop.C4F10.FLD",
        choice="Refprop.C5F12.FLD",
        choice="Refprop.C6F14.FLD",
        choice="Refprop.CF3I.FLD",
        choice="Refprop.CHLORINE.FLD",
        choice="Refprop.CHLOROBENZENE.FLD",
        choice="Refprop.CO.FLD",
        choice="Refprop.CO2.FLD",
        choice="Refprop.CO2_ACL.FLD",
        choice="Refprop.COS.FLD",
        choice="Refprop.CYCLOBUTENE.FLD",
        choice="Refprop.CYCLOHEX.FLD",
        choice="Refprop.CYCLOPEN.FLD",
        choice="Refprop.CYCLOPRO.FLD",
        choice="Refprop.D2.FLD",
        choice="Refprop.D2O.FLD",
        choice="Refprop.D4.FLD",
        choice="Refprop.D5.FLD",
        choice="Refprop.D6.FLD",
        choice="Refprop.DEA.FLD",
        choice="Refprop.DECANE.FLD",
        choice="Refprop.DEE.FLD",
        choice="Refprop.DMC.FLD",
        choice="Refprop.DME.FLD",
        choice="Refprop.EBENZENE.FLD",
        choice="Refprop.EGLYCOL.FLD",
        choice="Refprop.EKOFISK.MIX",
        choice="Refprop.ETHANE.FLD",
        choice="Refprop.ETHANOL.FLD",
        choice="Refprop.ETHYLENE.FLD",
        choice="Refprop.ETHYLENEOXIDE.FLD",
        choice="Refprop.FLUORINE.FLD",
        choice="Refprop.GLFCOAST.MIX",
        choice="Refprop.H2S.FLD",
        choice="Refprop.HCL.FLD",
        choice="Refprop.HELIUM.FLD",
        choice="Refprop.HEPTANE.FLD",
        choice="Refprop.HEXANE.FLD",
        choice="Refprop.HFE-7100.FLD",
        choice="Refprop.HFE-7200.FLD",
        choice="Refprop.HFE-7300.FLD",
        choice="Refprop.HFE-7500.FLD",
        choice="Refprop.HIGHCO2.MIX",
        choice="Refprop.HIGHN2.MIX",
        choice="Refprop.HYDROGEN.FLD",
        choice="Refprop.IBUTENE.FLD",
        choice="Refprop.IHEXANE.FLD",
        choice="Refprop.IOCTANE.FLD",
        choice="Refprop.IPENTANE.FLD",
        choice="Refprop.ISOBUTAN.FLD",
        choice="Refprop.KRYPTON.FLD",
        choice="Refprop.MD2M.FLD",
        choice="Refprop.MD3M.FLD",
        choice="Refprop.MD4M.FLD",
        choice="Refprop.MDM.FLD",
        choice="Refprop.MEA.FLD",
        choice="Refprop.METHANE.FLD",
        choice="Refprop.METHANOL.FLD",
        choice="Refprop.MLINOLEA.FLD",
        choice="Refprop.MLINOLEN.FLD",
        choice="Refprop.MM.FLD",
        choice="Refprop.MOLEATE.FLD",
        choice="Refprop.MPALMITA.FLD",
        choice="Refprop.MSTEARAT.FLD",
        choice="Refprop.MXYLENE.FLD",
        choice="Refprop.N2O.FLD",
        choice="Refprop.NEON.FLD",
        choice="Refprop.NEOPENTN.FLD",
        choice="Refprop.NF3.FLD",
        choice="Refprop.NGSAMPLE.MIX",
        choice="Refprop.NITROGEN.FLD",
        choice="Refprop.NONANE.FLD",
        choice="Refprop.NOVEC649.FLD",
        choice="Refprop.NOVEC7000.FLD",
        choice="Refprop.NOVEC774.FLD",
        choice="Refprop.OCTANE.FLD",
        choice="Refprop.ORTHOHYD.FLD",
        choice="Refprop.OXYGEN.FLD",
        choice="Refprop.OXYLENE.FLD",
        choice="Refprop.PARAHYD.FLD",
        choice="Refprop.PENTANE.FLD",
        choice="Refprop.PROPADIENE.FLD",
        choice="Refprop.PROPANE.FLD",
        choice="Refprop.PROPYLEN.FLD",
        choice="Refprop.PROPYLENEOXIDE.FLD",
        choice="Refprop.PROPYNE.FLD",
        choice="Refprop.PXYLENE.FLD",
        choice="Refprop.R11.FLD",
        choice="Refprop.R1123.FLD",
        choice="Refprop.R113.FLD",
        choice="Refprop.R114.FLD",
        choice="Refprop.R115.FLD",
        choice="Refprop.R116.FLD",
        choice="Refprop.R12.FLD",
        choice="Refprop.R1216.FLD",
        choice="Refprop.R1224YDZ.FLD",
        choice="Refprop.R123.FLD",
        choice="Refprop.R1233ZDE.FLD",
        choice="Refprop.R1234YF.FLD",
        choice="Refprop.R1234ZEE.FLD",
        choice="Refprop.R1234ZEZ.FLD",
        choice="Refprop.R124.FLD",
        choice="Refprop.R1243ZF.FLD",
        choice="Refprop.R125.FLD",
        choice="Refprop.R13.FLD",
        choice="Refprop.R1336MZZZ.FLD",
        choice="Refprop.R134A.FLD",
        choice="Refprop.R14.FLD",
        choice="Refprop.R141B.FLD",
        choice="Refprop.R142B.FLD",
        choice="Refprop.R143A.FLD",
        choice="Refprop.R150.FLD",
        choice="Refprop.R152A.FLD",
        choice="Refprop.R161.FLD",
        choice="Refprop.R21.FLD",
        choice="Refprop.R218.FLD",
        choice="Refprop.R22.FLD",
        choice="Refprop.R227EA.FLD",
        choice="Refprop.R23.FLD",
        choice="Refprop.R236EA.FLD",
        choice="Refprop.R236FA.FLD",
        choice="Refprop.R245CA.FLD",
        choice="Refprop.R245FA.FLD",
        choice="Refprop.R32.FLD",
        choice="Refprop.R365MFC.FLD",
        choice="Refprop.R40.FLD",
        choice="Refprop.R401A.MIX",
        choice="Refprop.R401B.MIX",
        choice="Refprop.R401C.MIX",
        choice="Refprop.R402A.MIX",
        choice="Refprop.R402B.MIX",
        choice="Refprop.R403A.MIX",
        choice="Refprop.R403B.MIX",
        choice="Refprop.R404A.MIX",
        choice="Refprop.R404A.PPF",
        choice="Refprop.R405A.MIX",
        choice="Refprop.R406A.MIX",
        choice="Refprop.R407A.MIX",
        choice="Refprop.R407B.MIX",
        choice="Refprop.R407C.MIX",
        choice="Refprop.R407C.PPF",
        choice="Refprop.R407D.MIX",
        choice="Refprop.R407E.MIX",
        choice="Refprop.R407F.MIX",
        choice="Refprop.R407G.MIX",
        choice="Refprop.R407H.MIX",
        choice="Refprop.R408A.MIX",
        choice="Refprop.R409A.MIX",
        choice="Refprop.R409B.MIX",
        choice="Refprop.R41.FLD",
        choice="Refprop.R410A.MIX",
        choice="Refprop.R410A.PPF",
        choice="Refprop.R410B.MIX",
        choice="Refprop.R411A.MIX",
        choice="Refprop.R411B.MIX",
        choice="Refprop.R412A.MIX",
        choice="Refprop.R413A.MIX",
        choice="Refprop.R414A.MIX",
        choice="Refprop.R414B.MIX",
        choice="Refprop.R415A.MIX",
        choice="Refprop.R415B.MIX",
        choice="Refprop.R416A.MIX",
        choice="Refprop.R417A.MIX",
        choice="Refprop.R417B.MIX",
        choice="Refprop.R417C.MIX",
        choice="Refprop.R418A.MIX",
        choice="Refprop.R419A.MIX",
        choice="Refprop.R419B.MIX",
        choice="Refprop.R420A.MIX",
        choice="Refprop.R421A.MIX",
        choice="Refprop.R421B.MIX",
        choice="Refprop.R422A.MIX",
        choice="Refprop.R422B.MIX",
        choice="Refprop.R422C.MIX",
        choice="Refprop.R422D.MIX",
        choice="Refprop.R422E.MIX",
        choice="Refprop.R423A.MIX",
        choice="Refprop.R424A.MIX",
        choice="Refprop.R425A.MIX",
        choice="Refprop.R426A.MIX",
        choice="Refprop.R427A.MIX",
        choice="Refprop.R428A.MIX",
        choice="Refprop.R429A.MIX",
        choice="Refprop.R430A.MIX",
        choice="Refprop.R431A.MIX",
        choice="Refprop.R432A.MIX",
        choice="Refprop.R433A.MIX",
        choice="Refprop.R433B.MIX",
        choice="Refprop.R433C.MIX",
        choice="Refprop.R434A.MIX",
        choice="Refprop.R435A.MIX",
        choice="Refprop.R436A.MIX",
        choice="Refprop.R436B.MIX",
        choice="Refprop.R437A.MIX",
        choice="Refprop.R438A.MIX",
        choice="Refprop.R439A.MIX",
        choice="Refprop.R440A.MIX",
        choice="Refprop.R441A.MIX",
        choice="Refprop.R442A.MIX",
        choice="Refprop.R443A.MIX",
        choice="Refprop.R444A.MIX",
        choice="Refprop.R444B.MIX",
        choice="Refprop.R445A.MIX",
        choice="Refprop.R446A.MIX",
        choice="Refprop.R447A.MIX",
        choice="Refprop.R447B.MIX",
        choice="Refprop.R448A.MIX",
        choice="Refprop.R449A.MIX",
        choice="Refprop.R449B.MIX",
        choice="Refprop.R449C.MIX",
        choice="Refprop.R450A.MIX",
        choice="Refprop.R451A.MIX",
        choice="Refprop.R451B.MIX",
        choice="Refprop.R452A.MIX",
        choice="Refprop.R452B.MIX",
        choice="Refprop.R452C.MIX",
        choice="Refprop.R453A.MIX",
        choice="Refprop.R454A.MIX",
        choice="Refprop.R454B.MIX",
        choice="Refprop.R454C.MIX",
        choice="Refprop.R455A.MIX",
        choice="Refprop.R456A.MIX",
        choice="Refprop.R457A.MIX",
        choice="Refprop.R458A.MIX",
        choice="Refprop.R459A.MIX",
        choice="Refprop.R459B.MIX",
        choice="Refprop.R460A.MIX",
        choice="Refprop.R460B.MIX",
        choice="Refprop.R500.MIX",
        choice="Refprop.R501.MIX",
        choice="Refprop.R502.MIX",
        choice="Refprop.R503.MIX",
        choice="Refprop.R504.MIX",
        choice="Refprop.R507A.MIX",
        choice="Refprop.R507A.PPF",
        choice="Refprop.R508A.MIX",
        choice="Refprop.R508B.MIX",
        choice="Refprop.R509A.MIX",
        choice="Refprop.R510A.MIX",
        choice="Refprop.R511A.MIX",
        choice="Refprop.R512A.MIX",
        choice="Refprop.R513A.MIX",
        choice="Refprop.R513B.MIX",
        choice="Refprop.R515A.MIX",
        choice="Refprop.RC318.FLD",
        choice="Refprop.RE143A.FLD",
        choice="Refprop.RE245CB2.FLD",
        choice="Refprop.RE245FA2.FLD",
        choice="Refprop.RE347MCC.FLD",
        choice="Refprop.SF6.FLD",
        choice="Refprop.SO2.FLD",
        choice="Refprop.T2BUTENE.FLD",
        choice="Refprop.TOLUENE.FLD",
        choice="Refprop.VINYLCHLORIDE.FLD",
        choice="Refprop.WATER.FLD",
        choice="Refprop.XENON.FLD"),
        Protection(access=Access.packageDuplicate));

    end VLEFluidName;

    record CriticalDataRecord "Critical data record"
       extends .TILMedia.Internals.ClassTypes.Record;

      SI.Density d "Critical density";
      SI.SpecificEnthalpy h "Critical specific enthalpy";
      SI.AbsolutePressure p "Critical pressure";
      SI.SpecificEntropy s "Critical specific entropy";
      SI.Temperature T "Critical temperature";
      annotation(defaultComponentName="crit",
        Protection(access=Access.packageDuplicate));
    end CriticalDataRecord;

    record PropertyRecord "Property record"
      extends .TILMedia.Internals.ClassTypes.Record;
      SI.Density d=0 "Density";
      SI.SpecificEnthalpy h=0 "Specific enthalpy";
      SI.AbsolutePressure p=0 "Pressure";
      SI.SpecificEntropy s=0 "Specific entropy";
      SI.Temperature T=0 "Temperature";
      SI.MassFraction q=0 "Steam mass fraction (quality)";
      SI.SpecificHeatCapacity cp=0 "Specific isobaric heat capacity cp";

      .TILMedia.Internals.CriticalDataRecord crit=
               .TILMedia.Internals.CriticalDataRecord(d=0.0,T=0.0,p=0.0,h=0.0,s=0.0)
        "Critical data record";
      .TILMedia.Internals.VLERecordSimple VLE=
               .TILMedia.Internals.VLERecordSimple(d_l=0.0, h_l=0.0, p_l=0.0, s_l=0.0, T_l=0.0, d_v=0.0, h_v=0.0, p_v=0.0, s_v=0.0, T_v=0.0)
        "Saturation property record";
      .TILMedia.Internals.VLETransportPropertyRecord VLETransp=
               .TILMedia.Internals.VLETransportPropertyRecord(Pr_l=0.0, Pr_v=0.0, eta_l=0.0, eta_v=0.0, lambda_l=0.0, lambda_v=0.0)
        "Saturation property record";
      .TILMedia.Internals.TransportPropertyRecord transp=
               .TILMedia.Internals.TransportPropertyRecord(Pr=0.0,lambda=0.0,eta=0.0,sigma=0.0)
        "Transport property record";

      annotation(defaultComponentName="properties",
        Protection(access=Access.packageDuplicate));
    end PropertyRecord;

    record VLERecord "VLE property record"
      extends .TILMedia.Internals.ClassTypes.Record;
      SI.Density d_l "Density of liquid phase";
      SI.Density d_v "Density of vapour phase";
      SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      SI.AbsolutePressure p_l "Pressure of liquid phase";
      SI.AbsolutePressure p_v "Pressure of vapour phase";
      SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      SI.Temperature T_l "Temperature of liquid phase";
      SI.Temperature T_v "Temperature of vapour phase";
      SI.MassFraction[nc-1] xi_l "Mass fraction of liquid phase";
      SI.MassFraction[nc-1] xi_v "Mass fraction of vapour phase";
      parameter Integer nc(start=1);

    annotation (Protection(access=Access.packageDuplicate));
    end VLERecord;

    record VLERecordSimple "VLE property record"
      extends .TILMedia.Internals.ClassTypes.Record;
      SI.Density d_l "Density of liquid phase";
      SI.Density d_v "Density of vapour phase";
      SI.SpecificEnthalpy h_l "Specific enthalpy of liquid phase";
      SI.SpecificEnthalpy h_v "Specific enthalpy of vapour phase";
      SI.AbsolutePressure p_l "Pressure of liquid phase";
      SI.AbsolutePressure p_v "Pressure of vapour phase";
      SI.SpecificEntropy s_l "Specific entropy of liquid phase";
      SI.SpecificEntropy s_v "Specific entropy of vapour phase";
      SI.Temperature T_l "Temperature of liquid phase";
      SI.Temperature T_v "Temperature of vapour phase";
      annotation (Protection(access=Access.packageDuplicate));
    end VLERecordSimple;

    record AdditionalVLERecord "Additional VLE property record"
       extends .TILMedia.Internals.ClassTypes.Record;
      SI.SpecificHeatCapacity cp_l
        "Specific heat capacity cp of liquid phase";
      SI.SpecificHeatCapacity cp_v
        "Specific heat capacity cp of vapour phase";
      SI.LinearExpansionCoefficient beta_l
        "Isobaric expansion coefficient of liquid phase";
      SI.LinearExpansionCoefficient beta_v
        "Isobaric expansion coefficient of vapour phase";
      SI.Compressibility kappa_l
        "Isothermal compressibility of liquid phase";
      SI.Compressibility kappa_v
        "Isothermal compressibility of vapour phase";

    annotation (Protection(access=Access.packageDuplicate));
    end AdditionalVLERecord;

    record VLETransportPropertyRecord "Transport property record"
       extends .TILMedia.Internals.ClassTypes.Record;
      SI.PrandtlNumber Pr_l "Prandtl number of liquid phase";
      SI.PrandtlNumber Pr_v "Prandtl number of vapour phase";
      SI.ThermalConductivity lambda_l "Thermal conductivity of liquid phase";
      SI.ThermalConductivity lambda_v "Thermal conductivity of vapour phase";
      SI.DynamicViscosity eta_l(min=-1) "Dynamic viscosity of liquid phase";
      SI.DynamicViscosity eta_v(min=-1) "Dynamic viscosity of vapour phase";

      annotation(defaultComponentName="transp",
        Protection(access=Access.packageDuplicate));
    end VLETransportPropertyRecord;

    record TransportPropertyRecord "Transport property record"
       extends .TILMedia.Internals.ClassTypes.Record;
      SI.PrandtlNumber Pr "Prandtl number";
      SI.ThermalConductivity lambda "Thermal conductivity";
      SI.DynamicViscosity eta(min=-1) "Dynamic viscosity";
      SI.SurfaceTension sigma "Surface tension";
      annotation(defaultComponentName="transp",
        Protection(access=Access.packageDuplicate));
    end TransportPropertyRecord;

    function calcComputeFlags
      input Boolean computeTransportProperties;
      input Boolean interpolateTransportProperties;
      input Boolean computeSurfaceTension;
      input Boolean deactivateTwoPhaseRegion;
      input Boolean deactivateDensityDerivatives;
      output Integer flags;
    algorithm
      flags := array(1,2,4,8,16)*array(if (computeTransportProperties) then 1 else 0,if (interpolateTransportProperties) then 1 else 0,if (computeSurfaceTension) then 1 else 0,if (deactivateTwoPhaseRegion) then 1 else 0,if (deactivateDensityDerivatives) then 1 else 0);
    //  flags := 0;
    /*  if computeTransportProperties then
    flags := flags + 1;
  end if;
  if interpolateTransportProperties then
    flags := flags + 2;
  end if;
  if computeSurfaceTension then
    flags := flags + 4;
  end if;
  if deactivateTwoPhaseRegion then
    flags := flags + 8;
  end if;
  if deactivateDensityDerivatives then
    flags := flags + 16;
  end if;
*/

      annotation(Inline=true);
    end calcComputeFlags;

    function redirectModelicaFormatMessage
      input Real y=0;
      //protected
      output Integer x;
      external "C" x = TILMedia_redirectModelicaFormatMessage_wrapper() annotation(__iti_dllNoExport = true,
        Include="static int TILMedia_redirectModelicaFormatMessage_wrapper() { return 0; }");
    annotation(Inline=false, LateInline=true);
    end redirectModelicaFormatMessage;

    function concatNames
     input String names[:];
     output String concatName;
    algorithm
      concatName := "";
      if (size(names, 1)>0) then
      concatName := names[1];
      end if;

        for i in 2:size(names, 1) loop
          concatName := concatName + "|" + names[i];
        end for;
    end concatNames;

    function getPropertiesVLE
      input Real d,  h,  p,  s,  T,  cp,  q;
      input Real d_crit,  h_crit,  p_crit,  s_crit,  T_crit;
      input Real d_l,  h_l,  p_l,  s_l,  T_l,  d_v,  h_v,  p_v,  s_v,  T_v;
      input Real Pr,  lambda,  eta,  sigma;
      input Real Pr_l,  Pr_v,  lambda_l,  lambda_v,  eta_l,  eta_v;
      output .TILMedia.Internals.PropertyRecord properties;
    algorithm
      properties.d := d;
      properties.h := h;
      properties.p := p;
      properties.s := s;
      properties.T := T;
      properties.cp := cp;
      properties.q := q;
      properties.VLE := .TILMedia.Internals.VLERecordSimple(
        d_l=d_l,
        h_l=h_l,
        p_l=p_l,
        s_l=s_l,
        T_l=T_l,
        d_v=d_v,
        h_v=h_v,
        p_v=p_v,
        s_v=s_v,
        T_v=T_v);
      properties.VLETransp := .TILMedia.Internals.VLETransportPropertyRecord(
        Pr_l=Pr_l,
        Pr_v=Pr_v,
        lambda_l=lambda_l,
        lambda_v=lambda_v,
        eta_l=eta_l,
        eta_v=eta_v);
      properties.transp := .TILMedia.Internals.TransportPropertyRecord(
        Pr=Pr,
        lambda=lambda,
        eta=eta,
        sigma=sigma);
      properties.crit := .TILMedia.Internals.CriticalDataRecord(
        d=d_crit,
        h=h_crit,
        p=p_crit,
        s=s_crit,
        T=T_crit);
    end getPropertiesVLE;

    class TILMediaExternalObject
      extends ExternalObject;
      function constructor "get memory"
        input String objectType;
        input String mediumName;
        input Integer flags;
        input Real[:] xi;
        input Integer nc;
        input Integer condensingIndex;
        input String instanceName;
        output TILMediaExternalObject externalObject;
    protected
        Integer nc_propertyCalculation=1;
      external "C" externalObject = TILMedia_createExternalObject(
              objectType,
              mediumName,
              flags,
              xi,
              nc,
              condensingIndex,
              instanceName) annotation (
          __iti_dllNoExport=true,
          Include="static void* TILMedia_createExternalObject(char*, char*, int, double*, int, int, char*) { return NULL; }");
      end constructor;

      function destructor "free memory"
        input TILMediaExternalObject externalObject;
      external "C" TILMedia_destroyExternalObject(externalObject) annotation (
          __iti_dllNoExport=true,
          Include="static void TILMedia_destroyExternalObject(void*) { return; }");
      end destructor;
    end TILMediaExternalObject;

    function massFraction_mixingRatio "conversion function"
      input Real[:] mixingRatio;
      output Real[size(mixingRatio, 1)-1] massFraction=mixingRatio[1:end - 1]/sum(mixingRatio);
    algorithm
    end massFraction_mixingRatio;
    annotation (Icon(graphics={Bitmap(extent={{-100,-100},{100,100}},
            imageSource="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",
            fileName="modelica://TILMedia/Images/Icon_Package_Internals.png")}));
  end Internals;
annotation (
preferredView="info",
   version="1.6.0 ClaRa",
   uses(Modelica(version="4.0.0")),
Documentation(info="<html>
<p><img src=\"modelica://TILMedia/Images/infoTILMedia.png\" ></p>
</html>"),                 Icon(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={1,1}), graphics={
                         Bitmap(
        extent={{-100,-100},{100,100}},
          imageSource="iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAYAAAB5fY51AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNvyMY98AAC1uSURBVHhe7Z0JeFTV2ccnCTuCgCCigAhaXCqCUBVRUaviUrS2Uq1aUNtPadViVdS2aoSEhOz7RvZAtskyk8ky2Sf7OlkICSGTjYRACAmLFgQFcr773rmDES8aIMncmfx/z/N/4JnM3HvPuee+9z3vOec9MgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgCHj4MGs+b3dmsMdrQnn9tR4XtCRbs25vm7Ne4wxC+GrAAAw8jQ3pcapU95ThQWtVgX63NMUEbSS+bgtZLZfyHjZfC5j9BkpLHh1Smryu6rKcl9VR1v+U8IhAABgaOnr000tLXVfUlxg92ZZiduZXaFPnLHfMvGM/Vdjmf0WK7Z9iyUnGXPYKmOONjLmZKsX/Z8+I+m/Y8V9fwzb9oXlWX+vu85kZ3xyJsj/vsfS0j5eUl8vHyecDgAAroyaqhD78KBHckIC7mfO26bwhomMkaudjHk4ypi3i4z5uclYgIeM7fCUsUAvGQv21ov+H8h9Rn+j7/hw3/V0kjE3exl3LL0hs//KkgV43cUcbKYkFORsCWttzZovnBoAAH4exphVbW3ELW2tWbpQ//u/cbCZeN5hqyVz4QwMGShfV70hCvWTsZ07ZCwySMaiQmQsNkwvefiPZfg8OpT7bjD3m0AZC/fnDJqPjPm7y5gXZ8BcOQPGe2I245n79htOFubZpOfn29wiXBIAAIijTnnfOTriGc6AjOU9KQ8HzjviDEsIZ2AiOAMVTcaJM0RxETKWsEuvxMjByfD9+J2cMeN+H0NGjDN4ZPzIO/NyljEXznNztBnDwgMfZKE7HnatqQm7S7g0AACQyXp7i6aoVe/euzPk0SNOthPPU3eNjAd5UgYjRd7S5RqowYiOR8aPvDDyvsjzoq6j3nCNpe7iiWaduig0dMME4XIBAKOV0mz32dnpm2u8nG/kPSrqogV5y9guznjEcEaEvKGhNlKXEu95cYaRvK6Bhst522QWGnC//EBHyTvCZQMARhOMWVumeTw9PthvRYez7TjmznX9qFtGcSnydsh4iBmVkRAZSDJcu8hwccbT05EC/WO4rumtZ4sLHP7BXT7mdAEwmtCWedsG+S7hR+sokB7mr48pGdNQXSy6FjKeEQH6AD2NTPq638KC/O79P6EYAABzp7YqNNLD6XrmZm/Be1XkyRhiVGKGw9giwxUVrO8m0kilk+2Ec2mqd+o7O2tuEooEADBH5FG/t3bbfi3fzSIDQAF1MghSNVYGGbwt8gRp7pfLtrGsOH/b2a6umqVC0QAA5kRS4oZId4dr+RFAevDJAEjdUF0sGlGk0USaiOpqP4alqzYeOXy4bqFQRACAqWNtbW1ZnG9j6+U8i/dOKCYk5S7gL4mMFo1i6o3WWFZe7HJeKCoAwNTp6iqN2OF9Kz9NgIwVPfBihsCUxButIH0w3t1xMgvyu2erUFwAgKkSFfj4bB+3eYeoGxhuJsbKIIPR8uU8LT/3G8/n5Xy+Xig2AMDUKCpymBIb+UyNp6MVv/zFlLuBlxIZLZo7Rt7jzpAH2LFjLV8KxQcAmBKtzer9Xs6T+MmXNMfK3IyVQWS0yHv0dLRgkWGPVWq1AZOEKgAAmAJlxW6/D/C6+VtK7ULZFMzVWBlEI540TcPXbTqLiXz6WaEaAABSRy5fZ+XnOd/P28WSnwIgpdnrwyV+cilnmMlAR4c/9HV7u+YGoToAAFKmrSXdLth3HgvxNc+41aVERouyS1CSwMpSlxqhOgAAUoWx+nGpite/oeH+0dAVHCgqK3UNKdtEiN9t37e3Z7woVAsAQIq0t6aH+bhOMrspDIMVGS2a6hDgOZEV5HwapNVqxwpVAwCQGkF+t4Tt8LLkUxKPJu9qoKgbTAF4pfxZptH84xqhagAAUqK0wHpJdPhS3rsaDYH2S8ngZfm7j2eVxfbPCdUDAJASzfsU1Ts8x/IZGEard2WQIZaVmvRai1A9AAApkZn65hma0T4aY1cXyzBi6OM67uDu3TvnClUEAJAKAe6TzlA+9NHuXZGoDiiOF+o3lWWm/e0DoYoAAFJg755wRZD3GL4rJPYAj0aRpxnqZ8liIu5zYUwzRqgqAICxUcqfUoX7W6I7OEDkZdFM/yz1X9g+beRMoaoAAMaks7NkYqDXlFx6ONEd/EF8t5AGIKKWM5XqzzBYAEiBffviVyVGrxjVc68uJZqTFeY/mQUEzIHBAkAKlBT8e1Xcrtv4LeTFHtrRLH0cS8Y62jObheoCABiTpJhHV0WFXof4lYgM0xvqd/v3CNUFADAmu0IXrooMnjSqZ7dfStRFpqkeJfmfwGABIAUCPWWrEHC/tChrRX7OOzBYAEgBMliYMHpp0UhhUtwjMFgASIFAP9kq2sodBktclM8+KW4VDBYAUiBUMFhiDyukXwitiofBAkASwGD9vGi6R476JRgsAKTArsBrVsWEjhF9WCG9wSov+RgGCwApkJr06KqEyOtEH1ZI3yWsKt8CgwWAFCjI3bBKGTsPQfdLiJYstbcqYLAAkAJ79vitSk28GwbrEooJtWLJyQ/cJFQXAMCYHD6cPTsxeu7ueBgsUaniFjKVajUWP4PRx4EDZXMVijfmWVtbWwofSYIk+W2q+J0Wog/saBZ5nZqMZ5lWay0pg+XsPGdmebk3dqcGw0d+7pcvp6k2fr8z5DEWG/vSDOFjSbBb+5UqLgIjhReL1ldq0p9O6e8smShUldE5eFA7P8hveVNUxDNHSotc7fp1uvHCnwC4Oii1rkKxaZom+/NOF/vppx22WjJP5+tYYOBcSRmsr4/vi5ZHjBd9aEezEiInsszk1ZLK6d7enLVyV+gq5rDVgjnbTWEpir8dPtRV+RFjzEL4CgBXRqpqo2d4kL5xuW+XMT832olFxhr2hGwSviIZMlT3nUHg/cdSxd7AOtqTJGWw8vI+W7kr+Da+LXk6ypijjQXb4X0X2+F7z+dNDYqHha8BMDi4N52lRv3ZE37ui1ucbCcxVzsZ8+WMVKi/jEUGUwZLGWtsiOgWvi4ZWpqCv0WKmR9Exjst8dcdx461XitUkSRIjF2zMjLker4t0aa3/u4y5mZPhmss8/O8/XhLc8Y+qcVIgQRhTG5VWxv+cqb6gwMu9tcyZ1sZ83bWb3tOjYsS5NFDsCtQxrLT35ScwcpOe3pJctyNog/vaBQZ79amcMltpFpe9Pl/IwKs+PZEovQ3lBWVPHfnbTJmv8WChe54oDA3/bOXhZ8A8FPUKe9leLnO5950lsyDc9V3eOl3XaG84AO7WtTAIoMXSc5gHTtctaQwZy3mYwlSK+9khzoylgvVIxnqd/ufG5i/jP4lw0Xb6wd7y5iXk4w52VpwbfB6FrtrbW17u2ap8FMw2ulqy1kctmPVnyKCHuqngLrbdr2LTq56TJj+LX3xg0DpSoK8xh5rbk66VTiMZKirsQ5TRCH4nhhpyarLP6ijHYWEqpEMGckvnSOP/eIXC7U1WkZExmyHp4x5OMiYw1YZ83VfxKqrAvekpb0/SzgEGI10dVWkhwau6nLeNom5GOJUnGtOCd8M3b+BDcog8rgidkxhlWVOW4VDSYbe3orFGUl3nRK77tGklPg5rK5m2+tCtUiKsIBZ5+ilJ3bdJDJc9Pcw7qXpx708Xe3J4xrHXOxn1pcUOoYIhwGjhUKN7QOJ8ldSHWzGcw2Bc8ENcSrOJb+4+ycmMmYRO8aymIh7JWewiBZdaOFo9rLo/uVlPF4rxWkCnR2a3CAfq1/c4YjKQIaLwg8hvjLm46KPbznZTuhPT3n3XGbaP3/b29t4o3BYYI7odNl3KmJfTfL3uv28WJxKrPsnJvoe/SZF8bumrq7y64TDS4b9+2NvKda8IHrto0FpiQtYV4fyCaE6JEW2+q95Yf4WLG6QbY0MF7VNepkGUXyLe7k62XD/usxjqoQN9WVl1lOFQwNzoUi5eUqzLq082H/Fdw42VvwQ8oU4Fed6D9ZQGUSNiN58itgHmEbzyVzhNJKBPIuq8k2fKmOuOSt2/eYsRdRY1tTg0s6YdqxQHZKhp6f+mhC/OZUDA+6DFX2f4lu0ZVmAp4yfE0gvXbfts87kZH3m39yQdJdwGmDK1FaH2vh6/CrTdfs05sK51IONU/2SqPGE+E5kOzxmSM5gGagp33RE7NrNWWkJ85p2l70vyXuypyboqZjwxfrt86+w3dHLldLl0FxAQ3zLxX4y2xn6+LmyYvfQU6c60E00RdSKdxbk5375tYv9tPM0RExDxeRS0+jMYOJUvyQydhRbKC/eelg4peTYU/HfeVnJ9xwTu35zVFLMNexgZ4pcKL7k2Bl0z1O0bT697MSuf7Citkvtj9JiD4xv0TKfpIQNJ6ND1yzQ6dKwPtEUUKmsJ8XsXOsU4Hn7CRoSpqFhcqF3cq40NZSrNVQG0XHItd8VvPikcGpJ0rDb+pPUhNmiZTAnKWMmsfKC17ylvB4vM3W9nDwjMjZiZbhcURukly9NZA7yMszfomkQC9musCd3HTpUtVE4NZAanfXpM6oqd9j5eizudbIdz8epaK1WONdADHGqoTJWBpFrv8NzQv++hlhn4TIkBzuonaTb61pHsR2xMpiHLFhq4rxsrXa55OJWA4mPWtVPxmWo2yG17QvxLQ8ZP5fQ0WYM83K95fvo8GdfyMr6VFJLk0Y9nBv8dGrS26cpTkWusTfnIpOrTC7z1cSpfkn0dgvxtWRR4csDhEuRJBqN9Zii3LVpymjznOpQkP1b1tdX/VehuJJkT23Yehro+bn5V1cjauPU1g3xLYrV0txCR5txbGfw6q78nC8+1moDJG3QzRpy/eXydeOy0z/e57Rtyv9oxTutfKc4FS1xGIo41S+J3mz0VouLXPlNXV3wQuHSJIlGs+6azOS76skbESuLqSonbfl53V6Pp4RiShJaTC/f9XBtiI++XYqVY6hkMFz0sqa5hbQW1tnWgrnYT2Nx0X/cf+RIw1vCZYGRoq+v7SlF7KtbQvxX6NO+UJyKc4UjBiynGW5jRaJzULcwxG8aa9izc7NweZJGnXRrriLKPBL9kbFq14VKPk7T1qxeFxG4iI95UtsUK8tQi9omGUc6J801pDmHjjbcc+J9B/Nxv3VjWaHLPcLlgeEkPeX9B4MD7jvptG2iPu2Lm94FvpL5VEMhepvRm0yTtYkJlyhpipSLp+RnPVpr6p5WXsZDTOqelYEg31vWBXqP47trYmUZTl2IbxnS2PDxrbHM03luz976+ArhEsFQwpjMorTI5Vl18nutjjYT9XEqkbQvYjdsuEXnpbeYr9skVlcXJrnMAJeiRPN8iSr2GtEySVmK6LGsMOfp77u7cyUdszLAmLVlWtIr/Nw/aqdiZRpuURvlu4lcbyBUmAZB8a3tW6xYsuJNVlzo8LZwueBqOX58/0vJyr8W+7jdwpxsLfVxKs7FpdGWkYhTDUbk3dHUieSEdUrhsiWPTucxtWWfV2lS7BTRMklRypgJTJN+v3d3d/Z9QjEkz+GDWnmAxyR+aY2x26rBcNFLnl72/DIfWxnzdLqBhQWuKq6qCrxDuGxwuTRU7bo51P+Bp0N33N+/fYsF78qSS0uuLbm4xuj+XUrUCKhbGhW+vL+uLnyFUATJQ1kti9QPLs5OubOHPBexsklBiihLlpG0iO2rt0sgb1u4fMlzqrfjRkXcC12B3AtWKi9XEl0HLb7m41sX0thY0PrE86XFzpWtrdkPS3k+m+TYt1chD/H/TbOL3TU/pH3hDAIFuEcqoH45oushd3uH53jWtFdeZGo3u6nebSnnbZ1OS7xBtHzGFHlV2pI32luavJ+lDUGESzYJKss93g/0nsmPJEvpBWsQXRP1DgbGt5xtx7OdIauZJvtzD6EY4FJUVQU9n5P56Xf6OBVn8QfEqaT0hhITXR/N/YqLfJQdOdJwm1Akk4HV1487eCD131kpd+5JiZvBlcm4QfmkmIksN235yZLCPz1hivOH5PJ1ViH+tzns8LQctrlXQyF6pi7EtyhNM8W3tlFgfkJ/UsL675Rxr98vxYwkRqWpKWWhPPL5nX4evzpniFORG00uKxkCKb6dLhbdeIpT0A2vKHXOEYpmcrS3h06oKn3z9cri9UeNFZQvK3iR86o22Jw82bxGuCyTQx6w/NrQgAV8RhBjBdsvR9R+6VmjOYx8GhthmY+36zwWF/VieUTE65OFoo1eYmNfmri3IT4n0HvJKVpKwMepPH6c9kXKXtXForgA7xGG/uZcd3flo0IxTZLaWqfJHW0x62vK/96iiBrXTR6PWJmHQjQDPzXhepaf+VBL75H8lsaizVNoQxDhUkyOEyc6Z6QkvtZO3ayrycxgDNEzZ1jmY4hvOdpYMfft159UJb7lUFsbcYtQzNFFXvaXH7k73pjgbDf5R+mJyTWlN5Ip3WSD6JrpDeXvPp4V53+ZIJeb7kM3kKYm14X52U98kJm82Lsg61GWLL9WtPyXI0WUFctJXcKqyv72bXbavR8caNv1T+F0Jk91ha+tn/u1/ECMKXhXYjLEt2gtLh/f4tM0j2eRYU9+l5vzuds3B/dJauv/YaGzs3NiQsLr1xfkfNXrbDfl7MVpX0zVUA0UudXkZYUG3M6qqz3MatMAiiVptR/O7GwLX93ZHtlTU/leT1byHT2K6DG9FPdKjpvGVPKpLCl2Mi/qUtJnJK5uejiD11Oa90JPm86/pyx/7S1aze9mdnUlmlV8pLFReWNK4sunAjwsTM67ulh07Xx8i3s2KT5La3T1aZonscTYV45G+K68ntapCkU3L+Ry63GZ6R8qA32W8DuBkKtJLifFqaQ2TeFqRDeZj2VxHmNy4iujYiZxX59u6vGjNdt6uzXbOtt2bdtb9yUv3V4n/jMSracTvm7WFOfbbgnwnMaPvJmqd3WxqE0PjG95UnzLhuJb89kOnyVe7S05fxaKb/q0t2smFGlsN3s6zT3gZDuBz5DIp30ZEKcSqyRTlmHE0N9j1nfZGf96UagKYOZotW+PDfCYe4JexNS2Tb23cLEGxrdo7a4+TbMV83JZcHpfo6KD88AnCVVhetD24GWFzm+pk9896SrsokwjaPQgm0v371KiclEszp8zzOrkN5lWa226NxIMCu7FPC1FuT7Px3UM32swxxcxido2lY26u3waG66NkxNiv4UzZEGPtGalffiWSQ6YpKdu2uPuOJtzHS14F5JP+yKh5TTDLTLIFLD0ch7LNFmfpQnVAsyU8MD77/D3nM3v3PxLW3iZg+gZpjbOL/Oh+BalsdlmwVy3z2BR4Wsa97fm/lGoGunSrtM8II964YNAn7v5OBW5jHzaF86FNKc41WBEN5S6BTSfzN9jDqutkn4aFHBltLRoVkRHPP4dbQpBAerR1s7p2SZnhNq6IY2Nj9tCVlnufUSjsZbc7ug8+9tyS4MDfnPCmdK+CHEqchkppcZouoEDReWmQKWvqyWTRz7dXlS0eYpQXcCMiAp/LN7TydJkJokOh6itk+GiOvghTbMV83SZ11le6pElVJXxycr69FFF3KsNTtsm83EqPj2xj/5NY85xqsGK6iDMTz8qWlJkf0CoNmAmZKT84x1ft5n9FPKgB3Y0t3dDN5GcFJpTaUjT7LB1DFPG/fl8pvrDP/f16e4Uqm5kOXiwdk1C7J8yLqR9cdK7hKMpTjUYUT0YuoZuDhPP7Ap57FWhCoGJc+hQtUNIwN391BWkWA7avF5UD3LOcP04TTP30na6geZvdefn24zcbHmuT3qDj/OiBwN9lp5z2Eo7zwpxKpqmMMriVIMV1QnNzaIRlfCg5ecqKjwluY06GDxK5fNTgnx/XeHlbKHP6z9Ku4KXEhktkiGNDb2waY0w7b3g5jDrbGG+XUFjnZwSXg5fZpO62ogdfh6Ldztvm8S7enycinP9DHEqvGEuLWrQ1LBpZn/Mzie+7+6ueVOoVmCCqBJey/VyGs9P06GuoNg9h/Q2gWwDv8xnQHzLyXYc9/JexZTxb2wVqnToqCx1e5TmUznaTuqnoUtDemLEqQYvqiPDhFIPR0sW4LVoZ0CAtPfRAz+lp6f+mpKC7ZWu9mP4lRqGHG1i9xz6sfj4FldffBobV/0yH4et487HRb1wMiLoyV/rdGVThWq+Mso0HnPDgx7x9vNc/D0NVQ5M+0KuHgzV5Ynqi940/PIGxwksPvr5nUJVAxOhtiokzdvlOsbHrbhuPozV5cnw4qa6o+eAnB8+TbPzHJq/ld3b27BFqOrBs3eves6e2iilp/PcExfSvnA3yBCnopPCWF2ZqIGTZ0qusav9OBo9icEGl6ZBcPDSWb7u83jvwJxns4+EyH4Y4lu0H8KFNDZOc84r41/7rDR722yh2n+evBzrt5Txf+G6fhN/SPvCdWPIlUP3b2hEDZ3mZ1EM0NdtNivSbPUXqh9IlCCvZSu8Xef0UQzSMN8Kz8LVi54F6nWEcXVKXiulsSEnaVfoY6cy0z60piVPwi34KaWFzl3O26Z+Ry4apScml41cN9ycoRfVKQXh6W3t7jCVact95eaSP8vcCPZYOsvH5abjno4WfPwF03aGVlSX9DxQz+PCNmTbZMzZ7hoWGfZUh3Abfkpx/lepHo5W+rQvwnIaOhhuzvCIN1rcm4X68T5uc1hh3hZX7FYiLXjPijNW1GUxjAjieRgeUb3Sy+BCGhtHzgOL+t0Z4Vb8lMoi62flEfN4Fw398+GX4QbREibyaD0cZ7AabZBcuB3AyJBn5e0yp8/DwQLGagRFtofqmpIHJCvWXDrV+IkTLcszVL85ipsycrrYaLlx3cPYqLX2tOuKcFvACENTF1TxG37v4zrvfwbPyjDYJHYPoaEX1XWGahmrKv7HzcJtEWfvbqfi+J3G3eJptMlgtCiYS91Dd4cpLCLo4TjhloARpr42spLzrPiRK3hWxlHCLguWEr8wvL5ePk64LeJQDEUln3te7CDQ8IkeCENMiwLxLnbjWEbq+/06XdpTwq0Bw4xS+daULPWHuTQLm+InMFbGkyJ6MquvtXcQbs3P07Db/jxuknFERosGPGjKg8s2Kxa24/7TZcVu5pMzW8IEeN5Z4mo/kfdyqYuOydHGEdV5auKtJ3p6qgaXS6sw67lHVfKZogeDhl9ktGikRD+5VMZ83ReeD/Rf9vTBg9r5wi0CQ0hZocs7wf73nnW2teAXqJOXi6kLxlPCLku2t84pV7g9v8y+fQEzk+PmVuGGGU80UkJ54Wl4192BM1zbpzBF7Cu67Ox/D24GMPhFentbViQnvhnv43ZzP70YaDoPvSjohYG2bzyplb9iBWlPX94WeburvkxNjLQSPSA0MjIM79JkRf2aK0sW5Lv0dIsuQ6HTeYwXbhW4AuIj/7BQnfLud07bxvFpfSkXO70gMJ3HuKJge03Fhz0nTtTPEG7V4Pj665ZnUhMWnBU7KDRyojc9dU9oVjyt5yRPwNP5BhYR8kjcsWNtZrNb8khB6zZTVe8EeLvMO04rOmiAg49XcS8GGCvjKyl2Oqur3vqRcLsuj/pa2wNk8cQODI2cyGjxXUQhgyONYDnZWjE/z9vPKmNfe/7QoQKz2mF6OGDM2rK1NWtLVPiaE7TluiHxJLqA0hHdA7Xi9v06XdqV9R7KizYsVSsWiR4cGnnRDaUJjDRfixaKutrp11slxr58YN9eha1GozHPbcOvkrrqkGcDvJe4+bgt4FOZ8PsO+CKXlfQ0ltVVWX8o3LbLh9zn5Li58fCypCMyWnEDvS3aNtzWgrnYT2cJMX/Kk8vXXcvYMKadNRFoIXlW1tvX1laHtHg633SSMgDQ4AW/Thb7DkhS+VlPssar3VlqT+2Xf1FETfxe7ASQ8USegSG2RV0behgdbSxZsN8y5u22cHNe1ufLhFs46mhry3k+LvJFh50hq9n2rZYXtp2jtWlI5y1NKaLGs4barZn9/f1XP5hUkPXM/8ROAhlf9PDx24b76R9KejjJm3Cxm9abkbap+Wiv7lOK3wi30pyxsLaWWdZqQ3XebreecrKdwKcoMXT/aAQQsSrpSq24jR3rq14v3Muro7srPVEZM1X0RJDxxXcTuYeRuon0cFLSRYpvbd8iY14u81lOxqffJ8a8uk6n23l1ObMlyLFjbTcX5tmu2xn8uJ2/5x3M/it9LiUyVNRlpqA6un/SFt2bmop/7RZu6dXT01O0qKzgZdGTQdLRxYaLPC4aDXOwIc9rOud1zWjMz/mq5vDhqiXCrTVparRBqSH+9+33cJrDaMs5ypBLyd/IUFHiSTJUCKpLX2rFrayzJfZu4bYODfW1Nu7K6EmiJ4SkJTJc9LBSN4i6ihTj0k+FkOk9ELsZ/arEN/tTk97+T36O9VP791fOEW6zpNGW+T4e5HPvUzmZnx4L8Lqr3/4rS677qzfKZJzJSJOhwoJl05EiagzbU/NlNWPaod3X4PTpjkV5WU+eEDspJE0ZPC5KyEjBeVrmQxMl6QGnB93RZhzzdl3APJ3n701W/i2vY39hXn9/n6S6jYe6quzyNTZ5bttn53m7LTrnbDeF86b0XV6a/U+jfjTNA3sOmKbSlbexVl3IWuF2Dy1HeoqyldGTRU8MSVf0EFPXiDwP2lKdZnbTg04PvD7pP8W7LJjdV1bM12PxuVTVxnN7dkee9HJbtDJL/fHK5mb1SkpqJzSDYaG9PW9ZXt6WlZHha1Yq49dvysn49Fyg7/Jz9l+N69++xfKCkaJpHDTjn7wpmp5A89JgqExTdM9KC14tHra04N3dGddXFL8henLINMR7XZzxogfdYLxor0kK1FPCOooDkQGjrqOT7WTm634rC92xkvv/jLxA3xXK9OR/KksKnZTtrRrl0aMtPkLTGDRdXRXzOvcXK2u0QfyxwoJWK+2+mqAM9v/NSQqauzvO5s9NBoo22nTnvEEKoJOBpTWVuzgjRVMTyEhheoJpKy1xITvUmblaaBpDD1nC8qI3/855WZiXZQbijRf34JPnRfEu6jaS50LGgbqOFPciD8zZ1uCFWXKyYvZbxnD/jmN21uP6bT6XnXbaNu10oN+Kn5Wvxx2n6bu2X1icsed+u33LWP5YBu+J4mvkQZHRJAPl76EPnlN3j+JSAz0pGCnTlyJqLGtvCW/jbMrwT7kp1rzYIXYRkOmKjAB5LAMNGHW5yAMjw0FGjJYD0SgcdctooioZM/LIyBMio/az4r5D36V5YvRbOgYZJgqW07EpWwINEJDRpFFOirsZRvlgoMxP2anL2MGOxIcEkzK8FBS8NAsJ/sxfFxsx6opRN5K6ZWRYaOY4GRnyysioUVBfTPQ3+g516cgAUoI8MoZ0LDKMdGw6Bzyo0SJLVlf1WSTnXY3MRiuMacYU5a6NQ76s0SeDQSFDZhAZGjmJ84hEJfx94G8Mx4FxGn2iNYOCKRk5DnYqX0tTzD8ndkEQBEFiSoqdyvLSn3pMMCMjy946+714Q0IQNFjlZz7WeORIvnEmKvf16eYW56xFVlIIggahsexoX/lOwXwYh5K8P6xVyWeIXBwEQZBeNI2hqnRjomA2jAdlAMhVP1iHriEEQZdSQdbjrKnJd6FgNozLyW/a3FIT5opeqCkoJX4mK8h+vDU7dcm3Yn+HIGMpJX7WkfSkRWlqxbz+xCjTzPyrjJnMqsvfdxXMhTQozH7mPWWMaWVzUERZsdL8F1hZ8SvPfXus6ub9zQEPlmh+J/pdCBppqRXzmTrpnrvo+WrR+f+9pnwj12YtRb8rZVWVbfzm9PH9t/CGQip0dWUty8t45HhipPTfApTSIjdtGauv/ixBLl/3o8lr+1uCnstV/+aU2O8gaKSUzHlWmclLbxOaJb8sjtpqR1tkbnbqr3uUMRNEfyc1ZaXczSrzX5Nm+qLa0k33q+QzJD1qmJpwA9tbt6Wt+4DyOZoAK1z6j2jTBa+uqfiHSb7NINNXWuK8s1nKJZfMyd/eFLo0P+OBv2Yl3y76e6koietx1VVtDtPpdNLd9Le50atBGT1etADGVErcDJaTes/uln2ejw8mWdjx3rLHizXPn6LRDbHjQdDQy4JlJd9xpFSzZoHQDC8J7Yz0zfG9n5YVvFSfmjCb/634MY0jGoQrzF7TyZh8ZJbfXCnl5e9ep1YuLJVSBZbkrWX76u1sLnf7q6NHq59JVy7YpoyZKHpcCBpKFWQ9erKqbMNyofkNivZ2zYSG2v/+RVuyoU8ZPU70uMYQLW4+fCjjdeEypc2hrjQPlfy6frGCjJSoO5eWeNP/2lqCWhsbN0+50oWWFDfIS1+1MylmslHLA5mvFNFjWXnhy0db67fPF5rdZdPdHTG5TvvBa1kpd31nbMPFPSvkXb1rUvtjlhX8aStduFiBhltqxVyWljTPpmWf2zPC5Vw1lYWvOtJxxc4HQVcqekb2VH9y7FCHcoXQ1K6Kb092rC8rWBeYqbpN9HwjobKCl7uPHq39tXBJpkFPT86isvw/fjuSXUMK8hVkP9rXd6TY8eLRv6tFo7Ee094cHKZWLOhPRDAeGgKpYqeczUq58+0TJ0pmCM1sSGCsfpxWs3pmVdn/9XDPxHdi5x4upSsXf11f/vENwqWYFs2Nbs+nJs4/LVawoRS51Jr0+0/sqdps39OjGdbc490H1VsyVbdraQ6X2LVA0GCUq17BKos3fCQ0q2Gjrupfb5YX/vFcUuzw93ZS4mZyXdvXXhRObZpkq26/lzwfsQJevSxYctx1/UWap/9VU/Ofm4RTDjt1hc9Nryr722EYLeiyxXnn+RkPn+7qVL5Fc6uEJjWsHDyomt/S5BOnVsw7M3xTdSxYZclfyw5qVZOE05om7e2aaVWl79QM9fSAtIQbaFQl5/jRChvhVCPKsWNZ11aXbQxNSbj+pNj1QdDFUsmnsPz0B9OYtfXw5zEXoa7u37MLsh4JTVfcfEbs+q5YnBEszf8Do7CJcCrTRlf971m5acsPixb2MkWz1MsK/sjyMn97d2+vcopwCqNRmPPcPZzhFL1WCDIoJf561tYSVHxQa210D2RfzRer6qo+ZEM1mpipup11dcRuMKlRwV9Co1l9TVbKXaIFHoyocnPT7mUNu7em/O9/nZIageg5pHk6V/1AcnLcNNFrh0avFNG0DGzFoYrCP0gjU8EAWnUBYenKRXVJsVcesqFRztqKfxqllzOsyOVyq8Y6OweVfLpowX9OqQnXs7rqT3IOtMc8IBxOkuyp2bw5M/lXomWARp9S42ex/a1h51sa3C+sCZQaLbXW1x88oNxPgwBiZfg5UW8nNWHeeuFQ5ge5jBXF63cpowe3cJPSvpTm/75Lt/uTuSMVoLwaqHwnv24N0Kjvr1XFXiNaJsj8lRQzgRVmP3ZW1+C8iTHjxKsuB2tra8uDB9UPF+etzaMMEYOdilSU81zvkSN5kjXGQ0Z97X9/dmExWe6KoldYddk7f/7mm/Y7hJ+ZDJ2dLjNy1feuyU69G5t0jDKlJsxi2uL1YcePV/1WaA4mxZ7a/6wpK3ip+pdGEzUZq/qb6t2WCj8zb/r6Kp7QZDz0kxQuZKhS4md0tDS6q5k2gBYom3QQr60t4p5SzdqqlLjrzl9cVsi8RHGgvIyVHV8fq1EP9aTlkYZG+3q6Myty0pYdEwvMJ8fPPJKVskJyMblhpa05ZE1O2n0X1ufRshfdXqeuqqp/3Sp8xWzYU/PZB1zXljPImLdljspLf4DlZ6za0NkZa1Ztt6cnd1Ve+sqPslN/zZVT301MjpvOdI3u3sJXRheVResfy0z+1an8zIebO9riXujv75wo/MmsoDhGbe1Hk1ubfKtSE2YfJU/y4kYPmZaoy0SDQdXl7zQf6618QbjVZgfFtzIynpxcWfzGbrViHmve57OHlv4Ifx59tDeH/t4UApNDRUPtlvvTFfM/TlcuEH0QIOkrWX4tKytc19TaHPDeaGm7/f3dk4/1lbxHWSGEj8BogUYT+3ry36up2Nitkk/lHgJpJV+DxGTBx6myU5d0a8veeFin85gq3E4ARg0WzU0+WyuKXu3WZ40Ue1AgY4sMVW7avdqaive3CvcNgNHL4dbs2c37PP5UVvjSySQ+uyk8LuPLgimixvUXZD1ysjD3qeV1dZ9NF24XAMBA35ECP87jaqcNBoZvZT30c6IJy9lpy4rqqz9zFG4LAOBSnDrVdNPuircW12o3UUoQ0YcKGnpRNoXGui2sSPPs0vb20GnC7QAADJZDuthZ9bWfKwtzfnsmLfFG7sFCd3EoRQvWs1Lu7C0vXKc8ebLFRah2AMDVcPx4/dLyoj+u2Fdv15Wrvlf04YMGL1qY3LD7c9a42/qNrragxUI1AwCGEloETtMiOlqCA/MzH67lvAM+l73YQwn9IFpikpG0kKUmzC5u3GOb092uXmAKC+oBMBu+/rrruo7W8Cd2a/+5qaH2vywnbZnowzqalRJ/Hc1GZznqZX9oqLN5or09dIJQfQAAY6D3ujRjNJrVY9qb/beUF75cka5c0E0Be2WM9HbhHi4po8eSB0UxKVrbV9m1P7aCJngyZiapewEwV471VN/T3OCyTp10y7r6ms+OFOU+aZbGSxkzgbIksNrK91h5wR/+W6PdtO7oUe06zoiPmuVeAJgVnPc1Qat9e5IqQDbpwP7Yxury/2vkPJHGlPhZJ6nLdDUpckdKZGxT4mYw8hoV0ROaywpebGxt8m48cazGRav63SStNmASjBQAZsyRQ3nP1tX+Z2N+5uqNGUm3frGnejMryVvLctKWMpXceBlTyWvKUN3KX0tNxd85gzrxvezUJRvrqj7aePiQemNnZ4lZZvUAAAwS8k46Ogqn0xKUwsLnpqdEXju9c7/8b91dKV26Bscuzph15WWu6uKMWVdipAUnGSerwzQrXFScN0RznC7+XCWfflb/W8uuDNWvuGM+1FVZ/Dp3/E+6Dh1Qdu3dbfsAnbsw5SH+Wjo6IrEkBgBw9XzdlXXdkUM5XwxU7+Hc5N7DGnb4YCrrbAn1/enfNRuFnwMAgHHp7s6Y3NuReSOJMS2luQYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAmshk/w+LaQ6A7b6GvgAAAABJRU5ErkJggg==",
          fileName="modelica://TILMedia/Images/TILMedia.png")}),
   Protection(access=Access.documentation,
      __Dymola_showVariables=true,
      __Dymola_showDiagnostics=true,
      __Dymola_showStatistics=true,
      __Dymola_showFlat=true),
   conversion(
    from(version="2.0.4", script="modelica://TILMedia/Scripts/ConvertTILMedia_to_3.0.0.mos"),
    from(version="2.1.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_to_3.0.0.mos"),
    from(version="2.1.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_to_3.0.0.mos"),
    from(version="2.1.2", script="modelica://TILMedia/Scripts/ConvertTILMedia_to_3.0.0.mos"),
    from(version="3.0.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.0.0.mos"),
    from(version="3.0.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.0.1.mos"),
    from(version="3.0.2", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.0.2.mos"),
    from(version="3.1.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.1.0.mos"),
    from(version="3.2.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.2.0.mos"),
    from(version="3.2.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.2.1.mos"),
    from(version="3.2.2", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.2.2.mos"),
    from(version="3.2.3", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.2.3.mos"),
    from(version="3.3.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.3.0.mos"),
    from(version="3.3.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.3.1.mos"),
    from(version="3.4.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.4.0.mos"),
    from(version="3.4.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.4.1.mos"),
    from(version="3.4.2", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.4.2.mos"),
    from(version="3.5.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.5.0.mos"),
    from(version="3.5.1", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.5.1.mos"),
    from(version="3.6.0", script="modelica://TILMedia/Scripts/ConvertTILMedia_from_3.6.0.mos")));
end TILMedia;

package Modelica "Modelica Standard Library - Version 4.0.0"
extends Modelica.Icons.Package;

  package Blocks
  "Library of basic input/output control blocks (continuous, discrete, logical, table blocks)"
    extends Modelica.Icons.Package;
    import Modelica.Units.SI;

    package Continuous
    "Library of continuous control blocks with internal states"
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Package;

      block Integrator "Output the integral of the input signal with optional reset"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit="1")=1 "Integrator gain";
        parameter Boolean use_reset = false "= true, if reset port enabled"
          annotation(Evaluate=true, HideResult=true, choices(checkBox=true));
        parameter Boolean use_set = false "= true, if set port enabled and used as reinitialization value when reset"
          annotation(Dialog(enable=use_reset), Evaluate=true, HideResult=true, choices(checkBox=true));

        /* InitialState is the default, because it was the default in Modelica 2.2
     and therefore this setting is backward compatible
  */
        parameter Init initType=Init.InitialState
          "Type of initialization (1: no init, 2: steady state, 3,4: initial output)" annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial or guess value of output (= state)"
          annotation (Dialog(group="Initialization"));
        extends Interfaces.SISO(y(start=y_start));
        Modelica.Blocks.Interfaces.BooleanInput reset if use_reset "Optional connector of reset signal" annotation(Placement(
          transformation(
            extent={{-20,-20},{20,20}},
            rotation=90,
            origin={60,-120})));
        Modelica.Blocks.Interfaces.RealInput set if use_reset and use_set "Optional connector of set signal" annotation(Placement(
          transformation(
            extent={{-20,-20},{20,20}},
            rotation=270,
            origin={60,120})));
    protected
        Modelica.Blocks.Interfaces.BooleanOutput local_reset annotation(HideResult=true);
        Modelica.Blocks.Interfaces.RealOutput local_set annotation(HideResult=true);

      initial equation
        if initType == Init.SteadyState then
           der(y) = 0;
        elseif initType == Init.InitialState or
               initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        if use_reset then
          connect(reset, local_reset);
          if use_set then
            connect(set, local_set);
          else
            local_set = y_start;
          end if;
          when local_reset then
            reinit(y, local_set);
          end when;
        else
          local_reset = false;
          local_set = 0;
        end if;
        der(y) = k*u;
        annotation (
          Documentation(info="<html>
<p>
This blocks computes output <strong>y</strong> as
<em>integral</em> of the input <strong>u</strong> multiplied with
the gain <em>k</em>:
</p>
<blockquote><pre>
    k
y = - u
    s
</pre></blockquote>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

<p>
If the <em>reset</em> port is enabled, then the output <strong>y</strong> is reset to <em>set</em>
or to <em>y_start</em> (if the <em>set</em> port is not enabled), whenever the <em>reset</em>
port has a rising edge.
</p>
</html>"),     Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100.0,-100.0},{100.0,100.0}}),
              graphics={
                Line(
                  points={{-80.0,78.0},{-80.0,-90.0}},
                  color={192,192,192}),
                Polygon(
                  lineColor={192,192,192},
                  fillColor={192,192,192},
                  fillPattern=FillPattern.Solid,
                  points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}),
                Line(
                  points={{-90.0,-80.0},{82.0,-80.0}},
                  color={192,192,192}),
                Polygon(
                  lineColor={192,192,192},
                  fillColor={192,192,192},
                  fillPattern=FillPattern.Solid,
                  points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}),
                Text(
                  textColor={192,192,192},
                  extent={{0.0,-70.0},{60.0,-10.0}},
                  textString="I"),
                Text(
                  extent={{-150.0,-150.0},{150.0,-110.0}},
                  textString="k=%k"),
                Line(
                  points=DynamicSelect({{-80.0,-80.0},{80.0,80.0}}, if use_reset then {{-80.0,-80.0},{60.0,60.0},{60.0,-80.0},{80.0,-60.0}} else {{-80.0,-80.0},{80.0,80.0}}),
                  color={0,0,127}),
                Line(
                  visible=use_reset,
                  points={{60,-100},{60,-80}},
                  color={255,0,255},
                  pattern=LinePattern.Dot),
                Text(
                  visible=use_reset,
                  extent={{-28,-62},{94,-86}},
                  textString="reset")}));
      end Integrator;
      annotation (
        Documentation(info="<html>
<p>
This package contains basic <strong>continuous</strong> input/output blocks
described by differential equations.
</p>

<p>
All blocks of this package can be initialized in different
ways controlled by parameter <strong>initType</strong>. The possible
values of initType are defined in
<a href=\"modelica://Modelica.Blocks.Types.Init\">Modelica.Blocks.Types.Init</a>:
</p>

<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
  <tr><td><strong>Name</strong></td>
      <td><strong>Description</strong></td></tr>

  <tr><td><strong>Init.NoInit</strong></td>
      <td>no initialization (start values are used as guess values with fixed=false)</td></tr>

  <tr><td><strong>Init.SteadyState</strong></td>
      <td>steady state initialization (derivatives of states are zero)</td></tr>

  <tr><td><strong>Init.InitialState</strong></td>
      <td>Initialization with initial states</td></tr>

  <tr><td><strong>Init.InitialOutput</strong></td>
      <td>Initialization with initial outputs (and steady state of the states if possible)</td></tr>
</table>

<p>
For backward compatibility reasons the default of all blocks is
<strong>Init.NoInit</strong>, with the exception of Integrator and LimIntegrator
where the default is <strong>Init.InitialState</strong> (this was the initialization
defined in version 2.2 of the Modelica standard library).
</p>

<p>
In many cases, the most useful initial condition is
<strong>Init.SteadyState</strong> because initial transients are then no longer
present. The drawback is that in combination with a non-linear
plant, non-linear algebraic equations occur that might be
difficult to solve if appropriate guess values for the
iteration variables are not provided (i.e., start values with fixed=false).
However, it is often already useful to just initialize
the linear blocks from the Continuous blocks library in SteadyState.
This is uncritical, because only linear algebraic equations occur.
If Init.NoInit is set, then the start values for the states are
interpreted as <strong>guess</strong> values and are propagated to the
states with fixed=<strong>false</strong>.
</p>

<p>
Note, initialization with Init.SteadyState is usually difficult
for a block that contains an integrator
(Integrator, LimIntegrator, PI, PID, LimPID).
This is due to the basic equation of an integrator:
</p>

<blockquote><pre>
<strong>initial equation</strong>
   <strong>der</strong>(y) = 0;   // Init.SteadyState
<strong>equation</strong>
   <strong>der</strong>(y) = k*u;
</pre></blockquote>

<p>
The steady state equation leads to the condition that the input to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <strong>singular</strong>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is always defined by
Init.InitialState or Init.SteadyState initialization.
</p>

<p>
In such a case, <strong>Init.NoInit</strong> has to be selected for the integrator
and an additional initial equation has to be added to the system
to which the integrator is connected. E.g., useful initial conditions
for a 1-dim. rotational inertia controlled by a PI controller are that
<strong>angle</strong>, <strong>speed</strong>, and <strong>acceleration</strong> of the inertia are zero.
</p>

</html>"),     Icon(graphics={Line(
              origin={0.061,4.184},
              points={{81.939,36.056},{65.362,36.056},{14.39,-26.199},{-29.966,
                  113.485},{-65.374,-61.217},{-78.061,-78.184}},
              color={95,95,95},
              smooth=Smooth.Bezier)}));
    end Continuous;

    package Interfaces
    "Library of connectors and partial models for input/output blocks"
      extends Modelica.Icons.InterfacesPackage;

      connector RealInput = input Real "'input Real' as connector" annotation (
        defaultComponentName="u",
        Icon(graphics={
          Polygon(
            lineColor={0,0,127},
            fillColor={0,0,127},
            fillPattern=FillPattern.Solid,
            points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0}})},
          coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}},
            preserveAspectRatio=true,
            initialScale=0.2)),
        Diagram(
          coordinateSystem(preserveAspectRatio=true,
            initialScale=0.2,
            extent={{-100.0,-100.0},{100.0,100.0}}),
            graphics={
          Polygon(
            lineColor={0,0,127},
            fillColor={0,0,127},
            fillPattern=FillPattern.Solid,
            points={{0.0,50.0},{100.0,0.0},{0.0,-50.0},{0.0,50.0}}),
          Text(
            textColor={0,0,127},
            extent={{-10.0,60.0},{-10.0,85.0}},
            textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Real.
</p>
</html>"));

      connector RealOutput = output Real "'output Real' as connector" annotation (
        defaultComponentName="y",
        Icon(
          coordinateSystem(preserveAspectRatio=true,
            extent={{-100.0,-100.0},{100.0,100.0}}),
            graphics={
          Polygon(
            lineColor={0,0,127},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0}})}),
        Diagram(
          coordinateSystem(preserveAspectRatio=true,
            extent={{-100.0,-100.0},{100.0,100.0}}),
            graphics={
          Polygon(
            lineColor={0,0,127},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            points={{-100.0,50.0},{0.0,0.0},{-100.0,-50.0}}),
          Text(
            textColor={0,0,127},
            extent={{30.0,60.0},{30.0,110.0}},
            textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one output signal of type Real.
</p>
</html>"));

      connector BooleanInput = input Boolean "'input Boolean' as connector"
        annotation (
        defaultComponentName="u",
        Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,0,255},
              fillColor={255,0,255},
              fillPattern=FillPattern.Solid)}, coordinateSystem(
            extent={{-100,-100},{100,100}},
            preserveAspectRatio=true,
            initialScale=0.2)),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            initialScale=0.2,
            extent={{-100,-100},{100,100}}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={255,0,255},
              fillColor={255,0,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              textColor={255,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Boolean.
</p>
</html>"));

      connector BooleanOutput = output Boolean "'output Boolean' as connector"
        annotation (
        defaultComponentName="y",
        Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}}), graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}}), graphics={Polygon(
              points={{-100,50},{0,0},{-100,-50},{-100,50}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{30,110},{30,60}},
              textColor={255,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one output signal of type Boolean.
</p>
</html>"));

      partial block SO "Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;

        RealOutput y "Connector of Real output signal" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));
        annotation (Documentation(info="<html>
<p>
Block has one continuous Real output signal.
</p>
</html>"));

      end SO;

      partial block MO "Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;

        parameter Integer nout(min=1) = 1 "Number of outputs";
        RealOutput y[nout] "Connector of Real output signals" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));
        annotation (Documentation(info="<html>
<p>
Block has one continuous Real output signal vector.
</p>
</html>"));

      end MO;

      partial block SISO "Single Input Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;

        RealInput u "Connector of Real input signal" annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}})));
        RealOutput y "Connector of Real output signal" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));
        annotation (Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Real output signal.
</p>
</html>"));
      end SISO;

      partial block SI2SO
        "2 Single Input / 1 Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;

        RealInput u1 "Connector of Real input signal 1" annotation (Placement(
              transformation(extent={{-140,40},{-100,80}})));
        RealInput u2 "Connector of Real input signal 2" annotation (Placement(
              transformation(extent={{-140,-80},{-100,-40}})));
        RealOutput y "Connector of Real output signal" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));

        annotation (Documentation(info="<html>
<p>
Block has two continuous Real input signals u1 and u2 and one
continuous Real output signal y.
</p>
</html>"));

      end SI2SO;

      partial block SIMO "Single Input Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nout=1 "Number of outputs";
        RealInput u "Connector of Real input signal" annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}})));
        RealOutput y[nout] "Connector of Real output signals" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));

        annotation (Documentation(info="<html>
<p> Block has one continuous Real input signal and a
    vector of continuous Real output signals.</p>

</html>"));
      end SIMO;

      partial block SignalSource "Base class for continuous signal source"
        extends SO;
        parameter Real offset=0 "Offset of output signal y";
        parameter SI.Time startTime=0 "Output y = offset for time < startTime";
        annotation (Documentation(info="<html>
<p>
Basic block for Real sources of package Blocks.Sources.
This component has one continuous Real output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
      end SignalSource;

      partial block BooleanSISO
        "Single Input Single Output control block with signals of type Boolean"

        extends Modelica.Blocks.Icons.BooleanBlock;

    public
        BooleanInput u "Connector of Boolean input signal" annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}})));
        BooleanOutput y "Connector of Boolean output signal" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));

        annotation (Documentation(info="<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal.
</p>
</html>"));
      end BooleanSISO;

      partial block partialBooleanSI2SO
        "Partial block with 2 input and 1 output Boolean signal"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u1 "Connector of first Boolean input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
        Blocks.Interfaces.BooleanInput u2
          "Connector of second Boolean input signal" annotation (Placement(
              transformation(extent={{-140,-100},{-100,-60}})));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal"
          annotation (Placement(transformation(extent={{100,-10},{120,10}})));

        annotation (Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Ellipse(
                extent={{-71,7},{-85,-7}},
                lineColor=DynamicSelect({235,235,235}, if u1 then {0,255,0} else {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u1 then {0,255,0} else {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-71,-74},{-85,-88}},
                lineColor=DynamicSelect({235,235,235}, if u2 then {0,255,0} else {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u2 then {0,255,0} else {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y then {0,255,0} else {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y then {0,255,0} else {235,235,235}),
                fillPattern=FillPattern.Solid)}), Documentation(info="<html>
<p>
Block has two continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSI2SO;

      partial block partialBooleanThresholdComparison
        "Partial block to compare the Real input u with a threshold and provide the result as 1 Boolean output signal"

        parameter Real threshold=0 "Comparison with respect to threshold";

        Blocks.Interfaces.RealInput u "Connector of Real input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal"
          annotation (Placement(transformation(extent={{100,-10},{120,10}})));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                fillColor={210,210,210},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-150,-140},{150,-110}},
                textString="%threshold"),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y then {0,255,0} else {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y then {0,255,0} else {235,235,235}),
                fillPattern=FillPattern.Solid), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                textColor={0,0,255})}), Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Boolean output signal
as well as a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanThresholdComparison;
      annotation (Documentation(info="<html>
<p>
This package contains interface definitions for
<strong>continuous</strong> input/output blocks with Real,
Integer and Boolean signals. Furthermore, it contains
partial models for continuous and discrete blocks.
</p>

</html>",     revisions="<html>
<ul>
<li><em>June 28, 2019</em>
       by Thomas Beutlich:<br>
       Removed obsolete blocks.</li>
<li><em>Oct. 21, 2002</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and Christian Schweiger:<br>
       Added several new interfaces.</li>
<li><em>Oct. 24, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       RealInputSignal renamed to RealInput. RealOutputSignal renamed to
       output RealOutput. GraphBlock renamed to BlockIcon. SISOreal renamed to
       SISO. SOreal renamed to SO. I2SOreal renamed to M2SO.
       SignalGenerator renamed to SignalSource. Introduced the following
       new models: MIMO, MIMOs, SVcontrol, MVcontrol, DiscreteBlockIcon,
       DiscreteBlock, DiscreteSISO, DiscreteMIMO, DiscreteMIMOs,
       BooleanBlockIcon, BooleanSISO, BooleanSignalSource, MI2BooleanMOs.</li>
<li><em>June 30, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));
    end Interfaces;

    package Logical
    "Library of components with Boolean input and output signals"
      extends Modelica.Icons.Package;

      block And "Logical 'and': y = u1 and u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = u1 and u2;
        annotation (
          defaultComponentName="and1",
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                textString="and")}),
          Documentation(info="<html>
<p>
The output is <strong>true</strong> if all inputs are <strong>true</strong>, otherwise
the output is <strong>false</strong>.
</p>
</html>"));
      end And;

      block GreaterThreshold
        "Output y is true, if input u is greater than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
      equation
        y = u > threshold;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={
              Line(
                points={{-54,20},{-8,0},{-54,-20}},
                thickness=0.5)}), Documentation(info="<html>
<p>
The output is <strong>true</strong> if the Real input is greater than
parameter <strong>threshold</strong>, otherwise
the output is <strong>false</strong>.
</p>
</html>"));
      end GreaterThreshold;

      block Switch "Switch between two Real signals"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.RealInput u1 "Connector of first Real input signal"
          annotation (Placement(transformation(extent={{-140,60},{-100,100}})));
        Blocks.Interfaces.BooleanInput u2 "Connector of Boolean input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
        Blocks.Interfaces.RealInput u3 "Connector of second Real input signal"
          annotation (Placement(transformation(extent={{-140,-100},{-100,-60}})));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal"
          annotation (Placement(transformation(extent={{100,-10},{120,10}})));

      equation
        y = if u2 then u1 else u3;
        annotation (
          defaultComponentName="switch1",
          Documentation(info="<html>
<p>The Logical.Switch switches, depending on the
logical connector u2 (the middle connector)
between the two possible input signals
u1 (upper connector) and u3 (lower connector).</p>
<p>If u2 is <strong>true</strong>, the output signal y is set equal to
u1, else it is set equal to u3.</p>
</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{12,0},{100,0}},
                color={0,0,127}),
              Line(points={{-100,0},{-40,0}},
                color={255,0,255}),
              Line(points={{-100,-80},{-40,-80},{-40,-80}},
                color={0,0,127}),
              Line(points={{-40,12},{-40,-12}},
                color={255,0,255}),
              Line(points={{-100,80},{-38,80}},
                color={0,0,127}),
              Line(points=DynamicSelect({{-38,80},{6,2}}, if u2 then {{-38,80},{6,2}} else {{-38,-80},{6,2}}),
                color={0,0,127},
                thickness=1),
              Ellipse(lineColor={0,0,255},
                pattern=LinePattern.None,
                fillPattern=FillPattern.Solid,
                extent={{2,-8},{18,8}})}));
      end Switch;

      block Timer
        "Timer measuring the time from the time instant where the Boolean input became true"

        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal"
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal"
          annotation (Placement(transformation(extent={{100,-10},{120,10}})));

    protected
        discrete SI.Time entryTime "Time instant when u became true";
      initial equation
        pre(entryTime) = 0;
      equation
        when u then
          entryTime = time;
        end when;
        y = if u then time - entryTime else 0.0;
        annotation (
          Icon(
            coordinateSystem(preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}),
              graphics={
            Line(points={{-90,-70},{82,-70}},
              color={192,192,192}),
            Line(points={{-80,68},{-80,-80}},
              color={192,192,192}),
            Polygon(lineColor={192,192,192},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              points={{90,-70},{68,-62},{68,-78},{90,-70}}),
            Polygon(lineColor={192,192,192},
              fillColor={192,192,192},
              fillPattern=FillPattern.Solid,
              points={{-80,90},{-88,68},{-72,68},{-80,90}}),
            Line(points={{-80,-70},{-60,-70},{-60,-26},{38,-26},{38,-70},{66,-70}},
              color={255,0,255}),
            Line(points={{-80,0},{-62,0},{40,90},{40,0},{68,0}},
              color={0,0,127})}),
          Documentation(info="<html>
<p>When the Boolean input <strong>u</strong> becomes <strong>true</strong>, the timer starts
and the output <strong>y</strong> is the time that has elapsed since <strong>u</strong> became <strong>true</strong>.
When the input becomes <strong>false</strong>, the timer stops and the output is reset to zero.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Logical/Timer.png\"
     alt=\"Timer.png\">
</p>

</html>"));
      end Timer;
      annotation (Documentation(info="<html>
<p>
This package provides blocks with Boolean input and output signals
to describe logical networks. A typical example for a logical
network built with package Logical is shown in the next figure:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Logical/LogicalNetwork1.png\"
     alt=\"LogicalNetwork1.png\">
</p>

<p>
The actual value of Boolean input and/or output signals is displayed
in the respective block icon as \"circle\", where \"white\" color means
value <strong>false</strong> and \"green\" color means value <strong>true</strong>. These
values are visualized in a diagram animation.
</p>
</html>"),     Icon(graphics={Line(
              points={{-86,-22},{-50,-22},{-50,22},{48,22},{48,-22},{88,-24}},
              color={255,0,255})}));
    end Logical;

    package Math
    "Library of Real mathematical functions as input/output blocks"
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Package;

      block Gain "Output the product of a gain value with the input signal"

        parameter Real k(start=1, unit="1")
          "Gain value multiplied with input signal";
    public
        Interfaces.RealInput u "Input signal connector" annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}})));
        Interfaces.RealOutput y "Output signal connector" annotation (Placement(
              transformation(extent={{100,-10},{120,10}})));

      equation
        y = k*u;
        annotation (
          Documentation(info="<html>
<p>
This block computes output <em>y</em> as
<em>product</em> of gain <em>k</em> with the
input <em>u</em>:
</p>
<blockquote><pre>
y = k * u;
</pre></blockquote>

</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Polygon(
                points={{-100,-100},{-100,100},{100,0},{-100,-100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-150,-140},{150,-100}},
                textString="k=%k"),
              Text(
                extent={{-150,140},{150,100}},
                textString="%name",
                textColor={0,0,255})}));
      end Gain;

      block Feedback "Output difference between commanded and feedback input"

        Interfaces.RealInput u1 "Commanded input" annotation (Placement(transformation(extent={{-100,
                  -20},{-60,20}})));
        Interfaces.RealInput u2 "Feedback input" annotation (Placement(transformation(
              origin={0,-80},
              extent={{-20,-20},{20,20}},
              rotation=90)));
        Interfaces.RealOutput y annotation (Placement(transformation(extent={{80,-10},
                  {100,10}})));

      equation
        y = u1 - u2;
        annotation (
          Documentation(info="<html>
<p>
This blocks computes output <strong>y</strong> as <em>difference</em> of the
commanded input <strong>u1</strong> and the feedback
input <strong>u2</strong>:
</p>
<blockquote><pre>
<strong>y</strong> = <strong>u1</strong> - <strong>u2</strong>;
</pre></blockquote>
<p>
Example:
</p>
<blockquote><pre>
   parameter:   n = 2

results in the following equations:

   y = u1 - u2
</pre></blockquote>

</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Ellipse(
                lineColor={0,0,127},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                extent={{-20,-20},{20,20}}),
              Line(points={{-60,0},{-20,0}}, color={0,0,127}),
              Line(points={{20,0},{80,0}}, color={0,0,127}),
              Line(points={{0,-20},{0,-60}}, color={0,0,127}),
              Text(extent={{-14,-94},{82,0}}, textString="-"),
              Text(
                textColor={0,0,255},
                extent={{-150,40},{150,80}},
                textString="%name")}));
      end Feedback;

      block Add "Output the sum of the two inputs"
        extends Interfaces.SI2SO;

        parameter Real k1=+1 "Gain of input signal 1";
        parameter Real k2=+1 "Gain of input signal 2";

      equation
        y = k1*u1 + k2*u2;
        annotation (
          Documentation(info="<html>
<p>
This blocks computes output <strong>y</strong> as <em>sum</em> of the
two input signals <strong>u1</strong> and <strong>u2</strong>:
</p>
<blockquote><pre>
<strong>y</strong> = k1*<strong>u1</strong> + k2*<strong>u2</strong>;
</pre></blockquote>
<p>
Example:
</p>
<blockquote><pre>
   parameter:   k1= +2, k2= -3

results in the following equations:

   y = 2 * u1 - 3 * u2
</pre></blockquote>

</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{-100,60},{-74,24},{-44,24}}, color={0,0,127}),
              Line(points={{-100,-60},{-74,-24},{-44,-24}}, color={0,0,127}),
              Ellipse(lineColor={0,0,127}, extent={{-50,-50},{50,50}}),
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Text(extent={{-40,40},{40,-40}}, textString="+"),
              Text(extent={{-100,52},{5,92}}, textString="%k1"),
              Text(extent={{-100,-92},{5,-52}}, textString="%k2")}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={         Line(points={{50,0},{100,0}},
                color={0,0,255}),                                        Line(
                points={{50,0},{100,0}}, color={0,0,127})}));
      end Add;

      block Add3 "Output the sum of the three inputs"
        extends Modelica.Blocks.Icons.Block;

        parameter Real k1=+1 "Gain of input signal 1";
        parameter Real k2=+1 "Gain of input signal 2";
        parameter Real k3=+1 "Gain of input signal 3";
        Interfaces.RealInput u1 "Connector of Real input signal 1" annotation (
            Placement(transformation(extent={{-140,60},{-100,100}})));
        Interfaces.RealInput u2 "Connector of Real input signal 2" annotation (
            Placement(transformation(extent={{-140,-20},{-100,20}})));
        Interfaces.RealInput u3 "Connector of Real input signal 3" annotation (
            Placement(transformation(extent={{-140,-100},{-100,-60}})));
        Interfaces.RealOutput y "Connector of Real output signal" annotation (
            Placement(transformation(extent={{100,-10},{120,10}})));

      equation
        y = k1*u1 + k2*u2 + k3*u3;
        annotation (
          Documentation(info="<html>
<p>
This blocks computes output <strong>y</strong> as <em>sum</em> of the
three input signals <strong>u1</strong>, <strong>u2</strong> and <strong>u3</strong>:
</p>
<blockquote><pre>
<strong>y</strong> = k1*<strong>u1</strong> + k2*<strong>u2</strong> + k3*<strong>u3</strong>;
</pre></blockquote>
<p>
Example:
</p>
<blockquote><pre>
   parameter:   k1= +2, k2= -3, k3=1;

results in the following equations:

   y = 2 * u1 - 3 * u2 + u3;
</pre></blockquote>

</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Text(
                extent={{-100,50},{5,90}},
                textString="%k1"),
              Text(
                extent={{-100,-20},{5,20}},
                textString="%k2"),
              Text(
                extent={{-100,-50},{5,-90}},
                textString="%k3"),
              Text(
                extent={{10,40},{90,-40}},
                textString="+")}));
      end Add3;

      block Product "Output product of the two inputs"
        extends Interfaces.SI2SO;

      equation
        y = u1*u2;
        annotation (
          Documentation(info="<html>
<p>
This blocks computes the output <strong>y</strong>
as <em>product</em> of the two inputs <strong>u1</strong> and <strong>u2</strong>:
</p>
<blockquote><pre>
y = u1 * u2;
</pre></blockquote>

</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{-100,60},{-40,60},{-30,40}}, color={0,0,127}),
              Line(points={{-100,-60},{-40,-60},{-30,-40}}, color={0,0,127}),
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Line(points={{-30,0},{30,0}}),
              Line(points={{-15,25.99},{15,-25.99}}),
              Line(points={{-15,-25.99},{15,25.99}}),
              Ellipse(lineColor={0,0,127}, extent={{-50,-50},{50,50}})}));
      end Product;
      annotation (Documentation(info="<html>
<p>
This package contains basic <strong>mathematical operations</strong>,
such as summation and multiplication, and basic <strong>mathematical
functions</strong>, such as <strong>sqrt</strong> and <strong>sin</strong>, as
input/output blocks. All blocks of this library can be either
connected with continuous blocks or with sampled-data blocks.
</p>
</html>",     revisions="<html>
<ul>
<li><em>August 24, 2016</em>
       by Christian Kral: added WrapAngle</li>
<li><em>October 21, 2002</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and Christian Schweiger:<br>
       New blocks added: RealToInteger, IntegerToReal, Max, Min, Edge, BooleanChange, IntegerChange.</li>
<li><em>August 7, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized (partly based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist).
</li>
</ul>
</html>"),     Icon(graphics={Line(
              points={{-80,-2},{-68.7,32.2},{-61.5,51.1},{-55.1,64.4},{-49.4,72.6},
                  {-43.8,77.1},{-38.2,77.8},{-32.6,74.6},{-26.9,67.7},{-21.3,57.4},
                  {-14.9,42.1},{-6.83,19.2},{10.1,-32.8},{17.3,-52.2},{23.7,-66.2},
                  {29.3,-75.1},{35,-80.4},{40.6,-82},{46.2,-79.6},{51.9,-73.5},{
                  57.5,-63.9},{63.9,-49.2},{72,-26.8},{80,-2}},
              color={95,95,95},
              smooth=Smooth.Bezier)}));
    end Math;

    package Nonlinear
    "Library of discontinuous or non-differentiable algebraic control blocks"
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Package;

          block Limiter "Limit the range of a signal"
            parameter Real uMax(start=1) "Upper limits of input signals";
            parameter Real uMin= -uMax "Lower limits of input signals";
            parameter Boolean strict=false "= true, if strict limits with noEvent(..)"
              annotation (Evaluate=true, choices(checkBox=true), Dialog(tab="Advanced"));
            parameter Types.LimiterHomotopy homotopyType = Modelica.Blocks.Types.LimiterHomotopy.Linear "Simplified model for homotopy-based initialization"
              annotation (Evaluate=true, Dialog(group="Initialization"));
            extends Interfaces.SISO;
    protected
            Real simplifiedExpr "Simplified expression for homotopy-based initialization";

          equation
            assert(uMax >= uMin, "Limiter: Limits must be consistent. However, uMax (=" + String(uMax) +
                                 ") < uMin (=" + String(uMin) + ")");
            simplifiedExpr = (if homotopyType == Types.LimiterHomotopy.Linear then u
                              else if homotopyType == Types.LimiterHomotopy.UpperLimit then uMax
                              else if homotopyType == Types.LimiterHomotopy.LowerLimit then uMin
                              else 0);
            if strict then
              if homotopyType == Types.LimiterHomotopy.NoHomotopy then
                y = smooth(0, noEvent(if u > uMax then uMax else if u < uMin then uMin else u));
              else
                y = homotopy(actual = smooth(0, noEvent(if u > uMax then uMax else if u < uMin then uMin else u)),
                             simplified=simplifiedExpr);
              end if;
            else
              if homotopyType == Types.LimiterHomotopy.NoHomotopy then
                y = smooth(0,if u > uMax then uMax else if u < uMin then uMin else u);
              else
                y = homotopy(actual = smooth(0,if u > uMax then uMax else if u < uMin then uMin else u),
                             simplified=simplifiedExpr);
              end if;
            end if;
            annotation (
              Documentation(info="<html>
<p>
The Limiter block passes its input signal as output signal
as long as the input is within the specified upper and lower
limits. If this is not the case, the corresponding limits are passed
as output.
</p>
<p>
The parameter <code>homotopyType</code> in the Advanced tab specifies the
simplified behaviour if homotopy-based initialization is used:
</p>
<ul>
<li><code>NoHomotopy</code>: the actual expression with limits is used</li>
<li><code>Linear</code>: a linear behaviour y = u is assumed (default option)</li>
<li><code>UpperLimit</code>: it is assumed that the output is stuck at the upper limit u = uMax</li>
<li><code>LowerLimit</code>: it is assumed that the output is stuck at the lower limit u = uMin</li>
</ul>
<p>
If it is known a priori in which region the input signal will be located, this option can help
a lot by removing one strong nonlinearity from the initialization problem.
</p>
</html>"),     Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{0,-90},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,-8},{68,8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-50,-70},{50,70},{80,70}}),
              Text(
                extent={{-150,-150},{150,-110}},
                textString="uMax=%uMax"),
              Line(
                visible=strict,
                points={{50,70},{80,70}},
                color={255,0,0}),
              Line(
                visible=strict,
                points={{-80,-70},{-50,-70}},
                color={255,0,0})}));
          end Limiter;
          annotation (
            Documentation(info="<html>
<p>
This package contains <strong>discontinuous</strong> and
<strong>non-differentiable, algebraic</strong> input/output blocks.
</p>
</html>",     revisions="<html>
<ul>
<li><em>October 21, 2002</em>
       by Christian Schweiger:<br>
       New block VariableLimiter added.</li>
<li><em>August 22, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.
</li>
</ul>
</html>"),     Icon(graphics={Line(points={{-80,-66},{-26,-66},{28,52},{88,52}},
                color={95,95,95})}));
    end Nonlinear;

    package Routing "Library of blocks to combine and extract signals"
      extends Modelica.Icons.Package;

      model BooleanPassThrough "Pass a Boolean signal through without modification"
        extends Modelica.Blocks.Interfaces.BooleanSISO;
      equation
        y = u;
        annotation (Documentation(info="<html>
<p>Passes a Boolean signal through without modification.  Enables signals to be read out of one bus, have their name changed and be sent back to a bus.</p>
</html>"),Icon(
            coordinateSystem(preserveAspectRatio=true,
                extent={{-100.0,-100.0},{100.0,100.0}}),
                graphics={
            Line(
              points={{-100.0,0.0},{100.0,0.0}},
              color={255,0,255})}));
      end BooleanPassThrough;
      annotation (Documentation(info="<html>
<p>
This package contains blocks to combine and extract signals.
</p>
</html>"),     Icon(graphics={
            Line(points={{-90,0},{4,0}}, color={95,95,95}),
            Line(points={{88,65},{48,65},{-8,0}}, color={95,95,95}),
            Line(points={{-8,0},{93,0}}, color={95,95,95}),
            Line(points={{87,-65},{48,-65},{-8,0}}, color={95,95,95})}));
    end Routing;

    package Sources
    "Library of signal source blocks generating Real, Integer and Boolean signals"
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.SourcesPackage;

      block RealExpression "Set output signal to a time varying Real expression"

        Modelica.Blocks.Interfaces.RealOutput y=0.0 "Value of Real output"
          annotation (Dialog(group="Time varying output signal"), Placement(
              transformation(extent={{100,-10},{120,10}})));

        annotation (Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-100,-100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,40},{100,-40}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-96,15},{96,-15}},
                textString="%y"),
              Text(
                extent={{-150,90},{150,50}},
                textString="%name",
                textColor={0,0,255})}), Documentation(info="<html>
<p>
The (time varying) Real output signal of this block can be defined in its
parameter menu via variable <strong>y</strong>. The purpose is to support the
easy definition of Real expressions in a block diagram. For example,
in the y-menu the definition \"if time &lt; 1 then 0 else 1\" can be given in order
to define that the output signal is one, if time &ge; 1 and otherwise
it is zero. Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that
variable <strong>y</strong> is both a variable and a connector.
</p>
</html>"));

      end RealExpression;

      block BooleanExpression
        "Set output signal to a time varying Boolean expression"

        Modelica.Blocks.Interfaces.BooleanOutput y=false "Value of Boolean output"
          annotation (Dialog(group="Time varying output signal"), Placement(
              transformation(extent={{100,-10},{120,10}})));

        annotation (Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-100,-100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,40},{100,-40}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-96,15},{96,-15}},
                textString="%y"),
              Text(
                extent={{-150,90},{150,50}},
                textString="%name",
                textColor={0,0,255}),
              Polygon(
                points={{100,10},{120,0},{100,-10},{100,10}},
                lineColor=DynamicSelect({255,0,255}, if y then {0,255,0} else {255,0,255}),
                fillColor=DynamicSelect({255,255,255}, if y then {0,255,0} else {255,255,255}),
                fillPattern=FillPattern.Solid)}), Documentation(info="<html>
<p>
The (time varying) Boolean output signal of this block can be defined in its
parameter menu via variable <strong>y</strong>. The purpose is to support the
easy definition of Boolean expressions in a block diagram. For example,
in the y-menu the definition \"time &gt;= 1 and time &lt;= 2\" can be given in order
to define that the output signal is <strong>true</strong> in the time interval
1 &le; time &le; 2 and otherwise it is <strong>false</strong>.
Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that
variable <strong>y</strong> is both a variable and a connector.
</p>
</html>"));

      end BooleanExpression;

      block Constant "Generate constant signal of type Real"
        parameter Real k(start=1) "Constant output value"
        annotation(Dialog(groupImage="modelica://Modelica/Resources/Images/Blocks/Sources/Constant.png"));
        extends Interfaces.SO;

      equation
        y = k;
        annotation (
          defaultComponentName="const",
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{80,0}}),
              Text(
                extent={{-150,-150},{150,-110}},
                textString="k=%k")}),
          Documentation(info="<html>
<p>
The Real output y is a constant signal:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Sources/Constant.png\"
     alt=\"Constant.png\">
</p>
</html>"));
      end Constant;

      block Ramp "Generate ramp signal"
        parameter Real height=1 "Height of ramps"
          annotation(Dialog(groupImage="modelica://Modelica/Resources/Images/Blocks/Sources/Ramp.png"));
        parameter SI.Time duration(min=0.0, start=2)
          "Duration of ramp (= 0.0 gives a Step)";
        extends Interfaces.SignalSource;

      equation
        y = offset + (if time < startTime then 0 else if time < (startTime +
          duration) then (time - startTime)*height/duration else height);
        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-40,-70},{31,38}}),
              Text(
                extent={{-150,-150},{150,-110}},
                textString="duration=%duration"),
              Line(points={{31,38},{86,38}})}),
          Documentation(info="<html>
<p>
The Real output y is a ramp signal:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Sources/Ramp.png\"
     alt=\"Ramp.png\">
</p>

<p>
If parameter duration is set to 0.0, the limiting case of a Step signal is achieved.
</p>
</html>"));
      end Ramp;

      block CombiTimeTable
        "Table look-up with respect to time and linear/periodic extrapolation methods (data from matrix/file)"
        import Modelica.Blocks.Tables.Internal;
        extends Modelica.Blocks.Interfaces.MO(final nout=max([size(columns, 1); size(offset, 1)]));
        parameter Boolean tableOnFile=false
          "= true, if table is defined on file or in function usertab"
          annotation (Dialog(group="Table data definition"));
        parameter Real table[:, :] = fill(0.0, 0, 2)
          "Table matrix (time = first column; e.g., table=[0, 0; 1, 1; 2, 4])"
          annotation (Dialog(group="Table data definition",enable=not tableOnFile));
        parameter String tableName="NoName"
          "Table name on file or in function usertab (see docu)"
          annotation (Dialog(group="Table data definition",enable=tableOnFile));
        parameter String fileName="NoName" "File where matrix is stored"
          annotation (Dialog(
            group="Table data definition",
            enable=tableOnFile,
            loadSelector(filter="Text files (*.txt);;MATLAB MAT-files (*.mat)",
                caption="Open file in which table is present")));
        parameter Boolean verboseRead=true
          "= true, if info message that file is loading is to be printed"
          annotation (Dialog(group="Table data definition",enable=tableOnFile));
        parameter Integer columns[:]=2:size(table, 2)
          "Columns of table to be interpolated"
          annotation (Dialog(group="Table data interpretation",
          groupImage="modelica://Modelica/Resources/Images/Blocks/Sources/CombiTimeTable.png"));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments
          "Smoothness of table interpolation"
          annotation (Dialog(group="Table data interpretation"));
        parameter Modelica.Blocks.Types.Extrapolation extrapolation=Modelica.Blocks.Types.Extrapolation.LastTwoPoints
          "Extrapolation of data outside the definition range"
          annotation (Dialog(group="Table data interpretation"));
        parameter SI.Time timeScale(
          min=Modelica.Constants.eps)=1 "Time scale of first table column"
          annotation (Dialog(group="Table data interpretation"), Evaluate=true);
        parameter Real offset[:]={0} "Offsets of output signals"
          annotation (Dialog(group="Table data interpretation"));
        parameter SI.Time startTime=0
          "Output = offset for time < startTime"
          annotation (Dialog(group="Table data interpretation"));
        parameter SI.Time shiftTime=startTime
          "Shift time of first table column"
          annotation (Dialog(group="Table data interpretation"));
        parameter Modelica.Blocks.Types.TimeEvents timeEvents=Modelica.Blocks.Types.TimeEvents.Always
          "Time event handling of table interpolation"
          annotation (Dialog(group="Table data interpretation", enable=smoothness == Modelica.Blocks.Types.Smoothness.LinearSegments));
        parameter Boolean verboseExtrapolation=false
          "= true, if warning messages are to be printed if time is outside the table definition range"
          annotation (Dialog(group="Table data interpretation", enable=extrapolation == Modelica.Blocks.Types.Extrapolation.LastTwoPoints or extrapolation == Modelica.Blocks.Types.Extrapolation.HoldLastPoint));
        final parameter SI.Time t_min=t_minScaled*timeScale
          "Minimum abscissa value defined in table";
        final parameter SI.Time t_max=t_maxScaled*timeScale
          "Maximum abscissa value defined in table";
        final parameter Real t_minScaled=Internal.getTimeTableTmin(tableID)
          "Minimum (scaled) abscissa value defined in table";
        final parameter Real t_maxScaled=Internal.getTimeTableTmax(tableID)
          "Maximum (scaled) abscissa value defined in table";
    protected
        final parameter Real p_offset[nout]=(if size(offset, 1) == 1 then ones(nout)*offset[1] else offset)
          "Offsets of output signals";
        parameter Modelica.Blocks.Types.ExternalCombiTimeTable tableID=
            Modelica.Blocks.Types.ExternalCombiTimeTable(
              if tableOnFile then tableName else "NoName",
              if tableOnFile and fileName <> "NoName" and not Modelica.Utilities.Strings.isEmpty(fileName) then fileName else "NoName",
              table,
              startTime/timeScale,
              columns,
              smoothness,
              extrapolation,
              shiftTime/timeScale,
              if smoothness == Modelica.Blocks.Types.Smoothness.LinearSegments then timeEvents elseif smoothness == Modelica.Blocks.Types.Smoothness.ConstantSegments then Modelica.Blocks.Types.TimeEvents.Always else Modelica.Blocks.Types.TimeEvents.NoTimeEvents,
              if tableOnFile then verboseRead else false) "External table object";
        discrete SI.Time nextTimeEvent(start=0, fixed=true)
          "Next time event instant";
        discrete Real nextTimeEventScaled(start=0, fixed=true)
          "Next scaled time event instant";
        Real timeScaled "Scaled time";
      equation
        if tableOnFile then
          assert(tableName <> "NoName",
            "tableOnFile = true and no table name given");
        else
          assert(size(table, 1) > 0 and size(table, 2) > 0,
            "tableOnFile = false and parameter table is an empty matrix");
        end if;

        if verboseExtrapolation and (
          extrapolation == Modelica.Blocks.Types.Extrapolation.LastTwoPoints or
          extrapolation == Modelica.Blocks.Types.Extrapolation.HoldLastPoint) then
          assert(noEvent(time >= t_min), "
Extrapolation warning: Time (="     + String(time) + ") must be greater or equal
than the minimum abscissa value t_min (="     + String(t_min) + ") defined in the table.
",     level=AssertionLevel.warning);
          assert(noEvent(time <= t_max), "
Extrapolation warning: Time (="     + String(time) + ") must be less or equal
than the maximum abscissa value t_max (="     + String(t_max) + ") defined in the table.
",     level=AssertionLevel.warning);
        end if;

        timeScaled = time/timeScale;
        when {time >= pre(nextTimeEvent), initial()} then
          nextTimeEventScaled = Internal.getNextTimeEvent(tableID, timeScaled);
          nextTimeEvent = if nextTimeEventScaled < Modelica.Constants.inf then nextTimeEventScaled*timeScale else Modelica.Constants.inf;
        end when;
        if smoothness == Modelica.Blocks.Types.Smoothness.ConstantSegments then
          for i in 1:nout loop
            y[i] = p_offset[i] + Internal.getTimeTableValueNoDer(tableID, i, timeScaled, nextTimeEventScaled, pre(nextTimeEventScaled));
          end for;
        elseif smoothness == Modelica.Blocks.Types.Smoothness.LinearSegments then
          for i in 1:nout loop
            y[i] = p_offset[i] + Internal.getTimeTableValueNoDer2(tableID, i, timeScaled, nextTimeEventScaled, pre(nextTimeEventScaled));
          end for;
        else
          for i in 1:nout loop
            y[i] = p_offset[i] + Internal.getTimeTableValue(tableID, i, timeScaled, nextTimeEventScaled, pre(nextTimeEventScaled));
          end for;
        end if;
        annotation (
          Documentation(info="<html>
<p>
This block generates an output signal y[:] by <strong>constant</strong>,
<strong>linear</strong> or <strong>cubic Hermite spline interpolation</strong>
in a table. The time points and function values are stored in a matrix
<strong>table[i,j]</strong>, where the first column table[:,1] contains the
time points and the other columns contain the data to be interpolated.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Sources/CombiTimeTable.png\"
     alt=\"CombiTimeTable.png\">
</p>

<p>
Via parameter <strong>columns</strong> it can be defined which columns of the
table are interpolated. If, e.g., columns={2,4}, it is assumed that
2 output signals are present and that the first output is computed
by interpolation of column 2 and the second output is computed
by interpolation of column 4 of the table matrix.
The table interpolation has the following properties:
</p>
<ul>
<li>The interpolation interval is found by a binary search where the interval used in the
    last call is used as start interval.</li>
<li>The time points need to be <strong>strictly increasing</strong> for cubic Hermite
    spline interpolation, otherwise <strong>monotonically increasing</strong>.</li>
<li><strong>Discontinuities</strong> are allowed for (constant or) linear interpolation,
    by providing the same time point twice in the table.</li>
<li>Via parameter <strong>smoothness</strong> it is defined how the data is interpolated:
<blockquote><pre>
smoothness = 1: Linear interpolation
           = 2: Akima interpolation: Smooth interpolation by cubic Hermite
                splines such that der(y) is continuous, also if extrapolated.
           = 3: Constant segments
           = 4: Fritsch-Butland interpolation: Smooth interpolation by cubic
                Hermite splines such that y preserves the monotonicity and
                der(y) is continuous, also if extrapolated.
           = 5: Steffen interpolation: Smooth interpolation by cubic Hermite
                splines such that y preserves the monotonicity and der(y)
                is continuous, also if extrapolated.
           = 6: Modified Akima interpolation: Smooth interpolation by cubic
                Hermite splines such that der(y) is continuous, also if
                extrapolated. Additionally, overshoots and edge cases of the
                original Akima interpolation method are avoided.
</pre></blockquote></li>
<li>First and second <strong>derivatives</strong> are provided, with exception of the following two smoothness options.
<ol>
<li>No derivatives are provided for interpolation by constant segments.</li>
<li>No second derivative is provided for linear interpolation.<br>There is a design inconsistency, that it is possible
to model a signal consisting of constant segments using linear interpolation and duplicated sample points.
In contrast to interpolation by constant segments, the first derivative is provided as zero.</li>
</ol></li>
<li>Values <strong>outside</strong> of the table range, are computed by
    extrapolation according to the setting of parameter <strong>extrapolation</strong>:
<blockquote><pre>
extrapolation = 1: Hold the first or last value of the table,
                   if outside of the table scope.
              = 2: Extrapolate by using the derivative at the first/last table
                   points if outside of the table scope.
                   (If smoothness is LinearSegments or ConstantSegments
                   this means to extrapolate linearly through the first/last
                   two table points.).
              = 3: Periodically repeat the table data (periodical function).
              = 4: No extrapolation, i.e. extrapolation triggers an error
</pre></blockquote></li>
<li>If the table has only <strong>one row</strong>, no interpolation is performed and
    the table values of this row are just returned.</li>
<li>Via parameters <strong>shiftTime</strong> and <strong>offset</strong> the curve defined
    by the table can be shifted both in time and in the ordinate value.
    The time instants stored in the table are therefore <strong>relative</strong>
    to <strong>shiftTime</strong>.</li>
<li>If time &lt; startTime, no interpolation is performed and the offset
    is used as ordinate value for all outputs.</li>
<li>The table is implemented in a numerically sound way by
    generating <strong>time events</strong> at interval boundaries, in case of
    interpolation by linear segments.
    This generates continuously differentiable values for the integrator.
    Via parameter <strong>timeEvents</strong> it is defined how the time events are generated:
<blockquote><pre>
timeEvents = 1: Always generate time events at interval boundaries
           = 2: Generate time events at discontinuities (defined by duplicated sample points)
           = 3: No time events at interval boundaries
</pre></blockquote>
    For interpolation by constant segments time events are always generated at interval boundaries.
    For smooth interpolation by cubic Hermite splines no time events are generated at interval boundaries.</li>
<li>Via parameter <strong>timeScale</strong> the first column of the table array can
    be scaled, e.g., if the table array is given in hours (instead of seconds)
    <strong>timeScale</strong> shall be set to 3600.</li>
<li>For special applications it is sometimes needed to know the minimum
    and maximum time instant defined in the table as a parameter. For this
    reason parameters <strong>t_min</strong>/<strong>t_minScaled</strong> and
    <strong>t_max</strong>/<strong>t_maxScaled</strong> are provided and can be
    accessed from the outside of the table object. Whereas <strong>t_min</strong> and
    <strong>t_max</strong> define the scaled abscissa values (using parameter
    <strong>timeScale</strong>) in SI.Time, <strong>t_minScaled</strong> and
    <strong>t_maxScaled</strong> define the unitless original abscissa values of
    the table.</li>
</ul>
<p>
Example:
</p>
<blockquote><pre>
table = [0, 0;
         1, 0;
         1, 1;
         2, 4;
         3, 9;
         4, 16];
extrapolation = 2 (default), timeEvents = 2
If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
    e.g., time = 1.5, the output y =  2.5,
    e.g., time = 2.0, the output y =  4.0,
    e.g., time = 5.0, the output y = 23.0 (i.e., extrapolation via last 2 points).
</pre></blockquote>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li>Explicitly supplied as <strong>parameter matrix</strong> \"table\",
    and the other parameters have the following values:
<blockquote><pre>
tableName is \"NoName\" or has only blanks,
fileName  is \"NoName\" or has only blanks.
</pre></blockquote></li>
<li><strong>Read</strong> from a <strong>file</strong> \"fileName\" where the matrix is stored as
    \"tableName\". Both text and MATLAB MAT-file format is possible.
    (The text format is described below).
    The MAT-file format comes in four different versions: v4, v6, v7 and v7.3.
    The library supports at least v4, v6 and v7 whereas v7.3 is optional.
    It is most convenient to generate the MAT-file from FreeMat or MATLAB&reg;
    by command
<blockquote><pre>
save tables.mat tab1 tab2 tab3
</pre></blockquote>
    or Scilab by command
<blockquote><pre>
savematfile tables.mat tab1 tab2 tab3
</pre></blockquote>
    when the three tables tab1, tab2, tab3 should be used from the model.<br>
    Note, a fileName can be defined as URI by using the helper function
    <a href=\"modelica://Modelica.Utilities.Files.loadResource\">loadResource</a>.</li>
<li>Statically stored in function \"usertab\" in file \"usertab.c\".
    The matrix is identified by \"tableName\". Parameter
    fileName = \"NoName\" or has only blanks. Row-wise storage is always to be
    preferred as otherwise the table is reallocated and transposed.</li>
</ol>
<p>
When the constant \"NO_FILE_SYSTEM\" is defined, all file I/O related parts of the
source code are removed by the C-preprocessor, such that no access to files takes place.
</p>
<p>
If tables are read from a text file, the file needs to have the
following structure (\"-----\" is not part of the file content):
</p>
<blockquote><pre>
-----------------------------------------------------
#1
double tab1(6,2)   # comment line
  0   0
  1   0
  1   1
  2   4
  3   9
  4  16
double tab2(6,2)   # another comment line
  0   0
  2   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre></blockquote>
<p>
Note, that the first two characters in the file need to be
\"#1\" (a line comment defining the version number of the file format).
Afterwards, the corresponding matrix has to be declared
with type (= \"double\" or \"float\"), name and actual dimensions.
Finally, in successive rows of the file, the elements of the matrix
have to be given. The elements have to be provided as a sequence of
numbers in row-wise order (therefore a matrix row can span several
lines in the file and need not start at the beginning of a line).
Numbers have to be given according to C syntax (such as 2.3, -2, +2.e4).
Number separators are spaces, tab (\\t), comma (,), or semicolon (;).
Several matrices may be defined one after another. Line comments start
with the hash symbol (#) and can appear everywhere.
Text files should either be ASCII or UTF-8 encoded, where UTF-8 encoded strings are only allowed in line comments and an optional UTF-8 BOM at the start of the text file is ignored.
Other characters, like trailing non comments, are not allowed in the file.
</p>
<p>
MATLAB is a registered trademark of The MathWorks, Inc.
</p>
</html>",     revisions="<html>
<p><strong>Release Notes:</strong></p>
<ul>
<li><em>April 09, 2013</em>
       by Thomas Beutlich:<br>
       Implemented as external object.</li>
<li><em>March 31, 2001</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Used CombiTableTime as a basis and added the
       arguments <strong>extrapolation, columns, startTime</strong>.
       This allows periodic function definitions.</li>
</ul>
</html>"),Icon(
          coordinateSystem(preserveAspectRatio=true,
            extent={{-100.0,-100.0},{100.0,100.0}}),
            graphics={
          Polygon(lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid,
            points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}),
          Line(points={{-80.0,68.0},{-80.0,-80.0}},
            color={192,192,192}),
          Line(points={{-90.0,-70.0},{82.0,-70.0}},
            color={192,192,192}),
          Polygon(lineColor={192,192,192},
            fillColor={192,192,192},
            fillPattern=FillPattern.Solid,
            points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}),
          Rectangle(lineColor={255,255,255},
            fillColor={255,215,136},
            fillPattern=FillPattern.Solid,
            extent={{-48.0,-50.0},{2.0,70.0}}),
          Line(points={{-48.0,-50.0},{-48.0,70.0},{52.0,70.0},{52.0,-50.0},{-48.0,-50.0},{-48.0,-20.0},{52.0,-20.0},{52.0,10.0},{-48.0,10.0},{-48.0,40.0},{52.0,40.0},{52.0,70.0},{2.0,70.0},{2.0,-51.0}})}));
      end CombiTimeTable;
      annotation (Documentation(info="<html>
<p>
This package contains <strong>source</strong> components, i.e., blocks which
have only output signals. These blocks are used as signal generators
for Real, Integer and Boolean signals.
</p>

<p>
All Real source signals (with the exception of the Constant source)
have at least the following two parameters:
</p>

<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
  <tr><td><strong>offset</strong></td>
      <td>Value which is added to the signal</td>
  </tr>
  <tr><td><strong>startTime</strong></td>
      <td>Start time of signal. For time &lt; startTime,
                the output y is set to offset.</td>
  </tr>
</table>

<p>
The <strong>offset</strong> parameter is especially useful in order to shift
the corresponding source, such that at initial time the system
is stationary. To determine the corresponding value of offset,
usually requires a trimming calculation.
</p>
</html>",     revisions="<html>
<ul>
<li><em>October 21, 2002</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and Christian Schweiger:<br>
       Integer sources added. Step, TimeTable and BooleanStep slightly changed.</li>
<li><em>Nov. 8, 1999</em>
       by <a href=\"mailto:christoph@clauss-it.com\">Christoph Clau&szlig;</a>,
       <a href=\"mailto:Andre.Schneider@eas.iis.fraunhofer.de\">Andre.Schneider@eas.iis.fraunhofer.de</a>,
       <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       New sources: Exponentials, TimeTable. Trapezoid slightly enhanced
       (nperiod=-1 is an infinite number of periods).</li>
<li><em>Oct. 31, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       <a href=\"mailto:christoph@clauss-it.com\">Christoph Clau&szlig;</a>,
       <a href=\"mailto:Andre.Schneider@eas.iis.fraunhofer.de\">Andre.Schneider@eas.iis.fraunhofer.de</a>,
       All sources vectorized. New sources: ExpSine, Trapezoid,
       BooleanConstant, BooleanStep, BooleanPulse, SampleTrigger.
       Improved documentation, especially detailed description of
       signals in diagram layer.</li>
<li><em>June 29, 1999</em>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));
    end Sources;

    package Tables
    "Library of blocks to interpolate in one and two-dimensional tables"
      extends Modelica.Icons.Package;

      block CombiTable1Ds
        "Table look-up in one dimension (matrix/file) with one input and n outputs"
        extends Modelica.Blocks.Interfaces.SIMO(final nout=size(columns, 1));
        parameter Boolean tableOnFile=false
          "= true, if table is defined on file or in function usertab"
          annotation (Dialog(group="Table data definition"));
        parameter Real table[:, :] = fill(0.0, 0, 2)
          "Table matrix (grid = first column; e.g., table=[0, 0; 1, 1; 2, 4])"
          annotation (Dialog(group="Table data definition",enable=not tableOnFile));
        parameter String tableName="NoName"
          "Table name on file or in function usertab (see docu)"
          annotation (Dialog(group="Table data definition",enable=tableOnFile));
        parameter String fileName="NoName" "File where matrix is stored"
          annotation (Dialog(
            group="Table data definition",
            enable=tableOnFile,
            loadSelector(filter="Text files (*.txt);;MATLAB MAT-files (*.mat)",
                caption="Open file in which table is present")));
        parameter Boolean verboseRead=true
          "= true, if info message that file is loading is to be printed"
          annotation (Dialog(group="Table data definition",enable=tableOnFile));
        parameter Integer columns[:]=2:size(table, 2)
          "Columns of table to be interpolated"
          annotation (Dialog(group="Table data interpretation"));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments
          "Smoothness of table interpolation"
          annotation (Dialog(group="Table data interpretation"));
        parameter Modelica.Blocks.Types.Extrapolation extrapolation=Modelica.Blocks.Types.Extrapolation.LastTwoPoints
          "Extrapolation of data outside the definition range"
          annotation (Dialog(group="Table data interpretation"));
        parameter Boolean verboseExtrapolation=false
          "= true, if warning messages are to be printed if table input is outside the definition range"
          annotation (Dialog(group="Table data interpretation", enable=extrapolation == Modelica.Blocks.Types.Extrapolation.LastTwoPoints or extrapolation == Modelica.Blocks.Types.Extrapolation.HoldLastPoint));
        final parameter Real u_min=Internal.getTable1DAbscissaUmin(tableID)
          "Minimum abscissa value defined in table";
        final parameter Real u_max=Internal.getTable1DAbscissaUmax(tableID)
          "Maximum abscissa value defined in table";
    protected
        parameter Modelica.Blocks.Types.ExternalCombiTable1D tableID=
            Modelica.Blocks.Types.ExternalCombiTable1D(
              if tableOnFile then tableName else "NoName",
              if tableOnFile and fileName <> "NoName" and not Modelica.Utilities.Strings.isEmpty(fileName) then fileName else "NoName",
              table,
              columns,
              smoothness,
              extrapolation,
              if tableOnFile then verboseRead else false) "External table object";
      equation
        if tableOnFile then
          assert(tableName <> "NoName",
            "tableOnFile = true and no table name given");
        else
          assert(size(table, 1) > 0 and size(table, 2) > 0,
            "tableOnFile = false and parameter table is an empty matrix");
        end if;

        if verboseExtrapolation and (
          extrapolation == Modelica.Blocks.Types.Extrapolation.LastTwoPoints or
          extrapolation == Modelica.Blocks.Types.Extrapolation.HoldLastPoint) then
          assert(noEvent(u >= u_min), "
Extrapolation warning: The value u (="     + String(u) + ") must be greater or equal
than the minimum abscissa value u_min (="     + String(u_min) + ") defined in the table.
",     level=AssertionLevel.warning);
          assert(noEvent(u <= u_max), "
Extrapolation warning: The value u (="     + String(u) + ") must be less or equal
than the maximum abscissa value u_max (="     + String(u_max) + ") defined in the table.
",     level=AssertionLevel.warning);
        end if;

        if smoothness == Modelica.Blocks.Types.Smoothness.ConstantSegments then
          for i in 1:nout loop
            y[i] = Internal.getTable1DValueNoDer(tableID, i, u);
          end for;
        elseif smoothness == Modelica.Blocks.Types.Smoothness.LinearSegments then
          for i in 1:nout loop
            y[i] = Internal.getTable1DValueNoDer2(tableID, i, u);
          end for;
        else
          for i in 1:nout loop
            y[i] = Internal.getTable1DValue(tableID, i, u);
          end for;
        end if;
        annotation (
          Documentation(info="<html>
<p>
<strong>Univariate constant</strong>, <strong>linear</strong> or <strong>cubic Hermite
spline interpolation</strong> in <strong>one</strong> dimension of a
<strong>table</strong>.
Via parameter <strong>columns</strong> it can be defined how many columns of the
table are interpolated. If, e.g., columns={2,4}, it is assumed that
2 output signals are present and that the first output interpolates
via column 2 and the second output interpolates via column 4 of the
table matrix.
</p>
<p>
The grid points and function values are stored in a matrix \"table[i,j]\",
where the first column \"table[:,1]\" contains the grid points and the
other columns contain the data to be interpolated. Example:
</p>
<blockquote><pre>
table = [0,  0;
         1,  1;
         2,  4;
         4, 16]
If, e.g., the input u = 1.0, the output y =  1.0,
    e.g., the input u = 1.5, the output y =  2.5,
    e.g., the input u = 2.0, the output y =  4.0,
    e.g., the input u =-1.0, the output y = -1.0 (i.e., extrapolation).
</pre></blockquote>
<ul>
<li>The interpolation interval is found by a binary search where the interval used in the
    last call is used as start interval.</li>
<li>Via parameter <strong>smoothness</strong> it is defined how the data is interpolated:
<blockquote><pre>
smoothness = 1: Linear interpolation
           = 2: Akima interpolation: Smooth interpolation by cubic Hermite
                splines such that der(y) is continuous, also if extrapolated.
           = 3: Constant segments
           = 4: Fritsch-Butland interpolation: Smooth interpolation by cubic
                Hermite splines such that y preserves the monotonicity and
                der(y) is continuous, also if extrapolated.
           = 5: Steffen interpolation: Smooth interpolation by cubic Hermite
                splines such that y preserves the monotonicity and der(y)
                is continuous, also if extrapolated.
           = 6: Modified Akima interpolation: Smooth interpolation by cubic
                Hermite splines such that der(y) is continuous, also if
                extrapolated. Additionally, overshoots and edge cases of the
                original Akima interpolation method are avoided.
</pre></blockquote></li>
<li>First and second <strong>derivatives</strong> are provided, with exception of the following two smoothness options.
<ol>
<li>No derivatives are provided for interpolation by constant segments.</li>
<li>No second derivative is provided for linear interpolation.</li>
</ol></li>
<li>Values <strong>outside</strong> of the table range, are computed by
    extrapolation according to the setting of parameter <strong>extrapolation</strong>:
<blockquote><pre>
extrapolation = 1: Hold the first or last value of the table,
                   if outside of the table scope.
              = 2: Extrapolate by using the derivative at the first/last table
                   points if outside of the table scope.
                   (If smoothness is LinearSegments or ConstantSegments
                   this means to extrapolate linearly through the first/last
                   two table points.).
              = 3: Periodically repeat the table data (periodical function).
              = 4: No extrapolation, i.e. extrapolation triggers an error
</pre></blockquote></li>
<li>If the table has only <strong>one row</strong>, the table value is returned,
    independent of the value of the input signal.</li>
<li>The grid values (first column) have to be strictly increasing.</li>
</ul>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li>Explicitly supplied as <strong>parameter matrix</strong> \"table\",
    and the other parameters have the following values:
<blockquote><pre>
tableName is \"NoName\" or has only blanks,
fileName  is \"NoName\" or has only blanks.
</pre></blockquote></li>
<li><strong>Read</strong> from a <strong>file</strong> \"fileName\" where the matrix is stored as
    \"tableName\". Both text and MATLAB MAT-file format is possible.
    (The text format is described below).
    The MAT-file format comes in four different versions: v4, v6, v7 and v7.3.
    The library supports at least v4, v6 and v7 whereas v7.3 is optional.
    It is most convenient to generate the MAT-file from FreeMat or MATLAB&reg;
    by command
<blockquote><pre>
save tables.mat tab1 tab2 tab3
</pre></blockquote>
    or Scilab by command
<blockquote><pre>
savematfile tables.mat tab1 tab2 tab3
</pre></blockquote>
    when the three tables tab1, tab2, tab3 should be used from the model.<br>
    Note, a fileName can be defined as URI by using the helper function
    <a href=\"modelica://Modelica.Utilities.Files.loadResource\">loadResource</a>.</li>
<li>Statically stored in function \"usertab\" in file \"usertab.c\".
    The matrix is identified by \"tableName\". Parameter
    fileName = \"NoName\" or has only blanks. Row-wise storage is always to be
    preferred as otherwise the table is reallocated and transposed.
    See the <a href=\"modelica://Modelica.Blocks.Tables\">Tables</a> package
    documentation for more details.</li>
</ol>
<p>
When the constant \"NO_FILE_SYSTEM\" is defined, all file I/O related parts of the
source code are removed by the C-preprocessor, such that no access to files takes place.
</p>
<p>
If tables are read from a text file, the file needs to have the
following structure (\"-----\" is not part of the file content):
</p>
<blockquote><pre>
-----------------------------------------------------
#1
double tab1(5,2)   # comment line
  0   0
  1   1
  2   4
  3   9
  4  16
double tab2(5,2)   # another comment line
  0   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre></blockquote>
<p>
Note, that the first two characters in the file need to be
\"#1\" (a line comment defining the version number of the file format).
Afterwards, the corresponding matrix has to be declared
with type (= \"double\" or \"float\"), name and actual dimensions.
Finally, in successive rows of the file, the elements of the matrix
have to be given. The elements have to be provided as a sequence of
numbers in row-wise order (therefore a matrix row can span several
lines in the file and need not start at the beginning of a line).
Numbers have to be given according to C syntax (such as 2.3, -2, +2.e4).
Number separators are spaces, tab (\\t), comma (,), or semicolon (;).
Several matrices may be defined one after another. Line comments start
with the hash symbol (#) and can appear everywhere.
Text files should either be ASCII or UTF-8 encoded, where UTF-8 encoded strings are only allowed in line comments and an optional UTF-8 BOM at the start of the text file is ignored.
Other characters, like trailing non comments, are not allowed in the file.
</p>
<p>
MATLAB is a registered trademark of The MathWorks, Inc.
</p>
</html>"),Icon(
          coordinateSystem(preserveAspectRatio=true,
            extent={{-100.0,-100.0},{100.0,100.0}}),
            graphics={
          Line(points={{-60.0,40.0},{-60.0,-40.0},{60.0,-40.0},{60.0,40.0},{30.0,40.0},{30.0,-40.0},{-30.0,-40.0},{-30.0,40.0},{-60.0,40.0},{-60.0,20.0},{60.0,20.0},{60.0,0.0},{-60.0,0.0},{-60.0,-20.0},{60.0,-20.0},{60.0,-40.0},{-60.0,-40.0},{-60.0,40.0},{60.0,40.0},{60.0,-40.0}}),
          Line(points={{0.0,40.0},{0.0,-40.0}}),
          Rectangle(fillColor={255,215,136},
            fillPattern=FillPattern.Solid,
            extent={{-60.0,20.0},{-30.0,40.0}}),
          Rectangle(fillColor={255,215,136},
            fillPattern=FillPattern.Solid,
            extent={{-60.0,0.0},{-30.0,20.0}}),
          Rectangle(fillColor={255,215,136},
            fillPattern=FillPattern.Solid,
            extent={{-60.0,-20.0},{-30.0,0.0}}),
          Rectangle(fillColor={255,215,136},
            fillPattern=FillPattern.Solid,
            extent={{-60.0,-40.0},{-30.0,-20.0}})}));
      end CombiTable1Ds;

      package Internal
      "Internal external object definitions for table functions that should not be directly utilized by the user"
        extends Modelica.Icons.InternalPackage;

        pure function getTimeTableValue
          "Interpolate 1-dim. table where first column is time"
          extends Modelica.Icons.Function;
          input Modelica.Blocks.Types.ExternalCombiTimeTable tableID "External table object";
          input Integer icol "Column number";
          input Real timeIn "(Scaled) time value";
          discrete input Real nextTimeEvent "(Scaled) next time event in table";
          discrete input Real pre_nextTimeEvent "Pre-value of (scaled) next time event in table";
          output Real y "Interpolated value";
          external "C" y = ModelicaStandardTables_CombiTimeTable_getValue(tableID, icol, timeIn, nextTimeEvent, pre_nextTimeEvent)
            annotation (IncludeDirectory="modelica://Modelica/Resources/C-Sources",  Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
          annotation (derivative(
              noDerivative=nextTimeEvent,
              noDerivative=pre_nextTimeEvent) = getDerTimeTableValue);
        end getTimeTableValue;

        pure function getTimeTableValueNoDer
          "Interpolate 1-dim. table where first column is time (but do not provide a derivative function)"
          extends Modelica.Icons.Function;
          input Modelica.Blocks.Types.ExternalCombiTimeTable tableID "External table object";
          input Integer icol "Column number";
          input Real timeIn "(Scaled) time value";
          discrete input Real nextTimeEvent "(Scaled) next time event in table";
          discrete input Real pre_nextTimeEvent "Pre-value of (scaled) next time event in table";
          output Real y "Interpolated value";
          external "C" y = ModelicaStandardTables_CombiTimeTable_getValue(tableID, icol, timeIn, nextTimeEvent, pre_nextTimeEvent)
            annotation (IncludeDirectory="modelica://Modelica/Resources/C-Sources",  Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
        end getTimeTableValueNoDer;

        pure function getTimeTableValueNoDer2
          "Interpolate 1-dim. table where first column is time (but do not provide a second derivative function)"
          extends Modelica.Icons.Function;
          input Modelica.Blocks.Types.ExternalCombiTimeTable tableID "External table object";
          input Integer icol "Column number";
          input Real timeIn "(Scaled) time value";
          discrete input Real nextTimeEvent "(Scaled) next time event in table";
          discrete input Real pre_nextTimeEvent "Pre-value of (scaled) next time event in table";
          output Real y "Interpolated value";
          external "C" y = ModelicaStandardTables_CombiTimeTable_getValue(tableID, icol, timeIn, nextTimeEvent, pre_nextTimeEvent)
            annotation (IncludeDirectory="modelica://Modelica/Resources/C-Sources",  Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
          annotation (derivative(
              noDerivative=nextTimeEvent,
              noDerivative=pre_nextTimeEvent) = getDerTimeTableValueNoDer);
        end getTimeTableValueNoDer2;

        pure function getDerTimeTableValue
          "Derivative of interpolated 1-dim. table where first column is time"
          extends Modelica.Icons.Function;
          input Modelica.Blocks.Types.ExternalCombiTimeTable tableID "External table object";
          input Integer icol "Column number";
          input Real timeIn "(Scaled) time value";
          discrete input Real nextTimeEvent "(Scaled) next time event in table";
          discrete input Real pre_nextTimeEvent "Pre-value of (scaled) next time event in table";
          input Real der_timeIn "Derivative of (scaled) time value";
          output Real der_y "Derivative of interpolated value";
          external "C" der_y = ModelicaStandardTables_CombiTimeTable_getDerValue(tableID, icol, timeIn, nextTimeEvent, pre_nextTimeEvent, der_timeIn)
            annotation (IncludeDirectory="modelica://Modelica/Resources/C-Sources",  Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
          annotation (derivative(
              order=2,
              noDerivative=nextTimeEvent,
              noDerivative=pre_nextTimeEvent) = getDer2TimeTableValue);
        end getDerTimeTableValue;

        pure function getDerTimeTableValueNoDer
          "Derivative of interpolated 1-dim. table where first column is time (but do not provide a derivative function)"
          extends Modelica.Icons.Function;
          input Modelica.Blocks.Types.ExternalCombiTimeTable tableID "External table object";
          input Integer icol "Column number";
          input Real timeIn "(Scaled) time value";
          discrete input Real nextTimeEvent "(Scaled) next time event in table";
          discrete input Real pre_next