within ThermoSysPro.InstrumentationAndControl.Blocks.Sources;
block Rampe
  parameter Real Starttime=1 "Instant de dpart de la rampe (s)";
  parameter Real Duration=2 "Dure de la rampe (s)";
  parameter Real Initialvalue=0 "Valeur initiale de la sortie";
  parameter Real Finalvalue=1 "Valeur finale de la sortie";
  annotation(Diagram(coordinateSystem(extent={{-100,-100},{100,100}}), graphics={Polygon(points={{-80,90},{-88,68},{-72,68},{-80,90}}, fillPattern=FillPattern.Solid, lineColor={192,192,192}, fillColor={192,192,192}),Line(points={{-80,68},{-80,-80}}, color={192,192,192}),Line(points={{-80,-20},{-20,-20},{50,50}}, color={0,0,0}, thickness=0.5),Line(points={{-90,-70},{82,-70}}, color={192,192,192}),Polygon(points={{90,-70},{68,-62},{68,-78},{90,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-30,-20},{-32,-30},{-27,-30},{-30,-20}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-30,-20},{-30,-70}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-30,-70},{-33,-60},{-28,-60},{-30,-70},{-30,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(lineColor={0,0,255}, extent={{-80,-33},{-30,-50}}, textString="initialValue", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{-40,-70},{6,-88}}, textString="startTime", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{-80,92},{-39,72}}, textString="y", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{70,-80},{94,-100}}, textString="temps", fillColor={160,160,160}),Line(points={{-20,-20},{-20,-70}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19,-20},{50,-20}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{50,50},{101,50}}, color={0,0,0}, thickness=0.5),Line(points={{50,50},{50,-62}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{50,-20},{42,-18},{42,-22},{50,-20}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-20,-20},{-11,-18},{-11,-22},{-20,-20}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50,50},{48,40},{53,40},{50,50}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50,-72},{47,-62},{52,-62},{50,-72},{50,-72}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(lineColor={0,0,255}, extent={{53,25},{100,8}}, textString="finalValue", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{0,-17},{35,-37}}, textString="duration", fillColor={160,160,160})}), Icon(coordinateSystem(extent={{-100,-100},{100,100}}), graphics={Rectangle(extent={{-100,-100},{100,100}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}, fillColor={255,255,255}),Line(points={{-80,68},{-80,-80}}, color={192,192,192}),Polygon(points={{-80,90},{-88,68},{-72,68},{-80,90}}, fillPattern=FillPattern.Solid, lineColor={192,192,192}, fillColor={192,192,192}),Line(points={{-90,-70},{82,-70}}, color={192,192,192}),Polygon(points={{90,-70},{68,-62},{68,-78},{90,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80,-70},{-40,-70},{31,38}}, color={0,0,0}),Line(points={{31,38},{86,38}}, color={0,0,0}),Text(lineColor={0,0,255}, extent={{-150,150},{150,110}}, textString="%name")}), Documentation(info="<html>
<p><b>Adapted from the Modelica.Blocks.Sources library</b></p>
</HTML>
<html>
<p><b>Version 1.0</b></p>
</HTML>
"));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal y annotation(Placement(transformation(x=110.0, y=0.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=110.0, y=0.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
equation
  y.signal=if time < Starttime then Initialvalue else if time > Starttime + Duration then Finalvalue else Initialvalue + (Finalvalue - Initialvalue)*(time - Starttime)/Duration;
end Rampe;
