within ThermoSysPro.InstrumentationAndControl.Blocks.Logique;
block Pulse
  parameter Real width=0.5 "Largeur des impulsions (s)";
  parameter Real period=1 "Periode des impulsions (s)";
  parameter Real startTime=0 "Instant de dpart des impulsions";
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputLogical yL annotation(Placement(transformation(x=110.0, y=0.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=110.0, y=0.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
protected
  Real T0;
  annotation(Icon(coordinateSystem(extent={{-100,-100},{100,100}}), graphics={Rectangle(extent={{-100,-100},{100,100}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}, fillColor={255,255,255}),Line(points={{-80,68},{-80,-80}}, color={192,192,192}),Polygon(points={{-80,90},{-88,68},{-72,68},{-80,90}}, fillPattern=FillPattern.Solid, lineColor={192,192,192}, fillColor={192,192,192}),Line(points={{-90,-70},{82,-70}}, color={192,192,192}),Polygon(points={{90,-70},{68,-62},{68,-78},{90,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80,-70},{-40,-70},{-40,44},{0,44},{0,-70},{40,-70},{40,44},{79,44}}, color={0,0,0}),Rectangle(extent={{-100,-102},{100,100}}, lineColor={0,0,255}, pattern=LinePattern.Solid, lineThickness=0.25, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Line(points={{-80,-70},{-40,-70},{-40,44},{0,44},{0,-70},{40,-70},{40,44},{79,44}}, color={0,0,0}),Line(points={{-80,68},{-80,-80}}, color={192,192,192}),Line(points={{-90,-70},{82,-70}}, color={192,192,192}),Polygon(points={{90,-70},{68,-62},{68,-78},{90,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-80,90},{-88,68},{-72,68},{-80,90}}, fillPattern=FillPattern.Solid, lineColor={160,160,160}, fillColor={192,192,192}),Text(lineColor={0,0,255}, extent={{-150,150},{150,110}}, textString="%name")}), Diagram(coordinateSystem(extent={{-100,-100},{100,100}}), graphics={Polygon(points={{-80,90},{-88,68},{-72,68},{-80,90}}, fillPattern=FillPattern.Solid, lineColor={192,192,192}, fillColor={192,192,192}),Line(points={{-80,68},{-80,-80}}, color={192,192,192}),Line(points={{-90,-70},{82,-70}}, color={192,192,192}),Polygon(points={{90,-70},{68,-62},{68,-78},{90,-70}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(lineColor={0,0,255}, extent={{-60,-72},{-14,-90}}, textString="startTime", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{-82,91},{-41,71}}, textString="y", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{70,-80},{94,-100}}, textString="temps", fillColor={160,160,160}),Line(points={{-78,-70},{-40,-70},{-40,20},{20,20},{20,-70},{50,-70},{50,20},{100,20}}, color={0,0,0}, thickness=0.5),Line(points={{-40,61},{-40,21}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{20,44},{20,20}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{50,58},{50,20}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-40,53},{50,53}}, color={192,192,192}),Line(points={{-40,35},{20,35}}, color={192,192,192}),Text(lineColor={0,0,255}, extent={{-30,67},{16,55}}, textString="period", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{-35,49},{14,37}}, textString="width", fillColor={160,160,160}),Line(points={{-80,20},{-41,20}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{-40,35},{-31,37},{-31,33},{-40,35}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20,35},{12,37},{12,33},{20,35}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-40,53},{-31,55},{-31,51},{-40,53}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50,53},{42,55},{42,51},{50,53}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(lineColor={0,0,255}, extent={{-109,28},{-77,14}}, textString="true", fillColor={160,160,160}),Text(lineColor={0,0,255}, extent={{-101,-56},{-80,-71}}, textString="false", fillColor={160,160,160})}), Documentation(info="<html>
<p><b>Adapted from the Modelica.Blocks.Sources library</b></p>
</HTML>
<html>
<p><b>Version 1.0</b></p>
</HTML>
"));
algorithm
  when sample(startTime, period) then
      T0:=time;
  end when;
  yL.signal:=if time < startTime or time >= T0 + width then false else true;
end Pulse;
