within ThermoSysPro.Examples.CombinedCyclePowerPlant.Control;
model Condenser_LevelControl "Condenser level control"
  annotation(Diagram(coordinateSystem(scale=0.1, extent={{-100,-100},{100,100}}), graphics={Text(lineColor={0,0,255}, extent={{-97,99},{-59,91}}, fillColor={191,0,0}, textString="Niveau ballon"),Text(lineColor={0,0,255}, extent={{-99,58},{-53,26}}, fillColor={191,0,0}, textString="Consigne Niveau"),Text(lineColor={0,0,255}, extent={{-103,-21},{-65,-29}}, fillColor={191,0,0}, textString="Dbit Eau"),Text(lineColor={0,0,255}, extent={{-99,-92},{-61,-100}}, fillColor={191,0,0}, textString="Dbit Vapeur"),Text(lineColor={0,0,255}, extent={{64,-92},{102,-100}}, fillColor={191,0,0}, textString="Ouv Vanne")}), Icon(coordinateSystem(scale=0.1, extent={{-100,-100},{100,100}}), graphics={Rectangle(lineColor={0,0,255}, extent={{-100,100},{100,-100}}),Rectangle(extent={{-80,81},{80,-80}}, lineColor={0,0,255}, fillColor={255,255,127}, fillPattern=FillPattern.Solid),Text(lineColor={0,0,255}, extent={{-88,65},{74,-26}}, fillColor={0,0,255}, textString="Rgulation Niveau "),Text(lineColor={0,0,255}, extent={{-41,-9},{38,-58}}, fillColor={0,0,255}, textString="Ballon"),Text(lineColor={0,0,255}, extent={{-98,93},{-60,85}}, fillColor={191,0,0}, textString="Niveau ballon"),Text(lineColor={0,0,255}, extent={{-99,46},{-50,13}}, fillColor={191,0,0}, textString="Consigne Niveau"),Text(lineColor={0,0,255}, extent={{-103,-27},{-65,-35}}, fillColor={191,0,0}, textString="Dbit Eau"),Text(lineColor={0,0,255}, extent={{-97,-86},{-59,-94}}, fillColor={191,0,0}, textString="Dbit Vapeur"),Text(lineColor={0,0,255}, extent={{64,-86},{102,-94}}, fillColor={191,0,0}, textString="Ouv Vanne")}));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal MesureDebitVapeur annotation(Placement(transformation(x=-104.0, y=-89.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=-104.0, y=-89.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal MesureDebitEau annotation(Placement(transformation(x=-105.5, y=-29.5, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=-105.5, y=-29.5, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal MesureNiveauEau annotation(Placement(transformation(x=-105.0, y=90.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=-105.0, y=90.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal ConsigneNiveauEau annotation(Placement(transformation(x=-105.0, y=30.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=-105.0, y=30.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal SortieReelle1 annotation(Placement(transformation(x=105.0, y=-90.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false), iconTransformation(x=105.0, y=-90.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Add add(k1=+1, k2=-1) annotation(Placement(transformation(x=75.5, y=78.0, scale=0.125, aspectRatio=1.04, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Continu.PIsat pIsat(permanent=true, ureset0=0, Ti=10, k=10) annotation(Placement(transformation(x=76.0, y=-78.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-180.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Add add1(k1=+1, k2=+1) annotation(Placement(transformation(x=-29.0, y=-65.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-180.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Continu.PIsat pIsat1(permanent=false, k=1, Ti=10, ureset0(fixed=true)=0.8) annotation(Placement(transformation(x=-63.0, y=-65.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-180.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Continu.PT1 pT1_1(permanent=true, U0=1.05) annotation(Placement(transformation(x=41.0, y=81.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Continu.PT1 pT1_2(permanent=true, U0=1.05) annotation(Placement(transformation(x=-17.0, y=13.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-270.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Continu.PT1 pT1_3(permanent=true, U0=1.05) annotation(Placement(transformation(x=15.0, y=13.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-270.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Add add2(k1=+1, k2=-1) annotation(Placement(transformation(x=-11.0, y=-29.0, scale=0.1, aspectRatio=1.0, flipHorizontal=false, flipVertical=false, rotation=-270.0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Logique.Edge edge annotation(Placement(transformation(x=-45.0, y=-35.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Logique.Echelon echelon annotation(Placement(transformation(x=-71.0, y=-6.0, scale=0.05, aspectRatio=1.0, flipHorizontal=false, flipVertical=false)));
equation
  connect(pIsat.u,add.y) annotation(Line(points={{87,-78},{89,-78},{89,78},{89.25,78}}));
  connect(pIsat1.u,add1.y) annotation(Line(points={{-52,-65},{-40,-65}}));
  connect(pT1_1.y,add.u1) annotation(Line(points={{52,81},{57,81},{57,85.8},{61.75,85.8}}));
  connect(pT1_2.y,add2.u2) annotation(Line(points={{-17,2},{-17,-8},{-17,-8},{-17,-18}}));
  connect(pT1_3.y,add2.u1) annotation(Line(points={{15,2},{15,-7},{-5,-7},{-5,-18}}));
  connect(pIsat.y,add1.u1) annotation(Line(points={{65,-78},{19,-78},{19,-71},{-18,-71}}));
  connect(pIsat1.y,SortieReelle1) annotation(Line(points={{-74,-65},{-79,-65},{-79,-90},{105,-90}}, color={255,0,0}));
  connect(MesureDebitVapeur,pT1_3.u) annotation(Line(points={{-104,-89},{-91,-89},{-91,-40},{-64,-40},{-64,29},{15,29},{15,24}}, color={255,0,0}));
  connect(MesureDebitEau,pT1_2.u) annotation(Line(points={{-105.5,-29.5},{-79,-29.5},{-79,37},{-17,37},{-17,24}}));
  connect(MesureNiveauEau,pT1_1.u) annotation(Line(points={{-105,90},{-38,90},{-38,81},{30,81}}, color={191,0,0}));
  connect(ConsigneNiveauEau,add.u2) annotation(Line(points={{-105,30},{-93,30},{-93,50},{55,50},{55,70.2},{61.75,70.2}}, color={191,0,0}));
  connect(add2.y,add1.u2) annotation(Line(points={{-11,-40},{-11,-59},{-18,-59}}));
  connect(echelon.yL,edge.uL) annotation(Line(points={{-65.5,-6},{-60,-6},{-60,-35},{-50.5,-35}}));
  connect(edge.yL,pIsat1.reset) annotation(Line(points={{-39.5,-35},{-31,-35},{-31,-46},{-62,-46},{-62,-54}}));
end Condenser_LevelControl;
