// name: ScalarizedWithRecords1
// status: correct
// cflags: -d=newInst -f --baseModelicaFormat=scalarized,withRecords

model M
  record R1
    Real x;
    Real y;
    Real z[3];
  end R1;

  record R2
    R1 r;
    R1 ra[3];
    Real w;
  end R2;

  constant R1 cr1 = R1(0, 0, zeros(3));
  constant R2 cr2 = R2(cr1, fill(cr1, 3), 0);
  R1 r1;
  R1 ra1[3];
  R2 r2;
  R2 ra2[3];
equation
  r1 = cr1;
  r1.x = 0;
  r1.z[1] = 0;

  ra1.x = zeros(3);
  ra1.z = zeros(3, 3);
  ra1.z[1] = zeros(3);
  ra1[2] = cr1;
  ra1[1].y = 0;
  ra1[1].z = zeros(3);
  ra1[1].z[2] = 0;

  ra2.r = fill(cr1, 3);
  ra2.r.x = zeros(3);
  ra2.ra.y = zeros(3, 3);

  ra2[2].ra = fill(cr1, 3);
  ra2[2].ra.y = zeros(3);
  ra2[1].ra[2].y = 0;
end M;

model ScalarizedWithRecords1
  extends M;
  M m;
  M ma[3];
equation
  m.r1.x = 0;
  m.ra1[1].x = 0;
  ma[1].r1.x = 0;
  ma[1].r1.z[2] = 0;
  ma[1].r1 = cr1;
end ScalarizedWithRecords1;

// Result:
// //! base 0.1.0
// package 'ScalarizedWithRecords1'
//   record 'R1'
//     Real 'x';
//     Real 'y';
//     Real[3] 'z';
//   end 'R1';
//
//   record 'R2'
//     'R1' 'r';
//     'R1'[3] 'ra';
//     Real 'w';
//   end 'R2';
//
//   record 'm.R1'
//     Real 'x';
//     Real 'y';
//     Real[3] 'z';
//   end 'm.R1';
//
//   record 'm.R2'
//     'm.R1' 'r';
//     'm.R1'[3] 'ra';
//     Real 'w';
//   end 'm.R2';
//
//   record 'ma.R1'
//     Real 'x';
//     Real 'y';
//     Real[3] 'z';
//   end 'ma.R1';
//
//   record 'ma.R2'
//     'ma.R1' 'r';
//     'ma.R1'[3] 'ra';
//     Real 'w';
//   end 'ma.R2';
//
//   model 'ScalarizedWithRecords1'
//     constant 'R1' 'cr1' = 'R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant 'R1' 'cr2'.'r' = 'R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant Real 'cr2'.'ra[1]'.'x' = 0.0;
//     constant Real 'cr2'.'ra[1]'.'y' = 0.0;
//     constant Real[3] 'cr2'.'ra[1]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'cr2'.'ra[2]'.'x' = 0.0;
//     constant Real 'cr2'.'ra[2]'.'y' = 0.0;
//     constant Real[3] 'cr2'.'ra[2]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'cr2'.'ra[3]'.'x' = 0.0;
//     constant Real 'cr2'.'ra[3]'.'y' = 0.0;
//     constant Real[3] 'cr2'.'ra[3]'.'z' = {0.0, 0.0, 0.0};
//     constant 'R2' 'cr2';
//     'R1' 'r1';
//     Real[3] 'ra1[1]'.'z';
//     Real 'ra1[2]'.'x';
//     Real 'ra1[2]'.'y';
//     Real[3] 'ra1[2]'.'z';
//     Real 'ra1[3]'.'x';
//     Real 'ra1[3]'.'y';
//     Real[3] 'ra1[3]'.'z';
//     'R1' 'r2'.'r';
//     Real 'r2'.'ra[1]'.'x';
//     Real 'r2'.'ra[1]'.'y';
//     Real[3] 'r2'.'ra[1]'.'z';
//     Real 'r2'.'ra[2]'.'x';
//     Real 'r2'.'ra[2]'.'y';
//     Real[3] 'r2'.'ra[2]'.'z';
//     Real 'r2'.'ra[3]'.'x';
//     Real 'r2'.'ra[3]'.'y';
//     Real[3] 'r2'.'ra[3]'.'z';
//     'R2' 'r2';
//     'R1' 'ra2[1]'.'r';
//     Real[3] 'ra2[1]'.'ra[1]'.'z';
//     Real 'ra2[1]'.'ra[2]'.'x';
//     Real 'ra2[1]'.'ra[2]'.'y';
//     Real[3] 'ra2[1]'.'ra[2]'.'z';
//     Real 'ra2[1]'.'ra[3]'.'x';
//     Real 'ra2[1]'.'ra[3]'.'y';
//     Real[3] 'ra2[1]'.'ra[3]'.'z';
//     Real 'ra2[1]'.'w';
//     'R1' 'ra2[2]'.'r';
//     Real 'ra2[2]'.'ra[1]'.'x';
//     Real 'ra2[2]'.'ra[1]'.'y';
//     Real[3] 'ra2[2]'.'ra[1]'.'z';
//     Real 'ra2[2]'.'ra[2]'.'x';
//     Real 'ra2[2]'.'ra[2]'.'y';
//     Real[3] 'ra2[2]'.'ra[2]'.'z';
//     Real 'ra2[2]'.'ra[3]'.'x';
//     Real 'ra2[2]'.'ra[3]'.'y';
//     Real[3] 'ra2[2]'.'ra[3]'.'z';
//     Real 'ra2[2]'.'w';
//     'R1' 'ra2[3]'.'r';
//     Real 'ra2[3]'.'ra[1]'.'x';
//     Real 'ra2[3]'.'ra[1]'.'y';
//     Real[3] 'ra2[3]'.'ra[1]'.'z';
//     Real 'ra2[3]'.'ra[2]'.'x';
//     Real 'ra2[3]'.'ra[2]'.'y';
//     Real[3] 'ra2[3]'.'ra[2]'.'z';
//     Real 'ra2[3]'.'ra[3]'.'x';
//     Real 'ra2[3]'.'ra[3]'.'y';
//     Real[3] 'ra2[3]'.'ra[3]'.'z';
//     Real 'ra2[3]'.'w';
//     constant 'm.R1' 'm.cr1' = 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant 'm.R1' 'm.cr2'.'r' = 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant Real 'm.cr2'.'ra[1]'.'x' = 0.0;
//     constant Real 'm.cr2'.'ra[1]'.'y' = 0.0;
//     constant Real[3] 'm.cr2'.'ra[1]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'm.cr2'.'ra[2]'.'x' = 0.0;
//     constant Real 'm.cr2'.'ra[2]'.'y' = 0.0;
//     constant Real[3] 'm.cr2'.'ra[2]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'm.cr2'.'ra[3]'.'x' = 0.0;
//     constant Real 'm.cr2'.'ra[3]'.'y' = 0.0;
//     constant Real[3] 'm.cr2'.'ra[3]'.'z' = {0.0, 0.0, 0.0};
//     constant 'm.R2' 'm.cr2';
//     'm.R1' 'm.r1';
//     Real[3] 'm.ra1[1]'.'z';
//     Real 'm.ra1[2]'.'x';
//     Real 'm.ra1[2]'.'y';
//     Real[3] 'm.ra1[2]'.'z';
//     Real 'm.ra1[3]'.'x';
//     Real 'm.ra1[3]'.'y';
//     Real[3] 'm.ra1[3]'.'z';
//     'm.R1' 'm.r2'.'r';
//     Real 'm.r2'.'ra[1]'.'x';
//     Real 'm.r2'.'ra[1]'.'y';
//     Real[3] 'm.r2'.'ra[1]'.'z';
//     Real 'm.r2'.'ra[2]'.'x';
//     Real 'm.r2'.'ra[2]'.'y';
//     Real[3] 'm.r2'.'ra[2]'.'z';
//     Real 'm.r2'.'ra[3]'.'x';
//     Real 'm.r2'.'ra[3]'.'y';
//     Real[3] 'm.r2'.'ra[3]'.'z';
//     'm.R2' 'm.r2';
//     'm.R1' 'm.ra2[1]'.'r';
//     Real[3] 'm.ra2[1]'.'ra[1]'.'z';
//     Real 'm.ra2[1]'.'ra[2]'.'x';
//     Real 'm.ra2[1]'.'ra[2]'.'y';
//     Real[3] 'm.ra2[1]'.'ra[2]'.'z';
//     Real 'm.ra2[1]'.'ra[3]'.'x';
//     Real 'm.ra2[1]'.'ra[3]'.'y';
//     Real[3] 'm.ra2[1]'.'ra[3]'.'z';
//     Real 'm.ra2[1]'.'w';
//     'm.R1' 'm.ra2[2]'.'r';
//     Real 'm.ra2[2]'.'ra[1]'.'x';
//     Real 'm.ra2[2]'.'ra[1]'.'y';
//     Real[3] 'm.ra2[2]'.'ra[1]'.'z';
//     Real 'm.ra2[2]'.'ra[2]'.'x';
//     Real 'm.ra2[2]'.'ra[2]'.'y';
//     Real[3] 'm.ra2[2]'.'ra[2]'.'z';
//     Real 'm.ra2[2]'.'ra[3]'.'x';
//     Real 'm.ra2[2]'.'ra[3]'.'y';
//     Real[3] 'm.ra2[2]'.'ra[3]'.'z';
//     Real 'm.ra2[2]'.'w';
//     'm.R1' 'm.ra2[3]'.'r';
//     Real 'm.ra2[3]'.'ra[1]'.'x';
//     Real 'm.ra2[3]'.'ra[1]'.'y';
//     Real[3] 'm.ra2[3]'.'ra[1]'.'z';
//     Real 'm.ra2[3]'.'ra[2]'.'x';
//     Real 'm.ra2[3]'.'ra[2]'.'y';
//     Real[3] 'm.ra2[3]'.'ra[2]'.'z';
//     Real 'm.ra2[3]'.'ra[3]'.'x';
//     Real 'm.ra2[3]'.'ra[3]'.'y';
//     Real[3] 'm.ra2[3]'.'ra[3]'.'z';
//     Real 'm.ra2[3]'.'w';
//     constant 'ma.R1' 'ma[1].cr1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant 'ma.R1' 'ma[1].cr2'.'r' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant Real 'ma[1].cr2'.'ra[1]'.'x' = 0.0;
//     constant Real 'ma[1].cr2'.'ra[1]'.'y' = 0.0;
//     constant Real[3] 'ma[1].cr2'.'ra[1]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[1].cr2'.'ra[2]'.'x' = 0.0;
//     constant Real 'ma[1].cr2'.'ra[2]'.'y' = 0.0;
//     constant Real[3] 'ma[1].cr2'.'ra[2]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[1].cr2'.'ra[3]'.'x' = 0.0;
//     constant Real 'ma[1].cr2'.'ra[3]'.'y' = 0.0;
//     constant Real[3] 'ma[1].cr2'.'ra[3]'.'z' = {0.0, 0.0, 0.0};
//     constant 'ma.R2' 'ma[1].cr2';
//     'ma.R1' 'ma[1].r1';
//     Real[3] 'ma[1].ra1[1]'.'z';
//     Real 'ma[1].ra1[2]'.'x';
//     Real 'ma[1].ra1[2]'.'y';
//     Real[3] 'ma[1].ra1[2]'.'z';
//     Real 'ma[1].ra1[3]'.'x';
//     Real 'ma[1].ra1[3]'.'y';
//     Real[3] 'ma[1].ra1[3]'.'z';
//     'ma.R1' 'ma[1].r2'.'r';
//     Real 'ma[1].r2'.'ra[1]'.'x';
//     Real 'ma[1].r2'.'ra[1]'.'y';
//     Real[3] 'ma[1].r2'.'ra[1]'.'z';
//     Real 'ma[1].r2'.'ra[2]'.'x';
//     Real 'ma[1].r2'.'ra[2]'.'y';
//     Real[3] 'ma[1].r2'.'ra[2]'.'z';
//     Real 'ma[1].r2'.'ra[3]'.'x';
//     Real 'ma[1].r2'.'ra[3]'.'y';
//     Real[3] 'ma[1].r2'.'ra[3]'.'z';
//     'ma.R2' 'ma[1].r2';
//     'ma.R1' 'ma[1].ra2[1]'.'r';
//     Real[3] 'ma[1].ra2[1]'.'ra[1]'.'z';
//     Real 'ma[1].ra2[1]'.'ra[2]'.'x';
//     Real 'ma[1].ra2[1]'.'ra[2]'.'y';
//     Real[3] 'ma[1].ra2[1]'.'ra[2]'.'z';
//     Real 'ma[1].ra2[1]'.'ra[3]'.'x';
//     Real 'ma[1].ra2[1]'.'ra[3]'.'y';
//     Real[3] 'ma[1].ra2[1]'.'ra[3]'.'z';
//     Real 'ma[1].ra2[1]'.'w';
//     'ma.R1' 'ma[1].ra2[2]'.'r';
//     Real 'ma[1].ra2[2]'.'ra[1]'.'x';
//     Real 'ma[1].ra2[2]'.'ra[1]'.'y';
//     Real[3] 'ma[1].ra2[2]'.'ra[1]'.'z';
//     Real 'ma[1].ra2[2]'.'ra[2]'.'x';
//     Real 'ma[1].ra2[2]'.'ra[2]'.'y';
//     Real[3] 'ma[1].ra2[2]'.'ra[2]'.'z';
//     Real 'ma[1].ra2[2]'.'ra[3]'.'x';
//     Real 'ma[1].ra2[2]'.'ra[3]'.'y';
//     Real[3] 'ma[1].ra2[2]'.'ra[3]'.'z';
//     Real 'ma[1].ra2[2]'.'w';
//     'ma.R1' 'ma[1].ra2[3]'.'r';
//     Real 'ma[1].ra2[3]'.'ra[1]'.'x';
//     Real 'ma[1].ra2[3]'.'ra[1]'.'y';
//     Real[3] 'ma[1].ra2[3]'.'ra[1]'.'z';
//     Real 'ma[1].ra2[3]'.'ra[2]'.'x';
//     Real 'ma[1].ra2[3]'.'ra[2]'.'y';
//     Real[3] 'ma[1].ra2[3]'.'ra[2]'.'z';
//     Real 'ma[1].ra2[3]'.'ra[3]'.'x';
//     Real 'ma[1].ra2[3]'.'ra[3]'.'y';
//     Real[3] 'ma[1].ra2[3]'.'ra[3]'.'z';
//     Real 'ma[1].ra2[3]'.'w';
//     constant 'ma.R1' 'ma[2].cr1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant 'ma.R1' 'ma[2].cr2'.'r' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant Real 'ma[2].cr2'.'ra[1]'.'x' = 0.0;
//     constant Real 'ma[2].cr2'.'ra[1]'.'y' = 0.0;
//     constant Real[3] 'ma[2].cr2'.'ra[1]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[2].cr2'.'ra[2]'.'x' = 0.0;
//     constant Real 'ma[2].cr2'.'ra[2]'.'y' = 0.0;
//     constant Real[3] 'ma[2].cr2'.'ra[2]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[2].cr2'.'ra[3]'.'x' = 0.0;
//     constant Real 'ma[2].cr2'.'ra[3]'.'y' = 0.0;
//     constant Real[3] 'ma[2].cr2'.'ra[3]'.'z' = {0.0, 0.0, 0.0};
//     constant 'ma.R2' 'ma[2].cr2';
//     'ma.R1' 'ma[2].r1';
//     Real[3] 'ma[2].ra1[1]'.'z';
//     Real 'ma[2].ra1[2]'.'x';
//     Real 'ma[2].ra1[2]'.'y';
//     Real[3] 'ma[2].ra1[2]'.'z';
//     Real 'ma[2].ra1[3]'.'x';
//     Real 'ma[2].ra1[3]'.'y';
//     Real[3] 'ma[2].ra1[3]'.'z';
//     'ma.R1' 'ma[2].r2'.'r';
//     Real 'ma[2].r2'.'ra[1]'.'x';
//     Real 'ma[2].r2'.'ra[1]'.'y';
//     Real[3] 'ma[2].r2'.'ra[1]'.'z';
//     Real 'ma[2].r2'.'ra[2]'.'x';
//     Real 'ma[2].r2'.'ra[2]'.'y';
//     Real[3] 'ma[2].r2'.'ra[2]'.'z';
//     Real 'ma[2].r2'.'ra[3]'.'x';
//     Real 'ma[2].r2'.'ra[3]'.'y';
//     Real[3] 'ma[2].r2'.'ra[3]'.'z';
//     'ma.R2' 'ma[2].r2';
//     'ma.R1' 'ma[2].ra2[1]'.'r';
//     Real[3] 'ma[2].ra2[1]'.'ra[1]'.'z';
//     Real 'ma[2].ra2[1]'.'ra[2]'.'x';
//     Real 'ma[2].ra2[1]'.'ra[2]'.'y';
//     Real[3] 'ma[2].ra2[1]'.'ra[2]'.'z';
//     Real 'ma[2].ra2[1]'.'ra[3]'.'x';
//     Real 'ma[2].ra2[1]'.'ra[3]'.'y';
//     Real[3] 'ma[2].ra2[1]'.'ra[3]'.'z';
//     Real 'ma[2].ra2[1]'.'w';
//     'ma.R1' 'ma[2].ra2[2]'.'r';
//     Real 'ma[2].ra2[2]'.'ra[1]'.'x';
//     Real 'ma[2].ra2[2]'.'ra[1]'.'y';
//     Real[3] 'ma[2].ra2[2]'.'ra[1]'.'z';
//     Real 'ma[2].ra2[2]'.'ra[2]'.'x';
//     Real 'ma[2].ra2[2]'.'ra[2]'.'y';
//     Real[3] 'ma[2].ra2[2]'.'ra[2]'.'z';
//     Real 'ma[2].ra2[2]'.'ra[3]'.'x';
//     Real 'ma[2].ra2[2]'.'ra[3]'.'y';
//     Real[3] 'ma[2].ra2[2]'.'ra[3]'.'z';
//     Real 'ma[2].ra2[2]'.'w';
//     'ma.R1' 'ma[2].ra2[3]'.'r';
//     Real 'ma[2].ra2[3]'.'ra[1]'.'x';
//     Real 'ma[2].ra2[3]'.'ra[1]'.'y';
//     Real[3] 'ma[2].ra2[3]'.'ra[1]'.'z';
//     Real 'ma[2].ra2[3]'.'ra[2]'.'x';
//     Real 'ma[2].ra2[3]'.'ra[2]'.'y';
//     Real[3] 'ma[2].ra2[3]'.'ra[2]'.'z';
//     Real 'ma[2].ra2[3]'.'ra[3]'.'x';
//     Real 'ma[2].ra2[3]'.'ra[3]'.'y';
//     Real[3] 'ma[2].ra2[3]'.'ra[3]'.'z';
//     Real 'ma[2].ra2[3]'.'w';
//     constant 'ma.R1' 'ma[3].cr1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant 'ma.R1' 'ma[3].cr2'.'r' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     constant Real 'ma[3].cr2'.'ra[1]'.'x' = 0.0;
//     constant Real 'ma[3].cr2'.'ra[1]'.'y' = 0.0;
//     constant Real[3] 'ma[3].cr2'.'ra[1]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[3].cr2'.'ra[2]'.'x' = 0.0;
//     constant Real 'ma[3].cr2'.'ra[2]'.'y' = 0.0;
//     constant Real[3] 'ma[3].cr2'.'ra[2]'.'z' = {0.0, 0.0, 0.0};
//     constant Real 'ma[3].cr2'.'ra[3]'.'x' = 0.0;
//     constant Real 'ma[3].cr2'.'ra[3]'.'y' = 0.0;
//     constant Real[3] 'ma[3].cr2'.'ra[3]'.'z' = {0.0, 0.0, 0.0};
//     constant 'ma.R2' 'ma[3].cr2';
//     'ma.R1' 'ma[3].r1';
//     Real[3] 'ma[3].ra1[1]'.'z';
//     Real 'ma[3].ra1[2]'.'x';
//     Real 'ma[3].ra1[2]'.'y';
//     Real[3] 'ma[3].ra1[2]'.'z';
//     Real 'ma[3].ra1[3]'.'x';
//     Real 'ma[3].ra1[3]'.'y';
//     Real[3] 'ma[3].ra1[3]'.'z';
//     'ma.R1' 'ma[3].r2'.'r';
//     Real 'ma[3].r2'.'ra[1]'.'x';
//     Real 'ma[3].r2'.'ra[1]'.'y';
//     Real[3] 'ma[3].r2'.'ra[1]'.'z';
//     Real 'ma[3].r2'.'ra[2]'.'x';
//     Real 'ma[3].r2'.'ra[2]'.'y';
//     Real[3] 'ma[3].r2'.'ra[2]'.'z';
//     Real 'ma[3].r2'.'ra[3]'.'x';
//     Real 'ma[3].r2'.'ra[3]'.'y';
//     Real[3] 'ma[3].r2'.'ra[3]'.'z';
//     'ma.R2' 'ma[3].r2';
//     'ma.R1' 'ma[3].ra2[1]'.'r';
//     Real[3] 'ma[3].ra2[1]'.'ra[1]'.'z';
//     Real 'ma[3].ra2[1]'.'ra[2]'.'x';
//     Real 'ma[3].ra2[1]'.'ra[2]'.'y';
//     Real[3] 'ma[3].ra2[1]'.'ra[2]'.'z';
//     Real 'ma[3].ra2[1]'.'ra[3]'.'x';
//     Real 'ma[3].ra2[1]'.'ra[3]'.'y';
//     Real[3] 'ma[3].ra2[1]'.'ra[3]'.'z';
//     Real 'ma[3].ra2[1]'.'w';
//     'ma.R1' 'ma[3].ra2[2]'.'r';
//     Real 'ma[3].ra2[2]'.'ra[1]'.'x';
//     Real 'ma[3].ra2[2]'.'ra[1]'.'y';
//     Real[3] 'ma[3].ra2[2]'.'ra[1]'.'z';
//     Real 'ma[3].ra2[2]'.'ra[2]'.'x';
//     Real 'ma[3].ra2[2]'.'ra[2]'.'y';
//     Real[3] 'ma[3].ra2[2]'.'ra[2]'.'z';
//     Real 'ma[3].ra2[2]'.'ra[3]'.'x';
//     Real 'ma[3].ra2[2]'.'ra[3]'.'y';
//     Real[3] 'ma[3].ra2[2]'.'ra[3]'.'z';
//     Real 'ma[3].ra2[2]'.'w';
//     'ma.R1' 'ma[3].ra2[3]'.'r';
//     Real 'ma[3].ra2[3]'.'ra[1]'.'x';
//     Real 'ma[3].ra2[3]'.'ra[1]'.'y';
//     Real[3] 'ma[3].ra2[3]'.'ra[1]'.'z';
//     Real 'ma[3].ra2[3]'.'ra[2]'.'x';
//     Real 'ma[3].ra2[3]'.'ra[2]'.'y';
//     Real[3] 'ma[3].ra2[3]'.'ra[2]'.'z';
//     Real 'ma[3].ra2[3]'.'ra[3]'.'x';
//     Real 'ma[3].ra2[3]'.'ra[3]'.'y';
//     Real[3] 'ma[3].ra2[3]'.'ra[3]'.'z';
//     Real 'ma[3].ra2[3]'.'w';
//   equation
//     'm.r1' = 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'm.r1'.'x' = 0.0;
//     'm.r1'.'z[1]' = 0.0;
//     'm.ra1'.'x' = {0.0, 0.0, 0.0};
//     'm.ra1'.'z' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'm.ra1'.'z[1]' = {0.0, 0.0, 0.0};
//     'm.ra1[2]' = 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'm.ra1[1]'.'y' = 0.0;
//     'm.ra1[1]'.'z' = {0.0, 0.0, 0.0};
//     'm.ra1[1]'.'z[2]' = 0.0;
//     'm.ra2'.'r' = {'m.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'm.ra2'.'r'.'x' = {0.0, 0.0, 0.0};
//     'm.ra2'.'ra'.'y' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'm.ra2[2]'.'ra' = {'m.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'm.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'm.ra2[2]'.'ra'.'y' = {0.0, 0.0, 0.0};
//     'm.ra2[1]'.'ra[2]'.'y' = 0.0;
//     'ma[1].r1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[1].r1'.'x' = 0.0;
//     'ma[1].r1'.'z[1]' = 0.0;
//     'ma[1].ra1'.'x' = {0.0, 0.0, 0.0};
//     'ma[1].ra1'.'z' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[1].ra1'.'z[1]' = {0.0, 0.0, 0.0};
//     'ma[1].ra1[2]' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[1].ra1[1]'.'y' = 0.0;
//     'ma[1].ra1[1]'.'z' = {0.0, 0.0, 0.0};
//     'ma[1].ra1[1]'.'z[2]' = 0.0;
//     'ma[1].ra2'.'r' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[1].ra2'.'r'.'x' = {0.0, 0.0, 0.0};
//     'ma[1].ra2'.'ra'.'y' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[1].ra2[2]'.'ra' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[1].ra2[2]'.'ra'.'y' = {0.0, 0.0, 0.0};
//     'ma[1].ra2[1]'.'ra[2]'.'y' = 0.0;
//     'ma[2].r1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[2].r1'.'x' = 0.0;
//     'ma[2].r1'.'z[1]' = 0.0;
//     'ma[2].ra1'.'x' = {0.0, 0.0, 0.0};
//     'ma[2].ra1'.'z' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[2].ra1'.'z[1]' = {0.0, 0.0, 0.0};
//     'ma[2].ra1[2]' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[2].ra1[1]'.'y' = 0.0;
//     'ma[2].ra1[1]'.'z' = {0.0, 0.0, 0.0};
//     'ma[2].ra1[1]'.'z[2]' = 0.0;
//     'ma[2].ra2'.'r' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[2].ra2'.'r'.'x' = {0.0, 0.0, 0.0};
//     'ma[2].ra2'.'ra'.'y' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[2].ra2[2]'.'ra' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[2].ra2[2]'.'ra'.'y' = {0.0, 0.0, 0.0};
//     'ma[2].ra2[1]'.'ra[2]'.'y' = 0.0;
//     'ma[3].r1' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[3].r1'.'x' = 0.0;
//     'ma[3].r1'.'z[1]' = 0.0;
//     'ma[3].ra1'.'x' = {0.0, 0.0, 0.0};
//     'ma[3].ra1'.'z' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[3].ra1'.'z[1]' = {0.0, 0.0, 0.0};
//     'ma[3].ra1[2]' = 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ma[3].ra1[1]'.'y' = 0.0;
//     'ma[3].ra1[1]'.'z' = {0.0, 0.0, 0.0};
//     'ma[3].ra1[1]'.'z[2]' = 0.0;
//     'ma[3].ra2'.'r' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[3].ra2'.'r'.'x' = {0.0, 0.0, 0.0};
//     'ma[3].ra2'.'ra'.'y' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ma[3].ra2[2]'.'ra' = {'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'ma.R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ma[3].ra2[2]'.'ra'.'y' = {0.0, 0.0, 0.0};
//     'ma[3].ra2[1]'.'ra[2]'.'y' = 0.0;
//     'm.r1'.'x' = 0.0;
//     'm.ra1[1]'.'x' = 0.0;
//     'ma[1].r1'.'x' = 0.0;
//     'ma[1].r1'.'z[2]' = 0.0;
//     'ma[1].r1' = 'R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'r1' = 'R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'r1'.'x' = 0.0;
//     'r1'.'z[1]' = 0.0;
//     'ra1'.'x' = {0.0, 0.0, 0.0};
//     'ra1'.'z' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ra1'.'z[1]' = {0.0, 0.0, 0.0};
//     'ra1[2]' = 'R1'(0.0, 0.0, {0.0, 0.0, 0.0});
//     'ra1[1]'.'y' = 0.0;
//     'ra1[1]'.'z' = {0.0, 0.0, 0.0};
//     'ra1[1]'.'z[2]' = 0.0;
//     'ra2'.'r' = {'R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ra2'.'r'.'x' = {0.0, 0.0, 0.0};
//     'ra2'.'ra'.'y' = {{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
//     'ra2[2]'.'ra' = {'R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'R1'(0.0, 0.0, {0.0, 0.0, 0.0}), 'R1'(0.0, 0.0, {0.0, 0.0, 0.0})};
//     'ra2[2]'.'ra'.'y' = {0.0, 0.0, 0.0};
//     'ra2[1]'.'ra[2]'.'y' = 0.0;
//   end 'ScalarizedWithRecords1';
// end 'ScalarizedWithRecords1';
// endResult
