package ModelicaServices "ModelicaServices (OpenModelica implementation) - Models and functions used in the Modelica Standard Library requiring a tool specific implementation"
  extends Modelica.Icons.Package;
  constant String target = "OpenModelica" "Target of this ModelicaServices implementation";

  package UsersGuide "User's Guide"
    extends Modelica.Icons.Information;

    class ModelicaLicense2 "Modelica License 2"
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>
<head>
  <title>The Modelica License 2</title>
<style type=\"text/css\">
*       { font-size: 10pt; font-family: Arial,sans-serif; }
code    { font-size:  9pt; font-family: Courier,monospace;}
h6      { font-size: 10pt; font-weight: bold; color: green; }
h5      { font-size: 11pt; font-weight: bold; color: green; }
h4      { font-size: 13pt; font-weight: bold; color: green; }
address {                  font-weight: normal}
td      { solid #000; vertical-align:top; }
th      { solid #000; vertical-align:top; font-weight: bold; }
table   { solid #000; border-collapse: collapse;}
</style>
</head>

<p>All files in this directory (Modelica) and in all
subdirectories are licensed by the <b><u>Modelica Association</u></b> under the
<b><u>Modelica License 2</u></b>.</p>

<p style=\"margin-left: 40px;\"><b>Licensor:</b><br>
Modelica Association<br>
(Ideella F&ouml;reningar 822003-8858 in Link&ouml;ping) <br>
c/o PELAB, IDA, Link&ouml;pings Universitet <br>
S-58183 Link&ouml;ping <br>
Sweden<br>
email: Board@Modelica.org<br>
web: <a href=\"https://www.Modelica.org\">https://www.Modelica.org</a></p>

<p style=\"margin-left: 40px;\"><b>Copyright notices of the files:</b><br/>
Copyright &copy; 1998-2015, DLR, Dassault Syst&egrave;mes AB.
</p>

<p>
<a href=\"#The_Modelica_License_2-outline\">The Modelica License 2</a><br>
<a href=\"#Frequently_Asked_Questions-outline\">Frequently Asked Questions</a><br>
</p>

<hr>

<h4><a name=\"The_Modelica_License_2-outline\"></a>The Modelica License 2</h4>

<p>
<b>Preamble.</b> The goal of this license is that Modelica related
model libraries, software, images, documents, data files etc. can be
used freely in the original or a modified form, in open source and in
commercial environments (as long as the license conditions below are
fulfilled, in particular sections 2c) and 2d). The Original Work is
provided free of charge and the use is completely at your own risk.
Developers of free Modelica packages are encouraged to utilize this
license for their work.</p>

<p>
The Modelica License applies to any Original Work that contains the
following licensing notice adjacent to the copyright notice(s) for
this Original Work:</p>

<p><b>Licensed by the Modelica Association under the Modelica License 2</b></p>

<p><b>1. Definitions.</b></p>
<ol type=\"a\">
  <li>&ldquo;License&rdquo; is this Modelica License.</li>

  <li>&ldquo;Original Work&rdquo; is any work of authorship, including
  software, images, documents, data files, that contains the above
  licensing notice or that is packed together with a licensing notice
  referencing it.</li>

  <li>&ldquo;Licensor&rdquo; is the provider of the Original Work who has
  placed this licensing notice adjacent to the copyright notice(s) for
  the Original Work. The Original Work is either directly provided by
  the owner of the Original Work, or by a licensee of the owner.</li>

  <li>&ldquo;Derivative Work&rdquo; is any modification of the Original
  Work which represents, as a whole, an original work of authorship.
  For the matter of clarity and as examples:

  <ol  type=\"A\">
    <li>Derivative Work shall not include work that remains separable from
    the Original Work, as well as merely extracting a part of the
    Original Work without modifying it.</li>

    <li>Derivative Work shall not include (a) fixing of errors and/or (b)
    adding vendor specific Modelica annotations and/or (c) using a
    subset of the classes of a Modelica package, and/or (d) using a
    different representation, e.g., a binary representation.</li>

    <li>Derivative Work shall include classes that are copied from the
    Original Work where declarations, equations or the documentation
    are modified.</li>

    <li>Derivative Work shall include executables to simulate the models
    that are generated by a Modelica translator based on the Original
    Work (of a Modelica package).</li>
  </ol>

  <li>&ldquo;Modified Work&rdquo; is any modification of the Original Work
  with the following exceptions: (a) fixing of errors and/or (b)
  adding vendor specific Modelica annotations and/or (c) using a
  subset of the classes of a Modelica package, and/or (d) using a
  different representation, e.g., a binary representation.</li>

  <li>&quot;Source Code&quot; means the preferred form of the Original
  Work for making modifications to it and all available documentation
  describing how to modify the Original Work.</li>

  <li>&ldquo;You&rdquo; means an individual or a legal entity exercising
  rights under, and complying with all of the terms of, this License.</li>

  <li>&ldquo;Modelica package&rdquo; means any Modelica library that is
  defined with the &ldquo;<code><b>package</b>&nbsp;&lt;Name&gt;&nbsp;...&nbsp;<b>end</b>&nbsp;&lt;Name&gt;;</code>&rdquo; Modelica language element.</li>

</ol>

<p>
<b>2. Grant of Copyright License.</b> Licensor grants You a
worldwide, royalty-free, non-exclusive, sublicensable license, for
the duration of the copyright, to do the following:</p>

<ol type=\"a\">
  <li><p>
  To reproduce the Original Work in copies, either alone or as part of
  a collection.</p></li>
  <li><p>
  To create Derivative Works according to Section 1d) of this License.</p></li>
  <li><p>
  To distribute or communicate to the public copies of the <u>Original
  Work</u> or a <u>Derivative Work</u> under <u>this License</u>. No
  fee, neither as a copyright-license fee, nor as a selling fee for
  the copy as such may be charged under this License. Furthermore, a
  verbatim copy of this License must be included in any copy of the
  Original Work or a Derivative Work under this License.<br>
  For the matter of clarity, it is permitted A) to distribute or
  communicate such copies as part of a (possible commercial)
  collection where other parts are provided under different licenses
  and a license fee is charged for the other parts only and B) to
  charge for mere printing and shipping costs.</p></li>
  <li><p>
  To distribute or communicate to the public copies of a <u>Derivative
  Work</u>, alternatively to Section 2c), under <u>any other license</u>
  of your choice, especially also under a license for
  commercial/proprietary software, as long as You comply with Sections
  3, 4 and 8 below. <br>      For the matter of clarity, no
  restrictions regarding fees, either as to a copyright-license fee or
  as to a selling fee for the copy as such apply.</p></li>
  <li><p>
  To perform the Original Work publicly.</p></li>
  <li><p>
  To display the Original Work publicly.</p></li>
</ol>

<p>
<b>3. Acceptance.</b> Any use of the Original Work or a
Derivative Work, or any action according to either Section 2a) to 2f)
above constitutes Your acceptance of this License.</p>

<p>
<b>4. Designation of Derivative Works and of Modified Works.
</b>The identifying designation of Derivative Work and of Modified
Work must be different to the corresponding identifying designation
of the Original Work. This means especially that the (root-level)
name of a Modelica package under this license must be changed if the
package is modified (besides fixing of errors, adding vendor specific
Modelica annotations, using a subset of the classes of a Modelica
package, or using another representation, e.g. a binary
representation).</p>

<p>
<b>5. Grant of Patent License.</b>
Licensor grants You a worldwide, royalty-free, non-exclusive, sublicensable license,
under patent claims owned by the Licensor or licensed to the Licensor by
the owners of the Original Work that are embodied in the Original Work
as furnished by the Licensor, for the duration of the patents,
to make, use, sell, offer for sale, have made, and import the Original Work
and Derivative Works under the conditions as given in Section 2.
For the matter of clarity, the license regarding Derivative Works covers
patent claims to the extent as they are embodied in the Original Work only.</p>

<p>
<b>6. Provision of Source Code.</b> Licensor agrees to provide
You with a copy of the Source Code of the Original Work but reserves
the right to decide freely on the manner of how the Original Work is
provided.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For the matter of clarity, Licensor might provide only a binary
representation of the Original Work. In that case, You may (a) either
reproduce the Source Code from the binary representation if this is
possible (e.g., by performing a copy of an encrypted Modelica
package, if encryption allows the copy operation) or (b) request the
Source Code from the Licensor who will provide it to You.</p>

<p>
<b>7. Exclusions from License Grant.</b> Neither the names of
Licensor, nor the names of any contributors to the Original Work, nor
any of their trademarks or service marks, may be used to endorse or
promote products derived from this Original Work without express
prior permission of the Licensor. Except as otherwise expressly
stated in this License and in particular in Sections 2 and 5, nothing
in this License grants any license to Licensor&rsquo;s trademarks,
copyrights, patents, trade secrets or any other intellectual
property, and no patent license is granted to make, use, sell, offer
for sale, have made, or import embodiments of any patent claims.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No license is granted to the trademarks of
Licensor even if such trademarks are included in the Original Work,
except as expressly stated in this License. Nothing in this License
shall be interpreted to prohibit Licensor from licensing under terms
different from this License any Original Work that Licensor otherwise
would have a right to license.</p>

<p>
<b>8. Attribution Rights.</b> You must retain in the Source
Code of the Original Work and of any Derivative Works that You
create, all author, copyright, patent, or trademark notices, as well
as any descriptive text identified therein as an &quot;Attribution
Notice&quot;. The same applies to the licensing notice of this
License in the Original Work. For the matter of clarity, &ldquo;author
notice&rdquo; means the notice that identifies the original
author(s). <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;You must cause the Source Code for any Derivative
Works that You create to carry a prominent Attribution Notice
reasonably calculated to inform recipients that You have modified the
Original Work. <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In case the Original Work or Derivative Work is not provided in
Source Code, the Attribution Notices shall be appropriately
displayed, e.g., in the documentation of the Derivative Work.</p>

<p><b>9. Disclaimer
of Warranty. <br></b><u><b>The Original Work is provided under this
License on an &quot;as is&quot; basis and without warranty, either
express or implied, including, without limitation, the warranties of
non-infringement, merchantability or fitness for a particular
purpose. The entire risk as to the quality of the Original Work is
with You.</b></u> This disclaimer of warranty constitutes an
essential part of this License. No license to the Original Work is
granted by this License except under this disclaimer.</p>

<p>
<b>10. Limitation of Liability.</b> Under no circumstances and
under no legal theory, whether in tort (including negligence),
contract, or otherwise, shall the Licensor, the owner or a licensee
of the Original Work be liable to anyone for any direct, indirect,
general, special, incidental, or consequential damages of any
character arising as a result of this License or the use of the
Original Work including, without limitation, damages for loss of
goodwill, work stoppage, computer failure or malfunction, or any and
all other commercial damages or losses. This limitation of liability
shall not apply to the extent applicable law prohibits such
limitation.</p>

<p>
<b>11. Termination.</b> This License conditions your rights to
undertake the activities listed in Section 2 and 5, including your
right to create Derivative Works based upon the Original Work, and
doing so without observing these terms and conditions is prohibited
by copyright law and international treaty. Nothing in this License is
intended to affect copyright exceptions and limitations. This License
shall terminate immediately and You may no longer exercise any of the
rights granted to You by this License upon your failure to observe
the conditions of this license.</p>

<p>
<b>12. Termination for Patent Action.</b> This License shall
terminate automatically and You may no longer exercise any of the
rights granted to You by this License as of the date You commence an
action, including a cross-claim or counterclaim, against Licensor,
any owners of the Original Work or any licensee alleging that the
Original Work infringes a patent. This termination provision shall
not apply for an action alleging patent infringement through
combinations of the Original Work under combination with other
software or hardware.</p>

<p>
<b>13. Jurisdiction.</b> Any action or suit relating to this
License may be brought only in the courts of a jurisdiction wherein
the Licensor resides and under the laws of that jurisdiction
excluding its conflict-of-law provisions. The application of the
United Nations Convention on Contracts for the International Sale of
Goods is expressly excluded. Any use of the Original Work outside the
scope of this License or after its termination shall be subject to
the requirements and penalties of copyright or patent law in the
appropriate jurisdiction. This section shall survive the termination
of this License.</p>

<p>
<b>14. Attorneys&rsquo; Fees.</b> In any action to enforce the
terms of this License or seeking damages relating thereto, the
prevailing party shall be entitled to recover its costs and expenses,
including, without limitation, reasonable attorneys' fees and costs
incurred in connection with such action, including any appeal of such
action. This section shall survive the termination of this License.</p>

<p>
<b>15. Miscellaneous.</b>
</p>
<ol type=\"a\">
  <li>If any
  provision of this License is held to be unenforceable, such
  provision shall be reformed only to the extent necessary to make it
  enforceable.</li>

  <li>No verbal
  ancillary agreements have been made. Changes and additions to this
  License must appear in writing to be valid. This also applies to
  changing the clause pertaining to written form.</li>

  <li>You may use the
  Original Work in all ways not otherwise restricted or conditioned by
  this License or by law, and Licensor promises not to interfere with
  or be responsible for such uses by You.</li>
</ol>

<hr>

<h5><a name=\"Frequently_Asked_Questions-outline\"></a>
Frequently Asked Questions</h5>
<p>This
section contains questions/answer to users and/or distributors of
Modelica packages and/or documents under Modelica License 2. Note,
the answers to the questions below are not a legal interpretation of
the Modelica License 2. In case of a conflict, the language of the
license shall prevail.</p>

<h6>Using or Distributing a Modelica <u>Package</u> under the Modelica License 2</h6>

<p><b>What are the main
differences to the previous version of the Modelica License?</b></p>
<ol>
  <li><p>
  Modelica License 1 is unclear whether the licensed Modelica package
  can be distributed under a different license. Version 2 explicitly
  allows that &ldquo;Derivative Work&rdquo; can be distributed under
  any license of Your choice, see examples in Section 1d) as to what
  qualifies as Derivative Work (so, version 2 is clearer).</p>
  <li><p>
  If You modify a Modelica package under Modelica License 2 (besides
  fixing of errors, adding vendor specific Modelica annotations, using
  a subset of the classes of a Modelica package, or using another
  representation, e.g., a binary representation), you must rename the
  root-level name of the package for your distribution. In version 1
  you could keep the name (so, version 2 is more restrictive). The
  reason of this restriction is to reduce the risk that Modelica
  packages are available that have identical names, but different
  functionality.</p>
  <li><p>
  Modelica License 1 states that &ldquo;It is not allowed to charge a
  fee for the original version or a modified version of the software,
  besides a reasonable fee for distribution and support&rdquo;.
  Version 2 has a similar intention for all Original Work under
  <u>Modelica License 2</u> (to remain free of charge and open source)
  but states this more clearly as &ldquo;No fee, neither as a
  copyright-license fee, nor as a selling fee for the copy as such may
  be charged&rdquo;. Contrary to version 1, Modelica License 2 has no
  restrictions on fees for Derivative Work that is provided under a
  different license (so, version 2 is clearer and has fewer
  restrictions).</p>
  <li><p>
  Modelica License 2 introduces several useful provisions for the
  licensee (articles 5, 6, 12), and for the licensor (articles 7, 12,
  13, 14) that have no counter part in version 1.</p>
  <li><p>
  Modelica License 2 can be applied to all type of work, including
  documents, images and data files, contrary to version 1 that was
  dedicated for software only (so, version 2 is more general).</p>
</ol>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) as part of my commercial
Modelica modeling and simulation environment?</b></p>
<p>Yes,
according to Section 2c). However, you are not allowed to charge a
fee for this part of your environment. Of course, you can charge for
your part of the environment.
</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different
license?</b></p>
<p>No.
The license of an unmodified Modelica package cannot be changed
according to Sections 2c) and 2d). This means that you cannot <u>sell</u>
copies of it, any distribution has to be free of charge.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first encrypt the package?</b></p>
<p>No.
Merely encrypting a package does not qualify for Derivative Work and
therefore the encrypted package has to stay under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first add classes to the package?</b></p>
<p>No.
The package itself remains unmodified, i.e., it is Original Work, and
therefore the license for this part must remain under Modelica
License 2. The newly added classes can be, however, under a different
license.
</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it </b><u><b>unmodified</b></u><b> in a Modelica package
under a </b><u><b>commercial/proprietary license</b></u><b>?</b></p>
<p>No,
according to article 2c). However, you can include model, block,
function, package, record and connector classes in your Modelica
package under <u>Modelica License 2</u>. This means that your
Modelica package could be under a commercial/proprietary license, but
one or more classes of it are under Modelica License 2.<br>Note, a
&ldquo;type&rdquo; class (e.g., type Angle = Real(unit=&rdquo;rad&rdquo;))
can be copied and included unmodified under a commercial/proprietary
license (for details, see the next question).</p>

<p><b>Can
I copy a type class or </b><u><b>part</b></u><b> of a model, block,
function, record, connector class, out of a Modelica package (under
Modelica License 2) and include it modified or unmodified in a
Modelica package under a </b><u><b>commercial/proprietary</b></u><b>
license</b></p>
<p>Yes,
according to article 2d), since this will in the end usually qualify
as Derivative Work. The reasoning is the following: A type class or
part of another class (e.g., an equation, a declaration, part of a
class description) cannot be utilized &ldquo;by its own&rdquo;. In
order to make this &ldquo;usable&rdquo;, you have to add additional
code in order that the class can be utilized. This is therefore
usually Derivative Work and Derivative Work can be provided under a
different license. Note, this only holds, if the additional code
introduced is sufficient to qualify for Derivative Work. Merely, just
copying a class and changing, say, one character in the documentation
of this class would be no Derivative Work and therefore the copied
code would have to stay under Modelica License 2.</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it in </b><u><b>modified </b></u><b>form in a
</b><u><b>commercial/proprietary</b></u><b> Modelica package?</b></p>
<p>Yes.
If the modification can be seen as a &ldquo;Derivative Work&rdquo;,
you can place it under your commercial/proprietary license. If the
modification does not qualify as &ldquo;Derivative Work&rdquo; (e.g.,
bug fixes, vendor specific annotations), it must remain under
Modelica License 2. This means that your Modelica package could be
under a commercial/proprietary license, but one or more parts of it
are under Modelica License 2.</p>

<p><b>Can I distribute a
&ldquo;save total model&rdquo; under my commercial/proprietary
license, even if classes under Modelica License 2 are included?</b></p>
<p>Your
classes of the &ldquo;save total model&rdquo; can be distributed
under your commercial/proprietary license, but the classes under
Modelica License 2 must remain under Modelica License 2. This means
you can distribute a &ldquo;save total model&rdquo;, but some parts
might be under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) in encrypted form?</b></p>
<p>Yes.
Note, if the encryption does not allow &ldquo;copying&rdquo; of
classes (in to unencrypted Modelica source code), you have to send
the Modelica source code of this package to your customer, if he/she
wishes it, according to article&nbsp;6.</p>

<p><b>Can I distribute an
executable under my commercial/proprietary license, if the model from
which the executable is generated uses models from a Modelica package
under Modelica License 2?</b></p>
<p>Yes,
according to article 2d), since this is seen as Derivative Work. The
reasoning is the following: An executable allows the simulation of a
concrete model, whereas models from a Modelica package (without
pre-processing, translation, tool run-time library) are not able to
be simulated without tool support. By the processing of the tool and
by its run-time libraries, significant new functionality is added (a
model can be simulated whereas previously it could not be simulated)
and functionality available in the package is removed (e.g., to build
up a new model by dragging components of the package is no longer
possible with the executable).</p>

<p><b>Is my modification to
a Modelica package (under Modelica License 2) a Derivative Work?</b></p>
<p>It
is not possible to give a general answer to it. To be regarded as &quot;an
original work of authorship&quot;, a derivative work must be
different enough from the original or must contain a substantial
amount of new material. Making minor changes or additions of little
substance to a preexisting work will not qualify the work as a new
version for such purposes.
</p>

<h6>Using or Distributing a Modelica <u>Document</u> under the Modelica License 2</h6>

<p>This
section is devoted especially for the following applications:</p>
<ol type=\"a\">
  <li><p>
  A Modelica tool extracts information out of a Modelica package and
  presents the result in form of a &ldquo;manual&rdquo; for this
  package in, e.g., html, doc, or pdf format.</p>
  <li><p>
  The Modelica language specification is a document defining the
  Modelica language. It will be licensed under Modelica License 2.</p>
  <li><p>
  Someone writes a book about the Modelica language and/or Modelica
  packages and uses information which is available in the Modelica
  language specification and/or the corresponding Modelica package.</p>
</ol>

<p><b>Can I sell a manual
that was basically derived by extracting information automatically
from a Modelica package under Modelica License 2 (e.g., a &ldquo;reference
guide&rdquo; of the Modelica Standard Library):</b></p>
<p>Yes.
Extracting information from a Modelica package, and providing it in a
human readable, suitable format, like html, doc or pdf format, where
the content is significantly modified (e.g. tables with interface
information are constructed from the declarations of the public
variables) qualifies as Derivative Work and there are no restrictions
to charge a fee for Derivative Work under alternative 2d).</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it </b><u><b>unmodified</b></u><b> in my document
(e.g. the Modelica syntax description in the Modelica Specification)?</b></p>
<p>Yes.
In case you distribute your document, the copied parts are still
under Modelica License 2 and you are not allowed to charge a license
fee for this part. You can, of course, charge a fee for the rest of
your document.</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it in </b><u><b>modified</b></u><b> form in my
document?</b></p>
<p>Yes,
the creation of Derivative Works is allowed. In case the content is
significantly modified this qualifies as Derivative Work and there
are no restrictions to charge a fee for Derivative Work under
alternative 2d).</p>

<p><b>Can I sell a printed
version of a Modelica document (under Modelica License 2), e.g., the
Modelica Language Specification?</b></p>
<p>No,
if you are not the copyright-holder, since article 2c) does not allow
a selling fee for a (in this case physical) copy. However, mere
printing and shipping costs may be recovered.</p>
</html>"));
    end ModelicaLicense2;

    class ReleaseNotes "Release notes"
      extends Modelica.Icons.ReleaseNotes;
      annotation(
        Documentation(info = "<html>
<h4>Version 3.2.1, 2012-12-05</h4>

<ul>
<li> Version numbering adapted to the corresponding version number of
     package Modelica (= Modelica Standard Library).</li>
<li> New function
     <a href=\"modelica://ModelicaServices.ExternalReferences.loadResource\">loadResource</a>
     to determine the absolute, local file name from an URI path name.
     </li>
<li> New String type with tool dependent choices
     <a href=\"modelica://ModelicaServices.Types.SolverMethod\">SolverMethod</a>
     to define the integration method to solve differential equations in a
     clocked discretized continuous-time partition.
     </li>
<li> New package
     <a href=\"modelica://ModelicaServices.Machine\">Machine</a>
     to define the processor dependent constants as used in
     <a href=\"modelica://Modelica.Constants\">Modelica.Constants</a>.
     </li>
</ul>


<h4>Version 1.1, 2010-07-30</h4>

<ul>
<li> New model <a href=\"modelica://ModelicaServices.Animation.Surface\">Surface</a>
     to describe movable, parameterized surfaces.</li>
<li> New string constant ModelicaServices.target to define the
     target of the corresponding ModelicaServices implementation</li>
<li> Package icons adapted to the icons of package Modelica, version 3.2.</li>
<li> ModelicaServices library on the Modelica subversion server provided in three versions:
     <ol>
     <li> <b>Default/ModelicaServices</b><br>
          (for tools that do not support 3-dim. visualization).</li>

     <li> <b>Dymola/ModelicaServices</b><br>
          (a Dymola-specific implementation).</li>

     <li> <b>DymolaAndDLRVisualization/ModelicaServices</b><br>
          (an implementation that uses the DLR Visualization library
           in combination with Dymola).</li>
     </ol>
     </li>
</ul>

<h4>Version 1.0, 2009-06-21</h4>

<p>
First version of the ModelicaServices library.
</p>
</html>"));
    end ReleaseNotes;

    class Contact "Contact"
      extends Modelica.Icons.Contact;
      annotation(
        Documentation(info = "<html>
<h5>Main Author:</h5>

<table border=0 cellspacing=0 cellpadding=2>
<tr>
<td>
<a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
    Robotik und Mechatronik Zentrum (RMC)<br>
    Institut f&uuml;r Systemdynamik und Regelungstechnik (SR)<br>
    Postfach 1116<br>
    D-82230 Wessling<br>
    Germany<br>
    email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A></td>
</tr>
</table>

<p><b>Acknowledgements:</b></p>

<p>
The design of the Animation.Shape component is from Hilding Elmqvist, Dassault Syst&egrave;mes AB.
</p>
</html>"));
    end Contact;
    annotation(
      DocumentationClass = true);
  end UsersGuide;

  package Animation "Models and functions for 3-dim. animation"
    extends Modelica.Icons.Package;

    model Shape "Different visual shapes with variable size; all data have to be set as modifiers (see info layer)"
      extends Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialShape;
      annotation(
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-150, -110}, {150, -140}}, lineColor = {0, 0, 0}, textString = "default")}),
        Documentation(info = "<html>
<p>
The interface of this model is documented at
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>.
</p>

</html>"));
    end Shape;

    model Surface "Animation of a moveable, parameterized surface; the surface characteristic is provided by a function"
      extends Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialSurface;
      annotation(
        Documentation(info = "<html>
<p>
The interface of this model is documented at
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface</a>.<br>
The interface of this model is defined at
<a href=\"modelica://Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialSurface\">Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialSurface</a>.
</p>

</html>"));
    end Surface;
  end Animation;

  package ExternalReferences "Library of functions to access external resources"
    extends Modelica.Icons.Package;

    function loadResource "Return the absolute path name of a URI or local file name (in this default implementation URIs are not supported, but only local file names)"
      extends Modelica.Utilities.Internal.PartialModelicaServices.ExternalReferences.PartialLoadResource;
    algorithm
      fileReference := OpenModelica.Scripting.uriToFilename(uri);
      annotation(
        Documentation(info = "<html>
<p>
The interface of this model is documented at
<a href=\"modelica://Modelica.Utilities.Files.loadResource\">Modelica.Utilities.Files.loadResource</a>.
</p>
</html>"));
    end loadResource;
  end ExternalReferences;

  package Machine
    // Machine dependent constants
    extends Modelica.Icons.Package;
    final constant Real eps = 1.e-15 "Biggest number such that 1.0 + eps = 1.0";
    final constant Real small = 1.e-60 "Smallest number such that small and -small are representable on the machine";
    final constant Real inf = 1.e+60 "Biggest Real number such that inf and -inf are representable on the machine";
    final constant Integer Integer_inf = OpenModelica.Internal.Architecture.integerMax() "Biggest Integer number such that Integer_inf and -Integer_inf are representable on the machine";
    annotation(
      Documentation(info = "<html>
<p>
Package in which processor specific constants are defined that are needed
by numerical algorithms. Typically these constants are not directly used,
but indirectly via the alias definition in
<a href=\"modelica://Modelica.Constants\">Modelica.Constants</a>.
</p>
</html>"));
  end Machine;

  package Types "Library of types with vendor specific choices"
    extends Modelica.Icons.Package;
    type SolverMethod = String "String defining the integration method to solve differential equations in a clocked discretized continuous-time partition" annotation(
      choices(choice = "External" "Solver specified externally", choice = "ExplicitEuler" "Explicit Euler method (order 1)", choice = "ExplicitMidPoint2" "Explicit mid point rule (order 2)", choice = "ExplicitRungeKutta4" "Explicit Runge-Kutta method (order 4)", choice = "ImplicitEuler" "Implicit Euler method (order 1)", choice = "ImplicitTrapezoid" "Implicit trapezoid rule (order 2)"),
      Documentation(info = "<html>
<p>
Type <b>SolverMethod</b> is a String type with menu choices to select the
integration method to solve differential equations in a clocked discretized
continuous-time partition. The choices are tool dependent.
For details, see chapter 16.8.2 \"Solver Method\" in the Modelica Language
Specification (version &ge; 3.3).
</p>
</html>"));
  end Types;
  annotation(
    Protection(access = Access.hide),
    preferredView = "info",
    version = "3.2.1",
    versionBuild = 2,
    versionDate = "2013-08-14",
    dateModified = "2013-08-14 08:44:41Z",
    revisionId = "$Id::                                       $",
    uses(Modelica(version = "3.2.1")),
    conversion(noneFromVersion = "1.0", noneFromVersion = "1.1", noneFromVersion = "1.2"),
    Documentation(info = "<html>
<p>
This package contains a set of functions and models to be used in the
Modelica Standard Library that requires a tool specific implementation.
These are:
</p>

<ul>
<li> <a href=\"modelica://ModelicaServices.Animation.Shape\">Shape</a>
     provides a 3-dim. visualization of elementary
     mechanical objects. It is used in
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Animation.Surface\">Surface</a>
     provides a 3-dim. visualization of
     moveable parameterized surface. It is used in
<a href=\"modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Surface</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.ExternalReferences.loadResource\">loadResource</a>
     provides a function to return the absolute path name of an URI or a local file name. It is used in
<a href=\"modelica://Modelica.Utilities.Files.loadResource\">Modelica.Utilities.Files.loadResource</a>
     via inheritance.</li>

<li> <a href=\"modelica://ModelicaServices.Machine\">ModelicaServices.Machine</a>
     provides a package of machine constants. It is used in
<a href=\"modelica://Modelica.Constants\">Modelica.Constants</a>.</li>

<li> <a href=\"modelica://ModelicaServices.Types.SolverMethod\">Types.SolverMethod</a>
     provides a string defining the integration method to solve differential equations in
     a clocked discretized continuous-time partition (see Modelica 3.3 language specification).
     It is not yet used in the Modelica Standard Library, but in the Modelica_Synchronous library
     that provides convenience blocks for the clock operators of Modelica version &ge; 3.3.</li>
</ul>

<p>
This is the default implementation, if no tool-specific implementation is available.
This ModelicaServices package provides only \"dummy\" models that do nothing.
</p>

<p>
<b>Licensed by DLR and Dassault Syst&egrave;mes AB under the Modelica License 2</b><br>
Copyright &copy; 2009-2015, DLR and Dassault Syst&egrave;mes AB.
</p>

<p>
<i>This Modelica package is <u>free</u> software and the use is completely at <u>your own risk</u>; it can be redistributed and/or modified under the terms of the Modelica License 2. For license conditions (including the disclaimer of warranty) see <a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica.UsersGuide.ModelicaLicense2</a> or visit <a href=\"https://www.modelica.org/licenses/ModelicaLicense2\"> https://www.modelica.org/licenses/ModelicaLicense2</a>.</i>
</p>

</html>"));
end ModelicaServices;

operator record Complex "Complex number with overloaded operators"
  //record Complex "Complex number with overloaded operators"
  replaceable Real re "Real part of complex number" annotation(
    Dialog);
  replaceable Real im "Imaginary part of complex number" annotation(
    Dialog);

  encapsulated operator 'constructor' "Constructor"
    function fromReal "Construct Complex from Real"
      import Complex;
      input Real re "Real part of complex number";
      input Real im = 0 "Imaginary part of complex number";
      output Complex result(re = re, im = im) "Complex number";
    algorithm

      annotation(
        Inline = true,
        Documentation(info = "<html>
<p>This function returns a Complex number defined by real part <i>re</i> and optional imaginary part <i>im</i> (default=0).</p>
</html>"));
    end fromReal;
    annotation(
      Documentation(info = "<html>
<p>Here the constructor operator(s) is/are defined.</p>
</html>"),
      Icon(graphics = {Rectangle(lineColor = {200, 200, 200}, fillColor = {248, 248, 248}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Rectangle(lineColor = {128, 128, 128}, fillPattern = FillPattern.None, extent = {{-100, -100}, {100, 100}}, radius = 25.0)}));
  end 'constructor';

  encapsulated operator function '0' "Zero-element of addition (= Complex(0))"
    import Complex;
    output Complex result "Complex(0)";
  algorithm
    result := Complex(0);
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function returns the zero-element of Complex, that is, Complex(0) = 0 + j*0.</p>
</html>"));
  end '0';

  encapsulated operator '-' "Unary and binary minus"
    function negate "Unary minus (multiply complex number by -1)"
      import Complex;
      input Complex c1 "Complex number";
      output Complex c2 "= -c1";
    algorithm
      c2 := Complex(-c1.re, -c1.im);
      annotation(
        Inline = true,
        Documentation(info = "<html>
<p>This function returns the binary minus of the given Complex number.</p>
</html>"));
    end negate;

    function subtract "Subtract two complex numbers"
      import Complex;
      input Complex c1 "Complex number 1";
      input Complex c2 "Complex number 2";
      output Complex c3 "= c1 - c2";
    algorithm
      c3 := Complex(c1.re - c2.re, c1.im - c2.im);
      annotation(
        Inline = true,
        Documentation(info = "<html>
<p>This function returns the difference of two given Complex numbers.</p>
</html>"));
    end subtract;
    annotation(
      Documentation(info = "<html>
<p>Here the unary and binary minus operator(s) is/are defined.</p>
</html>"),
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(lineColor = {200, 200, 200}, fillColor = {248, 248, 248}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Rectangle(lineColor = {128, 128, 128}, fillPattern = FillPattern.None, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Line(points = {{-50, 0}, {50, 0}}, color = {0, 0, 0}, smooth = Smooth.None)}));
  end '-';

  encapsulated operator '*' "Multiplication"
    function multiply "Multiply two complex numbers"
      import Complex;
      input Complex c1 "Complex number 1";
      input Complex c2 "Complex number 2";
      output Complex c3 "= c1*c2";
    algorithm
      c3 := Complex(c1.re * c2.re - c1.im * c2.im, c1.re * c2.im + c1.im * c2.re);
      annotation(
        Inline = true,
        Documentation(info = "<html>
<p>This function returns the product of two given Complex numbers.</p>
</html>"));
    end multiply;

    function scalarProduct "Scalar product c1*c2 of two complex vectors"
      import Complex;
      input Complex c1[:] "Vector of Complex numbers 1";
      input Complex c2[size(c1, 1)] "Vector of Complex numbers 2";
      output Complex c3 "= c1*c2";
    algorithm
      c3 := Complex(0);
      for i in 1:size(c1, 1) loop
        c3 := c3 + c1[i] * c2[i];
      end for;
/*
       c3 :=Complex(c3.re + c1[i].re*c2[i].re - c1[i].im*c2[i].im,
                    c3.im + c1[i].re*c2[i].im + c1[i].im*c2[i].re);
       */
      annotation(
        Inline = true,
        Documentation(info = "<html>
<p>This function returns the scalar product of two given arrays of Complex numbers.</p>
</html>"));
    end scalarProduct;
    annotation(
      Documentation(info = "<html>
<p>Here the multiplication operator(s) is/are defined.</p>
</html>"),
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(lineColor = {200, 200, 200}, fillColor = {248, 248, 248}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Rectangle(lineColor = {128, 128, 128}, fillPattern = FillPattern.None, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Line(points = {{-42, 36}, {39, -34}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-42, -35}, {39, 37}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-55, 1}, {52, 1}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-1.5, 55}, {-2, -53}}, color = {0, 0, 0}, smooth = Smooth.None)}));
  end '*';

  encapsulated operator function '+' "Add two complex numbers"
    import Complex;
    input Complex c1 "Complex number 1";
    input Complex c2 "Complex number 2";
    output Complex c3 "= c1 + c2";
  algorithm
    c3 := Complex(c1.re + c2.re, c1.im + c2.im);
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function returns the sum of two given Complex numbers.</p>
</html>"));
  end '+';

  encapsulated operator function '/' "Divide two complex numbers"
    import Complex;
    input Complex c1 "Complex number 1";
    input Complex c2 "Complex number 2";
    output Complex c3 "= c1/c2";
  algorithm
    c3 := Complex(((+c1.re * c2.re) + c1.im * c2.im) / (c2.re * c2.re + c2.im * c2.im), ((-c1.re * c2.im) + c1.im * c2.re) / (c2.re * c2.re + c2.im * c2.im));
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function returns the quotient of two given Complex numbers.</p>
</html>"));
  end '/';

  encapsulated operator function '^' "Complex power of complex number"
    import Complex;
    input Complex c1 "Complex number";
    input Complex c2 "Complex exponent";
    output Complex c3 "= c1^c2";
  protected
    Real lnz = 0.5 * log(c1.re * c1.re + c1.im * c1.im);
    Real phi = atan2(c1.im, c1.re);
    Real re = lnz * c2.re - phi * c2.im;
    Real im = lnz * c2.im + phi * c2.re;
  algorithm
    c3 := Complex(exp(re) * cos(im), exp(re) * sin(im));
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function returns the given Complex numbers c1 to the power of the Complex number c2.</p>
</html>"));
  end '^';

  encapsulated operator function '==' "Test whether two complex numbers are identical"
    import Complex;
    input Complex c1 "Complex number 1";
    input Complex c2 "Complex number 2";
    output Boolean result "c1 == c2";
  algorithm
    result := c1.re == c2.re and c1.im == c2.im;
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function tests whether two given Complex numbers are equal.</p>
</html>"));
  end '==';

  encapsulated operator function 'String' "Transform Complex number into a String representation"
    import Complex;
    input Complex c "Complex number to be transformed in a String representation";
    input String name = "j" "Name of variable representing sqrt(-1) in the string";
    input Integer significantDigits = 6 "Number of significant digits that are shown";
    output String s = "";
  algorithm
    s := String(c.re, significantDigits = significantDigits);
    if c.im <> 0 then
      if c.im > 0 then
        s := s + " + ";
      else
        s := s + " - ";
      end if;
      s := s + String(abs(c.im), significantDigits = significantDigits) + "*" + name;
    end if;
    annotation(
      Inline = true,
      Documentation(info = "<html>
<p>This function converts a given Complex number to String representation.</p>
</html>"));
  end 'String';
  annotation(
    Protection(access = Access.hide),
    version = "3.2.1",
    versionBuild = 2,
    versionDate = "2013-08-14",
    dateModified = "2013-08-14 08:44:41Z",
    revisionId = "$Id::                                       $",
    conversion(noneFromVersion = "1.0", noneFromVersion = "1.1"),
    Documentation(info = "<html>
<p>Complex number defined as a record containing real and imaginary part, utilizing operator overloading.</p>
</html>"),
    Icon(graphics = {Rectangle(lineColor = {160, 160, 164}, fillColor = {160, 160, 164}, fillPattern = FillPattern.Solid, extent = {{-100, -100}, {100, 100}}, radius = 25.0), Text(lineColor = {255, 255, 255}, extent = {{-90, -50}, {90, 50}}, textString = "C")}));
end Complex;

package Modelica "Modelica Standard Library - Version 3.2.1 (Build 4)"
  extends Modelica.Icons.Package;

  package UsersGuide "User's Guide"
    extends Modelica.Icons.Information;

    class Overview "Overview of Modelica Library"
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>
<p>
The Modelica Standard Library consists of the following
main sub-libraries:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th>Library Components</th> <th>Description</th></tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Electrical.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Electrical.Analog\">Analog</a><br>
 Analog electric and electronic components, such as
 resistor, capacitor, transformers, diodes, transistors,
 transmission lines, switches, sources, sensors.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Digital.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Electrical.Digital\">Digital</a><br>
 Digital electrical components based on the VHDL standard,
 like basic logic blocks with 9-value logic, delays, gates,
 sources, converters between 2-, 3-, 4-, and 9-valued logic.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Machines.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Electrical.Machines\">Machines</a><br>
            Electrical asynchronous-, synchronous-, and DC-machines
 (motors and generators) as well as 3-phase transformers.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-FluxTubes.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Magnetic.FluxTubes\">FluxTubes</a><br>
Based on magnetic flux tubes concepts. Especially to model electro-magnetic actuators. Nonlinear shape, force, leakage, and material models. Material data for steel, electric sheet, pure iron, Cobalt iron, Nickel iron, NdFeB, Sm2Co17, and more.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Translational.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Mechanics.Translational\">Translational</a><br>
 1-dim. mechanical, translational systems, e.g.,
 sliding mass, mass with stops, spring, damper.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Rotational.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Mechanics.Rotational\">Rotational</a><br>
 1-dim. mechanical, rotational systems, e.g., inertias, gears,
 planetary gears, convenient definition of speed/torque dependent friction
 (clutches, brakes, bearings, ..)
 </td>
</tr>

<tr><td valign=\"top\" width=100>
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-MultiBody1.png\"><br>
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-MultiBody2.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Mechanics.MultiBody\">MultiBody</a>
 3-dim. mechanical systems consisting of joints, bodies, force and
 sensor elements. Joints can be driven by drive trains defined by
 1-dim. mechanical system library (Rotational).
 Every component has a default animation.
 Components can be arbitrarily connected together.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Fluid.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Fluid\">Fluid</a><br>
        1-dim. thermo-fluid flow in networks of vessels, pipes,
        fluid machines, valves and fittings. All media from the
        Modelica.Media library can be used (so incompressible or compressible,
        single or multiple substance, one or two phase medium).
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Media.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Media\">Media</a><br>
 Large media library providing models and functions
 to compute media properties, such as h = h(p,T), d = d(p,T),
 for the following media:
 <ul>
 <li> 1240 gases and mixtures between these gases.</li>
 <li> incompressible, table based liquids (h = h(T), etc.).</li>
 <li> compressible liquids</li>
 <li> dry and moist air</li>
 <li> high precision model for water (IF97).</li>
 </ul>
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Thermal.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Thermal.FluidHeatFlow\">FluidHeatFlow</a>,
 <a href=\"modelica://Modelica.Thermal.HeatTransfer\">HeatTransfer</a>
 Simple thermo-fluid pipe flow, especially to model cooling of machines
 with air or water (pipes, pumps, valves, ambient, sensors, sources) and
 lumped heat transfer with heat capacitors, thermal conductors, convection,
 body radiation, sources and sensors.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Blocks1.png\"><br>
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-Blocks2.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Blocks\">Blocks</a><br>
 Input/output blocks to model block diagrams and logical networks, e.g.,
 integrator, PI, PID, transfer function, linear state space system,
 sampler, unit delay, discrete transfer function, and/or blocks,
 timer, hysteresis, nonlinear and routing blocks, sources, tables.
 </td>
</tr>

<tr><td valign=\"top\">
 <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Lib-StateGraph.png\">
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.StateGraph\">StateGraph</a><br>
 Hierarchical state machines with a similar modeling power as Statecharts.
 Modelica is used as synchronous action language, i.e., deterministic
 behavior is guaranteed
 </td>
</tr>

<tr><td valign=\"top\">
 <pre>
 A = [1,2,3;
   3,4,5;
   2,1,4];
 b = {10,22,12};
 x = Matrices.solve(A,b);
 Matrices.eigenValues(A);
 </pre>
 </td>
 <td valign=\"top\">
 <a href=\"modelica://Modelica.Math\">Math</a>,
 <a href=\"modelica://Modelica.Utilities\">Utilities</a><br>
 Functions operating on vectors and matrices, such as for solving
 linear systems, eigen and singular values etc.,  and
 functions operating on strings, streams, files, e.g.,
 to copy and remove a file or sort a vector of strings.
 </td>
</tr>

</table>

</html>"));
    end Overview;

    class Connectors "Connectors"
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>

<p>
The Modelica standard library defines the most important
<b>elementary connectors</b> in various domains. If any possible,
a user should utilize these connectors in order that components
from the Modelica Standard Library and from other libraries
can be combined without problems.
The following elementary connectors are defined
(the meaning of potential, flow, and stream
variables is explained in section \"Connector Equations\" below):
</p>

<table border=1 cellspacing=0 cellpadding=1>
<tr><td valign=\"top\"><b>domain</b></td>
   <td valign=\"top\"><b>potential<br>variables</b></td>
   <td valign=\"top\"><b>flow<br>variables</b></td>
   <td valign=\"top\"><b>stream<br>variables</b></td>
   <td valign=\"top\"><b>connector definition</b></td>
   <td valign=\"top\"><b>icons</b></td></tr>

<tr><td valign=\"top\"><b>electrical<br>analog</b></td>
   <td valign=\"top\">electrical potential</td>
   <td valign=\"top\">electrical current</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Analog.Interfaces\">Modelica.Electrical.Analog.Interfaces</a>
     <br>Pin, PositivePin, NegativePin</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/ElectricalPins.png\"></td></tr>

<tr><td valign=\"top\"><b>electrical<br>multi-phase</b></td>
   <td colspan=\"3\">vector of electrical pins</td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.MultiPhase.Interfaces\">Modelica.Electrical.MultiPhase.Interfaces</a>
     <br>Plug, PositivePlug, NegativePlug</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/ElectricalPlugs.png\"></td></tr>

<tr><td valign=\"top\"><b>electrical <br>space phasor</b></td>
   <td valign=\"top\">2 electrical potentials</td>
   <td valign=\"top\">2 electrical currents</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Machines.Interfaces\">Modelica.Electrical.Machines.Interfaces</a>
     <br>SpacePhasor</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/SpacePhasor.png\"></td></tr>

<tr><td valign=\"top\"><b>quasi<br>stationaray<br>single phase</b></td>
   <td valign=\"top\">complex electrical potential</td>
   <td valign=\"top\">complex electrical current</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.QuasiStationary.SinglePhase.Interfaces\">
                                       Modelica.Electrical.QuasiStationary.SinglePhase.Interfaces</a>
     <br>Pin, PositivePin, NegativePin</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/QuasiStationarySinglePhasePins.png\"></td></tr>

<tr><td valign=\"top\"><b>quasi<br>stationary<br>multi-phase</b></td>
   <td colspan=\"3\">vector of quasi stationary single phase pins</td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces\">Modelica.Electrical.QuasiStationary.MultiPhase.Interfaces</a>
     <br>Plug, PositivePlug, NegativePlug</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/QuasiStationaryMultiPhasePlugs.png\"></td></tr>

<tr><td valign=\"top\"><b>electrical <br>digital</b></td>
   <td valign=\"top\">Integer (1..9)</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Digital.Interfaces\">Modelica.Electrical.Digital.Interfaces</a>
     <br>DigitalSignal, DigitalInput, DigitalOutput</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/Digital.png\"></td></tr>

<tr><td valign=\"top\"><b>magnetic<br>flux tubes</b></td>
   <td valign=\"top\">magnetic potential</td>
   <td valign=\"top\">magnetic flux</td>
   <td valign=\"top\"></td>
   <td valign=\"top\">
<a href=\"modelica://Modelica.Magnetic.FluxTubes.Interfaces\">Modelica.Magnetic.FluxTubes.Interfaces</a>
     <br>MagneticPort, PositiveMagneticPort, <br>NegativeMagneticPort</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/MagneticPorts.png\"></td></tr>

<tr><td valign=\"top\"><b>magnetic<br>fundamental<br>wave</b></td>
   <td valign=\"top\">complex magnetic potential</td>
   <td valign=\"top\">complex magnetic flux</td>
   <td valign=\"top\"></td>
   <td valign=\"top\">
<a href=\"modelica://Modelica.Magnetic.FundamentalWave.Interfaces\">Modelica.Magnetic.FundamentalWave.Interfaces</a>
     <br>MagneticPort, PositiveMagneticPort, <br>NegativeMagneticPort</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/FundamentalWavePorts.png\"></td></tr>

<tr><td valign=\"top\"><b>translational</b></td>
   <td valign=\"top\">distance</td>
   <td valign=\"top\">cut-force</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.Translational.Interfaces\">Modelica.Mechanics.Translational.Interfaces</a>
     <br>Flange_a, Flange_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/TranslationalFlanges.png\"></td></tr>

<tr><td valign=\"top\"><b>rotational</b></td>
   <td valign=\"top\">angle</td>
   <td valign=\"top\">cut-torque</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.Rotational.Interfaces\">Modelica.Mechanics.Rotational.Interfaces</a>
     <br>Flange_a, Flange_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/RotationalFlanges.png\"></td></tr>

<tr><td valign=\"top\"><b>3-dim.<br>mechanics</b></td>
   <td valign=\"top\">position vector<br>
    orientation object</td>
   <td valign=\"top\">cut-force vector<br>
    cut-torque vector</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.MultiBody.Interfaces\">Modelica.Mechanics.MultiBody.Interfaces</a>
     <br>Frame, Frame_a, Frame_b, Frame_resolve</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/MultiBodyFrames.png\"></td></tr>

<tr><td valign=\"top\"><b>simple<br>fluid flow</b></td>
   <td valign=\"top\">pressure<br>
    specific enthalpy</td>
   <td valign=\"top\">mass flow rate<br>
    enthalpy flow rate</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Thermal.FluidHeatFlow.Interfaces\">Modelica.Thermal.FluidHeatFlow.Interfaces</a>
     <br>FlowPort, FlowPort_a, FlowPort_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/FluidHeatFlowPorts.png\"></td></tr>

<tr><td valign=\"top\"><b>thermo<br>fluid flow</b></td>
   <td valign=\"top\">pressure</td>
   <td valign=\"top\">mass flow rate</td>
   <td valign=\"top\">specific enthalpy<br>mass fractions</td>
   <td valign=\"top\">
<a href=\"modelica://Modelica.Fluid.Interfaces\">Modelica.Fluid.Interfaces</a>
     <br>FluidPort, FluidPort_a, FluidPort_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/FluidPorts.png\"></td></tr>

<tr><td valign=\"top\"><b>heat<br>transfer</b></td>
   <td valign=\"top\">temperature</td>
   <td valign=\"top\">heat flow rate</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Thermal.HeatTransfer.Interfaces\">Modelica.Thermal.HeatTransfer.Interfaces</a>
     <br>HeatPort, HeatPort_a, HeatPort_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/ThermalHeatPorts.png\"></td></tr>

<tr><td valign=\"top\"><b>blocks</b></td>
   <td valign=\"top\">
    Real variable<br>
    Integer variable<br>
    Boolean variable</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Interfaces\">Modelica.Blocks.Interfaces</a>
     <br>
      RealSignal, RealInput, RealOutput<br>
      IntegerSignal, IntegerInput, IntegerOutput<br>
      BooleanSignal, BooleanInput, BooleanOutput</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/Signals.png\"></tr>

<tr><td valign=\"top\"><b>complex<br>blocks</b></td>
   <td valign=\"top\">
    Complex variable</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.ComplexBlocks.Interfaces\">Modelica.ComplexBlocks.Interfaces</a>
     <br>ComplexSignal, ComplexInput, ComplexOutput</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/ComplexSignals.png\"></tr>

<tr><td valign=\"top\"><b>state<br>machine</b></td>
   <td valign=\"top\">Boolean variables<br>
    (occupied, set, <br>
     available, reset)</td>
   <td valign=\"top\"></td>
   <td valign=\"top\"></td>
   <td valign=\"top\"><a href=\"modelica://Modelica.StateGraph.Interfaces\">Modelica.StateGraph.Interfaces</a>
     <br>Step_in, Step_out, Transition_in, Transition_out</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/StateGraphPorts.png\"></td></tr>

<tr><td colspan=\"5\">&nbsp;<br><b>Connectors from other libraries</b></td></tr>

<tr><td valign=\"top\"><b>hydraulic</b></td>
   <td valign=\"top\">pressure</td>
   <td valign=\"top\">volume flow rate</td>
   <td valign=\"top\"></td>
   <td valign=\"top\">HyLibLight.Interfaces
     <br>Port_A, Port_b</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/HydraulicPorts.png\"></td></tr>

<tr><td valign=\"top\"><b>pneumatic</b></td>
   <td valign=\"top\">pressure</td>
   <td valign=\"top\">mass flow rate</td>
   <td valign=\"top\"></td>
   <td valign=\"top\">PneuLibLight.Interfaces
     <br>Port_1, Port_2</td>
   <td valign=\"top\"><img src=\"modelica://Modelica/Resources/Images/UsersGuide/PneumaticPorts.png\"></td></tr>
</table>

<p>
In all domains, usually 2 connectors are defined. The variable declarations
are <b>identical</b>, only the icons are different in order that it is easy
to distinguish connectors of the same domain that are attached at the same
component.
</p>

<h4>Hierarchical Connectors </h4>
<p>
Modelica supports also hierarchical connectors, in a similar way as hierarchical models.
As a result, it is, e.g., possible, to collect elementary connectors together.
For example, an electrical plug consisting of two electrical pins can be defined as:
</p>

<blockquote>
<pre>
<b>connector</b> Plug
   <b>import</b> Modelica.Electrical.Analog.Interfaces;
   Interfaces.PositivePin phase;
   Interfaces.NegativePin ground;
<b>end</b> Plug;
</pre>
</blockquote>

<p>
With one connect(..) equation, either two plugs can be connected
(and therefore implicitly also the phase and ground pins) or a
Pin connector can be directly connected to the phase or ground of
a Plug connector, such as \"connect(resistor.p, plug.phase)\".
</p>

<h4 id=\"ConnectorEquations\">Connector Equations</h4>

<p>
The connector variables listed above have been basically determined
with the following strategy:
</p>

<ol>
<li> State the relevant balance equations and boundary
     conditions of a volume for the particular physical domain.</li>
<li> Simplify the balance equations and boundary conditions
     of (1) by taking the
     limit of an infinitesimal small volume
     (e.g., thermal domain:
      temperatures are identical and heat flow rates
      sum up to zero).
</li>
<li> Use the variables needed for the balance equations
     and boundary conditions of (2)
     in the connector and select appropriate Modelica
     <b>prefixes</b>, so that these equations
     are generated by the Modelica connection semantics.
</ol>

<p>
The Modelica connection semantics is sketched at hand
of an example: Three connectors c1, c2, c3 with the definition
</p>

<pre>
<b>connector</b> Demo
  Real        p;  // potential variable
  <b>flow</b>   Real f;  // flow variable
  <b>stream</b> Real s;  // stream variable
<b>end</b> Demo;
</pre>

<p>
are connected together with
</p>

<pre>
   <b>connect</b>(c1,c2);
   <b>connect</b>(c1,c3);
</pre>

<p>
then this leads to the following equations:
</p>

<pre>
  // Potential variables are identical
  c1.p = c2.p;
  c1.p = c3.p;

  // The sum of the flow variables is zero
  0 = c1.f + c2.f + c3.f;

  /* The sum of the product of flow variables and upstream stream variables is zero
     (this implicit set of equations is explicitly solved when generating code;
     the \"&lt;undefined&gt;\" parts are defined in such a way that
     inStream(..) is continuous).
  */
  0 = c1.f*(<b>if</b> c1.f > 0 <b>then</b> s_mix <b>else</b> c1.s) +
      c2.f*(<b>if</b> c2.f > 0 <b>then</b> s_mix <b>else</b> c2.s) +
      c3.f*(<b>if</b> c3.f > 0 <b>then</b> s_mix <b>else</b> c3.s);

  <b>inStream</b>(c1.s) = <b>if</b> c1.f > 0 <b>then</b> s_mix <b>else</b> &lt;undefined&gt;;
  <b>inStream</b>(c2.s) = <b>if</b> c2.f > 0 <b>then</b> s_mix <b>else</b> &lt;undefined&gt;;
  <b>inStream</b>(c3.s) = <b>if</b> c3.f > 0 <b>then</b> s_mix <b>else</b> &lt;undefined&gt;;
</pre>

</html>"));
    end Connectors;

    package Conventions "Conventions"
      extends Modelica.Icons.Information;

      package Documentation "HTML documentation"
        extends Modelica.Icons.Information;

        package Format "Format"
          extends Modelica.Icons.Information;

          class Cases "Cases"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>

<p>In the Modelica documentation sometimes different cases have to be distinguished. If the case distinction refers to Modelica parameters or variables (Boolean expressions) the comparisons should be written in the style of Modelica code within <code>&lt;code&gt;</code> and <code>&lt;/code&gt;</code>
</p>

<h5>Example 1</h5>

<code>&lt;p&gt;If &lt;code&gt;useCage == true&lt;/code&gt;, a damper cage is considered in the model...&lt;/p&gt;</code>

<p>appears as</p>

<p>If <code>useCage == true</code>, a damper cage is considered in the model...</p>

<p>
For more complex case scenarios a unordered list should be used. In this case only Modelica specific code segments and Boolean expressions.
</p>

<h5>Example 2</h5>

<pre>
&lt;ul&gt;
  &lt;li&gt; If &lt;code&gt;useCage == true&lt;/code&gt;, a damper cage is considered in the model.
       Cage parameters must be specified in this case.&lt;/li&gt;
  &lt;li&gt; If &lt;code&gt;useCage == false&lt;/code&gt;, the damper cage is omitted.&lt;/li&gt;
&lt;/ul&gt;</pre>

<p>appears as</p>

<ul>
  <li> If <code>useCage == true</code>, a damper cage is considered in the model.
       Cage parameters must be specified in this case.</li>
  <li> If <code>useCage == false</code>, the damper cage is omitted.</li>
</ul>

<p>
In a more equation oriented case additional equations or code segments can be added.
</p>

<h5>Example 3</h5>

<pre>
&lt;ul&gt;
  &lt;li&gt;if &lt;code&gt;usePolar == true&lt;/code&gt;, assign magnitude and angle to output &lt;br&gt;
  &lt;!-- insert graphical representation of equations --&gt;
  y[i,1] = sqrt( a[i]^2 + b[i]^2 ) &lt;br&gt;
  y[i,2] = atan2( b[i], a[i] )
  &lt;/li&gt;
  &lt;li&gt;if &lt;code&gt;usePolar == false&lt;/code&gt;, assign cosine and sine to output &lt;br&gt;
  &lt;!-- insert graphical representation of equations --&gt;
  y[i,1] = a[i] &lt;br&gt;
  y[i,2] = b[i]
  &lt;/li&gt;
&lt;/ul&gt;</pre>

<p>appears as</p>

<ul>
  <li>if <code>usePolar == true</code>, assign magnitude and angle to output <br>

  <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Cases/y_i1_polar.png\"
       alt=\"y[i,1] = sqrt( a[i]^2 + b[i]^2 )\"> <br>
  <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Cases/y_i2_polar.png\"
       alt=\"y[i,2] = atan2( b[i], a[i] )\">
  </li>
  <li>if <code>usePolar == false</code>, assign cosine and sine to output <br>
  <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Cases/y_i1_rect.png\"
       alt=\"y[i,1] = a[i]\"> <br>
  <img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Cases/y_i2_rect.png\"
       alt=\" y[i,2] = b[i]\">
  </li>
</ul>

</html>"));
          end Cases;

          class Code "Code"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>
<p>
<a href=\"modelica://Modelica.UsersGuide.Conventions.ModelicaCode\">Modelica code</a> conventions of class and instance names,
parameters and variables are specified separately. In this section it is summarized how to refer to
Modelica code in the HTML documentation.
</p>

<ol>
<li> For constants, parameters and variables in code segments <code>&lt;code&gt;</code> and <code>&lt;/code&gt;</code>
     should to be used, e.g., <br>
     <code><b>parameter</b> Modelica.SIunits.Time tStart \"Start time\"</code></li>
<li> Write multi or single line code segments using <code>&lt;pre&gt;</code> and <code>&lt;/pre&gt;</code>.</li>
<li> Multi line or single line code shall not be indented.</li>
<li> Inline code segments may be typeset with <code>&lt;code&gt;</code> and <code>&lt;/code&gt;</code>.</li>
<li> In code segments use bold to emphasize Modelica keywords.</li>
</ol>

<h5>Example 1</h5>

<pre>
&lt;pre&gt;
&lt;b&gt;connector&lt;/b&gt; Frame
   ...
   &lt;b&gt;flow&lt;/b&gt; SI.Force f[Woehrnschimmel1998] &lt;b&gt;annotation&lt;/b&gt;(unassignedMessage=\"...\");
&lt;b&gt;end&lt;/b&gt; Frame;
&lt;/pre&gt;</pre>

<p>appears as</p>

<pre>
<b>connector</b> Frame
   ...
   <b>flow</b> SI.Force f[Woehrnschimmel1998] <b>annotation</b>(unassignedMessage=\"...\");
<b>end</b> Frame;
</pre>

<h5>Example 2</h5>

<pre>
&lt;pre&gt;
&lt;b&gt;parameter&lt;/b&gt; Modelica.SIunits.Conductance G=1 &quot;Conductance&quot;;
&lt;/pre&gt;
</pre>

<p>appears as</p>

<pre>
<b>parameter</b> Modelica.SIunits.Conductance G=1 &quot;Conductance&quot;;
</pre>
</html>"));
          end Code;

          class Equations "Equations"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>

<p>
In the context of <a href=\"http://www.w3c.org/\">HTML</a> documentation
equations should have a graphical representation in PNG format. For that purpose tool
specific math typing capabilities can be used. Alternatively the LaTeX to HTML translator
<a href=\"http://www.latex2html.org\">LaTeX2HTML</a>, or the
<a href=\"http://www.homeschoolmath.net/worksheets/equation_editor.php\">Online Equation Editor</a>
or <a href=\"http://www.codecogs.com/components/eqneditor/editor.php\">codecogs</a> can be used.
</p>

<p>
A typical equation, e.g., of a Fourier synthesis, could look like<br>
<img
 src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Equations/fourier.png\"> <br>
or <br>
<img
 src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Equations/sample.png\"
 alt=\"y=a_1+a_2\"><br>
In an <code>alt</code> tag the original equation should be stored, e.g.,</p>
<pre>
&lt;img
&nbsp;src=&quot;modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Equations/sample.png&quot;
&nbsp;alt=&quot;y=a_1+a_2&quot;&gt;
</pre>

<p>
If one wants to refer to particular variables and parameters in the documentation text, either a
graphical representation (PNG file) or italic fonts for regular physical symbols and lower case
<a href=\"http://www.w3.org/TR/html4/sgml/entities.html\">Greek letters</a>
should be used. Full word variables and full word indices should be spelled within &lt;code&gt; and &lt;/code&gt;.
Vector and array indices should be typeset as subscripts using the &lt;sub&gt; and &lt;/sub&gt; tags.
</p>

<p> Examples for such variables and parameters are:
<i>&phi;</i>, <i>&phi;</i><sub>ref</sub>, <i>v<sub>2</sub></i>, <code>useDamperCage</code>.
</p>

<h4>Numbered equations</h4>

<p>For numbering equations a one row table with two columns should be used. The equation number should be placed in the right column:</p>

<pre>
&lt;table border=\"0\" cellspacing=\"10\" cellpadding=\"2\"&gt;
  &lt;tr&gt;
      &lt;td&gt;&lt;img
      src=&quot;modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Equations/sample.png&quot;
      alt=&quot;y=a_1+a_2&quot;&gt; &lt;/td&gt;
      &lt;td&gt;(1)&lt;/td&gt;
  &lt;/tr&gt;
&lt;/table&gt;
</pre>

<p>appears as:</p>

<table border=\"0\" cellspacing=\"10\" cellpadding=\"2\">
  <tr>
    <td><img
         src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Documentation/Format/Equations/sample.png\"
         alt=\"y=a_1+a_2\"></td>
    <td>(1)</td>
  </tr>
</table>

</html>"));
          end Equations;

          class Figures "Figures"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>
<p>
Figures should in particular be included to examples to discuss the problems and results of the respective model. The library developers are yet encouraged to add figures to the documentation of other components to support the understanding of the users of the library.
</p>

<ol>
<li> Figures have to be placed <strong>outside</strong> of paragraphs to be HTML compliant.</li>
<li> Figures need to have <strong>at least</strong> a <code>src</code> and an <code>alt</code> attribute defined to be HTML compliant.</li>
<li> Technical figures should be placed within a table environment. Each technical figure should then also have a caption. The figure caption starts with a capital letter.</li>
<li> Illustration can be embedded without table environment.</li>
</ol>

<h4>Location of files</h4>

The <code>PNG</code> files should be placed in a folder which exactly represents the package structure.

<h5>Example 1</h5>

<p>This example shows how an illustration should be embedded in the Example
<a href=\"modelica://Modelica.Blocks.Examples.PID_Controller\">PID_Controller</a> of the
<a href=\"modelica://Modelica.Blocks\">Blocks</a> package.</p>

<pre>
&lt;img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Images/Blocks/Examples/PID_controller.png\"
     alt=\"PID_controller.png\"&gt;
</pre>

<h5>Example 2</h5>

<p>This is a simple example of a technical figure with caption.</p>

<pre>
&lt;table border=\"0\" cellspacing=\"0\" cellpadding=\"2\"&gt;
  &lt;caption align=\"bottom\"&gt;Caption starts with a capital letter&lt;/caption&gt;
  &lt;tr&gt;
    &lt;td&gt;
      &lt;img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Images/Blocks/Examples/PID_controller.png\"
           alt=\"PID_controller.png\"&gt;
    &lt;/td&gt;
  &lt;/tr&gt;
&lt;/table&gt;
</pre>

<h5>Example 3</h5>

<p>To refer to a certain figure, a figure number may be added. In such case the figure name (Fig.) including the figure enumeration (1,2,...) have to be displayed bold using <code>&lt;strong&gt;</code> and <code>&lt;/strong&gt;</code>.</p>
<p>The figure name and enumeration should look like this: <strong>Fig. 1:</strong></p>
<p>Figures have to be enumerated manually. </p>

<pre>
&lt;table border=\"0\" cellspacing=\"0\" cellpadding=\"2\"&gt;
  &lt;caption align=\"bottom\"&gt;&lt;strong&gt;Fig. 2: &lt;/strong&gt;Caption starts with a capital letter&lt;/caption&gt;
  &lt;tr&gt;
    &lt;td&gt;
      &lt;img src=\"modelica://Modelica/Resources/Images/UsersGuide/Conventions/Images/Blocks/Examples/PID_controller.png\"
           alt=\"PID_controller.png\"&gt;
    &lt;/td&gt;
  &lt;/tr&gt;
&lt;/table&gt;
</pre>

</html>"));
          end Figures;

          class Hyperlinks "Hyperlinks"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>
<ol>
<li> Hyperlinks should always be made when referring to a component or package.</li>
<li> The hyperlink text in between <code>&lt;a href=&quot;...&quot;&gt;</code> and <code>&lt;/a&gt;</code> should include the full main package name.</li>
<li> A link to an external component should include the full name of the package that it is referred to.</li>
<li> Modelica hyperlinks have to use the scheme <code>&quot;modelica://...&quot;</code></li>
<li> For hyperlinks referring to a Modelica component, see Example 1 and 2.</li>
<li> No links to commercial web sites are allowed.</li>
</ol>
<h5>Example 1</h5>
<pre>
&lt;a href=\"modelica://Modelica.Mechanics.MultiBody.UsersGuide.Tutorial.LoopStructures.PlanarLoops\"&gt;
         Modelica.Mechanics.MultiBody.UsersGuide.Tutorial.LoopStructures.PlanarLoops&lt;/a&gt;</pre>
<p>appears as</p>
<a href=\"modelica://Modelica.Mechanics.MultiBody.UsersGuide.Tutorial.LoopStructures.PlanarLoops\">
         Modelica.Mechanics.MultiBody.UsersGuide.Tutorial.LoopStructures.PlanarLoops</a>
<h5>Example 2</h5>
<pre>
&lt;p&gt;
  The feeder cables are connected to an
  &lt;a href=\"modelica://Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage\"&gt;
  induction machine&lt;/a&gt;.
&lt;/p&gt;</pre>
<p>appears as</p>
<p>
  The feeder cables are connected to an
  <a href=\"modelica://Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines.AIM_SquirrelCage\">
  induction machine</a>.
</p>
</html>"));
          end Hyperlinks;

          class Lists "Lists"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>
<p>
Lists have to be placed <strong>outside</strong> of paragraphs to be HTML compliant.
</p>

<ol>
<li> Items of a list shall start with
<ul>
    <li> a capital letter if each item is a full sentence</li>
    <li> a small letter, if only text fragments are used or the list is fragment of a sentence</li>
</ul></li>
</ol>

<h5>Example 1</h5>

<p>This is a simple example of an enumerated (ordered) list</p>

<pre>
&lt;ol&gt;
  &lt;li&gt;item 1&lt;/li&gt;
  &lt;li&gt;item 2&lt;/li&gt;
&lt;/ol&gt;
</pre>
<p>appears as</p>
<ol>
  <li>item 1</li>
  <li>item 2</li>
</ol>

<h5>Example 2</h5>

<p>This is a simple example of an unnumbered list.</p>

<pre>
&lt;ul&gt;
  &lt;li&gt;item 1&lt;/li&gt;
  &lt;li&gt;item 2&lt;/li&gt;
&lt;/ul&gt;
</pre>
<p>appears as</p>
<ul>
  <li>item 1</li>
  <li>item 2</li>
</ul>
</html>"));
          end Lists;

          class References "References"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>

<h4>General</h4>
<ol>
<li> Refer to references by [1], [Andronov1973], etc. by hyperlink and summarize literature in the references subsection of
     <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.References\">Conventions.UsersGuide.References</a>.
<li> There has to be made at least one citation to each reference.</li>
</ol>

<h5>Example</h5>

<pre>
&lt;p&gt;
  More details about sensorless rotor temperature estimation
  can be found in &lt;a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.References\"&gt;[Gao2008]&lt;/a.&gt;
&lt;/p&gt;</pre>
<p>appears as</p>
<p>
  More details about sensorless rotor temperature estimation can be found in <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.References\">[Gao2008]</a>.
</p>

</html>"));
          end References;

          class Tables "Tables"
            extends Modelica.Icons.Information;
            annotation(
              Documentation(info = "<html>
<ol>
<li> Tables should always be typeset with <code>&lt;table&gt;</code> and <code>&lt;/table&gt;</code>,
     not with <code>&lt;pre&gt;</code> and <code>&lt;/pre&gt;</code>.</li>
<li> Tables have to be placed <strong>outside</strong> of paragraphs to be HTML compliant.</li>
<li> Each table must have a table caption. </li>
<li> Table headers and entries start with capital letters.</li>
</ol>

<h5>Example 1</h5>

<p>This is a simple example of a table.</p>

<pre>
&lt;table border=\"1\" cellspacing=\"0\" cellpadding=\"2\"&gt;
  &lt;caption align=\"bottom\"&gt;Caption starts with a capital letter&lt;/caption&gt;
  &lt;tr&gt;
    &lt;th&gt;Head 1&lt;/th&gt;
    &lt;th&gt;Head 2&lt;/th&gt;
  &lt;/tr&gt;
  &lt;tr&gt;
    &lt;td&gt;Entry 1&lt;/td&gt;
    &lt;td&gt;Entry 2&lt;/td&gt;
  &lt;/tr&gt;
  &lt;tr&gt;
    &lt;td&gt;Entry 3&lt;/td&gt;
    &lt;td&gt;Entry 4&lt;/td&gt;
  &lt;/tr&gt;
&lt;/table&gt;
</pre>
<p>appears as</p>
<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\">Caption starts with a capital letter</caption>
  <tr>
    <th><b>Head 1</b></th>
    <th><b>Head 2</b></th>
  </tr>
  <tr>
    <td>Entry 1</td>
    <td>Entry 2</td>
  </tr>
  <tr>
    <td>Entry 3</td>
    <td>Entry 4</td>
  </tr>
</table>

<h5>Example 2</h5>

<p>In this case of table captions, the table name (Tab.) including the table enumeration (1,2,...)
has to be displayed bold using <code>&lt;b&gt;</code> and <code>&lt;/b&gt;</code>. The table name
and enumeration should look like this: <b>Tab. 1:</b> Tables have to be enumerated manually.</p>

<pre>
&lt;table border=\"1\" cellspacing=\"0\" cellpadding=\"2\"&gt;
  &lt;caption align=\"bottom\"&gt;&lt;b&gt;Tab 2: &lt;/b&gt;Caption starts with a capital letter&lt;/caption&gt;
  &lt;tr&gt;
    &lt;th&gt;Head 1&lt;/th&gt;
    &lt;th&gt;Head 2&lt;/th&gt;
  &lt;/tr&gt;
  &lt;tr&gt;
    &lt;td&gt;Entry 1&lt;/td&gt;
    &lt;td&gt;Entry 2&lt;/td&gt;
  &lt;/tr&gt;
  &lt;tr&gt;
    &lt;td&gt;Entry 3&lt;/td&gt;
    &lt;td&gt;Entry 4&lt;/td&gt;
  &lt;/tr&gt;
&lt;/table&gt;
</pre>
<p>appears as</p>
<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
  <caption align=\"bottom\"><b>Tab. 2: </b>Caption starts with a capital letter</caption>
  <tr>
    <th>Head 1</th>
    <th>Head 2</th>
  </tr>
  <tr>
    <td>Entry 1</td>
    <td>Entry 2</td>
  </tr>
  <tr>
    <td>Entry 3</td>
    <td>Entry 4</td>
  </tr>
</table>

</html>"));
          end Tables;
          annotation(
            Documentation(info = "<html>

<p>
In this section the format UsersGuide of the HTML documentation are specified.
The <a href=\"modelica://Modelica.UsersGuide.Conventions.Documentation.Structure\">structure</a> of the documentation is specified separately.
</p>

<h4>Paragraphs</h4>

<ol>
<li> In each section the paragraphs should start with <code>&lt;p&gt;</code>
     and terminate with <code>&lt;/p&gt;</code>.</li>
<li> Do not write plain text without putting it in a paragraph.</li>
<li> No artificial line breaks <code>&lt;br&gt;</code> should be added within text paragraphs if possible.
     Use separate paragraphs instead.</li>
<li> After a colon (:) continue with capital letter if new sentence starts;
     for text fragments continue with lower case letter</li>
</ol>

<h4>Emphasis</h4>

<ol>
<li> For setting text in <strong>strong font</strong> (normally interpreted as <strong>boldface</strong>) the tags <code>&lt;strong&gt;</code> and <code>&lt;/strong&gt;</code> have to be used.</li>
<li> For <em>emphasizing</em> text fragments <code>&lt;em&gt;</code> and <code>&lt;/em&gt;</code> has to be used.</li>
<li> Modelica terms such as expandable bus, array, etc. should not be emphasized anyhow.</li>
</ol>

<h4>Capitalization of Text</h4>

<ol>
<li> Table headers and entries should start with capital letters</li>
<li> Table entries should start with lower case letter if only text fragments are used.</li>
<li> Table and figure captions start with a capital letter</li>
</ol>

</html>"));
        end Format;

        class Structure "Structure"
          extends Modelica.Icons.Information;
          annotation(
            Documentation(info = "<html>

<h4>General</h4>

<ol>
<li> In the HTML documentation of any Modelica library, the headings <code>&lt;h1&gt;</code>,
     <code>&lt;h2&gt;</code> and <code>&lt;h3&gt;</code> should not be used, because they are utilized by
     the automatically generated documentation.
<li> The utilized heading format starts with <code>&lt;h4&gt;</code> and terminates with <code>&lt;/h4&gt;</code>, e.g.,
     <code>&lt;h4&gt;Description&lt;/h4&gt;</code> </li>
<li> The  <code>&lt;h4&gt;</code> and  <code>&lt;h5&gt;</code> headings must not be terminated by a colon (:).</li>
<li> For additional structuring <code>&lt;h5&gt;</code> and <code>&lt;/h5&gt;</code> may be used as demonstrated below.
</ol>

<h4>Structure</h4>
<p>
The following parts should be added to the documentation of each component:
</p>

<ol>
<li> General information without additional subsection explains how the class works</li>
<li> <b>Syntax</b> (for functions only): shows syntax of function call with minimum and full input parameters</li>
<li> <b>Implementation</b> (optional): explains how the implementation is made </li>
<li> <b>Limitations</b> (optional): explains the limitations of the component</li>
<li> <b>Notes</b> (optional): if required/useful </li>
<li> <b>Examples</b> (optional): if required/useful </li>
<li> <b>Acknowledgments</b> (optional): if required </li>
<li> <b>See also</b>: shows hyperlinks to related models </li>
<li> <b>Revision history</b> (optional): if required/intended for a package/model, the revision history
        should be placed in <code>annotation(Documentation(revisions=&quot;...&quot;));</code></li>
</ol>

<p>
These sections should appear in the listed order. The only exceptions are hierarchically structured notes and examples as explained in the following.
</p>

<h4>Additional notes and examples</h4>

<p>Some additional notes or examples may require additional <code>&lt;h5&gt;</code> headings. For either notes or examples the following cases may be applied:</p>

<h5>Example 1</h5>
<p>
This is an example of a single note.
</p>

<pre>
&lt;h5&gt;Note&lt;/h5&gt;
&lt;p&gt;This is the note.&lt;/p&gt;
</pre>

<h5>Example 2</h5>
<p>
This is an example of a very simple structure.
</p>

<pre>
&lt;h5&gt;Notes&lt;/h5&gt;
&lt;p&gt;This is the first note.&lt;/p&gt;
&lt;p&gt;This is the second note.&lt;/p&gt;
</pre>

<h5>Example 3</h5>

<p>
This example shows a more complex structure with enumeration.
</p>

<pre>
&lt;h5&gt;Note 1&lt;/h5&gt;
...
&lt;h5&gt;Note 2&lt;/h5&gt;
...
</pre>
<h4>Automatically created documentation</h4>
<p>
For parameters, connectors, as well as inputs and outputs of function automatic documentation is generated by the tool from the quoted comments.
</p>
</html>"));
        end Structure;
        annotation(
          Documentation(info = "<html>
<a href=\"http://www.w3c.org/\">HTML</a> documentation of Modelica classes.
</html>"));
      end Documentation;

      package ModelicaCode "Modelica code"
        extends Modelica.Icons.Information;

        class Format "Format"
          extends Modelica.Icons.Information;
          annotation(
            Documentation(info = "<html>

<ol>
<li> In the <b>icon</b> of a component the instance name is displayed
     (text string <code>%name</code>) in <b>blue color</b>.
     Parameter values, e.g., resistance, mass, gear ratio, are displayed
     in the icon in <b>black color</b> in a smaller font size as the instance name.</li>
<li> Comments and annotations always start with a capital letter, e.g.,
     <code><b>parameter</b> Real a = 1 \"Arbitrary factor\";</code></li>
</ol>

</html>"));
        end Format;

        class Naming "Naming convention"
          extends Modelica.Icons.Information;
          annotation(
            Documentation(info = "<html>

<ol>
<li> <b>Class and instance names</b> are usually written in upper and lower case
     letters, e.g., \"ElectricCurrent\". An underscore may be used in names.
     However, it has to be taken into account that the last underscore in a
     name might indicate that the following characters are rendered as a subscript.
     Example: \"pin_a\" may be rendered as \"pin<sub>a</sub>\".</li>

<li> <b>Class names</b> start always with an upper case letter,
     with the exception of functions, that start with a lower case letter.</li>

<li> <b>Instance names</b>, i.e., names of component instances and
     of variables (with the exception of constants),
     start usually with a lower case letter with only
     a few exceptions if this is common sense
     (such as <code>T</code> for a temperature variable).</li>

<li> <b>Constant names</b>, i.e., names of variables declared with the
     \"constant\" prefix, follow the usual naming conventions
     (= upper and lower case letters) and start usually with an
     upper case letter, e.g., UniformGravity, SteadyState.</li>

<li> The two <b>connectors</b> of a domain that have identical declarations
     and different icons are usually distinguished by <code>_a</code>, <code>_b</code>
     or <code>_p</code>, <code>_n</code>, e.g., <code>Flange_a</code>, <code>Flange_b</code>,
     <code>HeatPort_a</code>, <code>HeatPort_b</code>.</li>

<li> A <b>connector class</b> has the instance
     name definition in the diagram layer and not in the icon layer.</li>
</ol>

<h4>Variable names</h4>
<p>In the following table typical variable names are listed. This list should be completed.</p>

<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" >
   <caption align=\"bottom\">Variables and names</caption>
   <tr>
      <th>Variable</th>
      <th>Quantity</th>
    </tr>
     <tr>
      <td>a</td>
      <td>acceleration</td>
    </tr>
    <tr>
      <td>A</td>
      <td>area</td>
    </tr>
    <tr>
      <td>C</td>
      <td>capacitance</td>
    </tr>
    <tr>
      <td>d</td>
      <td>damping, density, diameter</td>
    </tr>
    <tr>
      <td>dp</td>
      <td>pressureDrop</td>
    </tr>
    <tr>
      <td>e</td>
      <td>specificEntropy</td>
    </tr>
    <tr>
      <td>E</td>
      <td>energy, entropy</td>
    </tr>
    <tr>
      <td>eta</td>
      <td>efficiency</td>
    </tr>
    <tr>
      <td>f</td>
      <td>force, frequency</td>
    </tr>
    <tr>
      <td>G</td>
      <td>conductance</td>
    </tr>
    <tr>
      <td>H</td>
      <td>enthalpy</td>
    </tr>
    <tr>
      <td>h</td>
      <td>height, specificEnthalpy</td>
    </tr>
    <tr>
      <td>HFlow</td>
      <td>enthalpyFlow</td>
    </tr>
    <tr>
      <td>i</td>
      <td>current</td>
    </tr>
    <tr>
      <td>J</td>
      <td>inertia</td>
    </tr>
    <tr>
      <td>l</td>
      <td>length</td>
    </tr>
    <tr>
      <td>L</td>
      <td>Inductance</td>
    </tr>
    <tr>
      <td>m</td>
      <td>mass</td>
    </tr>
    <tr>
      <td>M</td>
      <td>mutualInductance</td>
    </tr>
    <tr>
      <td>mFlow</td>
      <td>massFlow</td>
    </tr>
    <tr>
      <td>P</td>
      <td>power</td>
    </tr>
    <tr>
      <td>p</td>
      <td>pressure</td>
    </tr>
    <tr>
      <td>Q</td>
      <td>heat</td>
    </tr>
    <tr>
      <td>Qflow</td>
      <td>heatFlow</td>
    </tr>
    <tr>
      <td>r</td>
      <td>radius</td>
    </tr>
    <tr>
      <td>R</td>
      <td>radius, resistance</td>
    </tr>
    <tr>
      <td>t</td>
      <td>time</td>
    </tr>
    <tr>
      <td>T</td>
      <td>temperature</td>
    </tr>
    <tr>
      <td>tau</td>
      <td>torque</td>
    </tr>
    <tr>
      <td>U</td>
      <td>internalEnergy</td>
    </tr>
    <tr>
      <td>v</td>
      <td>electricPotential, specificVolume, velocity, voltage</td>
    </tr>
    <tr>
      <td>V</td>
      <td>volume</td>
    </tr>
    <tr>
      <td>w</td>
      <td>angularVelocity</td>
    </tr>
    <tr>
      <td>X</td>
      <td>reactance</td>
    </tr>
    <tr>
      <td>Z</td>
      <td>impedance</td>
    </tr>
</table>
</html>"));
        end Naming;
        annotation(
          Documentation(info = "<html>

<p>In this section the
<a href=\"modelica://Modelica.UsersGuide.Conventions.ModelicaCode.Naming\">naming conventions</a> of class and instance names, parameters and variables are specified. Additionally some
<a href=\"modelica://Modelica.UsersGuide.Conventions.ModelicaCode.Format\">format UsersGuide</a> are stated.</p>

</html>"));
      end ModelicaCode;

      package UsersGuide "User's Guide"
        extends Modelica.Icons.Information;

        class Implementation "Implementation notes"
          extends Modelica.Icons.Information;
          annotation(
            Documentation(info = "<html>
<p>
This class summarizes general information about the implementation which is not stated elsewhere.
</p>
<ol>
<li>The <code>&lt;caption&gt;</code> tag is currently not supported in some tools.</li>
<li>The <code>&amp;sim;</code> symbol (i.e., '&sim;' ) is currently not supported in some tools.</li>
<li>The <code>&amp;prop;</code> symbol (i.e., '&prop;' ) is currently not supported in some tools.</li>
</ol>
</html>"));
        end Implementation;

        class References "References"
          extends Modelica.Icons.References;
          annotation(
            Documentation(info = "<html>

<ol>
<li> Citation formats should be unified according to IEEE Transactions style.</li>
<li> Reference should be formatted as tables with two columns.</li>
</ol>

<p>In the following the reference formats will be explained based on five examples:</p>

<ul>
<li> Journal (or conference) [Gao2008] </li>
<li> Book [Andronov1973]</li>
<li> Master's thesis [Woehrnschimmel1998]</li>
<li> PhD thesis [Farnleitner1999]</li>
<li> Technical report [Marlino2005]</li>
</ul>

<p>The <a href=\"modelica://Modelica.UsersGuide.Conventions.Documentation.Format.References\">citation</a> is also explained.</p>

<h4>Example</h4>

<pre>
&lt;table border=\"0\" cellspacing=\"0\" cellpadding=\"2\"&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;[Gao2008]&lt;/td&gt;
      &lt;td valign=\"top\"&gt;Z. Gao, T. G. Habetler, R. G. Harley, and R. S. Colby,
        &quot;A sensorless  rotor temperature estimator for induction
                 machines based on a current harmonic spectral
                 estimation scheme,&quot;
        &lt;i&gt;IEEE Transactions on Industrial Electronics&lt;/i&gt;,
        vol. 55, no. 1, pp. 407-416, Jan. 2008.&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;[Andronov1973]&lt;/td&gt;
      &lt;td valign=\"top\"&gt;A. Andronov, E. Leontovich, I. Gordon, and A. Maier,
        &lt;i&gt;Theory of  Bifurcations of Dynamic Systems on a plane&lt;/i&gt;,
        1st ed. New York: J. Wiley &amp; Sons, 1973.&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;[Woehrnschimmel1998]&lt;/td&gt;
      &lt;td valign=\"top\"&gt;R. W&ouml;hrnschimmel,
        &quot;Simulation, modeling and fault detection for vector
              controlled induction machines,&quot;
        Master&#39;;s thesis, Vienna University of Technology,
        Vienna, Austria, 1998.&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;[Farnleitner1999]&lt;/td&gt;
      &lt;td valign=\"top\"&gt;E. Farnleitner,
        &quot;Computational ?uid dynamics analysis for rotating
              electrical machinery,&quot;
        Ph.D. dissertation, University of Leoben,
        Department  of Applied Mathematics, Leoben, Austria, 1999.&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;[Marlino2005]&lt;/td&gt;
      &lt;td valign=\"top\"&gt;L. D. Marlino,
        &quot;Oak ridge national laboratory annual progress report for the
              power electronics and electric machinery program,&quot;
      Oak Ridge National Laboratory, prepared for the U.S. Department of Energy,
      Tennessee, USA, Tech. Rep. FY2004 Progress Report, January 2005.&lt;/td&gt;
    &lt;/tr&gt;
&lt;/table&gt;</pre>

<p>appears as</p>

<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td valign=\"top\">[Gao08]</td>
      <td valign=\"top\">Z. Gao, T. G. Habetler, R. G. Harley, and R. S. Colby,
        &quot;A sensorless  rotor temperature estimator for induction
                 machines based on a current harmonic spectral
                 estimation scheme,&quot;
        <i>IEEE Transactions on Industrial Electronics</i>,
        vol. 55, no. 1, pp. 407-416, Jan. 2008.</td>
    </tr>
    <tr>
      <td valign=\"top\">[Andronov1973]</td>
      <td valign=\"top\">A. Andronov, E. Leontovich, I. Gordon, and A. Maier,
        <i>Theory of  Bifurcations of Dynamic Systems on a plane</i>,
        1st ed. New York: J. Wiley &amp; Sons, 1973.</td>
    </tr>
    <tr>
      <td valign=\"top\">[Woehrnschimmel1998]</td>
      <td valign=\"top\">R. W&ouml;hrnschimmel,
        &quot;Simulation, modeling and fault detection for vector
              controlled induction machines,&quot;
        Master&#39;;s thesis, Vienna University of Technology,
        Vienna, Austria, 1998.</td>
    </tr>
    <tr>
      <td valign=\"top\">[Farnleitner1999]</td>
      <td valign=\"top\">E. Farnleitner,
        &quot;Computational Fluid dynamics analysis for rotating
              electrical machinery,&quot;
        Ph.D. dissertation, University of Leoben,
        Department  of Applied Mathematics, Leoben, Austria, 1999.</td>
    </tr>
    <tr>
      <td valign=\"top\">[Marlino2005]</td>
      <td valign=\"top\">L. D. Marlino,
        &quot;Oak ridge national laboratory annual progress report for the
              power electronics and electric machinery program,&quot;
      Oak Ridge National Laboratory, prepared for the U.S. Department of Energy,
      Tennessee, USA, Tech. Rep. FY2004 Progress Report, January 2005.</td>
    </tr>
</table>

</html>"));
        end References;

        class Contact "Contact"
          extends Modelica.Icons.Contact;
          annotation(
            Documentation(info = "<html>

<p>
This class summarizes contact information of the contributing persons.
</p>

<h5>Example</h5>

<pre>
&lt;p&gt;This package is developed an maintained by the following contributors&lt;/p&gt;
  &lt;table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
    &lt;tr&gt;
      &lt;th&gt;&lt;/th&gt;
      &lt;th&gt;Name&lt;/th&gt;
      &lt;th&gt;Affiliation&lt;/th&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;Library officer&lt;/td&gt;
      &lt;td valign=\"top\"&gt;
      &lt;a href=\"mailto:a.haumer@haumer.at\"&gt;A. Haumer&lt;/a&gt;
      &lt;/td&gt;
      &lt;td valign=\"top\"&gt;
        &lt;a href=\"http://www.haumer.at\"&gt;Technical Consulting &amp;amp; Electrical Engineering&lt;/a&gt;&lt;br&gt;
        3423 St.Andrae-Woerdern&lt;br&gt;
        Austria
      &lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;Contributor&lt;/td&gt;
      &lt;td valign=\"top\"&gt;
        &lt;a href=\"mailto:dr.christian.kral@gmail.com\"&gt;C. Kral&lt;/a&gt;
      &lt;/td&gt;
      &lt;td valign=\"top\"&gt;
        &lt;a href=\"http://christiankral.net\"&gt;Electric Machines, Drives and Systems&lt;/a&gt;&lt;br&gt;
        1060 Vienna&lt;br&gt;
        Austria
      &lt;/td&gt;
    &lt;/tr&gt;
  &lt;/table&gt;</pre>


<p>appears as</p>

<p>This package is developed an maintained by the following contributors</p>
  <table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <th></th>
      <th>Name</th>
      <th>Affiliation</th>
    </tr>
    <tr>
      <td valign=\"top\">Library officer</td>
      <td valign=\"top\">
      <a href=\"mailto:a.haumer@haumer.at\">A. Haumer</a>
      </td>
      <td valign=\"top\">
        <a href=\"http://www.haumer.at\">Technical Consulting &amp; Electrical Engineering</a><br>
        3423 St.Andrae-Woerdern<br>
        Austria
      </td>
    </tr>
    <tr>
      <td valign=\"top\">Contributor</td>
      <td valign=\"top\">
        <a href=\"mailto:dr.christian.kral@gmail.com\">C. Kral</a>
      </td>
      <td valign=\"top\">
        <a href=\"http://christiankral.net\">Electric Machines, Drives and Systems</a><br>
        1060 Vienna<br>
        Austria
      </td>
    </tr>
    <tr>
      <td valign=\"top\">Contributor</td>
      <td valign=\"top\">
        <a href=\"http://www.linkedin.com/in/dietmarw\">D. Winkler</a>
      </td>
      <td valign=\"top\">
        <a href=\"http://www.hit.no\">Telemark University College</a><br>
        PO box 203<br>
        3901 Porsgrunn<br>
        Norway
      </td>
    </tr>
  </table>

</html>"));
        end Contact;

        class RevisionHistory "Revision History"
          extends Modelica.Icons.ReleaseNotes;
          annotation(
            Documentation(info = "<html>

<ol>
<li> The revision history needs to answer the question:
     What has changed and what are the improvements over the previous versions and revision.</li>
<li> The revision history includes the documentation of the development history of each class and/or package.</li>
<li> Version number, revision number, date, author and comments shall be included.</li>
</ol>

<h5>Example</h5>

<pre>
&lt;table border=\"1\" cellspacing=\"0\" cellpadding=\"2\"&gt;
    &lt;tr&gt;
      &lt;th&gt;Version&lt;/th&gt;
      &lt;th&gt;Revision&lt;/th&gt;
      &lt;th&gt;Date&lt;/th&gt;
      &lt;th&gt;Author&lt;/th&gt;
      &lt;th&gt;Comment&lt;/th&gt;
    &lt;/tr&gt;
    ...
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;1.0.1&lt;/td&gt;
      &lt;td valign=\"top\"&gt;828&lt;/td&gt;
      &lt;td valign=\"top\"&gt;2008-05-26&lt;/td&gt;
      &lt;td valign=\"top\"&gt;A. Haumer&lt;br&gt;C. Kral&lt;/td&gt;
      &lt;td valign=\"top\"&gt;Fixed bug in documentation&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;td valign=\"top\"&gt;1.0.0&lt;/td&gt;
      &lt;td valign=\"top\"&gt;821&lt;/td&gt;
      &lt;td valign=\"top\"&gt;2008-05-21&lt;/td&gt;
      &lt;td valign=\"top\"&gt;A. Haumer&lt;/td&gt;
      &lt;td valign=\"top\"&gt;&lt;/td&gt;
    &lt;/tr&gt;
&lt;/table&gt;</pre>

<p>This code appears then as in the \"Revisions\" section below.</p>

</html>", revisions = "<html>
<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <th>Version</th>
      <th>Revision</th>
      <th>Date</th>
      <th>Author</th>
      <th>Comment</th>
    </tr>
    <tr>
      <td valign=\"top\">1.1.0</td>
      <td valign=\"top\"></td>
      <td valign=\"top\">2010-04-22</td>
      <td valign=\"top\">C. Kral</td>
      <td valign=\"top\">Migrated Conventions to UsersGuide of MSL</td>
    </tr>
    <tr>
      <td valign=\"top\">1.0.5</td>
      <td valign=\"top\">3540</td>
      <td valign=\"top\">2010-03-11</td>
      <td valign=\"top\">D. Winkler</td>
      <td valign=\"top\">Updated image links guide to new 'modelica://' URIs, added contact details</td>
    </tr>
    <tr>
      <td valign=\"top\">1.0.4</td>
      <td valign=\"top\">2960</td>
      <td valign=\"top\">2009-09-28</td>
      <td valign=\"top\">C. Kral</td>
      <td valign=\"top\">Applied new rules for equations as discussed on the 63rd Modelica Design Meeting</td>
    </tr>
    <tr>
      <td valign=\"top\">1.0.3</td>
      <td valign=\"top\">2579</td>
      <td valign=\"top\">2008-05-26</td>
      <td valign=\"top\">D. Winkler</td>
      <td valign=\"top\">Layout fixes and enhancements</td>
    </tr>
    <tr>
      <td valign=\"top\">1.0.1</td>
      <td valign=\"top\">828</td>
      <td valign=\"top\">2008-05-26</td>
      <td valign=\"top\">A. Haumer<br>C. Kral</td>
      <td valign=\"top\">Fixed bug in documentation</td>
    </tr>
    <tr>
      <td valign=\"top\">1.0.0</td>
      <td valign=\"top\">821</td>
      <td valign=\"top\">2008-05-21</td>
      <td valign=\"top\">A. Haumer</td>
      <td valign=\"top\"></td>
    </tr>
</table>
</html>"));
        end RevisionHistory;
        annotation(
          Documentation(info = "<html>
<p>The UsersGuide of each package should consist of the following classes</p>
<ol>
<li> <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.Contact\">Contact</a> information of
     the library officer and the co-authors </li>
<li> Optional <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.Implementation\">Implementation Notes</a> to give general information about the implementation
<li> <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.References\">References</a> for summarizing the literature of the package</li>
<li> <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide.RevisionHistory\">Revision history </a> to summarize the most important changes and improvements of the package</li>
</ol>
</html>"));
      end UsersGuide;
      annotation(
        DocumentationClass = true,
        Documentation(info = "<html>
<p>A Modelica main package should be compliant with the UsersGuide stated in this documentation:</p>
<ol>
<li> Conventions of the <a href=\"modelica://Modelica.UsersGuide.Conventions.ModelicaCode\">Modelica code</a> </li>
<li> Consistent HTML documentation <a href=\"modelica://Modelica.UsersGuide.Conventions.Documentation\">UsersGuide</a> </li>
<li> Structure to be provided by a main package
<ul>
     <li> <a href=\"modelica://Modelica.UsersGuide.Conventions.UsersGuide\">User's Guide</a></li>
     <li> <b>Examples</b> containing models demonstrating the usage of the library.</li>
     <li> <b>Components</b> -- in case of a complex library a more detailed structure can be established.</li>
     <li> <b>Sensors</b></li>
     <li> <b>Sources</b></li>
     <li> <b>Interfaces</b> containing connectors and partial models.</li>
     <li> <b>Types</b> containing type, enumeration and choice definitions.</li>
</ul></li>
<li> These packages should appear in the listed order.</li>
</ol>
</html>"));
    end Conventions;

    class ParameterDefaults "Parameter defaults"
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>

<p>
In this section the convention is summarized how default parameters are
handled in the Modelica Standard Library (since version 3.0).
</p>

<p>
Many models in this library have parameter declarations to define
constants of a model that might be changed before simulation starts.
Example:
</p>

<blockquote>
<pre>
<b>model</b> SpringDamper
<b>parameter</b> Real c(final unit=\"N.m/rad\")    = 1e5 \"Spring constant\";
<b>parameter</b> Real d(final unit=\"N.m.s/rad\")  = 0   \"Damping constant\";
<b>parameter</b> Modelica.SIunits.Angle phi_rel0 = 0   \"Unstretched spring angle\";
...
<b>end</b> SpringDamper;
</pre>
</blockquote>

<p>
In Modelica it is possible to define a default value of a parameter in
the parameter declaration. In the example above, this is performed for
all parameters. Providing default values for all parameters can lead to
errors that are difficult to detect, since a modeler may have forgotten
to provide a meaningful value (the model simulates but gives wrong
results due to wrong parameter values). In general the following basic
situations are present:
</p>

<ol>
<li> The parameter value could be anything (e.g., a spring constant or
  a resistance value) and therefore the user should provide a value in
  all cases. A Modelica translator should warn, if no value is provided.
</li>

<li> The parameter value is not changed in &gt; 95 % of the cases
  (e.g., initialization or visualization parameters, or parameter phi_rel0
  in the example above). In this case a default parameter value should be
  provided, in order that the model or function can be conveniently
  used by a modeler.
</li>

<li> A modeler would like to quickly utilize a model, e.g.,
  <ul>
  <li> to automatically check that the model still translates and/or simulates
    (after some changes in the library),</li>
  <li> to make a quick demo of a library by drag-and-drop of components,</li>
  <li> to implement a simple test model in order to get a better understanding
    of the desired component.</li>
  </ul>
  In all these cases, it would be not practical, if the modeler would
  have to provide explicit values for all parameters first.
  </li>
</ol>

<p>
To handle the conflicting goals of (1) and (3), the Modelica Standard Library
uses two approaches to define default parameters, as demonstrated with the
following example:
</p>

<blockquote>
<pre>
<b>model</b> SpringDamper
<b>parameter</b> Real c(final unit=\"N.m/rad\"  , start=1e5) \"Spring constant\";
<b>parameter</b> Real d(final unit=\"N.m.s/rad\", start=  0) \"Damping constant\";
<b>parameter</b> Modelica.SIunits.Angle phi_rel0 = 0       \"Unstretched spring angle\";
...
<b>end</b> SpringDamper;

SpringDamper sp1;              // warning for \"c\" and \"d\"
SpringDamper sp2(c=1e4, d=0);  // fine, no warning
</pre>
</blockquote>

<p>
Both definition forms, using a \"start\" value (for \"c\" and \"d\") and providing
a declaration equation (for \"phi_rel0\"), are valid Modelica and define the value
of the parameter. By convention, it is expected that Modelica translators will
trigger a warning message for parameters that are <b>not</b> defined by a declaration
equation, by a modifier equation or in an initial equation/algorithm section.
A Modelica translator might have options to change this behavior, especially,
that no messages are printed in such cases and/or that an error is triggered
instead of a warning.
</p>

</html>"));
    end ParameterDefaults;

    class ModelicaLicense2 "Modelica License 2"
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>
<head>
<title>The Modelica License 2</title>
<style type=\"text/css\">
*       { font-size: 10pt; font-family: Arial,sans-serif; }
code    { font-size:  9pt; font-family: Courier,monospace;}
h6      { font-size: 10pt; font-weight: bold; color: green; }
h5      { font-size: 11pt; font-weight: bold; color: green; }
h4      { font-size: 13pt; font-weight: bold; color: green; }
address {                  font-weight: normal}
td      { solid #000; vertical-align:top; }
th      { solid #000; vertical-align:top; font-weight: bold; }
table   { solid #000; border-collapse: collapse;}
</style>
</head>

<p>All files in this directory (Modelica) and in all
subdirectories, especially all files that build package \"Modelica\" and all
files in \"Modelica/Resources/*\" and \"Modelica/help\" are licensed by the <b><u>Modelica Association</u></b> under the <b><u>Modelica License 2</u></b> (with exception of files
\"Modelica/Resources/C-Sources/win32_dirent.*, ModelicaMatIO.*, ModelicaStandardTables.*\").</p>

<p style=\"margin-left: 40px;\"><b>Licensor:</b><br>
Modelica Association<br>
(Ideella F&ouml;reningar 822003-8858 in Link&ouml;ping) <br>
c/o PELAB, IDA, Link&ouml;pings Universitet <br>
S-58183 Link&ouml;ping <br>
Sweden<br>
email: Board@Modelica.org<br>
web: <a href=\"https://www.Modelica.org\">https://www.Modelica.org</a></p>

<p style=\"margin-left: 40px;\"><b>Copyright notices of the files:</b><br/>
Copyright &copy; 1998-2015,
ABB, Austrian Institute of Technology, T.&nbsp;B&ouml;drich, DLR, Dassault Syst&egrave;mes AB, Fraunhofer, A.&nbsp;Haumer, ITI, Modelon,
TU Hamburg-Harburg, Politecnico di Milano, XRG Simulation.
</p>

<p>
<a href=\"#The_Modelica_License_2-outline\">The Modelica License 2</a><br>
<a href=\"#Frequently_Asked_Questions-outline\">Frequently Asked Questions</a><br>
</p>

<hr>

<h4><a name=\"The_Modelica_License_2-outline\"></a>The Modelica License 2</h4>

<p>
<b>Preamble.</b> The goal of this license is that Modelica related
model libraries, software, images, documents, data files etc. can be
used freely in the original or a modified form, in open source and in
commercial environments (as long as the license conditions below are
fulfilled, in particular sections 2c) and 2d). The Original Work is
provided free of charge and the use is completely at your own risk.
Developers of free Modelica packages are encouraged to utilize this
license for their work.</p>

<p>
The Modelica License applies to any Original Work that contains the
following licensing notice adjacent to the copyright notice(s) for
this Original Work:</p>

<p><b>Licensed by the Modelica Association under the Modelica License 2</b></p>

<p><b>1. Definitions.</b></p>
<ol type=\"a\">
  <li>&ldquo;License&rdquo; is this Modelica License.</li>

  <li>&ldquo;Original Work&rdquo; is any work of authorship, including
  software, images, documents, data files, that contains the above
  licensing notice or that is packed together with a licensing notice
  referencing it.</li>

  <li>&ldquo;Licensor&rdquo; is the provider of the Original Work who has
  placed this licensing notice adjacent to the copyright notice(s) for
  the Original Work. The Original Work is either directly provided by
  the owner of the Original Work, or by a licensee of the owner.</li>

  <li>&ldquo;Derivative Work&rdquo; is any modification of the Original
  Work which represents, as a whole, an original work of authorship.
  For the matter of clarity and as examples:

  <ol  type=\"A\">
    <li>Derivative Work shall not include work that remains separable from
    the Original Work, as well as merely extracting a part of the
    Original Work without modifying it.</li>

    <li>Derivative Work shall not include (a) fixing of errors and/or (b)
    adding vendor specific Modelica annotations and/or (c) using a
    subset of the classes of a Modelica package, and/or (d) using a
    different representation, e.g., a binary representation.</li>

    <li>Derivative Work shall include classes that are copied from the
    Original Work where declarations, equations or the documentation
    are modified.</li>

    <li>Derivative Work shall include executables to simulate the models
    that are generated by a Modelica translator based on the Original
    Work (of a Modelica package).</li>
  </ol>

  <li>&ldquo;Modified Work&rdquo; is any modification of the Original Work
  with the following exceptions: (a) fixing of errors and/or (b)
  adding vendor specific Modelica annotations and/or (c) using a
  subset of the classes of a Modelica package, and/or (d) using a
  different representation, e.g., a binary representation.</li>

  <li>&quot;Source Code&quot; means the preferred form of the Original
  Work for making modifications to it and all available documentation
  describing how to modify the Original Work.</li>

  <li>&ldquo;You&rdquo; means an individual or a legal entity exercising
  rights under, and complying with all of the terms of, this License.</li>

  <li>&ldquo;Modelica package&rdquo; means any Modelica library that is
  defined with the &ldquo;<code><b>package</b>&nbsp;&lt;Name&gt;&nbsp;...&nbsp;<b>end</b>&nbsp;&lt;Name&gt;;</code>&rdquo; Modelica language element.</li>

</ol>

<p>
<b>2. Grant of Copyright License.</b> Licensor grants You a
worldwide, royalty-free, non-exclusive, sublicensable license, for
the duration of the copyright, to do the following:</p>

<ol type=\"a\">
  <li><p>
  To reproduce the Original Work in copies, either alone or as part of
  a collection.</p></li>
  <li><p>
  To create Derivative Works according to Section 1d) of this License.</p></li>
  <li><p>
  To distribute or communicate to the public copies of the <u>Original
  Work</u> or a <u>Derivative Work</u> under <u>this License</u>. No
  fee, neither as a copyright-license fee, nor as a selling fee for
  the copy as such may be charged under this License. Furthermore, a
  verbatim copy of this License must be included in any copy of the
  Original Work or a Derivative Work under this License.<br>
  For the matter of clarity, it is permitted A) to distribute or
  communicate such copies as part of a (possible commercial)
  collection where other parts are provided under different licenses
  and a license fee is charged for the other parts only and B) to
  charge for mere printing and shipping costs.</p></li>
  <li><p>
  To distribute or communicate to the public copies of a <u>Derivative
  Work</u>, alternatively to Section 2c), under <u>any other license</u>
  of your choice, especially also under a license for
  commercial/proprietary software, as long as You comply with Sections
  3, 4 and 8 below. <br>      For the matter of clarity, no
  restrictions regarding fees, either as to a copyright-license fee or
  as to a selling fee for the copy as such apply.</p></li>
  <li><p>
  To perform the Original Work publicly.</p></li>
  <li><p>
  To display the Original Work publicly.</p></li>
</ol>

<p>
<b>3. Acceptance.</b> Any use of the Original Work or a
Derivative Work, or any action according to either Section 2a) to 2f)
above constitutes Your acceptance of this License.</p>

<p>
<b>4. Designation of Derivative Works and of Modified Works.
</b>The identifying designation of Derivative Work and of Modified
Work must be different to the corresponding identifying designation
of the Original Work. This means especially that the (root-level)
name of a Modelica package under this license must be changed if the
package is modified (besides fixing of errors, adding vendor specific
Modelica annotations, using a subset of the classes of a Modelica
package, or using another representation, e.g. a binary
representation).</p>

<p>
<b>5. Grant of Patent License.</b>
Licensor grants You a worldwide, royalty-free, non-exclusive, sublicensable license,
under patent claims owned by the Licensor or licensed to the Licensor by
the owners of the Original Work that are embodied in the Original Work
as furnished by the Licensor, for the duration of the patents,
to make, use, sell, offer for sale, have made, and import the Original Work
and Derivative Works under the conditions as given in Section 2.
For the matter of clarity, the license regarding Derivative Works covers
patent claims to the extent as they are embodied in the Original Work only.</p>

<p>
<b>6. Provision of Source Code.</b> Licensor agrees to provide
You with a copy of the Source Code of the Original Work but reserves
the right to decide freely on the manner of how the Original Work is
provided.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For the matter of clarity, Licensor might provide only a binary
representation of the Original Work. In that case, You may (a) either
reproduce the Source Code from the binary representation if this is
possible (e.g., by performing a copy of an encrypted Modelica
package, if encryption allows the copy operation) or (b) request the
Source Code from the Licensor who will provide it to You.</p>

<p>
<b>7. Exclusions from License Grant.</b> Neither the names of
Licensor, nor the names of any contributors to the Original Work, nor
any of their trademarks or service marks, may be used to endorse or
promote products derived from this Original Work without express
prior permission of the Licensor. Except as otherwise expressly
stated in this License and in particular in Sections 2 and 5, nothing
in this License grants any license to Licensor&rsquo;s trademarks,
copyrights, patents, trade secrets or any other intellectual
property, and no patent license is granted to make, use, sell, offer
for sale, have made, or import embodiments of any patent claims.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No license is granted to the trademarks of
Licensor even if such trademarks are included in the Original Work,
except as expressly stated in this License. Nothing in this License
shall be interpreted to prohibit Licensor from licensing under terms
different from this License any Original Work that Licensor otherwise
would have a right to license.</p>

<p>
<b>8. Attribution Rights.</b> You must retain in the Source
Code of the Original Work and of any Derivative Works that You
create, all author, copyright, patent, or trademark notices, as well
as any descriptive text identified therein as an &quot;Attribution
Notice&quot;. The same applies to the licensing notice of this
License in the Original Work. For the matter of clarity, &ldquo;author
notice&rdquo; means the notice that identifies the original
author(s). <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;You must cause the Source Code for any Derivative
Works that You create to carry a prominent Attribution Notice
reasonably calculated to inform recipients that You have modified the
Original Work. <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In case the Original Work or Derivative Work is not provided in
Source Code, the Attribution Notices shall be appropriately
displayed, e.g., in the documentation of the Derivative Work.</p>

<p><b>9. Disclaimer
of Warranty. <br></b><u><b>The Original Work is provided under this
License on an &quot;as is&quot; basis and without warranty, either
express or implied, including, without limitation, the warranties of
non-infringement, merchantability or fitness for a particular
purpose. The entire risk as to the quality of the Original Work is
with You.</b></u> This disclaimer of warranty constitutes an
essential part of this License. No license to the Original Work is
granted by this License except under this disclaimer.</p>

<p>
<b>10. Limitation of Liability.</b> Under no circumstances and
under no legal theory, whether in tort (including negligence),
contract, or otherwise, shall the Licensor, the owner or a licensee
of the Original Work be liable to anyone for any direct, indirect,
general, special, incidental, or consequential damages of any
character arising as a result of this License or the use of the
Original Work including, without limitation, damages for loss of
goodwill, work stoppage, computer failure or malfunction, or any and
all other commercial damages or losses. This limitation of liability
shall not apply to the extent applicable law prohibits such
limitation.</p>

<p>
<b>11. Termination.</b> This License conditions your rights to
undertake the activities listed in Section 2 and 5, including your
right to create Derivative Works based upon the Original Work, and
doing so without observing these terms and conditions is prohibited
by copyright law and international treaty. Nothing in this License is
intended to affect copyright exceptions and limitations. This License
shall terminate immediately and You may no longer exercise any of the
rights granted to You by this License upon your failure to observe
the conditions of this license.</p>

<p>
<b>12. Termination for Patent Action.</b> This License shall
terminate automatically and You may no longer exercise any of the
rights granted to You by this License as of the date You commence an
action, including a cross-claim or counterclaim, against Licensor,
any owners of the Original Work or any licensee alleging that the
Original Work infringes a patent. This termination provision shall
not apply for an action alleging patent infringement through
combinations of the Original Work under combination with other
software or hardware.</p>

<p>
<b>13. Jurisdiction.</b> Any action or suit relating to this
License may be brought only in the courts of a jurisdiction wherein
the Licensor resides and under the laws of that jurisdiction
excluding its conflict-of-law provisions. The application of the
United Nations Convention on Contracts for the International Sale of
Goods is expressly excluded. Any use of the Original Work outside the
scope of this License or after its termination shall be subject to
the requirements and penalties of copyright or patent law in the
appropriate jurisdiction. This section shall survive the termination
of this License.</p>

<p>
<b>14. Attorneys&rsquo; Fees.</b> In any action to enforce the
terms of this License or seeking damages relating thereto, the
prevailing party shall be entitled to recover its costs and expenses,
including, without limitation, reasonable attorneys' fees and costs
incurred in connection with such action, including any appeal of such
action. This section shall survive the termination of this License.</p>

<p>
<b>15. Miscellaneous.</b>
</p>
<ol type=\"a\">
  <li>If any
  provision of this License is held to be unenforceable, such
  provision shall be reformed only to the extent necessary to make it
  enforceable.</li>

  <li>No verbal
  ancillary agreements have been made. Changes and additions to this
  License must appear in writing to be valid. This also applies to
  changing the clause pertaining to written form.</li>

  <li>You may use the
  Original Work in all ways not otherwise restricted or conditioned by
  this License or by law, and Licensor promises not to interfere with
  or be responsible for such uses by You.</li>
</ol>

<hr>

<h5><a name=\"Frequently_Asked_Questions-outline\"></a>
Frequently Asked Questions</h5>
<p>This
section contains questions/answer to users and/or distributors of
Modelica packages and/or documents under Modelica License 2. Note,
the answers to the questions below are not a legal interpretation of
the Modelica License 2. In case of a conflict, the language of the
license shall prevail.</p>

<h6>Using or Distributing a Modelica <u>Package</u> under the Modelica License 2</h6>

<p><b>What are the main
differences to the previous version of the Modelica License?</b></p>
<ol>
  <li><p>
  Modelica License 1 is unclear whether the licensed Modelica package
  can be distributed under a different license. Version 2 explicitly
  allows that &ldquo;Derivative Work&rdquo; can be distributed under
  any license of Your choice, see examples in Section 1d) as to what
  qualifies as Derivative Work (so, version 2 is clearer).</p>
  <li><p>
  If You modify a Modelica package under Modelica License 2 (besides
  fixing of errors, adding vendor specific Modelica annotations, using
  a subset of the classes of a Modelica package, or using another
  representation, e.g., a binary representation), you must rename the
  root-level name of the package for your distribution. In version 1
  you could keep the name (so, version 2 is more restrictive). The
  reason of this restriction is to reduce the risk that Modelica
  packages are available that have identical names, but different
  functionality.</p>
  <li><p>
  Modelica License 1 states that &ldquo;It is not allowed to charge a
  fee for the original version or a modified version of the software,
  besides a reasonable fee for distribution and support&rdquo;.
  Version 2 has a similar intention for all Original Work under
  <u>Modelica License 2</u> (to remain free of charge and open source)
  but states this more clearly as &ldquo;No fee, neither as a
  copyright-license fee, nor as a selling fee for the copy as such may
  be charged&rdquo;. Contrary to version 1, Modelica License 2 has no
  restrictions on fees for Derivative Work that is provided under a
  different license (so, version 2 is clearer and has fewer
  restrictions).</p>
  <li><p>
  Modelica License 2 introduces several useful provisions for the
  licensee (articles 5, 6, 12), and for the licensor (articles 7, 12,
  13, 14) that have no counter part in version 1.</p>
  <li><p>
  Modelica License 2 can be applied to all type of work, including
  documents, images and data files, contrary to version 1 that was
  dedicated for software only (so, version 2 is more general).</p>
</ol>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) as part of my commercial
Modelica modeling and simulation environment?</b></p>
<p>Yes,
according to Section 2c). However, you are not allowed to charge a
fee for this part of your environment. Of course, you can charge for
your part of the environment.
</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different
license?</b></p>
<p>No.
The license of an unmodified Modelica package cannot be changed
according to Sections 2c) and 2d). This means that you cannot <u>sell</u>
copies of it, any distribution has to be free of charge.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first encrypt the package?</b></p>
<p>No.
Merely encrypting a package does not qualify for Derivative Work and
therefore the encrypted package has to stay under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first add classes to the package?</b></p>
<p>No.
The package itself remains unmodified, i.e., it is Original Work, and
therefore the license for this part must remain under Modelica
License 2. The newly added classes can be, however, under a different
license.
</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it </b><u><b>unmodified</b></u><b> in a Modelica package
under a </b><u><b>commercial/proprietary license</b></u><b>?</b></p>
<p>No,
according to article 2c). However, you can include model, block,
function, package, record and connector classes in your Modelica
package under <u>Modelica License 2</u>. This means that your
Modelica package could be under a commercial/proprietary license, but
one or more classes of it are under Modelica License 2.<br>Note, a
&ldquo;type&rdquo; class (e.g., type Angle = Real(unit=&rdquo;rad&rdquo;))
can be copied and included unmodified under a commercial/proprietary
license (for details, see the next question).</p>

<p><b>Can
I copy a type class or </b><u><b>part</b></u><b> of a model, block,
function, record, connector class, out of a Modelica package (under
Modelica License 2) and include it modified or unmodified in a
Modelica package under a </b><u><b>commercial/proprietary</b></u><b>
license</b></p>
<p>Yes,
according to article 2d), since this will in the end usually qualify
as Derivative Work. The reasoning is the following: A type class or
part of another class (e.g., an equation, a declaration, part of a
class description) cannot be utilized &ldquo;by its own&rdquo;. In
order to make this &ldquo;usable&rdquo;, you have to add additional
code in order that the class can be utilized. This is therefore
usually Derivative Work and Derivative Work can be provided under a
different license. Note, this only holds, if the additional code
introduced is sufficient to qualify for Derivative Work. Merely, just
copying a class and changing, say, one character in the documentation
of this class would be no Derivative Work and therefore the copied
code would have to stay under Modelica License 2.</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it in </b><u><b>modified </b></u><b>form in a
</b><u><b>commercial/proprietary</b></u><b> Modelica package?</b></p>
<p>Yes.
If the modification can be seen as a &ldquo;Derivative Work&rdquo;,
you can place it under your commercial/proprietary license. If the
modification does not qualify as &ldquo;Derivative Work&rdquo; (e.g.,
bug fixes, vendor specific annotations), it must remain under
Modelica License 2. This means that your Modelica package could be
under a commercial/proprietary license, but one or more parts of it
are under Modelica License 2.</p>

<p><b>Can I distribute a
&ldquo;save total model&rdquo; under my commercial/proprietary
license, even if classes under Modelica License 2 are included?</b></p>
<p>Your
classes of the &ldquo;save total model&rdquo; can be distributed
under your commercial/proprietary license, but the classes under
Modelica License 2 must remain under Modelica License 2. This means
you can distribute a &ldquo;save total model&rdquo;, but some parts
might be under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) in encrypted form?</b></p>
<p>Yes.
Note, if the encryption does not allow &ldquo;copying&rdquo; of
classes (in to unencrypted Modelica source code), you have to send
the Modelica source code of this package to your customer, if he/she
wishes it, according to article&nbsp;6.</p>

<p><b>Can I distribute an
executable under my commercial/proprietary license, if the model from
which the executable is generated uses models from a Modelica package
under Modelica License 2?</b></p>
<p>Yes,
according to article 2d), since this is seen as Derivative Work. The
reasoning is the following: An executable allows the simulation of a
concrete model, whereas models from a Modelica package (without
pre-processing, translation, tool run-time library) are not able to
be simulated without tool support. By the processing of the tool and
by its run-time libraries, significant new functionality is added (a
model can be simulated whereas previously it could not be simulated)
and functionality available in the package is removed (e.g., to build
up a new model by dragging components of the package is no longer
possible with the executable).</p>

<p><b>Is my modification to
a Modelica package (under Modelica License 2) a Derivative Work?</b></p>
<p>It
is not possible to give a general answer to it. To be regarded as &quot;an
original work of authorship&quot;, a derivative work must be
different enough from the original or must contain a substantial
amount of new material. Making minor changes or additions of little
substance to a preexisting work will not qualify the work as a new
version for such purposes.
</p>

<h6>Using or Distributing a Modelica <u>Document</u> under the Modelica License 2</h6>

<p>This
section is devoted especially for the following applications:</p>
<ol type=\"a\">
  <li><p>
  A Modelica tool extracts information out of a Modelica package and
  presents the result in form of a &ldquo;manual&rdquo; for this
  package in, e.g., html, doc, or pdf format.</p>
  <li><p>
  The Modelica language specification is a document defining the
  Modelica language. It will be licensed under Modelica License 2.</p>
  <li><p>
  Someone writes a book about the Modelica language and/or Modelica
  packages and uses information which is available in the Modelica
  language specification and/or the corresponding Modelica package.</p>
</ol>

<p><b>Can I sell a manual
that was basically derived by extracting information automatically
from a Modelica package under Modelica License 2 (e.g., a &ldquo;reference
guide&rdquo; of the Modelica Standard Library):</b></p>
<p>Yes.
Extracting information from a Modelica package, and providing it in a
human readable, suitable format, like html, doc or pdf format, where
the content is significantly modified (e.g. tables with interface
information are constructed from the declarations of the public
variables) qualifies as Derivative Work and there are no restrictions
to charge a fee for Derivative Work under alternative 2d).</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it </b><u><b>unmodified</b></u><b> in my document
(e.g. the Modelica syntax description in the Modelica Specification)?</b></p>
<p>Yes.
In case you distribute your document, the copied parts are still
under Modelica License 2 and you are not allowed to charge a license
fee for this part. You can, of course, charge a fee for the rest of
your document.</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it in </b><u><b>modified</b></u><b> form in my
document?</b></p>
<p>Yes,
the creation of Derivative Works is allowed. In case the content is
significantly modified this qualifies as Derivative Work and there
are no restrictions to charge a fee for Derivative Work under
alternative 2d).</p>

<p><b>Can I sell a printed
version of a Modelica document (under Modelica License 2), e.g., the
Modelica Language Specification?</b></p>
<p>No,
if you are not the copyright-holder, since article 2c) does not allow
a selling fee for a (in this case physical) copy. However, mere
printing and shipping costs may be recovered.</p>
</html>"));
    end ModelicaLicense2;

    package ReleaseNotes "Release notes"
      extends Modelica.Icons.ReleaseNotes;

      class VersionManagement "Version Management"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>
Maintenance of the Modelica Standard Library is performed with
three branches on the subversion server of the Modelica Association
(<a href=\"https://svn.modelica.org/projects/Modelica\">https://svn.modelica.org/projects/Modelica</a>):
</p>

<h4>Released branch</h4>
<p>
Example: \"/tags/v3.0.1/Modelica\"
</p>

<p>
This branch contains the released Modelica versions (e.g., version 3.0.1),
where all available test cases and compatibility checks with other Modelica
libraries have been performed on the respective release. This version is
usually shipped with a Modelica modeling and simulation environment and
utilized by a Modelica user.
</p>

<h4>Development branch</h4>
<p>
Example: \"/trunk/Modelica\"
</p>

<p>
This branch contains the actual development version, i.e., all bug fixes
and new features based on the last Modelica release.
New features should have been tested before including them.
However, the exhaustive tests for a new version are (usually) not performed.
This version is usually only be used by the developers of the
Modelica Standard Library and is not utilized by Modelica users.
</p>

<h4>Maintenance branch</h4>
<p>
Example: \"/branches/maintenance/3.0.1/Modelica\"
</p>

<p>
This branch contains the released Modelica version (e.g., version 3.0.1)
where all bug fixes since this release date are included (up to a  new release,
when becoming available; i.e., after a new release, the previous maintenance
versions are no longer changed).
These bug fixes might be not yet tested with all test cases or with
other Modelica libraries. The goal is that a vendor may take this version at
any time for a new release of its software, in order to incorporate the latest
bug fixes, without changing the version number of the Modelica Standard Library.
</p>

<p>
Incorporation of bug fixes (subversion \"commit\") shall be performed in the following way:
</p>

<ul>
<li> One person is fixing the bug and another person is checking whether the
         fix is fine.</li>
<li> It is up to the library developer, whether he opens a new branch for
         testing and then merges it with the \"head\" maintenance branch or not.</li>
<li> Every change to the maintenance branch has to be done at the development
         branch (see above) as well. One exception are pure changes to the
         \"versionBuild\" annotation as these have no meaning in the development trunk.</li>
<li> Every change to the maintenance branch requires introducing a
         description of the bug fix under
         Modelica.UsersGuide.ReleaseNotes.Version_&lt;release-number&gt;_BugFixes.</li>
<li> Annotations \"version\" and \"versionDate\" must <u>not</u> be changed in a maintenance release.</li>
<li> Every change to the maintenance branch requires changing the \"versionBuild\" number (incrementing it by one),
     as well as the \"dateModified\" field.<br>
     Example:
         <pre>  annotation(version      = \"3.1\",
             versionDate  = \"2009-06-22\",
             versionBuild = 3,
             dateModified = \"2009-08-28 07:40:19Z\",
             revisionId   = \"$I&#8203;d::                                       $\")</pre>
     The \"revisionId\" field is a bit special though. If written like in the example above it will be automatically
     expanded to:
        <pre>             revisionId   = \"$I&#8203;d:: package.mo 2879 2009-08-28 07:40:19Z #$\"</pre>
     by the subversion checkout procedure.</li>
<li> If time does not permit, a vendor makes the bug fix in its local version
         and then has to include it in the maintenance version. It would be best to make these
         changes at a new branch in order to get a unique release number.</li>
</ul>

<p>
A valid \"commit\" to the maintenance branch may contain one or
more of the following changes.
</p>

<ul>
<li> Correcting an equation.</li>
<li> Correcting attributes quantity/unit/defaultUnit in a declaration.</li>
<li> Improving/fixing the documentation.</li>
<li> Introducing a new name in the public section of a class
         (model, package, ...) or in any section of a partial class is <b>not</b> allowed.
         Since otherwise, a user might use this new name and when storing its model
         and loading it with an older build-version, an error would occur.</li>
<li> Introducing a new name in the protected section of a non-partial
         class should only be done if absolutely necessary to fix a bug.
         The problem is that this might be non-backward compatible,
         because a user might already extend from this class and already using the same name.</li>
</ul>
</html>"));
      end VersionManagement;

      class Version_3_2_1_build_4 "Version 3.2.1 build 4 (Sept. 30, 2015)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>
Version 3.2.1 build 4 is backward compatible to version 3.2.1 build 3,
that is models developed with versions 3.0, 3.0.1, 3.1, 3.2 or 3.2.1 will
work without any changes also with version 3.2.1 build 4
(see also issue (4) below, ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1757\">1757</a>).
This version is a bug-fix release. Short Overview:
</p>

<ol>
<li> This version of the Modelica package is <b>fully compatible</b> to
     Modelica Specification <b>3.2 revision 2</b>
     (with exception of issue (3) reported below and in
      ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1758\">1758</a>).
     </li>

<li> About <a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/ResolvedTracTickets-build-4.html\">10 tickets</a>
     have been fixed for this release. In particular the following <b>critical bug</b> has been fixed:<br>
     Ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1768\">1768</a>
     fixes an issue with block <a href=\"modelica://Modelica.Blocks.Sources.CombiTimeTable\">CombiTimeTable</a>
     (wrong output when using fixed time step integrator with time step greater than table resolution).
      </li>

<li> Ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1758\">1758</a>
     states that simulation of
     <a href=\"modelica://Modelica.Fluid.Examples.HeatingSystem\">Modelica.Fluid.Examples.HeatingSystem</a>
     fails in Dymola 2016 if option \"pedantic mode for checking Modelica semantics\" is set.
     This issue was not fixed in the library due to the following reasons:<br>
     The Modelica.Fluid library uses a particular pattern to define some parameters resulting
     in a cyclic dependency of parameters if only incident information is taken into account.
     According to Modelica Specification 3.2 revision 2 this is not allowed
     (and therefore Dymola 2016 correctly reports errors if the pedantic flag is set).
     In ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1320\">1320</a>
     this issue was resolved for Modelica Specification 3.3 revision 1 by allowing
     cyclic parameter definitions if the cycles disappear when evaluating parameters
     that have annotation Evaluate=true. Modelica.Fluid is correct with respect
     to Modelica Specification 3.3 revision 1.
     Changing the Modelica.Fluid library for build 4 so that no cyclic parameter dependencies
     would be present anymore would (a) result in a non-backwards compatible
     change and (b) make the usage of Modelica.Fluid less convenient. For this
     reason Modelica.Fluid is not changed. (Practically, this means for example that
     the pedantic flag in Dymola 2016 needs to be switched off, when using the
     Modelica.Fluid library in version 3.2.1 build 4 and any previous version).
     </li>

<li> In ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1757\">1757</a> it is (correctly) stated
     that the example model <a href=\"modelica://Modelica.Media.Examples.PsychrometricData\">PsychrometricData</a>
     was moved to another location and that this is a non-backwards compatible change.
     This non-backwards compatible change is accepted, because it fixes a circular depedency (a model references
     a package in which it resides), for details see ticket
     <a href=\"https://trac.modelica.org/Modelica/ticket/1679\">1679</a>.
     Fixing this ticket is seen as of much higher priority, as the small drawback that
     an example model is moved (and the probability is very high that this moved model is not
     used in any user model).
     </li>

<li> In the release notes of build 3 it is stated that no models, blocks, or functions have been
     newly introduced. This is not correct.<br>
     In package Modelica the following models have been newly introduced:<br>
     &nbsp;&nbsp;&nbsp;Modelica.Mechanics.Rotational.Examples.Utilities.SpringDamperNoRelativeStates
     (to fix ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1375\">1375</a>).<br>
     &nbsp;&nbsp;&nbsp;Modelica.Fluid.Examples.NonCircularPipes
     (to check the fix of ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1601\">1681</a>)<br>
     &nbsp;&nbsp;&nbsp;Modelica.Media.Examples.PsychrometricData
     (to fix ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1679\">1679</a>).<br>
     In package ModelicaTest the following models have been newly introduced:<br>
     &nbsp;&nbsp;&nbsp;Modelica.Tables.CombiTable2D.Test19<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTable2D.Test20<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTable2D.Test21<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTable2D.Test22<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTable2D.Test23<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTimeTable.Test68<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTimeTable.Test69<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTimeTable.Test70<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTimeTable.Test71<br>
     &nbsp;&nbsp;&nbsp;Tables.CombiTimeTable.Test72<br>
     &nbsp;&nbsp;&nbsp;MultiBody.PlanarLoopWithMove
     </li>
</ol>

<p>
This release of package Modelica, and the accompanying ModelicaTest,
has been tested with the following tools (the tools are listed alphabetically.
At the time of the test, some of the tools might not yet support the complete Modelica package):
</p>

<ul>
<li> Dymola 2016<br>
     Regression test results with regards to Modelica 3.2.1 build 3 are available
     <a href=\"https://trac.modelica.org/Modelica/ticket/1681\">here</a>.</li>

<li> Maplesim Parser</li>
<li> OpenModelica(Windows, Linux, Mac)<br>
     Test reports for the daily builds are available
     <a href=\"https://trac.openmodelica.org/OpenModelica/wiki\">here</a>.</li>
</ul>

<p>
The exact difference between package Modelica version 3.2.1 build 3 and version 3.2.1 build 4 is summarized in
a <a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/DifferencesTo3.2.1+build.3.html\">comparison table</a>.
</p>
</html>"));
      end Version_3_2_1_build_4;

      class Version_3_2_1_build_3 "Version 3.2.1 build 3 (July 30, 2015)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>Version 3.2.1 build 3 is backward compatible to version 3.2.1 build 2, that is models developed with versions 3.0, 3.0.1, 3.1, 3.2 or 3.2.1 will work without any changes also with version 3.2.1 build 3. This version is a bug-fix release. Short Overview: </p>
<ul>
<li>This version of the Modelica package is <b>fully compatible</b> to Modelica Specification <b>3.2 revision 2</b>. </li>
<li>About <a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/ResolvedTracTickets-build-3.html\">103 tickets</a> have been fixed for this release. </li>
<li><b>No</b> models and blocks and functions are newly included. </li>
</ul>
<p>This release of package Modelica, and the accompanying ModelicaTest, has been tested with the following tools (the tools are listed alphabetically. At the time of the test, some of the tools might not yet support the complete Modelica package): </p>
<ul>
<li>Dymola 2016<br>Regression test results with regards to Modelica 3.2.1 build 2 are available <a href=\"https://trac.modelica.org/Modelica/ticket/1681\">here</a>.</li>
<li>Maplesim Parser</li>
<li>OpenModelica(Windows, Linux, Mac)<br>Test reports for the daily builds are available <a href=\"https://trac.openmodelica.org/OpenModelica/wiki\">here</a>.</li>
<li>LMS Imagine.Lab Amesim 14.1</li>
</ul>
<p>The exact difference between package Modelica version 3.2.1 build 2 and version 3.2.1 build 3 is summarized in a <a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/DifferencesTo3.2.1+build.2.html\">comparison table</a>. </p>
</html>"));
      end Version_3_2_1_build_3;

      class Version_3_2_1 "Version 3.2.1 (August 14, 2013)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>
Version 3.2.1 is backward compatible to version 3.2, that is models developed with
versions 3.0, 3.0.1, 3.1, or 3.2 will work without any changes also with version 3.2.1.
This version is a \"clean-up\" with major emphasis on quality improvement and
tool compatibility. The goal is that all
<a href=\"https://www.modelica.org/tools\">Modelica tools</a> will support this package
and will interpret it in the same way. Short Overview:
</p>

<ul>
<li> This version of the Modelica package is <b>fully compatible</b> to
     Modelica Specification <b>3.2 revision 2</b>.<br>
     (Especially, some operators used in package Modelica,
     such as \"rooted\", have been standardized in 3.2 rev. 2,
     as well as vendor specific annotations. Furthermore,
     ambiguous/unclear descriptions in the specification have
     been corrected/improved. One important improvement in packages
     Modelica and ModelicaTest is that the initialization has been fully defined
     in all example models, in order that all tools can produce the same result
     without relying on tool heuristics).
     </li>

<li> About <a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/ResolvedTracTickets.html\">400 tickets</a>
     have been fixed for this release, and
     especially all compliance issues and all relevant defect issues.
     </li>

<li> An open source implementation of the <b>table blocks</b> has been provided
     by <a href=\"http://www.itisim.com\">ITI GmbH</a>. This work has been
     <a href=\"https://www.modelica.org/news_items/call-texts-to-improve-modelica-2012/2012-12-20-Call-for-quotation-for-MSL-tables.pdf/at_download/file\">paid by Modelica Association</a>.
     As a result, all parts of package Modelica are now available
     in a free implementation. Additionally new features have been added to the table blocks
     by this implementation:
     <ul>
     <li>The table outputs can be differentiated once.</li>
     <li>Support of binary MATLAB MAT-file formats v6 and v7</li>
     <li>New option ConstantSegments for parameter Smoothness</li>
     <li>New option NoExtrapolation for parameter Extrapolation</li>
     <li>Support of tables provided in the C-Code (usertab.c, for realtime systems without file system)</li>
     </ul>

<li> <b>Icons</b> have been re-designed by Wolfram Research to provide a more modern view .</li>

<li> The <b>Modelica.Media.Air.MoistAir</b> media model has been improved so that it
     can be used in a temperature range of 190 ... 647 K (previously: 240 ... 400 K).</li>

<li> New media models for air (<b>ReferenceAir</b> with a large operating range: 30 ... 2000 K,
     0 ... 2000 MPa), for moist air (<b>ReferenceMoistAir</b> with a large operating range:
     143.15 ... 2000 K, 0 .. 10 MPa;  but 1-2 orders of magnitude slower as
     Modelica.Media.Air.MoistAir),
     and the refrigerant <b>R134a</b> are included in the Modelica.Media library in order to
     improve the modeling of air conditioning systems especially in aircrafts.
     These models have been developed by
     <a href=\"http://www.xrg-simulation.de/\">XRG Simulation GmbH</a>
     as part of the <a href=\"http://www.cleansky.eu/\">Clean Sky</a> JTI project
     (Project number: 296369; Theme: JTI-CS-2011-1-SGO-02-026).
     The partial financial support by the European Union for this development
     is highly appreciated.</li>

<li> <b>60</b> models and blocks and <b>90</b> functions are newly included, for details see below.</li>

</ul>

<p>
This release of package Modelica, and the accompanying ModelicaTest, has been tested with the
following tools (the tools are listed alphabetically. At the time of the test, some of the
tools might not yet supported the complete Modelica package):
</p>

<ul>
<li> CyModelica </li>
<li> Dymola 2014 (Windows 64 bit)<br>
     Regression test results with regards to Modelica 3.2 are available
     in ticket <a href=\"https://trac.modelica.org/Modelica/ticket/1114\">#1114</a>.</li>
<li> Dymola 2014 FD01 development with pedantic flag (Windows 64 bit)<br>
     (\"pedantic flag\" means that strict Modelica compliance is checked.
     Dymola 2014 fails with pedantic flag, e.g., because the annotation DocumentationClass
     was not standardized when this version of Dymola was released).</li>
<li> Maplesim Parser</li>
<li> MWorks 3.2</li>
<li> OpenModelica 1.9.0 Beta4+dev (Windows, Linux, Mac)<br>
     Test reports for the daily builds are available
     <a href=\"https://trac.openmodelica.org/OpenModelica/wiki\">here</a>.
     Test reports of comparisons with Dymola result files are available
     <a href=\"https://test.openmodelica.org/hudson/job/OpenModelica_TEST_CLANG/lastCompletedBuild/testReport/(root)/simulation_libraries_msl32/\">here</a>.
     </li>
<li> SimulationX 3.6</li>
</ul>

<p>
The following Modelica packages have been tested that they work together with this release of package Modelica
(alphabetical list):
</p>

<ul>
<li> Buildings 1.4 (LBNL) </li>
<li> FlexibleBodies 2.0.1 (DLR)</li>
<li> Modelica_Synchronous 0.91 (DLR)</li>
<li> Optimization 2.2 (DLR)</li>
<li> PowerTrain 2.2.0 (DLR) </li>
</ul>

<p>
The new open source tables have been tested by T. Beutlich (ITI):
</p>

<ul>
<li> 193 Modelica test models for compatibility check with previous table implementation
     (available in ModelicaTest.Tables).
     Performed tests with SimulationX 3.5.707 (32 bit) and
     Dymola 2013 FD01 (32 bit). Furthermore a basic check was performed in OpenModelica
     to make sure it works in general.
     </li>
<li> The two C source files (Modelica/Resources/C-Sources/ModelicaStandardTables.c; ModelicaMatIO.c)
     have been tested to successfully compile for the following platforms<br>
     &nbsp;&nbsp;&nbsp;Windows 32 and 64 bit<br>
     &nbsp;&nbsp;&nbsp;Linux 32 and 64 bit<br>
     &nbsp;&nbsp;&nbsp;dSPACE SCALEXIO<br>
     &nbsp;&nbsp;&nbsp;dSPACE DS1005 (no file system)<br>
     &nbsp;&nbsp;&nbsp;dSPACE DS1006 (no file system)<br>
     &nbsp;&nbsp;&nbsp;dSPACE DS1401 (no file system)
     </li>
<li> The following compilers/environments have been used for the platform evaluation<br>
     &nbsp;&nbsp;&nbsp;Microsoft compilers (VC6 and &ge; VS2005 (Win32 and x64)) <br>
     &nbsp;&nbsp;&nbsp;MinGW (GCC 4.4.0 and GCC 4.7.2)<br>
     &nbsp;&nbsp;&nbsp;Cygwin (GCC 4.3.0)<br>
     &nbsp;&nbsp;&nbsp;Open WATCOM 1.3<br>
     &nbsp;&nbsp;&nbsp;LCC 2.4.1<br>
     &nbsp;&nbsp;&nbsp;Borland C/C++ (free command line tools) 5.5<br>
     &nbsp;&nbsp;&nbsp;GCC 4.x on Linux<br>
     &nbsp;&nbsp;&nbsp;GCC 3.3.5 (for DS1006)<br>
     &nbsp;&nbsp;&nbsp;Microtec PowerPC Compiler 3.7 (for DS1005)
     </li>
</ul>

<p>
The exact difference between package Modelica version 3.2 and version 3.2.1 is
summarized in a
<a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/DifferencesTo32.html\">comparison table</a>.
</p>

<p>
About <b>400</b> trac tickets have been fixed for this release. An overview is given
<a href=\"modelica://Modelica/Resources/Documentation/Version-3.2.1/ResolvedTracTickets.html\">here</a>.
Clicking on a ticket gives all information about it.
</p>


<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.Blocks.Logical.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> RSFlipFlop</td>
    <td valign=\"top\"> Basic RS flip flop</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> MinMax</td>
    <td valign=\"top\">Output the minimum and the maximum element of the input vector </td></tr>
<tr><td valign=\"top\" width=\"150\"> LinearDependency </td>
    <td valign=\"top\">Output a linear combination of the two inputs </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Nonlinear.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> SlewRateLimiter</td>
    <td valign=\"top\"> Limit the slew rate of a signal </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Memories</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> DLATRAM</td>
    <td valign=\"top\"> Level sensitive Random Access Memory </td></tr>
<tr><td valign=\"top\" width=\"150\"> DLATROM</td>
    <td valign=\"top\"> Level sensitive Read Only Memory </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Multiplexers</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> MUX2x1</td>
    <td valign=\"top\"> A two inputs MULTIPLEXER for multiple value logic (2 data inputs, 1 select input, 1 output) </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.AsynchronousInductionMachines.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> AIMC_Initialize </td>
    <td valign=\"top\"> Steady-State Initialization examnple of AsynchronousInductionMachineSquirrelCage </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.SynchronousInductionMachines.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> SMPM_VoltageSource </td>
    <td valign=\"top\"> PermanentMagnetSynchronousInductionMachine example fed by FOC </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Examples.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> TestSensors </td>
    <td valign=\"top\"> Example for multiphase quasiRMS sensors: A sinusoidal source feeds a load consisting of resistor and inductor </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Sensors.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> VoltageQuasiRMSSensor </td>
    <td valign=\"top\"> Continuous quasi voltage RMS sensor for multi phase system </td></tr>
<tr><td valign=\"top\" width=\"150\"> CurrentQuasiRMSSensor </td>
    <td valign=\"top\"> Continuous quasi current RMS sensor for multi phase system </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Blocks.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> QuasiRMS </td>
    <td valign=\"top\"> Determine quasi RMS value of a multi-phase system </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Functions.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> quasiRMS </td>
    <td valign=\"top\"> Calculate continuous quasi RMS value of input </td></tr>
<tr><td valign=\"top\" width=\"150\"> activePower </td>
    <td valign=\"top\"> Calculate active power of voltage and current input </td></tr>
<tr><td valign=\"top\" width=\"150\"> symmetricOrientation </td>
    <td valign=\"top\"> Orientations of the resulting fundamental wave field phasors </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Spice3.Examples.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> CoupledInductors<br>
                                      CascodeCircuit<br>
                                      Spice3BenchmarkDifferentialPair<br>
                                      Spice3BenchmarkMosfetCharacterization<br>
                                      Spice3BenchmarkRtlInverter<br>
                                      Spice3BenchmarkFourBitBinaryAdder</td>
    <td valign=\"top\"> Spice3 examples and benchmarks from the SPICE3 Version e3 Users's Manual </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Spice3.Basic.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> K_CoupledInductors</td>
    <td valign=\"top\"> Inductive coupling via coupling factor K </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Spice3.Semiconductors.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> M_NMOS2 <br>
                                      M_PMOS2 <br>
                                      ModelcardMOS2</td>
    <td valign=\"top\">  N/P channel MOSFET transistor with fixed level 2 </td></tr>
<tr><td valign=\"top\" width=\"150\"> J_NJFJFE <br>
                                      J_PJFJFE <br>
                                      ModelcardJFET</td>
    <td valign=\"top\">  N/P-channel junction field-effect transistor </td></tr>
<tr><td valign=\"top\" width=\"150\"> C_Capacitor <br>
                                      ModelcardCAPACITOR</td>
    <td valign=\"top\">  Semiconductor capacitor model </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Magnetic.FundamentalWave.Examples.BasicMachines.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> AIMC_DOL_MultiPhase<br>
                                      AIMS_Start_MultiPhase<br>
                                      SMPM_Inverter_MultiPhase<br>
                                      SMEE_Generator_MultiPhase<br>
                                      SMR_Inverter_MultiPhase</td>
    <td valign=\"top\"> Multi-phase machine examples </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Sensors.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> MassFractions<br>
                                      MassFractionsTwoPort</td>
    <td valign=\"top\"> Ideal mass fraction sensors </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Media.</b></td></tr>
<tr><td valign=\"top\" width=\"150\">R134a</td>
    <td valign=\"top\"> R134a (Tetrafluoroethane) medium model in the range (0.0039 bar .. 700 bar,
    169.85 K .. 455 K)</td></tr>

<tr><td colspan=\"2\"><b>Modelica.Media.Air.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> ReferenceAir</td>
    <td valign=\"top\"> Detailed dry air model with a large operating range (130 ... 2000 K, 0 ... 2000 MPa)
                        based on Helmholtz equations of state</td></tr>
<tr><td valign=\"top\" width=\"150\"> ReferenceMoistAir</td>
    <td valign=\"top\"> Detailed moist air model (143.15 ... 2000 K)</td></tr>
<tr><td valign=\"top\" width=\"150\"> MoistAir</td>
    <td valign=\"top\"> Temperature range of functions of MoistAir medium enlarged from
                        240 - 400 K to  190 - 647 K.</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> velocityOfSound<br>
                                      isobaricExpansionCoefficient<br>
                                      isothermalCompressibility<br>
                                      density_derp_h<br>
                                      density_derh_p<br>
                                      density_derp_T<br>
                                      density_derT_p<br>
                                      density_derX<br>
                                      molarMass<br>
                                      T_psX<br>
                                      setState_psX<br>
                                      s_pTX<br>
                                      s_pTX_der<br>
                                      isentropicEnthalpy</td>
    <td valign=\"top\"> Functions returning additional properties of the moist air medium model</td></tr>

<tr><td colspan=\"2\"><b>Modelica.Thermal.HeatTransfer.Components.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> ThermalResistor</td>
    <td valign=\"top\"> Lumped thermal element transporting heat without storing it (dT = R*Q_flow) </td></tr>
<tr><td valign=\"top\" width=\"150\"> ConvectiveResistor</td>
    <td valign=\"top\"> Lumped thermal element for heat convection (dT = Rc*Q_flow) </td></tr>

<tr><td colspan=\"2\"><b>Modelica.MultiBody.Examples.Constraints.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> PrismaticConstraint <br>
                        RevoluteConstraint<br>
                        SphericalConstraint<br>
                        UniversalConstraint</td>
    <td valign=\"top\"> Demonstrates the use of the new Joints.Constraints joints by comparing
                        them with the standard joints.</td></tr>
<tr><td colspan=\"2\"><b>Modelica.MultiBody.Joints.Constraints.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> Prismatic <br>
                        Revolute<br>
                        Spherical<br>
                        Universal</td>
    <td valign=\"top\"> Joint elements formulated as kinematic constraints. These elements are
                        designed to break kinematic loops and result usually in numerically more
                        efficient and reliable loop handling as the (standard) automatic handling.</td></tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> MultiSensor</td>
    <td valign=\"top\"> Ideal sensor to measure the torque and power between two flanges and the absolute angular velocity </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> MultiSensor</td>
    <td valign=\"top\"> Ideal sensor to measure the absolute velocity, force and power between two flanges </td></tr>

<tr><td colspan=\"2\"><b>Modelica.Math.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> isPowerOf2</td>
    <td valign=\"top\"> Determine if the integer input is a power of 2 </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Math.Vectors.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> normalizedWithAssert</td>
    <td valign=\"top\"> Return normalized vector such that length = 1 (trigger an assert for zero vector) </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Math.BooleanVectors.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> countTrue</td>
    <td valign=\"top\"> Returns the number of true entries in a Boolean vector  </td></tr>
<tr><td valign=\"top\" width=\"150\"> enumerate</td>
    <td valign=\"top\"> Enumerates the true entries in a Boolean vector (0 for false entries) </td></tr>
<tr><td valign=\"top\" width=\"150\"> index</td>
    <td valign=\"top\"> Returns the indices of the true entries of a Boolean vector</td></tr>

<tr><td colspan=\"2\"><b>Modelica.Utilities.Files.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> loadResource</td>
    <td valign=\"top\"> Return the absolute path name of a URI or local file name  </td></tr>

<tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
<tr><td valign=\"top\" width=\"150\"> PressureDifference<br>
                        MolarDensity<br>
                        MolarEnergy<br>
                        MolarEnthalpy<br>
                        TimeAging<br>
                        ChargeAging<br>
                        PerUnit<br>
                        DerPressureByDensity<br>
                        DerPressureByTemperature</td>
    <td valign=\"top\"> New SI unit types </td></tr>
</table>
</html>"));
      end Version_3_2_1;

      class Version_3_2 "Version 3.2 (Oct. 25, 2010)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p>
Version 3.2 is backward compatible to version 3.1, i.e., models developed with
versions 3.0, 3.0.1, or 3.1 will work without any changes also with version 3.2.
This version is a major improvement:
</p>

<ul>
<li> <b>357</b> models and blocks and <b>295</b> functions are newly included.</li>

<li><b>7</b> new libraries are included.</li>

<li> The icons of the library are newly designed to provide a modern, unified view,
     see <a href=\"modelica://Modelica.Icons\">Modelica.Icons</a>.</li>

<li> All non-Modelica files, such as images, pdf-files, C-source files,
     scripts are moved to the new directory \"Modelica\\Resources\".
     Furthermore, all file references are changed to URIs as introduced in
     Modelica 3.1 (e.g., a file with the file name
     \"Modelica/Resources/Images/xxx\" is referenced as
     \"modelica://Modelica/Resources/Images/xxx\").</li>

<li> All physical models that dissipate heat (such as electrical elements,
     electrical machines, bearings, dampers, etc.), have now an optional heat port
     to which the dissipated energy is flowing, if activated.
     This will significantly improve design studies about the thermal efficiency
     of technical systems.</li>

<li> All electrical machines in the
     <a href=\"modelica://Modelica.Electrical.Machines\">Machines</a>
     library have now a \"Losses\" tab in the parameter menu to optionally
     model machines losses such as frictional losses, stator core losses
     or stray load losses, respectively.</li>

<li> All electrical machines in the
     <a href=\"modelica://Modelica.Electrical.Machines\">Machines</a>
     library have now a \"powerBalance\" result record,
     summarizing converted power and losses.</li>
</ul>

<p>
Version 3.2 is slightly based on the Modelica Specification 3.2. It uses
the following new language elements (compared to Modelica Specification 3.1):
</p>

<ul>
<li> Operator records and overloaded operators. </li>
<li> Functions as input arguments to functions.</li>
<li> Improved expandable connectors (variables declared in expandable
     connectors are ignored if not referenced).</li>
</ul>

<p>
A large part of the new classes have been developed with
partial financial support by
<a href=\"http://www.bmbf.de/en/index.php\">BMBF</a>
(BMBF F&ouml;rderkennzeichen: 01IS07022F)
within the <a href=\"http://www.itea2.org\">ITEA2</a> project
<a href=\"http://www.eurosyslib.com/\">EUROSYSLIB</a>.
We highly appreciate this funding.
</p>

<p>
The following <b style=\"color:blue\">new libraries</b> have been added:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Complex\">Complex</a></td>
    <td valign=\"top\">
    This is a top-level record outside of the Modelica Standard Library.
    It is used for complex numbers and contains overloaded operators.
    From a users point of view, Complex is used in a similar way as the
    built-in type Real. Example:<br>
    <code>&nbsp;  Real     a    = 2;</code><br>
    <code>&nbsp;  Complex  j    = Modelica.ComplexMath.j;</code><br>
    <code>&nbsp;  Complex  b    = 2 + 3*j;</code><br>
    <code>&nbsp;  Complex  c    = (2*b + a)/b;</code><br>
    <code>&nbsp;  Complex  d    = Modelica.ComplexMath.sin(c);</code><br>
    <code>&nbsp;  Complex  v[3] = {b/2, c, 2*d};</code><br>
    (This library was developed by Marcus Baur, DLR).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.ComplexBlocks\">Modelica.ComplexBlocks</a></td>
    <td valign=\"top\">
    Library of basic input/output control blocks with Complex signals.<br>
    This library is especially useful in combination with the new
    <a href=\"modelica://Modelica.Electrical.QuasiStationary\">Modelica.Electrical.QuasiStationary</a>
    library in order to build up very fast simulations of electrical circuits with periodic
    currents and voltages.<br>
    (This library was developed by Anton Haumer).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Electrical.QuasiStationary\">Modelica.Electrical.QuasiStationary</a></td>
    <td valign=\"top\">
    Library for quasi-stationary electrical singlephase and multiphase AC simulation.<br>
    This library allows very fast simulations of electrical circuits with sinusoidal
    currents and voltages by only taking into account the quasi-stationary, periodic part
    and neglecting non-periodic transients.<br>
    (This library was developed by Anton Haumer and Christian Kral).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Spice3\">Modelica.Electrical.Spice3</a></td>
    <td valign=\"top\">
    Library with components of the Berkeley
    <a href=\"http://bwrc.eecs.berkeley.edu/Classes/IcBook/SPICE/\">SPICE3</a>
    simulator:<br>
    R, C, L, controlled and independent sources, semiconductor device models
    (MOSFET Level 1, Bipolar junction transistor, Diode, Semiconductor resistor).
    The components have been intensively tested with more than 1000 test models
    and compared with results from the SPICE3 simulator. All test models give identical
    results in Dymola 7.4 with respect to the Berkeley SPICE3 simulator up to the relative
    tolerance of the integrators.<br>
    This library allows detailed simulations of electronic circuits.
    Work on Level 2 SPICE3 models, i.e., even more detailed models, is under way.
    Furthermore, a pre-processor is under development to transform automatically
    a SPICE netlist into a Modelica model, in order that the many available
    SPICE3 models can be directly used in a Modelica model.<br>
    (This library was developed by Fraunhofer Gesellschaft, Dresden).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Magnetic.FundamentalWave\">Modelica.Magnetic.FundamentalWave</a></td>
    <td valign=\"top\">
     Library for magnetic fundamental wave effects in electric machines for the
     application in three phase electric machines.
     The library is an alternative approach to the Modelica.Electrical.Machines library.
     A great advantage of this library is the strict object orientation of the
     electrical and magnetic components that the electric machines models are composed of.
     This allows an easier incorporation of more detailed physical effects of
     electrical machines.
     From a didactic point of view this library is very beneficial for students in the field
     of electrical engineering.<br>
     (This library was developed by Christian Kral, and Anton Haumer, using
     ideas and source code of a library from Michael Beuschel from 2000).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Fluid.Dissipation\">Modelica.Fluid.Dissipation</a></td>
    <td valign=\"top\">
     Library with functions to compute convective heat transfer and pressure loss characteristics.<br>
     (This library was developed by Thorben Vahlenkamp and Stefan Wischhusen from
     XRG Simulation GmbH).
    </td></tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.ComplexMath\">Modelica.ComplexMath</a></td>
    <td valign=\"top\">
    Library of complex mathematical functions (e.g., sin, cos) and of functions operating
    on complex vectors.<br>
    (This library was developed by Marcus Baur from DLR-RM, Anton Haumer, and
     HansJ&uuml;rg Wiesmann).
    </td></tr>
</table>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.UsersGuide</b></td></tr>
<tr><td valign=\"top\"> Conventions
                      </td>
    <td valign=\"top\"> Considerably improved 'Conventions' for the Modelica Standard Library. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Examples</b></td></tr>
<tr><td valign=\"top\"> Filter<br>
                      FilterWithDifferentation<br>
                      FilterWithRiseTime<br>
                      RealNetwork1<br>
                      IntegerNetwork1<br>
                      BooleanNetwork1<br>
                      Interaction1
                      </td>
    <td valign=\"top\"> Examples for the newly introduced block components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Continuous</b></td></tr>
<tr><td valign=\"top\"> Filter </td>
    <td valign=\"top\"> Continuous low pass, high pass, band pass and band stop
                      IIR-filter of type CriticalDamping, Bessel, Butterworth and Chebyshev I. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Interaction.Show</b></td></tr>
<tr><td valign=\"top\"> RealValue<br>
                      IntegerValue<br>
                      BooleanValue</td>
    <td valign=\"top\"> Blocks to show the values of variables in a diagram animation. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces</b></td></tr>
<tr><td valign=\"top\"> RealVectorInput<br>
                      IntegerVectorInput<br>
                      BooleanVectorInput<br>
                      PartialRealMISO<br>
                      PartialIntegerSISO<br>
                      PartialIntegerMISO<br>
                      PartialBooleanSISO_small<br>
                      PartialBooleanMISO
                      </td>
    <td valign=\"top\"> Interfaces and partial blocks for the new block components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Math</b></td></tr>
<tr><td valign=\"top\"> MultiSum<br>
                      MultiProduct<br>
                      MultiSwitch </td>
    <td valign=\"top\"> Sum, product and switch blocks with 1,2,...,N inputs
                      (based on connectorSizing annotation to handle vectors of
                       connectors in a convenient way). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.MathInteger</b></td></tr>
<tr><td valign=\"top\"> MultiSwitch<br>
                      Sum<br>
                      Product<br>
                      TriggeredAdd</td>
    <td valign=\"top\"> Mathematical blocks for Integer signals. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Boolean</b></td></tr>
<tr><td valign=\"top\"> MultiSwitch<br>
                      And<br>
                      Or<br>
                      Xor<br>
                      Nand<br>
                      Nor<br>
                      Not<br>
                      RisingEdge<br>
                      FallingEdge<br>
                      ChangingEdge<br>
                      OnDelay</td>
    <td valign=\"top\"> Mathematical blocks for Boolean signals.
                      Some of these blocks are available also in library
                      <a href=\"modelica://Modelica.Blocks.Logical\">Logical</a>.
                      The new design is based on the connectorSizing annotation that allows
                      the convenient handling of an arbitrary number of input signals
                      (e.g., the \"And\" block has 1,2,...,N inputs, instead of only 2 inputs
                      in the <a href=\"modelica://Modelica.Blocks.Logical\">Logical</a> library).
                      Additionally, the icons are smaller so that the diagram area is
                      better utilized</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Sources</b></td></tr>
<tr><td valign=\"top\"> RadioButtonSource</td>
    <td valign=\"top\"> Boolean signal source that mimics a radio button. </td> </tr>
<tr><td valign=\"top\"> IntegerTable</td>
    <td valign=\"top\"> Generate an Integer output signal based on a table matrix
                      with [time, yi] values. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Examples</b></td></tr>
<tr><td valign=\"top\"> SimpleTriacCircuit,<br>
                      IdealTriacCircuit,<br>
                      AD_DA_conversion </td>
    <td valign=\"top\"> Examples for the newly introduced Analog components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal</b></td></tr>
<tr><td valign=\"top\"> IdealTriac,<br>
                      AD_Converter,<br>
                      DA_Converter </td>
    <td valign=\"top\"> AD and DA converter, ideal triac (based on ideal thyristor). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors</b></td></tr>
<tr><td valign=\"top\"> SimpleTriac </td>
    <td valign=\"top\"> Simple triac based on semiconductor thyristor model. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Examples</b></td></tr>
<tr><td valign=\"top\">  Delay_example,<br>
                       DFFREG_example,<br>
                       DFFREGL_example,<br>
                       DFFREGSRH_example,<br>
                       DFFREGSRL_example,<br>
                       DLATREG_example,<br>
                       DLATREGL_example,<br>
                       DLATREGSRH_example,<br>
                       DLATREGSRL_example,<br>
                       NXFER_example,<br>
                       NRXFER_example,<br>
                       BUF3S_example,<br>
                       INV3S_example,<br>
                       WiredX_example </td>
    <td valign=\"top\"> Examples for the newly introduced Digital components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Interfaces</b></td></tr>
<tr><td valign=\"top\"> UX01,<br>
                      Strength,<br>
                      MIMO </td>
    <td valign=\"top\"> Interfaces for the newly introduced Digital components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Tables</b></td></tr>
<tr><td valign=\"top\"> ResolutionTable,<br>
                      StrengthMap,<br>
                      NXferTable,<br>
                      NRXferTable,<br>
                      PXferTable,<br>
                      PRXferTable,<br>
                      Buf3sTable,<br>
                      Buf3slTable </td>
    <td valign=\"top\"> New Digital table components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Delay</b></td></tr>
<tr><td valign=\"top\"> InertialDelaySensitiveVector </td>
    <td valign=\"top\"> New Digital delay component. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Registers</b></td></tr>
<tr><td valign=\"top\"> DFFR,<br>
                      DFFREG,<br>
                      DFFREGL,<br>
                      DFFSR,<br>
                      DFFREGSRH,<br>
                      DFFREGSRL,<br>
                      DLATR,<br>
                      DLATREG,<br>
                      DLATREGL,<br>
                      DLATSR,<br>
                      DLATREGSRH,<br>
                      DLATREGSRL </td>
    <td valign=\"top\"> Various register components (collection of flipflops and latches)
                      according to the VHDL standard. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Tristates</b></td></tr>
<tr><td valign=\"top\"> NXFERGATE,<br>
                      NRXFERGATE,<br>
                      PXFERGATE,<br>
                      PRXFERGATE,<br>
                      BUF3S,<br>
                      BUF3SL,<br>
                      INV3S,<br>
                      INV3SL,<br>
                      WiredX </td>
    <td valign=\"top\"> Transfer gates, buffers, inverters and wired node.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Basic</b></td></tr>
<tr><td valign=\"top\"> MutualInductor </td>
    <td valign=\"top\"> Multi phase inductor providing a mutual inductance matrix model. </td> </tr>
<tr><td valign=\"top\"> ZeroInductor </td>
    <td valign=\"top\"> Multi phase zero sequence inductor. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines</b></td></tr>
<tr><td valign=\"top\"> Examples </td>
    <td valign=\"top\"> Structured according to machine types:<br>
                      AsynchronousInductionMachines<br>
                      SynchronousInductionMachines<br>
                      DCMachines<br>
                      Transformers </td> </tr>
<tr><td valign=\"top\"> Losses.* </td>
    <td valign=\"top\"> Parameter records and models for losses in electrical machines and transformers (where applicable): <br>
                      Friction losses <br>
                      Brush losses <br>
                      Stray Load losses <br>
                      Core losses (only eddy current losses but no hysteresis losses; not for transformers) </td> </tr>
<tr><td valign=\"top\"> Thermal.* </td>
    <td valign=\"top\"> Simple thermal ambients, to be connected to the thermal ports of machines, <br>
                      as well as material constants and utility functions. </td> </tr>
<tr><td valign=\"top\"> Icons.* </td>
    <td valign=\"top\"> Icons for transient and quasistationary electrical machines and transformers. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.AsynchronousInductionMachines.</b></td></tr>
<tr><td valign=\"top\"> AIMC_withLosses </td>
    <td valign=\"top\"> Asynchronous induction machine with squirrel cage with losses </td> </tr>
<tr><td valign=\"top\"> AIMC_Transformer </td>
    <td valign=\"top\"> Asynchronous induction machine with squirrel cage - transformer starting </td> </tr>
<tr><td valign=\"top\"> AIMC_withLosses </td>
    <td valign=\"top\"> Test example of an asynchronous induction machine with squirrel cage with losses </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.SynchronousInductionMachines.</b></td></tr>
<tr><td valign=\"top\"> SMPM_CurrentSource </td>
    <td valign=\"top\"> Permanent magnet synchronous induction machine fed by a current source </td> </tr>
<tr><td valign=\"top\"> SMEE_LoadDump </td>
    <td valign=\"top\"> Electrical excited synchronous induction machine with voltage controller </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.DCMachines.</b></td></tr>
<tr><td valign=\"top\"> DCSE_SinglePhase </td>
    <td valign=\"top\"> Series excited DC machine, fed by sinusoidal voltage </td> </tr>
<tr><td valign=\"top\"> DCPM_Temperature </td>
    <td valign=\"top\"> Permanent magnet DC machine, demonstration of varying temperature </td> </tr>
<tr><td valign=\"top\"> DCPM_Cooling </td>
    <td valign=\"top\"> Permanent magnet DC machine, coupled with a simple thermal model </td> </tr>
<tr><td valign=\"top\"> DCPM_QuasiStationary </td>
    <td valign=\"top\"> Permanent magnet DC machine, comparison between transient and quasistationary model </td> </tr>
<tr><td valign=\"top\"> DCPM_Losses </td>
    <td valign=\"top\"> Permanent magnet DC machine, comparison between model with and without losses </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.QuasiStationaryDCMachines.</b></td></tr>
<tr><td valign=\"top\"> DC_PermanentMagnet <br>
                      DC_ElectricalExcited <br>
                      DC_SeriesExcited </td>
    <td valign=\"top\"> QuasiStationary DC machines, i.e., neglecting electrical transients </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.Components.</b></td></tr>
<tr><td valign=\"top\"> InductorDC </td>
    <td valign=\"top\"> Inductor model which neglects der(i) if Boolean parameter quasiStationary = true </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Interfaces.</b></td></tr>
<tr><td valign=\"top\">  ThermalPortTransformer <br>
                       PowerBalanceTransformer </td>
    <td valign=\"top\"> Thermal ports and power balances for electrical machines and transformers. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Utilities</b></td></tr>
<tr><td valign=\"top\"> SwitchedRheostat </td>
    <td valign=\"top\"> Switched rheostat, used for starting asynchronous induction motors with slipring rotor. </td> </tr>
<tr><td valign=\"top\"> RampedRheostat </td>
    <td valign=\"top\"> Ramped rheostat, used for starting asynchronous induction motors with slipring rotor. </td> </tr>
<tr><td valign=\"top\"> SynchronousMachineData </td>
    <td valign=\"top\"> The parameters of the synchronous machine model with electrical excitation (and damper) are calculated
                      from parameters normally given in a technical description,
                      according to the standard EN 60034-4:2008 Appendix C. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Elementary.</b></td></tr>
<tr><td valign=\"top\"> HeatLosses </td>
    <td valign=\"top\"> Demonstrate the modeling of heat losses. </td> </tr>
<tr><td valign=\"top\"> UserDefinedGravityField </td>
    <td valign=\"top\"> Demonstrate the modeling of a user-defined gravity field. </td> </tr>
<tr><td valign=\"top\"> Surfaces </td>
    <td valign=\"top\"> Demonstrate the visualization of a sine surface,<br>
                      as well as a torus and a wheel constructed from a surface. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Joints.</b></td></tr>
<tr><td valign=\"top\"> FreeMotionScalarInit </td>
    <td valign=\"top\"> Free motion joint that allows initialization and state selection<br>
                      of single elements of the relevant vectors<br>
                      (e.g., initialize r_rel_a[2] but not the other elements of r_rel_a;<br>
                      this new component fixes ticket
                      <a href=\"https://trac.modelica.org/Modelica/ticket/274\">#274</a>) </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.</b></td></tr>
<tr><td valign=\"top\"> Torus </td>
    <td valign=\"top\"> Visualizing a torus. </td> </tr>
<tr><td valign=\"top\"> VoluminousWheel </td>
    <td valign=\"top\"> Visualizing a voluminous wheel. </td> </tr>
<tr><td valign=\"top\"> PipeWithScalarField </td>
    <td valign=\"top\"> Visualizing a pipe with scalar field quantities along the pipe axis. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.ColorMaps.</b></td></tr>
<tr><td valign=\"top\"> jet<br>
                      hot<br>
                      gray<br>
                      spring<br>
                      summer<br>
                      autumn<br>
                      winter </td>
    <td valign=\"top\"> Functions returning different color maps. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.Colors.</b></td></tr>
<tr><td valign=\"top\"> colorMapToSvg </td>
    <td valign=\"top\"> Save a color map on file in svg (scalable vector graphics) format. </td> </tr>
<tr><td valign=\"top\"> scalarToColor </td>
    <td valign=\"top\"> Map a scalar to a color using a color map. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.Advanced.</b></td></tr>
<tr><td valign=\"top\"> Surface </td>
    <td valign=\"top\"> Visualizing a moveable, parameterized surface;<br>
                      the surface characteristic is provided by a function<br>
                      (this new component fixes ticket
                       <a href=\"https://trac.modelica.org/Modelica/ticket/181\">#181</a>)</td> </tr>
<tr><td valign=\"top\"> PipeWithScalarField </td>
    <td valign=\"top\"> Visualizing a pipe with a scalar field. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.Advanced.SurfaceCharacteristics.</b></td></tr>
<tr><td valign=\"top\"> torus </td>
    <td valign=\"top\"> Function defining the surface characteristic of a torus. </td> </tr>
<tr><td valign=\"top\"> pipeWithScalarField </td>
    <td valign=\"top\"> Function defining the surface characteristic of a pipe<br>
                      where a scalar field value is displayed with color along the pipe axis. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.Examples.</b></td></tr>
<tr><td valign=\"top\"> HeatLosses </td>
    <td valign=\"top\"> Demonstrate the modeling of heat losses. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.Examples.</b></td></tr>
<tr><td valign=\"top\"> HeatLosses </td>
    <td valign=\"top\"> Demonstrate the modeling of heat losses. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Fittings.Bends</b></td></tr>
<tr><td valign=\"top\"> CurvedBend<br>
                      EdgedBend</td>
    <td valign=\"top\"> New fitting (pressure loss) components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Fittings.Orifices.</b></td></tr>
<tr><td valign=\"top\"> ThickEdgedOrifice</td>
    <td valign=\"top\"> New fitting (pressure loss) component. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Fittings.GenericResistances.</b></td></tr>
<tr><td valign=\"top\"> VolumeFlowRate</td>
    <td valign=\"top\"> New fitting (pressure loss) component. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math</b></td></tr>
<tr><td valign=\"top\"> isEqual </td>
    <td valign=\"top\"> Determine if two Real scalars are numerically identical. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Vectors</b></td></tr>
<tr><td valign=\"top\"> find </td>
    <td valign=\"top\"> Find element in vector. </td> </tr>
<tr><td valign=\"top\"> toString </td>
    <td valign=\"top\"> Convert a real vector to a string. </td> </tr>
<tr><td valign=\"top\"> interpolate </td>
    <td valign=\"top\"> Interpolate in a vector. </td> </tr>
<tr><td valign=\"top\"> relNodePositions </td>
    <td valign=\"top\"> Return vector of relative node positions (0..1). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Vectors.Utilities</b></td></tr>
<tr><td valign=\"top\"> householderVector<br>
                      householderReflection<br>
                      roots </td>
    <td valign=\"top\"> Utility functions for vectors that are used by the newly introduced functions,
                      but are only of interested for a specialist. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Matrices</b></td></tr>
<tr><td valign=\"top\"> continuousRiccati<br>
                      discreteRiccati </td>
    <td valign=\"top\"> Return solution of continuous-time and discrete-time
                      algebraic Riccati equation respectively. </td> </tr>
<tr><td valign=\"top\"> continuousSylvester<br>
                      discreteSylvester </td>
    <td valign=\"top\"> Return solution of continuous-time and discrete-time
                      Sylvester equation respectively. </td> </tr>
<tr><td valign=\"top\"> continuousLyapunov<br>
                      discreteLyapunov </td>
    <td valign=\"top\"> Return solution of continuous-time and discrete-time
                      Lyapunov equation respectively. </td> </tr>
<tr><td valign=\"top\"> trace </td>
    <td valign=\"top\"> Return the trace of a matrix. </td> </tr>
<tr><td valign=\"top\"> conditionNumber </td>
    <td valign=\"top\"> Compute the condition number of a matrix. </td> </tr>
<tr><td valign=\"top\"> rcond </td>
    <td valign=\"top\"> Estimate the reciprocal condition number of a matrix. </td> </tr>
<tr><td valign=\"top\"> nullSpace </td>
    <td valign=\"top\"> Return a orthonormal basis for the null space of a matrix. </td> </tr>
<tr><td valign=\"top\"> toString </td>
    <td valign=\"top\"> Convert a matrix into its string representation. </td> </tr>
<tr><td valign=\"top\"> flipLeftRight </td>
    <td valign=\"top\"> Flip the columns of a matrix in left/right direction. </td> </tr>
<tr><td valign=\"top\"> flipUpDown </td>
    <td valign=\"top\"> Flip the rows of a matrix in up/down direction. </td> </tr>
<tr><td valign=\"top\"> cholesky </td>
    <td valign=\"top\"> Perform Cholesky factorization of a real symmetric positive definite matrix. </td> </tr>
<tr><td valign=\"top\"> hessenberg </td>
    <td valign=\"top\"> Transform a matrix to upper Hessenberg form. </td> </tr>
<tr><td valign=\"top\"> realSchur </td>
    <td valign=\"top\"> Computes the real Schur form of a matrix. </td> </tr>
<tr><td valign=\"top\"> frobeniusNorm </td>
    <td valign=\"top\"> Return the Frobenius norm of a matrix. </td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.LAPACK.</b></td></tr>
<tr><td valign=\"top\"> dtrevc<br>
                      dpotrf<br>
                      dtrsm<br>
                      dgees<br>
                      dtrsen<br>
                      dgesvx<br>
                      dhseqr<br>
                      dlange<br>
                      dgecon<br>
                      dgehrd<br>
                      dgeqrf<br>
                      dggevx<br>
                      dgesdd<br>
                      dggev<br>
                      dggevx<br>
                      dhgeqz<br>
                      dormhr<br>
                      dormqr<br>
                      dorghr</td>
    <td valign=\"top\"> New interface functions for LAPACK
                      (should usually not directly be used but only indirectly via
                      Modelica.Math.Matrices). </td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.Utilities.</b></td></tr>
<tr><td valign=\"top\"> reorderRSF<br>
                      continuousRiccatiIterative<br>
                      discreteRiccatiIterative<br>
                      eigenvaluesHessenberg<br>
                      toUpperHessenberg<br>
                      householderReflection<br>
                      householderSimilarityTransformation<br>
                      findLokal_tk</td>
    <td valign=\"top\"> Utility functions for matrices that are used by the newly introduced functions,
                      but are only of interested for a specialist. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Nonlinear</b></td></tr>
<tr><td valign=\"top\"> quadratureLobatto </td>
    <td valign=\"top\"> Return the integral of an integrand function using an adaptive Lobatto rule.</td> </tr>
<tr><td valign=\"top\"> solveOneNonlinearEquation </td>
    <td valign=\"top\"> Solve f(u) = 0 in a very reliable and efficient way
                      (f(u_min) and f(u_max) must have different signs). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Nonlinear.Examples.</b></td></tr>
<tr><td valign=\"top\"> quadratureLobatto1<br>
                      quadratureLobatto2<br>
                      solveNonlinearEquations1<br>
                      solveNonlinearEquations2 </td>
    <td valign=\"top\"> Examples that demonstrate the usage of the Modelica.Math.Nonlinear functions
                      to integrate over functions and to solve scalar nonlinear equations. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.BooleanVectors.</b></td></tr>
<tr><td valign=\"top\"> allTrue </td>
    <td valign=\"top\"> Returns true, if all elements of the Boolean input vector are true. </td> </tr>
<tr><td valign=\"top\"> anyTrue </td>
    <td valign=\"top\"> Returns true, if at least on element of the Boolean input vector is true. </td> </tr>
<tr><td valign=\"top\"> oneTrue </td>
    <td valign=\"top\"> Returns true, if exactly one element of the Boolean input vector is true. </td> </tr>
<tr><td valign=\"top\"> firstTrueIndex </td>
    <td valign=\"top\"> Returns the index of the first element of the Boolean vector that
                      is true and returns 0, if no element is true </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
<tr><td valign=\"top\"> Information<br>
                      Contact<br>
                      ReleaseNotes<br>
                      References<br>
                      ExamplesPackage<br>
                      Example<br>
                      Package<br>
                      BasesPackage<br>
                      VariantsPackage<br>
                      InterfacesPackage<br>
                      SourcesPackage<br>
                      SensorsPackage<br>
                      MaterialPropertiesPackage<br>
                      MaterialProperty </td>
    <td valign=\"top\"> New icons to get a unified view on different categories
                      of packages. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
<tr><td valign=\"top\"> ComplexCurrent<br>
                      ComplexCurrentSlope<br>
                      ComplexCurrentDensity<br>
                      ComplexElectricPotential<br>
                      ComplexPotentialDifference<br>
                      ComplexVoltage<br>
                      ComplexVoltageSlope<br>
                      ComplexElectricFieldStrength<br>
                      ComplexElectricFluxDensity<br>
                      ComplexElectricFlux<br>
                      ComplexMagneticFieldStrength<br>
                      ComplexMagneticPotential<br>
                      ComplexMagneticPotentialDifference<br>
                      ComplexMagnetomotiveForce<br>
                      ComplexMagneticFluxDensity<br>
                      ComplexMagneticFlux<br>
                      ComplexReluctance<br>
                      ComplexImpedance<br>
                      ComplexAdmittance<br>
                      ComplexPower</td>
    <td valign=\"top\"> SIunits to be used in physical models using complex variables, e.g.,<br>
                      <a href=\"modelica://Modelica.Electrical.QuasiStationary\">Modelica.Electrical.QuasiStationary</a>,
                      <a href=\"modelica://Modelica.Magnetic.FundamentalWave\">Modelica.Magnetic.FundamentalWave</a> </td> </tr>
<tr><td valign=\"top\"> ImpulseFlowRate<br>
                      AngularImpulseFlowRate</td>
    <td valign=\"top\"> New SIunits for mechanics.</td> </tr>
</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b> in a
<b style=\"color:blue\">backward compatible</b> way:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\"> Pulse<br>
                      SawTooth </td>
    <td valign=\"top\"> New parameter \"nperiod\" introduced to define the number of periods
                      for the signal type. Default is \"infinite number of periods
                      (nperiods=-1).</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.</b></td></tr>
<tr><td valign=\"top\"> MultiPhase.*</td>
    <td valign=\"top\"> All dissipative components have now an optional heatPort connector
                      to which the dissipated losses are transported in form of heat.
                       </td> </tr>
<tr><td valign=\"top\"> Machines.*</td>
    <td valign=\"top\"> To all electric machines (asynchronous and synchronous induction machines, DC machines)
                      and transformers loss models have been added (where applicable): <br>
                      Temperature dependent resistances (ohmic losses) <br>
                      Friction losses <br>
                      Brush losses <br>
                      Stray Load losses <br>
                      Core losses (only eddy current losses but no hysteresis losses; not for transformers) <br>
                      As default, temperature dependency and losses are set to zero. <br><br>
                      To all electric machines (asynchronous and synchronous induction machines, DC machines)
                      and transformers conditional thermal ports have been added,
                      to which the dissipated losses are flowing, if activated.
                      The thermal port contains a <a href=\"modelica://Modelica.Thermal.HeatTransfer.Interfaces.HeatPort\">HeatPort</a>
                      for each loss source of the specific machine type. <br><br>
                      To all electric machines (asynchronous and synchronous induction machines, DC machines)
                      a \"powerBalance\" result record has been added, summarizing converted power and losses.
                       </td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.</b></td></tr>
<tr><td valign=\"top\"> MultiBody.*<br>
                      Rotational.*<br>
                      Translational.*</td>
    <td valign=\"top\"> All dissipative components in Modelica.Mechanics have now an
                      optional heatPort connector to which the dissipated energy is
                      transported in form of heat.<br>
                      All icons in Modelica.Mechanics are unified according to the
                      Modelica.Blocks library:<br>
                      \"%name\": width: -150 .. 150, height: 40, color: blue<br>
                      other text: height: 30, color: black
                       </td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\"> World </td>
    <td valign=\"top\"> Function gravityAcceleration is made replaceable, so that redeclaration
                      yields user-defined gravity fields.
                       </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Valves.</b></td></tr>
<tr><td valign=\"top\"> ValveIncompressible<br>
                      ValveVaporizing<br>
                      ValveCompressible</td>
    <td valign=\"top\"> (a) Optional filtering of opening signal introduced to model
                      the delay time of the opening/closing drive. In this case, an optional
                      leakageOpening can be defined to model leakage flow and/or to
                      improve the numerics in certain situations.
                      (b) Improved regularization of the valve characteristics in some cases
                      so that it is twice differentiable (smooth=2),
                      instead of continuous (smooth=0).</td>
                      </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Sources.</b></td></tr>
<tr><td valign=\"top\"> FixedBoundary<br>
                      Boundary_pT<br>
                      Boundary_ph</td>
    <td valign=\"top\"> Changed the implementation so that no non-linear algebraic
                      equation system occurs, if the given variables (e.g. p,T,X) do
                      not correspond to the medium states (e.g. p,h,X). This is
                      achieved by using appropriate \"setState_xxx\" calls to compute the
                      medium state from the given variables. If a nonlinear equation
                      system occurs, it is solved by a specialized handler inside the
                      setState_xxx(..) function, but in the model this equation system is
                      not visible.</td>
                      </tr>

<tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialMedium </td>
    <td valign=\"top\"> The min/max values of types SpecificEnthalpy, SpecificEntropy,
                      SpecificHeatCapacity increased, due to reported user problems.<br>
                      New constant C_nominal introduced to provide nominal values for
                      trace substances (utilized in Modelica.Fluid to avoid numerical problems;
                      this fixes ticket
                      <a href=\"https://trac.modelica.org/Modelica/ticket/393\">#393</a>).</td>
                      </tr>

<tr><td colspan=\"2\"><b>Modelica.Thermal.</b></td></tr>
<tr><td valign=\"top\"> HeatTransfer.*</td>
    <td valign=\"top\"> All icons are unified according to the
                      Modelica.Blocks library:<br>
                      \"%name\": width: -150 .. 150, height: 40, color: blue<br>
                      other text: height: 30, color: black
                       </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Matrices</b></td></tr>
<tr><td valign=\"top\"> QR </td>
    <td valign=\"top\"> A Boolean input \"pivoting\" has been added (now QR(A, pivoting)) to provide QR-decomposition without pivoting (QR(A, false)). Default is pivoting=true.</td> </tr>
</table>

<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e., errors
that can lead to wrong simulation results):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.Delay.</b></td></tr>
<tr><td valign=\"top\"> InertialDelaySensitive </td>
    <td valign=\"top\"> In order to decide whether the rising delay (tLH) or
                      the falling delay (tHL) is used, the \"previous\" value of the
                      output y has to be used and not the \"previous\" value of the
                      input x (delayType = delayTable[y_old, x] and not
                      delayType = delayTable[x_old, x]). This has been corrected.</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> BodyBox<br>
                      BodyCylinder </td>
    <td valign=\"top\"> Fixes ticket
                      <a href=\"https://trac.modelica.org/Modelica/ticket/373\">#373</a>:
                      The \"Center of Mass\" was calculated as normalize(r)*length/2. This is
                      only correct if the box/cylinder is attached between frame_a and frame_b.
                      If this is not the case, the calculation is wrong.
                      The has been fixed by using the correct formula:<br>
                      r_shape + normalize(lengthDirection)*length/2</td></tr>
<tr><td valign=\"top\"> BodyShape<br>
                      BodyBox<br>
                      BodyCylinder </td>
    <td valign=\"top\"> Fixes ticket
                      <a href=\"https://trac.modelica.org/Modelica/ticket/300\">#300</a>:
                      If parameter enforceStates=true, an error occurred.
                      This has been fixed.</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.Components.</b></td></tr>
<tr><td valign=\"top\"> LossyGear</td>
    <td valign=\"top\"> In cases where the driving flange is not obvious, the component could
                      lead to a non-convergent event iteration. This has been fixed
                      (a detailed description is provided in ticket
                      <a href=\"https://trac.modelica.org/Modelica/ticket/108\">#108</a>
                      and in the
                      <a href=\"modelica://Modelica/Resources/Documentation/Mechanics/Lossy-Gear-Bug_Solution.pdf\">attachment</a>
                      of this ticket).</td> </tr>

<tr><td valign=\"top\"> Gearbox</td>
    <td valign=\"top\"> If useSupport=false, the support flange of the internal LossyGear
                      model was connected to the (disabled) support connector. As a result, the
                      LossyGear was \"free floating\". This has been corrected.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Pipes.</b></td></tr>
<tr><td valign=\"top\"> DynamicPipe</td>
    <td valign=\"top\"> Bug fix for dynamic mass, energy and momentum balances
                      for pipes with nParallel&gt;1.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.</b></td></tr>
<tr><td valign=\"top\"> PartialPipeFlowHeatTransfer</td>
    <td valign=\"top\"> Calculation of Reynolds numbers for the heat transfer through
                      walls corrected, if nParallel&gt;1.
                      This partial model is used by LocalPipeFlowHeatTransfer
                      for laminar and turbulent forced convection in pipes.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.PartialLinearFluid</b></td></tr>
<tr><td valign=\"top\"> setState_psX</td>
    <td valign=\"top\"> Sign error fixed.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Media.CompressibleLiquids.</b></td></tr>
<tr><td valign=\"top\"> LinearColdWater</td>
    <td valign=\"top\"> Fixed wrong values for thermal conductivity and viscosity.</td> </tr>

</table>

<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e., errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g.,
units are wrong or errors in documentation):
</p>
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.LAPACK</b></td></tr>
<tr><td valign=\"top\"> dgesv_vec<br>
                        dgesv<br>
                        dgetrs<br>
                        dgetrf<br>
                        dgetrs_vec<br>
                        dgetri<br>
                        dgeqpf<br>
                        dorgqr<br>
                        dgesvx<br>
                        dtrsyl</td>
    <td valign=\"top\"> Integer inputs to specify leading dimensions of matrices have got a lower bound 1 (e.g., lda=max(1,n))
                      to avoid incorrect values (e.g., lda=0) in the case of empty matrices.<br>
                      The Integer variable \"info\" to indicate the successful call of a LAPACK routine has been converted to an output where it had been a protected variable. </td> </tr>
</table>

<p><br>
The following
<a href=\"http://trac.modelica.org/Modelica\">trac tickets</a>
have been fixed:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica</b></td></tr>
<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/155\">#155</a></td>
    <td valign=\"top\">Wrong usage of \"fillColor\" and \"fillPattern\" annotations for lines</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/211\">#211</a></td>
    <td valign=\"top\">Undefined function realString used in MSL</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/216\">#216</a></td>
    <td valign=\"top\">Make MSL version 3.2 more Modelica 3.1 conform</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/218\">#218</a></td>
    <td valign=\"top\">Replace `Modelica://`-URIs by `modelica://`-URIs</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/271\">#271</a></td>
    <td valign=\"top\">Documentation URI errors in MSL 3.1</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/292\">#292</a></td>
    <td valign=\"top\">Remove empty \"\" annotations\"</td>
</tr>
<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/294\">#294</a></td>
    <td valign=\"top\">Typo 'w.r.t' --> 'w.r.t.'</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/296\">#296</a></td>
    <td valign=\"top\">Unify disclaimer message and improve bad style \"here\" links</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/333\">#333</a></td>
    <td valign=\"top\">Fix real number formats of the form `.[0-9]+`</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/347\">#347</a></td>
    <td valign=\"top\">invalid URI in MSL 3.2</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/355\">#355</a></td>
    <td valign=\"top\">Non-standard annotations</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Blocks</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/227\">#227</a></td>
    <td valign=\"top\">Enhance unit deduction functionality by adding 'unit=\"1\"' to some blocks\"</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/349\">#349</a></td>
    <td valign=\"top\">Incorrect annotation in Blocks/Continuous.mo</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/374\">#374</a></td>
    <td valign=\"top\">Parameter with no value at all in Modelica.Blocks.Continuous.TransferFunction</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Constants</b></td></tr>
<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/356\">#356</a></td>
    <td valign=\"top\">Add Euler-Mascheroni constant to Modelica.Constants</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Electrical.Analog</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/346\">#346</a></td>
    <td valign=\"top\">Multiple text in Modelica.Electrical.Analog.Basic.Conductor</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/363\">#363</a></td>
    <td valign=\"top\">Mixture of Real and Integer in index expressions in Modelica.Electrical.Analog.Lines</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/384\">#384</a></td>
    <td valign=\"top\">Incomplete annotations in some examples</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/396\">#396</a></td>
    <td valign=\"top\">Bug in Modelica.Electrical.Analog.Ideal.ControlledIdealIntermediateSwitch</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Machines</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/276\">#276</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Electrical.Machines</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/288\">#288</a></td>
    <td valign=\"top\">Describe thermal concept of machines</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/301\">#301</a></td>
    <td valign=\"top\">Documentation of Electrical.Machines.Examples needs update</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/306\">#306</a></td>
    <td valign=\"top\">Merge content of `Modelica.Electrical.Machines.Icons` into `Modelica.Icons`</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/362\">#362</a></td>
    <td valign=\"top\">Incomplete example model for DC machines</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/375\">#375</a></td>
    <td valign=\"top\">Strangeness with final parameters with no value but a start value</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Electrical.MultiPhase</b></td></tr>
<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/173\">#173</a></td>
    <td valign=\"top\">m-phase mutual inductor</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/200\">#200</a></td>
    <td valign=\"top\">adjust Multiphase to Analog</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/277\">#277</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Electrical.Multiphase</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/352\">#352</a></td>
    <td valign=\"top\">Odd annotation in Modelica.Electrical.MultiPhase.Sources.SignalVoltage</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Fluid</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/215\">#215</a></td>
    <td valign=\"top\">Bug in Modelica.Fluid.Pipes.DynamicPipe</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/219\">#219</a></td>
    <td valign=\"top\">Fluid.Examples.HeatExchanger: Heat transfer is switched off and cannot be enabled</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Math</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/348\">#348</a></td>
    <td valign=\"top\">Small error in documentation</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/371\">#371</a></td>
    <td valign=\"top\">Modelica.Math functions declared as \"C\" not \"builtin\"\"</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Mechanics.MultiBody</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/50\">#50</a></td>
    <td valign=\"top\">Error in LineForce handling of potential root</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/71\">#71</a></td>
    <td valign=\"top\">Make MultiBody.World replaceable</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/181\">#181</a></td>
    <td valign=\"top\">3d surface visualisation</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/210\">#210</a></td>
    <td valign=\"top\">Description of internal gear wheel missing</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/242\">#242</a></td>
    <td valign=\"top\">Missing each qualifier for modifiers in MultiBody.</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/251\">#251</a></td>
    <td valign=\"top\">Using enforceStates=true for BodyShape causes errors</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/255\">#255</a></td>
    <td valign=\"top\">Error in Revolute's handling of non-normalized axis of rotations</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/268\">#268</a></td>
    <td valign=\"top\">Non-standard annotation in MultiBody,Examples.Systems.RobotR3</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/269\">#269</a></td>
    <td valign=\"top\">What is the purpose of MultiBody.Examples.Systems.RobotR3.Components.InternalConnectors?</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/272\">#272</a></td>
    <td valign=\"top\">Function World.gravityAcceleration should not be protected</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/274\">#274</a></td>
    <td valign=\"top\">Convenient and mighty  initialization of frame kinematics</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/286\">#286</a></td>
    <td valign=\"top\">Typo in Multibody/Frames.mo</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/300\">#300</a></td>
    <td valign=\"top\">enforceStates parameter managed incorrectly in BodyShape, BodyBox, BodyCylinder</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/320\">#320</a></td>
    <td valign=\"top\">Replace non-standard annotation by `showStartAttribute`</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/373\">#373</a></td>
    <td valign=\"top\">Error in Modelica Mechanics</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/389\">#389</a></td>
    <td valign=\"top\">Shape.rxvisobj wrongly referenced in Arrow/DoubleArrow</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Mechanics.Rotational</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/108\">#108</a></td>
    <td valign=\"top\">Problem with model \"Lossy Gear\" and approach to a solution</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/278\">#278</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Mechanics.Rotational</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/381\">#381</a></td>
    <td valign=\"top\">Bug in Modelica.Mechanics.Rotational.Gearbox</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Mechanics.Translational</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/279\">#279</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Mechanics.Translational</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/310\">#310</a></td>
    <td valign=\"top\">Erroneous image links in `Modelica.Mechanics.Translational`</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Media</b></td></tr>
<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/72\">#72</a></td>
    <td valign=\"top\">PartialMedium functions not provided for all media in  Modelica.Media</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/217\">#217</a></td>
    <td valign=\"top\">Missing image file Air.png</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/224\">#224</a></td>
    <td valign=\"top\">dpT calculation in waterBaseProp_dT</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/393\">#393</a></td>
    <td valign=\"top\">Provide C_nominal in Modelica.Media to allow propagating
                     value and avoid wrong numerical results</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.StateGraph</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/206\">#206</a></td>
    <td valign=\"top\">Syntax error in StateGraph.mo</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/261\">#261</a></td>
    <td valign=\"top\">Modelica.StateGraph should mention the availability of Modelica_StateGraph2</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/354\">#354</a></td>
    <td valign=\"top\">Bad annotation in Modelica.StateGraph.Temporary.NumericValue</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Thermal.FluidHeatFlow</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/280\">#280</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Thermal.FluidHeatFlow</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Thermal.HeatTransfer</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/281\">#281</a></td>
    <td valign=\"top\">Improve/fix documentation of Modelica.Thermal.HeatTransfer</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.UsersGuide</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/198\">#198</a></td>
    <td valign=\"top\">Name of components in MSL not according to naming conventions</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/204\">#204</a></td>
    <td valign=\"top\">Minor correction to User's Guide's section on version management</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/244\">#244</a></td>
    <td valign=\"top\">Update the contacts section of the User's Guide</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/267\">#267</a></td>
    <td valign=\"top\">MSL-Documentation: Shouldn't equations be numbered on the right hand side?</td>
</tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/299\">#299</a></td>
    <td valign=\"top\">SVN keyword expansion messed up the User's guide section on version management</td>
</tr>

<tr><td colspan=\"2\"><br><b>Modelica.Utilities</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/249\">#249</a></td>
    <td valign=\"top\">Documentation error in ModelicaUtilities.h</td>
</tr>

<tr><td colspan=\"2\"><br><b>ModelicaServices</b></td></tr>

<tr><td valign=\"top\">
    <a href=\"https://trac.modelica.org/Modelica/ticket/248\">#248</a></td>
    <td valign=\"top\">No uses statement on ModelicaServices in MSL 3.1</td>
</tr>

</table>

<p>
Note:
</p>
<ul>
<li> Libraries
     <a href=\"https://www.modelica.org/libraries/Modelica_FundamentalWave\">Modelica_FundamentalWave</a>
     and
     <a href=\"https://www.modelica.org/libraries/Modelica_QuasiStationary\">Modelica_QuasiStationary</a>
     are included in this version in an improved form.</li>
<li> From library
     <a href=\"https://www.modelica.org/libraries/Modelica_LinearSystems2\">Modelica_LinearSystems2</a>,
     the sublibraries
     Math.Complex, Math.Vectors and Math.Matrices are included in this version
     in an improved form.</li>
<li> From library
     <a href=\"https://www.modelica.org/libraries/Modelica_StateGraph2\">Modelica_StateGraph2</a>,
     the sublibrary Blocks is included in this version in an improved form.</li>
</ul>
</html>"));
      end Version_3_2;

      class Version_3_1 "Version 3.1 (August 14, 2009)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p>
Version 3.1 is backward compatible to version 3.0 and 3.0.1,
i.e., models developed with version 3.0 or 3.0.1 will work without any
changes also with version 3.1.
</p>

<p>
Version 3.1 is slightly based on the Modelica Specification 3.1. It uses
the following new language elements (compared to Modelica Specification 3.0):
</p>

<ul>
<li> Prefix <u>stream</u> and built-in operators <u>inStream(..)</u>
     and <u>actualStream(..)</u> in Modelica.Fluid.</li>
<li> Annotation <u>connectorSizing</u> in Modelica.Fluid.</li>
<li> Annotation <u>inverse</u> in Modelica.Media.</li>
<li> Annotations <u>versionBuild</u>, <u>dateModified</u>,
     <u>revisionId</u> at the root level annotation of package Modelica,
     to improve the version handling.</li>
<li> Modifiers can be used in connectors instances (so balanced models
     are less restrictive). This allowed to make the implementation
     of conditional connectors (support and heatPort) in the Rotational,
     Translational and Electrical libraries simpler.</li>
</ul>

<p>
The following <b style=\"color:blue\">new libraries</b> have been added:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Fluid\">Modelica.Fluid</a></td>
    <td valign=\"top\">
     Components to model 1-dim. thermo-fluid flow in networks of vessels, pipes,
     fluid machines, valves and fittings. All media from the
     Modelica.Media library can be used (so incompressible or compressible,
     single or multiple substance, one or two phase medium).
    The library is using the stream-concept from Modelica Specification 3.1.
    </td>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Magnetic.FluxTubes\">Modelica.Magnetic.FluxTubes</a></td>
    <td valign=\"top\">
     Components to model magnetic devices based on the magnetic flux tubes concepts.
     Especially to model
     electro-magnetic actuators. Nonlinear shape, force, leakage, and
     Material models. Material data for steel, electric sheet, pure iron,
     Cobalt iron, Nickel iron, NdFeB, Sm2Co17, and more.
    </td>

<tr><td valign=\"top\"><a href=\"modelica://ModelicaServices\">ModelicaServices</a></td>
    <td valign=\"top\">
     New top level package that shall contain functions and models to be used in the
     Modelica Standard Library that requires a tool specific implementation.
     ModelicaServices is then used in the Modelica package.
     In this first version, the 3-dim. animation with model Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape
     was moved to ModelicaServices. Tool vendors can now provide their own implementation
     of the animation.
    </td>
</table>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
<tr><td valign=\"top\"> versionBuild<br>versionDate<br>dateModified<br>revisionId </td>
    <td valign=\"top\"> New annotations from Modelica 3.1 for version handling added.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.UsersGuide.ReleaseNotes.</b></td></tr>
<tr><td valign=\"top\"> VersionManagement </td>
    <td valign=\"top\"> Copied from info layer of previous ReleaseNotes (to make it more
                      visible) and adapted it to the new possibilities in
                      Modelica Specification 3.1.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
<tr><td valign=\"top\"> RectangularToPolar<br>
                      PolarToRectangular </td>
    <td valign=\"top\"> New blocks to convert between rectangular and polar form
                      of space phasors. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Routing.</b></td></tr>
<tr><td valign=\"top\"> Replicator </td>
    <td valign=\"top\"> New block to replicate an input signal to many output signals. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Examples.</b></td></tr>
<tr><td valign=\"top\"> AmplifierWithOpAmpDetailed<br>
                      HeatingResistor<br>
                      CompareTransformers<br>
                      OvervoltageProtection<br>
                      ControlledSwitchWithArc<br>
                      SwitchWithArc<br>
                      ThyristorBehaviourTest</td>
    <td valign=\"top\"> New examples to demonstrate the usage of new components. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\"> OpAmpDetailed<br>
                      TranslationalEMF<br>
                      M_Transformer</td>
    <td valign=\"top\"> New detailed model of an operational amplifier. <br>
                      New electromotoric force from electrical energy into mechanical translational energy.<br>
                      Generic transformer with choosable number of inductors</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal.</b></td></tr>
<tr><td valign=\"top\"> OpenerWithArc<br>
                      CloserWithArc<br>
                      ControlledOpenerWithArc<br>
                      ControlledCloserWithArc</td>
    <td valign=\"top\"> New switches with simple arc model. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> ConditionalHeatPort</td>
    <td valign=\"top\"> New partial model to add a conditional HeatPort to
                      an electrical component. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Lines.</b></td></tr>
<tr><td valign=\"top\"> M_Oline</td>
    <td valign=\"top\"> New multiple line model, both the number of lines and the number of segments choosable. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors.</b></td></tr>
<tr><td valign=\"top\"> ZDiode<br>Thyristor</td>
    <td valign=\"top\"> Zener Diode with 3 working areas and simple thyristor model. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Ideal.</b></td></tr>
<tr><td valign=\"top\"> OpenerWithArc<br>CloserWithArc</td>
    <td valign=\"top\"> New switches with simple arc model (as in Modelica.Electrical.Analog.Ideal. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Elementary.</b></td></tr>
<tr><td valign=\"top\"> RollingWheel<br>
                      RollingWheelSetDriving<br>
                      RollingWheelSetPulling</td>
    <td valign=\"top\"> New examples to demonstrate the usage of new components.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Joints.</b></td></tr>
<tr><td valign=\"top\"> RollingWheel<br>
                      RollingWheelSet</td>
    <td valign=\"top\"> New joints (no mass, no inertia) that describe an
                      ideal rolling wheel and a ideal rolling wheel set consisting
                      of two wheels rolling on the plane z=0.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> RollingWheel<br>
                      RollingWheelSet</td>
    <td valign=\"top\"> New ideal rolling wheel and ideal rolling wheel set consisting
                      of two wheels rolling on the plane z=0.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.</b></td></tr>
<tr><td valign=\"top\"> Ground</td>
    <td valign=\"top\"> New model to visualize the ground (box at z=0).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialElementaryOneFlangeAndSupport2<br>
                      PartialElementaryTwoFlangesAndSupport2</td>
    <td valign=\"top\"> New partial model with one and two flanges and the support flange
                      with a much simpler implementation as previously.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialElementaryOneFlangeAndSupport2<br>
                      PartialElementaryTwoFlangesAndSupport2</td>
    <td valign=\"top\"> New partial model with one and two flanges and the support flange
                      with a much simpler implementation as previously.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Media.IdealGases.Common.MixtureGasNasa.</b></td></tr>
<tr><td valign=\"top\"> setSmoothState</td>
    <td valign=\"top\"> Return thermodynamic state so that it smoothly approximates:
                      if x &gt; 0 then state_a else state_b.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Utilities.Internal.</b></td></tr>
<tr><td valign=\"top\"> PartialModelicaServices</td>
    <td valign=\"top\"> New package containing the interface description of
                      models and functions that require a tool dependent
                      implementation (currently only \"Shape\" for 3-dim. animation,
                      but will be extended in the future)</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Thermal.HeatTransfer.Components.</b></td></tr>
<tr><td valign=\"top\"> ThermalCollector</td>
    <td valign=\"top\"> New auxiliary model to collect the heat flows
                      from m heatports to a single heatport;
                      useful for multiphase resistors (with heatports)
                      as a junction of the m heatports.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
<tr><td valign=\"top\"> VariantLibrary<br>
                      BaseClassLibrary<br>
                      ObsoleteModel</td>
    <td valign=\"top\"> New icons (VariantLibrary and BaseClassLibrary have been moved
                      from Modelica_Fluid.Icons to this place).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
<tr><td valign=\"top\"> ElectricalForceConstant </td>
    <td valign=\"top\"> New type added (#190).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.SIunits.Conversions.</b></td></tr>
<tr><td valign=\"top\"> from_Hz<br>
                      to_Hz</td>
    <td valign=\"top\"> New functions to convert between frequency [Hz] and
                      angular velocity [1/s]. (#156) </td> </tr>

</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b> in a
<b style=\"color:blue\">backward compatible</b> way:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
<tr><td valign=\"top\"> Blocks<br>Mechanics<br>StateGraph </td>
    <td valign=\"top\"> Provided missing parameter values for examples
                      (these parameters had only start values)</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic</b></td></tr>
<tr><td valign=\"top\"> Resistor, Conductor, VariableResistor, VariableConductor</td>
    <td valign=\"top\"> Conditional heatport added for coupling to thermal network. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal</b></td></tr>
<tr><td valign=\"top\"> Thyristors, Switches, IdealDiode</td>
    <td valign=\"top\"> Conditional heatport added for coupling to thermal network. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors</b></td></tr>
<tr><td valign=\"top\"> Diode, ZDiode, PMOS, NMOS, NPN, PNP</td>
    <td valign=\"top\"> Conditional heatport added for coupling to thermal network. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Basic</b></td></tr>
<tr><td valign=\"top\"> Resistor, Conductor, VariableResistor, VariableConductor</td>
    <td valign=\"top\"> Conditional heatport added for coupling to thermal network (as in Modelica.Electrical.Analog). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase.Ideal</b></td></tr>
<tr><td valign=\"top\"> Thyristors, Switches, IdealDiode</td>
    <td valign=\"top\"> Conditional heatport added for coupling to thermal network (as in Modelica.Electrical.Analog). </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Visualizers.Advanced.</b></td></tr>
<tr><td valign=\"top\"> Shape </td>
    <td valign=\"top\"> New implementation by inheriting from ModelicaServices. This allows a
                      tool vendor to provide its own implementation of Shape. </td> </tr>
<tr><td colspan=\"2\"><b>Modelica.StateGraph.</b></td></tr>
<tr><td valign=\"top\"> Examples </td>
    <td valign=\"top\"> Introduced \"StateGraphRoot\" on the top level of all example models. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.StateGraph.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> StateGraphRoot<br>PartialCompositeStep<br>CompositeStepState </td>
    <td valign=\"top\"> Replaced the wrong Modelica code \"flow output Real xxx\"
                      by \"Real dummy; flow Real xxx;\".
                      As a side effect, several \"blocks\" had to be changed to \"models\". </td> </tr>
<tr><td valign=\"top\"> PartialStep </td>
    <td valign=\"top\"> Changed model by packing the protected outer connector in to a model.
                      Otherwise, there might be differences in the sign of the flow variable
                      in Modelica 3.0 and 3.1. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Utilities.Examples.</b></td></tr>
<tr><td valign=\"top\"> expression </td>
    <td valign=\"top\"> Changed local variable \"operator\" to \"opString\" since \"operator\"
                      is a reserved keyword in Modelica 3.1 </td> </tr>
</table>

<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e., errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g.,
units are wrong or errors in documentation):
</p>
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
<tr><td valign=\"top\"> Many models</td>
    <td valign=\"top\"> Removed wrong usages of annotations fillColor and fillPattern
                      in text annotations (#155, #185).</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines</b></td></tr>
<tr><td valign=\"top\"> All machine models</td>
    <td valign=\"top\"> The conditional heatports of the instantiated resistors
                        (which are new in Modelica.Electrical.Analog and Modelica.Electrical.MultiPhase)
                        are finally switched off until a thermal connector design for machines is implemented. </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Media.Air.MoistAir</b></td></tr>
<tr><td valign=\"top\"> saturationPressureLiquid<br>
                      sublimationPressureIce<br>
                      saturationPressure</td>
          <td valign=\"top\"> For these three functions, an error in the <code>derivative</code> annotation was corrected. However, the effect of
                            this bug was minor, as a Modelica tool was allowed to compute derivatives automatically via
                            the <code>smoothOrder</code> annotation.</td>
</tr>
<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.</b></td></tr>
<tr><td valign=\"top\"> eigenValues</td>
    <td valign=\"top\"> Wrong documentation corrected (#162)</td> </tr>
</table>

</html>"));
      end Version_3_1;

      class Version_3_0_1 "Version 3.0.1 (Jan. 27, 2009)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p>
This Modelica package is provided under the
<a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica License 2</a>
and no longer under Modelica License 1.1. There are the following reasons
why the Modelica Association changes from Modelica License 1.1 to this
new license text (note, the text below is not a legal interpretation of the
Modelica License 2. In case of a conflict, the language of the license shall prevail):
</p>

<ol>
<li> The rights of licensor and licensee are much more clearly defined. For example:
         <ul>
         <li> The licensed work (Original Work) can be used in unmodified form in
                  open source and commercial software (the licensee cannot change the
                  license and the work must be provided without fees)</li>
         <li> If a model component is copied out of a Modelica package under
                  Modelica License 2 and is modified in order to adapt it to the needs
                  of the modeler, then the result can be licensed under any license
                  (including a commercial license).</li>
         <li> It is practically not possible to change the license of a
                  Modelica package under Modelica License 2 to another license, i.e., a
                  licensee cannot change the license by adding material or changing classes,
                  so the work must remain under Modelica License 2 (to be more precise,
                  if the licensee makes modifications to the Original Work \"which represents,
                  as a whole, an original work of authorship\", he/she can change the license
                  to another license. However, for a Modelica package this would
                  require a lot of changes which is usually unrealistic).</li>
         <li> If an executable is constructed using a Modelica package under
                  Modelica License 2, then this executable can be licensed under any
                  license (including a commercial license).</li>
         </ul>
         We hope that this compromise between open source contributors, commercial
         Modelica environments and Modelica users will motivate even more people to
         provide their Modelica packages freely under the Modelica License 2.<br><br></li>
<li> There are several new provisions that shall make law suites against licensors and licensees more unlikely (so the small risk is further reduced).</li>
</ol>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\">M_Transformer</td>
          <td valign=\"top\"> Transformer, with the possibility to
        choose the number of inductors. The inductances and the coupled inductances
        can be chosen arbitrarily.</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Lines.</b></td></tr>
<tr><td valign=\"top\">M_OLine</td>
          <td valign=\"top\"> Segmented line model that enables the use of
        multiple lines, that means, the number of segments and the number of
        single lines can be chosen by the user. The model allows to investigate
        phenomena at multiple lines like mutual magnetic or capacitive influence.</td> </tr>
<tr><td colspan=\"2\"><b>Mechanics.Translational.Components.Examples.</b></td></tr>
<tr><td valign=\"top\">Brake</td>
          <td valign=\"top\"> Demonstrates the usage of the translational brake component.</td> </tr>
<tr><td colspan=\"2\"><b>Media.Interfaces.PartialMedium.</b></td></tr>
<tr><td valign=\"top\">ThermoStates</td>
          <td valign=\"top\"> Enumeration type for independent variables to identify the independent
                                                variables of the medium (pT, ph, phX, pTX, dTX).<br>
                                                An implementation of this enumeration is provided for every medium.
                                                (This is useful for fluid libraries that do not use the
                                                PartialMedium.BaseProperties model). </td> </tr>
<tr><td valign=\"top\">setSmoothState</td>
          <td valign=\"top\"> Function that returns the thermodynamic state which smoothly approximates:
                                                if x > 0 then state_a else state_b.<br>
                                                (This is useful for pressure drop components in fluid libraries
                                                 where the upstream density and/or viscosity has to be computed
                                                 and these properties should be smooth a zero mass flow rate)<br>
                                                An implementation of this function is provided for every medium.</td> </tr>
<tr><td colspan=\"2\"><b>Media.Common.</b></td></tr>
<tr><td valign=\"top\">smoothStep</td>
          <td valign=\"top\"> Approximation of a general step, such that the characteristic
                                                is continuous and differentiable.</td> </tr>
<tr><td colspan=\"2\"><b>Media.UsersGuide.</b></td></tr>
<tr><td valign=\"top\">Future</td>
          <td valign=\"top\"> Short description of goals and changes of upcoming release of Modelica.Media. </td> </tr>
<tr><td colspan=\"2\"><b>Media.Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\">isentropicExponent</td>
          <td valign=\"top\"> Implemented Missing Function from interface. </td> </tr>
<tr><td valign=\"top\">isentropicEnthalpyApproximation</td>
<td valign=\"top\"> Implemented function that approximates the isentropic enthalpy change.
This is only correct as long as there is no liquid in the stream.</td> </tr>
</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">changed</b> (in a
<b style=\"color:blue\">backward compatible</b> way):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Mechanics.Rotational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialFriction </td>
          <td valign=\"top\"> Improvement of friction model so that in certain situations
                                                the number of iterations is much smaller.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Components.Examples.</b></td></tr>
<tr><td valign=\"top\"> Friction </td>
          <td valign=\"top\"> Added a third variant, where friction is modelled with
                                                the SupportFriction component.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Components.</b></td></tr>
<tr><td valign=\"top\"> MassWithStopAndFriction </td>
          <td valign=\"top\"> Improvement of friction model so that in certain situations
                                                the number of iterations is much smaller.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialFriction </td>
          <td valign=\"top\"> Improvement of friction model so that in certain situations
                                                the number of iterations is much smaller.</td>
</tr>

<tr><td colspan=\"2\"><b>Media.Examples.</b></td></tr>
<tr><td valign=\"top\"> SimpleLiquidWater <br>
                                                IdealGasH20 <br>
                                                WaterIF97 <br>
                                                MixtureGases <br>
                                                MoistAir </td>
          <td valign=\"top\"> Added equations to test the new setSmoothState(..) functions
                                                including the analytic derivatives of these functions.</td> </tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialLinearFluid.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX <br>
                                                setState_phX <br>
                                                setState_psX <br>
                                                setState_dTX </td>
          <td valign=\"top\"> Rewritten function in one statement so that it is usually inlined.</td> </tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialLinearFluid.</b></td></tr>
<tr><td valign=\"top\"> consistent use of reference_d instead of density(state </td>
          <td valign=\"top\"> Change was done to achieve consistency with analytic inverse functions.</td> </tr>

<tr><td colspan=\"2\"><b>Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\"> T_phX </td>
          <td valign=\"top\"> Interval of nonlinear solver to compute T from p,h,X changed
                                                from 200..6000 to 240 ..400 K.</td> </tr>

</table>

<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e., errors
that can lead to wrong simulation results):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces</b></td></tr>
<tr><td valign=\"top\"> WorldTorque </td>
          <td valign=\"top\"> Parameter \"ResolveInFrame\" was not propagated and therefore
                                                always the default (resolved in world frame) was used, independently
                                                of the setting of this parameter. </td>
</tr>
<tr><td valign=\"top\"> WorldForceAndTorque </td>
          <td valign=\"top\"> Parameter \"ResolveInFrame\" was not propagated and therefore
                                                always the default (resolved in world frame) was used, independently
                                                of the setting of this parameter.<br>
                                                Furthermore, internally WorldTorque was used instead of
                                                Internal.BasicWorldTorque and therefore the visualization of
                                                worldTorque was performed twice. </td>
</tr>
<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors</b></td></tr>
<tr><td valign=\"top\"> AbsoluteSensor </td>
          <td valign=\"top\"> Velocity, acceleration and angular acceleration were computed
                                                  by differentiating in the resolveInFrame frame. This has been corrected, by
                                                  first transforming the vectors in to the world frame, differentiating here
                                                  and then transforming into resolveInFrame. The parameter in the Advanced menu
                                                  resolveInFrameAfterDifferentiation is then superfluous and was removed . </td>
</tr>
<tr><td valign=\"top\"> AbsoluteVelocity </td>
          <td valign=\"top\"> The velocity was computed
                                                  by differentiating in the resolveInFrame frame. This has been corrected, by
                                                  first transforming the velocity in to the world frame, differentiating here
                                                  and then transforming into resolveInFrame </td>
</tr>
<tr><td valign=\"top\"> RelativeSensor </td>
          <td valign=\"top\"> If resolveInFrame &lt;&gt; frame_resolve and
                                                   resolveInFrameAfterDifferentiation = frame_resolve, a translation
                                                error occurred, since frame_resolve was not enabled in this situation.
                                                This has been corrected.</td>
</tr>
<tr><td valign=\"top\"> RelativeVelocity </td>
          <td valign=\"top\"> The velocity has have been computed
                                                  by differentiating in the resolveInFrame frame. This has been corrected, by
                                                  first transforming the relative position in to frame_a, differentiating here
                                                  and then transforming into resolveInFrame </td>
</tr>
<tr><td valign=\"top\"> TransformRelativeVector </td>
          <td valign=\"top\"> The transformation was wrong, since the parameters frame_r_in and frame_r_out
                                                have not been propagated to the submodel that performs the transformation.
                                                This has been corrected. </td>
</tr>
<tr><td colspan=\"2\"><b>Mechanics.Translational.Components.</b></td></tr>
<tr><td valign=\"top\"> SupportFriction<br>
                                                Brake </td>
          <td valign=\"top\"> The sign of the friction force was wrong and therefore friction accelerated
                                                instead of decelerated. This was fixed. </td>
<tr><td valign=\"top\"> SupportFriction</td>
          <td valign=\"top\"> The component was only correct for fixed support.
                                                This was corrected. </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialSimpleMedium<br>
                                                PartialSimpleIdealGasMedium </td>
          <td valign=\"top\"> BaseProperties.p was not defined as preferred state and BaseProperties.T was
                                                always defined as preferred state. This has been fixed by
                                                Defining p,T as preferred state if parameter preferredMediumState = true.
                                                This error had the effect that mass m is selected as state instead of p
                                                and if default initialization is used then m=0 could give not the expected
                                                behavior. This means, simulation is not wrong but the numerics is not as good
                                                and if a model relies on default initial values, the result could be not
                                                as expected. </td>
</tr>

</table>

<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e., errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g.,
units are wrong or errors in documentation):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
<tr><td valign=\"top\"> InverseBlockConstraint </td>
          <td valign=\"top\"> Changed annotation preserveAspectRatio from true to false.</td>
</tr>

<tr><td colspan=\"2\"><b>Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\"> RealExpression<br>
                                                IntegerExpression<br>
                                                BooleanExpression </td>
          <td valign=\"top\"> Changed annotation preserveAspectRatio from true to false.</td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\"> SaturatingInductor</td>
          <td valign=\"top\"> Replaced non-standard \"arctan\" by \"atan\" function.</td>
</tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Digital.</b></td></tr>
<tr><td valign=\"top\"> UsersGuide</td>
          <td valign=\"top\"> Removed empty documentation placeholders and added the missing
                                                  release comment for version 1.0.7</td>
</tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.Components.</b></td></tr>
<tr><td valign=\"top\"> MassWithStopAndFriction </td>
          <td valign=\"top\"> Changed usage of reinit(..), in order that it appears
                                                only once for one variable according to the language specification
                                                (if a tool could simulate the model, there is no difference).</td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialSimpleMedium</b></td></tr>
<tr><td valign=\"top\"> pressure<br>
                                                temperature<br>
                                                density<br>
                                                specificEnthalpy </td>
          <td valign=\"top\"> Missing functions added.</td>
</tr>

</table>

</html>"));
      end Version_3_0_1;

      class Version_3_0 "Version 3.0 (March 1, 2008)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>
Version 3.0 is <b>not</b> backward compatible to previous versions.
A conversion script is provided to transform models and libraries
of previous versions to the new version. Therefore, conversion
should be automatic.
</p>

<p>
The following changes are present for the whole library:
</p>

<ul>
<li> In the Modelica language version 3.0, several restrictions have been
         introduced to allow better checking, e.g., models on all levels must be balanced
         (number of equations = number of unknown variables - unknown variables that have
         to be defined when using the component). A few models of the Modelica
         Standard Library did not fulfill these new restrictions and had
         either to be moved to library ObsoleteModelica3 (e.g., Blocks.Math.TwoInputs)
         or had to be differently implemented
         (e.g., Media.Interfaces.PartialMedium.BaseProperties).
         The Modelica Standard Library version 3.0 fulfills all the restrictions of
         the Modelica Language version 3.0.<br>&nbsp;
         </li>

<li> The graphical annotations describing the layout of icon and diagram layer
         are changed from Modelica language version 1 to Modelica language version 3.
         This gives several significant improvements:<br>Especially, the coordinate systems
         of icon and diagram layers are no longer coupled and therefore the size of the
         icon layer can be changed independently of the size of the diagram layer.
         Also it can be defined that the aspect ratio of a component icon is kept when changing
         its size in a model. This flag is set so that all icons of the Modelica
         Standard Library keep its aspect ratios. This is slightly non-backward compatible:
         If the aspect ratio was not kept when using a component from the Modelica
         Standard Library, it is now resized so that the aspect ratio is maintained.<br>&nbsp; </li>

<li> All non-standard annotations removed by:<br>
         (1) Removing the annotation since without effect
                 (e.g., \"__Dymola_experimentSetupOutput\", \"Window\", \"Terminal\" removed).<br>
         (2) Renaming the annotation to a standard name (e.g., \"Hide\" renamed to \"HideResult\").<br>
         (3) Renaming the annotation to a vendor specific name
                 (e.g., \"checkBox\" renamed to \"__Dymola_checkBox\").<br>&nbsp; </li>

<li> All emulated enumerations (defined via packages and constants) have been
         replaced by \"real\" enumerations. User models are automatically correctly
         converted, provided the user models used the package constants previously.
         <b>Existing models that use directly literal values for enumerations, might give in
         some cases wrong results</b> (if the first constant of the emulated enumeration
         had value zero, whereas the first value of an enumeration is one).<br>&nbsp; </li>

<li> The operator \"cardinality\" will be removed in one of the next versions of the
         Modelica language, since it is a reflective operator and its usage significantly
         reduces the possibilities of advanced model checks (e.g., to guarantee that a model
         is \"balanced\", i.e., the number of equations and unknowns is identical,
         for all valid usages of the component). As a preparation for this change, all
         models that contain the \"cardinality(..)\" operator are rewritten: If possible
         the operator is removed. If this is not possible, it is only used in asserts to
         check that, e.g., a connector is connected at least once or is connected exactly
         once. In the next Modelica language version new language elements will be introduced
         to specify such a property check without the cardinality operator. Once these
         language elements are available, the cardinality operator will be removed completely
         from the Modelica Standard Library.<br>
         The changes with respect to the cardinality(..) operator are usually not backward
         compatible. This is the reason for the changes of the
         Rotational and Translational library (see below).<br>&nbsp;</li>

<li> The design of the <b>Rotational</b> and <b>Translational</b> libraries have been changed
         (especially to remove the cardinality(..) operator, see above):
         <ul>
         <li> Components have a <b>useSupport</b> flag to enable or disable a support flange.
                  If the support flange is enabled, it must be connected. If it is disabled, it must
                  not be connected and the component is then internally grounded. The grounding
                  is visualized in the icon.</li>
         <li> The relative angle/distance and the relative speed of all force/torque elements
                  (that need the relative speed) are by default defined with \"StateSelect.prefer\", i.e.,
                  to use these variables as preferred states. This improves the numerics if the
                  absolute angle or the absolute distance are continuously increasing during
                  operation (e.g., driving shaft of the wheels of a car). The effect is that relative
                  angles/distances and speeds are used as states and the size of these variables is
                  limited. Previously, the default was to use the absolute angle/distance
                  and absolute speed of every inertia/mass which has the disadvantage that the absolute
                  angle and or distance are state variables that grow in size continuously.<br>
                  A significant advantage is also, that default initialization is usually better,
                  because a default value of zero for a relative angle/distance is usually what the
                  user would like to have. Previously, say, the load was initialized to a non-zero
                  angle and then the elastically coupled motor inertia had to be explicitly
                  also initialized with this value. This is now, no longer needed. Since the default
                  nominal value of 1 is usually too large for a relative quantity, the nominal
                  values of the relative angle/distance was changed to 1e-4.</li>
         <li> The two libraries have been restructured in sublibraries to cope
                  with the growing number of components.</li>
         <li> Finally, the Translational library has been
                  made as similar as possible to the Rotational library by, e.g., adding missing
                  components.<br>&nbsp;</li>
         </ul></li>

<li> The initialization of the MultiBody, Rotational and Translational libraries have
         been significantly simplified by removing the \"initType\" parameters and only
         using start/fixed values. This design assumes that a tool has special support
         for start/fixed values in the parameter menu.<br>&nbsp;</li>

<li> Nearly all parameters defined in the Modelica Standard Library had been
         defined with a default equation, e.g.,
         <pre>   <b>parameter</b> Modelica.SIunits.Resistance R=1; </pre>
         Physical parameters, such as a resistance, mass, gear ratio, do not have a meaningful
         default and in nearly all cases, the user of the corresponding component has to
         provide values for such parameters. If the user forgets this, a tool
         cannot provide diagnostics, since a default value is present in the library
         (such as 1 Ohm for the resistance). In most cases the model will simulate but will
         give wrong results due to wrong parameter values. To improve this situation, all physical
         parameter declarations in the Modelica Standard Library have been changed, so
         that the previous default becomes a start value. For example, the above
         declaration is changed to:
         <pre>   <b>parameter</b> Modelica.SIunits.Resistance R(start=1);  </pre>
         This is a backward compatible change and completely equivalent from the perspective
         of the Modelica language. It is, however, advised that tools will print a warning
         or optionally an error message, if the start value of a parameter is defined, but
         no value for the parameter is given via a modification. Furthermore, it is expected,
         that the input field of a parameter menu is empty, if no default equation is defined,
         but only a start value. This shows clearly to the modeler that a value has to
         be provided.</li>
</ul>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries (note, the names in parentheses
are the new sublibrary names that are introduced in version 3.0):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Examples.</b></td></tr>
<tr><td valign=\"top\">InverseModel</td>
          <td valign=\"top\"> Demonstrates the construction of an inverse model.</td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
<tr><td valign=\"top\">InverseBlockConstraints</td>
          <td valign=\"top\"> Construct inverse model by requiring that two inputs
                                                and two outputs are identical (replaces the previously,
                                                unbalanced, TwoInputs and TwoOutputs blocks).</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Utilities</b></td></tr>
<tr><td valign=\"top\">TransformerData</td>
          <td valign=\"top\"> A record that calculates required impedances (parameters) from nominal data of transformers.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Rotational3DEffects</b></td></tr>
<tr><td valign=\"top\"> GyroscopicEffects<br>
                                                ActuatedDrive<br>
                                                MovingActuatedDrive<br>
                                                GearConstraint </td>
          <td valign=\"top\"> New examples to demonstrate the usage of the Rotational library
                                                in combination with multi-body components. </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors</b></td></tr>
<tr><td valign=\"top\"> AbsolutePosition<br>
                                                AbsoluteVelocity<br>
                                                AbsoluteAngles<br>
                                                AbsoluteAngularVelocity<br>
                                                RelativePosition<br>
                                                RelativeVelocity<br>
                                                RelativeAngles<br>
                                                RelativeAngularVelocity</td>
          <td valign=\"top\"> New sensors to measure one vector. </td>
</tr>
<tr><td valign=\"top\"> TransformAbsoluteVector<br>
                                                TransformRelativeVector</td>
          <td valign=\"top\"> Transform absolute and/or relative vector into another frame. </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.(Components)</b></td></tr>
<tr><td valign=\"top\"> Disc </td>
          <td valign=\"top\"> Right flange is rotated by a fixed angle with respect to left flange</td> </tr>
<tr><td valign=\"top\"> IdealRollingWheel </td>
          <td valign=\"top\"> Simple 1-dim. model of an ideal rolling wheel without inertia</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Sensors</b></td></tr>
<tr><td valign=\"top\">RelPositionSensor<br>RelSpeedSensor<br>RelAccSensor<br>PowerSensor</td>
          <td valign=\"top\"> Relative position sensor, i.e., distance between two flanges<br>
                                                Relative speed sensor<br>
                                                Relative acceleration sensor<br>
                                                Ideal power sensor</td> </tr>
<tr><td colspan=\"2\"><b>Mechanics.Translational(.Components)</b></td></tr>
<tr><td valign=\"top\">SupportFriction<br>Brake<br>InitializeFlange</td>
          <td valign=\"top\"> Model of friction due to support<br>
                                                Model of a brake, base on Coulomb friction<br>
                                                Initializes a flange with pre-defined position, speed and acceleration .</td> </tr>
<tr><td colspan=\"2\"><b>Mechanics.Translational(.Sources)</b></td></tr>
<tr><td valign=\"top\">Force2<br>LinearSpeedDependentForce<br>QuadraticSpeedDependentForce<br>
                                           ConstantForce<br>ConstantSpeed<br>ForceStep</td>
          <td valign=\"top\"> Force acting on 2 flanges<br>
                                                Force linearly dependent on flange speed<br>
                                                Force quadratic dependent on flange speed<br>
                                                Constant force source<br>
                                                Constant speed source<br>
                                                Force step</td> </tr>
</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">changed</b> in a
<b style=\"color:blue\">non-backward compatible</b> way
(the conversion script transforms models and libraries
of previous versions to the new version. Therefore, conversion
should be automatic):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Continuous.</b></td></tr>
<tr><td valign=\"top\"> CriticalDamping </td>
          <td valign=\"top\"> New parameter \"normalized\" to define whether filter is provided
                                                in normalized or non-normalized form. Default is \"normalized = true\".
                                                The previous implementation was a non-normalized filter.
                                                The conversion script automatically introduces the modifier
                                                \"normalized=false\" for existing models.</td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> RealInput<br>
                                                RealOutput</td>
          <td valign=\"top\"> Removed \"SignalType\", since extending from a replaceable class
                                                and this is not allowed in Modelica 3.<br>The conversion script
                                                removes modifiers to SignalType.</td> </tr>

<tr><td valign=\"top\"> RealSignal<br>
                                                IntegerSignal<br>
                                                BooleanSignal</td>
          <td valign=\"top\"> Moved to library ObsoleteModelica3, since these connectors
                                                are no longer allowed in Modelica 3<br>
                                                (prefixes input and/or output are required). </td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Interfaces.Adaptors.</b></td></tr>
<tr><td valign=\"top\"> AdaptorReal<br>
                                                AdaptorBoolean<br>
                                                AdaptorInteger</td>
          <td valign=\"top\"> Moved to library ObsoleteModelica3, since the models are not \"balanced\".
                                                These are completely obsolete adaptors<br>between the Real, Boolean, Integer
                                                signal connectors of version 1.6 and version &ge; 2.1 of the Modelica
                                                Standard Library. </td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
<tr><td valign=\"top\"> ConvertAllUnits</td>
          <td valign=\"top\"> Moved to library ObsoleteModelica3, since extending from a replaceable class
                                                and this is not allowed in Modelica 3.<br> It would be possible to rewrite this
                                                model to use a replaceable component. However, the information about the
                                                conversion<br> cannot be visualized in the icon in this case.</td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Math.UnitConversions.</b></td></tr>
<tr><td valign=\"top\"> TwoInputs<br>
                                                TwoOutputs</td>
          <td valign=\"top\"> Moved to library ObsoleteModelica3, since the models are not \"balanced\".
                                                A new component<br>\"InverseBlockConstraints\"
                                                is provided instead that has the same feature, but is \"balanced\".</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Baisc.</b></td></tr>
<tr><td valign=\"top\"> HeatingResistor</td>
          <td valign=\"top\"> The heatPort has to be connected; otherwise the component Resistor (without heatPort) has to be used.<br>
                                                cardinality() is only used to check whether the heatPort is connected.</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.MultiPhase.Examples.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Moved package <code>Machines.Examples.Utilities</code> to <code>Machines.Utilities</code></td> </tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Removed all nonSIunits; especially in DCMachines<br>
                                                parameter NonSIunits.AngularVelocity_rpm rpmNominal was replaced by<br>
                                                parameter SIunits.AngularVelocity wNominal</td> </tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Changed the following component variable and parameter names to be more concise:<br>
                                                Removed suffix \"DamperCage\" from all synchronous induction machines
                                                since the user can choose whether the damper cage is present or not.<br><code>
                                                RotorAngle ... RotorDisplacementAngle<br>
                                                J_Rotor ... Jr<br>
                                                Rr ........ Rrd (damper of synchronous induction machines)<br>
                                                Lrsigma ... Lrsigmad (damper of synchronous induction machines)<br>
                                                phi_mechanical ... phiMechanical<br>
                                                w_mechanical ..... wMechanical<br>
                                                rpm_mechanical ... rpmMechanical<br>
                                                tau_electrical ... tauElectrical<br>
                                                tau_shaft ........ tauShaft<br>
                                                TurnsRatio ....... turnsRatio    (AIMS)<br>
                                                VsNom ............ VsNominal     (AIMS)<br>
                                                Vr_Lr ............ VrLockedRotor (AIMS)<br>
                                                DamperCage ....... useDamperCage (synchronous induction machines)<br>
                                                V0 ............... VsOpenCicuit  (SMPM)<br>
                                                Ie0 .............. IeOpenCicuit  (SMEE)
                                                </code></td> </tr>
<tr><td valign=\"top\">Interfaces.</td>
          <td valign=\"top\"> Moved as much code as possible from specific machine models to partials to reduce redundant code.</td> </tr>
<tr><td valign=\"top\">Interfaces.Adapter</td>
          <td valign=\"top\"> Removed to avoid cardinality; instead, the following solution has been implemented:</td> </tr>
<tr><td valign=\"top\">Sensors.RotorDisplacementAngle<br>Interfaces.PartialBasicMachine</td>
          <td valign=\"top\"> Introduced <code>parameter Boolean useSupport=false \"enable / disable (=fixed stator) support\"</code><br>
                                                The rotational support connector is only present with <code>useSupport = true;</code><br>
                                                otherwise the stator is fixed internally.</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Changed the names of the examples to more meaningful names.<br>
                                                Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>
<tr><td valign=\"top\">SMEE_Generator</td>
          <td valign=\"top\"> Initialization of <code>smee.phiMechanical</code> with <code>fixed=true</code></td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\"> World</td>
          <td valign=\"top\"> Changed default value of parameter driveTrainMechanics3D from false to true.<br>
                                                3-dim. effects in Rotor1D, Mounting1D and BevelGear1D are therefore taken<br>
                                                into account by default (previously this was only the case, if
                                                world.driveTrainMechanics3D was explicitly set).</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces.</b></td></tr>
<tr><td valign=\"top\"> FrameForce<br>
                                                FrameTorque<br>
                                                FrameForceAndTorque</td>
          <td valign=\"top\"> Models removed, since functionality now available via Force, Torque, ForceAndTorque</td> </tr>
<tr><td valign=\"top\"> WorldForce<br>
                                                WorldTorque<br>
                                                WorldForceAndTorque<br>
                                                Force<br>
                                                Torque<br>
                                                ForceAndTorque</td>
          <td valign=\"top\"> Connector frame_resolve is optionally enabled via parameter resolveInFrame<br>.
                                                Forces and torques and be resolved in all meaningful frames defined
                                                by enumeration resolveInFrame.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.</b></td></tr>
<tr><td valign=\"top\"> length<br>
                                                normalize</td>
          <td valign=\"top\"> Removed functions, since available also in Modelica.Math.Vectors
                                                <br>The conversion script changes the references correspondingly.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.</b></td></tr>
<tr><td valign=\"top\"> Prismatic<br>
                                                ActuatedPrismatic<br>
                                                Revolute<br>
                                                ActuatedRevolute<br>
                                                Cylindrical<br>
                                                Universal<br>
                                                Planar<br>
                                                Spherical<br>
                                                FreeMotion</td>
          <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                                                start/fixed attributes.<br>
                                                When start/fixed attributes are properly supported
                                                in the parameter menu by a Modelica tool,<br>
                                                the initialization is considerably simplified for the
                                                user and the implementation is much simpler.<br>
                                                Replaced parameter \"enforceStates\" by the more general
                                                built-in enumeration stateSelect=StateSelection.xxx.<br>
                                                The conversion script automatically
                                                transforms from the \"old\" to the \"new\" forms.</td> </tr>
<tr><td valign=\"top\"> Revolute<br>
                                                ActuatedRevolute</td>
          <td valign=\"top\"> Parameter \"planarCutJoint\" in the \"Advanced\" menu of \"Revolute\" and of
                                                \"ActuatedRevolute\" removed.<br>
                                                A new joint \"RevolutePlanarLoopConstraint\" introduced that defines the constraints
                                                of a revolute joint<br> as cut-joint in a planar loop.
                                                This change was needed in order that the revolute joint can be
                                                properly used<br>in advanced model checking.<br>
                                                ActuatedRevolute joint removed. Flange connectors of Revolute joint<br>
                                                can be enabled with parameter useAxisFlange.</td> </tr>
<tr><td valign=\"top\"> Prismatic<br>
                                                ActuatedPrismatic</td>
          <td valign=\"top\"> ActuatedPrismatic joint removed. Flange connectors of Prismatic joint<br>
                                                can be enabled with parameter useAxisFlange.</td> </tr>
<tr><td valign=\"top\"> Assemblies</td>
          <td valign=\"top\"> Assembly joint implementation slightly changed, so that
                                                annotation \"structurallyIncomplete\" <br>could be removed
                                                (all Assembly joint models are now \"balanced\").</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.Internal</b></td></tr>
<tr><td valign=\"top\"> RevoluteWithLengthConstraint<br>
                                                PrismaticWithLengthConstraint</td>
          <td valign=\"top\"> These joints should not be used by a user of the MultiBody library.
                                                They are only provided to built-up the
                                                MultiBody.Joints.Assemblies.JointXYZ joints.
                                                These two joints have been changed in a slightly not backward compatible
                                                way, in order that the usage in the Assemblies.JointXYZ joints results in
                                                balanced models (<b>no conversion is provided for this change since the
                                                user should not have used these joints and the conversion would be too
                                                complicated</b>):
                                                In releases before version 3.0 of the Modelica Standard Library,
                                                it was possible to activate the torque/force projection equation
                                                (= cut-torque/-force projected to the rotation/translation
                                                axis must be identical to
                                                the drive torque/force of flange axis) via parameter <b>axisTorqueBalance</b>.
                                                This is no longer possible, since otherwise this model would not be
                                                \"balanced\" (= same number of unknowns as equations). Instead, when
                                                using this model in version 3.0 and later versions, the torque/force
                                                projection equation must be provided in the Advanced menu of joints
                                                Joints.SphericalSpherical and Joints.UniversalSpherical
                                                via the new parameter \"constraintResidue\".</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> BodyBox<br>
                                                BodyCylinder</td>
          <td valign=\"top\"> Changed unit of parameter density from g/cm3 to the SI unit kg/m3
                                                in order to allow stricter unit checking.<br>The conversion script multiplies
                                                previous density values with 1000.</td> </tr>
<tr><td valign=\"top\"> Body<br>
                                                BodyShape<br>
                                                BodyBox<br>
                                                BodyCylinder<br>
                                                PointMass
                                                Rotor1D</td>
          <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                                                start/fixed attributes.<br>
                                                When start/fixed attributes are properly supported
                                                in the parameter menu by a Modelica tool,<br>
                                                the initialization is considerably simplified for the
                                                user and the implementation is much simpler.<br>The conversion script automatically
                                                transforms from the \"old\" to the \"new\" form of initialization.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors.</b></td></tr>
<tr><td valign=\"top\"> AbsoluteSensor<br>
                                                RelativeSensor<br>
                                                CutForceAndTorque</td>
          <td valign=\"top\"> New design of sensor components: Via Boolean parameters<br>
                                                signal connectors for the respective vectors are enabled/disabled.<br>
                                                It is not possible to automatically convert models to this new design.<br>
                                                Instead, references in existing models are changed to ObsoleteModelice3.<br>
                                                This means that these models must be manually adapted.</td> </tr>
<tr><td valign=\"top\"> CutForce<br>
                                                CutTorque</td>
          <td valign=\"top\"> Slightly new design. The force and/or torque component can be
                                                resolved in world, frame_a, or frame_resolved.<br>
                                                Existing models are automatically converted.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Moved components to structured sub-packages (Sources, Components)</td> </tr>
<tr><td valign=\"top\"> Inertia<br>
                                                SpringDamper<br>
                                                RelativeStates</td>
          <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                                                start/fixed attributes.<br>
                                                When start/fixed attributes are properly supported
                                                in the parameter menu by a Modelica tool,<br>
                                                the initialization is considerably simplified for the
                                                user and the implementation is much simpler.<br>
                                                Parameter \"stateSelection\" in \"Inertia\" and \"SpringDamper\" replaced
                                                by the built-in enumeration<br>stateSelect=StateSelection.xxx.
                                                Introduced the \"stateSelect\" enumeration in \"RelativeStates\".<br>
                                                The conversion script automatically
                                                transforms from the \"old\" to the \"new\" forms.</td> </tr>
<tr><td valign=\"top\"> LossyGear<br>
                                                GearBox</td>
          <td valign=\"top\"> Renamed gear ratio parameter \"i\" to \"ratio\", in order to have a
                                                consistent naming convention.<br>
                                                Existing models are automatically converted. </td> </tr>
<tr><td valign=\"top\"> SpringDamper<br>
                                                ElastoBacklash<br>
                                                Clutch<br>
                                                OneWayClutch</td>
          <td valign=\"top\"> Relative quantities (phi_rel, w_rel) are used as states, if possible
                                                (due to StateSelect.prefer). <br>
                                                In most cases, relative states in drive trains are better suited as
                                                absolute states. <br> This change might give changes in the selected states
                                                of existing models.<br>
                                                This might give rise to problems if, e.g., the initialization was not
                                                completely defined in a user model,<br> since the default
                                                initialization heuristic may give different initial values.</td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Moved components to structured sub-packages (Sources, Components)</td> </tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Adaptions corresponding to Rotational</td> </tr>
<tr><td valign=\"top\"> Stop</td>
          <td valign=\"top\"> Renamed to Components.MassWithStopAndFriction to be more concise.<br>
                                                MassWithStopAndFriction is not available with a support connector, <br>
                                                since the reaction force can't be modeled in a meaningful way due to reinit of velocity v.<br>
                                                Until a sound implementation of a hard stop is available, the old model may be used.</td> </tr>
<tr><td colspan=\"2\"><b>Media.</b></td></tr>
<tr><td valign=\"top\"> constant nX <br>
                                                constant nXi <br>
                                                constant reference_X<br>
                                                BaseProperties</td>
          <td valign=\"top\"> The package constant nX = nS, now always, even for single species media. This also allows to define mixtures with only 1 element. The package constant nXi=if fixedX then 0 else if reducedX or nS==1 then nS - 1 else nS. This required that all BaseProperties for single species media get an additional equation to define the composition X as {1.0} (or reference_X, which is {1.0} for single species). This will also mean that all user defined single species media need to be updated by that equation.</td> </tr>

<tr><td colspan=\"2\"><b>SIunits.</b></td></tr>
<tr><td valign=\"top\"> CelsiusTemperature </td>
          <td valign=\"top\"> Removed, since no SI unit. The conversion script changes references to
                                                SIunits.Conversions.NonSIunits.Temperature_degC </td> </tr>
<tr><td valign=\"top\"> ThermodynamicTemperature <br>
                                                TemperatureDifference</td>
          <td valign=\"top\"> Added annotation \"absoluteValue=true/false\"
                                                in order that unit checking is possible<br>
                                                (the unit checker needs to know for a unit that has an offset,
                                                whether it is used as absolute or as a relative number)</td> </tr>

<tr><td colspan=\"2\"><b>SIunits.Conversions.NonSIunits.</b></td></tr>
<tr><td valign=\"top\"> Temperature_degC<br>
                                                Temperature_degF<br>
                                                Temperature_degRk </td>
          <td valign=\"top\"> Added annotation \"absoluteValue=true\"
                                                in order that unit checking is possible<br>
                                                (the unit checker needs to know for a unit that has an offset,
                                                whether it is used as absolute or as a relative number)</td> </tr>

<tr><td colspan=\"2\"><b>StateGraph.Examples.</b></td></tr>
<tr><td valign=\"top\"> ControlledTanks </td>
          <td valign=\"top\"> The connectors of the ControlledTanks did not fulfill the new
                                                restrictions of Modelica 3. This has been fixed.</td> </tr>
<tr><td valign=\"top\"> Utilities </td>
          <td valign=\"top\"> Replacing inflow, outflow by connectors inflow1, inflow2,
                                                outflow1, outflow2 with appropriate input/output prefixes in
                                                order to fulfill the restrictions of Modelica 3 to arrive
                                                at balanced models. No conversion is provided, since
                                                too difficult and since the non-backward compatible change is in
                                                an example. </td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Sensors.</b></td></tr>
<tr><td valign=\"top\"> <br>
                                                pSensor<br>TSensor<br>dpSensor<br>dTSensor<br>m_flowSensor<br>V_flowSensor<br>H_flowSensor</td>
          <td valign=\"top\"> renamed to:<br>
                                                PressureSensor<br>TemperatureSensor<br>RelPressureSensor<br>RelTemperatureSensor<br>MassFlowSensor<br>VolumeFlowSensor<br>EnthalpyFlowSensor
                                                </td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Sources.</b></td></tr>
<tr><td valign=\"top\"> Ambient<br>PrescribedAmbient</td>
          <td valign=\"top\"> available as one combined component Ambient<br>
                                                Boolean parameters usePressureInput and useTemperatureInput decide
                                                whether pressure and/or temperature are constant or prescribed</td> </tr>
<tr><td valign=\"top\"> ConstantVolumeFlow<br>PrescribedVolumeFlow</td>
          <td valign=\"top\"> available as one combined component VolumeFlow<br>
                                                Boolean parameter useVolumeFlowInput decides
                                                whether volume flow is constant or prescribed</td> </tr>
<tr><td valign=\"top\"> ConstantPressureIncrease<br>PrescribedPressureIncrease</td>
          <td valign=\"top\"> available as one combined component PressureIncrease<br>
                                                Boolean parameter usePressureIncreaseInput decides
                                                whether pressure increase is constant or prescribed</td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Examples.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>

<tr><td colspan=\"2\"><b>Thermal.HeatTransfer.(Components)</b></td></tr>
<tr><td valign=\"top\"> HeatCapacitor</td>
          <td valign=\"top\"> Initialization changed: SteadyStateStart removed. Instead
                                                start/fixed values for T and der_T<br>(initial temperature and its derivative).</td> </tr>

<tr><td valign=\"top\"> <br><br>HeatCapacitor<br>ThermalConductor<br>ThermalConvection<br>BodyRadiation<br><br>
                                                TemperatureSensor<br>RelTemperatureSensor<br>HeatFlowSensor<br><br>
                                                FixedTemperature<br>PrescribedTemperature<br>FixedHeatFlow<br>PrescribedHeatFlow</td>
          <td valign=\"top\"> Moved components to sub-packages:<br><br>
                                                Components.HeatCapacitor<br>Components.ThermalConductor<br>Components.ThermalConvection<br>Components.BodyRadiation<br><br>
                                                Sensors.TemperatureSensor<br>Sensors.RelTemperatureSensor<br>Sensors.HeatFlowSensor<br><br>
                                                Sources.FixedTemperature<br>Sources.PrescribedTemperature<br>Sources.FixedHeatFlow<br>Sources.PrescribedHeatFlow
                                                </td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Examples.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>
</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b> in a
<b style=\"color:blue\">backward compatible</b> way:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td valign=\"top\"> <b>Modelica.*</b> </td>
          <td valign=\"top\"> Parameter declarations, input and output function arguments without description
                                                strings improved<br> by providing meaningful description texts.
                                                </td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Continuous.</b></td></tr>
<tr><td valign=\"top\"> TransferFunction </td>
          <td valign=\"top\"> Internal scaling of the controller canonical states introduced
                                                in order to enlarge the range of transfer functions where the default
                                                relative tolerance of the simulator is sufficient.</td>
</tr>

<tr><td valign=\"top\"> Butterworth<br>CriticalDamping </td>
          <td valign=\"top\"> Documentation improved and plots of the filter characteristics added.</td> </tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\"> EMF </td>
          <td valign=\"top\"> New parameter \"useSupport\" to optionally enable a support connector.</td> </tr>

<tr><td colspan=\"2\"><b>Icons.</b></td></tr>
<tr><td valign=\"top\"> TranslationalSensor<br>
                                                RotationalSensor</td>
          <td valign=\"top\"> Removed drawing from the diagram layer (kept drawing only in
                                                icon layer),<br> in order that this icon can be used in situations
                                                where components are dragged in the diagram layer.</td> </tr>

<tr><td colspan=\"2\"><b>Math.Vectors.</b></td></tr>
<tr><td valign=\"top\"> normalize</td>
          <td valign=\"top\"> Implementation changed, so that the result is awalys continuous<br>
                                                (previously, this was not the case for small vectors: normalize(eps,eps)).
                                                </td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\"> </td>
          <td valign=\"top\"> Renamed non-standard keywords defineBranch, defineRoot, definePotentialRoot,
                                                isRooted to the standard names:<br>
                                                Connections.branch/.root/.potentialRoot/.isRooted.</td> </tr>
<tr><td valign=\"top\"> Frames </td>
          <td valign=\"top\"> Added annotation \"Inline=true\" to all one-line functions
                                                (which should be all inlined).</td> </tr>
<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> Mounting1D<br>
                                                Rotor1D<br>
                                                BevelGear1D</td>
          <td valign=\"top\"> Changed implementation so that no longer modifiers for connector
                                                variables are used,<br>because this violates the restrictions on
                                                \"balanced models\" of Modelica 3. </td> </tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> InitializeFlange</td>
          <td valign=\"top\"> Changed implementation so that counting unknowns and
                                                equations is possible without actual values of parameters.</td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
<tr><td valign=\"top\">TwoPort</td>
          <td valign=\"top\"> Introduced <code>parameter Real tapT(final min=0, final max=1)=1</code> <br> that defines the temperature of the heatPort
                                                between inlet and outlet.</td> </tr>

<tr><td colspan=\"2\"><b>StateGraph.</b></td></tr>
<tr><td valign=\"top\"> InitialStep<br>
                                                InitialStepWithSignal<br>
                                                Step<br>
                                                StepWithSignal</td>
          <td valign=\"top\"> Changed implementation so that no longer modifiers for output
                                                variables are used,<br>because this violates the restrictions on
                                                \"balanced models\" of Modelica 3. </td> </tr>

</table>

<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e., errors
that can lead to wrong simulation results):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Electrical.Analog.Examples.</b></td></tr>
<tr><td valign=\"top\"> CauerLowPassSC </td>
          <td valign=\"top\"> Wrong calculation of Capacitor1 both in Rn and Rp corrected
                                                (C=clock/R instead of C=clock*R) </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> Rotor1D </td>
          <td valign=\"top\"> The 3D reaction torque was not completely correct and gave in
                                                some situations a wrong result. This bug should not influence the
                                                movement of a multi-body system, but only the constraint torques
                                                are sometimes not correct. </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> ElastoBacklash </td>
          <td valign=\"top\"> If the damping torque was too large, the reaction torque
                                                could \"pull\" which is unphysical. The component was
                                                newly written by limiting the damping torque in such a case
                                                so that \"pulling\" torques can no longer occur. Furthermore,
                                                during initialization the characteristics is made continuous
                                                to reduce numerical errors. The relative angle and relative
                                                angular velocities are used as states, if possible
                                                (StateSelect.prefer), since relative quantities lead usually
                                                to better behavior.  </td>
</tr>
<tr><td valign=\"top\"> Position<br>Speed<br>Accelerate<br>Move</td>
          <td valign=\"top\"> The movement of the flange was wrongly defined as absolute;
                                                this is corrected as relative to connector support.<br>
                                                For Accelerate, it was necessary to rename
                                                RealInput a to a_ref, as well as the start values
                                                phi_start to phi.start and w_start to w.start.
                                                The conversion script performs the necessary conversion of
                                                existing models automatically.</td>
</tr>
<tr><td colspan=\"2\"><b>Media.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialSimpleIdealGasMedium </td>
          <td valign=\"top\"> Inconsistency in reference temperature corrected. This may give
                                                different results for functions:<br>
                                                specificEnthalpy, specificInternalEnergy, specificGibbsEnergy,
                                                specificHelmholtzEnergy. </td>
</tr>
<tr><td colspan=\"2\"><b>Media.Air.</b></td></tr>
<tr><td valign=\"top\"> specificEntropy </td>
          <td valign=\"top\"> Small bug in entropy computation of ideal gas mixtures corrected.</td>
</tr>
<tr><td colspan=\"2\"><b>Media.IdealGases.Common.MixtureGasNasa</b></td></tr>
<tr><td valign=\"top\"> specificEntropy </td>
          <td valign=\"top\"> Small bug in entropy computation of ideal gas mixtures corrected.</td>
</tr>
</table>

<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e., errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g.,
units are wrong or errors in documentation):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Tables.</b></td></tr>
<tr><td valign=\"top\"> CombiTable2D</td>
          <td valign=\"top\"> Documentation improved.</td>
</tr>

<tr><td colspan=\"2\"><b>Electrica.Digital.Gates</b></td></tr>
<tr><td valign=\"top\"> AndGate<br>
                                                NandGate<br>
                                                OrGate<br>
                                                NorGate<br>
                                                XorGate<br>
                                                XnorGate</td>
          <td valign=\"top\"> The number of inputs was not correctly propagated
                                                to the included base model.<br>
                                                This gave a translation error, if the number
                                                of inputs was changed (and not the default used).</td>
</tr>

<tr><td colspan=\"2\"><b>Electrica.Digital.Sources</b></td></tr>
<tr><td valign=\"top\"> Pulse </td>
          <td valign=\"top\"> Model differently implemented, so that
                                                warning message about \"cannot properly initialize\" is gone.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> BearingFriction<br>
                                                Clutch<br>
                                                OneWayClutch<br>
                                                Brake <br>
                                                Gear </td>
          <td valign=\"top\"> Declaration of table parameter changed from
                                                table[:,:] to table[:,2].</td>
</tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Loops.Utilities.</b></td></tr>
<tr><td valign=\"top\"> GasForce </td>
          <td valign=\"top\"> Unit of variable \"press\" corrected (from Pa to bar)</td>
</tr>

<tr><td colspan=\"2\"><b>StateGraph.Examples.</b></td></tr>
<tr><td valign=\"top\">SimpleFriction</td>
          <td valign=\"top\"> The internal parameter k is defined and calculated with the appropriate unit.</td> </tr>

<tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
<tr><td valign=\"top\">SimpleFriction</td>
          <td valign=\"top\"> The internal parameter k is defined and calculated with the appropriate unit.</td> </tr>

</table>

</html>"));
      end Version_3_0;

      class Version_2_2_2 "Version 2.2.2 (Aug. 31, 2007)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>
<p>
Version 2.2.2 is backward compatible to version 2.2.1 and 2.2 with
the following exceptions:
</p>
<ul>
<li> Removal of package Modelica.Media.Interfaces.PartialTwoPhaseMediumWithCache
         (this was not yet utilized).</li>
<li> Removal of the media packages in
         Modelica.Media.IdealGases.SingleGases that are not type compatible
         to Modelica.Media.Interfaces.PartialMedium, because a FluidConstants
         record definition is missing,
         for details, see
          <a href=\"modelica://Modelica.Media.IdealGases\">Modelica.Media.IdealGases</a>
         (this is seen as a bug fix).
</ul>

<p>
An overview of the differences between version 2.2.2 and the previous
version 2.2.1 is given below. The exact differences (but without
differences in the documentation) are available in
<a href=\"modelica://Modelica/Resources/Documentation/Differences-Modelica-221-222.html\">Differences-Modelica-221-222.html</a>.
This comparison file was generated automatically with Dymola's
ModelManagement.compare function.
</p>

<p>
In this version, <b>no</b> new libraries have been added. The <b>documentation</b>
of the whole library was improved.
</p>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added
to <b style=\"color:blue\">existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Logical.</b></td></tr>
<tr><td valign=\"top\"> TerminateSimulation</td>
          <td valign=\"top\"> Terminate a simulation by a given condition.</td>
</tr>

<tr><td colspan=\"2\"><b>Blocks.Routing.</b></td></tr>
<tr><td valign=\"top\"> RealPassThrough<br>
                   IntegerPassThrough<br>
                   BooleanPassThrough</td>
          <td valign=\"top\"> Pass a signal from input to output
                   (useful in combination with a bus due to restrictions
                   of expandable connectors).</td>
</tr>

<tr><td colspan=\"2\"><b>Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\"> KinematicPTP2 </td>
          <td valign=\"top\"> Directly gives q,qd,qdd as output (and not just qdd as KinematicPTP).
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
<tr><td valign=\"top\"> TransformerTestbench </td>
          <td valign=\"top\"> Transformer Testbench
          </td>
<tr><td valign=\"top\"> Rectifier6pulse </td>
          <td valign=\"top\"> 6-pulse rectifier with 1 transformer
          </td>
</tr>
<tr><td valign=\"top\"> Rectifier12pulse </td>
          <td valign=\"top\"> 12-pulse rectifier with 2 transformers
          </td>
</tr>
<tr><td valign=\"top\"> AIMC_Steinmetz </td>
          <td valign=\"top\"> Asynchronous induction machine squirrel cage with Steinmetz connection
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.Components.</b></td></tr>
<tr><td valign=\"top\"> BasicAIM </td>
          <td valign=\"top\"> Partial model for asynchronous induction machine
          </td>
<tr><td valign=\"top\"> BasicSM </td>
          <td valign=\"top\"> Partial model for synchronous induction machine
          </td>
<tr><td valign=\"top\"> PartialAirGap </td>
          <td valign=\"top\"> Partial airgap model
          </td>
<tr><td valign=\"top\"> BasicDCMachine </td>
          <td valign=\"top\"> Partial model for DC machine
          </td>
<tr><td valign=\"top\"> PartialAirGapDC </td>
          <td valign=\"top\"> Partial airgap model of a DC machine
          </td>
<tr><td valign=\"top\"> BasicTransformer </td>
          <td valign=\"top\"> Partial model of threephase transformer
          </td>
<tr><td valign=\"top\"> PartialCore </td>
          <td valign=\"top\"> Partial model of transformer core with 3 windings
          </td>
<tr><td valign=\"top\"> IdealCore </td>
          <td valign=\"top\"> Ideal transformer with 3 windings
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.</b></td></tr>
<tr><td valign=\"top\"> Transformers </td>
          <td valign=\"top\"> Sub-Library for technical 3phase transformers
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> Adapter </td>
          <td valign=\"top\"> Adapter to model housing of electrical machine
          </td>
</tr>

<tr><td colspan=\"2\"><b>Math.</b></td></tr>
<tr><td valign=\"top\"> Vectors </td>
          <td valign=\"top\"> New library of functions operating on vectors
          </td>
</tr>
<tr><td valign=\"top\"> atan3 </td>
          <td valign=\"top\"> Four quadrant inverse tangent (select solution that is closest to given angle y0)
          </td>
</tr>
<tr><td valign=\"top\"> asinh </td>
          <td valign=\"top\"> Inverse of sinh (area hyperbolic sine)
          </td>
</tr>
<tr><td valign=\"top\"> acosh </td>
          <td valign=\"top\"> Inverse of cosh (area hyperbolic cosine)
          </td>
</tr>

<tr><td colspan=\"2\"><b>Math.Vectors</b></td></tr>
<tr><td valign=\"top\"> isEqual </td>
          <td valign=\"top\"> Determine if two Real vectors are numerically identical
          </td>
</tr>
<tr><td valign=\"top\"> norm </td>
          <td valign=\"top\"> Return the p-norm of a vector
          </td></tr>
<tr><td valign=\"top\"> length </td>
          <td valign=\"top\"> Return length of a vector (better as norm(), if further symbolic processing is performed)
          </td></tr>
<tr><td valign=\"top\"> normalize </td>
          <td valign=\"top\"> Return normalized vector such that length = 1 and prevent zero-division for zero vector
          </td></tr>
<tr><td valign=\"top\"> reverse </td>
          <td valign=\"top\"> Reverse vector elements (e.g., v[1] becomes last element)
          </td></tr>
<tr><td valign=\"top\"> sort </td>
          <td valign=\"top\"> Sort elements of vector in ascending or descending order
          </td></tr>

<tr><td colspan=\"2\"><b>Math.Matrices</b></td></tr>
<tr><td valign=\"top\"> solve2 </td>
          <td valign=\"top\"> Solve real system of linear equations A*X=B with a B matrix
                   (Gaussian elimination with partial pivoting)
          </td>
</tr>
<tr><td valign=\"top\"> LU_solve2 </td>
          <td valign=\"top\"> Solve real system of linear equations P*L*U*X=B with a B matrix
                   and an LU decomposition (from LU(..))
          </td></tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> InitializeFlange </td>
          <td valign=\"top\"> Initialize a flange according to given signals
                   (useful if initialization signals are provided by a signal bus).
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialMedium.</b></td></tr>
<tr><td valign=\"top\"> density_pTX </td>
          <td valign=\"top\"> Return density from p, T, and X or Xi
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
<tr><td valign=\"top\"> BaseProperties </td>
          <td valign=\"top\"> Base properties (p, d, T, h, u, R, MM, x) of a two phase medium
          </td>
</tr>
<tr><td valign=\"top\"> molarMass </td>
          <td valign=\"top\"> Return the molar mass of the medium
          </td>
</tr>
<tr><td valign=\"top\"> saturationPressure_sat </td>
          <td valign=\"top\"> Return saturation pressure
          </td>
</tr>
<tr><td valign=\"top\"> saturationTemperature_sat </td>
          <td valign=\"top\"> Return saturation temperature
          </td>
</tr>
<tr><td valign=\"top\"> saturationTemperature_derp_sat </td>
          <td valign=\"top\"> Return derivative of saturation temperature w.r.t. pressure
          </td>
</tr>  <tr><td valign=\"top\"> setState_px </td>
          <td valign=\"top\"> Return thermodynamic state from pressure and vapour quality
          </td>
</tr>  <tr><td valign=\"top\"> setState_Tx </td>
          <td valign=\"top\"> Return thermodynamic state from temperature and vapour quality
          </td>
</tr>  <tr><td valign=\"top\"> vapourQuality </td>
          <td valign=\"top\"> Return vapour quality
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialLinearFluid </td>
          <td valign=\"top\"> Generic pure liquid model with constant cp,
                   compressibility and thermal expansion coefficients
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\"> massFraction_pTphi </td>
          <td valign=\"top\"> Return the steam mass fraction from relative humidity and T
          </td>
</tr>
<tr><td valign=\"top\"> saturationTemperature </td>
          <td valign=\"top\"> Return saturation temperature from (partial) pressure
                   via numerical inversion of function saturationPressure
          </td>
</tr>
<tr><td valign=\"top\"> enthalpyOfWater </td>
          <td valign=\"top\"> Return specific enthalpy of water (solid/liquid) near
                   atmospheric pressure from temperature
          </td>
</tr>
<tr><td valign=\"top\"> enthalpyOfWater_der </td>
          <td valign=\"top\"> Return derivative of enthalpyOfWater()\" function
          </td>
</tr>
<tr><td valign=\"top\"> PsychrometricData </td>
          <td valign=\"top\"> Model to generate plot data for psychrometric chart
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.CompressibleLiquids.</b><br>
          New sub-library for simple compressible liquid models</td></tr>
<tr><td valign=\"top\"> LinearColdWater </td>
          <td valign=\"top\"> Cold water model with linear compressibility
          </td>
<tr><td valign=\"top\"> LinearWater_pT_Ambient </td>
          <td valign=\"top\"> Liquid, linear compressibility water model at 1.01325 bar
                   and 25 degree Celsius
          </td>

<tr><td colspan=\"2\"><b>SIunits.</b></td></tr>
<tr><td valign=\"top\"> TemperatureDifference </td>
          <td valign=\"top\"> Type for temperature difference
          </td>
</table>

<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b>:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.Examples.</b></td></tr>
<tr><td valign=\"top\"> BusUsage</td>
          <td valign=\"top\"> Example changed from the \"old\" to the \"new\" bus concept with
                   expandable connectors.</td> </tr>

<tr><td colspan=\"2\"><b>Blocks.Discrete.</b></td></tr>
<tr><td valign=\"top\"> ZeroOrderHold</td>
          <td valign=\"top\"> Sample output ySample moved from \"protected\" to \"public\"
                   section with new attributes (start=0, fixed=true).
          </td>
</tr>
<tr><td valign=\"top\"> TransferFunction</td>
          <td valign=\"top\"> Discrete state x with new attributes (each start=0, each fixed=0).
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.</b></td></tr>
<tr><td valign=\"top\"> Analog<br>MultiPhase</td>
          <td valign=\"top\"> Improved some icons.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> MISO</td>
          <td valign=\"top\"> Removed \"algorithm\" from this partial block.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
<tr><td valign=\"top\"> DelayParams</td>
          <td valign=\"top\"> Removed \"algorithm\" from this partial block.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
<tr><td valign=\"top\"> DelayParams</td>
          <td valign=\"top\"> Removed \"algorithm\" from this partial block.
          </td>
</tr>
<tr><td valign=\"top\"> TransportDelay</td>
          <td valign=\"top\">  If delay time is zero, an infinitely small delay is
                        introduced via pre(x) (previously \"x\" was used).
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Sources.</b></td></tr>
<tr><td valign=\"top\"> Clock<br>Step</td>
          <td valign=\"top\"> Changed if-conditions from \"xxx < time\" to \"time >= xxx\"
                   (according to the Modelica specification, in the second case
                   a time event should be triggered, i.e., this change leads
                   potentially to a faster simulation).
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Converters.</b></td></tr>
<tr><td valign=\"top\"> BooleanToLogic<br>
                   LogicToBoolean<br>
                   RealToLogic<br>
                   LogicToReal</td>
          <td valign=\"top\"> Changed from \"algorithm\" to \"equation\" section
                   to allow better symbolic preprocessing
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.</b></td></tr>
<tr><td valign=\"top\"> Machines</td>
          <td valign=\"top\"> Slightly improved documentation, typos in
                   documentation corrected
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
<tr><td valign=\"top\"> AIMS_start</td>
          <td valign=\"top\"> Changed QuadraticLoadTorque1(TorqueDirection=true) to
                   QuadraticLoadTorque1(TorqueDirection=false) since more realistic
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialBasicMachine</td>
          <td valign=\"top\"> Introduced support flange to model the
                   reaction torque to the housing
          </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Machines.Sensors.</b></td></tr>
<tr><td valign=\"top\"> Rotorangle</td>
          <td valign=\"top\"> Introduced support flange to model the
                   reaction torque to the housing
          </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Elementary.</b></td></tr>
<tr><td valign=\"top\"> PointMassesWithGravity</td>
          <td valign=\"top\"> Added two point masses connected by a line force to demonstrate
                   additionally how this works. Connections of point masses
                   with 3D-elements are demonstrated in the new example
                   PointMassesWithGravity (there is the difficulty that the orientation
                   is not defined in a PointMass object and therefore some
                   special handling is needed in case of a connection with
                   3D-elements, where the orientation of the point mass is not
                   determined by these elements.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Systems.</b></td></tr>
<tr><td valign=\"top\"> RobotR3</td>
          <td valign=\"top\"> Changed from the \"old\" to the \"new\" bus concept with expandable connectors.
                   Replaced the non-standard Modelica function \"constrain()\" by
                   standard Modelica components. As a result, the non-standard function
                   constrain() is no longer used in the Modelica Standard Library.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.Orientation.</b></td></tr>
<tr><td valign=\"top\"> equalityConstraint</td>
          <td valign=\"top\"> Use a better residual for the equalityConstraint function.
                   As a result, the non-linear equation system of a kinematic
                   loop is formulated in a better way (the range where the
                   desired result is a unique solution of the non-linear
                   system of equations becomes much larger).</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\"> Visualizers.</td>
          <td valign=\"top\"> Removed (misleading) annotation \"structurallyIncomplete\"
                   in the models of this sub-library
          </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> Examples</td>
          <td valign=\"top\"> For all models in this sub-library:
                   <ul>
                   <li> Included a housing object in all examples to compute
                                all support torques.</li>
                   <li> Replaced initialization by modifiers via the
                                initialization menu parameters of Inertia components.</li>
                   <li> Removed \"encapsulated\" and unnecessary \"import\". </li>
                   <li> Included \"StopTime\" in the annotations.</li>
                   </ul>
          </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> FrictionBase</td>
          <td valign=\"top\"> Introduced \"fixed=true\" for Boolean variables startForward,
                   startBackward, mode.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> FrictionBase</td>
          <td valign=\"top\"> Introduced \"fixed=true\" for Boolean variables startForward,
                   startBackward, mode.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.UsersGuide.MediumUsage.</b></td></tr>
<tr><td valign=\"top\"> TwoPhase</td>
          <td valign=\"top\"> Improved documentation and demonstrating the newly introduced functions
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Examples.</b></td></tr>
<tr><td valign=\"top\"> WaterIF97</td>
          <td valign=\"top\"> Provided (missing) units for variables V, dV, H_flow_ext, m, U.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialMedium</td>
          <td valign=\"top\"> Final modifiers are removed from nX and nXi, to allow
                   customized medium models such as mixtures of refrigerants with oil, etc.
          </td>
</tr>
<tr><td valign=\"top\"> PartialCondensingGases</td>
          <td valign=\"top\"> Included attributes \"min=1, max=2\" for input argument FixedPhase
                   for functions setDewState and setBubbleState (in order to guarantee
                   that input arguments are correct).
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Interfaces.PartialMedium.</b></td></tr>
<tr><td valign=\"top\"> BaseProperties</td>
          <td valign=\"top\"> New Boolean parameter \"standardOrderComponents\".
                   If true, last element vector X is computed from 1-sum(Xi) (= default)
                   otherwise, no equation is provided for it in PartialMedium.
          </td>
</tr>
<tr><td valign=\"top\"> IsentropicExponent</td>
          <td valign=\"top\"> \"max\" value changed from 1.7 to 500000
          </td>
</tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_psX<br>
                   setState_dTX<br>
                   specificEnthalpy_pTX<br>
                   temperature_phX<br>
                   density_phX<br>
                   temperature_psX<br>
                   density_psX<br>
                   specificEnthalpy_psX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Interfaces.PartialSimpleMedium.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_psX<br>
                   setState_dTX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Interfaces.PartialSimpleIdealGasMedium.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_psX<br>
                   setState_dTX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_dTX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_psX<br>
                   setState_dTX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.IdealGases.Common.MixtureGasNasa.</b></td></tr>
<tr><td valign=\"top\"> setState_pTX<br>
                   setState_phX<br>
                   setState_psX<br>
                   setState_dTX<br>
                   h_TX</td>
          <td valign=\"top\"> Introduced default value \"reference_X\" for input argument \"X\".
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Common.</b></td></tr>
<tr><td valign=\"top\"> IF97PhaseBoundaryProperties<br>
                   gibbsToBridgmansTables </td>
          <td valign=\"top\"> Introduced unit for variables vt, vp.
          </td>
</tr>
<tr><td valign=\"top\"> SaturationProperties</td>
          <td valign=\"top\"> Introduced unit for variable dpT.
          </td>
</tr>
<tr><td valign=\"top\"> BridgmansTables</td>
          <td valign=\"top\"> Introduced unit for dfs, dgs.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Common.ThermoFluidSpecial.</b></td></tr>
<tr><td valign=\"top\"> gibbsToProps_ph<br>
                   gibbsToProps_ph  <br>
                   gibbsToBoundaryProps<br>
                   gibbsToProps_dT<br>
                   gibbsToProps_pT</td>
          <td valign=\"top\"> Introduced unit for variables vt, vp.
          </td>
<tr><td valign=\"top\"> TwoPhaseToProps_ph</td>
          <td valign=\"top\"> Introduced unit for variables dht, dhd, detph.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.</b></td></tr>
<tr><td valign=\"top\"> MoistAir</td>
          <td valign=\"top\"> Documentation of moist air model significantly improved.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.MoistAir.</b></td></tr>
<tr><td valign=\"top\"> enthalpyOfVaporization</td>
          <td valign=\"top\"> Replaced by linear correlation since simpler and more
                   accurate in the entire region.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Media.Water.IF97_Utilities.BaseIF97.Regions.</b></td></tr>
<tr><td valign=\"top\"> drhovl_dp</td>
          <td valign=\"top\"> Introduced unit for variable dd_dp.
          </td>
</tr>

<tr><td colspan=\"2\"><b> Thermal.</b></td></tr>
<tr><td valign=\"top\"> FluidHeatFlow</td>
          <td valign=\"top\"> Introduced new parameter tapT (0..1) to define the
                   temperature of the HeatPort as linear combination of the
                   flowPort_a (tapT=0) and flowPort_b (tapT=1) temperatures.
          </td>
</tr>
</table>

<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e., errors
that can lead to wrong simulation results):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.Components.</b></td></tr>
<tr><td valign=\"top\"> ElectricalExcitation</td>
          <td valign=\"top\"> Excitation voltage ve is calculated as
                   \"spacePhasor_r.v_[1]*TurnsRatio*3/2\" instead of
                   \"spacePhasor_r.v_[1]*TurnsRatio
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
<tr><td valign=\"top\"> FixedRotation</td>
          <td valign=\"top\"> Bug corrected that the torque balance was wrong in the
                   following cases (since vector r was not transformed
                   from frame_a to frame_b; note this special case occurs very seldom in practice):
                   <ul><li> frame_b is in the spanning tree closer to the root
                                        (usually this is frame_a).</li>
                           <li> vector r from frame_a to frame_b is not zero.</li>
                   </ul>
           </td>
</tr>

<tr><td valign=\"top\"> PointMass</td>
         <td valign=\"top\"> If a PointMass model is connected so that no equations are present
                  to compute its orientation object, the orientation was arbitrarily
                  set to a unit rotation. In some cases this can lead to a wrong overall
                  model, depending on how the PointMass model is used. For this reason,
                  such cases lead now to an error (via an assert(..)) with an explanation
                  how to fix this.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialPureSubstance.</b></td></tr>
<tr><td valign=\"top\"> pressure_dT<br>
                   specificEnthalpy_dT
          </td>
          <td valign=\"top\"> Changed wrong call from \"setState_pTX\" to \"setState_dTX\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
<tr><td valign=\"top\"> pressure_dT<br>
                   specificEnthalpy_dT
          </td>
          <td valign=\"top\"> Changed wrong call from \"setState_pTX\" to \"setState_dTX\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Common.ThermoFluidSpecial.</b></td></tr>
<tr><td valign=\"top\"> gibbsToProps_dT<br>
                   helmholtzToProps_ph<br>
                   helmholtzToProps_pT<br>
                   helmholtzToProps_dT</td>
          <td valign=\"top\"> Bugs in equations corrected </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Common.</b></td></tr>
<tr><td valign=\"top\"> helmholtzToBridgmansTables<br>
                   helmholtzToExtraDerivs</td>
          <td valign=\"top\"> Bugs in equations corrected </td>
</tr>

<tr><td colspan=\"2\"><b>Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
<tr><td valign=\"top\"> density_derp_T</td>
          <td valign=\"top\"> Bug in equation of partial derivative corrected </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.</b></td></tr>
<tr><td valign=\"top\"> BaseIF97.Inverses.dtofps3<br>
                   isentropicExponent_props_ph<br>
                   isentropicExponent_props_pT<br>
                   isentropicExponent_props_dT</td>
          <td valign=\"top\"> Bugs in equations corrected </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Air.MoistAir.</b></td></tr>
<tr><td valign=\"top\"> h_pTX</td>
          <td valign=\"top\"> Bug in setState_phX due to wrong vector size in h_pTX corrected.
                   Furthermore, syntactical errors corrected:
                   <ul><li> In function massFractionpTphi an equation
                                        sign is used in an algorithm.</li>
                           <li> Two consecutive semicolons removed</li>
                   </ul>
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.</b></td></tr>
<tr><td valign=\"top\"> waterConstants</td>
          <td valign=\"top\"> Bug in equation of criticalMolarVolume corrected.
          </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Regions.</b></td></tr>
<tr><td valign=\"top\"> region_ph<br>
                   region_ps</td>
          <td valign=\"top\"> Bug in region determination corrected.
          </td>
</tr>

<tr><td valign=\"top\"> boilingcurve_p<br>
                   dewcurve_p</td>
          <td valign=\"top\"> Bug in equation of plim corrected.
          </td>
</tr>
</table>

<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e., errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g.,
units are wrong or errors in documentation):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
<tr><td colspan=\"2\"><b>Blocks.</b></td></tr>
<tr><td valign=\"top\"> Examples</td>
          <td valign=\"top\"> Corrected typos in description texts of bus example models.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Blocks.Continuous.</b></td></tr>
<tr><td valign=\"top\"> LimIntegrator</td>
          <td valign=\"top\"> removed incorrect smooth(0,..) because expression might be discontinuous.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Blocks.Math.UnitConversions.</b></td></tr>
<tr><td valign=\"top\"> block_To_kWh<br>block_From_kWh</td>
          <td valign=\"top\"> Corrected unit from \"kWh\" to (syntactically correct) \"kW.h\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Examples.</b></td></tr>
<tr><td valign=\"top\"> HeatingNPN_OrGate</td>
          <td valign=\"top\"> Included start values, so that initialization is
                                                successful </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Analog.Lines.</b></td></tr>
<tr><td valign=\"top\"> OLine</td>
          <td valign=\"top\"> Corrected unit from \"Siemens/m\" to \"S/m\".
           </td>
<tr><td valign=\"top\"> TLine2</td>
          <td valign=\"top\"> Changed wrong type of parameter NL (normalized length) from
                   SIunits.Length to Real.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
<tr><td valign=\"top\"> TransportDelay</td>
          <td valign=\"top\"> Syntax error corrected
                   (\":=\" in equation section is converted by Dymola silently to \"=\").
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.Digital</b></td></tr>
<tr><td valign=\"top\"> Converters</td>
          <td valign=\"top\"> Syntax error corrected
                   (\":=\" in equation section is converted by Dymola silently to \"=\").
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.MultiPhase.Basic.</b></td></tr>
<tr><td valign=\"top\"> Conductor</td>
          <td valign=\"top\"> Changed wrong type of parameter G from SIunits.Resistance to
                   SIunits.Conductance.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.MultiPhase.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> Plug<br></td>
          <td valign=\"top\"> Made used \"pin\" connectors non-graphical (otherwise,
                   there are difficulties to connect to Plug).
           </td>
</tr>

<tr><td colspan=\"2\"><b>Electrical.MultiPhase.Sources.</b></td></tr>
<tr><td valign=\"top\"> SineCurrent</td>
          <td valign=\"top\"> Changed wrong type of parameter offset from SIunits.Voltage to
                   SIunits.Current.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Loops.</b></td></tr>
<tr><td valign=\"top\"> EngineV6</td>
          <td valign=\"top\"> Corrected wrong crankAngleOffset of some cylinders
                   and improved the example.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Loops.Utilities.</b></td></tr>
<tr><td valign=\"top\"> GasForce</td>
          <td valign=\"top\"> Wrong units corrected:
                   \"SIunitsPosition x,y\" to \"Real x,y\";
           \"SIunits.Pressure press\" to \"SIunits.Conversions.NonSIunits.Pressure_bar\"
           </td>
</tr>
<tr><td valign=\"top\"> GasForce2</td>
          <td valign=\"top\"> Wrong unit corrected: \"SIunits.Position x\" to \"Real x\".
           </td>
</tr>
<tr><td valign=\"top\"> EngineV6_analytic</td>
          <td valign=\"top\"> Corrected wrong crankAngleOffset of some cylinders.
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> PartialLineForce</td>
          <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position eRod_a\" to \"Real eRod_a\";
           </td>
</tr>
<tr><td valign=\"top\"> FlangeWithBearingAdaptor </td>
          <td valign=\"top\"> If includeBearingConnector = false, connector \"fr\"
                           + \"ame\" was not
                   removed. As long as the connecting element to \"frame\" determines
                   the non-flow variables, this is fine. In the corrected version, \"frame\"
                   is conditionally removed in this case.</td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces.</b></td></tr>
<tr><td valign=\"top\"> ForceAndTorque</td>
          <td valign=\"top\"> Corrected wrong unit: \"SIunits.Force t_b_0\" to \"SIunits.Torque t_b_0\".
           </td>
</tr>
<tr><td valign=\"top\"> LineForceWithTwoMasses</td>
          <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position e_rel_0\" to \"Real e_rel_0\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.</b></td></tr>
<tr><td valign=\"top\"> axisRotation</td>
          <td valign=\"top\"> Corrected wrong unit: \"SIunits.Angle der_angle\" to
                        \"SIunits.AngularVelocity der_angle\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.Assemblies.</b></td></tr>
<tr><td valign=\"top\"> JointUSP<br>JointSSP</td>
          <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position aux\"  to \"Real\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors.</b></td></tr>
<tr><td valign=\"top\"> AbsoluteSensor</td>
          <td valign=\"top\"> Corrected wrong units: \"SIunits.Acceleration angles\" to
                   \"SIunits.Angle angles\" and
                   \"SIunits.Velocity w_abs_0\" to \"SIunits.AngularVelocity w_abs_0\"
           </td>
</tr>
<tr><td valign=\"top\"> RelativeSensor</td>
          <td valign=\"top\"> Corrected wrong units: \"SIunits.Acceleration angles\" to
                   \"SIunits.Angle angles\"
           </td>
</tr>
<tr><td valign=\"top\"> Distance</td>
          <td valign=\"top\"> Corrected wrong units: \"SIunits.Length L2\" to \"SIunits.Area L2\" and
                   SIunits.Length s_small2\" to \"SIunits.Area s_small2\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.MultiBody.Visualizers.Advanced.</b></td></tr>
<tr><td valign=\"top\"> Shape</td>
          <td valign=\"top\"> Changed \"MultiBody.Types.Color color\" to \"Real color[3]\", since
                   \"Types.Color\" is \"Integer color[3]\" and there have been backward
                   compatibility problems with models using \"color\" before it was changed
                   to \"Types.Color\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> FrictionBase</td>
          <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
                   \"unitTorque\" in order that the equations are correct with respect
                   to units (previously, variable \"s\" can be both a torque and an
                   angular acceleration and this lead to unit incompatibilities)
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> OneWayClutch<br>LossyGear</td>
          <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
                   \"unitTorque\" in order that the equations are correct with respect
                   to units (previously, variable \"s\" can be both a torque and an
                   angular acceleration and this lead to unit incompatibilities)
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> FrictionBase</td>
          <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
                   \"unitTorque\" in order that the equations are correct with respect
                   to units (previously, variable \"s\" can be both a torque and an
                   angular acceleration and this lead to unit incompatibilities)
           </td>
</tr>

<tr><td colspan=\"2\"><b>Mechanics.Translational.</b></td></tr>
<tr><td valign=\"top\"> Speed</td>
          <td valign=\"top\"> Corrected unit of v_ref from SIunits.Position to SIunits.Velocity
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Examples.Tests.Components.</b></td></tr>
<tr><td valign=\"top\"> PartialTestModel<br>PartialTestModel2</td>
          <td valign=\"top\"> Corrected unit of h_start from \"SIunits.Density\" to \"SIunits.SpecificEnthalpy\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Examples.SolveOneNonlinearEquation.</b></td></tr>
<tr><td valign=\"top\"> Inverse_sh_T
                   InverseIncompressible_sh_T<br>
                   Inverse_sh_TX</td>
          <td valign=\"top\"> Rewrote equations so that dimensional (unit) analysis is correct\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Incompressible.Examples.</b></td></tr>
<tr><td valign=\"top\"> TestGlycol</td>
          <td valign=\"top\"> Rewrote equations so that dimensional (unit) analysis is correct\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
<tr><td valign=\"top\"> dBubbleDensity_dPressure<br>dDewDensity_dPressure</td>
          <td valign=\"top\"> Changed wrong type of ddldp from \"DerDensityByEnthalpy\"
                   to \"DerDensityByPressure\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Common.ThermoFluidSpecial.</b></td></tr>
<tr><td valign=\"top\"> ThermoProperties</td>
          <td valign=\"top\"> Changed wrong units:
                   \"SIunits.DerEnergyByPressure dupT\" to \"Real dupT\" and
                   \"SIunits.DerEnergyByDensity dudT\" to \"Real dudT\"
           </td>
</tr>
<tr><td valign=\"top\"> ThermoProperties_ph</td>
          <td valign=\"top\"> Changed wrong unit from \"SIunits.DerEnergyByPressure duph\" to \"Real duph\"
           </td>
</tr>
<tr><td valign=\"top\"> ThermoProperties_pT</td>
          <td valign=\"top\"> Changed wrong unit from \"SIunits.DerEnergyByPressure dupT\" to \"Real dupT\"
           </td>
</tr>
<tr><td valign=\"top\"> ThermoProperties_dT</td>
          <td valign=\"top\">  Changed wrong unit from \"SIunits.DerEnergyByDensity dudT\" to \"Real dudT\"
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
<tr><td valign=\"top\"> cp_Tlow_der</td>
          <td valign=\"top\"> Changed wrong unit from \"SIunits.Temperature dT\" to \"Real dT\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Basic.</b></td></tr>
<tr><td valign=\"top\"> p1_hs<br>
                   h2ab_s<br>
                   p2a_hs<br>
                   p2b_hs<br>
                   p2c_hs<br>
                   h3ab_p<br>
                   T3a_ph<br>
                   T3b_ph<br>
                   v3a_ph<br>
                   v3b_ph<br>
                   T3a_ps<br>
                   T3b_ps<br>
                   v3a_ps<br>
                   v3b_ps</td>
          <td valign=\"top\"> Changed wrong unit of variables h/hstar, s, sstar from
                   \"SIunits.Enthalpy\" to \"SIunits.SpecificEnthalpy\",
                   \"SIunits.SpecificEntropy\", \"SIunits.SpecificEntropy
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Transport.</b></td></tr>
<tr><td valign=\"top\"> cond_dTp</td>
          <td valign=\"top\"> Changed wrong unit of TREL, rhoREL, lambdaREL from
                   \"SIunits.Temperature\", \"SIunit.Density\", \"SIunits.ThermalConductivity\"
                   to \"Real\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Inverses.</b></td></tr>
<tr><td valign=\"top\"> tofps5<br>tofpst5</td>
          <td valign=\"top\"> Changed wrong unit of pros from \"SIunits.SpecificEnthalpy\" to
                   \"SIunits.SpecificEntropy\".
           </td>
</tr>

<tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.</b></td></tr>
<tr><td valign=\"top\"> waterBaseProp_ph</td>
          <td valign=\"top\"> Improved calculation at the limits of the validity.
           </td>
</tr>

        <tr><td colspan=\"2\"><b>Thermal.</b></td></tr>
<tr><td valign=\"top\"> FluidHeatFlow<br>HeatTransfer</td>
          <td valign=\"top\"> Corrected wrong unit \"SIunits.Temperature\" of difference temperature
                        variables with \"SIunits.TemperatureDifference\".
           </td>
</tr>

</table>

</html>"));
      end Version_2_2_2;

      class Version_2_2_1 "Version 2.2.1 (March 24, 2006)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p>
Version 2.2.1 is backward compatible to version 2.2.
</p>

<p>
In this version, <b>no</b> new libraries have been added.
The following major improvements have been made:
</p>

<ul>
<li> The <b>Documentation</b> of the Modelica standard library was
         considerably improved:<br>
         In Dymola 6, the new feature was introduced to automatically add tables
         for class content and component interface definitions (parameters and
         connectors) to the info layer. For this reason, the corresponding (partial)
         tables previously present in the Modelica Standard Library have been
         removed. The new feature of Dymola 6 has the significant advantage that
         all tables are now guaranteed to be up-to-date.<br>
         Additionally, the documentation has been improved by adding appropriate
         description texts to parameters, connector instances, function input
         and output arguments etc., in order that the automatically generated
         tables do not have empty entries. Also new User's Guides for sublibraries
         Rotational and SIunits have been added and the User's Guide on top
         level (Modelica.UsersGuide) has been improved.<br>&nbsp;</li>

<li> Initialization options have been added to the Modelica.Blocks.<b>Continuous</b>
         blocks (NoInit, SteadyState, InitialState, InitialOutput). If InitialOutput
         is selected, the block output is provided as initial condition. The states
         of the block are then initialized as close as possible to steady state.
         Furthermore, the Continuous.LimPID block has been significantly
         improved and much better documented.<br>&nbsp;</li>

<li> The Modelica.<b>Media</b> library has been significantly improved:<br>
         New functions setState_pTX, setState_phX, setState_psX, setState_dTX
         have been added to PartialMedium to compute the independent medium variables
         (= state of medium) from p,T,X, or from p,h,X or from p,s,X or from
         d,T,X. Then functions are provided for all interesting medium variables
         to compute them from its medium state. All these functions are
         implemented in a robust way for all media (with a few exceptions, if the
         generic function does not make sense for a particular medium).</li>
</ul>

<p>
The following <b>new components</b> have been added to <b>existing</b> libraries:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Examples.</b></td></tr>
<tr><td valign=\"top\"> PID_Controller</td>
          <td valign=\"top\"> Example to demonstrate the usage of the
                   Blocks.Continuous.LimPID block.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
<tr><td valign=\"top\"> UnitConversions.*</td>
          <td valign=\"top\"> New package that provides blocks for unit conversions.
                   UnitConversions.ConvertAllBlocks allows to select all
                   available conversions from a menu.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines.</b></td></tr>
<tr><td valign=\"top\"> SM_ElectricalExcitedDamperCage</td>
          <td valign=\"top\"> Electrical excited synchronous induction machine with damper cage</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.Components.</b></td></tr>
<tr><td valign=\"top\"> ElectricalExcitation </td>
          <td valign=\"top\"> Electrical excitation for electrical excited synchronous
                   induction machines</td> </tr>
<tr><td valign=\"top\"> DamperCage</td>
          <td valign=\"top\"> Unsymmetrical damper cage for electrical excited synchronous
                   induction machines. At least the user has to specify the dampers
                   resistance and stray inductance in d-axis; if he omits the
                   parameters of the q-axis, the same values as for the d.axis
                   are used, assuming a symmetrical damper.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.</b></td></tr>
<tr><td valign=\"top\"> SMEE_Gen </td>
          <td valign=\"top\"> Test example 7: ElectricalExcitedSynchronousInductionMachine
                   as Generator</td> </tr>
<tr><td valign=\"top\"> Utilities.TerminalBox</td>
          <td valign=\"top\"> Terminal box for three-phase induction machines to choose
                   either star (wye) ? or delta ? connection</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.</b></td></tr>
<tr><td valign=\"top\"> equalityLeastSquares</td>
          <td valign=\"top\"> Solve a linear equality constrained least squares problem:<br>
                  min|A*x-a|^2 subject to B*x=b</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\"> Parts.PointMass</td>
          <td valign=\"top\"> Point mass, i.e., body where inertia tensor is neglected.</td> </tr>
<tr><td valign=\"top\"> Interfaces.FlangeWithBearing</td>
          <td valign=\"top\"> Connector consisting of 1-dim. rotational flange and its
                   3-dim. bearing frame.</td> </tr>
<tr><td valign=\"top\"> Interfaces.FlangeWithBearingAdaptor</td>
          <td valign=\"top\"> Adaptor to allow direct connections to the sub-connectors
                   of FlangeWithBearing.</td> </tr>
<tr><td valign=\"top\"> Types.SpecularCoefficient</td>
          <td valign=\"top\"> New type to define a specular coefficient.</td> </tr>
<tr><td valign=\"top\"> Types.ShapeExtra</td>
          <td valign=\"top\"> New type to define the extra data for visual shape objects and to
                   have a central place for the documentation of this data.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Elementary</b></td></tr>
<tr><td valign=\"top\"> PointGravityWithPointMasses</td>
          <td valign=\"top\"> Example of two point masses in a central gravity field.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\">UsersGuide</td>
          <td valign=\"top\"> A User's Guide has been added by using the documentation previously
                   present in the package documentation of Rotational.</td> </tr>
<tr><td valign=\"top\">Sensors.PowerSensor</td>
          <td valign=\"top\"> New component to measure the energy flow between two connectors
                   of the Rotational library.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.</b></td></tr>
<tr><td valign=\"top\">Speed</td>
          <td valign=\"top\"> New component to move a translational flange
                   according to a reference speed</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.PartialMedium.</b></td></tr>
<tr><td valign=\"top\">specificEnthalpy_pTX</td>
          <td valign=\"top\"> New function to compute specific enthalpy from pressure, temperature
                   and mass fractions.</td> </tr>
<tr><td valign=\"top\">temperature_phX</td>
          <td valign=\"top\"> New function to compute temperature from pressure, specific enthalpy,
                   and mass fractions.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
<tr><td valign=\"top\"> SignalBus</td>
          <td valign=\"top\"> Icon for signal bus</td> </tr>
<tr><td valign=\"top\"> SignalSubBus</td>
          <td valign=\"top\"> Icon for signal sub-bus</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
<tr><td valign=\"top\">UsersGuide</td>
          <td valign=\"top\"> A User's Guide has been added that describes unit handling.</td> </tr>
<tr><td valign=\"top\"> Resistance<br>
                   Conductance</td>
          <td valign=\"top\"> Attribute 'min=0' removed from these types.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.</b></td></tr>
<tr><td valign=\"top\"> Components.Valve</td>
          <td valign=\"top\"> Simple controlled valve with either linear or
                   exponential characteristic.</td> </tr>
<tr><td valign=\"top\"> Sources. IdealPump </td>
          <td valign=\"top\"> Simple ideal pump (resp. fan)  dependent on the shaft?s speed;
                   pressure increase versus volume flow is defined as a linear
                   function. Torque * Speed = Pressure increase * Volume flow
                   (without losses).</td> </tr>
<tr><td valign=\"top\"> Examples.PumpAndValve </td>
          <td valign=\"top\"> Test example for valves.</td> </tr>
<tr><td valign=\"top\"> Examples.PumpDropOut </td>
          <td valign=\"top\"> Drop out of 1 pump to test behavior of semiLinear.</td> </tr>
<tr><td valign=\"top\"> Examples.ParallelPumpDropOut </td>
          <td valign=\"top\"> Drop out of 2 parallel pumps to test behavior of semiLinear.</td> </tr>
<tr><td valign=\"top\"> Examples.OneMass </td>
          <td valign=\"top\"> Cooling of 1 hot mass to test behavior of semiLinear.</td> </tr>
<tr><td valign=\"top\"> Examples.TwoMass </td>
          <td valign=\"top\"> Cooling of 2 hot masses to test behavior of semiLinear.</td> </tr>
</table>

<p>
The following <b>components</b> have been improved:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
<tr><td valign=\"top\"> UsersGuide</td>
          <td valign=\"top\"> User's Guide and package description of Modelica Standard Library improved.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces.</b></td></tr>
<tr><td valign=\"top\"> RealInput<br>
                   BooleanInput<br>
                   IntegerInput</td>
          <td valign=\"top\"> When dragging one of these connectors the width and height
                   is a factor of 2 larger as a standard icon. Previously,
                   these connectors have been dragged and then manually enlarged
                   by a factor of 2 in the Modelica standard library.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.</b></td></tr>
<tr><td valign=\"top\"> Continuous.*</td>
          <td valign=\"top\"> Initialization options added to all blocks
                   (NoInit, SteadyState, InitialState, InitialOutput).
                   New parameter limitsAtInit to switch off the limits
                   of LimIntegrator or LimPID during initialization</td> </tr>
<tr><td valign=\"top\"> Continuous.LimPID</td>
          <td valign=\"top\"> Option to select P, PI, PD, PID controller.
                   Documentation significantly improved.</td> </tr>
<tr><td valign=\"top\"> Nonlinear.Limiter<br>
                   Nonlinear.VariableLimiter<br>
                   Nonlinear.Deadzone</td>
          <td valign=\"top\"> New parameter limitsAtInit/deadZoneAtInit to switch off the limits
                   or the dead zone during initialization</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog. </b></td></tr>
<tr><td valign=\"top\"> Sources</td>
          <td valign=\"top\"> Icon improved (+/- added to voltage sources, arrow added to
                   current sources).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors. </b></td></tr>
<tr><td valign=\"top\"> Diode</td>
          <td valign=\"top\"> smooth() operator included to improve numerics.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines. </b></td></tr>
<tr><td valign=\"top\"> SM_PermanentMagnetDamperCage<br>
                   SM_ElectricalExcitedDamperCage<br>
                   SM_ReluctanceRotorDamperCage</td>
          <td valign=\"top\"> The user can choose \"DamperCage = false\" (default: true)
                   to remove all equations for the damper cage from the model.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines. </b></td></tr>
<tr><td valign=\"top\"> AIM_SlipRing</td>
          <td valign=\"top\"> Easier parameterization: if the user selects \"useTurnsRatio = false\"
                   (default: true, this is the same behavior as before),
                        parameter TurnsRatio is calculated internally from
                        Nominal stator voltage and Locked-rotor voltage.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Math.Matrices.</b></td></tr>
<tr><td valign=\"top\">leastSquares</td>
          <td valign=\"top\">The A matrix in the least squares problem might be rank deficient.
                  Previously, it was required that A has full rank.</td>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\">all models</td>
          <td valign=\"top\"> <ul>
                   <li> All components with animation information have a new variable
                                <b>specularCoefficient</b> to define the reflection of ambient light.
                                The default value is world.defaultSpecularCoefficient which has
                                a default of 0.7. By changing world.defaultSpecularCoefficient, the
                                specularCoefficient of all components is changed that are not
                                explicitly set differently. Since specularCoefficient is a variable
                                (and no parameter), it can be changed during simulation. Since
                                annotation(Dialog) is set, this variable still appears in the
                                parameter menus.<br>
                                Previously, a constant specularCoefficient of 0.7 was used
                                for all components.</li>
                   <li> Variable <b>color</b> of all components is no longer a parameter
                                but an input variable. Also all parameters in package <b>Visualizers</b>,
                                with the exception of <b>shapeType</b> are no longer parameters but
                                defined as input variables with annotation(Dialog). As a result,
                                all these variables appear still in parameter menus, but they can
                                be changed during simulation (e.g., color might be used to
                                display the temperature of a part).</li>
                   <li> All menus have been changed to follow the Modelica 2.2 annotations
                                \"Dialog, group, tab, enable\" (previously, a non-standard Dymola
                                definition for menus was used). Also, the \"enable\" annotation
                                is used in all menus
                                to disable input fields if the input would be ignored.</li>
                   <li> All visual shapes are now defined with conditional declarations
                                (to remove them, if animation is switched off). Previously,
                                these (protected) objects have been defined by arrays with
                                dimension 0 or 1.</li>
                   </ul></td></tr>

<tr><td valign=\"top\">Frames.resolveRelative</td>
          <td valign=\"top\"> The derivative of this function added as function and defined via
                   an annotation. In certain situations, tools had previously
                   difficulties to differentiate the inlined function automatically.</td>

<tr><td valign=\"top\">Forces.*</td>
          <td valign=\"top\"> The scaling factors N_to_m and Nm_to_m have no longer a default
                   value of 1000 but a default value of world.defaultN_to_m (=1000)
                   and world.defaultNm_to_m (=1000). This allows to change the
                   scaling factors for all forces and torques in the world
                   object.</td>
<tr><td valign=\"top\">Interfaces.Frame.a<br>
                  Interfaces.Frame.b<br>
                  Interfaces.Frame_resolve</td>
          <td valign=\"top\"> The Frame connectors are now centered around the origin to ease
                   the usage. The shape was changed, such that the icon is a factor
                   of 1.6 larger as a standard icon (previously, the icon had a
                   standard size when dragged and then the icon was manually enlarged
                   by a factor of 1.5 in the y-direction in the MultiBody library;
                   the height of 16 allows easy positioning on the standard grid size of 2).
                   The double line width of the border in icon and diagram layer was changed
                   to a single line width and when making a connection the connection
                   line is dark grey and no longer black which looks better.</td>
<tr><td valign=\"top\">Joints.Assemblies.*</td>
          <td valign=\"top\"> When dragging an assembly joint, the icon is a factor of 2
                   larger as a standard icon. Icon texts and connectors have a
                   standard size in this enlarged icon (and are not a factor of 2
                   larger as previously). </td>
<tr><td valign=\"top\">Types.*</td>
          <td valign=\"top\"> All types have a corresponding icon now to visualize the content
                   in the package browser (previously, the types did not have an icon).</td>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\"> Inertia</td>
          <td valign=\"top\"> Initialization and state selection added.</td> </tr>
<tr><td valign=\"top\"> SpringDamper</td>
          <td valign=\"top\"> Initialization and state selection added.</td> </tr>
<tr><td valign=\"top\"> Move</td>
          <td valign=\"top\"> New implementation based solely on Modelica 2.2 language
                   (previously, the Dymola specific constrain(..) function was used).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.</b></td></tr>
<tr><td valign=\"top\"> Move</td>
          <td valign=\"top\"> New implementation based solely on Modelica 2.2 language
                   (previously, the Dymola specific constrain(..) function was used).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
<tr><td valign=\"top\"> SimpleFriction</td>
          <td valign=\"top\"> Calculates friction losses from pressure drop and volume flow.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.Components.</b></td></tr>
<tr><td valign=\"top\"> IsolatedPipe <br>
                   HeatedPipe</td>
          <td valign=\"top\"> Added geodetic height as a source of pressure change;
                   feeds friction losses as calculated by simple friction to
                   the energy balance of the medium.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.PartialMedium.FluidConstants.</b></td></tr>
<tr><td valign=\"top\">HCRIT0</td><td valign=\"top\">Critical specific enthalpy of the fundamental
                  equation (base formulation of the fluid medium model). </td></tr>
<tr><td valign=\"top\">SCRIT0</td><td valign=\"top\">Critical specific entropy of the fundamental
                  equation (base formulation of the fluid medium model). </td></tr>
<tr><td valign=\"top\">deltah</td><td valign=\"top\">Enthalpy offset (default: 0) between the
                  specific enthalpy of the fluid model and the user-visible
                  specific enthalpy in the model: deltah = h_model - h_fundamentalEquation.
</td></tr>
<tr><td valign=\"top\">deltas</td><td valign=\"top\">Entropy offset (default: 0) between the
                  specific entropy of the fluid model and the user-visible
                  specific entropy in the model: deltas = s_model - s_fundamentalEquation.</td></tr>
<tr><td valign=\"top\">T_default</td><td valign=\"top\">Default value for temperature of medium (for initialization)</td></tr>
<tr><td valign=\"top\">h_default</td><td valign=\"top\">Default value for specific enthalpy of medium (for initialization)</td></tr>
<tr><td valign=\"top\">p_default</td><td valign=\"top\">Default value for pressure of medium (for initialization)</td></tr>
<tr><td valign=\"top\">X_default</td><td valign=\"top\">Default value for mass fractions of medium (for initialization)</td></tr>
</table>
<p>
The following <b>errors</b> have been fixed:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Tables.</b></td></tr>
<tr><td valign=\"top\">CombiTable1D<br>
                  CombiTable1Ds<br>
                  CombiTable2D</td>
          <td valign=\"top\"> Parameter \"tableOnFile\" determines now whether a table is read from
                   file or used from parameter \"table\". Previously, if \"fileName\" was not
                   \"NoName\", a table was always read from file \"fileName\", independently
                   of the setting of \"tableOnFile\". This has been corrected.<br>
                   Furthermore, the initialization of a table is now performed in a
                   when-clause and no longer in a parameter declaration, because some
                   tools evaluate the parameter declaration in some situation more than
                   once and then the table is unnecessarily read several times
                   (and occupies also more memory).</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\">CombiTimeTable</td>
          <td valign=\"top\"> Same bug fix/improvement as for the tables from Modelica.Blocks.Tables
                   as outlined above.</td> </tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors. </b></td></tr>
<tr><td valign=\"top\"> PMOS<br>
                   NMOS<br>
                   HeatingPMOS<br>
                   HeatingNMOS</td>
          <td valign=\"top\"> The Drain-Source-Resistance RDS had actually a resistance of
                   RDS/v, with v=Beta*(W+dW)/(L+dL). The correct formula is without
                   the division by \"v\". This has now been corrected.<br>
                   This bug fix should not have an essential effect in most applications.
                   In the default case (Beta=1e-5), the Drain-Source-Resistance was
                   a factor of 1e5 too large and had in the default case the
                   wrong value 1e12, although it should have the value 1e7. The effect
                   was that this resistance had practically no effect.</td> </tr>

<tr><td colspan=\"2\"> <b>Modelica.Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
<tr><td valign=\"top\"> dynamicViscosityLowPressure</td>
          <td valign=\"top\"> Viscosity and thermal conductivity (which needs viscosity as input)
                   were computed wrong for polar gases and gas mixtures
                   (i.e., if dipole moment not 0.0). This has been fixed in version 2.2.1.</td> </tr>
<tr><td colspan=\"2\"><b>Modelica.Utilities.Streams.</b></td></tr>
<tr><td valign=\"top\">readLine</td>
          <td valign=\"top\"> Depending on the C-implementation, the stream was not correctly closed.
                   This has been corrected by adding a \"Streams.close(..)\"
                   after reading the file content.</td> </tr>

</table>
</html>"));
      end Version_2_2_1;

      class Version_2_2 "Version 2.2 (April 6, 2005)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p>
Version 2.2 is backward compatible to version 2.1.
</p>

<p>
The following <b>new libraries</b> have been added:
</p>

<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Media\">Modelica.Media</a></td>
          <td valign=\"top\"> Property models of liquids and gases, especially
                   <ul>
                   <li>1241 detailed gas models,</li>
                   <li> moist air,</li>
                   <li> high precision water model (according to IAPWS/IF97 standard), </li>
                   <li> incompressible media defined by tables (cp(T), rho(t), eta(T), etc. are defined by tables).</li>
                   </ul>
                   The user can conveniently define mixtures of gases between the
                   1241 gas models. The models are
                   designed to work well in dynamic simulations. They
                   are based on a new standard interface for media with
                   single and multiple substances and one or multiple phases
                   with the following features:
                   <ul>
                   <li> The independent variables of a medium model do not influence the
                                definition of a fluid connector port or how the
                                balance equations have to be implemented.<br>
                                Used independent variables: \"p,T\", \"p,T,X\", \"p,h\", \"d,T\".</li>
                   <li> Optional variables, e.g., dynamic viscosity, are only computed
                                if needed.</li>
                   <li> The medium models are implemented with regards to efficient
                                dynamic simulation.</li>
                   </ul>
          </td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Thermal.FluidHeatFlow\">Modelica.Thermal.FluidHeatFlow</a></td>
          <td valign=\"top\"> Simple components for 1-dim., incompressible thermo-fluid flow
                   to model coolant flows, e.g., of electrical machines.
                   Components can be connected arbitrarily together (= ideal mixing
                   at connection points) and fluid may reverse direction of flow.
</td></tr>
</table>
<p>
The following <b>changes</b> have been performed in the
<b>Modelica.Mechanics.MultiBody</b> library:
</p>
<ul>
<li> Component MultiBody.World has a new parameter
         <b>driveTrainMechanics3D</b>. If set to <b>true</b>, 3D mechanical effects
         of MultiBody.Parts.Mounting1D/Rotor1D/BevelGear1D are taken into account. If set to
         <b>false</b> (= default), 3D mechanical effects in these elements
         are not taken into account and the
         frame connectors to connect to 3D parts are disabled (all
         connections to such a disabled connector are also disabled, due to the
         new feature of conditional declarations in Modelica language 2.2)</li>
<li> All references to \"MultiBody.xxx\" have
         been changed to \"Modelica.Mechanics.MultiBodys.xxx\" in order that after
         copying of a component outside of the Modelica library, the references
         still remain valid.</li>
</ul>
</html>"));
      end Version_2_2;

      class Version_2_1 "Version 2.1 (Nov. 11, 2004)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p> This is a major change with respect to previous versions of the
        Modelica Standard Library, because <b>many new libraries</b> and components
        are included and because the input/output blocks (Modelica.Blocks)
        have been considerably simplified:
</p>
<ul>
<li> An input/output connector is defined <b>without</b> a hierarchy (this is possible
         due to new features of the Modelica language). For example, the input
         signal of a block \"FirstOrder\" was previously accessed as \"FirstOrder.inPort.signal[1]\".
         Now it is accessed as \"FirstOrder.u\". This simplifies the understanding and usage
         especially for beginners.</li>
<li> De-vectorized the <b>Modelica.Blocks</b> library. All blocks in the
         Modelica.Blocks library are now scalar blocks. As a result,
         the parameters of the Blocks are scalars and no vectors any
         more. For example, a parameter \"amplitude\" that might had
         a value of \"{1}\" previously, has now a value of \"1\". This simplifies
         the understanding and usage especially for beginners.<br>
         If a vector of blocks is needed, this can be easily
         accomplished by adding a dimension to the instance. For example
         \"Constant const[3](k={1,2,3}\" defines three Constant blocks.
         An additional advantage of the new approach is that
         the implementation of Modelica.Blocks is much simpler and is easier to
         understand.
</li>
</ul>

<p>
The discussed changes of Modelica.Blocks are not backward compatible.
A script to <b>automatically</b> convert models to this new version is
provided. There might be rare cases, where this script does not convert.
In this case models have to be manually converted.
In any case you should make a back-up copy of your model
before automatic conversion is performed.
</p>
<p>
The following <b>new libraries</b> have been added:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Digital\">Modelica.Electrical.Digital</a></td>
          <td valign=\"top\">Digital electrical components based on 2-,3-,4-, and 9-valued logic<br>
                  according to the VHDL standard</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Machines\">Modelica.Electrical.Machines</a></td>
          <td valign=\"top\">Asynchronous, synchronous and DC motor and generator models</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Math.Matrices\">Modelica.Math.Matrices</a></td>
          <td valign=\"top\">Functions operating on matrices such as solve() (A*x=b), leastSquares(),<br>
                  norm(), LU(), QR(),  eigenValues(), singularValues(), exp(), ...</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.StateGraph\">Modelica.StateGraph</a></td>
          <td valign=\"top\"> Modeling of <b>discrete event</b> and <b>reactive</b> systems in a convenient way using<br>
                   <b>hierarchical state machines</b> and <b>Modelica</b> as <b>action language</b>. <br>
                   It is based on JGrafchart and Grafcet and  has a similar modeling power as <br>
                   StateCharts. It avoids deficiencies of usually used action languages. <br>
                   This library makes the ModelicaAdditions.PetriNets library obsolet.</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Utilities.Files\">Modelica.Utilities.Files</a></td>
          <td valign=\"top\">Functions to operate on files and directories (copy, move, remove files etc.)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Utilities.Streams\">Modelica.Utilities.Streams</a></td>
          <td valign=\"top\">Read from files and write to files (print, readLine, readFile, error, ...)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Utilities.Strings\">Modelica.Utilities.Strings</a></td>
          <td valign=\"top\">Operations on strings (substring, find, replace, sort, scanToken, ...)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Utilities.System\">Modelica.Utilities.System</a></td>
          <td valign=\"top\">Get/set current directory, get/set environment variable, execute shell command, etc.</td></tr>
</table>
<p>
The following existing libraries outside of the Modelica standard library
have been improved and added as <b>new libraries</b>
(models using the previous libraries are automatically converted
to the new sublibraries inside package Modelica):
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Discrete\">Modelica.Blocks.Discrete</a></td>
          <td valign=\"top\"> Discrete input/output blocks with fixed sample period<br>
                   (from ModelicaAdditions.Blocks.Discrete)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Logical\">Modelica.Blocks.Logical</a></td>
          <td valign=\"top\"> Logical components with Boolean input and output signals<br>
                   (from ModelicaAdditions.Blocks.Logical)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Nonlinear\">Modelica.Blocks.Nonlinear</a></td>
          <td valign=\"top\"> Discontinuous or non-differentiable algebraic control blocks such as variable limiter,<br>
                   fixed, variable and Pade delay etc. (from ModelicaAdditions.Blocks.Nonlinear)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Routing\">Modelica.Blocks.Routing</a></td>
          <td valign=\"top\"> Blocks to combine and extract signals, such as multiplexer<br>
                   (from ModelicaAdditions.Blocks.Multiplexer)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Blocks.Tables\">Modelica.Blocks.Tables</a></td>
          <td valign=\"top\"> One and two-dimensional interpolation in tables. CombiTimeTable is available<br>
                   in Modelica.Blocks.Sources (from ModelicaAdditions.Tables)</td></tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.MultiBody\">Modelica.Mechanics.MultiBody</a></td>
          <td valign=\"top\"> Components to model the movement of 3-dimensional mechanical systems. Contains <br>
                   body, joint, force and sensor components, analytic handling of kinematic loops,<br>
                   force elements with mass, series/parallel connection of 3D force elements etc.<br>
                   (from MultiBody 1.0 where the new signal connectors are used;<br>
                   makes the ModelicaAdditions.MultiBody library obsolete)</td></tr>
</table>
<p>
As a result, the ModelicaAdditions library is obsolete, because all components
are either included in the Modelica library or are replaced by much more
powerful libraries (MultiBody, StateGraph).
</p>
<p>
The following <b>new components</b> have been added to <b>existing</b> libraries.
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Logical.</b></td></tr>
<tr><td valign=\"top\">Pre</td>
          <td valign=\"top\">y = pre(u): Breaks algebraic loops by an infinitesimal small <br>
                  time delay (event iteration continues until u = pre(u))</td></tr>
<tr><td valign=\"top\">Edge</td>
          <td valign=\"top\">y = edge(u): Output y is true, if the input u has a rising edge </td></tr>
<tr><td valign=\"top\">FallingEdge</td>
          <td valign=\"top\">y = edge(not u): Output y is true, if the input u has a falling edge </td></tr>
<tr><td valign=\"top\">Change</td>
          <td valign=\"top\">y = change(u): Output y is true, if the input u has a rising or falling edge </td></tr>
<tr><td valign=\"top\">GreaterEqual</td>
          <td valign=\"top\">Output y is true, if input u1 is greater or equal than input u2 </td></tr>
<tr><td valign=\"top\">Less</td>
          <td valign=\"top\">Output y is true, if input u1 is less than input u2 </td></tr>
<tr><td valign=\"top\">LessEqual</td>
          <td valign=\"top\">Output y is true, if input u1 is less or equal than input u2 </td></tr>
<tr><td valign=\"top\">Timer</td>
          <td valign=\"top\">Timer measuring the time from the time instant where the <br>
                  Boolean input became true </td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
<tr><td valign=\"top\">BooleanToReal</td>
          <td valign=\"top\">Convert Boolean to Real signal</td></tr>
<tr><td valign=\"top\">BooleanToInteger</td>
          <td valign=\"top\">Convert Boolean to Integer signal</td></tr>
<tr><td valign=\"top\">RealToBoolean</td>
          <td valign=\"top\">Convert Real to Boolean signal</td></tr>
<tr><td valign=\"top\">IntegerToBoolean</td>
          <td valign=\"top\">Convert Integer to Boolean signal</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\">RealExpression</td>
          <td valign=\"top\">Set output signal to a time varying Real expression</td></tr>
<tr><td valign=\"top\">IntegerExpression</td>
          <td valign=\"top\">Set output signal to a time varying Integer expression</td></tr>
<tr><td valign=\"top\">BooleanExpression</td>
          <td valign=\"top\">Set output signal to a time varying Boolean expression</td></tr>
<tr><td valign=\"top\">BooleanTable</td>
          <td valign=\"top\">Generate a Boolean output signal based on a vector of time instants</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
<tr><td valign=\"top\">Frames.from_T2</td>
          <td valign=\"top\">Return orientation object R from transformation matrix T and its derivative der(T)</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\">LinearSpeedDependentTorque</td>
          <td valign=\"top\">Linear dependency of torque versus speed (acts as load torque)</td></tr>
<tr><td valign=\"top\">QuadraticSpeedDependentTorque</td>
          <td valign=\"top\">Quadratic dependency of torque versus speed (acts as load torque)</td></tr>
<tr><td valign=\"top\">ConstantTorque</td>
          <td valign=\"top\">Constant torque, not dependent on speed (acts as load torque)</td></tr>
<tr><td valign=\"top\">ConstantSpeed</td>
          <td valign=\"top\">Constant speed, not dependent on torque (acts as load torque)</td></tr>
<tr><td valign=\"top\">TorqueStep</td>
          <td valign=\"top\">Constant torque, not dependent on speed (acts as load torque)</td></tr>
</table>
<p>
The following <b>bugs</b> have been <b>corrected</b>:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Forces.</b></td></tr>
<tr><td valign=\"top\">LineForceWithMass<br>
                  Spring</td>
          <td valign=\"top\">If mass of the line force or spring component is not zero, the<br>
                  mass was (implicitly) treated as \"mass*mass\" instead of as \"mass\"</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\">Speed</td>
          <td valign=\"top\">If parameter exact=<b>false</b>, the filter was wrong<br>
                  (position was filtered and not the speed input signal)</td></tr>
</table>
<p>
Other changes:
</p>
<ul>
<li> All connectors are now smaller in the diagram layer. This gives
         a nicer layout when connectors and components are used together
         in a diagram</li>
<li> Default instance names are defined for all connectors, according
         to a new annotation introduced in Modelica 2.1. For example,
         when dragging connector \"Flange_a\" from the Rotational library to
         the diagram layer, the default connector instance name is
         \"flange_a\" and not \"Flange_a1\".</li>
<li> The Modelica.Mechanics.Rotational connectors are changed from
         a square to a circle</li>
<li> The Modelica.Mechanics.Translational connectors are changed from a
         green to a dark green color in order that connection lines
         can be better seen, especially when printed.</li>
<li> The Modelica.Blocks connectors for Real signals are changed from
         blue to dark blue in order to distinguish them from electrical signals.</li>
</ul>
</html>"));
      end Version_2_1;

      class Version_1_6 "Version 1.6 (June 21, 2004)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p> Added 1 new library (Electrical.MultiPhase), 17 new components,
        improved 3 existing components
        in the Modelica.Electrical library and improved 3 types
        in the Modelica.SIunits library. Furthermore,
        this User's Guide has been started. The improvements
        in more detail:
</p>
<p>
<b>New components</b>
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\">SaturatingInductor</td>
          <td valign=\"top\">Simple model of an inductor with saturation</td></tr>
<tr><td valign=\"top\">VariableResistor</td>
          <td valign=\"top\">Ideal linear electrical resistor with variable resistance</td></tr>
<tr><td valign=\"top\">VariableConductor</td>
          <td valign=\"top\">Ideal linear electrical conductor with variable conductance</td></tr>
<tr><td valign=\"top\">VariableCapacitor</td>
          <td valign=\"top\">Ideal linear electrical capacitor with variable capacitance</td></tr>
<tr><td valign=\"top\">VariableInductor</td>
          <td valign=\"top\">Ideal linear electrical inductor with variable inductance</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors.</b></td></tr>
<tr><td valign=\"top\">HeatingDiode</td>
          <td valign=\"top\">Simple diode with heating port</td></tr>
<tr><td valign=\"top\">HeatingNMOS</td>
          <td valign=\"top\">Simple MOS Transistor with heating port</td></tr>
<tr><td valign=\"top\">HeatingPMOS</td>
          <td valign=\"top\">Simple PMOS Transistor with heating port</td></tr>
<tr><td valign=\"top\">HeatingNPN</td>
          <td valign=\"top\">Simple NPN BJT according to Ebers-Moll with heating port</td></tr>
<tr><td valign=\"top\">HeatingPNP</td>
          <td valign=\"top\">Simple PNP BJT according to Ebers-Moll with heating port</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase</b><br>
          A new library for multi-phase electrical circuits</td></tr>
</table>
<p>
<b>New examples</b>
</p>
<p>
The following new examples have been added to
Modelica.Electrical.Analog.Examples:
</p>
<p>
CharacteristicThyristors,
CharacteristicIdealDiodes,
HeatingNPN_OrGate,
HeatingMOSInverter,
HeatingRectifier,
Rectifier,
ShowSaturatingInductor
ShowVariableResistor
</p>
<p>
<b>Improved existing components</b>
</p>
<p>In the library Modelica.Electrical.Analog.Ideal,
a knee voltage has been introduced for the components
IdealThyristor, IdealGTOThyristor, IdealDiode in order
that the approximation of these ideal elements is improved
with not much computational effort.</p>
<p> In the Modelica.SIunits library, the following changes
        have been made:</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td valign=\"top\">Inductance</td>
          <td valign=\"top\">min=0 removed</td></tr>
<tr><td valign=\"top\">SelfInductance</td>
          <td valign=\"top\">min=0 added</td></tr>
<tr><td valign=\"top\">ThermodynamicTemperature</td>
          <td valign=\"top\">min=0 added</td></tr>
</table>
</html>"));
      end Version_1_6;

      class Version_1_5 "Version 1.5 (Dec. 16, 2002)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<p> Added 55 new components. In particular, added new package
        <b>Thermal.HeatTransfer</b> for modeling of lumped
        heat transfer, added model <b>LossyGear</b> in Mechanics.Rotational
        to model gear efficiency and bearing friction according to a new
        theory in a robust way, added 10 new models in Electrical.Analog and
        added several other new models and improved existing models.
</p>
<p>
<b>New components</b>
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
<tr><td colspan=\"2\"><b>Modelica.Blocks.</b></td></tr>
<tr><td valign=\"top\">Continuous.Der</td><td valign=\"top\">Derivative of input (= analytic differentiations)</td></tr>
<tr><td valign=\"top\"><b><i>Examples</i></b></td><td valign=\"top\">Demonstration examples of the components of this package</td></tr>
<tr><td valign=\"top\">Nonlinear.VariableLimiter</td><td valign=\"top\">Limit the range of a signal with variable limits</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces.</b></td></tr>
<tr><td valign=\"top\">RealPort</td><td valign=\"top\">Real port (both input/output possible)</td></tr>
<tr><td valign=\"top\">IntegerPort</td><td valign=\"top\">Integer port (both input/output possible)</td></tr>
<tr><td valign=\"top\">BooleanPort</td><td valign=\"top\">Boolean port (both input/output possible)</td></tr>
<tr><td valign=\"top\">SIMO</td><td valign=\"top\">Single Input Multiple Output continuous control block</td></tr>
<tr><td valign=\"top\">IntegerBlockIcon</td><td valign=\"top\">Basic graphical layout of Integer block</td></tr>
<tr><td valign=\"top\">IntegerMO</td><td valign=\"top\">Multiple Integer Output continuous control block</td></tr>
<tr><td valign=\"top\">IntegerSignalSource</td><td valign=\"top\">Base class for continuous Integer signal source</td></tr>
<tr><td valign=\"top\">IntegerMIBooleanMOs</td><td valign=\"top\">Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
<tr><td valign=\"top\">BooleanMIMOs</td><td valign=\"top\">Multiple Input Multiple Output continuous control block with same number of inputs and outputs of Boolean type</td></tr>
<tr><td valign=\"top\"><b><i>BusAdaptors</i></b></td><td valign=\"top\">Components to send signals to the bus or receive signals from the bus</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
<tr><td valign=\"top\">RealToInteger</td><td valign=\"top\">Convert real to integer signals</td></tr>
<tr><td valign=\"top\">IntegerToReal</td><td valign=\"top\">Convert integer to real signals</td></tr>
<tr><td valign=\"top\">Max</td><td valign=\"top\">Pass through the largest signal</td></tr>
<tr><td valign=\"top\">Min</td><td valign=\"top\">Pass through the smallest signal</td></tr>
<tr><td valign=\"top\">Edge</td><td valign=\"top\">Indicates rising edge of Boolean signal</td></tr>
<tr><td valign=\"top\">BooleanChange</td><td valign=\"top\">Indicates Boolean signal changing</td></tr>
<tr><td valign=\"top\">IntegerChange</td><td valign=\"top\">Indicates integer signal changing</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
<tr><td valign=\"top\">IntegerConstant</td><td valign=\"top\">Generate constant signals of type Integer</td></tr>
<tr><td valign=\"top\">IntegerStep</td><td valign=\"top\">Generate step signals of type Integer</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
<tr><td valign=\"top\">HeatingResistor</td><td valign=\"top\">Temperature dependent electrical resistor</td></tr>
<tr><td valign=\"top\">OpAmp</td><td valign=\"top\">Simple nonideal model of an OpAmp with limitation</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal.</b></td></tr>
<tr><td valign=\"top\">IdealCommutingSwitch</td><td valign=\"top\">Ideal commuting switch</td></tr>
<tr><td valign=\"top\">IdealIntermediateSwitch</td><td valign=\"top\">Ideal intermediate switch</td></tr>
<tr><td valign=\"top\">ControlledIdealCommutingSwitch</td><td valign=\"top\">Controlled ideal commuting switch</td></tr>
<tr><td valign=\"top\">ControlledIdealIntermediateSwitch</td><td valign=\"top\">Controlled ideal intermediate switch</td></tr>
<tr><td valign=\"top\">IdealOpAmpLimited</td><td valign=\"top\">Ideal operational amplifier with limitation</td></tr>
<tr><td valign=\"top\">IdealOpeningSwitch</td><td valign=\"top\">Ideal opener</td></tr>
<tr><td valign=\"top\">IdealClosingSwitch</td><td valign=\"top\">Ideal closer</td></tr>
<tr><td valign=\"top\">ControlledIdealOpeningSwitch</td><td valign=\"top\">Controlled ideal opener</td></tr>
<tr><td valign=\"top\">ControlledIdealClosingSwitch</td><td valign=\"top\">Controlled ideal closer</td></tr>

<tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Lines.</b></td></tr>
<tr><td valign=\"top\">TLine1</td><td valign=\"top\">Lossless transmission line (Z0, TD)</td></tr>
<tr><td valign=\"top\">TLine2</td><td valign=\"top\">Lossless transmission line (Z0, F, NL)</td></tr>
<tr><td valign=\"top\">TLine2</td><td valign=\"top\">Lossless transmission line (Z0, F)</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
<tr><td valign=\"top\">Function</td><td valign=\"top\">Icon for a function</td></tr>
<tr><td valign=\"top\">Record</td><td valign=\"top\">Icon for a record</td></tr>
<tr><td valign=\"top\">Enumeration</td><td valign=\"top\">Icon for an enumeration</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Math.</b></td></tr>
<tr><td valign=\"top\">tempInterpol2</td><td valign=\"top\">temporary routine for vectorized linear interpolation (will be removed)</td></tr>
<tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
<tr><td valign=\"top\">Examples.LossyGearDemo1</td><td valign=\"top\">Example to show that gear efficiency may lead to stuck motion</td></tr>
<tr><td valign=\"top\">Examples.LossyGearDemo2</td><td valign=\"top\">Example to show combination of LossyGear and BearingFriction</td></tr>
<tr><td valign=\"top\">LossyGear</td><td valign=\"top\">Gear with mesh efficiency and bearing friction (stuck/rolling possible)</td></tr>
<tr><td valign=\"top\">Gear2</td><td valign=\"top\">Realistic model of a gearbox (based on LossyGear)</td></tr>
<tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
<tr><td valign=\"top\"><b><i>Conversions</i></b></td><td valign=\"top\">Conversion functions to/from non SI units and type definitions of non SI units</td></tr>
<tr><td valign=\"top\">EnergyFlowRate</td><td valign=\"top\">Same definition as <i>Power</i></td></tr>
<tr><td valign=\"top\">EnthalpyFlowRate</td><td valign=\"top\"><code>Real (final quantity=\"EnthalpyFlowRate\", final unit=\"W\")</code></td></tr>
<tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
<tr><td valign=\"top\"><b><i>Thermal.HeatTransfer</i></b></td><td valign=\"top\">1-dimensional heat transfer with lumped elements</td></tr>
<tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Discrete.</b></td></tr>
<tr><td valign=\"top\">TriggeredSampler</td><td valign=\"top\">Triggered sampling of continuous signals</td></tr>
<tr><td valign=\"top\">TriggeredMax</td><td valign=\"top\">Compute maximum, absolute value of continuous signal at trigger instants</td></tr>
<tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.Interfaces.</b></td></tr>
<tr><td valign=\"top\">BooleanMIRealMOs</td><td valign=\"top\">Multiple Boolean Input Multiple Real Output continuous control block with same number of inputs and outputs</td></tr>
<tr><td valign=\"top\">RealMIBooleanMOs</td><td valign=\"top\">Multiple Real Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
<tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.</b></td></tr>
<tr><td valign=\"top\">TriggeredTrapezoid</td><td valign=\"top\">Triggered trapezoid generator</td></tr>
<tr><td valign=\"top\">Hysteresis</td><td valign=\"top\">Transform Real to Boolean with Hysteresis</td></tr>
<tr><td valign=\"top\">OnOffController</td><td valign=\"top\">On-off controller</td></tr>
<tr><td valign=\"top\">Compare</td><td valign=\"top\">True, if signal of inPort1 is larger than signal of inPort2</td></tr>
<tr><td valign=\"top\">ZeroCrossing</td><td valign=\"top\">Trigger zero crossing of input signal</td></tr>
<tr><td colspan=\"2\"><b>ModelicaAdditions.</b></td></tr>
<tr><td valign=\"top\">Blocks.Multiplexer.Extractor</td><td valign=\"top\">Extract scalar signal out of signal vector dependent on IntegerRealInput index</td></tr>
<tr><td valign=\"top\">Tables.CombiTable1Ds</td><td valign=\"top\">Table look-up in one dimension (matrix/file) with only single input</td></tr>
</table>
<p>
<b>Package-specific Changes</b>
</p>
<ul>
<li>All example models made <b>encapsulated</b></li>
<li>Upper case constants changed to lower case (cf. Modelica.Constants)</li>
<li>Introduced Modelica.SIunits.Wavelength due to typo \"Wavelenght\"</li>
<li>Introduced ModelicaAdditions.Blocks.Logical.Interfaces.Comparison due to typo \"Comparision\"</li>
<li>Changed these components of *.Blocks to <code>block</code> class, which have not been already of block type</li>
<li>Changed *.Interfaces.RelativeSensor to <code>partial</code> models</li>
</ul>
<p>
<b>Class-specific Changes</b>
</p>
<p>
<i>Modelica.SIunits</i>
</p>
<p>Removed <code>final</code> from quantity attribute for <i>Mass</i> and <i>MassFlowRate</i>.</p>
<p>
<i>Modelica.Blocks.Math.Sum</i>
</p>
<p>Implemented avoiding algorithm section, which would lead to expensive function calls.</p>
<p><i>Modelica.Blocks.Sources.Step</i></p>
<pre>
block Step \"Generate step signals of type Real\"
        parameter Real height[:]={1} \"Heights of steps\";
<b> // parameter Real offset[:]={0} \"Offsets of output signals\";
// parameter SIunits.Time startTime[:]={0} \"Output = offset for time < startTime\";
// extends Interfaces.MO          (final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));
        extends Interfaces.SignalSource(final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));</b>
</pre>
<p><i>Modelica.Blocks.Sources.Exponentials</i></p>
<p>Replaced usage of built-in function <code>exp</code> by Modelica.Math.exp.</p>
<p><i>Modelica.Blocks.Sources.TimeTable</i></p>
<p>Interface definition changed from</p>
<pre>    parameter Real table[:, :]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
</pre>
<p>to</p>
<pre>    parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
</pre>
<p>Did the same for subfunction <i>getInterpolationCoefficients</i>.</p>
<p>Bug in <i>getInterpolationCoefficients</i> for startTime <> 0 fixed:</p>
<pre>        ...
                end if;
          end if;
          <b>// Take into account startTime \"a*(time - startTime) + b\"
          b := b - a*startTime;</b>
        end getInterpolationCoefficients;
</pre>
<p><i>Modelica.Blocks.Sources.BooleanStep</i></p>
<pre>
block BooleanStep \"Generate step signals of type Boolean\"
        parameter SIunits.Time startTime[:]={0} \"Time instants of steps\";
        <b>parameter Boolean startValue[size(startTime, 1)]=fill(false, size(startTime, 1)) \"Output before startTime\";</b>
        extends Interfaces.BooleanSignalSource(final nout=size(startTime, 1));
equation
        for i in 1:nout loop
<b>//   outPort.signal[i] = time >= startTime[i];
          outPort.signal[i] = if time >= startTime[i] then not startValue[i] else startValue[i];</b>
        end for;
end BooleanStep;
</pre>
<p>
<i>Modelica.Electrical.Analog</i></p>
<p>Corrected table of values and default for Beta by dividing them by 1000
(consistent with the values used in the NAND-example model):
</p>
<ul>
<li>Semiconductors.PMOS</li>
<li>Semiconductors.NMOS</li>
</ul>
<p>Corrected parameter defaults, unit and description for TrapezoidCurrent.
This makes the parameters consistent with their use in the model.
Models specifying parameter values are not changed.
Models not specifying parameter values did not generate trapezoids previously.
</p>
<p>Icon layer background changed from transparent to white:</p>
<ul>
<li>Basic.Gyrator</li>
<li>Basic.EMF</li>
<li>Ideal.Idle</li>
<li>Ideal.Short</li>
</ul>
<p>Basic.Transformer: Replaced invalid escape characters '\\ ' and '\\[newline]' in documentation by '|'.</p>
<p><i>Modelica.Mechanics.Rotational</i></p>
<p>Removed arrows and names documentation from flanges in diagram layer</p>
<p><i>Modelica.Mechanics.Rotational.Interfaces.FrictionBase</i></p>
<p><i>Modelica.Mechanics.Rotational.Position</i></p>
<p>Replaced <code>reinit</code> by <code>initial equation</code></p>
<p><i>Modelica.Mechanics.Rotational.RelativeStates</i></p>
<p>Bug corrected by using modifier <code>stateSelect = StateSelect.prefer</code> as implementation</p>
<p><i>Modelica.Mechanics.Translational.Interfaces.flange_b</i></p>
<p>Attribute <b>fillColor=7</b> added to Rectangle on Icon layer, i.e., it is now
filled with white and not transparent any more.</p>
<p><i>Modelica.Mechanics.Translational.Position</i></p>
<p>Replaced <code>reinit</code> by <code>initial equation</code></p>
<p><i>Modelica.Mechanics.Translational.RelativeStates</i></p>
<p>Bug corrected by using modifier <code>stateSelect = StateSelect.prefer</code> as implementation</p>
<p><i>Modelica.Mechanics.Translational.Stop</i></p>
<p>Use <code>stateSelect = StateSelect.prefer</code>.</p>
<p><i>Modelica.Mechanics.Translational.Examples.PreLoad</i></p>
<p>Improved documentation and coordinate system used for example.</p>
<p><i>ModelicaAdditions.Blocks.Nonlinear.PadeDelay</i></p>
<p>Replaced <code>reinit</code> by <code>initial equation</code></p>
<p><i>ModelicaAdditions.HeatFlow1D.Interfaces</i></p>
<p>Definition of connectors <i>Surface_a</i> and <i>Surface_b</i>:<br>
<code>flow SIunits.HeatFlux q;</code> changed to <code>flow SIunits.HeatFlowRate q;</code></p>
<p><i>MultiBody.Parts.InertialSystem</i></p>
<p>Icon corrected.</p>
</html>"));
      end Version_1_5;

      class Version_1_4 "Version 1.4 (June 28, 2001)"
        extends Modelica.Icons.ReleaseNotes;
        annotation(
          Documentation(info = "<html>

<ul>
<li>Several minor bugs fixed. </li>
<li>New models:<br>
        Modelica.Blocks.Interfaces.IntegerRealInput/IntegerRealOutput,<br>
        Modelica.Blocks.Math.TwoInputs/TwoOutputs<br>
        Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin,<br>
        Modelica.Mechanics.Rotational.Move,<br>
        Modelica.Mechanics.Translational.Move.<br>
        </li>
</ul>
<hr>
<h4>Version 1.4.1beta1 (February 12, 2001)</h4>
<p> Adapted to Modelica 1.4</p>
<hr>
<h4>Version 1.3.2beta2 (June 20, 2000)</h4>
<ul>
        <li>New subpackage Modelica.Mechanics.<b>Translational</b></li>
        <li>Changes to Modelica.Mechanics.<b>Rotational</b>:<br>
           New elements:
<pre>
IdealGearR2T    Ideal gear transforming rotational in translational motion.
Position        Forced movement of a flange with a reference angle
                                   given as input signal
RelativeStates  Definition of relative state variables
</pre>
</li>
        <li>Changes to Modelica.<b>SIunits</b>:<br>
          Introduced new types:<br>
          type Temperature = ThermodynamicTemperature;<br>
          types DerDensityByEnthalpy, DerDensityByPressure,
          DerDensityByTemperature, DerEnthalpyByPressure,
          DerEnergyByDensity, DerEnergyByPressure<br>
          Attribute \"final\" removed from min and max values
          in order that these values can still be changed to narrow
          the allowed range of values.<br>
          Quantity=\"Stress\" removed from type \"Stress\", in order
          that a type \"Stress\" can be connected to a type \"Pressure\".</li>
        <li>Changes to Modelica.<b>Icons</b>:<br>
           New icons for motors and gearboxes.</li>
        <li>Changes to Modelica.<b>Blocks.Interfaces</b>:<br>
           Introduced a replaceable signal type into
           Blocks.Interfaces.RealInput/RealOutput:
<pre>
replaceable type SignalType = Real
</pre>
           in order that the type of the signal of an input/output block
           can be changed to a physical type, for example:
<pre>
Sine sin1(outPort(redeclare type SignalType=Modelica.SIunits.Torque))
</pre>
</li>
</ul>
<hr>
<h4>Version 1.3.1 (Dec. 13, 1999)</h4>
<p>
First official release of the library.
</p>
</html>"));
      end Version_1_4;
      annotation(
        Documentation(info = "<html>

<p>
This section summarizes the changes that have been performed
on the Modelica standard library. Furthermore, it is explained in
<a href=\"modelica://Modelica.UsersGuide.ReleaseNotes.VersionManagement\">Modelica.UsersGuide.ReleaseNotes.VersionManagement</a>
how the versions are managed with the subversion management systems.
This is especially important for maintenance (bug-fix) releases where the
main version number is not changed.
</p>

</html>"));
    end ReleaseNotes;

    class Contact "Contact"
      extends Modelica.Icons.Contact;
      annotation(
        Documentation(info = "<html>
<dl><dt>The Modelica Standard Library (this Modelica package) is developed by many people from different organizations (see list below). It is licensed under the <a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica License 2</a> by:</dt>
<dt>&nbsp;</dt>
<dd>Modelica Association</dd>
<dd>(Ideella F&ouml;reningar 822003-8858 in Link&ouml;ping)</dd>
<dd>c/o PELAB, IDA, Link&ouml;pings Universitet</dd>
<dd>S-58183 Link&ouml;ping</dd>
<dd>Sweden</dd>
<dd>email: <a href=\"mailto:Board@Modelica.org\">Board@Modelica.org</a></dd>
<dd>web: <a href=\"https://www.Modelica.org\">https://www.Modelica.org</a></dd>
<dd>&nbsp;&nbsp;</dd>

<dt>The development of this Modelica package, starting with version 3.2.1, is organized by:</dt>
<dd><a href=\"http://www.haumer.at/eindex.htm\">Anton Haumer</a></dd>
<dd>Technical Consulting &amp; Electrical Engineering</dd>
<dd>A-3423 St.Andrae-Woerdern, Hadersfelderweg 21</dd>
<dd>Austria</dd>
<dd>email: <a href=\"mailto:A.Haumer@Haumer.at\">A.Haumer@Haumer.at</a></dd>
<dd>&nbsp;&nbsp;</dd>

<dt>The development of this Modelica package up to and including version 3.2.1 was organized by:</dt>
<dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a></dd>
<dd>German Aerospace Center (DLR)</dd>
<dd>Robotics and Mechatronics Center (RMC)</dd>
<dd>Institute of System Dynamics and Control (SR)</dd>
<dd>Postfach 1116</dd>
<dd>D-82230 Wessling</dd>
<dd>Germany</dd>
<dd>email: <a href=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</a></dd>
</dl>
<p>Since end of 2007, the development of the sublibraries of package Modelica is organized by personal and/or organizational <b>library officers</b> assigned by the Modelica Association. They are responsible for the maintenance and for the further organization of the development. Other persons may also contribute, but the final decision for library improvements and/or changes is performed by the responsible library officer(s). In order that a new sublibrary or a new version of a sublibrary is ready to be released, the responsible library officers report the changes to the members of the Modelica Association and the library is made available for beta testing to interested parties before a final decision. A new release of a sublibrary is formally decided by voting of the Modelica Association members.</p>
<p>The following library officers are currently assigned:</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><b>Sublibraries</b> </td>
   <td valign=\"top\"><b>Library officers</b></td>
</tr>

<tr><td valign=\"top\"> Complex </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
        (Martin Otter)<br>
        Anton Haumer, Consultant, St.Andrae-Woerdern, Austria, <br>
        Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria
</td>

</tr>

<tr><td valign=\"top\"> Modelica.Blocks <br>
                      Modelica.Constants </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
        (Martin Otter)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Electrical.Analog<br>
                      Modelica.Electrical.Digital<br>
                      Modelica.Electrical.Spice3 </td>
   <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits, Dresden, Germany<br>
      (Christoph Clauss)</td>
</tr>

<tr><td valign=\"top\"> Modelica.ComplexBlocks<br>
                      Modelica.Electrical.Machines<br>
                      Modelica.Electrical.MultiPhase<br>
                      Modelica.Electrical.QuasiStationary </td>
   <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria, and<br>
      Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria</td>
</tr>

<tr><td valign=\"top\"> Modelica.Magnetic.FluxTubes </td>
   <td valign=\"top\"> Thomas B&ouml;drich, Dresden, Germany<br>
                               (Dresden University of Technology,<br>
                               Institute of Electromechanical and Electronic Design)
</td>
</tr>

<tr><td valign=\"top\"> Modelica.Magnetic.FundamentalWave </td>
   <td valign=\"top\"> Electric Machines, Drives and Systems, Vienna, Austria<br>
                     Anton Haumer, Consultant, St.Andrae-Woerdern, Austria
</td>
</tr>

<tr><td valign=\"top\"> Modelica.Fluid </td>
   <td valign=\"top\"> Politecnico di Milano (Francesco Casella), and<br>
                            R&uuml;diger Franke (ABB)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Fluid.Dissipation </td>
   <td valign=\"top\"> XRG Simulation, Hamburg, Germany (Stefan Wischhusen)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Icons </td>
   <td valign=\"top\"> Modelon AB, Lund, Sweden (Johan Andreasson) </td>
</tr>

<tr><td valign=\"top\"> Modelica.Math </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)</td>
</tr>

<tr><td valign=\"top\"> Modelica.ComplexMath </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)<br>
      Anton Haumer, Consultant, St.Andrae-Woerdern, Austria,<br>
      Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria
   </td>
</tr>

<tr><td valign=\"top\"> Modelica.Mechanics.MultiBody </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter),<br>
       Modelon AB, Lund, Sweden (Johan Andreasson) </td>
</tr>

<tr><td valign=\"top\"> Modelica.Mechanics.Rotational </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)<br>
      Anton Haumer, Consultant, St.Andrae-Woerdern, Austria,<br>
      Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria,<br>
      Modelon AB, Lund, Sweden (Johan Andreasson)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Mechanics.Translational </td>
   <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria,<br>
      Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria, <br>
      DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)<br>
       Modelon AB, Lund, Sweden (Johan Andreasson)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Media </td>
   <td valign=\"top\"> Modelon AB, Lund, Sweden (Hubertus Tummescheit) </td>
</tr>

<tr><td valign=\"top\"> Modelica.SIunits <br>
      Modelica.StateGraph </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)</td>
</tr>

<tr><td valign=\"top\"> Modelica.Thermal.FluidHeatFlow <br>
      Modelica.Thermal.HeatTransfer </td>
   <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria, and<br>
      Christian Kral, Electric Machines, Drives and Systems, Vienna, Austria</td>

<tr><td valign=\"top\"> Modelica.Utilities </td>
   <td valign=\"top\"> DLR Institute of System Dynamics and Control, Oberpfaffenhofen, Germany<br>
      (Martin Otter)<br>
      Dassault Syst&egrave;mes AB, Lund, Sweden (Hans Olsson)</td>
</tr>
</table>

<p>
The following people have directly contributed to the implementation
of the Modelica package (many more people have contributed to the design):
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><b>Marcus Baur</b> </td>
   <td valign=\"top\"> Institute of System Dynamics and Control<br>
     DLR, German Aerospace Center, <br>
     Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Complex<br>
                     Modelica.Math.Vectors<br>
                     Modelica.Math.Matrices</td>
</tr>

<tr><td valign=\"top\"><b>Peter Beater</b> </td>
   <td valign=\"top\"> University of Paderborn, Germany</td>
   <td valign=\"top\"> Modelica.Mechanics.Translational </td>
</tr>



<tr><td valign=\"top\"><b>Thomas Beutlich</b> </td>
   <td valign=\"top\"> ITI GmbH, Germany</td>
   <td valign=\"top\"> Modelica.Blocks.Sources.CombiTimeTable<br>
                       Modelica.Blocks.Tables </td>
</tr>

<tr><td valign=\"top\"><b>Thomas B&ouml;drich</b> </td>
   <td valign=\"top\"> Dresden University of Technology, Germany</td>
   <td valign=\"top\"> Modelica.Magnetic.FluxTubes </td>

<tr><td valign=\"top\"><b>Dag Br&uuml;ck</b> </td>
   <td valign=\"top\"> Dassault Syst&egrave;mes AB, Lund, Sweden</td>
   <td valign=\"top\"> Modelica.Utilities</td>
</tr>

<tr><td valign=\"top\"><b>Francesco Casella</b> </td>
   <td valign=\"top\"> Politecnico di Milano, Milano, Italy</td>
   <td valign=\"top\"> Modelica.Fluid<br>
                            Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Christoph Clauss</b> </td>
   <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
   <td valign=\"top\"> Modelica.Electrical.Analog<br>
     Modelica.Electrical.Digital<br>
     Modelica.Electrical.Spice3</td>
</tr>

<tr><td valign=\"top\"><b>Jonas Eborn</b> </td>
   <td valign=\"top\"> Modelon AB, Lund, Sweden</td>
   <td valign=\"top\"> Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Hilding Elmqvist</b> </td>
   <td valign=\"top\"> Dassault Syst&egrave;mes AB, Lund, Sweden</td>
   <td valign=\"top\"> Modelica.Mechanics.MultiBody<br>
                   Modelica.Fluid<br>
     Modelica.Media<br>
     Modelica.StateGraph<br>
     Modelica.Utilities<br>
     Conversion from 1.6 to 2.0</td>
</tr>

<tr><td valign=\"top\"><b>R&uuml;diger Franke</b> </td>
   <td valign=\"top\"> ABB Corporate Research,<br>Ladenburg, German</td>
   <td valign=\"top\"> Modelica.Fluid<br>
                            Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Manuel Gr&auml;ber</b> </td>
   <td valign=\"top\"> Institut f&uuml;r Thermodynamik, <br>
     Technische Universit&auml;t Braunschweig, <br>
     Germany</td>
   <td valign=\"top\"> Modelica.Fluid</td>
</tr>

<tr><td valign=\"top\"><b>Anton Haumer</b> </td>
   <td valign=\"top\"> Consultant, St.Andrae-Woerdern,<br>Austria</td>
   <td valign=\"top\"> Modelica.ComplexBlocks<br>
     Modelica.Electrical.Machines<br>
     Modelica.Electrical.Multiphase<br>
     Modelica.Electrical.QuasiStationary<br>
     Modelica.Magnetics.FundamentalWave<br>
     Modelica.Mechanics.Rotational<br>
     Modelica.Mechanics.Translational<br>
     Modelica.Thermal.FluidHeatFlow<br>
     Modelica.Thermal.HeatTransfer<br>
     Modelica.ComplexMath<br>
     Conversion from 1.6 to 2.0<br>
     Conversion from 2.2 to 3.0</td>
</tr>

<tr><td valign=\"top\"><b>Hans-Dieter Joos</b> </td>
   <td valign=\"top\"> Institute of System Dynamics and Control<br>
     DLR, German Aerospace Center, <br>
     Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Modelica.Math.Matrices</td>
</tr>

<tr><td valign=\"top\"><b>Christian Kral</b> </td>
   <td valign=\"top\"> Electric Machines, Drives and Systems, Vienna, Austria</td>
   <td valign=\"top\"> Modelica.ComplexBlocks<br>
     Modelica.Electrical.Machines<br>
     Modelica.Electrical.MultiPhase<br>
     Modelica.Electrical.QuasiStationary<br>
     Modelica.Magnetics.FundamentalWave<br>
     Modelica.Mechanics.Rotational<br>
     Modelica.Mechanics.Translational<br>
     Modelica.Thermal.FluidHeatFlow<br>
     Modelica.Thermal.HeatTransfer<br>
     Modelica.ComplexMath
     </td>
</tr>

<tr><td valign=\"top\"><b>Sven Erik Mattsson</b> </td>
   <td valign=\"top\"> Dassault Syst&egrave;mes AB, Lund, Sweden</td>
   <td valign=\"top\"> Modelica.Mechanics.MultiBody</td>
</tr>
<tr><td valign=\"top\"><b>Hans Olsson</b> </td>
   <td valign=\"top\"> Dassault Syst&egrave;mes AB, Lund, Sweden</td>
   <td valign=\"top\"> Modelica.Blocks<br>
     Modelica.Math.Matrices<br>
     Modelica.Utilities<br>
     Conversion from 1.6 to 2.0<br>
     Conversion from 2.2 to 3.0</td>
</tr>

<tr><td valign=\"top\"><b>Martin Otter</b> </td>
   <td valign=\"top\"> Institute of System Dynamics and Control<br>
     DLR, German Aerospace Center, <br>
     Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Complex<br>
     Modelica.Blocks<br>
     Modelica.Fluid<br>
     Modelica.Mechanics.MultiBody<br>
     Modelica.Mechanics.Rotational<br>
     Modelica.Mechanics.Translational<br>
     Modelica.Math<br>
     Modelica.ComplexMath<br>
     Modelica.Media<br>
     Modelica.SIunits<br>
     Modelica.StateGraph<br>
     Modelica.Thermal.HeatTransfer<br>
     Modelica.Utilities<br>
     ModelicaReference<br>
     Conversion from 1.6 to 2.0<br>
     Conversion from 2.2 to 3.0</td>
</tr>

<tr><td valign=\"top\"><b>Katrin Pr&ouml;l&szlig;</b> </td>
   <td valign=\"top\"> Modelon AB, Lund, Sweden<br>
                            until 2008:<br>
                            Department of Technical Thermodynamics,<br>
     Technical University Hamburg-Harburg,<br>Germany</td>
   <td valign=\"top\"> Modelica.Fluid<br>
                            Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Christoph C. Richter</b> </td>
   <td valign=\"top\"> until 2009:<br>
     Institut f&uuml;r Thermodynamik, <br>
     Technische Universit&auml;t Braunschweig, <br>
     Germany</td>
   <td valign=\"top\"> Modelica.Fluid<br>
                            Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Andr&eacute; Schneider</b> </td>
   <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
   <td valign=\"top\"> Modelica.Electrical.Analog<br>
     Modelica.Electrical.Digital</td>
</tr>
<tr><td valign=\"top\"><b>Christian Schweiger</b> </td>
   <td valign=\"top\"> Until 2006:<br>
     Institute of System Dynamics and Control,<br>
     DLR, German Aerospace Center,<br>
     Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Modelica.Mechanics.Rotational<br>
     ModelicaReference<br>
     Conversion from 1.6 to 2.0</td>
</tr>

<tr><td valign=\"top\"><b>Michael Sielemann</b> </td>
   <td valign=\"top\"> Institute of System Dynamics and Control<br>
     DLR, German Aerospace Center, <br>
     Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Modelica.Fluid<br>
                       Modelica.Media</td>
</tr>

<tr><td valign=\"top\"><b>Michael Tiller</b> </td>
   <td valign=\"top\"> Emmeskay, Inc., Dearborn, MI, U.S.A, <br>
     (previously Ford Motor Company, Dearborn) </td>
   <td valign=\"top\"> Modelica.Media<br>
     Modelica.Thermal.HeatTransfer</td>
</tr>
<tr><td valign=\"top\"><b>Hubertus Tummescheit</b> </td>
   <td valign=\"top\"> Modelon AB, Lund, Sweden </td>
   <td valign=\"top\"> Modelica.Media<br>
     Modelica.Thermal.HeatTransfer</td>
</tr>

<tr><td valign=\"top\"><b>Thorsten Vahlenkamp</b> </td>
   <td valign=\"top\"> until 2010:<br>
                     XRG Simulation GmbH, Hamburg, Germany</td>
   <td valign=\"top\"> Modelica.Fluid.Dissipation</td>
</tr>

<tr><td valign=\"top\"><b>Nico Walter</b> </td>
   <td valign=\"top\"> Master thesis at HTWK Leipzig<br>
     (Prof. R. M&uuml;ller) and<br>
     DLR Oberpfaffenhofen, Germany</td>
   <td valign=\"top\"> Modelica.Math.Matrices</td>
</tr>

<tr><td valign=\"top\"><b>Michael Wetter</b> </td>
   <td valign=\"top\"> Lawrence Berkeley National Laboratory; U.S.A.</td>
   <td valign=\"top\"> Modelica.Fluid</td>
</tr>

<tr><td valign=\"top\"><b>Hans-J&uuml;rg Wiesmann</b> </td>
   <td valign=\"top\"> Switzerland</td>
   <td valign=\"top\"> Modelica.ComplexMath</td>
</tr>

<tr><td valign=\"top\"><b>Stefan Wischhusen</b> </td>
   <td valign=\"top\"> XRG Simulation GmbH, Hamburg, Germany</td>
   <td valign=\"top\"> Modelica.Fluid.Dissipation<br>
                       Modelica.Media</td>
</tr>
</table>

</html>"));
    end Contact;
    annotation(
      DocumentationClass = true,
      Documentation(info = "<html>
<p>
Package <b>Modelica</b> is a <b>standardized</b> and <b>pre-defined</b> package
that is developed together with the Modelica language from the
Modelica Association, see
<a href=\"https://www.Modelica.org\">https://www.Modelica.org</a>.
It is also called <b>Modelica Standard Library</b>.
It provides constants, types, connectors, partial models and model
components in various disciplines.
</p>
<p>
This is a short <b>User's Guide</b> for
the overall library. Some of the main sublibraries have their own
User's Guides that can be accessed by the following links:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.Electrical.Digital.UsersGuide\">Digital</a>
   </td>
   <td valign=\"top\">Library for digital electrical components based on the VHDL standard
   (2-,3-,4-,9-valued logic)</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Magnetic.FluxTubes.UsersGuide\">FluxTubes</a>
    </td>
   <td valign=\"top\">Library for modelling of electromagnetic devices with lumped magnetic networks</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.MultiBody.UsersGuide\">MultiBody</a>
    </td>
   <td valign=\"top\">Library to model 3-dimensional mechanical systems</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Mechanics.Rotational.UsersGuide\">Rotational</a>
    </td>
   <td valign=\"top\">Library to model 1-dimensional mechanical systems</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Fluid.UsersGuide\">Fluid</a></td>
    <td valign=\"top\">Library of 1-dim. thermo-fluid flow models using the Modelica.Media media description</td>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Media.UsersGuide\">Media</a>
    </td>
   <td valign=\"top\">Library of media property models</td>
</tr>
<tr><td valign=\"top\"><a href=\"modelica://Modelica.SIunits.UsersGuide\">SIunits</a> </td>
   <td valign=\"top\">Library of type definitions based on SI units according to ISO 31-1992</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.StateGraph.UsersGuide\">StateGraph</a>
    </td>
   <td valign=\"top\">Library to model discrete event and reactive systems by hierarchical state machines</td>
</tr>

<tr><td valign=\"top\"><a href=\"modelica://Modelica.Utilities.UsersGuide\">Utilities</a>
    </td>
   <td valign=\"top\">Library of utility functions especially for scripting (Files, Streams, Strings, System)</td>
</tr>
</table>

</html>"));
  end UsersGuide;

  package Blocks "Library of basic input/output control blocks (continuous, discrete, logical, table blocks)"
    import SI = Modelica.SIunits;
    extends Modelica.Icons.Package;

    package Examples "Library of examples to demonstrate the usage of package Blocks"
      extends Modelica.Icons.ExamplesPackage;

      model PID_Controller "Demonstrates the usage of a Continuous.LimPID controller"
        extends Modelica.Icons.Example;
        parameter Modelica.SIunits.Angle driveAngle = 1.57 "Reference distance to move";
        Modelica.Blocks.Continuous.LimPID PI(k = 100, Ti = 0.1, yMax = 12, Ni = 0.1, initType = Modelica.Blocks.Types.InitPID.SteadyState, limitsAtInit = false, controllerType = Modelica.Blocks.Types.SimpleController.PI, Td = 0.1) annotation(
          Placement(transformation(extent = {{-56, -20}, {-36, 0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia1(phi(fixed = true, start = 0), J = 1, a(fixed = true, start = 0)) annotation(
          Placement(transformation(extent = {{2, -20}, {22, 0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque annotation(
          Placement(transformation(extent = {{-25, -20}, {-5, 0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.SpringDamper spring(c = 1e4, d = 100, stateSelect = StateSelect.prefer, w_rel(fixed = true)) annotation(
          Placement(transformation(extent = {{32, -20}, {52, 0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia2(J = 2) annotation(
          Placement(transformation(extent = {{60, -20}, {80, 0}}, rotation = 0)));
        Modelica.Blocks.Sources.KinematicPTP kinematicPTP(startTime = 0.5, deltaq = {driveAngle}, qd_max = {1}, qdd_max = {1}) annotation(
          Placement(transformation(extent = {{-92, 20}, {-72, 40}}, rotation = 0)));
        Modelica.Blocks.Continuous.Integrator integrator(initType = Modelica.Blocks.Types.Init.InitialState) annotation(
          Placement(transformation(extent = {{-63, 20}, {-43, 40}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor annotation(
          Placement(transformation(extent = {{22, -50}, {2, -30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.ConstantTorque loadTorque(tau_constant = 10, useSupport = false) annotation(
          Placement(transformation(extent = {{98, -15}, {88, -5}}, rotation = 0)));
      initial equation
        der(spring.w_rel) = 0;
      equation
        connect(spring.flange_b, inertia2.flange_a) annotation(
          Line(points = {{52, -10}, {60, -10}}, color = {0, 0, 0}));
        connect(inertia1.flange_b, spring.flange_a) annotation(
          Line(points = {{22, -10}, {32, -10}}, color = {0, 0, 0}));
        connect(torque.flange, inertia1.flange_a) annotation(
          Line(points = {{-5, -10}, {2, -10}}, color = {0, 0, 0}));
        connect(kinematicPTP.y[1], integrator.u) annotation(
          Line(points = {{-71, 30}, {-65, 30}}, color = {0, 0, 127}));
        connect(speedSensor.flange, inertia1.flange_b) annotation(
          Line(points = {{22, -40}, {22, -10}}, color = {0, 0, 0}));
        connect(loadTorque.flange, inertia2.flange_b) annotation(
          Line(points = {{88, -10}, {80, -10}}, color = {0, 0, 0}));
        connect(PI.y, torque.tau) annotation(
          Line(points = {{-35, -10}, {-27, -10}}, color = {0, 0, 127}));
        connect(speedSensor.w, PI.u_m) annotation(
          Line(points = {{1, -40}, {-46, -40}, {-46, -22}}, color = {0, 0, 127}));
        connect(integrator.y, PI.u_s) annotation(
          Line(points = {{-42, 30}, {-37, 30}, {-37, 11}, {-67, 11}, {-67, -10}, {-58, -10}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-99, 48}, {-32, 8}}, lineColor = {255, 0, 0}), Text(extent = {{-98, 59}, {-31, 51}}, lineColor = {255, 0, 0}, textString = "reference speed generation"), Text(extent = {{-98, -46}, {-60, -52}}, lineColor = {255, 0, 0}, textString = "PI controller"), Line(points = {{-76, -44}, {-57, -23}}, color = {255, 0, 0}, arrow = {Arrow.None, Arrow.Filled}), Rectangle(extent = {{-25, 6}, {99, -50}}, lineColor = {255, 0, 0}), Text(extent = {{4, 14}, {71, 7}}, lineColor = {255, 0, 0}, textString = "plant (simple drive train)")}),
          experiment(StopTime = 4),
          Documentation(info = "<html>

<p>
This is a simple drive train controlled by a PID controller:
</p>

<ul>
<li> The two blocks \"kinematic_PTP\" and \"integrator\" are used to generate
     the reference speed (= constant acceleration phase, constant speed phase,
     constant deceleration phase until inertia is at rest). To check
     whether the system starts in steady state, the reference speed is
     zero until time = 0.5 s and then follows the sketched trajectory.</li>

<li> The block \"PI\" is an instance of \"Blocks.Continuous.LimPID\" which is
     a PID controller where several practical important aspects, such as
     anti-windup-compensation has been added. In this case, the control block
     is used as PI controller.</li>

<li> The output of the controller is a torque that drives a motor inertia
     \"inertia1\". Via a compliant spring/damper component, the load
     inertia \"inertia2\" is attached. A constant external torque of 10 Nm
     is acting on the load inertia.</li>
</ul>

<p>
The PI controller settings included \"limitAtInit=false\", in order that
the controller output limits of 12 Nm are removed from the initialization
problem.
</p>

<p>
The PI controller is initialized in steady state (initType=SteadyState)
and the drive shall also be initialized in steady state.
However, it is not possible to initialize \"inertia1\" in SteadyState, because
\"der(inertia1.phi)=inertia1.w=0\" is an input to the PI controller that
defines that the derivative of the integrator state is zero (= the same
condition that was already defined by option SteadyState of the PI controller).
Furthermore, one initial condition is missing, because the absolute position
of inertia1 or inertia2 is not defined. The solution shown in this examples is
to initialize the angle and the angular acceleration of \"inertia1\".
</p>

<p>
In the following figure, results of a typical simulation are shown:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/PID_controller.png\"
     alt=\"PID_controller.png\"><br>

<img src=\"modelica://Modelica/Resources/Images/Blocks/PID_controller2.png\"
     alt=\"PID_controller2.png\">

<p>
In the upper figure the reference speed (= integrator.y) and
the actual speed (= inertia1.w) are shown. As can be seen,
the system initializes in steady state, since no transients
are present. The inertia follows the reference speed quite good
until the end of the constant speed phase. Then there is a deviation.
In the lower figure the reason can be seen: The output of the
controller (PI.y) is in its limits. The anti-windup compensation
works reasonably, since the input to the limiter (PI.limiter.u)
is forced back to its limit after a transient phase.
</p>

</html>"));
      end PID_Controller;

      model Filter "Demonstrates the Continuous.Filter block with various options"
        extends Modelica.Icons.Example;
        parameter Integer order = 3;
        parameter Modelica.SIunits.Frequency f_cut = 2;
        parameter Modelica.Blocks.Types.FilterType filterType = Modelica.Blocks.Types.FilterType.LowPass "Type of filter (LowPass/HighPass)";
        parameter Modelica.Blocks.Types.Init init = Modelica.Blocks.Types.Init.SteadyState "Type of initialization (no init/steady state/initial state/initial output)";
        parameter Boolean normalized = true;
        Modelica.Blocks.Sources.Step step(startTime = 0.1, offset = 0.1) annotation(
          Placement(transformation(extent = {{-60, 40}, {-40, 60}})));
        Modelica.Blocks.Continuous.Filter CriticalDamping(analogFilter = Modelica.Blocks.Types.AnalogFilter.CriticalDamping, normalized = normalized, init = init, filterType = filterType, order = order, f_cut = f_cut, f_min = 0.8 * f_cut) annotation(
          Placement(transformation(extent = {{-20, 40}, {0, 60}})));
        Modelica.Blocks.Continuous.Filter Bessel(normalized = normalized, analogFilter = Modelica.Blocks.Types.AnalogFilter.Bessel, init = init, filterType = filterType, order = order, f_cut = f_cut, f_min = 0.8 * f_cut) annotation(
          Placement(transformation(extent = {{-20, 0}, {0, 20}})));
        Modelica.Blocks.Continuous.Filter Butterworth(normalized = normalized, analogFilter = Modelica.Blocks.Types.AnalogFilter.Butterworth, init = init, filterType = filterType, order = order, f_cut = f_cut, f_min = 0.8 * f_cut) annotation(
          Placement(transformation(extent = {{-20, -40}, {0, -20}})));
        Modelica.Blocks.Continuous.Filter ChebyshevI(normalized = normalized, analogFilter = Modelica.Blocks.Types.AnalogFilter.ChebyshevI, init = init, filterType = filterType, order = order, f_cut = f_cut, f_min = 0.8 * f_cut) annotation(
          Placement(transformation(extent = {{-20, -80}, {0, -60}})));
      equation
        connect(step.y, CriticalDamping.u) annotation(
          Line(points = {{-39, 50}, {-22, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(step.y, Bessel.u) annotation(
          Line(points = {{-39, 50}, {-32, 50}, {-32, 10}, {-22, 10}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(Butterworth.u, step.y) annotation(
          Line(points = {{-22, -30}, {-32, -30}, {-32, 50}, {-39, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(ChebyshevI.u, step.y) annotation(
          Line(points = {{-22, -70}, {-32, -70}, {-32, 50}, {-39, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 0.9),
          Documentation(info = "<html>

<p>
This example demonstrates various options of the
<a href=\"modelica://Modelica.Blocks.Continuous.Filter\">Filter</a> block.
A step input starts at 0.1 s with an offset of 0.1, in order to demonstrate
the initialization options. This step input drives 4 filter blocks that
have identical parameters, with the only exception of the used analog filter type
(CriticalDamping, Bessel, Butterworth, Chebyshev of type I). All the main options
can be set via parameters and are then applied to all the 4 filters.
The default setting uses low pass filters of order 3 with a cut-off frequency of
2 Hz resulting in the following outputs:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/Filter1.png\"
     alt=\"Filter1.png\">
</html>"));
      end Filter;

      model FilterWithDifferentiation "Demonstrates the use of low pass filters to determine derivatives of filters"
        extends Modelica.Icons.Example;
        parameter Modelica.SIunits.Frequency f_cut = 2;
        Modelica.Blocks.Sources.Step step(startTime = 0.1, offset = 0.1) annotation(
          Placement(transformation(extent = {{-80, 40}, {-60, 60}})));
        Modelica.Blocks.Continuous.Filter Bessel(f_cut = f_cut, filterType = Modelica.Blocks.Types.FilterType.LowPass, order = 3, analogFilter = Modelica.Blocks.Types.AnalogFilter.Bessel) annotation(
          Placement(transformation(extent = {{-40, 40}, {-20, 60}})));
        Continuous.Der der1 annotation(
          Placement(transformation(extent = {{-6, 40}, {14, 60}})));
        Continuous.Der der2 annotation(
          Placement(transformation(extent = {{30, 40}, {50, 60}})));
        Continuous.Der der3 annotation(
          Placement(transformation(extent = {{62, 40}, {82, 60}})));
      equation
        connect(step.y, Bessel.u) annotation(
          Line(points = {{-59, 50}, {-42, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(Bessel.y, der1.u) annotation(
          Line(points = {{-19, 50}, {-8, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(der1.y, der2.u) annotation(
          Line(points = {{15, 50}, {28, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(der2.y, der3.u) annotation(
          Line(points = {{51, 50}, {60, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 0.9),
          Documentation(info = "<html>

<p>
This example demonstrates that the output of the
<a href=\"modelica://Modelica.Blocks.Continuous.Filter\">Filter</a> block
can be differentiated up to the order of the filter. This feature can be
used in order to make an inverse model realizable or to \"smooth\" a potential
discontinuous control signal.
</p>

</html>"));
      end FilterWithDifferentiation;

      model FilterWithRiseTime "Demonstrates to use the rise time instead of the cut-off frequency to define a filter"
        extends Modelica.Icons.Example;
        parameter Integer order = 2 "Filter order";
        parameter Modelica.SIunits.Time riseTime = 2 "Time to reach the step input";
        constant Real pi = Modelica.Constants.pi;
        Continuous.Filter filter_fac5(f_cut = 5 / (2 * pi * riseTime), order = order) annotation(
          Placement(transformation(extent = {{-20, -20}, {0, 0}})));
        Sources.Step step(startTime = 1) annotation(
          Placement(transformation(extent = {{-60, 20}, {-40, 40}})));
        Continuous.Filter filter_fac4(f_cut = 4 / (2 * pi * riseTime), order = order) annotation(
          Placement(transformation(extent = {{-20, 20}, {0, 40}})));
        Continuous.Filter filter_fac3(f_cut = 3 / (2 * pi * riseTime), order = order) annotation(
          Placement(transformation(extent = {{-20, 62}, {0, 82}})));
      equation
        connect(step.y, filter_fac5.u) annotation(
          Line(points = {{-39, 30}, {-30, 30}, {-30, -10}, {-22, -10}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(step.y, filter_fac4.u) annotation(
          Line(points = {{-39, 30}, {-22, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(step.y, filter_fac3.u) annotation(
          Line(points = {{-39, 30}, {-30, 30}, {-30, 72}, {-22, 72}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 4),
          Documentation(info = "<html>
<p>
Filters are usually parameterized with the cut-off frequency.
Sometimes, it is more meaningful to parameterize a filter with its
rise time, i.e., the time it needs until the output reaches the end value
of a step input. This is performed with the formula:
</p>

<blockquote><pre>
f_cut = fac/(2*pi*riseTime);
</pre></blockquote>

<p>
where \"fac\" is typically 3, 4, or 5. The following image shows
the results of a simulation of this example model
(riseTime = 2 s, fac=3, 4, and 5):
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/FilterWithRiseTime.png\"
     alt=\"FilterWithRiseTime.png\">

<p>
Since the step starts at 1 s, and the rise time is 2 s, the filter output y
shall reach the value of 1 after 1+2=3 s. Depending on the factor \"fac\" this is
reached with different precisions. This is summarized in the following table:
</p>

<blockquote><table border=1 cellspacing=0 cellpadding=2>
<tr>
   <td>Filter order</td>
   <td>Factor fac</td>
   <td>Percentage of step value reached after rise time</td>
</tr>
<tr>
   <td align=\"center\">1</td>
   <td align=\"center\">3</td>
   <td align=\"center\">95.1 %</td>
</tr>
<tr>
   <td align=\"center\">1</td>
   <td align=\"center\">4</td>
   <td align=\"center\">98.2 %</td>
</tr>
<tr>
   <td align=\"center\">1</td>
   <td align=\"center\">5</td>
   <td align=\"center\">99.3 %</td>
</tr>

<tr>
   <td align=\"center\">2</td>
   <td align=\"center\">3</td>
   <td align=\"center\">94.7 %</td>
</tr>
<tr>
   <td align=\"center\">2</td>
   <td align=\"center\">4</td>
   <td align=\"center\">98.6 %</td>
</tr>
<tr>
   <td align=\"center\">2</td>
   <td align=\"center\">5</td>
   <td align=\"center\">99.6 %</td>
</tr>
</table></blockquote>

</html>"));
      end FilterWithRiseTime;

      model InverseModel "Demonstrates the construction of an inverse model"
        extends Modelica.Icons.Example;
        Continuous.FirstOrder firstOrder1(k = 1, T = 0.3, initType = Modelica.Blocks.Types.Init.SteadyState) annotation(
          Placement(transformation(extent = {{20, 20}, {0, 40}})));
        Sources.Sine sine(freqHz = 2, offset = 1, startTime = 0.2) annotation(
          Placement(transformation(extent = {{-80, 20}, {-60, 40}})));
        Math.InverseBlockConstraints inverseBlockConstraints annotation(
          Placement(transformation(extent = {{-10, 20}, {30, 40}})));
        Continuous.FirstOrder firstOrder2(k = 1, T = 0.3, initType = Modelica.Blocks.Types.Init.SteadyState) annotation(
          Placement(transformation(extent = {{20, -20}, {0, 0}})));
        Math.Feedback feedback annotation(
          Placement(transformation(extent = {{-40, 0}, {-60, -20}})));
        Continuous.CriticalDamping criticalDamping(n = 1, f = 50 * sine.freqHz) annotation(
          Placement(transformation(extent = {{-40, 20}, {-20, 40}})));
      equation
        connect(firstOrder1.y, inverseBlockConstraints.u2) annotation(
          Line(points = {{-1, 30}, {-6, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(inverseBlockConstraints.y2, firstOrder1.u) annotation(
          Line(points = {{27, 30}, {22, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(firstOrder2.y, feedback.u1) annotation(
          Line(points = {{-1, -10}, {-42, -10}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(sine.y, criticalDamping.u) annotation(
          Line(points = {{-59, 30}, {-42, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(criticalDamping.y, inverseBlockConstraints.u1) annotation(
          Line(points = {{-19, 30}, {-12, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(sine.y, feedback.u2) annotation(
          Line(points = {{-59, 30}, {-50, 30}, {-50, -2}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(inverseBlockConstraints.y1, firstOrder2.u) annotation(
          Line(points = {{31, 30}, {40, 30}, {40, -10}, {22, -10}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p>
This example demonstrates how to construct an inverse model in Modelica
(for more details see <a href=\"https://www.modelica.org/events/Conference2005/online_proceedings/Session3/Session3c3.pdf\">Looye, Th&uuml;mmel, Kurze, Otter, Bals: Nonlinear Inverse Models for Control</a>).
</p>

<p>
For a linear, single input, single output system
</p>

<pre>
   y = n(s)/d(s) * u   // plant model
</pre>

<p>
the inverse model is derived by simply exchanging the numerator and
the denominator polynomial:
</p>

<pre>
   u = d(s)/n(s) * y   // inverse plant model
</pre>

<p>
If the denominator polynomial d(s) has a higher degree as the
numerator polynomial n(s) (which is usually the case for plant models),
then the inverse model is no longer proper, i.e., it is not causal.
To avoid this, an approximate inverse model is constructed by adding
a sufficient number of poles to the denominator of the inverse model.
This can be interpreted as filtering the desired output signal y:
</p>

<pre>
   u = d(s)/(n(s)*f(s)) * y  // inverse plant model with filtered y
</pre>

<p>
With Modelica it is in principal possible to construct inverse models not only
for linear but also for non-linear models and in particular for every
Modelica model. The basic construction mechanism is explained at hand
of this example:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/InverseModelSchematic.png\"
     alt=\"InverseModelSchematic.png\">

<p>
Here the first order block \"firstOrder1\" shall be inverted. This is performed
by connecting its inputs and outputs with an instance of block
Modelica.Blocks.Math.<b>InverseBlockConstraints</b>. By this connection,
the inputs and outputs are exchanged. The goal is to compute the input of the
\"firstOrder1\" block so that its output follows a given sine signal.
For this, the sine signal \"sin\" is first filtered with a \"CriticalDamping\"
filter of order 1 and then the output of this filter is connected to the output
of the \"firstOrder1\" block (via the InverseBlockConstraints block, since
2 outputs cannot be connected directly together in a block diagram).
</p>

<p>
In order to check the inversion, the computed input of \"firstOrder1\" is used
as input in an identical block \"firstOrder2\". The output of \"firstOrder2\" should
be the given \"sine\" function. The difference is constructed with the \"feedback\"
block. Since the \"sine\" function is filtered, one cannot expect that this difference
is zero. The higher the cut-off frequency of the filter, the closer is the
agreement. A typical simulation result is shown in the next figure:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/InverseModel.png\"
     alt=\"InverseModel.png\">
</html>"),
          experiment(StopTime = 1.0));
      end InverseModel;

      model ShowLogicalSources "Demonstrates the usage of logical sources together with their diagram animation"
        extends Modelica.Icons.Example;
        Sources.BooleanTable table(table = {2, 4, 6, 8}) annotation(
          Placement(transformation(extent = {{-60, -100}, {-40, -80}}, rotation = 0)));
        Sources.BooleanConstant const annotation(
          Placement(transformation(extent = {{-60, 60}, {-40, 80}}, rotation = 0)));
        Sources.BooleanStep step(startTime = 4) annotation(
          Placement(transformation(extent = {{-60, 20}, {-40, 40}}, rotation = 0)));
        Sources.BooleanPulse pulse(period = 1.5) annotation(
          Placement(transformation(extent = {{-60, -20}, {-40, 0}}, rotation = 0)));
        Sources.SampleTrigger sample(period = 0.5) annotation(
          Placement(transformation(extent = {{-60, -60}, {-40, -40}}, rotation = 0)));
        Sources.BooleanExpression booleanExpression(y = pulse.y and step.y) annotation(
          Placement(transformation(extent = {{20, 20}, {80, 40}}, rotation = 0)));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This simple example demonstrates the logical sources in
<a href=\"modelica://Modelica.Blocks.Sources\">Modelica.Blocks.Sources</a> and demonstrate
their diagram animation (see \"small circle\" close to the output connector).
The \"booleanExpression\" source shows how a logical expression can be defined
in its parameter menu referring to variables available on this level of the
model.
</p>

</html>"));
      end ShowLogicalSources;

      model LogicalNetwork1 "Demonstrates the usage of logical blocks"
        extends Modelica.Icons.Example;
        Sources.BooleanTable table2(table = {1, 3, 5, 7}) annotation(
          Placement(transformation(extent = {{-80, -20}, {-60, 0}}, rotation = 0)));
        Sources.BooleanTable table1(table = {2, 4, 6, 8}) annotation(
          Placement(transformation(extent = {{-80, 20}, {-60, 40}}, rotation = 0)));
        Logical.Not Not1 annotation(
          Placement(transformation(extent = {{-40, -20}, {-20, 0}}, rotation = 0)));
        Logical.And And1 annotation(
          Placement(transformation(extent = {{0, -20}, {20, 0}}, rotation = 0)));
        Logical.Or Or1 annotation(
          Placement(transformation(extent = {{40, 20}, {60, 40}}, rotation = 0)));
        Logical.Pre Pre1 annotation(
          Placement(transformation(extent = {{-40, -60}, {-20, -40}}, rotation = 0)));
      equation
        connect(table2.y, Not1.u) annotation(
          Line(points = {{-59, -10}, {-42, -10}}, color = {255, 0, 255}));
        connect(And1.y, Or1.u2) annotation(
          Line(points = {{21, -10}, {28, -10}, {28, 22}, {38, 22}}, color = {255, 0, 255}));
        connect(table1.y, Or1.u1) annotation(
          Line(points = {{-59, 30}, {38, 30}}, color = {255, 0, 255}));
        connect(Not1.y, And1.u1) annotation(
          Line(points = {{-19, -10}, {-2, -10}}, color = {255, 0, 255}));
        connect(Pre1.y, And1.u2) annotation(
          Line(points = {{-19, -50}, {-10, -50}, {-10, -18}, {-2, -18}}, color = {255, 0, 255}));
        connect(Or1.y, Pre1.u) annotation(
          Line(points = {{61, 30}, {68, 30}, {68, -70}, {-60, -70}, {-60, -50}, {-42, -50}}, color = {255, 0, 255}));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This example demonstrates a network of logical blocks. Note, that
the Boolean values of the input and output signals are visualized
in the diagram animation, by the small \"circles\" close to the connectors.
If a \"circle\" is \"white\", the signal is <b>false</b>. It a
\"circle\" is \"green\", the signal is <b>true</b>.
</p>
</html>"));
      end LogicalNetwork1;

      model RealNetwork1 "Demonstrates the usage of blocks from Modelica.Blocks.Math"
        extends Modelica.Icons.Example;
        Modelica.Blocks.Math.MultiSum add(nu = 2) annotation(
          Placement(transformation(extent = {{-14, 64}, {-2, 76}})));
        Sources.Sine sine(amplitude = 3, freqHz = 0.1) annotation(
          Placement(transformation(extent = {{-96, 60}, {-76, 80}})));
        Sources.Step integerStep(height = 3, startTime = 2) annotation(
          Placement(transformation(extent = {{-60, 30}, {-40, 50}})));
        Sources.Constant integerConstant(k = 1) annotation(
          Placement(transformation(extent = {{-60, -10}, {-40, 10}})));
        Modelica.Blocks.Interaction.Show.RealValue showValue annotation(
          Placement(transformation(extent = {{66, 60}, {86, 80}})));
        Math.MultiProduct product(nu = 2) annotation(
          Placement(transformation(extent = {{6, 24}, {18, 36}})));
        Modelica.Blocks.Interaction.Show.RealValue showValue1(significantDigits = 2) annotation(
          Placement(transformation(extent = {{64, 20}, {84, 40}})));
        Sources.BooleanPulse booleanPulse1(period = 1) annotation(
          Placement(transformation(extent = {{-12, -30}, {8, -10}})));
        Math.MultiSwitch multiSwitch(nu = 2, expr = {4, 6}, y_default = 2) annotation(
          Placement(transformation(extent = {{28, -60}, {68, -40}})));
        Sources.BooleanPulse booleanPulse2(period = 2, width = 80) annotation(
          Placement(transformation(extent = {{-12, -70}, {8, -50}})));
        Modelica.Blocks.Interaction.Show.RealValue showValue3(use_numberPort = false, number = multiSwitch.y, significantDigits = 1) annotation(
          Placement(transformation(extent = {{40, -84}, {60, -64}})));
        Math.LinearDependency linearDependency1(y0 = 1, k1 = 2, k2 = 3) annotation(
          Placement(transformation(extent = {{40, 80}, {60, 100}})));
        Math.MinMax minMax(nu = 2) annotation(
          Placement(transformation(extent = {{58, -16}, {78, 4}})));
      equation
        connect(booleanPulse1.y, multiSwitch.u[1]) annotation(
          Line(points = {{9, -20}, {18, -20}, {18, -48}, {28, -48}, {28, -48.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, multiSwitch.u[2]) annotation(
          Line(points = {{9, -60}, {18, -60}, {18, -52}, {28, -52}, {28, -51.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(sine.y, add.u[1]) annotation(
          Line(points = {{-75, 70}, {-46.5, 70}, {-46.5, 72.1}, {-14, 72.1}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(integerStep.y, add.u[2]) annotation(
          Line(points = {{-39, 40}, {-28, 40}, {-28, 67.9}, {-14, 67.9}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(add.y, showValue.numberPort) annotation(
          Line(points = {{-0.98, 70}, {64.5, 70}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(integerStep.y, product.u[1]) annotation(
          Line(points = {{-39, 40}, {-20, 40}, {-20, 32.1}, {6, 32.1}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(integerConstant.y, product.u[2]) annotation(
          Line(points = {{-39, 0}, {-20, 0}, {-20, 27.9}, {6, 27.9}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(product.y, showValue1.numberPort) annotation(
          Line(points = {{19.02, 30}, {62.5, 30}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(add.y, linearDependency1.u1) annotation(
          Line(points = {{-0.98, 70}, {20, 70}, {20, 96}, {38, 96}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(product.y, linearDependency1.u2) annotation(
          Line(points = {{19.02, 30}, {30, 30}, {30, 84}, {38, 84}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(add.y, minMax.u[1]) annotation(
          Line(points = {{-0.98, 70}, {48, 70}, {48, -2.5}, {58, -2.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(product.y, minMax.u[2]) annotation(
          Line(points = {{19.02, 30}, {40, 30}, {40, -9.5}, {58, -9.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This example demonstrates a network of mathematical Real blocks.
from package <a href=\"modelica://Modelica.Blocks.Math\">Modelica.Blocks.Math</a>.
Note, that
</p>

<ul>
<li> at the right side of the model, several Math.ShowValue blocks
     are present, that visualize the actual value of the respective Real
     signal in a diagram animation.</li>

<li> the Boolean values of the input and output signals are visualized
     in the diagram animation, by the small \"circles\" close to the connectors.
     If a \"circle\" is \"white\", the signal is <b>false</b>. If a
     \"circle\" is \"green\", the signal is <b>true</b>.</li>
</ul>

</html>"));
      end RealNetwork1;

      model IntegerNetwork1 "Demonstrates the usage of blocks from Modelica.Blocks.MathInteger"
        extends Modelica.Icons.Example;
        MathInteger.Sum sum(nu = 3) annotation(
          Placement(transformation(extent = {{-14, 64}, {-2, 76}})));
        Sources.Sine sine(amplitude = 3, freqHz = 0.1) annotation(
          Placement(transformation(extent = {{-100, 60}, {-80, 80}})));
        Math.RealToInteger realToInteger annotation(
          Placement(transformation(extent = {{-60, 60}, {-40, 80}})));
        Sources.IntegerStep integerStep(height = 3, startTime = 2) annotation(
          Placement(transformation(extent = {{-60, 30}, {-40, 50}})));
        Sources.IntegerConstant integerConstant(k = 1) annotation(
          Placement(transformation(extent = {{-60, -10}, {-40, 10}})));
        Modelica.Blocks.Interaction.Show.IntegerValue showValue annotation(
          Placement(transformation(extent = {{40, 60}, {60, 80}})));
        MathInteger.Product product(nu = 2) annotation(
          Placement(transformation(extent = {{16, 24}, {28, 36}})));
        Modelica.Blocks.Interaction.Show.IntegerValue showValue1 annotation(
          Placement(transformation(extent = {{40, 20}, {60, 40}})));
        MathInteger.TriggeredAdd triggeredAdd(use_reset = false, use_set = false) annotation(
          Placement(transformation(extent = {{16, -6}, {28, 6}})));
        Sources.BooleanPulse booleanPulse1(period = 1) annotation(
          Placement(transformation(extent = {{-12, -30}, {8, -10}})));
        Modelica.Blocks.Interaction.Show.IntegerValue showValue2 annotation(
          Placement(transformation(extent = {{40, -10}, {60, 10}})));
        MathInteger.MultiSwitch multiSwitch1(nu = 2, expr = {4, 6}, y_default = 2, use_pre_as_default = false) annotation(
          Placement(transformation(extent = {{28, -60}, {68, -40}})));
        Sources.BooleanPulse booleanPulse2(period = 2, width = 80) annotation(
          Placement(transformation(extent = {{-12, -70}, {8, -50}})));
        Modelica.Blocks.Interaction.Show.IntegerValue showValue3(use_numberPort = false, number = multiSwitch1.y) annotation(
          Placement(transformation(extent = {{40, -84}, {60, -64}})));
      equation
        connect(sine.y, realToInteger.u) annotation(
          Line(points = {{-79, 70}, {-62, 70}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(realToInteger.y, sum.u[1]) annotation(
          Line(points = {{-39, 70}, {-32, 70}, {-32, 72}, {-14, 72}, {-14, 72.8}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(integerStep.y, sum.u[2]) annotation(
          Line(points = {{-39, 40}, {-28, 40}, {-28, 70}, {-14, 70}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(integerConstant.y, sum.u[3]) annotation(
          Line(points = {{-39, 0}, {-22, 0}, {-22, 67.2}, {-14, 67.2}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(sum.y, showValue.numberPort) annotation(
          Line(points = {{-1.1, 70}, {38.5, 70}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(sum.y, product.u[1]) annotation(
          Line(points = {{-1.1, 70}, {4, 70}, {4, 32.1}, {16, 32.1}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(integerStep.y, product.u[2]) annotation(
          Line(points = {{-39, 40}, {-8, 40}, {-8, 27.9}, {16, 27.9}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(product.y, showValue1.numberPort) annotation(
          Line(points = {{28.9, 30}, {38.5, 30}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(integerConstant.y, triggeredAdd.u) annotation(
          Line(points = {{-39, 0}, {13.6, 0}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(booleanPulse1.y, triggeredAdd.trigger) annotation(
          Line(points = {{9, -20}, {18.4, -20}, {18.4, -7.2}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(triggeredAdd.y, showValue2.numberPort) annotation(
          Line(points = {{29.2, 0}, {38.5, 0}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(booleanPulse1.y, multiSwitch1.u[1]) annotation(
          Line(points = {{9, -20}, {18, -20}, {18, -48}, {28, -48}, {28, -48.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, multiSwitch1.u[2]) annotation(
          Line(points = {{9, -60}, {18, -60}, {18, -52}, {28, -52}, {28, -51.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This example demonstrates a network of Integer blocks.
from package <a href=\"modelica://Modelica.Blocks.MathInteger\">Modelica.Blocks.MathInteger</a>.
Note, that
</p>

<ul>
<li> at the right side of the model, several MathInteger.ShowValue blocks
     are present, that visualize the actual value of the respective Integer
     signal in a diagram animation.</li>

<li> the Boolean values of the input and output signals are visualized
     in the diagram animation, by the small \"circles\" close to the connectors.
     If a \"circle\" is \"white\", the signal is <b>false</b>. If a
     \"circle\" is \"green\", the signal is <b>true</b>.</li>

</ul>

</html>"));
      end IntegerNetwork1;

      model BooleanNetwork1 "Demonstrates the usage of blocks from Modelica.Blocks.MathBoolean"
        extends Modelica.Icons.Example;
        Modelica.Blocks.Interaction.Show.BooleanValue showValue annotation(
          Placement(transformation(extent = {{-36, 74}, {-16, 94}})));
        MathBoolean.And and1(nu = 3) annotation(
          Placement(transformation(extent = {{-58, 64}, {-46, 76}})));
        Sources.BooleanPulse booleanPulse1(width = 20, period = 1) annotation(
          Placement(transformation(extent = {{-100, 60}, {-80, 80}})));
        Sources.BooleanPulse booleanPulse2(period = 1, width = 80) annotation(
          Placement(transformation(extent = {{-100, -4}, {-80, 16}})));
        Sources.BooleanStep booleanStep(startTime = 1.5) annotation(
          Placement(transformation(extent = {{-100, 28}, {-80, 48}})));
        MathBoolean.Or or1(nu = 2) annotation(
          Placement(transformation(extent = {{-28, 62}, {-16, 74}})));
        MathBoolean.Xor xor1(nu = 2) annotation(
          Placement(transformation(extent = {{-2, 60}, {10, 72}})));
        Modelica.Blocks.Interaction.Show.BooleanValue showValue2 annotation(
          Placement(transformation(extent = {{-2, 74}, {18, 94}})));
        Modelica.Blocks.Interaction.Show.BooleanValue showValue3 annotation(
          Placement(transformation(extent = {{24, 56}, {44, 76}})));
        MathBoolean.Nand nand1(nu = 2) annotation(
          Placement(transformation(extent = {{22, 40}, {34, 52}})));
        MathBoolean.Nor or2(nu = 2) annotation(
          Placement(transformation(extent = {{46, 38}, {58, 50}})));
        Modelica.Blocks.Interaction.Show.BooleanValue showValue4 annotation(
          Placement(transformation(extent = {{90, 34}, {110, 54}})));
        MathBoolean.Not nor1 annotation(
          Placement(transformation(extent = {{68, 40}, {76, 48}})));
        MathBoolean.OnDelay onDelay(delayTime = 1) annotation(
          Placement(transformation(extent = {{-56, -94}, {-48, -86}})));
        MathBoolean.RisingEdge rising annotation(
          Placement(transformation(extent = {{-56, -15}, {-48, -7}})));
        MathBoolean.MultiSwitch set1(nu = 2, expr = {false, true}) annotation(
          Placement(transformation(extent = {{-30, -23}, {10, -3}})));
        MathBoolean.FallingEdge falling annotation(
          Placement(transformation(extent = {{-56, -32}, {-48, -24}})));
        Sources.BooleanTable booleanTable(table = {2, 4, 6, 6.5, 7, 9, 11}) annotation(
          Placement(transformation(extent = {{-100, -100}, {-80, -80}})));
        MathBoolean.ChangingEdge changing annotation(
          Placement(transformation(extent = {{-56, -59}, {-48, -51}})));
        MathInteger.TriggeredAdd triggeredAdd annotation(
          Placement(transformation(extent = {{14, -56}, {26, -44}})));
        Sources.IntegerConstant integerConstant(k = 2) annotation(
          Placement(transformation(extent = {{-20, -60}, {0, -40}})));
        Modelica.Blocks.Interaction.Show.IntegerValue showValue1 annotation(
          Placement(transformation(extent = {{40, -60}, {60, -40}})));
        Modelica.Blocks.Interaction.Show.BooleanValue showValue5 annotation(
          Placement(transformation(extent = {{24, -23}, {44, -3}})));
        Modelica.Blocks.Interaction.Show.BooleanValue showValue6 annotation(
          Placement(transformation(extent = {{-32, -100}, {-12, -80}})));
        Logical.RSFlipFlop rSFlipFlop annotation(
          Placement(transformation(extent = {{70, -90}, {90, -70}})));
        Sources.SampleTrigger sampleTriggerSet(period = 0.5, startTime = 0) annotation(
          Placement(transformation(extent = {{40, -76}, {54, -62}})));
        Sources.SampleTrigger sampleTriggerReset(period = 0.5, startTime = 0.3) annotation(
          Placement(transformation(extent = {{40, -98}, {54, -84}})));
      equation
        connect(booleanPulse1.y, and1.u[1]) annotation(
          Line(points = {{-79, 70}, {-68, 70}, {-68, 72.8}, {-58, 72.8}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanStep.y, and1.u[2]) annotation(
          Line(points = {{-79, 38}, {-64, 38}, {-64, 70}, {-58, 70}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, and1.u[3]) annotation(
          Line(points = {{-79, 6}, {-62, 6}, {-62, 67.2}, {-58, 67.2}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(and1.y, or1.u[1]) annotation(
          Line(points = {{-45.1, 70}, {-36.4, 70}, {-36.4, 70.1}, {-28, 70.1}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, or1.u[2]) annotation(
          Line(points = {{-79, 6}, {-40, 6}, {-40, 65.9}, {-28, 65.9}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(or1.y, xor1.u[1]) annotation(
          Line(points = {{-15.1, 68}, {-8, 68}, {-8, 68.1}, {-2, 68.1}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, xor1.u[2]) annotation(
          Line(points = {{-79, 6}, {-12, 6}, {-12, 63.9}, {-2, 63.9}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(and1.y, showValue.activePort) annotation(
          Line(points = {{-45.1, 70}, {-42, 70}, {-42, 84}, {-37.5, 84}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(or1.y, showValue2.activePort) annotation(
          Line(points = {{-15.1, 68}, {-12, 68}, {-12, 84}, {-3.5, 84}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(xor1.y, showValue3.activePort) annotation(
          Line(points = {{10.9, 66}, {22.5, 66}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(xor1.y, nand1.u[1]) annotation(
          Line(points = {{10.9, 66}, {16, 66}, {16, 48.1}, {22, 48.1}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, nand1.u[2]) annotation(
          Line(points = {{-79, 6}, {16, 6}, {16, 44}, {22, 44}, {22, 43.9}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(nand1.y, or2.u[1]) annotation(
          Line(points = {{34.9, 46}, {46, 46}, {46, 46.1}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, or2.u[2]) annotation(
          Line(points = {{-79, 6}, {42, 6}, {42, 41.9}, {46, 41.9}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(or2.y, nor1.u) annotation(
          Line(points = {{58.9, 44}, {66.4, 44}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(nor1.y, showValue4.activePort) annotation(
          Line(points = {{76.8, 44}, {88.5, 44}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, rising.u) annotation(
          Line(points = {{-79, 6}, {-62, 6}, {-62, -11}, {-57.6, -11}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(rising.y, set1.u[1]) annotation(
          Line(points = {{-47.2, -11}, {-38.6, -11}, {-38.6, -11.5}, {-30, -11.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(falling.y, set1.u[2]) annotation(
          Line(points = {{-47.2, -28}, {-40, -28}, {-40, -14.5}, {-30, -14.5}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, falling.u) annotation(
          Line(points = {{-79, 6}, {-62, 6}, {-62, -28}, {-57.6, -28}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanTable.y, onDelay.u) annotation(
          Line(points = {{-79, -90}, {-57.6, -90}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(booleanPulse2.y, changing.u) annotation(
          Line(points = {{-79, 6}, {-62, 6}, {-62, -55}, {-57.6, -55}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(integerConstant.y, triggeredAdd.u) annotation(
          Line(points = {{1, -50}, {11.6, -50}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(changing.y, triggeredAdd.trigger) annotation(
          Line(points = {{-47.2, -55}, {-30, -55}, {-30, -74}, {16.4, -74}, {16.4, -57.2}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(triggeredAdd.y, showValue1.numberPort) annotation(
          Line(points = {{27.2, -50}, {38.5, -50}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(set1.y, showValue5.activePort) annotation(
          Line(points = {{11, -13}, {22.5, -13}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(onDelay.y, showValue6.activePort) annotation(
          Line(points = {{-47.2, -90}, {-33.5, -90}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(sampleTriggerSet.y, rSFlipFlop.S) annotation(
          Line(points = {{54.7, -69}, {60, -69}, {60, -74}, {68, -74}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(sampleTriggerReset.y, rSFlipFlop.R) annotation(
          Line(points = {{54.7, -91}, {60, -91}, {60, -86}, {68, -86}}, color = {255, 0, 255}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This example demonstrates a network of Boolean blocks
from package <a href=\"modelica://Modelica.Blocks.MathBoolean\">Modelica.Blocks.MathBoolean</a>.
Note, that
</p>

<ul>
<li> at the right side of the model, several MathBoolean.ShowValue blocks
     are present, that visualize the actual value of the respective Boolean
     signal in a diagram animation (\"green\" means \"true\").</li>

<li> the Boolean values of the input and output signals are visualized
     in the diagram animation, by the small \"circles\" close to the connectors.
     If a \"circle\" is \"white\", the signal is <b>false</b>. If a
     \"circle\" is \"green\", the signal is <b>true</b>.</li>

</ul>

</html>"));
      end BooleanNetwork1;

      model Interaction1 "Demonstrates the usage of blocks from Modelica.Blocks.Interaction.Show"
        extends Modelica.Icons.Example;
        Interaction.Show.IntegerValue integerValue annotation(
          Placement(transformation(extent = {{-40, 20}, {-20, 40}})));
        Sources.IntegerTable integerTable(table = [0, 0; 1, 2; 2, 4; 3, 6; 4, 4; 6, 2]) annotation(
          Placement(transformation(extent = {{-80, 20}, {-60, 40}})));
        Sources.TimeTable timeTable(table = [0, 0; 1, 2.1; 2, 4.2; 3, 6.3; 4, 4.2; 6, 2.1; 6, 2.1]) annotation(
          Placement(transformation(extent = {{-80, 60}, {-60, 80}})));
        Interaction.Show.RealValue realValue annotation(
          Placement(transformation(extent = {{-40, 60}, {-20, 80}})));
        Sources.BooleanTable booleanTable(table = {1, 2, 3, 4, 5, 6, 7, 8, 9}) annotation(
          Placement(transformation(extent = {{-80, -20}, {-60, 0}})));
        Interaction.Show.BooleanValue booleanValue annotation(
          Placement(transformation(extent = {{-40, -20}, {-20, 0}})));
        Sources.RadioButtonSource start(buttonTimeTable = {1, 3}, reset = {stop.on}) annotation(
          Placement(transformation(extent = {{24, 64}, {36, 76}})));
        Sources.RadioButtonSource stop(buttonTimeTable = {2, 4}, reset = {start.on}) annotation(
          Placement(transformation(extent = {{48, 64}, {60, 76}})));
      equation
        connect(integerTable.y, integerValue.numberPort) annotation(
          Line(points = {{-59, 30}, {-41.5, 30}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(timeTable.y, realValue.numberPort) annotation(
          Line(points = {{-59, 70}, {-41.5, 70}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(booleanTable.y, booleanValue.activePort) annotation(
          Line(points = {{-59, -10}, {-41.5, -10}}, color = {255, 0, 255}, smooth = Smooth.None));
        annotation(
          experiment(StopTime = 10),
          Documentation(info = "<html>
<p>
This example demonstrates a network of blocks
from package <a href=\"modelica://Modelica.Blocks.Interaction\">Modelica.Blocks.Interaction</a>
to show how diagram animations can be constructed.
</p>

</html>"));
      end Interaction1;

      model BusUsage "Demonstrates the usage of a signal bus"
        extends Modelica.Icons.Example;
      public
        Modelica.Blocks.Sources.IntegerStep integerStep(height = 1, offset = 2, startTime = 0.5) annotation(
          Placement(transformation(extent = {{-60, -40}, {-40, -20}}, rotation = 0)));
        Modelica.Blocks.Sources.BooleanStep booleanStep(startTime = 0.5) annotation(
          Placement(transformation(extent = {{-58, 0}, {-38, 20}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine(freqHz = 1) annotation(
          Placement(transformation(extent = {{-60, 40}, {-40, 60}}, rotation = 0)));
        Modelica.Blocks.Examples.BusUsage_Utilities.Part part annotation(
          Placement(transformation(extent = {{-60, -80}, {-40, -60}}, rotation = 0)));
        Modelica.Blocks.Math.Gain gain(k = 1) annotation(
          Placement(transformation(extent = {{-40, 70}, {-60, 90}}, rotation = 0)));
      protected
        BusUsage_Utilities.Interfaces.ControlBus controlBus annotation(
          Placement(transformation(origin = {30, 10}, extent = {{-20, 20}, {20, -20}}, rotation = 90)));
      equation
        connect(sine.y, controlBus.realSignal1) annotation(
          Line(points = {{-39, 50}, {12, 50}, {12, 14}, {30, 14}, {30, 10}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(booleanStep.y, controlBus.booleanSignal) annotation(
          Line(points = {{-37, 10}, {30, 10}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(integerStep.y, controlBus.integerSignal) annotation(
          Line(points = {{-39, -30}, {0, -30}, {0, 6}, {32, 6}, {32, 10}, {30, 10}}, color = {255, 127, 0}, smooth = Smooth.None));
        connect(part.subControlBus, controlBus.subControlBus) annotation(
          Line(points = {{-40, -70}, {30, -70}, {30, 10}}, color = {255, 204, 51}, thickness = 0.5, smooth = Smooth.None));
        connect(gain.u, controlBus.realSignal1) annotation(
          Line(points = {{-38, 80}, {20, 80}, {20, 18}, {32, 18}, {32, 10}, {30, 10}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p><b>Signal bus concept</b></p>
<p>
In technical systems, such as vehicles, robots or satellites, many signals
are exchanged between components. In a simulation system, these signals
are usually modelled by signal connections of input/output blocks.
Unfortunately, the signal connection structure may become very complicated,
especially for hierarchical models.
</p>

<p>
The same is also true for real technical systems. To reduce complexity
and get higher flexibility, many technical systems use data buses to
exchange data between components. For the same reasons, it is often better
to use a \"signal bus\" concept also in a Modelica model. This is demonstrated
at hand of this model (Modelica.Blocks.Examples.BusUsage):
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/BusUsage.png\"
     alt=\"BusUsage.png\">

<ul>
<li> Connector instance \"controlBus\" is a hierarchical connector that is
     used to exchange signals between different components. It is
     defined as \"expandable connector\" in order that <b>no</b> central definition
     of the connector is needed but is automatically constructed by the
     signals connected to it (see also Modelica specification 2.2.1).</li>
<li> Input/output signals can be directly connected to the \"controlBus\".</li>
<li> A component, such as \"part\", can be directly connected to the \"controlBus\",
     provided it has also a bus connector, or the \"part\" connector is a
     sub-connector contained in the \"controlBus\". </li>
</ul>

<p>
The control and sub-control bus icons are provided within Modelica.Icons.
In <a href=\"modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces\">Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces</a>
the buses for this example are defined. Both the \"ControlBus\" and the \"SubControlBus\" are
<b>expandable</b> connectors that do not define any variable. For example,
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.ControlBus#text\">Interfaces.ControlBus</a>
is defined as:
</p>
<pre>  <b>expandable connector</b> ControlBus
      <b>extends</b> Modelica.Icons.ControlBus;
      <b>annotation</b> ();
  <b>end</b> ControlBus;
</pre>
<p>
Note, the \"annotation\" in the connector is important since the color
and thickness of a connector line are taken from the first
line element in the icon annotation of a connector class. Above, a small rectangle in the
color of the bus is defined (and therefore this rectangle is not
visible). As a result, when connecting from an instance of this
connector to another connector instance, the connecting line has
the color of the \"ControlBus\" with double width (due to \"thickness=0.5\").
</p>

<p>
An <b>expandable</b> connector is a connector where the content of the connector
is constructed by the variables connected to instances of this connector.
For example, if \"sine.y\" is connected to the \"controlBus\", the following
menu pops-up in Dymola:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/BusUsage2.png\"
     alt=\"BusUsage2.png\">

<p>
The \"Add variable/New name\" field allows the user to define the name of the signal on
the \"controlBus\". When typing \"realSignal1\" as \"New name\", a connection of the form:
</p>

<pre>     <b>connect</b>(sine.y, controlBus.realSignal1)
</pre>

<p>
is generated and the \"controlBus\" contains the new signal \"realSignal1\". Modelica tools
may give more support in order to list potential signals for a connection.
For example, in Dymola all variables are listed in the menu that are contained in
connectors which are derived by inheritance from \"controlBus\". Therefore, in
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces\">BusUsage_Utilities.Interfaces</a>
the expected implementation of the \"ControlBus\" and of the \"SubControlBus\" are given.
For example \"Internal.ControlBus\" is defined as:
</p>

<pre>  <b>expandable connector</b> StandardControlBus
    <b>extends</b> BusUsage_Utilities.Interfaces.ControlBus;

    <b>import</b> SI = Modelica.SIunits;
    SI.AngularVelocity    realSignal1   \"First Real signal\";
    SI.Velocity           realSignal2   \"Second Real signal\";
    Integer               integerSignal \"Integer signal\";
    Boolean               booleanSignal \"Boolean signal\";
    StandardSubControlBus subControlBus \"Combined signal\";
  <b>end</b> StandardControlBus;
</pre>

<p>
Consequently, when connecting now from \"sine.y\" to \"controlBus\", the menu
looks differently:
</p>

<img src=\"modelica://Modelica/Resources/Images/Blocks/BusUsage3.png\"
     alt=\"BusUsage3.png\">

<p>
Note, even if the signals from \"Internal.StandardControlBus\" are listed, these are
just potential signals. The user might still add different signal names.
</p>

</html>"),
          experiment(StopTime = 2));
      end BusUsage;

      package BusUsage_Utilities "Utility models and connectors for example Modelica.Blocks.Examples.BusUsage"
        extends Modelica.Icons.UtilitiesPackage;

        package Interfaces "Interfaces specialised for this example"
          extends Modelica.Icons.InterfacesPackage;

          expandable connector ControlBus "Control bus that is adapted to the signals connected to it"
            extends Modelica.Icons.SignalBus;
            import SI = Modelica.SIunits;
            SI.AngularVelocity realSignal1 "First Real signal (angular velocity)" annotation(
              HideResult = false);
            SI.Velocity realSignal2 "Second Real signal" annotation(
              HideResult = false);
            Integer integerSignal "Integer signal" annotation(
              HideResult = false);
            Boolean booleanSignal "Boolean signal" annotation(
              HideResult = false);
            SubControlBus subControlBus "Combined signal" annotation(
              HideResult = false);
            annotation(
              Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-20, 2}, {22, -2}}, lineColor = {255, 204, 51}, lineThickness = 0.5)}),
              Documentation(info = "<html>
<p>
This connector defines the \"expandable connector\" ControlBus that
is used as bus in the
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
Note, this connector contains \"default\" signals that might be utilized
in a connection (the input/output causalities of the signals
are determined from the connections to this bus).
</p>
</html>"));
          end ControlBus;

          expandable connector SubControlBus "Sub-control bus that is adapted to the signals connected to it"
            extends Modelica.Icons.SignalSubBus;
            Real myRealSignal annotation(
              HideResult = false);
            Boolean myBooleanSignal annotation(
              HideResult = false);
            annotation(
              defaultComponentPrefixes = "protected",
              Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-20, 2}, {22, -2}}, lineColor = {255, 204, 51}, lineThickness = 0.5)}),
              Documentation(info = "<html>
<p>
This connector defines the \"expandable connector\" SubControlBus that
is used as sub-bus in the
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
Note, this is an expandable connector which has a \"default\" set of
signals (the input/output causalities of the signals are
determined from the connections to this bus).
</p>
</html>"));
          end SubControlBus;
          annotation(
            Documentation(info = "<html>
<p>
This package contains the bus definitions needed for the
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
</p>
</html>"));
        end Interfaces;

        model Part "Component with sub-control bus"
          Interfaces.SubControlBus subControlBus annotation(
            Placement(transformation(origin = {100, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 270)));
          Sources.RealExpression realExpression(y = time) annotation(
            Placement(transformation(extent = {{-6, 0}, {20, 20}}, rotation = 0)));
          Sources.BooleanExpression booleanExpression(y = time > 0.5) annotation(
            Placement(transformation(extent = {{-6, -30}, {20, -10}}, rotation = 0)));
        equation
          connect(realExpression.y, subControlBus.myRealSignal) annotation(
            Line(points = {{21.3, 10}, {88, 10}, {88, 6}, {98, 6}, {98, 0}, {100, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
          connect(booleanExpression.y, subControlBus.myBooleanSignal) annotation(
            Line(points = {{21.3, -20}, {60, -20}, {60, 0}, {100, 0}}, color = {255, 0, 255}, smooth = Smooth.None));
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 60}, {100, -60}}, fillColor = {159, 159, 223}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Text(extent = {{-106, 124}, {114, 68}}, textString = "%name", lineColor = {0, 0, 255})}),
            Documentation(info = "<html>
<p>
This model is used to demonstrate the bus usage in example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end Part;
        annotation(
          Documentation(info = "<html>
<p>
This package contains utility models and bus definitions needed for the
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
</p>
</html>"));
      end BusUsage_Utilities;
      annotation(
        Documentation(info = "<html>
<p>
This package contains example models to demonstrate the
usage of package blocks.
</p>
</html>"));
    end Examples;

    package Continuous "Library of continuous control blocks with internal states"
      import Modelica.Blocks.Interfaces;
      import Modelica.SIunits;
      extends Modelica.Icons.Package;

      block Integrator "Output the integral of the input signal"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Integrator gain";
        /* InitialState is the default, because it was the default in Modelica 2.2
             and therefore this setting is backward compatible
          */
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.InitialState "Type of initialization (1: no init, 2: steady state, 3,4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial or guess value of output (= state)" annotation(
          Dialog(group = "Initialization"));
        extends Interfaces.SISO(y(start = y_start));
      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(y) = k * u;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes output <b>y</b> (element-wise) as
<i>integral</i> of the input <b>u</b> multiplied with
the gain <i>k</i>:
</p>
<pre>
         k
     y = - u
         s
</pre>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Text(visible = true, lineColor = {192, 192, 192}, extent = {{0.0, -70.0}, {60.0, -10.0}}, textString = "I"), Text(visible = true, extent = {{-150.0, -150.0}, {150.0, -110.0}}, textString = "k=%k"), Line(visible = true, points = {{-80.0, -80.0}, {80.0, 80.0}}, color = {0, 0, 127})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255}), Text(extent = {{-36, 60}, {32, 2}}, lineColor = {0, 0, 0}, textString = "k"), Text(extent = {{-32, 0}, {36, -58}}, lineColor = {0, 0, 0}, textString = "s"), Line(points = {{-46, 0}, {46, 0}}, color = {0, 0, 0})}));
      end Integrator;

      block LimIntegrator "Integrator with limited value of the output"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Integrator gain";
        parameter Real outMax(start = 1) "Upper limit of output";
        parameter Real outMin = -outMax "Lower limit of output";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.InitialState "Type of initialization (1: no init, 2: steady state, 3/4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Boolean limitsAtInit = true "= false, if limits are ignored during initialization (i.e., der(y)=k*u)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial or guess value of output (must be in the limits outMin .. outMax)" annotation(
          Dialog(group = "Initialization"));
        parameter Boolean strict = false "= true, if strict limits with noEvent(..)" annotation(
          Evaluate = true,
          choices(checkBox = true),
          Dialog(tab = "Advanced"));
        extends Interfaces.SISO(y(start = y_start));
      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        if initial() and not limitsAtInit then
          der(y) = k * u;
          assert(y >= outMin - 0.001 * abs(outMax - outMin) and y <= outMax + 0.001 * abs(outMax - outMin), "LimIntegrator: During initialization the limits have been ignored.\n" + "However, the result is that the output y is not within the required limits:\n" + "  y = " + String(y) + ", outMin = " + String(outMin) + ", outMax = " + String(outMax));
        elseif strict then
          der(y) = noEvent(if y < outMin and k * u < 0 or y > outMax and k * u > 0 then 0 else k * u);
        else
          der(y) = if y < outMin and k * u < 0 or y > outMax and k * u > 0 then 0 else k * u;
        end if;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes <b>y</b> (element-wise) as <i>integral</i>
of the input <b>u</b> multiplied with the gain <i>k</i>. If the
integral reaches a given upper or lower <i>limit</i> and the
input will drive the integral outside of this bound, the
integration is halted and only restarted if the input drives
the integral away from the bounds.
</p>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits of the
integrator are removed from the initialization problem which
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 78}, {-80, -90}}, color = {192, 192, 192}), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, -80}, {82, -80}}, color = {192, 192, 192}), Polygon(points = {{90, -80}, {68, -72}, {68, -88}, {90, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {20, 20}, {80, 20}}, color = {0, 0, 127}), Text(extent = {{0, -10}, {60, -70}}, lineColor = {192, 192, 192}, textString = "I"), Text(extent = {{-150, -150}, {150, -110}}, lineColor = {0, 0, 0}, textString = "k=%k"), Line(visible = strict, points = {{20, 20}, {80, 20}}, color = {255, 0, 0}, smooth = Smooth.None)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-54, 46}, {-4, -48}}, lineColor = {0, 0, 0}, textString = "lim"), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255}), Text(extent = {{-8, 60}, {60, 2}}, lineColor = {0, 0, 0}, textString = "k"), Text(extent = {{-8, -2}, {60, -60}}, lineColor = {0, 0, 0}, textString = "s"), Line(points = {{4, 0}, {46, 0}}, color = {0, 0, 0})}));
      end LimIntegrator;

      block Derivative "Approximated derivative block"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Gains";
        parameter SIunits.Time T(min = Modelica.Constants.small) = 0.01 "Time constants (T>0 required; T=0 is ideal derivative block)";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x_start = 0 "Initial or guess value of state" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial value of output (= state)" annotation(
          Dialog(enable = initType == Init.InitialOutput, group = "Initialization"));
        extends Interfaces.SISO;
        output Real x(start = x_start) "State of block";
      protected
        parameter Boolean zeroGain = abs(k) < Modelica.Constants.eps;
      initial equation
        if initType == Init.SteadyState then
          der(x) = 0;
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          if zeroGain then
            x = u;
          else
            y = y_start;
          end if;
        end if;
      equation
        der(x) = if zeroGain then 0 else (u - x) / T;
        y = if zeroGain then 0 else k / T * (u - x);
        annotation(
          Documentation(info = "<html>
<p>
This blocks defines the transfer function between the
input u and the output y
(element-wise) as <i>approximated derivative</i>:
</p>
<pre>
             k * s
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a derivative block with parameters<br>
b = {k,0}, a = {T, 1}.
</p>

<p>
If k=0, the block reduces to y=0.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Line(visible = true, origin = {-24.667, -27.333}, points = {{-55.333, 87.333}, {-19.333, -40.667}, {86.667, -52.667}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-30.0, 14.0}, {86.0, 60.0}}, textString = "DT1"), Text(visible = true, extent = {{-150.0, -150.0}, {150.0, -110.0}}, textString = "k=%k")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-54, 52}, {50, 10}}, lineColor = {0, 0, 0}, textString = "k s"), Text(extent = {{-54, -6}, {52, -52}}, lineColor = {0, 0, 0}, textString = "T s + 1"), Line(points = {{-50, 0}, {50, 0}}, color = {0, 0, 0}), Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end Derivative;

      block FirstOrder "First order transfer function block (= 1 pole)"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Gain";
        parameter SIunits.Time T(start = 1) "Time Constant";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3/4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial or guess value of output (= state)" annotation(
          Dialog(group = "Initialization"));
        extends Interfaces.SISO(y(start = y_start));
      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(y) = (k * u - y) / T;
        annotation(
          Documentation(info = "<HTML>
<p>
This blocks defines the transfer function between the input u
and the output y (element-wise) as <i>first order</i> system:
</p>
<pre>
               k
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a first order SISO system with parameters<br>
b = {k}, a = {T, 1}.
</p>
<pre>
Example:
   parameter: k = 0.3, T = 0.4
   results in:
             0.3
      y = ----------- * u
          0.4 s + 1.0
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Line(visible = true, origin = {-26.667, 6.667}, points = {{106.667, 43.333}, {-13.333, 29.333}, {-53.333, -86.667}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(visible = true, lineColor = {192, 192, 192}, extent = {{0.0, -60.0}, {60.0, 0.0}}, textString = "PT1"), Text(visible = true, extent = {{-150.0, -150.0}, {150.0, -110.0}}, textString = "T=%T")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-48, 52}, {50, 8}}, lineColor = {0, 0, 0}, textString = "k"), Text(extent = {{-54, -6}, {56, -56}}, lineColor = {0, 0, 0}, textString = "T s + 1"), Line(points = {{-50, 0}, {50, 0}}, color = {0, 0, 0}), Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end FirstOrder;

      block SecondOrder "Second order transfer function block (= 2 poles)"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Gain";
        parameter Real w(start = 1) "Angular frequency";
        parameter Real D(start = 1) "Damping";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3/4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial or guess value of output (= state)" annotation(
          Dialog(group = "Initialization"));
        parameter Real yd_start = 0 "Initial or guess value of derivative of output (= state)" annotation(
          Dialog(group = "Initialization"));
        extends Interfaces.SISO(y(start = y_start));
        output Real yd(start = yd_start) "Derivative of y";
      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
          der(yd) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
          yd = yd_start;
        end if;
      equation
        der(y) = yd;
        der(yd) = w * (w * (k * u - y) - 2 * D * yd);
        annotation(
          Documentation(info = "<HTML>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>second order</i> system:
</p>
<pre>
                             k
     y = ---------------------------------------- * u
            ( s / w )^2 + 2*D*( s / w ) + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a second order SISO system with parameters<br>
b = {k}, a = {1/w^2, 2*D/w, 1}.
</p>
<pre>
Example:

   parameter: k =  0.3,  w = 0.5,  D = 0.4
   results in:
                  0.3
      y = ------------------- * u
          4.0 s^2 + 1.6 s + 1
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Line(visible = true, origin = {-1.939, -1.816}, points = {{81.939, 36.056}, {65.362, 36.056}, {14.39, -26.199}, {-29.966, 113.485}, {-65.374, -61.217}, {-78.061, -78.184}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(visible = true, lineColor = {192, 192, 192}, extent = {{0.0, -70.0}, {60.0, -10.0}}, textString = "PT2"), Text(visible = true, extent = {{-150.0, -150.0}, {150.0, -110.0}}, textString = "w=%w")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-60, 60}, {60, 14}}, lineColor = {0, 0, 0}, textString = "k"), Text(extent = {{-60, 8}, {-32, -20}}, lineColor = {0, 0, 0}, textString = "s"), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-50, 14}, {50, 14}}, color = {0, 0, 0}), Line(points = {{-54, -20}, {-38, -20}}, color = {0, 0, 0}), Text(extent = {{-52, -26}, {-36, -48}}, lineColor = {0, 0, 0}, textString = "w"), Line(points = {{-50, 2}, {-56, -8}, {-56, -28}, {-52, -46}}, color = {0, 0, 0}), Line(points = {{-40, 2}, {-34, -10}, {-34, -30}, {-38, -46}}, color = {0, 0, 0}), Text(extent = {{-34, 8}, {-22, -10}}, lineColor = {0, 0, 0}, textString = "2"), Text(extent = {{-34, -6}, {6, -36}}, lineColor = {0, 0, 0}, textString = "+2D"), Text(extent = {{2, 8}, {30, -20}}, lineColor = {0, 0, 0}, textString = "s"), Line(points = {{8, -20}, {24, -20}}, color = {0, 0, 0}), Text(extent = {{10, -26}, {26, -48}}, lineColor = {0, 0, 0}, textString = "w"), Line(points = {{12, 2}, {6, -8}, {6, -28}, {10, -46}}, color = {0, 0, 0}), Line(points = {{22, 2}, {28, -10}, {28, -30}, {24, -46}}, color = {0, 0, 0}), Text(extent = {{30, 2}, {58, -42}}, lineColor = {0, 0, 0}, textString = "+1")}));
      end SecondOrder;

      block PI "Proportional-Integral controller"
        import Modelica.Blocks.Types.Init;
        parameter Real k(unit = "1") = 1 "Gain";
        parameter SIunits.Time T(start = 1, min = Modelica.Constants.small) "Time Constant (T>0 required)";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x_start = 0 "Initial or guess value of state" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial value of output" annotation(
          Dialog(enable = initType == Init.SteadyState or initType == Init.InitialOutput, group = "Initialization"));
        extends Interfaces.SISO;
        output Real x(start = x_start) "State of block";
      initial equation
        if initType == Init.SteadyState then
          der(x) = 0;
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(x) = u / T;
        y = k * (x + u);
        annotation(
          defaultComponentName = "PI",
          Documentation(info = "<html>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>PI</i> system:
</p>
<pre>
                 1
   y = k * (1 + ---) * u
                T*s
           T*s + 1
     = k * ------- * u
             T*s
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a PI SISO system with parameters<br>
b = {k*T, k}, a = {T, 0}.
</p>
<pre>
Example:

   parameter: k = 0.3,  T = 0.4

   results in:
               0.4 s + 1
      y = 0.3 ----------- * u
                 0.4 s
</pre>

<p>
It might be difficult to initialize the PI component in steady state
due to the integrator part.
This is discussed in the description of package
<a href=\"modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 78}, {-80, -90}}, color = {192, 192, 192}), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, -80}, {82, -80}}, color = {192, 192, 192}), Polygon(points = {{90, -80}, {68, -72}, {68, -88}, {90, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80.0, -80.0}, {-80.0, -20.0}, {60.0, 80.0}}, color = {0, 0, 127}), Text(extent = {{0, 6}, {60, -56}}, lineColor = {192, 192, 192}, textString = "PI"), Text(extent = {{-150, -150}, {150, -110}}, lineColor = {0, 0, 0}, textString = "T=%T")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-68, 24}, {-24, -18}}, lineColor = {0, 0, 0}, textString = "k"), Text(extent = {{-32, 48}, {60, 0}}, lineColor = {0, 0, 0}, textString = "T s + 1"), Text(extent = {{-30, -8}, {52, -40}}, lineColor = {0, 0, 0}, textString = "T s"), Line(points = {{-24, 0}, {54, 0}}, color = {0, 0, 0}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{62, 0}, {100, 0}}, color = {0, 0, 255})}));
      end PI;

      block PID "PID-controller in additive description form"
        import Modelica.Blocks.Types.InitPID;
        import Modelica.Blocks.Types.Init;
        extends Interfaces.SISO;
        parameter Real k(unit = "1") = 1 "Gain";
        parameter SIunits.Time Ti(min = Modelica.Constants.small, start = 0.5) "Time Constant of Integrator";
        parameter SIunits.Time Td(min = 0, start = 0.1) "Time Constant of Derivative block";
        parameter Real Nd(min = Modelica.Constants.small) = 10 "The higher Nd, the more ideal the derivative block";
        parameter Modelica.Blocks.Types.InitPID initType = Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real xi_start = 0 "Initial or guess value value for integrator output (= integrator state)" annotation(
          Dialog(group = "Initialization"));
        parameter Real xd_start = 0 "Initial or guess value for state of derivative block" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial value of output" annotation(
          Dialog(enable = initType == InitPID.InitialOutput, group = "Initialization"));
        constant SI.Time unitTime = 1 annotation(
          HideResult = true);
        Blocks.Math.Gain P(k = 1) "Proportional part of PID controller" annotation(
          Placement(transformation(extent = {{-60, 60}, {-20, 100}}, rotation = 0)));
        Blocks.Continuous.Integrator I(k = unitTime / Ti, y_start = xi_start, initType = if initType == InitPID.SteadyState then Init.SteadyState else if initType == InitPID.InitialState or initType == InitPID.DoNotUse_InitialIntegratorState then Init.InitialState else Init.NoInit) "Integral part of PID controller" annotation(
          Placement(transformation(extent = {{-60, -20}, {-20, 20}}, rotation = 0)));
        Blocks.Continuous.Derivative D(k = Td / unitTime, T = max([Td / Nd, 100 * Modelica.Constants.eps]), x_start = xd_start, initType = if initType == InitPID.SteadyState or initType == InitPID.InitialOutput then Init.SteadyState else if initType == InitPID.InitialState then Init.InitialState else Init.NoInit) "Derivative part of PID controller" annotation(
          Placement(transformation(extent = {{-60, -100}, {-20, -60}}, rotation = 0)));
        Blocks.Math.Gain Gain(k = k) "Gain of PID controller" annotation(
          Placement(transformation(extent = {{60, -10}, {80, 10}}, rotation = 0)));
        Blocks.Math.Add3 Add annotation(
          Placement(transformation(extent = {{20, -10}, {40, 10}}, rotation = 0)));
      initial equation
        if initType == InitPID.InitialOutput then
          y = y_start;
        end if;
      equation
        connect(u, P.u) annotation(
          Line(points = {{-120, 0}, {-80, 0}, {-80, 80}, {-64, 80}}, color = {0, 0, 127}));
        connect(u, I.u) annotation(
          Line(points = {{-120, 0}, {-64, 0}}, color = {0, 0, 127}));
        connect(u, D.u) annotation(
          Line(points = {{-120, 0}, {-80, 0}, {-80, -80}, {-64, -80}}, color = {0, 0, 127}));
        connect(P.y, Add.u1) annotation(
          Line(points = {{-18, 80}, {0, 80}, {0, 8}, {18, 8}}, color = {0, 0, 127}));
        connect(I.y, Add.u2) annotation(
          Line(points = {{-18, 0}, {18, 0}}, color = {0, 0, 127}));
        connect(D.y, Add.u3) annotation(
          Line(points = {{-18, -80}, {0, -80}, {0, -8}, {18, -8}}, color = {0, 0, 127}));
        connect(Add.y, Gain.u) annotation(
          Line(points = {{41, 0}, {58, 0}}, color = {0, 0, 127}));
        connect(Gain.y, y) annotation(
          Line(points = {{81, 0}, {110, 0}}, color = {0, 0, 127}));
        annotation(
          defaultComponentName = "PID",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Line(visible = true, points = {{-80, -80}, {-80, -20}, {60, 80}}, color = {0, 0, 127}), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-20.0, -60.0}, {80.0, -20.0}}, textString = "PID"), Text(visible = true, extent = {{-150.0, -150.0}, {150.0, -110.0}}, textString = "Ti=%Ti")}),
          Documentation(info = "<HTML>
<p>
This is the text-book version of a PID-controller.
For a more practically useful PID-controller, use
block LimPID.
</p>

<p>
The PID block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to
<a href=\"modelica://Modelica.Blocks.Types.Init\">Types.Init</a>,
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>

<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>

  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>

  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>

  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>

<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the
equation of the integrator:
</p>

<pre>
   <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u or the variable that is used
to compute u by an algebraic equation.
</p>

</html>"));
      end PID;

      block LimPID "P, PI, PD, and PID controller with limited output, anti-windup compensation and setpoint weighting"
        import Modelica.Blocks.Types.InitPID;
        import Modelica.Blocks.Types.Init;
        import Modelica.Blocks.Types.SimpleController;
        extends Interfaces.SVcontrol;
        output Real controlError = u_s - u_m "Control error (set point - measurement)";
        parameter .Modelica.Blocks.Types.SimpleController controllerType = .Modelica.Blocks.Types.SimpleController.PID "Type of controller";
        parameter Real k(min = 0, unit = "1") = 1 "Gain of controller";
        parameter SIunits.Time Ti(min = Modelica.Constants.small) = 0.5 "Time constant of Integrator block" annotation(
          Dialog(enable = controllerType == .Modelica.Blocks.Types.SimpleController.PI or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter SIunits.Time Td(min = 0) = 0.1 "Time constant of Derivative block" annotation(
          Dialog(enable = controllerType == .Modelica.Blocks.Types.SimpleController.PD or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter Real yMax(start = 1) "Upper limit of output";
        parameter Real yMin = -yMax "Lower limit of output";
        parameter Real wp(min = 0) = 1 "Set-point weight for Proportional block (0..1)";
        parameter Real wd(min = 0) = 0 "Set-point weight for Derivative block (0..1)" annotation(
          Dialog(enable = controllerType == .Modelica.Blocks.Types.SimpleController.PD or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter Real Ni(min = 100 * Modelica.Constants.eps) = 0.9 "Ni*Ti is time constant of anti-windup compensation" annotation(
          Dialog(enable = controllerType == .Modelica.Blocks.Types.SimpleController.PI or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter Real Nd(min = 100 * Modelica.Constants.eps) = 10 "The higher Nd, the more ideal the derivative block" annotation(
          Dialog(enable = controllerType == .Modelica.Blocks.Types.SimpleController.PD or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter .Modelica.Blocks.Types.InitPID initType = .Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Boolean limitsAtInit = true "= false, if limits are ignored during initialization" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real xi_start = 0 "Initial or guess value value for integrator output (= integrator state)" annotation(
          Dialog(group = "Initialization", enable = controllerType == .Modelica.Blocks.Types.SimpleController.PI or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter Real xd_start = 0 "Initial or guess value for state of derivative block" annotation(
          Dialog(group = "Initialization", enable = controllerType == .Modelica.Blocks.Types.SimpleController.PD or controllerType == .Modelica.Blocks.Types.SimpleController.PID));
        parameter Real y_start = 0 "Initial value of output" annotation(
          Dialog(enable = initType == .Modelica.Blocks.Types.InitPID.InitialOutput, group = "Initialization"));
        parameter Boolean strict = false "= true, if strict limits with noEvent(..)" annotation(
          Evaluate = true,
          choices(checkBox = true),
          Dialog(tab = "Advanced"));
        constant SI.Time unitTime = 1 annotation(
          HideResult = true);
        Blocks.Math.Add addP(k1 = wp, k2 = -1) annotation(
          Placement(transformation(extent = {{-80, 40}, {-60, 60}}, rotation = 0)));
        Blocks.Math.Add addD(k1 = wd, k2 = -1) if with_D annotation(
          Placement(transformation(extent = {{-80, -10}, {-60, 10}}, rotation = 0)));
        Blocks.Math.Gain P(k = 1) annotation(
          Placement(transformation(extent = {{-40, 40}, {-20, 60}}, rotation = 0)));
        Blocks.Continuous.Integrator I(k = unitTime / Ti, y_start = xi_start, initType = if initType == InitPID.SteadyState then Init.SteadyState else if initType == InitPID.InitialState or initType == InitPID.DoNotUse_InitialIntegratorState then Init.InitialState else Init.NoInit) if with_I annotation(
          Placement(transformation(extent = {{-40, -60}, {-20, -40}}, rotation = 0)));
        Blocks.Continuous.Derivative D(k = Td / unitTime, T = max([Td / Nd, 1.e-14]), x_start = xd_start, initType = if initType == InitPID.SteadyState or initType == InitPID.InitialOutput then Init.SteadyState else if initType == InitPID.InitialState then Init.InitialState else Init.NoInit) if with_D annotation(
          Placement(transformation(extent = {{-40, -10}, {-20, 10}}, rotation = 0)));
        Blocks.Math.Gain gainPID(k = k) annotation(
          Placement(transformation(extent = {{30, -10}, {50, 10}}, rotation = 0)));
        Blocks.Math.Add3 addPID annotation(
          Placement(transformation(extent = {{0, -10}, {20, 10}}, rotation = 0)));
        Blocks.Math.Add3 addI(k2 = -1) if with_I annotation(
          Placement(transformation(extent = {{-80, -60}, {-60, -40}}, rotation = 0)));
        Blocks.Math.Add addSat(k1 = +1, k2 = -1) if with_I annotation(
          Placement(transformation(origin = {80, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Blocks.Math.Gain gainTrack(k = 1 / (k * Ni)) if with_I annotation(
          Placement(transformation(extent = {{40, -80}, {20, -60}}, rotation = 0)));
        Blocks.Nonlinear.Limiter limiter(uMax = yMax, uMin = yMin, strict = strict, limitsAtInit = limitsAtInit) annotation(
          Placement(transformation(extent = {{70, -10}, {90, 10}}, rotation = 0)));
      protected
        parameter Boolean with_I = controllerType == SimpleController.PI or controllerType == SimpleController.PID annotation(
          Evaluate = true,
          HideResult = true);
        parameter Boolean with_D = controllerType == SimpleController.PD or controllerType == SimpleController.PID annotation(
          Evaluate = true,
          HideResult = true);
      public
        Sources.Constant Dzero(k = 0) if not with_D annotation(
          Placement(transformation(extent = {{-30, 20}, {-20, 30}}, rotation = 0)));
        Sources.Constant Izero(k = 0) if not with_I annotation(
          Placement(transformation(extent = {{10, -55}, {0, -45}}, rotation = 0)));
      initial equation
        if initType == InitPID.InitialOutput then
          gainPID.y = y_start;
        end if;
      equation
        assert(yMax >= yMin, "LimPID: Limits must be consistent. However, yMax (=" + String(yMax) + ") < yMin (=" + String(yMin) + ")");
        if initType == InitPID.InitialOutput and (y_start < yMin or y_start > yMax) then
          Modelica.Utilities.Streams.error("LimPID: Start value y_start (=" + String(y_start) + ") is outside of the limits of yMin (=" + String(yMin) + ") and yMax (=" + String(yMax) + ")");
        end if;
        assert(limitsAtInit or not limitsAtInit and y >= yMin and y <= yMax, "LimPID: During initialization the limits have been switched off.\n" + "After initialization, the output y (=" + String(y) + ") is outside of the limits of yMin (=" + String(yMin) + ") and yMax (=" + String(yMax) + ")");
        connect(u_s, addP.u1) annotation(
          Line(points = {{-120, 0}, {-96, 0}, {-96, 56}, {-82, 56}}, color = {0, 0, 127}));
        connect(u_s, addD.u1) annotation(
          Line(points = {{-120, 0}, {-96, 0}, {-96, 6}, {-82, 6}}, color = {0, 0, 127}));
        connect(u_s, addI.u1) annotation(
          Line(points = {{-120, 0}, {-96, 0}, {-96, -42}, {-82, -42}}, color = {0, 0, 127}));
        connect(addP.y, P.u) annotation(
          Line(points = {{-59, 50}, {-42, 50}}, color = {0, 0, 127}));
        connect(addD.y, D.u) annotation(
          Line(points = {{-59, 0}, {-42, 0}}, color = {0, 0, 127}));
        connect(addI.y, I.u) annotation(
          Line(points = {{-59, -50}, {-42, -50}}, color = {0, 0, 127}));
        connect(P.y, addPID.u1) annotation(
          Line(points = {{-19, 50}, {-10, 50}, {-10, 8}, {-2, 8}}, color = {0, 0, 127}));
        connect(D.y, addPID.u2) annotation(
          Line(points = {{-19, 0}, {-2, 0}}, color = {0, 0, 127}));
        connect(I.y, addPID.u3) annotation(
          Line(points = {{-19, -50}, {-10, -50}, {-10, -8}, {-2, -8}}, color = {0, 0, 127}));
        connect(addPID.y, gainPID.u) annotation(
          Line(points = {{21, 0}, {28, 0}}, color = {0, 0, 127}));
        connect(gainPID.y, addSat.u2) annotation(
          Line(points = {{51, 0}, {60, 0}, {60, -20}, {74, -20}, {74, -38}}, color = {0, 0, 127}));
        connect(gainPID.y, limiter.u) annotation(
          Line(points = {{51, 0}, {68, 0}}, color = {0, 0, 127}));
        connect(limiter.y, addSat.u1) annotation(
          Line(points = {{91, 0}, {94, 0}, {94, -20}, {86, -20}, {86, -38}}, color = {0, 0, 127}));
        connect(limiter.y, y) annotation(
          Line(points = {{91, 0}, {110, 0}}, color = {0, 0, 127}));
        connect(addSat.y, gainTrack.u) annotation(
          Line(points = {{80, -61}, {80, -70}, {42, -70}}, color = {0, 0, 127}));
        connect(gainTrack.y, addI.u3) annotation(
          Line(points = {{19, -70}, {-88, -70}, {-88, -58}, {-82, -58}}, color = {0, 0, 127}));
        connect(u_m, addP.u2) annotation(
          Line(points = {{0, -120}, {0, -92}, {-92, -92}, {-92, 44}, {-82, 44}}, color = {0, 0, 127}, thickness = 0.5));
        connect(u_m, addD.u2) annotation(
          Line(points = {{0, -120}, {0, -92}, {-92, -92}, {-92, -6}, {-82, -6}}, color = {0, 0, 127}, thickness = 0.5));
        connect(u_m, addI.u2) annotation(
          Line(points = {{0, -120}, {0, -92}, {-92, -92}, {-92, -50}, {-82, -50}}, color = {0, 0, 127}, thickness = 0.5));
        connect(Dzero.y, addPID.u2) annotation(
          Line(points = {{-19.5, 25}, {-14, 25}, {-14, 0}, {-2, 0}}, color = {0, 0, 127}));
        connect(Izero.y, addPID.u3) annotation(
          Line(points = {{-0.5, -50}, {-10, -50}, {-10, -8}, {-2, -8}}, color = {0, 0, 127}));
        annotation(
          defaultComponentName = "PID",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 78}, {-80, -90}}, color = {192, 192, 192}), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, -80}, {82, -80}}, color = {192, 192, 192}), Polygon(points = {{90, -80}, {68, -72}, {68, -88}, {90, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-80, -20}, {30, 60}, {80, 60}}, color = {0, 0, 127}), Text(extent = {{-20, -20}, {80, -60}}, lineColor = {192, 192, 192}, textString = "%controllerType"), Line(visible = strict, points = {{30, 60}, {81, 60}}, color = {255, 0, 0}, smooth = Smooth.None)}),
          Documentation(info = "<HTML>
<p>
Via parameter <b>controllerType</b> either <b>P</b>, <b>PI</b>, <b>PD</b>,
or <b>PID</b> can be selected. If, e.g., PI is selected, all components belonging to the
D-part are removed from the block (via conditional declarations).
The example model
<a href=\"modelica://Modelica.Blocks.Examples.PID_Controller\">Modelica.Blocks.Examples.PID_Controller</a>
demonstrates the usage of this controller.
Several practical aspects of PID controller design are incorporated
according to chapter 3 of the book:
</p>

<dl>
<dt>&Aring;str&ouml;m K.J., and H&auml;gglund T.:</dt>
<dd> <b>PID Controllers: Theory, Design, and Tuning</b>.
     Instrument Society of America, 2nd edition, 1995.
</dd>
</dl>

<p>
Besides the additive <b>proportional, integral</b> and <b>derivative</b>
part of this controller, the following features are present:
</p>
<ul>
<li> The output of this controller is limited. If the controller is
     in its limits, anti-windup compensation is activated to drive
     the integrator state to zero. </li>
<li> The high-frequency gain of the derivative part is limited
     to avoid excessive amplification of measurement noise.</li>
<li> Setpoint weighting is present, which allows to weight
     the setpoint in the proportional and the derivative part
     independently from the measurement. The controller will respond
     to load disturbances and measurement noise independently of this setting
     (parameters wp, wd). However, setpoint changes will depend on this
     setting. For example, it is useful to set the setpoint weight wd
     for the derivative part to zero, if steps may occur in the
     setpoint signal.</li>
</ul>

<p>
The parameters of the controller can be manually adjusted by performing
simulations of the closed loop system (= controller + plant connected
together) and using the following strategy:
</p>

<ol>
<li> Set very large limits, e.g., yMax = Modelica.Constants.inf</li>
<li> Select a <b>P</b>-controller and manually enlarge parameter <b>k</b>
     (the total gain of the controller) until the closed-loop response
     cannot be improved any more.</li>
<li> Select a <b>PI</b>-controller and manually adjust parameters
     <b>k</b> and <b>Ti</b> (the time constant of the integrator).
     The first value of Ti can be selected, such that it is in the
     order of the time constant of the oscillations occurring with
     the P-controller. If, e.g., vibrations in the order of T=10 ms
     occur in the previous step, start with Ti=0.01 s.</li>
<li> If you want to make the reaction of the control loop faster
     (but probably less robust against disturbances and measurement noise)
     select a <b>PID</b>-Controller and manually adjust parameters
     <b>k</b>, <b>Ti</b>, <b>Td</b> (time constant of derivative block).</li>
<li> Set the limits yMax and yMin according to your specification.</li>
<li> Perform simulations such that the output of the PID controller
     goes in its limits. Tune <b>Ni</b> (Ni*Ti is the time constant of
     the anti-windup compensation) such that the input to the limiter
     block (= limiter.u) goes quickly enough back to its limits.
     If Ni is decreased, this happens faster. If Ni=infinity, the
     anti-windup compensation is switched off and the controller works bad.</li>
</ol>

<p>
<b>Initialization</b>
</p>

<p>
This block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to
<a href=\"modelica://Modelica.Blocks.Types.Init\">Types.Init</a>,
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>

<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>

  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>

  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>

  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>

  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>

<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the
equation of the integrator:
</p>

<pre>
   <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u_m or the variable that is used
to compute u_m by an algebraic equation.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits at the
output of this controller block are removed from the initialization problem which
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</html>"));
      end LimPID;

      block TransferFunction "Linear transfer function"
        import Modelica.Blocks.Types.Init;
        extends Interfaces.SISO;
        parameter Real b[:] = {1} "Numerator coefficients of transfer function (e.g., 2*s+3 is specified as {2,3})";
        parameter Real a[:] = {1} "Denominator coefficients of transfer function (e.g., 5*s+6 is specified as {5,6})";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x_start[size(a, 1) - 1] = zeros(nx) "Initial or guess values of states" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0 "Initial value of output (derivatives of y are zero upto nx-1-th derivative)" annotation(
          Dialog(enable = initType == Init.InitialOutput, group = "Initialization"));
        output Real x[size(a, 1) - 1](start = x_start) "State of transfer function from controller canonical form";
      protected
        parameter Integer na = size(a, 1) "Size of Denominator of transfer function.";
        parameter Integer nb = size(b, 1) "Size of Numerator of transfer function.";
        parameter Integer nx = size(a, 1) - 1;
        parameter Real bb[:] = vector([zeros(max(0, na - nb), 1); b]);
        parameter Real d = bb[1] / a[1];
        parameter Real a_end = if a[end] > 100 * Modelica.Constants.eps * sqrt(a * a) then a[end] else 1.0;
        Real x_scaled[size(x, 1)] "Scaled vector x";
      initial equation
        if initType == Init.SteadyState then
          der(x_scaled) = zeros(nx);
        elseif initType == Init.InitialState then
          x_scaled = x_start * a_end;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x_scaled[2:nx]) = zeros(nx - 1);
        end if;
      equation
        assert(size(b, 1) <= size(a, 1), "Transfer function is not proper");
        if nx == 0 then
          y = d * u;
        else
          der(x_scaled[1]) = ((-a[2:na] * x_scaled) + a_end * u) / a[1];
          der(x_scaled[2:nx]) = x_scaled[1:nx - 1];
          y = (bb[2:na] - d * a[2:na]) * x_scaled / a_end + d * u;
          x = x_scaled / a_end;
        end if;
        annotation(
          Documentation(info = "<html>
<p>
This block defines the transfer function between the input
u and the output y
as (nb = dimension of b, na = dimension of a):
</p>
<pre>
           b[1]*s^[nb-1] + b[2]*s^[nb-2] + ... + b[nb]
   y(s) = --------------------------------------------- * u(s)
           a[1]*s^[na-1] + a[2]*s^[na-2] + ... + a[na]
</pre>
<p>
State variables <b>x</b> are defined according to <b>controller canonical</b>
form. Internally, vector <b>x</b> is scaled to improve the numerics (the states in versions before version 3.0 of the Modelica Standard Library have been not scaled). This scaling is
not visible from the outside of this block because the non-scaled vector <b>x</b>
is provided as output signal and the start value is with respect to the non-scaled
vector <b>x</b>.
Initial values of the states <b>x</b> can be set via parameter <b>x_start</b>.
</p>

<p>
Example:
</p>
<pre>
     TransferFunction g(b = {2,4}, a = {1,3});
</pre>
<p>
results in the following transfer function:
</p>
<pre>
        2*s + 4
   y = --------- * u
         s + 3
</pre>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 0.0}, {80.0, 0.0}}, color = {0, 0, 127}), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-90.0, 10.0}, {90.0, 90.0}}, textString = "b(s)"), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-90.0, -90.0}, {90.0, -10.0}}, textString = "a(s)")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{40, 0}, {-40, 0}}, color = {0, 0, 0}), Text(extent = {{-55, 55}, {55, 5}}, lineColor = {0, 0, 0}, textString = "b(s)"), Text(extent = {{-55, -5}, {55, -55}}, lineColor = {0, 0, 0}, textString = "a(s)"), Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end TransferFunction;

      block StateSpace "Linear state space system"
        import Modelica.Blocks.Types.Init;
        parameter Real A[:, size(A, 1)] = [1, 0; 0, 1] "Matrix A of state space model (e.g., A=[1, 0; 0, 1])";
        parameter Real B[size(A, 1), :] = [1; 1] "Matrix B of state space model (e.g., B=[1; 1])";
        parameter Real C[:, size(A, 1)] = [1, 1] "Matrix C of state space model (e.g., C=[1, 1])";
        parameter Real D[size(C, 1), size(B, 2)] = zeros(size(C, 1), size(B, 2)) "Matrix D of state space model";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x_start[nx] = zeros(nx) "Initial or guess values of states" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start[ny] = zeros(ny) "Initial values of outputs (remaining states are in steady state if possible)" annotation(
          Dialog(enable = initType == Init.InitialOutput, group = "Initialization"));
        extends Interfaces.MIMO(final nin = size(B, 2), final nout = size(C, 1));
        output Real x[size(A, 1)](start = x_start) "State vector";
      protected
        parameter Integer nx = size(A, 1) "number of states";
        parameter Integer ny = size(C, 1) "number of outputs";
      initial equation
        if initType == Init.SteadyState then
          der(x) = zeros(nx);
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          x = Modelica.Math.Matrices.equalityLeastSquares(A, -B * u, C, y_start - D * u);
        end if;
      equation
        der(x) = A * x + B * u;
        y = C * x + D * u;
        annotation(
          Documentation(info = "<HTML>
<p>
The State Space block defines the relation
between the input u and the output
y in state space form:
</p>
<pre>

    der(x) = A * x + B * u
        y  = C * x + D * u
</pre>
<p>
The input is a vector of length nu, the output is a vector
of length ny and nx is the number of states. Accordingly
</p>
<pre>
        A has the dimension: A(nx,nx),
        B has the dimension: B(nx,nu),
        C has the dimension: C(ny,nx),
        D has the dimension: D(ny,nu)
</pre>
<p>
Example:
</p>
<pre>
     parameter: A = [0.12, 2;3, 1.5]
     parameter: B = [2, 7;3, 1]
     parameter: C = [0.1, 2]
     parameter: D = zeros(ny,nu)
results in the following equations:
  [der(x[1])]   [0.12  2.00] [x[1]]   [2.0  7.0] [u[1]]
  [         ] = [          ]*[    ] + [        ]*[    ]
  [der(x[2])]   [3.00  1.50] [x[2]]   [0.1  2.0] [u[2]]
                             [x[1]]            [u[1]]
       y[1]   = [0.1  2.0] * [    ] + [0  0] * [    ]
                             [x[2]]            [u[2]]
</pre>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 10}, {-10, 90}}, textString = "A", lineColor = {0, 0, 127}), Text(extent = {{10, 10}, {90, 90}}, textString = "B", lineColor = {0, 0, 127}), Text(extent = {{-90, -10}, {-10, -90}}, textString = "C", lineColor = {0, 0, 127}), Text(extent = {{10, -10}, {90, -90}}, textString = "D", lineColor = {0, 0, 127}), Line(points = {{0, -90}, {0, 90}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {90, 0}}, color = {192, 192, 192})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-60, 40}, {60, 0}}, lineColor = {0, 0, 0}, textString = "sx=Ax+Bu"), Text(extent = {{-60, 0}, {60, -40}}, lineColor = {0, 0, 0}, textString = " y=Cx+Du"), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end StateSpace;

      block Der "Derivative of input (= analytic differentiations)"
        extends Interfaces.SISO;
      equation
        y = der(u);
        annotation(
          defaultComponentName = "der1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-96, 28}, {94, -24}}, textString = "der()", lineColor = {0, 0, 127})}),
          Documentation(info = "<HTML>
<p>
Defines that the output y is the <i>derivative</i>
of the input u. Note, that Modelica.Blocks.Continuous.Derivative
computes the derivative in an approximate sense, where as this block computes
the derivative exactly. This requires that the input u is differentiated
by the Modelica translator, if this derivative is not yet present in
the model.
</p>
</HTML>"));
      end Der;

      block LowpassButterworth "Output the input signal filtered with a low pass Butterworth filter of any order"
        import Modelica.Blocks.Types.Init;
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Integer n(min = 1) = 2 "Order of filter";
        parameter SI.Frequency f(start = 1) "Cut-off frequency";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x1_start[m] = zeros(m) "Initial or guess values of states 1 (der(x1)=x2)" annotation(
          Dialog(group = "Initialization"));
        parameter Real x2_start[m] = zeros(m) "Initial or guess values of states 2" annotation(
          Dialog(group = "Initialization"));
        parameter Real xr_start = 0.0 "Initial or guess value of real pole for uneven order otherwise dummy" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0.0 "Initial value of output (states are initialized in steady state if possible)" annotation(
          Dialog(enable = initType == Init.InitialOutput, group = "Initialization"));
        output Real x1[m](start = x1_start) "states 1 of second order filters (der(x1) = x2)";
        output Real x2[m](start = x2_start) "states 2 of second order filters";
        output Real xr(start = xr_start) "state of real pole for uneven order otherwise dummy";
      protected
        constant Real pi = Modelica.Constants.pi;
        parameter Integer m = integer(n / 2);
        parameter Boolean evenOrder = 2 * m == n;
        parameter Real w = 2 * pi * f;
        Real z[m + 1];
        Real polereal[m];
        Real poleimag[m];
        Real realpol;
        Real k2[m];
        Real D[m];
        Real w0[m];
        Real k1;
        Real T;
      initial equation
        if initType == Init.SteadyState then
          der(x1) = zeros(m);
          der(x2) = zeros(m);
          if not evenOrder then
            der(xr) = 0.0;
          end if;
        elseif initType == Init.InitialState then
          x1 = x1_start;
          x2 = x2_start;
          if not evenOrder then
            xr = xr_start;
          end if;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x1) = zeros(m);
          if evenOrder then
            if m > 1 then
              der(x2[1:m - 1]) = zeros(m - 1);
            end if;
          else
            der(x1) = zeros(m);
          end if;
        end if;
      equation
        k2 = ones(m);
        k1 = 1;
        z[1] = u;
// calculate filter parameters
        for i in 1:m loop
// poles of prototype lowpass
          polereal[i] = cos(pi / 2 + pi / n * (i - 0.5));
          poleimag[i] = sin(pi / 2 + pi / n * (i - 0.5));
// scaling and calculation of second order filter coefficients
          w0[i] = (polereal[i] ^ 2 + poleimag[i] ^ 2) * w;
          D[i] = -polereal[i] / w0[i] * w;
        end for;
        realpol = 1 * w;
        T = 1 / realpol;
// calculate second order filters
        for i in 1:m loop
          der(x1[i]) = x2[i];
          der(x2[i]) = k2[i] * w0[i] ^ 2 * z[i] - 2 * D[i] * w0[i] * x2[i] - w0[i] ^ 2 * x1[i];
          z[i + 1] = x1[i];
        end for;
// calculate first order filter if necessary
        if evenOrder then
// even order
          xr = 0;
          y = z[m + 1];
        else
// uneven order
          der(xr) = (k1 * z[m + 1] - xr) / T;
          y = xr;
        end if;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 78.0}, {-80.0, -90.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-79.5584, 91.817}, {-87.5584, 69.817}, {-71.5584, 69.817}, {-79.5584, 91.817}}), Line(visible = true, origin = {-1.939, -1.816}, points = {{81.939, 36.056}, {65.362, 36.056}, {14.39, -26.199}, {-29.966, 113.485}, {-65.374, -61.217}, {-78.061, -78.184}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Line(visible = true, points = {{-90.9779, -80.7697}, {81.0221, -80.7697}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{91.3375, -79.8233}, {69.3375, -71.8233}, {69.3375, -87.8233}, {91.3375, -79.8233}}), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-45.1735, -68.0}, {92.0, -11.47}}, textString = "LowpassButterworthFilter"), Text(visible = true, extent = {{8.0, -146.0}, {8.0, -106.0}}, textString = "f=%f"), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-2.0, 48.0}, {94.0, 94.0}}, textString = "%n")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{40, 0}, {-40, 0}}, color = {0, 0, 0}), Text(extent = {{-55, 55}, {55, 5}}, lineColor = {0, 0, 0}, textString = "1"), Text(extent = {{-55, -5}, {55, -55}}, lineColor = {0, 0, 0}, textString = "a(s)"), Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This block defines the transfer function between the input u
and the output y as an n-th order low pass filter with <i>Butterworth</i>
characteristics and cut-off frequency f. It is implemented as
a series of second order filters and a first order filter.
Butterworth filters have the feature that the amplitude at the
cut-off frequency f is 1/sqrt(2) (= 3 dB), i.e., they are
always \"normalized\". Step responses of the Butterworth filter of
different orders are shown in the next figure:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Butterworth.png\"
     alt=\"Butterworth.png\">
</p>

<p>
If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>

</html>"));
      end LowpassButterworth;

      block CriticalDamping "Output the input signal filtered with an n-th order filter with critical damping"
        import Modelica.Blocks.Types.Init;
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Integer n = 2 "Order of filter";
        parameter Modelica.SIunits.Frequency f(start = 1) "Cut-off frequency";
        parameter Boolean normalized = true "= true, if amplitude at f_cut is 3 dB, otherwise unmodified filter";
        parameter Modelica.Blocks.Types.Init initType = Modelica.Blocks.Types.Init.NoInit "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)" annotation(
          Evaluate = true,
          Dialog(group = "Initialization"));
        parameter Real x_start[n] = zeros(n) "Initial or guess values of states" annotation(
          Dialog(group = "Initialization"));
        parameter Real y_start = 0.0 "Initial value of output (remaining states are in steady state)" annotation(
          Dialog(enable = initType == Init.InitialOutput, group = "Initialization"));
        output Real x[n](start = x_start) "Filter states";
      protected
        parameter Real alpha = if normalized then sqrt(2 ^ (1 / n) - 1) else 1.0 "Frequency correction factor for normalized filter";
        parameter Real w = 2 * Modelica.Constants.pi * f / alpha;
      initial equation
        if initType == Init.SteadyState then
          der(x) = zeros(n);
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x[1:n - 1]) = zeros(n - 1);
        end if;
      equation
        der(x[1]) = (u - x[1]) * w;
        for i in 2:n loop
          der(x[i]) = (x[i - 1] - x[i]) * w;
        end for;
        y = x[n];
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.6897, 77.6256}, {-80.6897, -90.3744}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-79.7044, 90.6305}, {-87.7044, 68.6305}, {-71.7044, 68.6305}, {-79.7044, 90.6305}}), Line(visible = true, points = {{-90.0, -80.0}, {82.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -80.0}, {68.0, -72.0}, {68.0, -88.0}, {90.0, -80.0}}), Text(visible = true, lineColor = {192, 192, 192}, extent = {{0.0, -60.0}, {60.0, 0.0}}, textString = "PTn"), Line(visible = true, origin = {-17.976, -6.521}, points = {{96.962, 55.158}, {16.42, 50.489}, {-18.988, 18.583}, {-32.024, -53.479}, {-62.024, -73.479}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-70.0, 48.0}, {26.0, 94.0}}, textString = "%n"), Text(visible = true, extent = {{8.0, -146.0}, {8.0, -106.0}}, textString = "f=%f")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{40, 0}, {-40, 0}}, color = {0, 0, 0}), Text(extent = {{-55, 55}, {55, 5}}, lineColor = {0, 0, 0}, textString = "1"), Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255}), Text(extent = {{-54, -6}, {44, -56}}, lineColor = {0, 0, 0}, textString = "(s/w + 1)"), Text(extent = {{38, -10}, {58, -30}}, lineColor = {0, 0, 0}, textString = "n")}),
          Documentation(info = "<html>
<p>This block defines the transfer function between the
input u and the output y
as an n-th order filter with <i>critical damping</i>
characteristics and cut-off frequency f. It is
implemented as a series of first order filters.
This filter type is especially useful to filter the input of an
inverse model, since the filter does not introduce any transients.
</p>

<p>
If parameter <b>normalized</b> = <b>true</b> (default), the filter
is normalized such that the amplitude of the filter transfer function
at the cut-off frequency f is 1/sqrt(2) (= 3 dB). Otherwise, the filter
is not normalized, i.e., it is unmodified. A normalized filter is usually
much better for applications, since filters of different orders are
\"comparable\", whereas non-normalized filters usually require to adapt the
cut-off frequency, when the order of the filter is changed.
Figures of the filter step responses are shown below.
Note, in versions before version 3.0 of the Modelica Standard library,
the CriticalDamping filter was provided only in non-normalized form.
</p>

<p>If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>

<p>
The critical damping filter is defined as
</p>

<pre>
    &alpha; = <b>if</b> normalized <b>then</b> <b>sqrt</b>(2^(1/n) - 1) <b>else</b> 1 // frequency correction factor
    &omega; = 2*&pi;*f/&alpha;
              1
    y = ------------- * u
         (s/w + 1)^n

</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/CriticalDampingNormalized.png\"
     alt=\"CriticalDampingNormalized.png\">
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/CriticalDampingNonNormalized.png\"
     alt=\"CriticalDampingNonNormalized.png\">
</p>

</html>"));
      end CriticalDamping;

      block Filter "Continuous low pass, high pass, band pass or band stop IIR-filter of type CriticalDamping, Bessel, Butterworth or ChebyshevI"
        import Modelica.Blocks.Continuous.Internal;
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.Blocks.Types.AnalogFilter analogFilter = Modelica.Blocks.Types.AnalogFilter.CriticalDamping "Analog filter characteristics (CriticalDamping/Bessel/Butterworth/ChebyshevI)";
        parameter Modelica.Blocks.Types.FilterType filterType = Modelica.Blocks.Types.FilterType.LowPass "Type of filter (LowPass/HighPass/BandPass/BandStop)";
        parameter Integer order(min = 1) = 2 "Order of filter";
        parameter Modelica.SIunits.Frequency f_cut "Cut-off frequency";
        parameter Real gain = 1.0 "Gain (= amplitude of frequency response at zero frequency)";
        parameter Real A_ripple(unit = "dB") = 0.5 "Pass band ripple for Chebyshev filter (otherwise not used); > 0 required" annotation(
          Dialog(enable = analogFilter == Modelica.Blocks.Types.AnalogFilter.ChebyshevI));
        parameter Modelica.SIunits.Frequency f_min = 0 "Band of band pass/stop filter is f_min (A=-3db*gain) .. f_cut (A=-3db*gain)" annotation(
          Dialog(enable = filterType == Modelica.Blocks.Types.FilterType.BandPass or filterType == Modelica.Blocks.Types.FilterType.BandStop));
        parameter Boolean normalized = true "= true, if amplitude at f_cut = -3db, otherwise unmodified filter";
        parameter Modelica.Blocks.Types.Init init = Modelica.Blocks.Types.Init.SteadyState "Type of initialization (no init/steady state/initial state/initial output)" annotation(
          Evaluate = true,
          Dialog(tab = "Advanced"));
        final parameter Integer nx = if filterType == Modelica.Blocks.Types.FilterType.LowPass or filterType == Modelica.Blocks.Types.FilterType.HighPass then order else 2 * order;
        parameter Real x_start[nx] = zeros(nx) "Initial or guess values of states" annotation(
          Dialog(tab = "Advanced"));
        parameter Real y_start = 0 "Initial value of output" annotation(
          Dialog(tab = "Advanced"));
        parameter Real u_nominal = 1.0 "Nominal value of input (used for scaling the states)" annotation(
          Dialog(tab = "Advanced"));
        Modelica.Blocks.Interfaces.RealOutput x[nx] "Filter states";
      protected
        parameter Integer ncr = if analogFilter == Modelica.Blocks.Types.AnalogFilter.CriticalDamping then order else mod(order, 2);
        parameter Integer nc0 = if analogFilter == Modelica.Blocks.Types.AnalogFilter.CriticalDamping then 0 else integer(order / 2);
        parameter Integer na = if filterType == Modelica.Blocks.Types.FilterType.BandPass or filterType == Modelica.Blocks.Types.FilterType.BandStop then order else if analogFilter == Modelica.Blocks.Types.AnalogFilter.CriticalDamping then 0 else integer(order / 2);
        parameter Integer nr = if filterType == Modelica.Blocks.Types.FilterType.BandPass or filterType == Modelica.Blocks.Types.FilterType.BandStop then 0 else if analogFilter == Modelica.Blocks.Types.AnalogFilter.CriticalDamping then order else mod(order, 2);
        // Coefficients of prototype base filter (low pass filter with w_cut = 1 rad/s)
        parameter Real cr[ncr](each fixed = false);
        parameter Real c0[nc0](each fixed = false);
        parameter Real c1[nc0](each fixed = false);
        // Coefficients for differential equations.
        parameter Real r[nr](each fixed = false);
        parameter Real a[na](each fixed = false);
        parameter Real b[na](each fixed = false);
        parameter Real ku[na](each fixed = false);
        parameter Real k1[if filterType == Modelica.Blocks.Types.FilterType.LowPass then 0 else na](each fixed = false);
        parameter Real k2[if filterType == Modelica.Blocks.Types.FilterType.LowPass then 0 else na](each fixed = false);
        // Auxiliary variables
        Real uu[na + nr + 1];
      initial equation
        if analogFilter == Modelica.Blocks.Types.AnalogFilter.CriticalDamping then
          cr = Internal.Filter.base.CriticalDamping(order, normalized);
        elseif analogFilter == Modelica.Blocks.Types.AnalogFilter.Bessel then
          (cr, c0, c1) = Internal.Filter.base.Bessel(order, normalized);
        elseif analogFilter == Modelica.Blocks.Types.AnalogFilter.Butterworth then
          (cr, c0, c1) = Internal.Filter.base.Butterworth(order, normalized);
        elseif analogFilter == Modelica.Blocks.Types.AnalogFilter.ChebyshevI then
          (cr, c0, c1) = Internal.Filter.base.ChebyshevI(order, A_ripple, normalized);
        end if;
        if filterType == Modelica.Blocks.Types.FilterType.LowPass then
          (r, a, b, ku) = Internal.Filter.roots.lowPass(cr, c0, c1, f_cut);
        elseif filterType == Modelica.Blocks.Types.FilterType.HighPass then
          (r, a, b, ku, k1, k2) = Internal.Filter.roots.highPass(cr, c0, c1, f_cut);
        elseif filterType == Modelica.Blocks.Types.FilterType.BandPass then
          (a, b, ku, k1, k2) = Internal.Filter.roots.bandPass(cr, c0, c1, f_min, f_cut);
        elseif filterType == Modelica.Blocks.Types.FilterType.BandStop then
          (a, b, ku, k1, k2) = Internal.Filter.roots.bandStop(cr, c0, c1, f_min, f_cut);
        end if;
        if init == Modelica.Blocks.Types.Init.InitialState then
          x = x_start;
        elseif init == Modelica.Blocks.Types.Init.SteadyState then
          der(x) = zeros(nx);
        elseif init == Modelica.Blocks.Types.Init.InitialOutput then
          y = y_start;
          if nx > 1 then
            der(x[1:nx - 1]) = zeros(nx - 1);
          end if;
        end if;
      equation
        assert(u_nominal > 0, "u_nominal > 0 required");
        assert(filterType == Modelica.Blocks.Types.FilterType.LowPass or filterType == Modelica.Blocks.Types.FilterType.HighPass or f_min > 0, "f_min > 0 required for band pass and band stop filter");
        assert(A_ripple > 0, "A_ripple > 0 required");
        assert(f_cut > 0, "f_cut > 0 required");
/* All filters have the same basic differential equations:
        Real poles:
           der(x) = r*x - r*u
        Complex conjugate poles:
           der(x1) = a*x1 - b*x2 + ku*u;
           der(x2) = b*x1 + a*x2;
   */
        uu[1] = u / u_nominal;
        for i in 1:nr loop
          der(x[i]) = r[i] * (x[i] - uu[i]);
        end for;
        for i in 1:na loop
          der(x[nr + 2 * i - 1]) = a[i] * x[nr + 2 * i - 1] - b[i] * x[nr + 2 * i] + ku[i] * uu[nr + i];
          der(x[nr + 2 * i]) = b[i] * x[nr + 2 * i - 1] + a[i] * x[nr + 2 * i];
        end for;
// The output equation is different for the different filter types
        if filterType == Modelica.Blocks.Types.FilterType.LowPass then
/* Low pass filter
           Real poles             :  y = x
           Complex conjugate poles:  y = x2
      */
          for i in 1:nr loop
            uu[i + 1] = x[i];
          end for;
          for i in 1:na loop
            uu[nr + i + 1] = x[nr + 2 * i];
          end for;
        elseif filterType == Modelica.Blocks.Types.FilterType.HighPass then
/* High pass filter
           Real poles             :  y = -x + u;
           Complex conjugate poles:  y = k1*x1 + k2*x2 + u;
      */
          for i in 1:nr loop
            uu[i + 1] = (-x[i]) + uu[i];
          end for;
          for i in 1:na loop
            uu[nr + i + 1] = k1[i] * x[nr + 2 * i - 1] + k2[i] * x[nr + 2 * i] + uu[nr + i];
          end for;
        elseif filterType == Modelica.Blocks.Types.FilterType.BandPass then
/* Band pass filter
           Complex conjugate poles:  y = k1*x1 + k2*x2;
      */
          for i in 1:na loop
            uu[nr + i + 1] = k1[i] * x[nr + 2 * i - 1] + k2[i] * x[nr + 2 * i];
          end for;
        elseif filterType == Modelica.Blocks.Types.FilterType.BandStop then
/* Band pass filter
           Complex conjugate poles:  y = k1*x1 + k2*x2 + u;
      */
          for i in 1:na loop
            uu[nr + i + 1] = k1[i] * x[nr + 2 * i - 1] + k2[i] * x[nr + 2 * i] + uu[nr + i];
          end for;
        else
          assert(false, "filterType (= " + String(filterType) + ") is unknown");
          uu = zeros(na + nr + 1);
        end if;
        y = gain * u_nominal * uu[nr + na + 1];
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-80.0, 80.0}, {-80.0, -88.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 92.0}, {-88.0, 70.0}, {-72.0, 70.0}, {-80.0, 92.0}}), Line(visible = true, points = {{-90.0, -78.0}, {82.0, -78.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -78.0}, {68.0, -70.0}, {68.0, -86.0}, {90.0, -78.0}}), Text(visible = true, lineColor = {192, 192, 192}, extent = {{-66.0, 52.0}, {88.0, 90.0}}, textString = "%order"), Text(visible = true, fillPattern = FillPattern.Solid, extent = {{-138.0, -140.0}, {162.0, -110.0}}, textString = "f_cut=%f_cut"), Rectangle(visible = true, lineColor = {160, 160, 164}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Backward, extent = {{-80.0, -78.0}, {22.0, 10.0}}), Line(visible = true, origin = {3.333, -6.667}, points = {{-83.333, 34.667}, {24.667, 34.667}, {42.667, -71.333}}, color = {0, 0, 127}, smooth = Smooth.Bezier)}),
          Documentation(info = "<html>

<p>
This blocks models various types of filters:
</p>

<blockquote>
<b>low pass, high pass, band pass, and band stop filters</b>
</blockquote>

<p>
using various filter characteristics:
</p>

<blockquote>
<b>CriticalDamping, Bessel, Butterworth, Chebyshev Type I filters</b>
</blockquote>

<p>
By default, a filter block is initialized in <b>steady-state</b>, in order to
avoid unwanted oscillations at the beginning. In special cases, it might be
useful to select one of the other initialization options under tab
\"Advanced\".
</p>

<p>
Typical frequency responses for the 4 supported low pass filter types
are shown in the next figure:
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/LowPassOrder4Filters.png\"
     alt=\"LowPassOrder4Filters.png\">
</blockquote>

<p>
The step responses of the same low pass filters are shown in the next figure,
starting from a steady state initial filter with initial input = 0.2:
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/LowPassOrder4FiltersStepResponse.png\"
     alt=\"LowPassOrder4FiltersStepResponse.png\">
</blockquote>

<p>
Obviously, the frequency responses give a somewhat wrong impression
of the filter characteristics: Although Butterworth and Chebyshev
filters have a significantly steeper magnitude as the
CriticalDamping and Bessel filters, the step responses of
the latter ones are much better. This means for example, that
a CriticalDamping or a Bessel filter should be selected,
if a filter is mainly used to make a non-linear inverse model
realizable.
</p>

<p>
Typical frequency responses for the 4 supported high pass filter types
are shown in the next figure:
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/HighPassOrder4Filters.png\"
     alt=\"HighPassOrder4Filters.png\">
</blockquote>

<p>
The corresponding step responses of these high pass filters are
shown in the next figure:
</p>
<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/HighPassOrder4FiltersStepResponse.png\"
     alt=\"HighPassOrder4FiltersStepResponse.png\">
</blockquote>

<p>
All filters are available in <b>normalized</b> (default) and non-normalized form.
In the normalized form, the amplitude of the filter transfer function
at the cut-off frequency f_cut is -3 dB (= 10^(-3/20) = 0.70794..).
Note, when comparing the filters of this function with other software systems,
the setting of \"normalized\" has to be selected appropriately. For example, the signal processing
toolbox of Matlab provides the filters in non-normalized form and
therefore a comparison makes only sense, if normalized = <b>false</b>
is set. A normalized filter is usually better suited for applications,
since filters of different orders are \"comparable\",
whereas non-normalized filters usually require to adapt the
cut-off frequency, when the order of the filter is changed.
See a comparison of \"normalized\" and \"non-normalized\" filters at hand of
CriticalDamping filters of order 1,2,3:
</p>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/CriticalDampingNormalized.png\"
     alt=\"CriticalDampingNormalized.png\">
</blockquote>

<blockquote>
<img src=\"modelica://Modelica/Resources/Images/Blocks/CriticalDampingNonNormalized.png\"
     alt=\"CriticalDampingNonNormalized.png\">
</blockquote>

<h4>Implementation</h4>

<p>
The filters are implemented in the following, reliable way:
</p>

<ol>
<li> A prototype low pass filter with a cut-off angular frequency of 1 rad/s is constructed
     from the desired analogFilter and the desired normalization.</li>

<li> This prototype low pass filter is transformed to the desired filterType and the
     desired cut-off frequency f_cut using a transformation on the Laplace variable \"s\".</li>

<li> The resulting first and second order transfer functions are implemented in
     state space form, using the \"eigen value\" representation of a transfer function:
     <pre>

  // second order block with eigen values: a +/- jb
  <b>der</b>(x1) = a*x1 - b*x2 + (a^2 + b^2)/b*u;
  <b>der</b>(x2) = b*x1 + a*x2;
       y  = x2;
     </pre>
     The dc-gain from the input to the output of this block is one and the selected
     states are in the order of the input (if \"u\" is in the order of \"one\", then the
     states are also in the order of \"one\"). In the \"Advanced\" tab, a \"nominal\" value for
     the input \"u\" can be given. If appropriately selected, the states are in the order of \"one\" and
     then step-size control is always appropriate.</li>
</ol>

<h4>References</h4>

<dl>
<dt>Tietze U., and Schenk C. (2002):</dt>
<dd> <b>Halbleiter-Schaltungstechnik</b>.
     Springer Verlag, 12. Auflage, pp. 815-852.</dd>
</dl>

</html>", revisions = "<html>
<dl>
  <dt><b>Main Author:</b></dt>
  <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>,
      DLR Oberpfaffenhofen.</dd>
</dl>

<h4>Acknowledgement</h4>

<p>
The development of this block was partially funded by BMBF within the
     <a href=\"http://www.eurosyslib.com/\">ITEA2 EUROSYSLIB</a>
      project.
</p>

</html>"));
      end Filter;

      package Internal "Internal utility functions and blocks that should not be directly utilized by the user"
        extends Modelica.Icons.InternalPackage;

        package Filter "Internal utility functions for filters that should not be directly used"
          extends Modelica.Icons.InternalPackage;

          package base "Prototype low pass filters with cut-off frequency of 1 rad/s (other filters are derived by transformation from these base filters)"
            extends Modelica.Icons.InternalPackage;

            function CriticalDamping "Return base filter coefficients of CriticalDamping filter (= low pass filter with w_cut = 1 rad/s)"
              extends Modelica.Icons.Function;
              input Integer order(min = 1) "Order of filter";
              input Boolean normalized = true "= true, if amplitude at f_cut = -3db, otherwise unmodified filter";
              output Real cr[order] "Coefficients of real poles";
            protected
              Real alpha = 1.0 "Frequency correction factor";
              Real alpha2 "= alpha*alpha";
              Real den1[order] "[p] coefficients of denominator first order polynomials (a*p + 1)";
              Real den2[0, 2] "[p^2, p] coefficients of denominator second order polynomials (b*p^2 + a*p + 1)";
              Real c0[0] "Coefficients of s^0 term if conjugate complex pole";
              Real c1[0] "Coefficients of s^1 term if conjugate complex pole";
            algorithm
              if normalized then
                alpha := sqrt(10 ^ (3 / 10 / order) - 1);
              else
                alpha := 1.0;
              end if;
// alpha := sqrt(2^(1/order) - 1);
              for i in 1:order loop
                den1[i] := alpha;
              end for;
// Determine polynomials with highest power of s equal to one
              (cr, c0, c1) := Modelica.Blocks.Continuous.Internal.Filter.Utilities.toHighestPowerOne(den1, den2);
            end CriticalDamping;

            function Bessel "Return base filter coefficients of Bessel filter (= low pass filter with w_cut = 1 rad/s)"
              extends Modelica.Icons.Function;
              input Integer order(min = 1) "Order of filter";
              input Boolean normalized = true "= true, if amplitude at f_cut = -3db, otherwise unmodified filter";
              output Real cr[mod(order, 2)] "Coefficient of real pole";
              output Real c0[integer(order / 2)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[integer(order / 2)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              Real alpha = 1.0 "Frequency correction factor";
              Real alpha2 "= alpha*alpha";
              Real den1[size(cr, 1)] "[p] coefficients of denominator first order polynomials (a*p + 1)";
              Real den2[size(c0, 1), 2] "[p^2, p] coefficients of denominator second order polynomials (b*p^2 + a*p + 1)";
            algorithm
              (den1, den2, alpha) := Modelica.Blocks.Continuous.Internal.Filter.Utilities.BesselBaseCoefficients(order);
              if not normalized then
                alpha2 := alpha * alpha;
                for i in 1:size(c0, 1) loop
                  den2[i, 1] := den2[i, 1] * alpha2;
                  den2[i, 2] := den2[i, 2] * alpha;
                end for;
                if size(cr, 1) == 1 then
                  den1[1] := den1[1] * alpha;
                end if;
              end if;
// Determine polynomials with highest power of s equal to one
              (cr, c0, c1) := Modelica.Blocks.Continuous.Internal.Filter.Utilities.toHighestPowerOne(den1, den2);
            end Bessel;

            function Butterworth "Return base filter coefficients of Butterworth filter (= low pass filter with w_cut = 1 rad/s)"
              extends Modelica.Icons.Function;
              input Integer order(min = 1) "Order of filter";
              input Boolean normalized = true "= true, if amplitude at f_cut = -3db, otherwise unmodified filter";
              output Real cr[mod(order, 2)] "Coefficient of real pole";
              output Real c0[integer(order / 2)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[integer(order / 2)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              Real alpha = 1.0 "Frequency correction factor";
              Real alpha2 "= alpha*alpha";
              Real den1[size(cr, 1)] "[p] coefficients of denominator first order polynomials (a*p + 1)";
              Real den2[size(c0, 1), 2] "[p^2, p] coefficients of denominator second order polynomials (b*p^2 + a*p + 1)";
              constant Real pi = Modelica.Constants.pi;
            algorithm
              for i in 1:size(c0, 1) loop
                den2[i, 1] := 1.0;
                den2[i, 2] := -2 * Modelica.Math.cos(pi * (0.5 + (i - 0.5) / order));
              end for;
              if size(cr, 1) == 1 then
                den1[1] := 1.0;
              end if;
/* Transformation of filter transfer function with "new(p) = alpha*p"
     in order that the filter transfer function has an amplitude of
     -3 db at the cutoff frequency
  */
/*
    if normalized then
      alpha := Internal.normalizationFactor(den1, den2);
      alpha2 := alpha*alpha;
      for i in 1:size(c0, 1) loop
        den2[i, 1] := den2[i, 1]*alpha2;
        den2[i, 2] := den2[i, 2]*alpha;
      end for;
      if size(cr,1) == 1 then
        den1[1] := den1[1]*alpha;
      end if;
    end if;
  */
// Determine polynomials with highest power of s equal to one
              (cr, c0, c1) := Modelica.Blocks.Continuous.Internal.Filter.Utilities.toHighestPowerOne(den1, den2);
            end Butterworth;

            function ChebyshevI "Return base filter coefficients of Chebyshev I filter (= low pass filter with w_cut = 1 rad/s)"
              import Modelica.Math.asinh;
              extends Modelica.Icons.Function;
              input Integer order(min = 1) "Order of filter";
              input Real A_ripple = 0.5 "Pass band ripple in [dB]";
              input Boolean normalized = true "= true, if amplitude at f_cut = -3db, otherwise unmodified filter";
              output Real cr[mod(order, 2)] "Coefficient of real pole";
              output Real c0[integer(order / 2)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[integer(order / 2)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              Real epsilon;
              Real fac;
              Real alpha = 1.0 "Frequency correction factor";
              Real alpha2 "= alpha*alpha";
              Real den1[size(cr, 1)] "[p] coefficients of denominator first order polynomials (a*p + 1)";
              Real den2[size(c0, 1), 2] "[p^2, p] coefficients of denominator second order polynomials (b*p^2 + a*p + 1)";
              constant Real pi = Modelica.Constants.pi;
            algorithm
              epsilon := sqrt(10 ^ (A_ripple / 10) - 1);
              fac := asinh(1 / epsilon) / order;
              den1 := fill(1 / sinh(fac), size(den1, 1));
              if size(cr, 1) == 0 then
                for i in 1:size(c0, 1) loop
                  den2[i, 1] := 1 / (cosh(fac) ^ 2 - cos((2 * i - 1) * pi / (2 * order)) ^ 2);
                  den2[i, 2] := 2 * den2[i, 1] * sinh(fac) * cos((2 * i - 1) * pi / (2 * order));
                end for;
              else
                for i in 1:size(c0, 1) loop
                  den2[i, 1] := 1 / (cosh(fac) ^ 2 - cos(i * pi / order) ^ 2);
                  den2[i, 2] := 2 * den2[i, 1] * sinh(fac) * cos(i * pi / order);
                end for;
              end if;
/* Transformation of filter transfer function with "new(p) = alpha*p"
       in order that the filter transfer function has an amplitude of
       -3 db at the cutoff frequency
    */
              if normalized then
                alpha := Modelica.Blocks.Continuous.Internal.Filter.Utilities.normalizationFactor(den1, den2);
                alpha2 := alpha * alpha;
                for i in 1:size(c0, 1) loop
                  den2[i, 1] := den2[i, 1] * alpha2;
                  den2[i, 2] := den2[i, 2] * alpha;
                end for;
                den1 := den1 * alpha;
              end if;
// Determine polynomials with highest power of s equal to one
              (cr, c0, c1) := Modelica.Blocks.Continuous.Internal.Filter.Utilities.toHighestPowerOne(den1, den2);
            end ChebyshevI;
          end base;

          package coefficients "Filter coefficients"
            extends Modelica.Icons.InternalPackage;

            function lowPass "Return low pass filter coefficients at given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles";
              input Real c0_in[:] "Coefficients of s^0 term if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
              input Modelica.SIunits.Frequency f_cut "Cut-off frequency";
              output Real cr[size(cr_in, 1)] "Coefficient of real pole";
              output Real c0[size(c0_in, 1)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              constant Real pi = Modelica.Constants.pi;
              Modelica.SIunits.AngularVelocity w_cut = 2 * pi * f_cut "Cut-off angular frequency";
              Real w_cut2 = w_cut * w_cut;
            algorithm
              assert(f_cut > 0, "Cut-off frequency f_cut must be positive");
/* Change filter coefficients according to transformation new(s) = s/w_cut
     s + cr           -> (s/w) + cr              = (s + w*cr)/w
     s^2 + c1*s + c0  -> (s/w)^2 + c1*(s/w) + c0 = (s^2 + (c1*w)*s + (c0*w^2))/w^2
  */
              cr := w_cut * cr_in;
              c1 := w_cut * c1_in;
              c0 := w_cut2 * c0_in;
            end lowPass;

            function highPass "Return high pass filter coefficients at given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles";
              input Real c0_in[:] "Coefficients of s^0 term if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
              input Modelica.SIunits.Frequency f_cut "Cut-off frequency";
              output Real cr[size(cr_in, 1)] "Coefficient of real pole";
              output Real c0[size(c0_in, 1)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              constant Real pi = Modelica.Constants.pi;
              Modelica.SIunits.AngularVelocity w_cut = 2 * pi * f_cut "Cut-off angular frequency";
              Real w_cut2 = w_cut * w_cut;
            algorithm
              assert(f_cut > 0, "Cut-off frequency f_cut must be positive");
/* Change filter coefficients according to transformation: new(s) = 1/s
        1/(s + cr)          -> 1/(1/s + cr)                = (1/cr)*s / (s + (1/cr))
        1/(s^2 + c1*s + c0) -> 1/((1/s)^2 + c1*(1/s) + c0) = (1/c0)*s^2 / (s^2 + (c1/c0)*s + 1/c0)

     Check whether transformed roots are also conjugate complex:
        c0 - c1^2/4 > 0  -> (1/c0) - (c1/c0)^2 / 4
                            = (c0 - c1^2/4) / c0^2 > 0
        It is therefore guaranteed that the roots remain conjugate complex

     Change filter coefficients according to transformation new(s) = s/w_cut
        s + 1/cr                -> (s/w) + 1/cr                   = (s + w/cr)/w
        s^2 + (c1/c0)*s + 1/c0  -> (s/w)^2 + (c1/c0)*(s/w) + 1/c0 = (s^2 + (w*c1/c0)*s + (w^2/c0))/w^2
  */
              for i in 1:size(cr_in, 1) loop
                cr[i] := w_cut / cr_in[i];
              end for;
              for i in 1:size(c0_in, 1) loop
                c0[i] := w_cut2 / c0_in[i];
                c1[i] := w_cut * c1_in[i] / c0_in[i];
              end for;
            end highPass;

            function bandPass "Return band pass filter coefficients at given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles";
              input Real c0_in[:] "Coefficients of s^0 term if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
              input Modelica.SIunits.Frequency f_min "Band of band pass filter is f_min (A=-3db) .. f_max (A=-3db)";
              input Modelica.SIunits.Frequency f_max "Upper band frequency";
              output Real cr[0] "Coefficient of real pole";
              output Real c0[size(cr_in, 1) + 2 * size(c0_in, 1)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[size(cr_in, 1) + 2 * size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
              output Real cn "Numerator coefficient of the PT2 terms";
            protected
              constant Real pi = Modelica.Constants.pi;
              Modelica.SIunits.Frequency f0 = sqrt(f_min * f_max);
              Modelica.SIunits.AngularVelocity w_cut = 2 * pi * f0 "Cut-off angular frequency";
              Real w_band = (f_max - f_min) / f0;
              Real w_cut2 = w_cut * w_cut;
              Real c;
              Real alpha;
              Integer j;
            algorithm
              assert(f_min > 0 and f_min < f_max, "Band frequencies f_min and f_max are wrong");
/* The band pass filter is derived from the low pass filter by
       the transformation new(s) = (s + 1/s)/w   (w = w_band = (f_max - f_min)/sqrt(f_max*f_min) )

       1/(s + cr)         -> 1/((s/w + 1/s/w) + cr)
                             = w*s / (s^2 + cr*w*s + 1)

       1/(s^2 + c1*s + c0) -> 1/( (s+1/s)^2/w^2 + c1*(s + 1/s)/w + c0 )
                              = 1 /( ( s^2 + 1/s^2 + 2)/w^2 + (s + 1/s)*c1/w + c0 )
                              = w^2*s^2 / (s^4 + 2*s^2 + 1 + (s^3 + s)*c1*w + c0*w^2*s^2)
                              = w^2*s^2 / (s^4 + c1*w*s^3 + (2+c0*w^2)*s^2 + c1*w*s + 1)

                              Assume the following description with PT2:
                              = w^2*s^2 /( (s^2 + s*(c/alpha) + 1/alpha^2)*
                                           (s^2 + s*(c*alpha) + alpha^2) )
                              = w^2*s^2 / ( s^4 + c*(alpha + 1/alpha)*s^3
                                                + (alpha^2 + 1/alpha^2 + c^2)*s^2
                                                + c*(alpha + 1/alpha)*s + 1 )

                              and therefore:
                                c*(alpha + 1/alpha) = c1*w       -> c = c1*w / (alpha + 1/alpha)
                                                                      = c1*w*alpha/(1+alpha^2)
                                alpha^2 + 1/alpha^2 + c^2 = 2+c0*w^2 -> equation to determine alpha
                                alpha^4 + 1 + c1^2*w^2*alpha^4/(1+alpha^2)^2 = (2+c0*w^2)*alpha^2
                                or z = alpha^2
                                z^2 + c^1^2*w^2*z^2/(1+z)^2 - (2+c0*w^2)*z + 1 = 0

     Check whether roots remain conjugate complex
        c0 - (c1/2)^2 > 0:    1/alpha^2 - (c/alpha)^2/4
                              = 1/alpha^2*(1 - c^2/4)    -> not possible to figure this out

     Afterwards, change filter coefficients according to transformation new(s) = s/w_cut
        w_band*s/(s^2 + c1*s + c0)  -> w_band*(s/w)/((s/w)^2 + c1*(s/w) + c0 =
                                       (w_band/w)*s/(s^2 + (c1*w)*s + (c0*w^2))/w^2) =
                                       (w_band*w)*s/(s^2 + (c1*w)*s + (c0*w^2))
    */
              for i in 1:size(cr_in, 1) loop
                c1[i] := w_cut * cr_in[i] * w_band;
                c0[i] := w_cut2;
              end for;
              for i in 1:size(c1_in, 1) loop
                alpha := Modelica.Blocks.Continuous.Internal.Filter.Utilities.bandPassAlpha(c1_in[i], c0_in[i], w_band);
                c := c1_in[i] * w_band / (alpha + 1 / alpha);
                j := size(cr_in, 1) + 2 * i - 1;
                c1[j] := w_cut * c / alpha;
                c1[j + 1] := w_cut * c * alpha;
                c0[j] := w_cut2 / alpha ^ 2;
                c0[j + 1] := w_cut2 * alpha ^ 2;
              end for;
              cn := w_band * w_cut;
            end bandPass;

            function bandStop "Return band stop filter coefficients at given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles";
              input Real c0_in[:] "Coefficients of s^0 term if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
              input Modelica.SIunits.Frequency f_min "Band of band stop filter is f_min (A=-3db) .. f_max (A=-3db)";
              input Modelica.SIunits.Frequency f_max "Upper band frequency";
              output Real cr[0] "Coefficient of real pole";
              output Real c0[size(cr_in, 1) + 2 * size(c0_in, 1)] "Coefficients of s^0 term if conjugate complex pole";
              output Real c1[size(cr_in, 1) + 2 * size(c0_in, 1)] "Coefficients of s^1 term if conjugate complex pole";
            protected
              constant Real pi = Modelica.Constants.pi;
              Modelica.SIunits.Frequency f0 = sqrt(f_min * f_max);
              Modelica.SIunits.AngularVelocity w_cut = 2 * pi * f0 "Cut-off angular frequency";
              Real w_band = (f_max - f_min) / f0;
              Real w_cut2 = w_cut * w_cut;
              Real c;
              Real ww;
              Real alpha;
              Integer j;
            algorithm
              assert(f_min > 0 and f_min < f_max, "Band frequencies f_min and f_max are wrong");
/* The band pass filter is derived from the low pass filter by
       the transformation new(s) = (s + 1/s)/w   (w = w_band = (f_max - f_min)/sqrt(f_max*f_min) )

       1/(s + cr)         -> 1/((s/w + 1/s/w) + cr)
                             = w*s / (s^2 + cr*w*s + 1)

       1/(s^2 + c1*s + c0) -> 1/( (s+1/s)^2/w^2 + c1*(s + 1/s)/w + c0 )
                              = 1 /( ( s^2 + 1/s^2 + 2)/w^2 + (s + 1/s)*c1/w + c0 )
                              = w^2*s^2 / (s^4 + 2*s^2 + 1 + (s^3 + s)*c1*w + c0*w^2*s^2)
                              = w^2*s^2 / (s^4 + c1*w*s^3 + (2+c0*w^2)*s^2 + c1*w*s + 1)

                              Assume the following description with PT2:
                              = w^2*s^2 /( (s^2 + s*(c/alpha) + 1/alpha^2)*
                                           (s^2 + s*(c*alpha) + alpha^2) )
                              = w^2*s^2 / ( s^4 + c*(alpha + 1/alpha)*s^3
                                                + (alpha^2 + 1/alpha^2 + c^2)*s^2
                                                + c*(alpha + 1/alpha)*s + 1 )

                              and therefore:
                                c*(alpha + 1/alpha) = c1*w       -> c = c1*w / (alpha + 1/alpha)
                                                                      = c1*w*alpha/(1+alpha^2)
                                alpha^2 + 1/alpha^2 + c^2 = 2+c0*w^2 -> equation to determine alpha
                                alpha^4 + 1 + c1^2*w^2*alpha^4/(1+alpha^2)^2 = (2+c0*w^2)*alpha^2
                                or z = alpha^2
                                z^2 + c^1^2*w^2*z^2/(1+z)^2 - (2+c0*w^2)*z + 1 = 0

       The band stop filter is derived from the low pass filter by
       the transformation new(s) = w/( (s + 1/s) )   (w = w_band = (f_max - f_min)/sqrt(f_max*f_min) )

       cr/(s + cr)         -> 1/(( w/(s + 1/s) ) + cr)
                              = (s^2 + 1) / (s^2 + (w/cr)*s + 1)

       c0/(s^2 + c1*s + c0) -> c0/( w^2/(s + 1/s)^2 + c1*w/(s + 1/s) + c0 )
                               = c0*(s^2 + 1)^2 / (s^4 + c1*w*s^3/c0 + (2+w^2/b)*s^2 + c1*w*s/c0 + 1)

                               Assume the following description with PT2:
                               = c0*(s^2 + 1)^2 / ( (s^2 + s*(c/alpha) + 1/alpha^2)*
                                                    (s^2 + s*(c*alpha) + alpha^2) )
                               = c0*(s^2 + 1)^2 / (  s^4 + c*(alpha + 1/alpha)*s^3
                                                         + (alpha^2 + 1/alpha^2 + c^2)*s^2
                                                         + c*(alpha + 1/alpha)*p + 1 )

                            and therefore:
                              c*(alpha + 1/alpha) = c1*w/b         -> c = c1*w/(c0*(alpha + 1/alpha))
                              alpha^2 + 1/alpha^2 + c^2 = 2+w^2/c0 -> equation to determine alpha
                              alpha^4 + 1 + (c1*w/c0*alpha^2)^2/(1+alpha^2)^2 = (2+w^2/c0)*alpha^2
                              or z = alpha^2
                              z^2 + (c1*w/c0*z)^2/(1+z)^2 - (2+w^2/c0)*z + 1 = 0

                            same as:  ww = w/c0
                              z^2 + (c1*ww*z)^2/(1+z)^2 - (2+c0*ww)*z + 1 = 0  -> same equation as for BandPass

     Afterwards, change filter coefficients according to transformation new(s) = s/w_cut
        c0*(s^2+1)(s^2 + c1*s + c0)  -> c0*((s/w)^2 + 1) / ((s/w)^2 + c1*(s/w) + c0 =
                                        c0/w^2*(s^2 + w^2) / (s^2 + (c1*w)*s + (c0*w^2))/w^2) =
                                        (s^2 + c0*w^2) / (s^2 + (c1*w)*s + (c0*w^2))
    */
              for i in 1:size(cr_in, 1) loop
                c1[i] := w_cut * w_band / cr_in[i];
                c0[i] := w_cut2;
              end for;
              for i in 1:size(c1_in, 1) loop
                ww := w_band / c0_in[i];
                alpha := Modelica.Blocks.Continuous.Internal.Filter.Utilities.bandPassAlpha(c1_in[i], c0_in[i], ww);
                c := c1_in[i] * ww / (alpha + 1 / alpha);
                j := size(cr_in, 1) + 2 * i - 1;
                c1[j] := w_cut * c / alpha;
                c1[j + 1] := w_cut * c * alpha;
                c0[j] := w_cut2 / alpha ^ 2;
                c0[j + 1] := w_cut2 * alpha ^ 2;
              end for;
            end bandStop;
          end coefficients;

          package roots "Filter roots and gain as needed for block implementations"
            extends Modelica.Icons.InternalPackage;

            function lowPass "Return low pass filter roots as needed for block for given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles of base filter";
              input Real c0_in[:] "Coefficients of s^0 term of base filter if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term of base filter if conjugate complex pole";
              input Modelica.SIunits.Frequency f_cut "Cut-off frequency";
              output Real r[size(cr_in, 1)] "Real eigenvalues";
              output Real a[size(c0_in, 1)] "Real parts of complex conjugate eigenvalues";
              output Real b[size(c0_in, 1)] "Imaginary parts of complex conjugate eigenvalues";
              output Real ku[size(c0_in, 1)] "Input gain";
            protected
              Real c0[size(c0_in, 1)];
              Real c1[size(c0_in, 1)];
              Real cr[size(cr_in, 1)];
            algorithm
// Get coefficients of low pass filter at f_cut
              (cr, c0, c1) := coefficients.lowPass(cr_in, c0_in, c1_in, f_cut);
// Transform coefficients in to root
              for i in 1:size(cr_in, 1) loop
                r[i] := -cr[i];
              end for;
              for i in 1:size(c0_in, 1) loop
                a[i] := -c1[i] / 2;
                b[i] := sqrt(c0[i] - a[i] * a[i]);
                ku[i] := c0[i] / b[i];
              end for;
              annotation(
                Documentation(info = "<html>

<p>
The goal is to implement the filter in the following form:
</p>

<pre>
  // real pole:
   der(x) = r*x - r*u
       y  = x

  // complex conjugate poles:
  der(x1) = a*x1 - b*x2 + ku*u;
  der(x2) = b*x1 + a*x2;
       y  = x2;

            ku = (a^2 + b^2)/b
</pre>
<p>
This representation has the following transfer function:
</p>
<pre>
// real pole:
    s*y = r*y - r*u
  or
    (s-r)*y = -r*u
  or
    y = -r/(s-r)*u

  comparing coefficients with
    y = cr/(s + cr)*u  ->  r = -cr      // r is the real eigenvalue

// complex conjugate poles
    s*x2 =  a*x2 + b*x1
    s*x1 = -b*x2 + a*x1 + ku*u
  or
    (s-a)*x2               = b*x1  ->  x2 = b/(s-a)*x1
    (s + b^2/(s-a) - a)*x1 = ku*u  ->  (s(s-a) + b^2 - a*(s-a))*x1  = ku*(s-a)*u
                                   ->  (s^2 - 2*a*s + a^2 + b^2)*x1 = ku*(s-a)*u
  or
    x1 = ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
    x2 = b/(s-a)*ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
       = b*ku/(s^2 - 2*a*s + a^2 + b^2)*u
    y  = x2

  comparing coefficients with
    y = c0/(s^2 + c1*s + c0)*u  ->  a  = -c1/2
                                    b  = sqrt(c0 - a^2)
                                    ku = c0/b
                                       = (a^2 + b^2)/b

  comparing with eigenvalue representation:
    (s - (a+jb))*(s - (a-jb)) = s^2 -2*a*s + a^2 + b^2
  shows that:
    a: real part of eigenvalue
    b: imaginary part of eigenvalue

  time -> infinity:
    y(s=0) = x2(s=0) = 1
             x1(s=0) = -ku*a/(a^2 + b^2)*u
                     = -(a/b)*u
</pre>

</html>"));
            end lowPass;

            function highPass "Return high pass filter roots as needed for block for given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles of base filter";
              input Real c0_in[:] "Coefficients of s^0 term of base filter if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term of base filter if conjugate complex pole";
              input Modelica.SIunits.Frequency f_cut "Cut-off frequency";
              output Real r[size(cr_in, 1)] "Real eigenvalues";
              output Real a[size(c0_in, 1)] "Real parts of complex conjugate eigenvalues";
              output Real b[size(c0_in, 1)] "Imaginary parts of complex conjugate eigenvalues";
              output Real ku[size(c0_in, 1)] "Gains of input terms";
              output Real k1[size(c0_in, 1)] "Gains of y = k1*x1 + k2*x + u";
              output Real k2[size(c0_in, 1)] "Gains of y = k1*x1 + k2*x + u";
            protected
              Real c0[size(c0_in, 1)];
              Real c1[size(c0_in, 1)];
              Real cr[size(cr_in, 1)];
              Real ba2;
            algorithm
// Get coefficients of high pass filter at f_cut
              (cr, c0, c1) := coefficients.highPass(cr_in, c0_in, c1_in, f_cut);
// Transform coefficients in to roots
              for i in 1:size(cr_in, 1) loop
                r[i] := -cr[i];
              end for;
              for i in 1:size(c0_in, 1) loop
                a[i] := -c1[i] / 2;
                b[i] := sqrt(c0[i] - a[i] * a[i]);
                ku[i] := c0[i] / b[i];
                k1[i] := 2 * a[i] / ku[i];
                ba2 := (b[i] / a[i]) ^ 2;
                k2[i] := (1 - ba2) / (1 + ba2);
              end for;
              annotation(
                Documentation(info = "<html>

<p>
The goal is to implement the filter in the following form:
</p>

<pre>
  // real pole:
   der(x) = r*x - r*u
       y  = -x + u

  // complex conjugate poles:
  der(x1) = a*x1 - b*x2 + ku*u;
  der(x2) = b*x1 + a*x2;
       y  = k1*x1 + k2*x2 + u;

            ku = (a^2 + b^2)/b
            k1 = 2*a/ku
            k2 = (a^2 - b^2) / (b*ku)
               = (a^2 - b^2) / (a^2 + b^2)
               = (1 - (b/a)^2) / (1 + (b/a)^2)

</pre>
<p>
This representation has the following transfer function:
</p>
<pre>
// real pole:
    s*x = r*x - r*u
  or
    (s-r)*x = -r*u   -> x = -r/(s-r)*u
  or
    y = r/(s-r)*u + (s-r)/(s-r)*u
      = (r+s-r)/(s-r)*u
      = s/(s-r)*u

  comparing coefficients with
    y = s/(s + cr)*u  ->  r = -cr      // r is the real eigenvalue

// complex conjugate poles
    s*x2 =  a*x2 + b*x1
    s*x1 = -b*x2 + a*x1 + ku*u
  or
    (s-a)*x2               = b*x1  ->  x2 = b/(s-a)*x1
    (s + b^2/(s-a) - a)*x1 = ku*u  ->  (s(s-a) + b^2 - a*(s-a))*x1  = ku*(s-a)*u
                                   ->  (s^2 - 2*a*s + a^2 + b^2)*x1 = ku*(s-a)*u
  or
    x1 = ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
    x2 = b/(s-a)*ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
       = b*ku/(s^2 - 2*a*s + a^2 + b^2)*u
    y  = k1*x1 + k2*x2 + u
       = (k1*ku*(s-a) + k2*b*ku +  s^2 - 2*a*s + a^2 + b^2) /
         (s^2 - 2*a*s + a^2 + b^2)*u
       = (s^2 + (k1*ku - 2*a)*s + k2*b*ku - k1*ku*a + a^2 + b^2) /
         (s^2 - 2*a*s + a^2 + b^2)*u
       = (s^2 + (2*a-2*a)*s + a^2 - b^2 - 2*a^2 + a^2 + b^2) /
         (s^2 - 2*a*s + a^2 + b^2)*u
       = s^2 / (s^2 - 2*a*s + a^2 + b^2)*u

  comparing coefficients with
    y = s^2/(s^2 + c1*s + c0)*u  ->  a = -c1/2
                                     b = sqrt(c0 - a^2)

  comparing with eigenvalue representation:
    (s - (a+jb))*(s - (a-jb)) = s^2 -2*a*s + a^2 + b^2
  shows that:
    a: real part of eigenvalue
    b: imaginary part of eigenvalue
</pre>

</html>"));
            end highPass;

            function bandPass "Return band pass filter roots as needed for block for given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles of base filter";
              input Real c0_in[:] "Coefficients of s^0 term of base filter if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term of base filter if conjugate complex pole";
              input Modelica.SIunits.Frequency f_min "Band of band pass filter is f_min (A=-3db) .. f_max (A=-3db)";
              input Modelica.SIunits.Frequency f_max "Upper band frequency";
              output Real a[size(cr_in, 1) + 2 * size(c0_in, 1)] "Real parts of complex conjugate eigenvalues";
              output Real b[size(cr_in, 1) + 2 * size(c0_in, 1)] "Imaginary parts of complex conjugate eigenvalues";
              output Real ku[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of input terms";
              output Real k1[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of y = k1*x1 + k2*x";
              output Real k2[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of y = k1*x1 + k2*x";
            protected
              Real cr[0];
              Real c0[size(a, 1)];
              Real c1[size(a, 1)];
              Real cn;
              Real bb;
            algorithm
// Get coefficients of band pass filter at f_cut
              (cr, c0, c1, cn) := coefficients.bandPass(cr_in, c0_in, c1_in, f_min, f_max);
// Transform coefficients in to roots
              for i in 1:size(a, 1) loop
                a[i] := -c1[i] / 2;
                bb := c0[i] - a[i] * a[i];
                assert(bb >= 0, "\nNot possible to use band pass filter, since transformation results in\n" + "system that does not have conjugate complex poles.\n" + "Try to use another analog filter for the band pass.\n");
                b[i] := sqrt(bb);
                ku[i] := c0[i] / b[i];
                k1[i] := cn / ku[i];
                k2[i] := cn * a[i] / (b[i] * ku[i]);
              end for;
              annotation(
                Documentation(info = "<html>

<p>
The goal is to implement the filter in the following form:
</p>

<pre>
  // complex conjugate poles:
  der(x1) = a*x1 - b*x2 + ku*u;
  der(x2) = b*x1 + a*x2;
       y  = k1*x1 + k2*x2;

            ku = (a^2 + b^2)/b
            k1 = cn/ku
            k2 = cn*a/(b*ku)
</pre>
<p>
This representation has the following transfer function:
</p>
<pre>
// complex conjugate poles
    s*x2 =  a*x2 + b*x1
    s*x1 = -b*x2 + a*x1 + ku*u
  or
    (s-a)*x2               = b*x1  ->  x2 = b/(s-a)*x1
    (s + b^2/(s-a) - a)*x1 = ku*u  ->  (s(s-a) + b^2 - a*(s-a))*x1  = ku*(s-a)*u
                                   ->  (s^2 - 2*a*s + a^2 + b^2)*x1 = ku*(s-a)*u
  or
    x1 = ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
    x2 = b/(s-a)*ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
       = b*ku/(s^2 - 2*a*s + a^2 + b^2)*u
    y  = k1*x1 + k2*x2
       = (k1*ku*(s-a) + k2*b*ku) / (s^2 - 2*a*s + a^2 + b^2)*u
       = (k1*ku*s + k2*b*ku - k1*ku*a) / (s^2 - 2*a*s + a^2 + b^2)*u
       = (cn*s + cn*a - cn*a) / (s^2 - 2*a*s + a^2 + b^2)*u
       = cn*s / (s^2 - 2*a*s + a^2 + b^2)*u

  comparing coefficients with
    y = cn*s / (s^2 + c1*s + c0)*u  ->  a = -c1/2
                                        b = sqrt(c0 - a^2)

  comparing with eigenvalue representation:
    (s - (a+jb))*(s - (a-jb)) = s^2 -2*a*s + a^2 + b^2
  shows that:
    a: real part of eigenvalue
    b: imaginary part of eigenvalue
</pre>

</html>"));
            end bandPass;

            function bandStop "Return band stop filter roots as needed for block for given cut-off frequency"
              extends Modelica.Icons.Function;
              input Real cr_in[:] "Coefficients of real poles of base filter";
              input Real c0_in[:] "Coefficients of s^0 term of base filter if conjugate complex pole";
              input Real c1_in[size(c0_in, 1)] "Coefficients of s^1 term of base filter if conjugate complex pole";
              input Modelica.SIunits.Frequency f_min "Band of band stop filter is f_min (A=-3db) .. f_max (A=-3db)";
              input Modelica.SIunits.Frequency f_max "Upper band frequency";
              output Real a[size(cr_in, 1) + 2 * size(c0_in, 1)] "Real parts of complex conjugate eigenvalues";
              output Real b[size(cr_in, 1) + 2 * size(c0_in, 1)] "Imaginary parts of complex conjugate eigenvalues";
              output Real ku[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of input terms";
              output Real k1[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of y = k1*x1 + k2*x";
              output Real k2[size(cr_in, 1) + 2 * size(c0_in, 1)] "Gains of y = k1*x1 + k2*x";
            protected
              Real cr[0];
              Real c0[size(a, 1)];
              Real c1[size(a, 1)];
              Real cn;
              Real bb;
            algorithm
// Get coefficients of band stop filter at f_cut
              (cr, c0, c1) := coefficients.bandStop(cr_in, c0_in, c1_in, f_min, f_max);
// Transform coefficients in to roots
              for i in 1:size(a, 1) loop
                a[i] := -c1[i] / 2;
                bb := c0[i] - a[i] * a[i];
                assert(bb >= 0, "\nNot possible to use band stop filter, since transformation results in\n" + "system that does not have conjugate complex poles.\n" + "Try to use another analog filter for the band stop filter.\n");
                b[i] := sqrt(bb);
                ku[i] := c0[i] / b[i];
                k1[i] := 2 * a[i] / ku[i];
                k2[i] := (c0[i] + a[i] ^ 2 - b[i] ^ 2) / (b[i] * ku[i]);
              end for;
              annotation(
                Documentation(info = "<html>

<p>
The goal is to implement the filter in the following form:
</p>

<pre>
  // complex conjugate poles:
  der(x1) = a*x1 - b*x2 + ku*u;
  der(x2) = b*x1 + a*x2;
       y  = k1*x1 + k2*x2 + u;

            ku = (a^2 + b^2)/b
            k1 = 2*a/ku
            k2 = (c0 + a^2 - b^2)/(b*ku)
</pre>
<p>
This representation has the following transfer function:
</p>
<pre>
// complex conjugate poles
    s*x2 =  a*x2 + b*x1
    s*x1 = -b*x2 + a*x1 + ku*u
  or
    (s-a)*x2               = b*x1  ->  x2 = b/(s-a)*x1
    (s + b^2/(s-a) - a)*x1 = ku*u  ->  (s(s-a) + b^2 - a*(s-a))*x1  = ku*(s-a)*u
                                   ->  (s^2 - 2*a*s + a^2 + b^2)*x1 = ku*(s-a)*u
  or
    x1 = ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
    x2 = b/(s-a)*ku*(s-a)/(s^2 - 2*a*s + a^2 + b^2)*u
       = b*ku/(s^2 - 2*a*s + a^2 + b^2)*u
    y  = k1*x1 + k2*x2 + u
       = (k1*ku*(s-a) + k2*b*ku + s^2 - 2*a*s + a^2 + b^2) / (s^2 - 2*a*s + a^2 + b^2)*u
       = (s^2 + (k1*ku-2*a)*s + k2*b*ku - k1*ku*a + a^2 + b^2) / (s^2 - 2*a*s + a^2 + b^2)*u
       = (s^2 + c0 + a^2 - b^2 - 2*a^2 + a^2 + b^2) / (s^2 - 2*a*s + a^2 + b^2)*u
       = (s^2 + c0) / (s^2 - 2*a*s + a^2 + b^2)*u

  comparing coefficients with
    y = (s^2 + c0) / (s^2 + c1*s + c0)*u  ->  a = -c1/2
                                              b = sqrt(c0 - a^2)

  comparing with eigenvalue representation:
    (s - (a+jb))*(s - (a-jb)) = s^2 -2*a*s + a^2 + b^2
  shows that:
    a: real part of eigenvalue
    b: imaginary part of eigenvalue
</pre>

</html>"));
            end bandStop;
          end roots;

          package Utilities "Utility functions for filter computations"
            extends Modelica.Icons.InternalPackage;

            function BesselBaseCoefficients "Return coefficients of normalized low pass Bessel filter (= gain at cut-off frequency 1 rad/s is decreased 3dB)"
              extends Modelica.Icons.Function;
              import Modelica.Utilities.Streams;
              input Integer order "Order of filter in the range 1..41";
              output Real c1[mod(order, 2)] "[p] coefficients of Bessel denominator polynomials (a*p + 1)";
              output Real c2[integer(order / 2), 2] "[p^2, p] coefficients of Bessel denominator polynomials (b2*p^2 + b1*p + 1)";
              output Real alpha "Normalization factor";
            algorithm
              if order == 1 then
                alpha := 1.002377293007601;
                c1[1] := 0.9976283451109835;
              elseif order == 2 then
                alpha := 0.7356641785819585;
                c2[1, 1] := 0.6159132201783791;
                c2[1, 2] := 1.359315879600889;
              elseif order == 3 then
                alpha := 0.5704770156982642;
                c1[1] := 0.7548574865985343;
                c2[1, 1] := 0.4756958028827457;
                c2[1, 2] := 0.9980615136104388;
              elseif order == 4 then
                alpha := 0.4737978580281427;
                c2[1, 1] := 0.4873729247240677;
                c2[1, 2] := 1.337564170455762;
                c2[2, 1] := 0.3877724315741958;
                c2[2, 2] := 0.7730405590839861;
              elseif order == 5 then
                alpha := 0.4126226974763408;
                c1[1] := 0.6645723262620757;
                c2[1, 1] := 0.4115231900614016;
                c2[1, 2] := 1.138349926728708;
                c2[2, 1] := 0.3234938702877912;
                c2[2, 2] := 0.6205992985771313;
              elseif order == 6 then
                alpha := 0.3705098000736233;
                c2[1, 1] := 0.3874508649098960;
                c2[1, 2] := 1.219740879520741;
                c2[2, 1] := 0.3493298843155746;
                c2[2, 2] := 0.9670265529381365;
                c2[3, 1] := 0.2747419229514599;
                c2[3, 2] := 0.5122165075105700;
              elseif order == 7 then
                alpha := 0.3393452623586350;
                c1[1] := 0.5927147125821412;
                c2[1, 1] := 0.3383379423919174;
                c2[1, 2] := 1.092630816438030;
                c2[2, 1] := 0.3001025788696046;
                c2[2, 2] := 0.8289928256598656;
                c2[3, 1] := 0.2372867471539579;
                c2[3, 2] := 0.4325128641920154;
              elseif order == 8 then
                alpha := 0.3150267393795002;
                c2[1, 1] := 0.3151115975207653;
                c2[1, 2] := 1.109403015460190;
                c2[2, 1] := 0.2969344839572762;
                c2[2, 2] := 0.9737455812222699;
                c2[3, 1] := 0.2612545921889538;
                c2[3, 2] := 0.7190394712068573;
                c2[4, 1] := 0.2080523342974281;
                c2[4, 2] := 0.3721456473047434;
              elseif order == 9 then
                alpha := 0.2953310177184124;
                c1[1] := 0.5377196679501422;
                c2[1, 1] := 0.2824689124281034;
                c2[1, 2] := 1.022646191567475;
                c2[2, 1] := 0.2626824161383468;
                c2[2, 2] := 0.8695626454762596;
                c2[3, 1] := 0.2302781917677917;
                c2[3, 2] := 0.6309047553448520;
                c2[4, 1] := 0.1847991729757028;
                c2[4, 2] := 0.3251978031287202;
              elseif order == 10 then
                alpha := 0.2789426890619463;
                c2[1, 1] := 0.2640769908255582;
                c2[1, 2] := 1.019788132875305;
                c2[2, 1] := 0.2540802639216947;
                c2[2, 2] := 0.9377020417760623;
                c2[3, 1] := 0.2343577229427963;
                c2[3, 2] := 0.7802229808216112;
                c2[4, 1] := 0.2052193139338624;
                c2[4, 2] := 0.5594176813008133;
                c2[5, 1] := 0.1659546953748916;
                c2[5, 2] := 0.2878349616233292;
              elseif order == 11 then
                alpha := 0.2650227766037203;
                c1[1] := 0.4950265498954191;
                c2[1, 1] := 0.2411858478546218;
                c2[1, 2] := 0.9567800996387417;
                c2[2, 1] := 0.2296849355380925;
                c2[2, 2] := 0.8592523717113126;
                c2[3, 1] := 0.2107851705677406;
                c2[3, 2] := 0.7040216048898129;
                c2[4, 1] := 0.1846461385164021;
                c2[4, 2] := 0.5006729207276717;
                c2[5, 1] := 0.1504217970817433;
                c2[5, 2] := 0.2575070491320295;
              elseif order == 12 then
                alpha := 0.2530051198547209;
                c2[1, 1] := 0.2268294941204543;
                c2[1, 2] := 0.9473116570034053;
                c2[2, 1] := 0.2207657387793729;
                c2[2, 2] := 0.8933728946287606;
                c2[3, 1] := 0.2087600700376653;
                c2[3, 2] := 0.7886236252756229;
                c2[4, 1] := 0.1909959101492760;
                c2[4, 2] := 0.6389263649257017;
                c2[5, 1] := 0.1675208146048472;
                c2[5, 2] := 0.4517847275162215;
                c2[6, 1] := 0.1374257286372761;
                c2[6, 2] := 0.2324699157474680;
              elseif order == 13 then
                alpha := 0.2424910397561007;
                c1[1] := 0.4608848369928040;
                c2[1, 1] := 0.2099813050274780;
                c2[1, 2] := 0.8992478823790660;
                c2[2, 1] := 0.2027250423101359;
                c2[2, 2] := 0.8328117484224146;
                c2[3, 1] := 0.1907635894058731;
                c2[3, 2] := 0.7257379204691213;
                c2[4, 1] := 0.1742280397887686;
                c2[4, 2] := 0.5830640944868014;
                c2[5, 1] := 0.1530858190490478;
                c2[5, 2] := 0.4106192089751885;
                c2[6, 1] := 0.1264090712880446;
                c2[6, 2] := 0.2114980230156001;
              elseif order == 14 then
                alpha := 0.2331902368695848;
                c2[1, 1] := 0.1986162311411235;
                c2[1, 2] := 0.8876961808055535;
                c2[2, 1] := 0.1946683341271615;
                c2[2, 2] := 0.8500754229171967;
                c2[3, 1] := 0.1868331332895056;
                c2[3, 2] := 0.7764629313723603;
                c2[4, 1] := 0.1752118757862992;
                c2[4, 2] := 0.6699720402924552;
                c2[5, 1] := 0.1598906457908402;
                c2[5, 2] := 0.5348446712848934;
                c2[6, 1] := 0.1407810153019944;
                c2[6, 2] := 0.3755841316563539;
                c2[7, 1] := 0.1169627966707339;
                c2[7, 2] := 0.1937088226304455;
              elseif order == 15 then
                alpha := 0.2248854870552422;
                c1[1] := 0.4328492272335646;
                c2[1, 1] := 0.1857292591004588;
                c2[1, 2] := 0.8496337061962563;
                c2[2, 1] := 0.1808644178280136;
                c2[2, 2] := 0.8020517898136011;
                c2[3, 1] := 0.1728264404199081;
                c2[3, 2] := 0.7247449729331105;
                c2[4, 1] := 0.1616970125901954;
                c2[4, 2] := 0.6205369315943097;
                c2[5, 1] := 0.1475257264578426;
                c2[5, 2] := 0.4929612162355906;
                c2[6, 1] := 0.1301861023357119;
                c2[6, 2] := 0.3454770708040735;
                c2[7, 1] := 0.1087810777120188;
                c2[7, 2] := 0.1784526655428406;
              elseif order == 16 then
                alpha := 0.2174105053474761;
                c2[1, 1] := 0.1765637967473151;
                c2[1, 2] := 0.8377453068635511;
                c2[2, 1] := 0.1738525357503125;
                c2[2, 2] := 0.8102988957433199;
                c2[3, 1] := 0.1684627004613343;
                c2[3, 2] := 0.7563265923413258;
                c2[4, 1] := 0.1604519074815815;
                c2[4, 2] := 0.6776082294687619;
                c2[5, 1] := 0.1498828607802206;
                c2[5, 2] := 0.5766417034027680;
                c2[6, 1] := 0.1367764717792823;
                c2[6, 2] := 0.4563528264410489;
                c2[7, 1] := 0.1209810465419295;
                c2[7, 2] := 0.3193782657322374;
                c2[8, 1] := 0.1016312648007554;
                c2[8, 2] := 0.1652419227369036;
              elseif order == 17 then
                alpha := 0.2106355148193306;
                c1[1] := 0.4093223608497299;
                c2[1, 1] := 0.1664014345826274;
                c2[1, 2] := 0.8067173752345952;
                c2[2, 1] := 0.1629839591538256;
                c2[2, 2] := 0.7712924931447541;
                c2[3, 1] := 0.1573277802512491;
                c2[3, 2] := 0.7134213666303411;
                c2[4, 1] := 0.1494828185148637;
                c2[4, 2] := 0.6347841731714884;
                c2[5, 1] := 0.1394948812681826;
                c2[5, 2] := 0.5375594414619047;
                c2[6, 1] := 0.1273627583380806;
                c2[6, 2] := 0.4241608926375478;
                c2[7, 1] := 0.1129187258461290;
                c2[7, 2] := 0.2965752009703245;
                c2[8, 1] := 0.9533357359908857e-1;
                c2[8, 2] := 0.1537041700889585;
              elseif order == 18 then
                alpha := 0.2044575288651841;
                c2[1, 1] := 0.1588768571976356;
                c2[1, 2] := 0.7951914263212913;
                c2[2, 1] := 0.1569357024981854;
                c2[2, 2] := 0.7744529690772538;
                c2[3, 1] := 0.1530722206358810;
                c2[3, 2] := 0.7335304425992080;
                c2[4, 1] := 0.1473206710524167;
                c2[4, 2] := 0.6735038935387268;
                c2[5, 1] := 0.1397225420331520;
                c2[5, 2] := 0.5959151542621590;
                c2[6, 1] := 0.1303092459809849;
                c2[6, 2] := 0.5026483447894845;
                c2[7, 1] := 0.1190627367060072;
                c2[7, 2] := 0.3956893824587150;
                c2[8, 1] := 0.1058058030798994;
                c2[8, 2] := 0.2765091830730650;
                c2[9, 1] := 0.8974708108800873e-1;
                c2[9, 2] := 0.1435505288284833;
              elseif order == 19 then
                alpha := 0.1987936248083529;
                c1[1] := 0.3892259966869526;
                c2[1, 1] := 0.1506640012172225;
                c2[1, 2] := 0.7693121733774260;
                c2[2, 1] := 0.1481728062796673;
                c2[2, 2] := 0.7421133586741549;
                c2[3, 1] := 0.1440444668388838;
                c2[3, 2] := 0.6975075386214800;
                c2[4, 1] := 0.1383101628540374;
                c2[4, 2] := 0.6365464378910025;
                c2[5, 1] := 0.1310032283190998;
                c2[5, 2] := 0.5606211948462122;
                c2[6, 1] := 0.1221431166405330;
                c2[6, 2] := 0.4713530424221445;
                c2[7, 1] := 0.1116991161103884;
                c2[7, 2] := 0.3703717538617073;
                c2[8, 1] := 0.9948917351196349e-1;
                c2[8, 2] := 0.2587371155559744;
                c2[9, 1] := 0.8475989238107367e-1;
                c2[9, 2] := 0.1345537894555993;
              elseif order == 20 then
                alpha := 0.1935761760416219;
                c2[1, 1] := 0.1443871348337404;
                c2[1, 2] := 0.7584165598446141;
                c2[2, 1] := 0.1429501891353184;
                c2[2, 2] := 0.7423000962318863;
                c2[3, 1] := 0.1400877384920004;
                c2[3, 2] := 0.7104185332215555;
                c2[4, 1] := 0.1358210369491446;
                c2[4, 2] := 0.6634599783272630;
                c2[5, 1] := 0.1301773703034290;
                c2[5, 2] := 0.6024175491895959;
                c2[6, 1] := 0.1231826501439148;
                c2[6, 2] := 0.5285332736326852;
                c2[7, 1] := 0.1148465498575254;
                c2[7, 2] := 0.4431977385498628;
                c2[8, 1] := 0.1051289462376788;
                c2[8, 2] := 0.3477444062821162;
                c2[9, 1] := 0.9384622797485121e-1;
                c2[9, 2] := 0.2429038300327729;
                c2[10, 1] := 0.8028211612831444e-1;
                c2[10, 2] := 0.1265329974009533;
              elseif order == 21 then
                alpha := 0.1887494014766075;
                c1[1] := 0.3718070668941645;
                c2[1, 1] := 0.1376151928386445;
                c2[1, 2] := 0.7364290859445481;
                c2[2, 1] := 0.1357438914390695;
                c2[2, 2] := 0.7150167318935022;
                c2[3, 1] := 0.1326398453462415;
                c2[3, 2] := 0.6798001808470175;
                c2[4, 1] := 0.1283231214897678;
                c2[4, 2] := 0.6314663440439816;
                c2[5, 1] := 0.1228169159777534;
                c2[5, 2] := 0.5709353626166905;
                c2[6, 1] := 0.1161406100773184;
                c2[6, 2] := 0.4993087153571335;
                c2[7, 1] := 0.1082959649233524;
                c2[7, 2] := 0.4177766148584385;
                c2[8, 1] := 0.9923596957485723e-1;
                c2[8, 2] := 0.3274257287232124;
                c2[9, 1] := 0.8877776108724853e-1;
                c2[9, 2] := 0.2287218166767916;
                c2[10, 1] := 0.7624076527736326e-1;
                c2[10, 2] := 0.1193423971506988;
              elseif order == 22 then
                alpha := 0.1842668221199706;
                c2[1, 1] := 0.1323053462701543;
                c2[1, 2] := 0.7262446126765204;
                c2[2, 1] := 0.1312121721769772;
                c2[2, 2] := 0.7134286088450949;
                c2[3, 1] := 0.1290330911166814;
                c2[3, 2] := 0.6880287870435514;
                c2[4, 1] := 0.1257817990372067;
                c2[4, 2] := 0.6505015800059301;
                c2[5, 1] := 0.1214765261983008;
                c2[5, 2] := 0.6015107185211451;
                c2[6, 1] := 0.1161365140967959;
                c2[6, 2] := 0.5418983553698413;
                c2[7, 1] := 0.1097755171533100;
                c2[7, 2] := 0.4726370779831614;
                c2[8, 1] := 0.1023889478519956;
                c2[8, 2] := 0.3947439506537486;
                c2[9, 1] := 0.9392485861253800e-1;
                c2[9, 2] := 0.3090996703083202;
                c2[10, 1] := 0.8420273775456455e-1;
                c2[10, 2] := 0.2159561978556017;
                c2[11, 1] := 0.7257600023938262e-1;
                c2[11, 2] := 0.1128633732721116;
              elseif order == 23 then
                alpha := 0.1800893554453722;
                c1[1] := 0.3565232673929280;
                c2[1, 1] := 0.1266275171652706;
                c2[1, 2] := 0.7072778066734162;
                c2[2, 1] := 0.1251865227648538;
                c2[2, 2] := 0.6900676345785905;
                c2[3, 1] := 0.1227944815236645;
                c2[3, 2] := 0.6617011100576023;
                c2[4, 1] := 0.1194647013077667;
                c2[4, 2] := 0.6226432315773119;
                c2[5, 1] := 0.1152132989252356;
                c2[5, 2] := 0.5735222810625359;
                c2[6, 1] := 0.1100558598478487;
                c2[6, 2] := 0.5151027978024605;
                c2[7, 1] := 0.1040013558214886;
                c2[7, 2] := 0.4482410942032739;
                c2[8, 1] := 0.9704014176512626e-1;
                c2[8, 2] := 0.3738049984631116;
                c2[9, 1] := 0.8911683905758054e-1;
                c2[9, 2] := 0.2925028692588410;
                c2[10, 1] := 0.8005438265072295e-1;
                c2[10, 2] := 0.2044134600278901;
                c2[11, 1] := 0.6923832296800832e-1;
                c2[11, 2] := 0.1069984887283394;
              elseif order == 24 then
                alpha := 0.1761838665838427;
                c2[1, 1] := 0.1220804912720132;
                c2[1, 2] := 0.6978026874156063;
                c2[2, 1] := 0.1212296762358897;
                c2[2, 2] := 0.6874139794926736;
                c2[3, 1] := 0.1195328372961027;
                c2[3, 2] := 0.6667954259551859;
                c2[4, 1] := 0.1169990987333593;
                c2[4, 2] := 0.6362602049901176;
                c2[5, 1] := 0.1136409040480130;
                c2[5, 2] := 0.5962662188435553;
                c2[6, 1] := 0.1094722001757955;
                c2[6, 2] := 0.5474001634109253;
                c2[7, 1] := 0.1045052832229087;
                c2[7, 2] := 0.4903523180249535;
                c2[8, 1] := 0.9874509806025907e-1;
                c2[8, 2] := 0.4258751523524645;
                c2[9, 1] := 0.9217799943472177e-1;
                c2[9, 2] := 0.3547079765396403;
                c2[10, 1] := 0.8474633796250476e-1;
                c2[10, 2] := 0.2774145482392767;
                c2[11, 1] := 0.7627722381240495e-1;
                c2[11, 2] := 0.1939329108084139;
                c2[12, 1] := 0.6618645465422745e-1;
                c2[12, 2] := 0.1016670147947242;
              elseif order == 25 then
                alpha := 0.1725220521949266;
                c1[1] := 0.3429735385896000;
                c2[1, 1] := 0.1172525033170618;
                c2[1, 2] := 0.6812327932576614;
                c2[2, 1] := 0.1161194585333535;
                c2[2, 2] := 0.6671566071153211;
                c2[3, 1] := 0.1142375145794466;
                c2[3, 2] := 0.6439167855053158;
                c2[4, 1] := 0.1116157454252308;
                c2[4, 2] := 0.6118378416180135;
                c2[5, 1] := 0.1082654809459177;
                c2[5, 2] := 0.5713609763370088;
                c2[6, 1] := 0.1041985674230918;
                c2[6, 2] := 0.5230289949762722;
                c2[7, 1] := 0.9942439308123559e-1;
                c2[7, 2] := 0.4674627926041906;
                c2[8, 1] := 0.9394453593830893e-1;
                c2[8, 2] := 0.4053226688298811;
                c2[9, 1] := 0.8774221237222533e-1;
                c2[9, 2] := 0.3372372276379071;
                c2[10, 1] := 0.8075839512216483e-1;
                c2[10, 2] := 0.2636485508005428;
                c2[11, 1] := 0.7282483286646764e-1;
                c2[11, 2] := 0.1843801345273085;
                c2[12, 1] := 0.6338571166846652e-1;
                c2[12, 2] := 0.9680153764737715e-1;
              elseif order == 26 then
                alpha := 0.1690795702796737;
                c2[1, 1] := 0.1133168695796030;
                c2[1, 2] := 0.6724297955493932;
                c2[2, 1] := 0.1126417845769961;
                c2[2, 2] := 0.6638709519790540;
                c2[3, 1] := 0.1112948749545606;
                c2[3, 2] := 0.6468652038763624;
                c2[4, 1] := 0.1092823986944244;
                c2[4, 2] := 0.6216337070799265;
                c2[5, 1] := 0.1066130386697976;
                c2[5, 2] := 0.5885011413992190;
                c2[6, 1] := 0.1032969057045413;
                c2[6, 2] := 0.5478864278297548;
                c2[7, 1] := 0.9934388184210715e-1;
                c2[7, 2] := 0.5002885306054287;
                c2[8, 1] := 0.9476081523436283e-1;
                c2[8, 2] := 0.4462644847551711;
                c2[9, 1] := 0.8954648464575577e-1;
                c2[9, 2] := 0.3863930785049522;
                c2[10, 1] := 0.8368166847159917e-1;
                c2[10, 2] := 0.3212074592527143;
                c2[11, 1] := 0.7710664731701103e-1;
                c2[11, 2] := 0.2510470347119383;
                c2[12, 1] := 0.6965807988411425e-1;
                c2[12, 2] := 0.1756419294111342;
                c2[13, 1] := 0.6080674930548766e-1;
                c2[13, 2] := 0.9234535279274277e-1;
              elseif order == 27 then
                alpha := 0.1658353543067995;
                c1[1] := 0.3308543720638957;
                c2[1, 1] := 0.1091618578712746;
                c2[1, 2] := 0.6577977071169651;
                c2[2, 1] := 0.1082549561495043;
                c2[2, 2] := 0.6461121666520275;
                c2[3, 1] := 0.1067479247890451;
                c2[3, 2] := 0.6267937760991321;
                c2[4, 1] := 0.1046471079537577;
                c2[4, 2] := 0.6000750116745808;
                c2[5, 1] := 0.1019605976654259;
                c2[5, 2] := 0.5662734183049320;
                c2[6, 1] := 0.9869726954433709e-1;
                c2[6, 2] := 0.5257827234948534;
                c2[7, 1] := 0.9486520934132483e-1;
                c2[7, 2] := 0.4790595019077763;
                c2[8, 1] := 0.9046906518775348e-1;
                c2[8, 2] := 0.4266025862147336;
                c2[9, 1] := 0.8550529998276152e-1;
                c2[9, 2] := 0.3689188223512328;
                c2[10, 1] := 0.7995282239306020e-1;
                c2[10, 2] := 0.3064589322702932;
                c2[11, 1] := 0.7375174596252882e-1;
                c2[11, 2] := 0.2394754504667310;
                c2[12, 1] := 0.6674377263329041e-1;
                c2[12, 2] := 0.1676223546666024;
                c2[13, 1] := 0.5842458027529246e-1;
                c2[13, 2] := 0.8825044329219431e-1;
              elseif order == 28 then
                alpha := 0.1627710671942929;
                c2[1, 1] := 0.1057232656113488;
                c2[1, 2] := 0.6496161226860832;
                c2[2, 1] := 0.1051786825724864;
                c2[2, 2] := 0.6424661279909941;
                c2[3, 1] := 0.1040917964935006;
                c2[3, 2] := 0.6282470268918791;
                c2[4, 1] := 0.1024670101953951;
                c2[4, 2] := 0.6071189030701136;
                c2[5, 1] := 0.1003105109519892;
                c2[5, 2] := 0.5793175191747016;
                c2[6, 1] := 0.9762969425430802e-1;
                c2[6, 2] := 0.5451486608855443;
                c2[7, 1] := 0.9443223803058400e-1;
                c2[7, 2] := 0.5049796971628137;
                c2[8, 1] := 0.9072460982036488e-1;
                c2[8, 2] := 0.4592270546572523;
                c2[9, 1] := 0.8650956423253280e-1;
                c2[9, 2] := 0.4083368605952977;
                c2[10, 1] := 0.8178165740374893e-1;
                c2[10, 2] := 0.3527525188880655;
                c2[11, 1] := 0.7651838885868020e-1;
                c2[11, 2] := 0.2928534570013572;
                c2[12, 1] := 0.7066010532447490e-1;
                c2[12, 2] := 0.2288185204390681;
                c2[13, 1] := 0.6405358596145789e-1;
                c2[13, 2] := 0.1602396172588190;
                c2[14, 1] := 0.5621780070227172e-1;
                c2[14, 2] := 0.8447589564915071e-1;
              elseif order == 29 then
                alpha := 0.1598706626277596;
                c1[1] := 0.3199314513011623;
                c2[1, 1] := 0.1021101032532951;
                c2[1, 2] := 0.6365758882240111;
                c2[2, 1] := 0.1013729819392774;
                c2[2, 2] := 0.6267495975736321;
                c2[3, 1] := 0.1001476175660628;
                c2[3, 2] := 0.6104876178266819;
                c2[4, 1] := 0.9843854640428316e-1;
                c2[4, 2] := 0.5879603139195113;
                c2[5, 1] := 0.9625164534591696e-1;
                c2[5, 2] := 0.5594012291050210;
                c2[6, 1] := 0.9359356960417668e-1;
                c2[6, 2] := 0.5251016150410664;
                c2[7, 1] := 0.9047086748649986e-1;
                c2[7, 2] := 0.4854024475590397;
                c2[8, 1] := 0.8688856407189167e-1;
                c2[8, 2] := 0.4406826457109709;
                c2[9, 1] := 0.8284779224069856e-1;
                c2[9, 2] := 0.3913408089298914;
                c2[10, 1] := 0.7834154620997181e-1;
                c2[10, 2] := 0.3377643999400627;
                c2[11, 1] := 0.7334628941928766e-1;
                c2[11, 2] := 0.2802710651919946;
                c2[12, 1] := 0.6780290487362146e-1;
                c2[12, 2] := 0.2189770008083379;
                c2[13, 1] := 0.6156321231528423e-1;
                c2[13, 2] := 0.1534235999306070;
                c2[14, 1] := 0.5416797446761512e-1;
                c2[14, 2] := 0.8098664736760292e-1;
              elseif order == 30 then
                alpha := 0.1571200296252450;
                c2[1, 1] := 0.9908074847842124e-1;
                c2[1, 2] := 0.6289618807831557;
                c2[2, 1] := 0.9863509708328196e-1;
                c2[2, 2] := 0.6229164525571278;
                c2[3, 1] := 0.9774542692037148e-1;
                c2[3, 2] := 0.6108853364240036;
                c2[4, 1] := 0.9641490581986484e-1;
                c2[4, 2] := 0.5929869253412513;
                c2[5, 1] := 0.9464802912225441e-1;
                c2[5, 2] := 0.5693960175547550;
                c2[6, 1] := 0.9245027206218041e-1;
                c2[6, 2] := 0.5403402396359503;
                c2[7, 1] := 0.8982754584112941e-1;
                c2[7, 2] := 0.5060948065875106;
                c2[8, 1] := 0.8678535291732599e-1;
                c2[8, 2] := 0.4669749797983789;
                c2[9, 1] := 0.8332744242052199e-1;
                c2[9, 2] := 0.4233249626334694;
                c2[10, 1] := 0.7945356393775309e-1;
                c2[10, 2] := 0.3755006094498054;
                c2[11, 1] := 0.7515543969833788e-1;
                c2[11, 2] := 0.3238400339292700;
                c2[12, 1] := 0.7040879901685638e-1;
                c2[12, 2] := 0.2686072427439079;
                c2[13, 1] := 0.6515528854010540e-1;
                c2[13, 2] := 0.2098650589782619;
                c2[14, 1] := 0.5925168237177876e-1;
                c2[14, 2] := 0.1471138832654873;
                c2[15, 1] := 0.5225913954211672e-1;
                c2[15, 2] := 0.7775248839507864e-1;
              elseif order == 31 then
                alpha := 0.1545067022920929;
                c1[1] := 0.3100206996451866;
                c2[1, 1] := 0.9591020358831668e-1;
                c2[1, 2] := 0.6172474793293396;
                c2[2, 1] := 0.9530301275601203e-1;
                c2[2, 2] := 0.6088916323460413;
                c2[3, 1] := 0.9429332655402368e-1;
                c2[3, 2] := 0.5950511595503025;
                c2[4, 1] := 0.9288445429894548e-1;
                c2[4, 2] := 0.5758534119053522;
                c2[5, 1] := 0.9108073420087422e-1;
                c2[5, 2] := 0.5514734636081183;
                c2[6, 1] := 0.8888719137536870e-1;
                c2[6, 2] := 0.5221306199481831;
                c2[7, 1] := 0.8630901440239650e-1;
                c2[7, 2] := 0.4880834248148061;
                c2[8, 1] := 0.8335074993373294e-1;
                c2[8, 2] := 0.4496225358496770;
                c2[9, 1] := 0.8001502494376102e-1;
                c2[9, 2] := 0.4070602306679052;
                c2[10, 1] := 0.7630041338037624e-1;
                c2[10, 2] := 0.3607139804818122;
                c2[11, 1] := 0.7219760885744920e-1;
                c2[11, 2] := 0.3108783301229550;
                c2[12, 1] := 0.6768185077153345e-1;
                c2[12, 2] := 0.2577706252514497;
                c2[13, 1] := 0.6269571766328638e-1;
                c2[13, 2] := 0.2014081375889921;
                c2[14, 1] := 0.5710081766945065e-1;
                c2[14, 2] := 0.1412581515841926;
                c2[15, 1] := 0.5047740914807019e-1;
                c2[15, 2] := 0.7474725873250158e-1;
              elseif order == 32 then
                alpha := 0.1520196210848210;
                c2[1, 1] := 0.9322163554339406e-1;
                c2[1, 2] := 0.6101488690506050;
                c2[2, 1] := 0.9285233997694042e-1;
                c2[2, 2] := 0.6049832320721264;
                c2[3, 1] := 0.9211494244473163e-1;
                c2[3, 2] := 0.5946969295569034;
                c2[4, 1] := 0.9101176786042449e-1;
                c2[4, 2] := 0.5793791854364477;
                c2[5, 1] := 0.8954614071360517e-1;
                c2[5, 2] := 0.5591619969234026;
                c2[6, 1] := 0.8772216763680164e-1;
                c2[6, 2] := 0.5342177994699602;
                c2[7, 1] := 0.8554440426912734e-1;
                c2[7, 2] := 0.5047560942986598;
                c2[8, 1] := 0.8301735302045588e-1;
                c2[8, 2] := 0.4710187048140929;
                c2[9, 1] := 0.8014469519188161e-1;
                c2[9, 2] := 0.4332730387207936;
                c2[10, 1] := 0.7692807528893225e-1;
                c2[10, 2] := 0.3918021436411035;
                c2[11, 1] := 0.7336507157284898e-1;
                c2[11, 2] := 0.3468890521471250;
                c2[12, 1] := 0.6944555312763458e-1;
                c2[12, 2] := 0.2987898029050460;
                c2[13, 1] := 0.6514446669420571e-1;
                c2[13, 2] := 0.2476810747407199;
                c2[14, 1] := 0.6040544477732702e-1;
                c2[14, 2] := 0.1935412053397663;
                c2[15, 1] := 0.5509478650672775e-1;
                c2[15, 2] := 0.1358108994174911;
                c2[16, 1] := 0.4881064725720192e-1;
                c2[16, 2] := 0.7194819894416505e-1;
              elseif order == 33 then
                alpha := 0.1496489351138032;
                c1[1] := 0.3009752799176432;
                c2[1, 1] := 0.9041725460994505e-1;
                c2[1, 2] := 0.5995521047364046;
                c2[2, 1] := 0.8991117804113002e-1;
                c2[2, 2] := 0.5923764112099496;
                c2[3, 1] := 0.8906941547422532e-1;
                c2[3, 2] := 0.5804822013853129;
                c2[4, 1] := 0.8789442491445575e-1;
                c2[4, 2] := 0.5639663528946501;
                c2[5, 1] := 0.8638945831033775e-1;
                c2[5, 2] := 0.5429623519607796;
                c2[6, 1] := 0.8455834602616358e-1;
                c2[6, 2] := 0.5176379938389326;
                c2[7, 1] := 0.8240517431382334e-1;
                c2[7, 2] := 0.4881921474066189;
                c2[8, 1] := 0.7993380417355076e-1;
                c2[8, 2] := 0.4548502528082586;
                c2[9, 1] := 0.7714713890732801e-1;
                c2[9, 2] := 0.4178579388038483;
                c2[10, 1] := 0.7404596598181127e-1;
                c2[10, 2] := 0.3774715722484659;
                c2[11, 1] := 0.7062702339160462e-1;
                c2[11, 2] := 0.3339432938810453;
                c2[12, 1] := 0.6687952672391507e-1;
                c2[12, 2] := 0.2874950693388235;
                c2[13, 1] := 0.6277828912909767e-1;
                c2[13, 2] := 0.2382680702894708;
                c2[14, 1] := 0.5826808305383988e-1;
                c2[14, 2] := 0.1862073169968455;
                c2[15, 1] := 0.5321974125363517e-1;
                c2[15, 2] := 0.1307323751236313;
                c2[16, 1] := 0.4724820282032780e-1;
                c2[16, 2] := 0.6933542082177094e-1;
              elseif order == 34 then
                alpha := 0.1473858373968463;
                c2[1, 1] := 0.8801537152275983e-1;
                c2[1, 2] := 0.5929204288972172;
                c2[2, 1] := 0.8770594341007476e-1;
                c2[2, 2] := 0.5884653382247518;
                c2[3, 1] := 0.8708797598072095e-1;
                c2[3, 2] := 0.5795895850253119;
                c2[4, 1] := 0.8616320590689187e-1;
                c2[4, 2] := 0.5663615383647170;
                c2[5, 1] := 0.8493413175570858e-1;
                c2[5, 2] := 0.5488825092350877;
                c2[6, 1] := 0.8340387368687513e-1;
                c2[6, 2] := 0.5272851839324592;
                c2[7, 1] := 0.8157596213131521e-1;
                c2[7, 2] := 0.5017313864372913;
                c2[8, 1] := 0.7945402670834270e-1;
                c2[8, 2] := 0.4724089864574216;
                c2[9, 1] := 0.7704133559556429e-1;
                c2[9, 2] := 0.4395276256463053;
                c2[10, 1] := 0.7434009635219704e-1;
                c2[10, 2] := 0.4033126590648964;
                c2[11, 1] := 0.7135035113853376e-1;
                c2[11, 2] := 0.3639961488919042;
                c2[12, 1] := 0.6806813160738834e-1;
                c2[12, 2] := 0.3218025212900124;
                c2[13, 1] := 0.6448214312000864e-1;
                c2[13, 2] := 0.2769235521088158;
                c2[14, 1] := 0.6056719318430530e-1;
                c2[14, 2] := 0.2294693573271038;
                c2[15, 1] := 0.5626925196925040e-1;
                c2[15, 2] := 0.1793564218840015;
                c2[16, 1] := 0.5146352031547277e-1;
                c2[16, 2] := 0.1259877129326412;
                c2[17, 1] := 0.4578069074410591e-1;
                c2[17, 2] := 0.6689147319568768e-1;
              elseif order == 35 then
                alpha := 0.1452224267615486;
                c1[1] := 0.2926764667564367;
                c2[1, 1] := 0.8551731299267280e-1;
                c2[1, 2] := 0.5832758214629523;
                c2[2, 1] := 0.8509109732853060e-1;
                c2[2, 2] := 0.5770596582643844;
                c2[3, 1] := 0.8438201446671953e-1;
                c2[3, 2] := 0.5667497616665494;
                c2[4, 1] := 0.8339191981579831e-1;
                c2[4, 2] := 0.5524209816238369;
                c2[5, 1] := 0.8212328610083385e-1;
                c2[5, 2] := 0.5341766459916322;
                c2[6, 1] := 0.8057906332198853e-1;
                c2[6, 2] := 0.5121470053512750;
                c2[7, 1] := 0.7876247299954955e-1;
                c2[7, 2] := 0.4864870722254752;
                c2[8, 1] := 0.7667670879950268e-1;
                c2[8, 2] := 0.4573736721705665;
                c2[9, 1] := 0.7432449556218945e-1;
                c2[9, 2] := 0.4250013835198991;
                c2[10, 1] := 0.7170742126011575e-1;
                c2[10, 2] := 0.3895767735915445;
                c2[11, 1] := 0.6882488171701314e-1;
                c2[11, 2] := 0.3513097926737368;
                c2[12, 1] := 0.6567231746957568e-1;
                c2[12, 2] := 0.3103999917596611;
                c2[13, 1] := 0.6223804362223595e-1;
                c2[13, 2] := 0.2670123611280899;
                c2[14, 1] := 0.5849696460782910e-1;
                c2[14, 2] := 0.2212298104867592;
                c2[15, 1] := 0.5439628409499822e-1;
                c2[15, 2] := 0.1729443731341637;
                c2[16, 1] := 0.4981540179136920e-1;
                c2[16, 2] := 0.1215462157134930;
                c2[17, 1] := 0.4439981033536435e-1;
                c2[17, 2] := 0.6460098363520967e-1;
              elseif order == 36 then
                alpha := 0.1431515914458580;
                c2[1, 1] := 0.8335881847130301e-1;
                c2[1, 2] := 0.5770670512160201;
                c2[2, 1] := 0.8309698922852212e-1;
                c2[2, 2] := 0.5731929100172432;
                c2[3, 1] := 0.8257400347039723e-1;
                c2[3, 2] := 0.5654713811993058;
                c2[4, 1] := 0.8179117911600136e-1;
                c2[4, 2] := 0.5539556343603020;
                c2[5, 1] := 0.8075042173126963e-1;
                c2[5, 2] := 0.5387245649546684;
                c2[6, 1] := 0.7945413151258206e-1;
                c2[6, 2] := 0.5198817177723069;
                c2[7, 1] := 0.7790506514288866e-1;
                c2[7, 2] := 0.4975537629595409;
                c2[8, 1] := 0.7610613635339480e-1;
                c2[8, 2] := 0.4718884193866789;
                c2[9, 1] := 0.7406012816626425e-1;
                c2[9, 2] := 0.4430516443136726;
                c2[10, 1] := 0.7176927060205631e-1;
                c2[10, 2] := 0.4112237708115829;
                c2[11, 1] := 0.6923460172504251e-1;
                c2[11, 2] := 0.3765940116389730;
                c2[12, 1] := 0.6645495833489556e-1;
                c2[12, 2] := 0.3393522147815403;
                c2[13, 1] := 0.6342528888937094e-1;
                c2[13, 2] := 0.2996755899575573;
                c2[14, 1] := 0.6013361864949449e-1;
                c2[14, 2] := 0.2577053294053830;
                c2[15, 1] := 0.5655503081322404e-1;
                c2[15, 2] := 0.2135004731531631;
                c2[16, 1] := 0.5263798119559069e-1;
                c2[16, 2] := 0.1669320999865636;
                c2[17, 1] := 0.4826589873626196e-1;
                c2[17, 2] := 0.1173807590715484;
                c2[18, 1] := 0.4309819397289806e-1;
                c2[18, 2] := 0.6245036108880222e-1;
              elseif order == 37 then
                alpha := 0.1411669104782917;
                c1[1] := 0.2850271036215707;
                c2[1, 1] := 0.8111958235023328e-1;
                c2[1, 2] := 0.5682412610563970;
                c2[2, 1] := 0.8075727567979578e-1;
                c2[2, 2] := 0.5628142923227016;
                c2[3, 1] := 0.8015440554413301e-1;
                c2[3, 2] := 0.5538087696879930;
                c2[4, 1] := 0.7931239302677386e-1;
                c2[4, 2] := 0.5412833323304460;
                c2[5, 1] := 0.7823314328639347e-1;
                c2[5, 2] := 0.5253190555393968;
                c2[6, 1] := 0.7691895211595101e-1;
                c2[6, 2] := 0.5060183741977191;
                c2[7, 1] := 0.7537237072011853e-1;
                c2[7, 2] := 0.4835036020049034;
                c2[8, 1] := 0.7359601294804538e-1;
                c2[8, 2] := 0.4579149413954837;
                c2[9, 1] := 0.7159227884849299e-1;
                c2[9, 2] := 0.4294078049978829;
                c2[10, 1] := 0.6936295002846032e-1;
                c2[10, 2] := 0.3981491350382047;
                c2[11, 1] := 0.6690857785828917e-1;
                c2[11, 2] := 0.3643121502867948;
                c2[12, 1] := 0.6422751692085542e-1;
                c2[12, 2] := 0.3280684291406284;
                c2[13, 1] := 0.6131430866206096e-1;
                c2[13, 2] := 0.2895750997170303;
                c2[14, 1] := 0.5815677249570920e-1;
                c2[14, 2] := 0.2489521814805720;
                c2[15, 1] := 0.5473023527947980e-1;
                c2[15, 2] := 0.2062377435955363;
                c2[16, 1] := 0.5098441033167034e-1;
                c2[16, 2] := 0.1612849131645336;
                c2[17, 1] := 0.4680658811093562e-1;
                c2[17, 2] := 0.1134672937045305;
                c2[18, 1] := 0.4186928031694695e-1;
                c2[18, 2] := 0.6042754777339966e-1;
              elseif order == 38 then
                alpha := 0.1392625697140030;
                c2[1, 1] := 0.7916943373658329e-1;
                c2[1, 2] := 0.5624158631591745;
                c2[2, 1] := 0.7894592250257840e-1;
                c2[2, 2] := 0.5590219398777304;
                c2[3, 1] := 0.7849941672384930e-1;
                c2[3, 2] := 0.5522551628416841;
                c2[4, 1] := 0.7783093084875645e-1;
                c2[4, 2] := 0.5421574325808380;
                c2[5, 1] := 0.7694193770482690e-1;
                c2[5, 2] := 0.5287909941093643;
                c2[6, 1] := 0.7583430534712885e-1;
                c2[6, 2] := 0.5122376814029880;
                c2[7, 1] := 0.7451020436122948e-1;
                c2[7, 2] := 0.4925978555548549;
                c2[8, 1] := 0.7297197617673508e-1;
                c2[8, 2] := 0.4699889739625235;
                c2[9, 1] := 0.7122194706992953e-1;
                c2[9, 2] := 0.4445436860615774;
                c2[10, 1] := 0.6926216260386816e-1;
                c2[10, 2] := 0.4164072786327193;
                c2[11, 1] := 0.6709399961255503e-1;
                c2[11, 2] := 0.3857341621868851;
                c2[12, 1] := 0.6471757977022456e-1;
                c2[12, 2] := 0.3526828388476838;
                c2[13, 1] := 0.6213084287116965e-1;
                c2[13, 2] := 0.3174082831364342;
                c2[14, 1] := 0.5932799638550641e-1;
                c2[14, 2] := 0.2800495563550299;
                c2[15, 1] := 0.5629672408524944e-1;
                c2[15, 2] := 0.2407078154782509;
                c2[16, 1] := 0.5301264751544952e-1;
                c2[16, 2] := 0.1994026830553859;
                c2[17, 1] := 0.4942673259817896e-1;
                c2[17, 2] := 0.1559719194038917;
                c2[18, 1] := 0.4542996716979947e-1;
                c2[18, 2] := 0.1097844277878470;
                c2[19, 1] := 0.4070720755433961e-1;
                c2[19, 2] := 0.5852181110523043e-1;
              elseif order == 39 then
                alpha := 0.1374332900196804;
                c1[1] := 0.2779468246419593;
                c2[1, 1] := 0.7715084161825772e-1;
                c2[1, 2] := 0.5543001331300056;
                c2[2, 1] := 0.7684028301163326e-1;
                c2[2, 2] := 0.5495289890712267;
                c2[3, 1] := 0.7632343924866024e-1;
                c2[3, 2] := 0.5416083298429741;
                c2[4, 1] := 0.7560141319808483e-1;
                c2[4, 2] := 0.5305846713929198;
                c2[5, 1] := 0.7467569064745969e-1;
                c2[5, 2] := 0.5165224112570647;
                c2[6, 1] := 0.7354807648551346e-1;
                c2[6, 2] := 0.4995030679271456;
                c2[7, 1] := 0.7222060351121389e-1;
                c2[7, 2] := 0.4796242430956156;
                c2[8, 1] := 0.7069540462458585e-1;
                c2[8, 2] := 0.4569982440368368;
                c2[9, 1] := 0.6897453353492381e-1;
                c2[9, 2] := 0.4317502624832354;
                c2[10, 1] := 0.6705970959388781e-1;
                c2[10, 2] := 0.4040159353969854;
                c2[11, 1] := 0.6495194541066725e-1;
                c2[11, 2] := 0.3739379843169939;
                c2[12, 1] := 0.6265098412417610e-1;
                c2[12, 2] := 0.3416613843816217;
                c2[13, 1] := 0.6015440984955930e-1;
                c2[13, 2] := 0.3073260166338746;
                c2[14, 1] := 0.5745615876877304e-1;
                c2[14, 2] := 0.2710546723961181;
                c2[15, 1] := 0.5454383762391338e-1;
                c2[15, 2] := 0.2329316824061170;
                c2[16, 1] := 0.5139340231935751e-1;
                c2[16, 2] := 0.1929604256043231;
                c2[17, 1] := 0.4795705862458131e-1;
                c2[17, 2] := 0.1509655259246037;
                c2[18, 1] := 0.4412933231935506e-1;
                c2[18, 2] := 0.1063130748962878;
                c2[19, 1] := 0.3960672309405603e-1;
                c2[19, 2] := 0.5672356837211527e-1;
              elseif order == 40 then
                alpha := 0.1356742655825434;
                c2[1, 1] := 0.7538038374294594e-1;
                c2[1, 2] := 0.5488228264329617;
                c2[2, 1] := 0.7518806529402738e-1;
                c2[2, 2] := 0.5458297722483311;
                c2[3, 1] := 0.7480383050347119e-1;
                c2[3, 2] := 0.5398604576730540;
                c2[4, 1] := 0.7422847031965465e-1;
                c2[4, 2] := 0.5309482987446206;
                c2[5, 1] := 0.7346313704205006e-1;
                c2[5, 2] := 0.5191429845322307;
                c2[6, 1] := 0.7250930053201402e-1;
                c2[6, 2] := 0.5045099368431007;
                c2[7, 1] := 0.7136868456879621e-1;
                c2[7, 2] := 0.4871295553902607;
                c2[8, 1] := 0.7004317764946634e-1;
                c2[8, 2] := 0.4670962098860498;
                c2[9, 1] := 0.6853470921527828e-1;
                c2[9, 2] := 0.4445169164956202;
                c2[10, 1] := 0.6684507689945471e-1;
                c2[10, 2] := 0.4195095960479698;
                c2[11, 1] := 0.6497570123412630e-1;
                c2[11, 2] := 0.3922007419030645;
                c2[12, 1] := 0.6292726794917847e-1;
                c2[12, 2] := 0.3627221993494397;
                c2[13, 1] := 0.6069918741663154e-1;
                c2[13, 2] := 0.3312065181294388;
                c2[14, 1] := 0.5828873983769410e-1;
                c2[14, 2] := 0.2977798532686911;
                c2[15, 1] := 0.5568964389813015e-1;
                c2[15, 2] := 0.2625503293999835;
                c2[16, 1] := 0.5288947816690705e-1;
                c2[16, 2] := 0.2255872486520188;
                c2[17, 1] := 0.4986456327645859e-1;
                c2[17, 2] := 0.1868796731919594;
                c2[18, 1] := 0.4656832613054458e-1;
                c2[18, 2] := 0.1462410193532463;
                c2[19, 1] := 0.4289867647614935e-1;
                c2[19, 2] := 0.1030361558710747;
                c2[20, 1] := 0.3856310684054106e-1;
                c2[20, 2] := 0.5502423832293889e-1;
              elseif order == 41 then
                alpha := 0.1339811106984253;
                c1[1] := 0.2713685065531391;
                c2[1, 1] := 0.7355140275160984e-1;
                c2[1, 2] := 0.5413274778282860;
                c2[2, 1] := 0.7328319082267173e-1;
                c2[2, 2] := 0.5371064088294270;
                c2[3, 1] := 0.7283676160772547e-1;
                c2[3, 2] := 0.5300963437270770;
                c2[4, 1] := 0.7221298133014343e-1;
                c2[4, 2] := 0.5203345998371490;
                c2[5, 1] := 0.7141302173623395e-1;
                c2[5, 2] := 0.5078728971879841;
                c2[6, 1] := 0.7043831559982149e-1;
                c2[6, 2] := 0.4927768111819803;
                c2[7, 1] := 0.6929049381827268e-1;
                c2[7, 2] := 0.4751250308594139;
                c2[8, 1] := 0.6797129849758392e-1;
                c2[8, 2] := 0.4550083840638406;
                c2[9, 1] := 0.6648246325101609e-1;
                c2[9, 2] := 0.4325285673076087;
                c2[10, 1] := 0.6482554675958526e-1;
                c2[10, 2] := 0.4077964789091151;
                c2[11, 1] := 0.6300169683004558e-1;
                c2[11, 2] := 0.3809299858742483;
                c2[12, 1] := 0.6101130648543355e-1;
                c2[12, 2] := 0.3520508315700898;
                c2[13, 1] := 0.5885349417435808e-1;
                c2[13, 2] := 0.3212801560701271;
                c2[14, 1] := 0.5652528148656809e-1;
                c2[14, 2] := 0.2887316252774887;
                c2[15, 1] := 0.5402021575818373e-1;
                c2[15, 2] := 0.2545001287790888;
                c2[16, 1] := 0.5132588802608274e-1;
                c2[16, 2] := 0.2186415296842951;
                c2[17, 1] := 0.4841900639702602e-1;
                c2[17, 2] := 0.1811322622296060;
                c2[18, 1] := 0.4525419574485134e-1;
                c2[18, 2] := 0.1417762065404688;
                c2[19, 1] := 0.4173260173087802e-1;
                c2[19, 2] := 0.9993834530966510e-1;
                c2[20, 1] := 0.3757210572966463e-1;
                c2[20, 2] := 0.5341611499960143e-1;
              else
                Streams.error("Input argument order (= " + String(order) + ") of Bessel filter is not in the range 1..41");
              end if;
              annotation(
                Documentation(info = "<html><p>The transfer function H(p) of a <i>n</i> 'th order Bessel filter is given by</p>
<blockquote><pre>
        Bn(0)
H(p) = -------
        Bn(p)
 </pre>
</blockquote>
<p>with the denominator polynomial</p>
<blockquote><pre>
         n             n  (2n - k)!       p^k
Bn(p) = sum c_k*p^k = sum ----------- * -------   (1)
        k=0           k=0 (n - k)!k!    2^(n-k)
</pre></blockquote>
<p>and the numerator</p>
<blockquote><pre>
               (2n)!     1
Bn(0) = c_0 = ------- * ---- .                    (2)
                n!      2^n
 </pre></blockquote>
<p>Although the coefficients c_k are integer numbers, it is not advisable to use the
polynomials in an unfactorized form because the coefficients are fast growing with order
n (c_0 is approximately 0.3e24 and 0.8e59 for order n=20 and order n=40
respectively).</p>

<p>Therefore, the polynomial Bn(p) is factorized to first and second order polynomials with
real coefficients corresponding to zeros and poles representation that is used in this library.</p>

<p>The function returns the coefficients which resulted from factorization of the normalized transfer function</p>
<blockquote><pre>
H'(p') = H(p),  p' = p/w0
</pre></blockquote>
<p>as well as</p>
<blockquote><pre>
alpha = 1/w0
</pre></blockquote>
<p>the reciprocal of the cut of frequency w0 where the gain of the transfer function is
decreased 3dB.</p>

<p>Both, coefficients and cut off frequency were calculated symbolically and were eventually evaluated
with high precision calculation. The results were stored in this function as real
numbers.</p>

<h4>Calculation of normalized Bessel filter coefficients</h4>
<p>Equation</p>
<blockquote><pre>
abs(H(j*w0)) = abs(Bn(0)/Bn(j*w0)) = 10^(-3/20)
</pre></blockquote>
<p>which must be fulfilled for cut off frequency w = w0 leads to</p>
<blockquote><pre>
[Re(Bn(j*w0))]^2 + [Im(Bn(j*w0))]^2 - (Bn(0)^2)*10^(3/10) = 0
</pre></blockquote>
<p>which has exactly one real solution w0 for each order n. This solutions of w0 are
calculated symbolically first and evaluated by using high precise values of the
coefficients c_k calculated by following (1) and (2).</p>

<p>With w0, the coefficients of the factorized polynomial can be computed by calculating the
zeros of the denominator polynomial</p>
<blockquote><pre>
        n
Bn(p) = sum w0^k*c_k*(p/w0)^k
        k=0
</pre></blockquote>
<p>of the normalized transfer function H'(p'). There exist n/2 of conjugate complex
pairs of zeros (beta +-j*gamma) if n is even and one additional real zero (alpha) if n is
odd. Finally, the coefficients a, b1_k, b2_k of the polynomials</p>
<blockquote><pre> a*p + 1,  n is odd </pre></blockquote>
<p>and</p>
<blockquote><pre>
b2_k*p^2 + b1_k*p + 1,   k = 1,... div(n,2)
</pre></blockquote>
<p>results from</p>
<blockquote><pre>
a = -1/alpha
</pre></blockquote>
<p>and</p>
<blockquote><pre>
b2_k = 1/(beta_k^2 + gamma_k^2) b1_k = -2*beta_k/(beta_k^2 + gamma_k^2)
</pre></blockquote>
</html>"));
            end BesselBaseCoefficients;

            function toHighestPowerOne "Transform filter to form with highest power of s equal 1"
              extends Modelica.Icons.Function;
              input Real den1[:] "[s] coefficients of polynomials (den1[i]*s + 1)";
              input Real den2[:, 2] "[s^2, s] coefficients of polynomials (den2[i,1]*s^2 + den2[i,2]*s + 1)";
              output Real cr[size(den1, 1)] "[s^0] coefficients of polynomials cr[i]*(s+1/cr[i])";
              output Real c0[size(den2, 1)] "[s^0] coefficients of polynomials (s^2 + (den2[i,2]/den2[i,1])*s + (1/den2[i,1]))";
              output Real c1[size(den2, 1)] "[s^1] coefficients of polynomials (s^2 + (den2[i,2]/den2[i,1])*s + (1/den2[i,1]))";
            algorithm
              for i in 1:size(den1, 1) loop
                cr[i] := 1 / den1[i];
              end for;
              for i in 1:size(den2, 1) loop
                c1[i] := den2[i, 2] / den2[i, 1];
                c0[i] := 1 / den2[i, 1];
              end for;
            end toHighestPowerOne;

            function normalizationFactor "Compute correction factor of low pass filter such that amplitude at cut-off frequency is -3db (=10^(-3/20) = 0.70794...)"
              extends Modelica.Icons.Function;
              import Modelica;
              import Modelica.Utilities.Streams;
              input Real c1[:] "[p] coefficients of denominator polynomials (c1[i}*p + 1)";
              input Real c2[:, 2] "[p^2, p] coefficients of denominator polynomials (c2[i,1]*p^2 + c2[i,2]*p + 1)";
              output Real alpha "Correction factor (replace p by alpha*p)";
            protected
              Real alpha_min;
              Real alpha_max;

              function normalizationResidue "Residue of correction factor computation"
                extends Modelica.Icons.Function;
                input Real c1[:] "[p] coefficients of denominator polynomials (c1[i]*p + 1)";
                input Real c2[:, 2] "[p^2, p] coefficients of denominator polynomials (c2[i,1]*p^2 + c2[i,2]*p + 1)";
                input Real alpha;
                output Real residue;
              protected
                constant Real beta = 10 ^ (-3 / 20) "Amplitude of -3db required, i.e., -3db = 20*log(beta)";
                Real cc1;
                Real cc2;
                Real p;
                Real alpha2 = alpha * alpha;
                Real alpha4 = alpha2 * alpha2;
                Real A2 = 1.0;
              algorithm
                assert(size(c1, 1) <= 1, "Internal error 2 (should not occur)");
                if size(c1, 1) == 1 then
                  cc1 := c1[1] * c1[1];
                  p := 1 + cc1 * alpha2;
                  A2 := A2 * p;
                end if;
                for i in 1:size(c2, 1) loop
                  cc1 := c2[i, 2] * c2[i, 2] - 2 * c2[i, 1];
                  cc2 := c2[i, 1] * c2[i, 1];
                  p := 1 + cc1 * alpha2 + cc2 * alpha4;
                  A2 := A2 * p;
                end for;
                residue := 1 / sqrt(A2) - beta;
              end normalizationResidue;

              function findInterval "Find interval for the root"
                extends Modelica.Icons.Function;
                input Real c1[:] "[p] coefficients of denominator polynomials (a*p + 1)";
                input Real c2[:, 2] "[p^2, p] coefficients of denominator polynomials (b*p^2 + a*p + 1)";
                output Real alpha_min;
                output Real alpha_max;
              protected
                Real alpha = 1.0;
                Real residue;
              algorithm
                alpha_min := 0;
                residue := normalizationResidue(c1, c2, alpha);
                if residue < 0 then
                  alpha_max := alpha;
                else
                  while residue >= 0 loop
                    alpha := 1.1 * alpha;
                    residue := normalizationResidue(c1, c2, alpha);
                  end while;
                  alpha_max := alpha;
                end if;
              end findInterval;

              function solveOneNonlinearEquation "Solve f(u) = 0; f(u_min) and f(u_max) must have different signs"
                extends Modelica.Icons.Function;
                import Modelica.Utilities.Streams.error;
                input Real c1[:] "[p] coefficients of denominator polynomials (c1[i]*p + 1)";
                input Real c2[:, 2] "[p^2, p] coefficients of denominator polynomials (c2[i,1]*p^2 + c2[i,2]*p + 1)";
                input Real u_min "Lower bound of search interval";
                input Real u_max "Upper bound of search interval";
                input Real tolerance = 100 * Modelica.Constants.eps "Relative tolerance of solution u";
                output Real u "Value of independent variable so that f(u) = 0";
              protected
                constant Real eps = Modelica.Constants.eps "machine epsilon";
                Real a = u_min "Current best minimum interval value";
                Real b = u_max "Current best maximum interval value";
                Real c "Intermediate point a <= c <= b";
                Real d;
                Real e "b - a";
                Real m;
                Real s;
                Real p;
                Real q;
                Real r;
                Real tol;
                Real fa "= f(a)";
                Real fb "= f(b)";
                Real fc;
                Boolean found = false;
              algorithm
// Check that f(u_min) and f(u_max) have different sign
                fa := normalizationResidue(c1, c2, u_min);
                fb := normalizationResidue(c1, c2, u_max);
                fc := fb;
                if fa > 0.0 and fb > 0.0 or fa < 0.0 and fb < 0.0 then
                  error("The arguments u_min and u_max to solveOneNonlinearEquation(..)\n" + "do not bracket the root of the single non-linear equation:\n" + "  u_min  = " + String(u_min) + "\n" + "  u_max  = " + String(u_max) + "\n" + "  fa = f(u_min) = " + String(fa) + "\n" + "  fb = f(u_max) = " + String(fb) + "\n" + "fa and fb must have opposite sign which is not the case");
                end if;
// Initialize variables
                c := a;
                fc := fa;
                e := b - a;
                d := e;
// Search loop
                while not found loop
                  if abs(fc) < abs(fb) then
                    a := b;
                    b := c;
                    c := a;
                    fa := fb;
                    fb := fc;
                    fc := fa;
                  end if;
                  tol := 2 * eps * abs(b) + tolerance;
                  m := (c - b) / 2;
                  if abs(m) <= tol or fb == 0.0 then
                    found := true;
                    u := b;
                  else
                    if abs(e) < tol or abs(fa) <= abs(fb) then
                      e := m;
                      d := e;
                    else
                      s := fb / fa;
                      if a == c then
                        p := 2 * m * s;
                        q := 1 - s;
                      else
                        q := fa / fc;
                        r := fb / fc;
                        p := s * (2 * m * q * (q - r) - (b - a) * (r - 1));
                        q := (q - 1) * (r - 1) * (s - 1);
                      end if;
                      if p > 0 then
                        q := -q;
                      else
                        p := -p;
                      end if;
                      s := e;
                      e := d;
                      if 2 * p < 3 * m * q - abs(tol * q) and p < abs(0.5 * s * q) then
                        d := p / q;
                      else
                        e := m;
                        d := e;
                      end if;
                    end if;
                    a := b;
                    fa := fb;
                    b := b + (if abs(d) > tol then d else if m > 0 then tol else -tol);
                    fb := normalizationResidue(c1, c2, b);
                    if fb > 0 and fc > 0 or fb < 0 and fc < 0 then
                      c := a;
                      fc := fa;
                      e := b - a;
                      d := e;
                    end if;
                  end if;
                end while;
// root found (interval is small enough)
// Determine if a bisection is needed
// linear interpolation
// inverse quadratic interpolation
// interpolation successful
// use bi-section
// Best guess value is defined as "a"
// initialize variables
                annotation(
                  Documentation(info = "<html>

<p>
This function determines the solution of <b>one non-linear algebraic equation</b> \"y=f(u)\"
in <b>one unknown</b> \"u\" in a reliable way. It is one of the best numerical
algorithms for this purpose. As input, the nonlinear function f(u)
has to be given, as well as an interval u_min, u_max that
contains the solution, i.e., \"f(u_min)\" and \"f(u_max)\" must
have a different sign. If possible, a smaller interval is computed by
inverse quadratic interpolation (interpolating with a quadratic polynomial
through the last 3 points and computing the zero). If this fails,
bisection is used, which always reduces the interval by a factor of 2.
The inverse quadratic interpolation method has superlinear convergence.
This is roughly the same convergence rate as a globally convergent Newton
method, but without the need to compute derivatives of the non-linear
function. The solver function is a direct mapping of the Algol 60 procedure
\"zero\" to Modelica, from:
</p>

<dl>
<dt> Brent R.P.:</dt>
<dd> <b>Algorithms for Minimization without derivatives</b>.
     Prentice Hall, 1973, pp. 58-59.</dd>
</dl>

</html>"));
              end solveOneNonlinearEquation;
            algorithm
// Find interval for alpha
              (alpha_min, alpha_max) := findInterval(c1, c2);
// Compute alpha, so that abs(G(p)) = -3db
              alpha := solveOneNonlinearEquation(c1, c2, alpha_min, alpha_max);
            end normalizationFactor;

            encapsulated function bandPassAlpha "Return alpha for band pass"
              extends Modelica.Icons.Function;
              import Modelica;
              input Real a "Coefficient of s^1";
              input Real b "Coefficient of s^0";
              input Modelica.SIunits.AngularVelocity w "Bandwidth angular frequency";
              output Real alpha "Alpha factor to build up band pass";
            protected
              Real alpha_min;
              Real alpha_max;
              Real z_min;
              Real z_max;
              Real z;

              function residue "Residue of non-linear equation"
                extends Modelica.Icons.Function;
                input Real a;
                input Real b;
                input Real w;
                input Real z;
                output Real res;
              algorithm
                res := z ^ 2 + (a * w * z / (1 + z)) ^ 2 - (2 + b * w ^ 2) * z + 1;
              end residue;

              function solveOneNonlinearEquation "Solve f(u) = 0; f(u_min) and f(u_max) must have different signs"
                extends Modelica.Icons.Function;
                import Modelica.Utilities.Streams.error;
                input Real aa;
                input Real bb;
                input Real ww;
                input Real u_min "Lower bound of search interval";
                input Real u_max "Upper bound of search interval";
                input Real tolerance = 100 * Modelica.Constants.eps "Relative tolerance of solution u";
                output Real u "Value of independent variable so that f(u) = 0";
              protected
                constant Real eps = Modelica.Constants.eps "machine epsilon";
                Real a = u_min "Current best minimum interval value";
                Real b = u_max "Current best maximum interval value";
                Real c "Intermediate point a <= c <= b";
                Real d;
                Real e "b - a";
                Real m;
                Real s;
                Real p;
                Real q;
                Real r;
                Real tol;
                Real fa "= f(a)";
                Real fb "= f(b)";
                Real fc;
                Boolean found = false;
              algorithm
// Check that f(u_min) and f(u_max) have different sign
                fa := residue(aa, bb, ww, u_min);
                fb := residue(aa, bb, ww, u_max);
                fc := fb;
                if fa > 0.0 and fb > 0.0 or fa < 0.0 and fb < 0.0 then
                  error("The arguments u_min and u_max to solveOneNonlinearEquation(..)\n" + "do not bracket the root of the single non-linear equation:\n" + "  u_min  = " + String(u_min) + "\n" + "  u_max  = " + String(u_max) + "\n" + "  fa = f(u_min) = " + String(fa) + "\n" + "  fb = f(u_max) = " + String(fb) + "\n" + "fa and fb must have opposite sign which is not the case");
                end if;
// Initialize variables
                c := a;
                fc := fa;
                e := b - a;
                d := e;
// Search loop
                while not found loop
                  if abs(fc) < abs(fb) then
                    a := b;
                    b := c;
                    c := a;
                    fa := fb;
                    fb := fc;
                    fc := fa;
                  end if;
                  tol := 2 * eps * abs(b) + tolerance;
                  m := (c - b) / 2;
                  if abs(m) <= tol or fb == 0.0 then
                    found := true;
                    u := b;
                  else
                    if abs(e) < tol or abs(fa) <= abs(fb) then
                      e := m;
                      d := e;
                    else
                      s := fb / fa;
                      if a == c then
                        p := 2 * m * s;
                        q := 1 - s;
                      else
                        q := fa / fc;
                        r := fb / fc;
                        p := s * (2 * m * q * (q - r) - (b - a) * (r - 1));
                        q := (q - 1) * (r - 1) * (s - 1);
                      end if;
                      if p > 0 then
                        q := -q;
                      else
                        p := -p;
                      end if;
                      s := e;
                      e := d;
                      if 2 * p < 3 * m * q - abs(tol * q) and p < abs(0.5 * s * q) then
                        d := p / q;
                      else
                        e := m;
                        d := e;
                      end if;
                    end if;
                    a := b;
                    fa := fb;
                    b := b + (if abs(d) > tol then d else if m > 0 then tol else -tol);
                    fb := residue(aa, bb, ww, b);
                    if fb > 0 and fc > 0 or fb < 0 and fc < 0 then
                      c := a;
                      fc := fa;
                      e := b - a;
                      d := e;
                    end if;
                  end if;
                end while;
// root found (interval is small enough)
// Determine if a bisection is needed
// linear interpolation
// inverse quadratic interpolation
// interpolation successful
// use bi-section
// Best guess value is defined as "a"
// initialize variables
                annotation(
                  Documentation(info = "<html>

<p>
This function determines the solution of <b>one non-linear algebraic equation</b> \"y=f(u)\"
in <b>one unknown</b> \"u\" in a reliable way. It is one of the best numerical
algorithms for this purpose. As input, the nonlinear function f(u)
has to be given, as well as an interval u_min, u_max that
contains the solution, i.e., \"f(u_min)\" and \"f(u_max)\" must
have a different sign. If possible, a smaller interval is computed by
inverse quadratic interpolation (interpolating with a quadratic polynomial
through the last 3 points and computing the zero). If this fails,
bisection is used, which always reduces the interval by a factor of 2.
The inverse quadratic interpolation method has superlinear convergence.
This is roughly the same convergence rate as a globally convergent Newton
method, but without the need to compute derivatives of the non-linear
function. The solver function is a direct mapping of the Algol 60 procedure
\"zero\" to Modelica, from:
</p>

<dl>
<dt> Brent R.P.:</dt>
<dd> <b>Algorithms for Minimization without derivatives</b>.
     Prentice Hall, 1973, pp. 58-59.</dd>
</dl>

</html>"));
              end solveOneNonlinearEquation;
            algorithm
              assert(a ^ 2 / 4 - b <= 0, "Band pass transformation cannot be computed");
              z := solveOneNonlinearEquation(a, b, w, 0, 1);
              alpha := sqrt(z);
              annotation(
                Documentation(info = "<html>
<p>
A band pass with bandwidth \"w\" is determined from a low pass
</p>

<pre>
  1/(p^2 + a*p + b)
</pre>

<p>
with the transformation
</p>

<pre>
  new(p) = (p + 1/p)/w
</pre>

<p>
This results in the following derivation:
</p>

<pre>
  1/(p^2 + a*p + b) -> 1/( (p+1/p)^2/w^2 + a*(p + 1/p)/w + b )
                     = 1 /( ( p^2 + 1/p^2 + 2)/w^2 + (p + 1/p)*a/w + b )
                     = w^2*p^2 / (p^4 + 2*p^2 + 1 + (p^3 + p)a*w + b*w^2*p^2)
                     = w^2*p^2 / (p^4 + a*w*p^3 + (2+b*w^2)*p^2 + a*w*p + 1)
</pre>

<p>
This 4th order transfer function shall be split in to two transfer functions of order 2 each
for numerical reasons. With the following formulation, the fourth order
polynomial can be represented (with the unknowns \"c\" and \"alpha\"):
</p>

<pre>
  g(p) = w^2*p^2 / ( (p*alpha)^2 + c*(p*alpha) + 1) * ( (p/alpha)^2 + c*(p/alpha) + 1)
       = w^2*p^2 / ( p^4 + c*(alpha + 1/alpha)*p^3 + (alpha^2 + 1/alpha^2 + c^2)*p^2
                                                   + c*(alpha + 1/alpha)*p + 1 )
</pre>

<p>
Comparison of coefficients:
</p>

<pre>
  c*(alpha + 1/alpha) = a*w           -> c = a*w / (alpha + 1/alpha)
  alpha^2 + 1/alpha^2 + c^2 = 2+b*w^2 -> equation to determine alpha

  alpha^4 + 1 + a^2*w^2*alpha^4/(1+alpha^2)^2 = (2+b*w^2)*alpha^2
    or z = alpha^2
  z^2 + a^2*w^2*z^2/(1+z)^2 - (2+b*w^2)*z + 1 = 0
</pre>

<p>
Therefore the last equation has to be solved for \"z\" (basically, this means to compute
a real zero of a fourth order polynomial):
</p>

<pre>
   solve: 0 = f(z)  = z^2 + a^2*w^2*z^2/(1+z)^2 - (2+b*w^2)*z + 1  for \"z\"
              f(0)  = 1  &gt; 0
              f(1)  = 1 + a^2*w^2/4 - (2+b*w^2) + 1
                    = (a^2/4 - b)*w^2  &lt; 0
                    // since b - a^2/4 > 0 requirement for complex conjugate poles
   -> 0 &lt; z &lt; 1
</pre>

<p>
This function computes the solution of this equation and returns \"alpha = sqrt(z)\";
</p>

</html>"));
            end bandPassAlpha;
          end Utilities;
        end Filter;
      end Internal;
      annotation(
        Documentation(info = "<html>
<p>
This package contains basic <b>continuous</b> input/output blocks
described by differential equations.
</p>

<p>
All blocks of this package can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in
<a href=\"modelica://Modelica.Blocks.Types.Init\">Modelica.Blocks.Types.Init</a>:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>Name</b></td>
      <td valign=\"top\"><b>Description</b></td></tr>

  <tr><td valign=\"top\"><b>Init.NoInit</b></td>
      <td valign=\"top\">no initialization (start values are used as guess values with fixed=false)</td></tr>

  <tr><td valign=\"top\"><b>Init.SteadyState</b></td>
      <td valign=\"top\">steady state initialization (derivatives of states are zero)</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialState</b></td>
      <td valign=\"top\">Initialization with initial states</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialOutput</b></td>
      <td valign=\"top\">Initialization with initial outputs (and steady state of the states if possible)</td></tr>
</table>

<p>
For backward compatibility reasons the default of all blocks is
<b>Init.NoInit</b>, with the exception of Integrator and LimIntegrator
where the default is <b>Init.InitialState</b> (this was the initialization
defined in version 2.2 of the Modelica standard library).
</p>

<p>
In many cases, the most useful initial condition is
<b>Init.SteadyState</b> because initial transients are then no longer
present. The drawback is that in combination with a non-linear
plant, non-linear algebraic equations occur that might be
difficult to solve if appropriate guess values for the
iteration variables are not provided (i.e., start values with fixed=false).
However, it is often already useful to just initialize
the linear blocks from the Continuous blocks library in SteadyState.
This is uncritical, because only linear algebraic equations occur.
If Init.NoInit is set, then the start values for the states are
interpreted as <b>guess</b> values and are propagated to the
states with fixed=<b>false</b>.
</p>

<p>
Note, initialization with Init.SteadyState is usually difficult
for a block that contains an integrator
(Integrator, LimIntegrator, PI, PID, LimPID).
This is due to the basic equation of an integrator:
</p>

<pre>
  <b>initial equation</b>
     <b>der</b>(y) = 0;   // Init.SteadyState
  <b>equation</b>
     <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation leads to the condition that the input to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is always defined by
Init.InitialState or Init.SteadyState initialization.
</p>

<p>
In such a case, <b>Init.NoInit</b> has to be selected for the integrator
and an additional initial equation has to be added to the system
to which the integrator is connected. E.g., useful initial conditions
for a 1-dim. rotational inertia controlled by a PI controller are that
<b>angle</b>, <b>speed</b>, and <b>acceleration</b> of the inertia are zero.
</p>

</html>"),
        Icon(graphics = {Line(origin = {0.061, 4.184}, points = {{81.939, 36.056}, {65.362, 36.056}, {14.39, -26.199}, {-29.966, 113.485}, {-65.374, -61.217}, {-78.061, -78.184}}, color = {95, 95, 95}, smooth = Smooth.Bezier)}));
    end Continuous;

    package Discrete "Library of discrete input/output blocks with fixed sample period"
      extends Modelica.Icons.Package;

      block Sampler "Ideal sampling of continuous signals"
        extends Interfaces.DiscreteSISO;
      equation
        when {sampleTrigger, initial()} then
          y = u;
        end when;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{25.0, -10.0}, {45.0, 10.0}}), Line(visible = true, points = {{-100.0, 0.0}, {-45.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{45.0, 0.0}, {100.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{-35.0, 0.0}, {30.0, 35.0}}, color = {0, 0, 127}), Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-45.0, -10.0}, {-25.0, 10.0}})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-25, -10}, {-45, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{45, -10}, {25, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {-45, 0}}, color = {0, 0, 255}), Line(points = {{45, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-35, 0}, {30, 35}}, color = {0, 0, 255})}),
          Documentation(info = "<HTML>
<p>
Samples the continues input signal with a sampling rate defined
via parameter <b>samplePeriod</b>.
</p>
</html>"));
      end Sampler;

      block ZeroOrderHold "Zero order hold of a sampled-data system"
        extends Interfaces.DiscreteSISO;
        output Real ySample(start = 0, fixed = true);
      equation
        when {sampleTrigger, initial()} then
          ySample = u;
        end when;
/* Define y=ySample with an infinitesimal delay to break potential
       algebraic loops if both the continuous and the discrete part have
       direct feedthrough
    */
        y = pre(ySample);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-78.0, -42.0}, {-52.0, -42.0}, {-52.0, 0.0}, {-26.0, 0.0}, {-26.0, 24.0}, {-6.0, 24.0}, {-6.0, 64.0}, {18.0, 64.0}, {18.0, 20.0}, {38.0, 20.0}, {38.0, 0.0}, {44.0, 0.0}, {44.0, 0.0}, {62.0, 0.0}}, color = {0, 0, 127})}),
          Documentation(info = "<HTML>
<p>
The output is identical to the sampled input signal at sample
time instants and holds the output at the value of the last
sample instant during the sample points.
</p>
</html>"));
      end ZeroOrderHold;

      block FirstOrderHold "First order hold of a sampled-data system"
        extends Modelica.Blocks.Interfaces.DiscreteSISO;
      protected
        Modelica.SIunits.Time tSample;
        Real uSample;
        Real pre_uSample;
        Real c;
      initial equation
        pre(tSample) = time;
        pre(uSample) = u;
        pre(pre_uSample) = u;
        pre(c) = 0.0;
      equation
        when sampleTrigger then
          tSample = time;
          uSample = u;
          pre_uSample = pre(uSample);
          c = if firstTrigger then 0 else (uSample - pre_uSample) / samplePeriod;
        end when;
/* Use pre_uSample and pre(c) to break potential algebraic loops by an
       infinitesimal delay if both the continuous and the discrete part
       have direct feedthrough.
    */
        y = pre_uSample + pre(c) * (time - tSample);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-79.0, -41.0}, {-59.0, -33.0}, {-40.0, 1.0}, {-20.0, 9.0}, {0.0, 63.0}, {21.0, 20.0}, {41.0, 10.0}, {60.0, 20.0}}, color = {0, 0, 127}), Line(visible = true, points = {{60.0, 20.0}, {81.0, 10.0}}, color = {0, 0, 127})}),
          Documentation(info = "<HTML>
<p>
The output signal is the extrapolation through the
values of the last two sampled input signals.
</p>
</html>"));
      end FirstOrderHold;

      block UnitDelay "Unit Delay Block"
        parameter Real y_start = 0 "Initial value of output signal";
        extends Interfaces.DiscreteSISO;
      equation
        when sampleTrigger then
          y = pre(u);
        end when;
      initial equation
        y = y_start;
        annotation(
          Documentation(info = "<html>
<p>
This block describes a unit delay:
</p>
<pre>
          1
     y = --- * u
          z
</pre>
<p>
that is, the output signal y is the input signal u of the
previous sample instant. Before the second sample instant,
the output y is identical to parameter yStart.
</p>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-30.0, 0.0}, {30.0, 0.0}}, color = {0, 0, 127}), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-90.0, 10.0}, {90.0, 90.0}}, textString = "1"), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-90.0, -90.0}, {90.0, -10.0}}, textString = "z")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-160, 10}, {-140, -10}}, textString = "u", lineColor = {0, 0, 255}), Text(extent = {{115, 10}, {135, -10}}, textString = "y", lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{40, 0}, {-40, 0}}, color = {0, 0, 0}), Text(extent = {{-55, 55}, {55, 5}}, lineColor = {0, 0, 0}, textString = "1"), Text(extent = {{-55, -5}, {55, -55}}, lineColor = {0, 0, 0}, textString = "z")}));
      end UnitDelay;

      block TransferFunction "Discrete Transfer Function block"
        parameter Real b[:] = {1} "Numerator coefficients of transfer function.";
        parameter Real a[:] = {1} "Denominator coefficients of transfer function.";
        extends Interfaces.DiscreteSISO;
        output Real x[size(a, 1) - 1](each start = 0, each fixed = true) "State of transfer function from controller canonical form";
      protected
        parameter Integer nb = size(b, 1) "Size of Numerator of transfer function";
        parameter Integer na = size(a, 1) "Size of Denominator of transfer function";
        Real x1;
        Real xext[size(a, 1)];
      equation
        when sampleTrigger then
/* State variables x are defined according to
       controller canonical form. */
          x1 = (u - a[2:size(a, 1)] * pre(x)) / a[1];
          xext = vector([x1; pre(x)]);
          x = xext[1:size(x, 1)];
          y = vector([zeros(na - nb, 1); b]) * xext;
        end when;
/* This is a non-sampled equation and above there are two separate
       when-clauses. This breaks feedback loops without direct terms,
       since in that case y will be independent of x1 (and only dependent
       on pre(x)).
    */
/* Corresponding (simpler) version using when-semantics of Modelica 1.3:
   equation
     when sampleTrigger then
      [x; xn] = [x1; pre(x)];
      [u] = transpose([a])*[x1; pre(x)];
      [y] = transpose([zeros(na - nb, 1); b])*[x1; pre(x)];
     end when;
*/
        annotation(
          Documentation(info = "<html>
<p>The <b>discrete transfer function</b> block defines the
transfer function between the input signal u and the output
signal y. The numerator has the order nb-1, the denominator
has the order na-1.</p>
<pre>
          b(1)*z^(nb-1) + b(2)*z^(nb-2) + ... + b(nb)
   y(z) = -------------------------------------------- * u(z)
          a(1)*z^(na-1) + a(2)*z^(na-2) + ... + a(na)
</pre>
<p>State variables <b>x</b> are defined according to
<b>controller canonical</b> form. Initial values of the
states can be set as start values of <b>x</b>.</p>
<p>Example:</p>
<pre>     Blocks.Discrete.TransferFunction g(b = {2,4}, a = {1,3});
</pre>
<p>results in the following transfer function:</p>
<pre>        2*z + 4
   y = --------- * u
         z + 3
</pre>

</html>", revisions = "<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>November 15, 2000</i>
    by <a href=\"http://www.dynasim.se\">Hans Olsson</a>:<br>
    Converted to when-semantics of Modelica 1.4 with special
    care to avoid unnecessary algebraic loops.</li>
<li><i>June 18, 2000</i>
    by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
    Realized based on a corresponding model of Dieter Moormann
    and Hilding Elmqvist.</li>
</ul>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{82.0, 0.0}, {-84.0, 0.0}}, color = {0, 0, 127}), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-92.0, 12.0}, {86.0, 92.0}}, textString = "b(z)"), Text(visible = true, lineColor = {0, 0, 127}, extent = {{-90.0, -90.0}, {90.0, -12.0}}, textString = "a(z)")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Line(points = {{40, 0}, {-44, 0}}, color = {0, 0, 0}, thickness = 0.5), Text(extent = {{-54, 54}, {54, 4}}, lineColor = {0, 0, 0}, textString = "b(z)"), Text(extent = {{-54, -6}, {56, -56}}, lineColor = {0, 0, 0}, textString = "a(z)"), Line(points = {{-100, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end TransferFunction;

      block StateSpace "Discrete State Space block"
        parameter Real A[:, size(A, 1)] = [1, 0; 0, 1] "Matrix A of state space model";
        parameter Real B[size(A, 1), :] = [1; 1] "Matrix B of state space model";
        parameter Real C[:, size(A, 1)] = [1, 1] "Matrix C of state space model";
        parameter Real D[size(C, 1), size(B, 2)] = zeros(size(C, 1), size(B, 2)) "Matrix D of state space model";
        extends Interfaces.DiscreteMIMO(final nin = size(B, 2), final nout = size(C, 1));
        output Real x[size(A, 1)] "State vector";
      equation
        when sampleTrigger then
          x = A * pre(x) + B * u;
          y = C * pre(x) + D * u;
        end when;
        annotation(
          Documentation(info = "<html>
<p>
The <b>discrete state space</b> block defines the relation
between the input u=inPort.signal and the output
y=outPort.signal in state space form:
</p>
<pre>
    x = A * pre(x) + B * u
    y = C * pre(x) + D * u
</pre>
<p>
where pre(x) is the value of the discrete state x at
the previous sample time instant.
The input is a vector of length nu, the output is a vector
of length ny and nx is the number of states. Accordingly
</p>
<pre>
        A has the dimension: A(nx,nx),
        B has the dimension: B(nx,nu),
        C has the dimension: C(ny,nx),
        D has the dimension: D(ny,nu)
</pre>
<p>
Example:
</p>
<pre>
     parameter: A = [0.12, 2;3, 1.5]
     parameter: B = [2, 7;3, 1]
     parameter: C = [0.1, 2]
     parameter: D = zeros(ny,nu)

results in the following equations:
  [x[1]]   [0.12  2.00] [pre(x[1])]   [2.0  7.0] [u[1]]
  [    ] = [          ]*[         ] + [        ]*[    ]
  [x[2]]   [3.00  1.50] [pre(x[2])]   [0.1  2.0] [u[2]]
                             [pre(x[1])]            [u[1]]
       y[1]   = [0.1  2.0] * [         ] + [0  0] * [    ]
                             [pre(x[2])]            [u[2]]
</pre>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 15}, {-15, 90}}, textString = "A", lineColor = {0, 0, 127}), Text(extent = {{15, 15}, {90, 90}}, textString = "B", lineColor = {0, 0, 127}), Text(extent = {{-52, 28}, {54, -20}}, textString = "z", lineColor = {0, 0, 127}), Text(extent = {{-90, -15}, {-15, -90}}, textString = "C", lineColor = {0, 0, 127}), Text(extent = {{15, -15}, {90, -90}}, textString = "D", lineColor = {0, 0, 127})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-60, 60}, {60, -60}}, lineColor = {0, 0, 255}), Text(extent = {{-54, 50}, {52, -10}}, lineColor = {0, 0, 0}, textString = "zx=Ax+Bu"), Text(extent = {{-56, 14}, {54, -50}}, lineColor = {0, 0, 0}, textString = "  y=Cx+Du"), Line(points = {{-102, 0}, {-60, 0}}, color = {0, 0, 255}), Line(points = {{60, 0}, {100, 0}}, color = {0, 0, 255})}));
      end StateSpace;

      block TriggeredSampler "Triggered sampling of continuous signals"
        extends Modelica.Blocks.Icons.DiscreteBlock;
        parameter Real y_start = 0 "initial value of output signal";
        Modelica.Blocks.Interfaces.RealInput u "Connector with a Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y "Connector with a Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation(
          Placement(transformation(origin = {0, -118}, extent = {{-20, -20}, {20, 20}}, rotation = 90)));
      equation
        when trigger then
          y = u;
        end when;
      initial equation
        y = y_start;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{25.0, -10.0}, {45.0, 10.0}}), Line(visible = true, points = {{-100.0, 0.0}, {-45.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{45.0, 0.0}, {100.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{0.0, -100.0}, {0.0, -26.0}}, color = {255, 0, 255}), Line(visible = true, points = {{-35.0, 0.0}, {28.0, -48.0}}, color = {0, 0, 127}), Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-45.0, -10.0}, {-25.0, 10.0}})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-25, -10}, {-45, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{45, -10}, {25, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {-45, 0}}, color = {0, 0, 255}), Line(points = {{45, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-35, 0}, {28, -48}}, color = {0, 0, 255}), Line(points = {{0, -100}, {0, -26}}, color = {255, 0, 255})}),
          Documentation(info = "<HTML>
<p>
Samples the continuous input signal whenever the trigger input
signal is rising (i.e., trigger changes from <b>false</b> to
<b>true</b>) and provides the sampled input signal as output.
Before the first sampling, the output signal is equal to
the initial value defined via parameter <b>y0</b>.
</p>
</html>"));
      end TriggeredSampler;

      block TriggeredMax "Compute maximum, absolute value of continuous signal at trigger instants"
        extends Modelica.Blocks.Icons.DiscreteBlock;
        Modelica.Blocks.Interfaces.RealInput u "Connector with a Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y "Connector with a Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation(
          Placement(transformation(origin = {0, -118}, extent = {{-20, -20}, {20, 20}}, rotation = 90)));
      equation
        when trigger then
          y = max(pre(y), abs(u));
        end when;
      initial equation
        y = 0;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{25.0, -10.0}, {45.0, 10.0}}), Line(visible = true, points = {{-100.0, 0.0}, {-45.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{45.0, 0.0}, {100.0, 0.0}}, color = {0, 0, 127}), Line(visible = true, points = {{0.0, -100.0}, {0.0, -26.0}}, color = {255, 0, 255}), Line(visible = true, points = {{-35.0, 0.0}, {28.0, -48.0}}, color = {0, 0, 127}), Text(visible = true, extent = {{-86.0, 24.0}, {82.0, 82.0}}, color = {0, 0, 127}, textString = "max"), Ellipse(visible = true, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-45.0, -10.0}, {-25.0, 10.0}})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-25, -10}, {-45, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{45, -10}, {25, 10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {-45, 0}}, color = {0, 0, 255}), Line(points = {{45, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-35, 0}, {28, -48}}, color = {0, 0, 255}), Line(points = {{0, -100}, {0, -26}}, color = {255, 0, 255})}),
          Documentation(info = "<HTML>
<p>
Samples the continuous input signal whenever the trigger input
signal is rising (i.e., trigger changes from <b>false</b> to
<b>true</b>). The maximum, absolute value of the input signal
at the sampling point is provided as output signal.
</p>
</html>"));
      end TriggeredMax;
      annotation(
        Documentation(info = "<html>
<p>
This package contains <b>discrete control blocks</b>
with <b>fixed sample period</b>.
Every component of this package is structured in the following way:
</p>
<ol>
<li> A component has <b>continuous real</b> input and output signals.</li>
<li> The <b>input</b> signals are <b>sampled</b> by the given sample period
     defined via parameter <b>samplePeriod</b>.
     The first sample instant is defined by parameter <b>startTime</b>.
<li> The <b>output</b> signals are computed from the sampled input signals.
</ol>
<p>
A <b>sampled data system</b> may consist of components of package <b>Discrete</b>
and of every other purely <b>algebraic</b> input/output block, such
as the components of packages <b>Modelica.Blocks.Math</b>,
<b>Modelica.Blocks.Nonlinear</b> or <b>Modelica.Blocks.Sources</b>.
</p>

</html>", revisions = "<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       New components TriggeredSampler and TriggeredMax added.</li>
<li><i>June 18, 2000</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized based on a corresponding library of Dieter Moormann and
       Hilding Elmqvist.</li>
</ul>
</html>"),
        Icon(graphics = {Line(points = {{-88, 0}, {-45, 0}}, color = {95, 95, 95}), Ellipse(lineColor = {95, 95, 95}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-45, -10}, {-25, 10}}), Line(points = {{-35, 0}, {24, 52}}, color = {95, 95, 95}), Ellipse(lineColor = {95, 95, 95}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{25, -10}, {45, 10}}), Line(points = {{45, 0}, {82, 0}}, color = {95, 95, 95})}));
    end Discrete;

    package Interaction "Library of user interaction blocks to input and to show variables in a diagram animation"
      extends Modelica.Icons.Package;

      package Show "Library of blocks to show variables in a diagram animation"
        extends Modelica.Icons.Package;

        block RealValue "Show Real value from numberPort or from number input field in diagram layer dynamically"
          parameter Boolean use_numberPort = true "= true, if numberPort enabled" annotation(
            Evaluate = true,
            HideResult = true,
            choices(checkBox = true));
          input Real number = 0.0 "Number to visualize if use_numberPort=false (time varying)" annotation(
            Dialog(enable = not use_numberPort),
            HideResult = true);
          parameter Integer significantDigits(min = 1) = 2 "Number of significant digits to be shown";
          Modelica.Blocks.Interfaces.RealInput numberPort if use_numberPort "Number to be shown in diagram layer if use_numberPort = true" annotation(
            HideResult = true,
            Placement(transformation(extent = {{-130, -15}, {-100, 15}})));
          Modelica.Blocks.Interfaces.RealOutput showNumber;
        equation
          if use_numberPort then
            connect(numberPort, showNumber);
          else
            showNumber = number;
          end if;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Rectangle(visible = true, lineColor = {0, 0, 127}, fillColor = {236, 233, 216}, fillPattern = FillPattern.Solid, lineThickness = 5.0, borderPattern = BorderPattern.Raised, extent = {{-100.0, -40.0}, {100.0, 40.0}}), Text(visible = true, extent = {{-94.0, -34.0}, {96.0, 34.0}}, textString = DynamicSelect("0.0", String(showNumber, significantDigits = significantDigits))), Text(visible = not use_numberPort, extent = {{-150.0, -70.0}, {150.0, -50.0}}, textString = "%number")}),
            Documentation(info = "<html>
<p>
This block visualizes a Real number in a diagram animation.
The number to be visualized can be defined in the following ways:
</p>

<ul>
<li> If useNumberPort = <b>true</b> (which is the default), a Real
     input is present and this input variable is shown.</li>

<li> If useNumberPort = <b>false</b> no input connector is present.
     Instead, a Real input field is activated in the parameter menu
     and the Real expression from this input menu is shown.</li>
</ul>

<p>
The two versions of the block are shown in the following image (in the right variant, the
name of the variable value that is displayed is also shown below the icon):
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Interaction/RealValue.png\"
     alt=\"RealValue.png\">
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.RealNetwork1\">Modelica.Blocks.Examples.RealNetwork1</a>.
</p>
</html>"));
        end RealValue;

        block IntegerValue "Show Integer value from numberPort or from number input field in diagram layer dynamically"
          parameter Boolean use_numberPort = true "= true, if numberPort enabled" annotation(
            Evaluate = true,
            HideResult = true,
            choices(checkBox = true));
          input Integer number = 0 "Number to visualize if use_numberPort=false (time varying)" annotation(
            Dialog(enable = not use_numberPort),
            HideResult = true);
          Modelica.Blocks.Interfaces.IntegerInput numberPort if use_numberPort "Number to be shown in diagram layer if use_numberPort = true" annotation(
            HideResult = true,
            Placement(transformation(extent = {{-130, -15}, {-100, 15}})));
          Modelica.Blocks.Interfaces.IntegerOutput showNumber;
        equation
          if use_numberPort then
            connect(numberPort, showNumber);
          else
            showNumber = number;
          end if;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Rectangle(visible = true, lineColor = {0, 0, 127}, fillColor = {236, 233, 216}, fillPattern = FillPattern.Solid, lineThickness = 5.0, borderPattern = BorderPattern.Raised, extent = {{-100.0, -40.0}, {100.0, 40.0}}), Text(visible = true, extent = {{-94.0, -34.0}, {96.0, 34.0}}, textString = DynamicSelect("0", String(showNumber))), Text(visible = not use_numberPort, extent = {{-150.0, -70.0}, {150.0, -50.0}}, textString = "%number")}),
            Documentation(info = "<html>
<p>
This block visualizes an Integer number in a diagram animation.
The number to be visualized can be defined in the following ways:
</p>

<ul>
<li> If useNumberPort = <b>true</b> (which is the default), an Integer
     input is present and this input variable is shown.</li>

<li> If useNumberPort = <b>false</b> no input connector is present.
     Instead, an Integer input field is activated in the parameter menu
     and the Integer expression from this input menu is shown.</li>
</ul>

<p>
The two versions of the block are shown in the following image (in the right variant, the
name of the variable value that is displayed is also shown below the icon):
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Interaction/IntegerValue.png\"
     alt=\"IntegerValue.png\">
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.IntegerNetwork1\">Modelica.Blocks.Examples.IntegerNetwork1</a>.
</p>
</html>"));
        end IntegerValue;

        block BooleanValue "Show Boolean value from numberPort or from number input field in diagram layer dynamically"
          parameter Boolean use_activePort = true "= true, if activePort enabled" annotation(
            Evaluate = true,
            HideResult = true,
            choices(checkBox = true));
          input Boolean active = false "Boolean variable to visualize if use_activePort=false (time varying)" annotation(
            Dialog(enable = not use_activePort),
            HideResult = true);
          Modelica.Blocks.Interfaces.BooleanInput activePort if use_activePort "Boolean variable to be shown in diagram layer if use_activePort = true" annotation(
            HideResult = true,
            Placement(transformation(extent = {{-130, -15}, {-100, 15}})));
          Modelica.Blocks.Interfaces.BooleanOutput showActive;
        equation
          if use_activePort then
            connect(activePort, showActive);
          else
            showActive = active;
          end if;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(visible = not use_activePort, extent = {{-188.0, -80.0}, {62.0, -60.0}}, textString = "%active"), Ellipse(visible = true, lineColor = {64, 64, 64}, fillColor = DynamicSelect({192, 192, 192}, if showActive > 0.5 then {0, 255, 0} else {235, 235, 235}), pattern = LinePattern.None, fillPattern = FillPattern.Sphere, extent = {{-100.0, -40.0}, {-20.0, 40.0}})}),
            Documentation(info = "<html>
<p>
This block visualizes a Boolean variable in a diagram animation.
The Boolean variable to be visualized can be defined in the following ways:
</p>

<ul>
<li> If useActivePort = <b>true</b> (which is the default), a Boolean
     input is present and this input variable is shown.</li>

<li> If useActivePort = <b>false</b> no input connector is present.
     Instead, a Boolean input field is activated in the parameter menu
     and the Boolean expression from this input menu is shown.</li>
</ul>

<p>
If the Boolean variable is <b>false</b> the block is \"grey\", otherwise, it is \"green\".
The two versions of the block are shown in the following image (in the right variant, the
name of the variable value that is displayed is also shown below the icon):
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/Interaction/BooleanValue.png\"
     alt=\"BooleanValue.png\">
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>
</html>"));
        end BooleanValue;
      end Show;
      annotation(
        Icon(graphics = {Text(extent = {{-98, -30}, {96, 34}}, textString = "0", lineColor = {0, 0, 0})}));
    end Interaction;

    package Interfaces "Library of connectors and partial models for input/output blocks"
      import Modelica.SIunits;
      extends Modelica.Icons.InterfacesPackage;
      connector RealInput = input Real "'input Real' as connector" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Polygon(lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, points = {{-100.0, 100.0}, {100.0, 0.0}, {-100.0, -100.0}})}, coordinateSystem(extent = {{-100.0, -100.0}, {100.0, 100.0}}, preserveAspectRatio = true, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = true, initialScale = 0.2, extent = {{-100.0, -100.0}, {100.0, 100.0}}), graphics = {Polygon(lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, points = {{0.0, 50.0}, {100.0, 0.0}, {0.0, -50.0}, {0.0, 50.0}}), Text(lineColor = {0, 0, 127}, extent = {{-10.0, 60.0}, {-10.0, 85.0}}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one input signal of type Real.
</p>
</html>"));
      connector RealOutput = output Real "'output Real' as connector" annotation(
        defaultComponentName = "y",
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Polygon(lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, points = {{-100.0, 100.0}, {100.0, 0.0}, {-100.0, -100.0}})}),
        Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Polygon(lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, points = {{-100.0, 50.0}, {0.0, 0.0}, {-100.0, -50.0}}), Text(lineColor = {0, 0, 127}, extent = {{30.0, 60.0}, {30.0, 110.0}}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one output signal of type Real.
</p>
</html>"));
      connector BooleanInput = input Boolean "'input Boolean' as connector" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Polygon(points = {{-100, 100}, {100, 0}, {-100, -100}, {-100, 100}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid)}, coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = true, initialScale = 0.2, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 50}, {100, 0}, {0, -50}, {0, 50}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-10, 85}, {-10, 60}}, lineColor = {255, 0, 255}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one input signal of type Boolean.
</p>
</html>"));
      connector BooleanOutput = output Boolean "'output Boolean' as connector" annotation(
        defaultComponentName = "y",
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, 100}, {100, 0}, {-100, -100}, {-100, 100}}, lineColor = {255, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid)}),
        Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, 50}, {0, 0}, {-100, -50}, {-100, 50}}, lineColor = {255, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{30, 110}, {30, 60}}, lineColor = {255, 0, 255}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one output signal of type Boolean.
</p>
</html>"));
      connector IntegerInput = input Integer "'input Integer' as connector" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Polygon(points = {{-100, 100}, {100, 0}, {-100, -100}, {-100, 100}}, lineColor = {255, 127, 0}, fillColor = {255, 127, 0}, fillPattern = FillPattern.Solid)}, coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = true, initialScale = 0.2, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 50}, {100, 0}, {0, -50}, {0, 50}}, lineColor = {255, 127, 0}, fillColor = {255, 127, 0}, fillPattern = FillPattern.Solid), Text(extent = {{-10, 85}, {-10, 60}}, lineColor = {255, 127, 0}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one input signal of type Integer.
</p>
</html>"));
      connector IntegerOutput = output Integer "'output Integer' as connector" annotation(
        defaultComponentName = "y",
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, 100}, {100, 0}, {-100, -100}, {-100, 100}}, lineColor = {255, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid)}),
        Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, 50}, {0, 0}, {-100, -50}, {-100, 50}}, lineColor = {255, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{30, 110}, {30, 60}}, lineColor = {255, 127, 0}, textString = "%name")}),
        Documentation(info = "<html>
<p>
Connector with one output signal of type Integer.
</p>
</html>"));
      connector RealVectorInput = input Real "Real input connector used for vector of connectors" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Ellipse(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid)}, coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.2, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-10, 85}, {-10, 60}}, lineColor = {0, 0, 127}, textString = "%name"), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid)}),
        Documentation(info = "<html>
<p>
Real input connector that is used for a vector of connectors,
for example <a href=\"modelica://Modelica.Blocks.Interfaces.PartialRealMISO\">PartialRealMISO</a>,
and has therefore a different icon as RealInput connector.
</p>
</html>"));
      connector IntegerVectorInput = input Integer "Integer input connector used for vector of connectors" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Ellipse(extent = {{-100, 100}, {100, -100}}, lineColor = {255, 128, 0}, fillColor = {255, 128, 0}, fillPattern = FillPattern.Solid)}, coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.2, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-10, 85}, {-10, 60}}, lineColor = {255, 128, 0}, textString = "%name"), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {255, 128, 0}, fillColor = {255, 128, 0}, fillPattern = FillPattern.Solid)}),
        Documentation(info = "<html>

<p>
Integer input connector that is used for a vector of connectors,
for example <a href=\"modelica://Modelica.Blocks.Interfaces.PartialIntegerMISO\">PartialIntegerMISO</a>,
and has therefore a different icon as IntegerInput connector.
</p>

</html>"));
      connector BooleanVectorInput = input Boolean "Boolean input connector used for vector of connectors" annotation(
        defaultComponentName = "u",
        Icon(graphics = {Ellipse(extent = {{-100, -100}, {100, 100}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid)}, coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.2)),
        Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.2, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-10, 85}, {-10, 60}}, lineColor = {255, 0, 255}, textString = "%name"), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid)}),
        Documentation(info = "<html>
<p>
Boolean input connector that is used for a vector of connectors,
for example <a href=\"modelica://Modelica.Blocks.Interfaces.PartialBooleanMISO\">PartialBooleanMISO</a>,
and has therefore a different icon as BooleanInput connector.
</p>
</html>"));

      partial block SO "Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Real output signal.
</p>
</html>"));
      end SO;

      partial block MO "Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nout(min = 1) = 1 "Number of outputs";
        RealOutput y[nout] "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Real output signal vector.
</p>
</html>"));
      end MO;

      partial block SISO "Single Input Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        RealInput u "Connector of Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Real input and one continuous Real output signal.
</p>
</html>"));
      end SISO;

      partial block SI2SO "2 Single Input / 1 Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        RealInput u1 "Connector of Real input signal 1" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        RealInput u2 "Connector of Real input signal 2" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has two continuous Real input signals u1 and u2 and one
continuous Real output signal y.
</p>
</html>"));
      end SI2SO;

      partial block SIMO "Single Input Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nout = 1 "Number of outputs";
        RealInput u "Connector of Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y[nout] "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p> Block has one continuous Real input signal and a
    vector of continuous Real output signals.</p>

</html>"));
      end SIMO;

      partial block MISO "Multiple Input Single Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nin = 1 "Number of inputs";
        RealInput u[nin] "Connector of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a vector of continuous Real input signals and
one continuous Real output signal.
</p>
</html>"));
      end MISO;

      partial block PartialRealMISO "Partial block with a RealVectorInput and a RealOutput signal"
        parameter Integer significantDigits(min = 1) = 3 "Number of significant digits to be shown in dynamic diagram layer for y" annotation(
          Dialog(tab = "Advanced"));
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.RealVectorInput u[nu] annotation(
          Placement(transformation(extent = {{-120, 70}, {-80, -70}})));
        Modelica.Blocks.Interfaces.RealOutput y annotation(
          Placement(transformation(extent = {{100, -17}, {134, 17}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.06), graphics = {Text(extent = {{110, -50}, {300, -70}}, lineColor = {0, 0, 0}, textString = DynamicSelect(" ", String(y, significantDigits = significantDigits))), Text(extent = {{-250, 170}, {250, 110}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {255, 137, 0}, lineThickness = 5.0, fillColor = {255, 255, 255}, borderPattern = BorderPattern.Raised, fillPattern = FillPattern.Solid)}));
      end PartialRealMISO;

      partial block MIMO "Multiple Input Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nin = 1 "Number of inputs";
        parameter Integer nout = 1 "Number of outputs";
        RealInput u[nin] "Connector of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y[nout] "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector.
The signal sizes of the input and output vector may be different.
</p>
</html>"));
      end MIMO;

      partial block MIMOs "Multiple Input Multiple Output continuous control block with same number of inputs and outputs"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer n = 1 "Number of inputs (= number of outputs)";
        RealInput u[n] "Connector of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y[n] "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</html>"));
      end MIMOs;

      partial block MI2MO "2 Multiple Input / Multiple Output continuous control block"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer n = 1 "Dimension of input and output vectors.";
        RealInput u1[n] "Connector 1 of Real input signals" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        RealInput u2[n] "Connector 2 of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        RealOutput y[n] "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has two continuous Real input vectors u1 and u2 and one
continuous Real output vector y.
All vectors have the same number of elements.
</p>
</html>"));
      end MI2MO;

      partial block SignalSource "Base class for continuous signal source"
        extends SO;
        parameter Real offset = 0 "Offset of output signal y";
        parameter SIunits.Time startTime = 0 "Output y = offset for time < startTime";
        annotation(
          Documentation(info = "<html>
<p>
Basic block for Real sources of package Blocks.Sources.
This component has one continuous Real output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
      end SignalSource;

      partial block SVcontrol "Single-Variable continuous controller"
        extends Modelica.Blocks.Icons.Block;
        RealInput u_s "Connector of setpoint input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealInput u_m "Connector of measurement input signal" annotation(
          Placement(transformation(origin = {0, -120}, extent = {{20, -20}, {-20, 20}}, rotation = 270)));
        RealOutput y "Connector of actuator output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-102, 34}, {-142, 24}}, textString = "(setpoint)", lineColor = {0, 0, 255}), Text(extent = {{100, 24}, {140, 14}}, textString = "(actuator)", lineColor = {0, 0, 255}), Text(extent = {{-83, -112}, {-33, -102}}, textString = " (measurement)", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
      end SVcontrol;

      partial block MVcontrol "Multi-Variable continuous controller"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nu_s = 1 "Number of setpoint inputs";
        parameter Integer nu_m = 1 "Number of measurement inputs";
        parameter Integer ny = 1 "Number of actuator outputs";
        RealInput u_s[nu_s] "Connector of setpoint input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealInput u_m[nu_m] "Connector of measurement input signals" annotation(
          Placement(transformation(origin = {0, -120}, extent = {{20, -20}, {-20, 20}}, rotation = 270)));
        RealOutput y[ny] "Connector of actuator output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-100, 36}, {-140, 26}}, textString = "(setpoint)", lineColor = {0, 0, 255}), Text(extent = {{102, 24}, {142, 14}}, textString = "(actuator)", lineColor = {0, 0, 255}), Text(extent = {{-75, -108}, {-25, -98}}, textString = " (measurement)", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
      end MVcontrol;

      partial block DiscreteBlock "Base class of discrete control blocks"
        extends Modelica.Blocks.Icons.DiscreteBlock;
        parameter SI.Time samplePeriod(min = 100 * Modelica.Constants.eps, start = 0.1) "Sample period of component";
        parameter SI.Time startTime = 0 "First sample time instant";
      protected
        output Boolean sampleTrigger "True, if sample time instant";
        output Boolean firstTrigger "Rising edge signals first sample instant";
      equation
        sampleTrigger = sample(startTime, samplePeriod);
        when sampleTrigger then
          firstTrigger = time <= startTime + samplePeriod / 2;
        end when;
        annotation(
          Documentation(info = "<html>
<p>
Basic definitions of a discrete block of library
Blocks.Discrete.
</p>
</html>"));
      end DiscreteBlock;

      partial block DiscreteSISO "Single Input Single Output discrete control block"
        extends DiscreteBlock;
        Modelica.Blocks.Interfaces.RealInput u "Continuous input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y "Continuous output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous input and one continuous output signal
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</html>"));
      end DiscreteSISO;

      partial block DiscreteMIMO "Multiple Input Multiple Output discrete control block"
        extends DiscreteBlock;
        parameter Integer nin = 1 "Number of inputs";
        parameter Integer nout = 1 "Number of outputs";
        Modelica.Blocks.Interfaces.RealInput u[nin] "Continuous input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y[nout] "Continuous output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has a continuous input and a continuous output signal vector
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</html>"));
      end DiscreteMIMO;

      partial block DiscreteMIMOs "Multiple Input Multiple Output discrete control block"
        parameter Integer n = 1 "Number of inputs (= number of outputs)";
        extends DiscreteBlock;
        Modelica.Blocks.Interfaces.RealInput u[n] "Continuous input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y[n] "Continuous output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has a continuous input and a continuous output signal vector
where the signal sizes of the input and output vector are identical.
These signals are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</html>"));
      end DiscreteMIMOs;

      partial block SVdiscrete "Discrete Single-Variable controller"
        extends DiscreteBlock;
        Discrete.Sampler sampler_s(final samplePeriod = samplePeriod, final startTime = startTime) annotation(
          Placement(transformation(extent = {{-100, -10}, {-80, 10}}, rotation = 0)));
        Discrete.Sampler sampler_m(final samplePeriod = samplePeriod, final startTime = startTime) annotation(
          Placement(transformation(origin = {0, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
        Modelica.Blocks.Interfaces.RealInput u_s "Continuous scalar setpoint input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput u_m "Continuous scalar measurement input signal" annotation(
          Placement(transformation(origin = {0, -120}, extent = {{20, -20}, {-20, 20}}, rotation = 270)));
        Modelica.Blocks.Interfaces.RealOutput y "Continuous scalar actuator output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        connect(u_s, sampler_s.u) annotation(
          Line(points = {{-120, 0}, {-102, 0}}));
        connect(u_m, sampler_m.u) annotation(
          Line(points = {{0, -120}, {0, -111}, {0, -102}}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-100, 34}, {-140, 24}}, lineColor = {0, 0, 0}, textString = "(setpoint)"), Text(extent = {{100, 22}, {130, 14}}, lineColor = {0, 0, 0}, textString = "(actuator)"), Text(extent = {{-70, -112}, {-20, -102}}, lineColor = {0, 0, 0}, textString = " (measurement)")}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal
that are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
      end SVdiscrete;

      partial block MVdiscrete "Discrete Multi-Variable controller"
        extends DiscreteBlock;
        parameter Integer nu_s = 1 "Number of setpoint inputs";
        parameter Integer nu_m = 1 "Number of measurement inputs";
        parameter Integer ny = 1 "Number of actuator outputs";
        Discrete.Sampler sampler_s[nu_s](each final samplePeriod = samplePeriod, each final startTime = startTime) annotation(
          Placement(transformation(extent = {{-90, -10}, {-70, 10}}, rotation = 0)));
        Discrete.Sampler sampler_m[nu_m](each final samplePeriod = samplePeriod, each final startTime = startTime) annotation(
          Placement(transformation(origin = {0, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
        Modelica.Blocks.Interfaces.RealInput u_s[nu_s] "Continuous setpoint input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput u_m[nu_m] "Continuous measurement input signals" annotation(
          Placement(transformation(origin = {0, -120}, extent = {{20, -20}, {-20, 20}}, rotation = 270)));
        Modelica.Blocks.Interfaces.RealOutput y[ny] "Continuous actuator output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        connect(u_s, sampler_s.u) annotation(
          Line(points = {{-120, 0}, {-92, 0}}));
        connect(u_m, sampler_m.u) annotation(
          Line(points = {{0, -120}, {0, -106}, {0, -92}}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-100, -10}, {-80, -30}}, textString = "u_s", lineColor = {0, 0, 255}), Text(extent = {{-98, 34}, {-138, 24}}, lineColor = {0, 0, 0}, textString = "(setpoint)"), Text(extent = {{98, 24}, {138, 14}}, lineColor = {0, 0, 0}, textString = "(actuator)"), Text(extent = {{-62, -110}, {-12, -100}}, lineColor = {0, 0, 0}, textString = " (measurement)")}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The vector signals
are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
      end MVdiscrete;

      partial block BooleanSISO "Single Input Single Output control block with signals of type Boolean"
        extends Modelica.Blocks.Icons.BooleanBlock;
      public
        BooleanInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal.
</p>
</html>"));
      end BooleanSISO;

      partial block BooleanMIMOs "Multiple Input Multiple Output continuous control block with same number of inputs and outputs of Boolean type"
        extends Modelica.Blocks.Icons.BooleanBlock;
        parameter Integer n = 1 "Number of inputs (= number of outputs)";
        BooleanInput u[n] "Connector of Boolean input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a continuous Boolean input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</html>"));
      end BooleanMIMOs;

      partial block MI2BooleanMOs "2 Multiple Input / Boolean Multiple Output block with same signal lengths"
        extends Modelica.Blocks.Icons.BooleanBlock;
        parameter Integer n = 1 "Dimension of input and output vectors.";
        RealInput u1[n] "Connector 1 of Boolean input signals" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        RealInput u2[n] "Connector 2 of Boolean input signals" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>Block has two Boolean input vectors u1 and u2 and one Boolean output
vector y. All vectors have the same number of elements.</p>
</html>"));
      end MI2BooleanMOs;

      partial block SI2BooleanSO "2 Single Input / Boolean Single Output block"
        extends Modelica.Blocks.Icons.BooleanBlock;
        BooleanInput u1 "Connector 1 of Boolean input signals" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        BooleanInput u2 "Connector 2 of Boolean input signals" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        BooleanOutput y "Connector of Boolean output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has two Boolean input signals u1 and u2 and one Boolean output signal y.
</p>
</html>"));
      end SI2BooleanSO;

      partial block BooleanSignalSource "Base class for Boolean signal sources"
        extends Modelica.Blocks.Icons.BooleanBlock;
        BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 68}, {-80, -80}}, color = {192, 192, 192}), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, -70}, {68, -70}}, color = {192, 192, 192}), Polygon(points = {{90, -70}, {68, -62}, {68, -78}, {90, -70}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y.
</p>
</html>"));
      end BooleanSignalSource;

      partial block IntegerSO "Single Integer Output continuous control block"
        extends Modelica.Blocks.Icons.IntegerBlock;
        IntegerOutput y "Connector of Integer output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Integer output signal.
</p>
</html>"));
      end IntegerSO;

      partial block IntegerMO "Multiple Integer Output continuous control block"
        extends Modelica.Blocks.Icons.IntegerBlock;
        parameter Integer nout(min = 1) = 1 "Number of outputs";
        IntegerOutput y[nout] "Connector of Integer output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<html>
<p>
Block has one continuous Integer output signal vector.
</p>
</html>"));
      end IntegerMO;

      partial block IntegerSignalSource "Base class for continuous Integer signal source"
        extends IntegerSO;
        parameter Integer offset = 0 "Offset of output signal y";
        parameter SI.Time startTime = 0 "Output y = offset for time < startTime";
        annotation(
          Documentation(info = "<html>
<p>
Basic block for Integer sources of package Blocks.Sources.
This component has one continuous Integer output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
      end IntegerSignalSource;

      partial block IntegerSIBooleanSO "Integer Input Boolean Output continuous control block"
        extends Modelica.Blocks.Icons.BooleanBlock;
        IntegerInput u "Connector of Integer input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal.
</p>
</html>"));
      end IntegerSIBooleanSO;

      partial block IntegerMIBooleanMOs "Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs"
        extends Modelica.Blocks.Icons.BooleanBlock;
        parameter Integer n = 1 "Number of inputs (= number of outputs)";
        IntegerInput u[n] "Connector of Integer input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Documentation(info = "<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</html>"));
      end IntegerMIBooleanMOs;

      partial block PartialIntegerSISO "Partial block with a IntegerInput and an IntegerOutput signal"
        Modelica.Blocks.Interfaces.IntegerInput u "Integer input signal" annotation(
          Placement(transformation(extent = {{-180, -40}, {-100, 40}})));
        Modelica.Blocks.Interfaces.IntegerOutput y "Integer output signal" annotation(
          Placement(transformation(extent = {{100, -20}, {140, 20}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}, initialScale = 0.06), graphics = {Text(extent = {{110, -50}, {250, -70}}, lineColor = {0, 0, 0}, textString = DynamicSelect(" ", String(y, minimumLength = 1, significantDigits = 0))), Text(extent = {{-250, 170}, {250, 110}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised)}));
      end PartialIntegerSISO;

      partial block PartialIntegerMISO "Partial block with an IntegerVectorInput and an IntegerOutput signal"
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.IntegerVectorInput u[nu] "Vector of Integer input signals" annotation(
          Placement(transformation(extent = {{-120, 70}, {-80, -70}})));
        Modelica.Blocks.Interfaces.IntegerOutput y "Integer output signal" annotation(
          Placement(transformation(extent = {{100, -15}, {130, 15}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.06), graphics = {Text(extent = {{110, -50}, {250, -70}}, lineColor = {0, 0, 0}, textString = DynamicSelect(" ", String(y, minimumLength = 1, significantDigits = 0))), Text(extent = {{-250, 170}, {250, 110}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {255, 137, 0}, lineThickness = 5.0, fillColor = {255, 213, 170}, borderPattern = BorderPattern.Raised, fillPattern = FillPattern.Solid)}));
      end PartialIntegerMISO;

      partial block partialBooleanSISO "Partial block with 1 input and 1 output Boolean signal"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-71, 7}, {-85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if u > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSISO;

      partial block partialBooleanSI2SO "Partial block with 2 input and 1 output Boolean signal"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u1 "Connector of first Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanInput u2 "Connector of second Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-71, 7}, {-85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if u1 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u1 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{-71, -74}, {-85, -88}}, lineColor = DynamicSelect({235, 235, 235}, if u2 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u2 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Block has two continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSI2SO;

      partial block partialBooleanSI3SO "Partial block with 3 input and 1 output Boolean signal"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u1 "Connector of first Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, 60}, {-100, 100}}, rotation = 0)));
        Blocks.Interfaces.BooleanInput u2 "Connector of second Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanInput u3 "Connector of third Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-71, 74}, {-85, 88}}, lineColor = DynamicSelect({235, 235, 235}, if u1 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u1 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{-71, 7}, {-85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if u2 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u2 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{-71, -74}, {-85, -88}}, lineColor = DynamicSelect({235, 235, 235}, if u3 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u3 > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html><p>
Block has three continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSI3SO;

      partial block partialBooleanSI "Partial block with 1 input Boolean signal"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-71, 7}, {-85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if u > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if u > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Block has one continuous Boolean input signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSI;

      partial block partialBooleanSO "Partial block with 1 output Boolean signal"
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Block has one continuous Boolean output signal
with a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSO;

      partial block partialBooleanSource "Partial source block (has 1 output Boolean signal and an appropriate default icon)"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-80, 88}, {-88, 66}, {-72, 66}, {-80, 88}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid), Line(points = {{-80, 66}, {-80, -82}}, color = {255, 0, 255}), Line(points = {{-90, -70}, {72, -70}}, color = {255, 0, 255}), Polygon(points = {{90, -70}, {68, -62}, {68, -78}, {90, -70}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-70, 92}, {-76, 70}, {-64, 70}, {-70, 92}}, lineColor = {95, 95, 95}, fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid), Line(points = {{-70, 70}, {-70, -88}}, color = {95, 95, 95}), Line(points = {{-90, -70}, {68, -70}}, color = {95, 95, 95}), Polygon(points = {{90, -70}, {68, -64}, {68, -76}, {90, -70}}, lineColor = {95, 95, 95}, fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid), Text(extent = {{54, -80}, {106, -92}}, lineColor = {0, 0, 0}, textString = "time"), Text(extent = {{-64, 92}, {-46, 74}}, lineColor = {0, 0, 0}, textString = "y")}),
          Documentation(info = "<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y
and a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanSource;

      partial block partialBooleanThresholdComparison "Partial block to compare the Real input u with a threshold and provide the result as 1 Boolean output signal"
        parameter Real threshold = 0 "Comparison with respect to threshold";
        Blocks.Interfaces.RealInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {210, 210, 210}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-150, -140}, {150, -110}}, lineColor = {0, 0, 0}, textString = "%threshold"), Ellipse(extent = {{71, 7}, {85, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
Block has one continuous Real input and one continuous Boolean output signal
as well as a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanThresholdComparison;

      partial block partialBooleanComparison "Partial block with 2 Real input and 1 Boolean output signal (the result of a comparison of the two Real inputs)"
        Blocks.Interfaces.RealInput u1 "Connector of first Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.RealInput u2 "Connector of second Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {210, 210, 210}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Ellipse(extent = {{73, 7}, {87, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127})}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input and one continuous Boolean output signal
as a result of the comparison of the two input signals. The block
has a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end partialBooleanComparison;

      partial block PartialBooleanSISO_small "Partial block with a BooleanInput and a BooleanOutput signal and a small block icon"
        Modelica.Blocks.Interfaces.BooleanInput u "Boolean input signal" annotation(
          Placement(transformation(extent = {{-180, -40}, {-100, 40}})));
        Modelica.Blocks.Interfaces.BooleanOutput y "Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -20}, {140, 20}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.04), graphics = {Text(extent = {{-250, 170}, {250, 110}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Ellipse(extent = {{60, 10}, {80, -10}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}));
      end PartialBooleanSISO_small;

      partial block PartialBooleanMISO "Partial block with a BooleanVectorInput and a BooleanOutput signal"
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.BooleanVectorInput u[nu] "Vector of Boolean input signals" annotation(
          Placement(transformation(extent = {{-120, 70}, {-80, -70}})));
        Modelica.Blocks.Interfaces.BooleanOutput y "Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -15}, {130, 15}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.06), graphics = {Text(extent = {{-250, 170}, {250, 110}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Ellipse(extent = {{60, 10}, {80, -10}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}));
      end PartialBooleanMISO;

      package Adaptors "Obsolete package with components to send signals to a bus or receive signals from a bus (only for backward compatibility)"
        extends Modelica.Icons.Package;
        // extends Modelica.Icons.ObsoleteModel;

        block SendReal "Obsolete block to send Real signal to bus"
          // extends Modelica.Icons.ObsoleteModel;
          RealOutput toBus "Output signal to be connected to bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
          RealInput u "Input signal to be send to bus" annotation(
            Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        equation
          toBus = u;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name"), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {0, 0, 127}, textString = "send")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect a Real signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end SendReal;

        block SendBoolean "Obsolete block to send Boolean signal to bus"
          // extends Modelica.Icons.ObsoleteModel;
          BooleanOutput toBus "Output signal to be connected to bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
          BooleanInput u "Input signal to be send to bus" annotation(
            Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        equation
          toBus = u;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {255, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name"), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {255, 0, 255}, textString = "send")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end SendBoolean;

        block SendInteger "Obsolete block to send Integer signal to bus"
          // extends Modelica.Icons.ObsoleteModel;
          IntegerOutput toBus "Output signal to be connected to bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
          IntegerInput u "Input signal to be send to bus" annotation(
            Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        equation
          toBus = u;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {255, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name"), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {255, 127, 0}, textString = "send")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect an Integer signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end SendInteger;

        block ReceiveReal "Obsolete block to receive Real signal from bus"
          // extends Modelica.Icons.ObsoleteModel;
          RealInput fromBus "To be connected with signal on bus" annotation(
            Placement(transformation(extent = {{-120, -10}, {-100, 10}}, rotation = 0)));
          RealOutput y "Output signal to be received from bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        equation
          y = fromBus;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {0, 0, 127}, textString = "receive"), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect a Real signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end ReceiveReal;

        block ReceiveBoolean "Obsolete block to receive Boolean signal from bus"
          // extends Modelica.Icons.ObsoleteModel;
          BooleanInput fromBus "To be connected with signal on bus" annotation(
            Placement(transformation(extent = {{-120, -10}, {-100, 10}}, rotation = 0)));
          BooleanOutput y "Output signal to be received from bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        equation
          y = fromBus;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {255, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {255, 0, 255}, textString = "receive"), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end ReceiveBoolean;

        block ReceiveInteger "Obsolete block to receive Integer signal from bus"
          // extends Modelica.Icons.ObsoleteModel;
          IntegerInput fromBus "To be connected with signal on bus" annotation(
            Placement(transformation(extent = {{-120, -10}, {-100, 10}}, rotation = 0)));
          IntegerOutput y "Output signal to be received from bus" annotation(
            Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        equation
          y = fromBus;
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 40}, {100, -40}}, lineColor = {255, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-100, 30}, {100, -30}}, lineColor = {255, 127, 0}, textString = "receive"), Text(extent = {{-144, 96}, {144, 46}}, lineColor = {0, 0, 0}, textString = "%name")}),
            Documentation(info = "<html>
<p>
Obsolete block that was previously used to connect an Integer signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>

<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
        end ReceiveInteger;
        annotation(
          Documentation(info = "<html>
<p>
The components of this package should no longer be used.
They are only provided for backward compatibility.
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example
<a href=\"modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
      end Adaptors;

      partial block PartialConversionBlock "Partial block defining the interface for conversion blocks"
        RealInput u "Connector of Real input signal to be converted" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        RealOutput y "Connector of Real output signal containing input signal u in another unit" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Rectangle(lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100.0, -100.0}, {100.0, 100.0}}), Line(points = {{-90.0, 0.0}, {30.0, 0.0}}, color = {191, 0, 0}), Polygon(lineColor = {191, 0, 0}, fillColor = {191, 0, 0}, fillPattern = FillPattern.Solid, points = {{90.0, 0.0}, {30.0, 20.0}, {30.0, -20.0}, {90.0, 0.0}}), Text(lineColor = {0, 0, 255}, extent = {{-115.0, 105.0}, {115.0, 155.0}}, textString = "%name")}),
          Documentation(info = "<html>
<p>
This block defines the interface of a conversion block that
converts from one unit into another one.
</p>

</html>"));
      end PartialConversionBlock;

      partial block BlockIcon "This icon will be removed in future Modelica versions, use Modelica.Blocks.Icons.Block instead."
        // extends Modelica.Icons.ObsoleteModel;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This icon will be removed in future versions of the Modelica Standard Library.
Instead the icon <a href=\"modelica://Modelica.Blocks.Icons.Block\">Modelica.Blocks.Icons.Block</a> shall be used.
</p>
</html>"));
      end BlockIcon;

      partial block BooleanBlockIcon "This icon will be removed in future Modelica versions, use Modelica.Blocks.Icons.BooleanBlock instead."
        // extends Modelica.Icons.ObsoleteModel;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {255, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This icon will be removed in future versions of the Modelica Standard Library.
Instead the icon <a href=\"modelica://Modelica.Blocks.Icons.BooleanBlock\">Modelica.Blocks.Icons.BooleanBlock</a> shall be used.
</p>
</html>"));
      end BooleanBlockIcon;

      partial block DiscreteBlockIcon "This icon will be removed in future Modelica versions, use Modelica.Blocks.Icons.DiscreteBlock instead."
        // extends Modelica.Icons.ObsoleteModel;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 127}, lineThickness = 5.0, fillColor = {223, 211, 169}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This icon will be removed in future versions of the Modelica Standard Library.
Instead the icon <a href=\"modelica://Modelica.Blocks.Icons.DiscreteBlock\">Modelica.Blocks.Icons.DiscreteBlock</a> shall be used.
</p>
</html>"));
      end DiscreteBlockIcon;

      partial block IntegerBlockIcon "This icon will be removed in future Modelica versions, use Modelica.Blocks.Icons.IntegerBlock instead."
        // extends Modelica.Icons.ObsoleteModel;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {255, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This icon will be removed in future versions of the Modelica Standard Library.
Instead the icon <a href=\"modelica://Modelica.Blocks.Icons.IntegerBlock\">Modelica.Blocks.Icons.IntegerBlock</a> shall be used.
</p>
</html>"));
      end IntegerBlockIcon;

      partial block partialBooleanBlockIcon "This icon will be removed in future Modelica versions, use Modelica.Blocks.Icons.PartialBooleanBlock instead."
        // extends Modelica.Icons.ObsoleteModel;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 5.0, fillColor = {210, 210, 210}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This icon will be removed in future versions of the Modelica Standard Library.
Instead the icon <a href=\"modelica://Modelica.Blocks.Icons.PartialBooleanBlock\">Modelica.Blocks.Icons.PartialBooleanBlock</a> shall be used.
</p>
</html>"));
      end partialBooleanBlockIcon;
      annotation(
        Documentation(info = "<HTML>
<p>
This package contains interface definitions for
<b>continuous</b> input/output blocks with Real,
Integer and Boolean signals. Furthermore, it contains
partial models for continuous and discrete blocks.
</p>

</html>", revisions = "<html>
<ul>
<li><i>Oct. 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Added several new interfaces.
<li><i>Oct. 24, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       RealInputSignal renamed to RealInput. RealOutputSignal renamed to
       output RealOutput. GraphBlock renamed to BlockIcon. SISOreal renamed to
       SISO. SOreal renamed to SO. I2SOreal renamed to M2SO.
       SignalGenerator renamed to SignalSource. Introduced the following
       new models: MIMO, MIMOs, SVcontrol, MVcontrol, DiscreteBlockIcon,
       DiscreteBlock, DiscreteSISO, DiscreteMIMO, DiscreteMIMOs,
       BooleanBlockIcon, BooleanSISO, BooleanSignalSource, MI2BooleanMOs.</li>
<li><i>June 30, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));
    end Interfaces;

    package Logical "Library of components with Boolean input and output signals"
      extends Modelica.Icons.Package;

      block And "Logical 'and': y = u1 and u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = u1 and u2;
        annotation(
          defaultComponentName = "and1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "and")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if all inputs are <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end And;

      block Or "Logical 'or': y = u1 or u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = u1 or u2;
        annotation(
          defaultComponentName = "or1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "or")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if at least one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Or;

      block Xor "Logical 'xor': y = u1 xor u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = not (u1 and u2 or not u1 and not u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "xor")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if exactly one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Xor;

      block Nor "Logical 'nor': y = not (u1 or u2)"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = not (u1 or u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "nor")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if none of the inputs is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Nor;

      block Nand "Logical 'nand': y = not (u1 and u2)"
        extends Blocks.Interfaces.partialBooleanSI2SO;
      equation
        y = not (u1 and u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "nand")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if at least one input is <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Nand;

      block Not "Logical 'not': y = not u"
        extends Blocks.Interfaces.partialBooleanSISO;
      equation
        y = not u;
        annotation(
          defaultComponentName = "not1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "not")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the input is <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Not;

      block Pre "Breaks algebraic loops by an infinitesimal small time delay (y = pre(u): event iteration continues until u = pre(u))"
        parameter Boolean pre_u_start = false "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;
      initial equation
        pre(u) = pre_u_start;
      equation
        y = pre(u);
        annotation(
          defaultComponentName = "pre1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "pre")}),
          Documentation(info = "<html>
<p>
This block delays the Boolean input by an infinitesimal small time delay and
therefore breaks algebraic loops. In a network of logical blocks, in every
\"closed connection loop\" at least one logical block must have a delay,
since algebraic systems of Boolean equations are not solvable.
</p>

<p>
The \"Pre\" block returns the value of the \"input\" signal from the
last \"event iteration\". The \"event iteration\" stops, once both
values are identical (u = pre(u)).
</p>
</html>"));
      end Pre;

      block Edge "Output y is true, if the input u has a rising edge (y = edge(u))"
        parameter Boolean pre_u_start = false "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;
      initial equation
        pre(u) = pre_u_start;
      equation
        y = edge(u);
        annotation(
          defaultComponentName = "edge1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "edge")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Boolean input has a rising edge
from <b>false</b> to <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Edge;

      block FallingEdge "Output y is true, if the input u has a falling edge (y = edge(not u))"
        parameter Boolean pre_u_start = false "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;
      protected
        Boolean not_u = not u;
      initial equation
        pre(not_u) = not pre_u_start;
      equation
        y = edge(not_u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "falling")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Boolean input has a falling edge
from <b>true</b> to <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end FallingEdge;

      block Change "Output y is true, if the input u has a rising or falling edge (y = change(u))"
        parameter Boolean pre_u_start = false "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;
      initial equation
        pre(u) = pre_u_start;
      equation
        y = change(u);
        annotation(
          defaultComponentName = "change1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 40}, {90, -40}}, lineColor = {0, 0, 0}, textString = "change")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Boolean input has either a rising edge
from <b>false</b> to <b>true</b> or a falling edge from
<b>true</b> to <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end Change;

      block GreaterThreshold "Output y is true, if input u is greater than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
      equation
        y = u > threshold;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, -40}, {60, 40}}, lineColor = {0, 0, 0}, textString = ">")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Real input is greater than
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end GreaterThreshold;

      block GreaterEqualThreshold "Output y is true, if input u is greater or equal than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
      equation
        y = u >= threshold;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, -40}, {60, 40}}, lineColor = {0, 0, 0}, textString = ">=")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Real input is greater than or equal to
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end GreaterEqualThreshold;

      block LessThreshold "Output y is true, if input u is less than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
      equation
        y = u < threshold;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, -40}, {60, 40}}, lineColor = {0, 0, 0}, textString = "<")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Real input is less than
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end LessThreshold;

      block LessEqualThreshold "Output y is true, if input u is less or equal than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
      equation
        y = u <= threshold;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, -40}, {60, 40}}, lineColor = {0, 0, 0}, textString = "<=")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if the Real input is less than or equal to
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      end LessEqualThreshold;

      block Greater "Output y is true, if input u1 is greater than input u2"
        extends Blocks.Interfaces.partialBooleanComparison;
      equation
        y = u1 > u2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127}), Line(points = {{-54, 22}, {-8, 2}, {-54, -18}}, color = {0, 0, 0}, smooth = Smooth.None, thickness = 0.5)}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if Real input u1 is greater than
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));
      end Greater;

      block GreaterEqual "Output y is true, if input u1 is greater or equal than input u2"
        extends Blocks.Interfaces.partialBooleanComparison;
      equation
        y = u1 >= u2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127}), Line(points = {{-54, 22}, {-8, 2}, {-54, -18}}, color = {0, 0, 0}, smooth = Smooth.None, thickness = 0.5), Line(points = {{-52, -36}, {-6, -14}}, color = {0, 0, 0}, thickness = 0.5, smooth = Smooth.None)}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if Real input u1 is greater than or equal to
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));
      end GreaterEqual;

      block Less "Output y is true, if input u1 is less than input u2"
        extends Blocks.Interfaces.partialBooleanComparison;
      equation
        y = u1 < u2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127}), Line(points = {{-6, 18}, {-50, -2}, {-6, -20}}, color = {0, 0, 0}, thickness = 0.5, smooth = Smooth.None)}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if Real input u1 is less than
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));
      end Less;

      block LessEqual "Output y is true, if input u1 is less or equal than input u2"
        extends Blocks.Interfaces.partialBooleanComparison;
      equation
        y = u1 <= u2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127}), Line(points = {{-10, 20}, {-54, 0}, {-10, -18}}, color = {0, 0, 0}, thickness = 0.5, smooth = Smooth.None), Line(points = {{-54, -18}, {-14, -34}}, color = {0, 0, 0}, thickness = 0.5, smooth = Smooth.None)}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if Real input u1 is less than or equal to
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));
      end LessEqual;

      block ZeroCrossing "Trigger zero crossing of input u"
        extends Blocks.Interfaces.partialBooleanSO;
        Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanInput enable "Zero input crossing is triggered if the enable input signal is true" annotation(
          Placement(transformation(origin = {0, -120}, extent = {{-20, -20}, {20, 20}}, rotation = 90)));
      protected
        Boolean disable = not enable;
        Boolean u_pos;
      initial equation
        pre(u_pos) = false;
        pre(enable) = false;
        pre(disable) = not pre(enable);
      equation
        u_pos = enable and u >= 0;
        y = change(u_pos) and not edge(enable) and not edge(disable);
        annotation(
          Documentation(info = "<HTML>
<p>
The output \"y\" is <b>true</b> at the
time instant when the input \"u\" becomes
zero, provided the input \"enable\" is
<b>true</b>. At all other time instants, the output \"y\" is <b>false</b>.
If the input \"u\" is zero at a time instant when the \"enable\"
input changes its value, then the output y is <b>false</b>.
</p>
<p>
Note, that in the plot window of a Modelica simulator, the output of
this block is usually identically to <b>false</b>, because the output
may only be <b>true</b> at an event instant, but not during
continuous integration. In order to check that this component is
actually working as expected, one should connect its output to, e.g.,
component <i>ModelicaAdditions.Blocks.Discrete.TriggeredSampler</i>.
</p>
</HTML>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-78, 68}, {-78, -80}}, color = {192, 192, 192}), Polygon(points = {{-78, 90}, {-86, 68}, {-70, 68}, {-78, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-88, 0}, {70, 0}}, color = {192, 192, 192}), Line(points = {{-78, 0}, {-73.2, 32.3}, {-70, 50.3}, {-66.7, 64.5}, {-63.5, 74.2}, {-60.3, 79.3}, {-57.1, 79.6}, {-53.9, 75.3}, {-50.7, 67.1}, {-46.6, 52.2}, {-41, 25.8}, {-33, -13.9}, {-28.2, -33.7}, {-24.1, -45.9}, {-20.1, -53.2}, {-16.1, -55.3}, {-12.1, -52.5}, {-8.1, -45.3}, {-3.23, -32.1}, {10.44, 13.7}, {15.3, 26.4}, {20.1, 34.8}, {24.1, 38}, {28.9, 37.2}, {33.8, 31.8}, {40.2, 19.4}, {53.1, -10.5}, {59.5, -21.2}, {65.1, -25.9}, {70.7, -25.9}, {77.2, -20.5}, {82, -13.8}}, color = {192, 192, 192}, smooth = Smooth.Bezier), Polygon(points = {{92, 0}, {70, 8}, {70, -8}, {92, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-36, -59}, {-36, 81}}, color = {255, 0, 255}), Line(points = {{6, -59}, {6, 81}}, color = {255, 0, 255}), Line(points = {{49, -59}, {49, 81}}, color = {255, 0, 255}), Line(points = {{-78, 0}, {70, 0}}, color = {255, 0, 255})}));
      end ZeroCrossing;

      block LogicalSwitch "Logical Switch"
        extends Blocks.Interfaces.partialBooleanSI3SO;
      equation
        y = if u2 then u1 else u3;
        annotation(
          Documentation(info = "<html>
<p>The LogicalSwitch switches, depending on the
Boolean u2 connector (the middle connector),
between the two possible input signals
u1 (upper connector) and u3 (lower connector).</p>
<p>If u2 is true, connector y is set equal to
u1, else it is set equal to u3.</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Line(points = {{12, 0}, {100, 0}}, color = {255, 0, 255}), Line(points = {{-100, 0}, {-40, 0}}, color = {255, 0, 255}), Line(points = {{-100, -80}, {-40, -80}, {-40, -80}}, color = {255, 0, 255}), Line(points = {{-40, 12}, {-40, -10}}, color = {255, 0, 255}), Line(points = {{-100, 80}, {-40, 80}}, color = {255, 0, 255}), Line(points = {{-40, 80}, {8, 2}}, color = {255, 0, 255}, thickness = 1), Ellipse(visible = true, lineColor = {0, 0, 127}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, extent = {{2.0, -6.0}, {18.0, 8.0}})}));
      end LogicalSwitch;

      block Switch "Switch between two Real signals"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.RealInput u1 "Connector of first Real input signal" annotation(
          Placement(transformation(extent = {{-140, 60}, {-100, 100}}, rotation = 0)));
        Blocks.Interfaces.BooleanInput u2 "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.RealInput u3 "Connector of second Real input signal" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = if u2 then u1 else u3;
        annotation(
          defaultComponentName = "switch1",
          Documentation(info = "<html>
<p>The Logical.Switch switches, depending on the
logical connector u2 (the middle connector)
between the two possible input signals
u1 (upper connector) and u3 (lower connector).</p>
<p>If u2 is <b>true</b>, the output signal y is set equal to
u1, else it is set equal to u3.</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Line(points = {{12.0, 0.0}, {100.0, 0.0}}, color = {0, 0, 127}), Line(points = {{-100.0, 0.0}, {-40.0, 0.0}}, color = {255, 0, 255}), Line(points = {{-100.0, -80.0}, {-40.0, -80.0}, {-40.0, -80.0}}, color = {0, 0, 127}), Line(points = {{-40.0, 12.0}, {-40.0, -12.0}}, color = {255, 0, 255}), Line(points = {{-100.0, 80.0}, {-38.0, 80.0}}, color = {0, 0, 127}), Line(points = {{-38.0, 80.0}, {6.0, 2.0}}, color = {0, 0, 127}, thickness = 1.0), Ellipse(lineColor = {0, 0, 255}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, extent = {{2.0, -8.0}, {18.0, 8.0}})}));
      end Switch;

      block Hysteresis "Transform Real to Boolean signal with Hysteresis"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        parameter Real uLow(start = 0) "if y=true and u<=uLow, switch to y=false";
        parameter Real uHigh(start = 1) "if y=false and u>=uHigh, switch to y=true";
        parameter Boolean pre_y_start = false "Value of pre(y) at initial time";
        Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      initial equation
        pre(y) = pre_y_start;
      equation
        y = u > uHigh or pre(y) and u >= uLow;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-65, 89}, {-73, 67}, {-57, 67}, {-65, 89}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-65, 67}, {-65, -81}}, color = {192, 192, 192}), Line(points = {{-90, -70}, {82, -70}}, color = {192, 192, 192}), Polygon(points = {{90, -70}, {68, -62}, {68, -78}, {90, -70}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{70, -80}, {94, -100}}, lineColor = {160, 160, 164}, textString = "u"), Text(extent = {{-65, 93}, {-12, 75}}, lineColor = {160, 160, 164}, textString = "y"), Line(points = {{-80, -70}, {30, -70}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{-50, 10}, {80, 10}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{-50, 10}, {-50, -70}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{30, 10}, {30, -70}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{-10, -65}, {0, -70}, {-10, -75}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{-10, 15}, {-20, 10}, {-10, 5}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{-55, -20}, {-50, -30}, {-44, -20}}, color = {0, 0, 0}, thickness = 0.5), Line(points = {{25, -30}, {30, -19}, {35, -30}}, color = {0, 0, 0}, thickness = 0.5), Text(extent = {{-99, 2}, {-70, 18}}, lineColor = {160, 160, 164}, textString = "true"), Text(extent = {{-98, -87}, {-66, -73}}, lineColor = {160, 160, 164}, textString = "false"), Text(extent = {{19, -87}, {44, -70}}, lineColor = {0, 0, 0}, textString = "uHigh"), Text(extent = {{-63, -88}, {-38, -71}}, lineColor = {0, 0, 0}, textString = "uLow"), Line(points = {{-69, 10}, {-60, 10}}, color = {160, 160, 164})}),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 68}, {-80, -29}}, color = {192, 192, 192}), Polygon(points = {{92, -29}, {70, -21}, {70, -37}, {92, -29}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-79, -29}, {84, -29}}, color = {192, 192, 192}), Line(points = {{-79, -29}, {41, -29}}, color = {0, 0, 0}), Line(points = {{-15, -21}, {1, -29}, {-15, -36}}, color = {0, 0, 0}), Line(points = {{41, 51}, {41, -29}}, color = {0, 0, 0}), Line(points = {{33, 3}, {41, 22}, {50, 3}}, color = {0, 0, 0}), Line(points = {{-49, 51}, {81, 51}}, color = {0, 0, 0}), Line(points = {{-4, 59}, {-19, 51}, {-4, 43}}, color = {0, 0, 0}), Line(points = {{-59, 29}, {-49, 11}, {-39, 29}}, color = {0, 0, 0}), Line(points = {{-49, 51}, {-49, -29}}, color = {0, 0, 0}), Text(extent = {{-92, -49}, {-9, -92}}, lineColor = {192, 192, 192}, textString = "%uLow"), Text(extent = {{2, -49}, {91, -92}}, lineColor = {192, 192, 192}, textString = "%uHigh"), Rectangle(extent = {{-91, -49}, {-8, -92}}, lineColor = {192, 192, 192}), Line(points = {{-49, -29}, {-49, -49}}, color = {192, 192, 192}), Rectangle(extent = {{2, -49}, {91, -92}}, lineColor = {192, 192, 192}), Line(points = {{41, -29}, {41, -49}}, color = {192, 192, 192})}),
          Documentation(info = "<HTML>
<p>
This block transforms a <b>Real</b> input signal into a <b>Boolean</b>
output signal:
</p>
<ul>
<li> When the output was <b>false</b> and the input becomes
     <b>greater</b> than parameter <b>uHigh</b>, the output
     switches to <b>true</b>.</li>
<li> When the output was <b>true</b> and the input becomes
     <b>less</b> than parameter <b>uLow</b>, the output
     switches to <b>false</b>.</li>
</ul>
<p>
The start value of the output is defined via parameter
<b>pre_y_start</b> (= value of pre(y) at initial time).
The default value of this parameter is <b>false</b>.
</p>
</html>"));
      end Hysteresis;

      block OnOffController "On-off controller"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.RealInput reference "Connector of Real input signal used as reference signal" annotation(
          Placement(transformation(extent = {{-140, 80}, {-100, 40}}, rotation = 0)));
        Blocks.Interfaces.RealInput u "Connector of Real input signal used as measurement signal" annotation(
          Placement(transformation(extent = {{-140, -40}, {-100, -80}}, rotation = 0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Real output signal used as actuator signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        parameter Real bandwidth(start = 0.1) "Bandwidth around reference signal";
        parameter Boolean pre_y_start = false "Value of pre(y) at initial time";
      initial equation
        pre(y) = pre_y_start;
      equation
        y = pre(y) and u < reference + bandwidth / 2 or u < reference - bandwidth / 2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Text(extent = {{-92, 74}, {44, 44}}, lineThickness = 0.5, textString = "reference"), Text(extent = {{-94, -52}, {-34, -74}}, textString = "u"), Line(points = {{-76.0, -32.0}, {-68.0, -6.0}, {-50.0, 26.0}, {-24.0, 40.0}, {-2.0, 42.0}, {16.0, 36.0}, {32.0, 28.0}, {48.0, 12.0}, {58.0, -6.0}, {68.0, -28.0}}, color = {0, 0, 127}), Line(points = {{-78.0, -2.0}, {-6.0, 18.0}, {82.0, -12.0}}, color = {255, 0, 0}), Line(points = {{-78.0, 12.0}, {-6.0, 30.0}, {82.0, 0.0}}), Line(points = {{-78.0, -16.0}, {-6.0, 4.0}, {82.0, -26.0}}), Line(points = {{-82.0, -18.0}, {-56.0, -18.0}, {-56.0, -40.0}, {64.0, -40.0}, {64.0, -20.0}, {90.0, -20.0}}, color = {255, 0, 255})}),
          Documentation(info = "<html>
<p>The block OnOffController sets the output signal <b>y</b> to <b>true</b> when
the input signal <b>u</b> falls below the <b>reference</b> signal minus half of
the bandwidth and sets the output signal <b>y</b> to <b>false</b> when the input
signal <b>u</b> exceeds the <b>reference</b> signal plus half of the bandwidth.</p>
</html>"));
      end OnOffController;

      block TriggeredTrapezoid "Triggered trapezoid generator"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        parameter Real amplitude = 1 "Amplitude of trapezoid";
        parameter Modelica.SIunits.Time rising(final min = 0) = 0 "Rising duration of trapezoid";
        parameter Modelica.SIunits.Time falling(final min = 0) = rising "Falling duration of trapezoid";
        parameter Real offset = 0 "Offset of output signal";
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      protected
        discrete Real endValue "Value of y at time of recent edge";
        discrete Real rate "Current rising/falling rate";
        discrete Modelica.SIunits.Time T "Predicted time of output reaching endValue";
      equation
        y = if time < T then endValue - (T - time) * rate else endValue;
        when {initial(), u, not u} then
          endValue = if u then offset + amplitude else offset;
          rate = if u and rising > 0 then amplitude / rising else if not u and falling > 0 then -amplitude / falling else 0;
          T = if u and not rising > 0 or not u and not falling > 0 or not abs(amplitude) > 0 or initial() then time else time + (endValue - pre(y)) / rate;
        end when;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-60.0, -70.0}, {-60.0, -70.0}, {-30.0, 40.0}, {8.0, 40.0}, {40.0, -70.0}, {40.0, -70.0}}, color = {0, 0, 127}), Line(visible = true, points = {{-90.0, -70.0}, {82.0, -70.0}}, color = {192, 192, 192}), Line(visible = true, points = {{-80.0, 68.0}, {-80.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -70.0}, {68.0, -62.0}, {68.0, -78.0}, {90.0, -70.0}}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-80.0, -70.0}, {-60.0, -70.0}, {-60.0, 24.0}, {8.0, 24.0}, {8.0, -70.0}, {60.0, -70.0}}, color = {255, 0, 255})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, -20}, {-60, -20}, {-30, 40}, {8, 40}, {40, -20}, {60, -20}}, color = {0, 0, 255}), Line(points = {{-90, -70}, {82, -70}}, color = {0, 0, 0}), Line(points = {{-80, 68}, {-80, -80}}, color = {0, 0, 0}), Polygon(points = {{90, -70}, {68, -62}, {68, -78}, {90, -70}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-80, -68}, {-60, -68}, {-60, -42}, {8, -42}, {8, -68}, {60, -68}}, color = {255, 0, 255}), Line(points = {{-60, 40}, {-60, -42}}, color = {0, 0, 0}, pattern = LinePattern.Dot), Line(points = {{8, -42}, {8, 40}}, color = {0, 0, 0}, pattern = LinePattern.Dot), Line(points = {{-60, 40}, {-30, 40}}, color = {0, 0, 0}), Line(points = {{8, -20}, {40, -20}}, color = {0, 0, 0}), Line(points = {{-20, 40}, {-20, -20}}, color = {0, 0, 0}), Line(points = {{-20, -20}, {-20, -70}}, color = {0, 0, 0}), Text(extent = {{-44, 50}, {-44, 40}}, lineColor = {0, 0, 0}, textString = "rising"), Text(extent = {{24, -10}, {24, -20}}, lineColor = {0, 0, 0}, textString = "falling"), Polygon(points = {{-60, 40}, {-56, 42}, {-56, 38}, {-60, 40}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-30, 40}, {-34, 42}, {-34, 38}, {-30, 40}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{8, -20}, {12, -18}, {12, -22}, {8, -20}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{40, -20}, {36, -18}, {36, -22}, {40, -20}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-22, -24}, {-20, -20}, {-18, -24}, {-22, -24}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-18, -66}, {-22, -66}, {-20, -70}, {-18, -66}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-22, 36}, {-20, 40}, {-18, 36}, {-22, 36}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-18, -16}, {-22, -16}, {-20, -20}, {-18, -16}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Rectangle(extent = {{-40, 6}, {0, -4}}, lineColor = {255, 255, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-20, 6}, {-20, -4}}, lineColor = {0, 0, 0}, textString = "amplitude"), Rectangle(extent = {{-40, -48}, {0, -58}}, lineColor = {255, 255, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-20, -48}, {-20, -58}}, lineColor = {0, 0, 0}, textString = "offset"), Text(extent = {{60, -82}, {94, -92}}, lineColor = {0, 0, 0}, textString = "time"), Text(extent = {{-88, -4}, {-54, -14}}, lineColor = {0, 0, 0}, textString = "y"), Text(extent = {{-88, -46}, {-54, -56}}, lineColor = {0, 0, 0}, textString = "u")}),
          Documentation(info = "<HTML>
<p>The block TriggeredTrapezoid has a Boolean input and a real
output signal and requires the parameters <i>amplitude</i>,
<i>rising</i>, <i>falling</i> and <i>offset</i>. The
output signal <b>y</b> represents a trapezoidal signal dependent on the
input signal <b>u</b>.
</p>
<p>The behaviour is as follows: Assume the initial input to be false. In this
case, the output will be <i>offset</i>. After a rising edge (i.e., the input
changes from false to true), the output is rising during <i>rising</i> to the
sum of <i>offset</i> and <i>amplitude</i>. In contrast, after a falling
edge (i.e., the input changes from true to false), the output is falling
during <i>falling</i> to a value of <i>offset</i>.
</p>
<p>Note, that the case of edges before expiration of rising or falling is
handled properly.</p>
</html>"));
      end TriggeredTrapezoid;

      block Timer "Timer measuring the time from the time instant where the Boolean input became true"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      protected
        discrete Modelica.SIunits.Time entryTime "Time instant when u became true";
      initial equation
        pre(entryTime) = 0;
      equation
        when u then
          entryTime = time;
        end when;
        y = if u then time - entryTime else 0.0;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Line(visible = true, points = {{-90.0, -70.0}, {82.0, -70.0}}, color = {192, 192, 192}), Line(visible = true, points = {{-80.0, 68.0}, {-80.0, -80.0}}, color = {192, 192, 192}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{90.0, -70.0}, {68.0, -62.0}, {68.0, -78.0}, {90.0, -70.0}}), Polygon(visible = true, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid, points = {{-80.0, 90.0}, {-88.0, 68.0}, {-72.0, 68.0}, {-80.0, 90.0}}), Line(visible = true, points = {{-80.0, -70.0}, {-60.0, -70.0}, {-60.0, -26.0}, {38.0, -26.0}, {38.0, -70.0}, {66.0, -70.0}}, color = {255, 0, 255}), Line(visible = true, points = {{-80.0, 0.0}, {-62.0, 0.0}, {40.0, 90.0}, {40.0, 0.0}, {68.0, 0.0}}, color = {0, 0, 127})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-90, -70}, {82, -70}}, color = {0, 0, 0}), Line(points = {{-80, 68}, {-80, -80}}, color = {0, 0, 0}), Polygon(points = {{90, -70}, {68, -62}, {68, -78}, {90, -70}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-80, -68}, {-60, -68}, {-60, -40}, {20, -40}, {20, -68}, {60, -68}}, color = {255, 0, 255}), Line(points = {{-80, -20}, {-60, -20}, {20, 60}, {20, -20}, {60, -20}, {60, -20}}, color = {0, 0, 255}), Text(extent = {{-88, 6}, {-54, -4}}, lineColor = {0, 0, 0}, textString = "y"), Text(extent = {{48, -80}, {84, -88}}, lineColor = {0, 0, 0}, textString = "time"), Text(extent = {{-88, -36}, {-54, -46}}, lineColor = {0, 0, 0}, textString = "u")}),
          Documentation(info = "<HTML>
<p> When the Boolean input \"u\" becomes <b>true</b>, the timer is started
and the output \"y\" is the time from the time instant where u became true.
The timer is stopped and the output is reset to zero, once the
input becomes false.
</p>
</html>"));
      end Timer;

      block RSFlipFlop "A basic RS Flip Flop"
        extends Modelica.Blocks.Icons.PartialBooleanBlock;
        parameter Boolean Qini = false "Start value of Q at initial time";
        Modelica.Blocks.Interfaces.BooleanOutput Q annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}}, rotation = 0)));
        Modelica.Blocks.Interfaces.BooleanOutput QI annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
        Modelica.Blocks.Logical.Nor nor annotation(
          Placement(transformation(extent = {{-20, 20}, {0, 40}}, rotation = 0)));
        Modelica.Blocks.Logical.Nor nor1 annotation(
          Placement(transformation(extent = {{-20, -20}, {0, 0}}, rotation = 0)));
        Modelica.Blocks.Logical.Pre pre(pre_u_start = not Qini) annotation(
          Placement(transformation(extent = {{10, 20}, {30, 40}}, rotation = 0)));
        Modelica.Blocks.Interfaces.BooleanInput S annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}})));
        Modelica.Blocks.Interfaces.BooleanInput R annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}})));
      equation
        connect(nor1.y, nor.u2) annotation(
          Line(points = {{1, -10}, {40, -10}, {40, -40}, {-60, -40}, {-60, 22}, {-22, 22}}, color = {255, 0, 255}));
        connect(nor1.y, Q) annotation(
          Line(points = {{1, -10}, {60, -10}, {60, 60}, {110, 60}}, color = {255, 0, 255}));
        connect(nor.y, pre.u) annotation(
          Line(points = {{1, 30}, {8, 30}}, color = {255, 0, 255}));
        connect(pre.y, nor1.u1) annotation(
          Line(points = {{31, 30}, {40, 30}, {40, 10}, {-40, 10}, {-40, -10}, {-22, -10}}, color = {255, 0, 255}));
        connect(pre.y, QI) annotation(
          Line(points = {{31, 30}, {80, 30}, {80, -60}, {110, -60}}, color = {255, 0, 255}));
        connect(S, nor.u1) annotation(
          Line(points = {{-120, 60}, {-40, 60}, {-40, 30}, {-22, 30}}, color = {255, 0, 255}, smooth = Smooth.None));
        connect(R, nor1.u2) annotation(
          Line(points = {{-120, -60}, {-40, -60}, {-40, -18}, {-22, -18}}, color = {255, 0, 255}, smooth = Smooth.None));
        annotation(
          Icon(graphics = {Text(extent = {{-60, -30}, {-20, -90}}, lineColor = {0, 0, 0}, textString = "R"), Text(extent = {{-62, 90}, {-22, 30}}, lineColor = {0, 0, 0}, textString = "S"), Text(extent = {{20, 90}, {60, 30}}, lineColor = {0, 0, 0}, textString = "Q"), Text(extent = {{6, -30}, {66, -90}}, lineColor = {0, 0, 0}, textString = "Q!"), Ellipse(extent = {{-73, 54}, {-87, 68}}, lineColor = DynamicSelect({235, 235, 235}, if S > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if S > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{83, -53}, {69, -67}}, lineColor = DynamicSelect({235, 235, 235}, if QI > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if QI > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{-71, -52}, {-85, -66}}, lineColor = DynamicSelect({235, 235, 235}, if R > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if R > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{71, 67}, {85, 53}}, lineColor = DynamicSelect({235, 235, 235}, if Q > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if Q > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
The output <code>Q</code> is set by the input <code>S</code> and reset by the input <code>R</code>, and keeps its value in between. <code>QI</code> is the inverse of <code>Q</code>.
</p>
</html>"));
      end RSFlipFlop;

      block TerminateSimulation "Terminate simulation if condition is fulfilled"
        Modelica.Blocks.Interfaces.BooleanOutput condition = false "Terminate simulation when condition becomes true" annotation(
          Dialog,
          Placement(transformation(extent = {{200, -10}, {220, 10}}, rotation = 0)));
        parameter String terminationText = "... End condition reached" "Text that will be displayed when simulation is terminated";
      equation
        when condition then
          terminate(terminationText);
        end when;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-200.0, -20.0}, {200.0, 20.0}}, initialScale = 0.2), graphics = {Rectangle(visible = true, fillColor = {235, 235, 235}, fillPattern = FillPattern.Solid, lineThickness = 5.0, borderPattern = BorderPattern.Raised, extent = {{-200.0, -20.0}, {200.0, 20.0}}), Text(visible = true, extent = {{-166.0, -15.0}, {194.0, 15.0}}, textString = "%condition"), Rectangle(visible = true, fillColor = {161, 35, 41}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised, extent = {{-194.0, -14.0}, {-168.0, 14.0}}), Text(visible = true, lineColor = {0, 0, 255}, extent = {{-200.0, 22.0}, {200.0, 46.0}}, textString = "%name")}),
          Documentation(info = "<html>
<p>
In the parameter menu, a <b>time varying</b> expression can be defined
via variable <b>condition</b>, for example \"condition = x &lt; 0\",
where \"x\" is a variable that is declared in the model in which the
\"TerminateSimulation\" block is present.
If this expression becomes <b>true</b>,
the simulation is (successfully) terminated. A termination message
explaining the reason for the termination can be given via
parameter \"terminationText\".
</p>

</html>"));
      end TerminateSimulation;
      annotation(
        Documentation(info = "<html>
<p>
This package provides blocks with Boolean input and output signals
to describe logical networks. A typical example for a logical
network built with package Logical is shown in the next figure:
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/LogicalNetwork1.png\"
     alt=\"LogicalNetwork1.png\">
</p>

<p>
The actual value of Boolean input and/or output signals is displayed
in the respective block icon as \"circle\", where \"white\" color means
value <b>false</b> and \"green\" color means value <b>true</b>. These
values are visualized in a diagram animation.
</p>
</html>"),
        Icon(graphics = {Line(visible = true, points = {{-86, -22}, {-50, -22}, {-50, 22}, {48, 22}, {48, -22}, {88, -24}}, color = {255, 0, 255})}));
    end Logical;

    package Math "Library of Real mathematical functions as input/output blocks"
      import Modelica.SIunits;
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Package;

      encapsulated package UnitConversions "Conversion blocks to convert between SI and non-SI unit signals"
        import Modelica;
        import SI = Modelica.SIunits;
        import NonSI = Modelica.SIunits.Conversions.NonSIunits;
        extends Modelica.Icons.Package;

        block To_degC "Convert from Kelvin to degCelsius"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "K"), y(unit = "degC"));
        equation
          y = SI.Conversions.to_degC(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "K"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "degC")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from Kelvin to degCelsius and returns
the result as output signal.
</p>
</html>"));
        end To_degC;

        block From_degC "Convert from degCelsius to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "degC"), y(unit = "K"));
        equation
          y = SI.Conversions.from_degC(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "degC"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "K")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from degCelsius to Kelvin and returns
the result as output signal.
</p>
</html>"));
        end From_degC;

        block To_degF "Convert from Kelvin to degFahrenheit"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "K"), y(unit = "degF"));
        equation
          y = SI.Conversions.to_degF(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "K"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "degF")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from Kelvin to degFahrenheit and returns
the result as output signal.
</p>
</html>"));
        end To_degF;

        block From_degF "Convert from degFahrenheit to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "degF"), y(unit = "K"));
        equation
          y = SI.Conversions.from_degF(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "degF"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "K")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from degFahrenheit to Kelvin and returns
the result as output signal.
</p>
</html>"));
        end From_degF;

        block To_degRk "Convert from Kelvin to degRankine"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "K"), y(unit = "degRk"));
        equation
          y = SI.Conversions.to_degRk(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "K"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "degRk")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from Kelvin to degRankine and returns
the result as output signal.
</p>
</html>"));
        end To_degRk;

        block From_degRk "Convert from degRankine to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "degRk"), y(unit = "K"));
        equation
          y = SI.Conversions.from_degRk(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "degRk"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "K")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from degRankine to Kelvin and returns
the result as output signal.
</p>
</html>"));
        end From_degRk;

        block To_deg "Convert from radian to degree"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "rad"), y(unit = "deg"));
        equation
          y = SI.Conversions.to_deg(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "rad"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "deg")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from radian to degree and returns
the result as output signal.
</p>
</html>"));
        end To_deg;

        block From_deg "Convert from degree to radian"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "deg"), y(unit = "rad"));
        equation
          y = SI.Conversions.from_deg(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "deg"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "rad")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from degree to radian and returns
the result as output signal.
</p>
</html>"));
        end From_deg;

        block To_rpm "Convert from radian per second to revolutions per minute"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "rad/s"), y(unit = "1/min"));
        equation
          y = SI.Conversions.to_rpm(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{26, 82}, {-98, 50}}, lineColor = {0, 0, 0}, textString = "rad/s"), Text(extent = {{100, -42}, {-62, -74}}, lineColor = {0, 0, 0}, textString = "1/min")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from radian per second to revolutions per minute and returns
the result as output signal.
</p>
</html>"));
        end To_rpm;

        block From_rpm "Convert from revolutions per minute to radian per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "1/min"), y(unit = "rad/s"));
        equation
          y = SI.Conversions.from_rpm(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{50, 84}, {-94, 56}}, lineColor = {0, 0, 0}, textString = "1/min"), Text(extent = {{94, -42}, {-26, -74}}, lineColor = {0, 0, 0}, textString = "rad/s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from revolutions per minute to radian per second and returns
the result as output signal.
</p>
</html>"));
        end From_rpm;

        block To_kmh "Convert from metre per second to kilometre per hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "m/s"), y(unit = "km/h"));
        equation
          y = SI.Conversions.to_kmh(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{0, 82}, {-96, 42}}, lineColor = {0, 0, 0}, textString = "m/s"), Text(extent = {{92, -40}, {-14, -84}}, lineColor = {0, 0, 0}, textString = "km/h")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from metre per second to kilometre per hour and returns
the result as output signal.
</p>
</html>"));
        end To_kmh;

        block From_kmh "Convert from kilometre per hour to metre per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "km/h"), y(unit = "m/s"));
        equation
          y = SI.Conversions.from_kmh(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{26, 80}, {-96, 48}}, lineColor = {0, 0, 0}, textString = "km/h"), Text(extent = {{92, -46}, {-20, -82}}, lineColor = {0, 0, 0}, textString = "m/s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from kilometre per hour to metre per second and returns
the result as output signal.
</p>
</html>"));
        end From_kmh;

        block To_day "Convert from second to day"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "s"), y(unit = "d"));
        equation
          y = SI.Conversions.to_day(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "s"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "day")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from second to day and returns
the result as output signal.
</p>
</html>"));
        end To_day;

        block From_day "Convert from day to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "d"), y(unit = "s"));
        equation
          y = SI.Conversions.from_day(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "day"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from day to second and returns
the result as output signal.
</p>
</html>"));
        end From_day;

        block To_hour "Convert from second to hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "s"), y(unit = "h"));
        equation
          y = SI.Conversions.to_hour(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "s"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "hour")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from second to hour and returns
the result as output signal.
</p>
</html>"));
        end To_hour;

        block From_hour "Convert from hour to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "h"), y(unit = "s"));
        equation
          y = SI.Conversions.from_hour(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "hour"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from hour to second and returns
the result as output signal.
</p>
</html>"));
        end From_hour;

        block To_minute "Convert from second to minute"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "s"), y(unit = "min"));
        equation
          y = SI.Conversions.to_minute(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "s"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "minute")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from second to minute and returns
the result as output signal.
</p>
</html>"));
        end To_minute;

        block From_minute "Convert from minute to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "min"), y(unit = "s"));
        equation
          y = SI.Conversions.from_minute(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "minute"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from minute to second and returns
the result as output signal.
</p>
</html>"));
        end From_minute;

        block To_litre "Convert from cubic metre to litre"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "m3"), y(unit = "l"));
        equation
          y = SI.Conversions.to_litre(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "m3"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "litre")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from metre to litre and returns
the result as output signal.
</p>
</html>"));
        end To_litre;

        block From_litre "Convert from litre to cubic metre"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "l"), y(unit = "m3"));
        equation
          y = SI.Conversions.from_litre(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "litre"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "m3")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from litre to cubic metre and returns
the result as output signal.
</p>
</html>"));
        end From_litre;

        block To_kWh "Convert from Joule to kilo Watt hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "J"), y(unit = "kW.h"));
        equation
          y = SI.Conversions.to_kWh(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "J"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "kW.h")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from Joule to kilo Watt hour and returns
the result as output signal.
</p>
</html>"));
        end To_kWh;

        block From_kWh "Convert from kilo Watt hour to Joule"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "kW.h"), y(unit = "J"));
        equation
          y = SI.Conversions.from_kWh(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "kW.h"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "J")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from kilo Watt hour to Joule and returns
the result as output signal.
</p>
</html>"));
        end From_kWh;

        block To_bar "Convert from Pascal to bar"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "Pa"), y(unit = "bar"));
        equation
          y = SI.Conversions.to_bar(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "Pa"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "bar")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from Pascal to bar and returns
the result as output signal.
</p>
</html>"));
        end To_bar;

        block From_bar "Convert from bar to Pascal"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "bar"), y(unit = "Pa"));
        equation
          y = SI.Conversions.from_bar(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "bar"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "Pa")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from bar to Pascal and returns
the result as output signal.
</p>
</html>"));
        end From_bar;

        block To_gps "Convert from kilogram per second to gram per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "kg/s"), y(unit = "g/s"));
        equation
          y = SI.Conversions.to_gps(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "kg/s"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "g/s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from kilogram per second to gram per seconds and returns
the result as output signal.
</p>
</html>"));
        end To_gps;

        block From_gps "Convert from gram per second to kilogram per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit = "g/s"), y(unit = "kg/s"));
        equation
          y = SI.Conversions.from_gps(u);
          annotation(
            Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-20, 100}, {-100, 20}}, lineColor = {0, 0, 0}, textString = "g/s"), Text(extent = {{100, -20}, {20, -100}}, lineColor = {0, 0, 0}, textString = "kg/s")}),
            Documentation(info = "<html>
<p>
This block converts the input signal from gram per second to kilogram per second and returns
the result as output signal.
</p>
</html>"));
        end From_gps;
        annotation(
          Documentation(info = "<html>
<p>
This package consists of blocks that convert an input signal
with a specific unit to an output signal in another unit
(e.g., conversion of an angle signal from \"deg\" to \"rad\").
</p>

</html>"));
      end UnitConversions;

      block InverseBlockConstraints "Construct inverse model by requiring that two inputs and two outputs are identical (replaces the previously, unbalanced, TwoInputs and TwoOutputs blocks)"
        Modelica.Blocks.Interfaces.RealInput u1 "Input signal 1 (u1 = u2)" annotation(
          Placement(transformation(extent = {{-240, -20}, {-200, 20}}, rotation = 0), iconTransformation(extent = {{-240, -20}, {-200, 20}})));
        Modelica.Blocks.Interfaces.RealInput u2 "Input signal 2 (u1 = u2)" annotation(
          Placement(transformation(extent = {{-140, -20}, {-180, 20}}, rotation = 0), iconTransformation(extent = {{-140, -20}, {-180, 20}})));
        Modelica.Blocks.Interfaces.RealOutput y1 "Output signal 1 (y1 = y2)" annotation(
          Placement(transformation(extent = {{200, -10}, {220, 10}}, rotation = 0), iconTransformation(extent = {{200, -10}, {220, 10}})));
        Modelica.Blocks.Interfaces.RealOutput y2 "Output signal 2 (y2 = y2)" annotation(
          Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = 0, origin = {170, 0}), iconTransformation(extent = {{180, -10}, {160, 10}})));
      equation
        u1 = u2;
        y1 = y2;
        annotation(
          __Dymola_structurallyIncomplete = true,
          defaultConnectionStructurallyInconsistent = true,
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-200, -120}, {200, 120}}), graphics = {Line(points = {{180, 0}, {200, 0}}, color = {0, 0, 127}, smooth = Smooth.None), Line(points = {{-200, 0}, {-180, 0}}, color = {0, 0, 127}, smooth = Smooth.None), Rectangle(extent = {{-190, 120}, {190, -120}}, lineColor = {135, 135, 135})}),
          Documentation(info = "<html>
<p>
Exchange input and output signals of a block, i.e., the previous
block inputs become block outputs and the previous block outputs become
block inputs. This block is used to construct inverse models.
Its usage is demonstrated in example:
<a href=\"modelica://Modelica.Blocks.Examples.InverseModel\">Modelica.Blocks.Examples.InverseModel</a>.
</p>

<p>
Note, if a block shall be inverted that has several input and output blocks,
then this can be easily achieved by using a vector of InverseBlockConstraints
instances:
</p>

<pre>
   InverseBlockConstraint invert[3];  // Block to be inverted has 3 input signals
</pre>
</html>"));
      end InverseBlockConstraints;

      block Gain "Output the product of a gain value with the input signal"
        parameter Real k(start = 1, unit = "1") "Gain value multiplied with input signal";
      public
        Interfaces.RealInput u "Input signal connector" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Interfaces.RealOutput y "Output signal connector" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = k * u;
        annotation(
          Documentation(info = "<html>
<p>
This block computes output <i>y</i> as
<i>product</i> of gain <i>k</i> with the
input <i>u</i>:
</p>
<pre>
    y = k * u;
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, -100}, {-100, 100}, {100, 0}, {-100, -100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-150, -140}, {150, -100}}, lineColor = {0, 0, 0}, textString = "k=%k"), Text(extent = {{-150, 140}, {150, 100}}, textString = "%name", lineColor = {0, 0, 255})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-100, -100}, {-100, 100}, {100, 0}, {-100, -100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-76, 38}, {0, -34}}, textString = "k", lineColor = {0, 0, 255})}));
      end Gain;

      block MatrixGain "Output the product of a gain matrix with the input signal vector"
        parameter Real K[:, :] = [1, 0; 0, 1] "Gain matrix which is multiplied with the input";
        extends Interfaces.MIMO(final nin = size(K, 2), final nout = size(K, 1));
      equation
        y = K * u;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes output vector <b>y</b> as <i>product</i> of the
gain matrix <b>K</b> with the input signal vector <b>u</b>:
</p>
<pre>
    <b>y</b> = <b>K</b> * <b>u</b>;
</pre>
<p>
Example:
</p>
<pre>
   parameter: <b>K</b> = [0.12 2; 3 1.5]

   results in the following equations:

     | y[1] |     | 0.12  2.00 |   | u[1] |
     |      |  =  |            | * |      |
     | y[2] |     | 3.00  1.50 |   | u[2] |
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, -60}, {90, 60}}, lineColor = {160, 160, 164}, textString = "*K"), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-90, -60}, {90, 60}}, lineColor = {160, 160, 164}, textString = "*K")}));
      end MatrixGain;

      block MultiSum "Sum of Reals: y = k[1]*u[1] + k[2]*u[2] + ... + k[n]*u[n]"
        extends Modelica.Blocks.Interfaces.PartialRealMISO;
        parameter Real k[nu] = fill(1, nu) "Input gains";
      equation
        if size(u, 1) > 0 then
          y = k * u;
        else
          y = 0;
        end if;
        annotation(
          Icon(graphics = {Text(extent = {{-200, -110}, {200, -140}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "%k"), Text(extent = {{-72, 68}, {92, -68}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "+")}),
          Documentation(info = "<html>
<p>
This blocks computes the scalar Real output \"y\" as sum of the elements of the
Real input signal vector u:
</p>
<blockquote><pre>
y = k[1]*u[1] + k[2]*u[2] + ... k[N]*u[N];
</pre></blockquote>

<p>
The input connector is a vector of Real input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.RealNetwork1\">Modelica.Blocks.Examples.RealNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to zero: y=0.
</p>

</html>"));
      end MultiSum;

      block MultiProduct "Product of Reals: y = u[1]*u[2]* ... *u[n]"
        extends Modelica.Blocks.Interfaces.PartialRealMISO;
      equation
        if size(u, 1) > 0 then
          y = product(u);
        else
          y = 0;
        end if;
        annotation(
          Icon(graphics = {Text(extent = {{-74, 50}, {94, -94}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "*")}),
          Documentation(info = "<html>
<p>
This blocks computes the scalar Real output \"y\" as product of the elements of the
Real input signal vector u:
</p>
<blockquote><pre>
y = u[1]*u[2]* ... *u[N];
</pre></blockquote>

<p>
The input connector is a vector of Real input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.RealNetwork1\">Modelica.Blocks.Examples.RealNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to zero: y=0.
</p>
</html>"));
      end MultiProduct;

      block MultiSwitch "Set Real expression that is associated with the first active input signal"
        input Real expr[nu] = fill(0.0, nu) "y = if u[i] then expr[i] else y_default (time varying)" annotation(
          Dialog);
        parameter Real y_default = 0.0 "Default value of output y if all u[i] = false";
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        parameter Integer precision(min = 0) = 3 "Number of significant digits to be shown in dynamic diagram layer for y" annotation(
          Dialog(tab = "Advanced"));
        Modelica.Blocks.Interfaces.BooleanVectorInput u[nu] "Set y = expr[i], if u[i] = true" annotation(
          Placement(transformation(extent = {{-110, 30}, {-90, -30}})));
        Modelica.Blocks.Interfaces.RealOutput y "Output depending on expression" annotation(
          Placement(transformation(extent = {{300, -10}, {320, 10}})));
      protected
        Integer firstActiveIndex;
      initial equation
        pre(u) = fill(false, nu);
      equation
        firstActiveIndex = Modelica.Math.BooleanVectors.firstTrueIndex(u);
        y = if firstActiveIndex == 0 then y_default else expr[firstActiveIndex];
        annotation(
          defaultComponentName = "multiSwitch1",
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {300, 100}}), graphics = {Rectangle(extent = {{-100, -51}, {300, 50}}, lineThickness = 5.0, lineColor = {0, 0, 0}, fillColor = {170, 213, 255}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-86, 16}, {295, -17}}, lineColor = {0, 0, 0}, fillColor = {255, 246, 238}, fillPattern = FillPattern.Solid, textString = "%expr"), Text(extent = {{310, -25}, {410, -45}}, lineColor = {0, 0, 0}, textString = DynamicSelect(" ", String(y, minimumLength = 1, significantDigits = precision))), Text(extent = {{-100, -60}, {300, -90}}, lineColor = {0, 0, 0}, textString = "else: %y_default"), Text(extent = {{-100, 100}, {300, 60}}, textString = "%name", lineColor = {0, 0, 255})}),
          Documentation(info = "<html>
<p>
This block has a vector of Boolean input signals u[nu] and a vector of
(time varying) Real expressions expr[nu]. The output signal y is
set to expr[i], if i is the first element in the input vector u that is true. If all input signals are
false, y is set to parameter \"y_default\".
</p>

<blockquote><pre>
  // Conceptual equation (not valid Modelica)
  i = 'first element of u[:] that is true';
  y = <b>if</b> i==0 <b>then</b> y_default <b>else</b> expr[i];
</pre></blockquote>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.RealNetwork1\">Modelica.Blocks.Examples.RealNetwork1</a>.
</p>

</html>"));
      end MultiSwitch;

      block Sum "Output the sum of the elements of the input vector"
        extends Interfaces.MISO;
        parameter Real k[nin] = ones(nin) "Optional: sum coefficients";
      equation
        y = k * u;
        annotation(
          defaultComponentName = "sum1",
          Documentation(info = "<html>
<p>
This blocks computes output <b>y</b> as
<i>sum</i> of the elements of the input signal vector
<b>u</b>:
</p>
<pre>
    <b>y</b> = <b>u</b>[1] + <b>u</b>[2] + ...;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   nin = 3;

  results in the following equations:

     y = u[1] + u[2] + u[3];
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{26, 42}, {-34, 42}, {6, 2}, {-34, -38}, {26, -38}}, color = {0, 0, 0}, thickness = 0.25), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{26, 42}, {-34, 42}, {6, 2}, {-34, -38}, {26, -38}}, color = {0, 0, 0}, thickness = 0.25)}));
      end Sum;

      block Feedback "Output difference between commanded and feedback input"
        Interfaces.RealInput u1 annotation(
          Placement(transformation(extent = {{-100, -20}, {-60, 20}}, rotation = 0)));
        Interfaces.RealInput u2 annotation(
          Placement(transformation(origin = {0, -80}, extent = {{-20, -20}, {20, 20}}, rotation = 90)));
        Interfaces.RealOutput y annotation(
          Placement(transformation(extent = {{80, -10}, {100, 10}}, rotation = 0)));
      equation
        y = u1 - u2;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes output <b>y</b> as <i>difference</i> of the
commanded input <b>u1</b> and the feedback
input <b>u2</b>:
</p>
<pre>
    <b>y</b> = <b>u1</b> - <b>u2</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   n = 2

  results in the following equations:

     y = u1 - u2
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Ellipse(lineColor = {0, 0, 127}, fillColor = {235, 235, 235}, fillPattern = FillPattern.Solid, extent = {{-20, -20}, {20, 20}}), Line(points = {{-60, 0}, {-20, 0}}, color = {0, 0, 127}), Line(points = {{20, 0}, {80, 0}}, color = {0, 0, 127}), Line(points = {{0, -20}, {0, -60}}, color = {0, 0, 127}), Text(extent = {{-14, -94}, {82, 0}}, textString = "-"), Text(lineColor = {0, 0, 255}, extent = {{-150, 44}, {150, 94}}, textString = "%name")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-20, 20}, {20, -20}}, pattern = LinePattern.Solid, lineThickness = 0.25, fillColor = {235, 235, 235}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 255}), Line(points = {{-60, 0}, {-20, 0}}, color = {0, 0, 255}), Line(points = {{20, 0}, {80, 0}}, color = {0, 0, 255}), Line(points = {{0, -20}, {0, -60}}, color = {0, 0, 255}), Text(extent = {{-12, 10}, {84, -84}}, lineColor = {0, 0, 0}, textString = "-")}));
      end Feedback;

      block Add "Output the sum of the two inputs"
        extends Interfaces.SI2SO;
        parameter Real k1 = +1 "Gain of upper input";
        parameter Real k2 = +1 "Gain of lower input";
      equation
        y = k1 * u1 + k2 * u2;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes output <b>y</b> as <i>sum</i> of the
two input signals <b>u1</b> and <b>u2</b>:
</p>
<pre>
    <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   k1= +2, k2= -3

  results in the following equations:

     y = 2 * u1 - 3 * u2
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Text(lineColor = {0, 0, 255}, extent = {{-150, 110}, {150, 150}}, textString = "%name"), Line(points = {{-100, 60}, {-74, 24}, {-44, 24}}, color = {0, 0, 127}), Line(points = {{-100, -60}, {-74, -28}, {-42, -28}}, color = {0, 0, 127}), Ellipse(lineColor = {0, 0, 127}, extent = {{-50, -50}, {50, 50}}), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 127}), Text(extent = {{-38, -34}, {38, 34}}, textString = "+"), Text(extent = {{-100, 52}, {5, 92}}, textString = "%k1"), Text(extent = {{-100, -92}, {5, -52}}, textString = "%k2")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-100, 60}, {-74, 24}, {-44, 24}}, color = {0, 0, 127}), Line(points = {{-100, -60}, {-74, -28}, {-42, -28}}, color = {0, 0, 127}), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {0, 0, 127}), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 127}), Text(extent = {{-36, 38}, {40, -30}}, lineColor = {0, 0, 0}, textString = "+"), Text(extent = {{-100, 52}, {5, 92}}, lineColor = {0, 0, 0}, textString = "k1"), Text(extent = {{-100, -52}, {5, -92}}, lineColor = {0, 0, 0}, textString = "k2")}));
      end Add;

      block Add3 "Output the sum of the three inputs"
        extends Modelica.Blocks.Icons.Block;
        parameter Real k1 = +1 "Gain of upper input";
        parameter Real k2 = +1 "Gain of middle input";
        parameter Real k3 = +1 "Gain of lower input";
        Interfaces.RealInput u1 "Connector 1 of Real input signals" annotation(
          Placement(transformation(extent = {{-140, 60}, {-100, 100}}, rotation = 0)));
        Interfaces.RealInput u2 "Connector 2 of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Interfaces.RealInput u3 "Connector 3 of Real input signals" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
        Interfaces.RealOutput y "Connector of Real output signals" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = k1 * u1 + k2 * u2 + k3 * u3;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes output <b>y</b> as <i>sum</i> of the
three input signals <b>u1</b>, <b>u2</b> and <b>u3</b>:
</p>
<pre>
    <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b> + k3*<b>u3</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   k1= +2, k2= -3, k3=1;

  results in the following equations:

     y = 2 * u1 - 3 * u2 + u3;
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-100, 50}, {5, 90}}, lineColor = {0, 0, 0}, textString = "%k1"), Text(extent = {{-100, -20}, {5, 20}}, lineColor = {0, 0, 0}, textString = "%k2"), Text(extent = {{-100, -50}, {5, -90}}, lineColor = {0, 0, 0}, textString = "%k3"), Text(extent = {{2, 36}, {100, -44}}, lineColor = {0, 0, 0}, textString = "+")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-100, 50}, {5, 90}}, lineColor = {0, 0, 0}, textString = "k1"), Text(extent = {{-100, -20}, {5, 20}}, lineColor = {0, 0, 0}, textString = "k2"), Text(extent = {{-100, -50}, {5, -90}}, lineColor = {0, 0, 0}, textString = "k3"), Text(extent = {{2, 46}, {100, -34}}, lineColor = {0, 0, 0}, textString = "+")}));
      end Add3;

      block Product "Output product of the two inputs"
        extends Interfaces.SI2SO;
      equation
        y = u1 * u2;
        annotation(
          Documentation(info = "<html>
<p>
This blocks computes the output <b>y</b> (element-wise)
as <i>product</i> of the corresponding elements of
the two inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>
    y = u1 * u2;
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Line(points = {{-100, 60}, {-40, 60}, {-30, 40}}, color = {0, 0, 127}), Line(points = {{-100, -60}, {-40, -60}, {-30, -40}}, color = {0, 0, 127}), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 127}), Line(points = {{-30, 0}, {30, 0}}), Line(points = {{-15, 25.99}, {15, -25.99}}), Line(points = {{-15, -25.99}, {15, 25.99}}), Ellipse(lineColor = {0, 0, 127}, extent = {{-50, -50}, {50, 50}})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-100, 60}, {-40, 60}, {-30, 40}}, color = {0, 0, 255}), Line(points = {{-100, -60}, {-40, -60}, {-30, -40}}, color = {0, 0, 255}), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-30, 0}, {30, 0}}, color = {0, 0, 0}), Line(points = {{-15, 25.99}, {15, -25.99}}, color = {0, 0, 0}), Line(points = {{-15, -25.99}, {15, 25.99}}, color = {0, 0, 0}), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {0, 0, 255})}));
      end Product;

      block Division "Output first input divided by second input"
        extends Interfaces.SI2SO;
      equation
        y = u1 / u2;
        annotation(
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b> (element-wise)
by <i>dividing</i> the corresponding elements of
the two inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>
    y = u1 / u2;
</pre>

</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 127}), Line(points = {{-30, 0}, {30, 0}}), Ellipse(fillPattern = FillPattern.Solid, extent = {{-5, 20}, {5, 30}}), Ellipse(fillPattern = FillPattern.Solid, extent = {{-5, -30}, {5, -20}}), Ellipse(lineColor = {0, 0, 127}, extent = {{-50, -50}, {50, 50}}), Text(lineColor = {0, 0, 255}, extent = {{-150, 110}, {150, 150}}, textString = "%name"), Line(points = {{-100, 60}, {-66, 60}, {-40, 30}}, color = {0, 0, 127}), Line(points = {{-100, -60}, {0, -60}, {0, -50}}, color = {0, 0, 127})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{50, 0}, {100, 0}}, color = {0, 0, 255}), Line(points = {{-30, 0}, {30, 0}}, color = {0, 0, 0}), Ellipse(extent = {{-5, 20}, {5, 30}}, lineColor = {0, 0, 0}, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid), Ellipse(extent = {{-5, -20}, {5, -30}}, lineColor = {0, 0, 0}, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid), Ellipse(extent = {{-50, 50}, {50, -50}}, lineColor = {0, 0, 255}), Line(points = {{-100, 60}, {-66, 60}, {-40, 30}}, color = {0, 0, 255}), Line(points = {{-100, -60}, {0, -60}, {0, -50}}, color = {0, 0, 255})}));
      end Division;

      block Abs "Output the absolute value of the input"
        extends Interfaces.SISO;
        parameter Boolean generateEvent = false "Choose whether events shall be generated" annotation(
          Evaluate = true);
      equation
//y = abs(u);
        y = if generateEvent then if u >= 0 then u else -u else if noEvent(u >= 0) then u else -u;
        annotation(
          defaultComponentName = "abs1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{92, 0}, {70, 8}, {70, -8}, {92, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {0, 0}, {80, 80}}, color = {0, 0, 0}), Line(points = {{0, -14}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-34, -28}, {38, -76}}, lineColor = {192, 192, 192}, textString = "abs"), Line(points = {{-88, 0}, {76, 0}}, color = {192, 192, 192})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-100, 0}, {76, 0}}, color = {192, 192, 192}), Polygon(points = {{92, 0}, {76, 6}, {76, -6}, {92, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {0, 0}, {80, 80}}, color = {0, 0, 0}), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{7, 98}, {34, 78}}, lineColor = {160, 160, 164}, textString = "u"), Text(extent = {{74, -8}, {96, -28}}, lineColor = {160, 160, 164}, textString = "y"), Text(extent = {{52, -3}, {72, -23}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{-86, -1}, {-66, -21}}, textString = "-1", lineColor = {0, 0, 255}), Text(extent = {{-28, 79}, {-8, 59}}, textString = "1", lineColor = {0, 0, 255})}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <i>absolute value</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>abs</b>( u );
</pre>
<p>
The Boolean parameter generateEvent decides whether Events are generated at zero crossing (Modelica specification before 3) or not.
</p>
</html>"));
      end Abs;

      block Sign "Output the sign of the input"
        extends Interfaces.SISO;
        parameter Boolean generateEvent = false "Choose whether events shall be generated" annotation(
          Evaluate = true);
      equation
//y = sign(u);
        y = if generateEvent then if u > 0 then 1 elseif u < 0 then -1 else 0 else if noEvent(u > 0) then 1 elseif noEvent(u < 0) then -1 else 0;
        annotation(
          defaultComponentName = "sign1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {0, -80}}, color = {0, 0, 0}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Text(extent = {{-90, 72}, {-18, 24}}, lineColor = {192, 192, 192}, textString = "sign"), Line(points = {{0, 80}, {80, 80}}, color = {0, 0, 0}), Rectangle(extent = {{-2, 2}, {2, -4}}, lineColor = {0, 0, 0}, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {0, -80}}, color = {0, 0, 0}), Line(points = {{-0.01, 0}, {0.01, 0}}, color = {0, 0, 0}), Line(points = {{0, 80}, {80, 80}}, color = {0, 0, 0}), Rectangle(extent = {{-2, 2}, {2, -4}}, lineColor = {0, 0, 0}, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{7, 102}, {32, 82}}, lineColor = {160, 160, 164}, textString = "y"), Text(extent = {{70, -6}, {94, -26}}, lineColor = {160, 160, 164}, textString = "u"), Text(extent = {{-25, 86}, {-5, 70}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{5, -72}, {25, -88}}, textString = "-1", lineColor = {0, 0, 255})}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>sign</b> of the input <b>u</b>:
</p>
<pre>
         1  <b>if</b> u &gt; 0
    y =  0  <b>if</b> u == 0
        -1  <b>if</b> u &lt; 0
</pre>
<p>
The Boolean parameter generateEvent decides whether Events are generated at zero crossing (Modelica specification before 3) or not.
</p>
</html>"));
      end Sign;

      block Sqrt "Output the square root of the input (input >= 0 required)"
        extends Interfaces.SISO;
      equation
        y = sqrt(u);
        annotation(
          defaultComponentName = "sqrt1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-90, -80}, {68, -80}}, color = {192, 192, 192}), Polygon(points = {{90, -80}, {68, -72}, {68, -88}, {90, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-79.2, -68.7}, {-78.4, -64}, {-76.8, -57.3}, {-73.6, -47.9}, {-67.9, -36.1}, {-59.1, -22.2}, {-46.2, -6.49}, {-28.5, 10.7}, {-4.42, 30}, {27.7, 51.3}, {69.5, 74.7}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -88}, {-80, 68}}, color = {192, 192, 192}), Text(extent = {{-8, -4}, {64, -52}}, lineColor = {192, 192, 192}, textString = "sqrt")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-92, -80}, {84, -80}}, color = {192, 192, 192}), Polygon(points = {{100, -80}, {84, -74}, {84, -86}, {100, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-79.2, -68.7}, {-78.4, -64}, {-76.8, -57.3}, {-73.6, -47.9}, {-67.9, -36.1}, {-59.1, -22.2}, {-46.2, -6.49}, {-28.5, 10.7}, {-4.42, 30}, {27.7, 51.3}, {69.5, 74.7}, {80, 80}}, color = {0, 0, 0}), Polygon(points = {{-80, 98}, {-86, 82}, {-74, 82}, {-80, 98}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -90}, {-80, 84}}, color = {192, 192, 192}), Text(extent = {{-71, 98}, {-44, 78}}, lineColor = {160, 160, 164}, textString = "y"), Text(extent = {{60, -52}, {84, -72}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <i>square root</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>sqrt</b>( u );
</pre>
<p>
All elements of the input vector shall be zero or positive.
Otherwise an error occurs.
</p>

</html>"));
      end Sqrt;

      block Sin "Output the sine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.sin(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-80, 68}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Line(points = {{-80, 0}, {-68.7, 34.2}, {-61.5, 53.1}, {-55.1, 66.4}, {-49.4, 74.6}, {-43.8, 79.1}, {-38.2, 79.8}, {-32.6, 76.6}, {-26.9, 69.7}, {-21.3, 59.4}, {-14.9, 44.1}, {-6.83, 21.2}, {10.1, -30.8}, {17.3, -50.2}, {23.7, -64.2}, {29.3, -73.1}, {35, -78.4}, {40.6, -80}, {46.2, -77.6}, {51.9, -71.5}, {57.5, -61.9}, {63.9, -47.2}, {72, -24.8}, {80, 0}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{12, 84}, {84, 36}}, lineColor = {192, 192, 192}, textString = "sin")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -90}, {-80, 84}}, color = {192, 192, 192}), Text(extent = {{-75, 98}, {-46, 78}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{-80, 96}, {-86, 80}, {-74, 80}, {-80, 96}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 0}, {-68.7, 34.2}, {-61.5, 53.1}, {-55.1, 66.4}, {-49.4, 74.6}, {-43.8, 79.1}, {-38.2, 79.8}, {-32.6, 76.6}, {-26.9, 69.7}, {-21.3, 59.4}, {-14.9, 44.1}, {-6.83, 21.2}, {10.1, -30.8}, {17.3, -50.2}, {23.7, -64.2}, {29.3, -73.1}, {35, -78.4}, {40.6, -80}, {46.2, -77.6}, {51.9, -71.5}, {57.5, -61.9}, {63.9, -47.2}, {72, -24.8}, {80, 0}}, color = {0, 0, 0}), Text(extent = {{-105, 72}, {-85, 88}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{70, 25}, {90, 5}}, textString = "2*pi", lineColor = {0, 0, 255}), Text(extent = {{-105, -72}, {-85, -88}}, textString = "-1", lineColor = {0, 0, 255}), Text(extent = {{76, -10}, {98, -30}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>sine</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>sin</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/sin.png\"
     alt=\"sin.png\">
</p>

</html>"));
      end Sin;

      block Cos "Output the cosine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.cos(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-80, 68}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {-74.4, 78.1}, {-68.7, 72.3}, {-63.1, 63}, {-56.7, 48.7}, {-48.6, 26.6}, {-29.3, -32.5}, {-22.1, -51.7}, {-15.7, -65.3}, {-10.1, -73.8}, {-4.42, -78.8}, {1.21, -79.9}, {6.83, -77.1}, {12.5, -70.6}, {18.1, -60.6}, {24.5, -45.7}, {32.6, -23}, {50.3, 31.3}, {57.5, 50.7}, {63.9, 64.6}, {69.5, 73.4}, {75.2, 78.6}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{-36, 82}, {36, 34}}, lineColor = {192, 192, 192}, textString = "cos")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -90}, {-80, 84}}, color = {192, 192, 192}), Text(extent = {{-75, 102}, {-48, 82}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{-80, 100}, {-86, 84}, {-74, 84}, {-80, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-103, 72}, {-83, 88}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{-79, -72}, {-59, -88}}, textString = "-1", lineColor = {0, 0, 255}), Text(extent = {{70, 25}, {90, 5}}, textString = "2*pi", lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {-74.4, 78.1}, {-68.7, 72.3}, {-63.1, 63}, {-56.7, 48.7}, {-48.6, 26.6}, {-29.3, -32.5}, {-22.1, -51.7}, {-15.7, -65.3}, {-10.1, -73.8}, {-4.42, -78.8}, {1.21, -79.9}, {6.83, -77.1}, {12.5, -70.6}, {18.1, -60.6}, {24.5, -45.7}, {32.6, -23}, {50.3, 31.3}, {57.5, 50.7}, {63.9, 64.6}, {69.5, 73.4}, {75.2, 78.6}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{74, -4}, {98, -24}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>cos</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>cos</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/cos.png\"
     alt=\"cos.png\">
</p>

</html>"));
      end Cos;

      block Tan "Output the tangent of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.tan(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-78.4, -68.4}, {-76.8, -59.7}, {-74.4, -50}, {-71.2, -40.9}, {-67.1, -33}, {-60.7, -24.8}, {-51.1, -17.2}, {-35.8, -9.98}, {-4.42, -1.07}, {33.4, 9.12}, {49.4, 16.2}, {59.1, 23.2}, {65.5, 30.6}, {70.4, 39.1}, {73.6, 47.4}, {76, 56.1}, {77.6, 63.8}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-90, 72}, {-18, 24}}, lineColor = {192, 192, 192}, textString = "tan")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -88}, {0, 86}}, color = {192, 192, 192}), Text(extent = {{11, 100}, {38, 80}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 102}, {-6, 86}, {6, 86}, {0, 102}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-37, -72}, {-17, -88}}, textString = "-5.8", lineColor = {0, 0, 255}), Text(extent = {{-33, 86}, {-13, 70}}, textString = " 5.8", lineColor = {0, 0, 255}), Text(extent = {{70, 25}, {90, 5}}, textString = "1.4", lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-78.4, -68.4}, {-76.8, -59.7}, {-74.4, -50}, {-71.2, -40.9}, {-67.1, -33}, {-60.7, -24.8}, {-51.1, -17.2}, {-35.8, -9.98}, {-4.42, -1.07}, {33.4, 9.12}, {49.4, 16.2}, {59.1, 23.2}, {65.5, 30.6}, {70.4, 39.1}, {73.6, 47.4}, {76, 56.1}, {77.6, 63.8}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{70, -6}, {94, -26}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>tan</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>tan</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/tan.png\"
     alt=\"tan.png\">
</p>

</html>"));
      end Tan;

      block Asin "Output the arc sine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.asin(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-79.2, -72.8}, {-77.6, -67.5}, {-73.6, -59.4}, {-66.3, -49.8}, {-53.5, -37.3}, {-30.2, -19.7}, {37.4, 24.8}, {57.5, 40.8}, {68.7, 52.7}, {75.2, 62.2}, {77.6, 67.5}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-88, 78}, {-16, 30}}, lineColor = {192, 192, 192}, textString = "asin")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{9, 102}, {36, 82}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-40, -72}, {-15, -88}}, textString = "-pi/2", lineColor = {0, 0, 255}), Text(extent = {{-38, 88}, {-13, 72}}, textString = " pi/2", lineColor = {0, 0, 255}), Text(extent = {{70, 25}, {90, 5}}, textString = "+1", lineColor = {0, 0, 255}), Text(extent = {{-90, 21}, {-70, 1}}, textString = "-1", lineColor = {0, 0, 255}), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-79.2, -72.8}, {-77.6, -67.5}, {-73.6, -59.4}, {-66.3, -49.8}, {-53.5, -37.3}, {-30.2, -19.7}, {37.4, 24.8}, {57.5, 40.8}, {68.7, 52.7}, {75.2, 62.2}, {77.6, 67.5}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{74, -4}, {100, -26}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>sine-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>asin</b>( u );
</pre>
<p>
The absolute values of the elements of the input <b>u</b> need to
be less or equal to one (<b>abs</b>( u ) <= 1).
Otherwise an error occurs.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/asin.png\"
     alt=\"atan.png\">
</p>

</html>"));
      end Asin;

      block Acos "Output the arc cosine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.acos(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {-79.2, 72.8}, {-77.6, 67.5}, {-73.6, 59.4}, {-66.3, 49.8}, {-53.5, 37.3}, {-30.2, 19.7}, {37.4, -24.8}, {57.5, -40.8}, {68.7, -52.7}, {75.2, -62.2}, {77.6, -67.5}, {80, -80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{0, -88}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-90, -80}, {68, -80}}, color = {192, 192, 192}), Polygon(points = {{90, -80}, {68, -72}, {68, -88}, {90, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-86, -14}, {-14, -62}}, lineColor = {192, 192, 192}, textString = "acos")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{13, 100}, {42, 82}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, -80}, {84, -80}}, color = {192, 192, 192}), Polygon(points = {{100, -80}, {84, -74}, {84, -86}, {100, -80}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {-79.2, 72.8}, {-77.6, 67.5}, {-73.6, 59.4}, {-66.3, 49.8}, {-53.5, 37.3}, {-30.2, 19.7}, {37.4, -24.8}, {57.5, -40.8}, {68.7, -52.7}, {75.2, -62.2}, {77.6, -67.5}, {80, -80}}, color = {0, 0, 0}), Text(extent = {{-30, 88}, {-5, 72}}, textString = " pi", lineColor = {0, 0, 255}), Text(extent = {{-94, -57}, {-74, -77}}, textString = "-1", lineColor = {0, 0, 255}), Text(extent = {{80, -45}, {100, -65}}, textString = "+1", lineColor = {0, 0, 255}), Text(extent = {{76, -84}, {102, -102}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>cosine-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>acos</b>( u );
</pre>
<p>
The absolute values of the elements of the input <b>u</b> need to
be less or equal to one (<b>abs</b>( u ) <= 1).
Otherwise an error occurs.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/acos.png\"
     alt=\"acos.png\">
</p>

</html>"));
      end Acos;

      block Atan "Output the arc tangent of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.atan(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-52.7, -75.2}, {-37.4, -69.7}, {-26.9, -63}, {-19.7, -55.2}, {-14.1, -45.8}, {-10.1, -36.4}, {-6.03, -23.9}, {-1.21, -5.06}, {5.23, 21}, {9.25, 34.1}, {13.3, 44.2}, {18.1, 52.9}, {24.5, 60.8}, {33.4, 67.6}, {47, 73.6}, {69.5, 78.6}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-86, 68}, {-14, 20}}, lineColor = {192, 192, 192}, textString = "atan")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{13, 102}, {42, 82}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-52.7, -75.2}, {-37.4, -69.7}, {-26.9, -63}, {-19.7, -55.2}, {-14.1, -45.8}, {-10.1, -36.4}, {-6.03, -23.9}, {-1.21, -5.06}, {5.23, 21}, {9.25, 34.1}, {13.3, 44.2}, {18.1, 52.9}, {24.5, 60.8}, {33.4, 67.6}, {47, 73.6}, {69.5, 78.6}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{-32, 91}, {-12, 71}}, textString = "1.4", lineColor = {0, 0, 255}), Text(extent = {{-32, -71}, {-12, -91}}, textString = "-1.4", lineColor = {0, 0, 255}), Text(extent = {{73, 26}, {93, 10}}, textString = " 5.8", lineColor = {0, 0, 255}), Text(extent = {{-103, 20}, {-83, 4}}, textString = "-5.8", lineColor = {0, 0, 255}), Text(extent = {{66, -8}, {94, -28}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>tangent-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y= <b>atan</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/atan.png\"
     alt=\"atan.png\">
</p>

</html>"));
      end Atan;

      block Atan2 "Output atan(u1/u2) of the inputs u1 and u2"
        extends Interfaces.SI2SO;
      equation
        y = Modelica.Math.atan2(u1, u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -34.9}, {-46.1, -31.4}, {-29.4, -27.1}, {-18.3, -21.5}, {-10.3, -14.5}, {-2.03, -3.17}, {7.97, 11.6}, {15.5, 19.4}, {24.3, 25}, {39, 30}, {62.1, 33.5}, {80, 34.9}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-80, 45.1}, {-45.9, 48.7}, {-29.1, 52.9}, {-18.1, 58.6}, {-10.2, 65.8}, {-1.82, 77.2}, {0, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{0, -80}, {8.93, -67.2}, {17.1, -59.3}, {27.3, -53.6}, {42.1, -49.4}, {69.9, -45.8}, {80, -45.1}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{-90, -46}, {-18, -94}}, lineColor = {192, 192, 192}, textString = "atan2")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{11, 98}, {42, 78}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {8.93, -67.2}, {17.1, -59.3}, {27.3, -53.6}, {42.1, -49.4}, {69.9, -45.8}, {80, -45.1}}, color = {0, 0, 0}), Line(points = {{-80, -34.9}, {-46.1, -31.4}, {-29.4, -27.1}, {-18.3, -21.5}, {-10.3, -14.5}, {-2.03, -3.17}, {7.97, 11.6}, {15.5, 19.4}, {24.3, 25}, {39, 30}, {62.1, 33.5}, {80, 34.9}}, color = {0, 0, 0}), Line(points = {{-80, 45.1}, {-45.9, 48.7}, {-29.1, 52.9}, {-18.1, 58.6}, {-10.2, 65.8}, {-1.82, 77.2}, {0, 80}}, color = {0, 0, 0}), Text(extent = {{-30, 89}, {-10, 70}}, textString = "pi", lineColor = {0, 0, 255}), Text(extent = {{-30, -69}, {-10, -88}}, textString = "-pi", lineColor = {0, 0, 255}), Text(extent = {{-30, 49}, {-10, 30}}, textString = "pi/2", lineColor = {0, 0, 255}), Line(points = {{0, 40}, {-8, 40}}, color = {192, 192, 192}), Line(points = {{0, -40}, {-8, -40}}, color = {192, 192, 192}), Text(extent = {{-30, -31}, {-10, -50}}, textString = "-pi/2", lineColor = {0, 0, 255}), Text(extent = {{48, 0}, {100, -34}}, lineColor = {160, 160, 164}, textString = "u1 / u2")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>tangent-inverse</i> of the input <b>u1</b> divided by
input <b>u2</b>:
</p>
<pre>
    y = <b>atan2</b>( u1, u2 );
</pre>
<p>
u1 and u2 shall not be zero at the same time instant.
<b>Atan2</b> uses the sign of u1 and u2 in order to construct
the solution in the range -180 deg &le; y &le; 180 deg, whereas
block <b>Atan</b> gives a solution in the range
-90 deg &le; y &le; 90 deg.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/atan2.png\"
     alt=\"atan2.png\">
</p>

</html>"));
      end Atan2;

      block Sinh "Output the hyperbolic sine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.sinh(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-86, 80}, {-14, 32}}, lineColor = {192, 192, 192}, textString = "sinh"), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-76, -65.4}, {-71.2, -51.4}, {-65.5, -38.8}, {-59.1, -28.1}, {-51.1, -18.7}, {-41.4, -11.4}, {-27.7, -5.5}, {-4.42, -0.653}, {24.5, 4.57}, {39, 10.1}, {49.4, 17.2}, {57.5, 25.9}, {63.9, 35.8}, {69.5, 47.4}, {74.4, 60.4}, {78.4, 73.8}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{9, 98}, {34, 78}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-76, -65.4}, {-71.2, -51.4}, {-65.5, -38.8}, {-59.1, -28.1}, {-51.1, -18.7}, {-41.4, -11.4}, {-27.7, -5.5}, {-4.42, -0.653}, {24.5, 4.57}, {39, 10.1}, {49.4, 17.2}, {57.5, 25.9}, {63.9, 35.8}, {69.5, 47.4}, {74.4, 60.4}, {78.4, 73.8}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{-31, 72}, {-11, 88}}, textString = "27", lineColor = {0, 0, 255}), Text(extent = {{-35, -88}, {-15, -72}}, textString = "-27", lineColor = {0, 0, 255}), Text(extent = {{70, 25}, {90, 5}}, textString = "4", lineColor = {0, 0, 255}), Text(extent = {{-98, 21}, {-78, 1}}, textString = "-4", lineColor = {0, 0, 255}), Text(extent = {{72, -6}, {96, -26}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic sine</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>sinh</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/sinh.png\"
     alt=\"sinh.png\">
</p>

</html>"));
      end Sinh;

      block Cosh "Output the hyperbolic cosine of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.cosh(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Text(extent = {{4, 66}, {66, 20}}, lineColor = {192, 192, 192}, textString = "cosh"), Line(points = {{-80, 80}, {-77.6, 61.1}, {-74.4, 39.3}, {-71.2, 20.7}, {-67.1, 1.29}, {-63.1, -14.6}, {-58.3, -29.8}, {-52.7, -43.5}, {-46.2, -55.1}, {-39, -64.3}, {-30.2, -71.7}, {-18.9, -77.1}, {-4.42, -79.9}, {10.9, -79.1}, {23.7, -75.2}, {34.2, -68.7}, {42.2, -60.6}, {48.6, -51.2}, {54.3, -40}, {59.1, -27.5}, {63.1, -14.6}, {67.1, 1.29}, {71.2, 20.7}, {74.4, 39.3}, {77.6, 61.1}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-90, -86.083}, {68, -86.083}}, color = {192, 192, 192}), Polygon(points = {{90, -86.083}, {68, -78.083}, {68, -94.083}, {90, -86.083}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{11, 98}, {38, 78}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, -86.083}, {84, -86.083}}, color = {192, 192, 192}), Polygon(points = {{100, -86.083}, {84, -80.083}, {84, -92.083}, {100, -86.083}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 80}, {-77.6, 61.1}, {-74.4, 39.3}, {-71.2, 20.7}, {-67.1, 1.29}, {-63.1, -14.6}, {-58.3, -29.8}, {-52.7, -43.5}, {-46.2, -55.1}, {-39, -64.3}, {-30.2, -71.7}, {-18.9, -77.1}, {-4.42, -79.9}, {10.9, -79.1}, {23.7, -75.2}, {34.2, -68.7}, {42.2, -60.6}, {48.6, -51.2}, {54.3, -40}, {59.1, -27.5}, {63.1, -14.6}, {67.1, 1.29}, {71.2, 20.7}, {74.4, 39.3}, {77.6, 61.1}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{-31, 72}, {-11, 88}}, textString = "27", lineColor = {0, 0, 255}), Text(extent = {{62, -67}, {82, -87}}, textString = "4", lineColor = {0, 0, 255}), Text(extent = {{-104, -63}, {-84, -83}}, textString = "-4", lineColor = {0, 0, 255}), Text(extent = {{78, -54}, {100, -74}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic cosine</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>cosh</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/cosh.png\"
     alt=\"cosh.png\">
</p>

</html>"));
      end Cosh;

      block Tanh "Output the hyperbolic tangent of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.tanh(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-47.8, -78.7}, {-35.8, -75.7}, {-27.7, -70.6}, {-22.1, -64.2}, {-17.3, -55.9}, {-12.5, -44.3}, {-7.64, -29.2}, {-1.21, -4.82}, {6.83, 26.3}, {11.7, 42}, {16.5, 54.2}, {21.3, 63.1}, {26.9, 69.9}, {34.2, 75}, {45.4, 78.4}, {72, 79.9}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-88, 72}, {-16, 24}}, lineColor = {192, 192, 192}, textString = "tanh"), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{9, 98}, {42, 80}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-47.8, -78.7}, {-35.8, -75.7}, {-27.7, -70.6}, {-22.1, -64.2}, {-17.3, -55.9}, {-12.5, -44.3}, {-7.64, -29.2}, {-1.21, -4.82}, {6.83, 26.3}, {11.7, 42}, {16.5, 54.2}, {21.3, 63.1}, {26.9, 69.9}, {34.2, 75}, {45.4, 78.4}, {72, 79.9}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{70, 25}, {90, 5}}, textString = "4", lineColor = {0, 0, 255}), Text(extent = {{-106, 21}, {-86, 1}}, textString = "-4", lineColor = {0, 0, 255}), Text(extent = {{-29, 72}, {-9, 88}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{3, -72}, {23, -88}}, textString = "-1", lineColor = {0, 0, 255}), Text(extent = {{72, -8}, {98, -26}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic tangent</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>tanh</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/tanh.png\"
     alt=\"tanh.png\">
</p>

</html>"));
      end Tanh;

      block Exp "Output the exponential (base e) of the input"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.exp(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -80}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-86, 50}, {-14, 2}}, lineColor = {192, 192, 192}, textString = "exp"), Line(points = {{-80, -80}, {-31, -77.9}, {-6.03, -74}, {10.9, -68.4}, {23.7, -61}, {34.2, -51.6}, {43, -40.3}, {50.3, -27.8}, {56.7, -13.5}, {62.3, 2.23}, {67.1, 18.6}, {72, 38.2}, {76, 57.6}, {80, 80}}, color = {0, 0, 0}), Line(points = {{-90, -80.3976}, {68, -80.3976}}, color = {192, 192, 192}, smooth = Smooth.Bezier), Polygon(points = {{90, -80.3976}, {68, -72.3976}, {68, -88.3976}, {90, -80.3976}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, 80}, {-8, 80}}, color = {192, 192, 192}), Line(points = {{0, -80}, {-8, -80}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 84}}, color = {192, 192, 192}), Text(extent = {{9, 100}, {40, 80}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{0, 100}, {-6, 84}, {6, 84}, {0, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, -80.3976}, {84, -80.3976}}, color = {192, 192, 192}), Polygon(points = {{100, -80.3976}, {84, -74.3976}, {84, -86.3976}, {100, -80.3976}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-31, -77.9}, {-6.03, -74}, {10.9, -68.4}, {23.7, -61}, {34.2, -51.6}, {43, -40.3}, {50.3, -27.8}, {56.7, -13.5}, {62.3, 2.23}, {67.1, 18.6}, {72, 38.2}, {76, 57.6}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{-31, 72}, {-11, 88}}, textString = "20", lineColor = {0, 0, 255}), Text(extent = {{-92, -83}, {-72, -103}}, textString = "-3", lineColor = {0, 0, 255}), Text(extent = {{70, -83}, {90, -103}}, textString = "3", lineColor = {0, 0, 255}), Text(extent = {{-18, -53}, {2, -73}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{66, -52}, {96, -72}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>exponential</i> (of base e) of the input <b>u</b>:
</p>
<pre>
    y = <b>exp</b>( u );
</pre>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/exp.png\"
     alt=\"exp.png\">
</p>

</html>"));
      end Exp;

      block Log "Output the natural (base e) logarithm of the input (input > 0 required)"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.log(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, -80}, {-80, 68}}, color = {192, 192, 192}), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-79.2, -50.6}, {-78.4, -37}, {-77.6, -28}, {-76.8, -21.3}, {-75.2, -11.4}, {-72.8, -1.31}, {-69.5, 8.08}, {-64.7, 17.9}, {-57.5, 28}, {-47, 38.1}, {-31.8, 48.1}, {-10.1, 58}, {22.1, 68}, {68.7, 78.1}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-6, -24}, {66, -72}}, lineColor = {192, 192, 192}, textString = "log")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -90}, {-80, 84}}, color = {192, 192, 192}), Text(extent = {{-67, 98}, {-40, 80}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{-80, 100}, {-86, 84}, {-74, 84}, {-80, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-79.2, -50.6}, {-78.4, -37}, {-77.6, -28}, {-76.8, -21.3}, {-75.2, -11.4}, {-72.8, -1.31}, {-69.5, 8.08}, {-64.7, 17.9}, {-57.5, 28}, {-47, 38.1}, {-31.8, 48.1}, {-10.1, 58}, {22.1, 68}, {68.7, 78.1}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{-105, 72}, {-85, 88}}, textString = "3", lineColor = {0, 0, 255}), Text(extent = {{-109, -88}, {-89, -72}}, textString = "-3", lineColor = {0, 0, 255}), Text(extent = {{70, -3}, {90, -23}}, textString = "20", lineColor = {0, 0, 255}), Text(extent = {{-78, -1}, {-58, -21}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{68, 28}, {94, 8}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>natural (base e) logarithm</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>log</b>( u );
</pre>
<p>
An error occurs if the elements of the input <b>u</b> are
zero or negative.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/log.png\"
     alt=\"log.png\">
</p>

</html>"));
      end Log;

      block Log10 "Output the base 10 logarithm of the input (input > 0 required)"
        extends Interfaces.SISO;
      equation
        y = Modelica.Math.log10(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{90, 0}, {68, 8}, {68, -8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Line(points = {{-79.8, -80}, {-79.2, -50.6}, {-78.4, -37}, {-77.6, -28}, {-76.8, -21.3}, {-75.2, -11.4}, {-72.8, -1.31}, {-69.5, 8.08}, {-64.7, 17.9}, {-57.5, 28}, {-47, 38.1}, {-31.8, 48.1}, {-10.1, 58}, {22.1, 68}, {68.7, 78.1}, {80, 80}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Polygon(points = {{-80, 90}, {-88, 68}, {-72, 68}, {-80, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -80}, {-80, 68}}, color = {192, 192, 192}), Text(extent = {{-30, -22}, {60, -70}}, lineColor = {192, 192, 192}, textString = "log10")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -90}, {-80, 84}}, color = {192, 192, 192}), Text(extent = {{-65, 96}, {-38, 78}}, lineColor = {160, 160, 164}, textString = "y"), Polygon(points = {{-80, 100}, {-86, 84}, {-74, 84}, {-80, 100}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-79.8, -80}, {-79.2, -50.6}, {-78.4, -37}, {-77.6, -28}, {-76.8, -21.3}, {-75.2, -11.4}, {-72.8, -1.31}, {-69.5, 8.08}, {-64.7, 17.9}, {-57.5, 28}, {-47, 38.1}, {-31.8, 48.1}, {-10.1, 58}, {22.1, 68}, {68.7, 78.1}, {80, 80}}, color = {0, 0, 0}), Text(extent = {{70, -3}, {90, -23}}, textString = "20", lineColor = {0, 0, 255}), Text(extent = {{-78, -1}, {-58, -21}}, textString = "1", lineColor = {0, 0, 255}), Text(extent = {{-109, 72}, {-89, 88}}, textString = " 1.3", lineColor = {0, 0, 255}), Text(extent = {{-109, -88}, {-89, -72}}, textString = "-1.3", lineColor = {0, 0, 255}), Text(extent = {{62, 30}, {90, 10}}, lineColor = {160, 160, 164}, textString = "u")}),
          Documentation(info = "<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>base 10 logarithm</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>log10</b>( u );
</pre>
<p>
An error occurs if the elements of the input <b>u</b> are
zero or negative.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Math/log10.png\"
     alt=\"log10.png\">
</p>

</html>"));
      end Log10;

      block RealToInteger "Convert Real to Integer signal"
        extends Modelica.Blocks.Icons.IntegerBlock;
      public
        Interfaces.RealInput u "Connector of Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Interfaces.IntegerOutput y "Connector of Integer output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = if u > 0 then integer(floor(u + 0.5)) else integer(ceil(u - 0.5));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(lineColor = {0, 0, 127}, extent = {{-100.0, -40.0}, {0.0, 40.0}}, textString = "R"), Text(lineColor = {255, 127, 0}, extent = {{20.0, -40.0}, {120.0, 40.0}}, textString = "I"), Polygon(lineColor = {255, 127, 0}, fillColor = {255, 127, 0}, fillPattern = FillPattern.Solid, points = {{50.0, 0.0}, {30.0, 20.0}, {30.0, 10.0}, {0.0, 10.0}, {0.0, -10.0}, {30.0, -10.0}, {30.0, -20.0}, {50.0, 0.0}})}),
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b>
as <i>nearest integer value</i> of the input <b>u</b>:
</p>
<pre>    y = <b>integer</b>( <b>floor</b>( u + 0.5 ) )  for  u &gt; 0;
    y = <b>integer</b>( <b>ceil </b>( u - 0.5 ) )  for  u &lt; 0;
</pre>
</html>"));
      end RealToInteger;

      block IntegerToReal "Convert Integer to Real signals"
        extends Modelica.Blocks.Icons.Block;
        Interfaces.IntegerInput u "Connector of Integer input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        Interfaces.RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = u;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(lineColor = {255, 127, 0}, extent = {{-120.0, -40.0}, {-20.0, 40.0}}, textString = "I"), Text(lineColor = {0, 0, 127}, fillPattern = FillPattern.Solid, extent = {{0.0, -40.0}, {100.0, 40.0}}, textString = "R"), Polygon(lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, points = {{10.0, 0.0}, {-10.0, 20.0}, {-10.0, 10.0}, {-40.0, 10.0}, {-40.0, -10.0}, {-10.0, -10.0}, {-10.0, -20.0}, {10.0, 0.0}})}),
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b>
as <i>Real equivalent</i> of the Integer input <b>u</b>:
</p>
<pre>    y = u;
</pre>
<p>where <b>u</b> is of Integer and <b>y</b> of Real type.</p>
</html>"));
      end IntegerToReal;

      block BooleanToReal "Convert Boolean to Real signal"
        extends Interfaces.partialBooleanSI;
        parameter Real realTrue = 1.0 "Output signal for true Boolean input";
        parameter Real realFalse = 0.0 "Output signal for false Boolean input";
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = if u then realTrue else realFalse;
        annotation(
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b>
as <i>Real equivalent</i> of the Boolean input <b>u</b>:
</p>
<pre>    y = <b>if</b> u <b>then</b> realTrue <b>else</b> realFalse;
</pre>
<p>where <b>u</b> is of Boolean and <b>y</b> of Real type,
and <b>realTrue</b> and <b>realFalse</b> are parameters.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-86, 92}, {-6, 10}}, lineColor = {255, 0, 255}, textString = "B"), Polygon(points = {{-12, -46}, {-32, -26}, {-32, -36}, {-64, -36}, {-64, -56}, {-32, -56}, {-32, -66}, {-12, -46}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Text(extent = {{8, -4}, {92, -94}}, textString = "R", lineColor = {0, 0, 127})}));
      end BooleanToReal;

      block BooleanToInteger "Convert Boolean to Integer signal"
        extends Interfaces.partialBooleanSI;
        parameter Integer integerTrue = 1 "Output signal for true Boolean input";
        parameter Integer integerFalse = 0 "Output signal for false Boolean input";
        Blocks.Interfaces.IntegerOutput y "Connector of Integer output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
      equation
        y = if u then integerTrue else integerFalse;
        annotation(
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b>
as <i>Integer equivalent</i> of the Boolean input <b>u</b>:
</p>
<pre>    y = <b>if</b> u <b>then</b> integerTrue <b>else</b> integerFalse;
</pre>
<p>where <b>u</b> is of Boolean and <b>y</b> of Integer type,
and <b>integerTrue</b> and <b>integerFalse</b> are parameters.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-86, 92}, {-6, 10}}, lineColor = {255, 0, 255}, textString = "B"), Polygon(points = {{-12, -46}, {-32, -26}, {-32, -36}, {-64, -36}, {-64, -56}, {-32, -56}, {-32, -66}, {-12, -46}}, lineColor = {255, 170, 85}, fillColor = {255, 170, 85}, fillPattern = FillPattern.Solid), Text(extent = {{8, -4}, {92, -94}}, lineColor = {255, 170, 85}, textString = "I")}));
      end BooleanToInteger;

      block RealToBoolean "Convert Real to Boolean signal"
        Blocks.Interfaces.RealInput u "Connector of Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        extends Interfaces.partialBooleanSO;
        parameter Real threshold = 0.5 "Output signal y is true, if input u >= threshold";
      equation
        y = u >= threshold;
        annotation(
          Documentation(info = "<html>
<p>
This block computes the Boolean output <b>y</b>
from the Real input <b> u</b> by the equation:
</p>

<pre>    y = u &ge; threshold;
</pre>

<p>
where <b>threshold</b> is a parameter.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-86, 92}, {-6, 10}}, lineColor = {0, 0, 127}, textString = "R"), Polygon(points = {{-12, -46}, {-32, -26}, {-32, -36}, {-64, -36}, {-64, -56}, {-32, -56}, {-32, -66}, {-12, -46}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid), Text(extent = {{8, -4}, {92, -94}}, lineColor = {255, 0, 255}, textString = "B")}));
      end RealToBoolean;

      block IntegerToBoolean "Convert Integer to Boolean signal"
        Blocks.Interfaces.IntegerInput u "Connector of Integer input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
        extends Interfaces.partialBooleanSO;
        parameter Integer threshold = 1 "Output signal y is true, if input u >= threshold";
      equation
        y = u >= threshold;
        annotation(
          Documentation(info = "<html>
<p>
This block computes the Boolean output <b>y</b>
from the Integer input <b> u</b> by the equation:
</p>

<pre>    y = u &ge; threshold;
</pre>

<p>
where <b>threshold</b> is a parameter.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-86, 92}, {-6, 10}}, lineColor = {255, 128, 0}, textString = "I"), Polygon(points = {{-12, -46}, {-32, -26}, {-32, -36}, {-64, -36}, {-64, -56}, {-32, -56}, {-32, -66}, {-12, -46}}, lineColor = {255, 0, 255}, fillColor = {255, 0, 255}, fillPattern = FillPattern.Solid), Text(extent = {{8, -4}, {92, -94}}, lineColor = {255, 0, 255}, textString = "B")}));
      end IntegerToBoolean;

      block RectangularToPolar "Convert rectangular coordinates to polar coordinates"
        extends Modelica.Blocks.Icons.Block;
        Modelica.Blocks.Interfaces.RealInput u_re "Real part of rectangular representation" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput u_im "Imaginary part of rectangular representation" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y_abs "Length of polar representation" annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y_arg "Angle of polar representation" annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
      equation
        y_abs = sqrt(u_re * u_re + u_im * u_im);
        y_arg = Modelica.Math.atan2(u_im, u_re);
        annotation(
          Icon(graphics = {Text(extent = {{-90, 80}, {-20, 40}}, lineColor = {0, 0, 0}, textString = "re"), Text(extent = {{-90, -40}, {-20, -80}}, lineColor = {0, 0, 0}, textString = "im"), Text(extent = {{20, 80}, {90, 40}}, lineColor = {0, 0, 0}, textString = "abs"), Text(extent = {{20, -40}, {90, -80}}, lineColor = {0, 0, 0}, textString = "arg")}),
          Documentation(info = "<html>
<p>
The input values of this block are the rectangular components
<code>u_re</code> and <code>u_im</code> of a phasor in two dimensions.
This block calculates the length <code>y_abs</code> and
the angle <code>y_arg</code> of the polar representation of this phasor.
</p>

<pre>
  y_abs = abs(u_re + j*u_im) = sqrt( u_re<sup>2</sup> + u_im<sup>2</sup> )
  y_arg = arg(u_re + j*u_im) = atan2(u_im, u_re)
</pre>
</html>"));
      end RectangularToPolar;

      block PolarToRectangular "Convert polar coordinates to rectangular coordinates"
        extends Modelica.Blocks.Icons.Block;
        Modelica.Blocks.Interfaces.RealInput u_abs "Length of polar representation" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput u_arg "Angle of polar representation" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y_re "Real part of rectangular representation" annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput y_im "Imaginary part of rectangular representation" annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
      equation
        y_re = u_abs * Modelica.Math.cos(u_arg);
        y_im = u_abs * Modelica.Math.sin(u_arg);
        annotation(
          Icon(graphics = {Text(extent = {{-90, 80}, {-20, 40}}, lineColor = {0, 0, 0}, textString = "abs"), Text(extent = {{-90, -40}, {-20, -80}}, lineColor = {0, 0, 0}, textString = "arg"), Text(extent = {{20, 80}, {90, 40}}, lineColor = {0, 0, 0}, textString = "re"), Text(extent = {{20, -40}, {90, -80}}, lineColor = {0, 0, 0}, textString = "im")}),
          Documentation(info = "<html>
<p>
The input values of this block are the polar components <code>uabs</code> and <code>uarg</code> of a phasor.
This block calculates the components <code>y_re</code> and <code>y_im</code> of the rectangular representation of this phasor.
</p>
<pre>
   y_re = u_abs * cos( u_arg )
   y_im = u_abs * sin( u_arg )
</pre>
</html>"));
      end PolarToRectangular;

      block Mean "Calculate mean over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start = 50) "Base frequency";
        parameter Real x0 = 0 "Start value of integrator state";
        parameter Boolean yGreaterOrEqualZero = false "=true, if output y is guaranteed to be >= 0 for the exact solution" annotation(
          Evaluate = true,
          Dialog(tab = "Advanced"));
      protected
        parameter Modelica.SIunits.Time t0(fixed = false) "Start time of simulation";
        Real x "Integrator state";
      initial equation
        t0 = time;
        x = x0;
        y = 0;
      equation
        der(x) = u;
        when sample(t0 + 1 / f, 1 / f) then
          y = if not yGreaterOrEqualZero then f * pre(x) else max(0.0, f * pre(x));
          reinit(x, 0);
        end when;
        annotation(
          Documentation(info = "<html>
<p>
This block calculates the mean of the input signal u over the given period 1/f:
</p>
<pre>
1 T
- &int; u(t) dt
T 0
</pre>
<p>
Note: The output is updated after each period defined by 1/f.
</p>

<p>
If parameter <b>yGreaterOrEqualZero</b> in the Advanced tab is <b>true</b> (default = <b>false</b>),
then the modeller provides the information that the mean of the input signal is guaranteed
to be &ge; 0 for the exact solution. However, due to inaccuracies in the numerical integration scheme,
the output might be slightly negative. If this parameter is set to true, then the output is
explicitly set to 0.0, if the mean value results in a negative value.
</p>
</html>"),
          Icon(graphics = {Text(extent = {{-80, 60}, {80, 20}}, lineColor = {0, 0, 0}, textString = "mean"), Text(extent = {{-80, -20}, {80, -60}}, lineColor = {0, 0, 0}, textString = "f=%f")}));
      end Mean;

      block RectifiedMean "Calculate rectified mean over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start = 50) "Base frequency";
        parameter Real x0 = 0 "Start value of integrator state";
        Mean mean(final f = f, final x0 = x0) annotation(
          Placement(transformation(extent = {{0, -10}, {20, 10}})));
        Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{-60, -10}, {-40, 10}})));
      equation
        connect(u, abs1.u) annotation(
          Line(points = {{-120, 0}, {-62, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(abs1.y, mean.u) annotation(
          Line(points = {{-39, 0}, {-2, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(mean.y, y) annotation(
          Line(points = {{21, 0}, {110, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p>
This block calculates the rectified mean of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
</html>"),
          Icon(graphics = {Text(extent = {{-80, 60}, {80, 20}}, lineColor = {0, 0, 0}, textString = "RM"), Text(extent = {{-80, -20}, {80, -60}}, lineColor = {0, 0, 0}, textString = "f=%f")}));
      end RectifiedMean;

      block RootMeanSquare "Calculate root mean square over period 1/f"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Modelica.SIunits.Frequency f(start = 50) "Base frequency";
        parameter Real x0 = 0 "Start value of integrator state";
        MultiProduct product(nu = 2) annotation(
          Placement(transformation(extent = {{-40, -10}, {-20, 10}})));
        Mean mean(final f = f, final yGreaterOrEqualZero = true, final x0 = x0) annotation(
          Placement(transformation(extent = {{0, -10}, {20, 10}})));
        Blocks.Math.Sqrt sqrt1 annotation(
          Placement(transformation(extent = {{40, -10}, {60, 10}})));
      equation
        connect(product.y, mean.u) annotation(
          Line(points = {{-18.3, 0}, {-2, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(mean.y, sqrt1.u) annotation(
          Line(points = {{21, 0}, {38, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(sqrt1.y, y) annotation(
          Line(points = {{61, 0}, {110, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(u, product.u[1]) annotation(
          Line(points = {{-120, 0}, {-60, 0}, {-60, 3.5}, {-40, 3.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(u, product.u[2]) annotation(
          Line(points = {{-120, 0}, {-60, 0}, {-60, -3.5}, {-40, -3.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p>
This block calculates the root mean square of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
</html>"),
          Icon(graphics = {Text(extent = {{-80, 60}, {80, 20}}, lineColor = {0, 0, 0}, textString = "RMS"), Text(extent = {{-80, -20}, {80, -60}}, lineColor = {0, 0, 0}, textString = "f=%f")}));
      end RootMeanSquare;

      block Harmonic "Calculate harmonic over period 1/f"
        extends Modelica.Blocks.Icons.Block;
        parameter Modelica.SIunits.Frequency f(start = 50) "Base frequency";
        parameter Integer k(start = 1) "Order of harmonic";
        parameter Real x0Cos = 0 "Start value of cos integrator state";
        parameter Real x0Sin = 0 "Start value of sin integrator state";
        Blocks.Sources.Sine sin1(final amplitude = sqrt(2), final phase = Modelica.Constants.pi / 2, final freqHz = k * f) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 270, origin = {-80, 70})));
        Blocks.Sources.Sine sin2(final amplitude = sqrt(2), final phase = 0, final freqHz = k * f) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {-80, -70})));
        MultiProduct product1(nu = 2) annotation(
          Placement(transformation(extent = {{-60, 30}, {-40, 50}})));
        MultiProduct product2(nu = 2) annotation(
          Placement(transformation(extent = {{-60, -50}, {-40, -30}})));
        Mean mean1(final f = f, final x0 = x0Cos) annotation(
          Placement(transformation(extent = {{-20, 30}, {0, 50}})));
        Mean mean2(final f = f, final x0 = x0Sin) annotation(
          Placement(transformation(extent = {{-20, -50}, {0, -30}})));
        Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}})));
        Blocks.Interfaces.RealOutput y_rms "Root mean square of polar representation" annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}}, rotation = 0)));
        Blocks.Interfaces.RealOutput y_arg "Angle of polar representation" annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
        Blocks.Math.RectangularToPolar rectangularToPolar annotation(
          Placement(transformation(extent = {{40, -12}, {60, 8}})));
      equation
        connect(product2.y, mean2.u) annotation(
          Line(points = {{-38.3, -40}, {-22, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(product1.y, mean1.u) annotation(
          Line(points = {{-38.3, 40}, {-22, 40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(mean1.y, rectangularToPolar.u_re) annotation(
          Line(points = {{1, 40}, {20, 40}, {20, 4}, {38, 4}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(mean2.y, rectangularToPolar.u_im) annotation(
          Line(points = {{1, -40}, {20, -40}, {20, -8}, {38, -8}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(rectangularToPolar.y_abs, y_rms) annotation(
          Line(points = {{61, 4}, {80, 4}, {80, 60}, {110, 60}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(rectangularToPolar.y_arg, y_arg) annotation(
          Line(points = {{61, -8}, {80, -8}, {80, -60}, {110, -60}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(sin1.y, product1.u[1]) annotation(
          Line(points = {{-80, 59}, {-80, 59}, {-80, 43.5}, {-60, 43.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(u, product1.u[2]) annotation(
          Line(points = {{-120, 0}, {-80, 0}, {-80, 36.5}, {-60, 36.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(u, product2.u[1]) annotation(
          Line(points = {{-120, 0}, {-80, 0}, {-80, -36.5}, {-60, -36.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(sin2.y, product2.u[2]) annotation(
          Line(points = {{-80, -59}, {-80, -43.5}, {-60, -43.5}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p>
This block calculates the root mean square and the phase angle of a single harmonic <i>k</i> of the input signal u over the given period 1/f, using the
<a href=\"modelica://Modelica.Blocks.Math.Mean\">mean block</a>.
</p>
<p>
Note: The output is updated after each period defined by 1/f.
</p>
<p>
Note: The harmonic is defined by <code>&radic;2 rms cos(k 2 &pi; f t - arg)</code>
</p>
</html>"),
          Icon(graphics = {Text(extent = {{-80, 60}, {80, 20}}, lineColor = {0, 0, 0}, textString = "H%k"), Text(extent = {{-80, -20}, {80, -60}}, lineColor = {0, 0, 0}, textString = "f=%f"), Text(extent = {{20, 100}, {100, 60}}, lineColor = {0, 0, 0}, textString = "rms"), Text(extent = {{20, -60}, {100, -100}}, lineColor = {0, 0, 0}, textString = "arg")}));
      end Harmonic;

      block Max "Pass through the largest signal"
        extends Interfaces.SI2SO;
      equation
        y = max(u1, u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 36}, {90, -36}}, lineColor = {160, 160, 164}, textString = "max()")}),
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b> as <i>maximum</i>
of the two Real inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>    y = <b>max</b> ( u1 , u2 );
</pre>
</html>"));
      end Max;

      block Min "Pass through the smallest signal"
        extends Interfaces.SI2SO;
      equation
        y = min(u1, u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 36}, {90, -36}}, lineColor = {160, 160, 164}, textString = "min()")}),
          Documentation(info = "<html>
<p>
This block computes the output <b>y</b> as <i>minimum</i> of
the two Real inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>    y = <b>min</b> ( u1 , u2 );
</pre>
</html>"));
      end Min;

      block MinMax "Output the minimum and the maximum element of the input vector"
        extends Modelica.Blocks.Icons.Block;
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.RealVectorInput u[nu] annotation(
          Placement(transformation(extent = {{-120, 70}, {-80, -70}})));
        Modelica.Blocks.Interfaces.RealOutput yMax annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput yMin annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
      equation
        yMax = max(u);
        yMin = min(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}, initialScale = 0.1), graphics = {Text(extent = {{-12, 80}, {100, 40}}, lineColor = {0, 0, 0}, textString = "yMax"), Text(extent = {{-10, -40}, {100, -80}}, lineColor = {0, 0, 0}, textString = "yMin")}),
          Documentation(info = "<html>
<p>
Determines the minimum and maximum element of the input vector and
provide both values as output.
</p>
</html>"));
      end MinMax;

      block LinearDependency "Output a linear combination of the two inputs"
        extends Modelica.Blocks.Interfaces.SI2SO;
        parameter Real y0 = 0 "Initial value";
        parameter Real k1 = 0 "u1 dependency";
        parameter Real k2 = 0 "u2 dependency";
      equation
        y = y0 * (1 + k1 * u1 + k2 * u2);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-100, 60}, {100, 0}, {-100, -60}}, color = {0, 0, 127}, smooth = Smooth.None), Text(extent = {{-14, 88}, {94, 32}}, lineColor = {0, 0, 0}, textString = "%k1"), Text(extent = {{-40, -48}, {96, -96}}, lineColor = {0, 0, 0}, textString = "%k2"), Text(extent = {{-94, 26}, {8, -30}}, lineColor = {0, 0, 0}, textString = "%y0")}),
          Documentation(info = "<html>
<p>
Determine the linear combination of the two inputs:
<code>y = y0*(1 + k1*u1 + k2*u2)</code>
</p>
</html>"));
      end LinearDependency;

      block Edge "Indicates rising edge of Boolean signal"
        extends Interfaces.BooleanSISO;
      equation
        y = edge(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 36}, {90, -36}}, lineColor = {160, 160, 164}, textString = "edge()")}),
          Documentation(info = "<html>
<p>
This block sets the Boolean output <b>y</b> to true,
when the Boolean input <b>u</b> shows a <i>rising edge</i>:
</p>
<pre>    y = <b>edge</b>( u );
</pre>
</html>"));
      end Edge;

      block BooleanChange "Indicates Boolean signal changing"
        extends Interfaces.BooleanSISO;
      equation
        y = change(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 36}, {90, -36}}, lineColor = {160, 160, 164}, textString = "change()")}),
          Documentation(info = "<html>
<p>
This block sets the Boolean output <b>y</b> to true, when the
Boolean input <b>u</b> shows a <i>rising or falling edge</i>,
i.e., when the signal changes:
</p>
<pre>    y = <b>change</b>( u );
</pre>
</html>"));
      end BooleanChange;

      block IntegerChange "Indicates integer signal changing"
        extends Interfaces.IntegerSIBooleanSO;
      equation
        y = change(u);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-90, 36}, {90, -36}}, lineColor = {160, 160, 164}, textString = "change()")}),
          Documentation(info = "<html>
<p>
This block sets the Boolean output <b>y</b> to true, when the
Integer input <b>u</b> changes:
</p>
<pre>    y = <b>change</b>( u );
</pre>
</html>"));
      end IntegerChange;
      annotation(
        Documentation(info = "<html>
<p>
This package contains basic <b>mathematical operations</b>,
such as summation and multiplication, and basic <b>mathematical
functions</b>, such as <b>sqrt</b> and <b>sin</b>, as
input/output blocks. All blocks of this library can be either
connected with continuous blocks or with sampled-data blocks.
</p>
</html>", revisions = "<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       New blocks added: RealToInteger, IntegerToReal, Max, Min, Edge, BooleanChange, IntegerChange.</li>
<li><i>August 7, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized (partly based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist).
</li>
</ul>
</html>"),
        Icon(graphics = {Line(points = {{-80, -2}, {-68.7, 32.2}, {-61.5, 51.1}, {-55.1, 64.4}, {-49.4, 72.6}, {-43.8, 77.1}, {-38.2, 77.8}, {-32.6, 74.6}, {-26.9, 67.7}, {-21.3, 57.4}, {-14.9, 42.1}, {-6.83, 19.2}, {10.1, -32.8}, {17.3, -52.2}, {23.7, -66.2}, {29.3, -75.1}, {35, -80.4}, {40.6, -82}, {46.2, -79.6}, {51.9, -73.5}, {57.5, -63.9}, {63.9, -49.2}, {72, -26.8}, {80, -2}}, color = {95, 95, 95}, smooth = Smooth.Bezier)}));
    end Math;

    package MathInteger "Library of Integer mathematical functions as input/output blocks"
      extends Modelica.Icons.Package;

      block MultiSwitch "Set Integer expression that is associated with the first active input signal"
        input Integer expr[nu] = fill(0, nu) "y = if u[i] then expr[i] elseif use_pre_as_default then pre(y) else y_default" annotation(
          Dialog);
        parameter Integer y_default = 0 "Default value of output y if use_pre_as_default=false, as well as pre(y) at initial time";
        parameter Boolean use_pre_as_default = true "= true, y holds its last value if all u[i]=false, otherwise y=y_default" annotation(
          HideResult = true,
          choices(checkBox = true));
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.BooleanVectorInput u[nu] "Set y = expr[i], if u[i] = true" annotation(
          Placement(transformation(extent = {{-110, 30}, {-90, -30}})));
        Modelica.Blocks.Interfaces.IntegerOutput y "Output depending on expression" annotation(
          Placement(transformation(extent = {{300, -10}, {320, 10}})));
      protected
        Integer firstActiveIndex;
      initial equation
        pre(y) = y_default;
      equation
        firstActiveIndex = Modelica.Math.BooleanVectors.firstTrueIndex(u);
        y = if firstActiveIndex > 0 then expr[firstActiveIndex] else if use_pre_as_default then pre(y) else y_default;
        annotation(
          defaultComponentName = "multiSwitch1",
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {300, 100}}), graphics = {Text(extent = {{310, -25}, {410, -45}}, lineColor = {0, 0, 0}, textString = DynamicSelect(" ", String(y, minimumLength = 1, significantDigits = 0))), Text(visible = not use_pre_as_default, extent = {{-100, -60}, {300, -90}}, lineColor = {0, 0, 0}, textString = "else: %y_default"), Text(visible = use_pre_as_default, extent = {{-100, -50}, {300, -80}}, lineColor = {0, 0, 0}, textString = "else: pre(y)"), Rectangle(extent = {{-100, -40}, {300, 40}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-100, 90}, {300, 50}}, textString = "%name", lineColor = {0, 0, 255}), Text(extent = {{-80, 15}, {290, -15}}, lineColor = {0, 0, 0}, fillColor = {255, 246, 238}, fillPattern = FillPattern.Solid, textString = "%expr")}),
          Documentation(info = "<html>
<p>
This block has a vector of Boolean input signals u[nu] and a vector of
(time varying) Integer expressions expr[nu]. The output signal y is
set to expr[i], if i is the first element in the input vector u that is true. If all input signals are
false, y is set to parameter \"y_default\" or the last value is kept, if use_pre_as_default = <b>true</b>.
</p>

<blockquote><pre>
  // Conceptual equation (not valid Modelica)
  i = 'first element of u[:] that is true';
  y = <b>if</b> i==0 <b>then</b> (<b>if</b> use_pre_as_default <b>then</b> pre(y)
                                          <b>else</b> y_default)
      <b>else</b> expr[i];
</pre></blockquote>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.IntegerNetwork1\">Modelica.Blocks.Examples.IntegerNetwork1</a>.
</p>

</html>"));
      end MultiSwitch;

      block Sum "Sum of Integers: y = k[1]*u[1] + k[2]*u[2] + ... + k[n]*u[n]"
        extends Modelica.Blocks.Interfaces.PartialIntegerMISO;
        parameter Integer k[nu] = fill(1, nu) "Input gains";
      equation
        if size(u, 1) > 0 then
          y = k * u;
        else
          y = 0;
        end if;
        annotation(
          Icon(graphics = {Text(extent = {{-200, -110}, {200, -140}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "%k"), Text(extent = {{-72, 68}, {92, -68}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "+")}),
          Documentation(info = "<html>
<p>
This blocks computes the scalar Integer output \"y\" as sum of the elements of the
Integer input signal vector u:
</p>
<blockquote><pre>
y = k[1]*u[1] + k[2]*u[2] + ... k[N]*u[N];
</pre></blockquote>

<p>
The input connector is a vector of Integer input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.IntegerNetwork1\">Modelica.Blocks.Examples.IntegerNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to zero: y=0.
</p>
</html>"));
      end Sum;

      block Product "Product of Integer: y = u[1]*u[2]* ... *u[n]"
        extends Modelica.Blocks.Interfaces.PartialIntegerMISO;
      equation
        if size(u, 1) > 0 then
          y = product(u);
        else
          y = 0;
        end if;
        annotation(
          Icon(graphics = {Text(extent = {{-74, 50}, {94, -94}}, lineColor = {0, 0, 0}, fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, textString = "*")}),
          Documentation(info = "<html>
<p>
This blocks computes the scalar Integer output \"y\" as product of the elements of the
Integer input signal vector u:
</p>
<blockquote><pre>
y = u[1]*u[2]* ... *u[N];
</pre></blockquote>

<p>
The input connector is a vector of Integer input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.IntegerNetwork1\">Modelica.Blocks.Examples.IntegerNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to zero: y=0.
</p>
</html>"));
      end Product;

      block TriggeredAdd "Add input to previous value of output, if rising edge of trigger port"
        extends Modelica.Blocks.Interfaces.PartialIntegerSISO;
        parameter Boolean use_reset = false "=true, if reset port enabled" annotation(
          Evaluate = true,
          HideResult = true,
          choices(checkBox = true));
        parameter Boolean use_set = false "=true, if set port enabled and used as default value when reset" annotation(
          Evaluate = true,
          HideResult = true,
          choices(checkBox = true));
        parameter Integer y_start = 0 "Initial and reset value of y if set port is not used";
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-60, -120})));
        Modelica.Blocks.Interfaces.BooleanInput reset if use_reset annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {60, -120})));
        Modelica.Blocks.Interfaces.IntegerInput set if use_set annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {60, 120}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {28, 98})));
      protected
        Modelica.Blocks.Interfaces.BooleanOutput local_reset annotation(
          HideResult = true);
        Modelica.Blocks.Interfaces.IntegerOutput local_set;
      initial equation
        pre(y) = y_start;
      equation
        if use_reset then
          connect(reset, local_reset);
          if use_set then
            connect(set, local_set);
          else
            local_set = y_start;
          end if;
        else
          local_reset = false;
          local_set = 0;
        end if;
        when {trigger, local_reset} then
          y = if local_reset then local_set else pre(y) + u;
        end when;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}, initialScale = 0.06), graphics = {Line(points = {{-100, 0}, {32, 76}}, color = {255, 128, 0}, smooth = Smooth.None, pattern = LinePattern.Dot), Line(points = {{-100, 0}, {32, -20}}, color = {255, 128, 0}, pattern = LinePattern.Dot, smooth = Smooth.None), Line(points = {{-54, -56}, {-26, -56}, {-26, -20}, {32, -20}, {32, 76}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-60, -100}, {32, -20}}, color = {255, 0, 255}, pattern = LinePattern.Dot, smooth = Smooth.None), Text(visible = use_reset, extent = {{-28, -62}, {94, -86}}, lineColor = {0, 0, 0}, textString = "reset")}),
          Documentation(info = "<html>
<p>
Add input to previous value of output, if rising edge of trigger port

<p>
This block has one Integer input \"u\", one Boolean input \"trigger\",
an optional Boolean input \"reset\", an optional Integer input \"set\", and
an Integer output \"y\".
The optional inputs can be activated with the \"use_reset\" and
\"use_set\" flags, respectively.
</p>

<p>
The input \"u\" is added to the previous value of the
output \"y\" if the \"trigger\" port has a rising edge. At the start of the
simulation \"y = y_start\".
</p>

<p>
If the \"reset\" port is enabled, then the output \"y\" is reset to \"set\"
or to \"y_start\" (if the \"set\" port is not enabled), whenever the \"reset\"
port has a rising edge.
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.IntegerNetwork1\">Modelica.Blocks.Examples.IntegerNetwork1</a>.
</p>

</html>"));
      end TriggeredAdd;
      annotation(
        Documentation(info = "<html>
<p>
This package contains basic <b>mathematical operations</b>
on <b>Integer</b> signals.
</p>
</html>"),
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-74, -66}, {-46, -66}, {-46, -30}, {12, -30}, {12, 66}}, color = {255, 128, 0}), Line(points = {{12, 66}, {70, 66}}, color = {255, 128, 0})}));
    end MathInteger;

    package MathBoolean "Library of Boolean mathematical functions as input/output blocks"
      extends Modelica.Icons.Package;

      block MultiSwitch "Set Boolean expression that is associated with the first active input signal"
        input Boolean expr[nu] = fill(false, nu) "y = if u[i] then expr[i] else y_default (time varying)" annotation(
          Dialog);
        parameter Boolean use_pre_as_default = true "set true to hold last value as default (y_default = pre(y))" annotation(
          HideResult = true,
          choices(checkBox = true));
        parameter Boolean y_default = false "Default value of output y if all u[i] = false" annotation(
          Dialog(enable = not use_pre_as_default));
        parameter Integer nu(min = 0) = 0 "Number of input connections" annotation(
          Dialog(connectorSizing = true),
          HideResult = true);
        Modelica.Blocks.Interfaces.BooleanVectorInput u[nu] "Set y = expr[i], if u[i] = true" annotation(
          Placement(transformation(extent = {{-110, 30}, {-90, -30}})));
        Modelica.Blocks.Interfaces.BooleanOutput y "Output depending on expression" annotation(
          Placement(transformation(extent = {{300, -10}, {320, 10}})));
      protected
        Integer firstActiveIndex;
      initial equation
        pre(y) = y_default;
      equation
        firstActiveIndex = Modelica.Math.BooleanVectors.firstTrueIndex(u);
        y = if firstActiveIndex == 0 then if use_pre_as_default then pre(y) else y_default else expr[firstActiveIndex];
        annotation(
          defaultComponentName = "set1",
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {300, 100}}), graphics = {Text(visible = not use_pre_as_default, extent = {{-100, -60}, {300, -90}}, lineColor = {0, 0, 0}, textString = "else: %y_default"), Text(visible = use_pre_as_default, extent = {{-100, -60}, {300, -90}}, lineColor = {0, 0, 0}, textString = "else: pre(y)"), Text(extent = {{-99, 99}, {300, 59}}, textString = "%name", lineColor = {0, 0, 255}), Rectangle(extent = {{-100, -51}, {300, 50}}, lineColor = {255, 127, 0}, lineThickness = 5.0, fillColor = {210, 210, 210}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Text(extent = {{-84, 16}, {273, -15}}, lineColor = {0, 0, 0}, fillColor = {255, 246, 238}, fillPattern = FillPattern.Solid, textString = "%expr"), Ellipse(extent = {{275, 8}, {289, -6}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
The block has a vector of Boolean input signals u[nu] and a vector of
(time varying) Boolean expressions expr[:]. The output signal y is
set to expr[i], if i is the first element in the input vector u that is true.
If all input signals are false, y is set to parameter \"y_default\" or the
previous value of y is kept if parameter use_pre_as_default = <b>true</b>:
</p>

<blockquote><pre>
  // Conceptual equation (not valid Modelica)
  i = 'first element of u[:] that is true';
  y = <b>if</b> i==0 <b>then</b> (<b>if</b> use_pre_as_default <b>then</b> pre(y)
                                          <b>else</b> y_default)
      <b>else</b> expr[i];
</pre></blockquote>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

</html>"));
      end MultiSwitch;

      block And "Logical 'and': y = u[1] and u[2] and ... and u[nu]"
        extends Modelica.Blocks.Interfaces.PartialBooleanMISO;
      equation
        y = Modelica.Math.BooleanVectors.allTrue(u);
        annotation(
          defaultComponentName = "and1",
          Icon(graphics = {Text(extent = {{-76, 40}, {60, -40}}, lineColor = {0, 0, 0}, textString = "and")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if all inputs are <b>true</b>, otherwise
the output is <b>false</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to <b>false</b>: y=false.
</p>
</html>"));
      end And;

      block Or "Logical 'or': y = u[1] or u[2] or ... or u[nu]"
        extends Modelica.Blocks.Interfaces.PartialBooleanMISO;
      equation
        y = Modelica.Math.BooleanVectors.anyTrue(u);
        annotation(
          defaultComponentName = "or1",
          Icon(graphics = {Text(extent = {{-80, 40}, {60, -40}}, lineColor = {0, 0, 0}, textString = "or")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if at least one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to <b>false</b>: y=false.
</p>

</html>"));
      end Or;

      block Xor "Logical 'xor': y = oneTrue(u)  (y is true, if exactly one element of u is true, otherwise it is false)"
        extends Modelica.Blocks.Interfaces.PartialBooleanMISO;
      equation
        y = Modelica.Math.BooleanVectors.oneTrue(u);
        annotation(
          defaultComponentName = "xor1",
          Icon(graphics = {Text(extent = {{-80, 40}, {60, -40}}, lineColor = {0, 0, 0}, textString = "xor")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if exactly one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to <b>false</b>: y=false.
</p>

</html>"));
      end Xor;

      block Nand "Logical 'nand': y = not ( u[1] and u[2] and ... and u[nu] )"
        extends Modelica.Blocks.Interfaces.PartialBooleanMISO;
      equation
        y = not Modelica.Math.BooleanVectors.allTrue(u);
        annotation(
          defaultComponentName = "nand1",
          Icon(graphics = {Text(extent = {{-78, 36}, {64, -30}}, lineColor = {0, 0, 0}, textString = "nand")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if at least one input is <b>false</b>, otherwise
the output is <b>false</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to <b>false</b>: y=false.
</p>

</html>"));
      end Nand;

      block Nor "Logical 'nor': y = not ( u[1] or u[2] or ... or u[nu] )"
        extends Modelica.Blocks.Interfaces.PartialBooleanMISO;
      equation
        y = not Modelica.Math.BooleanVectors.anyTrue(u);
        annotation(
          defaultComponentName = "nor1",
          Icon(graphics = {Text(extent = {{-80, 40}, {60, -40}}, lineColor = {0, 0, 0}, textString = "nor")}),
          Documentation(info = "<html>
<p>
The output is <b>false</b> if at least one input is <b>true</b>, otherwise
the output is <b>true</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

<p>
If no connection to the input connector \"u\" is present,
the output is set to <b>false</b>: y=false.
</p>
</html>"));
      end Nor;

      block Not "Logical 'not': y = not u"
        extends Modelica.Blocks.Interfaces.PartialBooleanSISO_small;
      equation
        y = not u;
        annotation(
          defaultComponentName = "not1",
          Icon(graphics = {Text(extent = {{-98, 40}, {42, -40}}, lineColor = {0, 0, 0}, textString = "not")}),
          Documentation(info = "<html>
<p>
The output is <b>false</b> if at least one input is <b>true</b>, otherwise
the output is <b>true</b>.
</p>

<p>
The input connector is a vector of Boolean input signals.
When a connection line is drawn, the dimension of the input
vector is enlarged by one and the connection is automatically
connected to this new free index (thanks to the
connectorSizing annotation).
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>
</html>"));
      end Not;

      block RisingEdge "Output y is true, if the input u has a rising edge, otherwise it is false (y = edge(u))"
        parameter Boolean pre_u_start = false "Value of pre(u) at initial time";
        extends Modelica.Blocks.Interfaces.PartialBooleanSISO_small;
      initial equation
        pre(u) = pre_u_start;
      equation
        y = edge(u);
        annotation(
          defaultComponentName = "rising1",
          Icon(graphics = {Line(points = {{-80, -68}, {-36, -68}, {-36, -24}, {22, -24}, {22, -68}, {66, -68}}, color = {0, 0, 0}), Line(points = {{-80, 32}, {-36, 32}, {-36, 76}, {-36, 76}, {-36, 32}, {66, 32}}, color = {255, 0, 255})}),
          Documentation(info = "<html>
<p>
A rising edge of the Boolean input u results in y = <b>true</b> at this
time instant. At all other time instants, y = <b>false</b>.
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

</html>"));
      end RisingEdge;

      block FallingEdge "Output y is true, if the input u has a falling edge, otherwise it is false (y = edge(not u))"
        parameter Boolean pre_u_start = false "Value of pre(u) at initial time";
        extends Modelica.Blocks.Interfaces.PartialBooleanSISO_small;
      protected
        Boolean not_u = not u annotation(
          HideResult = true);
      initial equation
        pre(not_u) = not pre_u_start;
      equation
        y = edge(not_u);
        annotation(
          defaultComponentName = "falling1",
          Icon(graphics = {Line(points = {{-80, -68}, {-36, -68}, {-36, -24}, {22, -24}, {22, -68}, {66, -68}}, color = {0, 0, 0}), Line(points = {{-80, 32}, {24, 32}, {24, 76}, {24, 76}, {24, 32}, {66, 32}}, color = {255, 0, 255})}),
          Documentation(info = "<html>
<p>
A falling edge of the Boolean input u results in y = <b>true</b> at this
time instant. At all other time instants, y = <b>false</b>.
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

</html>"));
      end FallingEdge;

      block ChangingEdge "Output y is true, if the input u has either a rising or a falling edge and otherwise it is false (y=change(u))"
        parameter Boolean pre_u_start = false "Value of pre(u) at initial time";
        extends Modelica.Blocks.Interfaces.PartialBooleanSISO_small;
      initial equation
        pre(u) = pre_u_start;
      equation
        y = change(u);
        annotation(
          defaultComponentName = "changing1",
          Icon(graphics = {Line(points = {{-80, -68}, {-36, -68}, {-36, -24}, {22, -24}, {22, -68}, {66, -68}}, color = {0, 0, 0}), Line(points = {{-80, 32}, {-36, 32}, {-36, 76}, {-36, 76}, {-36, 32}, {66, 32}}, color = {255, 0, 255}), Line(points = {{24, 32}, {24, 76}}, color = {255, 0, 255}, smooth = Smooth.None)}),
          Documentation(info = "<html>
<p>
A changing edge, i.e., either rising or falling,
of the Boolean input u results in y = <b>true</b> at this
time instant. At all other time instants, y = <b>false</b>.
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

</html>"));
      end ChangingEdge;

      block OnDelay "Delay a rising edge of the input, but do not delay a falling edge."
        extends Modelica.Blocks.Interfaces.PartialBooleanSISO_small;
        parameter Modelica.SIunits.Time delayTime "Delay time";
      protected
        Boolean delaySignal(start = false, fixed = true);
        discrete Modelica.SIunits.Time t_next;
      initial equation
        pre(u) = false;
        pre(t_next) = time - 1;
      algorithm
        when initial() then
          delaySignal := u;
          t_next := time - 1;
        elsewhen u then
          delaySignal := true;
          t_next := time + delayTime;
        elsewhen not u then
          delaySignal := false;
          t_next := time - 1;
        end when;
      equation
        if delaySignal then
          y = time >= t_next;
        else
          y = false;
        end if;
        annotation(
          Icon(graphics = {Text(extent = {{-250, -120}, {250, -150}}, lineColor = {0, 0, 0}, textString = "%delayTime s"), Line(points = {{-80, -66}, {-60, -66}, {-60, -22}, {38, -22}, {38, -66}, {66, -66}}, color = {0, 0, 0}), Line(points = {{-80, 32}, {-4, 32}, {-4, 76}, {38, 76}, {38, 32}, {66, 32}}, color = {255, 0, 255})}),
          Documentation(info = "<html>
<p>
A rising edge of the Boolean input u gives a delayed output.
A falling edge of the input is immediately given to the output.
</p>

<p>
Simulation results of a typical example with a delay time of 0.1 s
is shown in the next figure.
</p>

<p>
<img src=\"modelica://Modelica/Resources/Images/Blocks/MathBoolean/OnDelay1.png\"
     alt=\"OnDelay1.png\">
<br>
<img src=\"modelica://Modelica/Resources/Images/Blocks/MathBoolean/OnDelay2.png\"
     alt=\"OnDelay2.png\">
</p>

<p>
The usage is demonstrated, e.g., in example
<a href=\"modelica://Modelica.Blocks.Examples.BooleanNetwork1\">Modelica.Blocks.Examples.BooleanNetwork1</a>.
</p>

</html>"));
      end OnDelay;
      annotation(
        Documentation(info = "<html>
<p>
This package contains basic <b>mathematical operations</b>
on <b>Boolean</b> signals.
</p>

<p>
Package MathBoolean is a new design that shall replace in the future the
<a href=\"modelica://Modelica.Blocks.Logical\">Logical</a> package.
The new features are:
</p>

<ul>
<li> If useful, blocks may have an arbitrary number of inputs (e.g., \"And\" block with 2,3,4,...
     Boolean inputs). This is based on the \"connectorSizing\" annotation which
     allows a tool to conveniently handle vectors of connectors. </li>

<li> The blocks are smaller in size, so that the diagram area is better
     utilized for trivial blocks such as \"And\" or \"Or\".</li>

</ul>

</html>"),
        Icon(graphics = {Line(points = {{-80, -16}, {-4, -16}, {-4, 28}, {38, 28}, {38, -16}, {66, -16}}, color = {255, 0, 255})}));
    end MathBoolean;

    package Nonlinear "Library of discontinuous or non-differentiable algebraic control blocks"
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Package;

      block Limiter "Limit the range of a signal"
        parameter Real uMax(start = 1) "Upper limits of input signals";
        parameter Real uMin = -uMax "Lower limits of input signals";
        parameter Boolean strict = false "= true, if strict limits with noEvent(..)" annotation(
          Evaluate = true,
          choices(checkBox = true),
          Dialog(tab = "Advanced"));
        parameter Boolean limitsAtInit = true "= false, if limits are ignored during initialization (i.e., y=u)" annotation(
          Evaluate = true,
          choices(checkBox = true),
          Dialog(tab = "Advanced"));
        extends Interfaces.SISO;
      equation
        assert(uMax >= uMin, "Limiter: Limits must be consistent. However, uMax (=" + String(uMax) + ") < uMin (=" + String(uMin) + ")");
        if initial() and not limitsAtInit then
          y = u;
          assert(u >= uMin - 0.01 * abs(uMin) and u <= uMax + 0.01 * abs(uMax), "Limiter: During initialization the limits have been ignored.\n" + "However, the result is that the input u is not within the required limits:\n" + "  u = " + String(u) + ", uMin = " + String(uMin) + ", uMax = " + String(uMax));
        elseif strict then
          y = smooth(0, noEvent(if u > uMax then uMax else if u < uMin then uMin else u));
        else
          y = smooth(0, if u > uMax then uMax else if u < uMin then uMin else u);
        end if;
        annotation(
          Documentation(info = "<html>
<p>
The Limiter block passes its input signal as output signal
as long as the input is within the specified upper and lower
limits. If this is not the case, the corresponding limits are passed
as output.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -90}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, -8}, {68, 8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -70}, {-50, -70}, {50, 70}, {80, 70}}, color = {0, 0, 0}), Text(extent = {{-150, -150}, {150, -110}}, lineColor = {0, 0, 0}, textString = "uMax=%uMax"), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255}), Line(visible = strict, points = {{50, 70}, {80, 70}}, color = {255, 0, 0}, smooth = Smooth.None), Line(visible = strict, points = {{-80, -70}, {-50, -70}}, color = {255, 0, 0}, smooth = Smooth.None)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -60}, {0, 50}}, color = {192, 192, 192}), Polygon(points = {{0, 60}, {-5, 50}, {5, 50}, {0, 60}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-60, 0}, {50, 0}}, color = {192, 192, 192}), Polygon(points = {{60, 0}, {50, -5}, {50, 5}, {60, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-50, -40}, {-30, -40}, {30, 40}, {50, 40}}, color = {0, 0, 0}), Text(extent = {{46, -6}, {68, -18}}, lineColor = {128, 128, 128}, textString = "u"), Text(extent = {{-30, 70}, {-5, 50}}, lineColor = {128, 128, 128}, textString = "y"), Text(extent = {{-58, -54}, {-28, -42}}, lineColor = {128, 128, 128}, textString = "uMin"), Text(extent = {{26, 40}, {66, 56}}, lineColor = {128, 128, 128}, textString = "uMax")}));
      end Limiter;

      block VariableLimiter "Limit the range of a signal with variable limits"
        extends Interfaces.SISO;
        parameter Boolean strict = false "= true, if strict limits with noEvent(..)" annotation(
          Evaluate = true,
          choices(checkBox = true));
        parameter Boolean limitsAtInit = true "= false, if limits are ignored during initialization (i.e., y=u)" annotation(
          Evaluate = true,
          choices(checkBox = true));
        Interfaces.RealInput limit1 "Connector of Real input signal used as maximum of input u" annotation(
          Placement(transformation(extent = {{-140, 60}, {-100, 100}}, rotation = 0)));
        Interfaces.RealInput limit2 "Connector of Real input signal used as minimum of input u" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}}, rotation = 0)));
      protected
        Real uMax;
        Real uMin;
      equation
        if strict then
          uMax = noEvent(max(limit1, limit2));
          uMin = noEvent(min(limit1, limit2));
        else
          uMax = max(limit1, limit2);
          uMin = min(limit1, limit2);
        end if;
        if initial() and not limitsAtInit then
          y = u;
          assert(u >= uMin - 0.01 * abs(uMin) and u <= uMax + 0.01 * abs(uMax), "VariableLimiter: During initialization the limits have been ignored.\n" + "However, the result is that the input u is not within the required limits:\n" + "  u = " + String(u) + ", uMin = " + String(uMin) + ", uMax = " + String(uMax));
        elseif strict then
          y = smooth(0, noEvent(if u > uMax then uMax else if u < uMin then uMin else u));
        else
          y = smooth(0, if u > uMax then uMax else if u < uMin then uMin else u);
        end if;
        annotation(
          Documentation(info = "<html>
<p>
The Limiter block passes its input signal as output signal
as long as the input is within the upper and lower
limits specified by the two additional inputs limit1 and
limit2. If this is not the case, the corresponding limit
is passed as output.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -90}, {0, 68}}, color = {192, 192, 192}), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, -8}, {68, 8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -70}, {-50, -70}, {50, 70}, {80, 70}}, color = {0, 0, 0}), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255}), Line(points = {{-100, 80}, {66, 80}, {66, 70}}, color = {0, 0, 127}), Line(points = {{-100, -80}, {-64, -80}, {-64, -70}}, color = {0, 0, 127}), Polygon(points = {{-64, -70}, {-66, -74}, {-62, -74}, {-64, -70}}, lineColor = {0, 0, 127}), Polygon(points = {{66, 70}, {64, 74}, {68, 74}, {66, 70}}, lineColor = {0, 0, 127}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(visible = strict, points = {{50, 70}, {80, 70}}, color = {255, 0, 0}, smooth = Smooth.None), Line(visible = strict, points = {{-80, -70}, {-50, -70}}, color = {255, 0, 0}, smooth = Smooth.None)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -60}, {0, 50}}, color = {192, 192, 192}), Polygon(points = {{0, 60}, {-5, 50}, {5, 50}, {0, 60}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-60, 0}, {50, 0}}, color = {192, 192, 192}), Polygon(points = {{60, 0}, {50, -5}, {50, 5}, {60, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-50, -40}, {-30, -40}, {30, 40}, {50, 40}}, color = {0, 0, 0}), Text(extent = {{46, -6}, {68, -18}}, lineColor = {128, 128, 128}, textString = "inPort"), Text(extent = {{-30, 70}, {-5, 50}}, lineColor = {128, 128, 128}, textString = "outPort"), Text(extent = {{-66, -40}, {-26, -20}}, lineColor = {128, 128, 128}, textString = "uMin"), Text(extent = {{30, 20}, {70, 40}}, lineColor = {128, 128, 128}, textString = "uMax"), Line(points = {{-100, 80}, {40, 80}, {40, 40}}, color = {0, 0, 127}), Line(points = {{-100, -80}, {-40, -80}, {-40, -40}}, color = {0, 0, 127}), Polygon(points = {{40, 40}, {35, 50}, {45, 50}, {40, 40}}, lineColor = {0, 0, 127}), Polygon(points = {{-40, -40}, {-45, -50}, {-35, -50}, {-40, -40}}, lineColor = {0, 0, 127})}));
      end VariableLimiter;

      block SlewRateLimiter "Limits the slew rate of a signal"
        extends Modelica.Blocks.Interfaces.SISO;
        import Modelica.Constants.small;
        parameter Modelica.SIunits.DampingCoefficient Rising(min = small) = 1 "Maximum rising slew rate [+small..+inf)";
        parameter Modelica.SIunits.DampingCoefficient Falling(max = -small) = -Rising "Maximum falling slew rate (-inf..-small]";
        parameter Modelica.SIunits.Time Td(min = small) = 0.001 "Derivative time constant";
        parameter Boolean strict = false "= true, if strict limits with noEvent(..)" annotation(
          Evaluate = true,
          choices(checkBox = true),
          Dialog(tab = "Advanced"));
      initial equation
        y = u;
      equation
        if strict then
          der(y) = smooth(1, noEvent(min(max((u - y) / Td, Falling), Rising)));
        else
          der(y) = smooth(1, min(max((u - y) / Td, Falling), Rising));
        end if;
        annotation(
          Icon(graphics = {Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Line(points = {{0, -90}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Polygon(points = {{90, 0}, {68, -8}, {68, 8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-50, -70}, {50, 70}}, color = {0, 0, 0}, smooth = Smooth.None), Line(visible = strict, points = {{50, 70}, {-50, -70}}, color = {255, 0, 0}, smooth = Smooth.None)}),
          Documentation(info = "<html>
<p>The <code>SlewRateLimiter</code> block limits the slew rate of its input signal in the range of <code>[Falling, Rising]</code>.</p>
<p>To ensure this for arbitrary inputs and in order to produce a differential output, the input is numerically differentiated
with derivative time constant <code>Td</code>. Smaller time constant <code>Td</code> means nearer ideal derivative.</p>
<p><em>Note: The user has to choose the derivative time constant according to the nature of the input signal.</em></p>
</html>", revisions = "<html>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"1\"><tr>
<th>Revision</th>
<th>Date</th>
<th>Author</th>
<th>Comment</th>
</tr>
<tr>
<td valign=\"top\">4954</td>
<td valign=\"top\">2012-03-02</td>
<td valign=\"top\">A. Haumer &amp; D. Winkler</td>
<td valign=\"top\"><p>Initial version based on discussion in ticket <a href=\"https://trac.modelica.org/Modelica/ticket/529\">#529</a></p></td>
</tr>
</table>
</html>"));
      end SlewRateLimiter;

      block DeadZone "Provide a region of zero output"
        parameter Real uMax(start = 1) "Upper limits of dead zones";
        parameter Real uMin = -uMax "Lower limits of dead zones";
        parameter Boolean deadZoneAtInit = true "= false, if dead zone is ignored during initialization (i.e., y=u)";
        extends Interfaces.SISO;
      equation
        assert(uMax >= uMin, "DeadZone: Limits must be consistent. However, uMax (=" + String(uMax) + ") < uMin (=" + String(uMin) + ")");
        if initial() and not deadZoneAtInit then
          y = u;
        else
          y = smooth(0, if u > uMax then u - uMax else if u < uMin then u - uMin else 0);
        end if;
        annotation(
          Documentation(info = "<html>
<p>
The DeadZone block defines a region of zero output.
</p>
<p>
If the input is within uMin ... uMax, the output
is zero. Outside of this zone, the output is a linear
function of the input with a slope of 1.
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -90}, {0, 68}}, color = {192, 192, 192}), Polygon(points = {{0, 90}, {-8, 68}, {8, 68}, {0, 90}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-90, 0}, {68, 0}}, color = {192, 192, 192}), Polygon(points = {{90, 0}, {68, -8}, {68, 8}, {90, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, -60}, {-20, 0}, {20, 0}, {80, 60}}, color = {0, 0, 0}), Text(extent = {{-150, -150}, {150, -110}}, lineColor = {160, 160, 164}, textString = "uMax=%uMax"), Text(extent = {{-150, 150}, {150, 110}}, textString = "%name", lineColor = {0, 0, 255})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{0, -60}, {0, 50}}, color = {192, 192, 192}), Polygon(points = {{0, 60}, {-5, 50}, {5, 50}, {0, 60}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-76, 0}, {74, 0}}, color = {192, 192, 192}), Polygon(points = {{84, 0}, {74, -5}, {74, 5}, {84, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-81, -40}, {-38, 0}, {40, 0}, {80, 40}}, color = {0, 0, 0}), Text(extent = {{62, -7}, {88, -25}}, lineColor = {128, 128, 128}, textString = "u"), Text(extent = {{-36, 72}, {-5, 50}}, lineColor = {128, 128, 128}, textString = "y"), Text(extent = {{-51, 1}, {-28, 19}}, lineColor = {128, 128, 128}, textString = "uMin"), Text(extent = {{27, 21}, {52, 5}}, lineColor = {128, 128, 128}, textString = "uMax")}));
      end DeadZone;

      block FixedDelay "Delay block with fixed DelayTime"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter SI.Time delayTime(start = 1) "Delay time of output with respect to input signal";
      equation
        y = delay(u, delayTime);
        annotation(
          Documentation(info = "<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(extent = {{8.0, -142.0}, {8.0, -102.0}}, textString = "delayTime=%delayTime"), Line(points = {{-92.0, 0.0}, {-80.7, 34.2}, {-73.5, 53.1}, {-67.1, 66.4}, {-61.4, 74.6}, {-55.8, 79.1}, {-50.2, 79.8}, {-44.6, 76.6}, {-38.9, 69.7}, {-33.3, 59.4}, {-26.9, 44.1}, {-18.83, 21.2}, {-1.9, -30.8}, {5.3, -50.2}, {11.7, -64.2}, {17.3, -73.1}, {23.0, -78.4}, {28.6, -80.0}, {34.2, -77.6}, {39.9, -71.5}, {45.5, -61.9}, {51.9, -47.2}, {60.0, -24.8}, {68.0, 0.0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Line(points = {{-62.0, 0.0}, {-50.7, 34.2}, {-43.5, 53.1}, {-37.1, 66.4}, {-31.4, 74.6}, {-25.8, 79.1}, {-20.2, 79.8}, {-14.6, 76.6}, {-8.9, 69.7}, {-3.3, 59.4}, {3.1, 44.1}, {11.17, 21.2}, {28.1, -30.8}, {35.3, -50.2}, {41.7, -64.2}, {47.3, -73.1}, {53.0, -78.4}, {58.6, -80.0}, {64.2, -77.6}, {69.9, -71.5}, {75.5, -61.9}, {81.9, -47.2}, {90.0, -24.8}, {98.0, 0.0}}, color = {160, 160, 164}, smooth = Smooth.Bezier)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -88}, {-80, 86}}, color = {192, 192, 192}), Text(extent = {{-75, 98}, {-46, 78}}, lineColor = {0, 0, 255}, textString = "outPort"), Polygon(points = {{-80, 96}, {-86, 80}, {-74, 80}, {-80, 96}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 0}, {-68.7, 34.2}, {-61.5, 53.1}, {-55.1, 66.4}, {-49.4, 74.6}, {-43.8, 79.1}, {-38.2, 79.8}, {-32.6, 76.6}, {-26.9, 69.7}, {-21.3, 59.4}, {-14.9, 44.1}, {-6.83, 21.2}, {10.1, -30.8}, {17.3, -50.2}, {23.7, -64.2}, {29.3, -73.1}, {35, -78.4}, {40.6, -80}, {46.2, -77.6}, {51.9, -71.5}, {57.5, -61.9}, {63.9, -47.2}, {72, -24.8}, {80, 0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(extent = {{-24, 98}, {-2, 78}}, lineColor = {0, 0, 0}, textString = "inPort"), Line(points = {{-64, 0}, {-52.7, 34.2}, {-45.5, 53.1}, {-39.1, 66.4}, {-33.4, 74.6}, {-27.8, 79.1}, {-22.2, 79.8}, {-16.6, 76.6}, {-10.9, 69.7}, {-5.3, 59.4}, {1.1, 44.1}, {9.17, 21.2}, {26.1, -30.8}, {33.3, -50.2}, {39.7, -64.2}, {45.3, -73.1}, {51, -78.4}, {56.6, -80}, {62.2, -77.6}, {67.9, -71.5}, {73.5, -61.9}, {79.9, -47.2}, {88, -24.8}, {96, 0}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{67, 22}, {96, 6}}, lineColor = {160, 160, 164}, textString = "time"), Line(points = {{-64, -30}, {-64, 0}}, color = {192, 192, 192}), Text(extent = {{-58, -42}, {-58, -32}}, textString = "delayTime", lineColor = {0, 0, 255}), Line(points = {{-94, -26}, {-80, -26}}, color = {192, 192, 192}), Line(points = {{-64, -26}, {-50, -26}}, color = {192, 192, 192}), Polygon(points = {{-80, -26}, {-88, -24}, {-88, -28}, {-80, -26}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Polygon(points = {{-56, -24}, {-64, -26}, {-56, -28}, {-56, -24}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}));
      end FixedDelay;

      block PadeDelay "Pade approximation of delay block with fixed DelayTime"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter SI.Time delayTime(start = 1) "Delay time of output with respect to input signal";
        parameter Integer n(min = 1) = 1 "Order of Pade approximation";
        parameter Integer m(min = 1, max = n) = n "Order of numerator";
      protected
        Real x1dot "Derivative of first state of TransferFcn";
        Real xn "Highest order state of TransferFcn";
        Real a[n + 1];
        Real b[m + 1];
      public
        final output Real x[n] "State of transfer function from controller canonical form";
      protected
        function padeCoefficients
          extends Modelica.Icons.Function;
          input Real T "delay time";
          input Integer n "order of denominator";
          input Integer m "order of numerator";
          output Real b[m + 1] "numerator coefficients of transfer function";
          output Real a[n + 1] "denominator coefficients of transfer function";
        protected
          Real nm;
        algorithm
          a[1] := 1;
          b[1] := 1;
          nm := n + m;
          for i in 1:n loop
            a[i + 1] := a[i] * (T * ((n - i + 1) / (nm - i + 1)) / i);
            if i <= m then
              b[i + 1] := -b[i] * (T * ((m - i + 1) / (nm - i + 1)) / i);
            end if;
          end for;
          b := b[m + 1:(-1):1];
          a := a[n + 1:(-1):1];
        end padeCoefficients;
      equation
        (b, a) = padeCoefficients(delayTime, n, m);
        [der(x); xn] = [x1dot; x];
        [u] = transpose([a]) * [x1dot; x];
        [y] = transpose([zeros(n - m, 1); b]) * [x1dot; x];
      initial equation
        x[n] = u;
        annotation(
          Documentation(info = "<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
<p>
The delay is approximated by a Pade approximation, i.e., by
a transfer function
</p>
<pre>
           b[1]*s^m + b[2]*s^[m-1] + ... + b[m+1]
   y(s) = --------------------------------------------- * u(s)
           a[1]*s^n + a[2]*s^[n-1] + ... + a[n+1]
</pre>
<p>
where the coefficients b[:] and a[:] are calculated such that the
coefficients of the Taylor expansion of the delay exp(-T*s) around s=0
are identical upto order n+m.
</p>
<p>
The main advantage of this approach is that the delay is
approximated by a linear differential equation system, which
is continuous and continuously differentiable. For example, it
is uncritical to linearize a system containing a Pade-approximated
delay.
</p>
<p>
The standard text book version uses order \"m=n\", which is
also the default setting of this block. The setting
\"m=n-1\" may yield a better approximation in certain cases.
</p>
<h5>Literature:</h5>
<p>Otto Foellinger: Regelungstechnik, 8. Auflage,
chapter 11.9, page 412-414, Huethig Verlag Heidelberg, 1994
</p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(extent = {{8.0, -142.0}, {8.0, -102.0}}, textString = "delayTime=%delayTime"), Line(points = {{-94.0, 0.0}, {-82.7, 34.2}, {-75.5, 53.1}, {-69.1, 66.4}, {-63.4, 74.6}, {-57.8, 79.1}, {-52.2, 79.8}, {-46.6, 76.6}, {-40.9, 69.7}, {-35.3, 59.4}, {-28.9, 44.1}, {-20.83, 21.2}, {-3.9, -30.8}, {3.3, -50.2}, {9.7, -64.2}, {15.3, -73.1}, {21.0, -78.4}, {26.6, -80.0}, {32.2, -77.6}, {37.9, -71.5}, {43.5, -61.9}, {49.9, -47.2}, {58.0, -24.8}, {66.0, 0.0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Line(points = {{-72.0, 0.0}, {-60.7, 34.2}, {-53.5, 53.1}, {-47.1, 66.4}, {-41.4, 74.6}, {-35.8, 79.1}, {-30.2, 79.8}, {-24.6, 76.6}, {-18.9, 69.7}, {-13.3, 59.4}, {-6.9, 44.1}, {1.17, 21.2}, {18.1, -30.8}, {25.3, -50.2}, {31.7, -64.2}, {37.3, -73.1}, {43.0, -78.4}, {48.6, -80.0}, {54.2, -77.6}, {59.9, -71.5}, {65.5, -61.9}, {71.9, -47.2}, {80.0, -24.8}, {88.0, 0.0}}, color = {160, 160, 164}, smooth = Smooth.Bezier), Text(lineColor = {160, 160, 164}, extent = {{-10.0, 38.0}, {100.0, 100.0}}, textString = "m=%m"), Text(lineColor = {160, 160, 164}, extent = {{-98.0, -96.0}, {6.0, -34.0}}, textString = "n=%n")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, 80}, {-88, 80}}, color = {192, 192, 192}), Line(points = {{-80, -80}, {-88, -80}}, color = {192, 192, 192}), Line(points = {{-80, -88}, {-80, 86}}, color = {192, 192, 192}), Text(extent = {{-75, 98}, {-46, 78}}, lineColor = {0, 0, 255}, textString = "outPort"), Polygon(points = {{-80, 96}, {-86, 80}, {-74, 80}, {-80, 96}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-80, 0}, {-68.7, 34.2}, {-61.5, 53.1}, {-55.1, 66.4}, {-49.4, 74.6}, {-43.8, 79.1}, {-38.2, 79.8}, {-32.6, 76.6}, {-26.9, 69.7}, {-21.3, 59.4}, {-14.9, 44.1}, {-6.83, 21.2}, {10.1, -30.8}, {17.3, -50.2}, {23.7, -64.2}, {29.3, -73.1}, {35, -78.4}, {40.6, -80}, {46.2, -77.6}, {51.9, -71.5}, {57.5, -61.9}, {63.9, -47.2}, {72, -24.8}, {80, 0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Text(extent = {{-24, 98}, {-2, 78}}, lineColor = {0, 0, 0}, textString = "inPort"), Line(points = {{-64, 0}, {-52.7, 34.2}, {-45.5, 53.1}, {-39.1, 66.4}, {-33.4, 74.6}, {-27.8, 79.1}, {-22.2, 79.8}, {-16.6, 76.6}, {-10.9, 69.7}, {-5.3, 59.4}, {1.1, 44.1}, {9.17, 21.2}, {26.1, -30.8}, {33.3, -50.2}, {39.7, -64.2}, {45.3, -73.1}, {51, -78.4}, {56.6, -80}, {62.2, -77.6}, {67.9, -71.5}, {73.5, -61.9}, {79.9, -47.2}, {88, -24.8}, {96, 0}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{67, 22}, {96, 6}}, lineColor = {160, 160, 164}, textString = "time"), Line(points = {{-64, -30}, {-64, 0}}, color = {192, 192, 192}), Text(extent = {{-58, -42}, {-58, -32}}, textString = "delayTime", lineColor = {0, 0, 255}), Line(points = {{-94, -26}, {-80, -26}}, color = {192, 192, 192}), Line(points = {{-64, -26}, {-50, -26}}, color = {192, 192, 192}), Polygon(points = {{-80, -26}, {-88, -24}, {-88, -28}, {-80, -26}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Polygon(points = {{-56, -24}, {-64, -26}, {-56, -28}, {-56, -24}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid)}));
      end PadeDelay;

      block VariableDelay "Delay block with variable DelayTime"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Real delayMax(min = 0, start = 1) "maximum delay time";
        Modelica.Blocks.Interfaces.RealInput delayTime annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}, rotation = 0)));
      equation
        y = delay(u, delayTime, delayMax);
        annotation(
          Documentation(info = "<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
<p>
where delayTime is an additional input signal which must follow
the following relationship:
</p>
<pre>  0 &le; delayTime &le; delayMax
</pre>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100.0, -100.0}, {100.0, 100.0}}, initialScale = 0.1), graphics = {Text(extent = {{-100.0, -148.0}, {100.0, -108.0}}, textString = "delayMax=%delayMax"), Line(points = {{-92.0, 0.0}, {-80.7, 34.2}, {-73.5, 53.1}, {-67.1, 66.4}, {-61.4, 74.6}, {-55.8, 79.1}, {-50.2, 79.8}, {-44.6, 76.6}, {-38.9, 69.7}, {-33.3, 59.4}, {-26.9, 44.1}, {-18.83, 21.2}, {-1.9, -30.8}, {5.3, -50.2}, {11.7, -64.2}, {17.3, -73.1}, {23.0, -78.4}, {28.6, -80.0}, {34.2, -77.6}, {39.9, -71.5}, {45.5, -61.9}, {51.9, -47.2}, {60.0, -24.8}, {68.0, 0.0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Line(points = {{-64.0, 0.0}, {-52.7, 34.2}, {-45.5, 53.1}, {-39.1, 66.4}, {-33.4, 74.6}, {-27.8, 79.1}, {-22.2, 79.8}, {-16.6, 76.6}, {-10.9, 69.7}, {-5.3, 59.4}, {1.1, 44.1}, {9.17, 21.2}, {26.1, -30.8}, {33.3, -50.2}, {39.7, -64.2}, {45.3, -73.1}, {51.0, -78.4}, {56.6, -80.0}, {62.2, -77.6}, {67.9, -71.5}, {73.5, -61.9}, {79.9, -47.2}, {88.0, -24.8}, {96.0, 0.0}}, smooth = Smooth.Bezier), Polygon(fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}, fillColor = {0, 0, 127}, points = {{6.0, 4.0}, {-14.0, -2.0}, {-6.0, -12.0}, {6.0, 4.0}}), Line(color = {0, 0, 127}, points = {{-100.0, -60.0}, {-76.0, -60.0}, {-8.0, -6.0}})}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-80, 96}, {-86, 80}, {-74, 80}, {-80, 96}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{-69, 98}, {-40, 78}}, lineColor = {0, 0, 255}, textString = "outPort"), Line(points = {{-64, 0}, {-52.7, 34.2}, {-45.5, 53.1}, {-39.1, 66.4}, {-33.4, 74.6}, {-27.8, 79.1}, {-22.2, 79.8}, {-16.6, 76.6}, {-10.9, 69.7}, {-5.3, 59.4}, {1.1, 44.1}, {9.17, 21.2}, {26.1, -30.8}, {33.3, -50.2}, {39.7, -64.2}, {45.3, -73.1}, {51, -78.4}, {56.6, -80}, {62.2, -77.6}, {67.9, -71.5}, {73.5, -61.9}, {79.9, -47.2}, {88, -24.8}, {96, 0}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Line(points = {{-80, 0}, {-68.7, 34.2}, {-61.5, 53.1}, {-55.1, 66.4}, {-49.4, 74.6}, {-43.8, 79.1}, {-38.2, 79.8}, {-32.6, 76.6}, {-26.9, 69.7}, {-21.3, 59.4}, {-14.9, 44.1}, {-6.83, 21.2}, {10.1, -30.8}, {17.3, -50.2}, {23.7, -64.2}, {29.3, -73.1}, {35, -78.4}, {40.6, -80}, {46.2, -77.6}, {51.9, -71.5}, {57.5, -61.9}, {63.9, -47.2}, {72, -24.8}, {80, 0}}, color = {0, 0, 127}, smooth = Smooth.Bezier), Line(points = {{-100, 0}, {84, 0}}, color = {192, 192, 192}), Polygon(points = {{100, 0}, {84, 6}, {84, -6}, {100, 0}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Text(extent = {{67, 22}, {96, 6}}, lineColor = {160, 160, 164}, textString = "time"), Text(extent = {{-58, -42}, {-58, -32}}, textString = "delayTime", lineColor = {0, 0, 255}), Line(points = {{-80, -88}, {-80, 86}}, color = {192, 192, 192}), Text(extent = {{-24, 98}, {-2, 78}}, lineColor = {0, 0, 0}, textString = "inPort"), Polygon(points = {{-80, -26}, {-88, -24}, {-88, -28}, {-80, -26}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Polygon(points = {{-56, -24}, {-64, -26}, {-56, -28}, {-56, -24}}, lineColor = {192, 192, 192}, fillColor = {192, 192, 192}, fillPattern = FillPattern.Solid), Line(points = {{-64, -26}, {-50, -26}}, color = {192, 192, 192}), Line(points = {{-94, -26}, {-80, -26}}, color = {192, 192, 192}), Line(points = {{-100, -60}, {-70, -60}, {-64, -44}}, arrow = {Arrow.None, Arrow.Filled}, color = {0, 0, 127}), Line(points = {{-64, -30}, {-64, 0}}, color = {192, 192, 192})}));
      end VariableDelay;
      annotation(
        Documentation(info = "<html>
<p>
This package contains <b>discontinuous</b> and
<b>non-differentiable, algebraic</b> input/output blocks.
</p>
</html>", revisions = "<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       New block VariableLimiter added.
<li><i>August 22, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.
</li>
</ul>
</html>"),
        Icon(graphics = {Line(points = {{-80, -66}, {-26, -66}, {28, 52}, {88, 52}}, color = {95, 95, 95})}));
    end Nonlinear;

    package Routing "Library of blocks to combine and extract signals"
      extends Modelica.Icons.Package;

      block Replicator "Signal replicator"
        extends Modelica.Blocks.Interfaces.SIMO;
      equation
        y = fill(u, nout);
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-100, 0}, {-6, 0}}, color = {0, 0, 127}), Line(points = {{100, 0}, {10, 0}}, color = {0, 0, 127}), Line(points = {{0, 0}, {100, 10}}, color = {0, 0, 127}), Line(points = {{0, 0}, {100, -10}}, color = {0, 0, 127}), Ellipse(extent = {{-14, 16}, {16, -14}}, lineColor = {0, 0, 0}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid)}),
          Documentation(info = "<html>
<p>
This block replicates the input signal to an array of <code>nout</code> identical output signals.
</p>
</html>"));
      end Replicator;

      block ExtractSignal "Extract signals from an input signal vector"
        extends Modelica.Blocks.Interfaces.MIMO;
        parameter Integer extract[nout] = 1:nout "Extracting vector";
      equation
        for i in 1:nout loop
          y[i] = u[extract[i]];
        end for;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-90, 51}, {-50, -49}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Rectangle(extent = {{50, 50}, {90, -50}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Polygon(points = {{-94.4104, 1.90792}, {-94.4104, -2.09208}, {-90.4104, -0.0920762}, {-94.4104, 1.90792}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Line(points = {{-72, 2}, {-60.1395, 12.907}, {-49.1395, 12.907}}, color = {0, 0, 127}), Line(points = {{-73, 4}, {-59, 40}, {-49, 40}}, color = {0, 0, 127}), Line(points = {{-113, 0}, {-76.0373, -0.0180176}}, color = {0, 0, 127}), Ellipse(extent = {{-81.0437, 4.59255}, {-71.0437, -4.90745}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Line(points = {{-73, -5}, {-60, -40}, {-49, -40}}, color = {0, 0, 127}), Line(points = {{-72, -2}, {-60.0698, -12.907}, {-49.0698, -12.907}}, color = {0, 0, 127}), Polygon(points = {{-48.8808, -11}, {-48.8808, -15}, {-44.8808, -13}, {-48.8808, -11}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Line(points = {{-46, 13}, {-35, 13}, {35, -30}, {45, -30}}, color = {0, 0, 127}), Line(points = {{-45, 40}, {-35, 40}, {35, 0}, {44, 0}}, color = {0, 0, 127}), Line(points = {{-45, -40}, {-34, -40}, {35, 30}, {44, 30}}, color = {0, 0, 127}), Polygon(points = {{-49, 42}, {-49, 38}, {-45, 40}, {-49, 42}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Polygon(points = {{-48.8728, -38.0295}, {-48.8728, -42.0295}, {-44.8728, -40.0295}, {-48.8728, -38.0295}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Polygon(points = {{-48.9983, 14.8801}, {-48.9983, 10.8801}, {-44.9983, 12.8801}, {-48.9983, 14.8801}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Ellipse(extent = {{69.3052, 4.12743}, {79.3052, -5.37257}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Line(points = {{80, 0}, {100, 0}}, color = {0, 0, 127}), Polygon(points = {{43.1618, 32.3085}, {43.1618, 28.3085}, {47.1618, 30.3085}, {43.1618, 32.3085}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Polygon(points = {{43.2575, 1.80443}, {43.2575, -2.19557}, {47.2575, -0.195573}, {43.2575, 1.80443}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Polygon(points = {{43.8805, -28.1745}, {43.8805, -32.1745}, {47.8805, -30.1745}, {43.8805, -28.1745}}, fillColor = {0, 0, 127}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 127}), Line(points = {{48, 0}, {70, 0}}, color = {0, 0, 127}), Line(points = {{47, 30}, {60, 30}, {73, 3}}, color = {0, 0, 127}), Line(points = {{49, -30}, {60, -30}, {74, -4}}, color = {0, 0, 127}), Text(extent = {{-150, -150}, {150, -110}}, lineColor = {0, 0, 0}, textString = "extract=%extract")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-90, 50}, {-50, -50}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Rectangle(extent = {{50, 50}, {90, -50}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-94.4104, 1.90792}, {-94.4104, -2.09208}, {-90.4104, -0.0920762}, {-94.4104, 1.90792}}, lineColor = {0, 0, 255}, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid), Line(points = {{-72, 2}, {-60.1395, 12.907}, {-49.1395, 12.907}}, color = {0, 0, 255}), Line(points = {{-73, 4}, {-59, 40}, {-49, 40}}, color = {0, 0, 255}), Line(points = {{-112, 0}, {-75.0373, -0.0180176}}, color = {0, 0, 255}), Ellipse(extent = {{-80.0437, 4.59255}, {-70.0437, -4.90745}}, lineColor = {0, 0, 255}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid), Line(points = {{-73, -5}, {-60, -40}, {-49, -40}}, color = {0, 0, 255}), Line(points = {{-72, -2}, {-60.0698, -12.907}, {-49.0698, -12.907}}, color = {0, 0, 255}), Polygon(points = {{-48.8808, -11}, {-48.8808, -15}, {-44.8808, -13}, {-48.8808, -11}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-46, 13}, {-35, 13}, {35, -30}, {45, -30}}, color = {0, 0, 255}), Line(points = {{-45, 40}, {-35, 40}, {35, 0}, {44, 0}}, color = {0, 0, 255}), Line(points = {{-45, -40}, {-34, -40}, {35, 30}, {44, 30}}, color = {0, 0, 255}), Polygon(points = {{-49, 42}, {-49, 38}, {-45, 40}, {-49, 42}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-48.8728, -38.0295}, {-48.8728, -42.0295}, {-44.8728, -40.0295}, {-48.8728, -38.0295}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-48.9983, 14.8801}, {-48.9983, 10.8801}, {-44.9983, 12.8801}, {-48.9983, 14.8801}}, lineColor = {0, 0, 255}