(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7320,        174]*)
(*NotebookOutlinePosition[      7986,        197]*)
(*  CellTagsIndexPosition[      7942,        193]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    FormBox[
      RowBox[{\(Off[General::spell1];\), "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(workPATH\  = \ "\<C:\OpenModelica\>";\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(drmodelicaPATH\  = \ "\<C:\OpenModelica\DrModelica\>";\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[
      RowBox[{
        FormBox[\(outputName\  = \ "\<DrModelicaFullForm\>";\),
          "TraditionalForm"], "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(SetDirectory[workPATH];\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(DeleteDirectory[outputName, \ DeleteContents -> True];\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[
      RowBox[{
        FormBox[\(CreateDirectory[outputName];\),
          "TraditionalForm"], "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(SetDirectory[drmodelicaPATH];\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(exportedRootDir\  = \
          StringJoin[workPATH, \ "\<\\\>", \ outputName];\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(oldFilename\  = \ "\<DrModelica.nb\>";\),
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(newFilename\  = \ ToFileName[exportedRootDir, \ oldFilename];\),
       TraditionalForm], "\[IndentingNewLine]",
    FormBox[
      RowBox[{
        RowBox[{

          FormBox[\(WriteString[OpenWrite[newFilename], \
              FullForm[ReadList[oldFilename]]]\),
            "TraditionalForm"], ";"}], "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[
      RowBox[{\(dirVector\  = \ {\ "\<AccessControl\>", \ "\<Algorithms\>", \ \
"\<AnnUnitsQuant\>", \ "\<ApplicationEx\>", "\<Arrays\>", \ "\<Circuits\>", \ \
"\<Classes\>", \ "\<CompConn\>", \ "\<DiscreteHybrid\>", \ "\<Equations\>", \ \
"\<Functions\>", \ "\<Generic\>", \ "\<Inheritance\>", \ "\<InherMod\>", \ \
"\<LawsOfNature\>", \ "\<LitOpExp\>", \ "\<Packages\>", \ \ "\<QuickTour\>"\ \
, \ "\<Redeclaration\>", \ "\<SystemMod\>", \ "\<TypeSubtype\>", \ \
"\<Variables\>"};\), "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[
      RowBox[{
        RowBox[{"While", "[",

          RowBox[{\(Length[dirVector]\  \[NotEqual] \ 0\), ",",
            "\[IndentingNewLine]",

            RowBox[{\(dirname\  = \
                StringJoin["\<\\\>", \ First[dirVector]]\), ";",
              "\[IndentingNewLine]", \(dirVector\  = \ Rest[dirVector]\), ";",
               "\[IndentingNewLine]",
              "\[IndentingNewLine]", \(SetDirectory[workPATH]\), ";",
              "\[IndentingNewLine]", \(CreateDirectory[
                StringJoin[outputName, \ dirname]]\), ";",
              "\[IndentingNewLine]",
              "\[IndentingNewLine]", \(SetDirectory[
                StringJoin[drmodelicaPATH, \ dirname]]\), ";",
              "\[IndentingNewLine]", \(notebookFiles\  = \
                FileNames["\<*.nb\>"]\), ";", "\[IndentingNewLine]",

              FormBox[\(exportedRootDir\  = \
                  StringJoin[workPATH, \ "\<\\\>", \
                    outputName, \ \ dirname]\),
                "TraditionalForm"], ";", "\[IndentingNewLine]",
              "\[IndentingNewLine]", \(While[
                Length[notebookFiles]\  \[NotEqual] \
                  0, \[IndentingNewLine]oldFilename\  = \
                  First[notebookFiles]; \[IndentingNewLine]notebookFiles\  = \
\ Rest[notebookFiles]; \[IndentingNewLine]newFilename\  = \
                  ToFileName[exportedRootDir, \
                    oldFilename]; \
\[IndentingNewLine]\[IndentingNewLine]WriteString[OpenWrite[newFilename], \
                  FullForm[ReadList[oldFilename]]];\[IndentingNewLine]]\)}]}],
           "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(tmp\  = \ "\<END\>"\), TraditionalForm]}], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\)\)], \
"Input"],

Cell[BoxData[{
    FormBox[
      RowBox[{\(Off[General::spell1];\), "\[IndentingNewLine]"}],
      TraditionalForm], "\n",
    FormBox[\(workPATH\  = \ "\<C:\OpenModelica\>";\), TraditionalForm], "\n",

    FormBox[\(drmodelicaPATH\  = \ "\<C:\OpenModelica\DrModelica\>";\),
      TraditionalForm], "\n",
    FormBox[
      RowBox[{
        FormBox[\(outputName\  = \ "\<DrModelicaFullForm\>";\),
          "TraditionalForm"], "\[IndentingNewLine]"}], TraditionalForm], "\n",

    FormBox[
      RowBox[{\(SetDirectory[workPATH];\), "\n"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(SetDirectory[drmodelicaPATH];\), TraditionalForm], "\n",
    FormBox[\(exportedRootDir\  = \
          StringJoin[workPATH, \ "\<\\\>", \ outputName];\),
      TraditionalForm], "\n",
    FormBox[\(oldFilename\  = \ "\<DrModelica.nb\>";\),
      TraditionalForm], "\n",
    FormBox[\(newFilename\  = \ ToFileName[exportedRootDir, \ oldFilename];\),
       TraditionalForm], "\n",
    FormBox[
      RowBox[{
        RowBox[{

          FormBox[\(WriteString[OpenWrite[newFilename], \
              FullForm[ReadList[oldFilename]]]\),
            "TraditionalForm"], ";"}], "\[IndentingNewLine]"}],
      TraditionalForm], "\[IndentingNewLine]",
    FormBox[\(tmp = \ "\<End\>"\), TraditionalForm]}], "Input"]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{771, 589},
WindowMargins->{{Automatic, 74}, {32, Automatic}},
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 4111, 83, 917, "Input"],
Cell[5868, 136, 102, 2, 77, "Input"],
Cell[5973, 140, 1343, 32, 329, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

