<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:y="http://www.yworks.com/xml/graphml" xmlns:yed="http://www.yworks.com/xml/yed/3" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd">
	<xsl:import href="TransGraphMlToPnml1.xsl"/>
	<xsl:output encoding="ISO-8859-1" indent="yes" method="xml" />

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

	<!-- Convert threadInfo -->
	<xsl:template match="/*/net/threadInfo">
		<xsl:param name="paramThInfoThIdx" select="@idx" />
		<xsl:param name="paramThInfoTaskIdx" select="@nodeCount" />
		<xsl:param name="paramThInfoTransitionId">Comm_<xsl:value-of select="$paramThInfoThIdx" />_<xsl:value-of select="$paramThInfoTaskIdx" /></xsl:param>
		<xsl:param name="paramThInfoEscapeNodeId">escape_<xsl:value-of select="$paramThInfoThIdx" /></xsl:param>
		<blubb/>
		<!-- Add an escape state and edge to init transition -->
		<xsl:call-template name="createPlace">
			<xsl:with-param name="paramPosX" select="$paramThInfoThIdx * $paramStateSpaceX + $paramOffsetLeft" />
			<xsl:with-param name="paramPosY" select="$paramThInfoTaskIdx * $paramStateSpaceY + 250" />
			<xsl:with-param name="paramPlaceId" select="$paramThInfoEscapeNodeId" />
			<xsl:with-param name="paramPlaceName" select="$paramThInfoEscapeNodeId" />
			<xsl:with-param name="paramPlaceMarking" select="0" />
		</xsl:call-template>
		<xsl:call-template name="createArc">
			<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$paramThInfoEscapeNodeId" />_1</xsl:with-param>
			<xsl:with-param name="paramArcTarget" select="$paramThInfoEscapeNodeId" />
			<xsl:with-param name="paramArcSource" select="$paramThInfoTransitionId" />
		</xsl:call-template>
		<!-- Arc with curvePoints -->
 		<arc>
			<xsl:attribute name="id">PT_<xsl:value-of select="$paramThInfoEscapeNodeId" /></xsl:attribute>
			<xsl:attribute name="source"><xsl:value-of select="$paramThInfoEscapeNodeId" /></xsl:attribute>
			<xsl:attribute name="target"><xsl:value-of select="$paramInitTransId" /></xsl:attribute>
			<graphics />
			<inscription>
				<value>Default,1</value>
				<graphics />
			</inscription>
			<tagged>
				<value>false</value>
			</tagged>
			<arcpath id="000" x="20" curvePoint="true">
				<xsl:attribute name="y"><xsl:value-of select="$paramThInfoTaskIdx * $paramStateSpaceY + 120" /></xsl:attribute>
			</arcpath>
			<arcpath id="001" x="20" y="40" curvePoint="true" />
			<type value="normal" />
		</arc>
	</xsl:template>
</xsl:stylesheet>