<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:java="http://xml.apache.org/xalan/java" xmlns:javaHelper="main.TransformationHelper" xmlns:d="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:y="http://www.yworks.com/xml/graphml" xmlns:yed="http://www.yworks.com/xml/yed/3" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd">
	<xsl:output encoding="ISO-8859-1" indent="yes" method="xml" />

	<xsl:param name="paramThId" select="/*/d:key[@attr.name='ThreadId']/@id" />
	<xsl:param name="paramTaskNum" select="/*/d:key[@attr.name='TaskNumber']/@id" />
	<xsl:param name="paramTaskId" select="/*/d:key[@attr.name='TaskID']/@id" />
	<xsl:param name="paramOffsetTop">30</xsl:param>
	<xsl:param name="paramOffsetLeft">60</xsl:param>
	<xsl:param name="paramStateSpaceX">250</xsl:param>
	<xsl:param name="paramStateSpaceY">200</xsl:param>
	<xsl:param name="paramInitTransId">T_init</xsl:param>

	<xsl:template match="*">
		<xsl:apply-templates select="d:graph" />
	</xsl:template>

	<xsl:template match="/*/d:key">
	</xsl:template>
	<!-- Convert Graph -->
	<xsl:template match="d:graph">
		<pnml>
			<net type="P/T net">
				<xsl:attribute name="id">Net-<xsl:value-of select="@id" /></xsl:attribute>
				<token id="Default" enabled="true" red="0" green="0" blue="0" />

				<!-- Add Initial transition -->
				<xsl:call-template name="createTransition">
					<xsl:with-param name="paramPosX" select="400" />
					<xsl:with-param name="paramPosY" select="30" />
					<xsl:with-param name="paramTransId" select="$paramInitTransId" />
					<xsl:with-param name="paramTransName" select="$paramInitTransId" />
				</xsl:call-template>
				<xsl:apply-templates select="d:node" />
				<xsl:value-of select="javaHelper:GetThreadNodeCountInfo()" disable-output-escaping="yes" />
			</net>
		</pnml>
	</xsl:template>

	<!-- Handle Node -->
	<xsl:template match="d:node">
		<xsl:param name="paramNodeTaskId" select="d:data[@key=$paramTaskId]" />
		<xsl:param name="paramNodeThId" select="d:data[@key=$paramThId]" />
		<xsl:param name="paramNodeThIdx" select="substring($paramNodeThId,4)" />
		<xsl:param name="paramNodeTaskNum" select="d:data[@key=$paramTaskNum]" />
		<xsl:param name="paramNodeId" select="@id" />

		<xsl:param name="param_PN_St_Id">T_St_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_St_Name">St_<xsl:value-of select="$paramNodeTaskId" /></xsl:param>
		<xsl:param name="param_PN_En_Id">T_En_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_En_Name">En_<xsl:value-of select="$paramNodeTaskId" /></xsl:param>
		<xsl:param name="param_PN_CalcTransitionId">CalcFn_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_CalcTransitionName">CalcFn_<xsl:value-of select="$paramNodeTaskId" /></xsl:param>
		<xsl:param name="param_PN_CommTransitionId">Comm_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_CommTransitionName">Comm_<xsl:value-of select="$paramNodeTaskId" /></xsl:param>

		<xsl:variable name="tmp_var">
			<xsl:value-of select="javaHelper:NodeAdded($paramNodeThIdx, $paramNodeTaskNum)" />
		</xsl:variable>

		<xsl:param name="param_PN_StartPlaceId">P_start_<xsl:value-of select="$paramNodeThIdx" /><xsl:value-of select="$tmp_var" /></xsl:param>
		<xsl:param name="param_PN_StartPlaceName">St_Th_<xsl:value-of select="$paramNodeThIdx" /><xsl:value-of select="$tmp_var" /></xsl:param>
		<xsl:param name="param_PN_StartTransitionId">T_<xsl:value-of select="$paramNodeThIdx" />_0</xsl:param>

		<!-- Create the places and the transition for the task and connect them -->
		<xsl:call-template name="createPlace">
			<xsl:with-param name="paramPosX" select="$paramNodeThIdx * $paramStateSpaceX + $paramOffsetLeft" />
			<xsl:with-param name="paramPosY" select="($paramNodeTaskNum * $paramStateSpaceY) + $paramOffsetTop" />
			<xsl:with-param name="paramPlaceId" select="$param_PN_St_Id" />
			<xsl:with-param name="paramPlaceName" select="$param_PN_St_Name" />
			<xsl:with-param name="paramPlaceMarking" select="0" />
		</xsl:call-template>
		
		<xsl:call-template name="createTransition">
			<xsl:with-param name="paramPosX" select="($paramNodeThIdx * $paramStateSpaceX) + $paramOffsetLeft" />
			<xsl:with-param name="paramPosY" select="($paramNodeTaskNum * $paramStateSpaceY) + 30 + $paramOffsetTop" />
			<xsl:with-param name="paramTransId" select="$param_PN_CalcTransitionId" />
			<xsl:with-param name="paramTransName" select="$param_PN_CalcTransitionName" />
		</xsl:call-template>

		<xsl:call-template name="createPlace">
			<xsl:with-param name="paramPosX" select="$paramNodeThIdx * $paramStateSpaceX + $paramOffsetLeft" />
			<xsl:with-param name="paramPosY" select="($paramNodeTaskNum * $paramStateSpaceY) + 60 + $paramOffsetTop" />
			<xsl:with-param name="paramPlaceId" select="$param_PN_En_Id" />
			<xsl:with-param name="paramPlaceName" select="$param_PN_En_Name" />
			<xsl:with-param name="paramPlaceMarking" select="0" />
		</xsl:call-template>
		
		<xsl:call-template name="createTransition">
			<xsl:with-param name="paramPosX" select="($paramNodeThIdx * $paramStateSpaceX) + $paramOffsetLeft" />
			<xsl:with-param name="paramPosY" select="($paramNodeTaskNum * $paramStateSpaceY) + 130 + $paramOffsetTop" />
			<xsl:with-param name="paramTransId" select="$param_PN_CommTransitionId" />
			<xsl:with-param name="paramTransName" select="$param_PN_CommTransitionName" />
		</xsl:call-template>
		
 		<xsl:call-template name="createArc">
			<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$paramNodeTaskId" />_1</xsl:with-param>
			<xsl:with-param name="paramArcSource" select="$param_PN_St_Id" />
			<xsl:with-param name="paramArcTarget" select="$param_PN_CalcTransitionId" />
		</xsl:call-template>
 		<xsl:call-template name="createArc">
			<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$paramNodeTaskId" />_2</xsl:with-param>
			<xsl:with-param name="paramArcSource" select="$param_PN_CalcTransitionId" />
			<xsl:with-param name="paramArcTarget" select="$param_PN_En_Id" />
		</xsl:call-template>
 		<xsl:call-template name="createArc">
			<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$paramNodeTaskId" />_3</xsl:with-param>
			<xsl:with-param name="paramArcSource" select="$param_PN_En_Id" />
			<xsl:with-param name="paramArcTarget" select="$param_PN_CommTransitionId" />
		</xsl:call-template>
		
		<!--Check if the task is the first one of the thread -->
		<xsl:if test="$paramNodeTaskNum = 1">
		
			<!-- Create start place -->
			<xsl:call-template name="createPlace">
				<xsl:with-param name="paramPosX" select="$paramNodeThIdx * $paramStateSpaceX + $paramOffsetLeft" />
				<xsl:with-param name="paramPosY" select="100" />
				<xsl:with-param name="paramPlaceId" select="$param_PN_StartPlaceId" />
				<xsl:with-param name="paramPlaceName" select="$param_PN_StartPlaceName" />
				<xsl:with-param name="paramPlaceMarking" select="1" />
			</xsl:call-template>
			
			<!-- Create start transition -->
			<xsl:call-template name="createTransition">
				<xsl:with-param name="paramPosX" select="$paramNodeThIdx * $paramStateSpaceX + $paramOffsetLeft" />
				<xsl:with-param name="paramPosY" select="130" />
				<xsl:with-param name="paramTransId" select="$param_PN_StartTransitionId" />
				<xsl:with-param name="paramTransName" select="$param_PN_StartTransitionId" />
			</xsl:call-template>
			
			<!-- Connect them -->
 			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_start_<xsl:value-of select="$paramNodeThIdx" />_0</xsl:with-param>
				<xsl:with-param name="paramArcTarget" select="$param_PN_StartPlaceId" />
				<xsl:with-param name="paramArcSource" select="$paramInitTransId" />
			</xsl:call-template>
			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_start_<xsl:value-of select="$paramNodeThIdx" />_1</xsl:with-param>
				<xsl:with-param name="paramArcTarget" select="$param_PN_StartTransitionId" />
				<xsl:with-param name="paramArcSource" select="$param_PN_StartPlaceId" />
			</xsl:call-template>
			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_start_<xsl:value-of select="$paramNodeThIdx" />_2</xsl:with-param>
				<xsl:with-param name="paramArcTarget" select="$param_PN_St_Id" />
				<xsl:with-param name="paramArcSource" select="$param_PN_StartTransitionId" />
			</xsl:call-template>
		</xsl:if>

 		<!-- Connect the task with the previous task of the same thread -->
		<xsl:if test="$paramNodeTaskNum &gt; 1">
			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_pre_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum -1" /></xsl:with-param>
				<xsl:with-param name="paramArcTarget" select="$param_PN_St_Id" />
				<xsl:with-param name="paramArcSource">Comm_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum -1" /></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
 		<!-- Add transitions to child-tasks -->
		<xsl:for-each select="/*/d:graph/d:edge[@source=$paramNodeId]">
			<xsl:call-template name="addChildTransition">
				<xsl:with-param name="paramNodeTaskId" select="$paramNodeTaskId" />
				<xsl:with-param name="paramNodeThIdx" select="$paramNodeThIdx" />
				<xsl:with-param name="paramNodeTaskNum" select="$paramNodeTaskNum" />
				<xsl:with-param name="paramTargetNodeId" select="@target" />
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="addChildTransition">
		<xsl:param name="paramNodeTaskId" />
		<xsl:param name="paramNodeThIdx" />
		<xsl:param name="paramNodeTaskNum" />
		<xsl:param name="paramTargetNodeId" />

		<xsl:param name="paramChildNode" select="/*/d:graph/d:node[@id=$paramTargetNodeId]" />
		<xsl:param name="paramChildNodeTaskId" select="$paramChildNode/d:data[@key=$paramTaskId]" />
		<xsl:param name="paramChildNodeThId" select="$paramChildNode/d:data[@key=$paramThId]" />
		<xsl:param name="paramChildNodeThIdx" select="substring($paramChildNodeThId,4)" />
		<xsl:param name="paramChildNodeTaskNum" select="$paramChildNode/d:data[@key=$paramTaskNum]" />
		<xsl:param name="param_PN_ChildNodeId">P_<xsl:value-of select="$paramChildNodeThIdx" />_<xsl:value-of select="$paramChildNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_ChildTransitionId">T_<xsl:value-of select="$paramChildNodeThIdx" />_<xsl:value-of select="$paramChildNodeTaskNum" /></xsl:param>
		<xsl:param name="param_PN_LockId">P_lock_(<xsl:value-of select="$paramNodeThIdx" />,<xsl:value-of select="$paramNodeTaskNum" />)_(<xsl:value-of select="$paramChildNodeThIdx" />,<xsl:value-of select="$paramChildNodeTaskNum" />)</xsl:param>
		<xsl:param name="param_PN_LockName">Lck_<xsl:value-of select="$paramNodeTaskId" />_<xsl:value-of select="$paramChildNodeTaskId" /></xsl:param>

		<!-- Add transition to all child-tasks handled by other threads or handled by the same thread but with a higher taskNum -->
		<xsl:if test="(($paramNodeThIdx != $paramChildNodeThIdx) or (($paramNodeThIdx = $paramChildNodeThIdx) and ($paramNodeTaskNum &gt; $paramChildNodeTaskNum)))">
			<xsl:if test="$paramNodeThIdx &lt; $paramChildNodeThIdx">
				<xsl:call-template name="createPlace">
					<xsl:with-param name="paramPosX" select="$paramNodeThIdx * $paramStateSpaceX + 160" />
					<xsl:with-param name="paramPosY" select="($paramNodeTaskNum) * $paramStateSpaceY + $paramOffsetTop + 30" />
					<xsl:with-param name="paramPlaceId" select="$param_PN_LockId" />
					<xsl:with-param name="paramPlaceName" select="$param_PN_LockName" />
					<xsl:with-param name="paramPlaceMarking" select="0" />
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$paramNodeThIdx &gt; $paramChildNodeThIdx">
				<xsl:call-template name="createPlace">
					<xsl:with-param name="paramPosX" select="($paramNodeThIdx * $paramStateSpaceX) -30" />
					<xsl:with-param name="paramPosY" select="($paramNodeTaskNum) * $paramStateSpaceY + $paramOffsetTop + 30" />
					<xsl:with-param name="paramPlaceId" select="$param_PN_LockId" />
					<xsl:with-param name="paramPlaceName" select="$param_PN_LockName" />
					<xsl:with-param name="paramPlaceMarking" select="0" />
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$paramNodeThIdx = $paramChildNodeThIdx">
				<xsl:call-template name="createPlace">
					<xsl:with-param name="paramPosX" select="($paramNodeThIdx * $paramStateSpaceX) -30" />
					<xsl:with-param name="paramPosY" select="($paramNodeTaskNum) * $paramStateSpaceY + $paramOffsetTop + 30" />
					<xsl:with-param name="paramPlaceId" select="$param_PN_LockId" />
					<xsl:with-param name="paramPlaceName" select="$param_PN_LockName" />
					<xsl:with-param name="paramPlaceMarking" select="0" />
				</xsl:call-template>
			</xsl:if>
 			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$param_PN_LockId" />_1</xsl:with-param>
				<xsl:with-param name="paramArcSource">CalcFn_<xsl:value-of select="$paramNodeThIdx" />_<xsl:value-of select="$paramNodeTaskNum" /></xsl:with-param>
				<xsl:with-param name="paramArcTarget" select="$param_PN_LockId" />
			</xsl:call-template>
  			<xsl:call-template name="createArc">
				<xsl:with-param name="paramArcId">PT_<xsl:value-of select="$param_PN_LockId" />_2</xsl:with-param>
				<xsl:with-param name="paramArcSource" select="$param_PN_LockId" />
				<xsl:with-param name="paramArcTarget">Comm_<xsl:value-of select="$paramChildNodeThIdx" />_<xsl:value-of select="$paramChildNodeTaskNum -1" /></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="createPlace">
		<xsl:param name="paramPosX" />
		<xsl:param name="paramPosY" />
		<xsl:param name="paramPlaceId" />
		<xsl:param name="paramPlaceName" />
		<xsl:param name="paramPlaceMarking" />
		
		<place>
			<xsl:attribute name="id"><xsl:value-of select="$paramPlaceId" /></xsl:attribute>
			<graphics>
				<position>
					<xsl:attribute name="x"><xsl:value-of select="$paramPosX" /></xsl:attribute>
					<xsl:attribute name="y"><xsl:value-of select="$paramPosY" /></xsl:attribute>
				</position>
			</graphics>
			<name>
				<value>
					<xsl:value-of select="$paramPlaceName" />
				</value>
				<graphics>
					<offset x="0.0" y="0.0" />
				</graphics>
			</name>
			<initialMarking>
				<value>Default,<xsl:value-of select="$paramPlaceMarking" /></value>
				<graphics>
					<offset x="0.0" y="0.0" />
				</graphics>
			</initialMarking>
			<capacity>
				<value>1</value>
			</capacity>
		</place>
	</xsl:template>
	
	<xsl:template name="createTransition">
		<xsl:param name="paramPosX" />
		<xsl:param name="paramPosY" />
		<xsl:param name="paramTransId" />
		<xsl:param name="paramTransName" />
	
		<transition>
			<xsl:attribute name="id"><xsl:value-of select="$paramTransId" /></xsl:attribute>
			<graphics>
				<position>
					<xsl:attribute name="x"><xsl:value-of select="$paramPosX" /></xsl:attribute>
					<xsl:attribute name="y"><xsl:value-of select="$paramPosY" /></xsl:attribute>
				</position>
			</graphics>
			<name>
				<value>
					<xsl:value-of select="$paramTransName" />
				</value>
			</name>
			<orientation>
				<value>90</value>
			</orientation>
			<rate>
				<value>1.0</value>
			</rate>
			<timed>
				<value>false</value>
			</timed>
			<infiniteServer>
				<value>false</value>
			</infiniteServer>
			<priority>
				<value>1</value>
			</priority>
		</transition>
	</xsl:template>
	
	<xsl:template name="createArc">
		<xsl:param name="paramArcId" />
		<xsl:param name="paramArcTarget" />
		<xsl:param name="paramArcSource" />
		<arc>
			<xsl:attribute name="id"><xsl:value-of select="$paramArcId" /></xsl:attribute>
			<xsl:attribute name="target"><xsl:value-of select="$paramArcTarget" /></xsl:attribute>
			<xsl:attribute name="source"><xsl:value-of select="$paramArcSource" /></xsl:attribute>
			<graphics />
			<inscription>
				<value>Default,1</value>
				<graphics />
			</inscription>
			<tagged>
				<value>false</value>
			</tagged>
			<type value="normal" />
		</arc>
	</xsl:template>
</xsl:stylesheet>