/* Copyright (c)2000 Linkping University Sweden, All Rights Reserved
/* Programming Environments Laboratory
*******************************************************************************
  File        : "modelicaXML.cpp"
  Author      : Adrian Pop 2003-10-25
  Description : Antlr Parser caller and XML serializer
-------------------------------------------------------------------------------
  Source:
  Revision:
  Author:	Adrian Pop
  Date:		2004-05-12
*******************************************************************************
*/


//**  HEADERS ************************************************************

// standard include files
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <fstream>

// ModelicaParser related include file 
// the following header files are automatically generated by the antlr parser (Do not modify them)
#include "Modelica_Lexer.hpp"
#include "Modelica_Parser.hpp"
#include "Modelica_Tree_Parser.hpp"
#include "Modelica_ParserTokenTypes.hpp"
#include "Modelica_Tree_ParserTokenTypes.hpp"
#include "parse_tree_dumper.hpp"

// antlr related include files
#include "antlr/AST.hpp"
#include "antlr/CommonAST.hpp"
#include "antlr/ASTFactory.hpp"
#include "MyAST.h"


using namespace std;

//-----------------------------------------------------------------------------
// func         : main function for the modelica optimizer
// author       : Adrian Pop 2003-10-25
// organization : Linkping University Sweden, Programming Environment Laboratory
//-----------------------------------------------------------------------------
// the function accept as argument a flattened modelica file ad will generate as output the corresponding C files 
// for the Modelica Simulator
int main( int argc, char* argv[] )
{
	ifstream file;
	//ofstream wfile;

	// check if the modelica file is present in the argument list
    if (argc != 2){
  		cerr << "Incorrect number of arguments\n";
  		return 1;
    }
    
	//open the file passed as an argument
    file.open(argv[1]);

	//if the file cannot be opened
    if (!file){
  		cerr << "Could not open file: " << argv[1] << "\n";
		getchar();
  		return 2;
     }
 
    try 
	{
	  antlr::ASTFactory my_factory("MyAST", MyAST::factory); 
	  modelica_lexer lexer(file);
	  lexer.setFilename(argv[1]);
	  modelica_parser parser(lexer);
	  parser.initializeASTFactory(my_factory);
	  parser.setASTFactory(&my_factory);
	  parser.stored_definition();
	  //wfile.open("output.txt");
	  //wfile << parser.getAST()->toStringList() << std::endl;
	  antlr::RefAST ast = parser.getAST();
	  //parse_tree_dumper dumper(std::cout);
	  //std::cout << std::flush;
	  if (ast) 
	    {
	      //dumper.dump(ast);
	      modelica_tree_parser walker;
		  walker.initializeASTFactory(my_factory);
		  walker.setASTFactory(&my_factory);
		  std::string xmlFile(argv[1]);
		  xmlFile += ".xml";
		  walker.stored_definition(RefMyAST(ast), xmlFile, argv[1]);
	    }
	  else
	    {
			//wfile << std::endl << "Parse error: <NULL> AST\n";
			std::cerr << std::endl << "Parse error: <NULL> AST\n";
	    }
	}
    catch(antlr::ANTLRException& e) 
	{
		std::cerr << "Parser/Lexer/Walker Exception: " << e.toString() << std::endl;
		file.close();
		std::cerr << "ERROR! File:" << argv[1] << std::endl;
		getchar();
		return EXIT_FAILURE;
	}
    catch(std::exception& e) 
	{
		std::cerr << "Exception: " << e.what() << std::endl;
		file.close();
		std::cerr << "ERROR! File:" << argv[1] << std::endl;
		getchar();
		return EXIT_FAILURE;
	}
  
    file.close();
	std::cout << "SUCCESS! File:" << argv[1] << std::endl;
	//wfile << std::endl << "SUCCESS! File:" << argv[1] << std::endl;
	//wfile.close();
    return EXIT_SUCCESS;
}