/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Main {
    public void simpleTransform(String sourcePath, String xsltPath, String resultDir) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            URL url = this.getClass().getResource(xsltPath);
            StreamSource xsl = new StreamSource(url.toExternalForm());
            Transformer transformer = tFactory.newTransformer(xsl);
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setParameter("encoding", "ISO-8859-1");
            transformer.transform(new StreamSource(new File(sourcePath)), new StreamResult(new File(resultDir)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("------");
        System.out.println("java -jar xxx.jar 'path to input graphML-file' 'path to output pnml-file'");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Number of arguments incorrect.");
            System.out.println("");
            Main.printUsage();
            return;
        }
        Main m = new Main();
        String firstTransFile = "/TransGraphMlToPnml1.xsl";
        String secondTransFile = "/TransGraphMlToPnml2.xsl";
        m.simpleTransform(args[0], firstTransFile, String.valueOf(args[1]) + "_tmp.xml");
        m.simpleTransform(String.valueOf(args[1]) + "_tmp.xml", secondTransFile, args[1]);
    }
}

