# FreeCAD Addon Manager

**NOTE: This is the "dev" (development) branch of the Addon Manager. Most users should use "main" instead.**

Install and update third-party addons to FreeCAD, including Workbenches, Macros, Preference Packs, and more. FreeCAD
ships with a point-in-time snapshot of this Addon: by the time you install FreeCAD it is possible that version of the
Addon Manager is no longer the most recent version. Install *this* addon to update the internal Addon Manager to the
latest version (and to allow future self-updating).

## Addon Sources

The main source of addons is the git repository at https://github.com/FreeCAD/FreeCAD-Addons. Custom addon sources can
be configured in the Addon Manager preferences when running FreeCAD. These addons are primarily written by
third parties and provided by repositories not under the FreeCAD authors' or maintainers' control: you use these addons
at your own risk.

## Information for Addon Developers

To submit an addon you have created see the documentation [here](https://github.com/FreeCAD/FreeCAD-addons/blob/master/Documentation/Submission.md).
For information about developing an addon in the first place, see [the FreeCAD wiki](https://wiki.freecad.org/Workbench_creation#Distribution).
The Addon Manager supports five different types of addons: "Workbench", "Macro", "Preference Pack", "Bundle", and "Other". This
information is provided to the Addon Manager via a file called `package.xml` whose [format is documented on the wiki](https://wiki.freecad.org/Package_Metadata).

The Addon Manager relies on a remote cache of all addons maintained at https://addons.freecad.org,
[generated by a script](https://github.com/FreeCAD/AddonManager/blob/main/AddonCatalogCacheCreator.py) that runs
every six hours. This cache contains the complete code for all addons listed in the addon catalog. Another
process runs to cache all macros from both [the GitHub repository](https://github.com/FreeCAD/FreeCAD-macros/)
and [the Wiki](https://wiki.freecad.org/Macros_recipes). All official catalog-based addons and macros are downloaded from
that server.

## Addon Manager Design Goals

The Addon Manager is now designed to be self-updating, with a goal of allowing versions of FreeCAD back to 0.21 to
use their default copy of Addon Manager to install a new version of Addon Manager. This means that the Addon Manager
should support PySide2 and Python 3.8 for the foreseeable future.

The Addon Manager is also designed to be run in a "standalone" mode to allow for easier UI development. In this mode
it does not interact with FreeCAD at all, and does not use or affect "real" FreeCAD preferences, module installation,
etc.

### Request to Developers

If you plan on submitting a PR to improve the Addon Manager, please write unit tests as appropriate for your development
work. Network and filesystem access should be mocked, and the tests should be able to run without access to FreeCAD (always
use the `addonmanager_freecad_interface.py` file to mediate FreeCAD interactions).

## Roadmap

This module is under active development, with the following rough plan (the order of priorities is only approximate,
and actual development may happen out of order).

1. Handle download interruption and allow resumption
2. Automatic update check for Addon Manager to update itself, even if it's not installed as an Addon
3. Implement automatic Python dependency resolution on FreeCAD/Python version switching
4. Construct `requirements.txt` for <depends> to ensure correct Python module installation
5. FreeCAD in Virtual Env to eliminate `--user` option to `pip`
6. Add/remove macro toolbar button
7. Add option to perform background update checks and recaches
8. Implement "offline mode" for uninstallation
9. Add option to run Preference Pack after install
10. Redesign the GUI

Bug reports and pull requests are welcome. Please make sure you are familiar with
[the contributing process](https://github.com/FreeCAD/FreeCAD/blob/main/CONTRIBUTING.md).
