#ifndef FreeSansBold10pt7b_H
#define FreeSansBold10pt7b_H

#ifdef __AVR__
#include <avr/io.h>
#include <avr/pgmspace.h>
#elif defined(ESP8266)
#include <pgmspace.h>
#undef PROGMEM
#define PROGMEM STORE_ATTR
#elif defined(__IMXRT1052__) || defined(__IMXRT1062__)
// PROGMEM is defefind for T4 to place data in specific memory section
#undef PROGMEM
#define PROGMEM
#else
#define PROGMEM
#endif

const uint8_t FreeSansBold10pt7bBitmaps[] PROGMEM = {
  0x00, 0xFF, 0xFF, 0xFE, 0x48, 0x7F, 0xC0, 0xE7, 0xE7, 0xE7, 0xE7, 0x42,
  0x0C, 0xC3, 0x39, 0xFF, 0xBF, 0xF7, 0xFE, 0x73, 0x0C, 0xE7, 0xFE, 0xFF,
  0xDF, 0xF9, 0x8C, 0x33, 0x06, 0x60, 0x08, 0x0F, 0x87, 0xFB, 0xFE, 0xEB,
  0xFA, 0x7F, 0x81, 0xF8, 0x1F, 0x82, 0xFE, 0x9F, 0xAF, 0xFF, 0xDF, 0xE3,
  0xE0, 0x20, 0x3C, 0x08, 0x3F, 0x0C, 0x3F, 0xC4, 0x18, 0x66, 0x0F, 0xF2,
  0x03, 0xF3, 0x00, 0xF3, 0x00, 0x01, 0x1C, 0x01, 0x9F, 0x00, 0x9F, 0xC0,
  0xCC, 0x60, 0x47, 0xF0, 0x61, 0xF0, 0x60, 0x70, 0x0F, 0x00, 0xFC, 0x0F,
  0xF0, 0x73, 0x83, 0x9C, 0x0F, 0xC0, 0x78, 0x0F, 0xF6, 0xE3, 0xF7, 0x0F,
  0x3C, 0x79, 0xFF, 0xE7, 0xFB, 0x0F, 0x9C, 0xFF, 0xF4, 0x1C, 0x63, 0x8C,
  0x71, 0x8E, 0x38, 0xE3, 0x8E, 0x38, 0xE1, 0xC7, 0x0C, 0x38, 0x60, 0xC0,
  0xE1, 0x87, 0x0C, 0x38, 0x61, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0xE3, 0x8C,
  0x71, 0x8C, 0x00, 0x10, 0x23, 0xF8, 0x82, 0x85, 0x00, 0x1C, 0x0E, 0x07,
  0x1F, 0xFF, 0xFF, 0xFC, 0x70, 0x38, 0x1C, 0x00, 0xFF, 0x93, 0x80, 0xFF,
  0xFE, 0xFF, 0x80, 0x08, 0xC4, 0x23, 0x18, 0x84, 0x63, 0x10, 0x8C, 0x40,
  0x1E, 0x1F, 0xE7, 0xFB, 0xCF, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8,
  0x7F, 0x3D, 0xFE, 0x7F, 0x87, 0x80, 0x0C, 0x7F, 0xFF, 0x1C, 0x71, 0xC7,
  0x1C, 0x71, 0xC7, 0x1C, 0x70, 0x3E, 0x3F, 0xBF, 0xFC, 0x7E, 0x38, 0x1C,
  0x0E, 0x0E, 0x1C, 0x1C, 0x1C, 0x1F, 0xFF, 0xFF, 0xFC, 0x3E, 0x3F, 0xBF,
  0xFC, 0x70, 0x38, 0x1C, 0x38, 0x1E, 0x03, 0x81, 0xF8, 0xFF, 0xF7, 0xF1,
  0xF0, 0x07, 0x07, 0x83, 0xC3, 0xE3, 0x71, 0x39, 0x9C, 0x8E, 0xC7, 0x7F,
  0xFF, 0xFF, 0xF0, 0x70, 0x38, 0x7F, 0x9F, 0xE7, 0xF9, 0x80, 0x7E, 0x3F,
  0xEF, 0xFB, 0x8F, 0x01, 0xC0, 0x7E, 0x3F, 0xFE, 0x7F, 0x8F, 0x80, 0x1F,
  0x0F, 0xE7, 0xFD, 0xC0, 0xEF, 0x3F, 0xEF, 0xFF, 0xCF, 0xE1, 0xF8, 0x7F,
  0x3D, 0xFE, 0x7F, 0x87, 0x80, 0xFF, 0xFF, 0xFF, 0xE0, 0x60, 0x70, 0x30,
  0x38, 0x18, 0x1C, 0x0E, 0x06, 0x07, 0x03, 0x81, 0xC0, 0x1F, 0x0F, 0xFB,
  0xFF, 0xF0, 0x7E, 0x0E, 0xFF, 0x9F, 0xF7, 0x8F, 0xE0, 0xFC, 0x1F, 0xC7,
  0xBF, 0xE7, 0xFC, 0x3E, 0x00, 0x3E, 0x3F, 0x9F, 0xDC, 0x7E, 0x3F, 0x1F,
  0x8F, 0xFF, 0x7F, 0x9D, 0xF8, 0xEF, 0xE7, 0xF1, 0xE0, 0xFF, 0x80, 0x07,
  0xFC, 0xFF, 0x80, 0x07, 0xFC, 0x9C, 0x00, 0x40, 0xF0, 0xFD, 0xF8, 0xF0,
  0x38, 0x0F, 0xC0, 0x7E, 0x03, 0xC0, 0x30, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, 0x38, 0x0F, 0xC0, 0x7C, 0x03, 0xC0,
  0xF0, 0xF9, 0xF8, 0xF0, 0x20, 0x00, 0x1F, 0x1F, 0xE7, 0xFB, 0xC7, 0xE1,
  0xC0, 0x70, 0x1C, 0x0E, 0x07, 0x03, 0x80, 0xE0, 0x00, 0x0E, 0x03, 0x80,
  0xE0, 0x03, 0xF8, 0x03, 0xFF, 0x81, 0xE0, 0xF0, 0xE0, 0x0E, 0x70, 0x01,
  0x98, 0x7B, 0x36, 0x31, 0x8F, 0x18, 0x63, 0xCC, 0x18, 0xF3, 0x04, 0x3C,
  0xC3, 0x1B, 0x39, 0xCE, 0xE7, 0xDF, 0x18, 0xE7, 0x87, 0x00, 0x00, 0xF0,
  0x20, 0x1F, 0xF8, 0x01, 0xFC, 0x00, 0x07, 0x80, 0x1E, 0x00, 0x7C, 0x03,
  0xF0, 0x0F, 0xC0, 0x73, 0x81, 0xCE, 0x07, 0x38, 0x38, 0x70, 0xFF, 0xC3,
  0xFF, 0x1F, 0xFE, 0x70, 0x39, 0xC0, 0xEE, 0x03, 0xC0, 0xFF, 0x9F, 0xFB,
  0xFF, 0xF0, 0x7E, 0x0F, 0xC1, 0xFF, 0xF7, 0xFC, 0xFF, 0xDC, 0x1F, 0x83,
  0xF0, 0x7F, 0xFF, 0xFF, 0xBF, 0xE0, 0x0F, 0xC1, 0xFF, 0x1F, 0xFC, 0xF0,
  0xFF, 0x03, 0xF0, 0x03, 0x80, 0x1C, 0x00, 0xE0, 0x07, 0x00, 0x3C, 0x0E,
  0xF0, 0xF7, 0xFF, 0x1F, 0xF0, 0x3F, 0x00, 0xFF, 0x8F, 0xFC, 0xFF, 0xEE,
  0x0E, 0xE0, 0xFE, 0x07, 0xE0, 0x7E, 0x07, 0xE0, 0x7E, 0x07, 0xE0, 0xFE,
  0x0E, 0xFF, 0xEF, 0xFC, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xE0,
  0x38, 0x0F, 0xFB, 0xFE, 0xFF, 0xB8, 0x0E, 0x03, 0x80, 0xFF, 0xFF, 0xFF,
  0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xE0, 0x38, 0x0F, 0xFB, 0xFE, 0xFF,
  0xB8, 0x0E, 0x03, 0x80, 0xE0, 0x38, 0x0E, 0x00, 0x0F, 0xC0, 0xFF, 0x8F,
  0xFC, 0xF0, 0xF7, 0x00, 0x70, 0x03, 0x80, 0x1C, 0x1F, 0xE0, 0xFF, 0x07,
  0xFC, 0x0E, 0xF0, 0xF7, 0xFF, 0x9F, 0xEC, 0x3E, 0x60, 0xE0, 0xFC, 0x1F,
  0x83, 0xF0, 0x7E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFC, 0x1F, 0x83,
  0xF0, 0x7E, 0x0F, 0xC1, 0xF8, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x03, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x81, 0xF8,
  0xFC, 0x7F, 0xFB, 0xF8, 0xF8, 0xE0, 0xF7, 0x0F, 0x38, 0x71, 0xC7, 0x0E,
  0x70, 0x77, 0x03, 0xF0, 0x1F, 0xC0, 0xF7, 0x07, 0x3C, 0x38, 0xE1, 0xC3,
  0x8E, 0x1E, 0x70, 0x7B, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x07,
  0x03, 0x81, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0F, 0xFF, 0xFF, 0xFE, 0xF0,
  0x7F, 0xC3, 0xFF, 0x8F, 0xFE, 0x3F, 0xF8, 0xFF, 0xE3, 0xFF, 0x9D, 0xFF,
  0x77, 0xED, 0xDF, 0xB7, 0x7E, 0xF9, 0xFB, 0xE7, 0xE7, 0x9F, 0x9E, 0x7E,
  0x79, 0xC0, 0xE0, 0xFE, 0x1F, 0xC3, 0xFC, 0x7F, 0x8F, 0xF9, 0xFB, 0x3F,
  0x77, 0xE6, 0xFC, 0xFF, 0x8F, 0xF1, 0xFE, 0x1F, 0xC3, 0xF8, 0x38, 0x0F,
  0xC0, 0x7F, 0x83, 0xFF, 0x1E, 0x1E, 0x70, 0x3F, 0x80, 0x7E, 0x01, 0xF8,
  0x07, 0xE0, 0x1F, 0x80, 0x77, 0x03, 0xDE, 0x1E, 0x3F, 0xF0, 0x7F, 0x80,
  0xFC, 0x00, 0xFF, 0x9F, 0xFB, 0xFF, 0xF0, 0xFE, 0x0F, 0xC1, 0xF8, 0x7F,
  0xFF, 0xFF, 0xDF, 0xF3, 0x80, 0x70, 0x0E, 0x01, 0xC0, 0x38, 0x00, 0x0F,
  0xC0, 0x7F, 0x83, 0xFF, 0x1E, 0x1E, 0x70, 0x3F, 0x80, 0x7E, 0x01, 0xF8,
  0x07, 0xE0, 0x1F, 0x82, 0x77, 0x1F, 0x9E, 0x1E, 0x3F, 0xF8, 0x7F, 0xF0,
  0xFD, 0x80, 0xFF, 0x8F, 0xFC, 0xFF, 0xEE, 0x0E, 0xE0, 0xEE, 0x0E, 0xFF,
  0xCF, 0xF8, 0xFF, 0xCE, 0x0E, 0xE0, 0xEE, 0x0E, 0xE0, 0xEE, 0x0E, 0xE0,
  0xF0, 0x1F, 0x87, 0xFE, 0x7F, 0xFF, 0x07, 0xE0, 0x0E, 0x00, 0xFE, 0x07,
  0xFE, 0x0F, 0xF0, 0x0F, 0x00, 0x7E, 0x0F, 0xFF, 0xE7, 0xFE, 0x1F, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0x00, 0xE0, 0x1C, 0x03, 0x80, 0x70, 0x0E,
  0x01, 0xC0, 0x38, 0x07, 0x00, 0xE0, 0x1C, 0x03, 0x80, 0xE0, 0xFC, 0x1F,
  0x83, 0xF0, 0x7E, 0x0F, 0xC1, 0xF8, 0x3F, 0x07, 0xE0, 0xFC, 0x1F, 0x83,
  0xF8, 0xF7, 0xFC, 0xFF, 0x87, 0xC0, 0x70, 0x3B, 0x83, 0x9C, 0x1C, 0x60,
  0xE3, 0x86, 0x1C, 0x70, 0x63, 0x83, 0x98, 0x1D, 0xC0, 0x6E, 0x03, 0x60,
  0x1F, 0x00, 0xF8, 0x03, 0x80, 0x1C, 0x00, 0xF0, 0xE1, 0xEE, 0x1C, 0x39,
  0xC3, 0x87, 0x38, 0xF8, 0xE3, 0x1F, 0x1C, 0x73, 0xE3, 0x0E, 0x7C, 0xE1,
  0xCF, 0xDC, 0x1B, 0x9B, 0x03, 0x73, 0x60, 0x7E, 0x6C, 0x0F, 0xCF, 0x80,
  0xF8, 0xE0, 0x1E, 0x1C, 0x03, 0xC3, 0x80, 0x70, 0x7B, 0xC3, 0x8E, 0x38,
  0x39, 0xC1, 0xDC, 0x07, 0xE0, 0x3E, 0x00, 0xE0, 0x0F, 0x80, 0x7E, 0x07,
  0x70, 0x39, 0xC3, 0x8F, 0x3C, 0x39, 0xC1, 0xE0, 0xF0, 0x73, 0x83, 0x9E,
  0x38, 0x71, 0xC3, 0xDC, 0x0E, 0xE0, 0x76, 0x01, 0xF0, 0x07, 0x00, 0x38,
  0x01, 0xC0, 0x0E, 0x00, 0x70, 0x03, 0x80, 0x1C, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0x80, 0xE0, 0x38, 0x0E, 0x03, 0xC0, 0xF0, 0x3C, 0x07, 0x01, 0xC0,
  0x78, 0x0F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xCE, 0x73, 0x9C, 0xE7,
  0x39, 0xCE, 0x73, 0x9C, 0xFF, 0xFE, 0xC3, 0x04, 0x18, 0x60, 0x83, 0x0C,
  0x10, 0x61, 0x82, 0x0C, 0x30, 0xFF, 0xFE, 0x73, 0x9C, 0xE7, 0x39, 0xCE,
  0x73, 0x9C, 0xE7, 0xFF, 0xFE, 0x1C, 0x0F, 0x07, 0x86, 0xC3, 0x33, 0x99,
  0x8E, 0xC3, 0xC1, 0x80, 0xFF, 0xFF, 0xFF, 0xE6, 0x30, 0x3E, 0x1F, 0xC7,
  0xFB, 0x8E, 0x07, 0x9F, 0xEE, 0x3B, 0x8E, 0xFF, 0x9F, 0xE3, 0xBC, 0xE0,
  0x1C, 0x03, 0x80, 0x70, 0x0E, 0xF1, 0xFF, 0xBF, 0xF7, 0x8F, 0xE0, 0xFC,
  0x1F, 0x83, 0xF8, 0xFF, 0xFD, 0xFF, 0xBB, 0xC0, 0x1F, 0x1F, 0xE7, 0xFF,
  0xC7, 0xE0, 0x38, 0x0E, 0x03, 0xC7, 0x7F, 0xDF, 0xE1, 0xF0, 0x01, 0xC0,
  0x70, 0x1C, 0x07, 0x1D, 0xDF, 0xF7, 0xFF, 0xCF, 0xE1, 0xF8, 0x7E, 0x1F,
  0xCF, 0x7F, 0xDF, 0xF3, 0xDC, 0x1E, 0x1F, 0xE7, 0xFB, 0x87, 0xFF, 0xFF,
  0xFE, 0x03, 0xC7, 0x7F, 0xDF, 0xE1, 0xE0, 0x3D, 0xF7, 0xDC, 0xFB, 0xE7,
  0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x00, 0x1D, 0xDF, 0xF7, 0xFF, 0xCF,
  0xE1, 0xF8, 0x7E, 0x1F, 0xCF, 0x7F, 0xDF, 0xF3, 0xDC, 0x07, 0xF3, 0xDF,
  0xE3, 0xF0, 0xE0, 0x38, 0x0E, 0x03, 0x80, 0xEF, 0x3F, 0xEF, 0xFF, 0xC7,
  0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8, 0x7E, 0x1C, 0xFF, 0x8F, 0xFF,
  0xFF, 0xFF, 0xF8, 0x77, 0x70, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xFF,
  0xE0, 0xE0, 0x38, 0x0E, 0x03, 0x80, 0xE3, 0xB9, 0xCE, 0xF3, 0xB8, 0xFC,
  0x3F, 0x8F, 0xE3, 0x9C, 0xE7, 0xB8, 0xEE, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF8, 0xEF, 0x1E, 0xFF, 0xBF, 0xFF, 0xFF, 0xF1, 0xC7, 0xE1, 0xC7,
  0xE1, 0xC7, 0xE1, 0xC7, 0xE1, 0xC7, 0xE1, 0xC7, 0xE1, 0xC7, 0xE1, 0xC7,
  0xEF, 0x3F, 0xEF, 0xFF, 0xC7, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1, 0xF8,
  0x7E, 0x1C, 0x1F, 0x07, 0xF9, 0xFF, 0x78, 0xFE, 0x0F, 0xC1, 0xF8, 0x3F,
  0x8F, 0x7F, 0xC7, 0xF8, 0x7C, 0x00, 0xEF, 0x1F, 0xF3, 0xFF, 0x78, 0xFE,
  0x0F, 0xC1, 0xF8, 0x3F, 0x8F, 0xFF, 0xDF, 0xF3, 0xBC, 0x70, 0x0E, 0x01,
  0xC0, 0x38, 0x00, 0x1D, 0xCF, 0xF7, 0xFF, 0xCF, 0xE1, 0xF8, 0x7E, 0x1F,
  0xCF, 0x7F, 0xDF, 0xF1, 0xDC, 0x07, 0x01, 0xC0, 0x70, 0x1C, 0xEF, 0xFF,
  0xFC, 0xE3, 0x8E, 0x38, 0xE3, 0x8E, 0x00, 0x3E, 0x1F, 0xEF, 0xFB, 0x87,
  0xFC, 0x1F, 0xE1, 0xFF, 0x87, 0xFF, 0xDF, 0xE3, 0xF0, 0x73, 0xBF, 0xF7,
  0x39, 0xCE, 0x73, 0x9E, 0xF3, 0x80, 0xE1, 0xF8, 0x7E, 0x1F, 0x87, 0xE1,
  0xF8, 0x7E, 0x1F, 0x8F, 0xFF, 0xDF, 0xF3, 0xDC, 0xE0, 0xCE, 0x39, 0xC7,
  0x38, 0xC3, 0x38, 0x77, 0x0E, 0xC0, 0xD8, 0x1F, 0x03, 0xC0, 0x38, 0x00,
  0xE3, 0x8E, 0xC7, 0x1D, 0xCF, 0x3B, 0x9E, 0x67, 0x7C, 0xC6, 0xDB, 0x8D,
  0x9F, 0x1F, 0x3C, 0x3E, 0x78, 0x38, 0xF0, 0x71, 0xC0, 0x71, 0xCF, 0x78,
  0xEE, 0x0F, 0x81, 0xF0, 0x1C, 0x07, 0xC0, 0xF8, 0x3B, 0x8E, 0x39, 0xC7,
  0x00, 0xE0, 0xEE, 0x39, 0xC7, 0x18, 0xC3, 0xB8, 0x77, 0x06, 0xC0, 0xF8,
  0x0F, 0x01, 0xC0, 0x38, 0x06, 0x03, 0xC0, 0x78, 0x0E, 0x00, 0xFF, 0x7F,
  0xBF, 0xC1, 0xE1, 0xE1, 0xE1, 0xE1, 0xE0, 0xFF, 0xFF, 0xFF, 0xE0, 0x19,
  0xCE, 0x63, 0x18, 0xC6, 0x37, 0xBC, 0x63, 0x18, 0xC6, 0x39, 0xC6, 0xFF,
  0xFF, 0xE0, 0xC7, 0x38, 0xC6, 0x31, 0x8C, 0x63, 0xDE, 0xC6, 0x31, 0x8C,
  0xE7, 0x30, 0x70, 0x7C, 0x63, 0xE0, 0xE0 };

const GFXglyph FreeSansBold10pt7bGlyphs[] PROGMEM = {
  {     0,   1,   1,   6,    0,    0 },   // 0x20 ' '
  {     1,   3,  14,   7,    2,  -13 },   // 0x21 '!'
  {     7,   8,   5,   9,    1,  -14 },   // 0x22 '"'
  {    12,  11,  13,  11,    0,  -12 },   // 0x23 '#'
  {    30,  10,  16,  11,    1,  -14 },   // 0x24 '$'
  {    50,  17,  14,  18,    0,  -13 },   // 0x25 '%'
  {    80,  13,  14,  14,    1,  -13 },   // 0x26 '&'
  {   103,   3,   5,   5,    1,  -14 },   // 0x27 '''
  {   105,   6,  19,   7,    1,  -14 },   // 0x28 '('
  {   120,   6,  19,   7,    0,  -14 },   // 0x29 ')'
  {   135,   7,   6,   8,    0,  -14 },   // 0x2A '*'
  {   141,   9,   9,  12,    2,   -8 },   // 0x2B '+'
  {   152,   3,   6,   5,    1,   -2 },   // 0x2C ','
  {   155,   5,   3,   7,    1,   -6 },   // 0x2D '-'
  {   157,   3,   3,   5,    1,   -2 },   // 0x2E '.'
  {   159,   5,  14,   6,    0,  -13 },   // 0x2F '/'
  {   168,  10,  14,  11,    1,  -13 },   // 0x30 '0'
  {   186,   6,  14,  11,    2,  -13 },   // 0x31 '1'
  {   197,   9,  14,  11,    1,  -13 },   // 0x32 '2'
  {   213,   9,  14,  11,    1,  -13 },   // 0x33 '3'
  {   229,   9,  14,  11,    1,  -13 },   // 0x34 '4'
  {   245,  10,  14,  11,    1,  -13 },   // 0x35 '5'
  {   263,  10,  14,  11,    1,  -13 },   // 0x36 '6'
  {   281,   9,  14,  11,    1,  -13 },   // 0x37 '7'
  {   297,  11,  14,  11,    0,  -13 },   // 0x38 '8'
  {   317,   9,  14,  11,    1,  -13 },   // 0x39 '9'
  {   333,   3,  10,   5,    1,   -9 },   // 0x3A ':'
  {   337,   3,  13,   5,    1,   -9 },   // 0x3B ';'
  {   342,  10,  10,  12,    1,   -9 },   // 0x3C '<'
  {   355,  10,   8,  12,    1,   -8 },   // 0x3D '='
  {   365,  10,  10,  12,    1,   -9 },   // 0x3E '>'
  {   378,  10,  15,  12,    1,  -14 },   // 0x3F '?'
  {   397,  18,  18,  20,    1,  -14 },   // 0x40 '@'
  {   438,  14,  15,  14,    0,  -14 },   // 0x41 'A'
  {   465,  11,  15,  14,    2,  -14 },   // 0x42 'B'
  {   486,  13,  15,  14,    1,  -14 },   // 0x43 'C'
  {   511,  12,  15,  14,    2,  -14 },   // 0x44 'D'
  {   534,  10,  15,  13,    2,  -14 },   // 0x45 'E'
  {   553,  10,  15,  13,    2,  -14 },   // 0x46 'F'
  {   572,  13,  15,  15,    1,  -14 },   // 0x47 'G'
  {   597,  11,  15,  15,    2,  -14 },   // 0x48 'H'
  {   618,   3,  15,   6,    2,  -14 },   // 0x49 'I'
  {   624,   9,  15,  11,    1,  -14 },   // 0x4A 'J'
  {   641,  13,  15,  15,    2,  -14 },   // 0x4B 'K'
  {   666,   9,  15,  12,    2,  -14 },   // 0x4C 'L'
  {   683,  14,  15,  17,    2,  -14 },   // 0x4D 'M'
  {   710,  11,  15,  15,    2,  -14 },   // 0x4E 'N'
  {   731,  14,  15,  16,    1,  -14 },   // 0x4F 'O'
  {   758,  11,  15,  14,    2,  -14 },   // 0x50 'P'
  {   779,  14,  15,  16,    1,  -14 },   // 0x51 'Q'
  {   806,  12,  15,  14,    2,  -14 },   // 0x52 'R'
  {   829,  12,  15,  14,    1,  -14 },   // 0x53 'S'
  {   852,  11,  15,  13,    1,  -14 },   // 0x54 'T'
  {   873,  11,  15,  15,    2,  -14 },   // 0x55 'U'
  {   894,  13,  15,  13,    0,  -14 },   // 0x56 'V'
  {   919,  19,  15,  19,    0,  -14 },   // 0x57 'W'
  {   955,  13,  15,  13,    0,  -14 },   // 0x58 'X'
  {   980,  13,  15,  13,    0,  -14 },   // 0x59 'Y'
  {  1005,  11,  15,  12,    1,  -14 },   // 0x5A 'Z'
  {  1026,   5,  19,   7,    1,  -14 },   // 0x5B '['
  {  1038,   6,  14,   6,    0,  -13 },   // 0x5C '\'
  {  1049,   5,  19,   7,    0,  -14 },   // 0x5D ']'
  {  1061,   9,   9,  12,    1,  -13 },   // 0x5E '^'
  {  1072,  12,   2,  11,    0,    3 },   // 0x5F '_'
  {  1075,   4,   3,   5,    0,  -14 },   // 0x60 '`'
  {  1077,  10,  11,  11,    1,  -10 },   // 0x61 'a'
  {  1091,  11,  15,  12,    1,  -14 },   // 0x62 'b'
  {  1112,  10,  11,  11,    1,  -10 },   // 0x63 'c'
  {  1126,  10,  15,  12,    1,  -14 },   // 0x64 'd'
  {  1145,  10,  11,  12,    1,  -10 },   // 0x65 'e'
  {  1159,   6,  15,   7,    1,  -14 },   // 0x66 'f'
  {  1171,  10,  15,  12,    1,  -10 },   // 0x67 'g'
  {  1190,  10,  15,  12,    1,  -14 },   // 0x68 'h'
  {  1209,   3,  15,   6,    1,  -14 },   // 0x69 'i'
  {  1215,   4,  19,   6,    0,  -14 },   // 0x6A 'j'
  {  1225,  10,  15,  11,    1,  -14 },   // 0x6B 'k'
  {  1244,   3,  15,   5,    1,  -14 },   // 0x6C 'l'
  {  1250,  16,  11,  18,    1,  -10 },   // 0x6D 'm'
  {  1272,  10,  11,  12,    1,  -10 },   // 0x6E 'n'
  {  1286,  11,  11,  12,    1,  -10 },   // 0x6F 'o'
  {  1302,  11,  15,  12,    1,  -10 },   // 0x70 'p'
  {  1323,  10,  15,  12,    1,  -10 },   // 0x71 'q'
  {  1342,   6,  11,   8,    1,  -10 },   // 0x72 'r'
  {  1351,  10,  11,  11,    1,  -10 },   // 0x73 's'
  {  1365,   5,  13,   7,    1,  -12 },   // 0x74 't'
  {  1374,  10,  11,  12,    1,  -10 },   // 0x75 'u'
  {  1388,  11,  11,  11,    0,  -10 },   // 0x76 'v'
  {  1404,  15,  11,  16,    0,  -10 },   // 0x77 'w'
  {  1425,  11,  11,  11,    0,  -10 },   // 0x78 'x'
  {  1441,  11,  15,  11,    0,  -10 },   // 0x79 'y'
  {  1462,   9,  11,  10,    1,  -10 },   // 0x7A 'z'
  {  1475,   5,  19,   8,    0,  -14 },   // 0x7B '{'
  {  1487,   1,  19,   6,    2,  -14 },   // 0x7C '|'
  {  1490,   5,  19,   8,    2,  -14 },   // 0x7D '}'
  {  1502,   9,   4,  10,    0,   -6 } }; // 0x7E '~'

const GFXfont FreeSansBold10pt7b PROGMEM = {
  (uint8_t  *)FreeSansBold10pt7bBitmaps,
  (GFXglyph *)FreeSansBold10pt7bGlyphs,
  0x20, 0x7E, 24 };

// Approx. 2179 bytes

#endif // FreeSansBold10pt7b_H
