#!/bin/sh

DIR=$1

if [ ! -d $DIR ]; then
	echo "$DIR doesn't exist"
	exit 0
fi

cd $DIR

echo Upgrading $DIR

[ -e ntxfw.bin.header.fex ] && dd if=ntxfw.bin.header.fex of=/dev/mmcblk0 bs=512 seek=1029
[ -e ntxfw.bin.fex ] && dd if=ntxfw.bin.fex of=/dev/mmcblk0 bs=512 seek=1030
[ -e waveform.bin.header.fex ] && dd if=waveform.bin.header.fex of=/dev/mmcblk0 bs=512 seek=16415
[ -e waveform.bin.fex ] && dd if=waveform.bin.fex of=/dev/mmcblk0 bs=512 seek=16416
[ -e boot_package.fex ] && dd if=boot_package.fex of=/dev/mmcblk0 bs=512 seek=32800
[ -e boot.fex ] && dd if=boot.fex of=/dev/mmcblk0 bs=512 seek=172032

cp *.ko /drivers/b300-ntx

cd ..

sync
sync

exit 1
