"""empty message

Revision ID: 8d289573e1da
Revises: 0e154742a5fa
Create Date: 2025-08-20 17:47:17.015695

"""
from alembic import op
import models as models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '8d289573e1da'
down_revision = '0e154742a5fa'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('oauth_provider_apps',
    sa.Column('id', models.types.StringUUID(), server_default=sa.text('uuidv7()'), nullable=False),
    sa.Column('app_icon', sa.String(length=255), nullable=False),
    sa.Column('app_label', sa.JSON(), server_default='{}', nullable=False),
    sa.Column('client_id', sa.String(length=255), nullable=False),
    sa.Column('client_secret', sa.String(length=255), nullable=False),
    sa.Column('redirect_uris', sa.JSON(), server_default='[]', nullable=False),
    sa.Column('scope', sa.String(length=255), server_default=sa.text("'read:name read:email read:avatar read:interface_language read:timezone'"), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text('CURRENT_TIMESTAMP(0)'), nullable=False),
    sa.PrimaryKeyConstraint('id', name='oauth_provider_app_pkey')
    )
    with op.batch_alter_table('oauth_provider_apps', schema=None) as batch_op:
        batch_op.create_index('oauth_provider_app_client_id_idx', ['client_id'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('oauth_provider_apps', schema=None) as batch_op:
        batch_op.drop_index('oauth_provider_app_client_id_idx')

    op.drop_table('oauth_provider_apps')
    # ### end Alembic commands ###
