/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.IOUtils;

public final class NetworkUtils {
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String NAME_VALUE_SEPARATOR = "=";
    private static final int TIME_OUT = 8000;

    private NetworkUtils() {
    }

    public static String withQuery(String baseUrl, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(baseUrl);
        boolean first = true;
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (param.getValue() == null) continue;
            if (first) {
                if (!baseUrl.isEmpty()) {
                    sb.append('?');
                }
                first = false;
            } else {
                sb.append(PARAMETER_SEPARATOR);
            }
            sb.append(NetworkUtils.encodeURL(param.getKey()));
            sb.append(NAME_VALUE_SEPARATOR);
            sb.append(NetworkUtils.encodeURL(param.getValue()));
        }
        return sb.toString();
    }

    public static List<Pair<String, String>> parseQuery(URI uri) {
        return NetworkUtils.parseQuery(uri.getRawQuery());
    }

    public static List<Pair<String, String>> parseQuery(String queryParameterString) {
        if (queryParameterString == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        try (Scanner scanner = new Scanner(queryParameterString);){
            scanner.useDelimiter(PARAMETER_SEPARATOR);
            while (scanner.hasNext()) {
                String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
                if (nameValue.length <= 0 || nameValue.length > 2) {
                    throw new IllegalArgumentException("bad query string");
                }
                String name = NetworkUtils.decodeURL(nameValue[0]);
                String value = nameValue.length == 2 ? NetworkUtils.decodeURL(nameValue[1]) : null;
                result.add(Pair.pair(name, value));
            }
        }
        return result;
    }

    public static URLConnection createConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(8000);
        connection.setReadTimeout(8000);
        connection.setRequestProperty("Accept-Language", Locale.getDefault().toString());
        return connection;
    }

    public static HttpURLConnection createHttpConnection(URL url) throws IOException {
        return (HttpURLConnection)NetworkUtils.createConnection(url);
    }

    public static String encodeLocation(String location) {
        StringBuilder sb = new StringBuilder();
        boolean left = true;
        block4: for (char ch : location.toCharArray()) {
            switch (ch) {
                case ' ': {
                    if (left) {
                        sb.append("%20");
                        continue block4;
                    }
                    sb.append('+');
                    continue block4;
                }
                case '?': {
                    left = false;
                }
                default: {
                    if (ch >= '\u0080') {
                        sb.append(NetworkUtils.encodeURL(Character.toString(ch)));
                        continue block4;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static HttpURLConnection resolveConnection(HttpURLConnection conn) throws IOException {
        int redirect = 0;
        while (true) {
            conn.setUseCaches(false);
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(8000);
            conn.setInstanceFollowRedirects(false);
            Map<String, List<String>> properties = conn.getRequestProperties();
            String method = conn.getRequestMethod();
            int code = conn.getResponseCode();
            if (code < 300 || code > 307 || code == 306 || code == 304) break;
            String newURL = conn.getHeaderField("Location");
            conn.disconnect();
            if (redirect > 20) {
                throw new IOException("Too much redirects");
            }
            HttpURLConnection redirected = (HttpURLConnection)new URL(conn.getURL(), NetworkUtils.encodeLocation(newURL)).openConnection();
            properties.forEach((key, value) -> value.forEach(element -> redirected.addRequestProperty((String)key, (String)element)));
            redirected.setRequestMethod(method);
            conn = redirected;
            ++redirect;
        }
        return conn;
    }

    public static String doGet(URL url) throws IOException {
        HttpURLConnection con = NetworkUtils.createHttpConnection(url);
        con = NetworkUtils.resolveConnection(con);
        return IOUtils.readFullyAsString(con.getInputStream());
    }

    public static String doPost(URL u, Map<String, String> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey()).append(NAME_VALUE_SEPARATOR).append(e.getValue()).append(PARAMETER_SEPARATOR);
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return NetworkUtils.doPost(u, sb.toString());
    }

    public static String doPost(URL u, String post) throws IOException {
        return NetworkUtils.doPost(u, post, "application/x-www-form-urlencoded");
    }

    public static String doPost(URL url, String post, String contentType) throws IOException {
        byte[] bytes = post.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection con = NetworkUtils.createHttpConnection(url);
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        con.setRequestProperty("Content-Length", "" + bytes.length);
        try (OutputStream os = con.getOutputStream();){
            os.write(bytes);
        }
        return NetworkUtils.readData(con);
    }

    public static String readData(HttpURLConnection con) throws IOException {
        String string;
        block15: {
            InputStream stdout = con.getInputStream();
            try {
                string = IOUtils.readFullyAsString("gzip".equals(con.getContentEncoding()) ? IOUtils.wrapFromGZip(stdout) : stdout);
                if (stdout == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (stdout != null) {
                        try {
                            stdout.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    try (InputStream stderr = con.getErrorStream();){
                        if (stderr == null) {
                            throw e;
                        }
                        String string2 = IOUtils.readFullyAsString("gzip".equals(con.getContentEncoding()) ? IOUtils.wrapFromGZip(stderr) : stderr);
                        return string2;
                    }
                }
            }
            stdout.close();
        }
        return string;
    }

    public static String detectFileName(URL url) throws IOException {
        HttpURLConnection conn = NetworkUtils.resolveConnection(NetworkUtils.createHttpConnection(url));
        int code = conn.getResponseCode();
        if (code / 100 == 4) {
            throw new FileNotFoundException();
        }
        if (code / 100 != 2) {
            throw new IOException(url + ": response code " + conn.getResponseCode());
        }
        return NetworkUtils.detectFileName(conn);
    }

    public static String detectFileName(HttpURLConnection conn) {
        String disposition = conn.getHeaderField("Content-Disposition");
        if (disposition == null || !disposition.contains("filename=")) {
            String u = conn.getURL().toString();
            return NetworkUtils.decodeURL(StringUtils.substringAfterLast(u, '/'));
        }
        return NetworkUtils.decodeURL(StringUtils.removeSurrounding(StringUtils.substringAfter(disposition, "filename="), "\""));
    }

    public static URL toURL(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isURL(String str) {
        try {
            new URL(str);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean urlExists(URL url) throws IOException {
        HttpURLConnection con = NetworkUtils.createHttpConnection(url);
        con = NetworkUtils.resolveConnection(con);
        int responseCode = con.getResponseCode();
        con.disconnect();
        return responseCode / 100 == 2;
    }

    public static String encodeURL(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error();
        }
    }

    public static String decodeURL(String toDecode) {
        try {
            return URLDecoder.decode(toDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error();
        }
    }
}

