/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class CompressingUtils {
    private static final FileSystemProvider ZIPFS_PROVIDER = FileSystemProvider.installedProviders().stream().filter(it -> "jar".equalsIgnoreCase(it.getScheme())).findFirst().orElse(null);

    private CompressingUtils() {
    }

    private static CharsetDecoder newCharsetDecoder(Charset charset) {
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public static boolean testEncoding(Path zipFile, Charset encoding) throws IOException {
        try (ZipFile zf = CompressingUtils.openZipFile(zipFile, encoding);){
            boolean bl = CompressingUtils.testEncoding(zf, encoding);
            return bl;
        }
    }

    public static boolean testEncoding(ZipFile zipFile, Charset encoding) throws IOException {
        Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
        CharsetDecoder cd = CompressingUtils.newCharsetDecoder(encoding);
        CharBuffer cb = CharBuffer.allocate(32);
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            if (entry.getGeneralPurposeBit().usesUTF8ForNames()) continue;
            cd.reset();
            byte[] ba = entry.getRawName();
            int clen = (int)((float)ba.length * cd.maxCharsPerByte());
            if (clen == 0) continue;
            if (clen <= cb.capacity()) {
                ((Buffer)cb).clear();
            } else {
                cb = CharBuffer.allocate(clen);
            }
            ByteBuffer bb = ByteBuffer.wrap(ba, 0, ba.length);
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                return false;
            }
            cr = cd.flush(cb);
            if (cr.isUnderflow()) continue;
            return false;
        }
        return true;
    }

    public static Charset findSuitableEncoding(Path zipFile) throws IOException {
        try (ZipFile zf = CompressingUtils.openZipFile(zipFile, StandardCharsets.UTF_8);){
            Charset charset = CompressingUtils.findSuitableEncoding(zf);
            return charset;
        }
    }

    public static Charset findSuitableEncoding(ZipFile zipFile) throws IOException {
        String[] candidates;
        if (CompressingUtils.testEncoding(zipFile, StandardCharsets.UTF_8)) {
            return StandardCharsets.UTF_8;
        }
        if (OperatingSystem.NATIVE_CHARSET != StandardCharsets.UTF_8 && CompressingUtils.testEncoding(zipFile, OperatingSystem.NATIVE_CHARSET)) {
            return OperatingSystem.NATIVE_CHARSET;
        }
        for (String candidate : candidates = new String[]{"GB18030", "Big5", "Shift_JIS", "EUC-JP", "ISO-2022-JP", "EUC-KR", "ISO-2022-KR", "KOI8-R", "windows-1251", "x-MacCyrillic", "IBM855", "IBM866", "windows-1252", "ISO-8859-1", "ISO-8859-5", "ISO-8859-7", "ISO-8859-8", "UTF-16LE", "UTF-16BE", "UTF-32LE", "UTF-32BE"}) {
            try {
                Charset charset = Charset.forName(candidate);
                if (charset.equals(OperatingSystem.NATIVE_CHARSET) || !CompressingUtils.testEncoding(zipFile, charset)) continue;
                return charset;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IOException("Cannot find suitable encoding for the zip.");
    }

    public static ZipFile openZipFile(Path zipFile) throws IOException {
        return new ZipFile(Files.newByteChannel(zipFile, new OpenOption[0]));
    }

    public static ZipFile openZipFile(Path zipFile, Charset charset) throws IOException {
        return new ZipFile(Files.newByteChannel(zipFile, new OpenOption[0]), charset.name());
    }

    public static Builder readonly(Path zipFile) {
        return new Builder(zipFile, false);
    }

    public static Builder writable(Path zipFile) {
        return new Builder(zipFile, true).setUseTempFile(true);
    }

    public static FileSystem createReadOnlyZipFileSystem(Path zipFile) throws IOException {
        return CompressingUtils.createReadOnlyZipFileSystem(zipFile, null);
    }

    public static FileSystem createReadOnlyZipFileSystem(Path zipFile, Charset charset) throws IOException {
        return CompressingUtils.createZipFileSystem(zipFile, false, false, charset);
    }

    public static FileSystem createWritableZipFileSystem(Path zipFile) throws IOException {
        return CompressingUtils.createWritableZipFileSystem(zipFile, null);
    }

    public static FileSystem createWritableZipFileSystem(Path zipFile, Charset charset) throws IOException {
        return CompressingUtils.createZipFileSystem(zipFile, true, true, charset);
    }

    public static FileSystem createZipFileSystem(Path zipFile, boolean create, boolean useTempFile, Charset encoding) throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (create) {
            env.put("create", "true");
        }
        if (encoding != null) {
            env.put("encoding", encoding.name());
        }
        if (useTempFile) {
            env.put("useTempFile", true);
        }
        try {
            if (ZIPFS_PROVIDER == null) {
                throw new FileSystemNotFoundException("Module jdk.zipfs does not exist");
            }
            return ZIPFS_PROVIDER.newFileSystem(zipFile, env);
        }
        catch (ZipError error) {
            throw new ZipException(error.getMessage());
        }
        catch (UnsupportedOperationException ex) {
            throw new ZipException("Not a zip file");
        }
        catch (FileSystemNotFoundException ex) {
            throw Lang.apply(new ZipException("Java Environment is broken"), it -> it.initCause(ex));
        }
    }

    public static String readTextZipEntry(File zipFile, String name) throws IOException {
        try (ZipFile s = new ZipFile(zipFile);){
            String string = CompressingUtils.readTextZipEntry(s, name);
            return string;
        }
    }

    public static String readTextZipEntry(ZipFile zipFile, String name) throws IOException {
        return IOUtils.readFullyAsString(zipFile.getInputStream(zipFile.getEntry(name)));
    }

    public static String readTextZipEntry(Path zipFile, String name, Charset encoding) throws IOException {
        try (ZipFile s = CompressingUtils.openZipFile(zipFile, encoding);){
            String string = IOUtils.readFullyAsString(s.getInputStream(s.getEntry(name)));
            return string;
        }
    }

    public static Optional<String> readTextZipEntryQuietly(File file, String name) {
        try {
            return Optional.of(CompressingUtils.readTextZipEntry(file, name));
        }
        catch (IOException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> readTextZipEntryQuietly(Path file, String name, Charset encoding) {
        try {
            return Optional.of(CompressingUtils.readTextZipEntry(file, name, encoding));
        }
        catch (IOException | NullPointerException e) {
            return Optional.empty();
        }
    }

    public static final class Builder {
        private boolean autoDetectEncoding = false;
        private Charset encoding = StandardCharsets.UTF_8;
        private boolean useTempFile = false;
        private final boolean create;
        private final Path zip;

        public Builder(Path zip, boolean create) {
            this.zip = zip;
            this.create = create;
        }

        public Builder setAutoDetectEncoding(boolean autoDetectEncoding) {
            this.autoDetectEncoding = autoDetectEncoding;
            return this;
        }

        public Builder setEncoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setUseTempFile(boolean useTempFile) {
            this.useTempFile = useTempFile;
            return this;
        }

        public FileSystem build() throws IOException {
            if (this.autoDetectEncoding && !CompressingUtils.testEncoding(this.zip, this.encoding)) {
                this.encoding = CompressingUtils.findSuitableEncoding(this.zip);
            }
            return CompressingUtils.createZipFileSystem(this.zip, this.create, this.useTempFile, this.encoding);
        }
    }
}

