/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class FractureiserDetector {
    private FractureiserDetector() {
    }

    public static boolean detect() {
        try {
            Path dataDir;
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                Path appdata = Paths.get(System.getProperty("user.home"), "AppData");
                if (Files.isDirectory(appdata, new LinkOption[0])) {
                    FractureiserDetector.check(appdata.resolve("Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\run.bat"));
                    Path falseEdgePath = appdata.resolve("Local\\Microsoft Edge");
                    if (Files.exists(falseEdgePath, new LinkOption[0])) {
                        FractureiserDetector.check(falseEdgePath.resolve(".ref"));
                        FractureiserDetector.check(falseEdgePath.resolve("client.jar"));
                        FractureiserDetector.check(falseEdgePath.resolve("lib.dll"));
                        FractureiserDetector.check(falseEdgePath.resolve("libWebGL64.jar"));
                        FractureiserDetector.check(falseEdgePath.resolve("run.bat"));
                    }
                }
            } else if (OperatingSystem.CURRENT_OS.isLinuxOrBSD() && Files.exists(dataDir = Paths.get(System.getProperty("user.home"), ".config", ".data"), new LinkOption[0])) {
                FractureiserDetector.check(dataDir.resolve(".ref"));
                FractureiserDetector.check(dataDir.resolve("client.jar"));
                FractureiserDetector.check(dataDir.resolve("lib.jar"));
            }
        }
        catch (FractureiserException e) {
            return true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void check(Path path) throws FractureiserException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new FractureiserException();
        }
    }

    private static final class FractureiserException
    extends Exception {
        private FractureiserException() {
        }
    }
}

