/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DoubleValidator;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class WorldInfoPage
extends StackPane
implements DecoratorPage {
    private final World world;
    private final CompoundTag levelDat;
    private final CompoundTag dataTag;
    private final ObjectProperty<DecoratorPage.State> stateProperty = new SimpleObjectProperty();

    public WorldInfoPage(World world) throws IOException {
        Object tag;
        this.world = world;
        this.levelDat = world.readLevelDat();
        this.dataTag = (CompoundTag)this.levelDat.get("Data");
        CompoundTag worldGenSettings = (CompoundTag)this.dataTag.get("WorldGenSettings");
        this.stateProperty.set((Object)DecoratorPage.State.fromTitle(I18n.i18n("world.info.title", world.getWorldName())));
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        VBox rootPane = new VBox();
        rootPane.setFillWidth(true);
        scrollPane.setContent((Node)rootPane);
        FXUtils.smoothScrolling(scrollPane);
        rootPane.getStyleClass().add((Object)"card-list");
        ComponentList basicInfo = new ComponentList();
        BorderPane worldNamePane = new BorderPane();
        Label label = new Label(I18n.i18n("world.name"));
        worldNamePane.setLeft((Node)label);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        Label worldNameLabel = new Label();
        worldNameLabel.setText(world.getWorldName());
        BorderPane.setAlignment((Node)worldNameLabel, (Pos)Pos.CENTER_RIGHT);
        worldNamePane.setRight((Node)worldNameLabel);
        BorderPane gameVersionPane = new BorderPane();
        Label label2 = new Label(I18n.i18n("world.info.game_version"));
        BorderPane.setAlignment((Node)label2, (Pos)Pos.CENTER_LEFT);
        gameVersionPane.setLeft((Node)label2);
        Label gameVersionLabel = new Label();
        gameVersionLabel.setText(world.getGameVersion());
        BorderPane.setAlignment((Node)gameVersionLabel, (Pos)Pos.CENTER_RIGHT);
        gameVersionPane.setRight((Node)gameVersionLabel);
        BorderPane randomSeedPane = new BorderPane();
        Label label3 = new Label(I18n.i18n("world.info.random_seed"));
        BorderPane.setAlignment((Node)label3, (Pos)Pos.CENTER_LEFT);
        randomSeedPane.setLeft((Node)label3);
        Label randomSeedLabel = new Label();
        BorderPane.setAlignment((Node)randomSeedLabel, (Pos)Pos.CENTER_RIGHT);
        randomSeedPane.setRight((Node)randomSeedLabel);
        Object t = tag = worldGenSettings != null ? worldGenSettings.get("seed") : this.dataTag.get("RandomSeed");
        if (tag instanceof LongTag) {
            randomSeedLabel.setText(((Tag)tag).getValue().toString());
        }
        BorderPane lastPlayedPane = new BorderPane();
        Label label4 = new Label(I18n.i18n("world.info.last_played"));
        BorderPane.setAlignment((Node)label4, (Pos)Pos.CENTER_LEFT);
        lastPlayedPane.setLeft((Node)label4);
        Label lastPlayedLabel = new Label();
        lastPlayedLabel.setText(I18n.formatDateTime(Instant.ofEpochMilli(world.getLastPlayed())));
        BorderPane.setAlignment((Node)lastPlayedLabel, (Pos)Pos.CENTER_RIGHT);
        lastPlayedPane.setRight((Node)lastPlayedLabel);
        BorderPane timePane = new BorderPane();
        Label label5 = new Label(I18n.i18n("world.info.time"));
        BorderPane.setAlignment((Node)label5, (Pos)Pos.CENTER_LEFT);
        timePane.setLeft((Node)label5);
        Label timeLabel = new Label();
        BorderPane.setAlignment((Node)timeLabel, (Pos)Pos.CENTER_RIGHT);
        timePane.setRight((Node)timeLabel);
        Object tag2 = this.dataTag.get("Time");
        if (tag2 instanceof LongTag) {
            long days = ((LongTag)tag2).getValue() / 24000L;
            timeLabel.setText(I18n.i18n("world.info.time.format", days));
        }
        OptionToggleButton allowCheatsButton = new OptionToggleButton();
        allowCheatsButton.setTitle(I18n.i18n("world.info.allow_cheats"));
        Object tag3 = this.dataTag.get("allowCommands");
        if (tag3 instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag3;
            byte value = byteTag.getValue();
            if (value == 0 || value == 1) {
                allowCheatsButton.setSelected(value == 1);
                allowCheatsButton.selectedProperty().addListener((o, oldValue, newValue) -> {
                    byteTag.setValue(newValue != false ? (byte)1 : (byte)0);
                    this.saveLevelDat();
                });
            } else {
                allowCheatsButton.setDisable(true);
            }
        } else {
            allowCheatsButton.setDisable(true);
        }
        OptionToggleButton generateFeaturesButton = new OptionToggleButton();
        generateFeaturesButton.setTitle(I18n.i18n("world.info.generate_features"));
        Object t2 = tag2 = worldGenSettings != null ? worldGenSettings.get("generate_features") : this.dataTag.get("MapFeatures");
        if (tag2 instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag2;
            byte value = byteTag.getValue();
            if (value == 0 || value == 1) {
                generateFeaturesButton.setSelected(value == 1);
                generateFeaturesButton.selectedProperty().addListener((o, oldValue, newValue) -> {
                    byteTag.setValue(newValue != false ? (byte)1 : (byte)0);
                    this.saveLevelDat();
                });
            } else {
                generateFeaturesButton.setDisable(true);
            }
        } else {
            generateFeaturesButton.setDisable(true);
        }
        BorderPane difficultyPane = new BorderPane();
        Label label6 = new Label(I18n.i18n("world.info.difficulty"));
        BorderPane.setAlignment((Node)label6, (Pos)Pos.CENTER_LEFT);
        difficultyPane.setLeft((Node)label6);
        JFXComboBox<Difficulty> difficultyBox = new JFXComboBox<Difficulty>(Difficulty.items);
        BorderPane.setAlignment(difficultyBox, (Pos)Pos.CENTER_RIGHT);
        difficultyPane.setRight(difficultyBox);
        Object tag4 = this.dataTag.get("Difficulty");
        if (tag4 instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag4;
            Difficulty difficulty = Difficulty.of(byteTag.getValue().byteValue());
            if (difficulty != null) {
                difficultyBox.setValue((Object)difficulty);
                difficultyBox.valueProperty().addListener((o, oldValue, newValue) -> {
                    if (newValue != null) {
                        byteTag.setValue((byte)newValue.ordinal());
                        this.saveLevelDat();
                    }
                });
            } else {
                difficultyBox.setDisable(true);
            }
        } else {
            difficultyBox.setDisable(true);
        }
        basicInfo.getContent().setAll((Object[])new Node[]{worldNamePane, gameVersionPane, randomSeedPane, lastPlayedPane, timePane, allowCheatsButton, generateFeaturesButton, difficultyPane});
        rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info.basic")), basicInfo});
        Object playerTag = this.dataTag.get("Player");
        if (playerTag instanceof CompoundTag) {
            String posString;
            Dimension dim;
            String posString2;
            CompoundTag player = (CompoundTag)playerTag;
            ComponentList playerInfo = new ComponentList();
            BorderPane locationPane = new BorderPane();
            label4 = new Label(I18n.i18n("world.info.player.location"));
            BorderPane.setAlignment((Node)label4, (Pos)Pos.CENTER_LEFT);
            locationPane.setLeft((Node)label4);
            Label locationLabel = new Label();
            BorderPane.setAlignment((Node)locationLabel, (Pos)Pos.CENTER_RIGHT);
            locationPane.setRight((Node)locationLabel);
            Dimension dim2 = Dimension.of(player.get("Dimension"));
            if (dim2 != null && (posString2 = dim2.formatPosition((Tag)player.get("Pos"))) != null) {
                locationLabel.setText(posString2);
            }
            BorderPane lastDeathLocationPane = new BorderPane();
            label5 = new Label(I18n.i18n("world.info.player.last_death_location"));
            BorderPane.setAlignment((Node)label5, (Pos)Pos.CENTER_LEFT);
            lastDeathLocationPane.setLeft((Node)label5);
            Label lastDeathLocationLabel = new Label();
            BorderPane.setAlignment((Node)lastDeathLocationLabel, (Pos)Pos.CENTER_RIGHT);
            lastDeathLocationPane.setRight((Node)lastDeathLocationLabel);
            tag2 = player.get("LastDeathLocation");
            if (tag2 instanceof CompoundTag && (dim = Dimension.of(((CompoundTag)tag2).get("dimension"))) != null && (posString = dim.formatPosition((Tag)((CompoundTag)tag2).get("pos"))) != null) {
                lastDeathLocationLabel.setText(posString);
            }
            BorderPane spawnPane = new BorderPane();
            Label label7 = new Label(I18n.i18n("world.info.player.spawn"));
            BorderPane.setAlignment((Node)label7, (Pos)Pos.CENTER_LEFT);
            spawnPane.setLeft((Node)label7);
            Label spawnLabel = new Label();
            BorderPane.setAlignment((Node)spawnLabel, (Pos)Pos.CENTER_RIGHT);
            spawnPane.setRight((Node)spawnLabel);
            dim = Dimension.of(player.get("SpawnDimension"));
            if (dim != null) {
                Object x = player.get("SpawnX");
                Object y = player.get("SpawnY");
                Object z = player.get("SpawnZ");
                if (x instanceof IntTag && y instanceof IntTag && z instanceof IntTag) {
                    spawnLabel.setText(dim.formatPosition(((IntTag)x).getValue(), ((IntTag)y).getValue(), ((IntTag)z).getValue()));
                }
            }
            BorderPane playerGameTypePane = new BorderPane();
            Label label8 = new Label(I18n.i18n("world.info.player.game_type"));
            BorderPane.setAlignment((Node)label8, (Pos)Pos.CENTER_LEFT);
            playerGameTypePane.setLeft((Node)label8);
            JFXComboBox<GameType> gameTypeBox = new JFXComboBox<GameType>(GameType.items);
            BorderPane.setAlignment(gameTypeBox, (Pos)Pos.CENTER_RIGHT);
            playerGameTypePane.setRight(gameTypeBox);
            Object tag5 = player.get("playerGameType");
            if (tag5 instanceof IntTag) {
                IntTag intTag = (IntTag)tag5;
                GameType gameType = GameType.of(intTag.getValue());
                if (gameType != null) {
                    gameTypeBox.setValue((Object)gameType);
                    gameTypeBox.valueProperty().addListener((o, oldValue, newValue) -> {
                        if (newValue != null) {
                            intTag.setValue(newValue.ordinal());
                            this.saveLevelDat();
                        }
                    });
                } else {
                    gameTypeBox.setDisable(true);
                }
            } else {
                gameTypeBox.setDisable(true);
            }
            BorderPane healthPane = new BorderPane();
            label6 = new Label(I18n.i18n("world.info.player.health"));
            BorderPane.setAlignment((Node)label6, (Pos)Pos.CENTER_LEFT);
            healthPane.setLeft((Node)label6);
            JFXTextField healthField = new JFXTextField();
            healthField.setPrefWidth(50.0);
            healthField.setAlignment(Pos.CENTER_RIGHT);
            BorderPane.setAlignment((Node)healthField, (Pos)Pos.CENTER_RIGHT);
            healthPane.setRight((Node)healthField);
            tag4 = player.get("Health");
            if (tag4 instanceof FloatTag) {
                FloatTag floatTag = (FloatTag)tag4;
                healthField.setText(new DecimalFormat("#").format(floatTag.getValue().floatValue()));
                healthField.textProperty().addListener((o, oldValue, newValue) -> {
                    if (newValue != null) {
                        try {
                            floatTag.setValue(Float.parseFloat(newValue));
                            this.saveLevelDat();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                FXUtils.setValidateWhileTextChanged((Node)healthField, true);
                healthField.setValidators(new DoubleValidator(I18n.i18n("input.number"), true));
            } else {
                healthField.setDisable(true);
            }
            BorderPane foodLevelPane = new BorderPane();
            Label label9 = new Label(I18n.i18n("world.info.player.food_level"));
            BorderPane.setAlignment((Node)label9, (Pos)Pos.CENTER_LEFT);
            foodLevelPane.setLeft((Node)label9);
            JFXTextField foodLevelField = new JFXTextField();
            foodLevelField.setPrefWidth(50.0);
            foodLevelField.setAlignment(Pos.CENTER_RIGHT);
            BorderPane.setAlignment((Node)foodLevelField, (Pos)Pos.CENTER_RIGHT);
            foodLevelPane.setRight((Node)foodLevelField);
            Object tag6 = player.get("foodLevel");
            if (tag6 instanceof IntTag) {
                IntTag intTag = (IntTag)tag6;
                foodLevelField.setText(String.valueOf(intTag.getValue()));
                foodLevelField.textProperty().addListener((o, oldValue, newValue) -> {
                    if (newValue != null) {
                        try {
                            intTag.setValue(Integer.parseInt(newValue));
                            this.saveLevelDat();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                FXUtils.setValidateWhileTextChanged((Node)foodLevelField, true);
                foodLevelField.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
            } else {
                foodLevelField.setDisable(true);
            }
            BorderPane xpLevelPane = new BorderPane();
            Label label10 = new Label(I18n.i18n("world.info.player.xp_level"));
            BorderPane.setAlignment((Node)label10, (Pos)Pos.CENTER_LEFT);
            xpLevelPane.setLeft((Node)label10);
            JFXTextField xpLevelField = new JFXTextField();
            xpLevelField.setPrefWidth(50.0);
            xpLevelField.setAlignment(Pos.CENTER_RIGHT);
            BorderPane.setAlignment((Node)xpLevelField, (Pos)Pos.CENTER_RIGHT);
            xpLevelPane.setRight((Node)xpLevelField);
            Object tag7 = player.get("XpLevel");
            if (tag7 instanceof IntTag) {
                IntTag intTag = (IntTag)tag7;
                xpLevelField.setText(String.valueOf(intTag.getValue()));
                xpLevelField.textProperty().addListener((o, oldValue, newValue) -> {
                    if (newValue != null) {
                        try {
                            intTag.setValue(Integer.parseInt(newValue));
                            this.saveLevelDat();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                FXUtils.setValidateWhileTextChanged((Node)xpLevelField, true);
                xpLevelField.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
            } else {
                xpLevelField.setDisable(true);
            }
            playerInfo.getContent().setAll((Object[])new Node[]{locationPane, lastDeathLocationPane, spawnPane, playerGameTypePane, healthPane, foodLevelPane, xpLevelPane});
            rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info.player")), playerInfo});
        }
    }

    private void saveLevelDat() {
        Logging.LOG.info("Saving level.dat of world " + this.world.getWorldName());
        try {
            this.world.writeLevelDat(this.levelDat);
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to save level.dat of world " + this.world.getWorldName(), e);
        }
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.stateProperty;
    }

    private static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

        static final ObservableList<Difficulty> items;

        static Difficulty of(int d) {
            return d >= 0 && d <= items.size() ? (Difficulty)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.difficulty." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(Difficulty.values()));
        }
    }

    private static final class Dimension {
        static final Dimension OVERWORLD = new Dimension(null);
        static final Dimension THE_NETHER = new Dimension(I18n.i18n("world.info.dimension.the_nether"));
        static final Dimension THE_END = new Dimension(I18n.i18n("world.info.dimension.the_end"));
        final String name;

        static Dimension of(Tag tag) {
            if (tag instanceof IntTag) {
                switch (((IntTag)tag).getValue()) {
                    case 0: {
                        return OVERWORLD;
                    }
                    case 1: {
                        return THE_NETHER;
                    }
                    case 2: {
                        return THE_END;
                    }
                }
                return null;
            }
            if (tag instanceof StringTag) {
                String id;
                switch (id = ((StringTag)tag).getValue()) {
                    case "overworld": 
                    case "minecraft:overworld": {
                        return OVERWORLD;
                    }
                    case "the_nether": 
                    case "minecraft:the_nether": {
                        return THE_NETHER;
                    }
                    case "the_end": 
                    case "minecraft:the_end": {
                        return THE_END;
                    }
                }
                return new Dimension(id);
            }
            return null;
        }

        private Dimension(String name) {
            this.name = name;
        }

        String formatPosition(Tag tag) {
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                if (listTag.size() != 3) {
                    return null;
                }
                Object x = listTag.get(0);
                Object y = listTag.get(1);
                Object z = listTag.get(2);
                if (x instanceof DoubleTag && y instanceof DoubleTag && z instanceof DoubleTag) {
                    return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue()) : String.format("%s (%.2f, %.2f, %.2f)", this.name, ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue());
                }
                return null;
            }
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int x = intArrayTag.getValue(0);
                int y = intArrayTag.getValue(1);
                int z = intArrayTag.getValue(2);
                return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
            }
            return null;
        }

        String formatPosition(int x, int y, int z) {
            return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
        }

        String formatPosition(double x, double y, double z) {
            return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", x, y, z) : String.format("%s (%.2f, %.2f, %.2f)", this.name, x, y, z);
        }
    }

    private static enum GameType {
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR;

        static final ObservableList<GameType> items;

        static GameType of(int d) {
            return d >= 0 && d <= items.size() ? (GameType)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.player.game_type." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(GameType.values()));
        }
    }
}

