/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXListView;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.HttpRequest;

public class SponsorPage
extends StackPane {
    private final JFXListView<Sponsor> listView;

    public SponsorPage() {
        VBox content = new VBox();
        content.setPadding(new Insets(10.0));
        content.setSpacing(10.0);
        content.setFillWidth(true);
        StackPane sponsorPane = new StackPane();
        sponsorPane.getStyleClass().add((Object)"card");
        sponsorPane.setCursor(Cursor.HAND);
        sponsorPane.setOnMouseClicked(e -> this.onSponsor());
        GridPane gridPane = new GridPane();
        ColumnConstraints col = new ColumnConstraints();
        col.setHgrow(Priority.SOMETIMES);
        col.setMaxWidth(Double.POSITIVE_INFINITY);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col});
        RowConstraints row = new RowConstraints();
        row.setMinHeight(Double.NEGATIVE_INFINITY);
        row.setValignment(VPos.TOP);
        row.setVgrow(Priority.SOMETIMES);
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row});
        Label label = new Label(I18n.i18n("sponsor.hmcl"));
        label.setWrapText(true);
        label.setTextAlignment(TextAlignment.JUSTIFY);
        GridPane.setRowIndex((Node)label, (Integer)0);
        GridPane.setColumnIndex((Node)label, (Integer)0);
        gridPane.getChildren().add((Object)label);
        sponsorPane.getChildren().setAll((Object[])new Node[]{gridPane});
        content.getChildren().add((Object)sponsorPane);
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"card");
        this.listView = new JFXListView();
        final Holder lastCell = new Holder();
        this.listView.setCellFactory(listView -> new JFXListCell<Sponsor>(){

            @Override
            public void updateItem(Sponsor item, boolean empty) {
                super.updateItem(item, empty);
                if (this == lastCell.value && !this.isVisible()) {
                    return;
                }
                lastCell.value = this;
                if (!empty) {
                    this.setText(item.getName());
                    this.setGraphic(null);
                }
            }
        });
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        pane.getChildren().setAll((Object[])new Node[]{this.listView});
        content.getChildren().add((Object)pane);
        this.loadSponsorList();
        this.getChildren().setAll((Object[])new Node[]{content});
    }

    private void onSponsor() {
        FXUtils.openLink("https://hmcl.huangyuhui.net/api/redirect/sponsor");
    }

    private void loadSponsorList() {
        Task.supplyAsync(() -> (List)HttpRequest.GET("https://hmcl.huangyuhui.net/api/sponsor").getJson(new TypeToken<List<Sponsor>>(){}.getType())).thenAcceptAsync(Schedulers.javafx(), sponsors -> this.listView.getItems().setAll((Collection)sponsors)).start();
    }

    private static class Sponsor {
        @SerializedName(value="name")
        private final String name;
        @SerializedName(value="create_time")
        private final Instant createTime;
        @SerializedName(value="money")
        private final BigDecimal money;
        @SerializedName(value="contact")
        private final String contact;
        @SerializedName(value="afdian_id")
        private final String afdianId;

        public Sponsor() {
            this("", Instant.now(), BigDecimal.ZERO, "", "");
        }

        public Sponsor(String name, Instant createTime, BigDecimal money, String contact, String afdianId) {
            this.name = name;
            this.createTime = createTime;
            this.money = money;
            this.contact = contact;
            this.afdianId = afdianId;
        }

        public String getName() {
            return this.name;
        }

        public Instant getCreateTime() {
            return this.createTime;
        }

        public BigDecimal getMoney() {
            return this.money;
        }

        public String getContact() {
            return this.contact;
        }

        public String getAfdianId() {
            return this.afdianId;
        }
    }
}

