/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.main.AboutPage;
import org.jackhuang.hmcl.ui.main.DownloadSettingsPage;
import org.jackhuang.hmcl.ui.main.FeedbackPage;
import org.jackhuang.hmcl.ui.main.HelpPage;
import org.jackhuang.hmcl.ui.main.PersonalizationPage;
import org.jackhuang.hmcl.ui.main.SettingsPage;
import org.jackhuang.hmcl.ui.main.SponsorPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.VersionSettingsPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class LauncherSettingsPage
extends DecoratorAnimatedPage
implements DecoratorPage,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("settings")));
    private final TabHeader tab;
    private final TabControl.Tab<VersionSettingsPage> gameTab = new TabControl.Tab("versionSettingsPage");
    private final TabControl.Tab<SettingsPage> settingsTab = new TabControl.Tab("settingsPage");
    private final TabControl.Tab<PersonalizationPage> personalizationTab = new TabControl.Tab("personalizationPage");
    private final TabControl.Tab<DownloadSettingsPage> downloadTab = new TabControl.Tab("downloadSettingsPage");
    private final TabControl.Tab<HelpPage> helpTab = new TabControl.Tab("helpPage");
    private final TabControl.Tab<AboutPage> aboutTab = new TabControl.Tab("aboutPage");
    private final TabControl.Tab<FeedbackPage> feedbackTab = new TabControl.Tab("feedbackPage");
    private final TabControl.Tab<SponsorPage> sponsorTab = new TabControl.Tab("sponsorPage");
    private final TransitionPane transitionPane = new TransitionPane();

    public LauncherSettingsPage() {
        this.gameTab.setNodeSupplier(() -> new VersionSettingsPage(true));
        this.settingsTab.setNodeSupplier(SettingsPage::new);
        this.personalizationTab.setNodeSupplier(PersonalizationPage::new);
        this.downloadTab.setNodeSupplier(DownloadSettingsPage::new);
        this.helpTab.setNodeSupplier(HelpPage::new);
        this.feedbackTab.setNodeSupplier(FeedbackPage::new);
        this.sponsorTab.setNodeSupplier(SponsorPage::new);
        this.aboutTab.setNodeSupplier(AboutPage::new);
        this.tab = new TabHeader(this.gameTab, this.settingsTab, this.personalizationTab, this.downloadTab, this.helpTab, this.feedbackTab, this.sponsorTab, this.aboutTab);
        this.tab.select(this.gameTab);
        this.gameTab.initializeIfNeeded();
        this.gameTab.getNode().loadVersion(Profiles.getSelectedProfile(), null);
        FXUtils.onChangeAndOperate(this.tab.getSelectionModel().selectedItemProperty(), newValue -> this.transitionPane.setContent((Node)newValue.getNode(), ContainerAnimations.FADE.getAnimationProducer()));
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerItem(settingsItem -> {
            settingsItem.setTitle(I18n.i18n("settings.type.global.manage"));
            settingsItem.setLeftGraphic(VersionPage.wrap(SVG.GAMEPAD));
            settingsItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.gameTab));
            FXUtils.runInFX(() -> FXUtils.installFastTooltip((Node)settingsItem, I18n.i18n("settings.type.global.manage")));
            settingsItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.gameTab)));
        }).startCategory(I18n.i18n("launcher")).addNavigationDrawerItem(settingsItem -> {
            settingsItem.setTitle(I18n.i18n("settings.launcher.general"));
            settingsItem.setLeftGraphic(VersionPage.wrap(SVG.APPLICATION_OUTLINE));
            settingsItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.settingsTab));
            settingsItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.settingsTab)));
        }).addNavigationDrawerItem(personalizationItem -> {
            personalizationItem.setTitle(I18n.i18n("settings.launcher.appearance"));
            personalizationItem.setLeftGraphic(VersionPage.wrap(SVG.STYLE_OUTLINE));
            personalizationItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.personalizationTab));
            personalizationItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.personalizationTab)));
        }).addNavigationDrawerItem(downloadItem -> {
            downloadItem.setTitle(I18n.i18n("download"));
            downloadItem.setLeftGraphic(VersionPage.wrap(SVG.DOWNLOAD_OUTLINE));
            downloadItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.downloadTab));
            downloadItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.downloadTab)));
        }).startCategory(I18n.i18n("help")).addNavigationDrawerItem(helpItem -> {
            helpItem.setTitle(I18n.i18n("help"));
            helpItem.setLeftGraphic(VersionPage.wrap(SVG.HELP_CIRCLE_OUTLINE));
            helpItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.helpTab));
            helpItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.helpTab)));
        }).addNavigationDrawerItem(feedbackItem -> {
            feedbackItem.setTitle(I18n.i18n("feedback"));
            feedbackItem.setLeftGraphic(VersionPage.wrap(SVG.MESSAGE_ALERT_OUTLINE));
            feedbackItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.feedbackTab));
            feedbackItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.feedbackTab)));
        }).addNavigationDrawerItem(sponsorItem -> {
            sponsorItem.setTitle(I18n.i18n("sponsor"));
            sponsorItem.setLeftGraphic(VersionPage.wrap(SVG.HAND_HEAR_OUTLINE));
            sponsorItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.sponsorTab));
            sponsorItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.sponsorTab)));
        }).addNavigationDrawerItem(aboutItem -> {
            aboutItem.setTitle(I18n.i18n("about"));
            aboutItem.setLeftGraphic(VersionPage.wrap(SVG.INFORMATION_OUTLINE));
            aboutItem.activeProperty().bind((ObservableValue)this.tab.getSelectionModel().selectedItemProperty().isEqualTo(this.aboutTab));
            aboutItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.tab.select(this.aboutTab)));
        });
        FXUtils.setLimitWidth((Region)sideBar, 200.0);
        this.setLeft(new Node[]{sideBar});
        this.setCenter(new Node[]{this.transitionPane});
    }

    @Override
    public void onPageShown() {
        this.tab.onPageShown();
    }

    @Override
    public void onPageHidden() {
        this.tab.onPageHidden();
    }

    public void showGameSettings(Profile profile) {
        this.gameTab.getNode().loadVersion(profile, null);
        this.tab.select(this.gameTab);
    }

    public void showFeedback() {
        this.tab.select(this.feedbackTab);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }
}

