/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public abstract class ModpackPage
extends SpinnerPane
implements WizardPage {
    protected final WizardController controller;
    protected final Label lblName;
    protected final Label lblVersion;
    protected final Label lblAuthor;
    protected final Label lblModpackLocation;
    protected final JFXTextField txtModpackName;
    protected final JFXButton btnInstall;

    protected ModpackPage(WizardController controller) {
        this.controller = controller;
        this.getStyleClass().add((Object)"large-spinner-pane");
        VBox borderPane = new VBox();
        borderPane.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)borderPane, 500.0);
        ComponentList componentList = new ComponentList();
        BorderPane locationPane = new BorderPane();
        locationPane.setLeft((Node)new Label(I18n.i18n("modpack.task.install.will")));
        this.lblModpackLocation = new Label();
        BorderPane.setAlignment((Node)this.lblModpackLocation, (Pos)Pos.CENTER_RIGHT);
        locationPane.setCenter((Node)this.lblModpackLocation);
        BorderPane archiveNamePane = new BorderPane();
        Label label = new Label(I18n.i18n("archive.name"));
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        archiveNamePane.setLeft((Node)label);
        this.txtModpackName = new JFXTextField();
        BorderPane.setMargin((Node)this.txtModpackName, (Insets)new Insets(0.0, 0.0, 8.0, 32.0));
        BorderPane.setAlignment((Node)this.txtModpackName, (Pos)Pos.CENTER_RIGHT);
        archiveNamePane.setCenter((Node)this.txtModpackName);
        BorderPane modpackNamePane = new BorderPane();
        modpackNamePane.setLeft((Node)new Label(I18n.i18n("modpack.name")));
        this.lblName = new Label();
        BorderPane.setAlignment((Node)this.lblName, (Pos)Pos.CENTER_RIGHT);
        modpackNamePane.setCenter((Node)this.lblName);
        BorderPane versionPane = new BorderPane();
        versionPane.setLeft((Node)new Label(I18n.i18n("archive.version")));
        this.lblVersion = new Label();
        BorderPane.setAlignment((Node)this.lblVersion, (Pos)Pos.CENTER_RIGHT);
        versionPane.setCenter((Node)this.lblVersion);
        BorderPane authorPane = new BorderPane();
        authorPane.setLeft((Node)new Label(I18n.i18n("archive.author")));
        this.lblAuthor = new Label();
        BorderPane.setAlignment((Node)this.lblAuthor, (Pos)Pos.CENTER_RIGHT);
        authorPane.setCenter((Node)this.lblAuthor);
        BorderPane descriptionPane = new BorderPane();
        JFXButton btnDescription = new JFXButton(I18n.i18n("modpack.description"));
        btnDescription.getStyleClass().add((Object)"jfx-button-border");
        btnDescription.setOnAction(e -> this.onDescribe());
        descriptionPane.setLeft((Node)btnDescription);
        this.btnInstall = FXUtils.newRaisedButton(I18n.i18n("button.install"));
        this.btnInstall.setOnAction(e -> this.onInstall());
        this.btnInstall.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.txtModpackName.validate(), (Observable[])new Observable[]{this.txtModpackName.textProperty()}));
        descriptionPane.setRight((Node)this.btnInstall);
        componentList.getContent().setAll((Object[])new Node[]{locationPane, archiveNamePane, modpackNamePane, versionPane, authorPane, descriptionPane});
        borderPane.getChildren().setAll((Object[])new Node[]{componentList});
        this.setContent((Node)borderPane);
    }

    protected abstract void onInstall();

    protected abstract void onDescribe();

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

