/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InstallersPage
extends Control
implements WizardPage {
    protected final WizardController controller;
    protected InstallerItem.InstallerItemGroup group;
    protected JFXTextField txtName = new JFXTextField();
    protected BooleanProperty installable = new SimpleBooleanProperty();

    public InstallersPage(WizardController controller, HMCLGameRepository repository, String gameVersion, DownloadProvider downloadProvider) {
        this.controller = controller;
        this.group = new InstallerItem.InstallerItemGroup(gameVersion);
        this.txtName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !repository.versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(this.txtName::validate, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.txtName.setText(gameVersion);
        this.group.game.installable.setValue(Boolean.valueOf(false));
        for (InstallerItem item : this.group.getLibraries()) {
            item.setStyleMode(InstallerItem.Style.CARD);
        }
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId())) continue;
            library.action.set(e -> {
                if (LibraryAnalyzer.LibraryType.FABRIC_API.getPatchId().equals(libraryId)) {
                    Controllers.dialog(I18n.i18n("install.installer.fabric-api.warning"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING);
                }
                if (library.incompatibleLibraryName.get() == null) {
                    controller.onNext((Node)new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer." + libraryId)), gameVersion, downloadProvider, libraryId, () -> controller.onPrev(false)));
                }
            });
            library.removeAction.set(e -> {
                controller.getSettings().remove(libraryId);
                this.reload();
            });
        }
    }

    @Override
    public String getTitle() {
        return I18n.i18n("install.new_game");
    }

    private String getVersion(String id) {
        return ((RemoteVersion)this.controller.getSettings().get(id)).getSelfVersion();
    }

    protected void reload() {
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (this.controller.getSettings().containsKey(libraryId)) {
                library.libraryVersion.set((Object)this.getVersion(libraryId));
                library.removable.set(true);
                continue;
            }
            library.libraryVersion.set(null);
            library.removable.set(false);
        }
    }

    @Override
    public void onNavigate(Map<String, Object> settings) {
        this.reload();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    protected void onInstall() {
        this.controller.getSettings().put("name", this.txtName.getText());
        this.controller.onFinish();
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallersPageSkin(this);
    }

    protected static class InstallersPageSkin
    extends SkinBase<InstallersPage> {
        protected InstallersPageSkin(InstallersPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            root.setPadding(new Insets(16.0));
            HBox versionNamePane = new HBox(8.0);
            versionNamePane.getStyleClass().add((Object)"card-non-transparent");
            versionNamePane.setStyle("-fx-padding: 20 8 20 16");
            versionNamePane.setAlignment(Pos.CENTER_LEFT);
            control.txtName.setMaxWidth(300.0);
            versionNamePane.getChildren().setAll((Object[])new Node[]{new Label(I18n.i18n("archive.name")), control.txtName});
            root.setTop((Node)versionNamePane);
            InstallerItem[] libraries = control.group.getLibraries();
            FlowPane libraryPane = new FlowPane((Node[])libraries);
            libraryPane.setVgap(16.0);
            libraryPane.setHgap(16.0);
            if (libraries.length <= 8) {
                BorderPane.setMargin((Node)libraryPane, (Insets)new Insets(16.0, 0.0, 16.0, 0.0));
                root.setCenter((Node)libraryPane);
            } else {
                ScrollPane scrollPane = new ScrollPane((Node)libraryPane);
                scrollPane.setFitToWidth(true);
                scrollPane.setFitToHeight(true);
                BorderPane.setMargin((Node)scrollPane, (Insets)new Insets(16.0, 0.0, 16.0, 0.0));
                root.setCenter((Node)scrollPane);
            }
            JFXButton installButton = FXUtils.newRaisedButton(I18n.i18n("button.install"));
            installButton.disableProperty().bind((ObservableValue)control.installable.not());
            installButton.setPrefWidth(100.0);
            installButton.setPrefHeight(40.0);
            installButton.setOnMouseClicked(e -> control.onInstall());
            BorderPane.setAlignment((Node)installButton, (Pos)Pos.CENTER_RIGHT);
            root.setBottom((Node)installButton);
            this.getChildren().setAll((Object[])new Node[]{root});
        }
    }
}

