/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXSnackbar;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDnD;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.StackContainerPane;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimationProducer;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class DecoratorController {
    private static final String PROPERTY_DIALOG_CLOSE_HANDLER = DecoratorController.class.getName() + ".dialog.closeListener";
    private final Decorator decorator;
    private final Navigator navigator;
    private JFXDialog dialog;
    private StackContainerPane dialogPane;
    private int changeBackgroundCount = 0;
    private final InvalidationListener changeBackgroundListener;
    private static final DecoratorAnimationProducer animation = new DecoratorAnimationProducer();

    public DecoratorController(Stage stage, Node mainPage) {
        this.decorator = new Decorator(stage);
        this.decorator.setOnCloseButtonAction(Launcher::stopApplication);
        this.decorator.titleTransparentProperty().bind((ObservableValue)ConfigHolder.config().titleTransparentProperty());
        this.navigator = new Navigator();
        this.navigator.setOnNavigated((EventHandler<Navigator.NavigationEvent>)((EventHandler)this::onNavigated));
        this.navigator.init(mainPage);
        this.decorator.getContent().setAll((Object[])new Node[]{this.navigator});
        this.decorator.onCloseNavButtonActionProperty().set(e -> this.close());
        this.decorator.onBackNavButtonActionProperty().set(e -> this.back());
        this.decorator.onRefreshNavButtonActionProperty().set(e -> this.refresh());
        this.setupAuthlibInjectorDnD();
        this.decorator.setContentBackground(this.getBackground());
        this.changeBackgroundListener = o -> {
            int currentCount = ++this.changeBackgroundCount;
            CompletableFuture.supplyAsync(this::getBackground, Schedulers.io()).thenAcceptAsync(background -> {
                if (this.changeBackgroundCount == currentCount) {
                    this.decorator.setContentBackground((Background)background);
                }
            }, Schedulers.javafx());
        };
        WeakInvalidationListener weakListener = new WeakInvalidationListener(this.changeBackgroundListener);
        ConfigHolder.config().backgroundImageTypeProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundImageProperty().addListener((InvalidationListener)weakListener);
        ConfigHolder.config().backgroundImageUrlProperty().addListener((InvalidationListener)weakListener);
        this.decorator.addEventFilter(KeyEvent.ANY, e -> {
            if (!(e.getTarget() instanceof Node)) {
                return;
            }
            Node newTarget = this.dialogPane != null && this.dialogPane.peek().isPresent() ? this.dialogPane.peek().get() : this.navigator.getCurrentPage();
            boolean needsRedirect = true;
            for (Node t = (Node)e.getTarget(); t != null; t = t.getParent()) {
                if (t != newTarget) continue;
                needsRedirect = false;
                break;
            }
            if (!needsRedirect) {
                return;
            }
            e.consume();
            newTarget.fireEvent((Event)e.copyFor(e.getSource(), (EventTarget)newTarget));
        });
        FXUtils.onEscPressed((Node)this.navigator, this::back);
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    private Background getBackground() {
        EnumBackgroundImage imageType = ConfigHolder.config().getBackgroundImageType();
        Image image = null;
        switch (imageType) {
            case CUSTOM: {
                String backgroundImage = ConfigHolder.config().getBackgroundImage();
                if (backgroundImage == null) break;
                image = this.tryLoadImage(Paths.get(backgroundImage, new String[0])).orElse(null);
                break;
            }
            case NETWORK: {
                String backgroundImageUrl = ConfigHolder.config().getBackgroundImageUrl();
                if (backgroundImageUrl == null || !NetworkUtils.isURL(backgroundImageUrl)) break;
                image = this.tryLoadImage(backgroundImageUrl).orElse(null);
                break;
            }
            case CLASSIC: {
                image = FXUtils.newBuiltinImage("/assets/img/background-classic.jpg");
                break;
            }
            case TRANSLUCENT: {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)new Color(1.0, 1.0, 1.0, 0.5), CornerRadii.EMPTY, Insets.EMPTY)});
            }
        }
        if (image == null) {
            image = this.loadDefaultBackgroundImage();
        }
        return new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, new BackgroundSize(800.0, 480.0, false, false, true, true))});
    }

    private Image loadDefaultBackgroundImage() {
        Optional<Image> image = this.randomImageIn(Paths.get("bg", new String[0]));
        if (!image.isPresent()) {
            image = this.tryLoadImage(Paths.get("background.png", new String[0]));
        }
        if (!image.isPresent()) {
            image = this.tryLoadImage(Paths.get("background.jpg", new String[0]));
        }
        if (!image.isPresent()) {
            image = this.tryLoadImage(Paths.get("background.gif", new String[0]));
        }
        return image.orElseGet(() -> FXUtils.newBuiltinImage("/assets/img/background.jpg"));
    }

    private Optional<Image> randomImageIn(Path imageDir) {
        List candidates;
        if (!Files.isDirectory(imageDir, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> stream = Files.list(imageDir);){
            candidates = stream.filter(Files::isReadable).filter(it -> {
                String ext = FileUtils.getExtension(it).toLowerCase(Locale.ROOT);
                return ext.equals("png") || ext.equals("jpg") || ext.equals("gif");
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to list files in ./bg", e);
            return Optional.empty();
        }
        Random rnd = new Random();
        while (candidates.size() > 0) {
            int selected = rnd.nextInt(candidates.size());
            Optional<Image> loaded = this.tryLoadImage((Path)candidates.get(selected));
            if (loaded.isPresent()) {
                return loaded;
            }
            candidates.remove(selected);
        }
        return Optional.empty();
    }

    private Optional<Image> tryLoadImage(Path path) {
        if (!Files.isReadable(path)) {
            return Optional.empty();
        }
        return this.tryLoadImage(path.toAbsolutePath().toUri().toString());
    }

    private Optional<Image> tryLoadImage(String url) {
        Image img;
        try {
            img = new Image(url);
        }
        catch (IllegalArgumentException e) {
            Logging.LOG.log(Level.WARNING, "Couldn't load background image", e);
            return Optional.empty();
        }
        if (img.getException() != null) {
            Logging.LOG.log(Level.WARNING, "Couldn't load background image", img.getException());
            return Optional.empty();
        }
        return Optional.of(img);
    }

    public void navigate(Node node) {
        this.navigator.navigate(node, animation);
    }

    private void close() {
        DecoratorPage page;
        if (this.navigator.getCurrentPage() instanceof DecoratorPage && (page = (DecoratorPage)this.navigator.getCurrentPage()).isPageCloseable()) {
            page.closePage();
            return;
        }
        this.navigator.clear();
    }

    private void back() {
        if (this.navigator.getCurrentPage() instanceof DecoratorPage) {
            DecoratorPage page = (DecoratorPage)this.navigator.getCurrentPage();
            if (page.back() && this.navigator.canGoBack()) {
                this.navigator.close();
            }
        } else if (this.navigator.canGoBack()) {
            this.navigator.close();
        }
    }

    private void refresh() {
        Refreshable refreshable;
        if (this.navigator.getCurrentPage() instanceof Refreshable && (refreshable = (Refreshable)this.navigator.getCurrentPage()).refreshableProperty().get()) {
            refreshable.refresh();
        }
    }

    private void onNavigated(Navigator.NavigationEvent event) {
        if (event.getSource() != this.navigator) {
            return;
        }
        Node to = event.getNode();
        if (to instanceof Refreshable) {
            this.decorator.canRefreshProperty().bind((ObservableValue)((Refreshable)to).refreshableProperty());
        } else {
            this.decorator.canRefreshProperty().unbind();
            this.decorator.canRefreshProperty().set(false);
        }
        this.decorator.canCloseProperty().set(this.navigator.size() > 2);
        if (to instanceof DecoratorPage) {
            this.decorator.showCloseAsHomeProperty().set(!((DecoratorPage)to).isPageCloseable());
        } else {
            this.decorator.showCloseAsHomeProperty().set(true);
        }
        this.decorator.setNavigationDirection(event.getDirection());
        if (to instanceof DecoratorPage) {
            this.decorator.stateProperty().bind(((DecoratorPage)to).stateProperty());
        } else {
            this.decorator.stateProperty().unbind();
            this.decorator.stateProperty().set((Object)new DecoratorPage.State("", null, this.navigator.canGoBack(), false, true));
        }
        if (to instanceof Region) {
            Region region = (Region)to;
            StackPane parent = (StackPane)region.getParent();
            region.prefWidthProperty().bind((ObservableValue)parent.widthProperty());
            region.prefHeightProperty().bind((ObservableValue)parent.heightProperty());
        }
    }

    public void showDialog(Node node) {
        FXUtils.checkFxUserThread();
        if (this.dialog == null) {
            if (this.decorator.getDrawerWrapper() == null) {
                Platform.runLater(() -> this.showDialog(node));
                return;
            }
            this.dialog = new JFXDialog();
            this.dialogPane = new StackContainerPane();
            this.dialog.setContent((Region)this.dialogPane);
            this.decorator.capableDraggingWindow((Node)this.dialog);
            this.decorator.forbidDraggingWindow((Node)this.dialogPane);
            this.dialog.setDialogContainer(this.decorator.getDrawerWrapper());
            this.dialog.setOverlayClose(false);
            this.dialog.show();
            this.navigator.setDisable(true);
        }
        this.dialogPane.push(node);
        EventHandler handler = event -> this.closeDialog(node);
        node.getProperties().put((Object)PROPERTY_DIALOG_CLOSE_HANDLER, (Object)handler);
        node.addEventHandler(DialogCloseEvent.CLOSE, handler);
        if (node instanceof DialogAware) {
            final DialogAware dialogAware = (DialogAware)node;
            if (this.dialog.isVisible()) {
                dialogAware.onDialogShown();
            } else {
                this.dialog.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        if (newValue.booleanValue()) {
                            dialogAware.onDialogShown();
                            observable.removeListener((ChangeListener)this);
                        }
                    }
                });
            }
        }
    }

    private void closeDialog(Node node) {
        FXUtils.checkFxUserThread();
        Optional.ofNullable(node.getProperties().get((Object)PROPERTY_DIALOG_CLOSE_HANDLER)).ifPresent(handler -> node.removeEventHandler(DialogCloseEvent.CLOSE, (EventHandler)handler));
        if (this.dialog != null) {
            this.dialogPane.pop(node);
            if (node instanceof DialogAware) {
                ((DialogAware)node).onDialogClosed();
            }
            if (this.dialogPane.getChildren().isEmpty()) {
                this.dialog.close();
                this.dialog = null;
                this.dialogPane = null;
                this.navigator.setDisable(false);
            }
        }
    }

    public void showToast(String content) {
        this.decorator.getSnackbar().fireEvent(new JFXSnackbar.SnackbarEvent(content, null, 2000L, false, null));
    }

    public void startWizard(WizardProvider wizardProvider) {
        this.startWizard(wizardProvider, null);
    }

    public void startWizard(WizardProvider wizardProvider, String category) {
        FXUtils.checkFxUserThread();
        this.navigator.navigate((Node)new DecoratorWizardDisplayer(wizardProvider, category), ContainerAnimations.FADE.getAnimationProducer());
    }

    private void setupAuthlibInjectorDnD() {
        this.decorator.addEventFilter(DragEvent.DRAG_OVER, AuthlibInjectorDnD.dragOverHandler());
        this.decorator.addEventFilter(DragEvent.DRAG_DROPPED, AuthlibInjectorDnD.dragDroppedHandler(url -> Controllers.dialog((Region)new AddAuthlibInjectorServerPane((String)url))));
    }
}

