/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXListView;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.Holder;

public abstract class MDListCell<T>
extends ListCell<T> {
    private final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final StackPane container = new StackPane();
    private final StackPane root = new StackPane();
    private final Holder<Object> lastCell;

    public MDListCell(JFXListView<T> listView, Holder<Object> lastCell) {
        this.lastCell = lastCell;
        this.setText(null);
        this.setGraphic(null);
        this.root.getStyleClass().add((Object)"md-list-cell");
        RipplerContainer ripplerContainer = new RipplerContainer((Node)this.container);
        this.root.getChildren().setAll((Object[])new Node[]{ripplerContainer});
        Region clippedContainer = (Region)listView.lookup(".clipped-container");
        this.setPrefWidth(0.0);
        if (clippedContainer != null) {
            this.maxWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
            this.prefWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
            this.minWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
        }
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (this.lastCell != null) {
            if (this == this.lastCell.value && !this.isVisible()) {
                return;
            }
            this.lastCell.value = this;
        }
        this.updateControl(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.root);
        }
    }

    protected StackPane getContainer() {
        return this.container;
    }

    protected void setSelectable() {
        FXUtils.onChangeAndOperate(this.selectedProperty(), selected -> this.root.pseudoClassStateChanged(this.SELECTED, selected.booleanValue()));
    }

    protected abstract void updateControl(T var1, boolean var2);
}

