/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ClassTitle;

public class AdvancedListBox
extends ScrollPane {
    private final VBox container = new VBox();

    public AdvancedListBox() {
        this.setContent((Node)this.container);
        FXUtils.smoothScrolling(this);
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.container.getStyleClass().add((Object)"advanced-list-box-content");
    }

    public AdvancedListBox add(Node child) {
        if (child instanceof Pane || child instanceof AdvancedListItem) {
            this.container.getChildren().add((Object)child);
        } else {
            StackPane pane = new StackPane();
            pane.getStyleClass().add((Object)"advanced-list-box-item");
            pane.getChildren().setAll((Object[])new Node[]{child});
            this.container.getChildren().add((Object)pane);
        }
        return this;
    }

    public AdvancedListBox addNavigationDrawerItem(Consumer<AdvancedListItem> fn) {
        AdvancedListItem item = new AdvancedListItem();
        item.getStyleClass().add((Object)"navigation-drawer-item");
        item.setActionButtonVisible(false);
        fn.accept(item);
        return this.add((Node)item);
    }

    public AdvancedListBox add(int index, Node child) {
        if (child instanceof Pane || child instanceof AdvancedListItem) {
            this.container.getChildren().add(index, (Object)child);
        } else {
            StackPane pane = new StackPane();
            pane.getStyleClass().add((Object)"advanced-list-box-item");
            pane.getChildren().setAll((Object[])new Node[]{child});
            this.container.getChildren().add(index, (Object)pane);
        }
        return this;
    }

    public AdvancedListBox remove(Node child) {
        this.container.getChildren().remove(this.indexOf(child));
        return this;
    }

    public int indexOf(Node child) {
        if (child instanceof Pane) {
            return this.container.getChildren().indexOf((Object)child);
        }
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            ObservableList list;
            Node node = (Node)this.container.getChildren().get(i);
            if (!(node instanceof StackPane) || (list = ((StackPane)node).getChildren()).size() != 1 || list.get(0) != child) continue;
            return i;
        }
        return -1;
    }

    public AdvancedListBox startCategory(String category) {
        return this.add((Node)new ClassTitle(category));
    }

    public void setSpacing(double spacing) {
        this.container.setSpacing(spacing);
    }

    public void clear() {
        this.container.getChildren().clear();
    }
}

