/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class InstallerItem
extends Control {
    private final String id;
    private final VersionIconType iconType;
    public final StringProperty libraryVersion = new SimpleStringProperty();
    public final StringProperty incompatibleLibraryName = new SimpleStringProperty();
    public final StringProperty dependencyName = new SimpleStringProperty();
    public final BooleanProperty incompatibleWithGame = new SimpleBooleanProperty();
    public final BooleanProperty removable = new SimpleBooleanProperty();
    public final BooleanProperty upgradable = new SimpleBooleanProperty(false);
    public final BooleanProperty installable = new SimpleBooleanProperty(true);
    public final ObjectProperty<EventHandler<? super MouseEvent>> removeAction = new SimpleObjectProperty();
    public final ObjectProperty<EventHandler<? super MouseEvent>> action = new SimpleObjectProperty();
    private Style style = Style.LIST_ITEM;

    public InstallerItem(LibraryAnalyzer.LibraryType id) {
        this(id.getPatchId());
    }

    public InstallerItem(String id) {
        this.id = id;
        switch (id) {
            case "game": {
                this.iconType = VersionIconType.GRASS;
                break;
            }
            case "fabric": 
            case "fabric-api": {
                this.iconType = VersionIconType.FABRIC;
                break;
            }
            case "forge": {
                this.iconType = VersionIconType.FORGE;
                break;
            }
            case "liteloader": {
                this.iconType = VersionIconType.CHICKEN;
                break;
            }
            case "optifine": {
                this.iconType = VersionIconType.OPTIFINE;
                break;
            }
            case "quilt": 
            case "quilt-api": {
                this.iconType = VersionIconType.QUILT;
                break;
            }
            case "neoforge": {
                this.iconType = VersionIconType.NEO_FORGE;
                break;
            }
            default: {
                this.iconType = null;
            }
        }
    }

    public void setStyleMode(Style style) {
        this.style = style;
    }

    public void setState(String libraryVersion, boolean incompatibleWithGame, boolean removable) {
        this.libraryVersion.set((Object)libraryVersion);
        this.incompatibleWithGame.set(incompatibleWithGame);
        this.removable.set(removable);
    }

    public String getLibraryId() {
        return this.id;
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallerItemSkin(this);
    }

    public static enum Style {
        LIST_ITEM,
        CARD;

    }

    public static class InstallerItemSkin
    extends SkinBase<InstallerItem> {
        private static final PseudoClass LIST_ITEM = PseudoClass.getPseudoClass((String)"list-item");
        private static final PseudoClass CARD = PseudoClass.getPseudoClass((String)"card");

        InstallerItemSkin(InstallerItem control) {
            super((Control)control);
            Object pane = control.style == Style.CARD ? new VBox() : new HBox();
            pane.getStyleClass().add((Object)"installer-item");
            RipplerContainer container = new RipplerContainer((Node)pane);
            this.getChildren().setAll((Object[])new Node[]{container});
            pane.pseudoClassStateChanged(LIST_ITEM, control.style == Style.LIST_ITEM);
            pane.pseudoClassStateChanged(CARD, control.style == Style.CARD);
            if (control.iconType != null) {
                ImageView view = new ImageView(control.iconType.getIcon());
                Node node = FXUtils.limitingSize((Node)view, 32.0, 32.0);
                node.setMouseTransparent(true);
                node.getStyleClass().add((Object)"installer-item-image");
                pane.getChildren().add((Object)node);
                if (control.style == Style.CARD) {
                    VBox.setMargin((Node)node, (Insets)new Insets(8.0, 0.0, 16.0, 0.0));
                }
            }
            Label nameLabel = new Label();
            nameLabel.getStyleClass().add((Object)"installer-item-name");
            nameLabel.setMouseTransparent(true);
            pane.getChildren().add((Object)nameLabel);
            nameLabel.textProperty().set((Object)(I18n.hasKey("install.installer." + control.id) ? I18n.i18n("install.installer." + control.id) : control.id));
            HBox.setMargin((Node)nameLabel, (Insets)new Insets(0.0, 4.0, 0.0, 4.0));
            Label statusLabel = new Label();
            statusLabel.getStyleClass().add((Object)"installer-item-status");
            statusLabel.setMouseTransparent(true);
            pane.getChildren().add((Object)statusLabel);
            HBox.setHgrow((Node)statusLabel, (Priority)Priority.ALWAYS);
            statusLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                String incompatibleWith = (String)control.incompatibleLibraryName.get();
                String version = (String)control.libraryVersion.get();
                if (control.incompatibleWithGame.get()) {
                    return I18n.i18n("install.installer.change_version", version);
                }
                if (incompatibleWith != null) {
                    return I18n.i18n("install.installer.incompatible", I18n.i18n("install.installer." + incompatibleWith));
                }
                if (version == null) {
                    return I18n.i18n("install.installer.not_installed");
                }
                return I18n.i18n("install.installer.version", version);
            }, (Observable[])new Observable[]{control.incompatibleLibraryName, control.incompatibleWithGame, control.libraryVersion}));
            BorderPane.setMargin((Node)statusLabel, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
            BorderPane.setAlignment((Node)statusLabel, (Pos)Pos.CENTER_LEFT);
            HBox buttonsContainer = new HBox();
            buttonsContainer.setSpacing(8.0);
            buttonsContainer.setAlignment(Pos.CENTER);
            pane.getChildren().add((Object)buttonsContainer);
            JFXButton closeButton = new JFXButton();
            closeButton.setGraphic(SVG.CLOSE.createIcon((Paint)Theme.blackFill(), -1.0, -1.0));
            closeButton.getStyleClass().add((Object)"toggle-icon4");
            closeButton.visibleProperty().bind((ObservableValue)control.removable);
            closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
            closeButton.onMouseClickedProperty().bind(control.removeAction);
            buttonsContainer.getChildren().add((Object)closeButton);
            JFXButton arrowButton = new JFXButton();
            arrowButton.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> control.upgradable.get() ? SVG.UPDATE.createIcon((Paint)Theme.blackFill(), -1.0, -1.0) : SVG.ARROW_RIGHT.createIcon((Paint)Theme.blackFill(), -1.0, -1.0), (Observable[])new Observable[]{control.upgradable}));
            arrowButton.getStyleClass().add((Object)"toggle-icon4");
            arrowButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> control.installable.get() && control.incompatibleLibraryName.get() == null, (Observable[])new Observable[]{control.installable, control.incompatibleLibraryName}));
            arrowButton.managedProperty().bind((ObservableValue)arrowButton.visibleProperty());
            arrowButton.onMouseClickedProperty().bind(control.action);
            buttonsContainer.getChildren().add((Object)arrowButton);
            FXUtils.onChangeAndOperate(arrowButton.visibleProperty(), arg_0 -> InstallerItemSkin.lambda$new$3(container, control, (Pane)pane, arg_0));
        }

        private static /* synthetic */ void lambda$new$3(RipplerContainer container, InstallerItem control, Pane pane, Boolean clickable) {
            if (clickable.booleanValue()) {
                container.onMouseClickedProperty().bind(control.action);
                pane.setCursor(Cursor.HAND);
            } else {
                container.onMouseClickedProperty().unbind();
                container.onMouseClickedProperty().set(null);
                pane.setCursor(Cursor.DEFAULT);
            }
        }
    }

    public static final class InstallerItemGroup {
        public final InstallerItem game = new InstallerItem(LibraryAnalyzer.LibraryType.MINECRAFT);
        public final InstallerItem fabric = new InstallerItem(LibraryAnalyzer.LibraryType.FABRIC);
        public final InstallerItem fabricApi = new InstallerItem(LibraryAnalyzer.LibraryType.FABRIC_API);
        public final InstallerItem forge = new InstallerItem(LibraryAnalyzer.LibraryType.FORGE);
        public final InstallerItem neoForge = new InstallerItem(LibraryAnalyzer.LibraryType.NEO_FORGE);
        public final InstallerItem liteLoader = new InstallerItem(LibraryAnalyzer.LibraryType.LITELOADER);
        public final InstallerItem optiFine = new InstallerItem(LibraryAnalyzer.LibraryType.OPTIFINE);
        public final InstallerItem quilt = new InstallerItem(LibraryAnalyzer.LibraryType.QUILT);
        public final InstallerItem quiltApi = new InstallerItem(LibraryAnalyzer.LibraryType.QUILT_API);
        private final InstallerItem[] libraries;
        private final HashMap<InstallerItem, Set<InstallerItem>> incompatibleMap = new HashMap();

        private Set<InstallerItem> getIncompatibles(InstallerItem item) {
            return this.incompatibleMap.computeIfAbsent(item, it -> new HashSet());
        }

        private void addIncompatibles(InstallerItem item, InstallerItem ... others) {
            Set<InstallerItem> set = this.getIncompatibles(item);
            for (InstallerItem other : others) {
                set.add(other);
                this.getIncompatibles(other).add(item);
            }
        }

        private void mutualIncompatible(InstallerItem ... items) {
            for (InstallerItem item : items) {
                Set<InstallerItem> set = this.getIncompatibles(item);
                for (InstallerItem item2 : items) {
                    if (item2 == item) continue;
                    set.add(item2);
                }
            }
        }

        public InstallerItemGroup(String gameVersion) {
            this.mutualIncompatible(this.forge, this.fabric, this.quilt, this.neoForge, this.liteLoader);
            this.addIncompatibles(this.optiFine, this.fabric, this.quilt, this.neoForge);
            this.addIncompatibles(this.fabricApi, this.forge, this.quiltApi, this.neoForge, this.liteLoader, this.optiFine);
            this.addIncompatibles(this.quiltApi, this.forge, this.fabric, this.fabricApi, this.neoForge, this.liteLoader, this.optiFine);
            InvalidationListener listener = o -> {
                for (Map.Entry<InstallerItem, Set<InstallerItem>> entry : this.incompatibleMap.entrySet()) {
                    InstallerItem item = entry.getKey();
                    String incompatibleId = null;
                    for (InstallerItem other : entry.getValue()) {
                        if (other.libraryVersion.get() == null) continue;
                        incompatibleId = other.id;
                        break;
                    }
                    item.incompatibleLibraryName.set(incompatibleId);
                }
            };
            for (InstallerItem item : this.incompatibleMap.keySet()) {
                item.libraryVersion.addListener(listener);
            }
            this.fabricApi.dependencyName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.fabric.libraryVersion.get() == null) {
                    return LibraryAnalyzer.LibraryType.FABRIC.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.fabric.libraryVersion}));
            this.quiltApi.dependencyName.bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (this.quilt.libraryVersion.get() == null) {
                    return LibraryAnalyzer.LibraryType.QUILT.getPatchId();
                }
                return null;
            }, (Observable[])new Observable[]{this.quilt.libraryVersion}));
            this.libraries = gameVersion == null ? new InstallerItem[]{this.game, this.forge, this.neoForge, this.liteLoader, this.optiFine, this.fabric, this.fabricApi, this.quilt, this.quiltApi} : (GameVersionNumber.compare(gameVersion, "1.13") < 0 ? new InstallerItem[]{this.game, this.forge, this.liteLoader, this.optiFine} : new InstallerItem[]{this.game, this.forge, this.neoForge, this.optiFine, this.fabric, this.fabricApi, this.quilt, this.quiltApi});
        }

        public InstallerItem[] getLibraries() {
            return this.libraries;
        }
    }
}

