/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.game.HMCLCacheRepository;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.AuthlibInjectorServers;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.ProxyManager;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class Settings {
    private static Settings instance;

    public static Settings instance() {
        if (instance == null) {
            throw new IllegalStateException("Settings hasn't been initialized");
        }
        return instance;
    }

    static void init() {
        instance = new Settings();
    }

    private Settings() {
        ConfigHolder.config().localizationProperty().addListener(unused -> Settings.updateSystemLocale());
        Settings.updateSystemLocale();
        DownloadProviders.init();
        ProxyManager.init();
        Accounts.init();
        Profiles.init();
        AuthlibInjectorServers.init();
        AnimationUtils.init();
        CacheRepository.setInstance(HMCLCacheRepository.REPOSITORY);
        HMCLCacheRepository.REPOSITORY.directoryProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (FileUtils.canCreateDirectory(this.getCommonDirectory())) {
                return this.getCommonDirectory();
            }
            return Settings.getDefaultCommonDirectory();
        }, (Observable[])new Observable[]{ConfigHolder.config().commonDirectoryProperty(), ConfigHolder.config().commonDirTypeProperty()}));
    }

    public static String getDefaultCommonDirectory() {
        return Metadata.MINECRAFT_DIRECTORY.toString();
    }

    public String getCommonDirectory() {
        switch (ConfigHolder.config().getCommonDirType()) {
            case DEFAULT: {
                return Settings.getDefaultCommonDirectory();
            }
            case CUSTOM: {
                return ConfigHolder.config().getCommonDirectory();
            }
        }
        return null;
    }

    private static void updateSystemLocale() {
        Locale.setDefault(ConfigHolder.config().getLocalization().getLocale());
    }
}

