/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.curse.CurseManifest;
import org.jackhuang.hmcl.mod.modrinth.ModrinthCompletionTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthManifest;
import org.jackhuang.hmcl.mod.modrinth.ModrinthModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class ModrinthInstallTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository repository;
    private final File zipFile;
    private final Modpack modpack;
    private final ModrinthManifest manifest;
    private final String name;
    private final File run;
    private final ModpackConfiguration<ModrinthManifest> config;
    private final List<Task<?>> dependents = new ArrayList(4);
    private final List<Task<?>> dependencies = new ArrayList(1);

    public ModrinthInstallTask(DefaultDependencyManager dependencyManager, File zipFile, Modpack modpack, ModrinthManifest manifest, String name) {
        this.dependencyManager = dependencyManager;
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.repository = dependencyManager.getGameRepository();
        this.run = this.repository.getRunDirectory(name);
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name).gameVersion(manifest.getGameVersion());
        block14: for (Map.Entry<String, String> modLoader : manifest.getDependencies().entrySet()) {
            switch (modLoader.getKey()) {
                case "minecraft": {
                    continue block14;
                }
                case "forge": {
                    builder.version("forge", modLoader.getValue());
                    continue block14;
                }
                case "fabric-loader": {
                    builder.version("fabric", modLoader.getValue());
                    continue block14;
                }
                case "quilt-loader": {
                    builder.version("quilt", modLoader.getValue());
                    continue block14;
                }
            }
            throw new IllegalStateException("Unsupported mod loader " + modLoader.getKey());
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            Exception ex = event.getTask().getException();
            if (event.isFailed() && !(ex instanceof ModpackCompletionException)) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration config = null;
        try {
            if (json.exists()) {
                config = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(json), new TypeToken<ModpackConfiguration<CurseManifest>>(){}.getType());
                if (!ModrinthModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + name + " is not a Modrinth modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException modLoader) {
            // empty catch block
        }
        this.config = config;
        List<String> subDirectories = Arrays.asList("/client-overrides", "/overrides");
        this.dependents.add(new ModpackInstallTask(zipFile, this.run, modpack.getEncoding(), subDirectories, any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<ModrinthManifest>(zipFile, modpack.getEncoding(), subDirectories, manifest, ModrinthModpackProvider.INSTANCE, manifest.getName(), manifest.getVersionId(), this.repository.getModpackConfiguration(name)).withStage("hmcl.modpack"));
        this.dependencies.add(new ModrinthCompletionTask(dependencyManager, name, manifest));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        if (this.config != null) {
            for (ModrinthManifest.File oldManifestFile : this.config.getManifest().getFiles()) {
                Path oldFile = this.run.toPath().resolve(oldManifestFile.getPath());
                if (!Files.exists(oldFile, new LinkOption[0]) || !this.manifest.getFiles().stream().noneMatch(oldManifestFile::equals)) continue;
                Files.deleteIfExists(oldFile);
            }
        }
        File root = this.repository.getVersionRoot(this.name);
        FileUtils.writeText(new File(root, "modrinth.index.json"), JsonUtils.GSON.toJson(this.manifest));
    }
}

