/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.modrinth.ModrinthManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class ModrinthCompletionTask
extends Task<Void> {
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final String version;
    private ModrinthManifest manifest;
    private final List<Task<?>> dependencies = new ArrayList();
    private final AtomicBoolean allNameKnown = new AtomicBoolean(true);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicBoolean notFound = new AtomicBoolean(false);

    public ModrinthCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public ModrinthCompletionTask(DefaultDependencyManager dependencyManager, String version, ModrinthManifest manifest) {
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.version = version;
        this.manifest = manifest;
        if (manifest == null) {
            try {
                File manifestFile = new File(this.repository.getVersionRoot(version), "modrinth.index.json");
                if (manifestFile.exists()) {
                    this.manifest = JsonUtils.GSON.fromJson(FileUtils.readText(manifestFile), ModrinthManifest.class);
                }
            }
            catch (Exception e) {
                Logging.LOG.log(Level.WARNING, "Unable to read Modrinth modpack manifest.json", e);
            }
        }
        this.setStage("hmcl.modpack.download");
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.manifest == null) {
            return;
        }
        Path runDirectory = this.repository.getRunDirectory(this.version).toPath();
        for (ModrinthManifest.File file : this.manifest.getFiles()) {
            Path filePath;
            if (file.getEnv() != null && file.getEnv().getOrDefault("client", "required").equals("unsupported") || Files.exists(filePath = runDirectory.resolve(file.getPath()), new LinkOption[0]) || file.getDownloads().isEmpty()) continue;
            FileDownloadTask task = new FileDownloadTask(file.getDownloads().get(0), filePath.toFile());
            task.setCacheRepository(this.dependency.getCacheRepository());
            task.setCaching(true);
            this.dependencies.add(task.withCounter("hmcl.modpack.download"));
        }
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
            this.notifyPropertiesChanged();
        }
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (this.notFound.get()) {
            throw new ModpackCompletionException(new FileNotFoundException());
        }
        if (!this.allNameKnown.get() || !this.isDependenciesSucceeded()) {
            throw new ModpackCompletionException();
        }
    }
}

