/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.curse.CurseCompletionTask;
import org.jackhuang.hmcl.mod.curse.CurseManifest;
import org.jackhuang.hmcl.mod.curse.CurseManifestFile;
import org.jackhuang.hmcl.mod.curse.CurseManifestModLoader;
import org.jackhuang.hmcl.mod.curse.CurseModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class CurseInstallTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository repository;
    private final File zipFile;
    private final Modpack modpack;
    private final CurseManifest manifest;
    private final String name;
    private final File run;
    private final ModpackConfiguration<CurseManifest> config;
    private final List<Task<?>> dependents = new ArrayList(4);
    private final List<Task<?>> dependencies = new ArrayList(1);

    public CurseInstallTask(DefaultDependencyManager dependencyManager, File zipFile, Modpack modpack, CurseManifest manifest, String name) {
        this.dependencyManager = dependencyManager;
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.repository = dependencyManager.getGameRepository();
        this.run = this.repository.getRunDirectory(name);
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name).gameVersion(manifest.getMinecraft().getGameVersion());
        for (CurseManifestModLoader modLoader : manifest.getMinecraft().getModLoaders()) {
            if (modLoader.getId().startsWith("forge-")) {
                builder.version("forge", modLoader.getId().substring("forge-".length()));
                continue;
            }
            if (modLoader.getId().startsWith("fabric-")) {
                builder.version("fabric", modLoader.getId().substring("fabric-".length()));
                continue;
            }
            if (!modLoader.getId().startsWith("neoforge-")) continue;
            builder.version("neoforge", modLoader.getId().substring("neoforge-".length()));
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            Exception ex = event.getTask().getException();
            if (event.isFailed() && !(ex instanceof ModpackCompletionException)) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration config = null;
        try {
            if (json.exists()) {
                config = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(json), new TypeToken<ModpackConfiguration<CurseManifest>>(){}.getType());
                if (!CurseModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + name + " is not a Curse modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        this.config = config;
        this.dependents.add(new ModpackInstallTask(zipFile, this.run, modpack.getEncoding(), Collections.singletonList(manifest.getOverrides()), any -> true, config).withStage("hmcl.modpack"));
        this.dependents.add(new MinecraftInstanceTask<CurseManifest>(zipFile, modpack.getEncoding(), Collections.singletonList(manifest.getOverrides()), manifest, CurseModpackProvider.INSTANCE, manifest.getName(), manifest.getVersion(), this.repository.getModpackConfiguration(name)).withStage("hmcl.modpack"));
        this.dependencies.add(new CurseCompletionTask(dependencyManager, name, manifest));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        if (this.config != null) {
            for (CurseManifestFile oldCurseManifestFile : this.config.getManifest().getFiles()) {
                File oldFile;
                if (StringUtils.isBlank(oldCurseManifestFile.getFileName()) || !(oldFile = new File(this.run, "mods/" + oldCurseManifestFile.getFileName())).exists() || !this.manifest.getFiles().stream().noneMatch(oldCurseManifestFile::equals) || oldFile.delete()) continue;
                throw new IOException("Unable to delete mod file " + oldFile);
            }
        }
        File root = this.repository.getVersionRoot(this.name);
        FileUtils.writeText(new File(root, "manifest.json"), JsonUtils.GSON.toJson(this.manifest));
    }
}

