/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.mod.LocalMod;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.modinfo.FabricModMetadata;
import org.jackhuang.hmcl.mod.modinfo.ForgeNewModMetadata;
import org.jackhuang.hmcl.mod.modinfo.ForgeOldModMetadata;
import org.jackhuang.hmcl.mod.modinfo.LiteModMetadata;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.mod.modinfo.QuiltModMetadata;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class ModManager {
    private static final Map<String, Pair<ModMetadataReader[], String>> READERS;
    private final GameRepository repository;
    private final String id;
    private final TreeSet<LocalModFile> localModFiles = new TreeSet();
    private final HashMap<LocalMod, LocalMod> localMods = new HashMap();
    private boolean loaded = false;
    public static final String DISABLED_EXTENSION = ".disabled";
    public static final String OLD_EXTENSION = ".old";

    public ModManager(GameRepository repository, String id) {
        this.repository = repository;
        this.id = id;
    }

    public GameRepository getRepository() {
        return this.repository;
    }

    public String getVersion() {
        return this.id;
    }

    public Path getModsDirectory() {
        return this.repository.getRunDirectory(this.id).toPath().resolve("mods");
    }

    public LocalMod getLocalMod(String id, ModLoaderType modLoaderType) {
        return this.localMods.computeIfAbsent(new LocalMod(id, modLoaderType), x -> x);
    }

    private void addModInfo(Path file) {
        try {
            LocalModFile localModFile = this.getModInfo(file);
            if (!localModFile.isOld()) {
                this.localModFiles.add(localModFile);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public LocalModFile getModInfo(Path modFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void refreshMods() throws IOException {
        this.localModFiles.clear();
        this.localMods.clear();
        if (Files.isDirectory(this.getModsDirectory(), new LinkOption[0])) {
            try (DirectoryStream<Path> modsDirectoryStream = Files.newDirectoryStream(this.getModsDirectory());){
                for (Path subitem : modsDirectoryStream) {
                    if (Files.isDirectory(subitem, new LinkOption[0]) && VersionNumber.isIntVersionNumber(FileUtils.getName(subitem))) {
                        DirectoryStream<Path> subitemDirectoryStream = Files.newDirectoryStream(subitem);
                        try {
                            for (Path subsubitem : subitemDirectoryStream) {
                                this.addModInfo(subsubitem);
                            }
                            continue;
                        }
                        finally {
                            if (subitemDirectoryStream != null) {
                                subitemDirectoryStream.close();
                            }
                            continue;
                        }
                    }
                    this.addModInfo(subitem);
                }
            }
        }
        this.loaded = true;
    }

    public Collection<LocalModFile> getMods() throws IOException {
        if (!this.loaded) {
            this.refreshMods();
        }
        return this.localModFiles;
    }

    public void addMod(Path file) throws IOException {
        if (!ModManager.isFileNameMod(file)) {
            throw new IllegalArgumentException("File " + file + " is not a valid mod file.");
        }
        if (!this.loaded) {
            this.refreshMods();
        }
        Path modsDirectory = this.getModsDirectory();
        Files.createDirectories(modsDirectory, new FileAttribute[0]);
        Path newFile = modsDirectory.resolve(file.getFileName());
        FileUtils.copyFile(file, newFile);
        this.addModInfo(newFile);
    }

    public void removeMods(LocalModFile ... localModFiles) throws IOException {
        for (LocalModFile localModFile : localModFiles) {
            Files.deleteIfExists(localModFile.getFile());
        }
    }

    public void rollback(LocalModFile from, LocalModFile to) throws IOException {
        if (!this.loaded) {
            throw new IllegalStateException("ModManager Not loaded");
        }
        if (!this.localModFiles.contains(from)) {
            throw new IllegalStateException("Rolling back an unknown mod " + from.getFileName());
        }
        if (from.isOld()) {
            throw new IllegalArgumentException("Rolling back an old mod " + from.getFileName());
        }
        if (!to.isOld()) {
            throw new IllegalArgumentException("Rolling back to an old path " + to.getFileName());
        }
        if (from.getFileName().equals(to.getFileName())) {
            return;
        }
        LocalMod mod = Objects.requireNonNull(from.getMod());
        if (mod != to.getMod()) {
            throw new IllegalArgumentException("Rolling back mod " + from.getFileName() + " to a different mod " + to.getFileName());
        }
        if (!mod.getFiles().contains(from) || !mod.getOldFiles().contains(to)) {
            throw new IllegalStateException("LocalMod state corrupt");
        }
        boolean active = from.isActive();
        from.setActive(true);
        from.setOld(true);
        to.setOld(false);
        to.setActive(active);
    }

    private Path backupMod(Path file) throws IOException {
        Path newPath = file.resolveSibling(StringUtils.addSuffix(StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION), OLD_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return newPath;
    }

    private Path restoreMod(Path file) throws IOException {
        Path newPath = file.resolveSibling(StringUtils.removeSuffix(FileUtils.getName(file), OLD_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return newPath;
    }

    public Path setOld(LocalModFile modFile, boolean old) throws IOException {
        Path newPath;
        if (old) {
            newPath = this.backupMod(modFile.getFile());
            this.localModFiles.remove(modFile);
        } else {
            newPath = this.restoreMod(modFile.getFile());
            this.localModFiles.add(modFile);
        }
        return newPath;
    }

    public Path disableMod(Path file) throws IOException {
        if (this.isOld(file)) {
            return file;
        }
        String fileName = FileUtils.getName(file);
        if (fileName.endsWith(DISABLED_EXTENSION)) {
            return file;
        }
        Path disabled = file.resolveSibling(fileName + DISABLED_EXTENSION);
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, disabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return disabled;
    }

    public Path enableMod(Path file) throws IOException {
        if (this.isOld(file)) {
            return file;
        }
        Path enabled = file.resolveSibling(StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, enabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return enabled;
    }

    public static String getModName(Path file) {
        return StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION, OLD_EXTENSION);
    }

    public boolean isOld(Path file) {
        return FileUtils.getName(file).endsWith(OLD_EXTENSION);
    }

    public boolean isDisabled(Path file) {
        return FileUtils.getName(file).endsWith(DISABLED_EXTENSION);
    }

    public static boolean isFileNameMod(Path file) {
        String name = ModManager.getModName(file);
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".litemod");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFileMod(Path modFile) {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modFile);){
            if (Files.exists(fs.getPath("mcmod.info", new String[0]), new LinkOption[0]) || Files.exists(fs.getPath("META-INF/mods.toml", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("fabric.mod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("quilt.mod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("litemod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean hasSimpleMod(String fileName) {
        return Files.exists(this.getModsDirectory().resolve(StringUtils.removeSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]) || Files.exists(this.getModsDirectory().resolve(StringUtils.addSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]);
    }

    public Path getSimpleModPath(String fileName) {
        return this.getModsDirectory().resolve(fileName);
    }

    public static String getMcbbsUrl(String mcbbsId) {
        return String.format("https://www.mcbbs.net/thread-%s-1-1.html", mcbbsId);
    }

    static {
        TreeMap<String, Pair<ModMetadataReader[], String>> readers = new TreeMap<String, Pair<ModMetadataReader[], String>>();
        readers.put("zip", Pair.pair(new ModMetadataReader[]{ForgeOldModMetadata::fromFile, ForgeNewModMetadata::fromFile, FabricModMetadata::fromFile, QuiltModMetadata::fromFile, PackMcMeta::fromFile}, ""));
        readers.put("jar", (Pair)readers.get("zip"));
        readers.put("litemod", Pair.pair(new ModMetadataReader[]{LiteModMetadata::fromFile}, "LiteLoader Mod"));
        READERS = Collections.unmodifiableMap(readers);
    }

    @FunctionalInterface
    private static interface ModMetadataReader {
        public LocalModFile fromFile(ModManager var1, Path var2, FileSystem var3) throws IOException, JsonParseException;
    }
}

