/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.jfoenix.controls.JFXButton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.MaintainTask;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.download.game.GameVerificationFixTask;
import org.jackhuang.hmcl.download.game.LibraryDownloadException;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.download.java.JavaRepository;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.game.HMCLGameLauncher;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.JavaVersionConstraint;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.CommandTooLongException;
import org.jackhuang.hmcl.launch.ExecutionPolicyLimitException;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.mod.ModpackCompletionException;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.GameCrashWindow;
import org.jackhuang.hmcl.ui.LogWindow;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.NativePatcher;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class LauncherHelper {
    private final Profile profile;
    private Account account;
    private final String selectedVersion;
    private File scriptFile;
    private final VersionSetting setting;
    private LauncherVisibility launcherVisibility;
    private boolean showLogs;
    private final TaskExecutorDialogPane launchingStepsPane = new TaskExecutorDialogPane(TaskCancellationAction.NORMAL);
    private static final String ORACLEJDK_DOWNLOAD_LINK = "https://www.java.com/download";
    private static final String OPENJDK_DOWNLOAD_LINK = "https://docs.microsoft.com/java/openjdk/download";
    public static final Queue<ManagedProcess> PROCESSES = new ConcurrentLinkedQueue<ManagedProcess>();

    public LauncherHelper(Profile profile, Account account, String selectedVersion) {
        this.profile = Objects.requireNonNull(profile);
        this.account = Objects.requireNonNull(account);
        this.selectedVersion = Objects.requireNonNull(selectedVersion);
        this.setting = profile.getVersionSetting(selectedVersion);
        this.launcherVisibility = this.setting.getLauncherVisibility();
        this.showLogs = this.setting.isShowLogs();
        this.launchingStepsPane.setTitle(I18n.i18n("version.launch"));
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setTestMode() {
        this.launcherVisibility = LauncherVisibility.KEEP;
        this.showLogs = true;
    }

    public void setKeep() {
        this.launcherVisibility = LauncherVisibility.KEEP;
    }

    public void launch() {
        FXUtils.checkFxUserThread();
        Logging.LOG.info("Launching game version: " + this.selectedVersion);
        Controllers.dialog((Region)this.launchingStepsPane);
        this.launch0();
    }

    public void makeLaunchScript(File scriptFile) {
        this.scriptFile = Objects.requireNonNull(scriptFile);
        this.launch();
    }

    private void launch0() {
        HMCLGameRepository repository = this.profile.getRepository();
        DefaultDependencyManager dependencyManager = this.profile.getDependency();
        AtomicReference<Version> version = new AtomicReference<Version>(MaintainTask.maintain(repository, repository.getResolvedVersion(this.selectedVersion)));
        Optional<String> gameVersion = repository.getGameVersion(version.get());
        boolean integrityCheck = repository.unmarkVersionLaunchedAbnormally(this.selectedVersion);
        CountDownLatch launchingLatch = new CountDownLatch(1);
        ArrayList javaAgents = new ArrayList(0);
        AtomicReference javaVersionRef = new AtomicReference();
        TaskExecutor executor = LauncherHelper.checkGameState(this.profile, this.setting, version.get()).thenComposeAsync(javaVersion -> {
            javaVersionRef.set(Objects.requireNonNull(javaVersion));
            version.set(NativePatcher.patchNative((Version)version.get(), gameVersion.orElse(null), javaVersion, this.setting));
            if (this.setting.isNotCheckGame()) {
                return null;
            }
            return Task.allOf(dependencyManager.checkGameCompletionAsync((Version)version.get(), integrityCheck), Task.composeAsync(() -> {
                try {
                    ModpackConfiguration<?> configuration = ModpackHelper.readModpackConfiguration(repository.getModpackConfiguration(this.selectedVersion));
                    ModpackProvider provider = ModpackHelper.getProviderByType(configuration.getType());
                    if (provider == null) {
                        return null;
                    }
                    return provider.createCompletionTask(dependencyManager, this.selectedVersion);
                }
                catch (IOException e) {
                    return null;
                }
            }), Task.composeAsync(() -> {
                Renderer renderer = this.setting.getRenderer();
                if (renderer != Renderer.DEFAULT && OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                    Library lib = NativePatcher.getMesaLoader(javaVersion, renderer);
                    if (lib == null) {
                        return null;
                    }
                    File file = dependencyManager.getGameRepository().getLibraryFile((Version)version.get(), lib);
                    if (file.getAbsolutePath().indexOf(61) >= 0) {
                        Logging.LOG.warning("Invalid character '=' in the libraries directory path, unable to attach software renderer loader");
                        return null;
                    }
                    String agent = file.getAbsolutePath() + "=" + renderer.name().toLowerCase(Locale.ROOT);
                    if (GameLibrariesTask.shouldDownloadLibrary(repository, (Version)version.get(), lib, integrityCheck)) {
                        return new LibraryDownloadTask(dependencyManager, file, lib).thenRunAsync(() -> javaAgents.add(agent));
                    }
                    javaAgents.add(agent);
                    return null;
                }
                return null;
            }));
        }).withStage("launch.state.dependencies").thenComposeAsync(() -> gameVersion.map(s -> new GameVerificationFixTask(dependencyManager, (String)s, (Version)version.get())).orElse(null)).thenComposeAsync(() -> LauncherHelper.logIn(this.account).withStage("launch.state.logging_in")).thenComposeAsync(authInfo -> Task.supplyAsync(() -> {
            LaunchOptions launchOptions = repository.getLaunchOptions(this.selectedVersion, (JavaVersion)javaVersionRef.get(), this.profile.getGameDir(), javaAgents, this.scriptFile != null);
            return new HMCLGameLauncher(repository, (Version)version.get(), (AuthInfo)authInfo, launchOptions, this.launcherVisibility == LauncherVisibility.CLOSE ? null : new HMCLProcessListener(repository, (Version)version.get(), (AuthInfo)authInfo, launchOptions, launchingLatch, gameVersion.isPresent()));
        }).thenComposeAsync(launcher -> {
            if (this.scriptFile == null) {
                return Task.supplyAsync(launcher::launch);
            }
            return Task.supplyAsync(() -> {
                launcher.makeLaunchScript(this.scriptFile);
                return null;
            });
        }).thenAcceptAsync(process -> {
            if (this.scriptFile == null) {
                PROCESSES.add((ManagedProcess)process);
                if (this.launcherVisibility == LauncherVisibility.CLOSE) {
                    Launcher.stopApplication();
                } else {
                    this.launchingStepsPane.setCancel(new TaskCancellationAction(it -> {
                        process.stop();
                        it.fireEvent(new DialogCloseEvent());
                    }));
                }
            } else {
                Platform.runLater(() -> {
                    this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                    Controllers.dialog(I18n.i18n("version.launch_script.success", this.scriptFile.getAbsolutePath()));
                });
            }
        }).withFakeProgress(I18n.i18n("message.doing"), () -> launchingLatch.getCount() == 0L, 6.95).withStage("launch.state.waiting_launching")).withStagesHint(Lang.immutableListOf("launch.state.java", "launch.state.dependencies", "launch.state.logging_in", "launch.state.waiting_launching")).executor();
        this.launchingStepsPane.setExecutor(executor, false);
        executor.addTaskListener(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                Platform.runLater(() -> {
                    if (!Controllers.isStopped()) {
                        Exception ex;
                        LauncherHelper.this.launchingStepsPane.fireEvent(new DialogCloseEvent());
                        if (!success && !((ex = executor.getException()) instanceof CancellationException)) {
                            String message;
                            if (ex instanceof ModpackCompletionException) {
                                message = ex.getCause() instanceof FileNotFoundException ? I18n.i18n("modpack.type.curse.not_found") : I18n.i18n("modpack.type.curse.error");
                            } else if (ex instanceof PermissionException) {
                                message = I18n.i18n("launch.failed.executable_permission");
                            } else if (ex instanceof ProcessCreationException) {
                                message = I18n.i18n("launch.failed.creating_process") + ex.getLocalizedMessage();
                            } else if (ex instanceof NotDecompressingNativesException) {
                                message = I18n.i18n("launch.failed.decompressing_natives") + ex.getLocalizedMessage();
                            } else if (ex instanceof LibraryDownloadException) {
                                message = I18n.i18n("launch.failed.download_library", ((LibraryDownloadException)ex).getLibrary().getName()) + "\n";
                                if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException rce = (ResponseCodeException)ex.getCause();
                                    int responseCode = rce.getResponseCode();
                                    URL url = rce.getUrl();
                                    message = responseCode == 404 ? message + I18n.i18n("download.code.404", url) : message + I18n.i18n("download.failed", url, responseCode);
                                } else {
                                    message = message + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof DownloadException) {
                                URL url = ((DownloadException)ex).getUrl();
                                if (ex.getCause() instanceof SocketTimeoutException) {
                                    message = I18n.i18n("install.failed.downloading.timeout", url);
                                } else if (ex.getCause() instanceof ResponseCodeException) {
                                    ResponseCodeException responseCodeException = (ResponseCodeException)ex.getCause();
                                    message = I18n.hasKey("download.code." + responseCodeException.getResponseCode()) ? I18n.i18n("download.code." + responseCodeException.getResponseCode(), url) : I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                } else {
                                    message = I18n.i18n("install.failed.downloading.detail", url) + "\n" + StringUtils.getStackTrace(ex.getCause());
                                }
                            } else if (ex instanceof GameAssetIndexDownloadTask.GameAssetIndexMalformedException) {
                                message = I18n.i18n("assets.index.malformed");
                            } else if (ex instanceof AuthlibInjectorDownloadException) {
                                message = I18n.i18n("account.failed.injector_download_failure");
                            } else if (ex instanceof CharacterDeletedException) {
                                message = I18n.i18n("account.failed.character_deleted");
                            } else if (ex instanceof ResponseCodeException) {
                                ResponseCodeException rce = (ResponseCodeException)ex;
                                int responseCode = rce.getResponseCode();
                                URL url = rce.getUrl();
                                message = responseCode == 404 ? I18n.i18n("download.code.404", url) : I18n.i18n("download.failed", url, responseCode);
                            } else if (ex instanceof CommandTooLongException) {
                                message = I18n.i18n("launch.failed.command_too_long");
                            } else {
                                if (ex instanceof ExecutionPolicyLimitException) {
                                    Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("launch.failed.execution_policy"), (result, resolve, reject) -> {
                                        if (CommandBuilder.setExecutionPolicy()) {
                                            Logging.LOG.info("Set the ExecutionPolicy for the scope 'CurrentUser' to 'RemoteSigned'");
                                            resolve.run();
                                        } else {
                                            Logging.LOG.warning("Failed to set ExecutionPolicy");
                                            reject.accept(I18n.i18n("launch.failed.execution_policy.failed_to_set"));
                                        }
                                    }).addQuestion(new PromptDialogPane.Builder.HintQuestion(I18n.i18n("launch.failed.execution_policy.hint"))));
                                    return;
                                }
                                message = ex instanceof AccessDeniedException ? I18n.i18n("exception.access_denied", ((AccessDeniedException)ex).getFile()) : StringUtils.getStackTrace(ex);
                            }
                            Controllers.dialog(message, LauncherHelper.this.scriptFile == null ? I18n.i18n("launch.failed") : I18n.i18n("version.launch_script.failed"), MessageDialogPane.MessageType.ERROR);
                        }
                    }
                    LauncherHelper.this.launchingStepsPane.setExecutor(null);
                });
            }
        });
        executor.start();
    }

    private static Task<JavaVersion> checkGameState(Profile profile, VersionSetting setting, Version version) {
        GameVersionNumber gameVersion = GameVersionNumber.asGameVersion(profile.getRepository().getGameVersion(version));
        if (setting.isNotCheckJVM()) {
            return Task.composeAsync(() -> setting.getJavaVersion(gameVersion, version)).thenApplyAsync(javaVersion -> Optional.ofNullable(javaVersion).orElseGet(JavaVersion::fromCurrentEnvironment)).withStage("launch.state.java");
        }
        return Task.composeAsync(() -> setting.getJavaVersion(gameVersion, version)).thenComposeAsync(Schedulers.javafx(), javaVersion -> {
            if (javaVersion == null) {
                CompletableFuture future = new CompletableFuture();
                Runnable continueAction = () -> future.complete(JavaVersion.fromCurrentEnvironment());
                if (setting.isJavaAutoSelected()) {
                    GameJavaVersion targetJavaVersion = null;
                    if (org.jackhuang.hmcl.util.platform.Platform.isCompatibleWithX86Java()) {
                        JavaVersionConstraint.VersionRanges range = JavaVersionConstraint.findSuitableJavaVersionRange(gameVersion, version);
                        if (range.getMandatory().contains(VersionNumber.asVersion("17.0.1"))) {
                            targetJavaVersion = GameJavaVersion.JAVA_17;
                        } else if (range.getMandatory().contains(VersionNumber.asVersion("16.0.1"))) {
                            targetJavaVersion = GameJavaVersion.JAVA_16;
                        } else {
                            String java8Version = OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "1.8.0_51" : (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX ? "1.8.0_202" : (OperatingSystem.CURRENT_OS == OperatingSystem.OSX ? "1.8.0_74" : null));
                            targetJavaVersion = java8Version != null && range.getMandatory().contains(VersionNumber.asVersion(java8Version)) ? GameJavaVersion.JAVA_8 : null;
                        }
                    }
                    if (targetJavaVersion == null) {
                        Controllers.confirm(I18n.i18n("launch.failed.no_accepted_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction, () -> future.completeExceptionally(new CancellationException("No accepted java")));
                    } else {
                        ((CompletableFuture)LauncherHelper.downloadJava(gameVersion.toString(), targetJavaVersion, profile).thenAcceptAsync(downloadedJavaVersion -> future.complete(downloadedJavaVersion))).exceptionally(throwable -> {
                            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
                            Controllers.confirm(I18n.i18n("launch.failed.no_accepted_java"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction, () -> future.completeExceptionally(new CancellationException("No accepted java")));
                            return null;
                        });
                    }
                } else {
                    Controllers.dialog(I18n.i18n("launch.wrong_javadir"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, continueAction);
                    setting.setJava(null);
                    setting.setDefaultJavaPath(null);
                    setting.setJavaVersion(JavaVersion.fromCurrentEnvironment());
                }
                return Task.fromCompletableFuture(future);
            }
            return Task.completed(javaVersion);
        }).thenComposeAsync(javaVersion -> Task.allOf(Task.completed(javaVersion), Task.supplyAsync(() -> JavaVersionConstraint.findSuitableJavaVersion(gameVersion, version)))).thenComposeAsync(Schedulers.javafx(), javaVersions -> {
            VersionNumber forgeVersion;
            JavaVersion javaVersion = (JavaVersion)javaVersions.get(0);
            JavaVersion suggestedJavaVersion = (JavaVersion)javaVersions.get(1);
            if (setting.isJavaAutoSelected()) {
                return Task.completed(javaVersion);
            }
            Enum violatedMandatoryConstraint = null;
            ArrayList<JavaVersionConstraint> violatedSuggestedConstraints = null;
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(version, gameVersion.toString());
            for (JavaVersionConstraint constraint : JavaVersionConstraint.ALL) {
                if (!constraint.appliesToVersion(gameVersion, version, javaVersion, analyzer) || constraint.checkJava(gameVersion, version, javaVersion)) continue;
                if (constraint.getType() == 1) {
                    violatedMandatoryConstraint = constraint;
                    continue;
                }
                if (constraint.getType() != 2) continue;
                if (violatedSuggestedConstraints == null) {
                    violatedSuggestedConstraints = new ArrayList<JavaVersionConstraint>(1);
                }
                violatedSuggestedConstraints.add(constraint);
            }
            CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
            Runnable breakAction = () -> future.completeExceptionally(new CancellationException("Launch operation was cancelled by user"));
            if (violatedMandatoryConstraint != null) {
                if (suggestedJavaVersion != null) {
                    Controllers.confirm(I18n.i18n("launch.advice.java.auto"), I18n.i18n("message.warning"), () -> {
                        setting.setJavaAutoSelected();
                        future.complete(suggestedJavaVersion);
                    }, breakAction);
                    return Task.fromCompletableFuture(future);
                }
                switch (2.$SwitchMap$org$jackhuang$hmcl$game$JavaVersionConstraint[violatedMandatoryConstraint.ordinal()]) {
                    case 1: {
                        ((CompletableFuture)LauncherHelper.downloadJava(gameVersion.toString(), version.getJavaVersion(), profile).thenAcceptAsync(downloadedJavaVersion -> {
                            setting.setJavaVersion((JavaVersion)downloadedJavaVersion);
                            future.complete((JavaVersion)downloadedJavaVersion);
                        }, Schedulers.javafx())).whenCompleteAsync((result, throwable) -> {
                            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
                            breakAction.run();
                        }, Schedulers.javafx());
                        return Task.fromCompletableFuture(future);
                    }
                    case 2: {
                        Controllers.confirm(I18n.i18n("launch.advice.require_newer_java_version", gameVersion.toString(), 16), I18n.i18n("message.warning"), () -> FXUtils.openLink(OPENJDK_DOWNLOAD_LINK), null);
                        breakAction.run();
                        return Task.fromCompletableFuture(future);
                    }
                    case 3: {
                        Controllers.confirm(I18n.i18n("launch.advice.require_newer_java_version", gameVersion.toString(), 17), I18n.i18n("message.warning"), () -> FXUtils.openLink(OPENJDK_DOWNLOAD_LINK), null);
                        breakAction.run();
                        return Task.fromCompletableFuture(future);
                    }
                    case 4: {
                        Controllers.dialog(I18n.i18n("launch.advice.java8_1_13"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return Task.fromCompletableFuture(future);
                    }
                    case 5: {
                        if (setting.getNativesDirType() != NativesDirectoryType.VERSION_FOLDER) break;
                        Controllers.dialog(I18n.i18n("launch.advice.vanilla_linux_java_8"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return Task.fromCompletableFuture(future);
                    }
                    case 6: {
                        Controllers.dialog(I18n.i18n("launch.advice.java9") + "\n" + I18n.i18n("launch.advice.uncorrected"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR, breakAction);
                        return Task.fromCompletableFuture(future);
                    }
                }
            }
            ArrayList<String> suggestions = new ArrayList<String>(0);
            if (Architecture.SYSTEM_ARCH == Architecture.X86_64 && javaVersion.getPlatform().getArchitecture() == Architecture.X86) {
                suggestions.add(I18n.i18n("launch.advice.different_platform"));
            }
            if (javaVersion.getBits() == Bits.BIT_32 && (double)setting.getMaxMemory() > 1536.0) {
                suggestions.add(I18n.i18n("launch.advice.too_large_memory_for_32bit"));
            }
            if (violatedSuggestedConstraints != null) {
                for (JavaVersionConstraint violatedSuggestedConstraint : violatedSuggestedConstraints) {
                    switch (violatedSuggestedConstraint) {
                        case MODDED_JAVA_7: {
                            suggestions.add(I18n.i18n("launch.advice.java.modded_java_7"));
                            break;
                        }
                        case MODDED_JAVA_8: {
                            if (javaVersion.getParsedVersion() < 8) {
                                suggestions.add(I18n.i18n("launch.advice.newer_java"));
                                break;
                            }
                            suggestions.add(I18n.i18n("launch.advice.modded_java", 8, gameVersion));
                            break;
                        }
                        case MODDED_JAVA_16: {
                            String forgePatchVersion = analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).orElse(null);
                            if (forgePatchVersion != null && VersionNumber.compare(forgePatchVersion, "37.0.60") < 0) {
                                suggestions.add(I18n.i18n("launch.advice.forge37_0_60"));
                                break;
                            }
                            suggestions.add(I18n.i18n("launch.advice.modded_java", 16, gameVersion));
                            break;
                        }
                        case MODDED_JAVA_17: {
                            suggestions.add(I18n.i18n("launch.advice.modded_java", 17, gameVersion));
                            break;
                        }
                        case VANILLA_JAVA_8_51: {
                            suggestions.add(I18n.i18n("launch.advice.java8_51_1_13"));
                            break;
                        }
                        case MODLAUNCHER_8: {
                            suggestions.add(I18n.i18n("launch.advice.modlauncher8"));
                            break;
                        }
                        case VANILLA_X86: {
                            if (setting.getNativesDirType() != NativesDirectoryType.VERSION_FOLDER || !org.jackhuang.hmcl.util.platform.Platform.isCompatibleWithX86Java()) break;
                            suggestions.add(I18n.i18n("launch.advice.vanilla_x86.translation"));
                        }
                    }
                }
            }
            if (OperatingSystem.TOTAL_MEMORY > 0 && OperatingSystem.TOTAL_MEMORY < setting.getMaxMemory()) {
                suggestions.add(I18n.i18n("launch.advice.not_enough_space", OperatingSystem.TOTAL_MEMORY));
            }
            boolean hasForge2760 = (forgeVersion = (VersionNumber)version.getLibraries().stream().filter(it -> it.is("net.minecraftforge", "forge")).findFirst().map(library -> VersionNumber.asVersion(library.getVersion())).orElse(null)) != null && forgeVersion.compareTo("1.12.2-14.23.5.2760") >= 0 && forgeVersion.compareTo("1.12.2-14.23.5.2773") < 0;
            boolean hasLiteLoader = version.getLibraries().stream().anyMatch(it -> it.is("com.mumfrey", "liteloader"));
            if (hasForge2760 && hasLiteLoader && gameVersion.compareTo("1.12.2") == 0) {
                suggestions.add(I18n.i18n("launch.advice.forge2760_liteloader"));
            }
            boolean hasForge28_2_2 = forgeVersion != null && forgeVersion.compareTo("1.14.4-28.2.2") >= 0;
            boolean hasOptiFine = version.getLibraries().stream().anyMatch(it -> it.is("optifine", "OptiFine"));
            if (hasForge28_2_2 && hasOptiFine && gameVersion.compareTo("1.14.4") == 0) {
                suggestions.add(I18n.i18n("launch.advice.forge28_2_2_optifine"));
            }
            if (suggestions.isEmpty()) {
                if (!future.isDone()) {
                    future.complete(javaVersion);
                }
            } else {
                String message = suggestions.size() == 1 ? I18n.i18n("launch.advice", suggestions.get(0)) : I18n.i18n("launch.advice.multi", suggestions.stream().map(it -> "\u2192 " + it).collect(Collectors.joining("\n")));
                Controllers.confirm(message, I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, () -> future.complete(javaVersion), breakAction);
            }
            return Task.fromCompletableFuture(future);
        }).withStage("launch.state.java");
    }

    private static CompletableFuture<JavaVersion> downloadJava(String gameVersion, GameJavaVersion javaVersion, Profile profile) {
        CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
        JFXHyperlink link = new JFXHyperlink(I18n.i18n("download.external_link"));
        link.setOnAction(e -> {
            if (javaVersion.getMajorVersion() == 8) {
                FXUtils.openLink(ORACLEJDK_DOWNLOAD_LINK);
            } else {
                FXUtils.openLink(OPENJDK_DOWNLOAD_LINK);
            }
            future.completeExceptionally(new CancellationException());
        });
        Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("launch.advice.require_newer_java_version", gameVersion, javaVersion.getMajorVersion()), I18n.i18n("message.warning"), MessageDialogPane.MessageType.QUESTION).addAction((Node)link).yesOrNo(() -> ((CompletableFuture)LauncherHelper.downloadJavaImpl(javaVersion, profile.getDependency().getDownloadProvider()).thenAcceptAsync(future::complete)).exceptionally(throwable -> {
            Throwable resolvedException = Lang.resolveException(throwable);
            Logging.LOG.log(Level.WARNING, "Failed to download java", (Throwable)throwable);
            if (!(resolvedException instanceof CancellationException)) {
                Controllers.dialog(DownloadProviders.localizeErrorMessage(resolvedException), I18n.i18n("install.failed"));
            }
            future.completeExceptionally(new CancellationException());
            return null;
        }), () -> future.completeExceptionally(new CancellationException())).build());
        return future;
    }

    private static CompletableFuture<JavaVersion> downloadJavaImpl(GameJavaVersion javaVersion, DownloadProvider downloadProvider) {
        CompletableFuture<JavaVersion> future = new CompletableFuture<JavaVersion>();
        Controllers.taskDialog(JavaRepository.downloadJava(javaVersion, downloadProvider).whenComplete(Schedulers.javafx(), (downloadedJava, exception) -> {
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete((JavaVersion)downloadedJava);
            }
        }), I18n.i18n("download.java"), TaskCancellationAction.NORMAL);
        return future;
    }

    private static Task<AuthInfo> logIn(Account account) {
        return Task.composeAsync(() -> {
            try {
                return Task.completed(account.logIn());
            }
            catch (CredentialExpiredException e) {
                Logging.LOG.log(Level.INFO, "Credential has expired", e);
                return Task.completed(DialogController.logIn(account));
            }
            catch (AuthenticationException e) {
                Logging.LOG.log(Level.WARNING, "Authentication failed, try skipping refresh", e);
                CompletableFuture future = new CompletableFuture();
                FXUtils.runInFX(() -> {
                    JFXButton loginOfflineButton = new JFXButton(I18n.i18n("account.login.skip"));
                    loginOfflineButton.setOnAction(event -> {
                        try {
                            future.complete(Task.completed(account.playOffline()));
                        }
                        catch (AuthenticationException e2) {
                            future.completeExceptionally(e2);
                        }
                    });
                    JFXButton retryButton = new JFXButton(I18n.i18n("account.login.retry"));
                    retryButton.setOnAction(event -> future.complete(LauncherHelper.logIn(account)));
                    Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("account.failed.server_disconnected"), I18n.i18n("account.failed"), MessageDialogPane.MessageType.ERROR).addAction((Node)loginOfflineButton).addAction((Node)retryButton).addCancel(() -> future.completeExceptionally(new CancellationException())).build());
                });
                return Task.fromCompletableFuture(future).thenComposeAsync(task -> task);
            }
        });
    }

    private void checkExit() {
        switch (this.launcherVisibility) {
            case HIDE_AND_REOPEN: {
                Platform.runLater(() -> Optional.ofNullable(Controllers.getStage()).ifPresent(Stage::show));
                break;
            }
            case KEEP: {
                break;
            }
            case CLOSE: {
                throw new Error("Never get to here");
            }
            case HIDE: {
                Platform.runLater(() -> {
                    Platform.setImplicitExit((boolean)true);
                    Launcher.stopWithoutPlatform();
                });
            }
        }
    }

    public static void stopManagedProcesses() {
        while (!PROCESSES.isEmpty()) {
            Optional.ofNullable(PROCESSES.poll()).ifPresent(ManagedProcess::stop);
        }
    }

    private final class HMCLProcessListener
    implements ProcessListener {
        private final HMCLGameRepository repository;
        private final Version version;
        private final LaunchOptions launchOptions;
        private ManagedProcess process;
        private boolean lwjgl;
        private LogWindow logWindow;
        private final boolean detectWindow;
        private final ArrayDeque<String> logs;
        private final ArrayDeque<Object> levels;
        private final CountDownLatch logWindowLatch = new CountDownLatch(1);
        private final CountDownLatch launchingLatch;
        private final String forbiddenAccessToken;

        public HMCLProcessListener(HMCLGameRepository repository, Version version, AuthInfo authInfo, LaunchOptions launchOptions, CountDownLatch launchingLatch, boolean detectWindow) {
            this.repository = repository;
            this.version = version;
            this.launchOptions = launchOptions;
            this.launchingLatch = launchingLatch;
            this.detectWindow = detectWindow;
            this.forbiddenAccessToken = authInfo != null ? authInfo.getAccessToken() : null;
            int numLogs = ConfigHolder.config().getLogLines() + 1;
            this.logs = new ArrayDeque(numLogs);
            this.levels = new ArrayDeque(numLogs);
        }

        @Override
        public void setProcess(ManagedProcess process) {
            this.process = process;
            String command = new CommandBuilder().addAll(process.getCommands()).toString();
            Logging.LOG.info("Launched process: " + command);
            String classpath = process.getClasspath();
            if (classpath != null) {
                Logging.LOG.info("Process ClassPath: " + classpath);
            }
            if (LauncherHelper.this.showLogs) {
                Platform.runLater(() -> {
                    this.logWindow = new LogWindow(process);
                    this.logWindow.showNormal();
                    this.logWindowLatch.countDown();
                });
            }
        }

        private void finishLaunch() {
            switch (LauncherHelper.this.launcherVisibility) {
                case HIDE_AND_REOPEN: {
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().hide();
                            this.launchingLatch.countDown();
                        }
                    });
                    break;
                }
                case CLOSE: {
                    break;
                }
                case KEEP: {
                    Platform.runLater(this.launchingLatch::countDown);
                    break;
                }
                case HIDE: {
                    this.launchingLatch.countDown();
                    Platform.runLater(() -> {
                        if (Controllers.getStage() != null) {
                            Controllers.getStage().close();
                            Controllers.shutdown();
                            Schedulers.shutdown();
                            System.gc();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLog(String log, boolean isErrorStream) {
            String filteredLog;
            String string = filteredLog = this.forbiddenAccessToken == null ? log : log.replace(this.forbiddenAccessToken, "<access token>");
            if (isErrorStream) {
                System.err.println(filteredLog);
            } else {
                System.out.println(filteredLog);
            }
            Log4jLevel level = isErrorStream ? Log4jLevel.ERROR : (LauncherHelper.this.showLogs ? Optional.ofNullable(Log4jLevel.guessLevel(filteredLog)).orElse(Log4jLevel.INFO) : null);
            HMCLProcessListener hMCLProcessListener = this;
            synchronized (hMCLProcessListener) {
                this.logs.add(filteredLog);
                this.levels.add(level != null ? level : Optional.empty());
                if (this.logs.size() > ConfigHolder.config().getLogLines()) {
                    this.logs.removeFirst();
                    this.levels.removeFirst();
                }
            }
            if (LauncherHelper.this.showLogs) {
                try {
                    this.logWindowLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                Platform.runLater(() -> this.logWindow.logLine(filteredLog, level));
            }
            if (!this.lwjgl) {
                String lowerCaseLog = filteredLog.toLowerCase(Locale.ROOT);
                if (!this.detectWindow || lowerCaseLog.contains("lwjgl version") || lowerCaseLog.contains("lwjgl openal")) {
                    this.lwjgl = true;
                    this.finishLaunch();
                }
            }
        }

        @Override
        public void onExit(int exitCode, ProcessListener.ExitType exitType) {
            if (LauncherHelper.this.showLogs) {
                Platform.runLater(() -> this.logWindow.logLine(String.format("[HMCL ProcessListener] Minecraft exit with code %d(0x%x).", exitCode, exitCode), Log4jLevel.INFO));
            }
            this.launchingLatch.countDown();
            if (exitType == ProcessListener.ExitType.INTERRUPTED) {
                return;
            }
            if (!this.lwjgl) {
                this.finishLaunch();
            }
            if (exitType != ProcessListener.ExitType.NORMAL) {
                ArrayList pairs = new ArrayList(this.logs.size());
                Lang.forEachZipped(this.logs, this.levels, (log, l) -> pairs.add(Pair.pair(log, l instanceof Log4jLevel ? (Log4jLevel)((Object)((Object)l)) : Optional.ofNullable(Log4jLevel.guessLevel(log)).orElse(Log4jLevel.INFO))));
                this.repository.markVersionLaunchedAbnormally(this.version.getId());
                Platform.runLater(() -> new GameCrashWindow(this.process, exitType, this.repository, this.version, this.launchOptions, pairs).show());
            }
            LauncherHelper.this.checkExit();
        }
    }
}

