/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.neoforge;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;

public final class NeoForgeOfficialVersionList
extends VersionList<NeoForgeRemoteVersion> {
    private final DownloadProvider downloadProvider;
    private static final String OLD_URL = "https://maven.neoforged.net/api/maven/versions/releases/net/neoforged/forge";
    private static final String META_URL = "https://maven.neoforged.net/api/maven/versions/releases/net/neoforged/neoforge";

    public NeoForgeOfficialVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Optional<NeoForgeRemoteVersion> getVersion(String gameVersion, String remoteVersion) {
        if (gameVersion.equals("1.20.1") && !(remoteVersion = NeoForgeRemoteVersion.fixInvalidVersion(remoteVersion)).equals("47.1.82")) {
            remoteVersion = "1.20.1-" + remoteVersion;
        }
        return super.getVersion(gameVersion, remoteVersion);
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        return CompletableFuture.supplyAsync(Lang.wrap(() -> new OfficialAPIResult[]{HttpRequest.GET(this.downloadProvider.injectURL(OLD_URL)).getJson(OfficialAPIResult.class), HttpRequest.GET(this.downloadProvider.injectURL(META_URL)).getJson(OfficialAPIResult.class)})).thenAccept(results -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                for (String version : results[0].versions) {
                    this.versions.put("1.20.1", new NeoForgeRemoteVersion("1.20.1", StringUtils.removePrefix(version, "1.20.1-"), Lang.immutableListOf(this.downloadProvider.injectURL("https://maven.neoforged.net/releases/net/neoforged/forge/" + version + "/forge-" + version + "-installer.jar"))));
                }
                for (String version : results[1].versions) {
                    String mcVersion = "1." + version.substring(0, version.indexOf(46, version.indexOf(46) + 1));
                    this.versions.put(mcVersion, new NeoForgeRemoteVersion(mcVersion, version, Lang.immutableListOf(this.downloadProvider.injectURL("https://maven.neoforged.net/releases/net/neoforged/neoforge/" + version + "/neoforge-" + version + "-installer.jar"))));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private static final class OfficialAPIResult {
        private final boolean isSnapshot;
        private final List<String> versions;

        public OfficialAPIResult(boolean isSnapshot, List<String> versions) {
            this.isSnapshot = isSnapshot;
            this.versions = versions;
        }
    }
}

