/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.JavaDownloads;
import org.jackhuang.hmcl.download.java.JavaRepository;
import org.jackhuang.hmcl.download.java.RemoteFiles;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.tukaani.xz.LZMAInputStream;

public class JavaDownloadTask
extends Task<Void> {
    private final GameJavaVersion javaVersion;
    private final Path rootDir;
    private String platform;
    private final Task<RemoteFiles> javaDownloadsTask;
    private JavaDownloads.JavaDownload download;
    private final List<Task<?>> dependencies = new ArrayList();
    private final DownloadProvider downloadProvider;

    public JavaDownloadTask(GameJavaVersion javaVersion, Path rootDir, DownloadProvider downloadProvider) {
        this.javaVersion = javaVersion;
        this.rootDir = rootDir;
        this.downloadProvider = downloadProvider;
        this.javaDownloadsTask = new GetTask(NetworkUtils.toURL(downloadProvider.injectURL("https://piston-meta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json"))).thenComposeAsync((T javaDownloadsJson) -> {
            JavaDownloads allDownloads = JsonUtils.fromNonNullJson(javaDownloadsJson, JavaDownloads.class);
            if (!allDownloads.getDownloads().containsKey(this.platform)) {
                throw new UnsupportedPlatformException();
            }
            Map<String, List<JavaDownloads.JavaDownload>> osDownloads = allDownloads.getDownloads().get(this.platform);
            if (!osDownloads.containsKey(javaVersion.getComponent())) {
                throw new UnsupportedPlatformException();
            }
            List<JavaDownloads.JavaDownload> candidates = osDownloads.get(javaVersion.getComponent());
            for (JavaDownloads.JavaDownload download : candidates) {
                if (VersionNumber.compare(download.getVersion().getName(), Integer.toString(javaVersion.getMajorVersion())) < 0) continue;
                this.download = download;
                return new GetTask(NetworkUtils.toURL(downloadProvider.injectURL(download.getManifest().getUrl())));
            }
            throw new UnsupportedPlatformException();
        }).thenApplyAsync(javaDownloadJson -> JsonUtils.fromNonNullJson(javaDownloadJson, RemoteFiles.class));
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        this.platform = JavaRepository.getSystemJavaPlatform().orElseThrow(UnsupportedPlatformException::new);
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.javaDownloadsTask);
    }

    @Override
    public void execute() throws Exception {
        Path jvmDir = this.rootDir.resolve(this.javaVersion.getComponent()).resolve(this.platform).resolve(this.javaVersion.getComponent());
        for (Map.Entry<String, RemoteFiles.Remote> entry : this.javaDownloadsTask.getResult().getFiles().entrySet()) {
            Path dest = jvmDir.resolve(entry.getKey());
            if (entry.getValue() instanceof RemoteFiles.RemoteFile) {
                DownloadInfo download;
                RemoteFiles.RemoteFile file = (RemoteFiles.RemoteFile)entry.getValue();
                try {
                    BasicFileAttributes localFileAttributes = Files.readAttributes(dest, BasicFileAttributes.class, new LinkOption[0]);
                    if (localFileAttributes.isRegularFile() && file.getDownloads().containsKey("raw")) {
                        DownloadInfo downloadInfo = file.getDownloads().get("raw");
                        if (localFileAttributes.size() == (long)downloadInfo.getSize()) {
                            ChecksumMismatchException.verifyChecksum(dest, "SHA-1", downloadInfo.getSha1());
                            Logging.LOG.info("Skip existing file: " + dest);
                            continue;
                        }
                    }
                }
                catch (IOException localFileAttributes) {
                    // empty catch block
                }
                if (file.getDownloads().containsKey("lzma")) {
                    download = file.getDownloads().get("lzma");
                    File tempFile = jvmDir.resolve(entry.getKey() + ".lzma").toFile();
                    FileDownloadTask task = new FileDownloadTask(NetworkUtils.toURL(this.downloadProvider.injectURL(download.getUrl())), tempFile, new FileDownloadTask.IntegrityCheck("SHA-1", download.getSha1()));
                    task.setName(entry.getKey());
                    this.dependencies.add(task.thenRunAsync(() -> {
                        Path decompressed = jvmDir.resolve((String)entry.getKey() + ".tmp");
                        try (LZMAInputStream input = new LZMAInputStream(new FileInputStream(tempFile));){
                            Files.copy(input, decompressed, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new ArtifactMalformedException("File " + (String)entry.getKey() + " is malformed", e);
                        }
                        tempFile.delete();
                        Files.move(decompressed, dest, StandardCopyOption.REPLACE_EXISTING);
                        if (file.isExecutable()) {
                            dest.toFile().setExecutable(true);
                        }
                    }));
                    continue;
                }
                if (!file.getDownloads().containsKey("raw")) continue;
                download = file.getDownloads().get("raw");
                FileDownloadTask task = new FileDownloadTask(NetworkUtils.toURL(this.downloadProvider.injectURL(download.getUrl())), dest.toFile(), new FileDownloadTask.IntegrityCheck("SHA-1", download.getSha1()));
                task.setName(entry.getKey());
                if (file.isExecutable()) {
                    this.dependencies.add(task.thenRunAsync(() -> dest.toFile().setExecutable(true)));
                    continue;
                }
                this.dependencies.add(task);
                continue;
            }
            if (entry.getValue() instanceof RemoteFiles.RemoteDirectory) {
                Files.createDirectories(dest, new FileAttribute[0]);
                continue;
            }
            if (!(entry.getValue() instanceof RemoteFiles.RemoteLink)) continue;
            RemoteFiles.RemoteLink link = (RemoteFiles.RemoteLink)entry.getValue();
            Files.deleteIfExists(dest);
            Files.createSymbolicLink(dest, Paths.get(link.getTarget(), new String[0]), new FileAttribute[0]);
        }
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        FileUtils.writeText(this.rootDir.resolve(this.javaVersion.getComponent()).resolve(this.platform).resolve(".version").toFile(), this.download.getVersion().getName());
        FileUtils.writeText(this.rootDir.resolve(this.javaVersion.getComponent()).resolve(this.platform).resolve(this.javaVersion.getComponent() + ".sha1").toFile(), this.javaDownloadsTask.getResult().getFiles().entrySet().stream().filter(entry -> entry.getValue() instanceof RemoteFiles.RemoteFile).map(entry -> {
            RemoteFiles.RemoteFile file = (RemoteFiles.RemoteFile)entry.getValue();
            return (String)entry.getKey() + " /#// " + file.getDownloads().get("raw").getSha1() + " " + file.getDownloads().get("raw").getSize();
        }).collect(Collectors.joining(OperatingSystem.LINE_SEPARATOR)));
    }

    public static class UnsupportedPlatformException
    extends Exception {
    }
}

