/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.forge.ForgeNewInstallProfile;
import org.jackhuang.hmcl.download.game.GameLibrariesTask;
import org.jackhuang.hmcl.download.game.VersionJsonDownloadTask;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.DownloadType;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class ForgeNewInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository gameRepository;
    private final Version version;
    private final Path installer;
    private final List<Task<?>> dependents = new ArrayList(1);
    private final List<Task<?>> dependencies = new ArrayList(1);
    private ForgeNewInstallProfile profile;
    private List<ForgeNewInstallProfile.Processor> processors;
    private Version forgeVersion;
    private final String selfVersion;
    private Path tempDir;
    private AtomicInteger processorDoneCount = new AtomicInteger(0);

    public ForgeNewInstallTask(DefaultDependencyManager dependencyManager, Version version, String selfVersion, Path installer) {
        this.dependencyManager = dependencyManager;
        this.gameRepository = dependencyManager.getGameRepository();
        this.version = version;
        this.installer = installer;
        this.selfVersion = selfVersion;
        this.setSignificance(Task.TaskSignificance.MAJOR);
    }

    private static String replaceTokens(Map<String, String> tokens, String value) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '\\') {
                if (x == value.length() - 1) {
                    throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                }
                buf.append(value.charAt(++x));
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder key = new StringBuilder();
                for (int y = x + 1; y <= value.length(); ++y) {
                    if (y == value.length()) {
                        throw new IllegalArgumentException("Illegal pattern (Unclosed " + c + "): " + value);
                    }
                    char d = value.charAt(y);
                    if (d == '\\') {
                        if (y == value.length() - 1) {
                            throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                        }
                        key.append(value.charAt(++y));
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        x = y;
                        break;
                    }
                    if (c == '\'' && d == '\'') {
                        x = y;
                        break;
                    }
                    key.append(d);
                }
                if (c == '\'') {
                    buf.append((CharSequence)key);
                    continue;
                }
                if (!tokens.containsKey(key.toString())) {
                    throw new IllegalArgumentException("Illegal pattern: " + value + " Missing Key: " + key);
                }
                buf.append(tokens.get(key.toString()));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private <E extends Exception> String parseLiteral(String literal, Map<String, String> var, ExceptionalFunction<String, String, E> plainConverter) throws E {
        if (StringUtils.isSurrounded(literal, "{", "}")) {
            return var.get(StringUtils.removeSurrounding(literal, "{", "}"));
        }
        if (StringUtils.isSurrounded(literal, "'", "'")) {
            return StringUtils.removeSurrounding(literal, "'");
        }
        if (StringUtils.isSurrounded(literal, "[", "]")) {
            return this.gameRepository.getArtifactFile(this.version, Artifact.fromDescriptor(StringUtils.removeSurrounding(literal, "[", "]"))).toString();
        }
        return plainConverter.apply(ForgeNewInstallTask.replaceTokens(var, literal));
    }

    private String parseLiteral(String literal, Map<String, String> var) {
        return this.parseLiteral(literal, var, ExceptionalFunction.identity());
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.installer);){
            Path mainJar;
            this.profile = JsonUtils.fromNonNullJson(FileUtils.readText(fs.getPath("install_profile.json", new String[0])), ForgeNewInstallProfile.class);
            this.processors = this.profile.getProcessors();
            this.forgeVersion = JsonUtils.fromNonNullJson(FileUtils.readText(fs.getPath(this.profile.getJson(), new String[0])), Version.class);
            for (Library library : this.profile.getLibraries()) {
                Path file = fs.getPath("maven", new String[0]).resolve(library.getPath());
                if (!Files.exists(file, new LinkOption[0])) continue;
                Path dest = this.gameRepository.getLibraryFile(this.version, library).toPath();
                FileUtils.copyFile(file, dest);
            }
            if (this.profile.getPath().isPresent() && Files.exists(mainJar = this.profile.getPath().get().getPath(fs.getPath("maven", new String[0])), new LinkOption[0])) {
                Path dest = this.gameRepository.getArtifactFile(this.version, this.profile.getPath().get());
                FileUtils.copyFile(mainJar, dest);
            }
        }
        catch (ZipException ex) {
            throw new ArtifactMalformedException("Malformed forge installer file", ex);
        }
        this.dependents.add(new GameLibrariesTask(this.dependencyManager, this.version, true, this.profile.getLibraries()));
    }

    private Map<String, String> parseOptions(List<String> args, Map<String, String> vars) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        String optionName = null;
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if (optionName != null) {
                    options.put(optionName, "");
                }
                optionName = arg.substring(2);
                continue;
            }
            if (optionName == null) continue;
            options.put(optionName, this.parseLiteral(arg, vars));
            optionName = null;
        }
        if (optionName != null) {
            options.put(optionName, "");
        }
        return options;
    }

    private Task<?> patchDownloadMojangMappingsTask(ForgeNewInstallProfile.Processor processor, Map<String, String> vars) {
        Map<String, String> options = this.parseOptions(processor.getArgs(), vars);
        if (!"DOWNLOAD_MOJMAPS".equals(options.get("task")) || !"client".equals(options.get("side"))) {
            return null;
        }
        String version = options.get("version");
        String output = options.get("output");
        if (version == null || output == null) {
            return null;
        }
        Logging.LOG.info("Patching DOWNLOAD_MOJMAPS task");
        return new VersionJsonDownloadTask(version, this.dependencyManager).thenComposeAsync((T json) -> {
            DownloadInfo mappings = JsonUtils.fromNonNullJson(json, Version.class).getDownloads().get((Object)DownloadType.CLIENT_MAPPINGS);
            if (mappings == null) {
                throw new Exception("client_mappings download info not found");
            }
            List<URL> mappingsUrl = this.dependencyManager.getDownloadProvider().injectURLWithCandidates(mappings.getUrl());
            FileDownloadTask mappingsTask = new FileDownloadTask(mappingsUrl, new File(output), FileDownloadTask.IntegrityCheck.of("SHA-1", mappings.getSha1()));
            mappingsTask.setCaching(true);
            mappingsTask.setCacheRepository(this.dependencyManager.getCacheRepository());
            return mappingsTask;
        });
    }

    private Task<?> createProcessorTask(ForgeNewInstallProfile.Processor processor, Map<String, String> vars) {
        ProcessorTask task = this.patchDownloadMojangMappingsTask(processor, vars);
        if (task == null) {
            task = new ProcessorTask(processor, vars);
        }
        task.onDone().register(() -> this.updateProgress(this.processorDoneCount.incrementAndGet(), this.processors.size()));
        return task;
    }

    @Override
    public void execute() throws Exception {
        this.tempDir = Files.createTempDirectory("forge_installer", new FileAttribute[0]);
        HashMap<String, String> vars = new HashMap<String, String>();
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.installer);){
            for (Map.Entry<String, String> entry : this.profile.getData().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                vars.put(key, this.parseLiteral(value, Collections.emptyMap(), str -> {
                    Path dest = Files.createTempFile(this.tempDir, null, null, new FileAttribute[0]);
                    FileUtils.copyFile(fs.getPath((String)str, new String[0]), dest);
                    return dest.toString();
                }));
            }
        }
        catch (ZipException ex) {
            throw new ArtifactMalformedException("Malformed forge installer file", ex);
        }
        vars.put("SIDE", "client");
        vars.put("MINECRAFT_JAR", this.gameRepository.getVersionJar(this.version).getAbsolutePath());
        vars.put("MINECRAFT_VERSION", this.gameRepository.getVersionJar(this.version).getAbsolutePath());
        vars.put("ROOT", this.gameRepository.getBaseDirectory().getAbsolutePath());
        vars.put("INSTALLER", this.installer.toAbsolutePath().toString());
        vars.put("LIBRARY_DIR", this.gameRepository.getLibrariesDirectory(this.version).getAbsolutePath());
        this.updateProgress(0L, this.processors.size());
        Task<?> processorsTask = Task.runSequentially((Task[])this.processors.stream().map(processor -> this.createProcessorTask((ForgeNewInstallProfile.Processor)processor, (Map<String, String>)vars)).toArray(Task[]::new));
        this.dependencies.add(processorsTask.thenComposeAsync(this.dependencyManager.checkLibraryCompletionAsync(this.forgeVersion, true)));
        this.setResult(this.forgeVersion.setPriority(30000).setId(LibraryAnalyzer.LibraryType.FORGE.getPatchId()).setVersion(this.selfVersion));
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        FileUtils.deleteDirectory(this.tempDir.toFile());
    }

    private class ProcessorTask
    extends Task<Void> {
        private ForgeNewInstallProfile.Processor processor;
        private Map<String, String> vars;

        public ProcessorTask(@NotNull ForgeNewInstallProfile.Processor processor, Map<String, String> vars) {
            this.processor = processor;
            this.vars = vars;
            this.setSignificance(Task.TaskSignificance.MODERATE);
        }

        @Override
        public void execute() throws Exception {
            String mainClass;
            HashMap<String, String> outputs = new HashMap<String, String>();
            boolean miss = false;
            for (Map.Entry<String, String> entry : this.processor.getOutputs().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                key = ForgeNewInstallTask.this.parseLiteral(key, this.vars);
                value = ForgeNewInstallTask.this.parseLiteral(value, this.vars);
                if (key == null || value == null) {
                    throw new ArtifactMalformedException("Invalid forge installation configuration");
                }
                outputs.put(key, value);
                Path artifact = Paths.get(key, new String[0]);
                if (Files.exists(artifact, new LinkOption[0])) {
                    String string;
                    try (InputStream stream = Files.newInputStream(artifact, new OpenOption[0]);){
                        string = DigestUtils.digestToString("SHA-1", stream);
                    }
                    if (Objects.equals(string, value)) continue;
                    Files.delete(artifact);
                    Logging.LOG.info("Found existing file is not valid: " + artifact);
                    miss = true;
                    continue;
                }
                miss = true;
            }
            if (!this.processor.getOutputs().isEmpty() && !miss) {
                return;
            }
            Path jar = ForgeNewInstallTask.this.gameRepository.getArtifactFile(ForgeNewInstallTask.this.version, this.processor.getJar());
            if (!Files.isRegularFile(jar, new LinkOption[0])) {
                throw new FileNotFoundException("Game processor file not found, should be downloaded in preprocess");
            }
            try (JarFile jarFile = new JarFile(jar.toFile());){
                mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            if (StringUtils.isBlank(mainClass)) {
                throw new Exception("Game processor jar does not have main class " + jar);
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(JavaVersion.fromCurrentEnvironment().getBinary().toString());
            command.add("-cp");
            ArrayList<String> classpath = new ArrayList<String>(this.processor.getClasspath().size() + 1);
            for (Artifact artifact : this.processor.getClasspath()) {
                Path file = ForgeNewInstallTask.this.gameRepository.getArtifactFile(ForgeNewInstallTask.this.version, artifact);
                if (!Files.isRegularFile(file, new LinkOption[0])) {
                    throw new Exception("Game processor dependency missing");
                }
                classpath.add(file.toString());
            }
            classpath.add(jar.toString());
            command.add(String.join((CharSequence)OperatingSystem.PATH_SEPARATOR, classpath));
            command.add(mainClass);
            ArrayList<String> args = new ArrayList<String>(this.processor.getArgs().size());
            for (String arg : this.processor.getArgs()) {
                String parsed = ForgeNewInstallTask.this.parseLiteral(arg, this.vars);
                if (parsed == null) {
                    throw new ArtifactMalformedException("Invalid forge installation configuration");
                }
                args.add(parsed);
            }
            command.addAll(args);
            Logging.LOG.info("Executing external processor " + this.processor.getJar().toString() + ", command line: " + new CommandBuilder().addAll(command).toString());
            int n = SystemUtils.callExternalProcess(command);
            if (n != 0) {
                throw new IOException("Game processor exited abnormally with code " + n);
            }
            for (Map.Entry entry : outputs.entrySet()) {
                String code;
                Path artifact = Paths.get((String)entry.getKey(), new String[0]);
                if (!Files.isRegularFile(artifact, new LinkOption[0])) {
                    throw new FileNotFoundException("File missing: " + artifact);
                }
                try (InputStream stream = Files.newInputStream(artifact, new OpenOption[0]);){
                    code = DigestUtils.digestToString("SHA-1", stream);
                }
                if (Objects.equals(code, entry.getValue())) continue;
                Files.delete(artifact);
                throw new ChecksumMismatchException("SHA-1", (String)entry.getValue(), code);
            }
        }
    }
}

