/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class OAuth {
    public static final OAuth MICROSOFT = new OAuth("https://login.live.com/oauth20_authorize.srf", "https://login.live.com/oauth20_token.srf", "https://login.microsoftonline.com/consumers/oauth2/v2.0/devicecode", "https://login.microsoftonline.com/consumers/oauth2/v2.0/token");
    private final String authorizationURL;
    private final String accessTokenURL;
    private final String deviceCodeURL;
    private final String tokenURL;

    public OAuth(String authorizationURL, String accessTokenURL, String deviceCodeURL, String tokenURL) {
        this.authorizationURL = authorizationURL;
        this.accessTokenURL = accessTokenURL;
        this.deviceCodeURL = deviceCodeURL;
        this.tokenURL = tokenURL;
    }

    public Result authenticate(GrantFlow grantFlow, Options options) throws AuthenticationException {
        try {
            switch (grantFlow) {
                case AUTHORIZATION_CODE: {
                    return this.authenticateAuthorizationCode(options);
                }
                case DEVICE: {
                    return this.authenticateDevice(options);
                }
            }
            throw new UnsupportedOperationException("grant flow " + (Object)((Object)grantFlow));
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (InterruptedException e) {
            throw new NoSelectedCharacterException();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new NoSelectedCharacterException();
            }
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    private Result authenticateAuthorizationCode(Options options) throws IOException, InterruptedException, JsonParseException, ExecutionException, AuthenticationException {
        Session session = options.callback.startServer();
        options.callback.openBrowser(NetworkUtils.withQuery(this.authorizationURL, Lang.mapOf(Pair.pair("client_id", options.callback.getClientId()), Pair.pair("response_type", "code"), Pair.pair("redirect_uri", session.getRedirectURI()), Pair.pair("scope", options.scope), Pair.pair("prompt", "select_account"))));
        String code = session.waitFor();
        AuthorizationResponse response = HttpRequest.POST(this.accessTokenURL).form(Pair.pair("client_id", options.callback.getClientId()), Pair.pair("code", code), Pair.pair("grant_type", "authorization_code"), Pair.pair("client_secret", options.callback.getClientSecret()), Pair.pair("redirect_uri", session.getRedirectURI()), Pair.pair("scope", options.scope)).ignoreHttpCode().retry(5).getJson(AuthorizationResponse.class);
        OAuth.handleErrorResponse(response);
        return new Result(response.accessToken, response.refreshToken);
    }

    private Result authenticateDevice(Options options) throws IOException, InterruptedException, JsonParseException, AuthenticationException {
        TokenResponse tokenResponse;
        DeviceTokenResponse deviceTokenResponse = HttpRequest.POST(this.deviceCodeURL).form(Pair.pair("client_id", options.callback.getClientId()), Pair.pair("scope", options.scope)).ignoreHttpCode().retry(5).getJson(DeviceTokenResponse.class);
        OAuth.handleErrorResponse(deviceTokenResponse);
        options.callback.grantDeviceCode(deviceTokenResponse.userCode, deviceTokenResponse.verificationURI);
        options.callback.openBrowser(deviceTokenResponse.verificationURI);
        long startTime = System.nanoTime();
        int interval = deviceTokenResponse.interval;
        while (true) {
            Thread.sleep(Math.max(interval, 1));
            long estimatedTime = System.nanoTime() - startTime;
            if (TimeUnit.SECONDS.convert(estimatedTime, TimeUnit.NANOSECONDS) >= (long)Math.min(deviceTokenResponse.expiresIn, 900)) {
                throw new NoSelectedCharacterException();
            }
            tokenResponse = HttpRequest.POST(this.tokenURL).form(Pair.pair("grant_type", "urn:ietf:params:oauth:grant-type:device_code"), Pair.pair("code", deviceTokenResponse.deviceCode), Pair.pair("client_id", options.callback.getClientId())).ignoreHttpCode().retry(5).getJson(TokenResponse.class);
            if ("authorization_pending".equals(tokenResponse.error)) continue;
            if ("expired_token".equals(tokenResponse.error)) {
                throw new NoSelectedCharacterException();
            }
            if (!"slow_down".equals(tokenResponse.error)) break;
            interval += 5;
        }
        return new Result(tokenResponse.accessToken, tokenResponse.refreshToken);
    }

    public Result refresh(String refreshToken, Options options) throws AuthenticationException {
        try {
            Map<String, String> query = Lang.mapOf(Pair.pair("client_id", options.callback.getClientId()), Pair.pair("refresh_token", refreshToken), Pair.pair("grant_type", "refresh_token"));
            if (!options.callback.isPublicClient()) {
                query.put("client_secret", options.callback.getClientSecret());
            }
            RefreshResponse response = HttpRequest.POST(this.tokenURL).form(query).accept("application/json").ignoreHttpCode().retry(5).getJson(RefreshResponse.class);
            OAuth.handleErrorResponse(response);
            return new Result(response.accessToken, response.refreshToken);
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    private static void handleErrorResponse(ErrorResponse response) throws AuthenticationException {
        if (response.error == null || response.errorDescription == null) {
            return;
        }
        switch (response.error) {
            case "invalid_grant": {
                if (!response.errorDescription.contains("AADSTS70000")) break;
                throw new CredentialExpiredException();
            }
        }
        throw new RemoteAuthenticationException(response.error, response.errorDescription, "");
    }

    public static enum GrantFlow {
        AUTHORIZATION_CODE,
        DEVICE;

    }

    public static class Options {
        private String userAgent;
        private final String scope;
        private final Callback callback;

        public Options(String scope, Callback callback) {
            this.scope = scope;
            this.callback = callback;
        }

        public Options setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }
    }

    public static final class Result {
        private final String accessToken;
        private final String refreshToken;

        public Result(String accessToken, String refreshToken) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }
    }

    public static interface Callback {
        public Session startServer() throws IOException, AuthenticationException;

        public void grantDeviceCode(String var1, String var2);

        public void openBrowser(String var1) throws IOException;

        public String getClientId();

        public String getClientSecret();

        public boolean isPublicClient();
    }

    public static interface Session {
        public String getRedirectURI();

        public String waitFor() throws InterruptedException, ExecutionException;

        default public String getIdToken() {
            return null;
        }
    }

    public static class AuthorizationResponse
    extends ErrorResponse {
        @SerializedName(value="token_type")
        public String tokenType;
        @SerializedName(value="expires_in")
        public int expiresIn;
        @SerializedName(value="scope")
        public String scope;
        @SerializedName(value="access_token")
        public String accessToken;
        @SerializedName(value="refresh_token")
        public String refreshToken;
        @SerializedName(value="user_id")
        public String userId;
        @SerializedName(value="foci")
        public String foci;
    }

    private static class ErrorResponse {
        @SerializedName(value="error")
        public String error;
        @SerializedName(value="error_description")
        public String errorDescription;
        @SerializedName(value="correlation_id")
        public String correlationId;

        private ErrorResponse() {
        }
    }

    private static class DeviceTokenResponse
    extends ErrorResponse {
        @SerializedName(value="user_code")
        public String userCode;
        @SerializedName(value="device_code")
        public String deviceCode;
        @SerializedName(value="verification_uri")
        public String verificationURI;
        @SerializedName(value="expires_in")
        public int expiresIn;
        @SerializedName(value="interval")
        public int interval;

        private DeviceTokenResponse() {
        }
    }

    private static class TokenResponse
    extends ErrorResponse {
        @SerializedName(value="token_type")
        public String tokenType;
        @SerializedName(value="expires_in")
        public int expiresIn;
        @SerializedName(value="ext_expires_in")
        public int extExpiresIn;
        @SerializedName(value="scope")
        public String scope;
        @SerializedName(value="access_token")
        public String accessToken;
        @SerializedName(value="refresh_token")
        public String refreshToken;

        private TokenResponse() {
        }
    }

    private static class RefreshResponse
    extends ErrorResponse {
        @SerializedName(value="expires_in")
        int expiresIn;
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="refresh_token")
        String refreshToken;

        private RefreshResponse() {
        }
    }
}

