/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.SambaException;
import org.jackhuang.hmcl.task.AsyncTaskExecutor;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.CrashReporter;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Launcher
extends Application {
    public static final CookieManager COOKIE_MANAGER = new CookieManager();
    public static final CrashReporter CRASH_REPORTER = new CrashReporter(true);

    public void start(Stage primaryStage) {
        Thread.currentThread().setUncaughtExceptionHandler(CRASH_REPORTER);
        CookieHandler.setDefault(COOKIE_MANAGER);
        Launcher.register();
        Logging.LOG.info("JavaFX Version: " + System.getProperty("javafx.runtime.version"));
        try {
            Object pipeline = Class.forName("com.sun.prism.GraphicsPipeline").getMethod("getPipeline", new Class[0]).invoke(null, new Object[0]);
            Logging.LOG.info("Prism pipeline: " + (pipeline == null ? "null" : pipeline.getClass().getName()));
        }
        catch (Throwable e) {
            Logging.LOG.log(Level.WARNING, "Failed to get prism pipeline", e);
        }
        try {
            try {
                ConfigHolder.init();
            }
            catch (SambaException ignored) {
                Main.showWarningAndContinue(I18n.i18n("fatal.samba"));
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to load config", e);
                Launcher.checkConfigInTempDir();
                Launcher.checkConfigOwner();
                Main.showErrorAndExit(I18n.i18n("fatal.config_loading_failure", ConfigHolder.configLocation().getParent()));
            }
            if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX && ConfigHolder.isNewlyCreated() && System.getProperty("user.dir").startsWith("/private/var/folders/")) {
                if (Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.mac_app_translocation"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
                    return;
                }
            } else {
                Launcher.checkConfigInTempDir();
            }
            if (ConfigHolder.isOwnerChanged() && Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.config_change_owner_root"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
                return;
            }
            if (Metadata.HMCL_DIRECTORY.toString().indexOf(61) >= 0) {
                Main.showWarningAndContinue(I18n.i18n("fatal.illegal_char"));
            }
            Platform.runLater(() -> {
                Platform.setImplicitExit((boolean)false);
                Controllers.initialize(primaryStage);
                UpdateChecker.init();
                primaryStage.show();
            });
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    private static void register() {
        Skin.registerDefaultSkinLoader(type -> {
            switch (type) {
                case ALEX: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/alex.png");
                }
                case ARI: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/ari.png");
                }
                case EFE: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/efe.png");
                }
                case KAI: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/kai.png");
                }
                case MAKENA: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/makena.png");
                }
                case NOOR: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/noor.png");
                }
                case STEVE: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/steve.png");
                }
                case SUNNY: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/sunny.png");
                }
                case ZURI: {
                    return Skin.class.getResourceAsStream("/assets/img/skin/zuri.png");
                }
            }
            return null;
        });
        RemoteMod.registerEmptyRemoteMod(new RemoteMod("", "", I18n.i18n("mods.broken_dependency.title"), I18n.i18n("mods.broken_dependency.desc"), new ArrayList<String>(), "", "/assets/img/icon@8x.png", new RemoteMod.IMod(){

            @Override
            public List<RemoteMod> loadDependencies(RemoteModRepository modRepository) throws IOException {
                throw new IOException();
            }

            @Override
            public Stream<RemoteMod.Version> loadVersions(RemoteModRepository modRepository) throws IOException {
                throw new IOException();
            }
        }));
    }

    private static ButtonType showAlert(Alert.AlertType alertType, String contentText, ButtonType ... buttons) {
        return new Alert(alertType, contentText, buttons).showAndWait().orElse(null);
    }

    private static boolean isConfigInTempDir() {
        String[] tempFolderNames;
        String configPath = ConfigHolder.configLocation().toString();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isNotBlank(tmpdir) && configPath.startsWith(tmpdir)) {
            return true;
        }
        for (String name : tempFolderNames = new String[]{"Temp", "Cache", "Caches"}) {
            if (!configPath.contains(File.separator + name + File.separator)) continue;
            return true;
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            return configPath.contains("\\Temporary Internet Files\\") || configPath.contains("\\INetCache\\") || configPath.contains("\\$Recycle.Bin\\") || configPath.contains("\\recycler\\");
        }
        if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
            return configPath.startsWith("/tmp/") || configPath.startsWith("/var/tmp/") || configPath.startsWith("/var/cache/") || configPath.startsWith("/dev/shm/") || configPath.contains("/Trash/");
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            return configPath.startsWith("/var/folders/") || configPath.startsWith("/private/var/folders/") || configPath.startsWith("/tmp/") || configPath.startsWith("/private/tmp/") || configPath.startsWith("/var/tmp/") || configPath.startsWith("/private/var/tmp/") || configPath.contains("/.Trash/");
        }
        return false;
    }

    private static void checkConfigInTempDir() {
        if (ConfigHolder.isNewlyCreated() && Launcher.isConfigInTempDir() && Launcher.showAlert(Alert.AlertType.WARNING, I18n.i18n("fatal.config_in_temp_dir"), ButtonType.YES, ButtonType.NO) == ButtonType.NO) {
            System.exit(0);
        }
    }

    private static void checkConfigOwner() {
        Path mcDir;
        String owner;
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            return;
        }
        String userName = System.getProperty("user.name");
        try {
            owner = Files.getOwner(ConfigHolder.configLocation(), new LinkOption[0]).getName();
        }
        catch (IOException ioe) {
            Logging.LOG.log(Level.WARNING, "Failed to get file owner", ioe);
            return;
        }
        if (Files.isWritable(ConfigHolder.configLocation()) || userName.equals("root") || userName.equals(owner)) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(ConfigHolder.configLocation().toString());
        if (Files.exists(Metadata.HMCL_DIRECTORY, new LinkOption[0])) {
            files.add(Metadata.HMCL_DIRECTORY.toString());
        }
        if (Files.exists(mcDir = Paths.get(".minecraft", new String[0]).toAbsolutePath().normalize(), new LinkOption[0])) {
            files.add(mcDir.toString());
        }
        String command = new CommandBuilder().add("sudo", "chown", "-R", userName).addAll(files).toString();
        ButtonType copyAndExit = new ButtonType(I18n.i18n("button.copy_and_exit"));
        if (Launcher.showAlert(Alert.AlertType.ERROR, I18n.i18n("fatal.config_loading_failure.unix", owner, command), copyAndExit, ButtonType.CLOSE) == copyAndExit) {
            Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, command));
        }
        System.exit(1);
    }

    public void stop() throws Exception {
        super.stop();
        Controllers.onApplicationStop();
    }

    public static void main(String[] args) {
        if (UpdateHandler.processArguments(args)) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(CRASH_REPORTER);
        AsyncTaskExecutor.setUncaughtExceptionHandler(new CrashReporter(false));
        try {
            Logging.LOG.info("*** " + Metadata.TITLE + " ***");
            Logging.LOG.info("Operating System: " + OperatingSystem.SYSTEM_NAME + ' ' + OperatingSystem.SYSTEM_VERSION);
            Logging.LOG.info("System Architecture: " + Architecture.SYSTEM_ARCH_NAME);
            Logging.LOG.info("Java Architecture: " + Architecture.CURRENT_ARCH_NAME);
            Logging.LOG.info("Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
            Logging.LOG.info("Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
            Logging.LOG.info("Java Home: " + System.getProperty("java.home"));
            Logging.LOG.info("Current Directory: " + System.getProperty("user.dir"));
            Logging.LOG.info("HMCL Directory: " + Metadata.HMCL_DIRECTORY);
            Logging.LOG.info("HMCL Jar Path: " + Lang.requireNonNullElse(JarUtils.thisJarPath(), "Not Found"));
            Logging.LOG.info("Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB");
            Logging.LOG.info("Physical memory: " + OperatingSystem.TOTAL_MEMORY + " MB");
            Logging.LOG.info("Metaspace: " + ManagementFactory.getMemoryPoolMXBeans().stream().filter(bean -> bean.getName().equals("Metaspace")).findAny().map(bean -> bean.getUsage().getUsed() / 1024L / 1024L + "MB").orElse("Unknown"));
            if (OperatingSystem.CURRENT_OS.isLinuxOrBSD()) {
                Logging.LOG.info("XDG Session Type: " + System.getenv("XDG_SESSION_TYPE"));
            }
            Launcher.launch(Launcher.class, (String[])args);
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public static void stopApplication() {
        Logging.LOG.info("Stopping application.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Platform.exit();
        });
    }

    public static void stopWithoutPlatform() {
        Logging.LOG.info("Stopping application without JavaFX Toolkit.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Lang.executeDelayed(OperatingSystem::forceGC, TimeUnit.SECONDS, 5L, true);
        });
    }
}

