/*
 * Decompiled with CFR 0.152.
 */
package moe.mickey.minecraft.skin.fx;

import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public final class SkinHelper {
    private SkinHelper() {
    }

    public static boolean isNoRequest(Image image) {
        return image.getRequestedWidth() == 0.0 && image.getRequestedHeight() == 0.0;
    }

    public static boolean isSkin(Image image) {
        return image.getWidth() % 64.0 == 0.0 && image.getWidth() / 64.0 > 0.0 && (image.getHeight() == image.getWidth() / 2.0 || image.getHeight() == image.getWidth());
    }

    public static Image x32Tox64(Image srcSkin) {
        if (srcSkin.getHeight() == srcSkin.getWidth()) {
            return srcSkin;
        }
        WritableImage newSkin = new WritableImage((int)srcSkin.getWidth(), (int)srcSkin.getHeight() * 2);
        PixelCopier copier = new PixelCopier(srcSkin, newSkin);
        copier.copy(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.5f);
        SkinHelper.x32Tox64(copier, 0.0f, 0.5f, 0.25f, 0.75f, 0.0625f, 0.375f, 0.0625f);
        copier.copy(0.0f, 0.5f, 0.0f, 0.25f, 0.25f, 0.5f);
        copier.copy(0.25f, 0.5f, 0.25f, 0.25f, 0.375f, 0.5f);
        SkinHelper.x32Tox64(copier, 0.625f, 0.5f, 0.5f, 0.75f, 0.0625f, 0.375f, 0.0625f);
        copier.copy(0.625f, 0.5f, 0.625f, 0.25f, 0.25f, 0.5f);
        return newSkin;
    }

    static void x32Tox64(PixelCopier copier, float srcX, float srcY, float toX, float toY, float width, float height, float depth) {
        copier.copy(srcX + depth, srcY, toX + depth, toY, width, depth * 2.0f, true, false);
        copier.copy(srcX + depth + width, srcY, toX + depth + width, toY, width, depth * 2.0f, true, false);
        copier.copy(srcX, srcY + depth * 2.0f, toX + width + depth, toY + depth, depth, height, true, false);
        copier.copy(srcX + width + depth, srcY + depth * 2.0f, toX, toY + depth, depth, height, true, false);
        copier.copy(srcX + depth, srcY + depth * 2.0f, toX + depth, toY + depth, width, height, true, false);
        copier.copy(srcX + width + depth * 2.0f, srcY + depth * 2.0f, toX + width + depth * 2.0f, toY + depth, width, height, true, false);
    }

    public static Image enlarge(Image srcSkin, int multipleX, int multipleY) {
        WritableImage newSkin = new WritableImage((int)srcSkin.getWidth() * multipleX, (int)srcSkin.getHeight() * multipleY);
        PixelReader reader = srcSkin.getPixelReader();
        PixelWriter writer = newSkin.getPixelWriter();
        int lenX = (int)srcSkin.getWidth();
        for (int x = 0; x < lenX; ++x) {
            int lenY = (int)srcSkin.getHeight();
            for (int y = 0; y < lenY; ++y) {
                for (int mx = 0; mx < multipleX; ++mx) {
                    for (int my = 0; my < multipleY; ++my) {
                        int argb = reader.getArgb(x, y);
                        writer.setArgb(x * multipleX + mx, y * multipleY + my, argb);
                    }
                }
            }
        }
        return newSkin;
    }

    public static class PixelCopier {
        protected Image srcImage;
        protected WritableImage newImage;

        public PixelCopier(Image srcImage, WritableImage newImage) {
            this.srcImage = srcImage;
            this.newImage = newImage;
        }

        public void copy(int srcX, int srcY, int width, int height) {
            this.copy(srcX, srcY, srcX, srcY, width, height);
        }

        public void copy(int srcX, int srcY, int toX, int toY, int width, int height) {
            this.copy(srcX, srcY, toX, toY, width, height, false, false);
        }

        public void copy(int srcX, int srcY, int toX, int toY, int width, int height, boolean reversalX, boolean reversalY) {
            PixelReader reader = this.srcImage.getPixelReader();
            PixelWriter writer = this.newImage.getPixelWriter();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    writer.setArgb(toX + x, toY + y, reader.getArgb(srcX + (reversalX ? width - x - 1 : x), srcY + (reversalY ? height - y - 1 : y)));
                }
            }
        }

        public void copy(float srcX, float srcY, float toX, float toY, float width, float height) {
            this.copy(srcX, srcY, toX, toY, width, height, false, false);
        }

        public void copy(float srcX, float srcY, float toX, float toY, float width, float height, boolean reversalX, boolean reversalY) {
            PixelReader reader = this.srcImage.getPixelReader();
            PixelWriter writer = this.newImage.getPixelWriter();
            int srcScaleX = (int)this.srcImage.getWidth();
            int srcScaleY = (int)this.srcImage.getHeight();
            int newScaleX = (int)this.newImage.getWidth();
            int newScaleY = (int)this.newImage.getHeight();
            int srcWidth = (int)(width * (float)srcScaleX);
            int srcHeight = (int)(height * (float)srcScaleY);
            for (int x = 0; x < srcWidth; ++x) {
                for (int y = 0; y < srcHeight; ++y) {
                    writer.setArgb((int)(toX * (float)newScaleX + (float)x), (int)(toY * (float)newScaleY + (float)y), reader.getArgb((int)(srcX * (float)srcScaleX + (float)(reversalX ? srcWidth - x - 1 : x)), (int)(srcY * (float)srcScaleY + (float)(reversalY ? srcHeight - y - 1 : y))));
                }
            }
        }
    }
}

