
      SUBROUTINE uptake(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES EXCHANGES OF ENERGY, C, N AND P
C     BETWEEN THE CANOPY AND THE ATMOSPHERE AND BETWEEN ROOTS AND THE SOIL
C
      include "parameters.h"
      include "blkc.h"
      include "blk1cp.h"
      include "blk1cr.h"
      include "blk1g.h"
      include "blk1n.h"
      include "blk1p.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk3.h"
      include "blk5.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk9a.h"
      include "blk9b.h"
      include "blk9c.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk12a.h"
      include "blk12b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk13d.h"
      include "blk14.h"
      include "blk16.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk1u.h"
      DIMENSION PSIST1(JZ),PATH(2,JZ),RRADL(2,JZ),RTARS(2,JZ)
     2,RSRT(2,JZ),ILYR(2,JZ),RSRG(2,JZ),RSR1(2,JZ),RSR2(2,JZ) 
     3,RSSX(2,JZ),RSRS(2,JZ),WTRTG(JZ),FPQ(JZ,05),FPP(JZ,05) 
     4,RACZ(05,JY,JX),FRTDPX(JZ,05),RTARR(2,JZ)
      PARAMETER(MXN=200,DIFFX=1.0E-09,DIFFY=0.5E-02)
      PARAMETER (RTLGPX=0.0E-06,RTDNPZ=1.0E+03,FMN=1.0E-06
     2,RAM=1.39E-03,RACX=0.0278,RZ=0.0278,EMODW=50.0)
      PARAMETER(DSTK=0.225,VSTK=1.0E-06/DSTK)
      PARAMETER(SNH3X=2.852E+02,EMMC=0.98)
      PARAMETER(ZCKI=1.0E-01,PCKI=1.0E-02,ZPKI=ZCKI/PCKI
     2,PZKI=PCKI/ZCKI)
      PARAMETER(EXUDR=-0.50E-03,CNKER=1.0E+00,CPKER=1.0E+01
     2,CNMX=0.20,CPMX=0.020)
      REAL*4 RI,TKGO,TKSO 
C     REAL*16 B,C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
C
C     RESET TOTAL UPTAKE ARRAYS
C
      ARLSC=0.0
      DO 9984 NZ=1,NP0(NY,NX)
C     TKC(NZ,NY,NX)=TKA(NY,NX)+DTKC(NZ,NY,NX)
C     TCC(NZ,NY,NX)=TKC(NZ,NY,NX)-273.15
      ARLSC=ARLSC+ARLFP(NZ,NY,NX)+ARSTP(NZ,NY,NX)
      RAD1(NZ,NY,NX)=0.0
      EFLXC(NZ,NY,NX)=0.0
      SFLXC(NZ,NY,NX)=0.0
      HFLXC(NZ,NY,NX)=0.0
      THRM1(NZ,NY,NX)=0.0
      EP(NZ,NY,NX)=0.0
      EVAPC(NZ,NY,NX)=0.0
      UPOMC(NZ,NY,NX)=0.0
      UPOMN(NZ,NY,NX)=0.0
      UPOMP(NZ,NY,NX)=0.0
      UPNH4(NZ,NY,NX)=0.0
      UPNO3(NZ,NY,NX)=0.0
      UPH2P(NZ,NY,NX)=0.0
      UPNF(NZ,NY,NX)=0.0
C
C     RESET UPTAKE ARRAYS
C
      DO 9984 L=NU(NY,NX),NI(NZ,NY,NX)
      DO 9984 N=1,MY(NZ,NY,NX)
      UPWTR(N,L,NZ,NY,NX)=0.0
      RCO2P(N,L,NZ,NY,NX)=0.0
      RUPOXP(N,L,NZ,NY,NX)=0.0
      RCO2S(N,L,NZ,NY,NX)=0.0
      RUPOXS(N,L,NZ,NY,NX)=0.0
      RUPCHS(N,L,NZ,NY,NX)=0.0
      RUPN2S(N,L,NZ,NY,NX)=0.0
      RUPN3S(N,L,NZ,NY,NX)=0.0
      RUPN3B(N,L,NZ,NY,NX)=0.0
      RUPHGS(N,L,NZ,NY,NX)=0.0
      RCOFLA(N,L,NZ,NY,NX)=0.0
      ROXFLA(N,L,NZ,NY,NX)=0.0
      RCHFLA(N,L,NZ,NY,NX)=0.0
      RN2FLA(N,L,NZ,NY,NX)=0.0
      RNHFLA(N,L,NZ,NY,NX)=0.0
      RHGFLA(N,L,NZ,NY,NX)=0.0
      RCODFA(N,L,NZ,NY,NX)=0.0
      ROXDFA(N,L,NZ,NY,NX)=0.0
      RCHDFA(N,L,NZ,NY,NX)=0.0
      RN2DFA(N,L,NZ,NY,NX)=0.0
      RNHDFA(N,L,NZ,NY,NX)=0.0
      RHGDFA(N,L,NZ,NY,NX)=0.0
9984  CONTINUE
      DO 9000 L=NU(NY,NX),NL(NY,NX)
      PSIST1(L)=PSIST(L,NY,NX)-0.01*ALT(NY,NX)
      WTRTG(L)=0.0
      DO 9005 NZ=1,NP(NY,NX)
      IF(IFLGC(NZ,NY,NX).EQ.1.AND.PP(NZ,NY,NX).GT.0.0)THEN
      WTRTG(L)=WTRTG(L)+WTRTD(1,L,NZ,NY,NX)
      ENDIF
9005  CONTINUE
9000  CONTINUE
C
C     IF PLANT SPECIES EXISTS
C
      DO 9985 NZ=1,NP(NY,NX)
      OSTRN=0.0
      OSTRD=0.0
      IF(IFLGC(NZ,NY,NX).EQ.1.AND.PP(NZ,NY,NX).GT.0.0)THEN
C
C     APPLY CLUMPING FACTOR TO LEAF SURFACE AREA DEFINED BY INCLINATION,
C     LAYER, NODE, BRANNCH, SPECIES, N-S POSITION, E-W POSITION
C     (AZIMUTH ASSUMED UNIFORM)
C
      DO 500 NB=1,NBR(NZ,NY,NX)
      DO 550 K=1,25
C
C     NUMBER OF MINIMUM LEAFED NODE USED IN GROWTH ALLOCATION
C
      IF(ARLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WSLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      KLEAFX(NB,NZ,NY,NX)=K
      ENDIF
      DO 600 L=NC(NY,NX),1,-1
      DO 650 N=1,4
      SURFX(N,L,K,NB,NZ,NY,NX)=SURF(N,L,K,NB,NZ,NY,NX)*CFX(NZ,NY,NX)
650   CONTINUE
600   CONTINUE
550   CONTINUE
500   CONTINUE
C
C     CANOPY HEIGHT FROM HEIGHT OF MAXIMUM LEAF LAYER
C
C
C     DIFFUSIVE RESISTANCE OF OTHER TALLER CANOPIES TO HEAT AND VAPOR
C     TRANSFER OF CURRENT CANOPY ADDED TO BOUNDARY LAYER RESISTANCE
C     OF TALLEST CANOPY CALCULATED IN 'HOUR1'
C
      ARLSP=ARLFP(NZ,NY,NX)+ARSTP(NZ,NY,NX)
      IF(ARLSP.GT.0.0.AND.ZC(NZ,NY,NX).GT.DPTHS(NY,NX))THEN
      IF(IETYP(NY,NX).GE.0)THEN
      TFRADP=0.0
      DO 700 NZZ=1,NP(NY,NX)
      IF(ZC(NZZ,NY,NX).GT.ZC(NZ,NY,NX)+ZR(NY,NX))THEN
      TFRADP=TFRADP+FRADP(NZZ,NY,NX)
      ENDIF
700   CONTINUE
      ALFZ=2.0*TFRADP 
      IF(RAB(NY,NX).GT.ZERO.AND.ZT(NY,NX).GT.ZERO
     2.AND.ALFZ.GT.ZERO)THEN
      RACZ(NZ,NY,NX)=AMIN1(RACX,AMAX1(0.0,ZT(NY,NX)*EXP(ALFZ) 
     2/(ALFZ/RAB(NY,NX))*(EXP(-ALFZ*ZC(NZ,NY,NX)/ZT(NY,NX))
     3-EXP(-ALFZ*(ZD(NY,NX)+ZR(NY,NX))/ZT(NY,NX)))))
      ELSE
      RACZ(NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RACZ(NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RACZ(NZ,NY,NX)=RACX
      ENDIF
      RAZ(NZ,NY,NX)=RAB(NY,NX)+RACZ(NZ,NY,NX)
C     IF(NX.EQ.1.AND.NY.EQ.5.AND.NZ.EQ.3)THEN
C     WRITE(*,4411)'RAC',I,J,NZ,RACZ(NZ,NY,NX),RAB(NY,NX),RAZ(NZ,NY,NX)
C    2,ZT(NY,NX),ZD(NY,NX),ZR(NY,NX),ZC(NZ,NY,NX),ALFZ
C    3,TFRADP,RACX,EXP(-ALFZ*ZC(NZ,NY,NX)/ZT(NY,NX))
C    4,EXP(-ALFZ*(ZD(NY,NX)+ZR(NY,NX))/ZT(NY,NX)),RADP(NZ,NY,NX)
C    5,FRADP(NZ,NY,NX),DPTHS(NY,NX) 
4411  FORMAT(A8,3I4,20E12.4)
C     ENDIF
C
C     INITIALIZE CANOPY TEMPERATURE WITH CURRENT AIR TEMPERATURE AND
C     LAST HOUR'S CANOPY-AIR TEMPERATURE DIFFERENCE, AND CALL A
C     SUBROUTINE TO CALCULATE MINIMUM CANOPY STOMATAL RESISTANCE
C     FOR SUBSEQUENT USE IN ENERGY EXCHANGE CALCULATIONS
C
      TKCZ(NZ,NY,NX)=TKA(NY,NX)+DTKC(NZ,NY,NX)
      CALL STOMATE(I,J,NZ,NY,NX)
C
C     CALCULATE VARIABLES USED IN ROOT UPTAKE OF WATER AND NUTRIENTS
C
      DO 2000 N=1,MY(NZ,NY,NX)
      DO 2000 L=NU(NY,NX),NI(NZ,NY,NX)
      IF(N.EQ.1)THEN
      RTDPZ=0.0
      DO 2005 NR=1,NRT(NZ,NY,NX)
      RTDPZ=AMAX1(RTDPZ,RTDP1(1,NR,NZ,NY,NX))
2005  CONTINUE
      IF(L.EQ.NU(NY,NX))THEN
      FRTDPX(L,NZ)=1.0
      ELSE
      RTDPX=AMAX1(0.0,RTDPZ-CDPTHZ(L-1,NY,NX))
      RTDPX=AMAX1(0.0,AMIN1(DLYR(3,L,NY,NX),RTDPX)
     2-AMAX1(0.0,SDPTH(NZ,NY,NX)-CDPTHZ(L-1,NY,NX)-HTCTL(NZ,NY,NX)))
      FRTDPX(L,NZ)=RTDPX/DLYR(3,L,NY,NX)
      ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.2)THEN
C     WRITE(*,4413)'FRTDPX',I,J,NZ,L,N,FRTDPX(L,NZ)
C    2,RTDPX,DLYR(3,L,NY,NX),RTDPZ,RTDP1(1,1,NZ,NY,NX)
C    3,SDPTH(NZ,NY,NX),CDPTHZ(L-1,NY,NX),HTCTL(NZ,NY,NX)
C    4,WTRTD(1,L,NZ,NY,NX),WTRTG(L),FPQ(L,NZ)
C     ENDIF 
      ENDIF
      IF(WTRTG(L).GT.ZEROS(NY,NX))THEN
      FPQ(L,NZ)=WTRTD(1,L,NZ,NY,NX)/WTRTG(L)
      ELSEIF(PPT(NY,NX).GT.ZEROS(NY,NX))THEN
      FPQ(L,NZ)=PP(NZ,NY,NX)/PPT(NY,NX)
      ELSE
      FPQ(L,NZ)=1.0/NP(NY,NX)
      ENDIF
      FPP(L,NZ)=FMN*FPQ(L,NZ)
      IF(RTDNP(N,L,NZ,NY,NX).GT.ZERO
     2.AND.FRTDPX(L,NZ).GT.ZERO)THEN
      RRADL(N,L)=AMAX1(RRAD2X(N,NZ,NY,NX),SQRT((RTVLW(N,L,NZ,NY,NX)
     2/(1.0-PORT(N,NZ,NY,NX)))/(3.1416*PP(NZ,NY,NX)
     3*RTLGP(N,L,NZ,NY,NX))))
      PATH(N,L)=AMAX1(1.001*RRADL(N,L)
     2,1.0/(SQRT(3.1416*(RTDNP(N,L,NZ,NY,NX)/FRTDPX(L,NZ))
     3/FMPR(L,NY,NX))))
      RTARR(N,L)=6.283*AMAX1(RTLGPX,RTLGP(N,L,NZ,NY,NX)
     2/FRTDPX(L,NZ))
      IF(L.EQ.NU(NY,NX))THEN
      RTARS(N,L)=RTARR(N,L)
      ELSE
      RTDNPY=AMIN1(RTDNPZ,RTDNP(N,L,NZ,NY,NX))
      RTARS(N,L)=RTARR(N,L)
     2*(1.0+9.0*(1.0-RTDNPY/RTDNPZ))
      ENDIF
      ELSE
      RRADL(N,L)=RRAD2M(N,NZ,NY,NX)
      PATH(N,L)=1.001*RRADL(N,L)
      RTARR(N,L)=6.283*AMAX1(RTLGPX,RTLGP(N,L,NZ,NY,NX))
      RTARS(N,L)=RTARR(N,L) 
      ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.2)THEN
C     WRITE(*,4413)'RTAR',I,J,NZ,L,N,RTARR(N,L),RTARS(N,L)
C    2,RTDNPY,RTDNPZ,RTLGP(N,L,NZ,NY,NX),RTDNP(N,L,NZ,NY,NX) 
C    2,PP(NZ,NY,NX),RTDNP(N,L,NZ,NY,NX)*PP(NZ,NY,NX)
C    2/AREA(3,L,NY,NX),FRTDPX(L,NZ),FPQ(L,NZ)
4413  FORMAT(A8,5I4,12E16.8)
C     ENDIF 
2000  CONTINUE
C
C     CALCULATE CANOPY WATER STATUS FROM CONVERGENCE SOLUTION FOR
C     TRANSPIRATION - ROOT WATER UPTAKE = CHANGE IN CANOPY WATER CONTENT
C
C     IF((NX.EQ.2.AND.NY.EQ.2).OR.(NX.EQ.4.AND.NY.EQ.4))THEN
C     WRITE(*,2123)'START',I,J,NX,NY,NZ
C    2,IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX),ARLSP,PP(NZ,NY,NX)
C    3,FRADP(NZ,NY,NX),RTDP1(1,1,NZ,NY,NX),SDPTH(NZ,NY,NX)
C    4,FRTDPX(L,NZ),RTDPX,RAZ(NZ,NY,NX)
2123  FORMAT(A8,6I4,20E12.4)
C     ENDIF
      IF((IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).NE.0)
     3.AND.(ARLSP.GT.ZEROL(NZ,NY,NX).AND.FRADP(NZ,NY,NX).GT.0.0)
     4.AND.(RTDP1(1,1,NZ,NY,NX).GT.SDPTH(NZ,NY,NX)))THEN
C
C     GRAVIMETRIC WATER POTENTIAL FROM CANOPY HEIGHT
C
      CNDT=0.0
      HTSTZ(NZ,NY,NX)=0.80*ZC(NZ,NY,NX)
      PSILH=-0.01*HTSTZ(NZ,NY,NX)
      FRADW=1.0E+04*(AMAX1(0.5,1.0+PSILT(NZ,NY,NX)/EMODW))**4
C
C     SOIL AND ROOT HYDRAULIC RESISTANCES TO ROOT WATER UPTAKE
C
      DO 3880 N=1,MY(NZ,NY,NX)
      DO 3880 L=NU(NY,NX),NI(NZ,NY,NX)
C     IF(J.EQ.15.AND.NZ.EQ.3)THEN
C     WRITE(*,2124)'ILYR',I,J,NX,NY,NZ,L,N,NN,RTDNP(N,L,NZ,NY,NX)
C    2,CNDU(L,NY,NX),RTN1(1,L,NZ,NY,NX),RTNL(N,L,NZ,NY,NX)
C    3,THETW(L,NY,NX)
2124  FORMAT(A8,8I4,20E12.4)
C     ENDIF
      IF(RTDNP(N,L,NZ,NY,NX).GT.ZERO
     2.AND.CNDU(L,NY,NX).GT.ZERO
     3.AND.RTN1(1,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     4.AND.RTNL(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     5.AND.THETW(L,NY,NX).GT.ZERO)THEN 
      ILYR(N,L)=1
C
C     SOIL HYDRAULIC RESISTANCE FROM RADIAL UPTAKE GEOMETRY
C     AND SOIL HYDRAULIC CONDUCTIVITY
C
      RSSL=(LOG(PATH(N,L)/RRADL(N,L))/RTARR(N,L))/PP(NZ,NY,NX)
      RSSX(N,L)=RSSL/CNDU(L,NY,NX)
C
C     RADIAL ROOT RESISTANCE FROM ROOT AREA AND RADIAL RESISTIVITY
C     ENTERED IN 'READQ'
C
      RTAR2=6.283*RRAD2(N,L,NZ,NY,NX)*RTLGP(N,L,NZ,NY,NX)*PP(NZ,NY,NX)
      RSRG(N,L)=RSRR(N,NZ,NY,NX)/RTAR2*VOLA(L,NY,NX)/VOLWM(NPH,L,NY,NX)
C
C     ROOT AXIAL RESISTANCE FROM RADII AND LENGTHS OF PRIMARY AND
C     SECONDARY ROOTS AND FROM AXIAL RESISTIVITY ENTERED IN 'READQ'
C
      FRAD1=(RRAD1(N,L,NZ,NY,NX)/RRAD2M(N,NZ,NY,NX))**4
      RSR1(N,L)=RSRA(N,NZ,NY,NX)*DPTHZ(L,NY,NX) 
     2/(FRAD1*RTN1(1,L,NZ,NY,NX))
     3+RSRA(1,NZ,NY,NX)*HTSTZ(NZ,NY,NX)
     4/(FRADW*RTN1(1,L,NZ,NY,NX))
      FRAD2=(RRAD2(N,L,NZ,NY,NX)/RRAD2M(N,NZ,NY,NX))**4
      RSR2(N,L)=RSRA(N,NZ,NY,NX)*RTLGA(N,L,NZ,NY,NX)
     2/(FRAD2*RTNL(N,L,NZ,NY,NX))
      ELSE
      ILYR(N,L)=0
      ENDIF
3880  CONTINUE
      DO 3890 N=1,MY(NZ,NY,NX)
      DO 3890 L=NU(NY,NX),NI(NZ,NY,NX)
      IF(ILYR(N,L).EQ.1)THEN
C
C     TOTAL ROOT RESISTANCE = SOIL + RADIAL + AXIAL
C
      RSRT(N,L)=RSRG(N,L)+RSR1(N,L)+RSR2(N,L)
      RSRS(N,L)=RSSX(N,L)+RSRT(N,L)
      CNDT=CNDT+1.0/RSRS(N,L)
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,8855)'RSRT',I,J,NX,NY,NZ,L,N,RSRT(N,L),RSRG(N,L) 
C    2,RSR1(N,L),RSR2(N,L),RSSX(N,L),RSRS(N,L),DPTHZ(L,NY,NX)
C    3,HTSTZ(NZ,NY,NX),RSRA(1,NZ,NY,NX)*HTSTZ(NZ,NY,NX)
C    4/(FRADW*AMAX1(PP(NZ,NY,NX),RTN1(1,L,NZ,NY,NX))) 
C    4,RTNL(N,L,NZ,NY,NX),RTLGP(N,L,NZ,NY,NX) 
C    7,RTLGA(N,L,NZ,NY,NX),FRAD1,PP(NZ,NY,NX) 
C    8,RTN1(1,L,NZ,NY,NX),FRADW,RTNL(N,L,NZ,NY,NX),CNDT
8855  FORMAT(A8,7I4,30E14.6)
C     ENDIF
      ENDIF
3890  CONTINUE
      ICHK=0
      PSIL2=0.0
      EPX=0.0
      VOLWPX=0.0
C
C     INITIALIZE CANOPY WATER POTENTIAL, OTHER VARIABLES USED IN ENERGY
C     BALANCE THAT DON'T NEED TO BE RECALCULATED DURING CONVERGENCE
C
      PSILT(NZ,NY,NX)=AMIN1(-1.0E-06,0.667*PSILT(NZ,NY,NX))
      EP(NZ,NY,NX)=0.0
      EVAPC(NZ,NY,NX)=0.0
      UPRT=0.0
      HFLWC1=FLWC(NZ,NY,NX)*4.19*TKA(NY,NX)
      FTHRM=EMMC*2.04E-10*FRADP(NZ,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
      FDTHS=(THS(NY,NX)+THRMGX(NY,NX))*FRADP(NZ,NY,NX)
      IF(ARLSC.GT.ZEROS(NY,NX))THEN
      FPC=ARLSP/ARLSC*AMIN1(1.0,0.5*ARLFC(NY,NX)
     2/AREA(3,NU(NY,NX),NY,NX))
      ELSEIF(PPT(NY,NX).GT.ZEROS(NY,NX))THEN
      FPC=PP(NZ,NY,NX)/PPT(NY,NX)
      ELSE
      FPC=1.0/NP(NY,NX)
      ENDIF
      PAREX=FPC*AREA(3,NU(NY,NX),NY,NX)
      PARHX=FPC*AREA(3,NU(NY,NX),NY,NX)*1.25E-03
      CCPOLT=CCPOLP(NZ,NY,NX)+CZPOLP(NZ,NY,NX)+CPPOLP(NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      TKCX=TKC(NZ,NY,NX)
      WVPLT=AMAX1(0.0,WTLS(NZ,NY,NX)+WVSTK(NZ,NY,NX))
      VHCPX=4.19*(WVPLT*VSTK+VOLWC(NZ,NY,NX)+VOLWP(NZ,NY,NX))
      RA1=RAZ(NZ,NY,NX)
      IC=0
      XC=0.5
C
C     CONVERGENCE SOLUTION
C
      DO 4000 NN=1,MXN
C
C     NET RADIATION FROM ABSORBED SW AND NET LW
C
      TKC1=TKCZ(NZ,NY,NX)
      THRM1(NZ,NY,NX)=FTHRM*TKC1**4
      DTHS1=FDTHS-THRM1(NZ,NY,NX)*2.0
      RAD1(NZ,NY,NX)=RADC(NZ,NY,NX)+DTHS1
C
C     BOUNDARY LAYER RESISTANCE FROM RICHARDSON NUMBER
C
      RI=AMAX1(-0.3,AMIN1(0.075,RIB(NY,NX)*(TKA(NY,NX)-TKC1)))
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,4443)'RI',I,J,NX,NY,NZ,NN,RI,RIB(NY,NX)
C    2,TKA(NY,NX),TKC1 
4443  FORMAT(A8,6I4,12E24.16)
C     ENDIF
      RA(NZ,NY,NX)=AMAX1(RAM,0.75*RA1,AMIN1(1.33*RA1
     2,RAZ(NZ,NY,NX)/(1.0-10.0*RI)))
      RA1=RA(NZ,NY,NX)
      PAREC=PAREX/RA(NZ,NY,NX)
      PARHC=PARHX/RA(NZ,NY,NX)
C
C     CANOPY WATER AND OSMOTIC POTENTIALS
C
      APSILT=ABS(PSILT(NZ,NY,NX))
      FDMP=0.16+0.10*APSILT/(0.05*APSILT+2.0)
      PSILO(NZ,NY,NX)=FDMP/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKC1*FDMP*CCPOLT/OSWT
      PSILG(NZ,NY,NX)=AMAX1(0.0,PSILT(NZ,NY,NX)-PSILO(NZ,NY,NX))
C
C     CANOPY STOMATAL RESISTANCE
C
      WFNC=EXP(RCS(NZ,NY,NX)*PSILG(NZ,NY,NX))
      RC(NZ,NY,NX)=RSMN(NZ,NY,NX)+(RSMH(NZ,NY,NX)-RSMN(NZ,NY,NX))*WFNC
C
C     CANOPY VAPOR PRESSURE AND EVAPORATION OF INTERCEPTED WATER
C     OR TRANSPIRATION OF UPTAKEN WATER
C
      VPC=2.173E-03/TKC1
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKC1))
     3*EXP(18.0*PSILT(NZ,NY,NX)/(8.3143*TKC1))
      EX=PAREC*(VPA(NY,NX)-VPC)
      IF(EX.GT.0.0)THEN
      EVAPC(NZ,NY,NX)=EX*RA(NZ,NY,NX)/(RA(NZ,NY,NX)+RZ)
      EX=0.0
      ELSEIF(EX.LE.0.0.AND.VOLWC(NZ,NY,NX).GT.0.0)THEN
      EVAPC(NZ,NY,NX)=AMAX1(EX*RA(NZ,NY,NX)/(RA(NZ,NY,NX)+RZ)
     2,-VOLWC(NZ,NY,NX))
      EX=EX-EVAPC(NZ,NY,NX)
      ENDIF
      EP(NZ,NY,NX)=EX*RA(NZ,NY,NX)/(RA(NZ,NY,NX)+RC(NZ,NY,NX))
      EFLXC(NZ,NY,NX)=(EP(NZ,NY,NX)+EVAPC(NZ,NY,NX))*VAP
      VFLXC=EVAPC(NZ,NY,NX)*4.19*TKC1
C
C     SENSIBLE + STORAGE HEAT FROM RN, LE AND CONVECTIVE HEAT FLUXES
C
      HFLXS=RAD1(NZ,NY,NX)+EFLXC(NZ,NY,NX)+VFLXC+HFLWC1
C
C     SOLVE FOR CANOPY TEMPERATURE CAUSED BY SENSIBLE + STORAGE HEAT
C
      VHCPC(NZ,NY,NX)=VHCPX+4.19*(EVAPC(NZ,NY,NX)+FLWC(NZ,NY,NX))
      TKCY=(TKCX*VHCPX+TKA(NY,NX)*PARHC+HFLXS)/(VHCPC(NZ,NY,NX)+PARHC)
      TKCY=AMIN1(TKA(NY,NX)+20.0,AMAX1(TKA(NY,NX)-20.0,TKCY))
C
C     RESET CANOPY TEMPERATURE FOR NEXT ITERATION
C
      IF((IC.EQ.0.AND.TKCY.GT.TKC1).OR.(IC.EQ.1.AND.TKCY.LT.TKC1))THEN
      XC=0.5*XC
      ENDIF
      TKCZ(NZ,NY,NX)=TKC1+0.1*(TKCY-TKC1)
      IF(TKCY.GT.TKC1)THEN
      IC=1
      ELSE
      IC=0
      ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,4444)'TKZ',I,J,NX,NY,NZ,NN,XC,TKC1,TKCY,TKCZ(NZ,NY,NX)
C    2,TKA(NY,NX),TKCX,VHCPX,PARHC,HFLXS,VHCPC(NZ,NY,NX),WVPLT,EX
C    2,FLWC(NZ,NY,NX),VOLWC(NZ,NY,NX),VOLWP(NZ,NY,NX),EVAPC(NZ,NY,NX)
C    2,RAD1(NZ,NY,NX),EFLXC(NZ,NY,NX),RA(NZ,NY,NX),RC(NZ,NY,NX)
C    3,RADC(NZ,NY,NX),FDTHS,THRM1(NZ,NY,NX),VPC,VPA(NY,NX),PAREC
C    2,EP(NZ,NY,NX),HFLXS,VFLXC,HFLWC1,RADC(NZ,NY,NX),FRADP(NZ,NY,NX)
C    3,THS(NY,NX),THRMGX(NY,NX) 
C    2,CH2O,RSX,RSMN(NZ,NY,NX),CCPOLT,OSWT,CCPOLP(NZ,NY,NX)
C    4,DCO2(NZ,NY,NX),AREA(3,NU(NY,NX),NY,NX),WTLS(NZ,NY,NX)
C    2,PSILT(NZ,NY,NX),PSILG(NZ,NY,NX),RACZ(NZ,NY,NX),RAZ(NZ,NY,NX),RI 
C    3,RIB(NY,NX),RA1,ARLFV(1,NZ,NY,NX),ARSTV(1,NZ,NY,NX)
C    4,WVPLT,VSTK
4444  FORMAT(A8,6I4,60E16.8)
C     ENDIF
C
C     IF CONVERGENCE CRITERION IS MET OR ON EVERY TENTH ITERATION,
C     PROCEED TO WATER BALANCE
C
      IF(ABS(TKCY-TKC1).LT.0.05.OR.(NN/10)*10.EQ.NN)THEN
      UPRT=0.0
      PSILC=PSILT(NZ,NY,NX)-PSILH
C
C     ROOT WATER UPTAKE FROM SOIL-CANOPY WATER POTENTIALS,
C     SOIL + ROOT HYDRAULIC RESISTANCES
C
      DO 4200 N=1,MY(NZ,NY,NX)
      DO 4200 L=NU(NY,NX),NI(NZ,NY,NX)
      IF(ILYR(N,L).EQ.1)THEN
      UPWTR(N,L,NZ,NY,NX)=AMAX1(AMIN1(0.0,-VOLWM(NPH,L,NY,NX)*FPQ(L,NZ))
     2,AMIN1((PSILC-PSIST1(L))/RSRS(N,L),VOLP(L,NY,NX)*FPQ(L,NZ)))
      IF(UPWTR(N,L,NZ,NY,NX).GT.0.0)THEN
      UPWTR(N,L,NZ,NY,NX)=0.50*UPWTR(N,L,NZ,NY,NX)
      ENDIF
      UPRT=UPRT+UPWTR(N,L,NZ,NY,NX)
      ELSE
      UPWTR(N,L,NZ,NY,NX)=0.0
      ENDIF
C     IF(NZ.EQ.3.AND.J.EQ.13)THEN
C     WRITE(*,6565)'UPRT',I,J,NX,NY,NZ,L,N,NN,UPRT,UPWTR(N,L,NZ,NY,NX)
C    2,VOLWM(NPH,L,NY,NX),PSILC,PSIST1(L),RSRS(N,L),RSSX(N,L)
C    2,RSRT(N,L),RSRG(N,L),RSR1(N,L),RSR2(N,L),PSILH,RTAR2 
C    3,RSRR(N,NZ,NY,NX),VOLA(L,NY,NX),VOLWM(NPH,L,NY,NX)
6565  FORMAT(A8,8I4,30E14.6)
C     ENDIF
4200  CONTINUE
C
C     TEST TRANSPIRATION - ROOT WATER UPTAKE VS. CHANGE IN CANOPY
C     WATER STORAGE
C
      VOLWPZ=1.0E-06*WVPLT/FDMP
      DIFFZ=VOLWPZ-VOLWP(NZ,NY,NX)
      DIFFW=EP(NZ,NY,NX)-UPRT
      IF(UPRT.NE.0.0)THEN
      DIFF=ABS((DIFFW-DIFFZ)/UPRT)
      ELSE
      DIFF=ABS((DIFFW-DIFFZ)/VOLWPZ)
      ENDIF
      IF(DIFF.LT.5.0E-03)GO TO 4250
      IF(ABS(VOLWPZ-VOLWPX).GT.ZEROP(NZ,NY,NX))THEN
      RSSZ=ABS((PSILT(NZ,NY,NX)-PSIL2)/(VOLWPZ-VOLWPX))
      ELSEIF(CNDT.GT.ZEROP(NZ,NY,NX))THEN
      RSSZ=1.0/CNDT
      ELSE
      RSSZ=1.0E-06/PP(NZ,NY,NX)
      ENDIF
      IF(ABS(EP(NZ,NY,NX)-EPX).GT.ZEROP(NZ,NY,NX))THEN
      RSSU=ABS((PSILT(NZ,NY,NX)-PSIL2)/(EP(NZ,NY,NX)-EPX))
      IF(CNDT.GT.ZEROP(NZ,NY,NX))THEN
      RSSU=AMIN1(1.0/CNDT,RSSU)
      ENDIF
      ELSEIF(CNDT.GT.ZEROP(NZ,NY,NX))THEN
      RSSU=1.0/CNDT
      ELSE
      RSSU=ZEROL(NZ,NY,NX)
      ENDIF
C
C     CHANGE IN CANOPY WATER POTENTIAL REQUIRED TO BRING AGREEMENT
C     BETWEEN TRANSPIRATION - ROOT WATER UPTAKE AND CHANGE IN CANOPY
C     WATER STORAGE
C
      DPSI=AMIN1(AMIN1(RSSZ,RSSU)*(DIFFW-DIFFZ),ABS(PSILT(NZ,NY,NX)))
C     IF(NZ.EQ.3.AND.J.EQ.13)THEN
C     WRITE(*,2222)'PSI',I,J,NX,NY,NZ,NN,PSILT(NZ,NY,NX),PSIL2,DPSI
C    2,RSSU,RSSZ,CNDT,UPRT,EP(NZ,NY,NX),EX,EVAPC(NZ,NY,NX)
C    3,RC(NZ,NY,NX),RA(NZ,NY,NX),FRADP(NZ,NY,NX)
C    3,PAREC,VPA(NY,NX),VPC,TKA(NY,NX),TKC1,VOLWP(NZ,NY,NX) 
C    4,VOLWPZ,VOLWPX,WVPLT,DIFF,WFNC,PSILG(NZ,NY,NX)
C    5,FDMP,CCPOLT,OSWT,RAZ(NZ,NY,NX),RI,RIB(NY,NX)
C    4,DIFFZ,DIFFW,((UPWTR(N,L,NZ,NY,NX),L=1,8),N=1,1)
C    6,((RSRS(N,L),L=1,8),N=1,1),(PSIST1(L),L=1,8)
2222  FORMAT(A8,6I4,60E16.8)
C     ENDIF
C
C     IF CONVERGENCE CRITERION IS MET THEN FINISH,
C     OTHERWISE START NEXT ITERATION
C
      IF((NN.GE.30.AND.ABS(DPSI).LT.1.0E-03).OR.NN.GE.MXN)GO TO 4250
      PSIL2=PSILT(NZ,NY,NX)
      EPX=EP(NZ,NY,NX)
      VOLWPX=VOLWPZ
      PSILT(NZ,NY,NX)=AMIN1(0.0,PSILT(NZ,NY,NX)+0.50*DPSI)
      XC=0.50
      GO TO 4000
C
C     RESET MINIMUM STOMATAL RESISTANCE BEFORE FINAL ITERATION
C
4250  IF(ICHK.EQ.1)THEN
      GO TO 4500
      ELSE
      ICHK=1
      CALL STOMATE(I,J,NZ,NY,NX)
      ENDIF
      ENDIF
4000  CONTINUE
4500  CONTINUE
C
C     FINAL CANOPY TEMPERATURE
C
      TKC(NZ,NY,NX)=TKCZ(NZ,NY,NX)
      TCC(NZ,NY,NX)=TKC(NZ,NY,NX)-273.15
      DTKC(NZ,NY,NX)=TKC(NZ,NY,NX)-TKA(NY,NX)
C
C     IF CONVERGENCE NOT ACHIEVED (EXTREMELY RARE), RESET TEMPERATURES,
C     ENERGY FLUXES, WATER POTENTIALS
C
      IF(NN.GE.MXN)THEN
      WRITE(*,9999)IYRC,I,J,NX,NY,NZ
9999  FORMAT('CONVERGENCE FOR WATER UPTAKE NOT ACHIEVED ON   ',6I4)
      IF(DIFF.GT.0.5)THEN
      RAD1(NZ,NY,NX)=0.0
      EFLXC(NZ,NY,NX)=0.0
      SFLXC(NZ,NY,NX)=0.0
      HFLXC(NZ,NY,NX)=0.0
      EVAPC(NZ,NY,NX)=0.0
      EP(NZ,NY,NX)=0.0
      TKC(NZ,NY,NX)=TKA(NY,NX)+DTKC(NZ,NY,NX)
      TCC(NZ,NY,NX)=TKC(NZ,NY,NX)-273.15
      FTHRM=EMMC*2.04E-10*FRADP(NZ,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
      THRM1(NZ,NY,NX)=FTHRM*TKC(NZ,NY,NX)**4
      PSILT(NZ,NY,NX)=PSIST1(NG(NZ,NY,NX))
      APSILT=ABS(PSILT(NZ,NY,NX))
      FDMP=0.16+0.10*APSILT/(0.05*APSILT+2.0)
      CCPOLT=CCPOLP(NZ,NY,NX)+CZPOLP(NZ,NY,NX)+CPPOLP(NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSILO(NZ,NY,NX)=FDMP/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKC(NZ,NY,NX)*FDMP*CCPOLT/OSWT
      PSILG(NZ,NY,NX)=AMAX1(0.0,PSILT(NZ,NY,NX)-PSILO(NZ,NY,NX))
      WFNC=EXP(RCS(NZ,NY,NX)*PSILG(NZ,NY,NX))
      RC(NZ,NY,NX)=RSMN(NZ,NY,NX)+(RSMH(NZ,NY,NX)
     2-RSMN(NZ,NY,NX))*WFNC
      RA(NZ,NY,NX)=RAZ(NZ,NY,NX)
      VHCPC(NZ,NY,NX)=4.19*(WTSHT(NZ,NY,NX)*10.0E-06)
      DTKC(NZ,NY,NX)=0.0
      DO 4290 N=1,MY(NZ,NY,NX)
      DO 4290 L=NU(NY,NX),NI(NZ,NY,NX)
      PSIRT(N,L,NZ,NY,NX)=PSIST1(L)
      APSIRT=ABS(PSIRT(N,L,NZ,NY,NX))
      FDMR=0.16+0.10*APSIRT/(0.05*APSIRT+2.0)
      CCPOLT=CCPOLR(N,L,NZ,NY,NX)+CZPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSIRO(N,L,NZ,NY,NX)=FDMR/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKS(L,NY,NX)*FDMR*CCPOLT/OSWT
      PSIRG(N,L,NZ,NY,NX)=AMAX1(0.0,PSIRT(N,L,NZ,NY,NX)
     2-PSIRO(N,L,NZ,NY,NX))
      UPWTR(N,L,NZ,NY,NX)=0.0
4290  CONTINUE
      ENDIF
      ENDIF
C
C     CANOPY SURFACE WATER STORAGE, SENSIBLE AND STORAGE HEAT FLUXES
C     (NOT EXPLICITLY CALCULATED IN CONVERGENCE SOLUTION)
C
      VOLWP(NZ,NY,NX)=VOLWP(NZ,NY,NX)+EP(NZ,NY,NX)-UPRT
      VOLWC(NZ,NY,NX)=VOLWC(NZ,NY,NX)+FLWC(NZ,NY,NX)+EVAPC(NZ,NY,NX)
      SFLXC(NZ,NY,NX)=PARHC*(TKA(NY,NX)-TKCZ(NZ,NY,NX))
      HFLXC(NZ,NY,NX)=TKCX*VHCPX-TKCZ(NZ,NY,NX)*VHCPC(NZ,NY,NX)
     2+VFLXC+HFLWC1
C
C     ROOT TOTAL, OSMOTIC AND TURGOR WATER POTENTIALS
C
      DO 4505 N=1,MY(NZ,NY,NX)
      DO 4510 L=NU(NY,NX),NI(NZ,NY,NX)
      IF(ILYR(N,L).EQ.1)THEN
      PSIRT(N,L,NZ,NY,NX)=AMIN1(0.0,(PSIST1(L)*RSRT(N,L)
     2+PSILT(NZ,NY,NX)*RSSX(N,L))/RSRS(N,L))
      APSIRT=ABS(PSIRT(N,L,NZ,NY,NX))
      FDMR=0.16+0.10*APSIRT/(0.05*APSIRT+2.0)
      CCPOLT=CCPOLR(N,L,NZ,NY,NX)+CZPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSIRO(N,L,NZ,NY,NX)=FDMR/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKS(L,NY,NX)*FDMR*CCPOLT/OSWT
      PSIRG(N,L,NZ,NY,NX)=AMAX1(0.0,PSIRT(N,L,NZ,NY,NX)
     2-PSIRO(N,L,NZ,NY,NX))
      ELSE
      PSIRT(N,L,NZ,NY,NX)=PSIST1(L)
      APSIRT=ABS(PSIRT(N,L,NZ,NY,NX))
      FDMR=0.16+0.10*APSIRT/(0.05*APSIRT+2.0)
      CCPOLT=CCPOLR(N,L,NZ,NY,NX)+CZPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSIRO(N,L,NZ,NY,NX)=FDMR/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKS(L,NY,NX)*FDMR*CCPOLT/OSWT
      PSIRG(N,L,NZ,NY,NX)=AMAX1(0.0,PSIRT(N,L,NZ,NY,NX)
     2-PSIRO(N,L,NZ,NY,NX))
      ENDIF
C     IF(I.EQ.284)THEN
C     WRITE(*,1256)'PSIRT',I,J,NX,NY,NZ,NN,PSIRT(N,L,NZ,NY,NX)
C    2,PSIST1(L),RSRT(N,L),PSILT(NZ,NY,NX),RSSX(N,L),RSRS(N,L)
1256  FORMAT(A8,6I4,20E12.4)
C     ENDIF
4510  CONTINUE
4505  CONTINUE
C
C     IF PLANT SPECIES DOES NOT EXIST
C
      ELSE
      RAD1(NZ,NY,NX)=0.0
      EFLXC(NZ,NY,NX)=0.0
      SFLXC(NZ,NY,NX)=0.0
      HFLXC(NZ,NY,NX)=0.0
      EVAPC(NZ,NY,NX)=0.0
      EP(NZ,NY,NX)=0.0
      IF(ZC(NZ,NY,NX).GT.DPTHS(NY,NX))THEN
      TKC(NZ,NY,NX)=TKA(NY,NX)
      ELSE
      TKC(NZ,NY,NX)=TKW(NY,NX)
      ENDIF
      TCC(NZ,NY,NX)=TKC(NZ,NY,NX)-273.15
      FTHRM=EMMC*2.04E-10*FRADP(NZ,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
      THRM1(NZ,NY,NX)=FTHRM*TKC(NZ,NY,NX)**4
      PSILT(NZ,NY,NX)=PSIST1(NG(NZ,NY,NX))
      APSILT=ABS(PSILT(NZ,NY,NX))
      FDMP=0.16+0.10*APSILT/(0.05*APSILT+2.0)
      CCPOLT=CCPOLP(NZ,NY,NX)+CZPOLP(NZ,NY,NX)+CPPOLP(NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSILO(NZ,NY,NX)=FDMP/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKC(NZ,NY,NX)*FDMP*CCPOLT/OSWT
      PSILG(NZ,NY,NX)=AMAX1(0.0,PSILT(NZ,NY,NX)-PSILO(NZ,NY,NX))
      WFNC=EXP(RCS(NZ,NY,NX)*PSILG(NZ,NY,NX))
      RC(NZ,NY,NX)=RSMN(NZ,NY,NX)+(RSMH(NZ,NY,NX)
     2-RSMN(NZ,NY,NX))*WFNC
      RA(NZ,NY,NX)=RAZ(NZ,NY,NX)
      VHCPC(NZ,NY,NX)=4.19*(WTSHT(NZ,NY,NX)*10.0E-06)
      DTKC(NZ,NY,NX)=0.0
      DO 4300 N=1,MY(NZ,NY,NX)
      DO 4300 L=NU(NY,NX),NI(NZ,NY,NX)
      PSIRT(N,L,NZ,NY,NX)=PSIST1(L)
      APSIRT=ABS(PSIRT(N,L,NZ,NY,NX))
      FDMR=0.16+0.10*APSIRT/(0.05*APSIRT+2.0)
      CCPOLT=CCPOLR(N,L,NZ,NY,NX)+CZPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)
      OSWT=36.0+840.0*AMAX1(0.0,CCPOLT)
      PSIRO(N,L,NZ,NY,NX)=FDMR/0.16*OSMO(NZ,NY,NX)
     2-8.3143*TKS(L,NY,NX)*FDMR*CCPOLT/OSWT
      PSIRG(N,L,NZ,NY,NX)=AMAX1(0.0,PSIRT(N,L,NZ,NY,NX)
     2-PSIRO(N,L,NZ,NY,NX))
      UPWTR(N,L,NZ,NY,NX)=0.0
4300  CONTINUE
      ENDIF
C
C     SET CANOPY GROWTH TEMPERATURE FROM SOIL SURFACE
C     OR CANOPY TEMPERATURE
C
      IF(IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).EQ.0)THEN
      TKG(NZ,NY,NX)=TKS(NU(NY,NX),NY,NX)
C     ELSEIF((IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)
C    2.AND.IDAY(2,NB1(NZ,NY,NX),NZ,NY,NX).EQ.0)THEN
C     TKG(NZ,NY,NX)=TKS(NU(NY,NX),NY,NX)
      ELSE
      TKG(NZ,NY,NX)=TKC(NZ,NY,NX)
      ENDIF
      TCG(NZ,NY,NX)=TKG(NZ,NY,NX)-273.15
C
C     ARRHENIUS FUNCTION FOR CANOPY AND ROOT GROWTH WITH OFFSET
C     FOR ZONE OF THERMAL ADAPTATION ENTERED IN 'READQ'
C
      TKGO=TKG(NZ,NY,NX)+OFFST(NZ,NY,NX)
      RTK=8.3143*TKGO
      STK=710.0*TKGO
      ACTV=1+EXP((195000-STK)/RTK)+EXP((STK-222500)/RTK)
      TFN3(NZ,NY,NX)=EXP(25.227-62500/RTK)/ACTV
      DO 100 L=NU(NY,NX),NI(NZ,NY,NX)
      TKSO=TKS(L,NY,NX)+OFFST(NZ,NY,NX)
      RTK=8.3143*TKSO
      STK=710.0*TKSO
      ACTV=1+EXP((195000-STK)/RTK)+EXP((STK-222500)/RTK)
      TFN4(L,NZ,NY,NX)=EXP(25.227-62500/RTK)/ACTV
100   CONTINUE
      PSILZ(NZ,NY,NX)=AMIN1(PSILZ(NZ,NY,NX),PSILT(NZ,NY,NX))
C
C     DIURNAL CHILLING
C
      IF(TCC(NZ,NY,NX).LT.CTC(NZ,NY,NX))THEN
      CHILL(NZ,NY,NX)=AMIN1(24.0,CHILL(NZ,NY,NX)+1.0)
      ELSE
      CHILL(NZ,NY,NX)=AMAX1(0.0,CHILL(NZ,NY,NX)-1.0)
      ENDIF
C
C     NH3 EXCHANGE BETWEEN CANOPY AND ATMOSPHERE FROM NH3
C     CONCENTRATION DIFFERENCES 'CNH3E' (ATMOSPHERE FROM 'READS') AND
C     'CNH3P' (CANOPY), AND FROM STOMATAL + BOUNDARY LAYER RESISTANCE
C
      SNH3P=SNH3X*EXP(0.513-0.0171*TCC(NZ,NY,NX))
      FNH3P=1.0E-04*FDMP
      DO 105 NB=1,NBR(NZ,NY,NX)
      IF(WTLSB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.ARLFB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     3.AND.ARLFP(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CNH3P=AMAX1(0.0,FNH3P*CZPOLB(NB,NZ,NY,NX)/SNH3P)
      ZPOOLB=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX))
      RNH3B(NB,NZ,NY,NX)=AMIN1(0.1*ZPOOLB
     2,AMAX1((CNH3E(NY,NX)-CNH3P)/(RA(NZ,NY,NX)+RC(NZ,NY,NX))
     3*FRADP(NZ,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     3*ARLFB(NB,NZ,NY,NX)/ARLFP(NZ,NY,NX),-0.1*ZPOOLB))
      ELSE
      RNH3B(NB,NZ,NY,NX)=0.0
      ENDIF
C     WRITE(*,7777)'RNH3',I,J,NZ,NB,RNH3B(NB,NZ,NY,NX)
C    2,RNH3C(NZ,NY,NX),CNH3E(NY,NX),CNH3P,RA(NZ,NY,NX),RC(NZ,NY,NX)
C    2,ARLFB(NB,NZ,NY,NX),ARLFP(NZ,NY,NX),SNH3P
C    4,ZPOOL(NB,NZ,NY,NX),WTLSB(NB,NZ,NY,NX),FRADP(NZ,NY,NX)
7777  FORMAT(A8,4I4,40E24.16)
105   CONTINUE
C
C     ROOT O2 AND NUTRIENT UPTAKE
C
      DO 955 N=1,MY(NZ,NY,NX)
      DO 950 L=NU(NY,NX),NI(NZ,NY,NX)
      TFOXYX=0.0
      TFNH4X=0.0
      TFNHBX=0.0
      TFNO3X=0.0
      TFNOBX=0.0
      TFPO4X=0.0
      TFPOBX=0.0
C
C     ROOT UPTAKE CAPACITY 'FWSRT' DEPENDS ON ROOT PROTEIN CONTENT
C     RELATIVE TO 5% FOR WHICH ACTIVE UPTAKE PARAMETERS ARE DEFINED
C
      IF(WTRTL(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CWSRTL(N,L,NZ,NY,NX)=AMIN1(CWSRT(NZ,NY,NX)
     2,WSRTL(N,L,NZ,NY,NX)/WTRTL(N,L,NZ,NY,NX))
      FWSRT=CWSRTL(N,L,NZ,NY,NX)/0.05
      ELSE
      CWSRTL(N,L,NZ,NY,NX)=CWSRT(NZ,NY,NX)
      FWSRT=1.0
      ENDIF
C
C     RESPIRATION CONSTRAINT ON UPTAKE FROM NON-STRUCTURAL C
C
      IF(RCO2N(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FCUP=AMAX1(0.0,AMIN1(1.0,0.25*CPOOLR(N,L,NZ,NY,NX)
     2/RCO2N(N,L,NZ,NY,NX)))
      ELSE
      FCUP=0.0
      ENDIF
C
C     FEEDBACK CONSTRAINT ON N UPTAKE FROM NON-STRUCTURAL N AND P
C
      IF(CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
      FZUP=AMIN1(CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CZPOLR(N,L,NZ,NY,NX)/ZCKI)
     3,CPPOLR(N,L,NZ,NY,NX)/(CPPOLR(N,L,NZ,NY,NX)
     4+CZPOLR(N,L,NZ,NY,NX)/ZPKI))
      FPUP=AMIN1(CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)/PCKI)
     3,CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     4+CPPOLR(N,L,NZ,NY,NX)/PZKI))
      ELSE
      FZUP=0.0
      FPUP=0.0
      ENDIF
      IF(RTDNP(N,L,NZ,NY,NX).GT.ZERO
     2.AND.RTVLW(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     3.AND.THETW(L,NY,NX).GT.ZERO)THEN
C     NN=0
      UPWTRP=AMAX1(0.0,-UPWTR(N,L,NZ,NY,NX)/PP(NZ,NY,NX))
      UPWTRH=UPWTRP*XNPG
C
C     FACTORS CONSTRAINING O2 AND NUTRIENT UPTAKE AMONG
C     COMPETING ROOT AND MICROBIAL POPULATIONS IN BAND AND

C     NON-BAND SOIL ZONES
C
      IF(ROXYY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOXYX=AMAX1(FPP(L,NZ),ROXYP(N,L,NZ,NY,NX)/ROXYY(L,NY,NX))
      ELSE
      FOXYX=FPQ(L,NZ)
      ENDIF
      IF(RNH4Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNH4X=AMAX1(FPP(L,NZ),RUNNHP(N,L,NZ,NY,NX)/RNH4Y(L,NY,NX))
      ELSE
      FNH4X=FPQ(L,NZ)
      ENDIF
      IF(RNHBY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNHBX=AMAX1(FPP(L,NZ),RUNNBP(N,L,NZ,NY,NX)/RNHBY(L,NY,NX))
      ELSE
      FNHBX=FPQ(L,NZ)
      ENDIF
      IF(RNO3Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO3X=AMAX1(FPP(L,NZ),RUNNOP(N,L,NZ,NY,NX)/RNO3Y(L,NY,NX))
      ELSE
      FNO3X=FPQ(L,NZ)
      ENDIF
      IF(RN3BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNOBX=AMAX1(FPP(L,NZ),RUNNXP(N,L,NZ,NY,NX)/RN3BY(L,NY,NX))
      ELSE
      FNOBX=FPQ(L,NZ)
      ENDIF
      IF(RPO4Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FPO4X=AMAX1(FPP(L,NZ),RUPPOP(N,L,NZ,NY,NX)/RPO4Y(L,NY,NX))
      ELSE
      FPO4X=FPQ(L,NZ)
      ENDIF
      IF(RPOBY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FPOBX=AMAX1(FPP(L,NZ),RUPPBP(N,L,NZ,NY,NX)/RPOBY(L,NY,NX))
      ELSE
      FPOBX=FPQ(L,NZ)
      ENDIF
      TFOXYX=TFOXYX+FOXYX
      TFNH4X=TFNH4X+FNH4X
      TFNO3X=TFNO3X+FNO3X
      TFPO4X=TFPO4X+FPO4X
      TFNHBX=TFNHBX+FNHBX
      TFNOBX=TFNOBX+FNOBX
      TFPOBX=TFPOBX+FPOBX
C
C     ROOT O2 DEMAND CALCULATED FROM O2 NON-LIMITED RESPIRATION RATE
C
      ROXYP(N,L,NZ,NY,NX)=2.667*RCO2M(N,L,NZ,NY,NX)
      IF(RCO2M(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.RTVLW(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.FOXYX.GT.ZEROQ(NZ,NY,NX))THEN
C
C     INITIALIZE VARIABLES USED IN ROOT GAS EXCHANGE
C     (CO2, O2, CH4, N2, N2O, NH3, H2)
C
      CO2A1=AMAX1(ZEROP(NZ,NY,NX),CO2A(N,L,NZ,NY,NX))
      CO2P1=AMAX1(ZEROP(NZ,NY,NX),CO2P(N,L,NZ,NY,NX))
      CO2G1=AMAX1(ZEROP(NZ,NY,NX),CO2G(L,NY,NX)*FPQ(L,NZ))
      CO2S1=AMAX1(ZEROP(NZ,NY,NX),CO2S(L,NY,NX)*FPQ(L,NZ))
      OXYA1=AMAX1(ZEROP(NZ,NY,NX),OXYA(N,L,NZ,NY,NX))
      OXYP1=AMAX1(ZEROP(NZ,NY,NX),OXYP(N,L,NZ,NY,NX))
      OXYG1=AMAX1(ZEROP(NZ,NY,NX),OXYG(L,NY,NX)*FOXYX)
      OXYS1=OXYS(L,NY,NX)*FOXYX
      CH4A1=CH4A(N,L,NZ,NY,NX)
      CH4P1=CH4P(N,L,NZ,NY,NX)
      CH4S1=CH4S(L,NY,NX)*FPQ(L,NZ)
      CCH4S1=CCH4S(L,NY,NX)
      CCH4P1=AMAX1(0.0,CH4P1/RTVLW(N,L,NZ,NY,NX))
      Z2OA1=Z2OA(N,L,NZ,NY,NX)
      Z2OP1=Z2OP(N,L,NZ,NY,NX)
      Z2OS1=Z2OS(L,NY,NX)*FPQ(L,NZ)
      CN2OS1=CZ2OS(L,NY,NX)
      CN2OP1=AMAX1(0.0,Z2OP1/RTVLW(N,L,NZ,NY,NX))
      ZH3A1=ZH3A(N,L,NZ,NY,NX)
      ZH3P1=ZH3P(N,L,NZ,NY,NX)
      ZH3S1=ZNH3S(L,NY,NX)*FPQ(L,NZ)
      ZH3B1=ZNH3B(L,NY,NX)*FPQ(L,NZ)
      CNH3S1=CNH3S(L,NY,NX)
      CNH3B1=CNH3B(L,NY,NX)
      CNH3P1=AMAX1(0.0,ZH3P1/RTVLW(N,L,NZ,NY,NX))
      H2GA1=H2GA(N,L,NZ,NY,NX)
      H2GP1=H2GP(N,L,NZ,NY,NX)
      H2GS1=H2GS(L,NY,NX)*FPQ(L,NZ)
      CH2GS1=CH2GS(L,NY,NX)
      CH2GP1=AMAX1(0.0,H2GP1/RTVLW(N,L,NZ,NY,NX))
      RTVLWA=RTVLW(N,L,NZ,NY,NX)*VLNH4(L,NY,NX)
      RTVLWB=RTVLW(N,L,NZ,NY,NX)*VLNHB(L,NY,NX)
      UPMXP=ROXYP(N,L,NZ,NY,NX)*XNPG/PP(NZ,NY,NX)
      ROXYFX=ROXYF(L,NY,NX)*FOXYX*XNPG
      RCO2FX=RCO2F(L,NY,NX)*FOXYX*XNPG
      ROXYLX=ROXYL(L,NY,NX)*FOXYX*XNPG
C
C     GASEOUS AND AQUEOUS DIFFUSIVITIES IN ROOT AND SOIL
C
      CGSGL1=CGSGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      OGSGL1=OGSGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      CHSGL1=CHSGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      Z2SGL1=Z2SGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      ZHSGL1=ZHSGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      HGSGL1=HGSGL(L,NY,NX)*XNPG*PORTX(N,NZ,NY,NX)
      CLSGL1=CLSGL(L,NY,NX)*XNPG*FOXYX
      OLSGL1=OLSGL(L,NY,NX)*XNPG*FOXYX
      CQSGL1=CQSGL(L,NY,NX)*XNPG*FOXYX
      ZVSGL1=ZVSGL(L,NY,NX)*XNPG*FOXYX
      ZNSGL1=ZNSGL(L,NY,NX)*XNPG*FOXYX
      HLSGL1=HLSGL(L,NY,NX)*XNPG*FOXYX
      OLSGLP=OLSGL(L,NY,NX)*XNPG
      ROXDFQ=0.0
      RCHDFQ=0.0
      RN2DFQ=0.0
      RNHDFQ=0.0
      RHGDFQ=0.0
      ROXDF1=0.0
      RCHDF1=0.0
      RN2DF1=0.0
      RNHDF1=0.0
      RHGDF1=0.0
C
C     ROOT CONDUCTANCE TO GAS TRANSFER
C
      IF(WTRTS(NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.FRTDPX(L,NZ).GT.ZERO)THEN
      RTCR1=AMAX1(PP(NZ,NY,NX),RTN1(N,L,NZ,NY,NX))
     2*3.1416*RRAD1(N,L,NZ,NY,NX)**2
     2/DPTHZ(L,NY,NX)
      RTCR2=(RTNL(N,L,NZ,NY,NX)*3.1416*RRAD2(N,L,NZ,NY,NX)**2
     2/RTLGA(N,L,NZ,NY,NX))/FRTDPX(L,NZ)
      IF(RTCR2.GT.RTCR1)THEN
      RTCRA=RTCR1*RTCR2/(RTCR1+RTCR2)
      ELSE
      RTCRA=RTCR1
      ENDIF
      ELSE
      RTCRA=0.0
      ENDIF
C
C     VARIABLES USED TO CALCULATE ROOT GAS TRANSFER
C     BETWEEN AQUEOUS AND GASEOUS PHASES
C
      IF(N.EQ.1.AND.IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).GT.0
     2.AND.RTLGP(N,L,NZ,NY,NX).GT.RTLGPX)THEN
      RTARRX=RTARR(N,L)/RRADP(N,NZ,NY,NX) 
      DIFOP=OLSGLP*(1.0-PORT(N,NZ,NY,NX))*RTARRX
      VOLWCA=RTVLW(N,L,NZ,NY,NX)*SCO2L(L,NY,NX)
      VOLWOA=RTVLW(N,L,NZ,NY,NX)*SOXYL(L,NY,NX)
      VOLWC4=RTVLW(N,L,NZ,NY,NX)*SCH4L(L,NY,NX)
      VOLWZA=RTVLW(N,L,NZ,NY,NX)*SN2OL(L,NY,NX)
      VOLWNA=RTVLW(N,L,NZ,NY,NX)*SNH3L(L,NY,NX)
      VOLWH2=RTVLW(N,L,NZ,NY,NX)*SH2GL(L,NY,NX)
      DFCOA=CGSGL1*RTCRA
      DFOXA=OGSGL1*RTCRA
      DFCHA=CHSGL1*RTCRA
      DFN2A=Z2SGL1*RTCRA
      DFNHA=ZHSGL1*RTCRA
      DFHGA=HGSGL1*RTCRA
      ELSE
      RTARRX=0.0
      DIFOP=0.0
      VOLWCA=0.0
      VOLWOA=0.0
      VOLWC4=0.0
      VOLWZA=0.0
      VOLWNA=0.0
      VOLWH2=0.0
      DFCOA=0.0
      DFOXA=0.0
      DFCHA=0.0
      DFN2A=0.0
      DFNHA=0.0
      DFHGA=0.0
      ENDIF
      DFGP=AMIN1(1.0,XNPD*SQRT(PORT(N,NZ,NY,NX)))*TFND(L,NY,NX)
      RCO2PX=-RCO2A(N,L,NZ,NY,NX)*XNPG
C
C     SOLVE FOR GAS EXCHANGE IN SOIL AND ROOTS DURING ROOT UPTAKE
C     CONDUCTED AT SMALLER TIME STEP
C
      DO 99 M=1,NPH
C
C     AQUEOUS GAS DIFFUSIVITY THROUGH SOIL WATER TO ROOT
C
      VOLWMO=VOLWM(M,L,NY,NX)*FOXYX
      VOLWMM=VOLWM(M,L,NY,NX)*FPQ(L,NZ)
      VOLPMM=VOLPM(M,L,NY,NX)*FPQ(L,NZ)
      VOLWSP=RTVLW(N,L,NZ,NY,NX)+VOLWMM
      VOLWMA=VOLWMM*VLNH4(L,NY,NX)
      VOLWMB=VOLWMM*VLNHB(L,NY,NX)
      VOLWSA=RTVLWA+VOLWMA
      VOLWSB=RTVLWB+VOLWMB
      THETW1=AMAX1(0.0,VOLWM(M,L,NY,NX)/VOLX(L,NY,NX))
      IF(THETW1.GT.THETY(L,NY,NX)
     2.AND.FPQ(L,NZ).GT.ZEROQ(NZ,NY,NX))THEN
      THETM=TORT(L,NY,NX)*THETW1
      RRADS=LOG((FILM(M,L,NY,NX)+RRADL(N,L))/RRADL(N,L))
      RTARSX=RTARS(N,L)/RRADS 
      DIFOL=THETM*OLSGL1*RTARSX
      DIFCL=THETM*CQSGL1*RTARSX
      DIFZL=THETM*ZVSGL1*RTARSX
      DIFNL=THETM*ZNSGL1*RTARSX*VLNH4(L,NY,NX)
      DIFNB=THETM*ZNSGL1*RTARSX*VLNHB(L,NY,NX)
      DIFHL=THETM*HLSGL1*RTARSX
      CH4G1=CCH4G(L,NY,NX)*VOLPMM
      Z2OG1=CZ2OG(L,NY,NX)*VOLPMM
      ZH3G1=CNH3G(L,NY,NX)*VOLPMM
      H2GG1=CH2GG(L,NY,NX)*VOLPMM
      VOLWCO=VOLWMM*SCO2L(L,NY,NX)
      VOLWOX=VOLWMM*SOXYL(L,NY,NX)
      VOLWCH=VOLWMM*SCH4L(L,NY,NX)
      VOLWN2=VOLWMM*SN2OL(L,NY,NX)
      VOLWNH=VOLWMM*SNH3L(L,NY,NX)*VLNH4(L,NY,NX)
      VOLWNB=VOLWMM*SNH3L(L,NY,NX)*VLNHB(L,NY,NX)
      VOLWHG=VOLWMM*SH2GL(L,NY,NX)
      VOLPNH=VOLPMM*VLNH4(L,NY,NX)
      VOLPNB=VOLPMM*VLNHB(L,NY,NX)
C
C     MASS FLOW OF GAS THROUGH SOIL WATER TO ROOT
C
      DO 90 MX=1,NPT
      OXYS1=OXYS1+ROXYLX 
      CCO2S1=AMAX1(0.0,CO2S1/VOLWMM)
      COXYS1=AMIN1(COXYE(NY,NX)*SOXYL(L,NY,NX)
     2,AMAX1(0.0,OXYS1/VOLWMO))
      CCH4S1=AMAX1(0.0,CH4S1/VOLWMM)
      CN2OS1=AMAX1(0.0,Z2OS1/VOLWMM)
      CNH3S1=AMAX1(0.0,ZH3S1/VOLWMM)
      CNH3B1=AMAX1(0.0,ZH3B1/VOLWMM)
      CH2GS1=AMAX1(0.0,H2GS1/VOLWMM)
      IF(RTVLP(N,L,NZ,NY,NX).GT.ZERO)THEN
      CCO2A1=AMAX1(0.0,CO2A1/RTVLP(N,L,NZ,NY,NX))
      COXYA1=AMAX1(0.0,OXYA1/RTVLP(N,L,NZ,NY,NX))
      CCH4A1=AMAX1(0.0,CH4A1/RTVLP(N,L,NZ,NY,NX))
      CZ2OA1=AMAX1(0.0,Z2OA1/RTVLP(N,L,NZ,NY,NX))
      CNH3A1=AMAX1(0.0,ZH3A1/RTVLP(N,L,NZ,NY,NX))
      CH2GA1=AMAX1(0.0,H2GA1/RTVLP(N,L,NZ,NY,NX))
      ELSE
      CCO2A1=0.0
      COXYA1=0.0
      CCH4A1=0.0
      CZ2OA1=0.0
      CNH3A1=0.0
      CH2GA1=0.0
      ENDIF
      CCO2P1=AMAX1(0.0,CO2P1/RTVLW(N,L,NZ,NY,NX))
      COXYP1=AMIN1(COXYE(NY,NX)*SOXYL(L,NY,NX)
     2,AMAX1(0.0,OXYP1/RTVLW(N,L,NZ,NY,NX)))
      CCH4P1=AMAX1(0.0,CH4P1/RTVLW(N,L,NZ,NY,NX))
      CN2OP1=AMAX1(0.0,Z2OP1/RTVLW(N,L,NZ,NY,NX))
      CNH3P1=AMAX1(0.0,ZH3P1/RTVLW(N,L,NZ,NY,NX))
      CH2GP1=AMAX1(0.0,H2GP1/RTVLW(N,L,NZ,NY,NX))
      DIFOX=DIFOL+DIFOP
      RMFCOS=UPWTRH*CCO2S1
      RMFOXS=UPWTRH*COXYS1
      RMFCHS=UPWTRH*CCH4S1
      RMFN2S=UPWTRH*CN2OS1
      RMFNHS=UPWTRH*CNH3S1*VLNH4(L,NY,NX)
      RMFNHB=UPWTRH*CNH3B1*VLNHB(L,NY,NX)
      RMFHGS=UPWTRH*CH2GS1
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF O2 IN AQUEOUS PHASES OF
C     SOIL AND ROOT = ACTIVE UPTAKE OF O2 BY ROOT
C
      X=(DIFOL+UPWTRH)*COXYS1+DIFOP*COXYP1
      IF(X.GT.ZERO.AND.OXYS1.GT.ZEROP(NZ,NY,NX))THEN
      B=-UPMXP-DIFOX*OXKM-X
      C=X*UPMXP
      RUPOXR=(-B-SQRT(B*B-4.0*C))/2.0
      COXYR=(X-RUPOXR)/DIFOX
      RDFOXS=RMFOXS+DIFOL*(COXYS1-COXYR)
      RDFOXP=DIFOP*(COXYP1-COXYR)
      ELSE
      X=DIFOP*COXYP1
      IF(X.GT.ZERO.AND.OXYP1.GT.ZEROP(NZ,NY,NX))THEN
      B=-UPMXP-DIFOP*OXKM-X
      C=X*UPMXP
      RUPOXR=(-B-SQRT(B*B-4.0*C))/2.0
      COXYR=(X-RUPOXR)/DIFOP
      RDFOXS=0.0
      RDFOXP=DIFOP*(COXYP1-COXYR)
      ELSE
      RUPOXR=0.0
      COXYR=0.0
      RDFOXS=0.0
      RDFOXP=0.0
      ENDIF
      ENDIF
C
C     MASS FLOW + DIFFUSIVE EXCHANGE OF OTHER GASES
C     BETWEEN ROOT AND SOIL, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
C     IF(NX.EQ.3.AND.NY.EQ.3)THEN
C     WRITE(*,5555)'COXYR',I,J,NX,NY,NZ,L,N,M,MX,COXYR,RUPOXR
C    2,RMFOXS,RDFOXS,RDFOXP,COXYS1,COXYS1-COXYR,COXYP1,FOXYX
C    3,WTRTG(L),DIFOL,DIFOP,THETM,OLSGL1,UPWTRH,RTARR(N,L)
C    5,RTARSX,UPMXP,THETW(L,NY,NX),OXYS1,OXYS(L,NY,NX),OXYP1
C    3,OXYP(N,L,NZ,NY,NX),ROXYY(L,NY,NX),RTLGP(N,L,NZ,NY,NX)
C    2,UPMXP,DIFOX,THETW1,THETM,RRADS,RTARX,FPQ(L,NZ) 
C    4,RUPOXS(N,L,NZ,NY,NX),RUPOXP(N,L,NZ,NY,NX)
C    5,COXYE(NY,NX),SOXYL(L,NY,NX),FRTDPX(L,NZ)
5555  FORMAT(A8,9I4,40E12.4)
C     ENDIF
      RUPOSX=RDFOXS*PP(NZ,NY,NX)
      RUPOPX=RDFOXP*PP(NZ,NY,NX)
      RDFCOS=RMFCOS+DIFCL*(CCO2S1-CCO2P1)
      RDXCOS=(RTVLW(N,L,NZ,NY,NX)*AMAX1(ZEROP(NZ,NY,NX),CO2S1)
     2-VOLWMM*AMAX1(ZEROP(NZ,NY,NX),CO2P1))/VOLWSP
      IF(RDFCOS.GT.0.0)THEN
      RCO2SX=AMIN1(AMAX1(0.0,RDXCOS),RDFCOS*PP(NZ,NY,NX))
      ELSE
      RCO2SX=AMAX1(AMIN1(0.0,RDXCOS),RDFCOS*PP(NZ,NY,NX))
      ENDIF
      IF(N.EQ.1)THEN
      RDFCHS=RMFCHS+DIFCL*(CCH4S1-CCH4P1)
      RDXCHS=(RTVLW(N,L,NZ,NY,NX)*AMAX1(ZEROP(NZ,NY,NX),CH4S1)
     2-VOLWMM*AMAX1(ZEROP(NZ,NY,NX),CH4P1))/VOLWSP
      IF(RDFCHS.GT.0.0)THEN
      RUPCSX=AMIN1(AMAX1(0.0,RDXCHS),RDFCHS*PP(NZ,NY,NX))
      ELSE
      RUPCSX=AMAX1(AMIN1(0.0,RDXCHS),RDFCHS*PP(NZ,NY,NX))
      ENDIF
      RDFN2S=RMFN2S+DIFZL*(CN2OS1-CN2OP1)
      RDXN2S=(RTVLW(N,L,NZ,NY,NX)*AMAX1(ZEROP(NZ,NY,NX),Z2OS1)
     2-VOLWMM*AMAX1(ZEROP(NZ,NY,NX),Z2OP1))/VOLWSP
      IF(RDFN2S.GT.0.0)THEN
      RUPZSX=AMIN1(AMAX1(0.0,RDXN2S),RDFN2S*PP(NZ,NY,NX))
      ELSE
      RUPZSX=AMAX1(AMIN1(0.0,RDXN2S),RDFN2S*PP(NZ,NY,NX))
      ENDIF
      RDFNHS=RMFNHS+DIFNL*(CNH3S1-CNH3P1)
      IF(VOLWSA.GT.ZEROP(NZ,NY,NX))THEN
      ZH3PA=ZH3P1*VLNH4(L,NY,NX)
      RDXNHS=(RTVLWA*AMAX1(ZEROP(NZ,NY,NX),ZH3S1)
     2-VOLWMA*AMAX1(ZEROP(NZ,NY,NX),ZH3PA))/VOLWSA
      ELSE
      RDXNHS=0.0
      ENDIF
      IF(RDFNHS.GT.0.0)THEN
      RUPNSX=AMIN1(AMAX1(0.0,RDXNHS),RDFNHS*PP(NZ,NY,NX))
      ELSE
      RUPNSX=AMAX1(AMIN1(0.0,RDXNHS),RDFNHS*PP(NZ,NY,NX))
      ENDIF
      RDFNHB=RMFNHB+DIFNB*(CNH3B1-CNH3P1)
      IF(VOLWSB.GT.ZEROP(NZ,NY,NX))THEN
      ZH3PB=ZH3P1*VLNHB(L,NY,NX)
      RDXNHB=(RTVLWB*AMAX1(ZEROP(NZ,NY,NX),ZH3B1)
     2-VOLWMB*AMAX1(ZEROP(NZ,NY,NX),ZH3PB))/VOLWSB
      ELSE
      RDXNHB=0.0
      ENDIF
      IF(RDFNHB.GT.0.0)THEN
      RUPNBX=AMIN1(AMAX1(0.0,RDXNHB),RDFNHB*PP(NZ,NY,NX))
      ELSE
      RUPNBX=AMAX1(AMIN1(0.0,RDXNHB),RDFNHB*PP(NZ,NY,NX))
      ENDIF
      RDFHGS=RMFHGS+DIFHL*(CH2GS1-CH2GP1)
      RDXHGS=(RTVLW(N,L,NZ,NY,NX)*AMAX1(ZEROP(NZ,NY,NX),H2GS1)
     2-VOLWMM*AMAX1(ZEROP(NZ,NY,NX),H2GP1))/VOLWSP
      IF(RDFHGS.GT.0.0)THEN
      RUPHGX=AMIN1(AMAX1(0.0,RDXHGS),RDFHGS*PP(NZ,NY,NX))
      ELSE
      RUPHGX=AMAX1(AMIN1(0.0,RDXHGS),RDFHGS*PP(NZ,NY,NX))
      ENDIF
      ELSE
      RUPCSX=0.0
      RUPZSX=0.0
      RUPNSX=0.0
      RUPNBX=0.0
      RUPHGX=0.0
      ENDIF
C
C     GAS EXCHANGE BETWEEN GASEOUS AND AQUEOUS PHASES IN SOIL
C     DURING ROOT UPTAKE DEPENDING ON CONCENTRATION DIFFERENCES
C     CALCULATED FROM SOLUBILITIES, AND TRANSFER COEFFICIENTS
C     FROM 'WATSUB'
C
      IF(THETPM(M,L,NY,NX).GT.THETX)THEN
      RCODFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),CO2G1)*VOLWCO
     2-(AMAX1(ZEROS(NY,NX),CO2S1)-RCO2SX)*VOLPMM)/(VOLWCO+VOLPMM)
      RUPOST=RUPOSX-ROXYLX
      ROXDFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),OXYG1)*VOLWOX
     2-(AMAX1(ZEROS(NY,NX),OXYS1)-RUPOST)*VOLPMM)/(VOLWOX+VOLPMM)
      IF(N.EQ.1)THEN
      RCHDFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),CH4G1)*VOLWCH
     2-(AMAX1(ZEROS(NY,NX),CH4S1)-RUPCSX)*VOLPMM)/(VOLWCH+VOLPMM)
      RN2DFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),Z2OG1)*VOLWN2
     2-(AMAX1(ZEROS(NY,NX),Z2OS1)-RUPZSX)*VOLPMM)/(VOLWN2+VOLPMM)
      IF(VOLWNH+VOLPNH.GT.ZEROP(NZ,NY,NZ))THEN
      ZH3GA=ZH3G1*VLNH4(L,NY,NX)
      RNHDFQ=AMIN1(RUPNSX,AMAX1(-RUPNSX
     2,DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),ZH3GA)*VOLWNH
     3-(AMAX1(ZEROS(NY,NX),ZH3S1)-RUPNSX)*VOLPNH)/(VOLWNH+VOLPNH)))
      ELSE
      RNHDFQ=0.0
      ENDIF
      IF(VOLWNB+VOLPNB.GT.ZEROP(NZ,NY,NZ))THEN
      ZH3GB=ZH3G1*VLNHB(L,NY,NX)
      RNBDFQ=AMIN1(RUPNSX,AMAX1(-RUPNSX
     2,DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),ZH3GB)*VOLWNB
     3-(AMAX1(ZEROS(NY,NX),ZH3B1)-RUPNBX)*VOLPNB)/(VOLWNB+VOLPNB)))
      ELSE
      RNBDFQ=0.0
      ENDIF
      RHGDFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROP(NZ,NY,NX),H2GG1)*VOLWHG
     2-(AMAX1(ZEROS(NY,NX),H2GS1)-RUPHGX)*VOLPMM)/(VOLWHG+VOLPMM)
      ELSE
      RCHDFQ=0.0
      RN2DFQ=0.0
      RNHDFQ=0.0
      RNBDFQ=0.0
      RHGDFQ=0.0
      ENDIF
      ELSE
      RCODFQ=0.0
      ROXDFQ=0.0
      RCHDFQ=0.0
      RN2DFQ=0.0
      RNHDFQ=0.0
      RNBDFQ=0.0
      RHGDFQ=0.0
      ENDIF
C
C     UPDATE TRANSIENT STATE VARIABLES AND CONCENTRATIONS
C     FOR SOIL GAS TRANSFERS
C
      OXYG1=OXYG1-ROXDFQ+ROXYFX
      CO2G1=CO2G1-RCODFQ+RCO2FX
      CO2S1=CO2S1+RCODFQ-RCO2SX
      OXYS1=OXYS1+ROXDFQ-RUPOSX 
      CH4S1=CH4S1+RCHDFQ-RUPCSX
      Z2OS1=Z2OS1+RN2DFQ-RUPZSX
      ZH3S1=ZH3S1+RNHDFQ-RUPNSX
      ZH3B1=ZH3B1+RNBDFQ-RUPNBX
      H2GS1=H2GS1+RHGDFQ-RUPHGX
C     IF(L.EQ.1)THEN
C     WRITE(*,5547)'CO2S1',I,J,NX,NY,NZ,L,N,M,MX,CO2S1,RCODFQ,RCO2SX
C    2,RDXCOS,RDFCOS,PP(NZ,NY,NX),RTVLW(N,L,NZ,NY,NX),VOLWMM,CO2P1
C    3,CO2G1,RCO2FX,CCO2S1,CCO2P1,THETPM(M,L,NY,NX)
C    4,THETX,RCO2S(N,L,NZ,NY,NX)
C     ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,5547)'OXYG1',I,J,NX,NY,NZ,L,N,M,MX,OXYG1,OXYS1 
C    2,ROXDFQ,ROXYFX,ROXYLX,RUPOSX 
5547  FORMAT(A8,9I4,20E12.4)
C     ENDIF
C
C     GAS TRANSFER THROUGH ROOTS
C
      IF(N.EQ.1.AND.RTVLP(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RUPNTX=RUPNSX+RUPNBX
C
C     GAS EXCHANGE BETWEEN GASEOUS AND AQUEOUS PHASES IN ROOTS
C     DURING ROOT UPTAKE DEPENDING ON CONCENTRATION DIFFERENCES
C     CALCULATED FROM SOLUBILITIES, AND TRANSFER COEFFICIENT
C
      CO2PX=CO2P1+RCO2PX
      RCODF1=AMAX1(-CO2PX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),CO2A1)*VOLWCA 
     2-CO2PX*RTVLP(N,L,NZ,NY,NX))/(VOLWCA+RTVLP(N,L,NZ,NY,NX)))
      OXYPX=OXYP1-RUPOPX
      ROXDF1=AMAX1(-OXYPX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),OXYA1)*VOLWOA
     2-OXYPX*RTVLP(N,L,NZ,NY,NX))/(VOLWOA+RTVLP(N,L,NZ,NY,NX)))
      CH4PX=CH4P1+RUPCSX
      RCHDF1=AMAX1(-CH4PX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),CH4A1)*VOLWC4 
     2-CH4PX*RTVLP(N,L,NZ,NY,NX))/(VOLWC4+RTVLP(N,L,NZ,NY,NX)))
      Z2OPX=Z2OP1+RUPZSX
      RN2DF1=AMAX1(-Z2OPX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),Z2OA1)*VOLWZA 
     2-Z2OPX*RTVLP(N,L,NZ,NY,NX))/(VOLWZA+RTVLP(N,L,NZ,NY,NX)))
      ZH3PX=ZH3P1+RUPNTX
      RNHDF1=AMAX1(-ZH3PX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),ZH3A1)*VOLWNA 
     2-ZH3PX*RTVLP(N,L,NZ,NY,NX))/(VOLWNA+RTVLP(N,L,NZ,NY,NX)))
      H2GPX=H2GP1+RUPHGX 
      RHGDF1=AMAX1(-H2GPX,DFGP*(AMAX1(ZEROP(NZ,NY,NX),H2GA1)*VOLWH2 
     2-H2GPX*RTVLP(N,L,NZ,NY,NX))/(VOLWH2+RTVLP(N,L,NZ,NY,NX)))
      RCOFL1=AMIN1(DFCOA,RTVLP(N,L,NZ,NY,NX))*(CCO2E(NY,NX)-CCO2A1)
      ROXFL1=AMIN1(DFOXA,RTVLP(N,L,NZ,NY,NX))*(COXYE(NY,NX)-COXYA1)
      RCHFL1=AMIN1(DFCHA,RTVLP(N,L,NZ,NY,NX))*(CCH4E(NY,NX)-CCH4A1)
      RN2FL1=AMIN1(DFN2A,RTVLP(N,L,NZ,NY,NX))*(CZ2OE(NY,NX)-CZ2OA1)
      RNHFL1=AMIN1(DFNHA,RTVLP(N,L,NZ,NY,NX))*(CNH3E(NY,NX)-CNH3A1)
      RHGFL1=AMIN1(DFHGA,RTVLP(N,L,NZ,NY,NX))*(CH2GE(NY,NX)-CH2GA1)
      ELSE
      RCODF1=0.0
      ROXDF1=0.0
      RCHDF1=0.0
      RN2DF1=0.0
      RNHDF1=0.0
      RHGDF1=0.0
      RCOFL1=0.0
      ROXFL1=0.0
      RCHFL1=0.0
      RN2FL1=0.0
      RNHFL1=0.0
      RHGFL1=0.0
      ENDIF
C
C     UPDATE TRANSIENT STATE VARIABLES AND CONCENTRATIONS
C     FOR ROOT GAS TRANSFERS
C
      CO2A1=CO2A1-RCODF1+RCOFL1
      OXYA1=OXYA1-ROXDF1+ROXFL1
      CH4A1=CH4A1-RCHDF1+RCHFL1
      Z2OA1=Z2OA1-RN2DF1+RN2FL1
      ZH3A1=ZH3A1-RNHDF1+RNHFL1
      H2GA1=H2GA1-RHGDF1+RHGFL1
      CO2P1=CO2P1+RCODF1+RCO2SX+RCO2PX 
      OXYP1=OXYP1+ROXDF1-RUPOPX
      CH4P1=CH4P1+RCHDF1+RUPCSX
      Z2OP1=Z2OP1+RN2DF1+RUPZSX
      ZH3P1=ZH3P1+RNHDF1+RUPNSX
      H2GP1=H2GP1+RHGDF1+RUPHGX
C
C     ACCUMULATE SOIL-ROOT EXCHANGE OF NONREACTIVE GASES TO HOURLY TIME SCALE
C
      RCO2S(N,L,NZ,NY,NX)=RCO2S(N,L,NZ,NY,NX)+RCO2SX
      RUPOXS(N,L,NZ,NY,NX)=RUPOXS(N,L,NZ,NY,NX)+RUPOSX
      RUPCHS(N,L,NZ,NY,NX)=RUPCHS(N,L,NZ,NY,NX)+RUPCSX
      RUPN2S(N,L,NZ,NY,NX)=RUPN2S(N,L,NZ,NY,NX)+RUPZSX
      RUPN3S(N,L,NZ,NY,NX)=RUPN3S(N,L,NZ,NY,NX)+RUPNSX
      RUPN3B(N,L,NZ,NY,NX)=RUPN3B(N,L,NZ,NY,NX)+RUPNBX
      RUPHGS(N,L,NZ,NY,NX)=RUPHGS(N,L,NZ,NY,NX)+RUPHGX
C
C     ACCUMULATE WITHIN-ROOT GAS EXCHANGE TO HOURLY TIME SCALE
C
      RCODFA(N,L,NZ,NY,NX)=RCODFA(N,L,NZ,NY,NX)+RCODF1
      ROXDFA(N,L,NZ,NY,NX)=ROXDFA(N,L,NZ,NY,NX)+ROXDF1
      RCHDFA(N,L,NZ,NY,NX)=RCHDFA(N,L,NZ,NY,NX)+RCHDF1
      RN2DFA(N,L,NZ,NY,NX)=RN2DFA(N,L,NZ,NY,NX)+RN2DF1
      RNHDFA(N,L,NZ,NY,NX)=RNHDFA(N,L,NZ,NY,NX)+RNHDF1
      RHGDFA(N,L,NZ,NY,NX)=RHGDFA(N,L,NZ,NY,NX)+RHGDF1
      RCOFLA(N,L,NZ,NY,NX)=RCOFLA(N,L,NZ,NY,NX)+RCOFL1
      ROXFLA(N,L,NZ,NY,NX)=ROXFLA(N,L,NZ,NY,NX)+ROXFL1
      RCHFLA(N,L,NZ,NY,NX)=RCHFLA(N,L,NZ,NY,NX)+RCHFL1
      RN2FLA(N,L,NZ,NY,NX)=RN2FLA(N,L,NZ,NY,NX)+RN2FL1
      RNHFLA(N,L,NZ,NY,NX)=RNHFLA(N,L,NZ,NY,NX)+RNHFL1
      RHGFLA(N,L,NZ,NY,NX)=RHGFLA(N,L,NZ,NY,NX)+RHGFL1
C
C     ACCUMULATE SOIL-ROOT EXCHANGE OF REACTIVE GASES TO HOURLY TIME SCALE
C
      RCO2P(N,L,NZ,NY,NX)=RCO2P(N,L,NZ,NY,NX)+RCO2PX+RCO2SX
      RUPOXP(N,L,NZ,NY,NX)=RUPOXP(N,L,NZ,NY,NX)+RUPOPX
      ROXSK(M,L,NY,NX)=ROXSK(M,L,NY,NX)+RUPOSX
C     IF(NX.EQ.3.AND.NY.EQ.3)THEN
C     WRITE(*,5566)'OXYP1',I,J,NX,NY,NZ,L,N,M,MX,UPMXP*PP(NZ,NY,NX) 
C    2,RUPOSX,ROXDFQ,OXYS1,RUPOPX,ROXDF1,OXYP1
C    3,FOXYX,DFGS(M,L,NY,NX),DFGP,ROXYFX,ROXYLX,ROXFL1 
C    3,OXYG1,OXYA1,COXYS1,COXYP1,COXYR,ROXSK(M,L,NY,NX),XS,XR
C    4,OXYPY,VOLWOA,RTVLP(N,L,NZ,NY,NX),RTVLW(N,L,NZ,NY,NX)
C    5,DFOXA,COXYE(NY,NX),COXYA1,RUPOXP(N,L,NZ,NY,NX)
C    6,RUPOXS(N,L,NZ,NY,NX),ROXYP(N,L,NZ,NY,NX),THETPM(M,L,NY,NX)
C     WRITE(*,5566)'CH4S1',I,J,NX,NY,NZ,L,N,M,MX,CH4S1,RCHDFQ,RUPCSX
C    2,RDFCHS,RMFCHS,DIFCL,CCH4S1,CCH4P1,CH4P1,CH4PX,RCHDF1,RCHFL1 
C    3,DFCHA,RTVLP(N,L,NZ,NY,NX),CCH4E(NY,NX),CCH4A1
C    4,DFGS(M,L,NY,NX),CH4G1,VOLWCH,CH4S1,VOLPMM,THETPM(M,L,NY,NX)
5566  FORMAT(A8,9I4,40E12.4)
C     ENDIF
90    CONTINUE
      ENDIF
99    CONTINUE
C
C     O2 CONSTRAINTS TO ROOT RESPIRATION DEPENDS UPON RATIO
C     OF ROOT O2 UPTAKE 'RUPOXT' TO ROOT O2 DEMAND 'ROXYP'
C
      RUPOXT=RUPOXP(N,L,NZ,NY,NX)+RUPOXS(N,L,NZ,NY,NX)
      WFR(N,L,NZ,NY,NX)=AMIN1(1.0,AMAX1(0.0
     2,RUPOXT/ROXYP(N,L,NZ,NY,NX)))
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,3368)'WFR',I,J,NX,NY,NZ,L,N,WFR(N,L,NZ,NY,NX)
C    2,RUPOXP(N,L,NZ,NY,NX),RUPOXS(N,L,NZ,NY,NX)
C    3,ROXYP(N,L,NZ,NY,NX)
3368  FORMAT(A8,7I4,12E24.16)
C     ENDIF
      ELSE
      RUPOXT=0.0
      IF(L.GT.NG(NZ,NY,NX))THEN
      WFR(N,L,NZ,NY,NX)=WFR(N,L-1,NZ,NY,NX)
      ELSE
      WFR(N,L,NZ,NY,NX)=1.0
      ENDIF
      ENDIF
      OSTRD=OSTRD+ROXYP(N,L,NZ,NY,NX)
      OSTRN=OSTRN+RUPOXT
C
C     ROOT EXUDATION OF C, N AND P DEPENDS ON CONCENTRATION DIFFERENCES
C     BETWEEN ROOT NON-STRUCTURAL POOLS AND SOIL DISSOLVED POOLS
C
      IF(CCPOLR(N,L,NZ,NY,NX).GT.ZERO
     3.AND.CPOOLR(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CCR=AMAX1(CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CZPOLR(N,L,NZ,NY,NX)*CNKER)
     3,CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)*CPKER))
      CNR=CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CNKER)
      CPR=CPPOLR(N,L,NZ,NY,NX)/(CPPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CPKER)
      RDFOMC(N,L,NZ,NY,NX)=EXUDR*CCR*TFND(L,NY,NX)
     2*AMAX1(0.0,CPOOLR(N,L,NZ,NY,NX))
     3/(1.0+(COQC(1,L,NY,NX)+COQA(1,L,NY,NX))/1.0E+03) 
      RDFOMN(N,L,NZ,NY,NX)=RDFOMC(N,L,NZ,NY,NX)
     2*AMIN1(CNMX,CNR*ZPOOLR(N,L,NZ,NY,NX)/CPOOLR(N,L,NZ,NY,NX))
      RDFOMP(N,L,NZ,NY,NX)=RDFOMC(N,L,NZ,NY,NX)
     2*AMIN1(CPMX,CPR*PPOOLR(N,L,NZ,NY,NX)/CPOOLR(N,L,NZ,NY,NX))
      ELSE
      RDFOMC(N,L,NZ,NY,NX)=0.0
      RDFOMN(N,L,NZ,NY,NX)=0.0
      RDFOMP(N,L,NZ,NY,NX)=0.0
      ENDIF
C     IF((I/10)*10.EQ.I.AND.J.EQ.24.AND.NZ.EQ.3)THEN
C     WRITE(*,2224)'RDFOMC',I,J,NX,NY,NZ,L,N,RDFOMC(N,L,NZ,NY,NX)
C    2,RDFOMN(N,L,NZ,NY,NX),RDFOMP(N,L,NZ,NY,NX)
C    2,CPOOLR(N,L,NZ,NY,NX),ZPOOLR(N,L,NZ,NY,NX),PPOOLR(N,L,NZ,NY,NX)
C    3,CCR,CNR,CPR,COQC(1,L,NY,NX),COQA(1,L,NY,NX)
C    4,COQC(1,L,NY,NX),COQA(1,L,NY,NX)
C    5,OQN(1,L,NY,NX)/VOLWM(NPH,L,NY,NX)
C    5,OQP(1,L,NY,NX)/VOLWM(NPH,L,NY,NX)
C    6,ZPOOLR(N,L,NZ,NY,NX)/RTVLW(N,L,NZ,NY,NX)
C    6,PPOOLR(N,L,NZ,NY,NX)/RTVLW(N,L,NZ,NY,NX)
2224  FORMAT(A8,7I4,20E12.4)
C     ENDIF
C
C     NUTRIENT UPTAKE
C
      IF(WFR(N,L,NZ,NY,NX).GT.ZERO.AND.FCUP.GT.ZERO
     2.AND.FWSRT.GT.ZERO.AND.RTLGP(N,L,NZ,NY,NX).GT.RTLGPX)THEN
      IF(FZUP.GT.ZERO)THEN
C
C     PARAMETERS FOR RADIAL MASS FLOW AND DIFFUSION OF NH4
C     FROM SOIL TO ROOT
C
      ZNSGX=ZNSGL(L,NY,NX)*TORT(L,NY,NX)
      PATHL=AMIN1(PATH(N,L),RRADL(N,L)+SQRT(2.0*ZNSGX))
      DIFFL=ZNSGX*RTARR(N,L)/LOG(PATHL/RRADL(N,L))
C
C     NH4 UPTAKE IN NON-BAND SOIL ZONE
C
      IF(VLNH4(L,NY,NX).GT.ZERO.AND.CNH4S(L,NY,NX)
     2.GT.UPMNZH(N,NZ,NY,NX))THEN
      RMFNH4=UPWTRP*VLNH4(L,NY,NX)
      DIFNH=DIFFL*VLNH4(L,NY,NX)
C
C     NH4 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'
C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXZH(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX) 
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLNH4(L,NY,NX)*AMIN1(FCUP,FZUP)
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF NH4 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF NH4 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFNH+RMFNH4)*CNH4S(L,NY,NX)
      Y=DIFNH*UPMNZH(N,NZ,NY,NX)
      B=-UPMX-DIFNH*UPKMZH(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKNH4=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFNH*UPKMZH(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKNHP=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      ZNH4M=UPMNZH(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLNH4(L,NY,NX)
      ZNH4X=AMAX1(0.0,FNH4X*(ZNH4S(L,NY,NX)-ZNH4M))
      RUNNHP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKNH4*PP(NZ,NY,NX))
      RUPNH4(N,L,NZ,NY,NX)=AMIN1(ZNH4X,RUNNHP(N,L,NZ,NY,NX))
      RUONH4(N,L,NZ,NY,NX)=AMIN1(ZNH4X,AMAX1(0.0
     2,RTKNHP*PP(NZ,NY,NX)))
      RUCNH4(N,L,NZ,NY,NX)=RUPNH4(N,L,NZ,NY,NX)/FCUP
C     IF(NZ.EQ.1)THEN
C     WRITE(*,1110)'UPNH4',I,J,NX,NY,NZ,L,N,RUNNHP(N,L,NZ,NY,NX)
C    2,RUPNH4(N,L,NZ,NY,NX),RTKNH4,RMFNH4,X,Y,B,C,UPMX,UPMXP
C    2,WFR(N,L,NZ,NY,NX),CNH4S(L,NY,NX),DIFNH,RTDNP(N,L,NZ,NY,NX) 
C    2,WTRTD(N,L,NZ,NY,NX),CNH4S(L,NY,NX),RDFOMN(N,L,NZ,NY,NX)
C    3,CCPOLR(N,L,NZ,NY,NX),CZPOLR(N,L,NZ,NY,NX),CPPOLR(N,L,NZ,NY,NX)
C    4,THETW(L,NY,NX),TKS(L,NY,NX),RSCS(L,NY,NX),UPMXP,FWSRT
C    5,FNH4X,ZNH4S(L,NY,NX),FZUP,FCUP,COXYS(L,NY,NX),COXYG(L,NY,NX) 
C    6,CCPOLP(NZ,NY,NX)
C    7,CZPOLP(NZ,NY,NX),CPPOLP(NZ,NY,NX),FDBK(1,NZ,NY,NX),PSIST1(L)
C    2,PSIRT(N,L,NZ,NY,NX),ZPOOLR(N,L,NZ,NY,NX),WTRTL(N,L,NZ,NY,NX)
C    3,RTARP(N,L,NZ,NY,NX),RRADL(N,L),PATH(N,L)
C    4,DIFFL,ZNSGX,RTARR(N,L),PATHL,RRADL(N,L),VLNH4(L,NY,NX)
1110  FORMAT(A8,7I4,100E12.4)
C     ENDIF
      ELSE
      RUNNHP(N,L,NZ,NY,NX)=0.0
      RUPNH4(N,L,NZ,NY,NX)=0.0
      RUONH4(N,L,NZ,NY,NX)=0.0
      RUCNH4(N,L,NZ,NY,NX)=0.0
      ENDIF
C
C     NH4 UPTAKE IN BAND SOIL ZONE
C
      IF(VLNHB(L,NY,NX).GT.ZERO.AND.CNH4B(L,NY,NX)
     2.GT.UPMNZH(N,NZ,NY,NX))THEN
      RMFNHB=UPWTRP*VLNHB(L,NY,NX)
      DIFNH=DIFFL*VLNHB(L,NY,NX)
C
C     NH4 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'
C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXZH(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX) 
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLNHB(L,NY,NX)*AMIN1(FCUP,FZUP)
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF NH4 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF NH4 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFNH+RMFNHB)*CNH4B(L,NY,NX)
      Y=DIFNH*UPMNZH(N,NZ,NY,NX)
      B=-UPMX-DIFNH*UPKMZH(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKNHB=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFNH*UPKMZH(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKNBP=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      ZNHBM=UPMNZH(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLNHB(L,NY,NX)
      ZNHBX=AMAX1(0.0,FNHBX*(ZNH4B(L,NY,NX)-ZNHBM))
      RUNNBP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKNHB*PP(NZ,NY,NX))
      RUPNHB(N,L,NZ,NY,NX)=AMIN1(ZNHBX,RUNNBP(N,L,NZ,NY,NX))
      RUONHB(N,L,NZ,NY,NX)=AMIN1(ZNHBX,AMAX1(0.0
     2,RTKNBP*PP(NZ,NY,NX)))
      RUCNHB(N,L,NZ,NY,NX)=RUPNHB(N,L,NZ,NY,NX)/FCUP
      ELSE
      RUNNBP(N,L,NZ,NY,NX)=0.0
      RUPNHB(N,L,NZ,NY,NX)=0.0
      RUONHB(N,L,NZ,NY,NX)=0.0
      RUCNHB(N,L,NZ,NY,NX)=0.0
      ENDIF
C
C     PARAMETERS FOR RADIAL MASS FLOW AND DIFFUSION OF NO3
C     FROM SOIL TO ROOT
C
      ZOSGX=ZOSGL(L,NY,NX)*TORT(L,NY,NX)
      PATHL=AMIN1(PATH(N,L),RRADL(N,L)+SQRT(2.0*ZOSGX))
      DIFFL=ZOSGX*RTARR(N,L)/LOG(PATHL/RRADL(N,L))
C
C     NO3 UPTAKE IN NON-BAND SOIL ZONE
C
      IF(VLNO3(L,NY,NX).GT.ZERO.AND.CNO3S(L,NY,NX)
     2.GT.UPMNZO(N,NZ,NY,NX))THEN
      RMFNO3=UPWTRP*VLNO3(L,NY,NX)
      DIFNO=DIFFL*VLNO3(L,NY,NX)
C
C     NO3 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'
C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXZO(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX)
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLNO3(L,NY,NX)*AMIN1(FCUP,FZUP) 
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF NO3 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF NO3 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFNO+RMFNO3)*CNO3S(L,NY,NX)
      Y=DIFNO*UPMNZO(N,NZ,NY,NX)
      B=-UPMX-DIFNO*UPKMZO(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKNO3=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFNO*UPKMZO(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKNOP=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      ZNO3M=UPMNZO(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLNO3(L,NY,NX)
      ZNO3X=AMAX1(0.0,FNO3X*(ZNO3S(L,NY,NX)-ZNO3M))
      RUNNOP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKNO3*PP(NZ,NY,NX))
      RUPNO3(N,L,NZ,NY,NX)=AMIN1(ZNO3X,RUNNOP(N,L,NZ,NY,NX))
      RUONO3(N,L,NZ,NY,NX)=AMIN1(ZNO3X,AMAX1(0.0
     2,RTKNOP*PP(NZ,NY,NX)))
      RUCNO3(N,L,NZ,NY,NX)=RUPNO3(N,L,NZ,NY,NX)/FCUP
C     IF(NX.EQ.4.AND.NY.EQ.2)THEN
C     WRITE(*,1111)'UPNO3',I,J,NZ,L,N,RUPNO3(N,L,NZ,NY,NX),FNO3X
C    2,ZNO3S(L,NY,NX),ZNO3M,RTDNP(N,L,NZ,NY,NX),RTKNO3,RMFNO3,X,Y,B,C 
C    2,UPMX,CNO3S(L,NY,NX),DIFNO,RUONO3(N,L,NZ,NY,NX)
C    3,CCPOLR(N,L,NZ,NY,NX),CZPOLR(N,L,NZ,NY,NX),CPPOLR(N,L,NZ,NY,NX)
C    4,THETW(L,NY,NX),TKS(L,NY,NX),RSCS(L,NY,NX),UPMXP,FWSRT
C    5,FZUP,FCUP,COXYS(L,NY,NX),COXYG(L,NY,NX),WFR(N,L,NZ,NY,NX)
C    6,CCPOLP(NZ,NY,NX),CZPOLP(NZ,NY,NX),CPPOLP(NZ,NY,NX)
C    7,FDBK(1,NZ,NY,NX),PSIST1(L),PSIRT(N,L,NZ,NY,NX)
C    2,ZPOOLR(N,L,NZ,NY,NX),WTRTL(N,L,NZ,NY,NX)
C    3,RUNNOP(N,L,NZ,NY,NX),RNO3Y(L,NY,NX)
1111  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      ELSE
      RUNNOP(N,L,NZ,NY,NX)=0.0
      RUPNO3(N,L,NZ,NY,NX)=0.0
      RUONO3(N,L,NZ,NY,NX)=0.0
      RUCNO3(N,L,NZ,NY,NX)=0.0
      ENDIF
C
C     NO3 UPTAKE IN BAND SOIL ZONE
C
      IF(VLNOB(L,NY,NX).GT.ZERO.AND.CNO3B(L,NY,NX)
     2.GT.UPMNZO(N,NZ,NY,NX))THEN
      RMFNOB=UPWTRP*VLNOB(L,NY,NX)
      DIFNO=DIFFL*VLNOB(L,NY,NX)
C
C     NO3 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'

C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXZO(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX)
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLNOB(L,NY,NX)*AMIN1(FCUP,FZUP)
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF NO3 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF NO3 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFNO+RMFNOB)*CNO3B(L,NY,NX)
      Y=DIFNO*UPMNZO(N,NZ,NY,NX)
      B=-UPMX-DIFNO*UPKMZO(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKNOB=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFNO*UPKMZO(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKNPB=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      ZNOBM=UPMNZO(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLNOB(L,NY,NX)
      ZNOBX=AMAX1(0.0,FNOBX*(ZNO3B(L,NY,NX)-ZNOBM))
      RUNNXP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKNOB*PP(NZ,NY,NX))
      RUPNOB(N,L,NZ,NY,NX)=AMIN1(ZNOBX,RUNNXP(N,L,NZ,NY,NX))
      RUONOB(N,L,NZ,NY,NX)=AMIN1(ZNOBX
     2,AMAX1(0.0,RTKNPB*PP(NZ,NY,NX)))
      RUCNOB(N,L,NZ,NY,NX)=RUPNOB(N,L,NZ,NY,NX)/FCUP
      ELSE
      RUNNXP(N,L,NZ,NY,NX)=0.0
      RUPNOB(N,L,NZ,NY,NX)=0.0
      RUONOB(N,L,NZ,NY,NX)=0.0
      RUCNOB(N,L,NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RUNNHP(N,L,NZ,NY,NX)=0.0
      RUPNH4(N,L,NZ,NY,NX)=0.0
      RUONH4(N,L,NZ,NY,NX)=0.0
      RUCNH4(N,L,NZ,NY,NX)=0.0
      RUNNBP(N,L,NZ,NY,NX)=0.0
      RUPNHB(N,L,NZ,NY,NX)=0.0
      RUONHB(N,L,NZ,NY,NX)=0.0
      RUCNHB(N,L,NZ,NY,NX)=0.0
      RUNNOP(N,L,NZ,NY,NX)=0.0
      RUPNO3(N,L,NZ,NY,NX)=0.0
      RUONO3(N,L,NZ,NY,NX)=0.0
      RUCNO3(N,L,NZ,NY,NX)=0.0
      RUNNXP(N,L,NZ,NY,NX)=0.0
      RUPNOB(N,L,NZ,NY,NX)=0.0
      RUONOB(N,L,NZ,NY,NX)=0.0
      RUCNOB(N,L,NZ,NY,NX)=0.0
      ENDIF
      IF(FPUP.GT.1.0E-06)THEN
C
C     PARAMETERS FOR RADIAL MASS FLOW AND DIFFUSION OF PO4
C     FROM SOIL TO ROOT
C
      POSGX=POSGL(L,NY,NX)*TORT(L,NY,NX)
      PATHL=AMIN1(PATH(N,L),RRADL(N,L)+SQRT(2.0*POSGX))
      DIFFL=POSGX*RTARR(N,L)/LOG(PATHL/RRADL(N,L))
C
C     PO4 UPTAKE IN NON-BAND SOIL ZONE
C
      IF(VLPO4(L,NY,NX).GT.ZERO.AND.CH2P4(L,NY,NX)
     2.GT.UPMNPO(N,NZ,NY,NX))THEN
      FH2P=CPO4S(L,NY,NX)/CH2P4(L,NY,NX)
      RMFH2P=UPWTRP*VLPO4(L,NY,NX)
      DIFPO=DIFFL*FH2P*VLPO4(L,NY,NX)
C
C     PO4 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'
C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXPO(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX)
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLPO4(L,NY,NX)*AMIN1(FCUP,FPUP)
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF PO4 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF PO4 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFPO+RMFH2P)*CH2P4(L,NY,NX)
      Y=DIFPO*UPMNPO(N,NZ,NY,NX)
      B=-UPMX-DIFPO*UPKMPO(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKH2P=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFPO*UPKMPO(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKHPP=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      H2POM=UPMNPO(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      H2POX=AMAX1(0.0,FPO4X*(H2PO4(L,NY,NX)-H2POM))
      RUPPOP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKH2P*PP(NZ,NY,NX))
      RUPH2P(N,L,NZ,NY,NX)=AMIN1(H2POX,RUPPOP(N,L,NZ,NY,NX))
      RUOH2P(N,L,NZ,NY,NX)=AMIN1(H2POX,AMAX1(0.0
     2,RTKHPP*PP(NZ,NY,NX)))
      RUCH2P(N,L,NZ,NY,NX)=RUPH2P(N,L,NZ,NY,NX)/FCUP
C     IF((I/10)*10.EQ.I.AND.J.EQ.24.AND.NZ.EQ.3)THEN
C     WRITE(*,2223)'UPPO4',I,J,NZ,L,N,RUPH2P(N,L,NZ,NY,NX),FPO4X
C    2,H2PO4(L,NY,NX),RUPPOP(N,L,NZ,NY,NX),UPMX,DIFPO,UPKMPO(N,NZ,NY,NX)
C    3,UPMNPO(N,NZ,NY,NX),RMFH2P,CH2P4(L,NY,NX),UPMXP,WFR(N,L,NZ,NY,NX)
C    4,FCUP,FZUP,FPUP,UPMXPO(N,NZ,NY,NX),RTARP(N,L,NZ,NY,NX),FWSRT
C    5,TFN4(L,NZ,NY,NX),DIFFL,FH2P,CPO4S(L,NY,NX),CPOOLR(N,L,NZ,NY,NX)
C    6,PPOOLR(N,L,NZ,NY,NX),RTKH2P,PP(NZ,NY,NX)
C    2,RTLGP(N,L,NZ,NY,NX) 
2223  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      ELSE
      RUPPOP(N,L,NZ,NY,NX)=0.0
      RUPH2P(N,L,NZ,NY,NX)=0.0
      RUOH2P(N,L,NZ,NY,NX)=0.0
      RUCH2P(N,L,NZ,NY,NX)=0.0
      ENDIF
C
C     PO4 UPTAKE IN BAND SOIL ZONE
C
      IF(VLPOB(L,NY,NX).GT.ZERO.AND.CH2PB(L,NY,NX)
     2.GT.UPMNPO(N,NZ,NY,NX))THEN
      FH2P=CPO4B(L,NY,NX)/CH2PB(L,NY,NX)
      RMFH2B=UPWTRP*VLPOB(L,NY,NX)
      DIFPO=DIFFL*FH2P*VLPOB(L,NY,NX)
C
C     PO4 UPTAKE DEMAND FROM ROOT UPTAKE PARAMETERS ENTERED IN 'READQ'
C     AND FROM ROOT SURFACE AREA, C AND N CONSTRAINTS CALCULATED ABOVE
C
      UPMXP=UPMXPO(N,NZ,NY,NX)*RTARP(N,L,NZ,NY,NX)
     2*FWSRT*TFN4(L,NZ,NY,NX)*VLPOB(L,NY,NX)*AMIN1(FCUP,FPUP)
      UPMX=UPMXP*WFR(N,L,NZ,NY,NX) 
C
C     SOLUTION FOR MASS FLOW + DIFFUSION OF PO4 IN AQUEOUS PHASE OF
C     SOIL = ACTIVE UPTAKE OF PO4 BY ROOT, CONSTRAINED BY COMPETITION
C     WITH OTHER ROOT AND MICROBIAL POPULATIONS
C
      X=(DIFPO+RMFH2B)*CH2PB(L,NY,NX)
      Y=DIFPO*UPMNPO(N,NZ,NY,NX)
      B=-UPMX-DIFPO*UPKMPO(N,NZ,NY,NX)-X+Y
      C=(X-Y)*UPMX
      RTKH2B=(-B-SQRT(B*B-4.0*C))/2.0
      BP=-UPMXP-DIFPO*UPKMPO(N,NZ,NY,NX)-X+Y
      CP=(X-Y)*UPMXP
      RTKHPB=(-BP-SQRT(BP*BP-4.0*CP))/2.0
      H2PXM=UPMNPO(N,NZ,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      H2PXB=AMAX1(0.0,FPOBX*(H2POB(L,NY,NX)-H2PXM))
      RUPPBP(N,L,NZ,NY,NX)=AMAX1(0.0,RTKH2B*PP(NZ,NY,NX))
      RUPH2B(N,L,NZ,NY,NX)=AMIN1(H2PXB,RUPPBP(N,L,NZ,NY,NX))
      RUOH2B(N,L,NZ,NY,NX)=AMIN1(H2PXB
     2,AMAX1(0.0,RTKHPB*PP(NZ,NY,NX)))
      RUCH2B(N,L,NZ,NY,NX)=RUPH2B(N,L,NZ,NY,NX)/FCUP
      ELSE
      RUPPBP(N,L,NZ,NY,NX)=0.0
      RUPH2B(N,L,NZ,NY,NX)=0.0
      RUOH2B(N,L,NZ,NY,NX)=0.0
      RUCH2B(N,L,NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RUPPOP(N,L,NZ,NY,NX)=0.0
      RUPH2P(N,L,NZ,NY,NX)=0.0
      RUOH2P(N,L,NZ,NY,NX)=0.0
      RUCH2P(N,L,NZ,NY,NX)=0.0
      RUPPBP(N,L,NZ,NY,NX)=0.0
      RUPH2B(N,L,NZ,NY,NX)=0.0
      RUOH2B(N,L,NZ,NY,NX)=0.0
      RUCH2B(N,L,NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RUNNHP(N,L,NZ,NY,NX)=0.0
      RUPNH4(N,L,NZ,NY,NX)=0.0
      RUONH4(N,L,NZ,NY,NX)=0.0
      RUCNH4(N,L,NZ,NY,NX)=0.0
      RUNNBP(N,L,NZ,NY,NX)=0.0
      RUPNHB(N,L,NZ,NY,NX)=0.0
      RUONHB(N,L,NZ,NY,NX)=0.0
      RUCNHB(N,L,NZ,NY,NX)=0.0
      RUNNOP(N,L,NZ,NY,NX)=0.0
      RUPNO3(N,L,NZ,NY,NX)=0.0
      RUONO3(N,L,NZ,NY,NX)=0.0
      RUCNO3(N,L,NZ,NY,NX)=0.0
      RUNNXP(N,L,NZ,NY,NX)=0.0
      RUPNOB(N,L,NZ,NY,NX)=0.0
      RUONOB(N,L,NZ,NY,NX)=0.0
      RUCNOB(N,L,NZ,NY,NX)=0.0
      RUPPOP(N,L,NZ,NY,NX)=0.0
      RUPH2P(N,L,NZ,NY,NX)=0.0
      RUOH2P(N,L,NZ,NY,NX)=0.0
      RUCH2P(N,L,NZ,NY,NX)=0.0
      RUPPBP(N,L,NZ,NY,NX)=0.0
      RUPH2B(N,L,NZ,NY,NX)=0.0
      RUOH2B(N,L,NZ,NY,NX)=0.0
      RUCH2B(N,L,NZ,NY,NX)=0.0
      ENDIF
      ELSE
      RCOFLA(N,L,NZ,NY,NX)=0.0
      ROXFLA(N,L,NZ,NY,NX)=0.0
      RCHFLA(N,L,NZ,NY,NX)=0.0
      RN2FLA(N,L,NZ,NY,NX)=0.0
      RNHFLA(N,L,NZ,NY,NX)=0.0
      RCODFA(N,L,NZ,NY,NX)=0.0
      ROXDFA(N,L,NZ,NY,NX)=0.0
      RCHDFA(N,L,NZ,NY,NX)=0.0
      RN2DFA(N,L,NZ,NY,NX)=0.0
      RNHDFA(N,L,NZ,NY,NX)=0.0
      RCO2S(N,L,NZ,NY,NX)=0.0
      RUPOXS(N,L,NZ,NY,NX)=0.0
      RUPCHS(N,L,NZ,NY,NX)=0.0
      RUPN2S(N,L,NZ,NY,NX)=0.0
      RUPN3S(N,L,NZ,NY,NX)=0.0
      RCO2P(N,L,NZ,NY,NX)=0.0
      RUPOXP(N,L,NZ,NY,NX)=0.0
      RDFOMC(N,L,NZ,NY,NX)=0.0
      RDFOMN(N,L,NZ,NY,NX)=0.0
      RDFOMP(N,L,NZ,NY,NX)=0.0
      WFR(N,L,NZ,NY,NX)=1.0
      RUNNHP(N,L,NZ,NY,NX)=0.0
      RUPNH4(N,L,NZ,NY,NX)=0.0
      RUONH4(N,L,NZ,NY,NX)=0.0
      RUCNH4(N,L,NZ,NY,NX)=0.0
      RUNNBP(N,L,NZ,NY,NX)=0.0
      RUPNHB(N,L,NZ,NY,NX)=0.0
      RUONHB(N,L,NZ,NY,NX)=0.0
      RUCNHB(N,L,NZ,NY,NX)=0.0
      RUNNOP(N,L,NZ,NY,NX)=0.0
      RUPNO3(N,L,NZ,NY,NX)=0.0
      RUONO3(N,L,NZ,NY,NX)=0.0
      RUCNO3(N,L,NZ,NY,NX)=0.0
      RUNNXP(N,L,NZ,NY,NX)=0.0
      RUPNOB(N,L,NZ,NY,NX)=0.0
      RUONOB(N,L,NZ,NY,NX)=0.0
      RUCNOB(N,L,NZ,NY,NX)=0.0
      RUPPOP(N,L,NZ,NY,NX)=0.0
      RUPH2P(N,L,NZ,NY,NX)=0.0
      RUOH2P(N,L,NZ,NY,NX)=0.0
      RUCH2P(N,L,NZ,NY,NX)=0.0
      RUPPBP(N,L,NZ,NY,NX)=0.0
      RUPH2B(N,L,NZ,NY,NX)=0.0
      RUOH2B(N,L,NZ,NY,NX)=0.0
      RUCH2B(N,L,NZ,NY,NX)=0.0
      IF(N.EQ.1)RUPNF(L,NZ,NY,NX)=0.0
      ENDIF
C
C     TOTAL C,N,P EXCHANGE BETWEEN ROOTS AND SOIL
C
      UPOMC(NZ,NY,NX)=UPOMC(NZ,NY,NX)+RDFOMC(N,L,NZ,NY,NX)
      UPOMN(NZ,NY,NX)=UPOMN(NZ,NY,NX)+RDFOMN(N,L,NZ,NY,NX)
      UPOMP(NZ,NY,NX)=UPOMP(NZ,NY,NX)+RDFOMP(N,L,NZ,NY,NX)
      UPNH4(NZ,NY,NX)=UPNH4(NZ,NY,NX)+RUPNH4(N,L,NZ,NY,NX)
     2+RUPNHB(N,L,NZ,NY,NX)
      UPNO3(NZ,NY,NX)=UPNO3(NZ,NY,NX)+RUPNO3(N,L,NZ,NY,NX)
     2+RUPNOB(N,L,NZ,NY,NX)
      UPH2P(NZ,NY,NX)=UPH2P(NZ,NY,NX)+RUPH2P(N,L,NZ,NY,NX)
     2+RUPH2B(N,L,NZ,NY,NX)
      XOQCS(1,L,NY,NX)=XOQCS(1,L,NY,NX)-RDFOMC(N,L,NZ,NY,NX)
      XOQNS(1,L,NY,NX)=XOQNS(1,L,NY,NX)-RDFOMN(N,L,NZ,NY,NX)
      XOQPS(1,L,NY,NX)=XOQPS(1,L,NY,NX)-RDFOMP(N,L,NZ,NY,NX)
C     IF(J.EQ.12)THEN
C     WRITE(*,8765)'PLANT',I,J,NX,NY,L,NZ,N,TFOXYX,TFNH4X
C    2,TFNO3X,TFPO4X,TFNHBX,TFNOBX,TFPOBX 
8765  FORMAT(A8,7I4,7F15.6)
C     ENDIF
950   CONTINUE
955   CONTINUE
      TLEC(NY,NX)=TLEC(NY,NX)+EFLXC(NZ,NY,NX)*RA(NZ,NY,NX)
      TSHC(NY,NX)=TSHC(NY,NX)+SFLXC(NZ,NY,NX)*RA(NZ,NY,NX)
      IF(OSTRD.GT.ZEROP(NZ,NY,NX))THEN
      OSTR(NZ,NY,NX)=OSTRN/OSTRD
      ELSE
      OSTR(NZ,NY,NX)=0.0
      ENDIF
      ENDIF
9985  CONTINUE
9990  CONTINUE
9995  CONTINUE
      RETURN
      END
