      SUBROUTINE starte(NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE INITIALIZES ALL SOIL CHEMISTRY VARIABLES
C
      include "parameters.h"
      include "filec.h"
      include "files.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk19a.h"
      include "blk19b.h"
      include "blk19c.h"
      include "blk19d.h"
      CHARACTER*16 DATA(30)
      CHARACTER*3 CHOICE(102,20)
      CHARACTER*8 CDATE
      PARAMETER (SCO2X=7.391E-01,SCH4X=3.156E-02,SOXYX=2.925E-02
     2,SN2GX=1.510E-02,SN2OX=5.241E-01,SNH3X=2.852E+02,SH2GX=3.156E-02
     3,ACO2X=0.14,ACH4X=0.14,AOXYX=0.31,AN2GX=0.23,AN2OX=0.23
     4,ANH3X=0.07,AH2GX=0.14)
      PARAMETER (DPH2O=6.5E-09,SYALO=4.0E-21,SYFEO=4.0E-26
     2,SPCAC=4.0E-03,SPCAS=1.4E+01,SPALP=3.5E-15,SPFEP=3.0E-20
     3,SPCAM=7.0E+07,SPCAD=1.0E-01,SPCAH=6.4E-32,SXOH2=4.5E-05
     4,SXOH1=1.1E-06,SYH2P=1.6E+04,SHH2P=SYH2P*DPH2O,SYH1P=1.6E+04
     5,SHH1P=SYH1P*DPH2O,DPCO2=4.2E-04,DPHCO=5.6E-08
     6,DPN4=5.7E-07,DPAL1=8.6E-07,DPAL2=1.8E-08,DPAL3=2.0E-04
     7,DPAL4=8.0E-03,DPALS=0.16,DPFE1=7.1E-10,DPFE2=1.45E-08
     8,DPFE3=1.15E-04,DPFE4=1.45E-03,DPFES=7.1E-02,DPCAO=12.5
     9,DPCAC=4.2E-02,DPCAH=13.5,DPCAS=1.2,DPMGO=0.7,DPMGC=0.3
     1,DPMGH=67.0,DPMGS=2.1,DPNAC=0.45,DPNAS=3.3E+02,DPKAS=5.0E+01
     2,DPH1P=4.5E-10,DPH2P=6.3E-05,DPH3P=7.1,DPF1P=4.5E-02
     3,DPF2P=3.7E-03,DPC0P=3.5E-04,DPC1P=1.82,DPC2P=40.0
     4,DPM1P=1.23,DPCOH=1.0E-02,DPALO=6.3E+04)
      PARAMETER (DPCO3=DPCO2*DPHCO,SHALO=SYALO/DPH2O**3
     2,SYAL1=SYALO/DPAL1,SHAL1=SYAL1/DPH2O**2,SYAL2=SYAL1/DPAL2
     3,SHAL2=SYAL2/DPH2O,SPAL3=SYAL2/DPAL3,SYAL4=SPAL3/DPAL4
     4,SHAL4=SYAL4*DPH2O,SHFEO=SYFEO/DPH2O**3,SYFE1=SYFEO/DPFE1
     5,SHFE1=SYFE1/DPH2O**2,SYFE2=SYFE1/DPFE2,SHFE2=SYFE2/DPH2O
     6,SPFE3=SYFE2/DPFE3,SYFE4=SPFE3/DPFE4,SHFE4=SYFE4*DPH2O
     7,SHCAC1=SPCAC/DPHCO,SYCAC1=SHCAC1*DPH2O,SHCAC2=SHCAC1/DPCO2
     8,SYCAC2=SHCAC2*DPH2O**2,SHA0P1=SPALP/DPH1P,SYA0P1=SHA0P1*DPH2O
     9,SPA1P1=SYA0P1/DPAL1,SYA2P1=SPA1P1/DPAL2,SHA2P1=SYA2P1*DPH2O
     1,SYA3P1=SYA2P1/DPAL3,SHA3P1=SYA3P1*DPH2O**2,SYA4P1=SYA3P1/DPAL4
     2,SHA4P1=SYA4P1*DPH2O**3,SHA0P2=SHA0P1/DPH2P
     3,SYA0P2=SHA0P2*DPH2O**2,SYA1P2=SYA0P2/DPAL1,SHA1P2=SYA1P2/DPH2O
     4,SPA2P2=SYA1P2/DPAL2,SYA3P2=SPA2P2/DPAL3,SHA3P2=SYA3P2*DPH2O
     5,SYA4P2=SYA3P2/DPAL4,SHA4P2=SYA4P2*DPH2O**2)
      PARAMETER (SHF0P1=SPFEP/DPH1P,SYF0P1=SHF0P1*DPH2O
     2,SPF1P1=SYF0P1/DPFE1,SYF2P1=SPF1P1/DPFE2,SHF2P1=SYF2P1*DPH2O
     3,SYF3P1=SYF2P1/DPFE3,SHF3P1=SYF3P1*DPH2O**2,SYF4P1=SYF3P1/DPFE4
     4,SHF4P1=SYF4P1*DPH2O**3,SHF0P2=SHF0P1/DPH2P,SYF0P2=SHF0P2*DPH2O**2
     5,SYF1P2=SYF0P2/DPFE1,SHF1P2=SYF1P2/DPH2O,SPF2P2=SYF1P2/DPFE2
     6,SYF3P2=SPF2P2/DPFE3,SHF3P2=SYF3P2*DPH2O,SYF4P2=SYF3P2/DPFE4
     7,SHF4P2=SYF4P2*DPH2O**2,SHCAD2=SPCAD/DPH2P,SYCAD2=SHCAD2*DPH2O
     8,SHCAH1=SPCAH/(DPH2O*DPH1P**3),SYCAH1=SHCAH1*DPH2O**4
     9,SHCAH2=SHCAH1/DPH2P**3,SYCAH2=SHCAH2*DPH2O**7)
      PARAMETER (TPD=1.0E-03,TAD=1.0E-02,TSL=1.0,A0=1.0,AE=10.0
     2,COOH=2.5E-02)
C
C     INITIALIZE CATION AND ANION CONCENTRATIONS
C     IN PRECIPITATION (K=1), IRRIGATION (K=2) AND SOIL (K=3)
C     FROM WEATHER, IRRIGATION AND SOIL FILES IN 'READS'
C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      CCO2M=CCO2EI(NY,NX)/12.0
      CCH4M=CCH4E(NY,NX)/12.0
      COXYM=COXYE(NY,NX)/32.0
      CZ2GM=CZ2GE(NY,NX)/14.0
      CZ2OM=CZ2OE(NY,NX)/14.0
      DO 1200 I=1,366
      DO 1200 L=NU(NY,NX),NL(NY,NX)
      DO 2000 K=1,3
      IF(K.EQ.1.AND.I.EQ.1.AND.L.EQ.1)THEN
      PH1=PHR(NY,NX)-3.0
      AHY1=10.0**(-(PHR(NY,NX)-3.0))
      AOH1=DPH2O/AHY1
      CN4Z=CN4R(NY,NX)
      CNOZ=CNOR(NY,NX)
      CPOZ=CPOR(NY,NX)
      CALZ=CALR(NY,NX)
      CFEZ=CFER(NY,NX)
      CCAZ=CCAR(NY,NX)
      CMGZ=CMGR(NY,NX)
      CNAZ=CNAR(NY,NX)
      CKAZ=CKAR(NY,NX)
      CSOZ=CSOR(NY,NX)
      CCLZ=CCLR(NY,NX)
      ELSEIF(K.EQ.2.AND.L.EQ.1)THEN
      PH1=PHQ(I,NY,NX)-3.0
      AHY1=10.0**(-(PHQ(I,NY,NX)-3.0))
      AOH1=DPH2O/AHY1
      CN4Z=CN4Q(I,NY,NX)
      CNOZ=CNOQ(I,NY,NX)
      CPOZ=CPOQ(I,NY,NX)
      CALZ=CALQ(I,NY,NX)
      CFEZ=CFEQ(I,NY,NX)
      CCAZ=CCAQ(I,NY,NX)
      CMGZ=CMGQ(I,NY,NX)
      CNAZ=CNAQ(I,NY,NX)
      CKAZ=CKAQ(I,NY,NX)
      CSOZ=CSOQ(I,NY,NX)
      CCLZ=CCLQ(I,NY,NX)
      ELSEIF(K.EQ.3.AND.I.EQ.1.AND.DATA(20).EQ.'NO'.AND.IGO.EQ.0)THEN
      CN4X=CNH4(L,NY,NX)
      CNOX=CNO3(L,NY,NX)*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      CPOX=CPO4(L,NY,NX)
      CALX=CAL(L,NY,NX)
      CFEX=CFE(L,NY,NX)
      CCAX=CCA(L,NY,NX)
      CMGX=CMG(L,NY,NX)
      CNAX=CNA(L,NY,NX)
      CKAX=CKA(L,NY,NX)
      CSOX=CSO4(L,NY,NX)
      CCLX=CCL(L,NY,NX)
      CALPOX=CALPO(L,NY,NX)
      CFEPOX=CFEPO(L,NY,NX)
      CCAPDX=CCAPD(L,NY,NX)
      CCAPHX=CCAPH(L,NY,NX)
      CALOHX=CALOH(L,NY,NX)
      CFEOHX=CFEOH(L,NY,NX)
      CCACOX=CCACO(L,NY,NX)
      CCASOX=CCASO(L,NY,NX)
      XCEC(L,NY,NX)=AMAX1(CN4X,CEC(L,NY,NX))*BKVL(L,NY,NX)
      XAEC(L,NY,NX)=AMAX1(CPOX,AEC(L,NY,NX))*BKVL(L,NY,NX)
      PH1=PH(L,NY,NX)
      AHY1=10.0**(-(PH1-3.0))
      AOH1=DPH2O/AHY1
      CN4Z=CN4X
      CNOZ=CNOX
      CPOZ=CPOX
      CALZ=CALX
      CFEZ=CFEX
      CCAZ=CCAX
      CMGZ=CMGX
      CNAZ=CNAX
      CKAZ=CKAX
      CSOZ=CSOX
      CCLZ=CCLX
      DCHG=0.0
      ELSE
      GO TO 2000
      ENDIF
C
C     INITIALIZE SOLUTE EQUILIBRIA
C
      CC3=AMAX1(0.0,CALZ)+AMAX1(0.0,CFEZ)
      CA3=0.0
      CC2=AMAX1(0.0,CCAZ)+CMGZ
      CA2=CSOZ
      CC1=CN4Z+CNAZ+CKAZ
      CA1=CNOZ+CCLZ+CPOZ
      CX2=0.0
      CX1=0.0
      CN=0.0
C
C     INITIALIZE ION STRENGTH AND ACTIVITIES
C
      DO 3010 M=1,25
      CION1=ABS(3.0*(CC3-CA3)+2.0*(CC2-CA2)+CC1-CA1)
      CION2=AMAX1(0.0,CC3+CA3+CC2+CA2+CC1+CA1+CN+CION1)
      CSTR1=0.5E-03*(9.0*(CC3+CA3)+4.0*(CC2+CA2)+CC1+CA1+CION1)
      CSTRZ=0.5E-03*(9.0*(CC3+CA3)+4.0*(CC2+CX2)+CC1+CX1+CION1)
      CSTR2=SQRT(CSTR1)
      FSTR2=CSTR2/(1.0+CSTR2)
      FH2O=5.56E+04/(5.56E+04+CION2)
      IF(ISALT(NY,NX).NE.0)THEN
      A1=AMIN1(1.0,10.0**(-0.509*1.0*FSTR2+0.20*CSTR2))
      A2=AMIN1(1.0,10.0**(-0.509*4.0*FSTR2+0.20*CSTR2))
      A3=AMIN1(1.0,10.0**(-0.509*9.0*FSTR2+0.20*CSTR2))
      ELSE
      A1=1.0
      A2=1.0
      A3=1.0
      ENDIF
      CHY1=AHY1/A1
      COH1=AOH1/A1
C
C     INITIALIZE GASES
C
      CCO2X=CCO2M*SCO2X/(EXP(ACO2X*CSTRZ))*EXP(0.843-0.0281*ATCA(NY,NX))*FH2O
      CCO2Y=LOG(CCO2X)
      CCO2Z=ABS(CCO2Y)
      CCO21=CCO2X
      FCO3=DPCO3*A0/(AHY1**2*A2)
      FHCO=DPCO2*A0/(AHY1*A1)
      Z=ACO2X*(2.0E-03*FCO3+0.5E-03*FHCO)
      DO 3020 MM=1,25
      R=(LOG(CCO21)+Z*CCO21-CCO2Y)/CCO2Z
      IF(R.LT.1.0E-03)GO TO 3030
      CCO21=CCO21/SQRT(1.0+R)
3020  CONTINUE
3030  CONTINUE
      CCH41=CCH4M*SCH4X/(EXP(ACH4X*CSTR1))*EXP(0.597-0.0199*ATCA(NY,NX))*FH2O
      COXY1=COXYM*SOXYX/(EXP(AOXYX*CSTR1))*EXP(0.516-0.0172*ATCA(NY,NX))*FH2O
      CZ2G1=CZ2GM*SN2GX/(EXP(AN2GX*CSTR1))*EXP(0.456-0.0152*ATCA(NY,NX))*FH2O
      CZ2O1=CZ2OM*SN2OX/(EXP(AN2OX*CSTR1))*EXP(0.897-0.0299*ATCA(NY,NX))*FH2O
      CCO31=CCO21*DPCO3*A0/(AHY1**2*A2)
      CHCO31=CCO21*DPCO2*A0/(AHY1*A1)
      CNO1=CNOZ
C
C     INITIALIZE ION PAIR EQUILIBRIA
C
      IF(K.NE.3)THEN
      CN41=CN4Z/(1.0+DPN4*A1/(AHY1*A0))
      CN31=CN41*DPN4*A1/(AHY1*A0)
      ELSE
      CN41=0.0
      CN31=0.0
      ENDIF
      IF(CALZ.LT.0.0)THEN
      CAL1=AMIN1(1.0E+03,SYALO/(AOH1**3*A3))
      ELSE
      CAL1=AMIN1(CALZ,SYALO/(AOH1**3*A3))
      ENDIF
      IF(CFEZ.LT.0.0)THEN
      CFE1=AMIN1(1.0E+03,SYFEO/(AOH1**3*A3))
      ELSE
      CFE1=AMIN1(CFEZ,SYFEO/(AOH1**3*A3))
      ENDIF
      IF(CCAZ.LT.0.0)THEN
      CCA1=AMIN1(1.0E+03,SPCAC/(CCO31*A2**2))
      ELSE
      CCA1=AMIN1(CCAZ,SPCAC/(CCO31*A2**2))
      ENDIF
      CMG1=CMGZ
      CNA1=CNAZ
      CKA1=CKAZ
      CSO41=CSOZ
      CCL1=CCLZ
      CALO1=CAL1*AOH1*A3/(DPAL1*A2)
      CALO2=CAL1*AOH1**2*A3/(DPAL1*DPAL2*A1)
      CALO3=CAL1*AOH1**3*A3/(DPAL1*DPAL2*DPAL3*A0)
      CALO4=CAL1*AOH1**4*A3/(DPAL1*DPAL2*DPAL3*DPAL4*A1)
      CALS1=0.0
      CFEO1=CFE1*AOH1*A3/(DPFE1*A2)
      CFEO2=CFE1*AOH1**2*A3/(DPFE1*DPFE2*A1)
      CFEO3=CFE1*AOH1**3*A3/(DPFE1*DPFE2*DPFE3*A0)
      CFEO4=CFE1*AOH1**4*A3/(DPFE1*DPFE2*DPFE3*DPFE4*A1)
      CFES1=0.0
      CCAO1=CCA1*AOH1*A2/(DPCAO*A1)
      CCAC1=CCA1*CCO31*A2**2/(DPCAC*A0)
      CCAH1=CCA1*CHCO31*A2/DPCAH
      CCAS1=0.0
      CMGO1=CMG1*AOH1*A2/(DPMGO*A1)
      CMGC1=CMG1*CCO31*A2**2/(DPMGC*A0)
      CMGH1=CMG1*CHCO31*A2/DPMGH
      CMGS1=0.0
      CNAC1=CNA1*CCO31*A2/DPNAC
      CNAS1=0.0
      CKAS1=0.0
      CF1P1=0.0
      CF2P1=0.0
      CC0P1=0.0
      CC1P1=0.0
      CC2P1=0.0
      CM1P1=0.0
C
C     INITIALIZE PHOSPHORUS EQUILIBRIA AMONG SOLUBLE, ADSORBED
C     AND PRECIPITATED FORMS
C
      IF(K.NE.3)THEN
      CH3P1=CPOZ/(1.0+DPH3P*A0/(AHY1*A1)+DPH3P*DPH2P*A0
     2/(AHY1**2*A2)+DPH3P*DPH2P*DPH1P*A0/(AHY1**3*A3))
      CH2P1=CH3P1*DPH3P*A0/(AHY1*A1)
      CH1P1=CH3P1*DPH3P*DPH2P*A0/(AHY1**2*A2)
      CH0P1=CH3P1*DPH3P*DPH2P*DPH1P*A0/(AHY1**3*A3)
      ELSE
      XHP=CPOZ*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      XOH=XAEC(L,NY,NX)/VOLA(L,NY,NX)
      FHP3=1.0/(1.0+DPH3P*A0/(AHY1*A1)+DPH3P*DPH2P*A0
     2/(AHY1**2*A2)+DPH3P*DPH2P*DPH1P*A0/(AHY1**3*A3))
      FHP2=FHP3*DPH3P*A0/(AHY1*A1)
      FHP1=FHP3*DPH3P*DPH2P*A0/(AHY1**2*A2)
      FHP0=FHP3*DPH3P*DPH2P*DPH1P*A0/(AHY1**3*A3)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
      SPOH2=SXOH2*AEP/A1
      SPOH1=SXOH1/(AEN*A1)
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP*A1)
      SPH1P=SYH1P*AEN*A1/A2
      FXH2=1.0/(1.0+SPOH2/AHY1+SPOH2*SPOH1/AHY1**2)
      FXH1=FXH2*SPOH2/AHY1
      FXH0=FXH1*SPOH1/AHY1
      FXP2=1.0/(1.0+SYH2P*DPH2P/(SPH1P*AHY1))
      FXP1=FXP2*SYH2P*DPH2P/(SPH1P*AHY1)
      FHPA=FHP2*A1
      XPT=(XOH+XHP+SYH2P*FXP2*AOH1/(FXH1*FHPA)-SQRT(XOH**2*FXH1**2
     2*FHPA**2-2.0*XOH*FXH1**2*XHP*FHPA**2+FXH1**2*XHP**2*FHPA**2
     3+2.0*XOH*FXH1*FHPA*SYH2P*FXP2*AOH1+2.0*FXH1*XHP*FHPA*SYH2P
     4*FXP2*AOH1+SYH2P**2*FXP2**2*AOH1**2)/(FXH1*FHPA))/2.0
      XOH21=(XOH-XPT)*FXH2
      XOH11=(XOH-XPT)*FXH1
      XOH01=(XOH-XPT)*FXH0
      XH1P1=XPT*FXP1
      XH2P1=XPT*FXP2
      CH3P1=(XHP-XPT)*FHP3
      CH2P1=(XHP-XPT)*FHP2
      CH1P1=(XHP-XPT)*FHP1
      CH0P1=(XHP-XPT)*FHP0
      DCHG=0.25*(XOH21-XOH01-XH1P1)+0.75*DCHG
C
C     INITIALIZE CATION EQILIBRIA BETWEEN SOLUBLE
C     AND EXCHANGEABLE FORMS
C
      XCECQ=XCEC(L,NY,NX)/VOLA(L,NY,NX)
      XN4Q=CN4X*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      XHYQ=0.0
      XALQ=0.0
      XCAQ=0.0
      XMGQ=0.0
      XNAQ=0.0
      XKAQ=0.0
      XHC1=0.0
      XALO21=0.0
      XCOOH=AMAX1(0.0,COOH*ORGC(L,NY,NX)/VOLA(L,NY,NX))
      ENDIF
      CC3=CAL1+CFE1
      CA3=CH0P1
      CC2=CCA1+CMG1+CALO1+CFEO1+CF2P1
      CA2=CSO41+CCO31+CH1P1
      CC1=CN41+CHY1+CNA1+CKA1+CALO2+CFEO2+CALS1+CFES1+CCAO1
     2+CCAH1+CMGO1+CMGH1+CF1P1+CC2P1
      CA1=CNO1+COH1+CHCO31+CCL1+CALO4+CFEO4+CNAC1+CNAS1+CKAS1
     2+CH2P1+CC0P1
      CN=CCO21+CCH41+COXY1+CZ2G1+CZ2O1+CN31+CALO3+CFEO3+CCAC1+CCAS1
     2+CMGC1+CMGS1+CH3P1+CC1P1+CM1P1
      CX2=CA2-CCO31
      CX1=CA1-CHCO31
3010  CONTINUE
C
C     INITIALIZE EQUILIBRIA BETWEEN SOLUBLE AND PRECIPITATED FORMS
C
      IF(K.EQ.3)THEN
      IF(CALZ.GE.0.0)THEN
      RPALOX=AMAX1(0.0,CALZ-(CAL1+CALO1+CALO2+CALO3+CALO4+CALS1))
      PALOH1=CALOHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)+RPALOX
      ELSE
      PALOH1=CALOHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      ENDIF
      IF(CFEZ.GE.0.0)THEN
      RPFEOX=AMAX1(0.0,CFEZ-(CFE1+CFEO1+CFEO2+CFEO3+CFEO4+CFES1))
      PFEOH1=CFEOHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)+RPFEOX
      ELSE
      PFEOH1=CFEOHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      ENDIF
      IF(CCAZ.GE.0.0)THEN
      RPCACX=AMAX1(0.0,CCAZ-(CCA1+CCAO1+CCAC1+CCAH1+CCAS1))
      PCACO1=CCACOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)+RPCACX
      ELSE
      PCACO1=CCACOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      ENDIF
      PCASO1=CCASOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)
      PALPO1=CALPOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      PFEPO1=CFEPOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      PCAPD1=CCAPDX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      PCAPH1=CCAPHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      PALPOB=CALPOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      PFEPOB=CFEPOX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      PCAPDB=CCAPDX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      PCAPHB=CCAPHX*BKVL(L,NY,NX)/VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      ENDIF
C
C     CONVERGE TOWARDS ALL SOLUBILITY EQUILIBRIA
C     IF SALT OPTION IS SELECTED
C
      IF(ISALT(NY,NX).NE.0)THEN
      DO 1000 M=1,500
      CN41=AMAX1(ZERO,CN41)
      CN31=AMAX1(ZERO,CN31)
      CAL1=AMAX1(ZERO,CAL1)
      CFE1=AMAX1(ZERO,CFE1)
      CHY1=AHY1/A1
      CCA1=AMAX1(ZERO,CCA1)
      CMG1=AMAX1(ZERO,CMG1)
      CNA1=AMAX1(ZERO,CNA1)
      CKA1=AMAX1(ZERO,CKA1)
      COH1=AOH1/A1
      CSO41=AMAX1(ZERO,CSO41)
      CCO21=AMAX1(ZERO,CCO21)
      CCO31=AMAX1(ZERO,CCO31)
      CHCO31=AMAX1(ZERO,CHCO31)
      CALO1=AMAX1(ZERO,CALO1)
      CALO2=AMAX1(ZERO,CALO2)
      CALO3=AMAX1(ZERO,CALO3)
      CALO4=AMAX1(ZERO,CALO4)
      CALS1=AMAX1(ZERO,CALS1)
      CFEO1=AMAX1(ZERO,CFEO1)
      CFEO2=AMAX1(ZERO,CFEO2)
      CFEO3=AMAX1(ZERO,CFEO3)
      CFEO4=AMAX1(ZERO,CFEO4)
      CFES1=AMAX1(ZERO,CFES1)
      CCAO1=AMAX1(ZERO,CCAO1)
      CCAC1=AMAX1(ZERO,CCAC1)
      CCAH1=AMAX1(ZERO,CCAH1)
      CCAS1=AMAX1(ZERO,CCAS1)
      CMGO1=AMAX1(ZERO,CMGO1)
      CMGC1=AMAX1(ZERO,CMGC1)
      CMGH1=AMAX1(ZERO,CMGH1)
      CMGS1=AMAX1(ZERO,CMGS1)
      CNAC1=AMAX1(ZERO,CNAC1)
      CNAS1=AMAX1(ZERO,CNAS1)
      CKAS1=AMAX1(ZERO,CKAS1)
      CH0P1=AMAX1(ZERO,CH0P1)
      CH1P1=AMAX1(ZERO,CH1P1)
      CH2P1=AMAX1(ZERO,CH2P1)
      CH3P1=AMAX1(ZERO,CH3P1)
      CF1P1=AMAX1(ZERO,CF1P1)
      CF2P1=AMAX1(ZERO,CF2P1)
      CC0P1=AMAX1(ZERO,CC0P1)
      CC1P1=AMAX1(ZERO,CC1P1)
      CC2P1=AMAX1(ZERO,CC2P1)
      CM1P1=AMAX1(ZERO,CM1P1)
C
C     ION ACTIVITY COEFFICIENTS
C
      CC3=CAL1+CFE1
      CA3=CH0P1
      CC2=CCA1+CMG1+CALO1+CFEO1+CF2P1
      CA2=CSO41+CCO31+CH1P1
      CC1=CN41+CHY1+CNA1+CKA1+CALO2+CFEO2+CALS1+CFES1+CCAO1
     2+CCAH1+CMGO1+CMGH1+CF1P1+CC2P1
      CA1=CNO1+COH1+CHCO31+CCL1+CALO4+CFEO4+CNAC1+CNAS1+CKAS1
     2+CH2P1+CC0P1
      CN=CCO21+CCH41+COXY1+CZ2G1+CZ2O1+CN31+CALO3+CFEO3+CCAC1+CCAS1
     2+CMGC1+CMGS1+CH3P1+CC1P1+CM1P1
      CX2=CA2-CCO31
      CX1=CA1-CHCO31
      CION1=ABS(3.0*(CC3-CA3)+2.0*(CC2-CA2)+CC1-CA1)
      CION2=AMAX1(0.0,CC3+CA3+CC2+CA2+CC1+CA1+CN+CION1)
      CSTR1=0.5E-03*(9.0*(CC3+CA3)+4.0*(CC2+CA2)+CC1+CA1+CION1)
      CSTRZ=0.5E-03*(9.0*(CC3+CA3)+4.0*(CC2+CX2)+CC1+CX1+CION1)
      CSTR2=SQRT(CSTR1)
      FSTR2=CSTR2/(1.0+CSTR2)
      FH2O=5.56E+04/(5.56E+04+CION2)
      A1=AMIN1(1.0,10.0**(-0.509*1.0*FSTR2+0.20*CSTR2))
      A2=AMIN1(1.0,10.0**(-0.509*4.0*FSTR2+0.20*CSTR2))
      A3=AMIN1(1.0,10.0**(-0.509*9.0*FSTR2+0.20*CSTR2))
      A12=A1**2
      A13=A1**3
      A14=A1**4
      A22=A2**2
      A25=A2**5
      A28=A2**8
      A2Q=A2**0.500
      A3C=A3**0.333
      A0A2=A0*A2
      A0A12=A0/A12
      A0A22=A0/A22
      A0A1A2=A0*A12*A2
      A1A2=A1*A2
      A1A2D=A1/A2
      A1A3=A1*A3
      A1A3D=A1/A3
      A12A2=A12*A2
      A12A2D=A12/A2
      A12A22=A12/A22
      A12A25=A12/A25
      A12A28=A12/A28
      A1202D=A12/A0A2
      A13A2=A13*A2
      A13A3=A13*A3
      A13A3D=A13/A3
      A14A0=A14/A0
      A14A2=A14*A2
      A14A2D=A14/A2
      A14A0A=A14/A0A2
      A14A5D=A14/A25
      A14A28=A14*A28
      A14A8D=A14/A28
      A1TA25=A1**10*A25
      A2A3=A2*A3
      A2A13D=A2/A1A3
      A1A2A3=A1*A2A3
      A1A23D=A1/A2A3
C
C     PRECIPITATION-DISSOLUTION EQILIBRIA
C
      IF(K.EQ.3)THEN
      AAL1=CAL1*A3
      AALO1=CALO1*A2
      AALO2=CALO2*A1
      AALO3=CALO3
      AALO4=CALO4*A1
      AFE1=CFE1*A3
      AFEO1=CFEO1*A2
      AFEO2=CFEO2*A1
      AFEO3=CFEO3
      AFEO4=CFEO4*A1
      ACO31=CCO31*A2
      AHCO31=CHCO31*A1
      ACO21=CCO21*A0
      AH1P1=CH1P1*A2
      AH2P1=CH2P1*A1
C
C     ALUMINUM HYDROXIDE (GIBBSITE)
C
      PX=AMAX1(AAL1,AALO1,AALO2,AALO3,AALO4)
      IF(PX.EQ.AAL1)THEN
      R2=CHY1
      P2=COH1
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=3
      SP=SYALO/A13A3
      ELSE
      NR2=3
      NP2=0
      SP=SHALO*A13A3D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      R2=CHY1
      P2=COH1
      P1=CALO1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=2
      SP=SYAL1/A12A2
      ELSE
      NR2=2
      NP2=0
      SP=SHAL1*A12A2D
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      R2=CHY1
      P2=COH1
      P1=CALO2
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=1
      SP=SYAL2/A12
      ELSE
      NR2=1
      NP2=0
      SP=SHAL2
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      R2=CHY1
      P2=COH1
      P1=CALO3
      NR2=0
      NP2=0
      SP=SPAL3
      ELSEIF(PX.EQ.AALO4)THEN
      R2=COH1
      P2=CHY1
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP2=0
      SP=SYAL4
      ELSE
      NR2=0
      NP2=1
      SP=SHAL4/A12
      ENDIF
      ENDIF
      RYAL1=0.0
      RYALO1=0.0
      RYALO2=0.0
      RYALO3=0.0
      RYALO4=0.0
      RHAL1=0.0
      RHALO1=0.0
      RHALO2=0.0
      RHALO3=0.0
      RHALO4=0.0
      X=0.0
      TX=0.0
      DO 1010 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      Z=(P1*P2**NP2/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1110
      IF(Z.LE.0.95.AND.PALOH1.LE.0.0)GO TO 1110
      Y=P1
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1010  CONTINUE
1110  CONTINUE
      RPALOX=AMAX1(-PALOH1,TPD*TX)
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYAL1=RPALOX
      ELSE
      RHAL1=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO1=RPALOX
      ELSE
      RHALO1=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO2=RPALOX
      ELSE
      RHALO2=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO3=RPALOX
      ELSE
      RHALO3=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO4=RPALOX
      ELSE
      RHALO4=RPALOX
      ENDIF
      ENDIF
C     WRITE(*,1112)'GIBB',K,L,M,MM,PALOH1,CAL1,CALO1,CALO2,CALO3,CALO4
C    2,COH1,R2,P1,P2,SP,Z,TX,RPALOX,RHAL1,RHALO1,RHALO2,RHALO3,RHALO4
C    3,CAL1*A3*(COH1*A1)**3,SYALO
C
C     IRON HYDROXIDE
C
      PX=AMAX1(AFE1,AFEO1,AFEO2,AFEO3,AFEO4)
      IF(PX.EQ.AFE1)THEN
      R2=CHY1
      P2=COH1
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=3
      SP=SYFEO/A13A3
      ELSE
      NR2=3
      NP2=0
      SP=SHFEO*A13A3D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=2
      SP=SYFE1/A12A2
      ELSE
      NR2=2
      NP2=0
      SP=SHFE1*A12A2D
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO2
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=1
      SP=SYFE2/A12
      ELSE
      NR2=1
      NP2=0
      SP=SHFE2
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO3
      NR2=0
      NP2=0
      SP=SPFE3
      ELSEIF(PX.EQ.AFEO4)THEN
      R2=COH1
      P2=CHY1
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP2=0
      SP=SYFE4
      ELSE
      NR2=0
      NP2=1
      SP=SHFE4/A12
      ENDIF
      ENDIF
      RYFE1=0.0
      RYFEO1=0.0
      RYFEO2=0.0
      RYFEO3=0.0
      RYFEO4=0.0
      RHFE1=0.0
      RHFEO1=0.0
      RHFEO2=0.0
      RHFEO3=0.0
      RHFEO4=0.0
      X=0.0
      TX=0.0
      DO 1020 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      Z=(P1*P2**NP2/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1120
      IF(Z.LE.0.95.AND.PFEOH1.LE.0.0)GO TO 1120
      Y=P1
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1020  CONTINUE
1120  CONTINUE
      RPFEOX=AMAX1(-PFEOH1,TPD*TX)
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFE1=RPFEOX
      ELSE
      RHFE1=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO1=RPFEOX
      ELSE
      RHFEO1=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO2=RPFEOX
      ELSE
      RHFEO2=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO3=RPFEOX
      ELSE
      RHFEO3=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO4=RPFEOX
      ELSE
      RHFEO4=RPFEOX
      ENDIF
      ENDIF
C     WRITE(*,1112)'IRON',K,L,M,MM,PFEOH1,CFE1,CFEO1,CFEO2,CFEO3,CFEO4
C    2,COH1,R2,P1,P2,SP,Z,TX,RPFEOX,RHFE1,RHFEO1,RHFEO2,RHFEO3,RHFEO4
C    3,CFE1*A3*(COH1*A1)**3,SYFEO
C
C     CALCITE AND GYPSUM
C
      PX=AMAX1(ACO31,AHCO31,ACO21)
      R2=CHY1
      P3=COH1

      P1=CCA1
      IF(PX.EQ.ACO31)THEN
      P2=CCO31
      NR2=0
      NP3=0
      SP=SPCAC/A22
      ELSEIF(PX.EQ.AHCO31)THEN
      P2=CHCO31
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=1
      SP=SYCAC1/A12A2
      ELSE
      NR2=1
      NP3=0
      SP=SHCAC1/A2
      ENDIF
      ELSEIF(PX.EQ.ACO21)THEN
      P2=CCO21
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=2
      SP=SYCAC2/A0A1A2
      ELSE
      NR2=2
      NP3=0
      SP=SHCAC2*A1202D
      ENDIF
      ENDIF
      RYCAC3=0.0
      RYCACH=0.0
      RYCACO=0.0
      RHCAC3=0.0
      RHCACH=0.0
      RHCACO=0.0
      X=0.0
      TX=0.0
      DO 1030 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      Z=(P1*P2*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1130
      IF(Z.LE.0.95.AND.PCACO1.LE.0.0)GO TO 1130
      Y=P1
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1030  CONTINUE
1130  CONTINUE
      RPCACX=AMAX1(-PCACO1,TPD*TX)
      IF(PX.EQ.ACO31)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAC3=RPCACX
      ELSE
      RHCAC3=RPCACX
      ENDIF
      ELSEIF(PX.EQ.AHCO31)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCACH=RPCACX
      ELSE
      RHCACH=RPCACX
      ENDIF
      ELSEIF(PX.EQ.ACO21)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCACO=RPCACX
      ELSE
      RHCACO=RPCACX
      ENDIF
      ENDIF
      SP=SPCAS/A22
      S0=CCA1+CSO41
      S1=S0**2-4.0*(CCA1*CSO41-SP)
      RPCASO=AMAX1(-PCASO1,TPD*0.5*(S0-SQRT(S1)))
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      AH1P1=CH1P1*A2
      AH2P1=CH2P1*A1
      PX=AMAX1(AAL1,AALO1,AALO2,AALO3,AALO4)
      PY=AMAX1(AH1P1,AH2P1)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1P1)THEN
      P2=CH1P1
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYA0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA1P1/A22
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYA4P1*A12A2D

      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHA4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2P1
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYA0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1

      SP=SYA1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA2P2/A12
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYA0P1=0.0

      RYA1P1=0.0
      RYA2P1=0.0
      RYA3P1=0.0
      RYA4P1=0.0
      RYA0P2=0.0
      RYA1P2=0.0
      RYA2P2=0.0
      RYA3P2=0.0
      RYA4P2=0.0
      RHA0P1=0.0
      RHA1P1=0.0
      RHA2P1=0.0
      RHA3P1=0.0
      RHA4P1=0.0
      RHA0P2=0.0
      RHA1P2=0.0
      RHA2P2=0.0
      RHA3P2=0.0
      RHA4P2=0.0
      X=0.0
      TX=0.0
      DO 1040 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1140
      IF(Z.LE.0.95.AND.PALPO1.LE.0.0)GO TO 1140
      Y=AMIN1(P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1040  CONTINUE
1140  CONTINUE
      RPALPX=AMAX1(-PALPO1,TPD*TX)
      IF(PY.EQ.AH1P1)THEN
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0P1=RPALPX
      ELSE
      RHA0P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1P1=RPALPX
      ELSE
      RHA1P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2P1=RPALPX
      ELSE
      RHA2P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3P1=RPALPX
      ELSE
      RHA3P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4P1=RPALPX
      ELSE
      RHA4P1=RPALPX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0P2=RPALPX
      ELSE
      RHA0P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1P2=RPALPX
      ELSE
      RHA1P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2P2=RPALPX
      ELSE
      RHA2P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3P2=RPALPX
      ELSE
      RHA3P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4P2=RPALPX
      ELSE
      RHA4P2=RPALPX
      ENDIF
      ENDIF
      ENDIF
C     WRITE(*,1112)'ALPO4',K,L,M,MM,PALPO1,CAL1,CALO1,CALO2,CALO3,CALO4
C    2,CH1P1,CH2P1,CHY1,COH1,RPALPX,RHA0P1,RHA1P1,RHA2P1,RHA3P1,RHA4P1
C    3,RHA0P2,RHA1P2,RHA2P2,RHA3P2,RHA4P2,R3,R4,P3,P4,SP,Z,TX,A1,A2,A3
1112  FORMAT(A8,4I4,40E12.4)
C
C     IRON PHOSPHATE (STRENGITE)
C
      PX=AMAX1(AFE1,AFEO1,AFEO2,AFEO3,AFEO4)
      PY=AMAX1(AH1P1,AH2P1)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1P1)THEN
      P2=CH1P1
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF1P1/A22
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYF4P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHF4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2P1
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYF0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF2P2/A12
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYF0P1=0.0
      RYF1P1=0.0
      RYF2P1=0.0
      RYF3P1=0.0
      RYF4P1=0.0
      RYF0P2=0.0
      RYF1P2=0.0
      RYF2P2=0.0
      RYF3P2=0.0
      RYF4P2=0.0
      RHF0P1=0.0
      RHF1P1=0.0
      RHF2P1=0.0
      RHF3P1=0.0
      RHF4P1=0.0
      RHF0P2=0.0
      RHF1P2=0.0
      RHF2P2=0.0
      RHF3P2=0.0
      RHF4P2=0.0
      X=0.0
      TX=0.0
      DO 1050 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1150
      IF(Z.LE.0.95.AND.PFEPO1.LE.0.0)GO TO 1150
      Y=AMIN1(P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1050  CONTINUE
1150  CONTINUE
      RPFEPX=AMAX1(-PFEPO1,TPD*TX)
      IF(PY.EQ.AH1P1)THEN
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0P1=RPFEPX
      ELSE
      RHF0P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1P1=RPFEPX
      ELSE
      RHF1P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2P1=RPFEPX
      ELSE
      RHF2P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3P1=RPFEPX
      ELSE
      RHF3P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4P1=RPFEPX
      ELSE
      RHF4P1=RPFEPX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0P2=RPFEPX
      ELSE
      RHF0P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1P2=RPFEPX
      ELSE
      RHF1P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2P2=RPFEPX
      ELSE
      RHF2P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3P2=RPFEPX
      ELSE
      RHF3P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4P2=RPFEPX
      ELSE
      RHF4P2=RPFEPX
      ENDIF
      ENDIF
      ENDIF
C
C     DICALCIUM PHOSPHATE
C
      PX=AMAX1(AH1P1,AH2P1)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1P1)THEN
      P2=CH1P1
      NR2=0
      NP3=0
      SP=SPCAD/A22
      ELSEIF(PX.EQ.AH2P1)THEN
      P2=CH2P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=1
      SP=SYCAD2/A12A2
      ELSE
      NR2=1
      NP3=0
      SP=SHCAD2/A2
      ENDIF
      ENDIF
      RPCAD1=0.0
      RYCAD2=0.0
      RHCAD2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR2+NP3)
      DO 1060 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1160
      IF(Z.LE.0.95.AND.PCAPD1.LE.0.0)GO TO 1160
      Y=AMIN1(P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.50
      ELSE
      X=Y*Z**0.50-Y
      ENDIF
      TX=TX+X
1060  CONTINUE
1160  CONTINUE
      RPCADX=AMAX1(-PCAPD1,TPD*TX)
      IF(PX.EQ.AH1P1)THEN
      RPCAD1=RPCADX
      ELSEIF(PX.EQ.AH2P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAD2=RPCADX
      ELSE
      RHCAD2=RPCADX
      ENDIF
      ENDIF
C     WRITE(*,1112)'CAPO4',K,L,M,MM,PCAPD1,CCA1
C    2,CH1P1,CH2P1,CHY1,RPCADX,RPCAD1,RYCAD2,RHCAD2,R2,P1,P2,P3
C    3,SP,Z,CCA1*A2*CH1P1*A2,SPCAD
C
C     HYDROXYAPATITE
C
      PX=AMAX1(AH1P1,AH2P1)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1P1)THEN
      P2=CH1P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=4
      SP=SYCAH1/A14A28
      ELSE
      NR2=4
      NP3=0
      SP=SHCAH1*A14A8D
      ENDIF
      ELSEIF(PX.EQ.AH2P1)THEN
      P2=CH2P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=7
      SP=SYCAH2/A1TA25
      ELSE
      NR2=7
      NP3=0
      SP=SHCAH2*A14A5D
      ENDIF
      ENDIF
      RYCAH1=0.0
      RYCAH2=0.0
      RHCAH1=0.0
      RHCAH2=0.0
      X=0.0
      TX=0.0
      DO 1070 MM=1,100
      P1=AMAX1(ZERO,P1-5.0*X)
      P2=AMAX1(ZERO,P2-3.0*X)
      Z=(P1**5*P2**3*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1170
      IF(Z.LE.0.95.AND.PCAPH1.LE.0.0)GO TO 1170
      Y=AMIN1(P1/5,P2/3)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.125
      ELSE
      X=Y*Z**0.125-Y
      ENDIF
      TX=TX+X
1070  CONTINUE
1170  CONTINUE
      RPCAHX=AMAX1(-PCAPH1,TPD*TX)
      IF(PX.EQ.AH1P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAH1=RPCAHX
      ELSE
      RHCAH1=RPCAHX
      ENDIF
      ELSEIF(PX.EQ.AH2P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAH2=RPCAHX
      ELSE
      RHCAH2=RPCAHX
      ENDIF
      ENDIF
C     WRITE(*,1112)'APATITE',K,L,M,MM,PCAPH1,CCA1
C    2,CH1P1,CH2P1,CHY1,RPCAHX,RHCAH1,RHCAH2,R2,P1,P2,P3
C    3,SP,Z,(CCA1*A2)**5*(CH0P1*A3)**3*COH1*A1,SPCAH
      PALOH1=PALOH1+RPALOX
      PFEOH1=PFEOH1+RPFEOX
      PCACO1=PCACO1+RPCACX
      PCASO1=PCASO1+RPCASO
      PALPO1=PALPO1+RPALPX
      PFEPO1=PFEPO1+RPFEPX
      PCAPD1=PCAPD1+RPCADX
      PCAPH1=PCAPH1+RPCAHX
C
C     ANION EXCHANGE EQILIBRIA
C
      DCHG=AMAX1(-0.1E+05,XOH21-XOH01-XH1P1)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
C
C     PROTONATION OF EXCHANGE SITES
C
      SPOH2=SXOH2*AEP/A1
      X0=XOH11+CHY1+SPOH2
      X1=X0**2-4.0*(XOH11*CHY1-SPOH2*XOH21)
      RXOH2=TAD*0.5*(X0-SQRT(X1))
      SPOH1=SXOH1/(AEN*A1)
      X0=XOH01+CHY1+SPOH1
      X1=X0**2-4.0*(XOH01*CHY1-SPOH1*XOH11)
      RXOH1=TAD*0.5*(X0-SQRT(X1))
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP*A1)
      X0=XOH21+CH2P1+SPH2P
      X1=X0**2-4.0*(XOH21*CH2P1-SPH2P*XH2P1)
      RXH2P=TAD*0.5*(X0-SQRT(X1))
C
C     H2PO4 EXCHANGE
C
      R1=XH2P1
      R2=COH1
      P1=XOH11
      P2=CH2P1
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH2P
      ELSE
      NR2=0
      NP3=1
      SP=SHH2P/A12
      ENDIF
      RYH2P=0.0
      RHH2P=0.0
      X=0.0
      TX=0.0
      DO 4010 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 4110
      Y=AMIN1(R1,P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.33
      ELSE
      X=Y*Z**0.33-Y
      ENDIF
      TX=TX+X
4010  CONTINUE
4110  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH2P=TAD*TX
      ELSE
      RHH2P=TAD*TX
      ENDIF
C
C     HPO4 EXCHANGE
C
      R1=XH1P1
      R2=COH1
      P1=XOH11
      P2=CH1P1
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH1P*AEN*A1A2D
      ELSE
      NR2=0
      NP3=1
      SP=SHH1P*AEN/A1A2
      ENDIF
      RYH1P=0.0
      RHH1P=0.0
      X=0.0
      TX=0.0
      DO 4020 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 4120
      Y=AMIN1(R1,P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.33
      ELSE
      X=Y*Z**0.33-Y
      ENDIF
      TX=TX+X
4020  CONTINUE
4120  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH1P=TAD*TX
      ELSE
      RHH1P=TAD*TX
      ENDIF
      XOH01=XOH01-RXOH1
      XOH11=XOH11+RXOH1-RXOH2-RYH2P-RYH1P-RHH2P-RHH1P
      XOH21=XOH21+RXOH2-RXH2P
      XH1P1=XH1P1+RYH1P+RHH1P
      XH2P1=XH2P1+RXH2P+RYH2P+RHH2P
C
C     CATION EXCHANGE
C
      CHYX=CHY1
      CN4X=CN41
      CALX=CAL1**0.333
      CCAX=CCA1**0.500
      CMGX=CMG1**0.500
      CNAX=CNA1
      CKAX=CKA1
      A2Q=A2**0.500
      A3C=A3**0.333
      A1A2QD=A1/A2Q
      GKC4X=GKC4(L,NY,NX)*A1A2QD
      GKCHX=GKCH(L,NY,NX)*A1A2QD
      GKCAX=GKCA(L,NY,NX)*A3C/A2Q
      GKCMX=GKCM(L,NY,NX)
      GKCNX=GKCN(L,NY,NX)*A1A2QD
      GKCKX=GKCK(L,NY,NX)*A1A2QD
      XCAQ=XCECQ/(1.0+GKC4X*CN4X/CCAX+GKCHX*CHYX/CCAX+GKCAX*CALX/CCAX
     3+GKCMX*CMGX/CCAX+GKCNX*CNAX/CCAX+GKCKX*CKAX/CCAX)
      FCAQ=XCAQ/CCAX
      FN4Q=FCAQ*GKC4X
      RXN4=TSL*(FN4Q*CN41-XN4Q)/(1.0+FN4Q)
      XN4Q=XN4Q+RXN4
      XHYQ=FCAQ*GKCHX*CHYX
      XALQ=FCAQ*GKCAX*CALX
      XMGQ=FCAQ*GKCMX*CMGX
      XNAQ=FCAQ*GKCNX*CNAX
      XKAQ=FCAQ*GKCKX*CKAX
      XTLQ=XHYQ+XALQ+XCAQ+XMGQ+XNAQ+XKAQ
      IF(XTLQ.GT.ZERO)THEN
      FB=(XCECQ-XN4Q)/XTLQ
      ELSE
      FB=0.0
      ENDIF
      XHYQ=FB*XHYQ
      XALQ=FB*XALQ
      XCAQ=FB*XCAQ
      XMGQ=FB*XMGQ
      XNAQ=FB*XNAQ
      XKAQ=FB*XKAQ
C
C     ORGANIC MATTER
C
      DP=DPCOH*DPALO/A1**2
      XHC1=CHY1*(XCOOH-XALO21)/(CHY1+DPCOH/A1)
      XALO21=CALO2*(XCOOH-XHC1)/(CALO2+DPALO/A1)
      XCOO=AMAX1(0.0,XCOOH-XHC1-XALO21)
      ELSE
      RYAL1=0.0
      RYALO1=0.0
      RYALO2=0.0
      RYALO3=0.0
      RYALO4=0.0
      RHAL1=0.0
      RHALO1=0.0
      RHALO2=0.0
      RHALO3=0.0
      RHALO4=0.0
      RYFE1=0.0
      RYFEO1=0.0
      RYFEO2=0.0
      RYFEO3=0.0
      RYFEO4=0.0
      RHFE1=0.0
      RHFEO1=0.0
      RHFEO2=0.0
      RHFEO3=0.0
      RHFEO4=0.0
      RYCAC3=0.0
      RYCACH=0.0
      RYCACO=0.0
      RHCAC3=0.0
      RHCACH=0.0
      RHCACO=0.0
      RPCACX=0.0
      RPCASO=0.0
      RPCADX=0.0
      RPCAHX=0.0
      RYA0P1=0.0
      RYA1P1=0.0
      RYA2P1=0.0
      RYA3P1=0.0
      RYA4P1=0.0
      RYA0P2=0.0
      RYA1P2=0.0
      RYA2P2=0.0
      RYA3P2=0.0
      RYA4P2=0.0
      RHA0P1=0.0
      RHA1P1=0.0
      RHA2P1=0.0
      RHA3P1=0.0
      RHA4P1=0.0
      RHA0P2=0.0
      RHA1P2=0.0
      RHA2P2=0.0
      RHA3P2=0.0
      RHA4P2=0.0
      RYF0P1=0.0
      RYF1P1=0.0
      RYF2P1=0.0
      RYF3P1=0.0
      RYF4P1=0.0
      RYF0P2=0.0
      RYF1P2=0.0
      RYF2P2=0.0
      RYF3P2=0.0
      RYF4P2=0.0
      RHF0P1=0.0
      RHF1P1=0.0
      RHF2P1=0.0
      RHF3P1=0.0
      RHF4P1=0.0
      RHF0P2=0.0
      RHF1P2=0.0
      RHF2P2=0.0
      RHF3P2=0.0
      RHF4P2=0.0
      RPCAD1=0.0
      RYCAD2=0.0
      RHCAD2=0.0
      RYCAH1=0.0
      RYCAH2=0.0
      RHCAH1=0.0
      RHCAH2=0.0
      RXN4=0.0
      RXOH2=0.0
      RXOH1=0.0
      RXH2P=0.0
      RYH2P=0.0
      RYH1P=0.0
      RHH2P=0.0
      RHH1P=0.0
      ENDIF
C
C     ION SPECIATION
C
      DP=DPN4/A0
      S0=CHY1+CN31+DP
      S1=S0**2-4.0*(CHY1*CN31-DP*CN41)
      RNH4=TSL*(S0-SQRT(S1))
      DP=DPAL1*A2A13D
      S0=CAL1+COH1+DP
      S1=S0**2-4.0*(CAL1*COH1-DP*CALO1)
      RALO1=TSL*(S0-SQRT(S1))
      DP=DPAL2/A2
      S0=CALO1+COH1+DP
      S1=S0**2-4.0*(CALO1*COH1-DP*CALO2)
      RALO2=TSL*(S0-SQRT(S1))
      DP=DPAL3*A0A12
      S0=CALO2+COH1+DP
      S1=S0**2-4.0*(CALO2*COH1-DP*CALO3)
      RALO3=TSL*(S0-SQRT(S1))
      DP=DPAL4/A0
      S0=CALO3+COH1+DP
      S1=S0**2-4.0*(CALO3*COH1-DP*CALO4)
      RALO4=TSL*(S0-SQRT(S1))
      DP=DPALS*A1A23D
      S0=CAL1+CSO41+DP
      S1=S0**2-4.0*(CAL1*CSO41-DP*CALS1)
      RALS=TSL*(S0-SQRT(S1))
      DP=DPFE1*A2A13D
      S0=CFE1+COH1+DP
      S1=S0**2-4.0*(CFE1*COH1-DP*CFEO1)
      RFEO1=TSL*(S0-SQRT(S1))
      DP=DPFE2/A2
      S0=CFEO1+COH1+DP
      S1=S0**2-4.0*(CFEO1*COH1-DP*CFEO2)
      RFEO2=TSL*(S0-SQRT(S1))
      DP=DPFE3*A0A12
      S0=CFEO2+COH1+DP
      S1=S0**2-4.0*(CFEO2*COH1-DP*CFEO3)
      RFEO3=TSL*(S0-SQRT(S1))
      DP=DPFE4/A0
      S0=CFEO3+COH1+DP
      S1=S0**2-4.0*(CFEO3*COH1-DP*CFEO4)
      RFEO4=TSL*(S0-SQRT(S1))
      DP=DPFES*A1A23D
      S0=CFE1+CSO41+DP
      S1=S0**2-4.0*(CFE1*CSO41-DP*CFES1)
      RFES=TSL*(S0-SQRT(S1))
      DP=DPCAO/A2
      S0=CCA1+COH1+DP
      S1=S0**2-4.0*(CCA1*COH1-DP*CCAO1)
      RCAO=TSL*(S0-SQRT(S1))
      DP=DPCAC*A0A22
      S0=CCA1+CCO31+DP
      S1=S0**2-4.0*(CCA1*CCO31-DP*CCAC1)
      RCAC=TSL*(S0-SQRT(S1))

      DP=DPCAH/A2
      S0=CCA1+CHCO31+DP
      S1=S0**2-4.0*(CCA1*CHCO31-DP*CCAH1)
      RCAH=TSL*(S0-SQRT(S1))
      DP=DPCAS*A0A22
      S0=CCA1+CSO41+DP
      S1=S0**2-4.0*(CCA1*CSO41-DP*CCAS1)
      RCAS=TSL*(S0-SQRT(S1))
      DP=DPMGO/A2
      S0=CMG1+COH1+DP
      S1=S0**2-4.0*(CMG1*COH1-DP*CMGO1)
      RMGO=TSL*(S0-SQRT(S1))
      DP=DPMGC*A0A22
      S0=CMG1+CCO31+DP
      S1=S0**2-4.0*(CMG1*CCO31-DP*CMGC1)
      RMGC=TSL*(S0-SQRT(S1))
      DP=DPMGH/A2
      S0=CMG1+CHCO31+DP
      S1=S0**2-4.0*(CMG1*CHCO31-DP*CMGH1)
      RMGH=TSL*(S0-SQRT(S1))
      DP=DPMGS*A0A22
      S0=CMG1+CSO41+DP
      S1=S0**2-4.0*(CMG1*CSO41-DP*CMGS1)
      RMGS=TSL*(S0-SQRT(S1))
      DP=DPNAC/A2
      S0=CNA1+CCO31+DP
      S1=S0**2-4.0*(CNA1*CCO31-DP*CNAC1)
      RNAC=TSL*(S0-SQRT(S1))
      DP=DPNAS/A2
      S0=CNA1+CSO41+DP
      S1=S0**2-4.0*(CNA1*CSO41-DP*CNAS1)
      RNAS=TSL*(S0-SQRT(S1))
      DP=DPKAS/A2
      S0=CKA1+CSO41+DP
      S1=S0**2-4.0*(CKA1*CSO41-DP*CKAS1)
      RKAS=TSL*(S0-SQRT(S1))
      DP=DPH1P*A2A13D
      S0=CH0P1+CHY1+DP
      S1=S0**2-4.0*(CH0P1*CHY1-DP*CH1P1)
      RH1P=TSL*(S0-SQRT(S1))
      DP=DPH2P/A2
      S0=CH1P1+CHY1+DP
      S1=S0**2-4.0*(CH1P1*CHY1-DP*CH2P1)
      RH2P=TSL*(S0-SQRT(S1))

      DP=DPH3P*A0A12
      S0=CH2P1+CHY1+DP
      S1=S0**2-4.0*(CH2P1*CHY1-DP*CH3P1)
      RH3P=TSL*(S0-SQRT(S1))
      DP=DPF1P*A1A23D
      S0=CFE1+CH1P1+DP
      S1=S0**2-4.0*(CFE1*CH1P1-DP*CF1P1)
      RF1P=TSL*(S0-SQRT(S1))
      DP=DPF2P*A2A13D
      S0=CFE1+CH2P1+DP
      S1=S0**2-4.0*(CFE1*CH2P1-DP*CF2P1)
      RF2P=TSL*(S0-SQRT(S1))
      DP=DPC0P*A1A23D
      S0=CCA1+CH0P1+DP
      S1=S0**2-4.0*(CCA1*CH0P1-DP*CC0P1)
      RC0P=TSL*(S0-SQRT(S1))
      DP=DPC1P*A0A22
      S0=CCA1+CH1P1+DP
      S1=S0**2-4.0*(CCA1*CH1P1-DP*CC1P1)
      RC1P=TSL*(S0-SQRT(S1))
      DP=DPC2P/A2
      S0=CCA1+CH2P1+DP
      S1=S0**2-4.0*(CCA1*CH2P1-DP*CC2P1)
      RC2P=TSL*(S0-SQRT(S1))
      DP=DPM1P*A0A22
      S0=CMG1+CH1P1+DP
      S1=S0**2-4.0*(CMG1*CH1P1-DP*CM1P1)
      RM1P=TSL*(S0-SQRT(S1))
C
C     TOTAL ION FLUX FOR EACH ION SPECIES
C
      RN4S=RNH4-RXN4
      RN3S=-RNH4
      RAL=-RYAL1-RHAL1-RYA0P1-RHA0P1-RYA0P2-RHA0P2-RALO1-RALS
      RFE=-RYFE1-RHFE1-RYF0P1-RHF0P1-RYF0P2-RHF0P2-RFEO1-RFES
     2-RF1P-RF2P
      RCA=-RPCACX-RPCASO-RPCADX-5.0*RPCAHX
     2-RCAO-RCAC-RCAH-RCAS-RC0P-RC1P-RC2P
      RMG=-RMGO-RMGC-RMGH-RMGS-RM1P
      RNA=-RNAC-RNAS
      RKA=-RKAS
      RSO4=-RPCASO-RALS-RFES-RCAS-RMGS-RNAS-RKAS
      RAL1=-RYALO1-RHALO1-RYA1P1-RHA1P1-RYA1P2-RHA1P2+RALO1-RALO2
      RAL2=-RYALO2-RHALO2-RYA2P1-RHA2P1-RYA2P2-RHA2P2+RALO2-RALO3
      RAL3=-RYALO3-RHALO3-RYA3P1-RHA3P1-RYA3P2-RHA3P2+RALO3-RALO4
      RAL4=-RYALO4-RHALO4-RYA4P1-RHA4P1-RYA4P2-RHA4P2+RALO4
      RFE1=-RYFEO1-RHFEO1-RYF1P1-RHF1P1-RYF1P2-RHF1P2+RFEO1-RFEO2
      RFE2=-RYFEO2-RHFEO2-RYF2P1-RHF2P1-RYF2P2-RHF2P2+RFEO2-RFEO3
      RFE3=-RYFEO3-RHFEO3-RYF3P1-RHF3P1-RYF3P2-RHF3P2+RFEO3-RFEO4
      RFE4=-RYFEO4-RHFEO4-RYF4P1-RHF4P1-RYF4P2-RHF4P2+RFEO4
      RHP0=-RH1P-RC0P
      RHP1=-RYA0P1-RHA0P1-RYA1P1-RHA1P1-RYA2P1-RHA2P1-RYA3P1-RHA3P1
     2-RYA4P1-RHA4P1-RYF0P1-RHF0P1-RYF1P1-RHF1P1-RYF2P1-RHF2P1-RYF3P1
     3-RHF3P1-RYF4P1-RHF4P1-RPCAD1-3.0*(RYCAH1+RHCAH1)-RYH1P-RHH1P
     4+RH1P-RH2P-RF1P-RC1P-RM1P
      RHP2=-RYA0P2-RHA0P2-RYA1P2-RHA1P2-RYA2P2-RHA2P2-RYA3P2-RHA3P2
     2-RYA4P2-RHA4P2-RYF0P2-RHF0P2-RYF1P2-RHF1P2-RYF2P2-RHF2P2-RYF3P2
     3-RHF3P2-RYF4P2-RHF4P2-RHCAD2-RYCAD2-3.0*(RYCAH2+RHCAH2)
     4-RXH2P-RYH2P-RHH2P+RH2P-RH3P-RF2P-RC2P
      RHP3=RH3P
C
C     ION CONCENTRATIONS
C
      CCO2X=CCO2M*SCO2X/(EXP(ACO2X*CSTRZ))*EXP(0.843-0.0281*ATCA(NY,NX))*FH2O
      CCO2Y=LOG(CCO2X)
      CCO2Z=ABS(CCO2Y)
      CCO21=CCO2X
      FCO3=DPCO3*A0/(AHY1**2*A2)
      FHCO=DPCO2*A0/(AHY1*A1)
      Z=ACO2X*(2.0E-03*FCO3+0.5E-03*FHCO)
      DO 2120 MM=1,25
      R=(LOG(CCO21)+Z*CCO21-CCO2Y)/CCO2Z
      IF(R.LT.1.0E-03)GO TO 2130
      CCO21=CCO21/SQRT(1.0+R)
2120  CONTINUE
2130  CONTINUE
      CCH41=CCH4M*SCH4X/(EXP(ACH4X*CSTR1))*EXP(0.597-0.0199*ATCA(NY,NX))*FH2O
      COXY1=COXYM*SOXYX/(EXP(AOXYX*CSTR1))*EXP(0.516-0.0172*ATCA(NY,NX))*FH2O
      CZ2G1=CZ2GM*SN2GX/(EXP(AN2GX*CSTR1))*EXP(0.456-0.0152*ATCA(NY,NX))*FH2O
      CZ2O1=CZ2OM*SN2OX/(EXP(AN2OX*CSTR1))*EXP(0.897-0.0299*ATCA(NY,NX))*FH2O
      CN41=CN41+RN4S
      CN31=CN31+RN3S
C     CAL1=CAL1+RAL
C     CFE1=CFE1+RFE
C     CCA1=CCA1+RCA
C     CMG1=CMG1+RMG
C     CNA1=CNA1+RNA
C     CKA1=CKA1+RKA
C     CSO41=CSO41+RSO4
      CHY1=AHY1/A1
      COH1=AOH1/A1
      CCO31=CCO21*DPCO3*A0/(AHY1**2*A2)
      CHCO31=CCO21*DPCO2*A0/(AHY1*A1)
      CALO1=CALO1+RAL1
      CALO2=CALO2+RAL2
      CALO3=CALO3+RAL3
      CALO4=CALO4+RAL4
      CALS1=CALS1+RALS
      CFEO1=CFEO1+RFE1
      CFEO2=CFEO2+RFE2
      CFEO3=CFEO3+RFE3
      CFEO4=CFEO4+RFE4
      CFES1=CFES1+RFES
      CCAO1=CCAO1+RCAO
      CCAC1=CCAC1+RCAC
      CCAH1=CCAH1+RCAH
      CCAS1=CCAS1+RCAS
      CMGO1=CMGO1+RMGO
      CMGC1=CMGC1+RMGC
      CMGH1=CMGH1+RMGH
      CMGS1=CMGS1+RMGS
      CNAC1=CNAC1+RNAC
      CNAS1=CNAS1+RNAS
      CKAS1=CKAS1+RKAS
      CH0P1=CH0P1+RHP0
      CH1P1=CH1P1+RHP1
      CH2P1=CH2P1+RHP2
      CH3P1=CH3P1+RHP3
      CF1P1=CF1P1+RF1P
      CF2P1=CF2P1+RF2P
      CC0P1=CC0P1+RC0P
      CC1P1=CC1P1+RC1P
      CC2P1=CC2P1+RC2P
      CM1P1=CM1P1+RM1P
1000  CONTINUE
      ELSE
C
C     CONVERGE TOWARDS ALL SOLUBILITY EQUILIBRIA
C     IF SALT OPTION IS NOT SELECTED
C
      DO 1100 M=1,500
      CAL1=AMAX1(ZERO,CAL1)
      CFE1=AMAX1(ZERO,CFE1)
      CHY1=AHY1/A1
      CCA1=AMAX1(ZERO,CCA1)
      COH1=AOH1/A1
      CH2P1=AMAX1(ZERO,CH2P1)
C
C     PRECIPITATION-DISSOLUTION FLUXES
C
      IF(K.EQ.3)THEN
      CH2PA=SYA0P2/(CAL1*COH1**2)
      RPALPX=AMAX1(-PALPO1,TPD*(CH2P1-CH2PA))
      CH2PF=SYF0P2/(CFE1*COH1**2)
      RPFEPX=AMAX1(-PFEPO1,TPD*(CH2P1-CH2PF))
      CH2PD=SYCAD2/(CCA1*COH1)
      RPCADX=AMAX1(-PCAPD1,TPD*(CH2P1-CH2PD))
      CH2PH=(SYCAH2/(CCA1**5*COH1**7))**0.333
      RPCAHX=AMAX1(-PCAPH1,TPD*(CH2P1-CH2PH))
      PALPO1=PALPO1+RPALPX

      PFEPO1=PFEPO1+RPFEPX
      PCAPD1=PCAPD1+RPCADX
      PCAPH1=PCAPH1+RPCAHX
C
C     ANION EXCHANGE FLUXES
C
      DCHG=AMAX1(-0.1E+05,XOH21-XOH01-XH1P1)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP)
      X0=XOH21+CH2P1+SPH2P
      X1=AMAX1(0.0,X0**2-4.0*(XOH21*CH2P1-SPH2P*XH2P1))
      RXH2P=TAD*0.5*(X0-SQRT(X1))
C
C     H2PO4 EXCHANGE
C
      R1=XH2P1
      R2=COH1
      P1=XOH11
      P2=CH2P1
      X=0.0
      TX=0.0
      DO 6010 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      Z=(P1*P2/(R1*R2))/SYH2P
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 6110
      Y=AMIN1(R1,P1,P2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.33
      ELSE
      X=Y*Z**0.33-Y
      ENDIF
      TX=TX+X
6010  CONTINUE
6110  CONTINUE
      RYH2P=TAD*TX
      SPH1P=SYH1P*DPH2O*AEN/DPH2P
      X0=XOH11+CH2P1+SPH1P
      X1=AMAX1(0.0,X0**2-4.0*(XOH11*CH2P1-SPH1P*XH1P1))
      RXH1P=TAD*0.5*(X0-SQRT(X1))
      XOH11=XOH11-RYH2P-RXH1P
      XOH21=XOH21-RXH2P
      XH1P1=XH1P1+RXH1P
      XH2P1=XH2P1+RXH2P+RYH2P
C
C     CATION EXCHANGE
C
      CHYX=CHY1
      CN4X=CN41
      CALX=CAL1**0.333
      CCAX=CCA1**0.500
      XCAQ=XCECQ/(1.0+GKC4(L,NY,NX)*CN4X/CCAX+GKCH(L,NY,NX)*CHYX/CCAX
     2+GKCA(L,NY,NX)*CALX/CCAX)
      FCAQ=XCAQ/CCAX
      FN4Q=FCAQ*GKC4(L,NY,NX)
      RXN4=TSL*(FN4Q*CN41-XN4Q)/(1.0+FN4Q)
      XN4Q=XN4Q+RXN4
      ELSE
      RPALPX=0.0
      RPFEPX=0.0
      RPCADX=0.0
      RPCAHX=0.0
      RXH2P=0.0
      RYH2P=0.0
      RXH1P=0.0
      RXN4=0.0
      ENDIF
C
C     ION SPECIATION
C
      S0=CHY1+CN31+DPN4
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*CN31-DPN4*CN41))
      RNH4=TSL*(S0-SQRT(S1))
C
C     ION FLUXES
C
      RN4S=RNH4-RXN4
      RN3S=-RNH4
      RHP2=-RXH2P-RYH2P-RXH1P-RPALPX-RPFEPX-RPCADX-3.0*RPCAHX
      CN41=CN41+RN4S
      CN31=CN31+RN3S
      CH2P1=CH2P1+RHP2
1100  CONTINUE
      ENDIF
C
C     SOLUTE CONCENTRATIONS IN PRECIPITATION
C
      IF(K.EQ.1.AND.I.EQ.1.AND.L.EQ.1)THEN
      CCOR(NY,NX)=CCO21
      CCHR(NY,NX)=CCH41
      COXR(NY,NX)=COXY1
      CNNR(NY,NX)=CZ2G1
      CN2R(NY,NX)=CZ2O1
      CN4R(NY,NX)=CN41
      CN3R(NY,NX)=CN31
      CALR(NY,NX)=CAL1
      CFER(NY,NX)=CFE1
      CHYR(NY,NX)=CHY1
      CCAR(NY,NX)=CCA1
      CMGR(NY,NX)=CMG1
      CNAR(NY,NX)=CNA1
      CKAR(NY,NX)=CKA1
      COHR(NY,NX)=COH1
      CSOR(NY,NX)=CSO41
      CCLR(NY,NX)=CCL1
      CC3R(NY,NX)=CCO31
      CHCR(NY,NX)=CHCO31
      CAL1R(NY,NX)=CALO1
      CAL2R(NY,NX)=CALO2
      CAL3R(NY,NX)=CALO3
      CAL4R(NY,NX)=CALO4
      CALSR(NY,NX)=CALS1
      CFE1R(NY,NX)=CFEO1
      CFE2R(NY,NX)=CFEO2
      CFE3R(NY,NX)=CFEO3
      CFE4R(NY,NX)=CFEO4
      CFESR(NY,NX)=CFES1
      CCAOR(NY,NX)=CCAO1
      CCACR(NY,NX)=CCAC1
      CCAHR(NY,NX)=CCAH1
      CCASR(NY,NX)=CCAS1
      CMGOR(NY,NX)=CMGO1
      CMGCR(NY,NX)=CMGC1
      CMGHR(NY,NX)=CMGH1
      CMGSR(NY,NX)=CMGS1
      CNACR(NY,NX)=CNAC1
      CNASR(NY,NX)=CNAS1
      CKASR(NY,NX)=CKAS1
      CH0PR(NY,NX)=CH0P1
      CH1PR(NY,NX)=CH1P1
      CPOR(NY,NX)=CH2P1
      CH3PR(NY,NX)=CH3P1
      CF1PR(NY,NX)=CF1P1
      CF2PR(NY,NX)=CF2P1
      CC0PR(NY,NX)=CC0P1
      CC1PR(NY,NX)=CC1P1
      CC2PR(NY,NX)=CC2P1
      CM1PR(NY,NX)=CM1P1
      CSTRR(NY,NX)=CSTR1
C
C     SOLUTE CONCENTRATIONS IN IRRIGATION
C
      ELSEIF(K.EQ.2.AND.L.EQ.1)THEN
      CCOQ(NY,NX)=CCO21
      CCHQ(NY,NX)=CCH41
      COXQ(NY,NX)=COXY1
      CNNQ(NY,NX)=CZ2G1
      CN2Q(NY,NX)=CZ2O1
      CN4Q(I,NY,NX)=CN41
      CN3Q(I,NY,NX)=CN31
      CALQ(I,NY,NX)=CAL1
      CFEQ(I,NY,NX)=CFE1
      CHYQ(I,NY,NX)=CHY1
      CCAQ(I,NY,NX)=CCA1
      CMGQ(I,NY,NX)=CMG1
      CNAQ(I,NY,NX)=CNA1
      CKAQ(I,NY,NX)=CKA1
      COHQ(I,NY,NX)=COH1
      CSOQ(I,NY,NX)=CSO41
      CCLQ(I,NY,NX)=CCL1
      CC3Q(I,NY,NX)=CCO31
      CHCQ(I,NY,NX)=CHCO31
      CAL1Q(I,NY,NX)=CALO1
      CAL2Q(I,NY,NX)=CALO2
      CAL3Q(I,NY,NX)=CALO3
      CAL4Q(I,NY,NX)=CALO4
      CALSQ(I,NY,NX)=CALS1
      CFE1Q(I,NY,NX)=CFEO1
      CFE2Q(I,NY,NX)=CFEO2
      CFE3Q(I,NY,NX)=CFEO3
      CFE4Q(I,NY,NX)=CFEO4
      CFESQ(I,NY,NX)=CFES1
      CCAOQ(I,NY,NX)=CCAO1
      CCACQ(I,NY,NX)=CCAC1
      CCAHQ(I,NY,NX)=CCAH1
      CCASQ(I,NY,NX)=CCAS1
      CMGOQ(I,NY,NX)=CMGO1
      CMGCQ(I,NY,NX)=CMGC1
      CMGHQ(I,NY,NX)=CMGH1
      CMGSQ(I,NY,NX)=CMGS1
      CNACQ(I,NY,NX)=CNAC1
      CNASQ(I,NY,NX)=CNAS1
      CKASQ(I,NY,NX)=CKAS1
      CH0PQ(I,NY,NX)=CH0P1
      CH1PQ(I,NY,NX)=CH1P1
      CPOQ(I,NY,NX)=CH2P1
      CH3PQ(I,NY,NX)=CH3P1
      CF1PQ(I,NY,NX)=CF1P1
      CF2PQ(I,NY,NX)=CF2P1
      CC0PQ(I,NY,NX)=CC0P1
      CC1PQ(I,NY,NX)=CC1P1
      CC2PQ(I,NY,NX)=CC2P1
      CM1PQ(I,NY,NX)=CM1P1
      CSTRQ(I,NY,NX)=CSTR1
C
C     SOLUTE CONCENTRATIONS IN SOIL
C
      ELSEIF(K.EQ.3.AND.I.EQ.1.AND.DATA(20).EQ.'NO'.AND.IGO.EQ.0)THEN
      CCOU=CCO21
      CCHU=CCH41
      COXU=0.0
      CNNU=CZ2G1
      CN2U=CZ2O1
      CN4U(L,NY,NX)=CN41
      CN3U(L,NY,NX)=CN31
      CNOU(L,NY,NX)=CNOX
      CALU(L,NY,NX)=CAL1
      CFEU(L,NY,NX)=CFE1
      CHYU(L,NY,NX)=CHY1
      CCAU(L,NY,NX)=CCA1
      CMGU(L,NY,NX)=CMG1
      CNAU(L,NY,NX)=CNA1
      CKAU(L,NY,NX)=CKA1
      COHU(L,NY,NX)=COH1
      CSOU(L,NY,NX)=CSO41
      CCLU(L,NY,NX)=CCL1
      CC3U(L,NY,NX)=CCO31
      CHCU(L,NY,NX)=CHCO31
      CAL1U(L,NY,NX)=CALO1
      CAL2U(L,NY,NX)=CALO2
      CAL3U(L,NY,NX)=CALO3
      CAL4U(L,NY,NX)=CALO4
      CALSU(L,NY,NX)=CALS1
      CFE1U(L,NY,NX)=CFEO1
      CFE2U(L,NY,NX)=CFEO2
      CFE3U(L,NY,NX)=CFEO3
      CFE4U(L,NY,NX)=CFEO4
      CFESU(L,NY,NX)=CFES1
      CCAOU(L,NY,NX)=CCAO1
      CCACU(L,NY,NX)=CCAC1
      CCAHU(L,NY,NX)=CCAH1
      CCASU(L,NY,NX)=CCAS1
      CMGOU(L,NY,NX)=CMGO1
      CMGCU(L,NY,NX)=CMGC1
      CMGHU(L,NY,NX)=CMGH1
      CMGSU(L,NY,NX)=CMGS1
      CNACU(L,NY,NX)=CNAC1
      CNASU(L,NY,NX)=CNAS1
      CKASU(L,NY,NX)=CKAS1
      CH0PU(L,NY,NX)=CH0P1
      CH1PU(L,NY,NX)=CH1P1
      CPOU(L,NY,NX)=CH2P1
      CH3PU(L,NY,NX)=CH3P1
      CF1PU(L,NY,NX)=CF1P1
      CF2PU(L,NY,NX)=CF2P1
      CC0PU(L,NY,NX)=CC0P1
      CC1PU(L,NY,NX)=CC1P1
      CC2PU(L,NY,NX)=CC2P1
      CM1PU(L,NY,NX)=CM1P1
C
C     INITIAL STATE VARIABLES FOR GAS IN SOIL
C
      CO2G(L,NY,NX)=CCO2EI(NY,NX)*VOLP(L,NY,NX)
      CH4G(L,NY,NX)=CCH4E(NY,NX)*VOLP(L,NY,NX)
      OXYG(L,NY,NX)=COXYE(NY,NX)*VOLP(L,NY,NX)
      Z2GG(L,NY,NX)=CZ2GE(NY,NX)*VOLP(L,NY,NX)
      Z2OG(L,NY,NX)=CZ2OE(NY,NX)*VOLP(L,NY,NX)
      ZNH3G(L,NY,NX)=CNH3E(NY,NX)*VOLP(L,NY,NX)
      H2GG(L,NY,NX)=CH2GE(NY,NX)*VOLP(L,NY,NX)
      IF(CDPTH(L-1,NY,NX).LT.DTBLZ(NY,NX))THEN
      OXYS(L,NY,NX)=COXYE(NY,NX)*SOXYX/(EXP(AOXYX*CSTR1))
     2*EXP(0.516-0.0172*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
      ELSE
      OXYS(L,NY,NX)=0.0
      ENDIF
      CO2S(L,NY,NX)=CCO2EI(NY,NX)*SCO2X/(EXP(ACO2X*CSTR1))
     2*EXP(0.843-0.0281*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
      CH4S(L,NY,NX)=CCH4E(NY,NX)*SCH4X/(EXP(ACH4X*CSTR1))
     2*EXP(0.597-0.0199*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
      Z2GS(L,NY,NX)=CZ2GE(NY,NX)*SN2GX/(EXP(AN2GX*CSTR1))
     2*EXP(0.456-0.0152*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
      Z2OS(L,NY,NX)=CZ2OE(NY,NX)*SN2OX/(EXP(AN2OX*CSTR1))
     2*EXP(0.897-0.0299*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
      H2GS(L,NY,NX)=CH2GE(NY,NX)*SH2GX/(EXP(AH2GX*CSTR1))
     2*EXP(0.597-0.0199*ATCA(NY,NX))*FH2O*VOLW(L,NY,NX)
C
C     INITIAL STATE VARIABLES FOR MINERAL N AND P IN SOIL
C
      ZNH4S(L,NY,NX)=CN4U(L,NY,NX)*VOLW(L,NY,NX)*VLNH4(L,NY,NX)*14.0
      ZNH4B(L,NY,NX)=CN4U(L,NY,NX)*VOLW(L,NY,NX)*VLNHB(L,NY,NX)*14.0
      ZNH3S(L,NY,NX)=CN3U(L,NY,NX)*VOLW(L,NY,NX)*VLNH4(L,NY,NX)*14.0
      ZNH3B(L,NY,NX)=CN3U(L,NY,NX)*VOLW(L,NY,NX)*VLNHB(L,NY,NX)*14.0
      ZNO3S(L,NY,NX)=CNOU(L,NY,NX)*VOLW(L,NY,NX)*VLNO3(L,NY,NX)*14.0
      ZNO3B(L,NY,NX)=CNOU(L,NY,NX)*VOLW(L,NY,NX)*VLNOB(L,NY,NX)*14.0
      H2PO4(L,NY,NX)=CPOU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)*31.0
      H2POB(L,NY,NX)=CPOU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)*31.0
      ZNO2S(L,NY,NX)=0.0
      ZNO2B(L,NY,NX)=0.0
C
C     INITIAL STATE VARIABLES FOR CATIONS, ANIONS AND ION PAIRS IN SOIL
C
      ZAL(L,NY,NX)=CALU(L,NY,NX)*VOLW(L,NY,NX)
      ZFE(L,NY,NX)=CFEU(L,NY,NX)*VOLW(L,NY,NX)
      ZHY(L,NY,NX)=CHYU(L,NY,NX)*VOLW(L,NY,NX)
      ZCA(L,NY,NX)=CCAU(L,NY,NX)*VOLW(L,NY,NX)
      ZMG(L,NY,NX)=CMGU(L,NY,NX)*VOLW(L,NY,NX)
      ZNA(L,NY,NX)=CNAU(L,NY,NX)*VOLW(L,NY,NX)
      ZKA(L,NY,NX)=CKAU(L,NY,NX)*VOLW(L,NY,NX)
      ZOH(L,NY,NX)=COHU(L,NY,NX)*VOLW(L,NY,NX)
      ZSO4(L,NY,NX)=CSOU(L,NY,NX)*VOLW(L,NY,NX)
      ZCL(L,NY,NX)=CCLU(L,NY,NX)*VOLW(L,NY,NX)
      ZCO3(L,NY,NX)=CC3U(L,NY,NX)*VOLW(L,NY,NX)
      ZHCO3(L,NY,NX)=CHCU(L,NY,NX)*VOLW(L,NY,NX)
      ZALOH1(L,NY,NX)=CAL1U(L,NY,NX)*VOLW(L,NY,NX)
      ZALOH2(L,NY,NX)=CAL2U(L,NY,NX)*VOLW(L,NY,NX)
      ZALOH3(L,NY,NX)=CAL3U(L,NY,NX)*VOLW(L,NY,NX)
      ZALOH4(L,NY,NX)=CAL4U(L,NY,NX)*VOLW(L,NY,NX)
      ZALS(L,NY,NX)=CALSU(L,NY,NX)*VOLW(L,NY,NX)
      ZFEOH1(L,NY,NX)=CFE1U(L,NY,NX)*VOLW(L,NY,NX)
      ZFEOH2(L,NY,NX)=CFE2U(L,NY,NX)*VOLW(L,NY,NX)
      ZFEOH3(L,NY,NX)=CFE3U(L,NY,NX)*VOLW(L,NY,NX)
      ZFEOH4(L,NY,NX)=CFE4U(L,NY,NX)*VOLW(L,NY,NX)
      ZFES(L,NY,NX)=CFESU(L,NY,NX)*VOLW(L,NY,NX)
      ZCAO(L,NY,NX)=CCAOU(L,NY,NX)*VOLW(L,NY,NX)
      ZCAC(L,NY,NX)=CCACU(L,NY,NX)*VOLW(L,NY,NX)
      ZCAH(L,NY,NX)=CCAHU(L,NY,NX)*VOLW(L,NY,NX)
      ZCAS(L,NY,NX)=CCASU(L,NY,NX)*VOLW(L,NY,NX)
      ZMGO(L,NY,NX)=CMGOU(L,NY,NX)*VOLW(L,NY,NX)
      ZMGC(L,NY,NX)=CMGCU(L,NY,NX)*VOLW(L,NY,NX)
      ZMGH(L,NY,NX)=CMGHU(L,NY,NX)*VOLW(L,NY,NX)
      ZMGS(L,NY,NX)=CMGSU(L,NY,NX)*VOLW(L,NY,NX)
      ZNAC(L,NY,NX)=CNACU(L,NY,NX)*VOLW(L,NY,NX)
      ZNAS(L,NY,NX)=CNASU(L,NY,NX)*VOLW(L,NY,NX)
      ZKAS(L,NY,NX)=CKASU(L,NY,NX)*VOLW(L,NY,NX)
      H0PO4(L,NY,NX)=CH0PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      H1PO4(L,NY,NX)=CH1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      H3PO4(L,NY,NX)=CH3PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZFE1P(L,NY,NX)=CF1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZFE2P(L,NY,NX)=CF2PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZCA0P(L,NY,NX)=CC0PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZCA1P(L,NY,NX)=CC1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZCA2P(L,NY,NX)=CC2PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      ZMG1P(L,NY,NX)=CM1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      H0POB(L,NY,NX)=CH0PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      H1POB(L,NY,NX)=CH1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      H3POB(L,NY,NX)=CH3PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZFE1PB(L,NY,NX)=CF1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZFE2PB(L,NY,NX)=CF2PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZCA0PB(L,NY,NX)=CC0PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZCA1PB(L,NY,NX)=CC1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZCA2PB(L,NY,NX)=CC2PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      ZMG1PB(L,NY,NX)=CM1PU(L,NY,NX)*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
C
C     INITIAL STATE VARIABLES FOR ALL MATERIAL IN SOIL MACROPORES
C
      CO2SH(L,NY,NX)=0.0
      CH4SH(L,NY,NX)=0.0
      OXYSH(L,NY,NX)=0.0
      Z2GSH(L,NY,NX)=0.0
      Z2OSH(L,NY,NX)=0.0
      H2GSH(L,NY,NX)=0.0
      ZNH4SH(L,NY,NX)=0.0
      ZNH4BH(L,NY,NX)=0.0
      ZNH3SH(L,NY,NX)=0.0
      ZNH3BH(L,NY,NX)=0.0
      ZNO3SH(L,NY,NX)=0.0
      ZNO3BH(L,NY,NX)=0.0
      ZNO2SH(L,NY,NX)=0.0
      ZNO2BH(L,NY,NX)=0.0
      H2PO4H(L,NY,NX)=0.0
      H2POBH(L,NY,NX)=0.0
      ZALH(L,NY,NX)=0.0
      ZFEH(L,NY,NX)=0.0
      ZHYH(L,NY,NX)=0.0
      ZCCH(L,NY,NX)=0.0
      ZMAH(L,NY,NX)=0.0
      ZNAH(L,NY,NX)=0.0
      ZKAH(L,NY,NX)=0.0
      ZOHH(L,NY,NX)=0.0
      ZSO4H(L,NY,NX)=0.0
      ZCLH(L,NY,NX)=0.0
      ZCO3H(L,NY,NX)=0.0
      ZHCO3H(L,NY,NX)=0.0
      ZALO1H(L,NY,NX)=0.0
      ZALO2H(L,NY,NX)=0.0
      ZALO3H(L,NY,NX)=0.0
      ZALO4H(L,NY,NX)=0.0
      ZALSH(L,NY,NX)=0.0
      ZFEO1H(L,NY,NX)=0.0
      ZFEO2H(L,NY,NX)=0.0
      ZFEO3H(L,NY,NX)=0.0
      ZFEO4H(L,NY,NX)=0.0
      ZFESH(L,NY,NX)=0.0
      ZCAOH(L,NY,NX)=0.0
      ZCACH(L,NY,NX)=0.0
      ZCAHH(L,NY,NX)=0.0
      ZCASH(L,NY,NX)=0.0
      ZMGOH(L,NY,NX)=0.0
      ZMGCH(L,NY,NX)=0.0
      ZMGHH(L,NY,NX)=0.0
      ZMGSH(L,NY,NX)=0.0
      ZNACH(L,NY,NX)=0.0
      ZNASH(L,NY,NX)=0.0
      ZKASH(L,NY,NX)=0.0
      H0PO4H(L,NY,NX)=0.0
      H1PO4H(L,NY,NX)=0.0
      H3PO4H(L,NY,NX)=0.0
      ZFE1PH(L,NY,NX)=0.0
      ZFE2PH(L,NY,NX)=0.0
      ZCA0PH(L,NY,NX)=0.0
      ZCA1PH(L,NY,NX)=0.0
      ZCA2PH(L,NY,NX)=0.0
      ZMG1PH(L,NY,NX)=0.0
      H0POBH(L,NY,NX)=0.0
      H1POBH(L,NY,NX)=0.0
      H3POBH(L,NY,NX)=0.0
      ZFE1BH(L,NY,NX)=0.0
      ZFE2BH(L,NY,NX)=0.0
      ZCA0BH(L,NY,NX)=0.0
      ZCA1BH(L,NY,NX)=0.0
      ZCA2BH(L,NY,NX)=0.0
      ZMG1BH(L,NY,NX)=0.0
C
C     INITIAL STATE VARIABLES FOR EXCHANGEABLE CATIONS AND ANIONS
C
      XN4(L,NY,NX)=XN4Q*VOLA(L,NY,NX)*VLNH4(L,NY,NX)
      XNB(L,NY,NX)=XN4Q*VOLA(L,NY,NX)*VLNHB(L,NY,NX)
      XHY(L,NY,NX)=XHYQ*VOLA(L,NY,NX)
      XAL(L,NY,NX)=XALQ*VOLA(L,NY,NX)/3.0
      XCA(L,NY,NX)=XCAQ*VOLA(L,NY,NX)*0.50
      XMG(L,NY,NX)=XMGQ*VOLA(L,NY,NX)*0.50
      XNA(L,NY,NX)=XNAQ*VOLA(L,NY,NX)
      XKA(L,NY,NX)=XKAQ*VOLA(L,NY,NX)
      XHC(L,NY,NX)=XHC1*VOLA(L,NY,NX)
      XALO2(L,NY,NX)=XALO21*VOLA(L,NY,NX)
      XOH0(L,NY,NX)=XOH01*VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      XOH1(L,NY,NX)=XOH11*VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      XOH2(L,NY,NX)=XOH21*VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      XH1P(L,NY,NX)=XH1P1*VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      XH2P(L,NY,NX)=XH2P1*VOLA(L,NY,NX)*VLPO4(L,NY,NX)
      XOH0B(L,NY,NX)=XOH01*VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      XOH1B(L,NY,NX)=XOH11*VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      XOH2B(L,NY,NX)=XOH21*VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      XH1PB(L,NY,NX)=XH1P1*VOLA(L,NY,NX)*VLPOB(L,NY,NX)
      XH2PB(L,NY,NX)=XH2P1*VOLA(L,NY,NX)*VLPOB(L,NY,NX)
C
C     INITIAL STATE VARIABLES FOR PRECIPITATES
C
      PALOH(L,NY,NX)=PALOH1*VOLA(L,NY,NX)
      PFEOH(L,NY,NX)=PFEOH1*VOLA(L,NY,NX)
      PCACO(L,NY,NX)=PCACO1*VOLA(L,NY,NX)
      PCASO(L,NY,NX)=PCASO1*VOLA(L,NY,NX)
      PALPO(L,NY,NX)=PALPO1*VOLA(L,NY,NX)
      PFEPO(L,NY,NX)=PFEPO1*VOLA(L,NY,NX)
      PCAPD(L,NY,NX)=PCAPD1*VOLA(L,NY,NX)
      PCAPH(L,NY,NX)=PCAPH1*VOLA(L,NY,NX)
      PCAPM(L,NY,NX)=0.0
      PALPB(L,NY,NX)=PALPOB*VOLA(L,NY,NX)
      PFEPB(L,NY,NX)=PFEPOB*VOLA(L,NY,NX)
      PCPDB(L,NY,NX)=PCAPDB*VOLA(L,NY,NX)
      PCPHB(L,NY,NX)=PCAPHB*VOLA(L,NY,NX)
      PCPMB(L,NY,NX)=0.0
      ECND(L,NY,NX)=0.0
      CSTR(L,NY,NX)=0.0
      CION(L,NY,NX)=0.0
      ZNH4S(L,NY,NX)=ZNH4S(L,NY,NX)+0.5*OSN(1,2,L,NY,NX)
      OSN(1,2,L,NY,NX)=OSN(1,2,L,NY,NX)-0.5*OSN(1,2,L,NY,NX)
      ENDIF
2000  CONTINUE
1200  CONTINUE
C
C     INITIAL STATE VARIABLES FOR MINERALS IN SURFACE RESIDUE
C
      IF(DATA(20).EQ.'NO'.AND.IGO.EQ.0)THEN
      ZNH4S(0,NY,NX)=0.0
      ZNH3S(0,NY,NX)=0.0
      ZNO3S(0,NY,NX)=0.0
      ZNO2S(0,NY,NX)=0.0
      H2PO4(0,NY,NX)=0.0
      ZNH4B(0,NY,NX)=0.0
      ZNH3B(0,NY,NX)=0.0
      ZNO3B(0,NY,NX)=0.0
      ZNO2B(0,NY,NX)=0.0
      H2POB(0,NY,NX)=0.0
      XN4(0,NY,NX)=0.0
      XOH0(0,NY,NX)=0.0
      XOH1(0,NY,NX)=0.0
      XOH2(0,NY,NX)=0.0
      XH1P(0,NY,NX)=0.0
      XH2P(0,NY,NX)=0.0
      XNB(0,NY,NX)=0.0
      XOH0B(0,NY,NX)=0.0
      XOH1B(0,NY,NX)=0.0
      XOH2B(0,NY,NX)=0.0
      XH1PB(0,NY,NX)=0.0
      XH2PB(0,NY,NX)=0.0
      PALPO(0,NY,NX)=0.0
      PFEPO(0,NY,NX)=0.0
      PCAPD(0,NY,NX)=0.0
      PCAPH(0,NY,NX)=0.0
      PCAPM(0,NY,NX)=0.0
      PALPB(0,NY,NX)=0.0
      PFEPB(0,NY,NX)=0.0
      PCPDB(0,NY,NX)=0.0
      PCPHB(0,NY,NX)=0.0
      PCPMB(0,NY,NX)=0.0
C
C     INITIAL STATE VARIABLES FOR MINERAL N AND P IN SNOWPACK
C
      VOLWW=VOLWS(NY,NX)+VOLSS(NY,NX)+VOLIS(NY,NX)*0.92
      CO2W(NY,NX)=VOLWW*CCOR(NY,NX)
      CH4W(NY,NX)=VOLWW*CCHR(NY,NX)
      OXYW(NY,NX)=VOLWW*COXR(NY,NX)
      ZNGW(NY,NX)=VOLWW*CNNR(NY,NX)
      ZN2W(NY,NX)=VOLWW*CN2R(NY,NX)
      ZN4W(NY,NX)=VOLWW*CN4R(NY,NX)*14.0
      ZN3W(NY,NX)=VOLWW*CN3R(NY,NX)*14.0
      ZNOW(NY,NX)=VOLWW*CNOR(NY,NX)*14.0
      ZHPW(NY,NX)=VOLWW*CPOR(NY,NX)*31.0
C
C     INITIAL STATE VARIABLES FOR CATIONS AND ANIONS IN SNOWPACK
C
      IF(ISALT(NY,NX).NE.0)THEN
      ZALW(NY,NX)=VOLWW*CALR(NY,NX)
      ZFEW(NY,NX)=VOLWW*CFER(NY,NX)
      ZHYW(NY,NX)=VOLWW*CHYR(NY,NX)
      ZCAW(NY,NX)=VOLWW*CCAR(NY,NX)
      ZMGW(NY,NX)=VOLWW*CMGR(NY,NX)
      ZNAW(NY,NX)=VOLWW*CNAR(NY,NX)
      ZKAW(NY,NX)=VOLWW*CKAR(NY,NX)
      ZOHW(NY,NX)=VOLWW*COHR(NY,NX)
      ZSO4W(NY,NX)=VOLWW*CSOR(NY,NX)
      ZCLW(NY,NX)=VOLWW*CCLR(NY,NX)
      ZCO3W(NY,NX)=VOLWW*CC3R(NY,NX)
      ZHCO3W(NY,NX)=VOLWW*CHCR(NY,NX)
      ZALH1W(NY,NX)=VOLWW*CAL1R(NY,NX)
      ZALH2W(NY,NX)=VOLWW*CAL2R(NY,NX)
      ZALH3W(NY,NX)=VOLWW*CAL3R(NY,NX)
      ZALH4W(NY,NX)=VOLWW*CAL4R(NY,NX)
      ZALSW(NY,NX)=VOLWW*CALSR(NY,NX)
      ZFEH1W(NY,NX)=VOLWW*CFE1R(NY,NX)
      ZFEH2W(NY,NX)=VOLWW*CFE2R(NY,NX)
      ZFEH3W(NY,NX)=VOLWW*CFE3R(NY,NX)
      ZFEH4W(NY,NX)=VOLWW*CFE4R(NY,NX)
      ZFESW(NY,NX)=VOLWW*CFESR(NY,NX)
      ZCAOW(NY,NX)=VOLWW*CCAOR(NY,NX)
      ZCACW(NY,NX)=VOLWW*CCACR(NY,NX)
      ZCAHW(NY,NX)=VOLWW*CCAHR(NY,NX)
      ZCASW(NY,NX)=VOLWW*CCASR(NY,NX)
      ZMGOW(NY,NX)=VOLWW*CMGOR(NY,NX)
      ZMGCW(NY,NX)=VOLWW*CMGCR(NY,NX)
      ZMGHW(NY,NX)=VOLWW*CMGHR(NY,NX)
      ZMGSW(NY,NX)=VOLWW*CMGSR(NY,NX)
      ZNACW(NY,NX)=VOLWW*CNACR(NY,NX)
      ZNASW(NY,NX)=VOLWW*CNASR(NY,NX)
      ZKASW(NY,NX)=VOLWW*CKASR(NY,NX)
      H0PO4W(NY,NX)=VOLWW*CH0PR(NY,NX)
      H1PO4W(NY,NX)=VOLWW*CH1PR(NY,NX)
      H3PO4W(NY,NX)=VOLWW*CH3PR(NY,NX)
      ZFE1PW(NY,NX)=VOLWW*CF1PR(NY,NX)
      ZFE2PW(NY,NX)=VOLWW*CF2PR(NY,NX)
      ZCA0PW(NY,NX)=VOLWW*CC0PR(NY,NX)
      ZCA1PW(NY,NX)=VOLWW*CC1PR(NY,NX)
      ZCA2PW(NY,NX)=VOLWW*CC2PR(NY,NX)
      ZMG1PW(NY,NX)=VOLWW*CM1PR(NY,NX)
      ENDIF
      ENDIF
9990  CONTINUE
9995  CONTINUE
      RETURN
      END
